// TCInductorLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCInductorLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCInductorLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCInductorLabelsDlg property page

TCInductorLabelsDlg::TCInductorLabelsDlg() : CPropertyPage(TCInductorLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCInductorLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_init_voltage_visable = FALSE;
	CMEditTC1 = _T("");
	CMEditTC2 = _T("");
	m_check_visable_tc1 = FALSE;
	m_check_visable_tc2 = FALSE;
	//}}AFX_DATA_INIT

	m_init_voltage = 1.0;
}

TCInductorLabelsDlg::~TCInductorLabelsDlg()
{
}

void TCInductorLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCInductorLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_INIT_VOLTAGE, m_init_voltage_visable);
	DDX_MKSValue(pDX, IDC_EDIT_INIT_VOLTAGE, m_init_voltage);
	DDX_Text(pDX, IDC_EDIT_TC1, CMEditTC1);
	DDX_Text(pDX, IDC_EDIT_TC2, CMEditTC2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TC1, m_check_visable_tc1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TC2, m_check_visable_tc2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCInductorLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCInductorLabelsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCInductorLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_IC].is_visable = !!m_init_voltage_visable;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].CLabelValue = CMEditTC1;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].is_visable = !!m_check_visable_tc1;
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].CLabelValue = CMEditTC2;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].is_visable = !!m_check_visable_tc2;


	PCSchematicObjectData->CSpiceParameters.Set("IC", m_init_voltage);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_IC].CLabelValue = FloatToMKSString(m_init_voltage);

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCInductorLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;

	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

//	PCSchematicObjectData->CSpiceParameters.Get("IC", &m_init_voltage);

	m_init_voltage = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_IC].CLabelValue);

	return CPropertyPage::OnSetActive();
}

BOOL TCInductorLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_init_voltage_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_IC].is_visable;

	CMEditTC1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].CLabelValue;
	m_check_visable_tc1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].is_visable;
	
	CMEditTC2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].CLabelValue;
	m_check_visable_tc2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].is_visable;

//	PCSchematicObjectData->CSpiceParameters.Get("IC", &m_init_voltage);

	m_init_voltage = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_INDUCTOR_IC].CLabelValue);

	CPropertyPage::OnInitDialog();
	
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE;  
}
