// TCLaplaceLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCLaplaceLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCLaplaceLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCLaplaceLabelsDlg property page

TCLaplaceLabelsDlg::TCLaplaceLabelsDlg() : CPropertyPage(TCLaplaceLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCLaplaceLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_check_visable_bv = FALSE;
	m_check_visable_m_numerator = FALSE;
	CMEditNumerator= _T("");
	CMEditDenominator = _T("");
	m_visable_gain = FALSE;
	m_visable_ref_frequency = FALSE;
	//}}AFX_DATA_INIT
}

TCLaplaceLabelsDlg::~TCLaplaceLabelsDlg()
{
}

void TCLaplaceLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCLaplaceLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_BV, m_check_visable_bv);
	DDX_Check(pDX, IDC_CHECK_VISABLE_AREA, m_check_visable_m_numerator);
	DDX_Text(pDX, IDC_EDIT_AREA, CMEditNumerator);
	DDX_Text(pDX, IDC_EDIT_BREAKDOWN_VOLT, CMEditDenominator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_GAIN, m_visable_gain);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_FREQ, m_visable_ref_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_LAPLACE_GAIN, m_gain);
	DDX_MKSValue(pDX, IDC_EDIT_REF_FREQUENCY, m_ref_frequency);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCLaplaceLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCLaplaceLabelsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_AREA, OnKillfocusEditNumerator)
	ON_EN_KILLFOCUS(IDC_EDIT_BREAKDOWN_VOLT, OnKillfocusEditDenominator)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCLaplaceLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NUMERATOR].is_visable = !!m_check_visable_m_numerator;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NUMERATOR].CLabelValue = CMEditNumerator;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_DENOMINATOR].is_visable = !!m_check_visable_bv;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_DENOMINATOR].CLabelValue = CMEditDenominator;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_GAIN].is_visable = !!m_visable_gain;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_GAIN].CLabelValue = FloatToMKSString(m_gain);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].is_visable = !!m_visable_ref_frequency;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].CLabelValue = FloatToMKSString(m_ref_frequency);

	CString CText;

	CText = PCSchematicObjectData->CSpiceParameters.GetSpiceCoefficientsFromSpicePolynomial(CMEditNumerator);

	if(CText != "") PCSchematicObjectData->CSpiceParameters.Set("num_coeff", CText);

	CText = PCSchematicObjectData->CSpiceParameters.GetSpiceCoefficientsFromSpicePolynomial(CMEditDenominator);

	if(CText != "") PCSchematicObjectData->CSpiceParameters.Set("den_coeff", CText);

	PCSchematicObjectData->CSpiceParameters.Set("gain", m_gain);
	PCSchematicObjectData->CSpiceParameters.Set("denormalized_freq", m_ref_frequency);
	
	PCSchematicObjectData->FormatLabels();// this does a bit of dublication

	return true;
}

BOOL TCLaplaceLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	PCSchematicObjectData->CSpiceParameters.Get("num_coeff", &CMEditNumerator);
	PCSchematicObjectData->CSpiceParameters.Get("den_coeff", &CMEditDenominator);

	CMEditNumerator	= PCSchematicObjectData->CSpiceParameters.GetSpicePolynomialFromSpiceCoefficients(CMEditNumerator);
	CMEditDenominator = PCSchematicObjectData->CSpiceParameters.GetSpicePolynomialFromSpiceCoefficients(CMEditDenominator);

	PCSchematicObjectData->CSpiceParameters.Get("gain", &m_gain);
	PCSchematicObjectData->CSpiceParameters.Get("denormalized_freq", &m_ref_frequency);


	return CPropertyPage::OnSetActive();
}

BOOL TCLaplaceLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_check_visable_m_numerator = PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NUMERATOR].is_visable;
	PCSchematicObjectData->CSpiceParameters.Get("num_coeff", &CMEditNumerator);
	CMEditNumerator	= PCSchematicObjectData->CSpiceParameters.GetSpicePolynomialFromSpiceCoefficients(CMEditNumerator);

	m_check_visable_bv = PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_DENOMINATOR].is_visable;
	PCSchematicObjectData->CSpiceParameters.Get("den_coeff", &CMEditDenominator);
	CMEditDenominator = PCSchematicObjectData->CSpiceParameters.GetSpicePolynomialFromSpiceCoefficients(CMEditDenominator);

	m_visable_gain = PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_GAIN].is_visable;
	m_gain = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_GAIN].CLabelValue);

	m_visable_ref_frequency = PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].is_visable;
	m_ref_frequency = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].CLabelValue);

	PCSchematicObjectData->CSpiceParameters.Get("gain", &m_gain);
	PCSchematicObjectData->CSpiceParameters.Get("denormalized_freq", &m_ref_frequency);

	CPropertyPage::OnInitDialog();
	
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE;  
}

void TCLaplaceLabelsDlg::OnKillfocusEditNumerator() 
{
	UpdateData(true);

	TCSpiceParameters CSpiceParameters;

	CMEditNumerator = CSpiceParameters.GetSpiceCoefficientsFromSpicePolynomial(CMEditNumerator);
	
	CMEditNumerator = CSpiceParameters.GetSpicePolynomialFromSpiceCoefficients(CMEditNumerator);

	UpdateData(false);
}

void TCLaplaceLabelsDlg::OnKillfocusEditDenominator() 
{
	UpdateData(true);

	TCSpiceParameters CSpiceParameters;

	CMEditDenominator = CSpiceParameters.GetSpiceCoefficientsFromSpicePolynomial(CMEditDenominator);
	
	CMEditDenominator = CSpiceParameters.GetSpicePolynomialFromSpiceCoefficients(CMEditDenominator);

	UpdateData(false);
}
