// TCMKSConvert.cpp: implementation of the TCMKSConvert class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "float.h"
#include "math.h"
#include <afxtempl.h>
#include "TCMKSConvert.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif
#pragma warning (disable : 4702) // warning C4702: unreachable code 
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

static int num_digits_displayed = 6;
extern int g_mks_invalid_value;

void SetMKSNumDigits(int num_digits)
{
	if(num_digits < 1) return;
	if(num_digits > 12) return;

	num_digits_displayed = num_digits;
}

int  GetMKSNumDigits(void)
{
	return num_digits_displayed;
}

CString GetTurnsRatio(CString Sl1, CString Sl2)
{
	CString CText;

	double ratio, l1, l2;

	l1 = MKSStringToFloat(Sl1);
	l2 = MKSStringToFloat(Sl2);

	if(l2 != 0)
	{
		ratio = sqrt(l1/l2);

		CText = FloatToMKSString(ratio);

		CText += ":1";
	}
	else CText = "Error";

	return CText;
}

TCMKSConvert::TCMKSConvert()
{

}

TCMKSConvert::~TCMKSConvert()
{

}

/*
ExtraDDXCount=1
ExtraDDX1=E;;MKSValue;double;;MKSValue;Format scientific units
 */

class TCMKSData
{
public: TCMKSData(void);
		
			CArray <double, double>	MultyplierData;
			CArray <char, char>		PositiveExponentData;
			CArray <char, char>		NegativeExponentData;
};

static char mks_suffix = 'R';

char SetMKSuffix(char suffix)
{
	char l_suffix = mks_suffix;

	mks_suffix = suffix;

	return l_suffix;
}

TCMKSData::TCMKSData()
{
	MultyplierData.SetSize(512, 1);
	PositiveExponentData.SetSize(512, 1);
	NegativeExponentData.SetSize(512, 1);

	int p;

	for(p = 0; p < 512; p++)
	{
		MultyplierData[p] = -1.0;
	}

//	MultyplierData['a'] = 1e-18;
//	MultyplierData['A'] = 1e-18;
	MultyplierData['f'] = 1e-15;
	MultyplierData['F'] = 1e-15;
	MultyplierData['p'] = 1e-12;
	MultyplierData['P'] = 1e-12;
	MultyplierData['n'] = 1e-9;
	MultyplierData['N'] = 1e-9;
	MultyplierData['u'] = 1e-6;
	MultyplierData['U'] = 1e-6;
	MultyplierData['m'] = 1e-3;
	MultyplierData['R'] = 1.0;
	MultyplierData['r'] = 1.0;
	MultyplierData['V'] = 1.0;
	MultyplierData['v'] = 1.0;
	MultyplierData['K'] = 1e3;
	MultyplierData['k'] = 1e3;
	MultyplierData['M'] = 1e6;
	MultyplierData['G'] = 1e9;
	MultyplierData['g'] = 1e9;
	MultyplierData['T'] = 1e12;
	MultyplierData['t'] = 1e12;
	
	MultyplierData['0'] = -2.0;
	MultyplierData['1'] = -2.0;
	MultyplierData['2'] = -2.0;
	MultyplierData['3'] = -2.0;
	MultyplierData['4'] = -2.0;
	MultyplierData['5'] = -2.0;
	MultyplierData['6'] = -2.0;
	MultyplierData['7'] = -2.0;
	MultyplierData['8'] = -2.0;
	MultyplierData['9'] = -2.0;
	MultyplierData['e'] = -2.0;
	MultyplierData['E'] = -2.0;
	MultyplierData[' '] = -2.0;
	MultyplierData['\t'] = -2.0;
	MultyplierData['.']  = -2.0;
	MultyplierData['+']  = -2.0;
	MultyplierData['-']  = -2.0;


	for(p = 0; p < 512; p++) NegativeExponentData[p] = 'b';

	NegativeExponentData[0] = 'R';
	NegativeExponentData[1] = 'm';
	NegativeExponentData[2] = 'm';
	NegativeExponentData[3] = 'm';
	NegativeExponentData[4] = 'u';
	NegativeExponentData[5] = 'u';
	NegativeExponentData[6] = 'u';
	NegativeExponentData[7] = 'n';
	NegativeExponentData[8] = 'n';
	NegativeExponentData[9] = 'n';
	NegativeExponentData[10] = 'p';
	NegativeExponentData[11] = 'p';
	NegativeExponentData[12] = 'p';
	NegativeExponentData[13] = 'f';
	NegativeExponentData[14] = 'f';
	NegativeExponentData[15] = 'f';
	NegativeExponentData[16] = 'f';//a not supported in xspice
	NegativeExponentData[17] = 'f';
	NegativeExponentData[18] = 'f';
	NegativeExponentData[19] = 'f';
	NegativeExponentData[20] = 'f';
	NegativeExponentData[21] = 'f';
	NegativeExponentData[22] = 'f';
	NegativeExponentData[23] = 'f'; //24 dont work....

	for(p = 0; p < 512; p++) PositiveExponentData[p] = 'b';

	PositiveExponentData[0] = 'R';
	PositiveExponentData[1] = 'R';
	PositiveExponentData[2] = 'R';
	PositiveExponentData[3] = 'K';
	PositiveExponentData[4] = 'K';
	PositiveExponentData[5] = 'K';
	PositiveExponentData[6] = 'M';
	PositiveExponentData[7] = 'M';
	PositiveExponentData[8] = 'M';
	PositiveExponentData[9] = 'G';
	PositiveExponentData[10] = 'G';
	PositiveExponentData[11] = 'G';
	PositiveExponentData[12] = 'T';
	PositiveExponentData[13] = 'T';
	PositiveExponentData[14] = 'T';
	PositiveExponentData[15] = 'T';// non greater the Tera
	PositiveExponentData[16] = 'T';
	PositiveExponentData[17] = 'T';
	PositiveExponentData[18] = 'T';
	PositiveExponentData[19] = 'T';
	PositiveExponentData[20] = 'T';
	PositiveExponentData[21] = 'T';//22 dont work....
}

TCMKSData CMKSData;

void AFXAPI DDX_MKSValue(CDataExchange* pDX, int nIDC, double& data)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
	{
		if (!GetMKSValue(hWndCtrl, data))
		{
			AfxMessageBox(g_mks_invalid_value);

			pDX->Fail();
		}

		GetSafeDouble(data);
	}
	else
	{
		GetSafeDouble(data);
		SetMKSValue(hWndCtrl, data);
	}
}


bool GetMKSValue(CWnd* pWnd, double& data)
{
	ASSERT(pWnd != NULL);
	return GetMKSValue(pWnd->m_hWnd, data);
}

bool GetMKSValue(HWND hWnd, double& data)
{
	char p_buff[256];
	char *p_buff_copy = p_buff;
	char *p_buff_end_copy = NULL;
	double temp;
	double multiplier = 1.0;
	double multiplier_temp;
	char suffix = mks_suffix;
	bool suffix_found = false;

	::GetWindowText(hWnd, p_buff, 255);

	while(*p_buff_copy > 0)
	{
		multiplier_temp = CMKSData.MultyplierData[*p_buff_copy];
		
		if(multiplier_temp == -1) return false;

		if(multiplier_temp != -2)
		{
			if(!suffix_found)// only use 1st multyplier found
			{
				suffix = *p_buff_copy;
				suffix_found = true;
				multiplier = multiplier_temp;
			}

			*p_buff_copy = 0;
			p_buff_end_copy = p_buff_copy + 1;
		}

		p_buff_copy++;
	}

	CString CText = p_buff;

	CText += "."; // replace the char by the decimal point
	
	if(p_buff_end_copy) CText += p_buff_end_copy;

	temp = strtod(CText, '\0');

	data = temp * multiplier;

	return true;
}

double MKSStringToFloat(CString &CTextData)
{
	CTextData.TrimLeft();
	CTextData.TrimRight();

	if(CTextData == "") return 0.0;

	if(!(CTextData.GetLength() < 255)) return 0.0;

	char p_buff[256];
	char *p_buff_copy = p_buff;
	char *p_buff_end_copy = NULL;
	double temp;
	double multiplier = 1.0;
	double multiplier_temp;
	char suffix = mks_suffix;
	double data;
	bool suffix_found = false;

	strcpy(p_buff, CTextData);

	while(*p_buff_copy > 0)
	{
		multiplier_temp = CMKSData.MultyplierData[*p_buff_copy];
		
		if(multiplier_temp == -1) return false;

		if(multiplier_temp != -2)
		{
			if(!suffix_found)// only use 1st multyplier found
			{
				suffix = *p_buff_copy;
				suffix_found = true;
				multiplier = multiplier_temp;
			}

			*p_buff_copy = 0;
			p_buff_end_copy = p_buff_copy + 1;
		}

		p_buff_copy++;
	}

	CString CText = p_buff;

	CText += "."; // replace the char by the decimal point
	
	if(p_buff_end_copy) CText += p_buff_end_copy;

	temp = strtod(CText, '\0');

	data = temp * multiplier;

	return data;
}
CString FloatToMKSString(double data)
{
	CString CText;

	if(data == 0) return "0";

	char suffix = GetMKSSuffix(data);

	if(suffix != 'b')// too large so use exponent as normal
		data /= CMKSData.MultyplierData[suffix];

	int count, length;

	char *buff = new char[128];

	if(!buff) return "";
   
	CText = _gcvt(data, num_digits_displayed, buff);

	CText =  RoundNumber(CText);

	count = CText.Find('.');

	if(count > -1)
	{
		length = CText.GetLength();
		length--;

		while(CText.GetAt(length) == '0') CText = CText.Left(length--);

		length = CText.GetLength();

		length--;

		if(length > -1) if(CText.GetAt(length) == '.') 
			CText = CText.Left(length);
	}

	if(suffix != 'b')
		if(suffix != mks_suffix) CText += suffix;

	delete [] buff;

	return CText;
}

CString FloatToSpiceMKSString(double data)
{
	CString CText;

	if(data == 0) return "0";

	CText = FloatToMKSString(data);

	int length = CText.GetLength();

	if(CText.GetAt(length - 1) == 'M')
	{
		CText += "eg";	

	}

	return CText;
}
 
double SpiceMKSStringToFloat(CString &CTextData)
{
	CString CTemp = CTextData;

	CTemp.MakeUpper();

	int count = CTemp.Find("MEG");

	if(count < 0) return MKSStringToFloat(CTextData);
	
	CTemp = CTextData.Left(count);

	CTemp += "M";

	return MKSStringToFloat(CTemp);
}

void SetMKSValue(HWND hWnd, double data)
{
	CString CText; 

	char suffix = GetMKSSuffix(data);

	if(suffix != 'b')
		data /= CMKSData.MultyplierData[suffix];

	int count, length;

	char *buff = new char[128];

	if(!buff) return;

   CText = _gcvt(data, num_digits_displayed, buff);

   CText =  RoundNumber(CText);

	count = CText.Find('.');

	if(count > -1)
	{
		length = CText.GetLength();
		length--;

		while(CText.GetAt(length) == '0') CText = CText.Left(length--);

		length = CText.GetLength();

		length--;

		if(length > -1) if(CText.GetAt(length) == '.') CText = CText.Left(length);	
	}

	if(suffix != 'b')
	if(suffix != mks_suffix) CText += suffix;

		::SetWindowText(hWnd, CText.GetBufferSetLength(256));

	delete [] buff;
}


void SetMKSValue(CWnd* pWnd, double data)
{
	ASSERT(pWnd != NULL);
	SetMKSValue(pWnd->m_hWnd, data);
}

bool IsValidMKSSuffix(char suffix)
{
	if(CMKSData.MultyplierData[suffix] == -1) return false;

	return true;
}

double GetMKSMultyplier(char suffix)
{
	return CMKSData.MultyplierData[suffix];
}

char GetMKSSuffix(double data)
{
	double exponent;
	double f_data;

	f_data = data;

	if(f_data < 0) f_data = - f_data;
	if(!f_data) exponent = 0;

	else 
	{
		exponent = (double) f_data;

		exponent = Log(exponent);
	}

	if(exponent > 256.00) exponent = 256;
	if(exponent < -256.00) exponent = -256;

	if(exponent >= 0) return CMKSData.PositiveExponentData[(int) exponent];

	exponent = - exponent;

	if((exponent - double ((int) exponent)) == 0) exponent -= 1;
	
	return CMKSData.NegativeExponentData[(int) (exponent + 1.0)];	
}

CString MKSStringToSpiceMKSString(CString &CText)
{
	double data;

	data = MKSStringToFloat(CText);

	return FloatToSpiceMKSString(data);
}

CString RoundNumber(CString &CText)
{
	CString CNumber;

	CNumber;// to do

	return CText;
}
double Log(double value)
{
	if(value < 0) value = -value;

	if(!value) 
	{
		return 0;
	}

	return log10(value);
}

double Ln(double value)
{
	if(value < 0) value = -value;

	if(!value) return 0;

	return log(value);
}

double	Log2(double value)
{
	if(value < 0) value = -value;

	if(!value) return 0.0;

	return log(value)/0.693147805599453;
}

double	AntiLog(double value)// fucking exceptions
{
	if(value > 30.0) return 1e30;

	if(value < 1e-37 && value > 0) return 1.0;
	if(value > -1e-37 && value < 0) return 1.0;
	if(value < -37) return 0.0;

	value = exp(value * 2.302585092994045);

	if(value < 1e-37) value = 0.0;

	return value;
}

double	AntiLog2(double value)
{
	if(value > 30.0) return 1e30;

	if(value < 1e-37 && value > 0) return 1.0;
	if(value > -1e-37 && value < 0) return 1.0;
	if(value < -37) return 0.0;

	value = exp(value * 0.693147805599453);

	if(value < 1e-37) value = 0.0;

	return value;
}

double	Exp(double value)
{
	// checking to do

	return exp(value);
}

double QuantiseScale(double &max, double &min, int num_ticks, bool quantise)
{
	if(!quantise) return -1;

	double value = 1.0;

	try
	{
	// temp, fist time sometimes not correct
		value = _QuantiseScale(max, min, num_ticks);

		value = _QuantiseScale(max, min, num_ticks);

		if(value == -1)
		{
			value = _QuantiseScale(max, min, num_ticks);
		}

		if(value == -1)
		{
			value = _QuantiseScale(max, min, num_ticks);
		}
	}

	catch(...)
	{
		ASSERT(0);

		_fpreset();

		return value;
	}

	return value;
}

double QuantisePhaseScale(double &max, double &min, int num_ticks, bool quantise)
{
	if(!quantise) return -1;

	double value =1.0;

	try
	{
		value = _QuantisePhaseScale(max, min, num_ticks);

		value = _QuantisePhaseScale(max, min, num_ticks);

		if(value == -1)
		{
			value = _QuantisePhaseScale(max, min, num_ticks);
		}

		if(value == -1)
		{
			value = _QuantisePhaseScale(max, min, num_ticks);
		}
	}

	catch(...)
	{
		_fpreset();

		return value;
	}

	return value;
}

double _QuantiseScale(double &max, double &min, int num_ticks)// find rational values for graph axi
{
	double diff;
	double f_per_tick;
	int quantise;
	double l_min, l_max;
	double temp = 0.0;

 
	// (int) 3.0000000 where 3.0000000 is double gives 2. This is a compiler bug
	// (int) 3.0000 where 3.0000 is float gives 3.
	// 8/.4 gives 19.999.. not 20 when float

	GetSafeFloat(max);
	GetSafeFloat(min);

	if(max == 0 && min == 0)// sensible default for 0dbs etc
	{
		max = 1; 
		min = -1;
	}
	else
	{
		if(max)
		{
			if(fabs((max - min)/(2*max)) < 1e-6) min = max/2;// soft error corection
		}
		else
		{
			if(fabs((max - min)/(2*min)) < 1e-6) max = 2 * min;// soft error corection
		}
	}

	if(!(max > min)) // swop max and min
	{
		temp = (float)max;

		max = min;

		min = temp;
	}

//	diff = (float)(max - min);// first approximation

	diff = (max - min);// first approximation

	if(!diff) return 0.0;
	
	if(!num_ticks) num_ticks = 1;

	f_per_tick = diff/num_ticks;

	if(fabs(f_per_tick) < 1e-36) f_per_tick = 1; //soft error

	if(f_per_tick < 0) f_per_tick = - f_per_tick;
	
	f_per_tick = (double) MKSRoundFloat((float)f_per_tick);

	if(fabs(f_per_tick) < 1e-36) f_per_tick = 1; //soft error

	if(min < 0)
	{
		quantise = (int) (min / f_per_tick - 0.5);

		l_min = quantise * f_per_tick;

		if(l_min > min) l_min -= f_per_tick;

		min = l_min;
	}
	else
	{
		quantise = (int)(min / f_per_tick + 0.5);

		l_min = quantise * f_per_tick;

		if(l_min > min) l_min -= f_per_tick;

		min = l_min;
	}

	l_max = (float)(min + f_per_tick * num_ticks);

	temp = (float)max;

	if(!(temp <= l_max)) return -1;
/*	{
		if(!temp) return -1;

		if(!(fabs(temp - l_max) < .00001/temp))
			return -1;
	}*/

	max = min + f_per_tick * num_ticks;

	return (double)f_per_tick;
}

float MKSRoundFloat(float value)// find nearest 1,2,4,5,8 value
{
	float	decade;
	int		i_decade;
	double	multyplier;
	 
//	if(!value) return 0.0;

	decade = (float)Log((double)value);

	if(decade < 0) i_decade = (int)(decade) - 1;
	else i_decade = (int)(decade);

	multyplier = AntiLog((double)i_decade);// gets the power of 10

	if(multyplier) value = value/(float)multyplier;

	if(!(value < 0))
	{
		if(value <= 1) return 1 * (float)multyplier;

		if(value <= 1.25) return 1.25 * (float)multyplier; //Aug 2016

		if(value <= 1.5) return 1.5 * (float)multyplier; //Aug 2016

		if(value <= 2) return 2 * (float)multyplier;

		if(value <= 2.5) return 2.5 * (float)multyplier;  //Aug 2016

		if(value <= 3) return 3 * (float)multyplier;  //Aug 2016

		if(value <= 4) return 4 * (float)multyplier;

		if(value <= 5) return 5 * (float)multyplier;

		if(value <= 6) return 6 * (float)multyplier; //Aug 2016

		if(value <= 8) return 8 * (float)multyplier;

		if(value <= 9) return 9 * (float)multyplier; //Aug 2016

		return 10 * (float)multyplier;
	}

	value = -value;

	if(value <= 1) return -1 * (float)multyplier;

	if(value <= 1.25) return -1.25 * (float)multyplier; //Aug 2016

	if(value <= 1.5) return -1.5 * (float)multyplier;//Aug 2016

	if(value <= 2) return -2 * (float)multyplier;

	if(value <= 2.5) return -2.5 * (float)multyplier;  //Aug 2016

	if(value <= 3) return -3 * (float)multyplier;  //Aug 2016

	if(value <= 4) return -4 * (float)multyplier;

	if(value <= 5) return -5 * (float)multyplier;

	if(value <= 6) return -6 * (float)multyplier; //Aug 2016

	if(value <= 8) return -8 * (float)multyplier;

	if(value <= 9) return -9 * (float)multyplier; //Aug 2016

	return -10 * (float)multyplier;
}

double _QuantisePhaseScale(double &max, double &min, int num_ticks)// find rational values for graph axi
{
	double diff;
	double f_per_tick;
	double temp = 0.0;
	double l_min, l_max;

	GetSafeFloat(max);
	GetSafeFloat(min);

	if(max == 0 && min == 0)// sensible default for 0dbs etc
	{
		max = 1; 
		min = -1;
	}
	else
	{
		if(max)
		{
			if(fabs((max - min)/(2*max)) < 1e-6) min = max/2;// soft error coreection
		}
		else
		{
			if(fabs((max - min)/(2*min)) < 1e-6) max = 2 * min;// soft error coreection
		}
	}

	if(!(max > min)) // swop max and min
	{
		temp = (float)max;

		max = min;

		min = temp;
	}

//	diff = (float)(max - min);

	diff = (max - min);// first approximation


	if(!diff) return false;
	
	if(!num_ticks) num_ticks = 1;

	f_per_tick = diff/num_ticks;

	if(fabs(f_per_tick) < 1e-36) f_per_tick = 1; //soft error

	if(f_per_tick < 0) f_per_tick = - f_per_tick;
	
	f_per_tick = (double) MKSPhaseRoundFloat((float)f_per_tick);

	if(fabs(f_per_tick) < 1e-36) f_per_tick = 1; //soft error

	int quantise;


	if(min < 0)
	{
		quantise = (int) (min / f_per_tick - 0.5);

		l_min = quantise * f_per_tick;

		if(l_min > min) l_min -= f_per_tick;

		min = l_min;
	}
	else
	{
		quantise = (int)(min / f_per_tick + 0.5);

		l_min = quantise * f_per_tick;

		if(l_min > min) l_min -= f_per_tick;

		min = l_min;
	}


	l_max = (float)(min + f_per_tick * num_ticks);

	temp = (float)max;

	if(!(temp <= l_max)) return -1;
/*	{
		if(!temp) return -1;// bug cought

		if(!(fabs(temp - l_max) < .00001/temp))
			return -1;
	}*/

	max = min + f_per_tick * num_ticks;

	return (double)f_per_tick;
}

float MKSPhaseRoundFloat(float value)// find nearest 15, 2,4,5 value
{
	float	decade;
	int		i_decade;
	double	multyplier;
	
//	if(!value) return 0.0;

	if(fabs(value) >= 5)
	{
		if(!(value < 0))
		{
			if(value <= 5) return (float) 5;

			if(value <= 7.5) return (float)7.5;

			if(value <= 15) return (float)15;

			if(value <= 30) return (float)30;

			if(value <= 45) return (float)45;

			if(value <= 60) return (float)60;

			if(value <= 90) return (float)90;

			if(value <= 120) return (float)120;

			if(value <= 150) return (float)150;

			if(value <= 180) return (float)180;

			if(value <= 240) return (float)240;

			if(value <= 270) return (float)270;

			if(value <= 360) return (float)360;

			if(value <= 720) return (float)720;

			return (float) ((int)value/720 + 1) * 720;
		}
		else
		{
			value = -value;

			if(value <= 5) return -(float)5;

			if(value <= 7.5) return -(float)7.5;

			if(value <= 15) return -(float)15;

			if(value <= 30) return -(float)30;

			if(value <= 45) return -(float)45;

			if(value <= 60) return -(float)60;

			if(value <= 90) return -(float)90;

			if(value <= 120) return -(float)120;

			if(value <= 150) return -(float)150;

			if(value <= 180) return -(float)180;

			if(value <= 240) return -(float)240;

			if(value <= 270) return -(float)270;

			if(value <= 360) return -(float)360;

			if(value <= 720) return -(float)720;

			return -(float) ((int)value/720 + 1) * 720;
		}
	}

	decade = (float)Log((double)value);

	if(decade < 0) i_decade = (int)(decade) - 1;
	else i_decade = (int)(decade);

	multyplier = (float)AntiLog((double)i_decade);// gets the power of 10

	if(multyplier) value = value/(float)multyplier;

	if(!(value < 0))
	{
		if(value <= 1) return 1 * (float)multyplier;

		if(value <= 2) return (float)2 * (float)multyplier;

		if(value <= 2.5) return (float)2.5 * (float)multyplier;

		if(value <= 4) return (float)4 * (float)multyplier;

		if(value <= 5) return (float)5 * (float)multyplier;

		if(value <= 6) return (float)6 * (float)multyplier;

		if(value <= 8) return (float)8 * (float)multyplier;

		return 10 * (float)multyplier;
	}

	value = -value;

	if(value <= 1) return -1 * (float)multyplier;

	if(value <= 2) return -2 * (float)multyplier;

	if(value <= 2.5) return -2.5 * (float)multyplier;

	if(value <= 4) return -4 * (float)multyplier;

	if(value <= 5) return -5 * (float)multyplier;

	if(value <= 6) return -6 * (float)multyplier;

	if(value <= 8) return -8 * (float)multyplier;

	return -10 * (float)multyplier;
}

int QuantiseLogScale(double &max, double &min)
{
	int number;
	float temp = 0.0;
	float max1, max2;

	temp = (float)GetDecade(max);

	max1 = (float)temp;// rounding errors on double
	max2 = (float)max;

	if(max2 > max1) max = temp * 10;// round up
	else max = temp;

	min = GetDecade(min);

	if(max == min) max = min * 10;

	if(!(max > min)) // swop max and min
	{
		temp = (float)max;

		max = min;

		min = temp;
	}

	number = GetDecadeExponent(max) - GetDecadeExponent(min);

	return number;
}

int QuantiseLog2Scale(double &max, double &min)
{
	int number;
	float temp = 0.0;
	float max1, max2;

	temp = (float)GetPower2Decade(max);

	max1 = (float)temp;// rounding errors on double
	max2 = (float)max;

	if(max2 > max1) max = temp * 2;// round up
	else max = temp;

	min = GetPower2Decade(min);

	if(max == min) max = min * 2;

	if(!(max > min)) // swop max and min
	{
		temp = (float)max;

		max = min;

		min = temp;
	}

	number = GetPower2Exponent(max) - GetPower2Exponent(min);

	return number;
}

int  GetDecadeExponent(double value)
{
	int		i_decade;
	float	decade;

	value = Log(value);

	GetSafeFloat(value);// make sure value fits in float

	decade = (float) value;

	if(decade < 0)
	{
		i_decade = (int)(decade);

		if(!((double) i_decade == decade)) i_decade--;// dont modify already decaded
	}
	else i_decade = (int)(decade);

	return i_decade;
}

int  GetPower2Exponent(double value)
{
	int		i_decade;
	float	decade;

	value = Log2(value);

	GetSafeFloat(value);// make sure value fits in float

	decade = (float) value;

	if(decade < 0)
	{
		i_decade = (int)(decade);

		if(!((double) i_decade == decade)) i_decade--;// dont modify already decaded
	}
	else i_decade = (int)(decade);

	return i_decade;
}

double GetDecade(double value)
{
	int		i_decade;
	float	decade;

	value = Log(value);

	GetSafeFloat(value);// make sure value fits in float

	decade = (float) value;

	if(decade < 0) 
	{
		i_decade = (int)(decade);

		if(!((double) i_decade == decade)) i_decade--;// dont modify already decaded
	}
	else i_decade = (int)(decade);

	return AntiLog((double)i_decade);
}

double GetPower2Decade(double value)
{
	int		i_decade;
	float	decade;

	value = Log2(value);

	GetSafeFloat(value);// make sure value fits in float

	decade = (float) value;

	if(decade < 0) 
	{
		i_decade = (int)(decade);

		if(!((double) i_decade == decade)) i_decade--;// dont modify already decaded
	}
	else i_decade = (int)(decade);

	return AntiLog2((double)i_decade);
}

double ArcTanPositive(double y, double x)// fucking idiots, default should calculate the correct quadrant
{
	double arctan;

	double Y, X;

	Y = fabs(y);
	X = fabs(x);

	arctan = atan2(Y, X);

	if(y >= 0 && x >= 0) return arctan;

	if(y > 0 && x < 0) return 1.570796326794866 - arctan;
	if(y < 0 && x < 0) return 4.712388980384689 - arctan;
	if(y < 0 && x > 0) return 4.712388980384689 + arctan;

	return arctan;
}

double ArcTanNegitive(double y, double x)
{
	double arctan;

	double Y, X;

	Y = fabs(y);
	X = fabs(x);

	arctan = atan2(Y, X);

	if(y >= 0 && x >= 0) return -(4.712388980384689 + arctan);

	if(y > 0 && x < 0) return -(4.712388980384689 - arctan);
	if(y < 0 && x < 0) return -(1.570796326794866 - arctan);
	if(y < 0 && x > 0) return -arctan;

	return -(4.712388980384689 + arctan);
}

bool GetSafeDouble(double &value)
{
	int		exponent;
	double	data;
	double check = 0.0;
	int i_check;

	try
	{
		check = value;

		if(!value) value = check;// forces an exception check for invalid data

		if(value - check) value = check;// forces an exception check for invalid data
		else value = check;// forces an exception check for invalid data

		i_check = _fpclass(value);

		if(i_check == _FPCLASS_QNAN || i_check == _FPCLASS_SNAN)
		{
			value = 0.0;

			return false;
		}
		else if(i_check == _FPCLASS_NINF)
		{
			value = -1e307;

			return false;
		}
		else if(i_check == _FPCLASS_PINF)
		{
			value = 1e308;

			return false;
		}
		data = frexp(value, &exponent);

		if(exponent > DBL_MAX_EXP) 
		{
			if(data < 0)  value = -1e308;
			else  value = 1e308;

			return false;
		}

		if(exponent < LDBL_MIN_EXP) 
		{
			if(data < 0)  value = -1e-307;
			else  value = 1e-307;

			return false;
		}
	}
	catch(...)
	{
		ASSERT(0);

		value = 0.0;

		return false;
	}

	return true;
}

bool GetSafeFloat(double &value)
{
	int		exponent;
	double	data;
	double check = 0.0;
	int i_check;

	try
	{
		check = value;

		if(!value) value = check;// forces an exception check for invalid data

		if(value - check) value = check;// forces an exception check for invalid data
		else value = check;// forces an exception check for invalid data

		i_check = _fpclass(value);

		if(i_check == _FPCLASS_QNAN || i_check == _FPCLASS_SNAN)
		{
			value = 0.0;

			return false;
		}
		else if(i_check == _FPCLASS_NINF)
		{
			value = -1e37;

			return false;
		}
		else if(i_check == _FPCLASS_PINF)
		{
			value = 1e37;

			return false;
		}

		data = frexp(value, &exponent);

		if(exponent > FLT_MAX_EXP) //37
		{
			if(data < 0)  value = -1e37;
			else  value = 1e37;

			return false;
		}

		if(exponent < FLT_MIN_EXP) //for -37
		{
			if(data < 0)  value = -1e-37;
			else  value = 1e-37;

			return false;
		}
	}
	catch(...)
	{
		_fpreset();

		ASSERT(0);

		value = 0.0;

		return false;
	}

	return true;
}