// TCMKSConvert.h: interface for the TCMKSConvert class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TCMKSCONVERT_H__9CC248E3_6DCC_11D2_AD6A_6C660BC10000__INCLUDED_)
#define AFX_TCMKSCONVERT_H__9CC248E3_6DCC_11D2_AD6A_6C660BC10000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class TCMKSConvert  
{
public:
	TCMKSConvert();
	virtual ~TCMKSConvert();

};

CString GetTurnsRatio(CString Sl1, CString Sl2);

bool IsValidMKSSuffix(char suffix);
double GetMKSMultyplier(char suffix);
char GetMKSSuffix(double data);
void AFXAPI DDX_MKSValue(CDataExchange* pDX, int nIDC, double& data);
bool GetMKSValue(CWnd* pWnd, double& data);
bool GetMKSValue(HWND hWnd, double& data);
void SetMKSValue(CWnd* pWnd, double data);
void SetMKSValue(HWND hWnd, double data);
char SetMKSuffix(char suffix);
void SetMKSNumDigits(int num_digits);
int  GetMKSNumDigits(void);
double MKSStringToFloat(CString &CTextData);
CString FloatToMKSString(double data);
CString FloatToSpiceMKSString(double data);
double SpiceMKSStringToFloat(CString &CTextData);
CString MKSStringToSpiceMKSString(CString &CText);
CString RoundNumber(CString &CText);
double	AntiLog(double value);
double	Exp(double value);
double Log(double value);
double Ln(double value);
double	AntiLog2(double value);
double	Log2(double value);
double QuantiseScale(double &max, double &min, int num_ticks, bool quantise);
double QuantisePhaseScale(double &max, double &min, int num_ticks, bool quantise);
double _QuantiseScale(double &max, double &min, int num_ticks);
double _QuantisePhaseScale(double &max, double &min, int num_ticks);
float MKSRoundFloat(float value);
float MKSPhaseRoundFloat(float value);
int QuantiseLogScale(double &max, double &min);
int QuantiseLog2Scale(double &max, double &min);
int  GetDecadeExponent(double value);
double GetDecade(double value);

int  GetPower2Exponent(double value);
double GetPower2Decade(double value);

double ArcTanPositive(double y, double x);
double ArcTanNegitive(double y, double x);
bool GetSafeDouble(double &value);
bool GetSafeFloat(double &value);

double Log(double value);

#endif // !defined(AFX_TCMKSCONVERT_H__9CC248E3_6DCC_11D2_AD6A_6C660BC10000__INCLUDED_)
