// TCMasterLibaryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMasterLibaryDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
 
/////////////////////////////////////////////////////////////////////////////
// TCMasterLibaryDlg

extern int g_last_active_symbol_model_property_page;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase; 

IMPLEMENT_DYNAMIC(TCMasterLibaryDlg, CPropertySheet)

TCMasterLibaryDlg::TCMasterLibaryDlg(CWnd* pWndParent)
	 : CPropertySheet(IDS_PROPSHT_CAPTION_SYM_MOD_LIB, pWndParent)
{

	AddPage(&CMSymbolDlg);
	AddPage(&CMModelDlg);

	CMSymbolDlg.PCComponentDataBaseData	= &CComponentDataBaseData;
	CMModelDlg.PCComponentDataBaseData	= &CComponentDataBaseData;

	SetActivePage(g_last_active_symbol_model_property_page);

	button_pressed = E_LIB_CANCEL;
	CMSymbolDlg.PCParent = this;
}

TCMasterLibaryDlg::~TCMasterLibaryDlg()
{
}


BEGIN_MESSAGE_MAP(TCMasterLibaryDlg, CPropertySheet)
	//{{AFX_MSG_MAP(TCMasterLibaryDlg)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCMasterLibaryDlg message handlers



INT_PTR TCMasterLibaryDlg::DoModal() 
{
	int result = CPropertySheet::DoModal();

	FormatSpiceValue();

	button_pressed = CMSymbolDlg.button_pressed;

	return result;
}

void TCMasterLibaryDlg::FormatSpiceValue(void)
{
	bool	no_symbols	= true;
	bool	no_models	= true;
	int		symbol_index	= 0; 
	int		model_index		= 0;

	if(CComponentDataBaseData.symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())
	{
		symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[CComponentDataBaseData.symbol_file_index].index;
			
		no_symbols = false;
	}

	if(CComponentDataBaseData.model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())
	{
		model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].index;
	

		no_models = false;
	}


	if(!no_symbols)
	{
		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[CComponentDataBaseData.symbol_file_index].CSymbolList;

		if(!no_models)
		{
			if(symbol_index < CSymbolList.GetSize())
			{
				if(model_index < GCSuperSpiceDataBase.CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters.GetSize())
					CSymbolList[symbol_index].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = GCSuperSpiceDataBase.CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters[model_index].CDataBaseIdInfo.CRecordName;
		
				CSymbolList[symbol_index].FormatSpiceValue();
			}
		}
	}
}

BOOL TCMasterLibaryDlg::OnInitDialog() 
{
	BOOL bResult = CPropertySheet::OnInitDialog();
	
	int temp = g_last_active_symbol_model_property_page;

	SetActivePage(0);
	
	SetActivePage(temp);

	return bResult;
}
