// TCModelPreViewView.cpp : implementation file
//

#include "stdafx.h"
#include "TCSuperSpiceDataBase.h"
#include "superspice.h"
#include "TCModelPreviewDoc.h"
#include "TCModelPreViewView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
/////////////////////////////////////////////////////////////////////////////
// TCModelPreViewView
extern void DisplayPopupMenu(CWnd*, CPoint, int);

IMPLEMENT_DYNCREATE(TCModelPreViewView, CRichEditView)

TCModelPreViewView::TCModelPreViewView()
{
	m_nWordWrap = WrapNone;
}

TCModelPreViewView::~TCModelPreViewView()
{
}


BEGIN_MESSAGE_MAP(TCModelPreViewView, CRichEditView)
	//{{AFX_MSG_MAP(TCModelPreViewView)
	ON_WM_RBUTTONDOWN()
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP

	ON_COMMAND(ID_POPUP_SAVECHANGES, OnViewSaveChanges)
	ON_COMMAND(ID_POPUP_REFRESH, OnViewRefresh)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCModelPreViewView drawing

void TCModelPreViewView::OnDraw(CDC* pDC)
{
	pDC;
//	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// TCModelPreViewView diagnostics

#ifdef _DEBUG
void TCModelPreViewView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void TCModelPreViewView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCModelPreViewView message handlers


void TCModelPreViewView::OnRButtonDown(UINT nFlags, CPoint point) 
{	
	DisplayPopupMenu(this, point, CG_IDR_POPUP_TCSUPER_SPICE_MODEL_PREVIEW);

	CRichEditView::OnRButtonDown(nFlags, point);
}

bool TCModelPreViewView::DisplayModel(CString CFileName, CString CModelName)
{
	CSpiceParameters.CDataBaseIdInfo.CRecordName	= CModelName;
	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CFileName);
	CSpiceParameters.CDataBaseIdInfo.CRecordFileName = ExtractFileName(CFileName);

	OnViewRefresh();

	return true;
}

void TCModelPreViewView::OnViewSaveChanges(void)
{
	if(CSpiceParameters.CDataBaseIdInfo.model_type == E_SPICE_SCHEMATIC) return;
	if(CSpiceParameters.CDataBaseIdInfo.model_type == E_SPICE_GENERATOR) return;
	if(CSpiceParameters.CDataBaseIdInfo.CRecordName == "") return;
	if(CSpiceParameters.CDataBaseIdInfo.CRecordFileName == "") return;

	if(!GetText()) return;

	if(!GCSuperSpiceDataBase.CModelDataBase.Set(CSpiceParameters)) return;

	OnViewRefresh();
}

bool TCModelPreViewView::GetText(void)
{
	if(CSpiceParameters.CDataBaseIdInfo.model_type == E_SPICE_SCHEMATIC) return false;
	if(CSpiceParameters.CDataBaseIdInfo.model_type == E_SPICE_GENERATOR) return false;

	CString CTextLine;

	GetWindowText(CTextLine);

	CArray <CString, CString&> CTempModelData;
	CString CText;

	int size;

	char *buff;

	size = CTextLine.GetLength();

	if(!size) return false;

	buff = CTextLine.GetBuffer(size + 1);

	while(*buff != 0)
	{
		if(*buff == '\r')
		{
			buff++;// ignore next \n that should be there !!??
			if(*buff == '\n') buff++;

			CTempModelData.Add(CText);

			CText = "";
		}
		else CText += *buff++;
	}

	if(CText != "") CTempModelData.Add(CText);

	int count = CTempModelData.GetSize();

	if(!count) return false;

	if(CSpiceParameters.CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL)
		CSpiceParameters.SetFromText(CTempModelData);
	else
	{
		CSpiceParameters.CData.SetSize(count);

		for(int p = 0; p < count; p++) CSpiceParameters.CData[p].CName = CTempModelData[p];
	}

	return true;
}

void TCModelPreViewView::OnViewRefresh(void)
{
	SetWindowText("");

	CDocument* pDoc = GetDocument();

	if(!pDoc) return;

	pDoc->SetModifiedFlag(false);

	if(!GCSuperSpiceDataBase.CModelDataBase.Get(CSpiceParameters)) return;

	CArray <CString, CString &> CTextLines;

	CSpiceParameters.GetToText(CTextLines);

	int count = CTextLines.GetSize();

	if(!count) return;

	CString CTextLine;
	CString CEndLine = "\r\n";

	for(int p = 0; p < count; p++)
	{
		CTextLine += CTextLines[p] + CEndLine;
	}

	SetWindowText(CTextLine);

	pDoc->SetModifiedFlag(false);

	return;
}

BOOL TCModelPreViewView::PreTranslateMessage(MSG* pMsg) 
{

	if (::GetFocus( ) == m_hWnd)
	{
		::TranslateMessage(pMsg);
		::DispatchMessage(pMsg);

		return TRUE;
	}

//	WORD data = HIWORD(pMsg->wParam);

	return CRichEditView::PreTranslateMessage(pMsg);
}

