#include "stdafx.h"
#include "resource.h"
#include "SuperSpice.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicObjectData.h"
#include "TCSymbolPreDoc.h"
#include "TCSymbolPreView.h"
#include "TCModelPreViewView.h"
#include "TCModelPreViewDoc.h"
#include "TCModelSymbolTab.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;

TCModelSymbolTab::TCModelSymbolTab(void)
{
	PCMSymbolPreDoc = NULL;
	
	PCModelPreviewDoc = NULL;
}

TCModelSymbolTab::~TCModelSymbolTab(void)
{

}

void TCModelSymbolTab::DisplaySymbol(CString CFileName, CString CSymbolName, bool f_track, unsigned short f_default)
{
	if(!PCMSymbolPreDoc) return;

	if(!f_default) 
	{
		if(!PCMSymbolPreDoc->DisplaySymbol(CFileName, CSymbolName))
		{
			CFileName = ExtractFileName(CFileName);

			CFileName = GetSuperSpiceSystemDir() + CFileName;

			PCMSymbolPreDoc->DisplaySymbol(CFileName, CSymbolName);
		}
	}
	else //internal symbol but copied into external files
	{
		CSymbolName = GCSuperSpiceDataBase.CMDefaults[f_default].CSymbolData.CName;

		CFileName = GCSuperSpiceDataBase.GetDefaultFileNameFromId(f_default);

		CFileName = ExtractFileName(CFileName);

		CFileName = GetSuperSpiceSystemDir() + CFileName;

		PCMSymbolPreDoc->DisplaySymbol(CFileName, CSymbolName);
	}

	//Now find model, if any, attached to symbol  and display it

	if(!f_track) return;

	TCSchematicObjectData &CSchematicObjectData = PCMSymbolPreDoc->GetSchematicObjectData();

	CFileName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath + CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CSymbolName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;
	
	if(!PCModelPreviewDoc->DisplayModel(CFileName, CSymbolName))//model name
	{
		CFileName = GetSuperSpiceSystemDir() + CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	
		PCModelPreviewDoc->DisplayModel(CFileName, CSymbolName);
	}
}

void TCModelSymbolTab::DisplayModel(CString CFileName, CString CModelName, bool f_track)
{
	if(!PCModelPreviewDoc) return;

	PCModelPreviewDoc->DisplayModel(CFileName, CModelName);

	if(!f_track) return;

	//Now find symbol, if any, attached to model, and display it

	TCSpiceParameters &CSpiceParameters = PCModelPreviewDoc->GetSpiceParameters();

	CFileName = CSpiceParameters.CDataBaseIdInfo.CSymbolFileName;
	CString CSymbolName = CSpiceParameters.CDataBaseIdInfo.CSymbolName;

	if(CSymbolName == "")
	{
		int id = GCSuperSpiceDataBase.FindInternalSymbolFromModelType(CSpiceParameters);

		if(id < 0) return;

		CSymbolName = GCSuperSpiceDataBase.CMDefaults[id].CSymbolData.CName;
		CFileName = GCSuperSpiceDataBase.GetDefaultFileNameFromId(id);
	}

	CString CName = ExtractFileName(CFileName);

	CString CPathname = ExtractPathName(CFileName); // expand out the path

	CFileName = CPathname + CName;  

	if(!PCMSymbolPreDoc->DisplaySymbol(CFileName, CSymbolName))//find specified symbol
	{
		//try and find in default path

		CFileName = GetSuperSpiceSystemDir() + CName;

		PCMSymbolPreDoc->DisplaySymbol(CFileName, CSymbolName);
	}
}

void TCModelSymbolTab::DisplayCircuit(CString CFileName, CString CCircuitName)
{
	if(!PCMSymbolPreDoc) return;

	PCMSymbolPreDoc->DisplayCircuit(CFileName, CCircuitName);
}