#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "superspice.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceTextDoc.h"
#include "TCTreeRename.h"
#include "TCMasterModelDlg.h"
#include "TCModelTreeDoc.h"
#include "TCModelTreeView.h"
#include "TCModelSymbolTab.h"
#include "TCFindModelDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase		GCSuperSpiceDataBase; 
extern CString GLastFileTreeModelFile;
extern CString GLastFileTreeModel;
extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;
extern TCModelSymbolTab CModelSymbolTab;


/////////////////////////////////////////////////////////////////////////////
// TCModelTreeView

HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,LPCTSTR txt,int imgind,int selimgind, int id);
HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,HTREEITEM hTreeItem, LPCTSTR txt,int imgind,int selimgind, int id);


IMPLEMENT_DYNCREATE(TCModelTreeView, CXTTreeView)

BEGIN_MESSAGE_MAP(TCModelTreeView, CXTTreeView)
	//{{AFX_MSG_MAP(TCModelTreeView)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_WM_CONTEXTMENU()

	ON_COMMAND(ID_POPUP_ADDMODELFILE, AddModelFile)
	ON_COMMAND(ID_EDIT_COPY_TREE, EditCopy)
	ON_COMMAND(ID_EDIT_PASTE_TREE, EditPaste)
	ON_COMMAND(ID_EDIT_DELETE_TREE, EditDelete)
	ON_COMMAND(ID_POPUP_EDITMODEL, EditModel)
	ON_COMMAND(ID_POPUP_SELECTSYMBOL, SelectSymbol)
	ON_COMMAND(ID_POPUP_RENAME, Rename)
	ON_COMMAND(ID_POPUP_PROPERTIES, Properties)
	ON_COMMAND(ID_POPUP_EDITMODEL, EditModelFile)
	ON_COMMAND(ID_REFRESH_TREE, Refresh)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDoubleClickTree) 
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_POPUP_PLACEMODEL, PlaceModel)
	ON_NOTIFY_REFLECT(TVN_BEGINDRAG, OnBeginDragDrop)

	ON_COMMAND(ID_POPUP_FINDMODEL, FindModel)


END_MESSAGE_MAP()
 
/////////////////////////////////////////////////////////////////////////////
// TCModelTreeView construction/destruction

TCModelTreeView::TCModelTreeView()
{
	m_pTreeCtrl =  &GetTreeCtrl();

	ASSERT(m_pTreeCtrl);

	hlast_saved_file = NULL;
	hlast_saved_item = NULL;
	f_last_model	 = true;
	m_is_dragging	 = false;
}

TCModelTreeView::~TCModelTreeView()
{
//	m_ImageList.DeleteImageList();
}

void TCModelTreeView::FindModel(void)
{
	TCFindModelDlg CFindModelDlg;

	if(CFindModelDlg.DoModal() != IDOK) return;

	CFindModelDlg.FindAndDisplayModel(CFindModelDlg.CMModelName);
}

void TCModelTreeView::SelectModel(HTREEITEM hitem)
{
	if(!hitem) return;

	m_pTreeCtrl->SelectItem(hitem);
}

void TCModelTreeView::OnLButtonDown(UINT nFlags, CPoint CMousePosition) 
{
	HTREEITEM hItem;
	UINT      nHF;

	hItem = m_pTreeCtrl->HitTest(CMousePosition, &nHF);

	//Force the new selection to the current one
	if(hItem) m_pTreeCtrl->SelectItem(hItem);

	CXTTreeView::OnLButtonDown(nFlags, CMousePosition);

	CString CModelName = GetModelName();

	if(CModelName == "") return;

	CString CModelFileName = GetFileName();

	if(CModelFileName == "") return;

	CModelSymbolTab.DisplayModel(CModelFileName, CModelName);
}

BOOL TCModelTreeView::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CXTTreeView::PreCreateWindow( cs ))
		return FALSE;

	// Set the style for the tree control.
	cs.style |= TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT;

	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// TCModelTreeView drawing

void TCModelTreeView::OnDraw(CDC* pDC)
{
	pDC;
	TCModelTreeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

}

void TCModelTreeView::OnInitialUpdate()
{
	CXTTreeView::OnInitialUpdate();

	// TODO: You may populate your TreeView with items by directly accessing
	//  its tree control through a call to GetTreeCtrl().

}


/////////////////////////////////////////////////////////////////////////////
// TCModelTreeView diagnostics

#ifdef _DEBUG
void TCModelTreeView::AssertValid() const
{
	CXTTreeView::AssertValid();
}

void TCModelTreeView::Dump(CDumpContext& dc) const
{
	CXTTreeView::Dump(dc);
}

TCModelTreeDoc* TCModelTreeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(TCModelTreeDoc)));
	return (TCModelTreeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCModelTreeView message handlers

void TCModelTreeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender;
	lHint;
	pHint;
}

void TCModelTreeView::UpdateView()
{
/*
	if (!m_pTreeCtrl || !m_pTreeCtrl->GetSafeHwnd())
		return;

	CString strTreeItems[] = { _T("Tree item 1"), _T("Tree item 2"), _T("Tree item 3") };
		
	// Add the parent item
	HTREEITEM htItem = m_pTreeCtrl->InsertItem(strTreeItems[0]);
	m_pTreeCtrl->SetItemState(htItem, TVIS_BOLD, TVIS_BOLD);
	
	// Add children
	for( int i = 1; i < 8; i++ )
	{
		m_pTreeCtrl->InsertItem(
			strTreeItems[1], 1, 1, htItem, TVI_LAST);
	}
	
	// Add children
	m_pTreeCtrl->InsertItem (strTreeItems[2], 2, 3, htItem, TVI_LAST);
	m_pTreeCtrl->Expand(htItem, TVE_EXPAND);

	*/
}

BOOL TCModelTreeView::OnEraseBkgnd(CDC* pDC) 
{
	UNUSED_ALWAYS(pDC);
	return TRUE;
}

int TCModelTreeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CXTTreeView::OnCreate(lpCreateStruct) == -1) return -1;

	ASSERT(m_pTreeCtrl);
/*
	if (!m_ImageList.Create(IDB_TREENODES, 23, 1, RGB(0x00,0x80,0x80))) return -1;
	
	m_pTreeCtrl->SetImageList(&m_ImageList, TVSIL_NORMAL);
	*/	

	CBitmap bitmap;

	m_ImageList.Create(23, 19, ILC_COLOR|ILC_MASK, 6, 4); 
	m_ImageList.SetBkColor(GetSysColor(COLOR_WINDOW));
	bitmap.LoadBitmap(IDB_TREENODES);
	m_ImageList.Add(&bitmap, (COLORREF)0xFFFFFF);
	m_pTreeCtrl->SetImageList(&m_ImageList, TVSIL_NORMAL);

	UpdateView();

	return 0;
} 
 
void TCModelTreeView::OnRButtonDown(UINT nFlags, CPoint point)
{
	nFlags;
	OnContextMenu(NULL, point);// XT messes up context menu handling
}

void TCModelTreeView::OnContextMenu(CWnd*, CPoint point)
{
	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_TREE_MODEL));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	ClientToScreen(&point);// XT messes up context menu handling

	CWnd* pWndPopupOwner = this;
//	while (pWndPopupOwner->GetStyle() & WS_CHILD) // XT messes up context menu handling
//		pWndPopupOwner = pWndPopupOwner->GetParent(); // XT messes up context menu handling

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,pWndPopupOwner);
}

LRESULT TCModelTreeView::OnNcHitTest(CPoint point) 
{ 
	UINT uFlag=0;

	if(!m_pTreeCtrl) return HTNOWHERE;
	if(!m_pTreeCtrl->m_hWnd) return HTNOWHERE;
	// Get the cursor location in client coordinates.
	CPoint pt = point;	
	ScreenToClient(&pt);

	// Get a pointer to the tooltip control.
	CToolTipCtrl* pCtrl = (CToolTipCtrl*)CWnd::FromHandle((HWND)::SendMessage(m_hWnd, TVM_GETTOOLTIPS, 0, 0L));

	// If we have a valid tooltip pointer and the cursor
	// is over a tree item, the bring the tooltip control
	// to the top of the Z-order.
	if (pCtrl && m_pTreeCtrl->HitTest(pt, &uFlag))
	{
		pCtrl->SetWindowPos(&wndTop,0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE |SWP_NOMOVE);
	}
	
	return CXTTreeView::OnNcHitTest(point);
}

void TCModelTreeView::UpdateAllData(void)
{
	int count, p, q, model_count;
	CString CModelFileName, CModelName;

	HTREEITEM	hTI = NULL,  htmp = NULL;

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;
	
	count = CFiles.GetSize();

	if(!count) return;

	int id;

	for(p = 0; p < count; p++)
	{
		id = CFileID.GetNewPageId("");

		int index_id = CFileID.GetPageIndex(id);

		if(index_id < 0) return;

		CFileID.CPageIdData[index_id].CPageTitle = CFiles[p].CPath + CFiles[p].CName;

		hTI = InsertTreeItem(m_pTreeCtrl, CFiles[p].CType,0,1, id);// CType is File name

		CFiles[p].HTreeItem = hTI;

		if(!hlast_saved_file)
		if(CFileID.CPageIdData[index_id].CPageTitle == GLastFileTreeModelFile)
		{
			hlast_saved_file = hTI;
		}

		TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[p].CParametersList;

		model_count = CModelList.CParameters.GetSize();

		for(q= 0; q < model_count; q++)
		{
			htmp = InsertTreeItem(m_pTreeCtrl, hTI, CModelList.CParameters[q].CDataBaseIdInfo.CRecordName,2,3, 0);
	
			CModelList.CParameters[q].HTreeItem = htmp; 

			if(hlast_saved_file)
			{
				if(CModelList.CParameters[q].CDataBaseIdInfo.CRecordName == GLastFileTreeModelFile)
				{
					hlast_saved_item = htmp;
				}
			}
		}

		m_pTreeCtrl->SelectItem(hTI);// force a redraw
	}

	f_last_model = true;
}

void TCModelTreeView::Refresh(void)
{
	ASSERT(m_pTreeCtrl);

	m_pTreeCtrl->DeleteAllItems();

	CFileID.Clear();

	UpdateAllData();
}

HTREEITEM TCModelTreeView::GetFileItem(CString CFileName)
{
	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	int index = GCSuperSpiceDataBase.FindModelFile(CFileName);

	if(index < 0) return NULL;

	return CFiles[index].HTreeItem;
}

HTREEITEM TCModelTreeView::GetModelItem(CString CFileName, CString CModelName)
{
	int index = GCSuperSpiceDataBase.FindModelFile(CFileName);

	if(index < 0) return NULL;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[index].CParametersList;

	int model_index = CModelList.FindModelOrSubcircuit(CModelName);

	if(model_index < 0) return NULL;

	return CModelList.CParameters[model_index].HTreeItem;
}


HTREEITEM TCModelTreeView::GetItemClicked(TV_HITTESTINFO &tvhti)
{
	DWORD				dwpos;
	POINT				point;

// Bullshit code that should already be done my M.S.
	// find out where the cursor was
	dwpos = GetMessagePos();
	point.x = LOWORD(dwpos);
	point.y = HIWORD(dwpos);

	::MapWindowPoints(HWND_DESKTOP, m_hWnd, &point, 1);

	tvhti.pt = point;
	
	HTREEITEM hitem = m_pTreeCtrl->HitTest(&tvhti);

	if(!(tvhti.flags & (TVHT_ONITEMLABEL | TVHT_ONITEMICON))) return NULL;

	return hitem;
}

int TCModelTreeView::GetFileIndex()
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return -1;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CModelName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CModelName == "") return -1;

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return -1;

	id = CFileID.GetPageIndex(id);

	if(id < 0) return -1;

	CString CModelFileName = CFileID.CPageIdData[id].CPageTitle;

	return GCSuperSpiceDataBase.FindModelFile(CModelFileName);
}

int TCModelTreeView::GetIndex()
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return -1;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return -1;

	CString CModelName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CModelName == "") return -1;

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return -1;

	id = CFileID.GetPageIndex(id);

	if(id < 0) return -1;

	CString CModelFileName = CFileID.CPageIdData[id].CPageTitle;

	int model_file_index = GCSuperSpiceDataBase.FindModelFile(CModelFileName);

	if(model_file_index < 0) return -1; 
	
	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	return CFiles[model_file_index].CParametersList.FindModelOrSubcircuit(CModelName);
}

CString TCModelTreeView::GetFileName(void)
{ 
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CModelName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CModelName == "") return "";

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return "";

	id = CFileID.GetPageIndex(id);

	if(id < 0) return "";

	return CFileID.CPageIdData[id].CPageTitle;
}

CString TCModelTreeView::GetModelName(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return "";

	return m_pTreeCtrl->GetItemText(htiItemClicked);
}

void TCModelTreeView::PlaceModel(void)
{
	int file_index, model_index;

	file_index = GetFileIndex();

	if(file_index < 0) return;

	model_index = GetIndex();

	if(model_index < 0) return;

	GCSuperSpiceDataBase.PlaceSymbolFromModel(file_index, model_index);

	return;
}

void TCModelTreeView::OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult)
{
	*pResult = 0;

	if(!PCSuperSpiceDocLastFocused) return;
	if(!PCSuperSpiceViewLastFocused) return;

	pNMHDR;


	DWORD				dwpos;
	TV_HITTESTINFO		tvhti;
	HTREEITEM           htiItemClicked, hparent;
	POINT				point;

// Bullshit code that should already be done my M.S.
	// find out where the cursor was
	dwpos = GetMessagePos();
	point.x = LOWORD(dwpos);
	point.y = HIWORD(dwpos);

	::MapWindowPoints(HWND_DESKTOP, m_hWnd, &point, 1);

	tvhti.pt = point;
//
	htiItemClicked = m_pTreeCtrl->HitTest(&tvhti);

	if(!htiItemClicked) return;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;

	if(!(tvhti.flags & (TVHT_ONITEMLABEL | TVHT_ONITEMICON))) return;

	CString CModelName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CModelName == "") return;

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return;

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CString CModelFileName = CFileID.CPageIdData[id].CPageTitle;

	int model_file_index = GCSuperSpiceDataBase.FindModelFile(CModelFileName);

	if(model_file_index < 0) return; //system error

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	int model_index = CFiles[model_file_index].CParametersList.FindModelOrSubcircuit(CModelName);

	if(model_index < 0) return; //system error

	GCSuperSpiceDataBase.PlaceSymbolFromModel(model_file_index, model_index);
}

void TCModelTreeView::SelectSymbol()
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;

	CString CModelName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CModelName == "") return;

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return;

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CString CModelFileName = CFileID.CPageIdData[id].CPageTitle;

	int model_file_index = GCSuperSpiceDataBase.FindModelFile(CModelFileName);

	if(model_file_index < 0) return; //system error

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	int model_index = CFiles[model_file_index].CParametersList.FindModelOrSubcircuit(CModelName);

	if(model_index < 0) return; //system error
	
	int count = CFiles.GetSize();

	if(!count) return;
	if(!(model_file_index < count)) return;

	TCSpiceParametersList &CModelList = CFiles[model_file_index].CParametersList;

	if(!(model_index < CModelList.CParameters.GetSize())) return;

	TCSpiceParameters &CSpiceParameters = CModelList.CParameters[model_index];

	int result = GCSuperSpiceDataBase.FindInternalSymbolFromLibrary(CSpiceParameters, model_file_index, model_index);

	if(result == E_LIB_PLACE_SYMBOL) GCSuperSpiceDataBase.PlaceSymbolFromSymbol(model_file_index, model_index, 0);

}

bool TCModelTreeView::Remove(HTREEITEM HItem)
{ 
	int id;

	if(IsBadCodePtr((FARPROC) HItem)) return false;

	HTREEITEM hparent = m_pTreeCtrl->GetParentItem(HItem);

	if(!hparent)// must be the file folder
	{
		id = m_pTreeCtrl->GetItemData(hparent);

		if(id < 0) return false;

		CFileID.RemovePageId(id);
	}
	
	return !!m_pTreeCtrl->DeleteItem(HItem);
}

bool TCModelTreeView::Add(CString CFileName, int model_index)
{
	HTREEITEM HItem;

	if(model_index < 0) return false;

	int model_file_index = GCSuperSpiceDataBase.FindModelFile(CFileName);

	if(model_file_index < 0) return false;

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;
	
	int count = CFiles.GetSize();

	if(!count) return false;
	if(!(model_file_index < count)) return false;

	HItem = CFiles[model_file_index].HTreeItem;

	if(!HItem) return false;

	if(IsBadCodePtr((FARPROC) HItem)) return false;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

	int model_count = CModelList.CParameters.GetSize();

	if(!model_count) return false;
	if(!(model_index < model_count)) return false;

	HTREEITEM htmp = InsertTreeItem(m_pTreeCtrl, HItem, CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName,2,3, 0);

	CModelList.CParameters[model_index].HTreeItem = htmp;

	m_pTreeCtrl->SelectItem(htmp);// force redraw

	return true;
}

bool TCModelTreeView::AddFile(int model_file_index)
{
	int count, q, model_count;

	HTREEITEM	hTI = NULL, htmp = NULL;

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;
	
	count = CFiles.GetSize();

	if(!count) return false;
	if(!(model_file_index < count)) return false;
	if(model_file_index < 0) return false;

	int id = CFileID.GetNewPageId("");

	int index_id = CFileID.GetPageIndex(id);

	if(index_id < 0) return false;

	CFileID.CPageIdData[index_id].CPageTitle = CFiles[model_file_index].CPath + CFiles[model_file_index].CName;

	hTI = InsertTreeItem(m_pTreeCtrl, CFiles[model_file_index].CType,0,1, id);// CType is File name

	CFiles[model_file_index].HTreeItem = hTI;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

	model_count = CModelList.CParameters.GetSize();

	for(q = 0; q < model_count; q++)
	{
		htmp = InsertTreeItem(m_pTreeCtrl, hTI, CModelList.CParameters[q].CDataBaseIdInfo.CRecordName,2,3, 0);

		CModelList.CParameters[q].HTreeItem = htmp;
	}

	m_pTreeCtrl->Expand(hTI, TVE_COLLAPSE);

	return true;
}

void TCModelTreeView::EditCopy(void)
{
	Copy(CMDataBaseClipboard);
}

void TCModelTreeView::EditPaste(void)
{
	Paste(CMDataBaseClipboard);

	Rename();
}

void TCModelTreeView::Copy(TCDataBaseClipboard &CDataBaseClipboard)
{
	CString CFileName = GetFileName();

	CDataBaseClipboard.CSource.CModelFileName	= ExtractFileName(CFileName);
	CDataBaseClipboard.CSource.CModelPathName	= ExtractPathName(CFileName);
	CDataBaseClipboard.CSource.CModelName		= GetModelName();
	CDataBaseClipboard.CSource.use_index		= false;

	if(CDataBaseClipboard.CSource.CModelName != "")
		GCSuperSpiceDataBase.CopyModel(CDataBaseClipboard);
	else GCSuperSpiceDataBase.CopyModelFile(CDataBaseClipboard);
}

void TCModelTreeView::Paste(TCDataBaseClipboard &CDataBaseClipboard)
{
	CString CFileName = GetFileName();

	CDataBaseClipboard.CDestination.use_index		= false;

	if(CDataBaseClipboard.CSource.CModelName != "") 
	{
		CDataBaseClipboard.CDestination.CModelFileName	= ExtractFileName(CFileName);
		CDataBaseClipboard.CDestination.CModelPathName  = ExtractPathName(CFileName);

		CDataBaseClipboard.model_count = GetIndex() + 1;

		GCSuperSpiceDataBase.PasteModel(CDataBaseClipboard);

		if(!(CDataBaseClipboard.model_count < 0)) 
		{
			Refresh();

			m_pTreeCtrl->Expand(GetFileItem(CFileName), TVE_EXPAND);

			HTREEITEM h_item = GetModelItem(CFileName, CDataBaseClipboard.CDestination.CModelName);

			m_pTreeCtrl->SelectItem(h_item);
		}
	}
	else 
	{
		CString CFileName;

		CString CFileDescriptor;
	
		CFileDescriptor.LoadString(IDS_STRING_MODEL_FILE_DESCRIPTOR);

		CFileDialog	CLoadFileDialog(false, "lib",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName, OFN_OVERWRITEPROMPT,CFileDescriptor);

		if(CLoadFileDialog.DoModal() != IDOK) 
		{
			CFileName = CLoadFileDialog.GetPathName();

			GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName = CFileName;

			return;
		}

		CFileName = CLoadFileDialog.GetPathName();

		if(CFileName == "") return;

		CDataBaseClipboard.CDestination.CModelPathName = ExtractPathName(CFileName);
		CDataBaseClipboard.CDestination.CModelFileName = ExtractFileName(CFileName);

		GCSuperSpiceDataBase.PasteModelFile(CDataBaseClipboard);
	}
}

void TCModelTreeView::EditDelete(void)
{
	int model_file_index, model_index;

	model_file_index = GetFileIndex();
	model_index = GetIndex();

	if(model_file_index < 0) return;

	CString CFileName, CModelName, CMessage;

	if(!(model_index < 0)) 
	{
		CModelName = GetModelName();
		CFileName = GetFileName();

		CMessage = "Confirm delete of model " + CModelName + " in file " + CFileName;

		if(AfxMessageBox(CMessage, MB_OKCANCEL) != IDOK) return;

		GCSuperSpiceDataBase.RemoveModel(model_file_index, model_index);
	}
	else 
	{
		CFileName = GetFileName();

		CMessage = "Confirm remove of model file " + CFileName;

		if(AfxMessageBox(CMessage, MB_OKCANCEL) != IDOK) return;

		GCSuperSpiceDataBase.RemoveModelFile(model_file_index);
	}
}

void TCModelTreeView::EditModel(void)
{
	CString CFileName = GetFileName();

	if(CFileName == "") return;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();
	
	TCSuperSpiceDoc *PCTopDoc = PCSuperSpiceApp->GetATopLevelDocument();

	if(!PCTopDoc) return;

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc;

	PCSuperSpiceTextDoc = PCTopDoc->DisplayTextBasedDocument(CFileName);

	if(!PCSuperSpiceTextDoc)// try opening from main open file
	{
		PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc*) AfxGetApp()->OpenDocumentFile(CFileName);
	}

	if(PCSuperSpiceTextDoc) 
	{
		PCSuperSpiceTextDoc->update_model_libary = true;

		CString CModelName = GetModelName();

		if(CModelName == "") return;

		PCSuperSpiceTextDoc->ScrollTo(CModelName);
	}
}

void TCModelTreeView::AddModelFile(void)
{
	CString CFileName;

	CString CFileDescriptor;
	
	CFileDescriptor.LoadString(IDS_STRING_MODEL_FILE_DESCRIPTOR);

	CFileDialog	CLoadFileDialog(true, "lib",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName, 0, CFileDescriptor);

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.AddModelFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_MODEL_FILE);

		return;
	}

	EndWaitCursor();
}

void TCModelTreeView::Rename(HTREEITEM HItem, CString CName)
{
	m_pTreeCtrl->SetItemText(HItem, CName);

	m_pTreeCtrl->SelectItem(HItem);
}

void TCModelTreeView::Rename(void)
{
	TCTreeRename CTreeRename;
	
	CString CFileName =  GetFileName();

	if(CFileName == "") return;

	CString CModelName = GetModelName();

	if(CModelName == "") return;

	CTreeRename.CName = CModelName;

	if(CTreeRename.DoModal() != IDOK) return;

	CTreeRename.CName.TrimLeft();
	CTreeRename.CName.TrimRight();

	if(CTreeRename.CName == "") return;

	if(CTreeRename.CName == CModelName) return;

	GCSuperSpiceDataBase.RenameModel(CFileName, CModelName, CTreeRename.CName);
}

void TCModelTreeView::Properties(void)
{
	TCMasterModelDlg CMasterModelDlg;
	
	TCComponentDataBaseData CComponentDataBaseData;

	CString CFileName = GetFileName();

	CComponentDataBaseData.CModelFileName	= ExtractFileName(CFileName);
	CComponentDataBaseData.CModelPathName	= ExtractPathName(CFileName);
	CComponentDataBaseData.CModelName		= GetModelName();

	CMasterModelDlg.m_check = false;

	CMasterModelDlg.enable_edit_model_file = false;

	GCSuperSpiceDataBase.SetDefaultModelDisplayed(CComponentDataBaseData);

	CMasterModelDlg.DoModal();
}

void TCModelTreeView::EditModelFile(void)
{
	CString CFileName = GetFileName();

	if(CFileName == "") return;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();
	
	TCSuperSpiceDoc *PCTopDoc = PCSuperSpiceApp->GetATopLevelDocument();
 
	if(!PCTopDoc) return;

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc;

	PCSuperSpiceTextDoc = PCTopDoc->DisplayTextBasedDocument(CFileName);

	if(!PCSuperSpiceTextDoc)// try opening from main open file
	{
		PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc*) AfxGetApp()->OpenDocumentFile(CFileName);
	}

	if(PCSuperSpiceTextDoc) 
	{
		PCSuperSpiceTextDoc->update_model_libary = true;
	}
}

bool TCModelTreeView::IsDragging(void)
{
	return m_is_dragging;
}

bool TCModelTreeView::PlaceDragedSymbol(void)
{
	PlaceModel();

	return true;
}

void TCModelTreeView::ClearDragging(void)
{
	m_is_dragging	= false;
}

BOOL TCModelTreeView::PreTranslateMessage(MSG* pMsg) 
{
	return CXTTreeView::PreTranslateMessage(pMsg);
}

void TCModelTreeView::OnBeginDragDrop(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR; pResult;

	m_is_dragging = true;

	return;// false;
}
