#if !defined(AFX_TABVIEW1_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_)
#define AFX_TABVIEW_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxcview.h>
#include "TCNumberStack.h"

class TCModelTreeView : public CXTTreeView
{
protected: // create from serialization only
	TCModelTreeView();
	DECLARE_DYNCREATE(TCModelTreeView)

// Attributes
public:
	TCModelTreeDoc* GetDocument();
	
	CTreeCtrl*	m_pTreeCtrl;
	CImageList	m_ImageList;
	bool m_is_dragging;

	TCPageId		CFileID;

	void UpdateAllData(void);
	void Refresh(void);
	void Copy(void);
	void Paste(void);

	HTREEITEM hlast_saved_file;
	HTREEITEM hlast_saved_item;
	bool	  f_last_model;
	TCDataBaseClipboard			CMDataBaseClipboard;

	bool Add(CString CFileName, int model_index);
	bool AddFile(int model_file_index);

	HTREEITEM GetItemClicked(TV_HITTESTINFO &tvhti);
	int GetFileIndex();
	int GetIndex();

	HTREEITEM GetFileItem(CString CFileName);
	HTREEITEM GetModelItem(CString CFileName, CString CModelName);

	CString GetFileName(void);
	CString GetModelName(void);

	void SelectSymbol(void);

	void Copy(TCDataBaseClipboard &CDataBaseClipboard);
	void Paste(TCDataBaseClipboard &CDataBaseClipboard);
	void EditDelete(void);
	void EditModel(void);

	void AddModelFile(void);
	void Rename(HTREEITEM HItem, CString CName);
	void Rename(void);
	bool Remove(HTREEITEM HItem);
	void Properties(void);
	void EditModelFile(void);
	bool IsDragging(void);
	bool PlaceDragedSymbol(void);
	void ClearDragging(void);
	void FindModel(void);
	void SelectModel(HTREEITEM hitem);


// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCModelTreeView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL


// Implementation
public:
	void UpdateView();
	virtual ~TCModelTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(TCModelTreeView)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LRESULT OnNcHitTest(CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnBeginDragDrop(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);


	//}}AFX_MSG

	afx_msg void OnContextMenu(CWnd*, CPoint point);
	afx_msg void OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult); 
	afx_msg void EditCopy(void);
	afx_msg void EditPaste(void);
public:
	afx_msg void PlaceModel(void);

	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in TabView.cpp
inline TCModelTreeDoc* TCModelTreeView::GetDocument()
   { return (TCModelTreeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TABVIEW_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_)

