// TCNetList.cpp: implementation of the TCNetList class.
//
//////////////////////////////////////////////////////////////////////

#include "float.h"
#include "stdafx.h"
#include "resource.h"
#include "TDVersion.h"
#include "TCMKSConvert.h"
#include "TCStringFunctions.h"
#include "TESuperSpiceOpionsEnums.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicManager.h"
#include "TCAuthorization.h"
#include "TCNetList.h"
#include "TCSuperSpiceDoc.h"

#include "TEPropertyViewTypes.h"
  
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif 

extern TCSuperSpiceDataBase GCSuperSpiceDataBase; 
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern CDC GlobalCDCTemp;
extern TCMultyTaskedString CGlobalStatusMessage;
extern TCAuthorization	GCAuthorization;
extern HDC	HDCMDestCmp;
extern CString GSubCktCurrentStr;
extern CString GSubCktCurrentPinStr;


#pragma warning(disable : 4239) /* C4239 warning expected */


IMPLEMENT_SERIAL(TCPCBComponentData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPCBPinPinListData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPCBNetListInfo, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPCBNetPinList, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPCBFileData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPCBFileArrayData, CObject, ID_VERSION_NUMBER)


///////////////////////////////////////////////////
TCPCBFileData::TCPCBFileData(void)
{

}
TCPCBFileData::TCPCBFileData(TCPCBFileData &CPCBFileData)
{
	*this = CPCBFileData;
}
TCPCBFileData::~TCPCBFileData(void)
{

}

void TCPCBFileData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCPCBFileData::operator = (TCPCBFileData &CPCBFileData)
{
	int count = CPCBFileData.CData.GetSize();
	int p;
	
	CData.SetSize(count);

	for(p = 0; p < count; p++) CData[p] = CPCBFileData.CData[p];
}

//////////////////////////////////////////////

TCPCBFileArrayData::TCPCBFileArrayData(void)
{

}
TCPCBFileArrayData::TCPCBFileArrayData(TCPCBFileArrayData &CPCBFileArrayData)
{
	*this = CPCBFileArrayData;
}
TCPCBFileArrayData::~TCPCBFileArrayData(void)
{

}

void TCPCBFileArrayData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCPCBFileArrayData::operator = (TCPCBFileArrayData &CPCBFileArrayData)
{
	int count = CPCBFileArrayData.ArrayData.GetSize();
	int p;
	
	ArrayData.SetSize(count);

	for(p = 0; p < count; p++) ArrayData[p] = CPCBFileArrayData.ArrayData[p];
}

void TCPCBFileArrayData::Add(int index, TCPCBFileData &CPCBFileData)
{
	int count = ArrayData.GetSize();
	int p;

	if(!(index < count)) return;

	int data_count = CPCBFileData.CData.GetSize();

	if(!(2 < data_count)) return;

	TCPCBFileData &CPCBFileDataRef = ArrayData[index];

	int current_size = CPCBFileDataRef.CData.GetSize();

	CPCBFileDataRef.CData.SetSize(current_size -1, current_size + data_count);// remove last )

	for(p = 2; p < data_count - 1; p++)//ignore ()
	{
		CPCBFileDataRef.CData.Add(CPCBFileData.CData[p]);
	}

	CPCBFileDataRef.CData.Add(")"); //reinsert )
}

void TCPCBFileArrayData::Compact(void)
{
	int count = ArrayData.GetSize();
	int p, q;

	TCPCBFileArrayData CPCBArrayData;
	CString CNodeName, CNodeCheckName;

	CPCBArrayData.ArrayData.SetSize(0, count);

	for(p = 0; p < count; p++)// eliminate doublicate node names and copy its data over
	{
		if(!(2 < ArrayData[p].CData.GetSize())) continue;

		CNodeCheckName = ArrayData[p].CData[1];

		if(CNodeCheckName == "") continue;

		CPCBArrayData.ArrayData.Add(ArrayData[p]);// add the first occurance of node

		ArrayData[p].CData[1] = "";// mark to not use again

		for(q = 0; q < count; q++)
		{
			if(!(2 < ArrayData[q].CData.GetSize())) continue;

			CNodeName = ArrayData[q].CData[1];

			if(CNodeName == "") continue;// already done

			if(CNodeCheckName == CNodeName)
			{
				CPCBArrayData.Add(p, ArrayData[q]);

				ArrayData[q].CData[1] = "";//dont do again
			}
		}
	}

	*this = CPCBArrayData;// copy back over

}

bool TCPCBFileArrayData::Write(CFile &CDestination)
{
	int count = ArrayData.GetSize();
	int line_count;
	CString CLineText;
	int p, q;
	char line_end[3] = "\r\n";
	int length;

	for(p = 0; p < count; p++)
	{
		line_count = ArrayData[p].CData.GetSize();

		for(q = 0; q < line_count; q++)
		{
			CLineText = ArrayData[p].CData[q];

			length = CLineText.GetLength();

			CDestination.Write(CLineText.GetBuffer(length + 1), length);

			CDestination.Write(line_end, 2);
		}
	}
	return true;
}
///////////////////////////////////////////////////
TCPCBNetListInfo::TCPCBNetListInfo(void)
{

}
TCPCBNetListInfo::TCPCBNetListInfo(TCPCBNetListInfo &CPCBNetListInfo)
{
	*this = CPCBNetListInfo;
}
TCPCBNetListInfo::~TCPCBNetListInfo(void)
{

}

void TCPCBNetListInfo::Serialize(CArchive& CArchiveFile)
{
	int count, p;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CNetName;

		count = CPinList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CPinList[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> CNetName;

		CArchiveFile >> count;

		CPinList.SetSize(count); 

		for(p = 0; p < count; p++) CPinList[p].Serialize(CArchiveFile);
	}
}
void TCPCBNetListInfo::operator = (TCPCBNetListInfo &CPCBNetListInfo)
{
	int count, p;

	CNetName = CPCBNetListInfo.CNetName;

	count = CPCBNetListInfo.CPinList.GetSize();

	CPinList.SetSize(count);

	for(p = 0; p < count; p++) CPinList[p] = CPCBNetListInfo.CPinList[p];
}

//////////////////////////////////////////////////
TCPCBPinPinListData::TCPCBPinPinListData(void)
{
	pin = 0;
}
TCPCBPinPinListData::TCPCBPinPinListData(TCPCBPinPinListData &CPCBPinPinListData)
{
	*this = CPCBPinPinListData;
}
TCPCBPinPinListData::~TCPCBPinPinListData(void)
{

}

void TCPCBPinPinListData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CRefDes;
		CArchiveFile << CName;
		CArchiveFile << CNetName;
		CArchiveFile << CPinNumber;
		CArchiveFile << CPinName;
		CArchiveFile << CPackageType;

		CArchiveFile << pin;
	}
	else
	{
		CArchiveFile >> CRefDes;
		CArchiveFile >> CName;
		CArchiveFile >> CNetName;
		CArchiveFile >> CPinNumber;
		CArchiveFile >> CPinName;
		CArchiveFile >> CPackageType;

		CArchiveFile >> pin;
	}
}

void TCPCBPinPinListData::operator = (TCPCBPinPinListData &CPCBPinPinListData)
{
	CRefDes = CPCBPinPinListData.CRefDes;
	pin		= CPCBPinPinListData.pin;
	CName	= CPCBPinPinListData.CName;
	CNetName = CPCBPinPinListData.CNetName;
	CPinNumber  = CPCBPinPinListData.CPinNumber;
	CPinName = CPCBPinPinListData.CPinName ;
	CPackageType = CPCBPinPinListData.CPackageType;
}
///////////////////////////////////////////////////



TCPCBNetPinList::TCPCBNetPinList(void)
{
	pin = 0;
}
TCPCBNetPinList::TCPCBNetPinList(TCPCBNetPinList &CPCBNetPinList)
{
	*this = CPCBNetPinList;
}
TCPCBNetPinList::~TCPCBNetPinList(void)
{

}

void TCPCBNetPinList::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCPCBNetPinList::operator = (TCPCBNetPinList &CPCBNetPinList)
{
	int count;

	pin = CPCBNetPinList.pin;

	count = CPCBNetPinList.CPinList.GetSize();

	CPinList.SetSize(count);

	for(int p = 0; p < count; p++) CPinList[p] = CPCBNetPinList.CPinList[p];
}

//////////////////////////////////////////////////
TCPCBComponentData::TCPCBComponentData(void)
{
	PCSchematicObject = NULL;
}
TCPCBComponentData::TCPCBComponentData(TCPCBComponentData &CPCBComponentData)
{
	*this = CPCBComponentData;
}
TCPCBComponentData::~TCPCBComponentData(void)
{

}

void TCPCBComponentData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count, p;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CTextLine;

		count = CPinList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CPinList[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> CTextLine;

		CArchiveFile >> count;

		CPinList.SetSize(count); 

		for(p = 0; p < count; p++) CPinList[p].Serialize(CArchiveFile);

	}
}
void TCPCBComponentData::operator = (TCPCBComponentData &CPCBComponentData)
{
	int count, p;

	CRefDes			= CPCBComponentData.CRefDes;
	CPackageType	= CPCBComponentData.CPackageType;
	CDeviceName		= CPCBComponentData.CDeviceName;
	CNetName		= CPCBComponentData.CNetName;
	CName			= CPCBComponentData.CName;
	CDeviceValue	= CPCBComponentData.CDeviceValue; 

	PCSchematicObject = PCSchematicObject;

	CTextLine = CPCBComponentData.CTextLine;

	count = CPCBComponentData.CPinList.GetSize();

	CPinList.SetSize(count);

	for(p = 0; p < count; p++) CPinList[p] = CPCBComponentData.CPinList[p];
}

///////////////////////////////////////////////////

TCPCBData::TCPCBData(void)
{

}
TCPCBData::TCPCBData(TCPCBData &CPCBData)
{
	*this = CPCBData;
}
TCPCBData::~TCPCBData(void)
{

}

void TCPCBData::Serialize(TCAchiveRaw& CArchiveFile)
{
	int	count, p;

	if(CArchiveFile.IsStoring())
	{
		count = ComponentList.GetSize();

		for(p = 0; p < count; p++) // to do
		{
			CArchiveFile << ComponentList[p].CTextLine;
		}
	}
	else
	{
		;
	}
}
void TCPCBData::operator = (TCPCBData &CPCBData)
{
	int count, p;

	count = CPCBData.ComponentList.GetSize();

	ComponentList.SetSize(count);

	for(p = 0; p < count; p++) ComponentList[p] = CPCBData.ComponentList[p];
}


bool TCPCBData::Save(CString CFileName)
{
	return SaveGenericToRawArchive(this, CFileName);
}

bool TCPCBData::Load(CString CFileName)
{
	return LoadGenericFromRawArchive(this, CFileName);
}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


TCNetListLine::TCNetListLine(void)
{

}
TCNetListLine::TCNetListLine(TCNetListLine &CNetListLine)
{
	*this = CNetListLine;
}
TCNetListLine::~TCNetListLine(void)
{

}

void TCNetListLine::Serialize(TCAchiveRaw& CArchiveFile)
{
	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CRefDes;
		CArchiveFile << CPins;
		CArchiveFile << CValue;
		CArchiveFile << CLine;
	}
	else
	{
		CArchiveFile >> CRefDes;
		CArchiveFile >> CPins;
		CArchiveFile >> CValue;
		CArchiveFile >> CLine;
	}
}
void TCNetListLine::operator = (TCNetListLine &CNetListLine)
{
	CRefDes	= CNetListLine.CRefDes;
	CPins	= CNetListLine.CPins;
	CValue	= CNetListLine.CValue;
	CLine	= CNetListLine.CLine;
}

////////////////////////////////////////////////////


///////////////////////////////////
TCNetList::TCNetList()
{
	CMSweepTypeList.SetSize(3, 3);

	CMSweepTypeList[0] = "DEC ";
	CMSweepTypeList[1] = "OCT ";
	CMSweepTypeList[2] = "LIN ";

	m_is_ok		= false;
	top_level	= true;
	net_lines_stop_max_index = 0;
	net_lines_start_index = 0;

	PCMDoc = NULL;
}

TCNetList::TCNetList(TCNetList &CNetList)
{
	*this = CNetList;
}
TCNetList::~TCNetList()
{

}

void TCNetList::Serialize(TCAchiveRaw &CArchiveFile)
{
	int		 count;
	CString	 CGetLine;
	TCNetListLine  CNetListLine;
	CString  CEndLine = "\r\n";

	if(CArchiveFile.IsStoring())
	{
		count = CNetListLineList.GetSize();

		for(int p = 0; p < count; p++) 
		{
			CArchiveFile << CNetListLineList[p].CLine;// only save lines not other data
			CArchiveFile << CEndLine;
		}
	}
	else
	{
		if(CArchiveFile.GetLine(&CGetLine))// this aint used yet
		{
			CNetListLineList.SetSize(0, 4096);

			do
			{
				CNetListLine.CLine = CGetLine;

				CNetListLineList.Add(CNetListLine);

			}  while(CArchiveFile.GetLine(&CGetLine));
		}
	}
}

bool TCNetList::Load(void)
{
	return Load(CFileName);
}
bool TCNetList::Save(void)
{
	CString CText, CTemp;

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
	{
		if(CParentRef != "")
		{
			CText += "%" + CParentRef;

			CText.Replace(":", "%");// windows dont like :

			CTemp = RemoveExtention(CFileName);

			CText = CTemp + CText;

			CText += ".cir";
		}
		else CText = CFileName;
	}
	else CText = CFileName;

	return Save(CText);
}

bool TCNetList::Load(CString CLoadFileName)
{
	CFileName  = CLoadFileName;

	return LoadGenericFromRawArchive(this, CLoadFileName);
}
bool TCNetList::Save(CString CSaveFileName)
{
	return SaveGenericToRawArchive(this, CSaveFileName);
}

bool TCNetList::SaveModels(void)
{
	CFile CDataFile;

	if(!CDataFile.Open(CModelFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);

	int count = CMModelLines.GetSize();

	for(int p = 0; p < count; p++)
	{
		CDataFile.Write(CMModelLines[p], CMModelLines[p].GetLength());

		CDataFile.Write(data, char_size);
	}

	CDataFile.Close();

	return true;
}

void TCNetList::operator = (TCNetList &CNetList)
{
	CFileName		= CNetList.CFileName;
	CSchematicName	= CNetList.CSchematicName;
	CModelFileName  = CNetList.CModelFileName;

	int count = CNetList.CNetListLineList.GetSize();

	CNetListLineList.SetSize(count, count);

	for(int p = 0; p < count; p++)
	{
		CNetListLineList[p] = CNetList.CNetListLineList[p];
	}
}

bool TCNetList::FindNode(CString CNodeName)
{
	if(CNodeName == "") return false;

	int count = CMAnalysisSetup.CNodeList.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CString &CText = CMAnalysisSetup.CNodeList.CData[p].CSpiceName;

		if(CText == CNodeName) return true;
	}

	return false;
}

void TCNetList::SetUniqueModel(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup)
{
	TCSchematicManager *PCSchematicManager;
	TCSchematicObject *PCSchematicObject;
	int schematic_count, schematic_object_count;
	CString CText;
	int flag;

	//first, just for MC, then add in individual parameter

	schematic_count = CListOfSchematicManagers.GetSize();

	for(int p = 0; p < schematic_count; p++)
	{
		PCSchematicManager = CListOfSchematicManagers[p];

		CArray<TCSchematicObject*, TCSchematicObject*> &GraphicList = PCSchematicManager->GetGraphicList();

		schematic_object_count = GraphicList.GetSize();

		for(int q = 0; q < schematic_object_count; q++)
		{
			PCSchematicObject = GraphicList[q];

			PCSchematicObject->CMSchematicObjectData.is_unique_model = false;

			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_BIPOLAR ||
				PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_FET ||
				PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_MESFET ||
				PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_MOSFET ||
				PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_GENERIC_SUBCIRCUIT)
			{
				if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_BIPOLAR)
				{
					CText = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabel;
				}
				else if(PCSchematicObject->CMSchematicObjectData.component_property_view_type != E_PROPERTY_GENERIC_SUBCIRCUIT)
				{
					CText = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabel;
				}
				else
				{
					CText = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel;
				}

				CText.TrimLeft();
				CText.TrimRight();

				flag = 1;
				
				if(CText.Find('=') < 0) flag = 0;
				
				if(CText.GetLength() < 3) flag = 0;

				if(CText != "" && flag)
				{
					PCSchematicObject->CMSchematicObjectData.is_unique_model = true;

					continue;
				}

				if(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.unique_parameters)
				{
					PCSchematicObject->CMSchematicObjectData.is_unique_model = true;

					continue;	
				}
			}

			if(PCSchematicObject->CMSchematicObjectData.attached_model_type != E_SPICE_DOT_MODEL)  continue;

			if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) continue;

			PCSchematicObject->CMSchematicObjectData.is_unique_model = true;
		}
	}
}

bool TCNetList::InitaliseAnalysisSetup(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, CString CParentRefDes)
{
	TCSchematicManager *PCSchematicManager;
	TCSchematicObject *PCSchematicObject;
	int schematic_count, schematic_object_count;
	TCSelectParameter CSelectParameter;
	int p, q, type, ref_id;
	CString CText, CText2;
	TCOutput COutput;
	TCSpiceParameters CParameterLocal;
	int property_view;
//	int parameter_setup_counter = 0;

//	CAnalysisSetup.CParametricSetupData.CData.SetSize(0, 256);
	CAnalysisSetup.COutputList.CData.SetSize(0, 256);
	CAnalysisSetup.CDeviceCurrentNodeList.CData.SetSize(0, 256);
	CAnalysisSetup.CSourceList.CData.SetSize(0, 256);
	CAnalysisSetup.CStaticOutputList.CData.SetSize(0, 256);
	CAnalysisSetup.CNodeList.CData.SetSize(0, 256);

//  start of setup parameter
//  Parameter use a dummy model at item 0 to allow enable with no selected component
//  to be sweept for that schematic/subcircuit.
	
	TCSelectParameter CSelectSchematicParameters;

	CParameterLocal.CDataBaseIdInfo.CRecordName		= "VirtualNoParameters_XN";
	CParameterLocal.CDataBaseIdInfo.model_type		= E_SPICE_DOT_MODEL;
	CParameterLocal.CDataBaseIdInfo.CModelType		= "MODEL";
	CParameterLocal.CDataBaseIdInfo.CRecordFileName	= GCSuperSpiceDataBase.CSuperSpiceModelLibName;
	CSelectParameter.CRefDesignator					= "NONE";// shows up in list box

	CSelectParameter.PCParameter = GCSuperSpiceDataBase.GetModelPointer(CParameterLocal);

	int param_count = CAnalysisSetup.CParametricSetupData.CData.GetSize();

//  Get Existing SelectSchematic data, e.g. new sweep values set in Dialog box
	CSelectSchematicParameters = CAnalysisSetup.CSelectParameter;

	if(param_count) // always placed at array end
	{
		if(CAnalysisSetup.CParametricSetupData.CData[param_count - 1].CRefDesignator == GCSuperSpiceGlobalData.CSchParamsName)
		{
			CSelectSchematicParameters = CAnalysisSetup.CParametricSetupData.CData[param_count - 1];

			CSelectSchematicParameters.PCParameter = CAnalysisSetup.CSelectParameter.PCParameter;
		}
	}
////////////////////////

	if(CSelectParameter.PCParameter)
	{
		if(param_count)
		{
			int id = CAnalysisSetup.CParametricSetupData.source_id;

			if(id > -1 && id < param_count)
			{
				CSelectParameter.CSweepData.type = CAnalysisSetup.CParametricSetupData.CData[id].CSweepData.type;
				CSelectParameter.CSweepData.sweep_type = CAnalysisSetup.CParametricSetupData.CData[id].CSweepData.sweep_type;
			}
		}

		CAnalysisSetup.CParametricSetupData.CData.SetAtGrow(0, CSelectParameter);
	}

	if(!(CAnalysisSetup.CParametricSetupData.CData.GetSize() > 1))// copy existing temp data if available.
	{		
		CParameterLocal.CDataBaseIdInfo.CRecordName	= "VirtualTemperature_XN";
		CSelectParameter.CRefDesignator = ".TEMP";

		CSelectParameter.PCParameter = GCSuperSpiceDataBase.GetModelPointer(CParameterLocal);

		if(CSelectParameter.PCParameter) CAnalysisSetup.CParametricSetupData.CData.SetAtGrow(1, CSelectParameter);
	}
	else
	{
		CSelectParameter = CAnalysisSetup.CParametricSetupData.CData[1];

		CParameterLocal.CDataBaseIdInfo.CRecordName	= "VirtualTemperature_XN";
		CSelectParameter.CRefDesignator = ".TEMP";

		CSelectParameter.PCParameter = GCSuperSpiceDataBase.GetModelPointer(CParameterLocal);

		if(CSelectParameter.PCParameter) CAnalysisSetup.CParametricSetupData.CData.SetAtGrow(1, CSelectParameter);
	}
 
// end of setup default setups of selected parameter
	
	if(!SetupComponentList()) return false;

	SetupGlobalAndLocalNetNames();

	COutput.CUserName = "0";
	COutput.CSpiceName = "0";
	COutput.type = E_OUTPUT_VOLTAGE;
	CAnalysisSetup.CNodeList.CData.SetAtGrow(0, COutput);

	schematic_count = CListOfSchematicManagers.GetSize();

	char test_char;

	SetUniqueModel(CListOfSchematicManagers, CAnalysisSetup);

	int r;

	for(p = 0; p < schematic_count; p++)
	{
		PCSchematicManager = CListOfSchematicManagers[p];

		CArray<TCSchematicObject*, TCSchematicObject*> &GraphicList = PCSchematicManager->GetGraphicList();

		schematic_object_count = GraphicList.GetSize();

		for(q = 0; q < schematic_object_count; q++)
		{
			PCSchematicObject = GraphicList[q];

			type = PCSchematicObject->m_type;
			property_view = PCSchematicObject->CMSchematicObjectData.component_property_view_type;

			CText2 = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

			if(CText2 != "")
				test_char = CText2.GetAt(0);
			else test_char = ' ';
			// subcircuits dont have pin currents saved here
			if(test_char != 'X') AddToDeviceCurrentNodeList(CAnalysisSetup, PCSchematicObject);

			CText = CText2;

			if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_GENERATOR)
			{
				COutput.type = E_OUTPUT_VOLTAGE;
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				CAnalysisSetup.CSourceList.CData.Add(COutput);			

				// add to node list as well
				COutput.type = E_OUTPUT_CURRENT;

				CText = CText2;
				CText = "IM(" + CText + ")";
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				int name_count = CAnalysisSetup.COutputList.CData.GetSize();
				int flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.COutputList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.COutputList.CData.Add(COutput);

				CText = CText2;
				CText = "IP(" + CText + ")";
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				name_count = CAnalysisSetup.COutputList.CData.GetSize();
				flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.COutputList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.COutputList.CData.Add(COutput);

				CText = CText2;
				CText = "I(" + CText + ")";
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				name_count = CAnalysisSetup.CStaticOutputList.CData.GetSize();
				flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.CStaticOutputList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.CStaticOutputList.CData.Add(COutput);

				CText = CText2;// needed to reset ref des for paraeter sweep
			}
			else if(property_view >= E_PROPERTY_DC_CURRENT_SOURCE && property_view <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM)
			{
				COutput.type = E_OUTPUT_CURRENT;
				
				COutput.CUserName = CText;

				COutput.CSpiceName = CText;

				CAnalysisSetup.CSourceList.CData.Add(COutput);
			}
			else if(type == E_WIRE_COMPONENT)
			{
				CText = CText2;
				COutput.type = E_OUTPUT_VOLTAGE;
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				int name_count = CAnalysisSetup.CNodeList.CData.GetSize();
				int flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.CNodeList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.CNodeList.CData.Add(COutput);

				// add to node list as well
				CText = "VM(" + CText + ")";
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				name_count = CAnalysisSetup.COutputList.CData.GetSize();
				flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.COutputList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.COutputList.CData.Add(COutput);

				CText = CText2;

				CText = "VP(" + CText + ")";
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				name_count = CAnalysisSetup.COutputList.CData.GetSize();
				flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.COutputList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.COutputList.CData.Add(COutput);
//////////
				CText = CText2;

				CText = "V(" + CText + ")";
				COutput.CUserName = CText;
				COutput.CSpiceName = CText;

				name_count = CAnalysisSetup.CStaticOutputList.CData.GetSize();
				flag = true;

				for(r = 0; r < name_count; r++)
				{
					if(CAnalysisSetup.CStaticOutputList.CData[r].CUserName == CText)
					{
						flag = false;
						break;
					}
				}
				if(flag)CAnalysisSetup.CStaticOutputList.CData.Add(COutput);
			}
			
//			if(type >= E_DC_VOLTAGE_SOURCE)
//			else if(type >= E_RESISTOR_COMPONENT)
			{
				CParameterLocal = PCSchematicObject->CMSchematicObjectData.CSpiceParameters;

				if(property_view >= E_PROPERTY_DC_VOLTAGE_SOURCE && property_view <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM)
				{//added to support external sources
					CParameterLocal.CDataBaseIdInfo.CRecordFileName = GCSuperSpiceDataBase.CSuperSpiceModelLibName;
					PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = CParameterLocal.CDataBaseIdInfo.CRecordFileName;
					// correct bad setup of sources
					PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model = false;
				}

				if(property_view == E_PROPERTY_RESISTOR) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualResistor_XN";
				else if(property_view == E_PROPERTY_CAPACITOR) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualCapacitor_XN";
				else if(property_view == E_PROPERTY_INDUCTOR) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualInductor_XN";
				else if(property_view == E_PROPERTY_DC_VOLTAGE_SOURCE || property_view == E_PROPERTY_DC_CURRENT_SOURCE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualDCSource_XN";
				else if(property_view == E_PROPERTY_SINE_VOLTAGE_SOURCE || property_view == E_PROPERTY_SINE_CURRENT_SOURCE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualSineSource_XN";
				else if(property_view == E_PROPERTY_PULSE_VOLTAGE_SOURCE || property_view == E_PROPERTY_PULSE_CURRENT_SOURCE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualPulseSource_XN";
				else if(property_view == E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE || property_view == E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualEXPSource_XN";
				else if(property_view == E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE || property_view == E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualPWLSource_XN";
				else if(property_view == E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM || property_view == E_PROPERTY_SINGLE_FREQ_CURRENT_FM) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualSFFMSource_XN";				
				else if(property_view == E_PROPERTY_CONTROLED_SOURCE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtualCSource_XN";
				else if(property_view == E_PROPERTY_LOSSLESS_TRANSMISSION_LINE) CParameterLocal.CDataBaseIdInfo.CRecordName = "VirtuaLosslessTLine_XN";

				//model parameters only contain model name not model data
				CSelectParameter.PCParameter = GCSuperSpiceDataBase.GetModelPointer(CParameterLocal);

				if(CSelectParameter.PCParameter)
				{
					if(CSelectParameter.PCParameter->CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL)
					{
						CSelectParameter.CRefDesignator = CText;
						// allows the last selections to be used
						ref_id = FindComponentParameter(CAnalysisSetup, CText);

						if(ref_id < 0)
						{
							CAnalysisSetup.CParametricSetupData.CData.Add(CSelectParameter);
						}
						else 
							CAnalysisSetup.CParametricSetupData.CData[ref_id].PCParameter =

							CSelectParameter.PCParameter;
					}
				}
			}
		}	
	}

	RemoveUnincludedComponentParameter(CListOfSchematicManagers, CAnalysisSetup);

	CAnalysisSetup.RemoveInvalidOutputSelectData();

// Start add in the Schematic parameter list
	param_count = CAnalysisSetup.CParametricSetupData.CData.GetSize();

	if(CAnalysisSetup.CParametricSetupData.CData[param_count - 1].CRefDesignator == GCSuperSpiceGlobalData.CSchParamsName)
	{
		CAnalysisSetup.CParametricSetupData.CData[param_count - 1] = CSelectSchematicParameters;
	}
	else
	{
		CAnalysisSetup.CParametricSetupData.CData.Add(CSelectSchematicParameters);
	}
// End add in the Schematic parameter list

	return true;
}


void TCNetList::AddToDeviceCurrentNodeList(TCAnalysisSetup &CAnalysisSetup, TCSchematicObject *PCSchematicObject)
{
	TCOutput COutput;
	CString CText;
	int spice_parameter_start_index = 0;
	
	int type = GCSuperSpiceDataBase.GetSpiceModelType(&PCSchematicObject->CMSchematicObjectData);
	
	if(type && (type < GCSuperSpiceDataBase.CSpiceNodeParameterStartIndex.GetSize()))
		spice_parameter_start_index = GCSuperSpiceDataBase.CSpiceNodeParameterStartIndex[type];

	CArray <CString, CString> CDeviceNodes;

	PCSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CDeviceNodes);

	int count = CDeviceNodes.GetSize();
 
	for(int p = 0; p < count; p++)
	{
///		Bodge, needs fixng up later to inspect the virtual subcircuit
		if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES  ||
		   CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE)
		{
			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type ==  E_PROPERTY_INDUCTOR) continue;// can't support currents in paramatised inductors as subcircuits, try to fix later
			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type >= E_PROPERTY_DC_VOLTAGE_SOURCE && PCSchematicObject->CMSchematicObjectData.component_property_view_type <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM) continue; 

			if(PCSchematicObject->CMSchematicObjectData.IsWorstCaseGenerator())continue;
		}
///
		//bug fix 17th October, 2001.
		CText = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
		
		CText.TrimLeft();

		if(CText == "" || CText.GetAt(0) == 'i' || CText.GetAt(0) == 'I')continue;

		COutput.CUserName = CDeviceNodes[p];

		if(COutput.CUserName.Find('-') != -1) continue;// for testpoint support which add

		if(type)
		if(p < spice_parameter_start_index || CMAnalysisSetup.CDCSetupData.enable_operating_point)
		{
			CAnalysisSetup.CDeviceCurrentNodeList.CData.Add(COutput);
		}
	}
}

void TCNetList::RemoveUnincludedComponentParameter(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup)
{
	CString CRefDes;
	TCSchematicManager *PCSchematicManager;
	TCSchematicObject *PCSchematicObject;
	int schematic_count, schematic_object_count, count;
	int p, q, r, flag;
	CArray <CString, CString> CRefDesList;

	schematic_count = CListOfSchematicManagers.GetSize();

	count = CAnalysisSetup.CParametricSetupData.CData.GetSize();

	flag = false;

	for(r = 0; r < count; r++)// Scan parametric data and remove
	{
		if(r < 2) continue;//  None selected, and temperture is forced to item 0 and 1 in list

		CRefDes = CAnalysisSetup.CParametricSetupData.CData[r].CRefDesignator;

		for(p = 0; p < schematic_count; p++)
		{
			PCSchematicManager = CListOfSchematicManagers[p];

			CArray<TCSchematicObject*, TCSchematicObject*> &GraphicList = 
			PCSchematicManager->GetGraphicList();

			schematic_object_count = GraphicList.GetSize();

			for(q = 0; q < schematic_object_count; q++)
			{
				PCSchematicObject = GraphicList[q];

				if(PCSchematicObject->m_type)//generic subcircuits = 0
					if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE) continue;

				if(PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR) == CRefDes)
				{
					flag = true;
					break;
				}
			}
			if(flag) break;
		}

		if(!flag) CRefDesList.Add(CRefDes);// Mark all not found components
		flag = false;
	}

	count = CRefDesList.GetSize();
	int ref_id;

	for(p = 0; p < count; p++)
	{
		ref_id = FindComponentParameter(CAnalysisSetup, CRefDesList[p]);

		if(ref_id < 0) continue;

		CAnalysisSetup.CParametricSetupData.CData.RemoveAt(ref_id);
	}
}

int	 TCNetList::FindComponentParameter(TCAnalysisSetup &CAnalysisSetup, CString CRefDes)
{
	int count = CAnalysisSetup.CParametricSetupData.CData.GetSize();

	CString CTestRefDes;

	for(int p = 0; p < count; p++)
	{
		CTestRefDes = CAnalysisSetup.CParametricSetupData.CData[p].CRefDesignator;

		if(CRefDes != CTestRefDes) continue;

		return p;
	}

	return -1;
}

int TCNetList::Create(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, TCSuperSpiceDoc *PCDoc, int format, CString CParentRefDes, CArray <CString, CString>  &CPinList)
{
	TCNetListLine CNetListLine;
	PCMDoc = PCDoc;

	CParentRef = CParentRefDes;

	m_pcb_format = format;

	int p;

	int pin_count =  CPinList.GetSize();

	CSubCircuitPinList.SetSize(pin_count);// toplevel pin wire names

	for(p = 0; p < pin_count; p++)CSubCircuitPinList[p] = CPinList[p];

	int count = CListOfSchematicManagers.GetSize();

	if(GCAuthorization.m_build_type == E_DEMO_RELEASE || GCAuthorization.m_build_type == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type == E_RESTRICTED_RELEASE_STUDENT ||
		GCAuthorization.m_build_type == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT)// Max num pages
		if(count >= E_MAX_NUM_NET_PAGES) count = E_MAX_NUM_NET_PAGES;

	CMSchematicManagerList.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CMSchematicManagerList[p] = CListOfSchematicManagers[p];
	}

	CMAnalysisSetup = CAnalysisSetup;

	CFileName		= CAnalysisSetup.CFileName;
	CSchematicName	= CAnalysisSetup.CSchematicName;
	
	if(CAnalysisSetup.CIncludeNameList.GetSize() > 1)
		CModelFileName = CAnalysisSetup.CIncludeNameList[1];
	else CModelFileName = "";

	CNetListLineList.SetSize(1, 4096);

	if(!InitaliseAnalysisSetup(CMSchematicManagerList, CMAnalysisSetup, CParentRef)) return false;

	if(PCDoc)
	{
		PCDoc->GetSchematicTestPoints(PCDoc->GetTopLevelDoc()->CMTestPointDataList);
	}

	CreateHeader(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist);
		
	CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_START_NETLIST); 

	CNetListLineList.Add(CNetListLine);

	if(!CreateNetLines())	
	{
		RestoreToSubcktNets();

		return false;
	}

	CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_END_NETLIST); 

	CNetListLineList.Add(CNetListLine);

	if(!CreateModelLines(0))	
	{
		RestoreToSubcktNets();

		return false;
	}

	if(top_level)
	{
		CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_START_SPICE_LIBARY);

		CNetListLineList.Add(CNetListLine);

		CreateLibaryLines();

		CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_END_SPICE_LIBARY);

		CNetListLineList.Add(CNetListLine);

		CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_START_SPICE_INCLUDE); 

		CNetListLineList.Add(CNetListLine);
	}
	
	if(top_level)
	{	
		CreateIncludeLines();

		CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_START_END_INCLUDE);

		CNetListLineList.Add(CNetListLine);

		CreateSaveLines();// added before final end

		CNetListLine.CLine.LoadString(IDS_NETLIST_MSG_END_SPICE_DECK);

		CNetListLineList.Add(CNetListLine);

		CreateControlLines();
	}
	else
	{
		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			CNetListLine.CLine = "*.ENDS";
		else CNetListLine.CLine = ".ENDS";

		CNetListLineList.Add(CNetListLine);

		CreateIncludeLines();

		CreateSaveLines();//added after subckt end, append higer level names to nets 
	}

	m_is_ok = true;

	if(format) 
	{
		CreatePCBData(format);
	}

	RestoreToSubcktNets();

	if(!format && top_level) if(!SimulationSetupCheck()) return false;

	if(!SimulationElectricalCheck()) return false;

	return true;
}

bool TCNetList::CreateSubcktModel(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, TCSuperSpiceDoc *PCDoc, CArray <CString, CString> &CPinList)
{
	TCNetListLine CNetListLine;
	PCMDoc = PCDoc;

	int pin_count =  CPinList.GetSize();

	CSubCircuitPinList.SetSize(pin_count);//  pin wire names

	int p;

	for(p = 0; p < pin_count; p++)CSubCircuitPinList[p] = CPinList[p];

	int count = CListOfSchematicManagers.GetSize();

	CMSchematicManagerList.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CMSchematicManagerList[p] = CListOfSchematicManagers[p];
	}

	CMAnalysisSetup = CAnalysisSetup;

	CMAnalysisSetup.CReRun.enable = false;
	CMAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
	CMAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;

	CFileName		= CAnalysisSetup.CFileName;
	CSchematicName	= CAnalysisSetup.CSchematicName;

	CNetListLineList.SetSize(1, 4096);

	if(!InitaliseAnalysisSetup(CMSchematicManagerList, CMAnalysisSetup, "")) return false;

	CNetListLineList[0].CLine = CreateSubcircuitConnectionsLine(false);

	if(CNetListLineList[0].CLine == "")
	{
		RestoreToSubcktNets();

		return false;
	}

	CNetListLine.CLine = "*";

	CNetListLineList.Add(CNetListLine);

	if(!CreateNetLines())	
	{
		RestoreToSubcktNets();

		return false;
	}

	CNetListLine.CLine = "*";// filler between .subcks.

	CNetListLineList.Add(CNetListLine);

	if(!CreateSubCktModelLines())	
	{
		RestoreToSubcktNets();

		return false;
	}

	CNetListLine.CLine = ".ENDS";

	CNetListLineList.Add(CNetListLine);

	RestoreToSubcktNets();

	if(!Save()) return false;

	return true;
}

bool TCNetList::CreateSubCktModelLines(void)
{

	TCNetListLine		CNetListLine;
	TCSchematicObject	*PCSchematicObject;
	TCSchematicObject	*PCSchematicObjectNew;
	CString CTempText;
	CString CError;

	int count = CMAllSchematicComponentsList.GetSize();
	int p, q;

	SetSchematicTags(true);

	CString CNewRecordName;
	CString CRecordName;

	for(p = 0; p < count; p++)// dont include the same model data more then once
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		CNewRecordName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;

		if(!PCSchematicObject->user_tag) continue;// allready checked

		for(q = 0; q < count; q++)// include model unless already included
		{
			PCSchematicObjectNew = CMAllSchematicComponentsList[q];

			if(PCSchematicObject == PCSchematicObjectNew) continue;
	 
			CRecordName = PCSchematicObjectNew->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;
				
			if(CRecordName != CNewRecordName) continue;

			PCSchematicObjectNew->user_tag = false;
		}
	}

	bool flag = true;

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		CRecordName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;

		if(!PCSchematicObject->user_tag) continue;

		// symbols with file names have circuits and are included as a full netlist file
//		if(PCSchematicObject->CMSchematicObjectData.CSymbolData.CFileName == "") continue;

		if(PCSchematicObject->CMSchematicObjectData.attached_model_type != E_SPICE_SCHEMATIC)
		if(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model)
		{
			if(!AddSubCktModelModelLine(PCSchematicObject))
			{
				flag = false;

				CString CMsg;

				CMsg.LoadString(IDS_UNABLE_TO_FIND_MODEL);

				CError.Format(": %s for device %s", PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName, PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel);

				CError = CMsg + CError;

				if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_WARNING, CError);
			}
		}
	}

	return true;
}

bool TCNetList::AddSubCktModelModelLine(TCSchematicObject *PCSchematicObject)
{
	TCNetListLine CNetListLine;

	CArray <CString, CString&> CTextArray;
	int p, count;

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(PCSchematicObject->CMSchematicObjectData.CSpiceParameters);

	if(!PCSpiceParameters) return false;

	PCSpiceParameters->GetToText(CTextArray, true);

	count = CTextArray.GetSize();

	if(!count) return false;

	CString CSymbolNameTest, CPinLine;

	CPinLine = CTextArray[0];

	CString CVTest = "V" + GSubCktCurrentStr;//users uppercase V
	CString OrigName, CTempCheck;

	int index = CNetListLineList.GetSize();// get position 

	for(p = 0; p < count; p++)
	{
		CNetListLine.CLine = CTextArray[p];

		CSymbolNameTest = CNetListLine.CLine;

		CTempCheck = CSymbolNameTest;

		CTempCheck.MakeLower();

		if(CTempCheck.Find("_ss_symbol") > -1) continue;//  dont inclue symbol names

		//find and replace current sense voltage sources

		if(CSymbolNameTest.Find(CVTest) > -1)
		{
			CSymbolNameTest = RemoveFirstWord(CSymbolNameTest);//start of org name

			OrigName = GetFirstWord(CSymbolNameTest);

			CSymbolNameTest = RemoveFirstWord(CSymbolNameTest);// start of new name

			CSymbolNameTest = GetFirstWord(CSymbolNameTest);

			CPinLine.Replace(OrigName, CSymbolNameTest);

			continue;
		}

		CNetListLineList.Add(CNetListLine);
	}

	CNetListLine.CLine = "*";// filler between .subcks.

	CNetListLineList.Add(CNetListLine);

	CNetListLine.CLine = CPinLine;

	CNetListLineList.SetAtGrow(index, CNetListLine);

	return true;
}

bool TCNetList::CreatePCBData(int format)
{
	format;

	CString CText, CNetName, CRefDes, CFlattenedRefDes;
	
	int p, q, r, s, count, pin_count, unique_count, net_count;
	bool flag;
	TCSchematicObject *PCSchematicObject, *PCSchematicObjectNew;
	TCPCBPinPinListData CPCBPinPinListData;

	CArray <TCSchematicObject*, TCSchematicObject*> PCUniqueNetsList;

	count = CMAllNetsList.GetSize();

	PCUniqueNetsList.SetSize(0, count);

	for(p = 0; p < count; p++)// generate unique list of all net names
	{
		PCSchematicObject = CMAllNetsList[p];

		CText = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

		unique_count = PCUniqueNetsList.GetSize();
		flag = false;

		for(q = 0; q < unique_count; q++)
		{
			PCSchematicObjectNew = PCUniqueNetsList[q];

			if(PCSchematicObject == PCSchematicObjectNew) continue;

			CNetName = PCSchematicObjectNew->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
		
			if(CNetName == CText) 
			{
				flag = true;

				break;
			}
		}

		if(!flag) PCUniqueNetsList.Add(PCSchematicObject);
	}

	unique_count = PCUniqueNetsList.GetSize();

	int component_count = CMAllSchematicComponentsList.GetSize();

	CPCBNetsListInfo.SetSize(0);
	CPCBNetsListInfo.SetSize(unique_count);

	double pin_number;

	for(p = 0; p < unique_count; p++)// find what the nets are connected to each component pin
	{
		PCSchematicObject = PCUniqueNetsList[p];

		CText = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
 
		TCPCBNetListInfo &CPCBNetsInfo = CPCBNetsListInfo[p];

		CPCBNetsInfo.CPinList.SetSize(0, 8);

		CPCBNetsInfo.CNetName = CText;

		for(q = 0; q < component_count; q++)// check all components for same name on pins
		{
			PCSchematicObjectNew = CMAllSchematicComponentsList[q];

			pin_count = PCSchematicObjectNew->GetNumberOfPins();

			CRefDes = PCSchematicObjectNew->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			if(!PCSchematicObjectNew->CMSchematicObjectData.CReserved.CIntArray[0]) continue;// do not include in netlist

			for(r = 0; r < pin_count; r++)
			{
				CNetName = PCSchematicObjectNew->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

				pin_number = MKSStringToFloat(PCSchematicObjectNew->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel);

				if(CNetName == CText)
				{
				//	if(CNetName == "0") CNetName = "GND";

					CPCBPinPinListData.CNetName = CNetName;
					CPCBPinPinListData.pin		= (int)pin_number;
					CPCBPinPinListData.CRefDes	= CRefDes;
					CPCBPinPinListData.CName	= PCSchematicObjectNew->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
					CPCBPinPinListData.CPinNumber = PCSchematicObjectNew->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;
					CPCBPinPinListData.CPinName = PCSchematicObjectNew->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
					CPCBPinPinListData.CPackageType = PCSchematicObjectNew->CMSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
					
					CPCBNetsInfo.CPinList.Add(CPCBPinPinListData);
				}
			}
		}
	} 

	CString CLine;
	int  net_pin_count;

	CPCBData.ComponentList.SetSize(0);// clear last stuff

	CPCBData.ComponentList.SetSize(component_count, component_count + 16);// for last header

	TCPCBNetPinList CPCBNetPinList;
	net_count = CPCBNetsListInfo.GetSize();

	// find out what component pin is connected to what other component pin
	for(p = 0; p < component_count; p++)// main component list
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[p];

		PCSchematicObjectNew = CMAllSchematicComponentsList[p];

		TCSchematicObjectData &CSchematicObjectData = PCSchematicObjectNew->CMSchematicObjectData;
 
		if(!CSchematicObjectData.CReserved.CIntArray[0]) continue;// do not include in netlist

		CPCBComponentData.CRefDes = CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
		CPCBComponentData.CPackageType = CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
		CPCBComponentData.PCSchematicObject = PCSchematicObjectNew;

		CPCBComponentData.CDeviceValue = CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;

		CPCBComponentData.CDeviceName = CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME];

		CRefDes = CPCBComponentData.CRefDes;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		pin_count = PCSchematicObjectNew->GetNumberOfPins();

		CPCBComponentData.CPinList.SetSize(0, 32);

		for(q =0; q < pin_count; q++)
		{
			flag = false;

			CNetName = PCSchematicObjectNew->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

			for(r = 0; r < net_count; r++)// scan all pins
			{
				TCPCBNetListInfo CPCBNetsInfo = CPCBNetsListInfo[r];// list of nets for each component p

				if(CPCBNetsInfo.CNetName != CNetName) continue;

				net_pin_count = CPCBNetsInfo.CPinList.GetSize();

				CPCBNetPinList.CPinList.SetSize(0, net_pin_count);

				for(s = 0; s < net_pin_count; s++)//scan all net pins
				{
					TCPCBPinPinListData CPCBNetPinInfo = CPCBNetsInfo.CPinList[s];

					if(q == CPCBNetPinInfo.pin && CRefDes == CPCBNetPinInfo.CRefDes) continue;// dont add own pins to itself

					flag = true;

					if(CNetName == "0")
					{
						CPCBNetPinInfo.pin		= 0;
						CPCBNetPinInfo.CRefDes	= "GND";
						CPCBNetPinInfo.CName	= "GND";
					}

					CPCBNetPinList.CPinList.Add(CPCBNetPinInfo);
				}
			}
				
			if(flag) CPCBComponentData.CPinList.Add(CPCBNetPinList);
		}
	}

	switch(format)
	{
		case E_PCB_FORMATS_NULL: break;
		case E_PCB_FORMATS_GENERIC: CreatePCBGenericData();break;
		case E_PCB_FORMATS_ORCAD:CreatePCBOrcadIIData(); break;
		case E_PCB_FORMATS_PADS: CreatePCBPadsData();break;
		case E_PCB_FORMATS_EAGLE: CreatePCBPEagleData();break;
		case E_PCB_FORMATS_PROTEL:CreatePCBProtelData();break;
		case E_PCB_FORMATS_TANGO:CreatePCBPTangoData();break;
		case E_PCB_FORMATS_EDIF:CreatePCBPEdifData();break;
		case E_PCB_FORMATS_PCAD:CreatePCBPCadData();break;
		case E_PCB_FORMATS_PCLOGIC: CreatePCBLogicData();break;
		case E_PCB_FORMATS_SUBCKT: CreateModelSubData();break;

	}

/// Generate PCB formats here


	CText = RemoveExtention(CFileName);
 
	CText += ".net";
	
	if(!CPCBData.Save(CText)) return false;

	CString CNetFileName =  GetInitDirectory();

	CNetFileName += "SuperSpice.net";// create a temperory file to be appended to

	if(top_level)
	{
		DeleteFile(CNetFileName);// get rid of old one, if any

		CopyFile(CText, CNetFileName, 0);
		
	}
	else
	{
		AppendFile(CNetFileName, CText);// M.S. fucked up not incluing this one.
	}

	return true;
}

bool TCNetList::ReFormatPCBNetlist(CString CFileName)
{
	if(!top_level) return false;

	CString CNetFileName =  GetInitDirectory();

	CNetFileName += "SuperSpice.net";// Copy over the temperory file to the top level netlist

	// processing to do

	ifstream CSourceFile;
	CFile CDestination;

	CSourceFile.open(CNetFileName, ios::in | ios::out);
		
	if(CSourceFile.fail()) return false;

	if(!CDestination.Open(CFileName,  CFile::modeWrite | CFile::shareDenyNone)) return false;

	char *p_line = new char[2048];

	if(!p_line) return false;

	CString CLineText;

	char line_end[3] = "\r\n";


	switch(m_pcb_format)
	{
		case E_PCB_FORMATS_NULL: break;
		case E_PCB_FORMATS_GENERIC: break;
		case E_PCB_FORMATS_EDIF:break;
		case E_PCB_FORMATS_PCAD:break;
		case E_PCB_FORMATS_PADS: break;

		case E_PCB_FORMATS_ORCAD:
			{
				CSourceFile.getline(p_line, 2043);

				while(!CSourceFile.eof())
				{
					CLineText = p_line;

					CDestination.Write(p_line, CLineText.GetLength());

					CDestination.Write(line_end, 2);

					CSourceFile.getline(p_line, 2043);
				}

				// now add the final closing braket
				CDestination.Write(")\r\n", 3);

			}break;

		case E_PCB_FORMATS_PROTEL:
		case E_PCB_FORMATS_TANGO:
		case E_PCB_FORMATS_PCLOGIC:
			{
				CSourceFile.getline(p_line, 2043);

				while(!CSourceFile.eof())
				{
					while(*p_line != '(' && !CSourceFile.eof())
					{					
						CLineText = p_line;

						CDestination.Write(p_line, CLineText.GetLength());

						CDestination.Write(line_end, 2);

						CSourceFile.getline(p_line, 2043);
					}

					while(*p_line != '[' && !CSourceFile.eof()) 
						CSourceFile.getline(p_line, 2043);//wait till next valid stuff present
				}

				CSourceFile.seekg(0, ios::beg);

				CSourceFile.clear();

				CSourceFile.getline(p_line, 2043);

				TCPCBFileArrayData	CPCBFileArrayData;
				TCPCBFileData		CPCBFileData;

				CPCBFileArrayData.ArrayData.SetSize(0, 32);
				CPCBFileData.CData.SetSize(0, 32);

				while(!CSourceFile.eof())
				{
					while(*p_line != '(' && !CSourceFile.eof()) 
						CSourceFile.getline(p_line, 2043);//wait till next valid stuff present

					while(*p_line != '[' && !CSourceFile.eof())
					{					
						CLineText = p_line;

						if(*p_line != ')')
						{
							CPCBFileData.CData.Add(CLineText);
						}
						else
						{
							CPCBFileData.CData.Add(CLineText);

							CPCBFileArrayData.ArrayData.Add(CPCBFileData);

							CPCBFileData.CData.SetSize(0, 32);
						}

						CSourceFile.getline(p_line, 2043);
					}
				}

				CPCBFileArrayData.Compact();

				CPCBFileArrayData.Write(CDestination);

			}break;

		case E_PCB_FORMATS_EAGLE: 
			{
				// don't need to do anything here


			}break;
	}

	delete [] p_line;

	DeleteFile(CNetFileName);// get rid of old file

	return true;
}

bool TCNetList::CreatePCBGenericData(void)
{
	int p, q, r, pin, pin_count, net_pin_count;

	CString CText, CLine;
	CString	CEndLine = "\r\n";
	CString CRefDes;
	CString CPinRefDes;

	int test = sizeof(TCReserved);

	test = sizeof(CString);

	int component_count = CPCBData.ComponentList.GetSize();

	if(!component_count) return false;

	for(p = 0; p < component_count; p++)// testing PCB netlist format
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[p];

		CRefDes = CPCBComponentData.CRefDes;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		CPCBComponentData.CTextLine = CRefDes  + "\t";

		CPCBComponentData.CTextLine += CPCBComponentData.CDeviceName + "\t";

//		CPCBComponentData.CTextLine = "";

		pin_count = CPCBComponentData.CPinList.GetSize();
		
		for(q = 0; q < pin_count; q++)
		{
			TCPCBNetPinList &ComponentCPinList = CPCBComponentData.CPinList[q];

			net_pin_count = ComponentCPinList.CPinList.GetSize();

			for(r = 0; r < net_pin_count; r++)// scan all nets
			{
				CText = ComponentCPinList.CPinList[r].CRefDes;

				pin = ComponentCPinList.CPinList[r].pin;

				if(CText != "GND")
				if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
				{		
					if(CParentRef != "")

					CText = CText + ":" + CParentRef;
				}

				if(CText != "GND")
					CLine.Format("%s %d, %s %d", CRefDes, q + 1, CText, pin + 1); 
				else
					CLine.Format("%s %d, %s", CRefDes, q + 1, CText); 

				CPCBComponentData.CTextLine += CLine + "\t";

			}
		}
			
		CPCBComponentData.CTextLine += CEndLine;
	}

	return true;
}

bool TCNetList::CreatePCBOrcadIIData(void)
{
	int p, q, pin_count;

	CString CText, CName, CPinName, CLine, CNetName;
	CString	CEndLine = "\r\n";
	CString CRefDes;
	CString CPinRefDes;

	CString CPackageName;

	if(!CPCBData.ComponentList.GetSize()) return false;

	TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[0];

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist || top_level)
		CPCBComponentData.CTextLine = "( {OrCAD PCB II Netlist Format}" + CEndLine;

	int component_count = CPCBData.ComponentList.GetSize();

	bool flag = false;
	int pin_number;

	for(p = 0; p < component_count; p++)// testing PCB netlist format
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[p];

		if(!CPCBComponentData.PCSchematicObject) continue;

		if(CPCBComponentData.PCSchematicObject)
		{
			CPackageName = CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
		}

		CText.Format("%08d ", p +1);

		if(!flag)
		{
			flag = true;

			CPCBComponentData.CTextLine += " ( " + CText + " " + CPackageName + " " ;
		}
		
		else
		{
			CPCBComponentData.CTextLine = " ( " + CText + CPackageName + " " ;
		}

		CRefDes = CPCBComponentData.CRefDes;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		CPCBComponentData.CTextLine += CRefDes + " ";

		if(CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model)
			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceName + CEndLine;
		else
			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceValue + CEndLine;

		pin_count = CPCBComponentData.CPinList.GetSize();
		
		for(q = 0; q < pin_count; q++)// testing
		{
			CPCBComponentData.CTextLine += "  (";

			CPCBComponentData.CTextLine += " ";

			pin_number = (int) MKSStringToFloat(CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel);

			CText.Format("%d", pin_number);

			CPCBComponentData.CTextLine += CText + " ";

			if(CPCBComponentData.PCSchematicObject)
				CNetName = CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

			CPCBComponentData.CTextLine += CNetName + " )";

			CPCBComponentData.CTextLine += CEndLine;
		}

		CPCBComponentData.CTextLine += " )";

		CPCBComponentData.CTextLine += CEndLine;
	}

	TCPCBComponentData CPCBComponentDataNew;

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
	{
		CPCBComponentDataNew.CTextLine += ")" + CEndLine;

		CPCBData.ComponentList.Add(CPCBComponentDataNew);
	}


	return true;	
}

bool TCNetList::CreatePCBProtelData(void)
{
	int p, q;

	CString CText, CName, CPinName, CLine, CNetName;
	CString	CEndLine = "\r\n";

	CString CPackageName;
	CString CRefDes;
	CString CPinRefDes;

	int component_count = CPCBData.ComponentList.GetSize();

	for(p = 0; p < component_count; p++)// List components first
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[p];

		if(!CPCBComponentData.PCSchematicObject) continue;

		CPackageName = CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
		
		CPCBComponentData.CTextLine = "[" + CEndLine;

		CRefDes = CPCBComponentData.CRefDes;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		CPCBComponentData.CTextLine += CRefDes + CEndLine;

		CPCBComponentData.CTextLine += CPackageName + CEndLine;

		if(CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model)
			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceName + CEndLine;
		else 
			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceValue + CEndLine;


		CPCBComponentData.CTextLine += CEndLine + CEndLine;// insert two blank lines for now

		CPCBComponentData.CTextLine += "]" + CEndLine;
	}

	int net_count = CPCBNetsListInfo.GetSize();
	int net_pin_count = 0;

	if(!component_count) return false;

	CPCBData.ComponentList.SetSize(component_count + net_count + 1);// bit of spare

	for(p = 0; p < net_count; p++)// Now list the all components on each net
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[component_count + p];

		CPCBComponentData.CTextLine = "(" + CEndLine;

		TCPCBNetListInfo &CPCBNetsInfo = CPCBNetsListInfo[p];

		CPCBComponentData.CTextLine += CPCBNetsInfo.CNetName + CEndLine;

		net_pin_count = CPCBNetsInfo.CPinList.GetSize();

		for(q = 0; q < net_pin_count; q++)//scan all net pins
		{
			TCPCBPinPinListData &CPCBNetPinInfo = CPCBNetsInfo.CPinList[q];

			CRefDes = CPCBNetPinInfo.CRefDes;

			if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			{
				if(CParentRef != "")
					CRefDes = CRefDes + ":" + CParentRef;
			}

			CPCBComponentData.CTextLine += CRefDes + "-" + CPCBNetPinInfo.CPinNumber + CEndLine;
		}

		CPCBComponentData.CTextLine += ")" + CEndLine;
	}

	return true;
}

bool TCNetList::CreatePCBLogicData(void)
{
	int p, q;

	CString CText, CName, CPinName, CLine, CNetName;
	CString	CEndLine = "\r\n";

	CString CPackageName;
	CString CRefDes;
	CString CPinRefDes;

	int component_count = CPCBData.ComponentList.GetSize();

	for(p = 0; p < component_count; p++)// List components first
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[p];

		if(!CPCBComponentData.PCSchematicObject) continue;

		CPackageName = CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
		
		CPCBComponentData.CTextLine = "[" + CEndLine;

		CRefDes = CPCBComponentData.CRefDes;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		CPCBComponentData.CTextLine += CRefDes + CEndLine;

		CPCBComponentData.CTextLine += CPackageName + CEndLine;

		CPCBComponentData.CTextLine += CPCBComponentData.CDeviceName + CEndLine;

		if(!CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model)

			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceValue + CEndLine; 

		else CPCBComponentData.CTextLine += CEndLine; 

		CPCBComponentData.CTextLine += CEndLine;// insert blank line

		CPCBComponentData.CTextLine += "]" + CEndLine;
	}

	int net_count = CPCBNetsListInfo.GetSize();
	int net_pin_count = 0;

	if(!component_count) return false;

	CPCBData.ComponentList.SetSize(component_count + net_count + 1);// bit of spare

	for(p = 0; p < net_count; p++)// Now list the all components on each net
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[component_count + p];

		CPCBComponentData.CTextLine = "(" + CEndLine;

		TCPCBNetListInfo &CPCBNetsInfo = CPCBNetsListInfo[p];

		CPCBComponentData.CTextLine += CPCBNetsInfo.CNetName + CEndLine;

		net_pin_count = CPCBNetsInfo.CPinList.GetSize();

		for(q = 0; q < net_pin_count; q++)//scan all net pins
		{
			TCPCBPinPinListData &CPCBNetPinInfo = CPCBNetsInfo.CPinList[q];

			CRefDes = CPCBNetPinInfo.CRefDes;

			if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			{
				if(CParentRef != "")
					CRefDes = CRefDes + ":" + CParentRef;
			}

			CPCBComponentData.CTextLine += CRefDes + "-" + CPCBNetPinInfo.CPinNumber + CEndLine;
		}

		CPCBComponentData.CTextLine += ")" + CEndLine;
	}

	return true;
}

bool TCNetList::CreatePCBPadsData(void)
{

	return true;
}
bool TCNetList::CreatePCBPCadData(void)
{

	return true;
}


bool TCNetList::CreatePCBPEagleData(void)
{
	CString CText, CName, CPinName, CLine, CNetName;
	CString	CEndLine = "\r\n";
	CString CRefDes;
	CString CPinRefDes;

	int net_count = CPCBNetsListInfo.GetSize();
	int net_pin_count = 0;
	int p, q;

	int component_count = CPCBData.ComponentList.GetSize();

	if(!component_count) return false;

	CText = RemoveExtention(CFileName);

	CText += ".net";

	CPCBData.ComponentList.SetSize(component_count + net_count + 2);// bit of spare

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist || top_level)
	{
		CPCBData.ComponentList[component_count].CTextLine = "EAGLE Version 3.55" + CEndLine + CEndLine;

		CPCBData.ComponentList[component_count].CTextLine += "Netlist " + CText + CEndLine + CEndLine;

		CPCBData.ComponentList[component_count].CTextLine += "Net\tPart\tPad\tPin\tSheet " + CEndLine + CEndLine;
	}

	for(p = 0; p < net_count; p++)
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[component_count + p + 1];

		TCPCBNetListInfo &CPCBNetsInfo = CPCBNetsListInfo[p];

		CPCBComponentData.CTextLine = CPCBNetsInfo.CNetName + "\t";

		net_pin_count = CPCBNetsInfo.CPinList.GetSize();

		for(q = 0; q < net_pin_count; q++)//scan all net pins
		{
			TCPCBPinPinListData &CPCBNetPinInfo = CPCBNetsInfo.CPinList[q];

			CRefDes = CPCBNetPinInfo.CRefDes;

			if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			{
				if(CParentRef != "")
					CRefDes = CRefDes + ":" + CParentRef;
			}

			CPCBComponentData.CTextLine += CRefDes + "\t";
//			CPCBComponentData.CTextLine += CPCBNetPinInfo.CPackageType + "\t";
			CPCBComponentData.CTextLine += CPCBNetPinInfo.CPinNumber + "\t";

			CPCBComponentData.CTextLine += CPCBNetPinInfo.CPinName + "\t";
			CPCBComponentData.CTextLine += "1" ;
			CPCBComponentData.CTextLine += CEndLine + "\t";
		}

		CPCBComponentData.CTextLine += CEndLine + CEndLine;
	}

	return true;
}

bool TCNetList::CreatePCBPTangoData(void)
{
	int p, q;// this is the same as protel except fpr X1-1 -> X1,1

	CString CText, CName, CPinName, CLine, CNetName;
	CString	CEndLine = "\r\n";

	CString CPackageName;
	CString CRefDes;
	CString CPinRefDes;

	int component_count = CPCBData.ComponentList.GetSize();

	for(p = 0; p < component_count; p++)// List components first
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[p];

		if(!CPCBComponentData.PCSchematicObject) continue;

		CPackageName = CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
		
		CPCBComponentData.CTextLine = "[" + CEndLine;

		CRefDes = CPCBComponentData.CRefDes;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		CPCBComponentData.CTextLine += CRefDes + CEndLine;

		CPCBComponentData.CTextLine += CPackageName + CEndLine;

		if(CPCBComponentData.PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model)
			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceName + CEndLine;
		else 
			CPCBComponentData.CTextLine += CPCBComponentData.CDeviceValue + CEndLine;


		CPCBComponentData.CTextLine += CEndLine + CEndLine;// insert two blank lines for now

		CPCBComponentData.CTextLine += "]" + CEndLine;
	}

	int net_count = CPCBNetsListInfo.GetSize();
	int net_pin_count = 0;

	if(!component_count) return false;

	CPCBData.ComponentList.SetSize(component_count + net_count + 1);// bit of spare

	for(p = 0; p < net_count; p++)// Now list the all components on each net
	{
		TCPCBComponentData &CPCBComponentData = CPCBData.ComponentList[component_count + p];

		CPCBComponentData.CTextLine = "(" + CEndLine;

		TCPCBNetListInfo &CPCBNetsInfo = CPCBNetsListInfo[p];

		CPCBComponentData.CTextLine += CPCBNetsInfo.CNetName + CEndLine;

		net_pin_count = CPCBNetsInfo.CPinList.GetSize();

		for(q = 0; q < net_pin_count; q++)//scan all net pins
		{
			TCPCBPinPinListData &CPCBNetPinInfo = CPCBNetsInfo.CPinList[q];

			CRefDes = CPCBNetPinInfo.CRefDes;

			if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			{
				if(CParentRef != "")
					CRefDes = CRefDes + ":" + CParentRef;
			}

			CPCBComponentData.CTextLine += CRefDes + "," + CPCBNetPinInfo.CPinNumber + CEndLine;
		}

		CPCBComponentData.CTextLine += ")" + CEndLine;
	}

	return true;
}

bool TCNetList::CreatePCBPEdifData(void)
{

	return true;
}

bool TCNetList::CreateModelSubData(void)
{

	return true;
}

void TCNetList::CreateHeader(int flat_netist)
{
	time_t			s_current_time;
	CString			CTimeText;
	CString			CComment = "***";
	TCNetListLine	CNetListLine;

	time(&s_current_time);

	CTime CCurrentTime(s_current_time);

	if(top_level)
		CNetListLineList[0].CLine = CSchematicName + "\r\n";
	else
	{
		CNetListLineList[0].CLine = CreateSubcircuitConnectionsLine(flat_netist);

		CNetListLine.CLine = CComment + " " + CSchematicName + "\r\n";

		CNetListLineList.Add(CNetListLine);
	}
	CTimeText = CCurrentTime.Format("Time  %H:%M:%S, %A, %B %d, %Y");

	CNetListLine.CLine = CComment + " " + CTimeText + " " + CComment;

	CNetListLineList.Add(CNetListLine);

	CNetListLine.CLine = "\r\n";
	CNetListLineList.Add(CNetListLine);

	if(top_level && CMAnalysisSetup.CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT])
	{
		CString CText;

		TCSpiceOptionsData *PCSpiceOptionsData = &CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_DESIGNER_VOLTAGE_ACCURACY];

		if(PCSpiceOptionsData->m_include)
		{
			CText.Format("%e", PCSpiceOptionsData->value);

			CNetListLine.CLine = "*$#ssdesv=" + CText;

			CNetListLineList.Add(CNetListLine);
		}

		PCSpiceOptionsData = &CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_DESIGNER_CURRENT_ACCURACY];

		if(PCSpiceOptionsData->m_include)
		{
			CText.Format("%e", PCSpiceOptionsData->value);

			CNetListLine.CLine = "*$#ssdesi=" + CText;

			CNetListLineList.Add(CNetListLine);
		}
	}
}

CString TCNetList::CreateSubcircuitConnectionsLine(int flat_netlist)
{
	int p, count, pin_id;

	CArray <CString, CString> CPinNames;

	TCSchematicObject *PCSchematicObject; 

	CString CTemp = ExtractFileName(CFileName);

	CString CText;

	if(flat_netlist)
	{
		CText = "*.SUBCKT " + RemoveExtention(CTemp);
	}
	else CText = ".SUBCKT " + RemoveExtention(CTemp);

	count = CMAllConnectorsList.GetSize();

	int sub_circuit_pin_count = 0;

	for(p = 0; p < count; p++)// find out how many pin connections
	{
		PCSchematicObject = CMAllConnectorsList[p];

		if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;

		sub_circuit_pin_count++;
	}

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllConnectorsList[p];

		if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;

		CTemp = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;
		pin_id = (int)SpiceMKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);
		
		if(pin_id < 0) 
		{
			pin_id = 0;

			if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, IDS_INCORRECT_PIN_IDS, 0);

			return "";
		}

		if(!(pin_id < sub_circuit_pin_count))
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, IDS_INCORRECT_PIN_IDS, 0);

			return "";
		}

		try
		{
			CPinNames.SetAtGrow(pin_id, CTemp);// Set the name appropiate for that pin name.
		}
		catch(...)
		{
			_fpreset();

			return "";
		}
	}

	count = CPinNames.GetSize();

	for(p = 0; p < count; p++)
	{
		CText += " " + CPinNames[p];
	}

	return CText;
}

bool TCNetList::CreateLibaryLines(void)
{
	TCNetListLine	CNetListLine;
	CString CTest;

	int p, count;

	count = CMAnalysisSetup.CLibraryNameList.GetSize();

	for(p = 0; p < count; p++)
	{
		CTest = CMAnalysisSetup.CLibraryNameList[p];

		if(CTest == "") continue;

		CNetListLine.CLine = ".LIB " + CTest;

		CNetListLineList.Add(CNetListLine);
	}

	return true;
}

bool TCNetList::CreateIncludeLines(void)
{
	TCNetListLine	CNetListLine;

	int p, q, count;
	CString CTest;
	CString CTemp;

	count = CMAnalysisSetup.CIncludeNameList.GetSize();

	for(p = 0; p < count; p++)
	{
		CTest = CMAnalysisSetup.CIncludeNameList[p];

		if(CTest == "") continue;

		CNetListLine.CLine = ".INCLUDE " + CTest;

		CNetListLineList.Add(CNetListLine);
	}

	TCSchematicObject *PCSchematicObject;

	count = CMAllSchematicComponentsList.GetSize();
 
	int count2;
	CArray <CString, CString> CIncludeList; 

	bool flag;
	CString CSubFileName = CParentRef;
	CString CRefDes;

	CSubFileName.Replace(":", "%");

	if(CParentRef != "") CSubFileName += "%"; //added 18th January 2002, 3rd level deep subckt failed

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		// symbols with file names have circits and are included as a full netlist file
		CTest = PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName;

		CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		if(CTest == "") continue;

		if(!FileExists(CTest))// try the relative path
		{
			CTest = PCMDoc->GetRelativeFileName(CTest);
		}

		if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{		
			CTest = ReplaceFileExtension(CTest, "cir");
		}
		else
		{
			CTest = RemoveExtention(CTest);

			CTest += "%";

			CTest += CSubFileName + CRefDes + ".cir";
		}

		CTemp = ".INCLUDE " + CTest;


		count2 = CIncludeList.GetSize();
		
		flag = false;

		for(q = 0; q < count2; q++)// dont include twice
		{
			if(CTemp == CIncludeList[q])
			{
				flag = true;

				break;
			}
		}
		if(!flag) CIncludeList.Add(CTemp);
	}

	count = CIncludeList.GetSize();// dont include same file twice

	for(p = 0; p < count; p++)
	{
		CNetListLine.CLine = CIncludeList[p];

		CNetListLineList.Add(CNetListLine);
	}

	return true;
}
void TCNetList::ResetPinTags(void)
{
	TCSchematicObject *PCSchematicObject;

	int count = CMAllSchematicComponentsList.GetSize();

	for(int r = 0; r < count; r++)// ensuring no double net processing
	{
		PCSchematicObject = CMAllSchematicComponentsList[r];

		PCSchematicObject->user_tag = false;

		int count2 = PCSchematicObject->CMPinListObject.GetSize();

		for(int p = 0; p < count2; p++)
		{
			TCSchematicPinObject &CSchematicPinObject = PCSchematicObject->CMPinListObject[p];

			CSchematicPinObject.user_tag = false;
		}
	}
}

void TCNetList::ResetPinNets(int size)
{
	CMPinNets.SetSize(size);

	for(int p = 0; p < size; p++)
	{
		CMPinNets[p] = "";
	}
}
void TCNetList::ClearAllPinNames()
{
	TCSchematicObject *PCSchematicObject;
	int count, count2, p, q;

	count = CMAllSchematicComponentsList.GetSize();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		count2 = PCSchematicObject->GetNumberOfPins();

		for(q = 0; q < count2; q++)// this will always be overwriten in this function
									// this doesnot update screen drawing
		{
			PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "";
		}
	}
} 
bool TCNetList::CreatePinNetNames(CDC *PCDC)
{
	TCSchematicObject *PCSchematicObject, *PCSchematicObject2;
	TCSchematicObject *PCWireObject;
	CString CNetName, CPinName, CRefDes, CWireVoltage;
	int count, count2, count3;
	CRect	CTestRect;
	CRect	CPinRegion;	
	int p, q, r, s;
	int number_of_model_pins = 0;
	int pin_type;
	CRect CWireTestRect;
	CString CModelPinName;
	TCSpiceParameters *PCSpiceParameters;
	CString CModelType;
	int is_digital;

	ClearAllPinNames();

	m_include_ad_conversion = false;

	count = CMAllSchematicComponentsList.GetSize();

	for(p = 0; p < count; p++)// compare pins with wires
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		count2 = PCSchematicObject->GetNumberOfPins();
		is_digital = 1;

		if(CMAnalysisSetup.COutputSelectData.enable_auto_ad_conversion)
		{//auto AD addition
			if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT)
			{
				TCSpiceParameters &CSpiceParameters = PCSchematicObject->CMSchematicObjectData.CSpiceParameters;

				PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters);

				if(PCSpiceParameters)
				{
					PCSpiceParameters->GetPinList(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CPinArray);				
				}
				}
				else if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_MODEL ||
					PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_GENERATOR) 
				{
					if(!PCSchematicObject->CMSchematicObjectData.CSpiceParameters.IsDigital()) is_digital = 0;
				}

				number_of_model_pins = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CPinArray.GetSize();
		}

		for(q = 0; q < count2; q++)// try pins to wires
		{			    
			CPinRegion = PCSchematicObject->GetPinGrabRegion(q);

			count3= CMAllNetsList.GetSize();

			pin_type = is_digital;

			if(is_digital) 
			{
				pin_type = 1;

				if(q < number_of_model_pins)
				{
					CModelPinName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CPinArray[q];

					if(CModelPinName.GetAt(0) != '$' && CModelPinName.GetAt(0) != '#') pin_type = 0;
				}
			}

			for(s = 0; s < count3; s++)
			{
				PCWireObject = CMAllNetsList[s];

				if(PCWireObject->m_page_id != PCSchematicObject->m_page_id) continue;

				if(PCWireObject->m_draw_angle == E_VERTICAL || PCWireObject->m_draw_angle == E_HORIZONTAL)
				{
					if(!CTestRect.IntersectRect(CPinRegion, PCWireObject->CMRectGrabLocationRegion)) continue;
				}
				else //30 March 2002 xover wire bug
				{
					CWireTestRect = PCWireObject->GetPinGrabRegion(0);

					if(!CTestRect.IntersectRect(CPinRegion, CWireTestRect)) 
					{
						CWireTestRect = PCWireObject->GetPinGrabRegion(1);

						if(!CTestRect.IntersectRect(CPinRegion, CWireTestRect)) continue;
					}
				}													

				if(CMAnalysisSetup.COutputSelectData.enable_auto_ad_conversion)
				{
					if(pin_type) m_include_ad_conversion = true;
					else PCWireObject->is_digital = false;
				}
				else PCWireObject->is_digital = false;

				CNetName = PCWireObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

				PCSchematicObject->SetPinLabel(PCDC, q, E_COMPONENT_PIN_NET_NAME, CNetName);

				//added for device designer on read back, this will be restuffed
				CWireVoltage = FloatToSpiceMKSString(PCWireObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE]);
				PCSchematicObject->SetPinLabel(PCDC, q, E_COMPONENT_PIN_VOLTAGE, CWireVoltage);
			}
		}
	}

	for(p = 0; p < count; p++)// compare pins with pins
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		count2 = PCSchematicObject->GetNumberOfPins();

		for(q = 0; q < count2; q++)// try pins to pins
		{			    
			CPinRegion = PCSchematicObject->GetPinGrabRegion(q);
			CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
			CNetName  = PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

			if(CNetName == "")
			{
				CNetName.Format("Node%s_%d", CRefDes, q);
				PCSchematicObject->SetPinLabel(PCDC, q, E_COMPONENT_PIN_NET_NAME, CPinName);//speedup required
			}

			for(r = 0; r < count; r++)//second component scan
			{
				PCSchematicObject2 = CMAllSchematicComponentsList[r];

				if(PCSchematicObject == PCSchematicObject2) continue;
				if(PCSchematicObject->m_page_id != PCSchematicObject2->m_page_id) continue;

				count3 = PCSchematicObject2->GetNumberOfPins();

				for(s = 0; s < count3; s++)//second pin scan
				{
					if(!CTestRect.IntersectRect(CPinRegion, PCSchematicObject2->GetPinGrabRegion(s))) continue;

					PCSchematicObject2->SetPinLabel(PCDC, s, E_COMPONENT_PIN_NET_NAME, CNetName);//speedup required
					
					break;
				}
			}
		}
	}

	count = CMAllConnectorsList.GetSize();

	for(p = 0; p < count; p++)// compare connectors to pins
	{							// and force pin names 
		PCSchematicObject = CMAllConnectorsList[p];
    
		CPinRegion	= PCSchematicObject->GetPinGrabRegion(0);
		CRefDes		= PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
		CNetName	= PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		if(CNetName == "")
		{
			//issue warning
		}

		count2 = CMAllSchematicComponentsList.GetSize();

		for(r = 0; r < count2; r++)//second component scan
		{
			PCSchematicObject2 = CMAllSchematicComponentsList[r];

			if(PCSchematicObject == PCSchematicObject2) continue;
			if(PCSchematicObject->m_page_id != PCSchematicObject2->m_page_id) continue;

			count3 = PCSchematicObject2->GetNumberOfPins();

			for(s = 0; s < count3; s++)//second pin scan
			{
				if(!CTestRect.IntersectRect(CPinRegion, PCSchematicObject2->GetPinGrabRegion(s))) continue;

				PCSchematicObject2->SetPinLabel(PCDC, s, E_COMPONENT_PIN_NET_NAME, CNetName);//speedup required
					
				break;
			}
		}
		
	}

	count3= CMAllNetsList.GetSize();

	if(CMAnalysisSetup.COutputSelectData.enable_auto_ad_conversion)
	for(p = 0; p < count3; p++)//AD support, if any is flaged as analogue set all others to analog.
	{
		PCSchematicObject = CMAllNetsList[p];

		CNetName = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

		for(s = 0; s < count3; s++)
		{
			PCWireObject = CMAllNetsList[s];

			if(PCWireObject == PCSchematicObject) continue;

			if(CNetName != PCWireObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel) continue;

			if(!PCSchematicObject->is_digital) PCWireObject->is_digital = 0;
		}
	}

//	RenameNetsToComponentNames(PCDC);// new added 31 March 2012, still testing. Remove to fix.
	// problems with rename to orginal nets and stuff with this method. Need to directly remame nets by searching for connected nets to 
	// components. in cdoc->UpdateNets();

	return true;
}

void TCNetList::RenameNetsToComponentNames(CDC *PCDC)
{
	PCDC;

	TCSchematicObject *PCSchematicObject, *PCWireObject;

	int p, q, s, count, count2, count3;

	CString CPinNetName, CNetName, CPinName, CRefDes, CNewPinNetName; // initially pin name = net name

	count = CMAllSchematicComponentsList.GetSize();

	count3 = CMAllNetsList.GetSize();

	for(p = 0; p < count; p++)// compare pin net names with wire net names, if match, rename both, using ref designator and pin name
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		count2 = PCSchematicObject->GetNumberOfPins(); 

		for(q = 0; q < count2; q++)// try pins to wires
		{			    
			CPinNetName = PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

			if(CPinNetName == "0") continue;

			CPinName = PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;

			CNewPinNetName = CRefDes + CPinName;

			for(s = 0; s < count3; s++)
			{
				PCWireObject = CMAllNetsList[s];

				CNetName = PCWireObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
	
				if(CPinNetName != CNetName) continue;

				PCWireObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = CNewPinNetName;
			}

			PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = CNewPinNetName;
		}
	}
}

bool TCNetList::CreateNetLines(void)
{
	TCNetListLine CNetListLine, CADNetListLine;
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCSchematicObject2;
	TCSchematicObject *PCWireObject;
	CString CText, CTemp, CRefDes, CValueEval;
	CString CPinName;
	CRect	CTestRect;
	CRect	CPinRegion;	
	int count, count2, count3, count4;
	int p, r, q, s;
	bool f_add_net_line = false;
	bool f_pin_already_done = false;
	bool f_flag = false;
	int pin_check;
	CString CError;
	CString CComponentType;
	bool error_flag = false;
	bool pin_found = false;
	int property_view, number_of_model_pins, model_pin_type;
	bool ad_ad_converter;
	CString CADRefDes;
	int ad_counter=0;
	CString CADCounter;
	int create_wc_subckt_model;

	TCBillOfMaterials CBillOfMaterials;

	m_gmin_node_counter = 0;//virtual resistor node counter

	CreatePinNetNames(&GlobalCDCTemp);

	count = CMAllSchematicComponentsList.GetSize();
	count4 = CMAllComponentsAndConnectorsList.GetSize();

	ResetPinTags();

	net_lines_start_index = CNetListLineList.GetSize() - 1;

	CString CParamRefDes  = CMAnalysisSetup.CParametricSetupData.CSource;
	
	CString CTempRefAppend, CDigitalNodes;

	for(p = 0; p < count; p++)// compare pins with wires
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		PCSchematicObject->CMSchematicObjectData.PCMAnalysisSetup = &CMAnalysisSetup; // Added Dec 2014

		if(PCSchematicObject->m_type == E_GROUND) continue;

		count2 = PCSchematicObject->GetNumberOfPins();
		CMPinNets.SetSize(0, count2);
		CMPinNets.SetSize(count2, count2);

		CComponentType = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

		CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		create_wc_subckt_model = PCSchematicObject->CMSchematicObjectData.IsWorstCaseGenerator();

		property_view = PCSchematicObject->CMSchematicObjectData.component_property_view_type;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			//symbol .subckt is included in the file
			if(PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName != "") continue;

			if(CParentRef != "")
				CRefDes = CRefDes + ":" + CParentRef;
		}

		// this is an fudge bit of code

//		if(property_view == E_PROPERTY_INDUCTOR || // Now have .model for inductor Oct 26th 2016, no longer need X subckt
		if(property_view >= E_PROPERTY_DC_VOLTAGE_SOURCE && property_view <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM)
		{
			CTempRefAppend = "X_";

			if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES || CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE)// changed to support multiple param
			{
				//only change ref des if that L or VPS is being swept.
				int model_files_flag = CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES || CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE;

				if(model_files_flag && (property_view == E_PROPERTY_INDUCTOR || create_wc_subckt_model))	 
				{   
					CText = CTempRefAppend + CRefDes + " ";// dont let user use X_L
				}
				else CText = CRefDes + " ";
			}
			else CText = CRefDes + " ";
		}
		else CText = CRefDes + " ";

		
		CNetListLine.CRefDes = CRefDes;
		CNetListLine.CPins	= "";
		pin_check	= 0;
		pin_found	= false;
		CRect CWireTestRect;

		CArray <CString, CString> &CPinArray = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CPinArray;

		number_of_model_pins = CPinArray.GetSize();
		ad_ad_converter = false;
//		ad_counter = 0;

		for(q = 0; q < count2; q++)// try pins to wires
		{		
			pin_found = false;

			CPinRegion = PCSchematicObject->GetPinGrabRegion(q);

			count3= CMAllNetsList.GetSize();

			model_pin_type = 0;

			if(q < number_of_model_pins)
			{
				if(CPinArray[q].GetAt(0) == '#') model_pin_type		= 1;//digital input
				else if(CPinArray[q].GetAt(0) == '$') model_pin_type= 2;//digital output
			}			

			CADNetListLine.CLine = "";

			for(s = 0; s < count3; s++)
			{
				PCWireObject = CMAllNetsList[s];

				if(PCWireObject->m_page_id != PCSchematicObject->m_page_id) continue;
			
				if(PCWireObject->m_draw_angle == E_VERTICAL || PCWireObject->m_draw_angle == E_HORIZONTAL)
				{
					if(!CTestRect.IntersectRect(CPinRegion, PCWireObject->CMRectGrabLocationRegion)) continue;
				}
				else //30 March 2002 xover wire bug
				{
					CWireTestRect = PCWireObject->GetPinGrabRegion(0);

					if(!CTestRect.IntersectRect(CPinRegion, CWireTestRect)) 
					{
						CWireTestRect = PCWireObject->GetPinGrabRegion(1);

						if(!CTestRect.IntersectRect(CPinRegion, CWireTestRect)) continue;
					}
				}

				CTemp = PCWireObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
				
				if(CMAnalysisSetup.COutputSelectData.enable_auto_ad_conversion)
				if(m_include_ad_conversion)
				if(!PCWireObject->is_digital && model_pin_type)// analogue wire connected to a digital pin
				{		
					ad_counter++;

					CADCounter.Format("_%d", ad_counter);

					if(model_pin_type == 1) CADNetListLine.CLine = CTemp + ' ' + '$' + CTemp + CADCounter + ' ';

					else CADNetListLine.CLine = '$' + CTemp + CADCounter + ' ' + CTemp + ' ';

					CTemp = '$' + CTemp + CADCounter;

					ad_ad_converter = true;
				}

				CText += CTemp + " ";
				CNetListLine.CPins += CTemp + " ";
		
				f_add_net_line	= true;
				pin_found		= true;

				f_pin_already_done = true;
				CMPinNets[q] = CTemp;
				pin_check++;

				break;
			}//end of pins to wires

			if(ad_ad_converter)
			{
				ad_ad_converter = false;

				CADRefDes.Format("%s_%dAutoAD", CRefDes, q);

				CADNetListLine.CLine = CADRefDes + ' ' + CADNetListLine.CLine;

				if(model_pin_type == 1) CADNetListLine.CLine += CMAnalysisSetup.CReRun.GetADConversionModelName();				
				else CADNetListLine.CLine += CMAnalysisSetup.CReRun.GetDAConversionModelName();

				CNetListLineList.Add(CADNetListLine);
			}
			
			if(!f_pin_already_done)//try pins to pins
			{
				for(r = 0; r < count4; r++)//second component scan
				{
					PCSchematicObject2 = CMAllComponentsAndConnectorsList[r];

					if(PCSchematicObject == PCSchematicObject2) continue;
				
					if(PCSchematicObject->m_page_id != PCSchematicObject2->m_page_id) continue;

					count3 = PCSchematicObject2->GetNumberOfPins();

					for(s = 0; s < count3; s++)//second pin scan
					{
						if(!CTestRect.IntersectRect(CPinRegion, PCSchematicObject2->GetPinGrabRegion(s))) continue;

						if(PCSchematicObject2->m_type == E_GROUND) CPinName = "0";

						else CPinName  = PCSchematicObject2->CMSchematicObjectData.CPinListData[s].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

						f_flag = false;// dont doublicate nets
						
						TCSchematicPinObject &CSchematicPinObject = PCSchematicObject->CMPinListObject[q];

						if(CSchematicPinObject.user_tag) continue; 

						CSchematicPinObject.user_tag = true;

						if(f_flag) break;

			//			if(PCSchematicObject2->m_is_local) CPinName +=  PCSchematicObject2->CMPageId;

						if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
							if(CParentRef != "") CPinName += ':' + CParentRef;

						CText += CPinName + ' ';
						CNetListLine.CPins += CPinName + " ";
						pin_check++;
						f_add_net_line = true;
						pin_found = true;
		
						break; // cannot connect pin to differnt pin on same component
					}//End of second component pin scan loop
				}//End of 2nd component scan loop

			}

			f_pin_already_done = false;

			if(!pin_found)
			{
				if(property_view == E_PROPERTY_MOSFET)// connect up a 3 terminal as a 4 terminal
				{
					if(q == 3)// floating substrate connection, connect it to the source
					{
						CText += CMPinNets[2] + ' ';

						pin_check++;

						pin_found = true;
					}
				}

				if(!pin_found)
				{
					CString CDevicePinName = "?";

					if(q < PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize())

						CDevicePinName = PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;

					CError.Format("Pin name %s is not connected on device: %s - %s", CDevicePinName, CComponentType, CRefDes);

					if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_WARNING, CError, 0);//0 ->force message window to be displayed
			
					if(AddDefaultNet(PCSchematicObject, CPinName, q))// will add R to ground also and set up CPinName
					{
						CText += CPinName + " ";
						CNetListLine.CPins += CPinName + " ";
						f_add_net_line = true;
						pin_check++;
					}
				}
			}
		}

		if(f_add_net_line)
		{
			if(pin_check != count2) 
			{
				CGlobalStatusMessage = "Unconnected pin present";

				error_flag = true;
			}

			if(property_view == E_PROPERTY_MOSFET)// connect up a 3 terminal as a 4 terminal
			{
				if(count2 == 3)// 3 terninal, add extra pin node connected to source
				{
					CText += CMPinNets[2] + ' ';
				}
			}

			if(!CMAnalysisSetup.CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT] || (property_view != E_PROPERTY_RESISTOR && property_view != E_PROPERTY_MOSFET))
			{
				CNetListLine.CValue = PCSchematicObject->CMSchematicObjectData.GetSpiceValue(CMAnalysisSetup);
				CText += CNetListLine.CValue;
				CNetListLine.CLine = CText;
				CNetListLineList.Add(CNetListLine);
			}
			else if(!CreateDesignerNetLines(PCSchematicObject, CText)) return false;

			if(PCBillOfMaterials)
			{
				if(property_view == E_PROPERTY_INDUCTOR || property_view == E_PROPERTY_RESISTOR || property_view == E_PROPERTY_CAPACITOR)
				{
					CValueEval = GetFirstWord(CNetListLine.CValue);

					CBillOfMaterials.CModelName		= "";
					CBillOfMaterials.value			= MKSStringToFloat(GetFirstWord(CNetListLine.CValue));				
				}
				else
				{				
					CBillOfMaterials.CModelName		= GetFirstWord(CNetListLine.CValue);

					if(PCSchematicObject->CMSchematicObjectData.is_unique_model)
					{
						CBillOfMaterials.CModelName = CBillOfMaterials.CModelName.Right(CBillOfMaterials.CModelName.GetLength() - CRefDes.GetLength());
					}

					CBillOfMaterials.value			= 0.0;
				}

				CBillOfMaterials.CModelType		= PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType;
				CBillOfMaterials.property_view  = property_view;
				CBillOfMaterials.CRefDes		= CRefDes;
				CBillOfMaterials.CPackageName	= PCSchematicObject->CMSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];
				CBillOfMaterials.CModelFilePath = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
				CBillOfMaterials.CModelFileName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
				CBillOfMaterials.CSymbolParameters = PCSchematicObject->CMSchematicObjectData.GetSymbolParameters();

				PCBillOfMaterials->Add(CBillOfMaterials);
			}
		}

		f_add_net_line = false;
	}
 
	net_lines_stop_max_index = CNetListLineList.GetSize();

	if(GCAuthorization.m_build_type == E_RESTRICTED_RELEASE_STUDENT)
	{
		if(top_level)
		{
			if((net_lines_stop_max_index - net_lines_start_index) > 100) return false;
		}
		else if((net_lines_stop_max_index - net_lines_start_index) > 20) return false;

	}

	if(GCAuthorization.m_build_type == E_DEMO_RELEASE)
	{
		if(top_level)
		{
			if((net_lines_stop_max_index - net_lines_start_index) > E_MAX_NUM_NET_LINES) return false;
		}
		else if((net_lines_stop_max_index - net_lines_start_index) > E_MAX_NUM_SUBCKT_NET_LINES) return false;

	}

	if(1 && (GCAuthorization.m_build_type == E_DEMO_RELEASE))
	{
		if(top_level)
		{
			if((net_lines_stop_max_index - net_lines_start_index) > 31 - 1) return false;
		}
		else if((net_lines_stop_max_index - net_lines_start_index) > 24 + 1) return false;
	}

	if(error_flag) return false;

	return true;
}

bool TCNetList::CreateDesignerNetLines(TCSchematicObject *PCSchematicObject, CString CText)
{
	TCNetListLine CNetListLine;

	int selected_devices = (int) CMAnalysisSetup.CReRun.CReserved.CIntArray[E_DESIGNER_SELECTED_DEVICES];
	int selected_type = (int) PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];
	int view_type = PCSchematicObject->CMSchematicObjectData.component_property_view_type;

	int not_select = false;

	CString CRefDes = GetFirstWord(CText);

	if(view_type == E_PROPERTY_MOSFET && selected_devices == E_DEVICE_DESIGNER_SELECTED_RESISTORS) not_select = true;
	if(view_type == E_PROPERTY_RESISTOR && selected_devices == E_DEVICE_DESIGNER_SELECTED_MOSFETS) not_select = true;

	if(!selected_type || not_select || !selected_devices)
	{
		CNetListLine.CValue = PCSchematicObject->CMSchematicObjectData.GetSpiceValue(CMAnalysisSetup);
		CText += CNetListLine.CValue;
		CNetListLine.CLine = CText;
		CNetListLine.CRefDes = CRefDes;
		CNetListLineList.Add(CNetListLine);

		return true;
	}			

	CString CNode1, CNode2;

	CNode1 = RemoveFirstWord(CText);
	CNode1 = GetFirstWord(CNode1);
	CNode1 += " ";
	CNode2 = RemoveFirstWord(CText);
	CNode2 = RemoveFirstWord(CNode2);

	if(view_type == E_PROPERTY_MOSFET) CNode2 = RemoveFirstWord(CNode2);//get next nodename

	CNode2 = GetFirstWord(CNode2);
	CNode2 += " ";

	CString CValue;
	CString CRefDesAddition = "R$#";
	CString CNodeNames = "$" + CRefDes;
	CString CGeneratorName = "G$";
	CString CModelName = "ssdes";

	if(view_type == E_PROPERTY_MOSFET) CRefDesAddition.SetAt(0, 'M');

	CText = CRefDesAddition + CText;

	int type = (int) PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];

	if(!type && PCMDoc)
	{
		CString CMsg;
			
		CMsg.LoadString(IDS_VALUE_DESIGNER_NONE_ERROR);

		CMsg = CRefDes + " " + CMsg;
		
		PCMDoc->DisplayError(IDS_NETLIST_ERROR, CMsg);

		return false;
	}

	int pin_id = 0;

	if(type == E_VALUE_DESIGNER_NEGATIVE_VOLTS) 
	{
		pin_id = 1;

		if(view_type == E_PROPERTY_MOSFET) pin_id = 2;//source connection
	}

	if(type != E_VALUE_DESIGNER_CURRENT) 
	{
		CModelName = CModelName + "v";

		CGeneratorName = "V" + CGeneratorName + CRefDes + " ";
	}
	else 
	{
		CModelName = CModelName + "i";

		CGeneratorName = "I" + CGeneratorName + CRefDes + " ";
	}

	//replace resistor with .subckt with one additional node

	if(type == E_VALUE_DESIGNER_NEGATIVE_VOLTS || type == E_VALUE_DESIGNER_CURRENT) // generator output needs to be swopped over for +node
		CNetListLine.CLine = CRefDesAddition + CRefDes + " " + CNode1 + CNode2;
	else 
		CNetListLine.CLine = CRefDesAddition + CRefDes + " " + CNode2 + CNode1;

	CNetListLine.CLine += CNodeNames + " ";

	CNetListLine.CLine += CModelName;

	if(type == E_VALUE_DESIGNER_POSITIVE_VOLTS || type == E_VALUE_DESIGNER_NEGATIVE_VOLTS)
	{
		//This is set from E_RESERVED_INT_DESIGNER_VALUE in the netlist setup
		CValue = PCSchematicObject->GetPinLabel(pin_id, E_COMPONENT_PIN_VOLTAGE);

		CValue = MKSStringToSpiceMKSString(CValue);
	}
	else //Current specified
	{
		float data = PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE];

		data *= -1;

		CValue = FloatToMKSString(data);
	}

	CNetListLine.CLine += " $" + CValue; //new

	CNetListLine.CRefDes = CRefDesAddition + CRefDes;

	CNetListLineList.Add(CNetListLine);

	return true;
}

bool TCNetList::AddDefaultNet(TCSchematicObject *PCSchematicObject, CString &CPinName, int pin_id)
{
	// this funtion will add a "null" node for digital outputs not connected
	// a 1/GMin resistor will be added to ground from a virtual node for analofg parts
	
	if(!PCSchematicObject) return false;

	if(!(pin_id < PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize())) return false;
	if(!(E_COMPONENT_PIN_NAME < PCSchematicObject->CMSchematicObjectData.CPinListData[pin_id].CLabelListData.GetSize())) return false;
	
	int connection_type = PCSchematicObject->CMSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].connection_type;

	CString			CText;
	TCNetListLine	CNetListLine;
	
// get virtual resistor value
	CString RGMin;
	double gmin;
//
	switch(connection_type)
	{
		case E_SCHEMATIC_PIN_ANALOGUE_INPUT:	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_connect_analog_input_pins) return false;
											
												gmin = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_GMIN].value;
												if(!gmin) gmin = 1e-12;
												gmin = 1/gmin;// convert to a resistor
												RGMin.Format("%e", gmin);

												CPinName.Format("_GMIN_NET%d", m_gmin_node_counter);
												CNetListLine.CLine.Format("R_GMIN_NET%d _GMIN_NET%d 0 %s", m_gmin_node_counter, m_gmin_node_counter, RGMin);
												
												CNetListLineList.Add(CNetListLine);
												m_gmin_node_counter++;
												return true;

		case E_SCHEMATIC_PIN_ANALOGUE_OUTPUT:	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_connect_analog_output_pins) return false;
		
												gmin = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_GMIN].value;
												if(!gmin) gmin = 1e-12;
												gmin = 1/gmin;// convert to a resistor
												RGMin.Format("%e", gmin);

												CPinName.Format("_GMIN_NET%d", m_gmin_node_counter);
												CNetListLine.CLine.Format("R_GMIN_NET%d _GMIN_NET%d 0 %s", m_gmin_node_counter, m_gmin_node_counter, RGMin);
												CNetListLineList.Add(CNetListLine);
												m_gmin_node_counter++;

												return true;

		case E_SCHEMATIC_PIN_DIGITAL_INPUT: if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_connect_digital_input_pins) return false;
											return false;// not yet done

		case E_SCHEMATIC_PIN_DIGITAL_OUTPUT: if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_connect_digital_input_pins) return false;
												
											CPinName = "null";

											return true;

		default: return false;
	}
}

bool TCNetList::UpdateNetList(void)
{
	int count, p;// not fished yet, this is to allow update of component 
				// values without doing a full netlist

	count = CNetListLineList.GetSize();
	
	for(p = 0; p < count; p++)
	{
		TCNetListLine &CNetListLine = CNetListLineList[p];

		CNetListLine.CLine = CNetListLine.CRefDes + ' ' + CNetListLine.CPins + ' '+ CNetListLine.CValue;
	}

	return true;
}

void TCNetList::SetupGlobalAndLocalNetNames(void)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCNets;
	TCSchematicObject *PCSchematicObjectNew;
	CString CText, CTemp;

	int count = CMAllNetsList.GetSize();
	int p, q, r, count2, count3;

	for(p = 0; p < count; p++)// compare wires with connecters 
	{
		PCNets = CMAllNetsList[p];

		CText = PCNets->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
		PCNets->m_is_local = true;

		if(CText == '0')
		{
			PCNets->m_is_local = false;

			continue;
		}

		count2 = CMAllConnectorsList.GetSize();

		for(q = 0; q < count2; q++)// if net has same name as connecter
		{							// then net is global

			PCSchematicObject = CMAllConnectorsList[q];

			if(PCSchematicObject->m_page_id != PCNets->m_page_id) continue;

			if(CText != PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel) continue;
			
			 PCNets->m_is_local = false;
		}
	}

	///compare connectors with pins

	count = CMAllConnectorsList.GetSize();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllConnectorsList[p];

		PCSchematicObject->m_is_local = false;
		PCSchematicObject->CMPinListObject[0].m_is_local = false;

		CText = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		count2 = CMAllSchematicComponentsList.GetSize();

		for(q = 0; q < count2; q++)
		{
			PCSchematicObjectNew = CMAllSchematicComponentsList[q];

			if(PCSchematicObject->m_page_id != PCSchematicObjectNew->m_page_id) continue;

			count3 = PCSchematicObjectNew->CMSchematicObjectData.CPinListData.GetSize();

			for(r = 0; r < count3; r++)
			{
				CTemp = PCSchematicObjectNew->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;
				if(CTemp != CText) 
				{
					PCSchematicObjectNew->CMPinListObject[r].m_is_local = true;
					continue;
				}
				PCSchematicObjectNew->CMPinListObject[r].m_is_local = false;
			}
		}
	}
}

bool TCNetList::SetupComponentList(void)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicManager *PCSchematicManager;
	int type;

	CMAllSchematicComponentsList.SetSize(0, 1024);
	CMAllNetsList.SetSize(0, 1024);
	CMAllConnectorsList.SetSize(0, 1024);
	CMAllComponentsAndConnectorsList.SetSize(0, 1024);

	int schematic_object_count;
	CString CRefDes;
	bool f_ground = false;

	int schematic_count = CMSchematicManagerList.GetSize();

	for(int p = 0; p < schematic_count; p++)
	{
		PCSchematicManager = CMSchematicManagerList[p];

		CArray<TCSchematicObject*, TCSchematicObject*> &GraphicList = 
		PCSchematicManager->GetGraphicList();

		schematic_object_count = GraphicList.GetSize();

		for(int q = 0; q < schematic_object_count; q++)
		{
			// get conector pin and rename its net to do
			PCSchematicObject = GraphicList[q];

			CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

			type = PCSchematicObject->m_type;

			if(type == E_PAGE_CONNECTER_INPUT ||
			   type == E_PAGE_CONNECTER_OUTPUT ||
			   type == E_PAGE_CONNECTER_BIDIRECTIONAL||
			   type == E_SUBCIRCUIT_PIN_CONNECTER ||
			   type == E_GROUND)
			{
				CMAllConnectorsList.Add(PCSchematicObject);

				CMAllComponentsAndConnectorsList.Add(PCSchematicObject);

				if(PCSchematicObject->m_type == E_GROUND) 
				{
					f_ground = true;
				}
				continue;
			}

			if(type == E_WIRE_COMPONENT)
			{
				PCSchematicObject->is_digital = true;//auto A/D D/A

				CMAllNetsList.Add(PCSchematicObject);

				continue;
			}
			if(type)
				if(type < E_GROUND) continue;
		
			if(type == E_TITLE_BLOCK) continue;

			if(!PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE]) continue;// do not include in netlist

			CMAllSchematicComponentsList.Add(PCSchematicObject);
			CMAllComponentsAndConnectorsList.Add(PCSchematicObject);
		}
	}

	if(!f_ground) if(top_level) if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_WARNING, IDS_NO_GROUND, 0);

	if(!RenameToTopLevelNets()) 
	{
		RestoreToSubcktNets();

		return false;
	}

	return true;
}

bool TCNetList::RenameToTopLevelNets(void)
{
	TCSchematicObject *PCSchematicObject, *PCNets;

	int connector_count = CMAllConnectorsList.GetSize();

	int net_count =  CMAllNetsList.GetSize();

	COriginalNetNameList.SetSize(0);
	COriginalNetNameList.SetSize(net_count);

	int p;

	for(p = 0; p < net_count; p++) 
	{
		COriginalNetNameList[p] = CMAllNetsList[p]->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
	}

	//This is done here to simplify the restore;

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist) return true;

	if(top_level) return true;// assume not a subcircuit
	
	int pin_id;

	int sub_circuit_pin_count = 0;

	for(p = 0; p < connector_count; p++)// find out how many pin connections
	{
		PCSchematicObject = CMAllConnectorsList[p];

		if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;

		sub_circuit_pin_count++;
	}

	int sub_pin_list_size = CSubCircuitPinList.GetSize();

	if(sub_circuit_pin_count != sub_pin_list_size) 
	{
		if(!sub_pin_list_size) return false; // 15th dec 2006. need to figure out why this gives bogus msg

		CString CInfoName = ExtractFileName(CFileName);

		CString CMessageText;

		CString CMsg, CMsg2;

		CMsg.LoadString(IDS_PINS_ON_SCH_MATCH);

		CMsg2.LoadString(IDS_DO_NOT_MATCH_PINS);

		CInfoName = RemoveExtention(CInfoName);

		CInfoName += ".sss";

		CMessageText.Format("%s %s %s", CMsg, CInfoName, CMsg2);

		if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, CMessageText, 0);

		return false;
	}

	int flag = false;
	bool analog_flag = true;

	TCNetListLine	CNetListLine;
	CString			CConnectorNetName, CTopLevelName, CNetName;
	CString			CVoltName, CPinCount;

	for(p = 0; p < net_count; p++)
	{
		PCNets = CMAllNetsList[p];

		CNetName = PCNets->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

		if(CNetName == "0") continue;

		flag = false;

		for(int q = 0; q < connector_count; q++)// rename the nets which are the same as the connecter names
		{	
			PCSchematicObject = CMAllConnectorsList[q];

			if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;

			analog_flag = true;

			pin_id = (int)SpiceMKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);
		
			if(pin_id < 0) 
			{
				if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, IDS_NO_NEG_SUBCKT_PINS, 0);

				return false;
			}

			if(!(pin_id < connector_count))
			{
				if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, IDS_INVALID_SUBCKT_PIN_ID);

				return false;
			}

			CConnectorNetName 	= PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;
			CTopLevelName		= CSubCircuitPinList[pin_id];

			if(CNetName == CConnectorNetName)
			{				
				if(CConnectorNetName.GetAt(0) == '#') analog_flag = false;//digital connections
				if(CConnectorNetName.GetAt(0) == '$') analog_flag = false;//digital connections

				flag = true;

				break;
			} 
		}
		
		if(flag) 
		{
			if(!m_pcb_format && analog_flag && GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_subckt_currents) //digital connections cannot have voltage sources inserted
				PCNets->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = CNetName + ':' + CParentRef;
			else
				PCNets->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = CTopLevelName;

		}
		else PCNets->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = CNetName + ':' + CParentRef;					
	}
		
//********

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_subckt_currents)
	if(!m_pcb_format)// DO not insert voltage sources for PCB layouts
	for(int q = 0; q < connector_count; q++)//add current sensing voltage sources
	{	
		PCSchematicObject = CMAllConnectorsList[q];

		if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;
		
		CConnectorNetName 	= PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		if(CConnectorNetName == "")continue;

		flag = true;

		if(CConnectorNetName.GetAt(0) == '#') continue;//digital connections
		if(CConnectorNetName.GetAt(0) == '$') continue;//digital connections

		pin_id = (int)SpiceMKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);

		CConnectorNetName 	= PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;
			
		CTopLevelName		= CSubCircuitPinList[pin_id];
		
		CVoltName = "V";

		CVoltName += GSubCktCurrentStr + PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;
		
		CVoltName += ':' + CParentRef;

		CNetListLine.CLine = CVoltName + ' ' + CTopLevelName + ' ';

		CNetListLine.CLine += CConnectorNetName + ':' + CParentRef + " 0"; // original name 

		CNetListLineList.Add(CNetListLine);
	}

	return true;
}

void TCNetList::RestoreToSubcktNets(void)
{
	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist) return;

	int net_count = COriginalNetNameList.GetSize();

	for(int p = 0; p < net_count; p++) 
	{
		CMAllNetsList[p]->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = COriginalNetNameList[p];
	}
}

bool TCNetList::CreateModelLines(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, TCSuperSpiceDoc *PCDoc, int runs_counter)
{
// copied from create, avoid creating all netlists again
	TCNetListLine CNetListLine;
	PCMDoc = PCDoc;

	int p;

	int count = CListOfSchematicManagers.GetSize();

	CMSchematicManagerList.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CMSchematicManagerList[p] = CListOfSchematicManagers[p];
	}

	CMAnalysisSetup = CAnalysisSetup;

	CFileName		= CAnalysisSetup.CFileName;
	CSchematicName	= CAnalysisSetup.CSchematicName;
	
	if(CAnalysisSetup.CIncludeNameList.GetSize() > 1)
		CModelFileName = CAnalysisSetup.CIncludeNameList[1];
	else CModelFileName = "";

// copied from create

	// if paramertersweep need InitaliseAnalysisSetup, if WC sweep only need SetupComponentList*()
	InitaliseAnalysisSetup(CMSchematicManagerList, CMAnalysisSetup, "");// need parameter data

	bool flag = CreateModelLines(runs_counter);

	RestoreToSubcktNets();

	return flag;
}

bool TCNetList::CreateModelLines(int runs_counter)
{
	TCNetListLine		CNetListLine;
	TCSchematicObject	*PCSchematicObject;
	TCSchematicObject	*PCSchematicObjectNew;
	CString CTempText;
	CString CError;
	CString CRefDes, CRefDesNew;

	CMModelLines.SetSize(0, 256);

	CTempText.Format("*** %s ***", CModelFileName);

	CMModelLines.Add(CTempText);

	if(top_level)// add .options
	{
		CString CText;

		CText.LoadString(IDS_NETLIST_MSG_START_SPICE_CONTROL);

		CMModelLines.Add(CText);

		if(!CreateDotLines())	return false;

		if(CMAnalysisSetup.CBerklySpiceOptionsSetupData.tran_nodeset)
		{
			CString CFileName, CTempText, CText;

			CText = RemoveExtention(CSchematicName);

			CFileName.LoadString(IDS_TRAN_NODESET_EXT);

			CTempText.Format("%s%d", CText, runs_counter);

			CTempText += CFileName;

			if(FileExists(CTempText))
			{
				CText = ".INCLUDE " + CTempText;

				CMModelLines.Add(CText);
			}
		}

		CText.LoadString(IDS_NETLIST_MSG_END_SPICE_CONTROL);

		CMModelLines.Add(CText);
	}

	int count = CMAllSchematicComponentsList.GetSize();
	int p, q;
	double width, height;
	int create_wc_subckt_model = false;
	CString CVPSSubckt;
	int create_wc_subckt_model2 = false;
	CString CVPSSubckt2;

	SetSchematicTags(true);

	CString CNewRecordName;
	CString CRecordName;
	CString SweepRecordName = CMAnalysisSetup.CParametricSetupData.CRecordName;
	CString SweepRefDes = CMAnalysisSetup.CParametricSetupData.CSource;

	for(p = 0; p < count; p++)// dont include the same model data more then once
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		PCSchematicObject->CMSchematicObjectData.PCMAnalysisSetup = &CMAnalysisSetup;// Added Dec 5th 2014
		
		CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		create_wc_subckt_model = PCSchematicObject->CMSchematicObjectData.IsWorstCaseGenerator();

		PCSchematicObject->CMSchematicObjectData.GetWidthAndLength(width, height);// bining support
				
		CNewRecordName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.GetRecordName(width, height);

		if(!PCSchematicObject->user_tag) continue;// allready checked

		int property_view = PCSchematicObject->CMSchematicObjectData.component_property_view_type;

		if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES  ||
		   CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE)
		{
			if(property_view == E_PROPERTY_RESISTOR || property_view == E_PROPERTY_CAPACITOR || 
				property_view == E_PROPERTY_INDUCTOR || create_wc_subckt_model)
			{
				CNewRecordName += CRefDes + "_XN";
			}

			CNewRecordName = CNewRecordName.Left(CNewRecordName.GetLength() - 3);
		}

		for(q = 0; q < count; q++)// include model unless already included
		{
			PCSchematicObjectNew = CMAllSchematicComponentsList[q];

			PCSchematicObjectNew->CMSchematicObjectData.PCMAnalysisSetup = &CMAnalysisSetup;// Added Dec 5th 2014

			if(PCSchematicObject == PCSchematicObjectNew) continue;

			CRefDesNew = PCSchematicObjectNew->GetLabel(E_COMPONENT_DESIGNATOR);

			create_wc_subckt_model2 = PCSchematicObjectNew->CMSchematicObjectData.IsWorstCaseGenerator();

			PCSchematicObjectNew->CMSchematicObjectData.GetWidthAndLength(width, height);// bining support
				
			CRecordName = PCSchematicObjectNew->CMSchematicObjectData.CSpiceParameters.GetRecordName(width, height);

			if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES  ||
			   CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE)
			{
				if(property_view == E_PROPERTY_RESISTOR || property_view == E_PROPERTY_CAPACITOR || 
				   property_view == E_PROPERTY_INDUCTOR || create_wc_subckt_model2)
				{
					CRecordName += CRefDesNew + "_XN";
				}
			}

			if(CMAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES &&
			    CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type != E_PARAMETER_RUN_MODE_MODEL_FILE)//ignor _XN type for reruns
			{
				if(CNewRecordName != CRecordName) continue;
			}
			else
			{	 
				CRecordName	= CRecordName.Left(CRecordName.GetLength() - 3);
				
				if(CRecordName != CNewRecordName) continue;
			}

			if(PCSchematicObjectNew->CMSchematicObjectData.is_unique_model) continue;

			// Added 15th July 2012 for unique parameter support
			if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT) continue;

			PCSchematicObjectNew->user_tag = false;
		}
	}

	bool flag = true;

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		CRefDes		= PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		create_wc_subckt_model = PCSchematicObject->CMSchematicObjectData.IsWorstCaseGenerator();

		PCSchematicObject->CMSchematicObjectData.GetWidthAndLength(width, height);// bining support
			
		CRecordName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.GetRecordName(width, height);

		if(!PCSchematicObject->user_tag) continue;
	
		int property_view = PCSchematicObject->CMSchematicObjectData.component_property_view_type;

		// symbols with file names have circuits and are included as a full netlist file

		if(PCSchematicObject->CMSchematicObjectData.attached_model_type != E_SPICE_SCHEMATIC)
		if(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.use_model)
		{
			if(!AddModelLine(PCSchematicObject))
			{
				flag = false;

				CString CMsg;

				CMsg.LoadString(IDS_UNABLE_TO_FIND_MODEL);

				CError.Format("%s %s for %s", CMsg, PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName, CRefDes);

				if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_WARNING, CError);
			}
		}
		else if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES ||
			    CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE)// 
		{
			if(property_view == E_PROPERTY_RESISTOR || property_view == E_PROPERTY_CAPACITOR || 
			   property_view == E_PROPERTY_INDUCTOR || create_wc_subckt_model)
			{
				AddVirtualModelLine(PCSchematicObject);
			}
		}
	}
	
	if(m_include_ad_conversion) AddADConversionModels();

	return	SaveModels();
}

void TCNetList::AddADConversionModels(void)
{
	CString CModelName = CMAnalysisSetup.CReRun.GetADConversionModelName();

	TCNetListLine CNetListLine;
	CArray <CString, CString&> CTextArray;
	int p, count;
	double voltage = MKSStringToFloat(CMAnalysisSetup.CReRun.CReserved.CStringArray[E_ADC_VOLTAGE]);

	double capacitance = CMAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_INPUT_CAPACITANCE];

	if(!(capacitance > 0)) capacitance = 1.0e-12;

	double trf_delay = CMAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_T_RISE_FALL_DELAY];

	count = 5;

	CTextArray.SetSize(count);

	CTextArray[0] = ".subckt " + CModelName + " ain $dout";
	CTextArray[1] = "c1 ain 0 " + FloatToSpiceMKSString(capacitance);
	CTextArray[2] = "a1 [ain] [$dout] adc";

	CTextArray[3] = ".model adc adc_bridge(in_low=";
	CTextArray[3] += FloatToSpiceMKSString(voltage/2 - 1e-3);
	CTextArray[3] += " in_high=";
	CTextArray[3] += FloatToSpiceMKSString(voltage/2 + 1e-3);
	CTextArray[3] += " rise_delay=";
	CTextArray[3] += FloatToSpiceMKSString(trf_delay);
	CTextArray[3] += " fall_delay=";
	CTextArray[3] += FloatToSpiceMKSString(trf_delay);
	CTextArray[3] += ')';
	CTextArray[4] = ".ends";

	for(p = 0; p < count; p++)
	{
		CNetListLine.CLine = CTextArray[p];

		CMModelLines.Add(CNetListLine.CLine);
	}

	CNetListLine.CLine = "";

	CMModelLines.Add(CNetListLine.CLine);
	
	double resistance = CMAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_OUTPUT_RESISTANCE];

	if(!(resistance > 0)) resistance = 1.0;

	CModelName.Replace("A/D", "D/A");

	CTextArray[0] = ".subckt " + CModelName + " #din aout";
	CTextArray[1] = "r1 1 aout " + FloatToSpiceMKSString(resistance);
	CTextArray[2] = "a1 [#din] [1] dac";
	CTextArray[3] = ".model dac dac_bridge(out_low=0.0 out_high=";
	CTextArray[3] += FloatToSpiceMKSString(voltage);
	CTextArray[3] += " t_rise=";
	CTextArray[3] += FloatToSpiceMKSString(trf_delay);
	CTextArray[3] += " t_fall=";
	CTextArray[3] += FloatToSpiceMKSString(trf_delay);
	CTextArray[3] += ')';
	CTextArray[4] = ".ends";

	for(p = 0; p < count; p++)
	{
		CNetListLine.CLine = CTextArray[p];

		CMModelLines.Add(CNetListLine.CLine);
	}

	CNetListLine.CLine = "";

	CMModelLines.Add(CNetListLine.CLine);
}

bool TCNetList::AddModelLine(TCSchematicObject *PCSchematicObject)
{
	TCNetListLine CNetListLine;

	CArray <CString, CString&> CTextArray;
	int p, count;
	double width=0, length=0;
	CString CSymbolParameters;

	CString CReRunName;
	CString CRunType;
	CString CSchematicParameters;

	if(!PCSchematicObject) return false;

	if(!PCMDoc)
	{
		ASSERT(0);
	}


	CString	CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);
	CString SweepRefDes = CMAnalysisSetup.CParametricSetupData.CSource;

	// Parameters in models and MC support
	CSymbolParameters = PCSchematicObject->CMSchematicObjectData.GetSymbolParameters();

	//Don't mess with orginal
	TCSpiceParameters CSpiceParameters = PCSchematicObject->CMSchematicObjectData.CSpiceParameters;

	PCSchematicObject->CMSchematicObjectData.GetWidthAndLength(width, length);// bining support

	CSpiceParameters.CDataBaseIdInfo.CRecordName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.GetRecordName(width, length);

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters);

	if(!PCSpiceParameters) return false;

	CString CLocalRecordType = CSpiceParameters.CDataBaseIdInfo.CRecordType;

	CLocalRecordType.MakeLower();
	
	if(CLocalRecordType ==  "b" || CLocalRecordType == "e" || CLocalRecordType == "g" || CLocalRecordType == "h" || CLocalRecordType == "f") return true;// don't add model statments for E, G, F, H sources

	CSpiceParameters = *PCSpiceParameters;

	CSchematicParameters = PCSchematicObject->CMSchematicObjectData.GetSchematicParameters() + ' ';

	CSpiceParameters.CSymbolParameters = CSchematicParameters;
	
	CSpiceParameters.CSymbolParameters += CSymbolParameters;// Allows model expressions to be evaluated for WC/MC

	// changed to support parameter sweeps on a specific corner
	if(CMAnalysisSetup.CParametricSetupData.CSweepData.enable || CMAnalysisSetup.CReRun.enable )
//	if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES || CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) 
	{
		int type = CMAnalysisSetup.CReRun.GetModifiedSpiceModelType(CSpiceParameters.CDataBaseIdInfo.CRecordType);

		if(type == E_WC_SUBCKT)// model of type, e.g. NPN in subckt.
		{
			type = CMAnalysisSetup.CReRun.GetSubcktSpiceModelType(CSpiceParameters.CSubcktModelType);
		}

		if(type < CMAnalysisSetup.CReRun.CRunType.GetSize())// each spice type w, n or strong etc
		{
			CRunType = CMAnalysisSetup.CReRun.CRunType[type];

			if(CRunType != "") // for reruns, override the model name with the required model
			{
				CString	CRecordName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.GetRecordName(width, length);

				CString COrgName = CRecordName;

				CRecordName = CRecordName.Left(CRecordName.GetLength() - 3);

				CReRunName = CRecordName;

				CRecordName += CRunType;

				CSpiceParameters.Rename(CRecordName);// get required model parameters

				// changed to support parameter sweeps on a specific corner
//				PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters, CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES || CMAnalysisSetup.CParametricSetupData.CSweepData.enable && !CMAnalysisSetup.CReRun.xspice_param_run_mode);

				PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters, CMAnalysisSetup.CReRun.enable ||
					                CMAnalysisSetup.CParametricSetupData.CSweepData.enable );

				if(!PCSpiceParameters && type == E_WC_SUBCKT) //
				{
					CString CMessage, CMsg, CMsg2;

					CMsg.LoadString(IDS_UNABLE_TO_FIND_SUBCKT_MODEL);

					CMsg2.LoadString(IDS_EXISTING_MODEL_USED);

					CMessage = CMsg + " " + CRecordName + CMsg2;

					CSpiceParameters.Rename(COrgName);//Replace original name

					if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_WARNING, CMessage, -1);
				}
			}
			else CReRunName = CSpiceParameters.CDataBaseIdInfo.CRecordName;
		}
	}

	// changed to support parameter sweeps on a specific corner
	// reget the correct model from new model name
//	PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters, (CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES) || (CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) );

	PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters, CMAnalysisSetup.CReRun.enable || CMAnalysisSetup.CParametricSetupData.CSweepData.enable);

	if(!PCSpiceParameters) return false;

	CSpiceParameters = *PCSpiceParameters;

//	CSpiceParameters.CSymbolParameters = CSchematicParameters + CSymbolParameters;// Allows model expressions to be evaluated for WC/MC

	// changed to support parameter sweeps on a specific corner
//	if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES || CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE)
	if(CMAnalysisSetup.CReRun.enable || CMAnalysisSetup.CParametricSetupData.CSweepData.enable) 
	{
		CString CMessage = "* Model ";
		CString CTempName = CReRunName;

		if(CRunType != "")
			CReRunName += "_XN"; // clean up of names, make WC model name be type _XN

		CMessage += CReRunName + " ";

		CMessage += "is data from model " + CTempName + CRunType;

		CSpiceParameters.Rename(CReRunName);

		CNetListLine.CLine = CMessage;

		CMModelLines.Add(CNetListLine.CLine);
	}
			
	CString CSymbolParameterLine;

//	CSpiceParameters.CSymbolParameters = CSymbolParameters;// Allows model expressions to be evaluated for WC/MC

	// Preprocess symbol params with the schematic diffined params
	
	CSchematicParameters = PCSchematicObject->CMSchematicObjectData.GetSchematicParameters();

	CSymbolParameters = CSpiceParameters.EvaluateParameterLine(CSchematicParameters, CSymbolParameters);

	CSpiceParameters.CSymbolParameters = CSymbolParameters;// Allows model expressions to be evaluated for WC/MC

	if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT)
		CSpiceParameters.EvaluateSubcktParameters("", CSymbolParameters); // unique subckt support July 2012, additional parameter added

	if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_MODEL)
		CSpiceParameters.EvaluateModelParameters(CSymbolParameters);

	if(PCSchematicObject->CMSchematicObjectData.is_unique_model)
	{
		CSpiceParameters.CDataBaseIdInfo.CRecordName = CRefDes + CSpiceParameters.CDataBaseIdInfo.CRecordName;
	}

	if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT)
	{		
		CString CTemp1, CTemp2;

		CTemp1 = PCSchematicObject->CMSchematicObjectData.GetSubCktValue();

		CTemp2 = RemoveFirstWord(CSpiceParameters.CData[0].CName);// .subckt

		CTemp2 = RemoveFirstWord(CTemp2);// pin list left

		CTemp1 = ".SUBCKT " + CTemp1 + " " + CTemp2;

		CSpiceParameters.CData[0].CName = CTemp1;
	}

	CSpiceParameters.GetToText(CTextArray, true, false);//use exponent

	count = CTextArray.GetSize();

	for(p = 0; p < count; p++)
	{
		CNetListLine.CLine = CTextArray[p];

		CMModelLines.Add(CNetListLine.CLine);
	}

	CNetListLine.CLine = "";

	CMModelLines.Add(CNetListLine.CLine);

	return true;
}

bool TCNetList::AddVirtualModelLine(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return false;

	TCNetListLine CNetListLine;

	CArray <CString, CString&> CTextArray;
	int p, count;

	if(!PCSchematicObject->GetVirtualParameterModel(CTextArray, CMAnalysisSetup)) return false;

	count = CTextArray.GetSize();

	for(p = 0; p < count; p++)
	{
		CNetListLine.CLine = CTextArray[p];

		CMModelLines.Add(CNetListLine.CLine);
	}

	CNetListLine.CLine = "";

	CMModelLines.Add(CNetListLine.CLine);

	return true;
}

void TCNetList::SetSchematicTags(bool state)
{
	TCSchematicObject	*PCSchematicObject;

	int count = CMAllSchematicComponentsList.GetSize();
	int p;

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		PCSchematicObject->user_tag = state;
	}
}

bool TCNetList::CreateDotLines(void)
{
	CString	CNetListLine;
	CString	CText;
	int		count;
	int		index;

	// Spice options

	count = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize();
	char CType;
	CString CTempTest;

	int p;

	for(p = 0; p < count; p++)
	{
		TCSpiceOptionsData &CSpiceOptionsData = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[p];

		TCSpiceOptionsData &CSpiceOptionsDataDyamicStepping = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_VARGMIN];

		if(p == E_OPTIONS_TEMP)  CSpiceOptionsData.m_include = true;//always needed

		if(p == E_OPTIONS_DESIGNER_CURRENT_ACCURACY || p == E_OPTIONS_DESIGNER_VOLTAGE_ACCURACY) continue;// need at start of netlist

		if(!CSpiceOptionsData.m_include) continue;

		if(CSpiceOptionsData.SpiceName == "VARGMIN")  // allow orginal code as fullback
			if(CSpiceOptionsData.value == 0)
				continue;

		CTempTest = CSpiceOptionsData.SpiceName;
		CNetListLine = ".OPTIONS ";
		CNetListLine += CTempTest;
		CNetListLine += "=";

		CTempTest.TrimLeft();
		CTempTest.TrimRight();
		CTempTest.MakeLower();

		if((CMAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES && 
		   CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type != E_PARAMETER_RUN_MODE_MODEL_FILE)
			|| "temp" != CTempTest)
		{
			if(p != E_OPTIONS_GMINSTEPPING && p != E_OPTIONS_SOURCE_STEPPING) // need to overide static gmin/source stepping values option
			{
				CText = FloatToSpiceMKSString((float)CSpiceOptionsData.value);
			}
			else
			{
				if(CSpiceOptionsData.value != 0 && CSpiceOptionsDataDyamicStepping.m_include)// overide# steps
				{
					CText = "1";// engages dynamic gmin/source stepping
				}
				else // if gmin or source stepps = 0, use that value to turn of respective stepping
				{
					CText = FloatToSpiceMKSString((float)CSpiceOptionsData.value);
				}
			}
		}
		else
		{
			int size_check = CMAnalysisSetup.CReRun.CRunType.GetSize();

			if(E_SPICE_TEMP < size_check)
			{
				CString CRunType = CMAnalysisSetup.CReRun.CRunType[E_SPICE_TEMP];

				if(CRunType == "") CType ='N';
				else CType = CRunType.GetAt(0);

				if(CType == 'S')CText = FloatToSpiceMKSString((float)CMAnalysisSetup.CReRun.temp_max);
				else if (CType == 'W') CText = FloatToSpiceMKSString((float)CMAnalysisSetup.CReRun.temp_min);
				else CText = FloatToSpiceMKSString((float)CMAnalysisSetup.CReRun.temp_nominal);
			}
			else
			{
				if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_WARNING, IDS_WC_TEMP_WARNING);

				TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMAnalysisSetup.CBerklySpiceOptionsSetupData;

				CText.Format("%f", CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value);
			}
		}

		CNetListLine += CText + " ";
		
		CMModelLines.Add(CNetListLine);
	}

	count = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsStringData.GetSize();

	CString CTempText;

	for(p = 0; p < count; p++)
	{
		TCSpiceOptionsData &CSpiceOptionsData = CMAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsStringData[p];

		if(!CSpiceOptionsData.m_include) continue;

		if(CSpiceOptionsData.SpiceName == "")  continue;

		if(CSpiceOptionsData.SpiceName.GetAt(0) != '.') CNetListLine = ".OPTIONS ";	
		else CNetListLine = "";

		CTempText = CSpiceOptionsData.SpiceName;
	
		CTempText.TrimRight();
		CTempText.TrimLeft();
		CTempText.MakeUpper();

		if(CTempText == "RSHUNT")
			CSpiceOptionsData.CValue = MKSStringToSpiceMKSString(CSpiceOptionsData.CValue);

		CText = CSpiceOptionsData.CValue;

		CText.TrimLeft();
		CText.MakeUpper();

		if(CText == "")
		{
			CNetListLine += CSpiceOptionsData.SpiceName;//Make spice statement
		}
		else
		{
			CNetListLine += CSpiceOptionsData.SpiceName;
			CNetListLine += "=" + CText;
		}

		CMModelLines.Add(CNetListLine);
	}

	if(m_include_ad_conversion)//only one type of run allowed at a time for digital
	{
		bool flag = false;

		CNetListLine = ".OPTIONS ADCV=";

		CNetListLine += MKSStringToSpiceMKSString(CMAnalysisSetup.CReRun.CReserved.CStringArray[E_ADC_VOLTAGE]);

		CMModelLines.Add(CNetListLine);

		if(CMAnalysisSetup.CTransientSetupData.CSweepData.enable)
		{
			CMAnalysisSetup.CDCSetupData.enable_operating_point = 0;
			CMAnalysisSetup.CDCSetupData.CSweepData1.enable = 0;
			CMAnalysisSetup.CACSetupData.CSweepData.enable = 0;
		}
		else if(CMAnalysisSetup.CDCSetupData.CSweepData1.enable)
		{
			CMAnalysisSetup.CDCSetupData.enable_operating_point = 0;
			CMAnalysisSetup.CACSetupData.CSweepData.enable = 0;
		}
		else if(CMAnalysisSetup.CACSetupData.CSweepData.enable)
		{
			CMAnalysisSetup.CDCSetupData.enable_operating_point = 0;
		}

		if(flag) 
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_WARNING, IDS_ONE_DIGITAL_RUN_TYPE_ONLY, 0);
		}
	}

	if(CMAnalysisSetup.CDCSetupData.enable_operating_point || CMAnalysisSetup.CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT])
	{
		CNetListLine = ".OP";
		CMModelLines.Add(CNetListLine);
	}

	if(CMAnalysisSetup.CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT]) return true;

	if(!CMAnalysisSetup.CTemperatureSetupData.CSweepData.enable || CMAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type != E_TEMPERATURE_SWEEP_VOLTS_V_TEMP)
	if(CMAnalysisSetup.CDCSetupData.CSweepData1.enable || 
	   CMAnalysisSetup.CDCSetupData.CSweepData2.enable)
	{
		CNetListLine = ".DC ";

		double stop;
		double step;
		double start;

		if(CMAnalysisSetup.CDCSetupData.CSweepData1.enable)
		{
			CMAnalysisSetup.CDCSetupData.CSource1.TrimLeft();
			CMAnalysisSetup.CDCSetupData.CSource1.TrimRight();

			if(CMAnalysisSetup.CDCSetupData.CSource1 == "") 
			{
				if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, IDS_NO_DC_SOURCE, 0);

				return false;
			}

			CNetListLine += CMAnalysisSetup.CDCSetupData.CSource1 + " ";

			start = CMAnalysisSetup.CDCSetupData.CSweepData1.start;

			if(!CMAnalysisSetup.CDCSetupData.CSweepData1.type)
			{
				if(!start) 
				{
					start = 1e-6;

					PCMDoc->DisplayError(IDS_ERR_WARNING, "Start point cannot be zero, set to 1e-6");
				}
			}

			CMAnalysisSetup.CDCSetupData.CSweepData1.start = start;

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CDCSetupData.CSweepData1.start);
			CNetListLine += CText + " ";

			stop = CMAnalysisSetup.CDCSetupData.CSweepData1.stop;
			step = CMAnalysisSetup.CDCSetupData.CSweepData1.step;

			if(CMAnalysisSetup.CDCSetupData.CSweepData1.type)
			{
				if(stop < 0) stop -= step * 0.99/2;//  0 to 1, step .1 stops at .9 in spice, force extra step
				else stop += step * 0.99/2;
			}
			
			CText = FloatToSpiceMKSString(stop);
			CNetListLine += CText + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CDCSetupData.CSweepData1.step);
			CNetListLine += CText + " ";

			if(!CMAnalysisSetup.CDCSetupData.CSweepData1.type)// decades = 0, steps = 2, 1 unused octaves
			{
				CText = "DEC";

				CNetListLine += CText + " ";
			}
		}

		if(CMAnalysisSetup.CDCSetupData.CSweepData2.enable)
		{
			CMAnalysisSetup.CDCSetupData.CSource2.TrimLeft();
			CMAnalysisSetup.CDCSetupData.CSource2.TrimRight();

			if(CMAnalysisSetup.CDCSetupData.CSource2 == "") 
			{
				if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_ERROR, IDS_NO_DC_SOURCE);

				return false;
			}

			CNetListLine += CMAnalysisSetup.CDCSetupData.CSource2 + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CDCSetupData.CSweepData2.start);
			CNetListLine += CText + " ";

			stop = CMAnalysisSetup.CDCSetupData.CSweepData2.stop;
			step = CMAnalysisSetup.CDCSetupData.CSweepData2.step;

			CText = FloatToSpiceMKSString(stop);

			CNetListLine += CText + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CDCSetupData.CSweepData2.step);
			CNetListLine += CText + " ";
		}

		CMModelLines.Add(CNetListLine);

		if(CMAnalysisSetup.CDCSetupData.enable_print_all) AddDotOutputStaticTypes(".PRINT", "DC");
		if(CMAnalysisSetup.CDCSetupData.enable_plot_all) AddDotOutputStaticTypes(".PLOT", "DC");
	}

	if(CMAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_VOLTS_V_TEMP)
	{
		CNetListLine = ".DC ";

		double stop;
		double step;
		double start;

		CString CVoltSourceName = "Temp";

		if(CMAnalysisSetup.CTemperatureSetupData.CSweepData.enable)
		{
			start = CMAnalysisSetup.CTemperatureSetupData.CSweepData.start;
			stop = CMAnalysisSetup.CTemperatureSetupData.CSweepData.stop;
			step = CMAnalysisSetup.CTemperatureSetupData.CSweepData.step;

			if(!CMAnalysisSetup.CDCSetupData.CSweepData1.type)
			{
				if(!start) 
				{
					start = 1e-6;

					PCMDoc->DisplayError(IDS_ERR_WARNING, "Start point cannot be zero, set to 1e-6");
				}
			}

			CMAnalysisSetup.CDCSetupData.CSweepData1.start = start;

			CNetListLine += CVoltSourceName + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CTemperatureSetupData.CSweepData.start);
			CNetListLine += CText + " ";

			if(CMAnalysisSetup.CDCSetupData.CSweepData1.type)
			{
				if(stop < 0) stop -= step * 0.99/2;//  0 to 1, step .1 stops at .9 in spice, force extra step
				else stop += step * 0.99/2;
			}
			
			CText = FloatToSpiceMKSString(stop);
			CNetListLine += CText + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CTemperatureSetupData.CSweepData.step);
			CNetListLine += CText + " ";

			if(!CMAnalysisSetup.CTemperatureSetupData.CSweepData.type)// decades = 0, lin steps = 1
			{
				CText = "DEC";

				CNetListLine += CText + " ";
			}

			CMModelLines.Add(CNetListLine);
		}
	}

	if(CMAnalysisSetup.CACSetupData.CSweepData.enable)
	{
		CNetListLine = ".AC ";
		CNetListLine += CMSweepTypeList[CMAnalysisSetup.CACSetupData.CSweepData.type];

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.step);
		CNetListLine += CText + " ";

		if(CMAnalysisSetup.CACSetupData.CSweepData.start <= 0) CMAnalysisSetup.CACSetupData.CSweepData.start = 1e-3;
		if(CMAnalysisSetup.CACSetupData.CSweepData.stop <= 0) CMAnalysisSetup.CACSetupData.CSweepData.stop = 1;

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.start);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.stop);
		CNetListLine += CText;

		if(CMAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_FREQ_DEVICE_MODE])// Sweep device, not frequency
		{
			CNetListLine += " " + CMAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE];

			CText = MKSStringToSpiceMKSString(CMAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE_FREQ]);

			CNetListLine += " x "; // Select other params to do.

			CNetListLine += CText;
		}

		CMModelLines.Add(CNetListLine);
			
		if(CMAnalysisSetup.CACSetupData.enable_print_all) AddDotPrintPlotACTypes(".PRINT", "AC");
		if(CMAnalysisSetup.CACSetupData.enable_plot_all) AddDotPrintPlotACTypes(".PLOT", "AC");
	}

	if(CMAnalysisSetup.CNoiseSetupData.enable)
	{
		CString CTempText;
		int bracket_index;

		if(!CMAnalysisSetup.CStaticOutputList.CData.GetSize()) 
		{
			CGlobalStatusMessage = "The noise analysis setup is invalid";

			return false;
		}

		CNetListLine = ".NOISE ";

		index = CMAnalysisSetup.CNoiseSetupData.output_index;

		if(!(index < CMAnalysisSetup.CStaticOutputList.CData.GetSize()))// not used
		{
			CMAnalysisSetup.CNoiseSetupData.output_index = 0;
			index = 0;
		}

		CTempText = CMAnalysisSetup.CNoiseSetupData.COutput;

		bracket_index = CTempText.Find('(');

		if(bracket_index < 0)
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_INVALID_OUTPUT_NOISE_NODE);

			return false;
		}
		//extract node name
		CTempText = CTempText.Right(CTempText.GetLength() - bracket_index); // remove V/I 
		CTempText.Remove('(');
		CTempText.Remove(')');
		
		if(!FindNode(CTempText))
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_INVALID_OUTPUT_NOISE_NODE);

			return false;
		}

//		CNetListLine += CMAnalysisSetup.CStaticOutputList.CData[index].CSpiceName + " ";
		CNetListLine += CMAnalysisSetup.CNoiseSetupData.COutput + " ";
		CNetListLine += CMAnalysisSetup.CNoiseSetupData.CSource + " ";


		CNetListLine += CMSweepTypeList[CMAnalysisSetup.CACSetupData.CSweepData.type] + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.step);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.start);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.stop);
		CNetListLine += CText;

		if(CMAnalysisSetup.CNoiseSetupData.enable_summary)
				CNetListLine += " " + CMAnalysisSetup.CNoiseSetupData.CSummaryPoints;


		CMModelLines.Add(CNetListLine);

		if(CMAnalysisSetup.CNoiseSetupData.enable_print_all)
		{
			CNetListLine = ".PRINT NOISE INOISE ONOISE";

			CMModelLines.Add(CNetListLine);
		}
		if(CMAnalysisSetup.CNoiseSetupData.enable_plot_all)
		{
			CNetListLine = ".PLOT NOISE INOISE ONOISE";
			CMModelLines.Add(CNetListLine);
		}
	}

	if(CMAnalysisSetup.CParametricSetupData.CSweepData.enable)
	{
		if(CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_EXTERNAL_FILE)
		{
			CNetListLine = ".ReRuns " + CMAnalysisSetup.CParametricSetupData.CValue;

			CMModelLines.Add(CNetListLine);
		}
		
		if(CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_INTERNAL_FILE)
		{
			CString CFileName = CMAnalysisSetup.CSchematicName;

			CFileName = RemoveExtention(CFileName);

			CFileName += "RRN.rrn";

			CNetListLine = ".ReRuns " + CFileName;

			CMModelLines.Add(CNetListLine);
		}
	}

	if(PCMDoc)
	if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CString CFileName = RemoveExtention(PCMDoc->CThisFileName);

		CFileName += "MC.rrn";

		CNetListLine = ".ReRuns " + CFileName;

		CMModelLines.Add(CNetListLine);
	}

	if(PCMDoc)
	if(CMAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE)
	{
		CString CFileName = RemoveExtention(PCMDoc->CThisFileName);

		CFileName += "WC.rrn";

		CNetListLine = ".ReRuns " + CFileName;

		CMModelLines.Add(CNetListLine);
	}

	if(CMAnalysisSetup.CSensitivitySetupData.enable_ac)
	{
		CNetListLine = ".SENS ";

		index = CMAnalysisSetup.CSensitivitySetupData.ac_output_index;

		if(index < CMAnalysisSetup.CStaticOutputList.CData.GetSize() && index > -1)
		{
			CNetListLine += CMAnalysisSetup.CStaticOutputList.CData[index].CSpiceName + " ";

			CNetListLine += "AC ";//AC sens

			CNetListLine += CMSweepTypeList[CMAnalysisSetup.CACSetupData.CSweepData.type];

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.step);
			CNetListLine += CText + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.start);
			CNetListLine += CText + " ";

			CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.stop);
			CNetListLine += CText;
			CMModelLines.Add(CNetListLine);
		}
		else
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_WARNING, IDS_NOAC_SENS_NODE);
		}
	}
	if(CMAnalysisSetup.CSensitivitySetupData.enable_dc)
	{	
		index = CMAnalysisSetup.CSensitivitySetupData.dc_output_index; 

		if(index < CMAnalysisSetup.CStaticOutputList.CData.GetSize() && index > -1)
		{
			CNetListLine = ".SENS ";

			CText = CMAnalysisSetup.CStaticOutputList.CData[index].CSpiceName;

			CNetListLine += CText;

			CMModelLines.Add(CNetListLine);
		}
		else
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_WARNING, IDS_NODC_SENS_NODE);
		}
	}
//		if(CMAnalysisSetup.CSensitivitySetupData.enable_print_all) // to do

	if(CMAnalysisSetup.CPoleZeroSetupData.enable)
	{ 
		bool f_pole_zero = false;

		CNetListLine = ".PZ ";
		CNetListLine += CMAnalysisSetup.CPoleZeroSetupData.CSource1 + "  ";
		CNetListLine += CMAnalysisSetup.CPoleZeroSetupData.CSource2 + "  ";
		CNetListLine += CMAnalysisSetup.CPoleZeroSetupData.COutput1 + "  ";
		CNetListLine += CMAnalysisSetup.CPoleZeroSetupData.COutput2 + "  ";

		if(!FindNode(CMAnalysisSetup.CPoleZeroSetupData.CSource1)) 	f_pole_zero = true;
		if(!FindNode(CMAnalysisSetup.CPoleZeroSetupData.CSource2)) 	f_pole_zero = true;
		if(!FindNode(CMAnalysisSetup.CPoleZeroSetupData.COutput1)) 	f_pole_zero = true;
		if(!FindNode(CMAnalysisSetup.CPoleZeroSetupData.COutput1)) 	f_pole_zero = true;

		if(f_pole_zero)
		{
			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_INVALID_POLEZERO_NODES);

			return false;
		}

/*	This code is wrong. It looks aat net name!. Need extra radio buttion to determnine whether VOL or CUR is required
		if(CMAnalysisSetup.CPoleZeroSetupData.CSource1.GetAt(0) == 'I' ||
		   CMAnalysisSetup.CPoleZeroSetupData.CSource1.GetAt(0) == 'i')
		{
			CText = "CUR ";
		}
		else CText = "VOL ";*/

		CText = "VOL ";// default to Voltage/Voltage, current dont make sense

		CNetListLine += CText;

		if(CMAnalysisSetup.CPoleZeroSetupData.type == E_POLE_ONLY)
		{
			CText = "POL ";
		}
		else if(CMAnalysisSetup.CPoleZeroSetupData.type == E_ZERO_ONLY)
		{
			CText = "ZER ";
		}
		else
		{
			CText = "PZ ";
		}
		CNetListLine += CText;

		CMModelLines.Add(CNetListLine);
	}

	if(CMAnalysisSetup.CDistortionSetupData.enable)
	{
		CNetListLine = ".DISTO ";

		CNetListLine += CMSweepTypeList[CMAnalysisSetup.CACSetupData.CSweepData.type];

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.step);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.start);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CACSetupData.CSweepData.stop);
		CNetListLine += CText;

		if(CMAnalysisSetup.CDistortionSetupData.type)
		{
			CText = FloatToSpiceMKSString((float)CMAnalysisSetup.CDistortionSetupData.frequency);
			CNetListLine += " " + CText;
		}

		CMModelLines.Add(CNetListLine);

		CNetListLine = ".PRINT HD2 HD3";
//		if(CMAnalysisSetup.CDistortionSetupData.enable_print_all) AddDotOutputStaticTypes(".PRINT ", "DISTO");
//		if(CMAnalysisSetup.CDistortionSetupData.enable_plot_all) AddDotOutputStaticTypes(".PLOT ", "DISTO");
	}

	if(CMAnalysisSetup.CTransientSetupData.CSweepData.enable)
	{
		CNetListLine = ".TRAN ";

		//simplified transient setup
		CMAnalysisSetup.CTransientSetupData.max_calc_is_print_time = true;
		CMAnalysisSetup.CTransientSetupData.CSweepData.step = CMAnalysisSetup.CTransientSetupData.max_compute_step_size;

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CTransientSetupData.CSweepData.step);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CTransientSetupData.CSweepData.stop);
		CNetListLine += CText + " ";

		CText = FloatToSpiceMKSString(CMAnalysisSetup.CTransientSetupData.CSweepData.start);
		CNetListLine += CText + " ";

		if(!CMAnalysisSetup.CTransientSetupData.max_calc_is_print_time)
		{
			CText = FloatToSpiceMKSString(CMAnalysisSetup.CTransientSetupData.max_compute_step_size);
			CNetListLine += CText;
		}
		else
		{
			CText = FloatToSpiceMKSString(CMAnalysisSetup.CTransientSetupData.CSweepData.step);
			CNetListLine += CText + " ";
		}

		if(CMAnalysisSetup.CTransientSetupData.use_initial_conditions)
		{
			CNetListLine += " UIC";
		}

		CMModelLines.Add(CNetListLine);

		if(CMAnalysisSetup.CTransientSetupData.enable_print_all) AddDotOutputStaticTypes(".PRINT", "TRAN");
		if(CMAnalysisSetup.CTransientSetupData.enable_plot_all) AddDotOutputStaticTypes(".PLOT", "TRAN");
	}

	if(CMAnalysisSetup.CTransientSetupData.fourier_enable)
	{
		CNetListLine = ".FOUR ";

		CText = FloatToSpiceMKSString((float)CMAnalysisSetup.CTransientSetupData.frequency);
		CNetListLine += CText + " ";
		
		index = CMAnalysisSetup.CTransientSetupData.output_index;
	
		if(index < 0)
		{
			index = 0;

			if(PCMDoc) PCMDoc->DisplayError(IDS_NETLIST_WARNING, IDS_INVALID_FOUR_NODE, -1);//0 ->force message windo to be displayed
		}

		if(index < CMAnalysisSetup.CStaticOutputList.CData.GetSize())
			CNetListLine += CMAnalysisSetup.CStaticOutputList.CData[index].CSpiceName;

		CMModelLines.Add(CNetListLine);

		if(CMAnalysisSetup.CTransientSetupData.enable_print_all_fourier) AddDotPrintPlotACTypes(".PRINT", "FOUR");
		if(CMAnalysisSetup.CTransientSetupData.enable_plot_all_fourier) AddDotPrintPlotACTypes(".PLOT", "FOUR");
	}

	CMAnalysisSetup.CParametricSetupData;// handeled by program
	CMAnalysisSetup.CTemperatureSetupData;// handeled by program

	return true;
}

bool TCNetList::CreateSaveLines(void)
{
	TCNetListLine	CNetListLine;
	CString			CText, CTemp, CTempRef;
	int				next_line_count;
	int				index;

	if(CMAnalysisSetup.COutputSelectData.all_volts)
	{
		CNetListLine.CLine = ".SAVE ";// temp testing

		CNetListLine.CLine  += "all";

		if(top_level) CNetListLineList.Add(CNetListLine);
	}

	CString CTemp2;

	CString CTextTemp;

	//spice3 does not save subcircuit currents
	if(top_level || !GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.spice3_compatible ||
		GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
	if(CMAnalysisSetup.COutputSelectData.all_currents)
	{
		CNetListLine.CLine = ".SAVE ";

		int count = CMAnalysisSetup.CDeviceCurrentNodeList.CData.GetSize();

		next_line_count = 0;

		for(int p = 0; p < count; p++)
		{
			next_line_count++;

			CText = CMAnalysisSetup.CDeviceCurrentNodeList.CData[p].CUserName;

			if(IsParameterSwept(CText)) continue;

			CTemp		= CText;
			CTextTemp	= CText;

			index = CTemp.Find('[');

			CTemp = CTemp.Left(index);

			if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			{
				if(CParentRef != "") 
				{
					CTextTemp.Replace(CTemp, "");

					CTemp += ':' + CParentRef;

					CText = CTemp + CTextTemp;
				}
			}

			if(!FindRefDesignator(CTemp)) continue;
		
			CTempRef = CTemp.GetAt(0);

			if(CTempRef == 'B' || CTempRef == 'b') continue;// KA Oct 2017, quick fix

			CText = '@' + CText + ' ';

			CNetListLine.CLine  += CText;

			if(CNetListLine.CLine.GetLength() < 127 && (next_line_count < 8)) continue;

			CNetListLineList.Add(CNetListLine);

			CNetListLine.CLine = ".SAVE ";

			next_line_count = 0;			
		}

		if(CNetListLine.CLine != ".SAVE ")// ignore blnk lines
			CNetListLineList.Add(CNetListLine);
	}
//	else removed 8th Aug 2003 and changed to if()
	if(!CMAnalysisSetup.COutputSelectData.all_volts)
	{
		CNetListLine.CLine = ".SAVE ";

		int count = CMAnalysisSetup.COutputSelectData.CSpiceVoltAndCurrentList.GetSize();

		next_line_count = 0;

		for(int p = 0; p < count; p++)
		{
			next_line_count++;

			CText = CMAnalysisSetup.COutputSelectData.CSpiceVoltAndCurrentList[p];

			if(IsParameterSwept(CText)) continue;// dont generate the @V[i] for swept sources

			CTextTemp = CText;

			CTemp = CText;

			index = CTemp.Find('[');

			CTemp = CTemp.Left(index);

			if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			{
				if(CParentRef != "") 
				{
					CTextTemp.Replace(CTemp, "");

					CTemp += ':' + CParentRef;

					CText = CTemp + CTextTemp;
				}
			}

			if(!FindRefDesignator(CTemp)) continue;
			
			CTempRef = CTemp.GetAt(0);

			if(CTempRef == 'B' || CTempRef == 'b') continue;// KA Oct 2017, quick fix

			CText = '@' + CText + ' ';

			CNetListLine.CLine  += CText;

			if(CNetListLine.CLine.GetLength() < 127 && (next_line_count < 8)) continue;

			CNetListLineList.Add(CNetListLine);

			CNetListLine.CLine = ".SAVE ";

			next_line_count = 0;	
		}

		if(CNetListLine.CLine != ".SAVE ")// ignore blnk lines
			CNetListLineList.Add(CNetListLine);
	}

	return true;
}

bool  TCNetList::IsParameterSwept(CString CText)// to remove save lines for components not able to be probed
{
	if(CMAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES && 
	   CMAnalysisSetup.CParametricSetupData.CSweepData.sweep_type != E_PARAMETER_RUN_MODE_MODEL_FILE) return false;

	int index = CText.Find('[');

	if(index < 0) return false;

	CText = CText.Left(index);// recover the ref designator

	char type = CText.GetAt(0);

	if(type != 'V' && type != 'v') return false;

	CString CParameterName = CMAnalysisSetup.CParametricSetupData.CSource;

	if(CText != CParameterName) return false;

	return true;
}

int TCNetList::FindRefDesignator(CString CRefDes)
{
	int count = CNetListLineList.GetSize();

	if(!(net_lines_start_index < count)) net_lines_start_index = count - 1;

	if(net_lines_start_index < 0) return false;

	if(!(net_lines_stop_max_index < count)) net_lines_stop_max_index = count -1;

	if(!(net_lines_start_index < net_lines_stop_max_index)) return false;

	for(int p = net_lines_start_index; p < net_lines_stop_max_index; p++)
	{
		if(CNetListLineList[p].CRefDes == CRefDes) return p;
	}

	return false;
}

void TCNetList::AddDotPrintPlotACTypes(CString CSpiceType, CString CText)
{
	TCNetListLine	CNetListLine;
	int				count;
	
	count = CMAnalysisSetup.COutputList.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CNetListLine.CLine = CSpiceType + " " + CText + " ";

		CNetListLine.CLine += CMAnalysisSetup.COutputList.CData[p].CSpiceName;

		CNetListLineList.Add(CNetListLine);
	}
}
void TCNetList::AddDotOutputStaticTypes(CString CSpiceType, CString CText)
{
	TCNetListLine	CNetListLine;
	int				count;
	
	count = CMAnalysisSetup.CStaticOutputList.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CNetListLine.CLine = CSpiceType + " " + CText + " ";

		CNetListLine.CLine += CMAnalysisSetup.CStaticOutputList.CData[p].CSpiceName;

		CNetListLineList.Add(CNetListLine);
	}
}

bool TCNetList::CreateControlLines(void)
{
	if(!GCAuthorization.m_authorized2) HDCMDestCmp = NULL;// this will cause superspice to do strange things
	
	TCNetListLine	CNetListLine;

	CNetListLine.CLine = "";
	CNetListLineList.Add(CNetListLine);

	CNetListLine.CLine = ".control";
	CNetListLineList.Add(CNetListLine);

	CNetListLine.CLine = "set filetype=";

	// Wrong, 24th Dec 2016
//	if(GCSuperSpiceGlobalData.CAnalysisSetup.COutputSelectData.text_file_type)
	if(CMAnalysisSetup.COutputSelectData.text_file_type)// added 24th Dec 2016
		CNetListLine.CLine += "ascii";
	else CNetListLine.CLine += "binary";

	CNetListLineList.Add(CNetListLine);

	CNetListLine.CLine = ".endc";
	CNetListLineList.Add(CNetListLine);

	return true;
}

bool TCNetList::SimulationSetupCheck(void)
{
	int p, q;
	CString CText, CRefDes, CRefDesComponent;
	TCSchematicObject	*PCSchematicObject;

	int count = CMAnalysisSetup.CSourceList.CData.GetSize();

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.check_for_vi_sources) return true;

	if(!count)
	{
		if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_NO_VOLTS_OR_CURRENT);

		return false;
	}

	int component_count = CMAllSchematicComponentsList.GetSize();

	bool f_ac_found = false;
	bool f_dc_found = false;
	bool f_op_found = false;
	bool f_noise_found = false;

	for(p = 0; p < component_count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		CRefDesComponent = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		if(CMAnalysisSetup.CDCSetupData.enable_operating_point)//check for valid OP setup data.
		{
			for(q = 0; q < count; q++) // Are there any dc generators.
			{
				TCOutput &COutput = CMAnalysisSetup.CSourceList.CData[q];

				CRefDes = COutput.CSpiceName;

				if(CRefDesComponent != CRefDes) continue;

				if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) continue;

				f_op_found = true;

				break;
			}
		}
		else f_op_found = true;

		if(CMAnalysisSetup.CDCSetupData.CSweepData1.enable)//check for valid DC setup data.
		{
			for(q = 0; q < count; q++) // Are there any dc generators.
			{
				TCOutput &COutput = CMAnalysisSetup.CSourceList.CData[q];

				CRefDes = COutput.CSpiceName;

				if(CRefDesComponent != CRefDes) continue;

				if(CMAnalysisSetup.CDCSetupData.CSource1.GetAt(0) != 'r' && 
				   CMAnalysisSetup.CDCSetupData.CSource1.GetAt(0) != 'R')
				{
					if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) continue;

				
					if(CRefDesComponent != CMAnalysisSetup.CDCSetupData.CSource1) continue;
				}

				f_dc_found = true;

				break;
			}
		}
		else f_dc_found = true;

		if(CMAnalysisSetup.CACSetupData.CSweepData.enable)//check for valid AC setup data.
		{
			for(q = 0; q < count; q++) // Are there any ac generators set with non-zero ac.
			{
				TCOutput &COutput = CMAnalysisSetup.CSourceList.CData[q];

				CRefDes = COutput.CSpiceName;

				if(CRefDesComponent != CRefDes) continue;

				if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) continue;

				if(PCSchematicObject->CMSchematicObjectData.PCGeneratorData->CDCGeneratorData.CACVoltage == "") continue;

				f_ac_found = true;
				
				break;
			}
		}
		else f_ac_found = true;

		if(CMAnalysisSetup.CNoiseSetupData.enable)//check for valid Noise setup data.
		{
			for(q = 0; q < count; q++) // Are there any ac generators matching noise spec. 
			{
				TCOutput &COutput = CMAnalysisSetup.CSourceList.CData[q];

				CRefDes = COutput.CSpiceName;

				if(CRefDesComponent != CRefDes) continue;

				if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) continue;

				if(CMAnalysisSetup.CNoiseSetupData.CSource != CRefDes) continue;

				f_noise_found = true;

				break;
			}
		}
		else f_noise_found = true;
	}


	if(!f_op_found)
	{
		if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_NO_OPSRC_FOUND);

		return false;
	}

	if(!f_dc_found)
	{
		if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_NODCSRCFOUND);

		return false;
	}

	if(!f_ac_found)
	{
		if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_NOACSRCFOUND);

		return false;
	}

	if(!f_noise_found)
	{
		if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, IDS_INVALID_NOISE_ANAL);

		return false;
	}

	return true;
}

bool TCNetList::SimulationElectricalCheck(void)
{
	if(!CheckForShortedInductersAndVoltageSources()) return false;

	return true;
}

bool TCNetList::CheckForShortedInductersAndVoltageSources(void)
{
	TCSchematicObject	*PCSchematicObject, *PCNewSchematicObject;

	int component_count = CMAllSchematicComponentsList.GetSize();

	CString CRefDesComponent, CNewRefDesComponent, CPinNode1, CPinNode2, CNewPinNode1, CNewPinNode2, CMsg;
	bool flag = true;

	for(int p = 0; p < component_count; p++)
	{
		PCSchematicObject = CMAllSchematicComponentsList[p];

		if(PCSchematicObject->CMSchematicObjectData.component_property_view_type != E_PROPERTY_INDUCTOR &&
			(PCSchematicObject->CMSchematicObjectData.component_property_view_type < E_PROPERTY_DC_VOLTAGE_SOURCE ||
			PCSchematicObject->CMSchematicObjectData.component_property_view_type > E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM)) continue;

		CPinNode1 = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
		CPinNode2 = PCSchematicObject->GetPinLabel(1, E_COMPONENT_PIN_NET_NAME);

		if(CPinNode1 == "") continue;
		if(CPinNode2 == "") continue;

		CRefDesComponent = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		if(CPinNode1 == CPinNode2) //s/c itself
		{
			flag = false;

			CMsg = CRefDesComponent + " is s/c";

			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, CMsg);

			continue;
		}

		for(int q = 0; q < component_count; q++)
		{
			PCNewSchematicObject = CMAllSchematicComponentsList[q];

			if(PCNewSchematicObject->CMSchematicObjectData.component_property_view_type != E_PROPERTY_INDUCTOR &&
			   (PCNewSchematicObject->CMSchematicObjectData.component_property_view_type < E_PROPERTY_DC_VOLTAGE_SOURCE ||
			   PCNewSchematicObject->CMSchematicObjectData.component_property_view_type > E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM)) continue;

			CNewPinNode1 = PCNewSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
			CNewPinNode2 = PCNewSchematicObject->GetPinLabel(1, E_COMPONENT_PIN_NET_NAME);

			if(CNewPinNode1 == "") continue;
			if(CNewPinNode2 == "") continue;

			if(PCSchematicObject == PCNewSchematicObject) continue;

			if(CPinNode1 != CNewPinNode1 && CPinNode1 != CNewPinNode2) continue;
			if(CPinNode2 != CNewPinNode1 && CPinNode2 != CNewPinNode2) continue;

			if(CPinNode1 == CNewPinNode1)
				if(CPinNode2 != CNewPinNode2) continue;

			if(CPinNode2 == CNewPinNode1)
				if(CPinNode1 != CNewPinNode2) continue;

			CNewRefDesComponent = PCNewSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

			flag = false;

			CMsg = CRefDesComponent + " is s/c by " + CNewRefDesComponent;

			if(PCMDoc) PCMDoc->DisplayError(IDS_ERR_ERROR, CMsg);
		}	
	}

	return flag;
}