// TCNetList.h: interface for the TCNetList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TCNETLIST_H__D0AF9FA2_4B16_11D2_AD63_886A0BC10000__INCLUDED_)
#define AFX_TCNETLIST_H__D0AF9FA2_4B16_11D2_AD63_886A0BC10000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxtempl.h>
class TCSchematicManager;

#include "TCFileFunctions.h"
#include "TEPCBFormats.h"

class TCSuperSpiceDoc;
class TCBillOfMaterials;

enum TE_PCB_STRINGS
{
	E_PCB_REFDES,
	E_PCB_PACKAGE_TYPE,
	E_PCB_DEVICE_NAME,
	E_PCB_SPICE_NAME,

	E_PCB_STRINGS_MAX
};

class TCPCBFileData : public CObject
{
	public:	TCPCBFileData(void);
			TCPCBFileData(TCPCBFileData &CBlank);
			~TCPCBFileData(void);

			CArray <CString, CString> CData;

			void operator = (TCPCBFileData &CPCBFileData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPCBFileData)

};

class TCPCBFileArrayData : public CObject
{
	public:	TCPCBFileArrayData(void);
			TCPCBFileArrayData(TCPCBFileArrayData &CBlank);
			~TCPCBFileArrayData(void);

			CArray <TCPCBFileData, TCPCBFileData&> ArrayData;

			void operator = (TCPCBFileArrayData &CPCBFileArrayData);

			void Add(int index, TCPCBFileData &CPCBFileData);

			bool Write(CFile &CDestination);
			void Compact(void);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPCBFileArrayData)

};

class TCNetListLine : public CFileObject
{
	public:	TCNetListLine(void);
			TCNetListLine(TCNetListLine &CNetListLine);
			~TCNetListLine(void);

			CString CRefDes;
			CString CPins;
			CString CValue;
			CString	CLine;

			void operator = (TCNetListLine &CNetListLine);
	
			void Serialize(TCAchiveRaw& CArchiveFile);

};

class TCPCBPinPinListData : public CObject
{
	public:	TCPCBPinPinListData(void);
			TCPCBPinPinListData(TCPCBPinPinListData &CPCBPinPinListData);
			~TCPCBPinPinListData(void);

			CString CRefDes;
			CString CName;
			CString CNetName;
			int		pin;
			CString CPinNumber;
			CString CPinName;
			CString CPackageType;

			void operator = (TCPCBPinPinListData &CPCBPinPinListData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPCBPinPinListData)

};

class TCPCBNetListInfo : public CObject
{
	public:	TCPCBNetListInfo(void);
			TCPCBNetListInfo(TCPCBNetListInfo &CPCBNetListInfo);
			~TCPCBNetListInfo(void);

			CString CNetName;

			CArray <TCPCBPinPinListData, TCPCBPinPinListData&> CPinList;


			void operator = (TCPCBNetListInfo &CPCBNetListInfo);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPCBNetListInfo)

};

class TCPCBNetPinList : public CObject
{
	public:	TCPCBNetPinList(void);
			TCPCBNetPinList(TCPCBNetPinList &CPCBNetPinList);
			~TCPCBNetPinList(void);

			int pin;

			CArray <TCPCBPinPinListData, TCPCBPinPinListData&> CPinList;

			void operator = (TCPCBNetPinList &CPCBNetPinList);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPCBNetPinList)

};

class TCPCBComponentData : public CObject
{
	public:	TCPCBComponentData(void);
			TCPCBComponentData(TCPCBComponentData &CPCBComponentData);
			~TCPCBComponentData(void);

			CString CTextLine;

			CString CRefDes;
			CString CName;
			CString CPackageType;
			CString CDeviceName;
			CString CDeviceValue;
			CString CNetName;
			TCSchematicObject *PCSchematicObject;

			CArray <TCPCBNetPinList, TCPCBNetPinList&> CPinList;

			void operator = (TCPCBComponentData &CPCBComponentData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPCBComponentData)

};

class TCPCBData : public CFileObject
{
	public:	TCPCBData(void);
			TCPCBData(TCPCBData &CPCBData);
			~TCPCBData(void);

			int format;

			CArray <TCPCBComponentData, TCPCBComponentData&> ComponentList;

			void operator = (TCPCBData &CPCBData);

			bool Save(CString CFileName);
			bool Load(CString CFileName);
	
			void Serialize(TCAchiveRaw& CArchiveFile);

};


class TCNetList : public CFileObject  
{
	public:

		CArray <CString, CString> CMSweepTypeList;
		CArray <CString, CString&> CMPinNets;
		CArray <CString, CString&> CMModelLines;

		void ResetPinNets(int size);

		bool SetupComponentList(void);

		TCAnalysisSetup	CMAnalysisSetup;

		CArray <TCSchematicManager *, TCSchematicManager *> CMSchematicManagerList;
		CArray <TCSchematicObject *, TCSchematicObject *> CMAllSchematicComponentsList;
		CArray <TCSchematicObject *, TCSchematicObject *> CMAllNetsList;
		CArray <TCSchematicObject *, TCSchematicObject *> CMAllConnectorsList;
		CArray <TCSchematicObject *, TCSchematicObject *> CMAllComponentsAndConnectorsList;

		CArray<TCNetListLine, TCNetListLine&> CNetListLineList;

		CArray <TCPCBNetListInfo, TCPCBNetListInfo&> CPCBNetsListInfo;

		bool m_is_ok;

		TCNetList();
		TCNetList(TCNetList &CNetList);
	virtual ~TCNetList();

			int		net_lines_start_index;
			int		net_lines_stop_max_index;
			bool	top_level;
			int		m_pcb_format;
			bool	m_include_ad_conversion;

			int m_gmin_node_counter;// for adding virtual resistors
			TCSuperSpiceDoc *PCMDoc;

			CString CFileName;
			CString CModelFileName;
			CString CSchematicName;
			CString CParentRef;
			CArray <CString, CString>  CSubCircuitPinList;

			CArray <CString, CString> COriginalNetNameList;

			TCPCBData CPCBData;
			CArray <TCBillOfMaterials, TCBillOfMaterials&>  *PCBillOfMaterials;

			void ClearAllPinNames(void);
			bool CreatePinNetNames(CDC *PCDC); 
			void RenameNetsToComponentNames(CDC *PCDC);

			void Serialize(TCAchiveRaw &CRawFile);

			void operator = (TCNetList &CNetList);

			bool Load(CString CLoadFileName);
			bool Save(CString CSaveFileName);

			bool Load(void);
			bool Save(void);
			bool SaveModels(void);
			bool ReFormatPCBNetlist(CString CFileName);

			inline bool IsOk(void){return m_is_ok;};

			bool RenameToTopLevelNets(void);
			void RestoreToSubcktNets(void);
			void AddADConversionModels(void);

			bool FindNode(CString CNodeName);

			void AddDotPrintPlotACTypes(CString CPrintPlot, CString CText);
			void AddDotOutputStaticTypes(CString CPrintPlot, CString CText);
			bool AddDefaultNet(TCSchematicObject *PCSchematicObject, CString &CPinName, int pin_id);
	
			void ResetPinTags(void);
			void SetupGlobalAndLocalNetNames(void);
			void SetSchematicTags(bool state);
			void CreateHeader(int flat_netlist);
			bool CreateNetLines(void);
			bool CreateModelLines(int run_counter);
			bool CreateSaveLines(void);
			bool AddModelLine(TCSchematicObject	*PCSchematicObject);
			bool AddVirtualModelLine(TCSchematicObject	*PCSchematicObject);
			bool CreateDotLines(void);
			bool CreateLibaryLines(void);
			bool CreateIncludeLines(void);
			bool CreateControlLines(void);
			bool CreatePCBData(int format);
			bool CreatePCBGenericData(void);
			bool CreatePCBOrcadIIData(void);
			bool CreatePCBProtelData(void);
			bool CreatePCBPadsData(void);
			bool CreatePCBPCadData(void);
			bool CreatePCBPEagleData(void);
			bool CreatePCBPTangoData(void);
			bool CreatePCBPEdifData(void);
			bool CreatePCBLogicData(void);
			bool CreateModelSubData(void);
			bool SimulationSetupCheck(void);
			bool SimulationElectricalCheck(void);
			bool CheckForShortedInductersAndVoltageSources(void);

			bool CreateSubcktModel(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, TCSuperSpiceDoc *PCDoc, CArray <CString, CString> &CPinList);
			bool CreateSubCktModelLines(void);
			bool AddSubCktModelModelLine(TCSchematicObject *PCSchematicObject);
			bool CreateDesignerNetLines(TCSchematicObject *PCSchematicObject, CString CText);

			bool IsParameterSwept(CString CText);

			CString CreateSubcircuitConnectionsLine(int flat_netlist);
			bool UpdateNetList(void);
			void RemoveUnincludedComponentParameter(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup);
			int	 FindRefDesignator(CString CRefDes);
			int	 FindComponentParameter(TCAnalysisSetup &CAnalysisSetup, CString CRefDes);

			bool InitaliseAnalysisSetup(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, CString CParentRefDes);
			
			int Create(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, TCSuperSpiceDoc *PCDoc, int format, CString CParentRefDes, CArray <CString, CString>  &CPinList);
			bool CreateModelLines(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup, TCSuperSpiceDoc *PCDoc, int runs_counter);

			void AddToDeviceCurrentNodeList(TCAnalysisSetup &CAnalysisSetup, TCSchematicObject *PCSchematicObject);

			void SetUniqueModel(CArray <TCSchematicManager *, TCSchematicManager *> &CListOfSchematicManagers, TCAnalysisSetup &CAnalysisSetup);
};

#endif // !defined(AFX_TCNETLIST_H__D0AF9FA2_4B16_11D2_AD63_886A0BC10000__INCLUDED_)
