////////////////////////////////////////////////////////////////////////
//
#include <afxtempl.h>
#include "TCNumberStack.h"

#pragma warning(disable:4244)

TCNumberStack::TCNumberStack()
{
	// Dynamic stuffing of the stack is performed for unlimited numbers out

	m_block_size	= 1024;
	m_last_page_id	= 1023;

	SetBlockSize(m_block_size);	
}

void TCNumberStack::SetBlockSize(int size)
{
	if(size < 1) return;

	m_block_size	= size;
	m_last_page_id	= size - 1;

	Reset();
}

void TCNumberStack::Reset(void)
{
	m_index = 0;

	RemoveAll();

	for(int p = m_block_size - 1; p >= 0; p--) 
	{
		AddHead(p); 
	}

	m_index = -1;

	CMAlreadyRemoved.SetSize(0, m_block_size); // Clear array
}

bool TCNumberStack::IsAlradyRemoved(int number)
{
	int count = CMAlreadyRemoved.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CMAlreadyRemoved[p] == number) return true;
	}

	return false;
}

bool TCNumberStack::Remove(int number)
{
	if(IsAlradyRemoved(number)) return false;

	while(1) // If the code is working correctly this will return
	{			// will put in a 1 secound timer to provent any lockout
		POSITION position = GetHeadPosition();
		POSITION last_position;

		while(position != NULL)
		{
			last_position = position;

			if(number == GetNext(position)) // look at current, position goes to next
			{
				RemoveAt(last_position);

				CMAlreadyRemoved.Add(number);

				m_index++;

				return true;
			}
		}

		CreateNewNumbers();
	}
}

bool TCNumberStack::Push(int number)// Add element to top of stack
{ 
	if(m_index < 0) return false;

	AddHead(number); 

	m_index--;

	return true;
}
       
bool TCNumberStack::AlreadyExists(int number)
{
	POSITION position = GetHeadPosition();
	int stack_number;

	while(position)
	{
		stack_number = GetNext(position);

		if(stack_number == number) return true;
	}

	return false;
}

int TCNumberStack::Peek()// Peek at top element of stack
{ 
	if(IsEmpty()) return -1;  

	return GetHead(); 
}

int TCNumberStack::Pop() // Pop top element off stack
{ 
	if(IsEmpty()) CreateNewNumbers();
		
	m_index++;

	return RemoveHead(); 
}

void TCNumberStack::CreateNewNumbers(void)
{	
	for(int p = m_block_size + m_last_page_id; p > m_last_page_id; p--) 
	{
		AddHead(p); 
	}

	m_last_page_id += m_block_size;
}

int TCNumberStack::GetIndex(void)
{
	return m_index;
}

int TCNumberStack::GetSize(void)
{
	return m_index + 1;
}
////////////////////////////////////////////////////////////////////////


TCPageId::TCPageId()
{

}

TCPageId::~TCPageId()
{

}

int TCPageId::GetNewPageId(CString CTitleName)
{
	TCPageIdData CPageTitleData;

	int p = MCPageIdStack.Pop();

	if(p < 0)		
	{
		ASSERT(0);
		return -1;
	}

	CPageTitleData.page_id = p;

	CPageTitleData.CPageTitle.Format("%s %d", CTitleName, p);

	CPageIdData.Add(CPageTitleData);

	return p;
}

bool TCPageId::RemovePageId(int page_id)
{
	TCPageIdData CPageTitleData;

	MCPageIdStack.Push(page_id);
	
	int page_index = GetPageIndex(page_id);

	if(page_index < 0) 
	{
		ASSERT(0);
		return false;
	}

	CPageIdData.RemoveAt(page_index);

	return true;
}

int	TCPageId::GetPageIndex(int page_id)
{
	int count = CPageIdData.GetSize(); 

	for(int p = 0; p < count; p++)
	{
		if(CPageIdData.GetAt(p).page_id != page_id) continue;

		return p;
	}

	ASSERT(0);
	return -1;
}


bool TCPageId::Update(int page_id, CString CTitle)
{
	TCPageIdData CPageTitleData;

	MCPageIdStack.Remove(page_id);

	CPageTitleData.page_id = page_id;

	CPageTitleData.CPageTitle.Format("%s %d", CTitle, page_id);

	CPageIdData.Add(CPageTitleData);

	return true; // to do errors
}

void TCPageId::Clear(void)
{
	MCPageIdStack.Reset();

	CPageIdData.SetSize(0, 256);
}