#ifndef _TCNumberStack_H
#define _TCNumberStack_H


#include <afxtempl.h>

class TCNumberStack : public CList< int, int >
{

	private:	int m_index;
				int m_block_size;
				int m_last_page_id;

				CArray <int, int> CMAlreadyRemoved;

				bool IsAlradyRemoved(int number);

	public:

	TCNumberStack();
    
    bool	Push(int number);     
    int		Peek();
    int		Pop();
	bool	Remove(int number);
	int		GetIndex(void);
	int		GetSize(void);
	void	Reset(void);
	void	CreateNewNumbers(void);
	bool	AlreadyExists(int number);
	void	SetBlockSize(int size);
};

class TCPageIdData
{
	public:

			int		page_id;
			CString	CPageTitle;

};

class TCPageId
{

	private:	TCNumberStack MCPageIdStack;

				
	public:	TCPageId();
			~TCPageId();

			int		GetNewPageId(CString CTitleName);
			bool	RemovePageId(int page_id);
			bool	Update(int page_id, CString CTitle);
			int		GetPageIndex(int page_id);
			void	Clear(void);
			CArray <TCPageIdData, TCPageIdData> CPageIdData;
			


};

#endif