// TCOpenSchematicPage.cpp : implementation file
//
#include "TDVersion.h"
#include "stdafx.h"
#include "resource.h"
#include "TCOpenSchematicPage.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCOpenSchematicPage dialog


TCOpenSchematicPage::TCOpenSchematicPage(CWnd* pParent /*=NULL*/)
	: CDialog(TCOpenSchematicPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCOpenSchematicPage)
	//}}AFX_DATA_INIT

	fm_is_ok = FALSE;
}


void TCOpenSchematicPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCOpenSchematicPage)
	DDX_Control(pDX, IDC_PAGE_LIST_BOX, CMOpenPageList);
	//}}AFX_DATA_MAP

}


BEGIN_MESSAGE_MAP(TCOpenSchematicPage, CDialog)
	//{{AFX_MSG_MAP(TCOpenSchematicPage)
	ON_BN_CLICKED(IDC_PAGE_OPENPAGE_HELP, OnPageOpenPageHelp)
	ON_LBN_DBLCLK(IDC_PAGE_LIST_BOX, OnDblclkPageListBox)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////




int TCOpenSchematicPage::GetData(void)
{
	return m_name_index;
}

void TCOpenSchematicPage::SetData(CArray <TCPageIdData, TCPageIdData> &CMPageTitleData)
{
	int count = CMPageTitleData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMDataList.SetAtGrow(p, CMPageTitleData.GetAt(p).CPageTitle);
	}
}


BOOL TCOpenSchematicPage::LoadPageList(void)
{
	CString CPageName;

	int count = CMDataList.GetSize();

	for(int p = 0; p < count; p++)
	{
		CPageName = CMDataList.GetAt(p);

		CMOpenPageList.InsertString(p, CPageName);
	}

	CMOpenPageList.SetCurSel(0);

	return TRUE;
}

BOOL TCOpenSchematicPage::OnInitDialog()
{
	CDialog::OnInitDialog();

	LoadPageList();

	return TRUE;
}

BOOL TCOpenSchematicPage::IsOk()
{
	return fm_is_ok;
}


// TCOpenSchematicPage message handlers

void TCOpenSchematicPage::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	fm_is_ok = FALSE;

	CDialog::OnCancel();
}

void TCOpenSchematicPage::OnOK() 
{
	// TODO: Add extra validation here

	fm_is_ok = TRUE;

	int selection_index = CMOpenPageList.GetCurSel();

	if(selection_index == LB_ERR) fm_is_ok = FALSE;

	m_name_index = selection_index; 

	CDialog::OnOK();
}

void TCOpenSchematicPage::OnPageOpenPageHelp() 
{
	// TODO: Add your control notification handler code here

}

void TCOpenSchematicPage::OnDblclkPageListBox() 
{
	OnOK();	
}

BOOL TCOpenSchematicPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);

	return true;
}
