#pragma warning(disable:4239)//nonstandard extention

#include "stdafx.h"
#include "resource.h"
#include "float.h"
#include <fstream>
#include <iostream>
using namespace std;
#include "math.h"
#include "TDVersion.h"
#include "TCFileFunctions.h"
#include "TCTestPointData.h"
#include "TCOutputWaveformData.h"
#include "TCFloatingCursorData.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCLoadDataProgressDlg.h"
#include "TCFFT.h"
#include "TCOutputWaveformDoc.h"
#include "Generic.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCOutputWaveformData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCOutputWaveformDataRecord, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCOutputWaveformDataHeader, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSignal, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCWaveformDataRuns, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCMathFunctionData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCWaveformAnalyisisData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSignalEnables, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCGainPhaseMargin, CObject, ID_VERSION_NUMBER)

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
CString RemoveFirstWord(CString CText);
CString RemoveFirstWord(CString CText, char delimiter);
CString GetFirstWord(CString CText, char delimiter);
CString GetFirstWord(CString CText);
CString ReplaceFileExtension(CString CName, CString CExtention);
CString RemoveExtention(CString CPathAndName);
bool LoadGenericFromArchive(CObject*, CString);	
bool SaveGenericToArchive(CObject*, CString);
int  GetMKSNumDigits(void);
void SetMKSNumDigits(int num_digits);
CString FloatToMKSString(double data);
double	AntiLog(double value);
double Log(double value);
double QuantiseScale(double &max, double &min, int num_ticks, bool quantise);
double QuantisePhaseScale(double &max, double &min, int num_ticks, bool quantise);
int QuantiseLogScale(double &max, double &min);
double ArcTan(double y, double x);// fucking idiots, default should calculate the correct quadrant
double ArcTanNegitive(double y, double x);
CString Spice3ToSuperSpiceName(CString CName);
bool IsSpice3SubcircuitTypeName(CString CName);
bool GetSafeDouble(double &);
bool GetSafeFloat(double &);
bool ProcessWindowsMessages(void);
double MKSStringToFloat(CString &CText);

extern CArray <COLORREF, COLORREF> CMColorRefList;

bool FFT(int n, double xRe[], double xIm[], double yRe[], double yIm[]);
////////////////////////////////////////


////////////////////////////////////////
////////////////////////////////////////

TCGainPhaseMargin::TCGainPhaseMargin(void)
{

}

TCGainPhaseMargin::TCGainPhaseMargin(TCGainPhaseMargin &CGainPhaseMargin)
{
	*this = CGainPhaseMargin;
}

TCGainPhaseMargin::~TCGainPhaseMargin(void)
{

}

void TCGainPhaseMargin::operator = (TCGainPhaseMargin &CGainPhaseMargin)
{
	max_phase	= CGainPhaseMargin.max_phase;
	min_phase	= CGainPhaseMargin.min_phase;
	max_mag		= CGainPhaseMargin.max_mag;
	min_mag		= CGainPhaseMargin.min_mag;
	CMaxPhaseName	= CGainPhaseMargin.CMaxPhaseName;
	CMinPhaseName	= CGainPhaseMargin.CMinPhaseName;
	CMaxMagName		= CGainPhaseMargin.CMaxMagName;
	CMaxMagName		= CGainPhaseMargin.CMaxMagName;

}
void TCGainPhaseMargin::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
//////////////////////////////////////////////
TCSignalEnables::TCSignalEnables(void)
{
	magnitude = -1;
	phase = -1;
}

TCSignalEnables::TCSignalEnables(TCSignalEnables &CSignalEnables)
{
	*this = CSignalEnables;
}
TCSignalEnables::~TCSignalEnables(void)
{

}

void TCSignalEnables::operator = (TCSignalEnables &CSignalEnables)
{
	magnitude = CSignalEnables.magnitude;
	phase	  = CSignalEnables.phase;

}
/////////////////////////////
TCWaveformAnalyisisData::TCWaveformAnalyisisData(void)
{
	ac_analysis_type = E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN;
	plot_ac_analysis	= false;
	gain_margin		= 1000;
	phase_margin	= 1000;
	phase_zero		= -180;
	unity_gain_frequency = 0;
	zero_phase_frequency = 0;
	low_frequency_gain = 0;

	trans_frequency_enable = false;
	trans_frequency			= 0.0;
	trans_xing_level		= 0.0;
	trans_xing_first_count	= 2;//first one is usually crap
	trans_xing_last_count	= 3;
	trans_xing_sign			= 1;//-1 for negative slope
	trans_first_time		= -1;
	trans_last_time			= -1;
	
	CPulseMeasureSignal;
	CPulseReferanceSignal;
	pulse_max_level = 1;
	pulse_mid_level = 0;
	pulse_min_level	=-1;
	pulse_xing_count= 0;
	pulse_ref_xing_count=0;
	pulse_rise_xing_time =0;
	pulse_rise_time =0;		
	pulse_fall_xing_time =0;
	pulse_fall_time =0;
	pulse_width_polarity =1;
	pulse_width_mid_time =0;
	pulse_width =0;
	pulse_period =0;
	pulse_delay=0;
	pulse_enable=0;
	pulse_time=0;
	power_value = 0;
	power_temperture = 0;
	power_rtheata = 0;
	power_start = 0;
	power_end = 0;
	power_enable = 1;

	CRMSSignalName;
	CRMSRunSelect;
	rms_value		= 0;
	rms_pk_value	= 0;
	rms_av_value	= 0;
	rms_start		= 0;
	rms_end			= 0;
	rms_enable		= 0;
	rms_ripple_value= 0;

	CNoiseReportFrequencyList = "1"; // 1HZ default

	CPowerRunSelect = "Single Run";
	CPulseRunSelect = CPowerRunSelect;
	CRMSRunSelect	= CPowerRunSelect;
}

TCWaveformAnalyisisData::TCWaveformAnalyisisData(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	*this = CWaveformAnalyisisData;
}

TCWaveformAnalyisisData::~TCWaveformAnalyisisData(void)
{

}

void TCWaveformAnalyisisData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCWaveformAnalyisisData::operator = (TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CLoopGainSource = CWaveformAnalyisisData.CLoopGainSource;
	CLoopGainInputNode = CWaveformAnalyisisData.CLoopGainInputNode;
	CLoopGainOutputNode = CWaveformAnalyisisData.CLoopGainOutputNode;
	CNoiseReportFrequencyList = CWaveformAnalyisisData.CNoiseReportFrequencyList;

	ac_analysis_type = CWaveformAnalyisisData.ac_analysis_type;
	plot_ac_analysis	= CWaveformAnalyisisData.plot_ac_analysis;
	phase_margin	= CWaveformAnalyisisData.phase_margin;
	gain_margin		= CWaveformAnalyisisData.gain_margin;
	unity_gain_frequency = CWaveformAnalyisisData.unity_gain_frequency;
	zero_phase_frequency = CWaveformAnalyisisData.zero_phase_frequency;
	phase_zero = CWaveformAnalyisisData.phase_zero;
	low_frequency_gain  = CWaveformAnalyisisData.low_frequency_gain;

	trans_frequency_enable	= CWaveformAnalyisisData.trans_frequency_enable;
	trans_frequency			= CWaveformAnalyisisData.trans_frequency;
	trans_xing_level		= CWaveformAnalyisisData.trans_xing_level;
	trans_xing_first_count  = CWaveformAnalyisisData.trans_xing_first_count;
	trans_xing_last_count	= CWaveformAnalyisisData.trans_xing_last_count;
	trans_xing_sign			= CWaveformAnalyisisData.trans_xing_sign;
	CTransFrequencySignalName = CWaveformAnalyisisData.CTransFrequencySignalName;

	trans_first_time = CWaveformAnalyisisData.trans_first_time;
	trans_last_time = CWaveformAnalyisisData.trans_last_time;

	CPulseMeasureSignal = CWaveformAnalyisisData.CPulseMeasureSignal;
	CPulseReferanceSignal = CWaveformAnalyisisData.CPulseReferanceSignal;
	pulse_max_level = CWaveformAnalyisisData.pulse_max_level;
	pulse_mid_level = CWaveformAnalyisisData.pulse_mid_level;
	pulse_min_level = CWaveformAnalyisisData.pulse_min_level;
	pulse_xing_count = CWaveformAnalyisisData.pulse_xing_count;
	pulse_ref_xing_count = CWaveformAnalyisisData.pulse_ref_xing_count;
	pulse_rise_xing_time = CWaveformAnalyisisData.pulse_rise_xing_time;
	pulse_rise_time = CWaveformAnalyisisData.pulse_rise_time;		
	pulse_fall_xing_time = CWaveformAnalyisisData.pulse_fall_xing_time;
	pulse_fall_time = CWaveformAnalyisisData.pulse_fall_time;
	pulse_width_polarity = CWaveformAnalyisisData.pulse_width_polarity;
	pulse_width_mid_time = CWaveformAnalyisisData.pulse_width_mid_time;
	pulse_width = CWaveformAnalyisisData.pulse_width;
	pulse_period = CWaveformAnalyisisData.pulse_period;
	pulse_delay  = CWaveformAnalyisisData.pulse_delay;
	pulse_enable = CWaveformAnalyisisData.pulse_enable;
	pulse_time = CWaveformAnalyisisData.pulse_time;

	CPowerVoltName		= CWaveformAnalyisisData.CPowerVoltName;
	CPowerCurrentName	= CWaveformAnalyisisData.CPowerCurrentName;
	CPowerDeviceName	= CWaveformAnalyisisData.CPowerDeviceName;
	power_value			= CWaveformAnalyisisData.power_value;
	power_temperture	= CWaveformAnalyisisData.power_temperture;
	power_rtheata		= CWaveformAnalyisisData.power_rtheata;
	power_start			= CWaveformAnalyisisData.power_start;
	power_end			= CWaveformAnalyisisData.power_end;
	power_enable		= CWaveformAnalyisisData.power_enable;

	CRMSSignalName		= CWaveformAnalyisisData.CRMSSignalName;
	CRMSRunSelect		= CWaveformAnalyisisData.CRMSRunSelect;
	rms_value			= CWaveformAnalyisisData.rms_value;
	rms_pk_value		= CWaveformAnalyisisData.rms_pk_value;
	rms_av_value		= CWaveformAnalyisisData.rms_av_value;
	rms_ripple_value	= CWaveformAnalyisisData.rms_ripple_value;
	rms_start			= CWaveformAnalyisisData.rms_start;
	rms_end				= CWaveformAnalyisisData.rms_end;
	rms_enable			= CWaveformAnalyisisData.rms_enable;
}

void TCWaveformAnalyisisData::operator = (TCReRun &CReRun)
{
	pulse_enable = (int)CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_ENABLE];

	pulse_max_level = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_MAX_LEVEL] ;
	pulse_mid_level = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_MID_LEVEL];
	pulse_min_level = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_MIN_LEVEL];

	pulse_xing_count = (int)CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_XING_COUNT];
	pulse_ref_xing_count = (int)CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_REF_XING_COUNT];

	pulse_rise_xing_time = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_RISE_XING_TIME];
	pulse_rise_time = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_RISE_TIME] ;

	pulse_fall_xing_time = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_FALL_XING_TIME];
	pulse_fall_time = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_FALL_TIME];

	pulse_width_mid_time = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_WIDTH_MID_TIME];

	pulse_width_polarity = (int)CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_POLARITY];
	pulse_delay = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_DELAY];
	pulse_time = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_TIME];
	pulse_period = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_PERIOD];
	pulse_width = CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_WIDTH];

	CPulseReferanceSignal = CReRun.CReserved.CStringArray[E_PULSE_ANALYSIS_REFERANCE_SIGNAL_NAME];
	CPulseMeasureSignal = CReRun.CReserved.CStringArray[E_PULSE_ANALYSIS_MEASURE_SIGNAL_NAME];
	CPulseRunSelect = CReRun.CReserved.CStringArray[E_PULSE_ANALYSIS_RUN_SELECT];

	CPowerVoltName = CReRun.CReserved.CStringArray[E_TRAN_POWER_VOLT_NAME];
	CPowerCurrentName = CReRun.CReserved.CStringArray[E_TRAN_POWER_CURRENT_NAME];
	CPowerDeviceName = CReRun.CReserved.CStringArray[E_TRAN_POWER_DEVICE_NAME];
	CPowerRunSelect = CReRun.CReserved.CStringArray[E_TRAN_POWER_RUN_SELECT];

	power_start = CReRun.CReserved.CIntArray[E_TRAN_POWER_START];
	power_end	= CReRun.CReserved.CIntArray[E_TRAN_POWER_END];
	power_enable 	= (int)CReRun.CReserved.CIntArray[E_TRAN_POWER_ENABLE];

	CRMSRunSelect	= CReRun.CReserved.CStringArray[E_TRAN_RMS_RUN_SELECT];
	CRMSSignalName	= CReRun.CReserved.CStringArray[E_TRAN_RMS_SIGNAL_NAME];
	rms_start		= CReRun.CReserved.CIntArray[E_TRAN_RMS_START];
	rms_end			= CReRun.CReserved.CIntArray[E_TRAN_RMS_END];
	rms_enable		= (int) CReRun.CReserved.CIntArray[E_TRAN_RMS_ENABLE];

	CNoiseReportFrequencyList = CReRun.CReserved.CStringArray[E_NOISE_REPORT_FREQUENCY_LIST];
}
///////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////
TCMathFunctionData::TCMathFunctionData(void)
{
	function_operator		= 0;
	signals_ab_operator		= 0;
	a_signal				= 1;
	b_signal				= 1;
	magnitude				= -1;
	phase					= -1;
	calculator_enabled		= 0;
	record_index			= 0;
	last_graphic_type		= 0;
}

TCMathFunctionData::TCMathFunctionData(TCMathFunctionData &CMathFunctionData)
{
	*this = CMathFunctionData;
}
TCMathFunctionData::~TCMathFunctionData(void)
{

}

void TCMathFunctionData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << function_operator;
		CArchiveFile << signals_ab_operator;
		CArchiveFile << a_signal;
		CArchiveFile << b_signal;
		CArchiveFile << magnitude;
		CArchiveFile << phase;
		CArchiveFile << calculator_enabled;
		CArchiveFile << record_index;
		CArchiveFile << last_graphic_type;
	}
	else
	{
		CArchiveFile >> function_operator;
		CArchiveFile >> signals_ab_operator;
		CArchiveFile >> a_signal;
		CArchiveFile >> b_signal;
		CArchiveFile >> magnitude;
		CArchiveFile >> phase;
		CArchiveFile >> calculator_enabled;
		CArchiveFile >> record_index;
		CArchiveFile >> last_graphic_type;
	}
}
void TCMathFunctionData::operator = (TCMathFunctionData &CMathFunctionData)
{
	CMathFunctionData;

	function_operator		= CMathFunctionData.function_operator;
	signals_ab_operator		= CMathFunctionData.signals_ab_operator;
	a_signal				= CMathFunctionData.a_signal;
	b_signal				= CMathFunctionData.b_signal;
	magnitude				= CMathFunctionData.magnitude;
	phase					= CMathFunctionData.phase;
	calculator_enabled		= CMathFunctionData.calculator_enabled;
	record_index			= CMathFunctionData.record_index;
	last_graphic_type		= CMathFunctionData.last_graphic_type;
}

///////////////////////////////////////////////////////////////////

TCMathOperatorTypeData::TCMathOperatorTypeData()
{
	CMathOperatorTypeList.SetSize(E_MATH_OPERATOR_MAX);

	CMathOperatorTypeList[E_MATH_OPERATOR_ADD]		= "+";
	CMathOperatorTypeList[E_MATH_OPERATOR_SUBTRACT]	= "-";
	CMathOperatorTypeList[E_MATH_OPERATOR_MULTIPLY]	= "*";
	CMathOperatorTypeList[E_MATH_OPERATOR_DIVIDE]	= "/";
	CMathOperatorTypeList[E_MATH_OPERATOR_POWER]	= "^";
	CMathOperatorTypeList[E_MATH_OPERATOR_NONE]		= "N/A";

}
////////////////////////////////////////////////////////////////

TCMathFunctionTypeData::TCMathFunctionTypeData()
{
	CMathFunctionTypeList.SetSize(TE_MATH_FUNCTION_MAX - 1);//TO DO remove 1 for real and imaj

	CMathFunctionTypeList[E_MATH_FUNCTION_NO_UNITS]		= "None";

	CMathFunctionTypeList[E_MATH_FUNCTION_10DB]	= "10Log10/Phase";
	CMathFunctionTypeList[E_MATH_FUNCTION_20DB]	= "20Log10/Phase";

	CMathFunctionTypeList[E_MATH_FUNCTION_HALF] = "1/2 *";// for getting unmodified signal

	CMathFunctionTypeList[E_MATH_FUNCTION_GROUP_DELAY]		= "GrpDel, d/dt";

//	CMathFunctionTypeList[E_MATH_FUNCTION_REIMJ] = "ReImj"; TO DO
}
////////////////////////////////////////////////////////////////

TCDisplayedSignals::TCDisplayedSignals()
{
	type		= 0;
	PCSignal1	= NULL; // for impedences etc
	PCSignalX   = NULL; // Added Aug 19th 2016. Wow....
	index1		= 0;
	magnitude	= -1;
	phase		= -1;
}

void TCDisplayedSignals::TCSignalEnables(TCDisplayedSignals &CDisplayedSignals)
{
	*this = CDisplayedSignals;
}

void TCDisplayedSignals::operator = (TCDisplayedSignals &CDisplayedSignals)
{
	type		= CDisplayedSignals.type;
	PCSignal1	= CDisplayedSignals.PCSignal1; 
	index1		= CDisplayedSignals.index1;
	magnitude	= CDisplayedSignals.magnitude;
	phase		= CDisplayedSignals.phase;
	PCSignalX   = CDisplayedSignals.PCSignalX; // Added Aug 19th 2016. Wow....
}

//////////////////////////////////////////////////
TCSignal::TCSignal(void)
{
	PCDoc = NULL;

	x_gain			= 1.0;
	y_gain			= 1.0;
	x_offset		= 0.0;
	y_offset		= 0.0;

	y_phase_gain	= 1.0;
	y_phase_offset  = 0.0;

	points_per_float = 100;
	min_points		= 0;	
	max_points		= 1;

	phase_points_per_float = 100;
	min_phase_points	= 0;
	max_phase_points	= 1;
	phase_axis = false;
	already_polar = true;// spice data is initally in real and imaginary
	rectangular		= false;
	stop_point		= 0;
	start_point		= 0;
	graphic_stop_point = 0;

	normal_colour	= RGB(0, 0, 255);
	selected_colour	= RGB(255, 0, 0);
	highlighted_colour	= RGB(0, 255, 255);

	normal_phase_colour		= normal_colour;
	selected_phase_colour	= selected_colour;
	highlighted_phase_colour=highlighted_colour;

	style			= 0;
	type			= E_SPICE_RECORD_NULL;

	magnitude		= -1;// 0 = mag or dbmagnitude, -1 not displayed
	phase			= -1;// 0 = degress or radians

	magnitude_and_phase_type = false; // must be always overwrritten
	f_first = true;// for init displaying

}

TCSignal::TCSignal(TCSignal &CSignal)
{
	*this = CSignal;
}
TCSignal::~TCSignal(void)
{

}

void TCSignal::DisplayError(CString CDescription, CString CErrorMsg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(CDescription, CErrorMsg, error_code);
}

void TCSignal::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
//	CMagnitudeData.Serialize(CArchiveFile);// use the text file to get data
//	CPhaseData.Serialize(CArchiveFile);// but recover the setup

	int save_serialize = 12345678;
	int load_serialize = 3456;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CName;
		CArchiveFile << CXType;
		CArchiveFile << CYType;
//		CArchiveFile << CCalculatorNameMagnitude;// keep compatible with old
//		CArchiveFile << CCalculatorNamePhase;	// to fix later

		CArchiveFile << x_gain;
		CArchiveFile << y_gain;
		CArchiveFile << x_offset;
		CArchiveFile << y_offset;
		CArchiveFile << y_phase_gain;
		CArchiveFile << y_phase_offset;
		CArchiveFile << normal_colour;
		CArchiveFile << selected_colour;
		CArchiveFile << highlighted_colour;
		CArchiveFile << normal_phase_colour;
		CArchiveFile << selected_phase_colour;
		CArchiveFile << highlighted_phase_colour;
		CArchiveFile << style;
		CArchiveFile << type;
		CArchiveFile << magnitude;	
		CArchiveFile << phase;

		CArchiveFile << points_per_float;
		CArchiveFile << min_points;	
		CArchiveFile << max_points;
		CArchiveFile << phase_points_per_float;
		CArchiveFile << min_phase_points;
		CArchiveFile << max_phase_points;
		CArchiveFile << phase_axis;
		CArchiveFile << already_polar;
		CArchiveFile << rectangular;
		CArchiveFile << magnitude_and_phase_type;
		CArchiveFile << f_first;
	}
	else
	{
		CArchiveFile >> CName;
		CArchiveFile >> CXType;
		CArchiveFile >> CYType;
//		CArchiveFile >> CCalculatorNameMagnitude;
//		CArchiveFile >> CCalculatorNamePhase;

		CArchiveFile >> x_gain;
		CArchiveFile >> y_gain;
		CArchiveFile >> x_offset;
		CArchiveFile >> y_offset;
		CArchiveFile >> y_phase_gain;
		CArchiveFile >> y_phase_offset;
		CArchiveFile >> normal_colour;
		CArchiveFile >> selected_colour;
		CArchiveFile >> highlighted_colour;
		CArchiveFile >> normal_phase_colour;
		CArchiveFile >> selected_phase_colour;
		CArchiveFile >> highlighted_phase_colour;
		CArchiveFile >> style;
		CArchiveFile >> type;
		CArchiveFile >> magnitude;	
		CArchiveFile >> phase;

		CArchiveFile >> points_per_float;
		CArchiveFile >> min_points;	
		CArchiveFile >> max_points;
		CArchiveFile >> phase_points_per_float;
		CArchiveFile >> min_phase_points;
		CArchiveFile >> max_phase_points;
		CArchiveFile >> phase_axis;
		CArchiveFile >> already_polar;
		CArchiveFile >> rectangular;
		CArchiveFile >> magnitude_and_phase_type;
		CArchiveFile >> f_first;
	}

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_serialize;
	}
	else
	{
		CArchiveFile >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_DATA_FILE);
			ASSERT(0);

			return;
		}
	}
}

void TCSignal::operator = (TCSignal &CSignal)
{
	PCDoc	= CSignal.PCDoc;

	CName	= CSignal.CName;
	CXType	= CSignal.CXType;
	CYType	= CSignal.CYType;
	CCalculatorNameMagnitude = CSignal.CCalculatorNameMagnitude;
	CCalculatorNamePhase  = CSignal.CCalculatorNamePhase;

	CMagnitudeData	= CSignal.CMagnitudeData;
	CPhaseData = CSignal.CPhaseData;

	x_gain					= CSignal.x_gain;
	y_gain					= CSignal.y_gain;
	x_offset				= CSignal.x_offset;
	y_offset				= CSignal.y_offset;
	y_phase_gain			= CSignal.y_phase_gain;
	y_phase_offset			= CSignal.y_phase_offset;

	points_per_float		= CSignal.points_per_float;
	min_points				= CSignal.min_points;	
	max_points				= CSignal.max_points;
	phase_points_per_float	= CSignal.phase_points_per_float;
	min_phase_points		= CSignal.min_phase_points;
	max_phase_points		= CSignal.max_phase_points;
	phase_axis				= CSignal.phase_axis;
	already_polar			= CSignal.already_polar;
	rectangular				= CSignal.rectangular;
	stop_point				= CSignal.stop_point;
	start_point				= CSignal.start_point;
	graphic_stop_point		= CSignal.graphic_stop_point;

	normal_colour				= CSignal.normal_colour;
	selected_colour				= CSignal.selected_colour;
	highlighted_colour			= CSignal.highlighted_colour;
	normal_phase_colour			= CSignal.normal_phase_colour;
	selected_phase_colour		= CSignal.selected_phase_colour;
	highlighted_phase_colour	= CSignal.highlighted_phase_colour;

	style			= CSignal.style;
	type			= CSignal.type;
	magnitude		= CSignal.magnitude;	
	phase			= CSignal.phase;

	magnitude_and_phase_type = CSignal.magnitude_and_phase_type;
	f_first = CSignal.f_first;

	int index_count = CSignal.GraphPointToMagDataIndex.GetSize();

	GraphPointToMagDataIndex.SetSize(index_count);

	for(int p = 0; p < index_count; p++)
	{
		GraphPointToMagDataIndex[p] = CSignal.GraphPointToMagDataIndex[p];
	}
}

void TCSignal::CopyScaleFactors(TCSignal &CSignal)
{
	points_per_float		= CSignal.points_per_float;
	min_points				= CSignal.min_points;	
	max_points				= CSignal.max_points;
	phase_points_per_float	= CSignal.phase_points_per_float;
	min_phase_points		= CSignal.min_phase_points;
	max_phase_points		= CSignal.max_phase_points;
}

bool TCSignal::SetMagnitudeScaleFactors(unsigned short size,  bool auto_scale, double xmax, double xmin, int loged, int num_ticks)
{
	points_per_float = 100;
	phase_points_per_float = 100;

	if(!size) return false;

	if(rectangular)if(already_polar)PolarToRectanguler();
	else if(!already_polar)RectangulerToPolar();

	double data = 0.0;

	if(auto_scale)
	{
		if(magnitude == 1)// convert to db
		{
			xmin = (double)CMagnitudeData.GetMinDBValue();
			xmax = (double)CMagnitudeData.GetMaxDBValue();

			if(xmax == xmin) xmax += 20;
		}
		else
		{
			xmin = (double)CMagnitudeData.GetMinValue();
			xmax = (double)CMagnitudeData.GetMaxValue();

			if(xmax == xmin) xmax += 1;
		}

		if(loged)
		{
			QuantiseLogScale(xmax, xmin);

			if(xmin > 0 && xmax > 0)
			{
				data =(double)xmin;

				xmin = (double)Log(data);

				data = (double)xmax;

				xmax = (double)Log(data);
			}
		}
		else
		{
			QuantiseScale(xmax, xmin, num_ticks, auto_scale || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);
		}
	}

	double test = 1.0;

	if(loged && !auto_scale)
	{
		QuantiseLogScale(xmax, xmin);

		if(xmin > 0 && xmax > 0)
		{
			data =(double)xmin;

			xmin = (double)Log(data);

			data = (double)xmax;

			xmax = (double)Log(data);
		}
	}

	test = (double)(xmax - xmin);// double cause exceptions

	if(test) points_per_float = size / test;

	test = points_per_float * xmin;

	if(test < 0) min_points = -(long)(test - 0.5);
	else min_points = -(long)(test + 0.5);

	max_points = size + min_points;

	return true;
}

bool TCSignal::SetPhaseScaleFactors(unsigned short size, bool auto_scale, double xmax, double xmin, int loged, int num_ticks)
{
	if(!size) return false;

	num_ticks;

	if(rectangular)if(already_polar)PolarToRectanguler();
	else if(!already_polar)RectangulerToPolar();

	double data = 0.0;

	if(auto_scale)
	{
		xmin = (double)CPhaseData.GetMinValue();
		xmax = (double)CPhaseData.GetMaxValue();

		if(!phase)// convert to degrees
		{
			xmin *= (double)57.29577951308;
			xmax *= (double)57.29577951308;
		}

		if(loged)
		{
			QuantiseLogScale(xmax, xmin);

			if(xmin > 0 && xmax > 0)
			{
				data =(double)xmin;

				xmin = (double)Log(data);

				data = (double)xmax;

				xmax = (double)Log(data);
			}
		}
	}

	phase_points_per_float = 1.0;
	double test = 1.0;

	if(loged && !auto_scale)
	{
		double data = 0.0;

		QuantiseLogScale(xmax, xmin);

		if(xmin > 0 && xmax > 0)
		{
			data =(double)xmin;

			xmin = (double)Log(data);

			data = (double)xmax;

			xmax = (double)Log(data);
		}
	}

	test = (double)(xmax - xmin);

	if(test) phase_points_per_float = size / test;

	test = phase_points_per_float * xmin;

	if(test < 0) min_phase_points = -(long)(test - 0.5);
	else min_phase_points = -(long)(test + 0.5);

	max_phase_points = size + min_phase_points;

	return true;
}

bool TCSignal::SetName(CString CText)
{
	CName = GetFirstWord(CText);// now get 1st word in line

	if(CName.GetAt(0) == '@')// branch currents, remove the @
	{
		CName = CName.Right(CName.GetLength() - 1);

		return true;
	}

	int index = CName.Find("#branch");

	if(index > -1)
	{
		CName = CName.Left(index);
	
		index = CName.Find("%");//added for designer

		if(index < 0)
		{
			CName = CName + "[i]";

			return true;
		}

		CName = CName.Left(index - 1);

		index = CName.Find("r");//added for designer

		if(index < 0) 
		{
			index = CName.Find("m");

			CName = CName.Right(CName.GetLength() - index);

			CName = CName + "[id]";

			return true;
		}

		CName = CName.Right(CName.GetLength() - index);

		CName = CName + "[i]";

		return true;
	}

	index = CName.Find("#");

	if(index > -1)
	{
		CText = CName.Left(index);
	
		CName = CName.GetAt(index + 1);

		CName = CText + "[v" + CName + "]";
	}

	return true;
}

void TCSignal::SetMagnitudeAndPhaseType(int record_type, CString CText)
{
	if(CText.GetAt(0) == '@')// used on currents
	{
		magnitude_and_phase_type = false;// no phase data

		return;
	}

	if(record_type == E_SPICE_RECORD_DC || record_type == E_SPICE_RECORD_NOISE_SPECTRAL ||
	   record_type == E_SPICE_RECORD_NOISE_INTEGRATED || record_type == E_SPICE_RECORD_TRANSIENT ||
	   record_type == E_SPICE_RECORD_OPERATING_POINT)
	{
		magnitude_and_phase_type = false;

		return;
	}

	magnitude_and_phase_type = true;
}

int TCSignal::AddBinaryData(double data1, double data2, int index, int type)
{
	if(type == E_SPICE_RECORD_NOISE_SPECTRAL || 
		type == E_SPICE_RECORD_NOISE_INTEGRATED)
	{
		if(data1 < 0) data1 = -data1;// should always be positive, but spice is fucked

		data1 = sqrt(data1);
	}

	if(type == E_SPICE_RECORD_AC && CName.GetAt(0) != 'v')// zero out AC currents if not v source
	{
		if(!(CName.Find("[i") < 0) || !(CName.Find("[p") < 0))
		{
			data1 = 0;
			data2 = 0;
		}
	}

	CMagnitudeData.CX[index] = data1;

	if(!magnitude_and_phase_type) return true;

	CPhaseData.CX[index] = data2;
	
	if(type != -1 && type != E_SPICE_RECORD_POLE_ZERO  && type != E_SPICE_RECORD_SENSITIVITY) RectangulerToPolar(index);	// let default be in this form

	if(type == E_SPICE_RECORD_SENSITIVITY) already_polar = true;

	return true;
}

int TCSignal::AddData(CString CText, int index, int type)
{
	CString CTemp, CError;

	CTemp = GetFirstWord(CText, ',');

	double d_data, i_data;

	int error_index = CTemp.Find('e');// eliminate < e-308 errors

	 if(error_index < 0) d_data = strtod(CTemp, '\0');
	 else
	 {
		CError = CTemp.Right(CTemp.GetLength() - error_index - 2);

		i_data = strtod(CError, '\0');

		if(fabs(i_data) > 306) d_data = 0.0;
		else d_data = strtod(CTemp, '\0');
	 }

	GetSafeFloat(d_data);


	if(type == E_SPICE_RECORD_NOISE_SPECTRAL || 
		type == E_SPICE_RECORD_NOISE_INTEGRATED)
	{
		if(d_data < 0) d_data = -d_data;// should always be positive, but spice ifs fucked

		d_data = sqrt(d_data);
	}

	CMagnitudeData.CX[index] = d_data;

	if(!magnitude_and_phase_type) return true;

	CText = RemoveFirstWord(CText, ',');
	
	 error_index = CText.Find('e');// eliminate < e-308 errors

	 if(error_index < 0) d_data = strtod(CText, '\0');
	 else
	 {
		CError = CText.Right(CTemp.GetLength() - error_index - 2);

		i_data = strtod(CError, '\0');

		if(fabs(i_data) > 306) d_data = 0.0;
		else d_data = strtod(CText, '\0');
	 }

	GetSafeFloat(d_data);

	CPhaseData.CX[index] = d_data;// no checking for speed, ok by design
	
	if(type != -1 && type != E_SPICE_RECORD_POLE_ZERO && type != E_SPICE_RECORD_SENSITIVITY) 
	{
		RectangulerToPolar(index);	// let default be in this form
	}

	if(type == E_SPICE_RECORD_SENSITIVITY) already_polar = true;

	return 0;
}

void TCSignal::RectangulerToPolar(int index)
{
	double real = 0.0;
	double imag = 0.0;

	real = CMagnitudeData.CX[index];// can give me a -1.#IND000000000
	imag = CPhaseData.CX[index];

	if(!real && !imag)
	{
		CMagnitudeData.CX[index] = 0.0;
		CPhaseData.CX[index]	 = 0.0;

		return;
	}

	CPhaseData.CX[index] = atan2(imag, real);

//	CPhaseData.CX[index] = ArcTanNegitive(imag, real);

	real = real * real;
	imag = imag * imag;

	CMagnitudeData.CX[index] = sqrt(real + imag);
}


void TCSignal::PolarToRectanguler(int index)
{
	double mag	= CMagnitudeData.CX[index];
	double phase = CPhaseData.CX[index];

	double fmag, fphase;// this is to get rid of the fucking exceptions

	fmag	= (double) mag;
	fphase	= (double) phase;

	mag		= (double) fmag;
	phase	= (double) fphase;

	CMagnitudeData.CX[index] = mag*cos(phase);
	CPhaseData.CX[index]	 = mag*sin(phase);
}

void TCSignal::MakePhaseContinuous(void)
{
	// called only once and immediatly after data is loaded
	// this is not foolproof, 

	int count = CPhaseData.CX.GetSize();

	if(!count) return;

	int p, n;

	double next_data, last_data, diff, max_test, min_test, pi, pi_test;

	max_test;
	min_test;

	pi		= 3.14159265358979;
	diff	= 0.0;
	n		= 0;
//	max_test = pi - 0.05;// how close to the pi is the data
//	min_test = -pi + 0.05;// this will only work if enougth points are taken
//	pi_test = pi * 2 * 0.95;// how close to 2 * pi is the data jump
	pi_test = pi * 1.1; // Dec 14th 2014, changed to reduce the detected step change

	last_data	= CPhaseData.CX[0];

	for(p = 1; p < count; p++)
	{
		next_data = CPhaseData.CX[p];

		// first detect the discontinuity at n * pi_div
		diff = next_data - last_data;

		// Removed this check Dec 14th 2014. Any large step may be assumed to be non real phase jump  
//		if(next_data > max_test || next_data < min_test)// data is restricted to +/- pi
		{
			// is phase difference large enough to be a discontinuity

			if(diff > pi_test)	
				n--;// draw a phase graph to see this

			if(diff < -pi_test)	
				n++;
		}

		last_data = next_data;

		if(n) CPhaseData.CX[p] = next_data + 2 * n * pi;
	}
}

int	TCSignal::GetXAxisType(void)
{
	if(!phase_axis)
	{
		return TE_SIGNAL_DISPLAY_MAGNITUDE;
	}

	return TE_SIGNAL_DISPLAY_PHASE_DEG;
}

void TCSignal::RectangulerToPolar(void)
{
	if(already_polar) return;

	already_polar = true;

	int mcount = CMagnitudeData.CX.GetSize();
	int pcount = CPhaseData.CX.GetSize();

	if(!mcount || !pcount) return;

	if(mcount != pcount) return;

	for(int p = 0; p < mcount; p++)
	{
		RectangulerToPolar(p);
	}
}

void TCSignal::PolarToRectanguler(void)
{
	if(!already_polar) return;// already converted so leave alone

	already_polar = false;

	int mcount = CMagnitudeData.CX.GetSize();
	int pcount = CPhaseData.CX.GetSize();

	if(!mcount || !pcount) return;

	if(mcount != pcount) return;

	for(int p = 0; p < mcount; p++)
	{
		PolarToRectanguler(p);
	}
}

void TCSignal::ClearGraphPointToMagData(void)
{
	int count = GraphPointToMagDataIndex.GetSize();

	if(!count) return;

	for(int p = 0; p < count; p++)
	{
		GraphPointToMagDataIndex[p] = -1;
	}
}

void TCSignal::FormatGraphPointToMagDataIndex(long start, long stop)
{
	long size = max_points - min_points + 1;

	if(start < 0) start = 0;
	if(!(start < size)) start = 0;
	if(stop < 0) stop = 0;
	if(!(stop < size)) stop = size;
	if(!stop) stop = size;

//	GraphPointToMagDataIndex.SetSize(size);

	if(size != GraphPointToMagDataIndex.GetSize())
	{
		ASSERT(0);

		return;
	}

	int index = 0;
	long point;
	long last_found_index = 0; 

	for(point = start; point < stop; point++)
	{
		index = GraphPointToMagDataIndex[point];
		
		if(index == -1) GraphPointToMagDataIndex[point] = last_found_index;
		else last_found_index = index;

	}
}

long TCSignal::GetDataPoint(int p, int type, double &gain, double &offset)
{
	if(p < 0) return 0;
//	if(!phase_axis)
	long long_data = 0;
	double test;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)// this function is for x axis data
	{
		test = CMagnitudeData.CX[p];

		long_data = (long)((test * gain + offset) * points_per_float + min_points + 0.5);
	}

	else if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		test = CMagnitudeData.GetDBValue(p);

		long_data =  (long)((test * gain + offset) * points_per_float + min_points + 0.5);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		test = CPhaseData.CX[p];

		long_data =  (long)((test * gain + offset) * phase_points_per_float + min_phase_points + 0.5);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
	{
		test = CPhaseData.CX[p];

		long_data =  (long)((test * gain + offset) * phase_points_per_float + min_phase_points + 0.5);
	}

	return long_data;
}

long TCSignal::GetDataPoint(int p, int type)
{
	if(p < 0) return 0;

	double offset = (double) y_offset;
	double gain	 = (double) y_gain;
	long long_data = 0;
	double test;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		test = CMagnitudeData.CX[p];

		long_data =  (long)((test * gain + offset) * points_per_float + min_points + 0.5);
	}

	else if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		test = CMagnitudeData.GetDBValue(p);

		long_data =  (long) ((test + offset) * gain * points_per_float + min_points + 0.5);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		offset = (double) y_phase_offset;
		gain   = (double) y_phase_gain;

		long_data =  (long)(((CPhaseData.CX[p] * gain + offset) * 57.29577951308) * phase_points_per_float + min_phase_points + 0.5);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
	{
		offset = (double) y_phase_offset;
		gain   = (double) y_phase_gain;

		long_data =  (long)((CPhaseData.CX[p] * gain + offset) * phase_points_per_float + min_phase_points + 0.5);
	}

	return long_data;
}

long TCSignal::GetLogDataPoint(int p, int type, double &gain, double &offset)
{
	if(p < 0) return 0;
	double data;
	long long_data = 0;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		data = CMagnitudeData.CX[p] * gain + offset;

		if(data < 0) return 0;

		data = Log(data);

		long_data =  (long)(data * points_per_float + min_points);
	}

	else if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		data = CMagnitudeData.GetDBValue(p);

		if(data < 0) return 0;

		data = Log(data);
		
		long_data =  (long) ((data + offset) * gain * points_per_float + min_points);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		data = CPhaseData.CX[p] * gain + offset;

		if(data < 0) return 0;

		data = Log(data * 57.29577951308);

		long_data =  (long)((data * gain + offset)  * phase_points_per_float + min_phase_points);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
	{
		data = CPhaseData.CX[p] * gain + offset;

		if(data < 0) return 0;

		data = Log(data);

		long_data =  (long)((data * gain + offset)  * phase_points_per_float + min_phase_points);	
	}

	return long_data;
}

long TCSignal::GetLogDataPoint(int p, int type)
{
	if(p < 0) return 0;

	double offset = (double) y_offset;
	double gain	 = (double) y_gain;

	double data;
	long long_data = 0;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		data = CMagnitudeData.CX[p] * gain + offset;

		data = Log(data);

		long_data =  (long)(data * points_per_float + min_points);
	}

	else if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		data = CMagnitudeData.GetDBValue(p);

		data = Log(data);
		
		long_data =  (long) ((data + offset) * gain * points_per_float + min_points);
	}
	else if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		offset = (double) y_phase_offset;
		gain   = (double) y_phase_gain;

		data = CPhaseData.CX[p] * gain + offset;

		if(data < 0) data = -data;

		data = Log(data * 57.29577951308);

		long_data =  (long)((data * gain + offset)  * phase_points_per_float + min_phase_points);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
	{
		offset = (double) y_phase_offset;
		gain   = (double) y_phase_gain;

		data = CPhaseData.CX[p] * gain + offset;

		if(data < 0) data = -data;

		data = Log(data);

		long_data =  (long)((data * gain + offset)  * phase_points_per_float + min_phase_points);	
	}

	return long_data;
}

double TCSignal::GetDataValue(int index, int type)
{
	if(index < 0) return 0.0;

	if(!(index < CMagnitudeData.CX.GetSize())) return 0.0;

	double data = 0.0;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		data = (double)(CMagnitudeData.CX[index]);
	}

	else if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		data = (double)(20 * Log(CMagnitudeData.CX[index]));
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		if(!(index < CPhaseData.CX.GetSize())) return 0.0;

		data = (double)(57.29577951308 * CPhaseData.CX[index]);
	}

	else if(type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
	{
		if(!(index < CPhaseData.CX.GetSize())) return 0.0;

		data = (double)(CPhaseData.CX[index]);
	}
	
	// need negitaive data as well
	return data;
}

double TCSignal::GetDataValue(long data, int type)
{
	double offset;
	double gain;

	offset = (double) y_offset;
	gain	 = (double) y_gain;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		return (double)(((data - min_points)/points_per_float - offset) / gain);
	}

	if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		return (double)(((data - min_points)/points_per_float - offset) / gain);
	}

	offset = (double) y_phase_offset;
	gain   = (double) y_phase_gain;

	if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		return (double)(((data - min_phase_points)/phase_points_per_float - offset) / gain);
	}

	return (double)(((data - min_phase_points)/phase_points_per_float - offset) / gain);
}

double TCSignal::GetDataValue(long data, int type, double gain, double offset)
{
	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		return (double)(((data - min_points)/points_per_float - offset) / gain);
	}

	if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		return (double)(((data - min_points)/points_per_float - offset) / gain);
	}

	if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		return (double)(((data - min_phase_points)/phase_points_per_float - offset) / gain);
	}

	return (double)(((data - min_phase_points)/phase_points_per_float - offset) / gain);
}

double TCSignal::GetAntiLogDataValue(long data, int type)
{
	double offset = 0.0;
	double gain = 1.0;
	double value = 0.0;
	double f_value = 0.0;

	offset = (double) y_offset;
	gain	 = (double) y_gain;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		value = (data - min_points)/points_per_float;

		value = AntiLog(value);

		f_value = (double)((value - offset) / gain);

		return f_value;
	}

	if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		value = (data - min_points)/points_per_float;

		value = AntiLog(value);

		f_value = (double)((value - offset) / gain);

		return f_value;
	}

	offset = (double) y_phase_offset;
	gain   = (double) y_phase_gain;

	if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		value = (data - min_phase_points)/phase_points_per_float;

		value = AntiLog(value);

		f_value = (double)((value - offset) / gain);

		return f_value;
	}

	value = (data - min_phase_points)/phase_points_per_float;

	value = AntiLog(value);

	f_value = (double)((value - offset) / gain);

	return f_value;
}

double TCSignal::GetAntiLogDataValue(long data, int type, double gain, double offset)
{
	double value = 0.0;
	double f_value = 0.0;

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		value = (data - min_points)/points_per_float;

		value = AntiLog(value);

		f_value = (double)((value - offset) / gain);

		return f_value;
	}

	if(type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		value = (data - min_points)/points_per_float;

		value = AntiLog(value);

		f_value = (double)((value - offset) / gain);

		return f_value;
	}

	if(type == TE_SIGNAL_DISPLAY_PHASE_DEG)
	{
		value = (data - min_phase_points)/phase_points_per_float;

		value = AntiLog(value);

		value = (double)((value - offset) / gain);

		return f_value;
	}

	value = (data - min_phase_points)/phase_points_per_float;

	value = AntiLog(value);

	value = (double)((value - offset) / gain);

	return f_value;
}

////////////////////////////////////////////////
////////////////////////////////////////////////
TCOutputWaveformDataHeader::TCOutputWaveformDataHeader(void)
{
	index		= 0;
	PCSignals	= NULL;
	PCDoc		= NULL;
	type		= E_SPICE_RECORD_NULL;
	signal_mag_max		= 1.0;
	signal_mag_min		= 0.0;
	signal_phase_max	= 1.0;
	signal_phase_min	= 0.0;

	axis_normal_colour		= RGB(0, 0, 255);
	axis_selected_colour	= RGB(255, 0, 0);
	axis_highlighted_colour	= RGB(0, 255, 255);
	grid_colour				= RGB(255, 255, 255);
	background_colour		= RGB(0, 0, 0);
	x_major_grid_size		= 100;
	x_minor_grid_size		= 10;
	y_major_grid_size		= 100;
	y_minor_grid_size		= 10;

	x_major_grid_number		= 10;// default w = 1000, h = 500
	x_minor_grid_number		= 10;
	y_major_grid_number		= 4;
	y_minor_grid_number		= 10;

	x_grid_decades			= false;
	y_grid_decades			= false;
	y_phase_grid_decades		= false;

	x_manual					= 0;
	y_manual					= 0;//auto on
	y_phase_manual			= 0;
	x_max					= 1.0;
	y_max					= 1.0;
	x_min					= 0.0;
	y_min					= 0.0;
	signal_index			= 0;
	axis_index				= 0;
	y_mag_div				= 1.0;
	y_phase_div				= 30.0;
	x_mag_div				= 1.0;
 
	y_phase_major_grid_size		= 100;
	y_phase_minor_grid_size		= 25;
	y_phase_major_grid_number	= 5;
	y_phase_minor_grid_number	= 1;

	x_manual_major_grid_number			= 10;
	y_manual_major_grid_number			= 4;
	y_manual_phase_major_grid_number	= 5;

	x_manual_minor_grid_number			= 10;
	y_manual_minor_grid_number			= 10;
	y_manual_phase_minor_grid_number	= 1;


	y_phase_min				= -180;
	y_phase_max				= 180;

	multy_magnitude_axis	= false;
	multy_phase_axis		= false;
	active_magnitude_axis_index		= -1;
	active_phase_axis_index = -1;
	inteligent_signal_default = true;
	inteligent_signal_magnitude = 0;
	inteligent_signal_phase     = 0;

	CTitle.LoadString(IDS_DEFAULT_WAVE_TITLE); 
	CPlotName.LoadString(IDS_DEFAULT_PLOT_NAME);
	CDateAndTime.LoadString(IDS_DEFAULT_DATE_AND_TIME);
	CFileName.LoadString(IDS_DEFAULT_FILE_NAME);

	run_selected	= true;
	select_all_runs	= true;
	run_index		= 0;
	f_first			= true;// for setting up initial defaults for each type of record
	magnitude_db		= -1;

	CZoomRectangle.SetRectEmpty();

	PCWaveformDataRuns = NULL;
}

TCOutputWaveformDataHeader::TCOutputWaveformDataHeader(TCOutputWaveformDataHeader &COutputWaveformDataHeader)
{
	*this = COutputWaveformDataHeader;
}

TCOutputWaveformDataHeader::~TCOutputWaveformDataHeader(void)
{

}

void TCOutputWaveformDataHeader::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int p, count;
	int save_serialize = 12345678;
	int load_serialize = 3456;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << index;
		CArchiveFile << CTitle;
		CArchiveFile << CDateAndTime;
		CArchiveFile << CPlotName;
		CArchiveFile << CFlags;
		CArchiveFile << CNumberOfVariables;
		CArchiveFile << CNumberOfPoints;
		CArchiveFile << CCommand;
		CArchiveFile << CVariable;
		CArchiveFile << CBinaryOrValues;
		CArchiveFile << CFileName;
		CArchiveFile << axis_normal_colour;
		CArchiveFile << axis_selected_colour;
		CArchiveFile << axis_highlighted_colour;
		CArchiveFile << grid_colour;
		CArchiveFile << background_colour;
		CArchiveFile << type;
		CArchiveFile << CAxisName;

		CArchiveFile << x_major_grid_size;
		CArchiveFile << x_minor_grid_size;
		CArchiveFile << x_major_grid_number;
		CArchiveFile << x_minor_grid_number;
		CArchiveFile << x_grid_decades;
		CArchiveFile << x_manual;
		CArchiveFile << x_mag_div;
		CArchiveFile << x_max;
		CArchiveFile << x_min;

		CArchiveFile << y_major_grid_size;
		CArchiveFile << y_minor_grid_size;
		CArchiveFile << y_major_grid_number;
		CArchiveFile << y_minor_grid_number;
		CArchiveFile << y_grid_decades;
		CArchiveFile << y_manual;
		CArchiveFile << y_mag_div;
		CArchiveFile << y_max;
		CArchiveFile << y_min;

		CArchiveFile << y_phase_major_grid_size;
		CArchiveFile << y_phase_minor_grid_size;
		CArchiveFile << y_phase_major_grid_number;
		CArchiveFile << y_phase_minor_grid_number;
		CArchiveFile << y_phase_grid_decades;
		CArchiveFile << y_phase_manual;
		CArchiveFile << y_phase_div;
		CArchiveFile << y_phase_min;
		CArchiveFile << y_phase_max;
		CArchiveFile << x_manual_major_grid_number;
		CArchiveFile << y_manual_major_grid_number;
		CArchiveFile << y_manual_phase_major_grid_number;
		CArchiveFile << x_manual_minor_grid_number;
		CArchiveFile << y_manual_minor_grid_number;
		CArchiveFile << y_manual_phase_minor_grid_number;
			
		CArchiveFile << signal_index;
		CArchiveFile << axis_index;

		CArchiveFile << multy_magnitude_axis;
		CArchiveFile << multy_phase_axis;

		CArchiveFile << active_magnitude_axis_index;
		CArchiveFile << active_phase_axis_index;
			
		CArchiveFile << run_selected;
		CArchiveFile << real_and_imaginary;
		CArchiveFile << f_first;
		CArchiveFile << inteligent_signal_default;
		CArchiveFile << inteligent_signal_magnitude;
		CArchiveFile << inteligent_signal_phase;

		count = CVariables.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CVariables[p];
	}
	else
	{
		CArchiveFile >> index;
		CArchiveFile >> CTitle;
		CArchiveFile >> CDateAndTime;
		CArchiveFile >> CPlotName;
		CArchiveFile >> CFlags;
		CArchiveFile >> CNumberOfVariables;
		CArchiveFile >> CNumberOfPoints;
		CArchiveFile >> CCommand;
		CArchiveFile >> CVariable;
		CArchiveFile >> CBinaryOrValues;
		CArchiveFile >> CFileName;
		CArchiveFile >> axis_normal_colour	;
		CArchiveFile >> axis_selected_colour;
		CArchiveFile >> axis_highlighted_colour;
		CArchiveFile >> grid_colour;
		CArchiveFile >> background_colour;
		CArchiveFile >> type;
		CArchiveFile >> CAxisName;

		CArchiveFile >> x_major_grid_size;
		CArchiveFile >> x_minor_grid_size;
		CArchiveFile >> x_major_grid_number;
		CArchiveFile >> x_minor_grid_number;
		CArchiveFile >> x_grid_decades;
		CArchiveFile >> x_manual;
		CArchiveFile >> x_mag_div;
		CArchiveFile >> x_max;
		CArchiveFile >> x_min;

		CArchiveFile >> y_major_grid_size;
		CArchiveFile >> y_minor_grid_size;
		CArchiveFile >> y_major_grid_number;
		CArchiveFile >> y_minor_grid_number;
		CArchiveFile >> y_grid_decades;
		CArchiveFile >> y_manual;
		CArchiveFile >> y_mag_div;
		CArchiveFile >> y_max;
		CArchiveFile >> y_min;

		CArchiveFile >> y_phase_major_grid_size;
		CArchiveFile >> y_phase_minor_grid_size;
		CArchiveFile >> y_phase_major_grid_number;
		CArchiveFile >> y_phase_minor_grid_number;
		CArchiveFile >> y_phase_grid_decades;
		CArchiveFile >> y_phase_manual;
		CArchiveFile >> y_phase_div;
		CArchiveFile >> y_phase_min;
		CArchiveFile >> y_phase_max;
		CArchiveFile >> x_manual_major_grid_number;
		CArchiveFile >> y_manual_major_grid_number;
		CArchiveFile >> y_manual_phase_major_grid_number;
		CArchiveFile >> x_manual_minor_grid_number;
		CArchiveFile >> y_manual_minor_grid_number;
		CArchiveFile >> y_manual_phase_minor_grid_number;
			
		CArchiveFile >> signal_index;
		CArchiveFile >> axis_index;

		CArchiveFile >> multy_magnitude_axis;
		CArchiveFile >> multy_phase_axis;

		CArchiveFile >> active_magnitude_axis_index;
		CArchiveFile >> active_phase_axis_index;
			
		CArchiveFile >> run_selected;
		CArchiveFile >> real_and_imaginary;
		CArchiveFile >> f_first;
		CArchiveFile >> inteligent_signal_default;
		CArchiveFile >> inteligent_signal_magnitude;
		CArchiveFile >> inteligent_signal_phase;
		
		CArchiveFile >> count;

		CVariables.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CVariables[p];
	}

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_serialize;
	}
	else
	{
		CArchiveFile >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_DATA_FILE);

			return;
		}
	}
}
void TCOutputWaveformDataHeader::operator = (TCOutputWaveformDataHeader &COutputWaveformDataHeader)
{
	PCDoc				= COutputWaveformDataHeader.PCDoc;
//	index				= COutputWaveformDataHeader.index;// should not mbe messed with
	axis_index			= COutputWaveformDataHeader.axis_index;
	CTitle				= COutputWaveformDataHeader.CTitle;
	CDateAndTime		= COutputWaveformDataHeader.CDateAndTime;
	CPlotName			= COutputWaveformDataHeader.CPlotName;
	CFlags				= COutputWaveformDataHeader.CFlags;
	CNumberOfVariables	= COutputWaveformDataHeader.CNumberOfVariables;
	CNumberOfPoints		= COutputWaveformDataHeader.CNumberOfPoints;
	CCommand			= COutputWaveformDataHeader.CCommand;
	CVariable			= COutputWaveformDataHeader.CVariable;
	CBinaryOrValues		= COutputWaveformDataHeader.CBinaryOrValues;
	type				= COutputWaveformDataHeader.type;
	CFileName			= COutputWaveformDataHeader.CFileName;
	PCSignals			= COutputWaveformDataHeader.PCSignals;
	PCWaveformDataRuns  = COutputWaveformDataHeader.PCWaveformDataRuns;
	CDataType			= COutputWaveformDataHeader.CDataType;

	signal_mag_max		= COutputWaveformDataHeader.signal_mag_max;
	signal_mag_min		= COutputWaveformDataHeader.signal_mag_min;
	signal_phase_max	= COutputWaveformDataHeader.signal_phase_max;
	signal_phase_min	= COutputWaveformDataHeader.signal_phase_min;

	axis_normal_colour		= COutputWaveformDataHeader.axis_normal_colour;
	axis_selected_colour	= COutputWaveformDataHeader.axis_selected_colour;
	axis_highlighted_colour	= COutputWaveformDataHeader.axis_highlighted_colour;
	grid_colour				= COutputWaveformDataHeader.grid_colour;
	background_colour		= COutputWaveformDataHeader.background_colour;
	CAxisName				= COutputWaveformDataHeader.CAxisName;
	f_first 				= COutputWaveformDataHeader.f_first;
	

	x_major_grid_size		= COutputWaveformDataHeader.x_major_grid_size;
	x_minor_grid_size		= COutputWaveformDataHeader.x_minor_grid_size;
	x_major_grid_number		= COutputWaveformDataHeader.x_major_grid_number;
	x_minor_grid_number		= COutputWaveformDataHeader.x_minor_grid_number;
	x_grid_decades			= COutputWaveformDataHeader.x_grid_decades;
	x_manual				= COutputWaveformDataHeader.x_manual;
	x_mag_div				= COutputWaveformDataHeader.x_mag_div;
	x_max					= COutputWaveformDataHeader.x_max;
	x_min					= COutputWaveformDataHeader.x_min;

	y_major_grid_size		= COutputWaveformDataHeader.y_major_grid_size;
	y_minor_grid_size		= COutputWaveformDataHeader.y_minor_grid_size;
	y_major_grid_number		= COutputWaveformDataHeader.y_major_grid_number;
	y_minor_grid_number		= COutputWaveformDataHeader.y_minor_grid_number;
	y_grid_decades			= COutputWaveformDataHeader.y_grid_decades;
	y_manual				= COutputWaveformDataHeader.y_manual;
	y_mag_div				= COutputWaveformDataHeader.y_mag_div;
	y_max					= COutputWaveformDataHeader.y_max;
	y_min					= COutputWaveformDataHeader.y_min;

	y_phase_major_grid_size		= COutputWaveformDataHeader.y_phase_major_grid_size;
	y_phase_minor_grid_size		= COutputWaveformDataHeader.y_phase_minor_grid_size;
	y_phase_major_grid_number	= COutputWaveformDataHeader.y_phase_major_grid_number;
	y_phase_minor_grid_number	= COutputWaveformDataHeader.y_phase_minor_grid_number;
	y_phase_grid_decades		= COutputWaveformDataHeader.y_phase_grid_decades;
	y_phase_manual			= COutputWaveformDataHeader.y_phase_manual;
	y_phase_div					= COutputWaveformDataHeader.y_phase_div;
	y_phase_min					= COutputWaveformDataHeader.y_phase_min;
	y_phase_max					= COutputWaveformDataHeader.y_phase_max;
			
	x_manual_major_grid_number		= COutputWaveformDataHeader.x_manual_major_grid_number;
	y_manual_major_grid_number		= COutputWaveformDataHeader.y_manual_major_grid_number;
	y_manual_phase_major_grid_number= COutputWaveformDataHeader.y_manual_phase_major_grid_number;
	x_manual_minor_grid_number		= COutputWaveformDataHeader.x_manual_minor_grid_number;
	y_manual_minor_grid_number		= COutputWaveformDataHeader.y_manual_minor_grid_number;
	y_manual_phase_minor_grid_number= COutputWaveformDataHeader.y_manual_phase_minor_grid_number;

	signal_index				= COutputWaveformDataHeader.signal_index;
	axis_index					= COutputWaveformDataHeader.axis_index;

	multy_magnitude_axis		= COutputWaveformDataHeader.multy_magnitude_axis;
	multy_phase_axis			= COutputWaveformDataHeader.multy_phase_axis;

	active_magnitude_axis_index	= COutputWaveformDataHeader.active_magnitude_axis_index;
	active_phase_axis_index		= COutputWaveformDataHeader.active_phase_axis_index;
			
	inteligent_signal_default	= COutputWaveformDataHeader.inteligent_signal_default;
	inteligent_signal_magnitude = COutputWaveformDataHeader.inteligent_signal_magnitude;
	inteligent_signal_phase		= COutputWaveformDataHeader.inteligent_signal_phase;

	run_selected				= COutputWaveformDataHeader.run_selected;
	real_and_imaginary			= COutputWaveformDataHeader.real_and_imaginary;

	CZoomRectangle = COutputWaveformDataHeader.CZoomRectangle;

	int p, count;

	count = COutputWaveformDataHeader.CVariables.GetSize();

	CVariables.SetSize(count);

	for(p = 0; p < count; p++)
	{
		CVariables[p] = COutputWaveformDataHeader.CVariables[p];
	}

	count = COutputWaveformDataHeader.CDisplayedSignalsList.GetSize();

	CDisplayedSignalsList.SetSize(count);

	for(p = 0; p < count; p++) CDisplayedSignalsList[p] = COutputWaveformDataHeader.CDisplayedSignalsList[p];

	count = COutputWaveformDataHeader.CSignalEnablesList.GetSize();

	CSignalEnablesList.SetSize(count);

	for(p = 0; p < count; p++) CSignalEnablesList[p] = COutputWaveformDataHeader.CSignalEnablesList[p];
}

void  TCOutputWaveformDataHeader::SyncAllRuns(void)
{
	// This is a fuckup in class design. I should not have had common data doublicated in all runs
	if(!PCWaveformDataRuns) return;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count) return;

	if(!PCWaveformDataRuns->CRuns[0]) return;

	for(int p = 0; p < count; p++)
	{
		if(!(type < PCWaveformDataRuns->CRuns[p]->CRecords.GetSize())) return;

		TCOutputWaveformDataHeader &COutputWaveformDataHeader = PCWaveformDataRuns->CRuns[p]->CRecords[type].CHeader;

		COutputWaveformDataHeader.axis_index		= axis_index;
		COutputWaveformDataHeader.CTitle			= CTitle;
		COutputWaveformDataHeader.CDateAndTime		= CDateAndTime;
		COutputWaveformDataHeader.CPlotName			= CPlotName;

		COutputWaveformDataHeader.signal_mag_max	= signal_mag_max;
		COutputWaveformDataHeader.signal_mag_min	= signal_mag_min;
		COutputWaveformDataHeader.signal_phase_max	= signal_phase_max;
		COutputWaveformDataHeader.signal_phase_min	= signal_phase_min;

		COutputWaveformDataHeader.axis_normal_colour		= axis_normal_colour;
		COutputWaveformDataHeader.axis_selected_colour		= axis_selected_colour;
		COutputWaveformDataHeader.axis_highlighted_colour	= axis_highlighted_colour;
		COutputWaveformDataHeader.grid_colour				= grid_colour;
		COutputWaveformDataHeader.background_colour			= background_colour;
		COutputWaveformDataHeader.CAxisName					= CAxisName;

		COutputWaveformDataHeader.x_major_grid_size		= x_major_grid_size;
		COutputWaveformDataHeader.x_minor_grid_size		= x_minor_grid_size;
		COutputWaveformDataHeader.x_major_grid_number	= x_major_grid_number;
		COutputWaveformDataHeader.x_minor_grid_number	= x_minor_grid_number;
		COutputWaveformDataHeader.x_grid_decades		= x_grid_decades;
		COutputWaveformDataHeader.x_manual				= x_manual;
		COutputWaveformDataHeader.x_mag_div				= x_mag_div;
		COutputWaveformDataHeader.x_max					= x_max;
		COutputWaveformDataHeader.x_min					= x_min;

		COutputWaveformDataHeader.y_major_grid_size		= y_major_grid_size;
		COutputWaveformDataHeader.y_minor_grid_size		= y_minor_grid_size;
		COutputWaveformDataHeader.y_major_grid_number	= y_major_grid_number;
		COutputWaveformDataHeader.y_minor_grid_number	= y_minor_grid_number;
		COutputWaveformDataHeader.y_grid_decades		= y_grid_decades;
		COutputWaveformDataHeader.y_manual				= y_manual;

		COutputWaveformDataHeader.y_phase_major_grid_size	= y_phase_major_grid_size;
		COutputWaveformDataHeader.y_phase_minor_grid_size	= y_phase_minor_grid_size;
		COutputWaveformDataHeader.y_phase_major_grid_number	= y_phase_major_grid_number;
		COutputWaveformDataHeader.y_phase_minor_grid_number	= y_phase_minor_grid_number;
		COutputWaveformDataHeader.y_phase_grid_decades		= y_phase_grid_decades;
		COutputWaveformDataHeader.y_phase_manual		= y_phase_manual;
			
		COutputWaveformDataHeader.x_manual_major_grid_number		= x_manual_major_grid_number;
		COutputWaveformDataHeader.y_manual_major_grid_number		= y_manual_major_grid_number;
		COutputWaveformDataHeader.y_manual_phase_major_grid_number	= y_manual_phase_major_grid_number;
		COutputWaveformDataHeader.x_manual_minor_grid_number		= x_manual_minor_grid_number;
		COutputWaveformDataHeader.y_manual_minor_grid_number		= y_manual_minor_grid_number;
		COutputWaveformDataHeader.y_manual_phase_minor_grid_number= y_manual_phase_minor_grid_number;

		COutputWaveformDataHeader.signal_index				= signal_index;
		COutputWaveformDataHeader.axis_index				= axis_index;

		COutputWaveformDataHeader.multy_magnitude_axis		= multy_magnitude_axis;
		COutputWaveformDataHeader.multy_phase_axis			= multy_phase_axis;

		COutputWaveformDataHeader.active_magnitude_axis_index	= active_magnitude_axis_index;
		COutputWaveformDataHeader.active_phase_axis_index		= active_phase_axis_index;
			
		COutputWaveformDataHeader.inteligent_signal_default		= inteligent_signal_default;
		COutputWaveformDataHeader.inteligent_signal_magnitude	= inteligent_signal_magnitude;
		COutputWaveformDataHeader.inteligent_signal_phase		= inteligent_signal_phase;

		COutputWaveformDataHeader.real_and_imaginary			= real_and_imaginary;
	}
}

void TCOutputWaveformDataHeader::DisplayError(CString CDescription, CString CErrorMsg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(CDescription, CErrorMsg, error_code);
}

void TCOutputWaveformDataHeader::DisplayError(int des, CString CErrorMsg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(des, CErrorMsg, error_code);
}

void TCOutputWaveformDataHeader::DisplayError(int des, int msg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(des, msg, error_code);
}

///////
int TCOutputWaveformDataHeader::GetNumberOfDisplayedSignals(void)
{
	if(!PCSignals) return -1;

	if(IsBadReadPtr(PCSignals, 4))
	{
		ASSERT(0);

		return -1;
	}

	int counter = 0;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(count)
	if(IsBadCodePtr((FARPROC)&CSignals[0]))
	{
		return -1; 
	}


	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		if(CSignal.magnitude != -1) counter++;
		else if(CSignal.phase != -1) counter++;
	}

	return counter;
}

bool TCOutputWaveformDataHeader::IsAnyMagnitudesDisplayed(void)
{
	if(!PCSignals) return false;

	if(IsBadReadPtr(PCSignals, 4))
	{
		ASSERT(0);

		return false;
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(count)
	if(IsBadCodePtr((FARPROC)&CSignals[0]))
	{
		return false; 
	}

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		if(CSignal.magnitude != -1) return true;
	}

	return false;
}

bool TCOutputWaveformDataHeader::IsAnyPhaseDisplayed(void)
{
	if(!PCSignals) return false;

	if(IsBadReadPtr(PCSignals, 4))
	{
		ASSERT(0);

		return false;
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(count)
	if(IsBadCodePtr((FARPROC)&CSignals[0]))
	{
		return false; 
	}

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		if(CSignal.phase != -1) return true;
	}

	return false;
}

int	TCOutputWaveformDataHeader::GetFirstDisplayedSignal(void)
{
	if(!PCSignals) return -1;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return -1; 
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(count)
	if(IsBadCodePtr((FARPROC)&CSignals[0]))
	{
		ASSERT(0);

		return -1; 
	}

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		if(CSignal.magnitude != -1) return p;
		if(CSignal.phase != -1) return p;
	}

	return -1;
}

void TCOutputWaveformDataHeader::SetDisplayedSignals(TCOutputWaveformDataHeader &CHeader)
{
	if(!PCSignals) return;
	if(IsBadCodePtr((FARPROC)PCSignals))  return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(!count)  return;

	if(IsBadCodePtr((FARPROC)&CSignals[0]))  return;

	int signal_list_count = CHeader.CDisplayedSignalsList.GetSize();
	int displayed_counter = 0;
	int index;

	TCDisplayedSignals *PCDisplayedSignal;

	int p;

	for(p = 0; p < count; p++)//Clear old
	{
		TCSignal &CSignal = CSignals[p];

		CSignal.magnitude	= -1;
		CSignal.phase		= -1;
	}

	for(p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		if(!(displayed_counter < signal_list_count)) return;//finished

		CSignal.magnitude	= -1;
		CSignal.phase		= -1;

		PCDisplayedSignal = &CHeader.CDisplayedSignalsList[displayed_counter];
		
		index = PCDisplayedSignal->index1;

		if(p != index) continue;

		if(PCDisplayedSignal->magnitude != -1)
		{
			CSignal.magnitude = PCDisplayedSignal->magnitude;

			displayed_counter++;
		}

		if(!(displayed_counter < signal_list_count)) return;

		PCDisplayedSignal = &CHeader.CDisplayedSignalsList[displayed_counter];

		index = PCDisplayedSignal->index1;

		if(p != index) continue;

		if(PCDisplayedSignal->phase != -1)
		{
			CSignal.phase = PCDisplayedSignal->phase;

			displayed_counter++;
		}
	}
}

void TCOutputWaveformDataHeader::CopyScaleFactors(TCOutputWaveformDataHeader &CHeader)
{
	if(!PCSignals) return;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return; 
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(!count) return;

	CArray <TCSignal, TCSignal &> &CSignalsCopy = *CHeader.PCSignals;

	int count_copy = CSignalsCopy.GetSize();

	if(!count_copy) return;

	if(count > count_copy) count = count_copy;//

//	if(count != count_copy) return;

	for(int p = 0; p < count; p++)
	{
		CSignals[p].CopyScaleFactors(CSignalsCopy[p]);
	}
}

bool TCOutputWaveformDataHeader::SetScaleFactors(unsigned short width, unsigned short height)
{
	if(!PCSignals) return 0;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return 0; 
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(!count) return true;

	double g_max = 0.0, g_min = 0.0;// to set all signals scaled to the largest/smallest value found

	if(!(axis_index < CSignals.GetSize())) axis_index = 0;

	if(!CSignals[axis_index].phase_axis)
		CSignals[axis_index].SetMagnitudeScaleFactors(width, !x_manual, x_max, x_min, x_grid_decades, x_major_grid_number);// this class variable!!
	else 
		CSignals[axis_index].SetPhaseScaleFactors(width, !x_manual, x_max, x_min, x_grid_decades, x_major_grid_number);// this class variable!!
 
///////////magnitude

	if(!y_manual) 
	{
		GetMagnitudeMaxMin(g_max, g_min);
//		g_max = signal_mag_max;
//		g_min = signal_mag_min;

	}
	else
	{
		g_max = y_max;
		g_min = y_min;
	}

	if(y_grid_decades)// decades
	{
		y_major_grid_number = QuantiseLogScale(g_max, g_min);// dont allow arbitary scale in decade mode
	}
	else
	{
		QuantiseScale(g_max, g_min, y_major_grid_number, !y_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);
	}

	TCDisplayedSignals CDisplayedSignal;

	count = CDisplayedSignalsList.GetSize();

	if(!count) return false;

	int p;

	for(p = 0; p < count; p++)
	{
		CDisplayedSignalsList[p].PCSignal1->SetMagnitudeScaleFactors(height, !y_manual && multy_magnitude_axis, g_max, g_min, y_grid_decades, y_major_grid_number);
	}


////////////phase

	if(!y_phase_manual) 
	{
		GetPhaseMaxMin(g_max, g_min);
	}
	else
	{
		g_max = y_phase_max;
		g_min = y_phase_min;
	}

	if(y_phase_grid_decades)
	{
		y_phase_major_grid_number = QuantiseLogScale(g_max, g_min);
	}
	else
	{
		QuantisePhaseScale(g_max, g_min, y_phase_major_grid_number, !y_phase_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);
	}

	for(p = 0; p < count; p++)
	{
		CDisplayedSignalsList[p].PCSignal1->SetPhaseScaleFactors(height, !y_phase_manual && multy_phase_axis, g_max, g_min, y_phase_grid_decades, y_phase_major_grid_number);
	}

	return true;
}

bool TCOutputWaveformDataHeader::_GetMagnitudeMaxMin(double &max, double &min)
{
	// This function scans all signals and gets the min amd max values
	if(!PCSignals) return 0;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return 0; 
	}

//	CreateListOfDisplayedSignals();

	int count = CDisplayedSignalsList.GetSize();

	if(!count) return false;

	double t_max, t_min;

	max = 0.0, min = 0.0;

	TCDisplayedSignals &CDisplayedSignals = CDisplayedSignalsList[0];

	if(!ValidateSignal(CDisplayedSignals.PCSignal1)) return false;

	if(!CDisplayedSignals.PCSignal1->magnitude)
	{
		t_max = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMaxValue();
		t_min = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMinValue();
	}
	else// note, mixd db and magnitudes cannot auto scale
	{
		t_max = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMaxDBValue();
		t_min = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMinDBValue();
	}
	
	max = t_max;
	min = t_min;

	for(int p = 0; p < count; p++)
	{
		TCDisplayedSignals &CDisplayedSignals = CDisplayedSignalsList[p];

		if(!CDisplayedSignals.PCSignal1) continue;

		if(!CDisplayedSignals.PCSignal1->magnitude)
			t_max = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMaxValue();
		else
			t_max = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMaxDBValue();

		if(t_max > max) max = t_max;
	
		if(!CDisplayedSignals.PCSignal1->magnitude)
			t_min = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMinValue();
		else
			t_min = (double)CDisplayedSignals.PCSignal1->CMagnitudeData.GetMinDBValue();

		if(t_min < min) min = t_min;
	}

	return true;
}

bool TCOutputWaveformDataHeader::_GetPhaseMaxMin(double &max, double &min)
{
	if(!PCSignals) return 0;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return 0; 
	}

	int count = CDisplayedSignalsList.GetSize();

	if(!count) return false;

	double t_max, t_min;

	max = 0.0, min = 0.0;

	TCDisplayedSignals &CDisplayedSignals = CDisplayedSignalsList[0];

	if(!ValidateSignal(CDisplayedSignals.PCSignal1)) return false;

	t_max = (double)CDisplayedSignals.PCSignal1->CPhaseData.GetMaxValue();
	t_min = (double)CDisplayedSignals.PCSignal1->CPhaseData.GetMinValue();
	max = t_max;
	min = t_min;

	if(!CDisplayedSignals.PCSignal1->phase)
	{
		max *= (double)57.29577951308;
		min *= (double)57.29577951308;
	}

	for(int p = 0; p < count; p++)// ignore x data
	{
		TCDisplayedSignals &CDisplayedSignals = CDisplayedSignalsList[p];

		if(!CDisplayedSignals.PCSignal1) continue;

		t_max = (double)CDisplayedSignals.PCSignal1->CPhaseData.GetMaxValue();

		if(!CDisplayedSignals.PCSignal1->phase)
		{
			t_max *= (double)57.29577951308;// auto scaling only relevent on same type
		}

		if(t_max > max) max = t_max;

		t_min = (double)CDisplayedSignals.PCSignal1->CPhaseData.GetMinValue();

		if(!CDisplayedSignals.PCSignal1->phase)
		{
			t_min *= (double)57.29577951308;// auto scaling only relevent on same type
		}

		if(t_min < min) min = t_min;
	}

	return true;
}

bool TCOutputWaveformDataHeader::GetMagnitudeMaxMin(double &max, double &min)
{
	if(!PCWaveformDataRuns) return false;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count) return false;

	if(count < 0){ASSERT(0);return false;}

	if(!PCWaveformDataRuns->CRuns[0]) return false;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(type);

	if(index < 0) return false;

	if(!(index < PCWaveformDataRuns->CRuns[0]->CRecords.GetSize())) return false;

	TCOutputWaveformDataHeader *PCHeaderMax = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;
	TCOutputWaveformDataHeader *PCHeaderMin = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;

	if(!PCWaveformDataRuns->GetMagnitudeMaxMin(&PCHeaderMax, &PCHeaderMin, index, max, min)) return false;

	signal_mag_max		= PCHeaderMax->signal_mag_max;
	signal_mag_min		= PCHeaderMin->signal_mag_min;

	return true;
}

bool TCOutputWaveformDataHeader::GetPhaseMaxMin(double &max, double &min)
{
	if(!PCWaveformDataRuns) return false;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count) return false;

	if(count < 0){ASSERT(0);return false;}

	if(!PCWaveformDataRuns->CRuns[0]) return false;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(type);

	if(index < 0) return false;

	if(!(index < PCWaveformDataRuns->CRuns[0]->CRecords.GetSize())) return false;

	TCOutputWaveformDataHeader *PCHeaderMax = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;
	TCOutputWaveformDataHeader *PCHeaderMin = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;

	if(!PCWaveformDataRuns->GetPhaseMaxMin(&PCHeaderMax, &PCHeaderMin, index, max, min)) return false;

	signal_phase_max	= PCHeaderMax->signal_phase_max;
	signal_phase_min	= PCHeaderMin->signal_phase_min;

	return true;
}

bool TCOutputWaveformDataHeader::IsBadSignalsPointer(void)
{
	if(!PCSignals) return true;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		return true; 
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(!count) return false;// ok but empty

	if(count < 0) return true;//

	if(!count) return true;

	for(int p = 0; p < count; p++)
	{
		if(IsBadCodePtr((FARPROC)&CSignals[p]))
		{
			return true;
		}
	}

	return false;
}

void TCOutputWaveformDataHeader::CreateListOfDisplayedSignals(void)
{
	if(!PCSignals) return;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return; 
	}

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(!count) return;

	TCDisplayedSignals CDisplayedSignal;

	CDisplayedSignalsList.SetSize(0, count);

	for(int p = 0; p < count; p++)
	{
		if(!ValidateSignal(&CSignals[p])) return;

		TCSignal &CSignal = CSignals[p];

		TCXArray &CXArray = CSignal.CMagnitudeData;

		int test_count = CXArray.CX.GetSize();

		if(!test_count) continue;

		CDisplayedSignal.magnitude	= CSignal.magnitude;
		CDisplayedSignal.phase		= CSignal.phase;

		if(CSignal.magnitude == -1 && CSignal.phase == -1) continue;

		CDisplayedSignal.PCSignal1 = &CSignal;
		CDisplayedSignal.index1 = p;

//		CDisplayedSignalsList.Add(CDisplayedSignal);

		if(CDisplayedSignal.magnitude == 0) CDisplayedSignal.type = TE_SIGNAL_DISPLAY_MAGNITUDE;
		else CDisplayedSignal.type = TE_SIGNAL_DISPLAY_DB_MAGNITUDE;

		if(CSignal.magnitude != -1) CDisplayedSignalsList.Add(CDisplayedSignal);

		if(CDisplayedSignal.phase == 0) CDisplayedSignal.type = TE_SIGNAL_DISPLAY_PHASE_DEG;
		else CDisplayedSignal.type = TE_SIGNAL_DISPLAY_PHASE_RADIANS;

		if(CSignal.phase != -1) CDisplayedSignalsList.Add(CDisplayedSignal);
	}

	int count2 = CDisplayedSignalsList.GetSize();

	if(count2)
	{	// defaults if no axis currently selected or, circuit has been resized smaller
		if(active_magnitude_axis_index < 0) active_magnitude_axis_index = CDisplayedSignalsList[0].index1;
		if(!(active_magnitude_axis_index < count)) active_magnitude_axis_index = CDisplayedSignalsList[0].index1;
		
		if(active_phase_axis_index < 0) active_phase_axis_index = CDisplayedSignalsList[0].index1;
		if(!(active_phase_axis_index < count)) active_phase_axis_index = CDisplayedSignalsList[0].index1;
		
		if(!CDisplayedSignalsList[0].PCSignal1->CPhaseData.CX.GetSize()) active_phase_axis_index = -1;
	}
}

bool TCOutputWaveformDataHeader:: ValidateSignal(TCSignal *PCSignal)
{
	try
	{
		if(!PCSignal) return false;

		if(IsBadCodePtr((FARPROC)PCSignal))
		{
			ASSERT(0);

			DisplayError(IDS_ERR_ERROR, IDS_ERR_SYSTEM_ERROR);

			return false; 
		}

		TCSignal &CSignal = *PCSignal;

		TCXArray &CXArray = CSignal.CMagnitudeData;

		if(IsBadCodePtr((FARPROC)&CXArray))
		{
			ASSERT(0);

			return false; 
		}

		if(IsBadCodePtr((FARPROC)&CXArray.CX))
		{
			ASSERT(0);

			return false;
		}

		int count = CXArray.CX.GetSize();

		if(!count) return true; // maybe ok data, but not relevent

		if(IsBadCodePtr((FARPROC)&CXArray.CX[0]))
		{
			ASSERT(0);

			return false; 
		}

		if(IsBadCodePtr((FARPROC)CXArray.CX.GetData()))
		{
			ASSERT(0);

			return false; 
		}

		return true;
	}

	catch(...)
	{
		ASSERT(0);

		return false; 
	}
}

void TCOutputWaveformDataHeader::ScaleGrid(unsigned short *width, unsigned short *height)
{
//	CreateListOfDisplayedSignals();

	if(*height < 16) *height = 16;

	if(*width < 16) *width = 16;

	if(y_minor_grid_number < 1) y_minor_grid_number = 1;
	if(x_minor_grid_number < 1) x_minor_grid_number = 1;
	if(y_major_grid_number < 1) y_major_grid_number = 1;
	if(x_major_grid_number < 1) x_major_grid_number = 1;

	SetupXGridCounts(*width);
	SetupYMagGridCounts(*height);
//	SetupYPhaseGridCounts(*height);

	y_minor_grid_size = *height / y_minor_grid_number /y_major_grid_number;
	
	if(y_minor_grid_size < 1) y_minor_grid_size = 1;
	
//	y_phase_minor_grid_size = *height / y_phase_minor_grid_number /y_phase_major_grid_number;
//	if(y_phase_minor_grid_size < 1) y_phase_minor_grid_size = 1;

	y_major_grid_size = y_minor_grid_size * y_minor_grid_number;
//	y_phase_major_grid_size = y_phase_minor_grid_size * y_phase_minor_grid_number;

	//some ignored for decades
	x_minor_grid_size = *width / x_minor_grid_number / x_major_grid_number;
	
	if(x_minor_grid_size < 1) x_minor_grid_size = 1;
	
	x_major_grid_size = x_minor_grid_size * x_minor_grid_number;

	// resize
//	if(!x_manual)
	*width	= (unsigned short)(x_minor_grid_size * x_minor_grid_number * x_major_grid_number);

//	if(!y_manual)
	*height	= (unsigned short)(y_minor_grid_size * y_minor_grid_number * y_major_grid_number);

	//now height may have changed, so now set phase scale
	SetupYPhaseGridCounts(*height);

	y_phase_minor_grid_size = *height / y_phase_minor_grid_number /y_phase_major_grid_number;
	
	if(y_phase_minor_grid_size < 1) y_phase_minor_grid_size = 1;
	
	y_phase_major_grid_size = y_phase_minor_grid_size * y_phase_minor_grid_number;

	if(*height < 16) *height = 16;

	if(*width < 16) *width = 16;
}

void TCOutputWaveformDataHeader::SetupXGridCounts(unsigned short width)
{
	if(!PCSignals) return;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return; 
	}

	if(!(axis_index < PCSignals->GetSize())) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	TCSignal &CSignal = CSignals[axis_index];

	if(IsBadCodePtr((FARPROC)&CSignal))
	{
		return; 
	}

	if(!x_manual)// i.e if auto scale
	{
		if(!CSignal.phase_axis)
		{
			x_max = (double)CSignal.CMagnitudeData.GetMaxValue(); 
			x_min = (double)CSignal.CMagnitudeData.GetMinValue();
		}
		else// linear, may add octaves later
		{
			x_max = (double)CSignal.CPhaseData.GetMaxValue(); 
			x_min = (double)CSignal.CPhaseData.GetMinValue();
		}

		if(x_grid_decades)//is decades
		{
			x_major_grid_number = QuantiseLogScale(x_max, x_min);

			if(!x_major_grid_number) x_major_grid_number = 1;

			// convert any error in data soft error
			if(x_major_grid_number < 0) x_major_grid_number = -x_major_grid_number;

			x_major_grid_size = width/x_major_grid_number;

			x_minor_grid_number = x_manual_minor_grid_number;

			return;
		}
		else
		{
			SetupXAutoMajorMinorCounts();
		}
	}
	else // not autoscale
	{
		if(x_grid_decades)//is decades
		{
			x_major_grid_number = QuantiseLogScale(x_max, x_min);

			if(!x_major_grid_number) x_major_grid_number = 1;

			// convert any error in data soft error
			if(x_major_grid_number < 0) x_major_grid_number = -x_major_grid_number;

			x_major_grid_size = width/x_major_grid_number;

			x_minor_grid_number = x_manual_minor_grid_number;

			return;
		}

		if(!x_mag_div) x_mag_div = 1;// soft error

		x_major_grid_number = (int)((x_max - x_min)/x_mag_div);

		if(!x_major_grid_number) x_major_grid_number = 1;

		if(x_major_grid_number < 0) x_major_grid_number = - x_major_grid_number;

		x_major_grid_size = width/x_major_grid_number;

		if(x_major_grid_size < 10) 
		{
			x_major_grid_size	= 10;
			x_major_grid_number = width/x_major_grid_size;
		}

		x_minor_grid_number = x_manual_minor_grid_number;// 
	}
}

void TCOutputWaveformDataHeader::SetupYMagGridCounts(unsigned short height)
{
	if(!PCSignals) return;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return; 
	}
	
	if(!(active_magnitude_axis_index < PCSignals->GetSize())) return;
	if(active_magnitude_axis_index < 0) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	TCSignal &CSignal = CSignals[active_magnitude_axis_index];

	if(IsBadCodePtr((FARPROC)&CSignal))
	{
		return; 
	}

	if(!y_manual)// i.e if auto scale
	{
		if(multy_magnitude_axis)
		{
			if(!CSignal.magnitude)
			{
				y_max = (double)CSignal.CMagnitudeData.GetMaxValue(); 
				y_min = (double)CSignal.CMagnitudeData.GetMinValue();
			}
			else
			{
				y_max = (double)CSignal.CMagnitudeData.GetMaxDBValue(); 
				y_min = (double)CSignal.CMagnitudeData.GetMinDBValue();
			}
		}
		else
		{
			GetMagnitudeMaxMin(y_max, y_min);
		}

		if(y_grid_decades)//decades, very unlickly to want decades AND db
		{
			y_major_grid_number = QuantiseLogScale(y_max, y_min);

			if(!y_major_grid_number) y_major_grid_number = 1;
		
			if(y_major_grid_number < 0) y_major_grid_number = -y_major_grid_number;

			y_major_grid_size = height/y_major_grid_number;

			y_minor_grid_number = y_manual_minor_grid_number; 

			y_mag_div = 10;// more to do

			return;
		}
		else
		{
			SetupYMagnitudeAutoMajorMinorCounts();
		}
	}
	else // not autoscale
	{
		if(y_grid_decades)//decades, very unlikely to want decades AND db
		{
			y_major_grid_number = QuantiseLogScale(y_max, y_min);

			if(!y_major_grid_number) y_major_grid_number = 1;
		
			if(y_major_grid_number < 0) y_major_grid_number = -y_major_grid_number;

			y_major_grid_size = height/y_major_grid_number;

			y_minor_grid_number = y_manual_minor_grid_number; 

			y_mag_div = 10;// more to do

			return;
		}

		y_major_grid_number = y_manual_major_grid_number;
		
		if(!y_major_grid_number) y_major_grid_number = 1;

		if(y_major_grid_number < 0) y_major_grid_number = - y_major_grid_number;
		
		if(!y_grid_decades)
		{
			QuantiseScale(y_max, y_min, y_major_grid_number, !y_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);// this quantises user data

			y_mag_div = (y_max - y_min)/y_manual_major_grid_number;
		}
		else
		{
			y_major_grid_number = QuantiseLogScale(y_max, y_min);

			y_mag_div = 10;
		}

		y_major_grid_size = height/y_major_grid_number;

		if(y_major_grid_size < 10) 
		{
			y_major_grid_size	= 10;
			y_major_grid_number = height/y_major_grid_size;
		}

		y_minor_grid_number = y_manual_minor_grid_number;// temp, more to do
	}
}

void TCOutputWaveformDataHeader::SetupYPhaseGridCounts(unsigned short height)
{
	if(!PCSignals) return;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return; 
	}


	if(!(active_phase_axis_index < PCSignals->GetSize())) return;
	if(active_phase_axis_index < 0) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	TCSignal &CSignal = CSignals[active_phase_axis_index];

	if(IsBadCodePtr((FARPROC)&CSignal))
	{
		return; 
	}

	if(!y_phase_manual)// i.e if auto scale
	{
		if(multy_phase_axis)
		{
			y_phase_max = (double)CSignal.CPhaseData.GetMaxValue(); //convienient
			y_phase_min = (double)CSignal.CPhaseData.GetMinValue();

			if(!CSignal.phase)// convert to degrees
			{
				y_phase_min *= (double)57.29577951308;
				y_phase_max *= (double)57.29577951308;
			}
		}
		else
		{
			GetPhaseMaxMin(y_phase_max, y_phase_min);
		}

		if(y_phase_grid_decades)//is decades
		{
			y_phase_major_grid_number = QuantiseLogScale(y_phase_max, y_phase_min);

			if(!y_phase_major_grid_number) y_phase_major_grid_number = 1;
		
			if(y_phase_major_grid_number < 0) y_phase_major_grid_number = -y_phase_major_grid_number;

			y_phase_major_grid_size = height/y_phase_major_grid_number;

			y_phase_minor_grid_number = y_manual_phase_minor_grid_number;

			return;
		}
		else
		{
			SetupYPhaseAutoMajorMinorCounts();
		}
	}
	else // not autoscale
	{
		if(y_phase_grid_decades)//is decades
		{
			y_phase_major_grid_number = QuantiseLogScale(y_phase_max, y_phase_min);

			if(!y_phase_major_grid_number) y_phase_major_grid_number = 1;
		
			if(y_phase_major_grid_number < 0) y_phase_major_grid_number = -y_phase_major_grid_number;

			y_phase_major_grid_size = height/y_phase_major_grid_number;

			y_phase_minor_grid_number = y_manual_phase_minor_grid_number;

			return;
		}

		if(!y_phase_div) y_phase_div = 1;// soft error

		y_phase_major_grid_number = y_manual_phase_major_grid_number;

		if(!y_phase_major_grid_number) y_phase_major_grid_number = 1;

		if(y_phase_major_grid_number < 0) y_phase_major_grid_number = - y_phase_major_grid_number;

		if(!y_phase_grid_decades)
		{
			QuantisePhaseScale(y_phase_max, y_phase_min, y_phase_major_grid_number, !y_phase_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);// this quantises user data

			y_phase_div = (y_phase_max - y_phase_min) / y_phase_major_grid_number;

		}
		else
		{
			y_phase_major_grid_number = QuantiseLogScale(y_phase_max, y_phase_min);// this quantises user data

			y_phase_div = 10;
		}

		y_phase_major_grid_size = height/y_phase_major_grid_number;

		if(y_phase_major_grid_size < 10) 
		{
			y_phase_major_grid_size	= 10;
			y_phase_major_grid_number = height/y_phase_major_grid_size;
		}

		y_phase_minor_grid_number = y_manual_phase_minor_grid_number;// temp, more to do
	}
}

void TCOutputWaveformDataHeader::SetupXAutoMajorMinorCounts(void)
{
	x_minor_grid_number = x_manual_minor_grid_number;

	if(x_manual_major_grid_number < 1) x_manual_major_grid_number = 1;

	QuantiseScale(x_max, x_min, x_major_grid_number, !x_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);

	x_major_grid_number = x_manual_major_grid_number;

	x_mag_div = (x_max - x_min)/x_major_grid_number;
}

void TCOutputWaveformDataHeader::SetupYMagnitudeAutoMajorMinorCounts(void)
{
	if(y_manual_major_grid_number < 1) y_manual_major_grid_number = 1;

	y_major_grid_number = y_manual_major_grid_number;

	QuantiseScale(y_max, y_min, y_major_grid_number, !y_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);

	y_minor_grid_number = y_manual_minor_grid_number;//temp, need to determine if increment is too small

	y_mag_div = (y_max - y_min)/y_major_grid_number;

	if(!y_mag_div)
	{
		ASSERT(0);

		y_mag_div = 1;
	}
}

void TCOutputWaveformDataHeader::SetupYPhaseAutoMajorMinorCounts(void)
{
	if(y_manual_phase_major_grid_number < 1) y_manual_phase_major_grid_number = 1;

	y_phase_major_grid_number = y_manual_phase_major_grid_number;

	QuantisePhaseScale(y_phase_max, y_phase_min, y_phase_major_grid_number, !y_phase_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);

	y_phase_minor_grid_number = y_manual_phase_minor_grid_number;

	y_phase_div = (y_phase_max - y_phase_min)/y_phase_major_grid_number;

	if(!y_phase_div)
	{
		ASSERT(0);

		y_phase_div = 1;
	}
}



//////////////////////////////////////////////////////////////
TCOutputWaveformDataRecord::TCOutputWaveformDataRecord(void)
{
	CHeader.PCSignals = &CSignals;
	PCDoc = NULL;
}
TCOutputWaveformDataRecord::TCOutputWaveformDataRecord(TCOutputWaveformDataRecord &COutputWaveformDataRecord)
{
	*this = COutputWaveformDataRecord;
}
TCOutputWaveformDataRecord::~TCOutputWaveformDataRecord(void)
{

}

void TCOutputWaveformDataRecord::ClearMathFunctionData(int record_index)
{
	record_index;// to do

	CHeader.type = E_SPICE_RECORD_MATH_0;
	
	CHeader.PCSignals = &CSignals;
	
	CHeader.CDisplayedSignalsList.SetSize(0);
	
	int count2 = CSignals.GetSize();

	for(int q = 0; q < count2; q++)
	{
		CSignals[q].CMagnitudeData.CX.SetSize(0);
		CSignals[q].CPhaseData.CX.SetSize(0);
		CSignals[q].magnitude	= -1;
		CSignals[q].phase		= -1;
	}
}

void TCOutputWaveformDataRecord::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CHeader.Serialize(CArchiveFile);

	int p, count;

	if(CArchiveFile.IsStoring())
	{
		count = CSignals.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CSignals[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> count;

		CSignals.SetSize(count);

		for(p = 0; p < count; p++) CSignals[p].Serialize(CArchiveFile);	
	}
}
void TCOutputWaveformDataRecord::operator = (TCOutputWaveformDataRecord &COutputWaveformDataRecord)
{
	CHeader		= COutputWaveformDataRecord.CHeader;
	PCDoc		= COutputWaveformDataRecord.PCDoc;

	int p, count;

	count = COutputWaveformDataRecord.CSignals.GetSize();

	CSignals.SetSize(count);

	for(p = 0; p < count; p++)
	{
		CSignals[p] = COutputWaveformDataRecord.CSignals[p];
	}
}

void TCOutputWaveformDataRecord::DisplayError(CString CDescription, CString CErrorMsg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(CDescription, CErrorMsg, error_code);
}

void TCOutputWaveformDataRecord::DisplayError(int des, CString CErrorMsg, int error_code)
{
	PCDoc->DisplayError(des, CErrorMsg, error_code);
}

void TCOutputWaveformDataRecord::DisplayError(int des, int msg, int error_code)
{
	PCDoc->DisplayError(des, msg, error_code);
}

////////////////////////////////////////////////////////

TCOutputWaveformData::TCOutputWaveformData(void)
{
	CRunDiscription = "Single Run";

	CRunType.SetSize(E_NUMBER_OF_BASIC_SPICE_TYPES);

	PCDoc = NULL;

	current_active_analysis_type = 0;
	m_peek_increment = 0;
	m_linearize_transient_data = false;
	m_run_number		= 0;
}

TCOutputWaveformData::TCOutputWaveformData(TCOutputWaveformData &COutputWaveformData)
{
	*this = COutputWaveformData;
}
TCOutputWaveformData::~TCOutputWaveformData(void)
{

}

int TCOutputWaveformData::GetFirstActiveAnalysisType(void)
{
	current_active_analysis_type = 0;

	int count, p;

	count = CRecords.GetSize();

	for(p = current_active_analysis_type; p < count; p++)
	{
		if(IsWaveformHeaderAvailable(p))
		{
			current_active_analysis_type = p;
			
			return p;
		}
	}

	return E_SPICE_RECORD_NULL;
}

int TCOutputWaveformData::GetNextActiveAnalysisType(void)
{
	int count, p;

	count = CRecords.GetSize();

	current_active_analysis_type++;

	for(p = current_active_analysis_type; p < count; p++)
	{
		if(IsWaveformHeaderAvailable(p))
		{			
			current_active_analysis_type = p;

			return p;
		}
	}

	return E_SPICE_RECORD_NULL;
}

int TCOutputWaveformData::PeekNextActiveAnalysisType(void)
{
	int count, p;

	count = CRecords.GetSize();

	m_peek_increment = current_active_analysis_type + 1;

	for(p = m_peek_increment; p < count; p++)
	{
		if(IsWaveformHeaderAvailable(p))
		{			
			return p;
		}
	}

	return E_SPICE_RECORD_NULL;
}

int TCOutputWaveformData::PeekIncrementActiveAnalysisType(void)
{
	int count, p;

	count = CRecords.GetSize();

	m_peek_increment++;

	for(p = m_peek_increment; p < count; p++)
	{
		if(IsWaveformHeaderAvailable(p))
		{			
			return p;
		}
	}

	return E_SPICE_RECORD_NULL;
}

void TCOutputWaveformData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int p, count;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CFileName;
		CArchiveFile << CRunDiscription;

		count = CRecords.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CRecords[p].Serialize(CArchiveFile);
		}

		count = CRunType.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CRunType[p];

	}
	else
	{
		CArchiveFile >> CFileName;
		CArchiveFile >> CRunDiscription;

		CArchiveFile >> count;

		CRecords.SetSize(count);

		for(p = 0; p < count; p++) 
		{		
			CRecords[p].Serialize(CArchiveFile);
		}

		CArchiveFile >> count;

		CRunType.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CRunType[p];
	}
}

void TCOutputWaveformData::operator = (TCOutputWaveformData &COutputWaveformData)
{
	CFileName		= COutputWaveformData.CFileName;
	CRunDiscription = COutputWaveformData.CRunDiscription;
	PCDoc			= COutputWaveformData.PCDoc;

	int p, count;

	count = COutputWaveformData.CRecords.GetSize();

	CRecords.SetSize(count);

	for(p = 0; p < count; p++)
	{
		CRecords[p] = COutputWaveformData.CRecords[p];
	}
}

int TCOutputWaveformData::GetFirstEnabledSignalsType(void)
{
	int count, p;

	count = CRecords.GetSize();

	if(!count) return E_SPICE_RECORD_NULL;

	for(p = 0; p < count; p++)
	{
		
		if(p == E_SPICE_RECORD_NOISE_SPECTRAL || p == E_SPICE_RECORD_NOISE_INTEGRATED ||
		   p == E_SPICE_RECORD_OPERATING_POINT || p == E_SPICE_RECORD_SENSITIVITY) continue;

		if(AreAnySignalsEnabled(p)) return p;
	}

	return E_SPICE_RECORD_NULL;
}

void TCOutputWaveformData::CopySignalEnables(int destination, int source)
{
	int count, q, signal_count;

	count = CRecords.GetSize();

	if(destination < 0) return;
	if(source < 0) return;
	if(!(destination < count)) return;
	if(!(source < count)) return;

	if(destination == source) return;

	signal_count = CRecords[destination].CSignals.GetSize();

	int source_type, destination_type;

	if(destination == E_SPICE_RECORD_NULL) return;
	if(destination == E_SPICE_RECORD_NOISE_SPECTRAL || destination == E_SPICE_RECORD_NOISE_INTEGRATED) return;
	if(destination == E_SPICE_RECORD_OPERATING_POINT) return;

	if(source == E_SPICE_RECORD_NOISE_SPECTRAL || source == E_SPICE_RECORD_NOISE_INTEGRATED ||
	   source == E_SPICE_RECORD_OPERATING_POINT || source == E_SPICE_RECORD_NULL)
	{
		source = GetFirstEnabledSignalsType();

		if(source == E_SPICE_RECORD_NULL) return;
	}

	if(signal_count != CRecords[source].CSignals.GetSize())return;

	if(source == E_SPICE_RECORD_AC || source == E_SPICE_RECORD_POLE_ZERO || source == E_SPICE_RECORD_TIME_TO_FREQ_FFT ||
			source == E_SPICE_RECORD_DISTORTION_IMD_2F || source == E_SPICE_RECORD_THD || source == E_SPICE_RECORD_IMD)
		source_type = 1;//db
	else source_type = 0;//mag

	if(destination == E_SPICE_RECORD_AC || destination == E_SPICE_RECORD_POLE_ZERO || destination == E_SPICE_RECORD_TIME_TO_FREQ_FFT ||
			destination == E_SPICE_RECORD_DISTORTION_IMD_2F || destination == E_SPICE_RECORD_THD || destination == E_SPICE_RECORD_IMD)
		destination_type = 1;//db
	else destination_type = 0;//mag

	CArray <TCSignal, TCSignal &> &CSourceSignals = CRecords[source].CSignals;

	if(IsBadCodePtr((FARPROC) &CSourceSignals))return;

	CArray <TCSignal, TCSignal &> &CDestSignals = CRecords[destination].CSignals;

	if(IsBadCodePtr((FARPROC) &CDestSignals))return;

	for(q = 0; q < signal_count; q++)
	{
		if(source_type == 1)//db source
		{
			if(destination_type == 1)//db destination
			{
				CDestSignals[q].magnitude = CSourceSignals[q].magnitude; 
				CDestSignals[q].phase		= CSourceSignals[q].phase;
			}
			else //mag destination
			{
				if(CSourceSignals[q].magnitude > -1) CDestSignals[q].magnitude = 0;
				CDestSignals[q].phase		= -1;
			}
		}
		else //mag source
		{
			if(destination_type == 1)//db destination
			{
				if(CSourceSignals[q].magnitude > -1) CDestSignals[q].magnitude = 1;
				CDestSignals[q].phase		= -1;
			}
			else  //mag destination
			{
				CDestSignals[q].magnitude = CSourceSignals[q].magnitude; 
				CDestSignals[q].phase		= -1;
			}
		}
	}
}


void TCOutputWaveformData::DisplayError(CString CDescription, CString CErrorMsg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(CDescription, CErrorMsg, error_code);
}

void TCOutputWaveformData::DisplayError(int des, CString CErrorMsg, int error_code)
{
	PCDoc->DisplayError(des, CErrorMsg, error_code);
}

void TCOutputWaveformData::DisplayError(int des, int msg, int error_code)
{
	PCDoc->DisplayError(des, msg, error_code);
}

void TCOutputWaveformData::SetupRecords(TCWaveformDataRuns *PCWaveformDataRuns)
{
	CRecords.SetSize(E_SPICE_RECORD_SIZE, E_SPICE_RECORD_SIZE);

	int count = CRecords.GetSize();

	for(int p = 0; p < count; p++)
	{
		CRecords[p].CHeader.PCWaveformDataRuns = PCWaveformDataRuns;
	}
}

int TCOutputWaveformData::OpenFile(TCIFStream &CFileStream, CString CFileName, TCSuperSpiceDoc *PCParentDoc, TCWaveformDataRuns *PCWaveformDataRuns, int run_number)
{
	PCDoc = PCParentDoc;// pass to header and signals
	m_run_number = run_number;
	m_marching_waveform_type = -1;

	CString CMsg;

	if(PCWaveformDataRuns)
	{
		LoadInit(CFileName, PCWaveformDataRuns);
	}

	CFile COutFile;
	int default_size = 0;

	if(COutFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone))
	{
		default_size = (int) COutFile.GetLength();

		COutFile.Close();

		if(!default_size) default_size = 1;// Might be zero length file
	}

	if(!default_size) return false;

	int flags;

	if(PCParentDoc)
	{
		TCAnalysisSetup	&CAnalysisSetup = PCDoc->GetAnalysisSetup();

		if(CAnalysisSetup.COutputSelectData.text_file_type)
		{
		//	flags = ios::in;
			flags = ios_base::in;
			CFileStream.text_file_mode = true;
		}
		else
		{
	//		flags = ios::in | ios::binary;
			flags = ios_base::in | ios_base::binary;
			CFileStream.text_file_mode = false;
		}
	}
	else
	{
	//	flags = ios::in;
		flags = ios_base::in  | ios::binary;
		CFileStream.text_file_mode = true;// fstream wont read lines correctly in 
	}

	if(!WaitUntillSpiceEngineFinishesWriting())
	{
		CMsg = "Unable to open file " + CFileName;

		DisplayError(IDS_ERR_ERROR, CMsg, -1);

		return false;
	}

	CFileStream.open(CFileName, flags);
	// need to pass through mode

	if(CFileStream.fail()) 
	{
		CMsg = "Unable to open file " + CFileName;

		DisplayError(IDS_ERR_ERROR, CMsg, -1);

		return false;
	}

	if(PCWaveformDataRuns)
	{
		ClearAllData();

		ResetRecordSignalPointers();
	}

	return default_size;
}

void TCOutputWaveformData::ResetRecordSignalPointers(void)
{
	for(int a = 0; a < E_SPICE_RECORD_SIZE; a++) 
	{
		CRecords[a].PCDoc			= PCDoc;
		CRecords[a].CHeader.PCDoc	= PCDoc;
		
		// This is because things can get out of sync, April 30th 2000
		// the above constructor in setsize keeps old data that may be bad.
		CRecords[a].CHeader.PCSignals = &CRecords[a].CSignals;
	}
}

void TCOutputWaveformData::LoadInit(CString CFileName, TCWaveformDataRuns *PCWaveformDataRuns)
{
	PCMOutputWaveformDoc = NULL;
	fm_open_waveform_graph = false;

	PCDoc = PCDoc->GetTopLevelDoc();// extra check to get right superspice doc pointer

	m_linearize_transient_data = PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.linearize_transient_data;

	CString CText2 = ReplaceFileExtension(CFileName, "ssd");
	
	LoadData(CText2);//see if processed data is available first, has old setups stord

	SetupRecords(PCWaveformDataRuns);
}

/////////

int TCOutputWaveformData::ReadNextData(TCIFStream &CFileStream)
{
	int index = 0;

	index = CRecords[E_SPICE_RECORD_NULL].CHeader.type;// keep same data type in same place

	if(index < 0) return -1;
	if(index == E_SPICE_RECORD_NULL) return -1;

	CRecords[index].CHeader.index = index;//

	m_binary = CRecords[index].CHeader.IsBinary();

	int value = -1;

	if(m_binary)
	{
		value = ReadNextBinaryData(CFileStream, index); 

		if(value < 0) 
		{
			ClearAllData();

			return -1;
		}

		return value;
	}
		
	value = ReadNextTextData(CFileStream, index);

	if(value < 0) 
	{
		ClearAllData();

		return -1;
	}

	return value;
}

bool TCOutputWaveformData::Load(CString CName, TCWaveformDataRuns *PCWaveformDataRuns, TCSuperSpiceDoc *PCParentDoc,  TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	PCDoc = PCParentDoc;// pass to header and signals
	CMWaveformAnalyisisData = CWaveformAnalyisisData;
	int record_type;

	LoadInit(CName, PCWaveformDataRuns);

	TCIFStream CFileStream;
 
	int default_size = OpenFile(CFileStream, CName, PCDoc);

	if(!default_size) return false;

	ClearAllData();

	ResetRecordSignalPointers();

	bool first_flag = true;

	while(!CFileStream.eof())
	{
		record_type = ReadNextHeader(CFileStream, default_size);

		if(!record_type && first_flag) return false;// 

		if(!record_type) break;// ok but finished

		first_flag = false;

		if(record_type == -1) 
		{
			DisplayError(IDS_ERR_ERROR, IDS_ERROR_IN_DATA_HEADER);

			return false;// error in file
		}

		if(ReadNextData(CFileStream) < 0) 
		{
			DisplayError(IDS_ERR_ERROR, IDS_ERRO_IN_DATA_DATA);

			return false;
		}
	}

	CWaveformAnalyisisData = CMWaveformAnalyisisData;//returned data to caller, e.g. gain and phase margins

	return true;
}

bool TCOutputWaveformData::Load(TCIFStream &CFileStream, CString CName, TCWaveformAnalyisisData &CWaveformAnalyisisData, int default_size)
{
	CMWaveformAnalyisisData = CWaveformAnalyisisData;

	int record_type;

	bool first_flag = true;

	while(!CFileStream.eof())
	{
		record_type = ReadNextHeader(CFileStream, default_size);

		if(!record_type && first_flag) return false;// 

		if(!record_type) break;// ok but finished

		first_flag = false;

		if(record_type == -1) return false;// error in file

		if(ReadNextData(CFileStream) < 0) return false;
	}

	CWaveformAnalyisisData = CMWaveformAnalyisisData;//returned data to caller, e.g. gain and phase margins

	return true;
}

bool TCOutputWaveformData::WaitUntillSpiceEngineFinishesWriting(void)
{
	// should no need this. will check and remove
	Sleep(100);// wait 100ms so that engine has finished duming data, need to check if buffer is closed 

	return true;
}

bool TCOutputWaveformData::Save(CString CName)
{
	CName = ReplaceFileExtension(CName, "ssd");

	return SaveData(CName);

}

bool TCOutputWaveformData::LoadData(CString CName)
{
	return 	LoadGenericFromArchive(this, CName);	
}

bool TCOutputWaveformData::SaveData(CString CName)
{
	return SaveGenericToArchive(this, CName);
}

int TCOutputWaveformData::ReadNextHeader(TCIFStream &CFileStream, int default_size)
{
	int index = E_SPICE_RECORD_NULL;

	char buff[1024];

	if(!(index < CRecords.GetSize())) return false;

	CString CText;

	CRecords[index].CHeader.index = index;

	int num_var;

	if(!CFileStream.ReadLine(buff, 1023)) 
	{
		if(*buff == 0) 
		{
			return 0; // null line, end of file
		}
		return -1;
	}

	CText = buff;
 
	CString CTemp = GetFirstWord(CText, ' ');

	//if(!m_binary) why was this in?
	if("Title:" != CTemp) 
	{
		return -1;
	}

	CRecords[index].CHeader.CFileName = CText;

	if(!CFileStream.ReadLine(buff, 1023)) 
	{
		if(m_binary)
		{
			if(!CFileStream.eof()) return -1;

			if(*buff == 0) return 0;
		}

		return -1;
	}

	CRecords[index].CHeader.CDateAndTime = buff;

	CText = CRecords[index].CHeader.CDateAndTime;

	if(!CFileStream.ReadLine(buff, 1023)) 	
	{
		return -1;
	}

	CRecords[index].CHeader.CPlotName = buff;

	CRecords[index].CHeader.CPlotName = 
	CRecords[index].CHeader.CPlotName.Right(CRecords[index].CHeader.CPlotName.GetLength() - 10);

	CText = CRecords[index].CHeader.CPlotName;

	if(!CRecords[index].CHeader.SetType())
	{
		return -1;
	}


	// now we know where to put the header

	// Make sure data is stuffed in same place so that signal setup data is recovered
	int type = CRecords[index].CHeader.type;

	TCOutputWaveformDataRecord &CRecord = CRecords[type];

	CRecord.CHeader.type						= type;
	CRecord.CHeader.CTitle						= CRecords[index].CHeader.CTitle;
	CRecord.CHeader.CFileName					= CRecords[index].CHeader.CFileName;
	CRecord.CHeader.CDateAndTime				= CRecords[index].CHeader.CDateAndTime;
	CRecord.CHeader.CPlotName					= CRecords[index].CHeader.CPlotName;
	CRecord.CHeader.inteligent_signal_magnitude	= CRecords[index].CHeader.inteligent_signal_magnitude;
	CRecord.CHeader.inteligent_signal_phase		= CRecords[index].CHeader.inteligent_signal_phase;

	CRecord.CHeader.SetType();

	CString CMessageText = "Reading ";

	switch(type)
	{
		case E_SPICE_RECORD_DC: CMessageText +="DC"; break;
		case E_SPICE_RECORD_AC:CMessageText +="AC"; break;
		case E_SPICE_RECORD_NOISE_SPECTRAL:CMessageText +="noise spectral"; break;
		case E_SPICE_RECORD_TRANSIENT:CMessageText +="Transient"; break;
		case E_SPICE_RECORD_FOURIER:CMessageText +="Fourier"; break;
		case E_SPICE_RECORD_THD:CMessageText +="T.H.D."; break;
		case E_SPICE_RECORD_IMD:CMessageText +="I.M.D."; break;
		case E_SPICE_RECORD_DISTORTION_IMD_2F:CMessageText +="distortion"; break;
		case E_SPICE_RECORD_SENSITIVITY:CMessageText +="sensitivity"; break;
		case E_SPICE_RECORD_POLE_ZERO:CMessageText +="pole-zero"; break;
		case E_SPICE_RECORD_TIME_TO_FREQ_FFT:CMessageText +="FFT"; break;	
		case E_SPICE_RECORD_FREQ_TO_TIME_FFT:CMessageText +="IFT"; break;
		case E_SPICE_RECORD_MATH_0:CMessageText +="calculater"; break;
		case E_SPICE_RECORD_OPERATING_POINT:CMessageText +="operating point"; break;
		case E_SPICE_RECORD_NOISE_INTEGRATED:CMessageText +="noise integrated"; break;
	}

	CMessageText += " data...";

	DisplayError(IDS_EER_STATUS, CMessageText);

	// I am not sure why this needs to be done, but it does 1998-1999
	// added note April 30th 2000, this is probably not needed now
	// see code where ClearAllData(); is called 
	CRecord.CHeader.PCSignals = &CRecords[type].CSignals;

	if(!CFileStream.ReadLine(buff, 1023)) return -1;

	CRecord.CHeader.CFlags = buff;

	CRecord.CHeader.CFlags = 
	CRecord.CHeader.CFlags.Right(CRecords[type].CHeader.CFlags.GetLength() - 7);

	CText = CRecord.CHeader.CFlags;

	if(!CFileStream.ReadLine(buff, 1023)) return -1;

	CRecord.CHeader.CNumberOfVariables = buff;

	CRecord.CHeader.CNumberOfVariables = 
	CRecord.CHeader.CNumberOfVariables.Right(CRecord.CHeader.CNumberOfVariables.GetLength() - 15);

	CText = CRecord.CHeader.CNumberOfVariables;

	int number_of_varibles;

	sscanf(CText, "%d", &number_of_varibles);

	if(!number_of_varibles) 
	{
		return -1;
	}

	if(!CFileStream.ReadLine(buff, 1023))
	{
		return -1;
	}


	CRecord.CHeader.CNumberOfPoints = buff;

	CRecord.CHeader.CNumberOfPoints = 
	CRecord.CHeader.CNumberOfPoints.Right(CRecord.CHeader.CNumberOfPoints.GetLength() - 12);

	CText = CRecord.CHeader.CNumberOfPoints;
	CText.TrimRight();

	int number_of_points = 0;

	if(type != E_SPICE_RECORD_TRANSIENT) 
	if(CText == "0") 
	{
		DisplayError(IDS_ERR_ERROR, IDS_ZERO_NUMBER_OF_POINTS);

		return -1; //try and read in what is there
	}

	if(CText == "0" /*|| CText == "1"*/)//guestimate number of points,  occurs on premature terminate or marching waveforms; 
	{
		if(m_marching_waveform_type == type)
		{
			if(PCDoc) number_of_points = PCDoc->GetDefaultNumberOfPoints(type);
		}
		else
		{
			number_of_points = default_size/number_of_varibles/sizeof(double);
		}
		
		CRecord.CHeader.CNumberOfPoints.Format("%d", number_of_points);
	}

	if(!CFileStream.ReadLine(buff, 1023)) 
	{
		return -1;
	}

	CRecord.CHeader.CCommand = buff;

	CText = CRecord.CHeader.CCommand;

	CText.MakeLower();

	if(CText.Find("offset") > -1)//LT Spice adds Offset: so ignore it
	{
		if(!CFileStream.ReadLine(buff, 1023)) 
		{
			return -1;
		}

		CRecord.CHeader.CCommand = buff;
	}

	if(CText.Find("variables") < 0)// ngspice dec 2014 doesnt have command line
	if(!CFileStream.ReadLine(buff, 1023)) 
	{
		return -1;
	}


	CRecord.CHeader.CVariable = buff;

	CText = buff;// checking

	CText.TrimRight();
	CText.TrimLeft();
	CText.MakeLower();

	if(CText != "variables:")
	{
		// maybe LT's "Backannotation:", so ignore it
		if(!CFileStream.ReadLine(buff, 1023)) return -1;

		CText = buff;// checking

		CText.TrimRight();
		CText.TrimLeft();
		CText.MakeLower();

		if(CText != "variables:") return -1;
	}

	sscanf(CRecord.CHeader.CNumberOfVariables, "%d", &num_var);

	CRecord.CHeader.CVariables.SetSize(num_var);

	int start_index = CRecord.CSignals.GetSize();

	CRecord.CSignals.SetSize(num_var, num_var);// if new signals added, generate colours

	GenerateNewDefaultWaveformColours(CRecord, start_index);

	for(int p = 0; p < num_var; p++)
	{
		if(!CFileStream.ReadLine(buff, 1023))
		{
			return -1;
		}

		CRecord.CSignals[p].PCDoc = PCDoc;// for error reporting

		CText = buff;

		CText = RemoveFirstWord(CText);//remove numbering

		CText.TrimLeft();

		if(CText == "") 
		{
			return -1;
		}

		CRecord.CHeader.CVariables[p] = CText;

		if(!p && type != E_SPICE_RECORD_OPERATING_POINT && type != E_SPICE_RECORD_POLE_ZERO &&
			type != E_SPICE_RECORD_SENSITIVITY) 
		{
			if(CRecord.CHeader.CAxisName != "") 
				CRecord.CSignals[p].CName = CRecord.CHeader.CAxisName;// set in set type, overidse spice generated name
			else CRecord.CSignals[p].CName  = CRecord.CHeader.CVariables[p];
		}
		else 
		{
			CRecord.CSignals[p].SetName(CText);

			CRecord.CSignals[p].CName = Spice3ToSuperSpiceName(CRecord.CSignals[p].CName);
		}
	}

	if(!CFileStream.ReadLine(buff, 1023)) 
	{
		return -1;
	}

	CRecord.CHeader.CBinaryOrValues = buff;

	CText = CRecord.CHeader.CBinaryOrValues;

	CRecord.CHeader.SetupFFTHeader(*this);

	SetupSignalTypes(type);// moved from data reading

	m_last_signal_end_point	= 0;
	m_last_points_end_point = 0;

	return type + 1;
}

void TCOutputWaveformDataHeader::SetupFFTHeader(TCOutputWaveformData &COutputWaveformData)
{
	if(type != E_SPICE_RECORD_AC && type != E_SPICE_RECORD_TRANSIENT) return;

	int fft_index = -1;

	if(type == E_SPICE_RECORD_AC)			fft_index = E_SPICE_RECORD_FREQ_TO_TIME_FFT;
	else 	fft_index = E_SPICE_RECORD_TIME_TO_FREQ_FFT;

	TCOutputWaveformDataHeader &CHeaderDest = COutputWaveformData.CRecords[fft_index].CHeader;

	CHeaderDest.type = E_SPICE_RECORD_NULL;

	CHeaderDest.PCDoc				= PCDoc;
	CHeaderDest.PCWaveformDataRuns	= PCWaveformDataRuns;
		
	CHeaderDest.CDateAndTime		= CDateAndTime;
	CHeaderDest.CPlotName			= CPlotName;
	CHeaderDest.CFlags				= CFlags;
	CHeaderDest.CNumberOfVariables	= CNumberOfVariables;
	CHeaderDest.CNumberOfPoints		= CNumberOfPoints;
	CHeaderDest.CCommand			= CCommand;
	CHeaderDest.CVariable			= CVariable;
	CHeaderDest.CBinaryOrValues		= CBinaryOrValues;
	CHeaderDest.CFileName			= CFileName;
	CHeaderDest.CDataType			= CDataType;

	CHeaderDest.active_magnitude_axis_index = 0;
	CHeaderDest.active_phase_axis_index		= 0;
		
	int var_count = CVariables.GetSize();
			 
	CHeaderDest.CVariables.SetSize(var_count);

	int p;

	for(int p = 0; p < var_count; p++)
	{
		CHeaderDest.CVariables[p] = CVariables[p];
	}

	if(type == E_SPICE_RECORD_TRANSIENT)
	{
		CHeaderDest.CPlotName = "FFT " + CPlotName;
	}
	else if(type == E_SPICE_RECORD_AC)
	{
	
		CHeaderDest.CPlotName = "IFFT " + CPlotName;
	}

	CHeaderDest.SetType();// sets type to correct type if ok

	int start_index = COutputWaveformData.CRecords[fft_index].CSignals.GetSize();

	COutputWaveformData.CRecords[fft_index].CSignals.SetSize(var_count, var_count);// if new signals added, generate colours

	COutputWaveformData.GenerateNewDefaultWaveformColours(COutputWaveformData.CRecords[fft_index], start_index);

	for(p = 0; p < var_count; p++)
	{
		COutputWaveformData.CRecords[fft_index].CSignals[p].CName = COutputWaveformData.CRecords[type].CSignals[p].CName;
	}
}

bool TCOutputWaveformDataHeader::ChangeColour(TCTestPointData &CTestPointData)
{
	if(!PCSignals) return false;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	int index = FindSignal(CTestPointData.CNew);

	if(index < 0) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

	TCSignal &CSignal = CSignals[index];

	if(CTestPointData.new_type == TE_SIGNAL_DISPLAY_MAGNITUDE || 
	   CTestPointData.new_type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		CSignal.normal_colour = CTestPointData.old_type; // old_type comtains the colour ino.
	}
	else
	{
		CSignal.normal_phase_colour = CTestPointData.old_type;
	}
	

	return true;
}

bool TCOutputWaveformDataHeader::SaveAsText(CString CRunNumber, CString CRunName)
{
	if(!PCSignals) return false;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(count < 2) return true;

	CFile CDataFile;
	CString CFileName, CDataText, CFloatData, CXData;

	CFileName = CRunNumber + ".txt";

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);
	int points_count, q;
	bool phase;

	CDataText = CDataType + " - " + CRunName;
	
	CDataFile.Write(CDataText, CDataText.GetLength());

	CDataFile.Write(data, char_size);
	CDataFile.Write(data, char_size);

	int start = 1;
	if(type == E_SPICE_RECORD_POLE_ZERO) start = 0;

	for(int p = start; p < count; p++)// signal 0 is x axis
	{
		TCSignal &CSignal = CSignals[p];
		
		points_count = CSignal.CMagnitudeData.CX.GetSize();

		if(!points_count) 
		{
			CDataFile.Close();

			DeleteFile(CFileName);

			return true;
		}

		CDataText = CSignal.CName;

		if(type == E_SPICE_RECORD_POLE_ZERO && CSignal.CName.Find('[') > -1) break;// end of pole-zero data

		CDataFile.Write(CDataText, CDataText.GetLength()); //write name

		CDataFile.Write(data, char_size);

		if(type != E_SPICE_RECORD_POLE_ZERO)
		{
			CDataText = "X-Axis\tY-Mag\tY-Phase";// Header
		}
		else
		{
			CDataText = "Real\tImaginary";// Header
		}

		if(points_count != 1)
		{
			CDataFile.Write(CDataText, CDataText.GetLength());

			CDataFile.Write(data, char_size);
		}
		else if(p == 1)
		{
			CDataFile.Write(CDataText, CDataText.GetLength());

			CDataFile.Write(data, char_size);
		}

		if(!CSignal.CPhaseData.CX.GetSize()) phase = false;
		else phase = true;

		for(q = 0; q < points_count; q++)
		{
			CXData.Format("%e", CSignals[0].CMagnitudeData.CX[q]);

			CFloatData.Format("%e", CSignal.CMagnitudeData.CX[q]);

			if(type != E_SPICE_RECORD_POLE_ZERO) CDataText = CXData + "\t" + CFloatData;
			else CDataText = CFloatData;

			if(phase)
			{
				CFloatData.Format("%e", CSignal.CPhaseData.CX[q]);

				CDataText += "\t";

				CDataText += CFloatData;
			}
			else CDataText += "\t0.0";

			CDataFile.Write(CDataText, CDataText.GetLength());

			CDataFile.Write(data, char_size);
		}

		CDataFile.Write(data, char_size);// add blank line
	}
	
	CDataFile.Close();

	CString CMsg;

	CMsg.LoadString(IDS_DATA_SAVED_IN);
		
	CMsg = CPlotName + " " + CMsg + " " + CFileName;

	PCDoc->DisplayError(IDS_EER_STATUS, CMsg, 0);
	
	return true;
}

bool TCOutputWaveformDataHeader::SaveTranNodeSet(CString CRunName)
{
	if(!PCSignals) return false;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	if(count < 2) return true;

	CFile CDataFile;
	CString CFileName, CDataText, CFloatData, CXData, CNodeSet, CSpace;

	CFileName = CRunName;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);
	int points_count;

	int start = 1;

	CNodeSet = ".NODESET ";
	CSpace = " ";

	for(int p = start; p < count; p++)// signal 0 is x axis
	{
		TCSignal &CSignal = CSignals[p];
		
		points_count = CSignal.CMagnitudeData.CX.GetSize();

		if(!points_count) 
		{
			CDataFile.Close();

			DeleteFile(CFileName);

			return true;
		}

		// need to only save voltage nets names only
		
		index = CSignal.CName.Find("[");// currents, power etc have [] in them, may need mod for .subcks

		if(index > -1) continue;

		CDataText = CNodeSet + "V(" + CSignal.CName + ")=";

		CFloatData.Format("%e", CSignal.CMagnitudeData.CX[points_count-1]);

		CDataText += CFloatData;

		CDataFile.Write(CDataText, CDataText.GetLength()); //write .NODESET = V(name)

		CDataFile.Write(data, char_size);
	}

	CDataFile.Close();

	CString CMsg;

	CMsg.LoadString(IDS_DATA_SAVED_IN);
		
	CMsg = CPlotName + " " + CMsg + " " + CFileName;

	PCDoc->DisplayError(IDS_EER_STATUS, CMsg, 0);
	
	return true;
}

bool TCOutputWaveformDataHeader::ClearAllWaveforms(void)
{
	if(!PCSignals) return false;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		CSignal.magnitude = -1;
		CSignal.phase	  = -1;
	}

	return true;
}

bool TCOutputWaveformDataHeader::ChangeWaveform(TCTestPointData &CTestPointData)
{
	if(!PCSignals) return false;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	if(CTestPointData.old_index == -1 && 
		CTestPointData.new_index == -1)
	{
		CTestPointData.new_index = FindSignal(CTestPointData.CNew);

		CTestPointData.old_index = FindSignal(CTestPointData.COld);
	}

	int phase_size = 0;
	bool phase_flag = false;

	if(CTestPointData.old_index > -1)
	{
		CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

		if(!(CTestPointData.old_index < CSignals.GetSize())) return true;

		TCSignal &CSignal = CSignals[CTestPointData.old_index];
	
		if(IsBadCodePtr((FARPROC)&CSignal))
		{
			return false; 
		}

		switch(CTestPointData.old_type)// dont delete non test point signals
		{
			case E_TESTPOINT_VMAG:		CSignal.magnitude = -1; break;
			case E_TESTPOINT_VDB:		CSignal.magnitude = -1; break;
			case E_TESTPOINT_VPHDEGS:	CSignal.phase = -1; break;
			case E_TESTPOINT_VPRADS:	CSignal.phase = -1;break;	
			
			case E_TESTPOINT_MAGDEGS:	CSignal.magnitude = -1;CSignal.phase = -1;break;
			case E_TESTPOINT_MAGDBDEGS:	CSignal.magnitude = -1;CSignal.phase = -1;break;
			case E_TESTPOINT_MAGPHRADS:	CSignal.phase = -1;CSignal.magnitude = -1;break;
			case E_TESTPOINT_MAGDBRAD:	CSignal.phase = -1;CSignal.magnitude = -1;break;
		}
	}
	
	if(CTestPointData.new_index > -1)//allows waveform to be removed but testpoint stays on schematic
	{
		CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

		if(CTestPointData.new_index < CSignals.GetSize())
		{
			TCSignal &CSignal = CSignals[CTestPointData.new_index];

			if(IsBadCodePtr((FARPROC)&CSignal))
			{
				return false; 
			}

//			if(!CSignal.CMagnitudeData.CX.GetSize()) return false;// no runs data// removed for marching waveforms

			phase_size = 1;//CSignal.CPhaseData.CX.GetSize();//// removed for marching waveforms

			if(inteligent_signal_default)
			{
				switch(CTestPointData.new_type)
				{
					case E_TESTPOINT_VMAG:		active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = inteligent_signal_magnitude; break;
					case E_TESTPOINT_VDB:		active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = inteligent_signal_magnitude;break;
					case E_TESTPOINT_VPHDEGS:	active_phase_axis_index	= CTestPointData.new_index;CSignal.phase = inteligent_signal_phase; phase_flag = true; break;
					case E_TESTPOINT_VPRADS:	active_phase_axis_index	= CTestPointData.new_index;CSignal.phase = inteligent_signal_phase; phase_flag = true;break;	
					
					case E_TESTPOINT_MAGDEGS:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = inteligent_signal_magnitude;CSignal.phase = inteligent_signal_phase;active_magnitude_axis_index = CTestPointData.new_index; break;
					case E_TESTPOINT_MAGDBDEGS:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = inteligent_signal_magnitude;CSignal.phase = inteligent_signal_phase;active_magnitude_axis_index = CTestPointData.new_index; break;
					case E_TESTPOINT_MAGPHRADS:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = inteligent_signal_magnitude;CSignal.phase = inteligent_signal_phase;active_phase_axis_index = CTestPointData.new_index; phase_flag = true;break;
					case E_TESTPOINT_MAGDBRAD:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = inteligent_signal_magnitude;CSignal.phase = inteligent_signal_phase;active_phase_axis_index = CTestPointData.new_index; phase_flag = true;break;
				}
			}
			else
			{
				switch(CTestPointData.new_type)
				{
					case E_TESTPOINT_VMAG:		active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = 0;  break;
					case E_TESTPOINT_VDB:		active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = 1; break;
					case E_TESTPOINT_VPHDEGS:	active_phase_axis_index	= CTestPointData.new_index;CSignal.phase = 0;  phase_flag = true; break;
					case E_TESTPOINT_VPRADS:	active_phase_axis_index	= CTestPointData.new_index;CSignal.phase = 1; phase_flag = true;break;	
					
					case E_TESTPOINT_MAGDEGS:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = 0;CSignal.phase = 0;break;
					case E_TESTPOINT_MAGDBDEGS:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = 1;CSignal.phase = 0; break;
					case E_TESTPOINT_MAGPHRADS:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = 0;CSignal.phase = 1; phase_flag = true;break;
					case E_TESTPOINT_MAGDBRAD:	active_phase_axis_index	= CTestPointData.new_index;active_magnitude_axis_index = CTestPointData.new_index;CSignal.magnitude = 1;CSignal.phase = 1; phase_flag = true;break;
				}
			}

			if(!phase_size && phase_flag) // override as no phase data available
			{
				CSignal.phase= -1;
			}
		}
	}

	return true;
}

int	TCOutputWaveformDataHeader::FindSignal(CString CSignalName)
{
	CString CText;

	CSignalName.Remove('-');// need to flag and display data as negative

	CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

	if(IsBadReadPtr((void*)PCSignals, sizeof(CArray <TCSignal, TCSignal&>)))
	{
		ASSERT(0);

		return -1; 
	}

	int count = CSignals.GetSize();

	if(!count) return -1;

#ifdef _DEBUG
	if(count > 1000)
	{
		ASSERT(0);

		return -1;
	}
#endif

	CSignalName.MakeLower();

	if(!IsSpice3SubcircuitTypeName(CSignals))
	{
		for(int p = 0; p < count; p++)
		{
			CText = CSignals[p].CName;
	
			CText.MakeLower();

			if(CSignalName == CText) return p;
		}
	}
	else
	{
		for(int p = 0; p < count; p++)
		{
			CText = CSignals[p].CName;
	
			CText.MakeLower();

			CText = Spice3ToSuperSpiceName(CText);

			if(CSignalName == CText) return p;
		}
	}

	return -1;
}

// spice 3 has subcircuits as 1:2:net1, instead of x1:x2:net1

bool TCOutputWaveformDataHeader::IsSpice3SubcircuitTypeName(CArray <TCSignal, TCSignal&> &CSignals)
{
	if(!(2 < CSignals.GetSize()))return false;//first is x axis

	CString CText = CSignals[1].CName;// not foolproof

	if(CText.Find(':') < 0) return false;// not a subcircuit

	if(CText.GetAt(0) != 'x')
		if(CText.GetAt(0) != 'X') return true;

	return true;
}

bool TCOutputWaveformDataHeader::IsBinary(void)
{
	CString CText = CBinaryOrValues;

	CText.TrimLeft();
		
	CText = CText.Left(6);

	CText.MakeUpper();

	if(CText == "VALUES") return false;

	return true;
}

void TCOutputWaveformDataHeader::ClearAllSignals(void)
{
	CArray <TCSignal, TCSignal&> &CSignals = *PCSignals;

	int count = CSignals.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];

		if(IsBadCodePtr((FARPROC)&CSignal))
		{
			return; 
		}

		CSignal.phase		= -1;
		CSignal.magnitude	= -1;
	}
}

void TCOutputWaveformDataHeader::ComputeFFT(TCOutputWaveformDataHeader &CDataHeaderSource)
{
	if(IsBadCodePtr((FARPROC)PCSignals)) return;
	if(IsBadCodePtr((FARPROC)CDataHeaderSource.PCSignals)) return;

	CArray <TCSignal, TCSignal &> &CSignalsSource =	 *CDataHeaderSource.PCSignals;
	CArray <TCSignal, TCSignal &> &CSignalsDest	  = *PCSignals;

	int count = CSignalsSource.GetSize();

	CSignalsDest.SetSize(count);

	if(CSignalsDest.GetSize() != count) return;

	TCSignal CSourceCopiedData;

	TCFFT CFFT;

	int selected_signals = false;

	if(PCDoc)
	if(!IsBadCodePtr((FARPROC)PCDoc))
	if(!PCDoc->CMSuperSpiceDocData.PCAnalysisSetup)
	if(!(E_TRAN_CALCULATE_SELECTED_FFT_SIGNALS < PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray.GetSize()))
	{
		selected_signals = PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_SELECTED_FFT_SIGNALS];
	}

	for(int p = 0; p < count; p++)// first one is xaxis remember, fixup other one later
	{
		TCSignal &CSignalSource = CSignalsSource[p];
		TCSignal &CSignalDest	= CSignalsDest[p];

		if(IsBadCodePtr((FARPROC)&CSignalSource)) return;
		if(IsBadCodePtr((FARPROC)&CSignalDest)) return;

		int data_count = CSignalSource.CMagnitudeData.CX.GetSize();

		if(!data_count) return;

		CSignalDest.CMagnitudeData.CX.SetSize(data_count);
		CSignalDest.CPhaseData.CX.SetSize(data_count);

		if(!CSignalDest.CMagnitudeData.CX.GetSize()) return;
		if(!CSignalDest.CPhaseData.CX.GetSize()) return;

		CSourceCopiedData.CMagnitudeData	= CSignalSource.CMagnitudeData;
		CSourceCopiedData.CPhaseData		= CSignalSource.CPhaseData;
 
		// to do, axis recalulate  

		if(!CSourceCopiedData.CPhaseData.CX.GetSize())// no phase data
		{
			CSourceCopiedData.CPhaseData.CX.SetSize(data_count);

			CSourceCopiedData.CPhaseData.Zero();
		}

		if(p)
		{
			if(selected_signals)
			{
				if(CSignalDest.magnitude < 0)
					if(CSignalDest.phase < 0) continue;
			}

			if(CDataHeaderSource.type == E_SPICE_RECORD_AC)// *(a+ib)
			{
				CSourceCopiedData.CPhaseData = CSourceCopiedData.CPhaseData * (-1.0); 
			}

			CSourceCopiedData.already_polar = true;

			CSourceCopiedData.PolarToRectanguler();// data is in polar form

			if(!CFFT.Calculate(data_count, 
				CSourceCopiedData.CMagnitudeData.CX.GetData(), CSourceCopiedData.CPhaseData.CX.GetData(),
				CSignalDest.CMagnitudeData.CX.GetData(), CSignalDest.CPhaseData.CX.GetData())) return;

			int phase_count = CSignalDest.CPhaseData.CX.GetSize();

			double scale_factor = 3.14159265353897932/2/data_count;

			for(int q = 0; q < data_count; q++)
			{
				CSignalDest.CMagnitudeData.CX[q] *= scale_factor;

				if(phase_count == data_count) CSignalDest.CPhaseData.CX[q] *= scale_factor;
			}

			CSignalDest.already_polar = false;

			if(CDataHeaderSource.type == E_SPICE_RECORD_AC)// *(a+ib)
			{
				CSignalDest.CPhaseData = CSourceCopiedData.CPhaseData * (-1.0); 
			}

			CSignalDest.RectangulerToPolar();
		}
		else// just copy xaxis and rescale and allocate for next points
		{
			if(!CFFT.AllocateMemory(data_count)) 
			{
				AfxMessageBox(IDS_ERR_NO_MEMORY);

				return;
			}

			double freq, time, offset;// convert the scale factors

			CSignalDest.CMagnitudeData	= CSignalSource.CMagnitudeData;
			CSignalDest.CPhaseData		= CSignalSource.CPhaseData;

			offset = CSignalDest.CMagnitudeData.CX[0];

			time = CSignalDest.CMagnitudeData.CX[data_count - 1] - offset;

			if(!time) time =1.0;// soft error

			freq = 1.0/time;

			int phase_count = CSignalDest.CPhaseData.CX.GetSize();

			for(int q = 0; q < data_count; q++)
			{
				CSignalDest.CMagnitudeData.CX[q] = freq * q + offset;

				if(phase_count == data_count) CSignalDest.CPhaseData.CX[q] = freq * q + offset;	
			}
		}


		if(f_first)
		{
			CSignalDest.phase				= -1;// this makes mose sense for a default

			if(CDataHeaderSource.type == E_SPICE_RECORD_TRANSIENT)
			{
				if(CSignalSource.magnitude != -1)
					CSignalDest.magnitude = 1;//display in db
								
			}
			else if(CDataHeaderSource.type == E_SPICE_RECORD_AC)
			{
				if(CSignalSource.magnitude != -1)
					CSignalDest.magnitude = 0;//display as real
			}
		}
	}

	CFFT.DeleteMemory();

	if(CDataHeaderSource.type == E_SPICE_RECORD_TRANSIENT)
	{
		TCSignal &CSignalDest	= CSignalsDest[0];

		CSignalDest.CName = "FFT Frequency";
	}
	else if(CDataHeaderSource.type == E_SPICE_RECORD_AC)
	{
		TCSignal &CSignalDest	= CSignalsDest[0];

		CSignalDest.CName = "IFFT Time";
	}
}

bool TCOutputWaveformDataHeader::SetType(void)
{
	CString CText = CPlotName;
	CString CLine;

	CString CFirstWord = GetFirstWord(CPlotName, ' ');
	
	CFirstWord.MakeUpper();
	CText.MakeUpper();

	if(CText == "AC ANALYSIS")
	{
		type = E_SPICE_RECORD_AC;

		CDataType = "AC Analysis";

		CAxisName = "Frequency";

		if(PCDoc) // 8th Sept 2017
			if(PCDoc->CMSuperSpiceDocData.PCAnalysisSetup)
				if(PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_AC_ANALYSIS_FREQ_DEVICE_MODE])
					CAxisName = "Swept Device = " + PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE];

		inteligent_signal_magnitude = 1;//DB
		inteligent_signal_phase		= 0;

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;
			y_grid_decades = false;  
			y_phase_grid_decades = false;
			magnitude_db = true;//set db

		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CText == "DC TRANSFER CHARACTERISTIC")
	{
		type = E_SPICE_RECORD_DC;

		CAxisName = "DC Sweep"; 
		CDataType = "DC Sweep";
		inteligent_signal_magnitude = 0;//Magnitude
		inteligent_signal_phase		= -1;

		if(f_first)
		{
			f_first = false;

			x_grid_decades = false;
			y_grid_decades = false; 
			y_phase_grid_decades = false;// cant happen
			magnitude_db = false;//set linear
		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}


	if(CFirstWord == "NOISE")
	{
		DisplayError(IDS_EER_STATUS, "Reading spectral data...");

		type = E_SPICE_RECORD_NOISE_SPECTRAL;
		CDataType = "Spectral Noise";

		CAxisName = "Frequency";
		CPlotName = "Noise Spectral Density (V/A/sqrt Hz)";
		inteligent_signal_magnitude = 0;//Magnitude, with log y axis
		inteligent_signal_phase		= -1;

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;

			y_grid_decades = true; 

			y_phase_grid_decades = false;// cant happen

			magnitude_db = false;//set linear
		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "INTEGRATED")
	{
		type = E_SPICE_RECORD_NOISE_INTEGRATED;
		CDataType = "Integrated Noise";

		CAxisName = "Frequency";
		CPlotName = "Integrated Noise (V/A)";
		inteligent_signal_magnitude = 0;//Mag
		inteligent_signal_phase		= -1;

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;

			y_grid_decades = true; 
		
			y_phase_grid_decades = false;// cant happen

			magnitude_db = false;//set linear
		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "POLE-ZERO")
	{
		type = E_SPICE_RECORD_POLE_ZERO;
		CDataType = "Pole-Zero";

		CAxisName = "Real(S)";
		inteligent_signal_magnitude = 0;
		inteligent_signal_phase		= 0;

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;
			y_grid_decades = true;// db/db
			y_phase_grid_decades = false;// 

			magnitude_db = true;//set db
		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "SENSITIVITY")
	{
		type = E_SPICE_RECORD_SENSITIVITY;
		CDataType = "Sensitivity";

		inteligent_signal_magnitude = 0;//real
		inteligent_signal_phase		= 1;//radons

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;
			y_grid_decades = false; 
			y_phase_grid_decades = false;
			magnitude_db = false;//

		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "DISTORTION")
	{
		CFirstWord = CPlotName;
		CDataType = "Distortion";
		inteligent_signal_magnitude = 1;
		inteligent_signal_phase		= -1;

		CFirstWord = CFirstWord.Left(16);// THD and IMD in same space

		if(CFirstWord == "DISTORTION - 2nd") type = E_SPICE_RECORD_THD;

		else if(CFirstWord == "DISTORTION - 3rd") type = E_SPICE_RECORD_IMD;
		
		else if (CFirstWord == "DISTORTION - IM:")
		{
			CFirstWord = RemoveFirstWord(CPlotName);

			CFirstWord = RemoveFirstWord(CFirstWord, ':');

			if(CFirstWord == "f1+f2")type = E_SPICE_RECORD_IMD;

			else if (CFirstWord == "f1-f2")type = E_SPICE_RECORD_THD;

			else type = E_SPICE_RECORD_DISTORTION_IMD_2F;
		}

		CAxisName = "Frequency";

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;
			y_grid_decades = false;
			y_phase_grid_decades = false;// cant happen

			magnitude_db = true;//set db
		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "TRANSIENT")
	{
		type = E_SPICE_RECORD_TRANSIENT;
		CDataType = "Transient Analysis";
		inteligent_signal_magnitude = 0;
		inteligent_signal_phase		= -1;

		CAxisName = "Time";

		if(f_first)
		{
			f_first = false;

			x_grid_decades = false;
			y_grid_decades = false; 
			y_phase_grid_decades = false;// cant happen

			magnitude_db = false;//set linear
		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "OPERATING")
	{
		type = E_SPICE_RECORD_OPERATING_POINT;
		CDataType = "Operating Point";
		inteligent_signal_magnitude = 0;
		inteligent_signal_phase		= -1;

		return true;
	}

	if(CFirstWord == "FFT")
	{
		type = E_SPICE_RECORD_TIME_TO_FREQ_FFT;
		CDataType = "FFT";

		CAxisName = "FFT Frequency"; 
		inteligent_signal_magnitude = 1; // DB changed from 0 16th Nov 2013. SHold be in dB
		inteligent_signal_phase		= -1; 

		if(f_first)
		{
			f_first = false;

			x_grid_decades = true;
			y_grid_decades = false;  
			y_phase_grid_decades = false;
			magnitude_db = true;//set db

		}
		else magnitude_db = -1;// so set name on signal will ignore this yime

		return true;
	}

	if(CFirstWord == "IFFT")
	{
		type = E_SPICE_RECORD_FREQ_TO_TIME_FFT;
		CDataType = "IFFT";
		inteligent_signal_magnitude = 0;
		inteligent_signal_phase		= 0;

		CAxisName = "IFFT Time";

		if(f_first)
		{
			f_first = false;

			x_grid_decades = false;
			y_grid_decades = false; 
			y_phase_grid_decades = false;

			magnitude_db = false;//set linear
		}
		else magnitude_db = -1;// so set name on signal will ignore this time

		return true;
	}
	
	DisplayError(IDS_ERR_ERROR, "Invalid spice data header");

	return false;
}


/////////////////////////////////////////////////////////////////////////
bool TCOutputWaveformData::IsWaveformHeaderAvailable(int type_id)
{
	int index = GetWaveFormHeaderIndex(type_id);

	if(index < 0) return false;

	return true;
}

bool TCOutputWaveformData::AreWaveformsAvailable(void)
{
	for(int p = 0; p < E_SPICE_RECORD_NULL; p++)
	{
		if(p == E_SPICE_RECORD_OPERATING_POINT) continue;
		if(p == E_SPICE_RECORD_MATH_0) continue;
		if(p == E_SPICE_RECORD_NULL) continue;
		
		if(GetWaveFormHeaderIndex(p) < 0) continue;

		return true;
	}
	
	return false;
}

int TCOutputWaveformData::GetWaveFormHeaderIndex(int type_id)
{
	int p, count;
	CString CText;

	count = CRecords.GetSize();

	if(type_id == E_SPICE_RECORD_NULL)// get first record, if any
	{
		if(count) return 0;
	}

	for(p = 0; p < count; p++)
	{		
		if(CRecords[p].CHeader.type == type_id) return p;
	}

	return -1;
}

bool TCOutputWaveformData::AreAnySignalsEnabled(int id)
{
	if(id < 0) return true;

	if(!(id < CRecords.GetSize())) return true;

	if(!CRecords[0].CHeader.PCWaveformDataRuns) return true;

	if(IsBadCodePtr((FARPROC) CRecords[0].CHeader.PCWaveformDataRuns))return true;

	CArray <TCSignal, TCSignal &> &CSignals = CRecords[id].CSignals;

	if(IsBadCodePtr((FARPROC) &CSignals))return true;

	int signal_count = CSignals.GetSize();

	for(int p = 0; p < signal_count; p++)
	{
		if(CSignals[p].magnitude > -1) return true;
		if(CSignals[p].phase > -1) return true;
	}

	return false;
}

void TCOutputWaveformData::ClearAllData(void)
{
	// only clear data, keep existing setups
	int count, count2, p, q;

	count = CRecords.GetSize();

	for(p = 0; p < count; p++)
	{
		count2 = CRecords[p].CSignals.GetSize();

		CRecords[p].CHeader.type	= E_SPICE_RECORD_NULL;
		CRecords[p].CHeader.index	= p;
		CRecords[p].CHeader.CDisplayedSignalsList.SetSize(0);// will be recreated with new pointers

		// need a bit more checking on this, wants to be available always
		if(p == E_SPICE_RECORD_MATH_0) CRecords[p].CHeader.type = E_SPICE_RECORD_MATH_0;

		for(q = 0; q < count2; q++)
		{
			if(!CRecords[p].CHeader.ValidateSignal(&CRecords[p].CSignals[q])) continue;

			CRecords[p].CSignals[q].CMagnitudeData.CX.SetSize(0);
			CRecords[p].CSignals[q].CPhaseData.CX.SetSize(0);
		}
	}
}


////////////////////////
void TCOutputWaveformData::GenerateNewDefaultWaveformColours(TCOutputWaveformDataRecord &CRecord, int start_index)
{
	int count = CRecord.CSignals.GetSize();

	if(!(start_index < count)) return;

	int max = CMColorRefList.GetSize() - 2;// ignore ist marker and black, white, and last marker

	if(max < 0) return; // not really possible

	int index = 3;
	int index_phase = 64;

	for(int p = start_index; p < count; p++)
	{
		if(!(index < max)) index = 3;
		if(!(index_phase < max)) index_phase = 3;

		CRecord.CSignals[p].normal_colour = CMColorRefList[index];
		CRecord.CSignals[p].normal_phase_colour = CMColorRefList[index_phase];

		index++;
		index_phase++;
	}
}
void TCOutputWaveformData::SetupSignalTypes(int index)
{
	CString CText;
	int num_points;

	if(index < 0) return;

	if(!(index < CRecords.GetSize())) return;// this can not happen but check anyway

	int num_signals = CRecords[index].CSignals.GetSize();

	sscanf(CRecords[index].CHeader.CNumberOfPoints, "%d", &num_points);

	int type = CRecords[index].CHeader.type;

	int inoise_index = CRecords[index].CHeader.FindSignal("inoise_spectrum");
	int onoise_index = CRecords[index].CHeader.FindSignal("onoise_spectrum");

	if(inoise_index < 0) inoise_index = 1;
	if(onoise_index < 0) onoise_index = 2;

	for(int p = 0; p < num_signals; p++)
	{
		TCOutputWaveformDataRecord &CRecord = CRecords[index];

		CArray <TCSignal, TCSignal&> &CSignals = *CRecord.CHeader.PCSignals;

		if(!(p < CSignals.GetSize())) continue;
		
		TCSignal &CSignal = CSignals[p];

		if(CRecord.CHeader.type == E_SPICE_RECORD_NOISE_SPECTRAL ||
		   CRecord.CHeader.type == E_SPICE_RECORD_NOISE_INTEGRATED)
		{// this is to be more user friendly for noise results
			if(p == inoise_index || p == onoise_index) //inoise, outnoise display as first default
			{
				if(CSignal.f_first)//i.e no prior data
				{
					CSignal.f_first = false;
					CSignal.CMagnitudeData.CX.SetSize(num_points, num_points);
					CSignal.CMagnitudeData.Zero();
					CSignal.already_polar = true;
					CSignal.magnitude = 0;
				}
			}
		}

		CSignal.CMagnitudeData.CX.SetSize(num_points, num_points);
		CSignal.CMagnitudeData.Zero();
		CSignal.stop_point = 0;
		CSignal.start_point = 0;
		CSignal.graphic_stop_point = 0;

		CSignal.already_polar = true;

		CText = CRecord.CHeader.CVariables[p];

		if(type == E_SPICE_RECORD_SENSITIVITY && num_points < 2)// 2 points and more is an ac sens run
		{
			CSignal.magnitude_and_phase_type = false;	
		}
		else
		{
			CSignal.SetMagnitudeAndPhaseType(type, CText);
		}
		
		// determine if any phase data here
		if(CSignal.magnitude_and_phase_type)
		{
			CSignal.CPhaseData.CX.SetSize(num_points, num_points);
			CSignal.CPhaseData.Zero();
		}
		else CSignal.CPhaseData.CX.SetSize(0);
	}
}

void TCOutputWaveformData::ReadDataEnded(int status)
{
	if(!CRecords.GetSize()) return;

  	int index = CRecords[E_SPICE_RECORD_NULL].CHeader.type;

	if(index < 0) return;

  	TCOutputWaveformDataRecord &CRecord = CRecords[index];

	int num_signals = CRecord.CSignals.GetSize();

	CArray <TCSignal, TCSignal&> &CSignals = *CRecord.CHeader.PCSignals;

	for(int p = 0; p < num_signals; p++)
	{	
		TCSignal &CSignal = CSignals[p];

		if(CSignal.magnitude_and_phase_type) CSignal.MakePhaseContinuous();

		if(status)
		{
			if(status == 1)
			{
				CSignal.CMagnitudeData.CX.SetSize(m_last_points_end_point);

				if(CSignal.magnitude_and_phase_type)
					CSignal.CPhaseData.CX.SetSize(m_last_points_end_point);
			}
		}
		else
		{
			CSignal.CMagnitudeData.CX.SetSize(m_last_points_end_point + 1);

			if(CSignal.magnitude_and_phase_type) CSignal.CPhaseData.CX.SetSize(m_last_points_end_point + 1);
		}

		CSignal.stop_point = 0;			// marching aveforms
		CSignal.graphic_stop_point = 0; // marching aveforms
		CSignal.CMagnitudeData.stop_point = 0;
		CSignal.CPhaseData.stop_point = 0;
	}

//	Removed on 6th May 2004. Issue with displaying old signal correctly. Need to fix later 
//	RemoveDublicateSignals();

	if(index == E_SPICE_RECORD_DC) SetDCSweepAxisName();
	if(index == E_SPICE_RECORD_TRANSIENT) if(m_linearize_transient_data) LinearizeTransientData();
	if(index == E_SPICE_RECORD_NOISE_SPECTRAL) GenerateIntegratedNoiseData();
	if(index == E_SPICE_RECORD_AC) GenerateACAnalysisData();
	if(index == E_SPICE_RECORD_TRANSIENT) GenerateTransientFrequencyData();
}

void TCOutputWaveformData::SetDCSweepAxisName(void)
{
	if(!PCDoc) return;

	int type = CRecords[E_SPICE_RECORD_NULL].CHeader.type;

	TCOutputWaveformDataRecord &CRecord = CRecords[type];

	if(type != E_SPICE_RECORD_DC) return;
	
	CArray <TCSignal, TCSignal&> &CSignals = *CRecord.CHeader.PCSignals;

	CString CName;

	TCSignal &CSignal = CSignals[0];

	if(PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable)
	if(PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_VOLTS_V_TEMP)
	{
		CSignal.CName = "Temperature Sweep In Degrees Centigrade";

		return;
	}

	CString CRefDes, CTemp;

	CRefDes = PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSource1;

	CTemp = CRefDes;

	CTemp.TrimLeft();
	CTemp.TrimRight();
	CTemp.MakeLower();

	if(CTemp == "") return;

	if(CTemp.GetAt(0) == 'v') 
	{
		CSignal.CName = "DC Voltage Sweep Of " + CRefDes;
	}
	else if(CTemp.GetAt(0) == 'i')
	{
		CSignal.CName = "DC Current Sweep Of " + CRefDes;
	}

	else CSignal.CName = "DC Resistance Sweep Of " + CRefDes;
}

void TCOutputWaveformData::RemoveDublicateSignals(void)
{
	int type = CRecords[E_SPICE_RECORD_NULL].CHeader.type;

	TCOutputWaveformDataRecord &CRecord = CRecords[type];

	int p=0, q;
	
	CArray <TCSignal, TCSignal&> &CSignals = *CRecord.CHeader.PCSignals;

	CString CFirstName;

	while(p < CSignals.GetSize())
	{
		TCSignal &CFirstSignal = CSignals[p];

		CFirstName = CFirstSignal.CName;

		if(type == E_SPICE_RECORD_DC)// quick bodge to display temp instead of dc sweep
		{
			if("v1_ss_temp_sweepnode" == CFirstName)
			{
				CSignals[0].CName = "Temperature Degs. C";

				CSignals.RemoveAt(p);

				continue;
			}

			if("v1_ss_temp_sweep[i]" == CFirstName)
			{
				CSignals.RemoveAt(p);

				continue;
			}
		}

		q = p + 1;

		while(q < CSignals.GetSize())
		{
			TCSignal &CSecondSignal = CSignals[q];

			if(CFirstName != CSecondSignal.CName)
			{
				q++;

				continue;
			}

			CSignals.RemoveAt(q);

			break;
		}

		p++;
	}
}

int TCOutputWaveformData::GrowDataSize(void)
{
	if(!CRecords.GetSize()) return 0;

  	int index = CRecords[E_SPICE_RECORD_NULL].CHeader.type;

	if(index < 0) return 0;

  	TCOutputWaveformDataRecord &CRecord = CRecords[index];

	int num_signals = CRecord.CSignals.GetSize();
	int size = 0;

	CArray <TCSignal, TCSignal&> &CSignals = *CRecord.CHeader.PCSignals;

	for(int p = 0; p < num_signals; p++)
	{	
		TCSignal &CSignal = CSignals[p];

		size = CSignal.CMagnitudeData.CX.GetSize();

		size *= 2;

		CSignal.CMagnitudeData.CX.SetSize(size);

		if(CSignal.CPhaseData.CX.GetSize()) CSignal.CPhaseData.CX.SetSize(size);
	}

	return size;
}

void TCOutputWaveformData::DisplayLoadingStatus(int p, int num_points)
{
	ProcessWindowsMessages();// stop bad loading locking out system

	if(!GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.display_loading_status) return;

	CString Counter;

	Counter.Format("Reading data point %d of %d", p, num_points);

	if(m_marching_waveform_type != -1) DisplayError(IDS_READING_MARCHING_DATA, Counter);
	else DisplayError(IDS_LOADING_DATA, Counter);// output status info
}

int TCOutputWaveformData::ReadNextTextData(TCIFStream &CFileStream, int index)
{
	// This dont work for marching waveforms. Use Binary mode.
	if(!(index < CRecords.GetSize())) return -1;

	TCOutputWaveformDataRecord &CRecord = CRecords[index];

	char buff[1024];

	CString CText;
	CString CError;

	int q = 0, num_points;

	int num_signals = CRecord.CSignals.GetSize();

	sscanf(CRecord.CHeader.CNumberOfPoints, "%d", &num_points);

	int type = CRecord.CHeader.type;

	int step_size = 1;

	step_size = num_points/20;

	if(!step_size) step_size = 1;

	CString CMessage, Counter;

	int missing_data = false;
	int new_p;
	int last_signal_end_point = 0;
	int last_points_end_point = 0;

	for(int p = 0; p < num_points; p++)
	{
		if(!(p % step_size) && p) DisplayLoadingStatus(p, num_points);// check every 5% point

		new_p = p;

		if(p > 2) new_p = p - 2;

		TCSignal *PCSignals = &CRecord.CSignals[0];

		for(q = 0; q <  num_signals; q++)
		{
			if(CFileStream.peek() != EOF)
			{
				if(!CFileStream.ReadLine(buff, 1023)) 
				{
					missing_data  = true;
				}
			}
			else 
			{
				m_last_signal_end_point = q;

				missing_data  = true;
			}

			if(missing_data) break;

			m_last_signal_end_point = 0;// After getting new data, next time round starts from 0 again

			CText = buff;

			if(q || index == E_SPICE_RECORD_POLE_ZERO ||  (index == E_SPICE_RECORD_SENSITIVITY && !PCSignals->magnitude_and_phase_type))// Pole-zero is unique
			{
				if((!q && index == E_SPICE_RECORD_POLE_ZERO) || (!q && (index == E_SPICE_RECORD_SENSITIVITY && !PCSignals->magnitude_and_phase_type))) 
					CText = RemoveFirstWord(CText);// get rid of counter

				PCSignals->AddData(CText, p, type);

			}
			else 
			{
				CText = RemoveFirstWord(CText);// get rid of counter

				PCSignals->AddData(CText, p, -1);// 0th signal is axis so dont modify data
			}

			if(!q)  //X signal
			{							
				PCSignals->CMagnitudeData.stop_point = p;	// tells max/min stop point
				PCSignals->CPhaseData.stop_point = p;		// for max/max stop point
			}
			else
			{		
				PCSignals->CMagnitudeData.stop_point = new_p;	
				PCSignals->CPhaseData.stop_point = new_p;	
			}

			last_signal_end_point = q;

			PCSignals->stop_point = new_p; // realtime update, drawing stop point

			PCSignals++;
		}

		last_points_end_point = p;

		if(missing_data) break;
	}

	m_last_signal_end_point = last_signal_end_point;
	m_last_points_end_point = last_points_end_point;

	if(m_marching_waveform_type == -1)//marching reading but not marching
	if(missing_data)
	{
		DisplayError(IDS_LOAD_DATA_ERROR, IDS_MISSING_DATA_IN_FILE);
	}

	if(!missing_data) missing_data = 2;

	ReadDataEnded(missing_data);// missing data will truncate the data size, otherwise left along

	if(missing_data == 1) return 0;////Tells marching reading that non marching read is not finished

	return true;//Tells marching reading that non marching read is finished
}

int TCOutputWaveformData::ReadNextBinaryData(TCIFStream &CFileStream, int index)
{
	if(!(index < CRecords.GetSize())) return -1;

	TCOutputWaveformDataRecord &CRecord = CRecords[index];
	double d_data1 = 0.0;
	double d_data2 = 0.0;
	float  f_data1 = 0.0;
	float  f_data2 = 0.0;

	bool double_data = true;
	
	if(!(CRecord.CHeader.CFlags.Find("$") < 0)) double_data = false;

//	double_data = false;//temp tsting of LTSpice format

	CString CText;

	int q = 0, num_points;

	int num_signals = CRecord.CSignals.GetSize();

	sscanf(CRecord.CHeader.CNumberOfPoints, "%d", &num_points);

	if(m_marching_waveform_type == index)
	if(index == E_SPICE_RECORD_TRANSIENT)//only transient has unknown size
	if(m_last_points_end_point)// zero is use points as is
	if(!(m_last_points_end_point < num_points))// this will only happen on marching waveforms
	{
		num_points = GrowDataSize();

		CRecord.CHeader.CNumberOfPoints.Format("%d", num_points);
	}

	int type = CRecord.CHeader.type;

	int step_size = 1;

	step_size = num_points/20;

	if(!step_size) step_size = 1;

	CString CMessage, Counter;

	int missing_data = false;
	int new_p;
	int last_points_end_point = 0;
	int last_signal_end_point = 0;

	for(int p = m_last_points_end_point; p < num_points; p++)
	{
		if(!(p % step_size) && p) DisplayLoadingStatus(p, num_points);// check every 5% point

		new_p = p;

		if(p > 2) new_p = p - 2;

		if(m_last_signal_end_point < 0) return -1;// major fault, should not happen

		for(q = m_last_signal_end_point; q < num_signals; q++)
		{
			if(CFileStream.peek() != EOF)
			{
				if(double_data)
				{
					if(!CFileStream.read((char*)&d_data1, sizeof(d_data1)))
					{
						missing_data  = true;
					}
				}
				else
				{
					if(!CFileStream.read((char*)&f_data1, sizeof(f_data1)))
					{
						missing_data  = true;
					}
				}
			}
			else 
			{
				last_signal_end_point = q;

				missing_data  = true;
			}

			if(missing_data) break;

			m_last_signal_end_point = 0;// After getting new data, next time round starts from 0 again

			TCSignal &CSignal = CRecord.CSignals[q];

			if(!double_data) d_data1 = (double) f_data1;

			GetSafeFloat(d_data1);

			if(CSignal.magnitude_and_phase_type)
			{
				if(double_data)
				{
					if(!CFileStream.read((char*)&d_data2, sizeof(d_data2)))
					{
						missing_data  = true;
					}
				}
				else
				{
					if(!CFileStream.read((char*)&f_data2, sizeof(f_data2)))
					{
						missing_data  = true;
					}
				}

				if(missing_data) break;

				if(!double_data) d_data2 = (double) f_data2;

				GetSafeFloat(d_data2);
			}

			if(q || index == E_SPICE_RECORD_POLE_ZERO || (index == E_SPICE_RECORD_SENSITIVITY && !CRecords[index].CSignals[q].magnitude_and_phase_type))// Pole-zero is unique
			{
				CSignal.AddBinaryData(d_data1, d_data2, p, type);
			}
			else 
			{
				CSignal.AddBinaryData(d_data1, d_data2, p, -1);// 0th signal is axis so dont modify data
			}

			if(!q)  //X signal
			{							
				CSignal.CMagnitudeData.stop_point = p;	// tells max/min stop point
				CSignal.CPhaseData.stop_point = p;		// for max/max stop point
			}
			else
			{		
				CSignal.CMagnitudeData.stop_point = new_p;	
				CSignal.CPhaseData.stop_point = new_p;	
			}

			last_signal_end_point = q;

			CSignal.stop_point = new_p; // realtime update, drawing stop point
		}

		last_points_end_point = p;
		
		if(p == 10)  if(m_marching_waveform_type == index) SetupMarchingWaveforms(index, CRecord.CSignals[0], p - 1);// get first few points before starting the march

		if(missing_data) break;
	}

	m_last_signal_end_point = last_signal_end_point;

	if(m_marching_waveform_type == index)  
	{	
		//dont march the same data
		if(missing_data)//pathalogical case
		if(m_last_points_end_point == last_points_end_point)
		{
			return m_last_points_end_point;
		}

		m_last_points_end_point = last_points_end_point;

		if(PCDoc) PCDoc->SendContinueCommand();

		UpdateMarchingWaveforms(index, CRecord.CSignals[0], m_last_points_end_point - 1);

		if(missing_data) return m_last_points_end_point;// need to try again for last point

		m_last_points_end_point++;// go on to next point
		m_last_signal_end_point++;// go on to next point

		if(!(m_last_signal_end_point < num_signals)) m_last_signal_end_point = 0;

		return m_last_points_end_point;// premerture end, so scan again.
	}

	m_last_points_end_point = last_points_end_point;

	if(m_marching_waveform_type == -1)//marching reading but not marching
	if(missing_data)// marching waveforms never get here
	{
		DisplayError(IDS_LOAD_DATA_ERROR, IDS_MISSING_DATA_IN_FILE);
	}

	if(!missing_data) missing_data = 2;

	ReadDataEnded(missing_data);// missing data will truncate the data size, otherwise left along

	if(missing_data == 1) return 0;////Tells marching reading that non marching read is not finished

	return true;//Tells marching reading that non marching read is finished
}

void TCOutputWaveformData::SetupMarchingWaveforms(int index, TCSignal &CSignal, int end_point)
{
	if(fm_open_waveform_graph) return;
	if(!PCDoc) return;
	if(index != E_SPICE_RECORD_TRANSIENT) return;

	double max, min, last;

	last = CSignal.CMagnitudeData.CX[end_point];
	max  = last;

	if(!PCDoc->GetGraphXRange(index, max, min)) return;

	CSignal.CMagnitudeData.CX[end_point] = max;

	PCMOutputWaveformDoc = PCDoc->OpenAndUpdateAllWaveformGraphs();

	if(!PCMOutputWaveformDoc)
	{
		CSignal.CMagnitudeData.CX[end_point] = last;

		return;
	}

	PCMOutputWaveformDoc->SetupMarchingWaveforms(m_run_number + 1, index);// offset as zero is non refresh

	CSignal.CMagnitudeData.CX[end_point] = last;

	fm_open_waveform_graph = true;
}

void TCOutputWaveformData::UpdateMarchingWaveforms(int index, TCSignal &CSignal, int end_point)
{
	if(!PCDoc) return;
	if(!fm_open_waveform_graph) return;
	if(!PCMOutputWaveformDoc) return;
	if(index < 0) return;
	if(end_point < 0) return;

	double max, min, last;

	last = CSignal.CMagnitudeData.CX[end_point];
	max  = last;

	if(!PCDoc->GetGraphXRange(index, max, min)) return;

	CSignal.CMagnitudeData.CX[end_point] = max; // keep feeding in correct end point

	PCMOutputWaveformDoc->UpdateMarchingWaveforms(m_run_number, index);

	CSignal.CMagnitudeData.CX[end_point] = last;

//	Sleep(500);
}

void TCOutputWaveformData::GenerateIntegratedNoiseData(void)
{
	int count = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals.GetSize();

	if(count < 3) return; 
 
	int index = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CHeader.FindSignal("inoise_spectrum"); //last usfull one in list

	if(index < 0) return;

	int new_size = index + 2 + 1;// Two extra for integrated inoise and onoise and delete garbage

	CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals.SetSize(new_size);

	int base_index = index - 1;

	TCSignal &CFrequencySignal = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals[0];
	TCSignal &COutputSignal = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals[base_index];
	TCSignal &CInputSignal = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals[base_index + 1];
	TCSignal &COutputSignalIntegrated = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals[base_index + 2];
	TCSignal &CInputSignalIntegrated = CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CSignals[base_index + 3];

	COutputSignalIntegrated.CName = "onoise_integrated";
	CInputSignalIntegrated.CName = "inoise_integrated";

	int points_count = CFrequencySignal.CMagnitudeData.CX.GetSize();

	if(points_count < 2) return;

	COutputSignalIntegrated.CMagnitudeData.CX.SetSize(points_count);
	CInputSignalIntegrated.CMagnitudeData.CX.SetSize(points_count);
	
	double df, last_f = CFrequencySignal.CMagnitudeData.CX[0];
	double ssi = 0, sso = 0;

	for(int q = 0; q < points_count; q++)//rms of signals.
	{
		df = CFrequencySignal.CMagnitudeData.CX[q] - last_f; 

		last_f = CFrequencySignal.CMagnitudeData.CX[q];

		sso += COutputSignal.CMagnitudeData.CX[q] * COutputSignal.CMagnitudeData.CX[q] * df;

		ssi += CInputSignal.CMagnitudeData.CX[q] * CInputSignal.CMagnitudeData.CX[q] * df;

		if(sso < 2.0e-22) sso = 2.0e-22; //20 pV minium integrated noise to set graph auto scaling
		if(ssi < 2.0e-22) ssi = 2.0e-22; //This means that to get < 20 pV, compute some prior decades

		COutputSignalIntegrated.CMagnitudeData.CX[q] = sqrt(sso);
		CInputSignalIntegrated.CMagnitudeData.CX[q] = sqrt(ssi);
	}
}

bool TCOutputWaveformData::GenerateTransientFrequencyData(void)
{
	if(!CMWaveformAnalyisisData.trans_frequency_enable) return true;

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CMWaveformAnalyisisData.CTransFrequencySignalName);

	if(index < 0) return false;

	TCSignal &CXSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CYSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CYSignal.CMagnitudeData.CX.GetSize())  return false;

	int first_index = CYSignal.CMagnitudeData.GetForwardValuePosition(CMWaveformAnalyisisData.trans_xing_level, CMWaveformAnalyisisData.trans_xing_first_count, CMWaveformAnalyisisData.trans_xing_sign);

	if(first_index < 0) return false;

	double first_value = CXSignal.CMagnitudeData.CX[first_index];

	int last_index = CYSignal.CMagnitudeData.GetForwardValuePosition(CMWaveformAnalyisisData.trans_xing_level, CMWaveformAnalyisisData.trans_xing_last_count, CMWaveformAnalyisisData.trans_xing_sign);

	if(last_index < 0) return false;

	double last_value = CXSignal.CMagnitudeData.CX[last_index];

	double value = last_value - first_value;

	if(!value) return false;

	int number_of_cycles = CMWaveformAnalyisisData.trans_xing_last_count - CMWaveformAnalyisisData.trans_xing_first_count;

	if(number_of_cycles < 1) number_of_cycles = 1;

	CMWaveformAnalyisisData.trans_frequency = number_of_cycles/value;
	
	CMWaveformAnalyisisData.trans_last_time	 = last_value;
	CMWaveformAnalyisisData.trans_first_time = first_value;

	return true;
}

bool TCOutputWaveformData::GeneratePulseRise(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CPulseMeasureSignal);

	if(index < 0) return false;

	TCSignal &CXSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CYSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CYSignal.CMagnitudeData.CX.GetSize())  return false;

	double lower_level = 0.1 * (CWaveformAnalyisisData.pulse_max_level - CWaveformAnalyisisData.pulse_min_level) + CWaveformAnalyisisData.pulse_min_level;

	int first_index = CYSignal.CMagnitudeData.GetForwardValuePosition(lower_level, CWaveformAnalyisisData.pulse_xing_count, 1);

	if(first_index < 0) return false;

	double first_value = CXSignal.CMagnitudeData.CX[first_index];

	double upper_level = 0.9 * (CWaveformAnalyisisData.pulse_max_level - CWaveformAnalyisisData.pulse_min_level) + CWaveformAnalyisisData.pulse_min_level;

	int secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(upper_level, CWaveformAnalyisisData.pulse_xing_count, 1);

	if(secound_index < 0) return false;

	int extra_count = CWaveformAnalyisisData.pulse_xing_count;
	int exit_count = 0;

	while(secound_index <= first_index) // migt be strange waveforms
	{
		extra_count++;
		exit_count++;
		
		if(exit_count > 10) break;

		secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(upper_level, extra_count, 1);
	}

	if(secound_index < 0) return false;

	double secound_value = CXSignal.CMagnitudeData.CX[secound_index];

	double mid_level = CWaveformAnalyisisData.pulse_mid_level;
	
	int mid_index = CYSignal.CMagnitudeData.GetForwardValuePosition(mid_level, CWaveformAnalyisisData.pulse_xing_count, 1);

	if(mid_index < 0) return false;

	double mid_value = CXSignal.CMagnitudeData.CX[mid_index];

	CWaveformAnalyisisData.pulse_rise_time = secound_value - first_value;

	CWaveformAnalyisisData.pulse_rise_xing_time = mid_value;

	return true;
}

bool TCOutputWaveformData::GeneratePulseFall(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CWaveformAnalyisisData.pulse_fall_time = 0;
	CWaveformAnalyisisData.pulse_fall_xing_time = 0;

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CPulseMeasureSignal);

	if(index < 0) return false;

	TCSignal &CXSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CYSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CYSignal.CMagnitudeData.CX.GetSize())  return false;

	double upper_level = 0.9 * (CWaveformAnalyisisData.pulse_max_level - CWaveformAnalyisisData.pulse_min_level) + CWaveformAnalyisisData.pulse_min_level;

	int first_index = CYSignal.CMagnitudeData.GetForwardValuePosition(upper_level, CWaveformAnalyisisData.pulse_xing_count, -1);

	if(first_index < 0) return false;

	double first_value = CXSignal.CMagnitudeData.CX[first_index];

	double lower_level = 0.1 * (CWaveformAnalyisisData.pulse_max_level - CWaveformAnalyisisData.pulse_min_level) + CWaveformAnalyisisData.pulse_min_level;

	int secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(lower_level, CWaveformAnalyisisData.pulse_xing_count, -1);

	if(secound_index < 0) return false;

	int extra_count = CWaveformAnalyisisData.pulse_xing_count;
	int exit_count = 0;

	while(secound_index <= first_index) // migt be strange waveforms
	{
		extra_count++;
		exit_count++;
		
		if(exit_count > 10) break;

		secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(lower_level, extra_count, -1);
	}

	if(secound_index < 0) return false;
	double secound_value = CXSignal.CMagnitudeData.CX[secound_index];

	double mid_level = CWaveformAnalyisisData.pulse_mid_level;
	
	int mid_index = CYSignal.CMagnitudeData.GetForwardValuePosition(mid_level, CWaveformAnalyisisData.pulse_xing_count, -1);

	if(mid_index < 0) return false;

	double mid_value = CXSignal.CMagnitudeData.CX[mid_index];

	CWaveformAnalyisisData.pulse_fall_time = secound_value - first_value;

	CWaveformAnalyisisData.pulse_fall_xing_time = mid_value;

	return true;
}

bool TCOutputWaveformData::GeneratePulseWidth(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CWaveformAnalyisisData.pulse_width = 0;

	CWaveformAnalyisisData.pulse_width_mid_time = 0;

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CPulseMeasureSignal);

	if(index < 0) return false;

	TCSignal &CXSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CYSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CYSignal.CMagnitudeData.CX.GetSize())  return false;

	double level = CWaveformAnalyisisData.pulse_mid_level;

	int first_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, CWaveformAnalyisisData.pulse_xing_count, CWaveformAnalyisisData.pulse_width_polarity);

	if(first_index < 0) return false;

	double first_value = CXSignal.CMagnitudeData.CX[first_index];

	int secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, CWaveformAnalyisisData.pulse_xing_count, -CWaveformAnalyisisData.pulse_width_polarity);

	if(secound_index < 0) return false;

	int extra_count = CWaveformAnalyisisData.pulse_xing_count;
	int exit_count = 0;

	while(secound_index <= first_index) // migt be strange waveforms
	{
		extra_count++;
		exit_count++;
		
		if(exit_count > 10) break;

		secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, extra_count, -CWaveformAnalyisisData.pulse_width_polarity);
	}

	if(secound_index < 0) return false;

	double secound_value = CXSignal.CMagnitudeData.CX[secound_index];

	double mid_value = (secound_value + first_value)/2;

	CWaveformAnalyisisData.pulse_width = secound_value - first_value;

	CWaveformAnalyisisData.pulse_width_mid_time = mid_value;

	return true;
}

bool TCOutputWaveformData::GeneratePulsePeriod(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CWaveformAnalyisisData.pulse_period = 0;
	CWaveformAnalyisisData.pulse_time = 0;

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CPulseMeasureSignal);

	if(index < 0) return false;

	TCSignal &CXSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CYSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CYSignal.CMagnitudeData.CX.GetSize())  return false;

	double level = CWaveformAnalyisisData.pulse_mid_level;

	int first_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, CWaveformAnalyisisData.pulse_xing_count, CWaveformAnalyisisData.pulse_width_polarity);

	if(first_index < 0) return false;

	double first_value = CXSignal.CMagnitudeData.CX[first_index];

	int secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, CWaveformAnalyisisData.pulse_xing_count + 1, CWaveformAnalyisisData.pulse_width_polarity);

	if(secound_index < 0) return false;

	int extra_count = CWaveformAnalyisisData.pulse_xing_count + 1;
	int exit_count = 0;

	while(secound_index <= first_index) // migt be strange waveforms
	{
		extra_count++;
		exit_count++;
		
		if(exit_count > 10) break;

		secound_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, extra_count, CWaveformAnalyisisData.pulse_width_polarity);
	}

	if(secound_index < 0) return false;

	double secound_value = CXSignal.CMagnitudeData.CX[secound_index];

	CWaveformAnalyisisData.pulse_period = secound_value - first_value;
	CWaveformAnalyisisData.pulse_time = first_value;

	return true;
}

bool TCOutputWaveformData::GeneratePulseDelay(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CWaveformAnalyisisData.pulse_delay = 0;

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CPulseMeasureSignal);

	if(index < 0) return false;

	TCSignal &CXSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CYSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CYSignal.CMagnitudeData.CX.GetSize())  return false;

	double level = CWaveformAnalyisisData.pulse_mid_level;

	int first_index = CYSignal.CMagnitudeData.GetForwardValuePosition(level, CWaveformAnalyisisData.pulse_xing_count, CWaveformAnalyisisData.pulse_width_polarity);

	if(first_index < 0) return false;

	double first_value = CXSignal.CMagnitudeData.CX[first_index];

	index = CHeader.FindSignal(CWaveformAnalyisisData.CPulseReferanceSignal);

	if(index < 0) return false;

	TCSignal &CYRefSignal	= CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int secound_index = CYRefSignal.CMagnitudeData.GetForwardValuePosition(level, CWaveformAnalyisisData.pulse_ref_xing_count, CWaveformAnalyisisData.pulse_width_polarity);

	if(secound_index < 0) return false;

	double secound_value = CXSignal.CMagnitudeData.CX[secound_index];

	CWaveformAnalyisisData.pulse_delay = first_value - secound_value;

	return true;
}

bool TCOutputWaveformData::GenerateTransientAverages(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CWaveformAnalyisisData.rms_pk_value = 0;
	CWaveformAnalyisisData.rms_av_value = 0;
	CWaveformAnalyisisData.rms_value	= 0;
	CWaveformAnalyisisData.rms_ripple_value	= 0;

	double rms_end = CWaveformAnalyisisData.rms_end * 0.9999;//rounding bug

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; 

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CRMSSignalName);

	if(index < 0) return false;

	TCSignal &CXSignal = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CSignalName = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	CWaveformAnalyisisData.rms_av_value = CSignalName.CMagnitudeData.AVG(CXSignal.CMagnitudeData, CWaveformAnalyisisData.rms_start, rms_end);
	
	int start_index, end_index;
		
	start_index = CXSignal.CMagnitudeData.GetForwardValuePosition(CWaveformAnalyisisData.rms_start);
	
	if(start_index < 0) return false;

	if(start_index) start_index--;

	if(!rms_end) end_index = CXSignal.CMagnitudeData.CX.GetSize();
	else end_index	= CXSignal.CMagnitudeData.GetForwardValuePosition(rms_end);

	if(end_index < 0) return false;

	if(end_index) end_index--;

	double max, min;

	max = CSignalName.CMagnitudeData.GetMaxValue(start_index, end_index);
	min = CSignalName.CMagnitudeData.GetMinValue(start_index, end_index);

	CWaveformAnalyisisData.rms_pk_value = max - min;

	CWaveformAnalyisisData.rms_value = CSignalName.CMagnitudeData.RMS(CXSignal.CMagnitudeData, CWaveformAnalyisisData.rms_start, rms_end);

	CWaveformAnalyisisData.rms_ripple_value = CSignalName.CMagnitudeData.RMS(CXSignal.CMagnitudeData, CWaveformAnalyisisData.rms_start, rms_end, true);

	return true;
}

bool TCOutputWaveformData::GeneratePower(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CWaveformAnalyisisData.power_temperture = 0;
	CWaveformAnalyisisData.power_value		= 0;

	int count = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals.GetSize();

	if(count < 2) return false; 

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	int index = CHeader.FindSignal(CWaveformAnalyisisData.CPowerVoltName);

	if(index < 0) return false;

	TCSignal &CXSignal = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[0];

	TCSignal &CVoltSignal = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	index = CHeader.FindSignal(CWaveformAnalyisisData.CPowerCurrentName);

	if(index < 0) return false;

	TCSignal &CCurrentSignal = CRecords[E_SPICE_RECORD_TRANSIENT].CSignals[index];

	int points_count = CXSignal.CMagnitudeData.CX.GetSize();

	if(points_count != CVoltSignal.CMagnitudeData.CX.GetSize())  return false;

	if(points_count != CCurrentSignal.CMagnitudeData.CX.GetSize())  return false;

	CWaveformAnalyisisData.power_value = CXSignal.CMagnitudeData.Power(CVoltSignal.CMagnitudeData, CCurrentSignal.CMagnitudeData, CWaveformAnalyisisData.power_start, CWaveformAnalyisisData.power_end);

	if(!(CWaveformAnalyisisData.CPowerCurrentName.Find("-") < 0))// current is negative r1[-i]
		CWaveformAnalyisisData.power_value = - CWaveformAnalyisisData.power_value;

	CWaveformAnalyisisData.power_temperture = CWaveformAnalyisisData.power_value * CWaveformAnalyisisData.power_rtheata;

	return true;
}

bool TCOutputWaveformData::GenerateACAnalysisData(void)
{
	// This function overwrites last signal with LG data
	if(!CMWaveformAnalyisisData.plot_ac_analysis) return true;
	if(CMWaveformAnalyisisData.CLoopGainInputNode == "") return false;
	if(CMWaveformAnalyisisData.CLoopGainOutputNode == "") return false;

	int count = CRecords[E_SPICE_RECORD_AC].CSignals.GetSize();

	if(count < 2) return false; //

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_AC].CHeader;

	int input_index = CHeader.FindSignal(CMWaveformAnalyisisData.CLoopGainInputNode);

	if(input_index < 0) input_index = 0;//

	int output_index = CHeader.FindSignal(CMWaveformAnalyisisData.CLoopGainOutputNode);

	if(output_index < 0) output_index = 0;

	if((output_index == count -1) || (input_index == count -1)) return false;

	CString CVoltageSourceCurent = CMWaveformAnalyisisData.CLoopGainSource + "[i]";

	TCSignal &CLoopGainSignal = CRecords[E_SPICE_RECORD_AC].CSignals[count -1];// stuff Loop gain in last data point, this is a power anyway

	TCSignal &CInputSignal	= CRecords[E_SPICE_RECORD_AC].CSignals[input_index];
	TCSignal &COutputSignal	= CRecords[E_SPICE_RECORD_AC].CSignals[output_index];

	switch(CMWaveformAnalyisisData.ac_analysis_type)
	{
		case E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN: CLoopGainSignal.CName = "Loop Gain"; break;
		case E_WAVEFORM_ANALYSIS_IMPEDANCE: CLoopGainSignal.CName = "Impedance"; break;
		case E_WAVEFORM_ANALYSIS_POWER: CLoopGainSignal.CName = "Power";break;
	}

	int points_count = CRecords[E_SPICE_RECORD_AC].CSignals[0].CMagnitudeData.CX.GetSize();

	if(points_count != COutputSignal.CMagnitudeData.CX.GetSize()) return false;
	if(points_count != COutputSignal.CPhaseData.CX.GetSize()) return false;
	if(points_count != CInputSignal.CMagnitudeData.CX.GetSize()) return false;
	if(points_count != CInputSignal.CPhaseData.CX.GetSize()) return false;

	CLoopGainSignal.CPhaseData.CX.SetSize(points_count);

	double data, current_mag, current_phase, delta_vr, delta_vi, delta_vm, delta_vp;
	double output_mag, output_phase, input_mag, input_phase;

	int current_index = CHeader.FindSignal(CVoltageSourceCurent);
	
	if(CMWaveformAnalyisisData.ac_analysis_type != E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN)
	{
		if(current_index < 0) return false;

		TCSignal &CCurrentSignal	= CRecords[E_SPICE_RECORD_AC].CSignals[current_index];

		if(points_count != CCurrentSignal.CMagnitudeData.CX.GetSize()) return false;
		if(points_count != CCurrentSignal.CPhaseData.CX.GetSize()) return false;
	}

	for(int p = 0; p < points_count; p++)
	{
		data = CInputSignal.CMagnitudeData.CX[p];

		if(!data) data = 1e-37;// should not happen

		switch(CMWaveformAnalyisisData.ac_analysis_type)
		{
			case E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN: 
			{
				if(!output_index || !input_index) return false;

				CLoopGainSignal.CMagnitudeData.CX[p] = COutputSignal.CMagnitudeData.CX[p]/data;
				CLoopGainSignal.CPhaseData.CX[p] = COutputSignal.CPhaseData.CX[p] - CInputSignal.CPhaseData.CX[p] - 3.141592654;
			
			} break;

			case E_WAVEFORM_ANALYSIS_IMPEDANCE:  
			{
				TCSignal &CCurrentSignal	= CRecords[E_SPICE_RECORD_AC].CSignals[current_index];

				current_mag = CCurrentSignal.CMagnitudeData.CX[p];
				current_phase = CCurrentSignal.CPhaseData.CX[p];

				if(!current_mag) current_mag = 1e-37;

				if(output_index) {output_mag = COutputSignal.CMagnitudeData.CX[p]; output_phase=COutputSignal.CPhaseData.CX[p];}
				else {output_mag = 0;output_phase=0;}

				if(input_index) {input_mag = CInputSignal.CMagnitudeData.CX[p];input_phase=CInputSignal.CPhaseData.CX[p];}
				else {input_mag = 0;input_phase=0;}

				delta_vr =  input_mag * cos(input_phase) - output_mag * cos(output_phase);

				delta_vi =  input_mag * sin(input_phase) - output_mag * sin(output_phase);

				delta_vm = sqrt(delta_vr*delta_vr + delta_vi*delta_vi);

				delta_vp = atan2(delta_vi, delta_vr);

				CLoopGainSignal.CMagnitudeData.CX[p] = delta_vm/current_mag;
				CLoopGainSignal.CPhaseData.CX[p]	= asin(sin(delta_vp - current_phase - 3.141592954));

			} break;

			case E_WAVEFORM_ANALYSIS_POWER: 
			{
				TCSignal &CCurrentSignal	= CRecords[E_SPICE_RECORD_AC].CSignals[current_index];

				current_mag = CCurrentSignal.CMagnitudeData.CX[p];
				current_phase = CCurrentSignal.CPhaseData.CX[p];

				if(!current_mag && !current_phase) current_mag = 1e-37;

				if(output_index) {output_mag = COutputSignal.CMagnitudeData.CX[p]; output_phase=COutputSignal.CPhaseData.CX[p];}
				else {output_mag = 0;output_phase=0;}

				if(input_index) {input_mag = CInputSignal.CMagnitudeData.CX[p];input_phase=CInputSignal.CPhaseData.CX[p];}
				else {input_mag = 0;input_phase=0;}

				delta_vr =  input_mag * cos(input_phase) - output_mag * cos(output_phase);

				delta_vi =  input_mag * sin(input_phase) - output_mag * sin(output_phase);

				delta_vm = sqrt(delta_vr*delta_vr + delta_vi*delta_vi);

				delta_vp = atan2(delta_vi, delta_vr);

				CLoopGainSignal.CMagnitudeData.CX[p] = delta_vm * current_mag * cos(delta_vp + current_phase - 3.141592954);
				CLoopGainSignal.CPhaseData.CX[p]	= delta_vm * current_mag * sin(delta_vp + current_phase - 3.141592954);

			}break;
		}
	}

	switch(CMWaveformAnalyisisData.ac_analysis_type)
	{
		case E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN:
			
			GenerateGainAndPhaseMargin(CLoopGainSignal.CName, CMWaveformAnalyisisData);

			CLoopGainSignal.magnitude	= 1;// plot mag in dbs
			CLoopGainSignal.phase		= 0;// plot in degrees
			break;


			case E_WAVEFORM_ANALYSIS_IMPEDANCE: 

			CLoopGainSignal.magnitude	= 0;// plot mag in real
			CLoopGainSignal.phase		= 0;// plot in degrees
			break;

			case E_WAVEFORM_ANALYSIS_POWER: 

			CLoopGainSignal.magnitude	= 0;// plot mag in real
			CLoopGainSignal.phase		= 0;// plot in degrees
			break;
	}

	return true;
}

bool TCOutputWaveformData::GenerateGainAndPhaseMargin(CString CSignalName, TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	double &gain_margin = CWaveformAnalyisisData.gain_margin;
	double &phase_margin = CWaveformAnalyisisData.phase_margin;
	double &phase_zero = CWaveformAnalyisisData.phase_zero;
	double &unity_gain_frequency = CWaveformAnalyisisData.unity_gain_frequency;
	double &zero_phase_frequency = CWaveformAnalyisisData.zero_phase_frequency;
	double &low_frequency_gain = CWaveformAnalyisisData.low_frequency_gain;

	gain_margin		= -100;
	phase_margin	= -1000;
	unity_gain_frequency = 0;
	zero_phase_frequency = 0;

	TCOutputWaveformDataHeader &CHeader = CRecords[E_SPICE_RECORD_AC].CHeader;

	int index = CHeader.FindSignal(CSignalName);

	if(index < 0) return false;

	TCSignal &CLoopGainSignal = CRecords[E_SPICE_RECORD_AC].CSignals[index];
	TCSignal &CFrequency = CRecords[E_SPICE_RECORD_AC].CSignals[0];

	int points_count = CLoopGainSignal.CMagnitudeData.CX.GetSize();

	if(points_count < 2) return false;

//  Modified 7th November 2004, usualy the first phase zero is the one we want. Spurious later ones can confuse the issue.
//	int magnitude_index = CLoopGainSignal.CPhaseData.GetReverseValuePosition(phase_zero/57.29577951);

	int magnitude_index = CLoopGainSignal.CPhaseData.GetForwardValuePosition(phase_zero/57.29577951, -1, -1);

	if(magnitude_index < 0) gain_margin = 1e5; // 100db indicates no phase found
	else 
	{
		gain_margin = CLoopGainSignal.CMagnitudeData.CX[magnitude_index];
		zero_phase_frequency = CFrequency.CMagnitudeData.CX[magnitude_index];
	}

	low_frequency_gain = CLoopGainSignal.CMagnitudeData.CX[0];
	
	low_frequency_gain = 20*Log(low_frequency_gain);

	gain_margin = -20*Log(gain_margin);// convention to negative the gain

	int phase_index = CLoopGainSignal.CMagnitudeData.GetReverseValuePosition(1.0);//find unity gain

	if(phase_index < 0) return true; //

	phase_margin = 57.29577951 * CLoopGainSignal.CPhaseData.CX[phase_index];//convention to negative the phase

	phase_margin = phase_margin - phase_zero;

	unity_gain_frequency = CFrequency.CMagnitudeData.CX[phase_index];

	return true;
}

void TCOutputWaveformData::LinearizeTransientData()
{
	TCOutputWaveformDataRecord &CRecord = CRecords[E_SPICE_RECORD_TRANSIENT];

	int signal_count = CRecord.CSignals.GetSize();

	if(!signal_count) return;

	TCOutputWaveformDataRecord CRecordCopy;
	
	CRecordCopy = CRecord;

	int points_count = CRecord.CSignals[0].CMagnitudeData.CX.GetSize();

	if(points_count < 2) return;

	double time_step = CRecord.CSignals[0].CMagnitudeData.CX[points_count - 1] - CRecord.CSignals[0].CMagnitudeData.CX[0];

	if(!time_step) return;

	int fft_count = 1;
	// Now convert to power of 2 for FAST FFT by getting largest 2^n less than orginal data size
	while(fft_count < points_count)
	{
		fft_count = 2 * fft_count;
	}

	points_count = fft_count/2;

	points_count = fft_count;

	time_step /= (points_count - 1);

	double next_time = CRecord.CSignals[0].CMagnitudeData.CX[0];
	double first_time = next_time;

	int p;

	CRecord.CSignals[0].CMagnitudeData.CX.SetSize(points_count);// Added 23rd April 2016 for pow 2 FFT

	for(p = 0; p < points_count; p++) //make time axis in equal steps.
	{
		CRecord.CSignals[0].CMagnitudeData.CX[p] = next_time;

		next_time += time_step;
	}

	CArray <double, double&> &CSignalOrigX = CRecordCopy.CSignals[0].CMagnitudeData.CX; ///original time data

	int q = 0, signal_points_count;
	int next_time_position;

	for(p = 1; p < signal_count; p++)
	{
		CArray <double, double&>  &CSignalOrigY =  CRecordCopy.CSignals[p].CMagnitudeData.CX;//org signal data

		CArray <double, double&>  &CSignalY = CRecord.CSignals[p].CMagnitudeData.CX;//new signal data

		CSignalY.SetSize(points_count);// Added 23rd April 2016 for pow 2 FFT

		signal_points_count = CSignalOrigY.GetSize();

		if(!signal_points_count) return;

//		if(!(signal_points_count <= points_count)) return; // Removed 23rd April 2016 for pow 2 FFT

		next_time_position = 0;
		next_time = first_time;

		for(q = 0; q < points_count/*signal_points_count*/; q++)
		{
			CSignalY[q] = GetNextLinearYValue(signal_points_count, next_time_position, next_time, CSignalOrigY, CSignalOrigX);

			next_time += time_step;
		}
	}
}

double TCOutputWaveformData::GetNextLinearYValue(int signal_points_count, int &next_time_position, double next_time, CArray <double, double&>  &CSignalOrigSrc, CArray <double, double&> &CSignalOrigX)
{
	double data = 0.0;
	double last_y = 0, next_y;
	double last_x = 0, next_x;
	double dx, dxt;

	if(next_time_position < signal_points_count) 
	{
		last_y = CSignalOrigSrc[next_time_position];
		last_x = CSignalOrigX[next_time_position];
	}
	
	while(next_time_position < signal_points_count)
	{
		next_y = CSignalOrigSrc[next_time_position];

		next_x = CSignalOrigX[next_time_position];

		if(next_x < next_time)// see if t for new data is same as steped t.
		{
			last_y = next_y;
			last_x = next_x;

			next_time_position++;

			continue;
		}

		dxt = next_time - last_x;

		if(!dxt) return next_y;// 

		dx = next_x -  last_x;
		
		if(!dx) return next_y;// should not happen, time data is always monotonically increasing

		data = dxt*(next_y - last_y)/dx + last_y;

		if(next_time_position) next_time_position--;// 24th Aprill start from one back on next search

		return data;

	};

	return CSignalOrigSrc[signal_points_count - 1];// always return last data point at end
}
////////////////////////////////////


TCWaveformDataRuns::TCWaveformDataRuns(void)
{
	PCDoc				= NULL;
	m_last_runs_count	= 1;

	CMathFunctionDataList.SetSize(4);// magic number
}

TCWaveformDataRuns::TCWaveformDataRuns(TCWaveformDataRuns &CWaveformDataRuns)
{
	*this = CWaveformDataRuns;
}

TCWaveformDataRuns::~TCWaveformDataRuns(void)
{
	Delete();
}

void TCWaveformDataRuns::Delete(void)
{
	int count = CRuns.GetSize();

	for(int p = 0; p < count; p++) if(CRuns[p]) delete [] CRuns[p];

	CRuns.SetSize(0);
}

int TCWaveformDataRuns::Add(void)
{
	TCOutputWaveformData *PCOutputWaveformData;

	PCOutputWaveformData = new TCOutputWaveformData;

	if(!PCOutputWaveformData) return -1;

	CRuns.Add(PCOutputWaveformData);

	return CRuns.GetSize() - 1;
}

void TCWaveformDataRuns::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

//	CMathFunctionDataList.Serialize(CArchiveFile);// to add later

	int count, p;
	int this_index;

	CString CFileName;

	if(CArchiveFile.IsStoring())
	{
		count = CRuns.GetSize();

		CArchiveFile << CRunDiscription;

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CArchiveFile << CRuns[p]->CFileName;
		}

		count = CMathFunctionDataList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CMathFunctionDataList[p].Serialize(CArchiveFile);;
		}
	}
	else
	{
		CArchiveFile >> CRunDiscription;
		CArchiveFile >> count;

		Delete();

		for(p = 0; p < count; p++)
		{
			this_index = Add();

			if(this_index != p || !CRuns[p])
			{
				AfxMessageBox(IDS_ERR_NO_MEMORY);

				return;
			}

			CArchiveFile >> CFileName;

			CRuns[p]->CFileName = CFileName;// may not be needed

			CRuns[p]->Load(CFileName, this, PCDoc, CMWaveformAnalyisisData);

			CArchiveFile >> count;

			CMathFunctionDataList.SetSize(count);

			for(p = 0; p < count; p++) 
			{
				CMathFunctionDataList[p].Serialize(CArchiveFile);;
			}
		}
	}
}

void TCWaveformDataRuns::DisplayError(CString CDescription, CString CErrorMsg, int error_code)
{
	if(!PCDoc) return;

	PCDoc->DisplayError(CDescription, CErrorMsg, error_code);
}
///////
int TCWaveformDataRuns::LoadStart(int number_of_runs, TCSuperSpiceDoc *PCParentDoc)
{
	if(!PCParentDoc) return -1;

	PCDoc = PCParentDoc;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!number_of_runs) return -1;

	int count = CRuns.GetSize();
	int f_default_display = 0;

	if(number_of_runs > m_last_runs_count) f_default_display = true;
	else f_default_display = 0;

	SetSize(number_of_runs);

	count = CRuns.GetSize();

	if(!count) return -1;

	m_last_runs_count = number_of_runs;

	return f_default_display;
}

bool TCWaveformDataRuns::Load(CString CBaseName, int number_of_runs, TCSuperSpiceDoc *PCParentDoc, TCWaveformAnalyisisData *PCWaveformAnalyisisData, int mode)
{
	int value = LoadStart(number_of_runs, PCParentDoc);

	if(value < 0) return false;
	
	if(PCWaveformAnalyisisData)	CMWaveformAnalyisisData = *PCWaveformAnalyisisData;

	bool flag = true;
	int default_size;

	CString CFileName;
	CString CText;

	int count = CRuns.GetSize();
	
	if(!mode)// normal load of first data run. This is to avoid loading in first for WC/MC runs
	{
		TCIFStream CFileStream;

		if(CBaseName != "")// SuperSpice Schematic based data file
		{	
			default_size = CRuns[0]->OpenFile(CFileStream, CBaseName, PCParentDoc, this, 0);

			if(default_size)
				if(!CRuns[0]->Load(CFileStream, CBaseName, CMWaveformAnalyisisData, default_size)) flag = false;// main one, 

			CFileStream.close();
		}
		else // generic load of external spice data
		{
			CFileName = CRuns[0]->CRunDiscription;// description has directory for first

			if(!CRuns[0]->Load(CFileName, this, PCDoc, CMWaveformAnalyisisData)) flag = false;// main one, 
		}
	}

	CString CNewName;// each run has number appended

	CBaseName = RemoveExtention(CBaseName);

	int start = 1;

	if(mode) start = 0;// mode is one 

	for(int p = start; p < count; p++)
	{
		TCIFStream* PCFileStream = new TCIFStream;

		if(!PCFileStream) return false;

		if(CBaseName != "")
		{
			CNewName.Format("%s%d.out", CBaseName, p + mode);

			default_size =  CRuns[p]->OpenFile(*PCFileStream, CNewName, PCParentDoc, this, p);

			if(default_size)
				if(CRuns[p]) if(!CRuns[p]->Load(*PCFileStream, CNewName, CMWaveformAnalyisisData, default_size)) flag = false;
				
			// CFileStream.close();

			//	if(CFileStream.fail())

		}
		else  // generic load of external spice data
		{
			if(CRuns[p])CFileName = CRuns[p]->CRunDiscription;// description has directory for first
			
			if(CRuns[p]) if(!CRuns[p]->Load(CFileName, this, PCDoc, CMWaveformAnalyisisData)) flag = false;
		}

		delete PCFileStream;
	}

	if(!flag) return flag;

	if(PCWaveformAnalyisisData) *PCWaveformAnalyisisData = CMWaveformAnalyisisData;

	value = LoadEnd(value);

	if(PCParentDoc)
	{
		if(PCParentDoc->CMSuperSpiceDocData.PCAnalysisSetup)
		{
			if(PCParentDoc->CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.tran_nodeset)
				SaveTranNodeSet(CBaseName); 

			TCParametricSetupData &CParametricSetupData = PCParentDoc->CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;
			/// testing, not  yet valid Aug 2016
			if(CParametricSetupData.multi_run_enable)
			{
				CreateMultiPlots(PCParentDoc);
			}
		}
	}

	return !!value;
}

bool TCWaveformDataRuns::CreateMultiPlots(TCSuperSpiceDoc *PCParentDoc)
{
	if(!PCParentDoc) return false;
	if(!PCParentDoc->CMSuperSpiceDocData.PCAnalysisSetup) return false;

	TCParametricSetupData &CParametricSetupData = PCParentDoc->CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;
	
	TCSweepData &CSweepData = CParametricSetupData.CSweepData;

	CString CSignalName = CParametricSetupData.CMultiRunSignal;

	double param_x = MKSStringToFloat(CParametricSetupData.CMultiRunACParam);

	double swept_value;
	int num_signals, p, q, phase_points, num_points;

	int count = CRuns.GetSize();

	for(p = 0; p < count; p++)
	{
		for(int q = 0; q < E_SPICE_RECORD_NULL; q++)
		{
			if(!CRuns[0]->IsWaveformHeaderAvailable(q)) continue;

			if(q == E_SPICE_RECORD_DC) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunDCParam);
			else if(q == E_SPICE_RECORD_AC) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunACParam);
			else if(q == E_SPICE_RECORD_NOISE_SPECTRAL) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunNoiseParam);
			else if(q == E_SPICE_RECORD_TRANSIENT) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunTranParam);
			else if(q == E_SPICE_RECORD_THD) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunTHDParam);
			else if(q == E_SPICE_RECORD_IMD) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunTHDParam);
			else if(q == E_SPICE_RECORD_DISTORTION_IMD_2F) param_x = MKSStringToFloat(CParametricSetupData.CMultiRunTHDParam);
			else continue;

			CRuns[p]->CreateMultiPlots(q, CSignalName, param_x);
		}
	}

	for(q = 0; q < E_SPICE_RECORD_NULL; q++)// Setup new x and y signals
	{
		if(!CRuns[0]->IsWaveformHeaderAvailable(q)) continue;

		if(q == E_SPICE_RECORD_TIME_TO_FREQ_FFT) continue;
		if(q == E_SPICE_RECORD_FREQ_TO_TIME_FFT) continue;
		if(q == E_SPICE_RECORD_OPERATING_POINT) continue;
		if(q == E_SPICE_RECORD_MATH_0) continue;
		if(q == E_SPICE_RECORD_FOURIER) continue;
		if(q == E_SPICE_RECORD_SENSITIVITY) continue;
		if(q == E_SPICE_RECORD_TIME_TO_FREQ_FFT) continue;
		if(q == E_SPICE_RECORD_FREQ_TO_TIME_FFT) continue;
		if(q == E_SPICE_RECORD_NOISE_INTEGRATED) continue;

		TCOutputWaveformDataRecord &CRecord = CRuns[0]->CRecords[q];

		CRecord.CHeader.CDisplayedSignalsList.SetSize(0); // Clear any bad pointer data from old lists

		num_signals = CRecord.CSignals.GetSize();

		if(!num_signals) continue;

		num_signals = num_signals + 2;

		CRecord.CHeader.active_magnitude_axis_index = num_signals - 2;

		CRecord.CSignals.SetSize(num_signals); 

		TCSignal &CSignalY = CRecord.CSignals[num_signals - 1];	// New End of array, Y data
		TCSignal &CSignalX = CRecord.CSignals[num_signals - 2];	// New End but one of array, X Data

		CSignalX = CRecord.CSignals[1]; // Copy over to initialise
		CSignalY = CRecord.CSignals[1]; // Copy over to initialise

		CSignalX.CMagnitudeData.CX.SetSize(count - 1); // Dublicate first run
		CSignalY.CMagnitudeData.CX.SetSize(count - 1); 

		num_points = CSignalY.CPhaseData.CX.GetSize();

		if(num_points)
		{
			CSignalY.CPhaseData.CX.SetSize(count - 1);
		}
		else
		{
			CSignalY.CPhaseData.CX.SetSize(0);
		}  

		CSignalX.CMagnitudeData.Zero();
		CSignalX.CPhaseData.Zero();
		CSignalX.CName = CParametricSetupData.CSource + "_ParamX";

		CSignalY.CMagnitudeData.Zero();
		CSignalY.CPhaseData.Zero();
		CSignalY.CName = CSignalName + "_ValueY";	
	}

	for(q = 0; q < E_SPICE_RECORD_NULL; q++)
	{
		if(!CRuns[0]->IsWaveformHeaderAvailable(q)) continue;
		
		if(q == E_SPICE_RECORD_TIME_TO_FREQ_FFT) continue;
		if(q == E_SPICE_RECORD_FREQ_TO_TIME_FFT) continue;
		if(q == E_SPICE_RECORD_OPERATING_POINT) continue;
		if(q == E_SPICE_RECORD_MATH_0) continue;
		if(q == E_SPICE_RECORD_FOURIER) continue;
		if(q == E_SPICE_RECORD_SENSITIVITY) continue;
		if(q == E_SPICE_RECORD_TIME_TO_FREQ_FFT) continue;
		if(q == E_SPICE_RECORD_FREQ_TO_TIME_FFT) continue;
		if(q == E_SPICE_RECORD_NOISE_INTEGRATED) continue;

		CSweepData.GetFirstValue(swept_value);

		for(p = 1; p < count; p++) // over runs, 1st run is is duplicated data run.
		{
			TCOutputWaveformDataRecord &CRecordXY = CRuns[0]->CRecords[q];
			TCOutputWaveformDataRecord &CRecordY = CRuns[p]->CRecords[q];

			num_signals = CRecordXY.CSignals.GetSize();

			if(num_signals < 3) 
			{
				ASSERT(0);

				break;
			}

			TCSignal &CSignalY = CRecordXY.CSignals[num_signals - 1];	
			TCSignal &CSignalX = CRecordXY.CSignals[num_signals - 2];	

			num_points = CSignalX.CMagnitudeData.CX.GetSize();

			if(num_points != count - 1) 
			{
				ASSERT(0);

				break;
			}

			num_points = CSignalY.CMagnitudeData.CX.GetSize();

			if(num_points != count - 1) 
			{
				ASSERT(0);

				break;
			}

			CSignalY.CMagnitudeData.CX[p - 1] = CRecordY.m_y_mag_reruns;
			CSignalY.magnitude = 0; //default

			CSignalX.CMagnitudeData.CX[p - 1] = swept_value;

			CSweepData.GetNextValue(swept_value);

			CRecordXY.CHeader.CDisplayedSignalsList.SetSize(1);

			TCDisplayedSignals &CDisplayedSignal = CRecordXY.CHeader.CDisplayedSignalsList[0];

			CDisplayedSignal.PCSignal1 = &CSignalY;
			CDisplayedSignal.PCSignalX = &CSignalX;
			CDisplayedSignal.magnitude = CSignalY.magnitude;
			CDisplayedSignal.phase	   = -1;
			CDisplayedSignal.index1    = num_signals - 1;
			
			// For ease of understanding, and updating later
			if(CDisplayedSignal.magnitude == 0) CDisplayedSignal.type = TE_SIGNAL_DISPLAY_MAGNITUDE;
			else CDisplayedSignal.type = TE_SIGNAL_DISPLAY_DB_MAGNITUDE;

			phase_points = CSignalY.CPhaseData.CX.GetSize();

			if(!phase_points) continue;

			if(phase_points != count - 1) 
			{
				ASSERT(0);

				break;
			}

			CSignalY.CPhaseData.CX[p - 1] = CRecordY.m_y_phase_reruns;	
			CSignalY.phase = 0;
			CDisplayedSignal.phase = TE_SIGNAL_DISPLAY_PHASE_DEG;// Fuck radians. Never used
		}
	}

//	RealignHeaderSignalPointers();

	return true;
}

void TCWaveformDataRuns::RealignHeaderSignalPointers(void)
{
	int p, q;
	int record_count;

	int run_count = CRuns.GetSize();

	for(p = 0; p < run_count; p++)
	{
		TCOutputWaveformData &COutputWaveformData = *CRuns[p];

		record_count = COutputWaveformData.CRecords.GetSize();

		for(q = 0; q < record_count; q++)
		{
			TCOutputWaveformDataRecord &CRecord = COutputWaveformData.CRecords[q];

			if(CRecord.CHeader.PCSignals != &CRecord.CSignals)
			{
				ASSERT(0);

				CRecord.CHeader.PCSignals = &CRecord.CSignals;
			}
		}
	}
}

int TCWaveformDataRuns::CalculateFFTOnLoad(void)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = PCDoc;

	if(!PCSuperSpiceDoc) return false;

	if(!PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup) return false;

	if(!(E_TRAN_CALCULATE_FFT_ON_LOAD < PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray.GetSize())) return false;

	int flag = PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_FFT_ON_LOAD];

//	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.calculate_fft_on_load)

	return flag;
}

int TCWaveformDataRuns::LoadEnd(int default_display)
{
	if(default_display) SetDefaultDisplayedSignals();

	if(!SetAllMaxMin()) return false;

	if(CalculateFFTOnLoad()) ComputeFFTs();

	return true;
}

bool TCWaveformDataRuns::SetDefaultDisplayedSignals(void)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	if(!CRuns[0]) return false;

	int record_count, signal_count, signal_zero_count, index;

	for(int p = 1; p < count; p++)
	{
		if(!CRuns[p]) return false;

		record_count = CRuns[p]->CRecords.GetSize();

		for(int q = 0; q < record_count; q++)
		{
			index = q;

			CArray <TCSignal, TCSignal &> &CSignals = *CRuns[p]->CRecords[q].CHeader.PCSignals;

			if(!CRuns[0]->AreAnySignalsEnabled(q)) index = CRuns[0]->GetFirstEnabledSignalsType();	
			
			CArray <TCSignal, TCSignal &> &CSignalsZero = *CRuns[0]->CRecords[q].CHeader.PCSignals;

			if(!&CSignals) 
			{
				ASSERT(0);
				return false;
			}
			if(!&CSignalsZero) 
			{
				ASSERT(0);
				return false;
			}

			if((index == E_SPICE_RECORD_NULL) && index != q) CRuns[0]->CopySignalEnables(q, index);

			signal_count = CSignals.GetSize();

			signal_zero_count = CSignalsZero.GetSize();

			if(signal_count != signal_zero_count) continue;

			for(int r = 0; r < signal_zero_count; r++)
			{
				CSignals[r].magnitude	= CSignalsZero[r].magnitude;
				CSignals[r].phase		= CSignalsZero[r].phase;
			}
		}
	}

	return true;
}

void TCWaveformDataRuns::CreateListsOfDisplayedSignals(TCOutputWaveformDataHeader *PCHeader)
{
	if(!PCHeader) return;

	int run_count = CRuns.GetSize();

	if(!run_count) return;

	int record_count;

	PCHeader->CreateListOfDisplayedSignals();

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		if(!(PCHeader->type < record_count)) return;

		CRuns[p]->CRecords[PCHeader->type].CHeader.CreateListOfDisplayedSignals();
	}
}

void TCWaveformDataRuns::CreateAllListsOfDisplayedSignals(void)
{
	int run_count = CRuns.GetSize();

	if(!run_count) return;

	int q, recourd_count;

	for(int p = 0; p < run_count; p++)
	{
		recourd_count = CRuns[p]->CRecords.GetSize();

		for(q = 0; q < recourd_count; q++)
		{
			TCOutputWaveformDataHeader &CHeader = CRuns[p]->CRecords[q].CHeader;

			if(!CHeader.IsAnyMagnitudesDisplayed())
				if(!CHeader.IsAnyPhaseDisplayed()) continue;

			CHeader.CreateListOfDisplayedSignals();
		}
	}
}

bool TCWaveformDataRuns::SetAllMaxMin(void)
{
// force main min max to be calculated for all runs
	TCOutputWaveformDataHeader *PCHeaderMax = NULL;
	TCOutputWaveformDataHeader *PCHeaderMin = NULL;

	int count = CRuns.GetSize();

	if(!count) return false;

	count = CRuns[0]->CRecords.GetSize();

	double dmax = 0.0, dmin = 0.0;
	int count2 = CRuns.GetSize();

	CreateAllListsOfDisplayedSignals();

	int q;

	for(int p = 0; p < count; p++)// for each record type
	{
		PCHeaderMax = &CRuns[0]->CRecords[p].CHeader;
		PCHeaderMin = &CRuns[0]->CRecords[p].CHeader;

		GetMagnitudeMaxMin(&PCHeaderMax, &PCHeaderMin, p, dmax, dmin);

		for(q = 0; q < count2; q++)
		{
			CRuns[q]->CRecords[p].CHeader.signal_mag_max	= dmax;
			CRuns[q]->CRecords[p].CHeader.signal_mag_min	= dmin;
		}

		GetPhaseMaxMin(&PCHeaderMax, &PCHeaderMin, p, dmax, dmin);

		for(q = 0; q < count2; q++)
		{
			CRuns[q]->CRecords[p].CHeader.signal_phase_max	= dmax;
			CRuns[q]->CRecords[p].CHeader.signal_phase_min	= dmin;
		}
	}

	return true;
}

bool TCWaveformDataRuns::Save(CString CBaseName, int mode)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	bool flag = true;

	if(!mode)
	if(!CRuns[0]->Save(CBaseName)) flag = false;// main one, 

	CString CNewName;// each run has number appended

	CBaseName = RemoveExtention(CBaseName);

	int start = 1;

	if(mode) start = 0;// mode is one // to eliminate loading and saving firts run in WC.

	for(int p = start; p < count; p++)	
	{
		CNewName.Format("%s%d.out", CBaseName, p + mode);

		if(CRuns[p]) if(!CRuns[p]->Save(CNewName)) flag = false;
	}

	return flag;
}

bool TCWaveformDataRuns::Load(TCSuperSpiceDoc *PCParentDoc)
{
	PCDoc = PCParentDoc;

	PCDoc = PCDoc->GetTopLevelDoc();

	int count = CRuns.GetSize();

	bool flag = true;

	for(int p = 0; p < count; p++)
	{
		if(CRuns[p]) if(!CRuns[p]->Load(CRuns[p]->CFileName, this, PCDoc, CMWaveformAnalyisisData)) flag = false;
	}

	return flag;
}

bool TCWaveformDataRuns::Save(void)
{
	int count = CRuns.GetSize();

	bool flag = true;

	for(int p = 0; p < count; p++)
	{
		if(CRuns[p]) if(!CRuns[p]->Save(CRuns[p]->CFileName)) flag = false;
	}

	return 	flag;
}

int TCWaveformDataRuns::SetSize(int size, int alloc_size)
{
	int test= CRuns.GetSize();
	int count;

	if(test >= size)
	{
		for(int p = size; p < test; p++)
		{
			if(CRuns[p]) delete CRuns[p];
		}

		CRuns.SetSize(size, alloc_size);

		return size;
	}

	CRuns.SetSize(size, alloc_size);

	count = CRuns.GetSize();

	for(int p = test; p < count; p++)
	{
		CRuns[p] = new TCOutputWaveformData;

		if(!CRuns[p]) 
		{
			CRuns.SetSize(test);

			return test;
		}
	}

	return count;
}

void TCWaveformDataRuns::CopyAllRunHeaders(TCWaveformDataRuns &CWaveformDataRuns, int type)
{
	int count = CRuns.GetSize();

	if(CWaveformDataRuns.CRuns.GetSize() != count)
	{
		ASSERT(0);
		return;
	}

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return;

		CRuns[p]->CRecords[type].CHeader = CWaveformDataRuns.CRuns[p]->CRecords[type].CHeader;
	}
}

void TCWaveformDataRuns::CopySignalEnables(int destination, int source)
{
	int count = CRuns.GetSize();

	if(CRuns.GetSize() != count) return;

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return;

		CRuns[p]->CopySignalEnables(destination,  source);
	}
}

int TCWaveformDataRuns::GetFirstEnabledSignalsType(int &run_index)
{
	run_index = 0;

	int count = CRuns.GetSize();

	if(CRuns.GetSize() != count) return E_SPICE_RECORD_NULL;

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return E_SPICE_RECORD_NULL;

		run_index = p;

		if(CRuns[p]->GetFirstEnabledSignalsType() != E_SPICE_RECORD_NULL) continue;

		return p;
	}

	return E_SPICE_RECORD_NULL;
}

void TCWaveformDataRuns::Load(TCWaveformDataRuns &CWaveformDataRunsSource)
{
	int count = CWaveformDataRunsSource.CRuns.GetSize();

	if(!count) return;

//	CRuns.SetSize(count);
	SetSize(count);

	int count2;

	for(int p = 0; p < count; p++)
	{
		count2 = CWaveformDataRunsSource.CRuns[p]->CRecords.GetSize();

		if(!CWaveformDataRunsSource.CRuns[p]) 
		{
			ASSERT(0);

			return;
		}

		if(!CRuns[p]) 
		{
			ASSERT(0);

			return;
		}

		CRuns[p]->CRecords.SetSize(count2);

		// might tidy up with the = operator
		CRuns[p]->CRunDiscription = CWaveformDataRunsSource.CRuns[p]->CRunDiscription;

		for(int q = 0; q < count2; q++)
		{
			CRuns[p]->CRecords[q].CHeader = CWaveformDataRunsSource.CRuns[p]->CRecords[q].CHeader;
		
//			CRuns[p]->CRecords[q].CHeader.PCSignals = &CWaveformDataRunsSource.CRuns[p]->CRecords[q].CSignals;
		}
	}
}

void TCWaveformDataRuns::DeleteOldFiles(int old_number_of_runs)
{
old_number_of_runs;
}

TCOutputWaveformDataHeader *TCWaveformDataRuns::GetHeader(TCOutputWaveformDataHeader *PCHeader, int run_index)
{
	if(!PCHeader)		return NULL;
	if(!(run_index < CRuns.GetSize())) return NULL;
	if(run_index < 0)	return NULL;
	if(!CRuns[0])		return NULL;

	int index = CRuns[0]->GetWaveFormHeaderIndex(PCHeader->type);// always exists

	if(index < 0) return NULL;

	if(!(index < CRuns[run_index]->CRecords.GetSize())) return NULL;

	return &CRuns[run_index]->CRecords[index].CHeader;
}
CString	TCOutputWaveformDataHeader::GetDataTextXValue(long position)
{
	// This function is only used for the axis labels
	CString CText = "(NULL)";

	if(position < 0) return CText;

	if(!PCWaveformDataRuns) return CText;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count)		return CText;
	if(!PCWaveformDataRuns->CRuns[0])	return CText;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(type);//ac, dc, tran type etc.

	if(index < 0) return CText;

	TCOutputWaveformDataHeader *PCHeader;

	PCHeader = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;
	
	if(!(axis_index <CSignals.GetSize()))
	{

		return CText;
	}

	TCSignal &CXSignal = CSignals[axis_index];

	double xdata;

	int xtype = 0;

	if(!CXSignal.phase_axis)
	{
		xtype = TE_SIGNAL_DISPLAY_MAGNITUDE;
	}
	else
	{
		xtype = TE_SIGNAL_DISPLAY_PHASE_DEG;
	}

	if(!PCHeader->x_grid_decades)
		xdata = CXSignal.GetDataValue(position, xtype, 1, 0);
	else
		xdata = CXSignal.GetAntiLogDataValue(position, xtype, 1, 0);

	int n;
	
	if(!x_grid_decades)
	{
		n = (int)((xdata - x_min)/x_mag_div + .5);
		xdata = n * x_mag_div;
		xdata += x_min;
	}			
	else 
	{
		n = (int) (Log(xdata/x_min) + .5);
		xdata = (double)AntiLog((double)n)  * x_min; 
	}

	double ddata;

	ddata = (double) xdata;

	CText = FloatToMKSString(ddata);

	return CText;
}


void TCOutputWaveformDataHeader::AllWaveformZoom(CRect CZoomRect)
{
	if(!PCWaveformDataRuns) return;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count) return;

	if(!PCWaveformDataRuns->CRuns[0]) return;

	for(int p = 0; p < count; p++)
	{
		if(!(type < PCWaveformDataRuns->CRuns[p]->CRecords.GetSize())) return;

		TCOutputWaveformDataHeader &CHeader = PCWaveformDataRuns->CRuns[p]->CRecords[type].CHeader;

		CHeader.WaveformZoom(CZoomRect);
	}
}

void TCOutputWaveformDataHeader::WaveformZoom(CRect CZoomRect)
{
	x_manual = true;
	y_manual = true;
	y_phase_manual = true;
	CZoomRectangle = CZoomRect;

//	position = ;

	// need to add all runs copies, may be already done?
	// get phase limits from y limits 

	y_max = GetDataYValue(CZoomRect.top, false);
	y_min = GetDataYValue(CZoomRect.bottom, false);

	if(!y_major_grid_number) y_major_grid_number  = 1;

	if(y_grid_decades)
		y_major_grid_number = QuantiseLogScale(y_max, y_min);
	else
		QuantiseScale(y_max, y_min, y_major_grid_number, !y_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);

	if(y_grid_decades) y_mag_div = 10;// more to do
	else y_mag_div = (y_max - y_min) / y_major_grid_number;

	if(y_mag_div < 0) y_mag_div = -y_mag_div;

	x_max = GetDataXValue(CZoomRect.right);
	x_min = GetDataXValue(CZoomRect.left);

	if(!x_major_grid_number) x_major_grid_number = 1;

	if(x_grid_decades)
		x_major_grid_number = QuantiseLogScale(x_max, x_min);
	else
		QuantiseScale(x_max, x_min, x_major_grid_number, !y_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);

	double diff;

	diff = (x_max - x_min);// x_mag_div not used for decades, may update later

	if(diff) x_mag_div = (x_max - x_min) / x_major_grid_number;
	else x_mag_div = 1.0;

	if(x_grid_decades) x_mag_div = 10;

	if(x_mag_div < 0) x_mag_div = -x_mag_div;

	if(!PCSignals) return;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return; 
	}

	if(!(active_magnitude_axis_index < PCSignals->GetSize())) return;

	if(active_magnitude_axis_index < 0) return;

	if(!(axis_index < PCSignals->GetSize())) return;

	if(axis_index < 0) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	TCSignal &CSignalY = CSignals[active_magnitude_axis_index];

	if(IsBadCodePtr((FARPROC)&CSignals))
	{
		return; 
	}


	int index;
	int type;

	if(CSignalY.phase == 0)	type = TE_SIGNAL_DISPLAY_PHASE_DEG;
	else					type = TE_SIGNAL_DISPLAY_PHASE_RADIANS;

	// Get index corresponding to the magnitude selected region
	// and then get that phase region to make phase track the magnitude xaxis

	index = FindXIndex(x_max);

	if(index < 0) return;

	if(!(index < CSignalY.CPhaseData.CX.GetSize())) return;

	y_phase_max = CSignalY.GetDataValue(index, type);

	if(y_grid_decades)	y_phase_max = (double)Log((double)y_phase_max);				

	index = FindXIndex(x_min);

	if(index < 0) return;

	if(!(index < CSignalY.CPhaseData.CX.GetSize())) return;

	y_phase_min = CSignalY.GetDataValue(index, type);

	if(y_grid_decades)	y_phase_min = (double)Log((double)y_phase_min);				

	if(!y_phase_major_grid_number) y_phase_major_grid_number = 1;

	QuantisePhaseScale(y_phase_max, y_phase_min, y_phase_major_grid_number, !y_phase_manual || !!GCSuperSpiceGlobalData.CWaveformData.enable_quantisation);

	y_phase_div = (y_phase_max - y_phase_min) / y_phase_major_grid_number;

	if(y_phase_div < 0) y_phase_div = -y_phase_div; 
}

int TCOutputWaveformDataHeader::FindXIndex(double value)
{
	if(!PCSignals) return -1;

	if(IsBadCodePtr((FARPROC)PCSignals))
	{
		ASSERT(0);

		return -1; 
	}

	if(!(axis_index < PCSignals->GetSize())) return -1;

	if(axis_index < 0) return -1;

	CArray <TCSignal, TCSignal &> &CSignals = *PCSignals;

	if(!(axis_index < CSignals.GetSize())) return -1;

	TCSignal &CSignalX = CSignals[axis_index];

	if(IsBadCodePtr((FARPROC)&CSignals))
	{
		return -1; 
	}


	int index;
	int type = CSignalX.GetXAxisType();// weather x axis is mag or phase
	double resolution =0.0;

	if(!CSignalX.points_per_float) return -1;

	int size =	CSignalX.max_points - CSignalX.min_points;

	if(type != TE_SIGNAL_DISPLAY_MAGNITUDE)
	{
		resolution = size/(double)CSignalX.phase_points_per_float;

		if(!x_grid_decades)
			index = CSignalX.CPhaseData.FindIndex((double)value, resolution); 
		else
		{
			resolution = Log(resolution);

			index = CSignalX.CPhaseData.FindDBIndex(20* Log((double)value), 20* resolution); 
		}
	}
	else
	{
		resolution = size/(double)CSignalX.points_per_float;

		if(!x_grid_decades)
			index = CSignalX.CMagnitudeData.FindIndex((double)value, resolution);
		else
		{
			resolution = Log(resolution);

			index = CSignalX.CMagnitudeData.FindDBIndex(20* Log((double)value), 20* resolution); 
		}
	}

	return index;
}

int	TCOutputWaveformDataHeader::FindXIndex(int value)
{
	value;

	return -1;
}

double TCOutputWaveformDataHeader::GetDataYValue(long position, int is_yphase)
{
	if(position < 0) return 0.0;

	if(!PCWaveformDataRuns) return 0.0;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count)		return 0.0;
	if(!PCWaveformDataRuns->CRuns[0])	return 0.0;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(type);//ac, dc, tran type etc.

	if(index < 0) return 0.0;

	TCOutputWaveformDataHeader *PCHeader;

	PCHeader = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;
	
	double ydata = 0.0;
	int signal_type = 0;

	int signal_axis_index = active_magnitude_axis_index;

	if(is_yphase) signal_axis_index = active_phase_axis_index; 

	if(!(signal_axis_index < CSignals.GetSize())) return 0.0;

	if(signal_axis_index < 0) return 0.0;

	TCSignal &CYSignal = CSignals[signal_axis_index];

	if(!is_yphase) 
	{
		if(CYSignal.magnitude == 0)signal_type = TE_SIGNAL_DISPLAY_MAGNITUDE;
		else signal_type = TE_SIGNAL_DISPLAY_DB_MAGNITUDE;

		if(!y_grid_decades)
			ydata = CYSignal.GetDataValue(position, signal_type);
		else
			ydata = CYSignal.GetAntiLogDataValue(position, signal_type);
	}
	else
	{
		if(CYSignal.phase == 0)signal_type = TE_SIGNAL_DISPLAY_PHASE_DEG;
		else signal_type = TE_SIGNAL_DISPLAY_PHASE_RADIANS;

		if(!y_phase_grid_decades)
			ydata = CYSignal.GetDataValue(position, signal_type);
		else
		ydata = CYSignal.GetAntiLogDataValue(position, signal_type);
	}

	return ydata;
}

double  TCOutputWaveformDataHeader::GetDataXValue(long position)
{
	if(position < 0) return 0.0;
	
	if(!PCWaveformDataRuns) return 0.0;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count)		return 0.0;
	if(!PCWaveformDataRuns->CRuns[0])	return 0.0;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(type);//ac, dc, tran type etc.

	if(index < 0) return 0.0;

	TCOutputWaveformDataHeader *PCHeader;

	PCHeader = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;
	
	double ydata = 0.0;
	int signal_type = 0;

	int signal_axis_index;

	signal_axis_index = axis_index;

	if(!(signal_axis_index < CSignals.GetSize())) return 0.0;

	if(signal_axis_index < 0) return 0.0;

	TCSignal &CXSignal = CSignals[signal_axis_index];

	if(!CXSignal.phase_axis) 
	{
		if(!x_grid_decades)
			ydata = CXSignal.GetDataValue(position, signal_type);
		else
			ydata = CXSignal.GetAntiLogDataValue(position, signal_type);
	}
	else
	{
		if(!x_grid_decades)
			ydata = CXSignal.GetDataValue(position, signal_type);
		else
			ydata = CXSignal.GetAntiLogDataValue(position, signal_type);
	}

	return ydata;
}

CString	TCOutputWaveformDataHeader::GetDataTextYValue(long position, int is_yphase)
{
	// This function is only used for the axis labels
	CString CText = "(NULL)";

	if(position < 0) return CText;

	if(!PCWaveformDataRuns) return CText;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!count)		return CText;
	if(!PCWaveformDataRuns->CRuns[0])	return CText;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(type);//ac, dc, tran type etc.

	if(index < 0) return CText;

	TCOutputWaveformDataHeader *PCHeader;

	PCHeader = &PCWaveformDataRuns->CRuns[0]->CRecords[index].CHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;
	
	double ydata = 0.0;
	int signal_type = 0;

	int signal_axis_index = active_magnitude_axis_index;

	if(is_yphase) signal_axis_index = active_phase_axis_index;

	if(!(signal_axis_index < CSignals.GetSize())) return CText;

	TCSignal &CYSignal = CSignals[signal_axis_index];

	CString CPostFix;

	if(!is_yphase) 
	{
		if(CYSignal.magnitude == 0)signal_type = TE_SIGNAL_DISPLAY_MAGNITUDE;
		else signal_type = TE_SIGNAL_DISPLAY_DB_MAGNITUDE;

		if(signal_type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE) CPostFix = "dB";

		if(!y_grid_decades)
			ydata = CYSignal.GetDataValue(position, signal_type);
		else
			ydata = CYSignal.GetAntiLogDataValue(position, signal_type);
	}
	else 
	{
		if(CYSignal.phase == 1)signal_type = TE_SIGNAL_DISPLAY_PHASE_RADIANS;
		else signal_type = TE_SIGNAL_DISPLAY_PHASE_DEG;

		if(signal_type != TE_SIGNAL_DISPLAY_PHASE_DEG) CPostFix = "rad.";
		else CPostFix = "deg.";

		if(type == E_SPICE_RECORD_SENSITIVITY) CPostFix = "";

		if(!y_phase_grid_decades)
			ydata = CYSignal.GetDataValue(position, signal_type);
		else
		ydata = CYSignal.GetAntiLogDataValue(position, signal_type);
	}

	// add more to prefix later, eg volts/amps resistance

/*
	int n;
	
	if(!is_yphase)
	{
		if(!y_grid_decades)
		{
			n = (int)((ydata - y_min)/y_mag_div + .5);
			ydata = n * y_mag_div;
			ydata += y_min;// this is needed to prevent rounding error on 0!
		}			
		else 
		{
			if(y_min) n = (int) (Log(ydata/y_min) + .5);
			else n = 1;
			ydata = (double)AntiLog((double)n)  * y_min; 
		}
	}
	else
	{
		if(!y_phase_grid_decades)
		{
			n = (int)((ydata - y_phase_min)/y_phase_div + .5);
			ydata = n * y_phase_div;
			ydata += y_phase_min;
		}
		else 
		{
			if(y_phase_min) n = (int) (Log(ydata/y_phase_min) + .5);
			else n = 1;

			ydata = (double)AntiLog((double)n)  * y_phase_min; 
		}
	}
*/
	double ddata;

	ddata = (double)ydata;

	CText = FloatToMKSString(ddata);

	CText = CText + ' ' + CPostFix;

	return CText;
}


bool TCWaveformDataRuns::GetMagnitudeMaxMin(TCOutputWaveformDataHeader **PCHeaderMax, TCOutputWaveformDataHeader **PCHeaderMin, int index, double &dmax, double &dmin)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	if(!CRuns[0]) return false;

	double min = 0.0, max = 0.0, min0 = 0.0, max0 = 0.0;

	if(!(index < CRuns[0]->CRecords.GetSize())) return false;

	if(!PCHeaderMax) return false;
	if(!*PCHeaderMax) return false;

	if(!PCHeaderMin) return false;
	if(!*PCHeaderMin) return false;

	(*PCHeaderMax)->_GetMagnitudeMaxMin(max0, min0);

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return false;

		if(!(index < CRuns[p]->CRecords.GetSize())) return false;

		CRuns[p]->CRecords[index].CHeader._GetMagnitudeMaxMin(max, min);

		if(max > max0) 
		{
			*PCHeaderMax = &CRuns[p]->CRecords[index].CHeader;
			max0 = max;
		}
		if(min < min0) 
		{
			*PCHeaderMin = &CRuns[p]->CRecords[index].CHeader;
			min0 = min;
		}
	}

	dmax = max0;
	dmin = min0;

	return true;
}

bool TCWaveformDataRuns::GetPhaseMaxMin(TCOutputWaveformDataHeader **PCHeaderMax, TCOutputWaveformDataHeader **PCHeaderMin, int index, double &dmax, double &dmin)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	if(!CRuns[0]) return false;

	double min = 0.0, max = 0.0, min0 = 0.0, max0 = 0.0;

	if(!(index < CRuns[0]->CRecords.GetSize())) return false;

	if(!PCHeaderMax) return false;
	if(!*PCHeaderMax) return false;

	if(!PCHeaderMin) return false;
	if(!*PCHeaderMin) return false;

	(*PCHeaderMax)->_GetPhaseMaxMin(max0, min0);

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return false;

		if(!(index < CRuns[p]->CRecords.GetSize())) return false;

		CRuns[p]->CRecords[index].CHeader._GetPhaseMaxMin(max, min);

		if(max > max0) 
		{
			*PCHeaderMax = &CRuns[p]->CRecords[index].CHeader;
			max0 = max;
		}
		if(min < min0) 
		{
			*PCHeaderMin = &CRuns[p]->CRecords[index].CHeader;
			min0 = min;
		}
	}

	dmax = max0;
	dmin = min0;

	return true;
}

bool TCWaveformDataRuns::ChangeColour(TCOutputWaveformDataHeader *PCHeader, TCTestPointData &CTestPointData)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(!PCHeader) return false;

	int record_count, q;

	if(!PCHeader->ChangeColour(CTestPointData)) return false;// finds the correct index's from name

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		for(q = 0; q < record_count; q++)
		{
			CRuns[p]->CRecords[q].CHeader.ChangeColour(CTestPointData);
		}
	}

	return true;
}

bool TCWaveformDataRuns::ChangeBKGColour(TCOutputWaveformDataHeader *PCHeader, int colour) // Add Dec 2018
{
	//Below is additional Dec 2018 Fix as BKG colour was not saved!

	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(!PCHeader) return false;

	int record_count, q;

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		for(q = 0; q < record_count; q++)
		{
			CRuns[p]->CRecords[q].CHeader.background_colour = colour;
		}
	}

	return true;
}

bool TCWaveformDataRuns::ClearAllWaveforms(TCOutputWaveformDataHeader *PCHeader)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(!PCHeader) return false;

	int record_count, q;

	if(!PCHeader->ClearAllWaveforms()) return false;// finds the correct index's from name

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		for(q = 0; q < record_count; q++)
		{
			CRuns[p]->CRecords[q].CHeader.ClearAllWaveforms();
		}
	}

	return true;
}

bool TCWaveformDataRuns::ChangeWaveform(TCOutputWaveformDataHeader *PCHeader, TCTestPointData &CTestPointData)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(!PCHeader) return false;

	int record_count, q;
	bool f_noise_waveform = 0;
	CString CPlotName;

	CTestPointData.old_index = -1;// because testpoint might be on nothing
	CTestPointData.new_index = -1;// no anoying popups as in PSpice!

	// by referance to update CTestPointData
	if(!PCHeader->ChangeWaveform(CTestPointData)) return false;// finds the correct index's from name

	CPlotName = CTestPointData.CNew;
	CPlotName.MakeLower();

	CPlotName = PCHeader->CPlotName;
		
	CPlotName.MakeLower();

	if(CPlotName.Find("noise") > -1) f_noise_waveform = 1;

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		for(q = 0; q < record_count; q++)
		{
			if(q == E_SPICE_RECORD_NULL) continue;

			if((q == E_SPICE_RECORD_NOISE_SPECTRAL || q == E_SPICE_RECORD_NOISE_INTEGRATED) && !f_noise_waveform) continue;

			if((q != E_SPICE_RECORD_NOISE_SPECTRAL && q != E_SPICE_RECORD_NOISE_INTEGRATED) && f_noise_waveform) continue;

			CRuns[p]->CRecords[q].CHeader.ChangeWaveform(CTestPointData);
		}
	}

	return true;
}

bool TCWaveformDataRuns::SaveAsText(CString CFileName)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	int record_count;
	CString CName, CRunNumber;

	bool flag = true;

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		CName = CRuns[p]->CRunDiscription;

		for(int q = 0; q < record_count; q++)
		{
			if(q == E_SPICE_RECORD_NULL) continue;

			if(!CRuns[p]->IsWaveformHeaderAvailable(q)) continue;

			CRunNumber.Format("%sR%dT%d", CFileName, p, q);

			if(!CRuns[p]->CRecords[q].CHeader.SaveAsText(CRunNumber, CName))
				flag = false;
		}
	}

	return flag;
}

bool TCWaveformDataRuns::SaveTranNodeSet(CString CFileName)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	int record_count;
	CString CName, CRunName;

	bool flag = true;

	for(int p = 0; p < run_count; p++)
	{
		record_count = CRuns[p]->CRecords.GetSize();

		CName = CRuns[p]->CRunDiscription;

		for(int q = 0; q < record_count; q++)
		{
			if(q != E_SPICE_RECORD_TRANSIENT) continue;// may change later

			if(!CRuns[p]->IsWaveformHeaderAvailable(q)) continue;

			CRunName.Format("%s%d", CFileName, p);

			CString CTempText;

			CTempText.LoadString(IDS_TRAN_NODESET_EXT);

			CRunName += CTempText;

			if(!CRuns[p]->CRecords[q].CHeader.SaveTranNodeSet(CRunName))
				flag = false;
		}
	}

	return flag;
}

bool TCWaveformDataRuns::CreateDCOperatingPointReport(CString CFileName)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	int record_count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);

	CString CText;

	CText = "DC operating point maximums and minimums from all runs:\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	CText = "Signal_Name\tMin\tMax\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_DC < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_OPERATING_POINT)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_OPERATING_POINT].CHeader.PCSignals;

	int new_count;
	int count = CSignals.GetSize();

	if(!count) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;

	double max, min;
	CString CRecordName;
	int max_run_type_index, min_run_type_index;

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];//1st run signals

		CText = CSignal.CName + "\t";

		CDataFile.Write(CText, CText.GetLength());
		
		max = CSignal.CMagnitudeData.CX[0];
		min = CSignal.CMagnitudeData.CX[0];

		max_run_type_index = 0;
		min_run_type_index = 0;

		for(int q = 1; q < run_count; q++)
		{
			CArray <TCSignal, TCSignal&> &CSignalsNew = *CRuns[q]->CRecords[E_SPICE_RECORD_OPERATING_POINT].CHeader.PCSignals;

			new_count = CSignalsNew.GetSize();

			if(!new_count) return false; 
	
			if(new_count != count) return false; 

			TCSignal &CSignalNew = CSignalsNew[p];

			if(!CSignalNew.CMagnitudeData.CX.GetSize()) return false;

			if(CSignalNew.CMagnitudeData.CX[0] > max) max = CSignalNew.CMagnitudeData.CX[0];
			if(CSignalNew.CMagnitudeData.CX[0] < min) min = CSignalNew.CMagnitudeData.CX[0];
		}

		CText = FloatToMKSString(min) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText= FloatToMKSString(max) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText = "Min At=" + CRuns[min_run_type_index]->CRunDiscription + "\t" + "Max At=" + CRuns[max_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());

		CDataFile.Write(data, char_size);
	}

	CDataFile.Close();

	return true;
}

bool TCWaveformDataRuns::CreateDCSweepReport(CString CFileName)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	int record_count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);

	CString CText;

	CText = "DC Sweep maximums and minimums from all runs:\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	CText = "Signal Name\tMin\tMax\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_DC < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_DC)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_DC].CHeader.PCSignals;

	int new_count;
	int count = CSignals.GetSize();

	if(!count) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;

	double max, min, newmax, newmin;

	CString CRecordName;
	int max_run_type_index, min_run_type_index;

	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];//1st run signals

		CText = CSignal.CName + "\t";

		CDataFile.Write(CText, CText.GetLength());
		
		max = CSignal.CMagnitudeData.GetMaxValue();
		min = CSignal. CMagnitudeData.GetMinValue();

		max_run_type_index = 0;
		min_run_type_index = 0;

		for(int q = 1; q < run_count; q++)
		{
			CArray <TCSignal, TCSignal&> &CSignalsNew = *CRuns[q]->CRecords[E_SPICE_RECORD_DC].CHeader.PCSignals;

			new_count = CSignalsNew.GetSize();

			if(!new_count) return false; 
	
			if(new_count != count) return false; 

			TCSignal &CSignalNew = CSignalsNew[p];

			if(!CSignalNew.CMagnitudeData.CX.GetSize()) return false;

			newmax = CSignalNew.CMagnitudeData.GetMaxValue();
			newmin = CSignalNew.CMagnitudeData.GetMinValue();

			if(newmax > max) {max = newmax; max_run_type_index = q;}
			if(newmin < min) {min = newmin; min_run_type_index = q;}
		}

		CText= FloatToMKSString(min) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText =FloatToMKSString(max) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText = "Min At=" + CRuns[min_run_type_index]->CRunDiscription + "\t" + "Max At=" + CRuns[max_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());

		CDataFile.Write(data, char_size);
	}

	CDataFile.Close();

	return true;
}

bool TCWaveformDataRuns::CreateNoiseReport(CString CFileName, TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);
	double noise_frequency;

	int record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_NOISE_SPECTRAL < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_NOISE_SPECTRAL)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_NOISE_SPECTRAL].CHeader.PCSignals;

	int sig_count, frequency_index;
	int count = CSignals.GetSize();

	if(count < 2) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;

	CString CText, CTemp, CLine;

	CLine = CWaveformAnalyisisData.CNoiseReportFrequencyList;

	CTemp = GetFirstWord(CLine);

	noise_frequency = MKSStringToFloat(CTemp);

	while(CTemp != "")
	{
		CText = "Component Noise Report at Frequency = " + CTemp + "Hz"; 
		
		CText += "\r\n\r\n";

		CDataFile.Write(CText, CText.GetLength());

		CText = "\"Rank\"\t\t\"Ref Des\"\t\"Noise (V/sqrtHz)\"\t\"Contribution\"\r\n\r\n";

		CDataFile.Write(CText, CText.GetLength());

		sig_count = CSignals.GetSize();

		sig_count -= 3;// ignore last two integrated noise values, and inoise

		if(sig_count < 2) return false;

		TCSignal &CSignal = CSignals[0]; // find the test frequency required

		frequency_index  = CSignal.CMagnitudeData.GetForwardValuePosition(noise_frequency);

		if(frequency_index < 0)// 10th Nov 2018 added to stop lockup for invalid data
		{
			CLine = RemoveFirstWord(CLine);

			CTemp = GetFirstWord(CLine);

			noise_frequency = MKSStringToFloat(CTemp);

			continue;
		}

		double max;
		CString CName;
		int length;

		CArray <double, double> COrderedValues;
		CArray <CString, CString> COrderedNames;

		sig_count--; // onoise

		double total_onoise = CSignals[sig_count].CMagnitudeData.CX[frequency_index];
		double swap_double;
		CString CSwapString;
		int ordered_sig_count, p, q;

		ordered_sig_count = sig_count - 1;

		COrderedValues.SetSize(ordered_sig_count);
		COrderedNames.SetSize(ordered_sig_count);

		for(p = 1; p < sig_count; p++) // Copy over the data for sorting
		{
			TCSignal &CSignal = CSignals[p];

			COrderedNames[p - 1] = CSignal.CName; 
			COrderedValues[p - 1] = CSignal.CMagnitudeData.CX[frequency_index];
		}

		for(p = 0; p < ordered_sig_count; p++)
		{
			for(q = 0; q < ordered_sig_count - 1; q++)
			{
				if(COrderedValues[q] < COrderedValues[q + 1])
				{
					swap_double = COrderedValues[q + 1];
					CSwapString = COrderedNames[q + 1];

					COrderedValues[q + 1] = COrderedValues[q];
					COrderedNames[q + 1]  = COrderedNames[q];

					COrderedValues[q] = swap_double;
					COrderedNames[q]  = CSwapString;
				}
			}
		}
	// NoisePercentRatio(double fraction, double total);
		for(int p = 0; p < ordered_sig_count; p++)
		{
			length = COrderedNames[p].GetLength();

			CTemp = COrderedNames[p].Right(length - 7); // remove onoise_

			CTemp.Replace("1overf", "1f");

			CText.Format("%d\t\t%s\t\t", p + 1, CTemp);

			max = COrderedValues[p];

			CTemp =  FloatToMKSString(max) + "\t\t";

			CText += CTemp;

			max = NoisePercentRatio(max, total_onoise);

			CTemp =  FloatToMKSString(max) + " %\t\t";

			CText += CTemp;

			CDataFile.Write(CText, CText.GetLength());

			CDataFile.Write(data, char_size); // New line
		}

		CDataFile.Write(data, char_size); // New line

		CTemp = FloatToMKSString(total_onoise) + "\t\t";

		CText.Format("Total Output Noise\t\t%s", CTemp); 

		CDataFile.Write(CText, CText.GetLength());

		CDataFile.Write(data, char_size); // New line

		CDataFile.Write(data, char_size); // New line

		CLine = RemoveFirstWord(CLine);

		CTemp = GetFirstWord(CLine);

		noise_frequency = MKSStringToFloat(CTemp);
	}

	CDataFile.Close();
	
	return true;
}

bool TCWaveformDataRuns::GetMinMaxLoopGain(TCGainPhaseMargin &CGainPhaseMargin)
{
// Start validate
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	int record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_AC < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_AC].CHeader.PCSignals;

	int count = CSignals.GetSize();

	if(!count) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;
// End validate

	TCOutputWaveformData &COutputWaveformData = *CRuns[0];

	CGainPhaseMargin.max_mag	= COutputWaveformData.CMWaveformAnalyisisData.gain_margin;
	CGainPhaseMargin.min_mag	= COutputWaveformData.CMWaveformAnalyisisData.gain_margin;
	CGainPhaseMargin.max_phase	= COutputWaveformData.CMWaveformAnalyisisData.phase_margin;
	CGainPhaseMargin.min_phase	= COutputWaveformData.CMWaveformAnalyisisData.phase_margin;

	int	max_gain_margin_run_type_index, min_gain_margin_run_type_index;
	int	max_phase_margin_run_type_index, min_phase_margin_run_type_index;

	max_gain_margin_run_type_index = 0;
	min_gain_margin_run_type_index = 0;
	max_phase_margin_run_type_index = 0;
	min_phase_margin_run_type_index = 0;

	for(int q = 1; q < run_count; q++)
	{
		TCOutputWaveformData &CNewOutputWaveformData = *CRuns[q];

		TCWaveformAnalyisisData &CWaveformAnalyisisData = CNewOutputWaveformData.CMWaveformAnalyisisData;
		
		if(CMWaveformAnalyisisData.gain_margin != -100)// Ignore invalid data
		{
			if(CWaveformAnalyisisData.gain_margin > CGainPhaseMargin.max_mag) {CGainPhaseMargin.max_mag = CWaveformAnalyisisData.gain_margin; max_gain_margin_run_type_index = q;}
			if(CWaveformAnalyisisData.gain_margin < CGainPhaseMargin.min_mag) {CGainPhaseMargin.min_mag = CWaveformAnalyisisData.gain_margin; min_gain_margin_run_type_index= q;}
		}

		if(CMWaveformAnalyisisData.phase_margin != -1000)// Ignore invalid data
		{
			if(CWaveformAnalyisisData.phase_margin > CGainPhaseMargin.max_phase) {CGainPhaseMargin.max_phase = CWaveformAnalyisisData.phase_margin;max_phase_margin_run_type_index = q;}
			if(CWaveformAnalyisisData.phase_margin < CGainPhaseMargin.min_phase) {CGainPhaseMargin.min_phase = CWaveformAnalyisisData.phase_margin;min_phase_margin_run_type_index = q;}
		}
	}
		
	CGainPhaseMargin.CMinMagName = CRuns[min_gain_margin_run_type_index]->CRunDiscription;
	CGainPhaseMargin.CMaxMagName = CRuns[max_gain_margin_run_type_index]->CRunDiscription;
	CGainPhaseMargin.CMinPhaseName = CRuns[min_phase_margin_run_type_index]->CRunDiscription;
	CGainPhaseMargin.CMaxPhaseName = CRuns[max_phase_margin_run_type_index]->CRunDiscription;

	return true;
}

bool TCWaveformDataRuns::CreateACSweepReport(CString CFileName)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	int record_count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_AC < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_AC].CHeader.PCSignals;

	int new_count;

	int count = CSignals.GetSize();

	if(!count) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;

	CString CText;

///start of Loop Gain

	double  max_phase_margin, min_phase_margin;
	double  max_gain_margin, min_gain_margin;
	double  max_unity_gain_frequency, min_unity_gain_frequency;
	double	max_zero_phase_frequency, min_zero_phase_frequency;
	double  max_low_frequency_gain, min_low_frequency_gain;
	int		max_gain_margin_run_type_index, min_gain_margin_run_type_index;
	int		max_phase_margin_run_type_index, min_phase_margin_run_type_index;
	int		max_unity_gain_frequency_run_type_index, min_unity_gain_frequency_run_type_index;
	int		max_zero_phase_frequency_run_type_index, min_zero_phase_frequency_run_type_index;
	int		max_low_frequency_gain_run_type_index, min_low_frequency_gain_run_type_index;

	TCOutputWaveformData &COutputWaveformData = *CRuns[0];

	if(COutputWaveformData.CMWaveformAnalyisisData.plot_ac_analysis)
	{
		CText = "Loop Gain maximum and minimum from all runs:\r\n\r\n";

		CDataFile.Write(CText, CText.GetLength());

		max_gain_margin			= COutputWaveformData.CMWaveformAnalyisisData.gain_margin;
		max_phase_margin		= COutputWaveformData.CMWaveformAnalyisisData.phase_margin;
		max_unity_gain_frequency = COutputWaveformData.CMWaveformAnalyisisData.unity_gain_frequency;
		max_zero_phase_frequency = COutputWaveformData.CMWaveformAnalyisisData.zero_phase_frequency;
		max_low_frequency_gain	= COutputWaveformData.CMWaveformAnalyisisData.low_frequency_gain;

		min_gain_margin			= max_gain_margin;
		min_phase_margin		= max_phase_margin;
		min_unity_gain_frequency = max_unity_gain_frequency;
		min_zero_phase_frequency =max_zero_phase_frequency;
		min_low_frequency_gain = max_low_frequency_gain;

		max_gain_margin_run_type_index = 0;
		min_gain_margin_run_type_index = 0;
		max_phase_margin_run_type_index = 0;
		min_phase_margin_run_type_index = 0;
		max_unity_gain_frequency_run_type_index = 0;
		min_unity_gain_frequency_run_type_index = 0;
		max_zero_phase_frequency_run_type_index = 0;
		min_zero_phase_frequency_run_type_index = 0;
		max_low_frequency_gain_run_type_index =	0;
		min_low_frequency_gain_run_type_index = 0;

		for(int q = 1; q < run_count; q++)
		{
			TCOutputWaveformData &CNewOutputWaveformData = *CRuns[q];

			TCWaveformAnalyisisData &CWaveformAnalyisisData = CNewOutputWaveformData.CMWaveformAnalyisisData;
		
			if(CMWaveformAnalyisisData.gain_margin != -100)// Ignore invalid data
			{
				if(CWaveformAnalyisisData.gain_margin > max_gain_margin) {max_gain_margin = CWaveformAnalyisisData.gain_margin; max_gain_margin_run_type_index = q;}
				if(CWaveformAnalyisisData.gain_margin < min_gain_margin) {min_gain_margin = CWaveformAnalyisisData.gain_margin; min_gain_margin_run_type_index= q;}
			}

			if(CMWaveformAnalyisisData.phase_margin != -1000)// Ignore invalid data
			{
				if(CWaveformAnalyisisData.phase_margin > max_phase_margin) {max_phase_margin = CWaveformAnalyisisData.phase_margin;max_phase_margin_run_type_index = q;}
				if(CWaveformAnalyisisData.phase_margin < min_phase_margin) {min_phase_margin = CWaveformAnalyisisData.phase_margin;min_phase_margin_run_type_index = q;}
			}

			if(CWaveformAnalyisisData.unity_gain_frequency > max_unity_gain_frequency) {max_unity_gain_frequency = CWaveformAnalyisisData.unity_gain_frequency;max_unity_gain_frequency_run_type_index = q;}
			if(CWaveformAnalyisisData.unity_gain_frequency < min_unity_gain_frequency) {min_unity_gain_frequency = CWaveformAnalyisisData.unity_gain_frequency;min_unity_gain_frequency_run_type_index = q;}

			if(CWaveformAnalyisisData.zero_phase_frequency > max_zero_phase_frequency) {max_zero_phase_frequency = CWaveformAnalyisisData.zero_phase_frequency;max_zero_phase_frequency_run_type_index = q;}
			if(CWaveformAnalyisisData.zero_phase_frequency < min_zero_phase_frequency) {min_zero_phase_frequency = CWaveformAnalyisisData.zero_phase_frequency;min_zero_phase_frequency_run_type_index = q;}
			
			if(CWaveformAnalyisisData.low_frequency_gain > max_low_frequency_gain) {max_low_frequency_gain = CWaveformAnalyisisData.low_frequency_gain;max_low_frequency_gain_run_type_index = q;}
			if(CWaveformAnalyisisData.low_frequency_gain < min_low_frequency_gain) {min_low_frequency_gain = CWaveformAnalyisisData.low_frequency_gain;min_low_frequency_gain_run_type_index = q;}
		}

		CString CMaxPhaseMargin, CMaxGainMargin, CMaxUnityGain, CMaxZeroPhaseFrequency, CMaxLowFGain;
		CString CMinPhaseMargin, CMinGainMargin, CMinUnityGain, CMinZeroPhaseFrequency, CMinLowFGain;
		CString CDB, CDeg;

		if(CMWaveformAnalyisisData.phase_margin != -1000)
		{
			CMaxPhaseMargin = FloatToMKSString(max_phase_margin);
			CMinPhaseMargin = FloatToMKSString(min_phase_margin);

			CDeg =  " Degs.";
		}
		else CMaxPhaseMargin = "Undefined";

		if(CMWaveformAnalyisisData.gain_margin != -100)
		{
			CMaxGainMargin = FloatToMKSString(max_gain_margin);
			CMinGainMargin = FloatToMKSString(min_gain_margin);

			CDB = "dB";
		}
		else CMaxGainMargin = "Undefined";

		CMaxUnityGain = FloatToMKSString(max_unity_gain_frequency);
		CMinUnityGain = FloatToMKSString(min_unity_gain_frequency);

		CMaxZeroPhaseFrequency = FloatToMKSString(max_zero_phase_frequency);
		CMinZeroPhaseFrequency = FloatToMKSString(min_zero_phase_frequency);

		CMaxLowFGain  = FloatToMKSString(max_low_frequency_gain);
		CMinLowFGain  = FloatToMKSString(min_low_frequency_gain);

		CText	= "MinGainMargin=" + CMinGainMargin + CDB + " MaxGainMargin=" + CMaxGainMargin + CDB;
		CText	+= "\tMinAt=" + CRuns[min_gain_margin_run_type_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_gain_margin_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());
		CDataFile.Write(data, char_size);

		CText = "MinPhaseMargin=" + CMinPhaseMargin  + CDeg + " MaxPhaseMargin=" + CMaxPhaseMargin + CDeg;
		CText	+= "\tMinAt=" + CRuns[min_phase_margin_run_type_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_phase_margin_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());
		CDataFile.Write(data, char_size);

		CText = "MinUnityGainFrequency=" + CMinUnityGain + "Hz" + " MaxUnityGainFrequency=" + CMaxUnityGain + "Hz";
		CText	+= "\tMinAt=" + CRuns[min_unity_gain_frequency_run_type_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_unity_gain_frequency_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());
		CDataFile.Write(data, char_size);

		CText = "MinZeroPhaseFrequency=" + CMinZeroPhaseFrequency + "Hz" + " MaxZeroPhaseFrequency=" + CMaxZeroPhaseFrequency + "Hz";
		CText	+= "\tMinAt=" + CRuns[min_zero_phase_frequency_run_type_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_zero_phase_frequency_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());
		CDataFile.Write(data, char_size);

		CText = "MinLowFrequencyGain=" + CMinLowFGain + "dB" + " MaxLowFrequencyGain=" + CMaxLowFGain + "dB";
		CText	+= "\tMinAt=" + CRuns[min_low_frequency_gain_run_type_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_low_frequency_gain_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());

		CDataFile.Write(data, char_size);
		CDataFile.Write(data, char_size);
	}

///End of Loop Gain
	CText = "AC Sweep maximums and minimums from all runs:\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	CText = "Signal_Name\tMagMin\tMagMax\tPhaseMin\tPhaseMax\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	double max, min, newmax, newmin;
	double maxphase, minphase, newmaxphase, newminphase;

	CString CRecordName;
	int max_run_type_index, min_run_type_index, maxphase_run_type_index, minphase_run_type_index;

	//Main min max data from all signals
	for(int p = 0; p < count; p++)
	{
		TCSignal &CSignal = CSignals[p];//1st run signals

		CText = CSignal.CName + "\t";

		CDataFile.Write(CText, CText.GetLength());
		
		max = CSignal.CMagnitudeData.GetMaxValue();
		min = CSignal. CMagnitudeData.GetMinValue();

		if(p)//dont db frequency
		{
			max = 20*Log(max);
			min = 20*Log(min);
		}

		max_run_type_index = 0;
		min_run_type_index = 0;

		maxphase = CSignal.CPhaseData.GetMaxValue();
		minphase = CSignal. CPhaseData.GetMinValue();

		if(!p){maxphase = 0; minphase = 0;}

		maxphase_run_type_index = 0;
		minphase_run_type_index = 0;

		for(int q = 1; q < run_count; q++)
		{
			CArray <TCSignal, TCSignal&> &CSignalsNew = *CRuns[q]->CRecords[E_SPICE_RECORD_AC].CHeader.PCSignals;

			new_count = CSignalsNew.GetSize();

			if(!new_count) return false; 
	
			if(new_count != count) return false; 

			TCSignal &CSignalNew = CSignalsNew[p];

			if(!CSignalNew.CMagnitudeData.CX.GetSize()) return false;

			newmax = CSignalNew.CMagnitudeData.GetMaxValue();
			newmin = CSignalNew.CMagnitudeData.GetMinValue();

			if(p)//dont db frequency
			{
				newmax = 20*Log(newmax);
				newmin = 20*Log(newmin);
			}

			if(newmax > max) {max = newmax; max_run_type_index = q;}
			if(newmin < min) {min = newmin; min_run_type_index = q;}

			if(!CSignalNew.CPhaseData.CX.GetSize()) continue;

			if(!p) continue;// no phase for frequency

			newmaxphase = CSignalNew.CPhaseData.GetMaxValue();
			newminphase = CSignalNew.CPhaseData.GetMinValue();

			if(newmaxphase > maxphase) {maxphase = newmaxphase; maxphase_run_type_index = q;}
			if(newminphase < minphase) {minphase = newminphase; minphase_run_type_index = q;}
		}

		CText = FloatToMKSString(min) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText = FloatToMKSString(max) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		maxphase *= 57.29577951;
		minphase *= 57.29577951;

		CText = FloatToMKSString(minphase) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText = FloatToMKSString(maxphase) + '\t';
		CDataFile.Write(CText, CText.GetLength());

		CText = "MinMagAtParam=" + CRuns[min_run_type_index]->CRunDiscription + "\tMaxMagAtParam=" + CRuns[max_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());

		CText = "\tMinPhaseAtParam=" + CRuns[minphase_run_type_index]->CRunDiscription + "\tMaxPhaseAtParam=" + CRuns[maxphase_run_type_index]->CRunDiscription;
		CDataFile.Write(CText, CText.GetLength());

		CDataFile.Write(data, char_size);
	}

	CDataFile.Close();


	return true;
}

bool TCWaveformDataRuns::CreatePulseAnalysisReport(CString CFileName, TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	int record_count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char new_line[2];
	new_line[0] = '\r';
	new_line[1] = '\n';
	int char_size = 2 * sizeof(char);

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_AC < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader.PCSignals;

	int count = CSignals.GetSize();

	if(!count) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;

	CString CText = "Pulse Analysis maximum and minimum from all runs:\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	CText = "ReferanceSignal=" + CWaveformAnalyisisData.CPulseReferanceSignal + ", ";
	CText += "MeasuredSignal=" + CWaveformAnalyisisData.CPulseMeasureSignal;

	CDataFile.Write(CText, CText.GetLength());

	double max_rise_time, min_rise_time, max_fall_time, min_fall_time;
	double max_width, min_width, max_period, min_period;
	double max_delay, min_delay;

	int max_rise_time_run_index, min_rise_time_run_index, max_fall_time_run_index, min_fall_time_run_index;
	int max_width_run_index, min_width_run_index, max_period_run_index, min_period_run_index;
	int max_delay_run_index, min_delay_run_index;
	
	CalculatePulseData(CWaveformAnalyisisData, 0);
	
	max_rise_time = CWaveformAnalyisisData.pulse_rise_time;
	max_fall_time = CWaveformAnalyisisData.pulse_fall_time;
	max_width	  = CWaveformAnalyisisData.pulse_width;
	max_period	  = CWaveformAnalyisisData.pulse_period;
	max_delay     = CWaveformAnalyisisData.pulse_delay;

	min_rise_time = max_rise_time;
	min_fall_time = max_fall_time;
	min_width     = max_width;
	min_period    = max_period;
	min_delay     = max_delay;

	max_rise_time_run_index = 0;
	max_fall_time_run_index = 0;
	max_width_run_index		= 0;
	max_period_run_index	 = 0;
	max_delay_run_index     = 0;

	min_rise_time_run_index = 0;
	min_fall_time_run_index = 0;
	min_width_run_index     = 0;
	min_period_run_index    = 0;
	min_delay_run_index     = 0;
	
	CString CRise, CFall, CDelay, CPeriod, CWidth;
	CString CSec = "s";

	for(int q = 0; q < run_count; q++)
	{
		CalculatePulseData(CWaveformAnalyisisData, q);

		if(CWaveformAnalyisisData.pulse_rise_time > max_rise_time) {max_rise_time = CWaveformAnalyisisData.pulse_rise_time; max_rise_time_run_index = q;}
		if(CWaveformAnalyisisData.pulse_rise_time < min_rise_time) {min_rise_time = CWaveformAnalyisisData.pulse_rise_time; min_rise_time_run_index = q;}

		if(CWaveformAnalyisisData.pulse_fall_time > max_fall_time) {max_fall_time = CWaveformAnalyisisData.pulse_fall_time; max_fall_time_run_index = q;}
		if(CWaveformAnalyisisData.pulse_fall_time < min_fall_time) {min_fall_time = CWaveformAnalyisisData.pulse_fall_time; min_fall_time_run_index = q;}

		if(CWaveformAnalyisisData.pulse_width > max_width) {max_width = CWaveformAnalyisisData.pulse_width; max_width_run_index = q;}
		if(CWaveformAnalyisisData.pulse_width < min_width) {min_width = CWaveformAnalyisisData.pulse_width; min_width_run_index = q;}

		if(CWaveformAnalyisisData.pulse_period > max_period) {max_period = CWaveformAnalyisisData.pulse_period; max_period_run_index = q;}
		if(CWaveformAnalyisisData.pulse_period < min_period) {min_period = CWaveformAnalyisisData.pulse_period; min_period_run_index = q;}

		if(CWaveformAnalyisisData.pulse_delay > max_delay) {max_delay = CWaveformAnalyisisData.pulse_delay; max_delay_run_index = q;}
		if(CWaveformAnalyisisData.pulse_delay < min_delay) {min_delay = CWaveformAnalyisisData.pulse_delay; min_delay_run_index = q;}

		CDataFile.Write(new_line, char_size);
		CText = "Run=" + CRuns[q]->CRunDiscription;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());
    
		CDelay	= FloatToMKSString(CWaveformAnalyisisData.pulse_delay);
		CRise	= FloatToMKSString(CWaveformAnalyisisData.pulse_rise_time);
		CFall	= FloatToMKSString(CWaveformAnalyisisData.pulse_fall_time);
		CPeriod = FloatToMKSString(CWaveformAnalyisisData.pulse_period);
		CWidth	= FloatToMKSString(CWaveformAnalyisisData.pulse_width);

		CText = "Delay=" + CDelay + CSec;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "Rise=" + CRise + CSec;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "Fall=" + CFall + CSec;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "CWidth=" + CWidth + CSec;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "CPeriod=" + CPeriod + CSec;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());
	}

	CString CMaxRiseTime = FloatToMKSString(max_rise_time);
	CString CMaxFallTime = FloatToMKSString(max_fall_time);
	CString CMaxWidth = FloatToMKSString(max_width);
	CString CMaxPeriod = FloatToMKSString(max_period);
	CString CMaxDelay = FloatToMKSString(max_delay);

	CString CMinRiseTime = FloatToMKSString(min_rise_time);
	CString CMinFallTime = FloatToMKSString(min_fall_time);
	CString CMinWidth = FloatToMKSString(min_width);
	CString CMinPeriod = FloatToMKSString(min_period);
	CString CMinDelay = FloatToMKSString(min_delay);

	CDataFile.Write(new_line, char_size);
	CText	= "MinRiseTime=" + CMinRiseTime + CSec + " MaxRiseTime=" + CMaxRiseTime  + CSec;
	CText	+= "\tMinAt=" + CRuns[min_rise_time_run_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_rise_time_run_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());
	
	CText	= "MinFallTime=" + CMinFallTime + CSec + " MaxFallTime=" + CMaxFallTime + CSec;
	CText	+= "\tMinAt=" + CRuns[min_fall_time_run_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_fall_time_run_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());

	CText	= "MinPulseWidth=" + CMinWidth + CSec + " MaxPulseWidth=" + CMaxWidth + CSec;
	CText	+= "\tMinAt=" + CRuns[min_width_run_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_width_run_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());

	CText	= "MinPulsePeriod=" + CMinPeriod + CSec + " MaxPulsePeriod=" + CMaxPeriod + CSec;
	CText	+= "\tMinAt=" + CRuns[min_period_run_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_period_run_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());

	CText	= "MinDelay=" + CMinDelay + CSec + " MaxDelay=" + CMaxDelay + CSec;
	CText	+= "\tMinAt=" + CRuns[min_delay_run_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_delay_run_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());
	

	return true;
}

bool TCWaveformDataRuns::CreateTransientAveragesReport(CString CFileName, TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;

	int record_count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char new_line[2];
	new_line[0] = '\r';
	new_line[1] = '\n';
	int char_size = 2 * sizeof(char);

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(E_SPICE_RECORD_AC < record_count)) return false;

	if(!CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	if(!CRuns[0]->CRecords.GetSize()) return false;

	CArray <TCSignal, TCSignal&> &CSignals = *CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader.PCSignals;

	int count = CSignals.GetSize();

	if(!count) return false;
	
	if(!CSignals[0].CMagnitudeData.CX.GetSize()) return false;

	if(!CalculateTransientAverages(CWaveformAnalyisisData, 0)) return false;

	CString CText = "Transient Averages from all runs:\r\n\r\n";

	CDataFile.Write(CText, CText.GetLength());

	CText = "Signal=" + CWaveformAnalyisisData.CRMSSignalName;

	CDataFile.Write(CText, CText.GetLength());

	CString CSignalName, CRMS, CRMSRipple, CAVE, CPkPk;

	double	max_rms, max_ripple, max_average, max_peak;
	double	min_rms, min_ripple, min_average, min_peak;
	int		max_rms_index, max_ripple_index, max_average_index, max_peak_index;
	int		min_rms_index, min_ripple_index, min_average_index, min_peak_index;

	max_rms		= CWaveformAnalyisisData.rms_value;
	max_ripple	= CWaveformAnalyisisData.rms_ripple_value;
	max_average = CWaveformAnalyisisData.rms_av_value;
	max_peak	= CWaveformAnalyisisData.rms_pk_value;

	min_rms		= max_rms;
	min_ripple	= max_ripple;
	min_average = max_average;
	min_peak	= max_peak;

	min_rms_index		= 0;
	min_ripple_index	= 0;
	min_average_index	= 0;
	min_peak_index		= 0;
	max_rms_index		= 0;
	max_ripple_index	= 0;
	max_average_index	= 0;
	max_peak_index		= 0;

	for(int p = 0; p < run_count; p++)
	{
		if(!CalculateTransientAverages(CWaveformAnalyisisData, p)) continue;

		if(CWaveformAnalyisisData.rms_value > max_rms) {max_rms = CWaveformAnalyisisData.rms_value; max_rms_index = p;}
		if(CWaveformAnalyisisData.rms_value < min_rms) {min_rms = CWaveformAnalyisisData.rms_value; min_rms_index = p;}

		if(CWaveformAnalyisisData.rms_ripple_value > max_ripple) {max_ripple = CWaveformAnalyisisData.rms_ripple_value; max_ripple_index = p;}
		if(CWaveformAnalyisisData.rms_ripple_value < min_ripple) {min_ripple = CWaveformAnalyisisData.rms_ripple_value; min_ripple_index = p;}

		if(CWaveformAnalyisisData.rms_av_value > max_average) {max_average = CWaveformAnalyisisData.rms_av_value; max_average_index = p;}
		if(CWaveformAnalyisisData.rms_av_value < min_average) {min_average = CWaveformAnalyisisData.rms_av_value; min_average_index = p;}

		if(CWaveformAnalyisisData.rms_pk_value > max_peak) {max_peak = CWaveformAnalyisisData.rms_pk_value; max_peak_index = p;}
		if(CWaveformAnalyisisData.rms_pk_value < min_peak) {min_peak = CWaveformAnalyisisData.rms_pk_value; min_peak_index = p;}

		CDataFile.Write(new_line, char_size);
		CText = "Run=" + CRuns[p]->CRunDiscription;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CRMS = FloatToMKSString(CWaveformAnalyisisData.rms_value);

		CRMSRipple = FloatToMKSString(CWaveformAnalyisisData.rms_ripple_value);

		CAVE = FloatToMKSString(CWaveformAnalyisisData.rms_av_value);

		CPkPk = FloatToMKSString(CWaveformAnalyisisData.rms_pk_value);

		CText = "RMS=" + CRMS;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "RMS Ripple=" + CRMSRipple;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "Average=" + CAVE;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());

		CText = "Pk-Pk=" + CPkPk;

		CDataFile.Write(new_line, char_size);
		CDataFile.Write(CText, CText.GetLength());
	}

	CString CMaxRMS, CMaxRMSRipple, CMaxAVE, CMaxPkPk;
	CString CMinRMS, CMinRMSRipple, CMinAVE, CMinPkPk;

	CMaxRMS = FloatToMKSString(max_rms);
	CMinRMS = FloatToMKSString(min_rms);
	CMaxRMSRipple = FloatToMKSString(max_ripple);
	CMinRMSRipple= FloatToMKSString(min_ripple);
	CMaxAVE = FloatToMKSString(max_average);
	CMinAVE = FloatToMKSString(min_average);
	CMaxPkPk = FloatToMKSString(max_peak);
	CMinPkPk = FloatToMKSString(min_peak);

	CDataFile.Write(new_line, char_size);

	CText	= "MinRMS=" + CMinRMS + " MaxRMS=" + CMaxRMS;
	CText	+= "\tMinAt=" + CRuns[min_rms_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_rms_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());
	
	CText	= "MinRMSRipple=" + CMinRMSRipple + " MaxRMSRipple=" + CMaxRMSRipple;
	CText	+= "\tMinAt=" + CRuns[min_ripple_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_ripple_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());

	CText	= "MinAverage=" + CMinAVE + " MaxAverage=" + CMaxAVE;
	CText	+= "\tMinAt=" + CRuns[min_average_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_average_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());

	CText	= "Pk-Pk=" + CMinPkPk + " Pk-Pk=" + CMaxPkPk;
	CText	+= "\tMinAt=" + CRuns[min_peak_index]->CRunDiscription + "\tMaxAt=" + CRuns[max_peak_index]->CRunDiscription;
	CDataFile.Write(new_line, char_size);
	CDataFile.Write(CText, CText.GetLength());

	return true;
}

bool TCWaveformDataRuns::CreateTransientSweepReport(CString CFileName)
{
	CFileName;

	return true;
}

bool TCWaveformDataRuns::CalculateLoopGain(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_AC < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC)) return false;

	CRuns[run]->CMWaveformAnalyisisData = CWaveformAnalyisisData;

	bool result = CRuns[run]->GenerateACAnalysisData();

	CWaveformAnalyisisData = CRuns[run]->CMWaveformAnalyisisData;

	return result;
}

bool TCWaveformDataRuns::CalculateTransientFrequency(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	CRuns[run]->CMWaveformAnalyisisData = CWaveformAnalyisisData;

	bool result = CRuns[run]->GenerateTransientFrequencyData();

	CWaveformAnalyisisData = CRuns[run]->CMWaveformAnalyisisData;

	return result;
}

bool TCWaveformDataRuns::CalculatePulseRise(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GeneratePulseRise(CWaveformAnalyisisData);

	return result;
}

bool TCWaveformDataRuns::CalculatePulseFall(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GeneratePulseFall(CWaveformAnalyisisData);

	return result;
}

bool TCWaveformDataRuns::CalculatePulseWidth(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GeneratePulseWidth(CWaveformAnalyisisData);

	return result;
}

bool TCWaveformDataRuns::CalculatePulsePeriod(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GeneratePulsePeriod(CWaveformAnalyisisData);

	return result;
}

bool TCWaveformDataRuns::CalculatePulseDelay(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GeneratePulseDelay(CWaveformAnalyisisData);

	return result;
}

bool TCWaveformDataRuns::CalculatePulseData(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	bool result = true;

	if(!CalculatePulseRise(CWaveformAnalyisisData, run)) result = false;
	if(!CalculatePulseFall(CWaveformAnalyisisData, run)) result = false;
	if(!CalculatePulseWidth(CWaveformAnalyisisData, run)) result = false;
	if(!CalculatePulsePeriod(CWaveformAnalyisisData, run)) result = false;
	if(!CalculatePulseDelay(CWaveformAnalyisisData, run)) result = false;

	return result;
}

bool TCWaveformDataRuns::CalculateTransientAverages(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GenerateTransientAverages(CWaveformAnalyisisData);

	return result;
}

bool TCWaveformDataRuns::CalculatePower(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run)
{
	int run_count = CRuns.GetSize();
	if(!run_count) return false;
	if(!CRuns[0]) return false;
	if(run < 0) return false;

	int record_count;

	record_count = CRuns[0]->CRecords.GetSize();

	if(!(run < run_count)) return false;

	if(!(E_SPICE_RECORD_TRANSIENT < record_count)) return false;

	if(!CRuns[run]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	bool result = CRuns[run]->GeneratePower(CWaveformAnalyisisData);

	return result;
}

void TCWaveformDataRuns::SetScaleFactors(unsigned short width, unsigned short height, int type, double zoom)
{
	int count = CRuns.GetSize();

	if(!count) return;

	if(count < 0)
	{
		ASSERT(0);
		return;
	}

	if(!CRuns[0]) return;

	TCOutputWaveformDataHeader *PCHeaderMax = NULL;
	TCOutputWaveformDataHeader *PCHeaderMin = NULL;

	PCHeaderMin;

	int index = CRuns[0]->GetWaveFormHeaderIndex(type);

	if(index < 0) return;

	if(!(index < CRuns[0]->CRecords.GetSize())) return;

	PCHeaderMax = &CRuns[0]->CRecords[index].CHeader;
	PCHeaderMin = &CRuns[0]->CRecords[index].CHeader;

	// this replaces the PCHeaderMax, PCHeaderMin with the max,min found in all runs
	double dmax = 0.0, dmin = 0.0;

	if(!GetMagnitudeMaxMin(&PCHeaderMax, &PCHeaderMin, index, dmax, dmin)) return;

	PCHeaderMin;

	unsigned short s_width, s_height;

	s_width		= width;
	s_height	= height;

	PCHeaderMax->ScaleGrid(&s_width, &s_height);// needed to update data base copy

	PCHeaderMax->SetScaleFactors((unsigned short) (width * zoom), (unsigned short) (height * zoom));

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return;

		if(!(index < CRuns[p]->CRecords.GetSize())) return;

		if(CRuns[p]->CRecords[index].CHeader.type == E_SPICE_RECORD_NULL) continue;

		CRuns[p]->CRecords[index].CHeader.CopyScaleFactors(*PCHeaderMax);
	}
}

bool TCWaveformDataRuns::GetData(TCFloatingCursorData &CFloatingCursorData)
{
	CFloatingCursorData.CSignalName = "None selected";

//	CFloatingCursorData.Zero();

	int count = CRuns.GetSize();

	if(!count)		return false;
	if(!CRuns[0])	return false;
	if(!(CFloatingCursorData.run_index < count)) return false;

	int index = CRuns[CFloatingCursorData.run_index]->GetWaveFormHeaderIndex(CFloatingCursorData.type);//ac, dc, tran type etc.

	if(index < 0) return false;

	CFloatingCursorData.CRun = CRuns[CFloatingCursorData.run_index]->CRunDiscription;

	TCOutputWaveformDataHeader *PCHeader;

	if(!(index < CRuns[CFloatingCursorData.run_index]->CRecords.GetSize())) return false;

	PCHeader = &CRuns[CFloatingCursorData.run_index]->CRecords[index].CHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;
	
	TCSignal CXSignal = CSignals[CFloatingCursorData.axis_index];

	TCSignal CYSignal = CSignals[CFloatingCursorData.signal_index];

	double xdata;

	int xtype = 0;
	if(!CXSignal.phase_axis)
	{
		xtype = TE_SIGNAL_DISPLAY_MAGNITUDE;
	}
	else
	{
		xtype = TE_SIGNAL_DISPLAY_PHASE_DEG;
	}

	int graph_size = CXSignal.GraphPointToMagDataIndex.GetSize();

	if(!(CFloatingCursorData.CSignalLocation.x < graph_size) ||
		 CFloatingCursorData.CSignalLocation.x < 0)
	{

		CFloatingCursorData.CSignalLocation.x = 0;
	}

	if(!CXSignal.GraphPointToMagDataIndex.GetSize()) return false;

	int data_index = CXSignal.GraphPointToMagDataIndex[CFloatingCursorData.CSignalLocation.x];

	// need check on phase log/linear axis
	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.interperlated_points)
	{
		if(!PCHeader->x_grid_decades)	
			xdata = CXSignal.GetDataValue(CFloatingCursorData.CSignalLocation.x, xtype, CYSignal.x_gain, CYSignal.x_offset);
		else
			xdata = CXSignal.GetAntiLogDataValue(CFloatingCursorData.CSignalLocation.x, xtype, CYSignal.x_gain, CYSignal.x_offset);

	}
	else //13 april 2001
	{
		xdata = CXSignal.GetDataValue(data_index, xtype);

		xdata = xdata - (CXSignal.x_offset)/CXSignal.x_gain;
	}

	double ydata;
	
	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.interperlated_points)
	{
		if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE || 
			CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_MAGNITUDE)
		{
			if(!PCHeader->y_grid_decades)
				ydata = CYSignal.GetDataValue(CFloatingCursorData.CSignalLocation.y, CFloatingCursorData.signal_type);
			else
				ydata = CYSignal.GetAntiLogDataValue(CFloatingCursorData.CSignalLocation.y, CFloatingCursorData.signal_type);
		}
		else
		{
			if(!PCHeader->y_phase_grid_decades)
				ydata = CYSignal.GetDataValue(CFloatingCursorData.CSignalLocation.y, CFloatingCursorData.signal_type);
			else
				ydata = CYSignal.GetAntiLogDataValue(CFloatingCursorData.CSignalLocation.y, CFloatingCursorData.signal_type);
		}
	}
	else
	{
		if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE || 
		   CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_MAGNITUDE)
		{
			ydata = CYSignal.GetDataValue(data_index, CFloatingCursorData.signal_type);

			if(!CYSignal.magnitude) ydata;
			else ydata = 20*Log(ydata);
		}
		else
		{
			ydata = CYSignal.GetDataValue(data_index, CYSignal.type);
		}

		ydata = ydata - (CYSignal.y_offset)/CYSignal.y_gain;
	}


	CFloatingCursorData.CSignalName = CSignals[CFloatingCursorData.signal_index].CName;

	CFloatingCursorData.CSignalNameHeader = "";

	if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)CFloatingCursorData.CSignalNameHeader = "Phase (Rad.) of ";
	else if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)CFloatingCursorData.CSignalNameHeader = "Magnitude (DB) of ";
	else if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_PHASE_DEG)CFloatingCursorData.CSignalNameHeader = "Phase (Degs.) of ";
	else if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_MAGNITUDE) CFloatingCursorData.CSignalNameHeader = "Mag. of ";
	else CFloatingCursorData.CSignalNameHeader = "Signal: ";

	if(PCHeader->type == E_SPICE_RECORD_SENSITIVITY)
	{
		if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_PHASE_DEG ||
	       CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_PHASE_RADIANS) 
			CFloatingCursorData.CSignalNameHeader = "Sensitivity2: ";
		else CFloatingCursorData.CSignalNameHeader = "Sensitivity1: ";
	}

	if(!CFloatingCursorData.cursor2_active)
	{
		CFloatingCursorData.x1 = xdata;
		CFloatingCursorData.y1 = ydata;
	}
	else
	{
		CFloatingCursorData.x2 = xdata;
		CFloatingCursorData.y2 = ydata;
	}

	CFloatingCursorData.dx = CFloatingCursorData.x1 - CFloatingCursorData.x2;
	CFloatingCursorData.dy = CFloatingCursorData.y1 - CFloatingCursorData.y2;

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.display_signal_x2)//test, display phase instead of second cursor
	{
		TCFloatingCursorData CFloatingCursorDataPhase;

		CFloatingCursorDataPhase = CFloatingCursorData;

		_GetDataPhase(CFloatingCursorDataPhase);

		CFloatingCursorData.x2 = xdata;
		CFloatingCursorData.y2 = CFloatingCursorDataPhase.y2;

		CFloatingCursorData.dx = 0.0;
		CFloatingCursorData.dy = 0.0;
	}

	return true;
}

bool TCWaveformDataRuns::_GetDataPhase(TCFloatingCursorData &CFloatingCursorData)
{
	int count = CRuns.GetSize();

	if(!count)		return false;
	if(!CRuns[0])	return false;
	if(!(CFloatingCursorData.run_index < count)) return false;

	int index = CRuns[CFloatingCursorData.run_index]->GetWaveFormHeaderIndex(CFloatingCursorData.type);//ac, dc, tran type etc.

	if(index < 0) return false;

	CFloatingCursorData.CRun = CRuns[CFloatingCursorData.run_index]->CRunDiscription;

	TCOutputWaveformDataHeader *PCHeader;

	if(!(index < CRuns[CFloatingCursorData.run_index]->CRecords.GetSize())) return false;

	PCHeader = &CRuns[CFloatingCursorData.run_index]->CRecords[index].CHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;
	
	TCSignal CXSignal = CSignals[CFloatingCursorData.axis_index];

	TCSignal CYSignal = CSignals[CFloatingCursorData.signal_index];

	int graph_size = CXSignal.GraphPointToMagDataIndex.GetSize();

	if(!(CFloatingCursorData.CSignalLocation.x < graph_size) ||
		 CFloatingCursorData.CSignalLocation.x < 0)
	{

		CFloatingCursorData.CSignalLocation.x = 0;
	}

	int data_index = CXSignal.GraphPointToMagDataIndex[CFloatingCursorData.CSignalLocation.x];

	double ydata;

	CFloatingCursorData.signal_type = TE_SIGNAL_DISPLAY_PHASE_DEG;// need to add switch for radians
	
//	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.interperlated_points)// can not determine y 
	
	ydata = CYSignal.GetDataValue(data_index, CYSignal.type);

	ydata = ydata - (CYSignal.y_offset)/CYSignal.y_gain;

	CFloatingCursorData.y2 = ydata;

	return true;
}

void TCWaveformDataRuns::operator = (TCWaveformDataRuns &CWaveformDataRuns)
{
	CWaveformDataRuns;// unlikely to be needed
	PCDoc			= CWaveformDataRuns.PCDoc;

	int count = CMathFunctionDataList.GetSize();

	for(int p = 0; p , count; p++)
	{
		CMathFunctionDataList[p] = CWaveformDataRuns.CMathFunctionDataList[p];

	}
}

void TCWaveformDataRuns::ComputeFFTs(void)
{
	int count = CRuns.GetSize();

	if(!count) return;

	if(count < 0)return;

	if(!CRuns[0]) return;

	if(IsBadCodePtr((FARPROC)CRuns[0])) return;

	if((CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)))
		ComputeFFT(CRuns[0]->CRecords[E_SPICE_RECORD_TIME_TO_FREQ_FFT].CHeader, CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader);
	
	if((CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC)))
		ComputeFFT(CRuns[0]->CRecords[E_SPICE_RECORD_FREQ_TO_TIME_FFT].CHeader, CRuns[0]->CRecords[E_SPICE_RECORD_AC].CHeader);
}

void TCWaveformDataRuns::ComputeFFT(TCOutputWaveformDataHeader &CDataHeaderDestination, TCOutputWaveformDataHeader &CDataHeaderSource)
{
	int count = CRuns.GetSize();

	if(!count) return;

	if(count < 0)return;

	if(!CRuns[0]) return;

	int source_index = CDataHeaderSource.type;
	int destination_index = CDataHeaderDestination.index;

	if(source_index < 0) return;
	if(destination_index < 0) return;

	TCOutputWaveformData *POutputWaveformData;

	for(int p = 0; p < count; p++)// first copy the data to get signal names etc
	{
		POutputWaveformData = CRuns[p];

		if(!POutputWaveformData) return;

		if(IsBadCodePtr((FARPROC)POutputWaveformData)) return;

		if(!(source_index < POutputWaveformData->CRecords.GetSize())) return;

		if(!(destination_index < CRuns[p]->CRecords.GetSize())) return;
	
		POutputWaveformData->CRecords[destination_index].CHeader.ComputeFFT(POutputWaveformData->CRecords[source_index].CHeader);
	}
}

bool TCWaveformDataRuns::IsAnyMagnitudesDisplayed(int index)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	if(count < 0)return false;

	if(!CRuns[0]) return false;

	TCOutputWaveformData *POutputWaveformData;

	for(int p = 0; p < count; p++)
	{
		POutputWaveformData = CRuns[p];

		if(!POutputWaveformData) return false;

		if(IsBadCodePtr((FARPROC)POutputWaveformData)) return false;

		if(!(index < POutputWaveformData->CRecords.GetSize())) return false;

		if(POutputWaveformData->CRecords[index].CHeader.IsAnyMagnitudesDisplayed()) return true;
	}

	return false;
}

bool TCWaveformDataRuns::IsAnyPhaseDisplayed(int index)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	if(count < 0)return false;

	if(!CRuns[0]) return false;

	TCOutputWaveformData *POutputWaveformData;

	for(int p = 0; p < count; p++)
	{
		POutputWaveformData = CRuns[p];

		if(!POutputWaveformData) return false;

		if(IsBadCodePtr((FARPROC)POutputWaveformData)) return false;

		if(!(index < POutputWaveformData->CRecords.GetSize())) return false;

		if(POutputWaveformData->CRecords[index].CHeader.IsAnyPhaseDisplayed()) return true;
	}

	return false;
}

void TCWaveformDataRuns::CopyData(TCOutputWaveformDataHeader &CDataHeaderDestination, TCOutputWaveformDataHeader &CDataHeaderSource)
{
	int count = CRuns.GetSize();

	if(!count) return;

	if(count < 0)return;

	if(!CRuns[0]) return;

	int source_index = CDataHeaderSource.type;
	int destination_index = CDataHeaderDestination.type;

	if(source_index < 0) return;
	if(destination_index < 0) return;

	if(destination_index != E_SPICE_RECORD_MATH_0)
	{
		ASSERT(0);

		return;
	}

	TCOutputWaveformData *POutputWaveformData;

	for(int p = 0; p < count; p++)
	{
		POutputWaveformData = CRuns[p];

		if(!POutputWaveformData) return;

		if(IsBadCodePtr((FARPROC)POutputWaveformData)) return;

		if(!(source_index < POutputWaveformData->CRecords.GetSize())) return;

		if(!(destination_index < CRuns[p]->CRecords.GetSize())) return;

		POutputWaveformData->CRecords[destination_index] = POutputWaveformData->CRecords[source_index];

		// recover signal pointer and type index that was overwritten by above
		POutputWaveformData->CRecords[destination_index].CHeader.PCSignals = &POutputWaveformData->CRecords[destination_index].CSignals;
		POutputWaveformData->CRecords[destination_index].CHeader.type = destination_index;
		POutputWaveformData->CRecords[destination_index].CHeader.index = destination_index;
	}
}

bool TCWaveformDataRuns::SetupMathFunctionData(void)
{
	int count = CRuns.GetSize();

	if(!count) return false;

	if(count < 0)
	{
		ASSERT(0);
		return false;
	}

	if(!CRuns[0]) return false;

	if(!CMathFunctionDataList[0].calculator_enabled) return false;

	int index = CMathFunctionDataList[0].record_index;

	for(int p = 0; p < count; p++)
	{
		if(!CRuns[p]) return false;

		if(IsBadCodePtr((FARPROC)&CRuns[p])) return false;

		if(!(index < CRuns[p]->CRecords.GetSize())) return false;

		CRuns[p]->CRecords[E_SPICE_RECORD_MATH_0].ClearMathFunctionData(index);

		if(CRuns[p]->CRecords[index].CHeader.type == E_SPICE_RECORD_NULL) continue;

		SetupMathFunctionData(CRuns[p]->CRecords[index].CHeader, p);
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionData(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index)
{
	int count = CMathFunctionDataList.GetSize();

	for(int p = 0; p < count; p++)
	{
		if((CMathFunctionDataList[p].magnitude < 0)&& (CMathFunctionDataList[p].phase < 0)) continue;

		switch(CMathFunctionDataList[p].signals_ab_operator)
		{
			case E_MATH_OPERATOR_ADD:		SetupMathFunctionDataAdd(COutputWaveformDataHeader, run_index, p); break;
			case E_MATH_OPERATOR_SUBTRACT:	SetupMathFunctionDataSubtract(COutputWaveformDataHeader, run_index, p); break;
			case E_MATH_OPERATOR_MULTIPLY:	SetupMathFunctionDataMultiply(COutputWaveformDataHeader, run_index, p); break;
			case E_MATH_OPERATOR_DIVIDE:	SetupMathFunctionDataDivide(COutputWaveformDataHeader, run_index, p); break;
			case E_MATH_OPERATOR_POWER:		SetupMathFunctionDataPower(COutputWaveformDataHeader, run_index, p); break;
			case E_MATH_OPERATOR_NONE:		SetupMathFunctionDataNone(COutputWaveformDataHeader, run_index, p); break;

		}
	}
	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataAdd(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	int type = COutputWaveformDataHeader.type;

	switch(type)
	{
		case E_SPICE_RECORD_DC:
		case E_SPICE_RECORD_TRANSIENT:
			 
			 SetupMathFunctionDataAddReal(COutputWaveformDataHeader, run_index, index);
			 break;

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_FOURIER:

			 SetupMathFunctionDataAddComplex(COutputWaveformDataHeader, run_index, index);

			 break;

		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:

			 SetupMathFunctionDataAddSquares(COutputWaveformDataHeader, run_index, index);

			 break;
		

		case E_SPICE_RECORD_THD:
		case E_SPICE_RECORD_IMD:
		case E_SPICE_RECORD_DISTORTION_IMD_2F:
		case E_SPICE_RECORD_SENSITIVITY:
		case E_SPICE_RECORD_POLE_ZERO:
		case E_SPICE_RECORD_OPERATING_POINT:
		
		default: return false;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataSubtract(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	int type = COutputWaveformDataHeader.type;

	switch(type)
	{
		case E_SPICE_RECORD_DC:
		case E_SPICE_RECORD_TRANSIENT:
			 
			 SetupMathFunctionDataSubtractReal(COutputWaveformDataHeader, run_index, index);
			 break;

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_FOURIER:

			 SetupMathFunctionDataSubtractComplex(COutputWaveformDataHeader, run_index, index);

			 break;

		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:

			 SetupMathFunctionDataSubtractSquares(COutputWaveformDataHeader, run_index, index);

			 break;
		

		case E_SPICE_RECORD_THD:
		case E_SPICE_RECORD_IMD:
		case E_SPICE_RECORD_DISTORTION_IMD_2F:
		case E_SPICE_RECORD_SENSITIVITY:
		case E_SPICE_RECORD_POLE_ZERO:
		case E_SPICE_RECORD_OPERATING_POINT:
		
		default: return false;
	}

	return true;
}
bool TCWaveformDataRuns::SetupMathFunctionDataMultiply(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{

	int type = COutputWaveformDataHeader.type;

	switch(type)
	{
		case E_SPICE_RECORD_DC:
		case E_SPICE_RECORD_TRANSIENT:
			 
			 SetupMathFunctionDataMultiplyReal(COutputWaveformDataHeader, run_index, index);
			 break;

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_FOURIER:

			 SetupMathFunctionDataMultiplyComplex(COutputWaveformDataHeader, run_index, index);

			 break;

		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:

			 SetupMathFunctionDataMultiplySquares(COutputWaveformDataHeader, run_index, index);

			 break;
		

		case E_SPICE_RECORD_THD:
		case E_SPICE_RECORD_IMD:
		case E_SPICE_RECORD_DISTORTION_IMD_2F:
		case E_SPICE_RECORD_SENSITIVITY:
		case E_SPICE_RECORD_POLE_ZERO:
		case E_SPICE_RECORD_OPERATING_POINT:
		
		default: return false;
	}

	return true;
}
bool TCWaveformDataRuns::SetupMathFunctionDataDivide(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	int type = COutputWaveformDataHeader.type;

	switch(type)
	{
		case E_SPICE_RECORD_DC:
		case E_SPICE_RECORD_TRANSIENT:
			 
			 SetupMathFunctionDataDivideReal(COutputWaveformDataHeader, run_index, index);
			 break;

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_FOURIER:

			 SetupMathFunctionDataDivideComplex(COutputWaveformDataHeader, run_index, index);

			 break;

		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:

			 SetupMathFunctionDataDivideSquares(COutputWaveformDataHeader, run_index, index);

			 break;
		

		case E_SPICE_RECORD_THD:
		case E_SPICE_RECORD_IMD:
		case E_SPICE_RECORD_DISTORTION_IMD_2F:
		case E_SPICE_RECORD_SENSITIVITY:
		case E_SPICE_RECORD_POLE_ZERO:
		case E_SPICE_RECORD_OPERATING_POINT:
		
		default: return false;
	}

	return true;
}
bool TCWaveformDataRuns::SetupMathFunctionDataPower(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	int type = COutputWaveformDataHeader.type;

	switch(type)
	{
		case E_SPICE_RECORD_DC:
		case E_SPICE_RECORD_TRANSIENT:
			 
			 SetupMathFunctionDataPowerReal(COutputWaveformDataHeader, run_index, index);
			 break;

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_FOURIER:

			 SetupMathFunctionDataPowerComplex(COutputWaveformDataHeader, run_index, index);

			 break;

		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:

			 SetupMathFunctionDataPowerSquares(COutputWaveformDataHeader, run_index, index);

			 break;
		

		case E_SPICE_RECORD_THD:
		case E_SPICE_RECORD_IMD:
		case E_SPICE_RECORD_DISTORTION_IMD_2F:
		case E_SPICE_RECORD_SENSITIVITY:
		case E_SPICE_RECORD_POLE_ZERO:
		case E_SPICE_RECORD_OPERATING_POINT:
		
		default: return false;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataNone(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	int type = COutputWaveformDataHeader.type;

	switch(type)
	{
		case E_SPICE_RECORD_DC:
		case E_SPICE_RECORD_TRANSIENT:
			 
			 break;

		case E_SPICE_RECORD_AC:

			SetupMathFunctionNone(COutputWaveformDataHeader, run_index, index); 

			break;

		case E_SPICE_RECORD_FOURIER:


			 break;

		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:


			 break;
		

		case E_SPICE_RECORD_THD:
		case E_SPICE_RECORD_IMD:
		case E_SPICE_RECORD_DISTORTION_IMD_2F:
		case E_SPICE_RECORD_SENSITIVITY:
		case E_SPICE_RECORD_POLE_ZERO:
		case E_SPICE_RECORD_OPERATING_POINT:
		
		default: return false;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathSignals(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index, 
								          TCSignal **PCSignalA, TCSignal **PCSignalB, TCSignal **PCSignalC)

{
	int a_signal_index, b_signal_index;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	if(CMathFunctionData.magnitude < 0 && CMathFunctionData.phase < 0) return false;//data not requested

	TCOutputWaveformDataHeader &CWaveformDataHeader = CRuns[run_index]->CRecords[E_SPICE_RECORD_MATH_0].CHeader; 

// copy graph data and recover original pointer
	CArray<TCSignal, TCSignal &> *PCSignals = CWaveformDataHeader.PCSignals;

	CWaveformDataHeader = COutputWaveformDataHeader;

	CWaveformDataHeader.PCSignals = PCSignals;
//
	a_signal_index = CMathFunctionData.a_signal;
	b_signal_index = CMathFunctionData.b_signal;

	if(a_signal_index < 0) a_signal_index = 1;
	if(b_signal_index < 0) b_signal_index = 1;

	if(IsBadReadPtr(CWaveformDataHeader.PCSignals, 4)) return false;
	if(IsBadReadPtr(COutputWaveformDataHeader.PCSignals, 4)) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	CArray <TCSignal, TCSignal &> &CSignalsC = *CWaveformDataHeader.PCSignals;

	int signal_count = CSignals.GetSize();
	
	if(!(a_signal_index < signal_count)) return false;
	if(!(b_signal_index < signal_count)) return false;

	CSignalsC.SetSize(signal_count);// this is safer, althougth it wastes space

	if(CSignalsC.GetSize() != signal_count) return false;

	*PCSignalA = &CSignals[a_signal_index];
	*PCSignalB = &CSignals[b_signal_index];
	*PCSignalC = &CSignalsC[a_signal_index];
	
// first copy A to the new data to get reasonable defaults, e.g. colours etc;

//	**PCSignalC = **PCSignalA;
	
	CWaveformDataHeader.active_magnitude_axis_index = a_signal_index;
	CWaveformDataHeader.active_phase_axis_index		= a_signal_index;
	CWaveformDataHeader.type						= E_SPICE_RECORD_MATH_0;

	COutputWaveformDataHeader.active_magnitude_axis_index	= a_signal_index;
	COutputWaveformDataHeader.active_phase_axis_index		= a_signal_index;

	CSignalsC[a_signal_index].magnitude	= CMathFunctionData.magnitude;
	CSignalsC[a_signal_index].phase		= CMathFunctionData.phase;

// now do x axis by simple copy, this will get redunduntly copied for more then one signal displayed
	int x_axis = COutputWaveformDataHeader.axis_index;

	TCSignal &CSignalXA = CSignals[x_axis];
	TCSignal &CSignalXC = CSignalsC[x_axis];

	CSignalXC = CSignalXA;

	CSignalXC.CMagnitudeData	= CSignalXA.CMagnitudeData;
	CSignalXC.CPhaseData		= CSignalXA.CPhaseData;
//

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataAddReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData	= PCSignalA->CMagnitudeData + PCSignalB->CMagnitudeData;
	PCSignalC->CPhaseData		= PCSignalA->CPhaseData + PCSignalB->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;

	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "+" + PCSignalB->CName +")";
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();
		CSignal.CCalculatorNameMagnitude = "db10(" + PCSignalA->CName + "+" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataAddComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	TCXArray CSignalOne, CSignalTwo;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	if(PCSignalA->CPhaseData.CX.GetSize() && PCSignalA->CMagnitudeData.CX.GetSize())
		CSignalOne = PCSignalA->CMagnitudeData * PCSignalA->CPhaseData.Cos();
	else if(PCSignalA->CMagnitudeData.CX.GetSize())
		     CSignalOne = PCSignalA->CMagnitudeData;
	 

	if(PCSignalB->CPhaseData.CX.GetSize() && PCSignalB->CMagnitudeData.CX.GetSize())
		CSignalTwo = PCSignalB->CMagnitudeData * PCSignalB->CPhaseData.Cos();
	else if(PCSignalB->CMagnitudeData.CX.GetSize())
		    CSignalTwo = PCSignalB->CMagnitudeData;

	PCSignalC->CMagnitudeData = CSignalOne + CSignalTwo;

	CSignalOne = PCSignalA->CMagnitudeData * PCSignalA->CPhaseData.Sin();

	CSignalTwo = PCSignalB->CMagnitudeData * PCSignalB->CPhaseData.Sin();

	PCSignalC->CPhaseData = CSignalOne + CSignalTwo;

	PCSignalC->already_polar = false;//ahmmm

	PCSignalC->RectangulerToPolar();

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
	//	PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
	//	PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();
		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "+" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
	//	PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "+" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
	//	PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataAddSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	TCXArray CSignal1, CSignal2;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	CSignal1 = PCSignalA->CMagnitudeData * PCSignalA->CMagnitudeData;
	CSignal2 = PCSignalB->CMagnitudeData * PCSignalB->CMagnitudeData;

	PCSignalC->CMagnitudeData = CSignal1 + CSignal2;

	PCSignalC->CMagnitudeData = PCSignalC->CMagnitudeData.Sqrt();


	CSignal1 = PCSignalA->CPhaseData * PCSignalA->CPhaseData;
	CSignal2 = PCSignalB->CPhaseData * PCSignalB->CPhaseData;

	PCSignalC->CPhaseData = CSignal1 + CSignal2;

	PCSignalC->CPhaseData = PCSignalC->CPhaseData.Sqrt();

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;

	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;
		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "+" + PCSignalB->CName +")";
	
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "+" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "+" + PCSignalB->CName;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;
		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "+" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataSubtractReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData	= PCSignalA->CMagnitudeData - PCSignalB->CMagnitudeData;
	PCSignalC->CPhaseData		= PCSignalA->CPhaseData - PCSignalB->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;

	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();
			
		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "-" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "-" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}

	return true;
}
bool TCWaveformDataRuns::SetupMathFunctionDataSubtractComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	TCXArray CSignalOne, CSignalTwo;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	if(PCSignalA->CPhaseData.CX.GetSize() && PCSignalA->CMagnitudeData.CX.GetSize())
		CSignalOne = PCSignalA->CMagnitudeData * PCSignalA->CPhaseData.Cos();
	else if(PCSignalA->CMagnitudeData.CX.GetSize())
		     CSignalOne = PCSignalA->CMagnitudeData;
	 

	if(PCSignalB->CPhaseData.CX.GetSize() && PCSignalB->CMagnitudeData.CX.GetSize())
		CSignalTwo = PCSignalB->CMagnitudeData * PCSignalB->CPhaseData.Cos();
	else if(PCSignalB->CMagnitudeData.CX.GetSize())
		    CSignalTwo = PCSignalB->CMagnitudeData;

	PCSignalC->CMagnitudeData = CSignalOne - CSignalTwo;

	CSignalOne = PCSignalA->CMagnitudeData * PCSignalA->CPhaseData.Sin();

	CSignalTwo = PCSignalB->CMagnitudeData * PCSignalB->CPhaseData.Sin();

	PCSignalC->CPhaseData = CSignalOne - CSignalTwo;

	PCSignalC->already_polar = false;//ahmmm

	PCSignalC->RectangulerToPolar();

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;
		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "-" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "-" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;
		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;;
	}

	return true;
}
bool TCWaveformDataRuns::SetupMathFunctionDataSubtractSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	TCXArray CSignal1, CSignal2;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	CSignal1 = PCSignalA->CMagnitudeData * PCSignalA->CMagnitudeData;
	CSignal2 = PCSignalB->CMagnitudeData * PCSignalB->CMagnitudeData;

	PCSignalC->CMagnitudeData = CSignal1 - CSignal2;

	PCSignalC->CMagnitudeData = PCSignalC->CMagnitudeData.Sqrt();


	CSignal1 = PCSignalA->CPhaseData * PCSignalA->CPhaseData;
	CSignal2 = PCSignalB->CPhaseData * PCSignalB->CPhaseData;

	PCSignalC->CPhaseData = CSignal1 - CSignal2;

	PCSignalC->CPhaseData = PCSignalC->CPhaseData.Sqrt();

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "-" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "-" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "-" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "-" + PCSignalB->CName;;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataDivideReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData = PCSignalA->CMagnitudeData / PCSignalB->CMagnitudeData;

	PCSignalC->CPhaseData = PCSignalA->CPhaseData / PCSignalB->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "/" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "/" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "/" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "/" + PCSignalB->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "/" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}

	return true;
}
bool TCWaveformDataRuns::SetupMathFunctionDataDivideComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData = PCSignalA->CMagnitudeData / PCSignalB->CMagnitudeData; 
	
	if(PCSignalB->CPhaseData.CX.GetSize())
		PCSignalC->CPhaseData = PCSignalA->CPhaseData - PCSignalB->CPhaseData; 
	else PCSignalC->CPhaseData = PCSignalA->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "/" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "/" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "/" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "/" + PCSignalB->CName +")";
	
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "/" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "/" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataDivideSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	return SetupMathFunctionDataDivideReal(COutputWaveformDataHeader, run_index,  index);
}

bool TCWaveformDataRuns::SetupMathFunctionDataMultiplyReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData	= PCSignalA->CMagnitudeData * PCSignalB->CMagnitudeData;
	PCSignalC->CPhaseData		= PCSignalA->CPhaseData * PCSignalB->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "*" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "*" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "*" + PCSignalB->CName +")";
	
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "*" + PCSignalB->CName +")";
	
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "*" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataMultiplyComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData = PCSignalA->CMagnitudeData * PCSignalB->CMagnitudeData; 
	
	if(PCSignalB->CPhaseData.CX.GetSize())
		PCSignalC->CPhaseData = PCSignalA->CPhaseData + PCSignalB->CPhaseData; 
	else PCSignalC->CPhaseData = PCSignalA->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "*" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "*" + PCSignalB->CName;

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();
		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "*" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();
		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "*" + PCSignalB->CName +")";
	
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "*" + PCSignalB->CName;

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "*" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataMultiplySquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	return SetupMathFunctionDataMultiplyReal(COutputWaveformDataHeader, run_index, index);
}

bool TCWaveformDataRuns::SetupMathFunctionDataPowerReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	PCSignalC->CMagnitudeData = PCSignalA->CMagnitudeData ^ PCSignalB->CMagnitudeData;
	PCSignalC->CPhaseData = PCSignalA->CPhaseData ^ PCSignalB->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "^" + PCSignalB->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "^" + PCSignalB->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "^" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "^" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName + "*" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "^" + PCSignalB->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName + "*" + PCSignalB->CName +")";

		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "^" + PCSignalB->CName;
	}

	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_GROUP_DELAY)
	{
		;
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
		PCSignalC->CPhaseData		= PCSignalC->CPhaseData;

		CSignal.CCalculatorNameMagnitude = PCSignalA->CName + "^" + PCSignalB->CName;
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName + "^" + PCSignalB->CName;
	}

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataPowerComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{// to do
	SetupMathFunctionDataPowerReal(COutputWaveformDataHeader, run_index, index);


	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionDataPowerSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{// to do
	SetupMathFunctionDataPowerReal(COutputWaveformDataHeader, run_index, index);

	return true;
}

bool TCWaveformDataRuns::SetupMathFunctionNone(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index)
{
	TCSignal *PCSignalA, *PCSignalB, *PCSignalC;

	TCXArray CSignalOne, CSignalTwo;

	if(!SetupMathSignals(COutputWaveformDataHeader, run_index, index, &PCSignalA, &PCSignalB, &PCSignalC)) return false;

	int x_axis = COutputWaveformDataHeader.axis_index;

	CArray <TCSignal, TCSignal &> &CSignals = *COutputWaveformDataHeader.PCSignals;

	TCSignal &CSignalXA = CSignals[x_axis];// get axis data

	PCSignalC->CMagnitudeData = PCSignalA->CMagnitudeData;
	PCSignalC->CPhaseData = PCSignalA->CPhaseData;

	TCMathFunctionData &CMathFunctionData = CMathFunctionDataList[index];
	
	int size = CSignals.GetSize();

	if(CMathFunctionData.a_signal < 0) return false;

	if(!(CMathFunctionData.a_signal < size)) return false;

	TCSignal &CSignal = CSignals[CMathFunctionData.a_signal];

	CSignal.CCalculatorNameMagnitude = PCSignalA->CName;
	CSignal.CCalculatorNamePhase	 = PCSignalA->CName;

	if(CMathFunctionData.function_operator == E_MATH_FUNCTION_HALF)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData * 0.5;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;
		CSignal.CCalculatorNameMagnitude = PCSignalA->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_20DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB20Log10();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB20Log10();

		CSignal.CCalculatorNameMagnitude = "db("+ PCSignalA->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_10DB)
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData.DB10Log();
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData.DB10Log();

		CSignal.CCalculatorNameMagnitude = "db10("+ PCSignalA->CName +")";
		CSignal.CCalculatorNamePhase	 = PCSignalA->CName;
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_GROUP_DELAY)
	{
		PCSignalC->CMagnitudeData =  PCSignalA->CMagnitudeData.Derivative(CSignalXA.CMagnitudeData);

		PCSignalC->CPhaseData	=   PCSignalA->CPhaseData.Derivative(CSignalXA.CMagnitudeData);

		PCSignalC->CPhaseData = PCSignalC->CPhaseData/360;//  3.141592654;

		CSignal.CCalculatorNameMagnitude = "d/dt(" + PCSignalA->CName +")";
		CSignal.CCalculatorNamePhase	 = "Group delay(" + PCSignalA->CName +")";
	}
	else if(CMathFunctionData.function_operator == E_MATH_FUNCTION_REIMJ)// TO DO
	{
		TCXArray CXArrayTemp;

		CXArrayTemp = PCSignalA->CPhaseData / 6.28318507179;// convert to radians

		PCSignalC->CMagnitudeData = PCSignalA->CMagnitudeData * CXArrayTemp.Cos();

		PCSignalC->CPhaseData = PCSignalA->CMagnitudeData * CXArrayTemp.Sin();

		CSignal.CCalculatorNameMagnitude = "Re(" + PCSignalA->CName +")";
		CSignal.CCalculatorNamePhase	 = "Imj(" + PCSignalA->CName +")";
	}
	else
	{
		PCSignalC->CMagnitudeData	= PCSignalC->CMagnitudeData;
//		PCSignalC->CPhaseData		= PCSignalC->CPhaseData * 0.5;
		CSignal.CCalculatorNameMagnitude = PCSignalA->CName;
	}

	return true;
}