
#ifndef _TCOutputWaveformData_H
#define _TCOutputWaveformData_H

#include <afxtempl.h>
#include "TCXYArray.h"

class TCSuperSpiceDoc;
class TCTestPointData;
class TCOutputWaveformData;
class TCReRun;

enum TE_SPICE_RECORD_TYPE
{
	E_SPICE_RECORD_DC = 0,
	E_SPICE_RECORD_AC,
	E_SPICE_RECORD_NOISE_SPECTRAL,
	E_SPICE_RECORD_TRANSIENT,
	E_SPICE_RECORD_FOURIER,
	E_SPICE_RECORD_THD,
	E_SPICE_RECORD_IMD,
	E_SPICE_RECORD_DISTORTION_IMD_2F,
	E_SPICE_RECORD_SENSITIVITY,
	E_SPICE_RECORD_POLE_ZERO,
	E_SPICE_RECORD_TIME_TO_FREQ_FFT,	// to do
	E_SPICE_RECORD_FREQ_TO_TIME_FFT,	// to do
	
	E_SPICE_RECORD_MATH_0,

	E_SPICE_RECORD_OPERATING_POINT,
	E_SPICE_RECORD_NOISE_INTEGRATED,

	E_SPICE_RECORD_NULL,

	E_SPICE_RECORD_SIZE,
};

enum TE_MATH_OPERATOR_TYPE
{
	E_MATH_OPERATOR_NONE,
	E_MATH_OPERATOR_ADD,
	E_MATH_OPERATOR_SUBTRACT,
	E_MATH_OPERATOR_MULTIPLY,
	E_MATH_OPERATOR_DIVIDE,
	E_MATH_OPERATOR_POWER,

	E_MATH_OPERATOR_MAX,
};

enum TE_WAVEFORM_ANALYSIS_TYPE
{
	E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN,
	E_WAVEFORM_ANALYSIS_IMPEDANCE,
	E_WAVEFORM_ANALYSIS_POWER,
};

class TCGainPhaseMargin : public CObject
{
	public: TCGainPhaseMargin(void);
			TCGainPhaseMargin(TCGainPhaseMargin &CGainPhaseMargin);
			~TCGainPhaseMargin(void);

			double max_phase;
			double min_phase;
			double max_mag;
			double min_mag;

			CString CMaxPhaseName;
			CString CMinPhaseName;
			CString CMaxMagName;
			CString CMinMagName;

			void operator = (TCGainPhaseMargin &CGainPhaseMargin);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCGainPhaseMargin)

};

class TCWaveformAnalyisisData : public CObject
{
	public:	TCWaveformAnalyisisData(void);
			TCWaveformAnalyisisData(TCWaveformAnalyisisData &CBlank);
			~TCWaveformAnalyisisData(void);

			CString CLoopGainSource;
			CString CLoopGainInputNode;
			CString CLoopGainOutputNode;

			int		ac_analysis_type;
			bool	plot_ac_analysis;
			double  phase_zero;
			double  phase_margin;
			double  gain_margin;
			double  unity_gain_frequency;
			double	zero_phase_frequency;
			double  low_frequency_gain;

			bool	trans_frequency_enable;
			double	trans_frequency;
			double  trans_xing_level;
			unsigned int trans_xing_first_count;
			unsigned int trans_xing_last_count;
			int		trans_xing_sign;
			CString CTransFrequencySignalName;
			double  trans_first_time;
			double  trans_last_time;

			CString CPulseMeasureSignal;
			CString CPulseReferanceSignal;
			CString CPulseRunSelect;
			int		pulse_enable;
			double	pulse_max_level;
			double	pulse_mid_level;
			double	pulse_min_level;
			int		pulse_xing_count;
			int		pulse_ref_xing_count;

			double	pulse_rise_xing_time;
			double	pulse_rise_time;
			
			double	pulse_fall_xing_time;
			double	pulse_fall_time;

			int		pulse_width_polarity;
			double	pulse_width_mid_time;
			double  pulse_width;
			double	pulse_period;
			double	pulse_delay;
			double	pulse_time;

			CString CPowerVoltName;
			CString CPowerCurrentName;
			CString CPowerDeviceName;
			CString CPowerRunSelect;
			double	power_value;
			double  power_temperture;
			double  power_rtheata;
			double	power_start;
			double	power_end;
			int		power_enable;

			CString CRMSSignalName;
			CString CRMSRunSelect;
			double	rms_value;
			double	rms_pk_value;
			double	rms_av_value;
			double	rms_ripple_value;
			double	rms_start;
			double	rms_end;
			int		rms_enable;

			CString  CNoiseReportFrequencyList;

			void operator = (TCWaveformAnalyisisData &CWaveformAnalyisisData);
			void operator = (TCReRun &CReRun);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCWaveformAnalyisisData)

};

class TCMathOperatorTypeData
{
	public:	TCMathOperatorTypeData();
			~TCMathOperatorTypeData(){};

			 CArray<CString, CString> CMathOperatorTypeList;

};



class TCMathFunctionData : public CObject
{
	public:	TCMathFunctionData(void);
			TCMathFunctionData(TCMathFunctionData &CMathFunctionData);
			~TCMathFunctionData(void);

			int function_operator;
			int signals_ab_operator;
			int a_signal;
			int b_signal;
			int magnitude;
			int phase;
			int calculator_enabled;
			int record_index;
			int last_graphic_type;


			void operator = (TCMathFunctionData &CMathFunctionData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCMathFunctionData)

};

enum TE_MATH_FUNCTION_TYPE// have precoded, most used functions already available
{
	E_MATH_FUNCTION_NO_UNITS,		// unitless gain
	E_MATH_FUNCTION_20DB,	
	E_MATH_FUNCTION_10DB,			// power in 10log vi
	E_MATH_FUNCTION_HALF,			// for displaying unmodified signal
	E_MATH_FUNCTION_GROUP_DELAY,
	E_MATH_FUNCTION_REIMJ,

	TE_MATH_FUNCTION_MAX,
};

class TCMathFunctionTypeData
{
	public:	TCMathFunctionTypeData();
			~TCMathFunctionTypeData(){};

			CArray<CString, CString> CMathFunctionTypeList;

};

enum TE_WAVEFORM_IDS
{
	E_WAVEFORM_XAXIS = 0,//location in CSchematicObjectData.CSymbolData.CData[]
	E_WAVEFORM_YAXIS,

};

enum TE_SPICE_SIGNAL_TYPE
{
	E_SPICE_SIGNAL_X_VARIABLE,
	E_SPICE_SIGNAL_NET_NAME,
	E_SPICE_SIGNAL_DEVICE_VOLTAGE,
	E_SPICE_SIGNAL_DEVICE_CURRENT,
};

class TCSignal;
class TCFloatingCursorData;

enum TE_TESTPOINT_TYPES// set by tab order
{
	E_TESTPOINT_VMAG,
	E_TESTPOINT_VDB,
	E_TESTPOINT_VPHDEGS,
	E_TESTPOINT_VPRADS,
	E_TESTPOINT_MAGDEGS,
	E_TESTPOINT_MAGDBDEGS,
	E_TESTPOINT_MAGPHRADS,
	E_TESTPOINT_MAGDBRAD,
};

class TCSignal : public CObject
{
	public:	TCSignal(void);
			TCSignal(TCSignal &CSignal);
			~TCSignal(void);

			CString			CName;
			CString			CXType;
			CString			CYType;
			CString			CCalculatorNameMagnitude;
			CString			CCalculatorNamePhase;
			TCXArray		CMagnitudeData;
			TCXArray		CPhaseData;

			CArray <int, int>	GraphPointToMagDataIndex;

			int			magnitude_and_phase_type;
			int			f_first;
			void		SetMagnitudeAndPhaseType(int record_type, CString CText);

			double		x_gain;
			double		y_gain;
			double		x_offset;
			double		y_offset;

			double		y_phase_gain;
			double		y_phase_offset;

			double		points_per_float;
			long		min_points;		// should have had another class
			long		max_points;
			double		phase_points_per_float;
			long		min_phase_points;
			long		max_phase_points;

			COLORREF	normal_phase_colour;
			COLORREF	selected_phase_colour;
			COLORREF	highlighted_phase_colour;

			COLORREF	normal_colour;
			COLORREF	selected_colour;
			COLORREF	highlighted_colour;
			int			style;

			int			magnitude;// or dbmagnitude
			int			phase;// deg or radians
			int			phase_axis;


			int			type;//current, volt, xvariables
			int			already_polar;
			int			rectangular;

			int			stop_point;
			int			start_point;
			int			graphic_stop_point;

			bool		SetName(CString CText);
			int			AddData(CString CText, int index, int type);
			int			AddBinaryData(double data1, double data2, int index, int type);

			bool		SetMagnitudeScaleFactors(unsigned short size,bool auto_scale, double max, double min, int loged, int num_ticks);
			bool		SetPhaseScaleFactors(unsigned short size, bool auto_scale,  double max, double min, int loged, int num_ticks);

			long		GetDataPoint(int p, int type);
			long		GetDataPoint(int p, int type, double &gain, double &offset);
			long		GetLogDataPoint(int p, int type);
			long		GetLogDataPoint(int p, int type, double &gain, double &offset);

			double		GetDataValue(long data, int type);
			double		GetDataValue(long data, int type, double gain, double offset);
			double		GetAntiLogDataValue(long data, int type);
			double		GetAntiLogDataValue(long data, int type, double gain, double offset);
			double		GetDataValue(int index, int type);

			void		CopyScaleFactors(TCSignal &CSignal);
			void		RectangulerToPolar(int index);
			void		PolarToRectanguler(int index);
			void		RectangulerToPolar(void);
			void		PolarToRectanguler(void);
			int			GetXAxisType(void);
			void		MakePhaseContinuous(void);

			void		FormatGraphPointToMagDataIndex(long start, long stop);
			void		ClearGraphPointToMagData(void);

			void DisplayError(CString CDescription, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, int msg, int error_code = -1);

			TCSuperSpiceDoc *PCDoc;

			void operator = (TCSignal &CSignal);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSignal)

};

class TCDisplayedSignals
{
	public:		
			TCDisplayedSignals();
			void TCSignalEnables(TCDisplayedSignals &CDisplayedSignals);
			~TCDisplayedSignals(){};

			TCSignal  *PCSignal1; // for impedences etc
			TCSignal  *PCSignalX;

			int index1;

			int	type;// Mag or phase, z etc
			int magnitude;
			int phase;

			void operator = (TCDisplayedSignals &CDisplayedSignals);
};

class TCOutputWaveformDataRecord;
class TCWaveformDataRuns;

class TCSignalEnables : public CObject
{
	public:

	TCSignalEnables(void);
	TCSignalEnables(TCSignalEnables &CSignalEnables);
	~TCSignalEnables(void);
	void operator = (TCSignalEnables &CSignalEnables);

	int magnitude;
	int phase;

	DECLARE_SERIAL(TCSignalEnables)
};

class TCOutputWaveformDataHeader : public CObject
{
	public:	TCOutputWaveformDataHeader(void);
			TCOutputWaveformDataHeader(TCOutputWaveformDataHeader &COutputWaveformDataHeader);
			~TCOutputWaveformDataHeader(void);

			int		index;
			CString CTitle;
			CString CDateAndTime;
			CString CPlotName;
			CString CFlags;
			CString CNumberOfVariables;
			CString CNumberOfPoints;
			CString CCommand;
			CString CVariable;
			
			CArray <CString, CString> CVariables;
			CString CBinaryOrValues;
			void operator = (TCOutputWaveformDataHeader &COutputWaveformDataHeader);
	
			int		type;//AC, DC etc
			CArray <TCSignal, TCSignal&> *PCSignals;
			CArray <TCDisplayedSignals, TCDisplayedSignals&> CDisplayedSignalsList;
			CArray <TCSignalEnables, TCSignalEnables&> CSignalEnablesList;

			CString  CFileName;
			CString  CAxisName;
			CString  CDataType;
			COLORREF axis_normal_colour;
			COLORREF axis_selected_colour;
			COLORREF axis_highlighted_colour;
			COLORREF grid_colour;
			COLORREF background_colour;
			int		f_first;
			int		magnitude_db;

			int		x_major_grid_size;
			int		x_minor_grid_size;
			int		x_major_grid_number;
			int		x_minor_grid_number;
			int		x_grid_decades;
			int		x_manual;
			double	x_mag_div;
			double	x_max;
			double	x_min;

			int		y_major_grid_size;
			int		y_minor_grid_size;
			int		y_major_grid_number;
			int		y_minor_grid_number;
			int		y_grid_decades;
			int		y_manual;
			double	y_mag_div;
			double	y_max;
			double	y_min;

			int		y_phase_major_grid_size;
			int		y_phase_minor_grid_size;
			int		y_phase_major_grid_number;
			int		y_phase_minor_grid_number;
			int		y_phase_grid_decades;
			int		y_phase_manual;
			double	y_phase_div;
			double	y_phase_min;
			double	y_phase_max;

			int		x_manual_major_grid_number;
			int		y_manual_major_grid_number;
			int		y_manual_phase_major_grid_number;
			int		x_manual_minor_grid_number;
			int		y_manual_minor_grid_number;
			int		y_manual_phase_minor_grid_number;
			
			int		signal_index;
			int		axis_index;

			int		multy_magnitude_axis;
			int		multy_phase_axis;

			int		active_magnitude_axis_index;
			int		active_phase_axis_index;
			TCSuperSpiceDoc *PCDoc;

			int		inteligent_signal_default;
			int		inteligent_signal_magnitude;
			int		inteligent_signal_phase;
	
			//run support
			
			int		run_selected;
			int		real_and_imaginary;
			int		select_all_runs;
			int		run_index;			//works easier to put this data here
			//run support

			double signal_mag_max;
			double signal_mag_min;
			double signal_phase_max;
			double signal_phase_min;

			TCWaveformDataRuns *PCWaveformDataRuns;

			CRect CZoomRectangle;

			bool	SetType(void);
			int		GetNumberOfDisplayedSignals(void);
			bool	IsAnyMagnitudesDisplayed(void);
			bool	IsAnyPhaseDisplayed(void);
			void	CreateListOfDisplayedSignals(void);
			int		GetFirstDisplayedSignal(void);
			bool	SetScaleFactors(unsigned short width, unsigned short height);
			bool    ValidateSignal(TCSignal *PCSignal);

			bool	GetMagnitudeMaxMin(double &max, double &min);
			bool	GetPhaseMaxMin(double &max, double &min);

			bool	_GetMagnitudeMaxMin(double &max, double &min);
			bool	_GetPhaseMaxMin(double &max, double &min);

			void	CopyScaleFactors(TCOutputWaveformDataHeader &CHeader);
			void	SetupXGridCounts(unsigned short width);
			void	SetupYMagGridCounts(unsigned short height);
			void	SetupYPhaseGridCounts(unsigned short height);
			void	SetupXAutoMajorMinorCounts(void);
			void	SetupYMagnitudeAutoMajorMinorCounts(void);
			void	SetupYPhaseAutoMajorMinorCounts(void);

			CString	GetDataTextXValue(long position);
			CString	GetDataTextYValue(long position, int is_yphase);
			double   GetDataYValue(long position, int is_yphase);
			double   GetDataXValue(long position);
			void	WaveformZoom(CRect CZoomRect);
			void   SyncAllRuns(void);
			void   AllWaveformZoom(CRect CZoomRect);

			int		FindXIndex(double value);
			int		FindXIndex(int value);
			bool	ChangeWaveform(TCTestPointData &CTestPointData);
			bool	ChangeColour(TCTestPointData &CTestPointData);
			bool	ClearAllWaveforms(void);
			bool	SaveAsText(CString CRunNumber, CString CRunName);
			bool	SaveTranNodeSet(CString CRunName);
			int		FindSignal(CString CSignalName);
			void    ClearAllSignals(void);
			void	SetDisplayedSignals(TCOutputWaveformDataHeader &CHeader);
			bool	IsSpice3SubcircuitTypeName(CArray <TCSignal, TCSignal&> &CSignals);

			bool	IsBadSignalsPointer(void);
			bool	IsBinary(void);

			void Serialize(CArchive& CArchiveFile);
			void DisplayError(CString CDescription, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, int msg, int error_code = -1);

			void ScaleGrid(unsigned short *width, unsigned short *height);

			void SetupFFTHeader(TCOutputWaveformData &COutputWaveformData);

			void ComputeFFT(TCOutputWaveformDataHeader &CDataHeaderSource);

			DECLARE_SERIAL(TCOutputWaveformDataHeader)

};

enum TE_SIGNAL_DISPLAY_TYPE
{
	TE_SIGNAL_DISPLAY_MAGNITUDE = 0,
	TE_SIGNAL_DISPLAY_DB_MAGNITUDE,
	TE_SIGNAL_DISPLAY_PHASE_DEG,
	TE_SIGNAL_DISPLAY_PHASE_RADIANS,
};


class TCOutputWaveformDataRecord : public CObject
{
	public:	TCOutputWaveformDataRecord(void);
			TCOutputWaveformDataRecord(TCOutputWaveformDataRecord &COutputWaveformDataRecord);
			~TCOutputWaveformDataRecord(void);
		
			TCOutputWaveformDataHeader		CHeader;
			CArray <TCSignal, TCSignal&>	CSignals;// v1, v2 q1[ic] etc
			TCSuperSpiceDoc *PCDoc;

			double m_y_mag_reruns;
			double m_y_phase_reruns;

			void operator = (TCOutputWaveformDataRecord &COutputWaveformDataRecord);

			void ClearMathFunctionData(int record_index);
	
			void Serialize(CArchive& CArchiveFile);
			void DisplayError(CString CDescription, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, int msg, int error_code = -1);

			void CopySignalEnables(int destination, int source);

			void ComputeFFT(TCOutputWaveformDataHeader &CDataHeaderDestination, TCOutputWaveformDataHeader &CDataHeaderSource);

			DECLARE_SERIAL(TCOutputWaveformDataRecord)

};

class TCIFStream;
class ofstream;
class TCOutputWaveformDoc;
class TCLoadDataProgressDlg;

class TCOutputWaveformData : public CObject
{
	public:	TCOutputWaveformData(void);
			TCOutputWaveformData(TCOutputWaveformData &COutputWaveformData);
			~TCOutputWaveformData(void);

			CString CFileName;
			CString	CRunDiscription;
			CArray <CString, CString&> CRunType;

			bool	m_binary;
			TCSuperSpiceDoc *PCDoc;
			int current_active_analysis_type;
			int m_peek_increment;
			int m_linearize_transient_data;
			TCOutputWaveformDoc *PCMOutputWaveformDoc;
			bool fm_open_waveform_graph;
			int  m_run_number;
			int  m_last_signal_end_point;
			int  m_last_points_end_point;
			int  m_marching_waveform_type;

			//Data for whole file split up to each type, AC,DC, NOISE etc
			CArray<TCOutputWaveformDataRecord, TCOutputWaveformDataRecord&> CRecords;

			TCWaveformAnalyisisData CMWaveformAnalyisisData;

			void ComputeFFT(int dest_type, int source_type);

			void operator = (TCOutputWaveformData &COutputWaveformData);
	
			void Serialize(CArchive& CArchiveFile);

			void LoadInit(CString CFileName, TCWaveformDataRuns *PCWaveformDataRuns);
			void ClearAllData(void);
			void SetupRecords(TCWaveformDataRuns *PCWaveformDataRuns);
			int OpenFile(TCIFStream &CFileStream, CString CFileName, TCSuperSpiceDoc *PCParentDoc, TCWaveformDataRuns *PCWaveformDataRuns = NULL, int run_number = 0);
			void ResetRecordSignalPointers(void);

			void UpdateMarchingWaveforms(int index, TCSignal &CSignal, int end_point);
			void SetupMarchingWaveforms(int index, TCSignal &CSignal, int end_point);

			int ReadNextHeader(TCIFStream &CFileStream, int default_size);
			int ReadNextBinaryData(TCIFStream &CFileStream, int index);
			int ReadNextTextData(TCIFStream &CFileStream, int index);
			int ReadNextData(TCIFStream &CFileStream);
			int GrowDataSize(void);
			void ReadDataEnded(int status = false);
			void RemoveDublicateSignals(void);
			void SetDCSweepAxisName(void);
			void DisplayLoadingStatus(int p, int num_points);
			void LinearizeTransientData(void);
			void GenerateIntegratedNoiseData(void);
			bool GenerateACAnalysisData(void);
			bool GenerateTransientFrequencyData(void);
			bool GenerateGainAndPhaseMargin(CString CSignalName, TCWaveformAnalyisisData &CWaveformAnalyisisData);

			bool GeneratePulseRise(TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool GeneratePulseFall(TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool GeneratePulseWidth(TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool GeneratePulsePeriod(TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool GeneratePulseDelay(TCWaveformAnalyisisData &CWaveformAnalyisisData);

			bool GeneratePower(TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool GenerateTransientAverages(TCWaveformAnalyisisData &CWaveformAnalyisisData);

			double GetNextLinearYValue(int signal_points_count, int &next_time_position, double next_time, CArray <double, double&>  &CSignalOrigSrc, CArray <double, double&> &CSignalOrigX);

			void SetupSignalTypes(int index);

			bool Load(TCIFStream &CFileStream, CString CName, TCWaveformAnalyisisData &CWaveformAnalyisisData, int default_size);
			bool Load(CString CName, TCWaveformDataRuns *PCWaveformDataRuns, TCSuperSpiceDoc *PCParentDoc, TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool Save(CString CName);
		
			bool LoadData(CString CName);
			bool SaveData(CString CName);

			bool IsWaveformHeaderAvailable(int id);
			bool AreWaveformsAvailable(void);
			bool AreAnySignalsEnabled(int id);
			void GenerateNewDefaultWaveformColours(TCOutputWaveformDataRecord &CRecord, int start_index);

			bool WaitUntillSpiceEngineFinishesWriting(void);

			int GetWaveFormHeaderIndex(int type_id);
			void CopySignalEnables(int destination, int source);
			int GetFirstEnabledSignalsType(void);

			bool CreateMultiPlots(int index, CString CSignalName, double x);
						
			
			int GetFirstActiveAnalysisType(void);
			int GetNextActiveAnalysisType(void);
			int PeekNextActiveAnalysisType(void);
			int PeekIncrementActiveAnalysisType(void);

			void DisplayError(CString CDescription, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, CString CErrorMsg, int error_code = -1);
			void DisplayError(int des, int msg, int error_code = -1);

			DECLARE_SERIAL(TCOutputWaveformData)

};


class TCWaveformDataRuns : public CObject
{
	public:	TCWaveformDataRuns(void);
			TCWaveformDataRuns(TCWaveformDataRuns &CWaveformDataRuns);
			~TCWaveformDataRuns(void);

			CArray <TCOutputWaveformData*, TCOutputWaveformData*> CRuns;

			TCWaveformAnalyisisData CMWaveformAnalyisisData;

			CArray <TCMathFunctionData, TCMathFunctionData&> CMathFunctionDataList;
			
			void RealignHeaderSignalPointers(void);
			void ComputeFFT(TCOutputWaveformDataHeader &CDataHeaderDestination, TCOutputWaveformDataHeader &CDataHeaderSource);
			void ComputeFFTs(void);
			bool IsAnyMagnitudesDisplayed(int index);
			bool IsAnyPhaseDisplayed(int index);
			int CalculateFFTOnLoad(void);

			bool SetupMathFunctionData(void);
			bool SetupMathFunctionData(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index);
			bool SetupMathFunctionDataAdd(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataSubtract(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index); 
			bool SetupMathFunctionDataMultiply(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataDivide(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index); 
			bool SetupMathFunctionDataPower(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataNone(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);

			bool SetupMathFunctionDataAddReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataAddComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataAddSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);

			bool SetupMathFunctionDataSubtractReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataSubtractComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataSubtractSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);

			bool SetupMathFunctionDataDivideReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataDivideComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataDivideSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);

			bool SetupMathFunctionDataMultiplyReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataMultiplyComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataMultiplySquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);

			bool SetupMathFunctionDataPowerReal(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataPowerComplex(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);
			bool SetupMathFunctionDataPowerSquares(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);

			bool SetupMathFunctionNone(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index);


			bool SetupMathSignals(TCOutputWaveformDataHeader &COutputWaveformDataHeader, int run_index, int index, 
								  TCSignal **PCSignalA, TCSignal **PCSignalB, TCSignal **PCSignalC);


			void CopyData(TCOutputWaveformDataHeader &CDataHeaderDestination, TCOutputWaveformDataHeader &CDataHeaderSource);
			
			CString	CRunDiscription;
			TCSuperSpiceDoc *PCDoc;
			int m_last_runs_count;

			bool Load(CString CBaseName, int number_of_runs, TCSuperSpiceDoc *PCParentDoc, TCWaveformAnalyisisData *PCWaveformAnalyisisData, int mode);
			bool Load(TCSuperSpiceDoc *PCParentDoc);
			void Load(TCWaveformDataRuns &CWaveformDataRunsSource);
			void DeleteOldFiles(int old_number_of_runs);

			bool Save(CString CBaseName, int mode);
			bool Save(void);
			int  Add(void);
			int  SetSize(int size, int alloc_size = 8);
			void Delete(void);
			bool GetMagnitudeMaxMin(TCOutputWaveformDataHeader **PCHeaderMax, TCOutputWaveformDataHeader **PCHeaderMin, int index, double &dmax, double &dmin);
			bool GetPhaseMaxMin(TCOutputWaveformDataHeader **PCHeaderMax, TCOutputWaveformDataHeader **PCHeaderMin, int index, double &dmax, double &dmin);
			bool SetAllMaxMin(void);
			void CreateAllListsOfDisplayedSignals(void);
			void CreateListsOfDisplayedSignals(TCOutputWaveformDataHeader *PCHeader);
			bool SetDefaultDisplayedSignals(void);

			void SetScaleFactors(unsigned short width, unsigned short height, int type, double zoom);

			void CopyAllRunHeaders(TCWaveformDataRuns &CWaveformDataRuns, int type);
			TCOutputWaveformDataHeader *GetHeader(TCOutputWaveformDataHeader *PCHeader, int run_index);

			bool GetData(TCFloatingCursorData &CFloatingCursorData);
			bool _GetDataPhase(TCFloatingCursorData &CFloatingCursorData);
			bool ChangeWaveform(TCOutputWaveformDataHeader *PCHeader, TCTestPointData &CTestPointData);
			bool ChangeColour(TCOutputWaveformDataHeader *PCHeader, TCTestPointData &CTestPointData);
			bool ChangeBKGColour(TCOutputWaveformDataHeader *PCHeader, int colour); // Add Dec 2018
			bool ClearAllWaveforms(TCOutputWaveformDataHeader *PCHeader);

			void DisplayError(CString CDescription, CString CErrorMsg, int error_code = -1);

			void operator = (TCWaveformDataRuns &CWaveformDataRuns);

			void CopySignalEnables(int destination, int source);
			int GetFirstEnabledSignalsType(int &run_index);

			bool SaveAsText(CString CFileName);
			bool SaveTranNodeSet(CString CFileName);
			bool CreateDCOperatingPointReport(CString CFileName);
			bool CreateDCSweepReport(CString CFileName);
			bool CreateACSweepReport(CString CFileName);
			bool CreateTransientSweepReport(CString CFileName);
			bool CreateTransientAveragesReport(CString CFileName, TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool CreatePulseAnalysisReport(CString CFileName, TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool CreateNoiseReport(CString CFileName, TCWaveformAnalyisisData &CWaveformAnalyisisData);
			bool CalculateLoopGain(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculateTransientFrequency(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool GetMinMaxLoopGain(TCGainPhaseMargin &CGainPhaseMargin); 

			bool CalculatePulseRise(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculatePulseFall(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculatePulseWidth(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculatePulsePeriod(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculatePulseDelay(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculatePulseData(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);

			bool CalculatePower(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CalculateTransientAverages(TCWaveformAnalyisisData &CWaveformAnalyisisData, int run);
			bool CreateMultiPlots(TCSuperSpiceDoc *PCParentDoc);

			int LoadStart(int number_of_runs, TCSuperSpiceDoc *PCParentDoc);
			int LoadEnd(int default_display);
 
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCWaveformDataRuns)

};

#endif