// TCOutputWaveformDoc.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceMainFrame.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceClipboard.h"
#include "TCSuperSpiceView.h"
#include "TCSuperSpiceDoc.h"
#include "TCWaveformGraphicsManager.h"
#include "TCOutputWaveformDoc.h"
#include "TCOutputWaveformData.h"
#include "TCOutputWaveformView.h"
#include "TCOutputWaveformDoc.h"
#include "TCAddText1.h"
#include "TCMasterWaveformPropPages.h"
#include "TCWireLableDlg.h"
#include "TCComponentText.h"
#include "TCReferanceDesignator.h"
#include "TCFloatingCursorDlg.h"
#include "TEPCBFormats.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CView *CreateNewView(CDocument *PCDocument);
WINDOWPLACEMENT GetDefaultWindowPlacment(void);
extern TCSuperSpiceClipboard GCSuperSpiceClipboard;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern CString FloatToMKSString(double data);
bool FileExists(CString &CName);

extern TCMultyTaskedString CGlobalStatusMessage;
void MultyplyCPoint(CPoint *CPosition, float multiplyer);
/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformDoc

IMPLEMENT_DYNCREATE(TCOutputWaveformDoc, CDocument)

TCOutputWaveformDoc::TCOutputWaveformDoc()
{
	PCParentSuperSpiceDoc = NULL;

	PCOutputWaveformData = new TCOutputWaveformData;

	s_window_placment = GetDefaultWindowPlacment();
	first_draw = true;

	m_current_waveform_type = E_SPICE_RECORD_NULL;
	m_waveform_type = E_SPICE_RECORD_NULL;
	m_active_list_index = 0;

	CWaveformDataRuns.SetSize(1);
}

TCSuperSpiceDoc *TCOutputWaveformDoc::GetParentSuperSpiceDoc(void)
{
	if(!PCParentSuperSpiceDoc) return NULL;

	if(IsBadReadPtr(PCParentSuperSpiceDoc, sizeof(TCSuperSpiceDoc))) 
	{
		ASSERT(0);

		PCParentSuperSpiceDoc = NULL;

		return NULL;
	}

	return PCParentSuperSpiceDoc;
}

BOOL TCOutputWaveformDoc::OnNewDocument()
{
	first_draw = true;

	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

BOOL TCOutputWaveformDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	if(CSpiceDataFileName != "")
	{// to do if doc opened outside framwork, dont wont double loading if possible
		// framework will call update
//		if(FileExists(CSpiceDataFileName)) Load(CSpiceDataFileName, false);
	}
	
	return TRUE;
}

TCOutputWaveformDoc::~TCOutputWaveformDoc()
{
	if(PCOutputWaveformData) delete PCOutputWaveformData;
}


BEGIN_MESSAGE_MAP(TCOutputWaveformDoc, CDocument)
	//{{AFX_MSG_MAP(TCOutputWaveformDoc)
	ON_COMMAND(ID_RUN_STOP, OnRunStop)
	ON_COMMAND(ID_RUN_CREATENETLIST, OnRunCreatenetlist)
	ON_COMMAND(ID_VIEW_TOP_LEVEL_FILES, OnViewTopLevelFiles)
	ON_COMMAND(ID_SETUP_SETTEMPERATURE, OnSetupSetTemperature)
	ON_COMMAND(ID_FILE_LOADSPICEDATAFILE, OnFileLoadSpiceDataFile)
	ON_COMMAND(ID_WAVEFORMS_CALCULATEFFTIFFTDATA, OnWaveformsCalculatefftifftdata)
	ON_COMMAND(ID_FILE_PCBNETLISTS_GENERIC, OnFilePcbnetlistsGeneric)
	ON_COMMAND(ID_FILE_PCBNETLISTS_ORCAD, OnFilePcbnetlistsOrcad)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATETANGO, OnFilePcbnetlistsCreatetango)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATEPROTEL, OnFilePcbnetlistsCreateprotel)
	ON_COMMAND(ID_FILE_PCBNETLISTS_PCLOGIC, OnFilePcbnetlistsPclogic)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATEEAGLE, OnFilePcbnetlistsCreateeagle)
	ON_COMMAND(ID_FILE_NEWTEXTFILE, OnFileNewTextFile)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEWTEXTFILE, OnUpdateFileNewtextfile)
	ON_COMMAND(ID_FILE_SAVEASTEXTDATAFILES, OnFileSaveastextdatafiles)
	ON_COMMAND(ID_FILE_REPORTS_DCOPERATINGPOINT, OnFileReportsDcoperatingpoint)
	ON_COMMAND(ID_VIEW_REPORTS_DCOPERATINGPOINT, OnViewReportsDcoperatingpoint)
	ON_COMMAND(ID_FILE_REPORTS_DCSWEEP, OnFileReportsDcsweep)
	ON_COMMAND(ID_VIEW_REPORTS_DCSWEEP, OnViewReportsDcsweep)
	ON_COMMAND(ID_FILE_REPORTS_CREATENOISE, OnFileReportsNoise)
	ON_COMMAND(ID_VIEW_REPORTS_NOISE, OnViewReportsNoise)
	ON_COMMAND(ID_RUN_ENABLELOOPGAIN, OnRunEnableloopgain)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLELOOPGAIN, OnUpdateRunEnableloopgain)
	ON_COMMAND(ID_FILE_REPORTS_ACSWEEP, OnFileReportsAcsweep)
	ON_COMMAND(ID_VIEW_REPORTS_ACSWEEP, OnViewReportsAcsweep)
	ON_COMMAND(ID_RUN_TERMINATEXSPICEENGINE, OnRunTerminatexspiceengine)
	ON_COMMAND(ID_GRAPH_PROBEMODE, OnGraphProbeMode)
	ON_UPDATE_COMMAND_UI(ID_GRAPH_PROBEMODE, OnUpdateGraphProbeMode)
	ON_COMMAND(ID_VIEW_ANALYSIS_LOOPGAIN, OnViewAnalysisLoopGain)
	ON_COMMAND(ID_VIEW_ANALYSIS_TRANSIENTFREQUENCY, OnViewAnalysisTransientFrequency)
	ON_COMMAND(ID_VIEW_ANALYSISSETUP, OnViewAnalysisSetup)
	ON_COMMAND(ID_VIEW_ANALYSISRESULTS_TRANSIENTPULSE, OnViewAnalysisresultsTransientpulse)
	ON_COMMAND(ID_VIEW_REPORTS_PULSEANALYSIS, OnViewReportsPulseAnalysis)
	ON_COMMAND(ID_SETUPS_XSPICEPROGRESSRATE, OnSetupsXspiceprogressrate)
	ON_COMMAND(ID_FILE_REPORTS_CREATETRANSIENTPOWER, OnFileReportsCreateTransientPower)
	ON_COMMAND(ID_VIEW_REPORTS_TRANSIENTPOWER, OnViewReportsTransientPower)
	ON_COMMAND(ID_VIEW_ANALYSISRESULTS_TRANSIENTAVERAGES, OnViewAnalysisresultsTransientAverages)
	ON_COMMAND(ID_FILE_REPORTS_CREATETRANSIENTAVERAGES, OnFileReportsCreateTransientAverages)
	ON_COMMAND(ID_VIEW_REPORTS_TRANSIENTAVERAGES, OnViewReportsTransientAverages)
	ON_COMMAND(ID_FILE_REPORTS_CREATETRANSIENTPULSE, OnFileReportsPulseAnalysis)
	ON_COMMAND(ID_RUN_PAUSECONTINUE, OnRunPauseContinue)
	ON_UPDATE_COMMAND_UI(ID_RUN_PAUSECONTINUE, OnUpdateRunPauseContinue)
	ON_COMMAND(ID_RUN_ENABLEMARCHINGWAVEFORMS, OnRunEnableMarchingWaveforms)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEMARCHINGWAVEFORMS, OnUpdateRunEnableMarchingWaveforms)
	ON_COMMAND(ID_TESTPOINTS_WIREONCLICKTESTPOINTSETUP, OnTestpointsWireonClicktestPointSetup)
	ON_COMMAND(ID_RUN_RUNASOPERATINGPOINTDESIGNER, OnRunRunasoperatingpointdesigner)
	ON_COMMAND(ID_SETUPS_DESIGNERSETUP, OnSetupsDesignersetup)
	ON_COMMAND(ID_VIEW_PARAMETERLISTRERUNFILE, OnViewParameterlistrerunfile)
	ON_COMMAND(ID_VIEW_MONTECARLORERUNFILE, OnViewMontecarlorerunfile)
	ON_COMMAND(ID_VIEW_PARAMETERLISTGENERATERFILE, OnViewParameterlistgeneraterfile)
	ON_COMMAND(ID_VIEW_MULTIPARAMETERSWEEPFILE, OnViewMultiParameterSweepFile)
	ON_COMMAND(ID_VIEW_WORSTCASERERUNFILE, OnViewWorstCaseReRunFile)
	//}}AFX_MSG_MAP

	ON_COMMAND(ID_TEST_GRAPHIC, OnDebugTest)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformDoc diagnostics

#ifdef _DEBUG
void TCOutputWaveformDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void TCOutputWaveformDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
void TCOutputWaveformDoc::OnViewOnDraw(TCOutputWaveformView *PCView, CDC* pDC)
{
	pDC;

	if(!PCView) return;
	if(!PCView->CSuperSpiceViewData.PCMSchematicManager) return;
	
	TCWaveformGraphicsManager *PCSchematicManager;
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;

	PCSchematicManager = (TCWaveformGraphicsManager *) PCView->CSuperSpiceViewData.PCMSchematicManager;

	if(first_draw)
	{
		first_draw = false;


		PCOutputWaveformView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
	}

	PCSchematicManager->DrawAll();
}

void TCOutputWaveformDoc::Print(CView *PCView, CDC *PCDC)
{
	TCWaveformGraphicsManager *PCSchematicManager;
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;

	PCSchematicManager = (TCWaveformGraphicsManager *) PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	PCSchematicManager->PrintAll(PCDC);
}

void TCOutputWaveformDoc::UpdateWaveforms(CString CFileName)
{
	CSpiceDataFileName = CFileName;

	CloseNonActiveViews();

	BeginWaitCursor();

	UpdateAndCreateWaveformViews();

//	UpdateAllViews(NULL, NULL);

	EndWaitCursor();
}

void TCOutputWaveformDoc::CloseNonActiveViews(void)
{
	TCOutputWaveformData *PCOutputWaveformDataActive = GetOutputWaveformData();

	if(!PCOutputWaveformDataActive) return;

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_display_graphics) return;

	CArray <TCOutputWaveformView *,TCOutputWaveformView *> CViewList;

	POSITION pos = GetFirstViewPosition();

	while(pos != NULL)
	{
		TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView*)GetNextView(pos);

		if(!PCOutputWaveformDataActive->IsWaveformHeaderAvailable(PCOutputWaveformView->m_current_waveform_type)) 
			CViewList.Add(PCOutputWaveformView);
	}	

	int count = CViewList.GetSize();

	for(int p = 0; p < count; p++) //close non active ones, but 1
	{
		if(GetNumberOfViews() > 1) CViewList[p]->GetParent()->DestroyWindow();
	}
}

void TCOutputWaveformDoc::UpdateAndCreateWaveformViews(void)
{
	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_display_graphics) return;
	
	TCOutputWaveformData *PCOutputWaveformDataActive = GetOutputWaveformData();
	if(!PCOutputWaveformDataActive) return;

	TCOutputWaveformView *PCOutputWaveformView = NULL;

	m_current_waveform_type = SetupActiveWaveformList();

	bool found;

	CArray <TCOutputWaveformView *,TCOutputWaveformView *> CViewList;

	bool f_first = false;

	while(m_current_waveform_type != E_SPICE_RECORD_NULL)
	{
		found = false;

		POSITION pos = GetFirstViewPosition();

		while(pos != NULL)
		{
			PCOutputWaveformView = (TCOutputWaveformView*)GetNextView(pos);

			if(!f_first)// force first view to have a vaild type.
			{
				f_first = true;

				PCOutputWaveformView->m_current_waveform_type = m_current_waveform_type;
			}

			if(PCOutputWaveformView->m_current_waveform_type != m_current_waveform_type) continue;
			
			found = true;

			PCOutputWaveformView->UpdateWaveforms(m_current_waveform_type);

			break;
		}

		if(!found)
		{
			PCOutputWaveformView = OnViewNewView(PCOutputWaveformView);

			if(PCOutputWaveformView)
			PCOutputWaveformView->UpdateWaveforms(m_current_waveform_type);
		}

		m_current_waveform_type = GetNextActiveWaveform();
	}
}

int TCOutputWaveformDoc::CalculateFFTOnLoad(void)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = PCParentSuperSpiceDoc;

	if(!PCSuperSpiceDoc) return false;

	if(!PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup) return false;

	if(!(E_TRAN_CALCULATE_FFT_ON_LOAD < PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray.GetSize())) return false;

	int flag = PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_FFT_ON_LOAD];

//	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.calculate_fft_on_load)

	return flag;
}

int TCOutputWaveformDoc::SetupActiveWaveformList(void)
{
	TCOutputWaveformData *PCOutputWaveformDataActive = GetOutputWaveformData();

	if(!PCOutputWaveformDataActive) return E_SPICE_RECORD_NULL;

	CActiveWaveFormList.SetSize(0, E_SPICE_RECORD_NULL);

	m_active_list_index = 0;

	m_current_waveform_type = PCOutputWaveformDataActive->GetFirstActiveAnalysisType();

	while(m_current_waveform_type != E_SPICE_RECORD_NULL) 
	{
		while(m_current_waveform_type == E_SPICE_RECORD_POLE_ZERO || 
			  (m_current_waveform_type == E_SPICE_RECORD_TIME_TO_FREQ_FFT) && (!CalculateFFTOnLoad()) ||
			  m_current_waveform_type == E_SPICE_RECORD_FREQ_TO_TIME_FFT  ||
			  m_current_waveform_type == E_SPICE_RECORD_OPERATING_POINT ||
			  (!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_update_calc_graph && 
			  (m_current_waveform_type == E_SPICE_RECORD_MATH_0)))
		{
			m_current_waveform_type = PCOutputWaveformDataActive->GetNextActiveAnalysisType();
		}


		if(m_current_waveform_type == E_SPICE_RECORD_NULL) break;

		CActiveWaveFormList.Add(m_current_waveform_type);

		m_current_waveform_type = PCOutputWaveformDataActive->GetNextActiveAnalysisType();
	}

	if(CActiveWaveFormList.GetSize())return CActiveWaveFormList[0];

	return E_SPICE_RECORD_NULL;
}

TCOutputWaveformView * TCOutputWaveformDoc::FindWaveformType(int type)
{
	POSITION pos = GetFirstViewPosition();

	while(pos != NULL)
	{
		TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView*)GetNextView(pos);

		if(PCOutputWaveformView->m_current_waveform_type == type) return PCOutputWaveformView;
	}

	return NULL;
}


int TCOutputWaveformDoc::GetNextActiveWaveform(void)
{
	m_active_list_index++;

	if(!(m_active_list_index < CActiveWaveFormList.GetSize())) return E_SPICE_RECORD_NULL;

	return CActiveWaveFormList[m_active_list_index];
}

bool TCOutputWaveformDoc::PeekNextActiveWaveform(void)
{
	return ((m_active_list_index + 1) < CActiveWaveFormList.GetSize());
}

int TCOutputWaveformDoc::GetNumberOfViews(void)
{
	int number =0;

	POSITION pos = GetFirstViewPosition();

	while(pos != NULL)
	{
		GetNextView(pos);

		number++;
	}

	return number;
}

void TCOutputWaveformDoc::SetTestPointData(CArray <TCTestPointData, TCTestPointData&> &CSourceTestPointDataList)
{
	int count, p;

	count = CSourceTestPointDataList.GetSize();

	CTestPointDataList.SetSize(count);

	for(p = 0; p < count; p++)
	{
		CTestPointDataList[p] = CSourceTestPointDataList[p];
	}

}


void TCOutputWaveformDoc::ChangeWaveform(TCTestPointData &CTestPointData)
{
	TCOutputWaveformView *PCOutputWaveformView;
	TCWaveformGraphicsManager *PCSchematicManager;
	
	POSITION pos = GetFirstViewPosition();

	AfxGetApp()->BeginWaitCursor();

	while (pos != NULL)
	{
		PCOutputWaveformView = (TCOutputWaveformView *)GetNextView(pos);

		PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

		if(!PCSchematicManager) continue;

		PCSchematicManager->ChangeWaveform(CTestPointData);
		PCSchematicManager->DrawAll();
	}

	AfxGetApp()->EndWaitCursor();
}

bool TCOutputWaveformDoc::Load(CString CName, bool update)
{
	TCOutputWaveformData *PCOutputWaveformDataActive;
	TCWaveformDataRuns *PCWaveformDataRuns = NULL;

	if(PCParentSuperSpiceDoc) 
	{
		PCWaveformDataRuns = &PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns;

		PCOutputWaveformDataActive = PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	}
	else
	{
		PCWaveformDataRuns = &CWaveformDataRuns;

		PCOutputWaveformDataActive = PCOutputWaveformData;
	}

	if(!PCOutputWaveformDataActive) return false;

	CGlobalStatusMessage = "Loading data file, please wait...";

//	BeginWaitCursor();

	TCWaveformAnalyisisData CWaveformAnalyisisData;

	if(!PCOutputWaveformDataActive->Load(CName, PCWaveformDataRuns, PCParentSuperSpiceDoc, CWaveformAnalyisisData)) 
	{
		EndWaitCursor();

		CGlobalStatusMessage = "Error: Errors in waveform data file";

		return false;
	}

	CSpiceDataFileName = CName;

	if(update) UpdateAllViews(NULL, NULL);

//	EndWaitCursor();

	CGlobalStatusMessage = "Data file loaded";

	return true;
}

bool TCOutputWaveformData::CreateMultiPlots(int index, CString CSignalName, double x)
{
	//Add support for plotting a signal for each run
	//Redundant dublication of the data
	int num_signals;
	int x_index, y_index;
	double y;
	
	TCOutputWaveformDataRecord &CRecord = CRecords[index];

	num_signals = CRecord.CSignals.GetSize();

	if(!num_signals) return false;

	if(!index)
	for(int p = 0; p < num_signals; p++)
	{
		TCSignal &CSignal = CRecord.CSignals[p];

		CSignal.magnitude	= -1; // Do not display signals except for other than run 0
		CSignal.phase		= -1;
	}

	x_index = CRecord.CSignals[0].CMagnitudeData.GetForwardValuePosition(x);

	if(x_index < 0) 
	{
		CString CError, CTest;

		CTest = FloatToMKSString(x);

		CError = "Unable to find parameter collated test point: " + CRecord.CHeader.CPlotName + ", "  + CTest;

		DisplayError(IDS_ERR_WARNING, CError);

		return false;
	}

	y_index = CRecord.CHeader.FindSignal(CSignalName);

	if(y_index < 0) 
	{
		CString CError;

		CError = "Unable to find parameter collated signal: " + CRecord.CHeader.CPlotName + ", " + CSignalName;

		DisplayError(IDS_ERR_WARNING, CError);

		return false;
	}

	y = CRecord.CSignals[y_index].CMagnitudeData.CX[x_index];

	CRecord.m_y_mag_reruns = y;

	CRecord.m_y_phase_reruns = 0;

	if(CRecord.CSignals[y_index].CPhaseData.CX.GetSize())
	{
		y = CRecord.CSignals[y_index].CPhaseData.CX[x_index];

		CRecord.m_y_phase_reruns = y;
	}

	return true;
}

TCOutputWaveformData *TCOutputWaveformDoc::GetOutputWaveformData(void)
{
	TCOutputWaveformData *PCOutputWaveformDataActive;

	if(!PCParentSuperSpiceDoc) return NULL;

	if(PCParentSuperSpiceDoc) PCOutputWaveformDataActive = PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	else PCOutputWaveformDataActive = PCOutputWaveformData;

	if(PCOutputWaveformDataActive)
	if(IsBadReadPtr(PCOutputWaveformDataActive, 4))
	{
		ASSERT(0);

		return NULL;
	}
	return PCOutputWaveformDataActive;
}

TCWaveformDataRuns *TCOutputWaveformDoc::GetWaveformDataRuns(void)
{
	TCWaveformDataRuns *PCOutputWaveformDataActive;

	if(PCParentSuperSpiceDoc) PCOutputWaveformDataActive = &PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns;
	else PCOutputWaveformDataActive = &CWaveformDataRuns;

	if(PCOutputWaveformDataActive)
	if(IsBadReadPtr(PCOutputWaveformDataActive, 4))
	{
		ASSERT(0);

		return NULL;
	}

	return PCOutputWaveformDataActive;
}

bool TCOutputWaveformDoc::Save(CString CName)
{
	TCOutputWaveformData *PCOutputWaveformDataActive;

	if(PCParentSuperSpiceDoc) PCOutputWaveformDataActive = PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	else PCOutputWaveformDataActive = PCOutputWaveformData;

	if(!PCOutputWaveformDataActive) return false;

	if(!PCOutputWaveformDataActive->Save(CName)) return false;

	return false;
}

void TCOutputWaveformDoc::Serialize(CArchive& CArchiveFile)
{
	CVersionInfo.Serialize(CArchiveFile);

	POSITION				CViewPosition;
	TCOutputWaveformView	*PCOutputWaveformView;
	TCWaveformGraphicsManager *PCSchematicManager;

	int count = 0;
	int p;

	int save_serialize = 12345678;
	int load_serialize = 3456;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CSpiceDataFileName;

		CViewPosition	= GetFirstViewPosition();

		while(CViewPosition != NULL)// first count views
		{
			count++;
			PCOutputWaveformView = (TCOutputWaveformView *)GetNextView(CViewPosition);
		}

		CArchiveFile << count;

		CViewPosition = GetFirstViewPosition();

		while(CViewPosition != NULL)
		{
			PCOutputWaveformView = (TCOutputWaveformView *)GetNextView(CViewPosition);

			PCOutputWaveformView->Serialize(CArchiveFile);
		}
	}
	else
	{
		CArchiveFile >> CSpiceDataFileName;

		CViewPosition	= GetFirstViewPosition();

		CArchiveFile >> count;

		for(p = 0; p < count; p++) 
		{
			if(!p)
			{
				PCOutputWaveformView = (TCOutputWaveformView *) GetNextView(CViewPosition);
			}
			else PCOutputWaveformView = (TCOutputWaveformView *) CreateNewView(this);

			if(!PCOutputWaveformView) return;// fatal error

			PCOutputWaveformView->Serialize(CArchiveFile);
			if(p) 
			{
				PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

				if(!PCSchematicManager) return;

				PCSchematicManager->PCWaveformDataRuns = &CWaveformDataRuns;

				PCOutputWaveformView->GetParent()->SetWindowPlacement(&PCOutputWaveformView->s_window_placment);

				PCOutputWaveformView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
			}
		}
	}

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_serialize;
	}
	else
	{
		CArchiveFile >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_DATA_FILE);

			return;
		}
	}	CObject::Serialize(CArchiveFile);

}

/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformDoc commands

void TCOutputWaveformDoc::OnCloseDocument() 
{
	if(PCParentSuperSpiceDoc)PCParentSuperSpiceDoc->OnNotifyDocumentClosed(this);

	OnSaveDocument(GetPathName());

	TCWaveformDataRuns *PCWaveformDataRuns = NULL;

	if(PCParentSuperSpiceDoc) 
	{
		PCWaveformDataRuns = &PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns;
	}
	else
	{
		PCWaveformDataRuns = &CWaveformDataRuns;
	}

	TCOutputWaveformData &COutputWaveformData = *PCWaveformDataRuns->CRuns[0];

	COutputWaveformData.PCMOutputWaveformDoc = NULL;

	CDocument::OnCloseDocument();
}

void TCOutputWaveformDoc::OnViewDisplaySchematic(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplaySchematic(PCView);
}
void TCOutputWaveformDoc::OnViewDisplayOutputGraph(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayOutputGraph(PCView);
}
void TCOutputWaveformDoc::OnViewPcbNetlist(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayPCBNetlist(PCView);
}

void TCOutputWaveformDoc::OnViewDisplayOutputText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplayOutputText(PCView);
}

void TCOutputWaveformDoc::OnViewDisplaySymbolEditor(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplaySymbolEditor(PCView);
}

void TCOutputWaveformDoc::OnViewDisplayModelsText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayModelsText(PCView);
}
void TCOutputWaveformDoc::OnViewDisplayInputText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayInputText(PCView);

}
void TCOutputWaveformDoc::OnViewDisplayIncludeText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayIncludeText(PCView);

}

void TCOutputWaveformDoc::OnRunRun(CView *PCView, bool renetlist) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnRunRun(PCView, renetlist);
}

void TCOutputWaveformDoc::OnRunRunDebugMode(CView *PCView, bool renetlist) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnRunRunDebugMode(PCView, renetlist);
}

void  TCOutputWaveformDoc::TimerCallBack(void)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->TimerCallBack();
}

TCSuperSpiceView *TCOutputWaveformDoc::GetSchematicView(void)
{
	if(!PCParentSuperSpiceDoc) return NULL;

	POSITION pos = PCParentSuperSpiceDoc->GetFirstViewPosition();

	TCSuperSpiceView *PCViewInList;

	PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

	if(!PCViewInList) return NULL;

	return PCViewInList;
}

void TCOutputWaveformDoc::OnRunCreatenetlist() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnRunCreateNetlist();
}

void TCOutputWaveformDoc::OnRunStop() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnRunStop();
}

void TCOutputWaveformDoc::OnViewTopLevelFiles() 
{
	if(!PCParentSuperSpiceDoc) return;
	
	PCParentSuperSpiceDoc->OnViewTopLevelFiles();
}

void TCOutputWaveformDoc::OnViewSetZoomCenter(CView *PCView, CPoint CMousePosition)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	CPoint	CScrollOrigin	= PCOutputWaveformView->GetScrollBarPosition();
	float	zoom			= PCSchematicManager->GetZoom();

	CMousePosition.x = 	(int)((CMousePosition.x + CScrollOrigin.x) / zoom);
	CMousePosition.y = 	(int)((CMousePosition.y + CScrollOrigin.y) / zoom);

	PCSchematicManager->SetZoomCenter(CMousePosition);
}

void TCOutputWaveformDoc::OnViewZoomIn(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	float zoom = PCSchematicManager->GetZoom();

	if(zoom >= 4.0 ) return;

	CPoint CCurrentOrigin = PCOutputWaveformView->GetScrollBarPosition();	

	PCSchematicManager->SetZoom(zoom * GCSuperSpiceGlobalData.CGeneric.zoom_scale_rate_facter);

	zoom = PCSchematicManager->GetZoom();

	CPoint CZoomCenter = PCSchematicManager->GetZoomCenter();

	CZoomCenter.x = (int)(CZoomCenter.x * zoom); // Zoom about current center
	CZoomCenter.y = (int)(CZoomCenter.y * zoom);

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CCurrentOrigin.x =  CZoomCenter.x - width / 2;
	CCurrentOrigin.y =  CZoomCenter.y - height / 2;

	PCOutputWaveformView->SetScrollBarPosition(CCurrentOrigin);
	PCSchematicManager->SetScrollBarPosition(CCurrentOrigin);

	PCSchematicManager->Zoom(zoom);
	PCSchematicManager->DrawAll();
}

bool TCOutputWaveformDoc::OnViewCheckZoomIn(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return false;

	if(PCSchematicManager->GetZoom() >= 4.0 ) return false;

	return true;
}
void TCOutputWaveformDoc::OnViewZoomOut(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	float zoom = PCSchematicManager->GetZoom();

	if(zoom <= 1.0/16.0) return;

	CPoint CCurrentOrigin = PCOutputWaveformView->GetScrollBarPosition();


	PCSchematicManager->SetZoom(zoom / GCSuperSpiceGlobalData.CGeneric.zoom_scale_rate_facter);

	zoom = PCSchematicManager->GetZoom();

	CPoint CZoomCenter = PCSchematicManager->GetZoomCenter();

	CZoomCenter.x = (int)(CZoomCenter.x * zoom); // Zoom about current center
	CZoomCenter.y = (int)(CZoomCenter.y * zoom);

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CCurrentOrigin.x =  CZoomCenter.x - width / 2;
	CCurrentOrigin.y =  CZoomCenter.y - height / 2;

	PCOutputWaveformView->SetScrollBarPosition(CCurrentOrigin);
	PCSchematicManager->SetScrollBarPosition(CCurrentOrigin);

	PCSchematicManager->Zoom(zoom);
	
	PCSchematicManager->DrawAll();
}

bool TCOutputWaveformDoc::OnViewCheckZoomOut(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return false;

	if(PCSchematicManager->GetZoom() <= 1.0/16.0) return false;

	return true;
}

void TCOutputWaveformDoc::OnViewZoomCenter(CView *PCView, CPoint CMousePosition)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	CPoint COrigin = PCOutputWaveformView->GetScrollBarPosition();

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CMousePosition.x =  CMousePosition.x - width / 2;
	CMousePosition.y =  CMousePosition.y - height / 2;

	COrigin.x = COrigin.x + CMousePosition.x;
	COrigin.y = COrigin.y + CMousePosition.y;

	PCOutputWaveformView->SetScrollBarPosition(COrigin);
	PCSchematicManager->SetScrollBarPosition(COrigin);

	PCSchematicManager->DrawAll();
}

void TCOutputWaveformDoc::SetGraphSize(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	TCWaveformGraphicsManager *PCSchematicManager;

	PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	CRect CWindowData;

	PCView->GetClientRect(&CWindowData);

	int width, height;

	width  = GCSuperSpiceGlobalData.CDrawData.wave_graph_x_shrink ;// bit of a cludge
	height = GCSuperSpiceGlobalData.CDrawData.wave_graph_y_shrink ;
	
	if(!GCSuperSpiceGlobalData.CDrawData.draw_waveform_page_border)
	{
		height -= GCSuperSpiceGlobalData.CDrawData.wave_graph_no_border_y_shrink ;
	}

	CRect COffset(0, 0, width, height);// bit of a cludge

	CWindowData.DeflateRect(COffset);

	PCSchematicManager->SetGraphSize(NULL, CWindowData);
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewIdleOnCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(PCSchematicManager) PCSchematicManager->DrawAll();

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleOnCancel();

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsSelectedOnCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsMovingOnCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSelectRegionOnCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotGraphicOnCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();
	
	if(PCSchematicObject)
		if(PCParentSuperSpiceDoc)
			if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
				PCParentSuperSpiceDoc->PutBackReferanceDesignator(PCSchematicObject->m_type);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotClipboardOnCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();

	if(PCSchematicObject)
		if(PCParentSuperSpiceDoc)
			if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
				PCParentSuperSpiceDoc->PutBackReferanceDesignator(PCSchematicObject->m_type);


	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardOnCancel();

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewIdleStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsSelectedStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsMovingStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSelectRegionStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotGraphicStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotClipboardGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}
/////////////////////////////////////
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewIdleStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsSelectedStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsMovingStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSelectRegionStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotGraphicStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();

	if(!PCSchematicObject) return E_GRAPHICS_MANAGER_STATE_IDLE;

	int graphic_type = PCSchematicObject->m_type;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateLBDown(mouse_flags, CScaledPoint);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) return system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotClipboardLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->PutNewReferanceDesignatorsInClipboard(PCSchematicManager);

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardLBDown(mouse_flags, CScaledPoint);

	GCSuperSpiceClipboard.Zoom(that_zoom);

	GCSuperSpiceClipboard.PasteComponents(PCSchematicManager, CScaledPoint, "*");
		// keep pasting until canceled
	GCSuperSpiceClipboard.Zoom(that_zoom);

	return system_state; 
}

////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewIdleStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsSelectedStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsMovingStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSelectRegionStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotGraphicStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotClipboardLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}
/////////////////////////////////////
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewIdleStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsSelectedStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGraphicsMovingStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSelectRegionStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotGraphicStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewGotClipboardMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

////////////////////////
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSizingWaveformWindowMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SizingWaveformWindowMouseMoved(nFlags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSizingWaveformWindowLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SizingWaveformWindowLBUp(nFlags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewSizingWaveformWindowLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	page_id;

	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SizingWaveformWindowLBDown(nFlags, CScaledPoint);

	return system_state; 
}

////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditCancel(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	//PCSchematicManager->XXX() nothing done yet

	return PCOutputWaveformView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditCut(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	GCSuperSpiceClipboard.CutComponents(PCSchematicManager);

	return PCOutputWaveformView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditPaste(CView *PCView, CPoint CMousePosition)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->PutNewReferanceDesignatorsInClipboard(PCSchematicManager);

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	GCSuperSpiceClipboard.Zoom(that_zoom);

	GCSuperSpiceClipboard.PasteComponents(PCSchematicManager, CScaledPoint, "*");

	GCSuperSpiceClipboard.Zoom(1);

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditDelete(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	PCSchematicManager->DeleteSelectedGraphics();

	return PCOutputWaveformView->CSuperSpiceViewData.system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditCopy(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	GCSuperSpiceClipboard.CopyComponents(PCSchematicManager);

	GCSuperSpiceClipboard.Zoom(1);

	return PCOutputWaveformView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditCopyToWindowsClipboard(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	GCSuperSpiceClipboard.CopyComponentsToWindowsClipboard(PCSchematicManager);

	GCSuperSpiceClipboard.Zoom(1);

	return PCOutputWaveformView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCOutputWaveformDoc::OnViewEditSelectAll(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	PCSchematicManager->SetSelectAll();

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}
/////////////////////
void TCOutputWaveformDoc::OnLButtonDblClk(CView *PCView, CPoint CMousePosition, UINT mouse_flags)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	TCSchematicComponentInfo CSchematicComponentInfo;

	bool fine = false;

	if(mouse_flags & MK_SHIFT) fine = true;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	CPoint CNewOffset = (CPoint) (COffset - PCSchematicManager->GetViewPortOrigin());

	CSchematicComponentInfo = PCSchematicManager->InspectSchematicObject((CPoint) (CMousePosition - CNewOffset), fine, true);

	if(CSchematicComponentInfo.id < 0) 
	{
		PCOutputWaveformView->OnOptionsSchematic();

		return;
	}

	switch(CSchematicComponentInfo.type)
	{
		case E_SCHEMATIC_OBJECT: InspectSchematicObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;	
			
		case E_SCHEMATIC_TEXT_LABEL: InspectSchematicTextLableObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;

		case E_SCHEMATIC_LABEL: InspectSchematicLabelObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	

		case E_WAVEFORM_OBJECT_SCREEN: InspectWaveformObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;	

		default: OnProperties();
	}
}

void  TCOutputWaveformDoc::OnViewPropertyAccelerater(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	CPoint CMousePosition;

	if(PCSchematicManager->IsComponentOutlined())
	{
		CMousePosition = PCSchematicManager->GetComponentOutlinePosition();	

		PCSchematicManager->EraseComponentOutline();

		OnLButtonDblClk(PCView, CMousePosition, 0);

		return;
	}
	
	if(PCSchematicManager->GetGraphicSelectedPosition(&CMousePosition))
	{
		CMousePosition += PCSchematicManager->GetViewPortOrigin();
		OnLButtonDblClk(PCView, CMousePosition, 0);

		return;
	}

//	OnViewProperties(PCView, PCSchematicManager); page data?
}

void TCOutputWaveformDoc::InspectSchematicTextLableObject(TCWaveformGraphicsManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	
	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	TCAddText1 CDlgText;

	CDlgText.CMEditAddText = PCSchematicObject->GetLabel();

	if(CDlgText.DoModal() == IDCANCEL) return;

	CText = CDlgText.CMEditAddText;

	if(CText == "") return; // Do not change null strings
							// To do: invalidate all white space strings
	

	PCSchematicManager->SetLabel(CSchematicComponentInfo.id, CSchematicComponentInfo.label_id, CText);

}

void TCOutputWaveformDoc::InspectSchematicObject(TCWaveformGraphicsManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	
	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;

//	int type = PCSchematicObject->m_type;

//	int view_type = CSchematicObjectData.component_property_view_type;
}

void TCOutputWaveformDoc::InspectSchematicLabelObject(TCWaveformGraphicsManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return;

	if(!PCSchematicManager) return;

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	int label	= CSchematicComponentInfo.label_id;
	int object_type = PCSchematicObject->m_type;


	CString CText = CSchematicComponentInfo.CText;

	TCSchematicObjectData CSchematicObjectDataBase;
	CSchematicObjectDataBase = GCSuperSpiceDataBase.CMDefaults[object_type];

	if(!(label < CSchematicObjectDataBase.CLabelListData.GetSize())) return;

	if(object_type == E_WIRE_COMPONENT)
	{
		TCWireLableDlg CWireLableDlg;

		CWireLableDlg.m_lable_id	= label;
		CWireLableDlg.CEditWireText = CText;

		if(CWireLableDlg.DoModal() != IDOK) return;
			
		CText = CWireLableDlg.CEditWireText;

	}
	else
	{
	switch(label)
	{
		case E_COMPONENT_VALUE:
		{
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;

		}break;

		case E_COMPONENT_DESIGNATOR:
		{
				TCReferanceDesignator CComponentText;

				CComponentText.CEditReferanceDesignator = CText;

				if(CComponentText.DoModal() != IDOK) return;

				CText = CComponentText.CEditReferanceDesignator;
		}break;

		case E_COMPONENT_SPICE_MODEL_NAME:
		{ //node name
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;


		}break;

		case E_COMPONENT_SYMBOL_NAME:
		{//node lable
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;

		}break;
	}
	}

	CSchematicObjectDataBase.CLabelListData[label].CLabel = CText;

	GCSuperSpiceDataBase.CMDefaults[object_type].Copy(CSchematicObjectDataBase);

	TCSchematicObjectData CSchematicObjectData;

	PCSchematicManager->SetLabel(CSchematicComponentInfo.id, CSchematicComponentInfo.label_id, CText, true, false);

	CSchematicObjectData = PCSchematicObject->CMSchematicObjectData;

	PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);

	if(object_type == E_WAVEFORM_COMPONENT)
	{

	}
}

TCOutputWaveformView *TCOutputWaveformDoc::OnViewNewView(CView *PCView)
{
	if(!PCView) return NULL;

	TCOutputWaveformView *PCNewOutputWaveformView	= (TCOutputWaveformView *) CreateNewView(this);
	TCOutputWaveformView *PCOutputWaveformView		= (TCOutputWaveformView *) PCView;
	
	if(!PCNewOutputWaveformView) return NULL;

	TCSchematicManager *PCNewSchematicManager = PCNewOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCNewSchematicManager) return NULL;

	TCSchematicManager *PCSchematicManager = PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return NULL;

	PCNewSchematicManager->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
	
	PCNewOutputWaveformView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());

//	PCNewOutputWaveformView->m_current_waveform_type = PCOutputWaveformView->m_current_waveform_type;

//	*PCNewSchematicManager = *PCSchematicManager;

	PCNewOutputWaveformView->ShowWindow(SW_SHOW); 
	PCNewOutputWaveformView->UpdateWindow();

	return PCNewOutputWaveformView;
}

void TCOutputWaveformDoc::InspectWaveformObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	
	if(!PCSchematicManager) return;

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;
 
	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;
	TCWaveformDataRuns *PCWaveformDataRuns = GetWaveformDataRuns();

	TCMasterWaveformPropPages CMasterWaveformPropPages;

	CMasterWaveformPropPages.CSchematicObjectData = CSchematicObjectData;
	CMasterWaveformPropPages.PCOutputWaveformData = GetOutputWaveformData();
	CMasterWaveformPropPages.CLabels.POutputWaveformData = CMasterWaveformPropPages.PCOutputWaveformData;
	CMasterWaveformPropPages.CPageOptions.POutputWaveformData  = CMasterWaveformPropPages.PCOutputWaveformData;
	CMasterWaveformPropPages.CGraphSetup.POutputWaveformData  = CMasterWaveformPropPages.PCOutputWaveformData;
	CMasterWaveformPropPages.CSignalSetup.POutputWaveformData  = CMasterWaveformPropPages.PCOutputWaveformData;
	CMasterWaveformPropPages.CCalculator.POutputWaveformData  = CMasterWaveformPropPages.PCOutputWaveformData;

	if(PCWaveformDataRuns && PCWaveformDataRuns->CRuns.GetSize() == 1)
	if(PCSchematicObjectData->PCOutputWaveformDataHeader && PCWaveformDataRuns->CRuns[0])//Make sure data base has this objects current signal list
	{
		int type = CSchematicObjectData.PCOutputWaveformDataHeader->type;

		TCOutputWaveformDataHeader &COutputWaveformDataHeader = PCWaveformDataRuns->CRuns[0]->CRecords[type].CHeader;

		COutputWaveformDataHeader.SetDisplayedSignals(*PCSchematicObjectData->PCOutputWaveformDataHeader);
	}

	if(CMasterWaveformPropPages.DoModal() != IDOK) return;

	BeginWaitCursor();

	CSchematicObjectData = CMasterWaveformPropPages.CSchematicObjectData;

	TCOutputWaveformData *PCOutputWaveformData = GetOutputWaveformData();

	if(PCOutputWaveformData)
	if(CSchematicObjectData.PCOutputWaveformDataHeader)
	{
		int type = CSchematicObjectData.PCOutputWaveformDataHeader->type;
/*
		type = PCOutputWaveformData->GetWaveFormHeaderIndex(type);

		TCOutputWaveformDataHeader &COutputWaveformDataHeader = PCWaveformDataRuns->CRuns[0]->CRecords[type].CHeader;

		COutputWaveformDataHeader.SetDisplayedSignals(*PCSchematicObjectData->PCOutputWaveformDataHeader);
*/
		if(PCWaveformDataRuns) PCWaveformDataRuns->SetupMathFunctionData();

		if(type > -1)
		if(type < PCOutputWaveformData->CRecords.GetSize())
		{
			TCOutputWaveformDataHeader &COutputWaveformDataHeader = GetOutputWaveformData()->CRecords[type].CHeader;

	 		CSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
			CSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;

			if(type != E_SPICE_RECORD_MATH_0)// do not destroy data base with math data
				PCOutputWaveformData->CRecords[type].CHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		
			COutputWaveformDataHeader.CreateListOfDisplayedSignals();// need to get the max/min updated correctly

			COutputWaveformDataHeader.SyncAllRuns();
		}
	}

//	This is too risky
//	GCSuperSpiceDataBase.SetSchematicObjectData(CSchematicObjectData, false);

	PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);
	
	EndWaitCursor();
}

void TCOutputWaveformDoc::OnProperties()
{
/*
	TCMasterWaveformPropPages CMasterWaveformPropPages;

	CMasterWaveformPropPages.DoModal();
*/
}

void TCOutputWaveformDoc::OnSetupSetTemperature() 
{
	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnSetupSetTemperature();	
}

void TCOutputWaveformDoc::OnFileLoadSpiceDataFile() 
{
	// this document to do
	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnFileLoadSpiceDataFile();	
	
}

void TCOutputWaveformDoc::OnViewDisplayPoleZeroText(CView *PCView)
{
	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnViewDisplayPoleZeroText(PCView);	
}

void TCOutputWaveformDoc::OnViewDisplaySensitivityText(CView *PCView)
{
	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnViewDisplaySensitivityText(PCView);	
}

void TCOutputWaveformDoc::OnWaveformsCalculatefftifftdata() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	BeginWaitCursor();

	PCDoc->CMSuperSpiceDocData.CWaveformDataRuns.ComputeFFTs();	

	EndWaitCursor();
}

void TCOutputWaveformDoc::OnFilePcbnetlistsGeneric() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	PCDoc->CreatePCBNetlist(1/*E_PCB_FORMATS_GENERIC*/);
}

void TCOutputWaveformDoc::OnFilePcbnetlistsOrcad() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_ORCAD);	
}

void TCOutputWaveformDoc::OnFilePcbnetlistsCreatetango() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_TANGO);		
}

void TCOutputWaveformDoc::OnFilePcbnetlistsCreateprotel() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_PROTEL);		
}

void TCOutputWaveformDoc::OnFilePcbnetlistsPclogic() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_PCLOGIC);	
}

void TCOutputWaveformDoc::OnFilePcbnetlistsCreateeagle() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc;

	PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_EAGLE);		
}

void TCOutputWaveformDoc::OnViewDisplaySpiceErrorLog(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplaySpiceErrorLog(PCView);
}

void TCOutputWaveformDoc::OnFileNewTextFile() 
{
	if(!PCParentSuperSpiceDoc) 
	{
		TCSuperSpiceMainFrame *PCSuperSpiceMainFrame = (TCSuperSpiceMainFrame *)AfxGetMainWnd();

		if(!PCSuperSpiceMainFrame) return;

		PCSuperSpiceMainFrame->OnFileNewTextFilePublic();

		return;
	}

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileNewTextFile();	
}

void TCOutputWaveformDoc::OnUpdateFileNewtextfile(CCmdUI* pCmdUI) 
{
//	if(!PCParentSuperSpiceDoc)	pCmdUI->Enable(false);
	pCmdUI->Enable(true);	
}

void TCOutputWaveformDoc::ChangeWaveformColour(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	COLORREF colour;

	CColorDialog CColorDialog;

	if(CColorDialog.DoModal() != IDOK) return;

	colour = CColorDialog.GetColor();

	PCSchematicManager->ChangeColour(PCOutputWaveformView->CSuperSpiceViewData.CLastMousePosition ,colour);
}

void TCOutputWaveformDoc::ChangeGraphBKGColour(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	COLORREF colour;

	CColorDialog CColorDialog;

	if(CColorDialog.DoModal() != IDOK) return;

	colour = CColorDialog.GetColor();

	PCSchematicManager->ChangeGraphBKGColour(PCOutputWaveformView->CSuperSpiceViewData.CLastMousePosition ,colour);
}

void TCOutputWaveformDoc::ClearAllWaveforms(void)
{
	POSITION pos = GetFirstViewPosition();

	TCOutputWaveformView * PCOutputWaveformView = (TCOutputWaveformView *) GetNextView(pos);

	ClearAllWaveforms(PCOutputWaveformView);
}

void TCOutputWaveformDoc::ClearAllWaveforms(CView *PCView)
{
	TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView *)PCView;
	
	if(!PCOutputWaveformView) return;

	TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *)PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	PCSchematicManager->ClearAllWaveforms();
}

void TCOutputWaveformDoc::OnFileSaveastextdatafiles() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileSaveastextdatafiles();	
}

void TCOutputWaveformDoc::OnFileReportsDcoperatingpoint() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsDcoperatingpoint();	
}

void TCOutputWaveformDoc::OnViewReportsDcoperatingpoint() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsDcoperatingpoint();		
}

void TCOutputWaveformDoc::OnFileReportsDcsweep() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsDcsweep();	
}

void TCOutputWaveformDoc::OnViewReportsDcsweep() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsDcsweep();	
}

void TCOutputWaveformDoc::OnFileReportsNoise() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsNoise();	
}

void TCOutputWaveformDoc::OnViewReportsNoise() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsNoise();	
}

void TCOutputWaveformDoc::OnRunEnableloopgain() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 2;
	else 
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 1;
}

void TCOutputWaveformDoc::OnUpdateRunEnableloopgain(CCmdUI* pCmdUI) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc();

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();	
}

void TCOutputWaveformDoc::OnViewReportsAcsweep() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsAcsweep();	
}

void TCOutputWaveformDoc::OnFileReportsAcsweep() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsAcsweep();	
}


void TCOutputWaveformDoc::OnRunTerminatexspiceengine() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunExitEngine();	
}

void TCOutputWaveformDoc::OnGraphProbeMode() 
{
	GCSuperSpiceGlobalData.CDrawData.probe_mode = !GCSuperSpiceGlobalData.CDrawData.probe_mode;	
}

void TCOutputWaveformDoc::OnUpdateGraphProbeMode(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(GCSuperSpiceGlobalData.CDrawData.probe_mode);	
}

void TCOutputWaveformDoc::OnViewAnalysisLoopGain() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewAnalysisLoopGain();
}

void TCOutputWaveformDoc::OnViewAnalysisTransientFrequency() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewAnalysisTransientFrequency(); 
}

void TCOutputWaveformDoc::OnViewAnalysisSetup() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewAnalysisSetup();
	
}

void TCOutputWaveformDoc::OnViewAnalysisresultsTransientpulse() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewAnalysisresultsTransientPulse(); 	
}

void TCOutputWaveformDoc::OnViewReportsPulseAnalysis() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsPulseAnalysis();	
}

void TCOutputWaveformDoc::OnSetupsXspiceprogressrate() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnSetupsXSpiceProgressRate();	
}

void TCOutputWaveformDoc::OnFileReportsCreateTransientPower() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsCreateTransientPower();	
}

void TCOutputWaveformDoc::OnViewReportsTransientPower() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsTransientPower();		
}

void TCOutputWaveformDoc::OnViewAnalysisresultsTransientAverages() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewAnalysisresultsTransientAverages();			
}

void TCOutputWaveformDoc::OnFileReportsCreateTransientAverages() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsCreateTransientAverages();				
}

void TCOutputWaveformDoc::OnViewReportsTransientAverages() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewReportsTransientAverages();					
}

void TCOutputWaveformDoc::OnFileReportsPulseAnalysis() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileReportsPulseAnalysis();					
}

void TCOutputWaveformDoc::OnRunPauseContinue() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunPauseContinue();	
}

void TCOutputWaveformDoc::OnUpdateRunPauseContinue(CCmdUI* pCmdUI) 
{
	if(!PCParentSuperSpiceDoc) return;

	pCmdUI->SetCheck(PCParentSuperSpiceDoc->GetTopLevelDoc()->m_is_simulation_paused);
}

void TCOutputWaveformDoc::OnRunEnableMarchingWaveforms() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunEnableMarchingWaveforms();		
}

void TCOutputWaveformDoc::OnUpdateRunEnableMarchingWaveforms(CCmdUI* pCmdUI) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnUpdateRunEnableMarchingWaveforms(pCmdUI);	
}

void TCOutputWaveformDoc::UpdateMarchingWaveforms(int run_number, int waveform_type)
{
	TCOutputWaveformView *PCViewInList = NULL;

	TCWaveformGraphicsManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCOutputWaveformView *)GetNextView(pos);

		PCSchematicManager = (TCWaveformGraphicsManager *)PCViewInList->CSuperSpiceViewData.PCMSchematicManager;

		if(!PCSchematicManager) continue;

		if(PCViewInList->m_current_waveform_type < 0) continue;

		if(PCViewInList->m_current_waveform_type != waveform_type) continue;

		PCSchematicManager->UpdateMarchingWaveforms(run_number);
	}
}

void TCOutputWaveformDoc::SetupMarchingWaveforms(int run_number, int waveform_type)
{
	TCWaveformDataRuns *PCWaveformDataRuns = NULL;

	if(PCParentSuperSpiceDoc) 
	{
		PCWaveformDataRuns = &PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns;
	}
	else
	{
		PCWaveformDataRuns = &CWaveformDataRuns;
	}

	TCOutputWaveformData &COutputWaveformData = *PCWaveformDataRuns->CRuns[0];

	TCOutputWaveformView *PCViewInList = NULL;

	TCWaveformGraphicsManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCOutputWaveformView *)GetNextView(pos);

		PCSchematicManager = (TCWaveformGraphicsManager *)PCViewInList->CSuperSpiceViewData.PCMSchematicManager;

		if(!PCSchematicManager) continue;

		if(PCViewInList->m_current_waveform_type < 0) continue;

		TCOutputWaveformDataHeader &CHeader = COutputWaveformData.CRecords[PCViewInList->m_current_waveform_type].CHeader;

		PCSchematicManager->SetupMarchingWaveforms(PCWaveformDataRuns, CHeader.PCSignals, PCViewInList->m_current_waveform_type, run_number);

		if(waveform_type == PCViewInList->m_current_waveform_type) 
		{
			TCSuperSpiceMainFrame *PCSuperSpicMainFrame = (TCSuperSpiceMainFrame *) AfxGetMainWnd();
			
			PCSuperSpicMainFrame->MDIActivate(PCViewInList->GetParent());
		}
	}
}

void TCOutputWaveformDoc::OnDebugTest2(void)
{	return; /*
	TCWaveformDataRuns *PCWaveformDataRuns; 

	if(PCParentSuperSpiceDoc) 
	{
		PCWaveformDataRuns = &PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns;
	}
	else
	{
		PCWaveformDataRuns = &CWaveformDataRuns;
	}

	TCOutputWaveformDataHeader &CHeader = PCWaveformDataRuns->CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	CArray <TCSignal, TCSignal&> &CSignals = *CHeader.PCSignals;

	TCSignal &CSignal = CSignals[1];

	CSignal.magnitude = 0;
	CSignal.stop_point = 0;
	CSignal.start_point = 0;

	SetupMarchingWaveforms(1, 3);*/
}

void TCOutputWaveformDoc::OnDebugTest(void)
{
return;/*
	TCWaveformDataRuns *PCWaveformDataRuns;

	if(PCParentSuperSpiceDoc) 
	{
		PCWaveformDataRuns = &PCParentSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns;
	}
	else
	{
		PCWaveformDataRuns = &CWaveformDataRuns;
	}

	TCOutputWaveformView *PCViewInList = NULL;

	POSITION pos = GetFirstViewPosition();

	PCViewInList = (TCOutputWaveformView *)GetNextView(pos);

	PCViewInList->m_current_waveform_type = E_SPICE_RECORD_TRANSIENT;

	TCOutputWaveformDataHeader &CHeader = PCWaveformDataRuns->CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	CArray <TCSignal, TCSignal&> &CSignals = *CHeader.PCSignals;

	TCSignal &CSignal = CSignals[1];

	CSignal.magnitude = 0;
	CSignal.stop_point += 50;

	UpdateMarchingWaveforms(0, 3);*/
}

int TCOutputWaveformDoc::GetWaveFormType(void)
{
	return m_waveform_type;
}

void TCOutputWaveformDoc::OnTestpointsWireonClicktestPointSetup() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	if(!PCDoc->m_viewList.IsEmpty()) 
	{
		((TCSuperSpiceView*) PCDoc->m_viewList.GetHead())->OnTestpointsWireOncliCkTestPointSetup();
	}
}

void TCOutputWaveformDoc::OnRunRunasoperatingpointdesigner() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->OnRunRunasOperatingPointDesigner();
}

void TCOutputWaveformDoc::OnSetupsDesignersetup() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->OnSetupsDesignerSetup();	
}

void TCOutputWaveformDoc::OnViewParameterlistrerunfile() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->GetTopLevelDoc()->OnViewParameterlistrerunfile();		
}

void TCOutputWaveformDoc::OnViewMontecarlorerunfile() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->GetTopLevelDoc()->OnViewMonteCarloReRunFile();	
}

void TCOutputWaveformDoc::OnViewParameterlistgeneraterfile() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->GetTopLevelDoc()->OnViewParameterlistgeneraterfile();	
}

void TCOutputWaveformDoc::OnViewMultiParameterSweepFile() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->GetTopLevelDoc()->OnViewMultiParameterSweepFile();	
}

void TCOutputWaveformDoc::OnViewWorstCaseReRunFile() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	PCDoc->GetTopLevelDoc()->OnViewWorstCaseReRunFile();	
}
