// TCOutputWaveformDoc.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformDoc document


#ifndef _TCSPICE_OUTPUT_WAVEFORM_DOC_H 
#define _TCSPICE_OUTPUT_WAVEFORM_DOC_H 

#include "TCOutputWaveformData.h"

class TCSuperSpiceDoc;
class TCSuperSpiceView;
class TCWaveformGraphicsManager;
class TCSchematicComponentInfo;

class TCOutputWaveformDoc : public CDocument
{
protected:
	TCOutputWaveformDoc();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(TCOutputWaveformDoc)


	TCSuperSpiceDoc				*PCParentSuperSpiceDoc;
	TCOutputWaveformData		*PCOutputWaveformData;
	WINDOWPLACEMENT				s_window_placment;

	bool first_draw;

// Attributes
public:

	CString	CSpiceDataFileName;
	CArray <TCTestPointData, TCTestPointData&> CTestPointDataList;

	void SetTestPointData(CArray <TCTestPointData, TCTestPointData&> &CSourceTestPointDataList);

	TCVersionInfo CVersionInfo;
	int m_current_waveform_type;
	int m_waveform_type;
	CArray <int, int> CActiveWaveFormList;
	int m_active_list_index;

	TCOutputWaveformData *GetOutputWaveformData(void);

	TCWaveformDataRuns	 CWaveformDataRuns;
	TCWaveformDataRuns *GetWaveformDataRuns(void);

	void Print(CView *PCView, CDC *PCDC);

	TCSuperSpiceDoc *GetParentSuperSpiceDoc(void);

	TCSuperSpiceView *GetSchematicView(void);

	void OnViewOnDraw(TCOutputWaveformView *PCView, CDC* pDC);
	int GetWaveFormType(void);

	void UpdateWaveforms(CString CFileName);
	void ChangeWaveform(TCTestPointData &CTestPointData);
	void ChangeAllWaveforms(CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList);

	TCOutputWaveformView *FindWaveformType(int type);
	void UpdateAndCreateWaveformViews(void);
	void CloseNonActiveViews(void);

	void OnViewDisplaySchematic(CView *PCView);
	void OnViewDisplayOutputGraph(CView *PCView);
	void OnViewDisplayOutputText(CView *PCView);
	void OnViewDisplayInputText(CView *PCView);
	void OnViewDisplayIncludeText(CView *PCView);
	void OnViewDisplayModelsText(CView *PCView);
	void OnViewDisplaySymbolEditor(CView *PCView);
	void OnViewPcbNetlist(CView *PCView);

	void OnViewPropertyAccelerater(CView *PCView);
	void ChangeWaveformColour(CView *PCView);
	void ClearAllWaveforms(CView *PCView);
	void ClearAllWaveforms(void);

	void ChangeGraphBKGColour(CView *PCView);

	void OnViewZoomIn(CView *PCView);
	bool OnViewCheckZoomIn(CView *PCView);
	void OnViewZoomOut(CView *PCView);
	bool OnViewCheckZoomOut(CView *PCView);
	void OnViewZoomCenter(CView *PCView, CPoint CMousePosition);
	void OnViewSetZoomCenter(CView *PCView, CPoint CMousePosition);
	void OnViewDisplayPoleZeroText(CView *PCView);
	void OnViewDisplaySensitivityText(CView *PCView);
	void OnViewDisplaySpiceErrorLog(CView *PCView);

	int GetNumberOfViews(void);
	int SetupActiveWaveformList(void);
	int GetNextActiveWaveform(void);
	bool PeekNextActiveWaveform(void);
	int CalculateFFTOnLoad(void);

	void SetGraphSize(CView *PCView);

	TCOutputWaveformView *OnViewNewView(CView *PCView);

	void  TimerCallBack(void);

	void OnRunRun(CView *PCView, bool renetlist = true);
	void OnRunRunDebugMode(CView *PCView, bool renetlist = true);

	bool Load(CString CName, bool update = true);
	bool Save(CString CName);

	void OnLButtonDblClk(CView *PCView, CPoint CMousePosition, UINT mouse_flags);
	void InspectSchematicTextLableObject(TCWaveformGraphicsManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo);
	void InspectSchematicObject(TCWaveformGraphicsManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo);
	void InspectSchematicLabelObject(TCWaveformGraphicsManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo);
	void InspectWaveformObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleOnCancel(CView *PCView);//
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedOnCancel(CView *PCView);//
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingOnCancel(CView *PCView);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardOnCancel(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);		 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateLBDown(CView *PCView,  int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateMouseMoved(CView *PCView,int page_id,  UINT nFlags, CPoint CMousePosition);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateMouseMoved(CView *PCView,  int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCancel(CView *PCView); 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCut(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditPaste(CView *PCView, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditDelete(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCopy(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCopyToWindowsClipboard(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditSelectAll(CView *PCView);

	void UpdateMarchingWaveforms(int run_number, int waveform_type);
	void SetupMarchingWaveforms(int run_number, int waveform_type);
	void OnDebugTest2(void);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCOutputWaveformDoc)
	public:
	virtual void Serialize(CArchive& CArchiveFile);   // overridden for document i/o
	virtual void OnCloseDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	protected:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	void OnProperties();
	virtual ~TCOutputWaveformDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(TCOutputWaveformDoc)
	afx_msg void OnRunStop();
	afx_msg void OnRunCreatenetlist();
	afx_msg void OnViewTopLevelFiles();
	afx_msg void OnSetupSetTemperature();
	afx_msg void OnFileLoadSpiceDataFile();
	afx_msg void OnWaveformsCalculatefftifftdata();
	afx_msg void OnFilePcbnetlistsGeneric();
	afx_msg void OnFilePcbnetlistsOrcad();
	afx_msg void OnFilePcbnetlistsCreatetango();
	afx_msg void OnFilePcbnetlistsCreateprotel();
	afx_msg void OnFilePcbnetlistsPclogic();
	afx_msg void OnFilePcbnetlistsCreateeagle();
	afx_msg void OnFileNewTextFile();
	afx_msg void OnUpdateFileNewtextfile(CCmdUI* pCmdUI);
	afx_msg void OnFileSaveastextdatafiles();
	afx_msg void OnFileReportsDcoperatingpoint();
	afx_msg void OnViewReportsDcoperatingpoint();
	afx_msg void OnFileReportsDcsweep();
	afx_msg void OnViewReportsDcsweep();
	afx_msg void OnFileReportsNoise();
	afx_msg void OnViewReportsNoise();
	afx_msg void OnRunEnableloopgain();
	afx_msg void OnUpdateRunEnableloopgain(CCmdUI* pCmdUI);
	afx_msg void OnFileReportsAcsweep();
	afx_msg void OnViewReportsAcsweep();
	afx_msg void OnRunTerminatexspiceengine();
	afx_msg void OnGraphProbeMode();
	afx_msg void OnUpdateGraphProbeMode(CCmdUI* pCmdUI);
	afx_msg void OnViewAnalysisLoopGain();
	afx_msg void OnViewAnalysisTransientFrequency();
	afx_msg void OnViewAnalysisSetup();
	afx_msg void OnViewAnalysisresultsTransientpulse();
	afx_msg void OnViewReportsPulseAnalysis();
	afx_msg void OnSetupsXspiceprogressrate();
	afx_msg void OnFileReportsCreateTransientPower();
	afx_msg void OnViewReportsTransientPower();
	afx_msg void OnViewAnalysisresultsTransientAverages();
	afx_msg void OnFileReportsCreateTransientAverages();
	afx_msg void OnViewReportsTransientAverages();
	afx_msg void OnFileReportsPulseAnalysis();
	afx_msg void OnRunPauseContinue();
	afx_msg void OnUpdateRunPauseContinue(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableMarchingWaveforms();
	afx_msg void OnUpdateRunEnableMarchingWaveforms(CCmdUI* pCmdUI);
	afx_msg void OnTestpointsWireonClicktestPointSetup();
	afx_msg void OnRunRunasoperatingpointdesigner();
	afx_msg void OnSetupsDesignersetup();
	afx_msg void OnViewParameterlistrerunfile();
	afx_msg void OnViewMontecarlorerunfile();
	afx_msg void OnViewParameterlistgeneraterfile();
	afx_msg void OnViewMultiParameterSweepFile();
	afx_msg void OnViewWorstCaseReRunFile();
	//}}AFX_MSG

	afx_msg void OnDebugTest(void);

	DECLARE_MESSAGE_MAP()
};

#endif
