// TCOutputWaveformView.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TESuperSpiceMsgStringsEnums.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCWaveformGraphicsManager.h"
#include "TCSuperSpiceView.h"
#include "TCSuperSpiceDoc.h"
#include "TCOutputWaveformView.h"
#include "TCOutputWaveformDoc.h"
#include "TCAddText1.h"
#include "TCPasswordId.h"
#include "TCWorkspaceTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern void DisplayPopupMenu(CWnd*, CPoint, int);
extern TCMultyTaskedString CGlobalStatusMessage;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCWorkspaceTree GCWorkspaceTree;


/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformView

IMPLEMENT_DYNCREATE(TCOutputWaveformView, CScrollView)

TCOutputWaveformView::TCOutputWaveformView()
{
	CSuperSpiceViewData.PCMSchematicManager	= NULL;// notused, copied from syperspice view

	CSuperSpiceViewData.CMaxSize.cx  = 8181;
	CSuperSpiceViewData.CMaxSize.cy  = 8181;
	CSuperSpiceViewData.CPageSize.cx = 128;
	CSuperSpiceViewData.CPageSize.cy = 128;
	CSuperSpiceViewData.CLineSize.cx = 8;
	CSuperSpiceViewData.CLineSize.cy = 8;
	
	CSuperSpiceViewData.CViewPortOrigin.x = 0;
	CSuperSpiceViewData.CViewPortOrigin.y = 0;

	CSuperSpiceViewData.CScrollBarPosition.x = 0;
	CSuperSpiceViewData.CScrollBarPosition.y = 0;

	CLastWindowSize.x = 0;
	CLastWindowSize.y = 0;

	CSuperSpiceViewData.PCMSchematicManager = new TCWaveformGraphicsManager;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.PCMSchematicManager->SetView(( CView *)this);
	CSuperSpiceViewData.PCMSchematicManager->SetViewSize(CSuperSpiceViewData.CMaxSize);

	CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_IDLE;

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);
	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

	first_draw = false;

	m_current_waveform_type = E_SPICE_RECORD_NULL;
	m_is_window_sizing = false;
}

TCOutputWaveformView::~TCOutputWaveformView()
{
	if(CSuperSpiceViewData.PCMSchematicManager) delete CSuperSpiceViewData.PCMSchematicManager;
}


void TCOutputWaveformView::Serialize(CArchive& CArchive) 
{
	CSuperSpiceViewData.Serialize(CArchive);

	if (CArchive.IsStoring())
	{
		CArchive << m_current_waveform_type;

		if(CSuperSpiceViewData.PCMSchematicManager) CSuperSpiceViewData.PCMSchematicManager->Serialize(CArchive);

		GetParent()->GetWindowPlacement(&s_window_placment);

		CArchive.Write(&s_window_placment, sizeof(s_window_placment));
	}
	else 
	{	
		CArchive >> m_current_waveform_type;

		if(CSuperSpiceViewData.PCMSchematicManager) 
		{
			// Make sure all old data is destroyed
			delete CSuperSpiceViewData.PCMSchematicManager;

			CSuperSpiceViewData.PCMSchematicManager = new TCWaveformGraphicsManager;

			if(!CSuperSpiceViewData.PCMSchematicManager) return;

			CSuperSpiceViewData.PCMSchematicManager->SetView(( CView *)this);
			CSuperSpiceViewData.PCMSchematicManager->SetViewSize(CSuperSpiceViewData.CMaxSize);

			CSuperSpiceViewData.PCMSchematicManager->Serialize(CArchive);
		}
		CArchive.Read(&s_window_placment, sizeof(s_window_placment));
	}
}


BEGIN_MESSAGE_MAP(TCOutputWaveformView, CScrollView)
	//{{AFX_MSG_MAP(TCOutputWaveformView)
	ON_COMMAND(ID_VIEW_INCLUDEDMODELSFILE, OnViewIncludedModelsfile)
	ON_COMMAND(ID_VIEW_INCLUDEFILE, OnViewIncludeFile)
	ON_COMMAND(ID_VIEW_SCHEMATIC, OnViewSchematic)
	ON_COMMAND(ID_VIEW_SCHEMATICFILES, OnViewSchematicFiles)
	ON_COMMAND(ID_RUN_RUN, OnRunRun)
	ON_COMMAND(ID_RUN_RUN_SAME_NRT_LIST, OnRunRunSameNrtList)
	ON_COMMAND(IDM_VIEW_OUTPUT_GRAPH, OnViewOutputGraph)
	ON_COMMAND(IDM_VIEW_OUTPUT_TEXT, OnViewOutputText)
	ON_COMMAND(IDM_VIEW_SPICE_TEXT, OnViewSpiceText)
	ON_COMMAND(ID_OPTIONS_SCHEMATIC, OnOptionsSchematic)
	ON_COMMAND(ID_OPTIONS_PROGRAM, OnOptionsProgram)
	ON_COMMAND(IDM_SIMULATION_SETUP, OnSimulationSetup)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_SIZE()
	ON_WM_HELPINFO()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_DRAWING_ZOOMIN, OnDrawingZoomIn)
	ON_COMMAND(ID_DRAWING_ZOOMOUT, OnDrawingZoomOut)
	ON_COMMAND(ID_DRAWING_ZOOMAREA, OnDrawingZoomArea)
	ON_COMMAND(ID_EDIT_SELECT_ALL, OnEditSelectAll)
	ON_COMMAND(ID_AROW_UP, OnArowUp)
	ON_COMMAND(ID_ARROW_DOWN, OnArrowDown)
	ON_COMMAND(ID_ARROW_LEFT, OnArrowLeft)
	ON_COMMAND(ID_ARROW_RIGHT, OnArrowRight)
	ON_COMMAND(ID_PAGE_DOWN, OnPageDown)
	ON_COMMAND(ID_PAGE_UP, OnPageUp)
	ON_WM_SETCURSOR()
	ON_COMMAND(ID_CANCEL_COMMAND, OnCancelCommand)
	ON_COMMAND(ID_RUN_AC, OnRunAc)
	ON_UPDATE_COMMAND_UI(ID_RUN_AC, OnUpdateRunAc)
	ON_COMMAND(ID_RUN_DC, OnRunDc)
	ON_UPDATE_COMMAND_UI(ID_RUN_DC, OnUpdateRunDc)
	ON_COMMAND(ID_RUN_ENABLEDISTORTION, OnRunEnableDistortion)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEDISTORTION, OnUpdateRunEnableDistortion)
	ON_COMMAND(ID_RUN_ENABLEFOURIER, OnRunEnableFourier)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEFOURIER, OnUpdateRunEnableFourier)
	ON_COMMAND(ID_RUN_ENABLENOISE, OnRunEnableNoise)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLENOISE, OnUpdateRunEnableNoise)
	ON_COMMAND(ID_RUN_ENABLEPOLEZERO, OnRunEnablePoleZero)
	ON_COMMAND(ID_RUN_ENABLE_STATISTICS, OnRunStatistics)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEPOLEZERO, OnUpdateRunEnablePoleZero)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLE_STATISTICS, OnUpdateRunStatistics)
	ON_COMMAND(ID_RUN_PARAMETRIC, OnRunParametric)
	ON_UPDATE_COMMAND_UI(ID_RUN_PARAMETRIC, OnUpdateRunParametric)
	ON_COMMAND(ID_RUN_RERUNS, OnRunReRuns)
	ON_UPDATE_COMMAND_UI(ID_RUN_RERUNS, OnUpdateRunReRuns)
	ON_COMMAND(ID_RUN_SENSITIVITY, OnRunSensitivity)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY, OnUpdateRunSensitivity)
	ON_COMMAND(ID_RUN_STOP, OnRunStop)
	ON_COMMAND(ID_RUN_TEMPERATURE, OnRunTemperature)
	ON_UPDATE_COMMAND_UI(ID_RUN_TEMPERATURE, OnUpdateRunTemperature)
	ON_COMMAND(ID_RUN_TRANSIENT, OnRunTransient)
	ON_UPDATE_COMMAND_UI(ID_RUN_TRANSIENT, OnUpdateRunTransient)
	ON_COMMAND(ID_CANCEL_EDIT_CNTR, OnCancelEditCntr)
	ON_COMMAND(ID_WINDOW_NEW_GRAPHIC, OnWindowNewGraph)
	ON_COMMAND(ID_VIEW_TOP_LEVEL_FILES, OnViewTopLevelFiles)
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOMIN, OnUpdateDrawingZoomIn)
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOMOUT, OnUpdateDrawingZoomOut)
	ON_COMMAND(ID_DRAWING_ZOOM_CENTER, OnDrawingZoomCenter)
	ON_COMMAND(ID_ADD_USER_TEXT, OnAddUserText)
	ON_COMMAND(ID_EDIT_COPY_WITH_PASTE, OnEditCopyWithPaste)
	ON_COMMAND(ID_EDIT_PASTE1, OnEditPaste1)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYDCWAVEFORM, OnWaveformsDisplayDCWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYDCWAVEFORM, OnUpdateWaveformsDisplayDCWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYACWAVEFORM, OnWaveformsDisplayACWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYACWAVEFORM, OnUpdateWaveformsDisplayACWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYTRANSWAVEFORM, OnWaveformsDisplayTransWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYTRANSWAVEFORM, OnUpdateWaveformsDisplaytransWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYNOISEWAVEFORM, OnWaveformsDisplayNoiseWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYNOISEWAVEFORM, OnUpdateWaveformsDisplayNoiseWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYFOURIERWAVEFORM, OnWaveformsDisplayFourierWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYFOURIERWAVEFORM, OnUpdateWaveformsDisplayFourierWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYSENSWAVEFORM, OnWaveformsDisplaySensitivityWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYSENSWAVEFORM, OnUpdateWaveformsDisplaySensitivityWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYPOLEZEROWAVEFORM, OnWaveformsDisplayPoleZeroWaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYPOLEZEROWAVEFORM, OnUpdateWaveformsDisplayPoleZeroWaveform)
	ON_COMMAND(ID_WAVEFORMS_DISTORTION, OnWaveformsDistortion)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISTORTION, OnUpdateWaveformsDistortion)
	ON_COMMAND(ID_WINDOW_NEW, OnWindowNew)
	ON_COMMAND(ID_AXIS_MAGNIFY, OnAxisMagnify)
	ON_COMMAND(ID_AXIS_REDUCE, OnAxisReduce)
	ON_COMMAND(ID_AXIS_SCROL_XLEFT, OnAxisScrollXLeft)
	ON_COMMAND(ID_AXIS_SCROL_XRIGHT, OnAxisScrollXRight)
	ON_COMMAND(ID_AXIS_SCROLL_YDOWN, OnAxisScrollYDown)
	ON_COMMAND(ID_AXIS_SCROLL_YUP, OnAxisScrollYUp)
	ON_UPDATE_COMMAND_UI(ID_AXIS_MAGNIFY, OnUpdateAxisMagnify)
	ON_UPDATE_COMMAND_UI(ID_AXIS_REDUCE, OnUpdateAxisReduce)
	ON_UPDATE_COMMAND_UI(ID_AXIS_SCROL_XLEFT, OnUpdateAxisScrollXLeft)
	ON_UPDATE_COMMAND_UI(ID_AXIS_SCROL_XRIGHT, OnUpdateAxisScrollXRight)
	ON_UPDATE_COMMAND_UI(ID_AXIS_SCROLL_YDOWN, OnUpdateAxisScrollYDown)
	ON_UPDATE_COMMAND_UI(ID_AXIS_SCROLL_YUP, OnUpdateAxisScrollYUp)
	ON_COMMAND(ID_GRAPHICS_PLACENEWGRAPH, OnGraphicsPlaceNewGraph)
	ON_COMMAND(ID_RUN_ENABLEOPERATINGPOINT, OnRunEnableOperatingPoint)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEOPERATINGPOINT, OnUpdateRunEnableOperatingPoint)
	ON_COMMAND(ID_AXIS_AUTOSCALE, OnAxisAutoScale)
	ON_COMMAND(ID_VIEW_DESIGNNOTES, OnViewDesignNotes)
	ON_COMMAND(ID_HELP_GETCOMPUTERPASSWORD, OnHelpGetcomputerpassword)
	ON_COMMAND(ID_EDIT_COPY_TO_WINDOWS_CLIPBOARD, OnEditCopyToWindowsClipboard)
	ON_COMMAND(ID_RUN_RUNDEBUGMODE, OnRunRunDebugMode)
	ON_COMMAND(ID_VIEW_COMPONENTMAKER, OnViewComponentMaker)
	ON_COMMAND(ID_RUN_SENSITIVITY_AC, OnRunSensitivityAc)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY_AC, OnUpdateRunSensitivityAc)
	ON_COMMAND(ID_WAVEFORMS_DISTORTION2, OnWaveformsDistortion2)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISTORTION2, OnUpdateWaveformsDistortion2)
	ON_COMMAND(ID_WAVEFORMS_DISTORTION_F2, OnWaveformsDistortionF2)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISTORTION_F2, OnUpdateWaveformsDistortionF2)
	ON_COMMAND(ID_PROPERTY_ACCELERATER, OnPropertyAccelerater)
	ON_COMMAND(ID_WAVEFORMS_TRANTOFREQFFT, OnWaveformsTrantofreqFFT)
	ON_COMMAND(ID_WAVEFORMS_ACTOTIMEDOMAINFFT, OnWaveformsActotimedomainFFT)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_TRANTOFREQFFT, OnUpdateWaveformsTrantofreqFFT)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_ACTOTIMEDOMAINFFT, OnUpdateWaveformsActotimedomainFFT)
	ON_COMMAND(ID_VIEW_PCBNETLIST, OnViewPcbNetlist)
	ON_COMMAND(ID_VIEW_SPICEENGNEERRORLOG, OnViewDisplaySpiceErrorLog)
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_POPUP_PROPERTIES_VIEW, OnPopupProperties)
	ON_COMMAND(ID_POPUP_CHANGEWAVECOLOUR, OnPopupChangeWaveColour)
	ON_COMMAND(ID_POPUP_CLEARALLWAVEFORMS, OnPopUpClearAllWaveforms)
	ON_COMMAND(ID_POPUP_CHANGE_BKG_COLOUR, OnPopupChangeGraphBKGColour)
	ON_COMMAND(ID_EDIT_SELECTALL, OnEditSelectAll)
	ON_COMMAND(ID_EDIT_DEBAGTEST2, OnEditDebagtest2)
	//}}AFX_MSG_MAP

	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
	ON_COMMAND(ID_RUN_ENABLEMONTECARLO, &TCOutputWaveformView::OnRunEnableMonteCarlo)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEMONTECARLO, &TCOutputWaveformView::OnUpdateRunEnableMonteCarlo)
	END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformView drawing

void TCOutputWaveformView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();

	pDC;
	pDoc;
	if(!CSuperSpiceViewData.PCMSchematicManager) return;


	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(first_draw)
	{
		first_draw = false;

		SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

		GetParent()->SetWindowPlacement(&s_window_placment);
	}

	if(!pDC->IsPrinting())
	{
		PCDoc->OnViewOnDraw(this, pDC);
	}
	else
	{
		PCDoc->Print(this, pDC);
	}
}

void TCOutputWaveformView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender, lHint, pHint;
	
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

	Update();
}

void TCOutputWaveformView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

void TCOutputWaveformView::Update(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc*) GetDocument();
	
	if(!PCDoc) return;

	CSuperSpiceViewData.PCMSchematicManager->PCWaveformDataRuns = PCDoc->GetWaveformDataRuns();

	UpdateWaveforms(m_current_waveform_type);
}

void TCOutputWaveformView::UpdateWaveforms(int type)
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc*) GetDocument();
	if(!PCDoc) return;
	// Create at least one window if non exists

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();
	
	if(!PCOutputWaveformData) return;

	CSuperSpiceViewData.PCMSchematicManager->PCWaveformDataRuns = PCDoc->GetWaveformDataRuns();

	if(!CSuperSpiceViewData.PCMSchematicManager->PCWaveformDataRuns) return;

	TCOutputWaveformDataHeader COutputWaveformDataHeader;

	int count =	CSuperSpiceViewData.PCMSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	m_current_waveform_type = type;

	if(m_current_waveform_type < PCOutputWaveformData->CRecords.GetSize())
			CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCOutputWaveformData->CRecords[m_current_waveform_type].CHeader);
	else CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(COutputWaveformDataHeader);// create default graphic component

	if(count)
	{
		CSuperSpiceViewData.PCMSchematicManager->UpdateGraphicWaveforms(*PCOutputWaveformData, PCDoc->CTestPointDataList);
	}
}


void TCOutputWaveformView::SetScrollSizesZoomed(float zoom)
{
	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	CMaxSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CMaxSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	// MFC asserts for this, presumably due to 16 bit problems
	// need to correct this later
	if(CMaxSize.cx > 32767) CMaxSize.cx = 32767;
	if(CMaxSize.cy > 32767) CMaxSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}
/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformView diagnostics

#ifdef _DEBUG
void TCOutputWaveformView::AssertValid() const
{
	CView::AssertValid();
}

void TCOutputWaveformView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformView message handlers


void TCOutputWaveformView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	DisplayPopupMenu(this, point, CG_IDR_POPUP_TCSUPER_SPICE_GRAPHIC);
	
	CView::OnRButtonDown(nFlags, point);
}

void TCOutputWaveformView::OnViewIncludeFile() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayIncludeText(this);
	
}
void TCOutputWaveformView::OnViewOutputGraph() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewDisplayOutputGraph(this);
}

void TCOutputWaveformView::OnViewComponentMaker() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewDisplaySymbolEditor(this);
	
}

void TCOutputWaveformView::OnViewSpiceText() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewDisplayInputText(this);
}

void TCOutputWaveformView::OnViewOutputText() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayOutputText(this);
	
}
void TCOutputWaveformView::OnViewIncludedModelsfile() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplayModelsText(this);
	
}

void TCOutputWaveformView::OnViewSchematic() 
{
	GCWorkspaceTree.RefreshSchematicFiles();
}


void TCOutputWaveformView::OnViewSchematicFiles() 
{
	GCWorkspaceTree.RefreshSchematicFiles();
}

void TCOutputWaveformView::OnRunRun() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnRunRun(this);
}

void TCOutputWaveformView::OnRunRunDebugMode() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnRunRunDebugMode(this);	
}

void TCOutputWaveformView::OnRunRunSameNrtList() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnRunRun(this, false);
}


void TCOutputWaveformView::OnOptionsSchematic() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	TCSuperSpiceView *PCSuperSpiceView = PCDoc->GetSchematicView();

	if(!PCSuperSpiceView) return;

	PCSuperSpiceView->OnOptionsSchematic();
	
}

void TCOutputWaveformView::OnOptionsProgram() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	PCDoc->PCParentSuperSpiceDoc->OnOptionsProgram();
	
}

void TCOutputWaveformView::OnSimulationSetup() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	PCDoc->PCParentSuperSpiceDoc->OnViewSimulationSetup();
	
}

void TCOutputWaveformView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	if(CLastWindowSize.x == cx && CLastWindowSize.y == cy) return;

	CLastWindowSize.x = cx;
	CLastWindowSize.y = cy;

	m_is_window_sizing = true;
}

void TCOutputWaveformView::OnLButtonDown(UINT nFlags, CPoint CMousePosition) 
{
	CSuperSpiceViewData.CLastLBDownMousePosition = CMousePosition;

	if(CSuperSpiceViewData.PCMSchematicManager)
	{
		TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

		PCDoc->OnViewSetZoomCenter(this, CMousePosition);
	}

	if(CSuperSpiceViewData.PCMSchematicManager)

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedLBDown(nFlags, CMousePosition); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingLBDown(nFlags, CMousePosition);break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionLBDown(nFlags, CMousePosition);break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW: SizingWaveformWindowLBDown(nFlags, CMousePosition);break;

		default: IdleOnCancel();
	}
	
	CView::OnLButtonDown(nFlags, CMousePosition);
}

void TCOutputWaveformView::OnLButtonUp(UINT nFlags, CPoint CMousePosition) 
{
	if(CSuperSpiceViewData.PCMSchematicManager)	
	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingLBUp(nFlags, CMousePosition); break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW: SizingWaveformWindowLBUp(nFlags, CMousePosition);break;

		default: IdleOnCancel();
	}
	
	CView::OnLButtonUp(nFlags, CMousePosition);
}

void TCOutputWaveformView::OnLButtonDblClk(UINT nFlags, CPoint CMousePosition) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnLButtonDblClk(nFlags, CMousePosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	PCDoc->OnLButtonDblClk(this, CMousePosition, nFlags);

	CView::OnLButtonDblClk(nFlags, CMousePosition);
}

void TCOutputWaveformView::GetComponent(int graphic_id, short version)
{
	if(CSuperSpiceViewData.PCMSchematicManager)

	OnCancelCommand();

	if(graphic_id)
		CGlobalStatusMessage = E_STATUS_MSG_PLACING_COMPONENT;
	else CGlobalStatusMessage = E_STATUS_MSG_GETING_LIB_COMPONENT;

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedGetGraphic(graphic_id, version); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingGetGraphic(graphic_id, version);break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionGetGraphic(graphic_id, version);break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardGetGraphic(graphic_id, version);break;


		default: IdleOnCancel();
	}
}

void TCOutputWaveformView::OnMouseMove(UINT nFlags, CPoint CMousePosition) 
{
	if(m_is_window_sizing) SetGraphSize();// when mouse enters the client area for the first time graph will get resized
	
	m_is_window_sizing = false;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(CSuperSpiceViewData.CLastMousePosition == CMousePosition) return;

	CSuperSpiceViewData.CLastMousePosition = CMousePosition; 

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW: SizingWaveformWindowMouseMoved(nFlags, CMousePosition);break;

		default: IdleOnCancel();
	}

	CView::OnMouseMove(nFlags, CMousePosition);
}

void TCOutputWaveformView::SetGraphSize()
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.lock_graph_size_to_window_size) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->SetGraphSize(this);
}

void TCOutputWaveformView::SizingWaveformWindowLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSizingWaveformWindowLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::SizingWaveformWindowMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSizingWaveformWindowMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::SizingWaveformWindowLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSizingWaveformWindowLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::IdleGetGraphic(int graphic_id, short version)
{
	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCOutputWaveformView::GraphicsSelectedGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateGetGraphic(this, CSuperSpiceViewData.page_id,CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCOutputWaveformView::GraphicsMovingGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
	
void TCOutputWaveformView::SelectRegionGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}	
	 
void TCOutputWaveformView::GotGraphicGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
 
void TCOutputWaveformView::GotClipboardGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCOutputWaveformView::IdleLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCOutputWaveformView::GraphicsSelectedLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}


void TCOutputWaveformView::GraphicsMovingLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::SelectRegionLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}


void TCOutputWaveformView::GotGraphicLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCOutputWaveformView::GotClipboardLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCOutputWaveformView::IdleLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags,CMousePosition);
}

void TCOutputWaveformView::GraphicsSelectedLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::GraphicsMovingLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::SelectRegionLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateLBUp(this, CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}

void TCOutputWaveformView::GotGraphicLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}


void TCOutputWaveformView::GotClipboardLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}
void TCOutputWaveformView::IdleMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::GraphicsSelectedMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::GraphicsMovingMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::SelectRegionMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::GotGraphicMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCOutputWaveformView::IdleOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleOnCancel(this);
}

void TCOutputWaveformView::GraphicsSelectedOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedOnCancel(this);
}

void TCOutputWaveformView::GraphicsMovingOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingOnCancel(this);	
}

void TCOutputWaveformView::SelectRegionOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionOnCancel(this);
}

void TCOutputWaveformView::GotGraphicOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicOnCancel(this);
}

void TCOutputWaveformView::GotClipboardOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardOnCancel(this);
}
void TCOutputWaveformView::OnEditDelete() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditDelete(this);
}

void TCOutputWaveformView::OnEditCut() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCut(this);
}

void TCOutputWaveformView::OnEditCopy() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();	

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopy(this);
}

void TCOutputWaveformView::OnEditCopyToWindowsClipboard() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();	

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopyToWindowsClipboard(this);	
}

void TCOutputWaveformView::OnEditCopyWithPaste() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopy(this);

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
}

void TCOutputWaveformView::OnEditPaste1() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
}
void TCOutputWaveformView::OnEditSelectAll() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditSelectAll(this);
}

void TCOutputWaveformView::OnDrawingZoomArea() 
{
	// TODO: Add your command handler code here
	
}

void TCOutputWaveformView::OnCancelCommand() 
{
	CGlobalStatusMessage = E_STATUS_MSG_IDLE;

	m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);
	SetCursor(m_hcursor);

	if(CSuperSpiceViewData.PCMSchematicManager)	
	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingOnCancel(); break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardOnCancel();break;

		default: break;
	}	
}

void TCOutputWaveformView::OnCancelEditCntr() 
{
	OnCancelCommand();	
}


void TCOutputWaveformView::OnArowUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y -= CSuperSpiceViewData.CLineSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCOutputWaveformView::OnArrowDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y += CSuperSpiceViewData.CLineSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCOutputWaveformView::OnArrowLeft() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.x -= CSuperSpiceViewData.CPageSize.cx;

	SetScrollBarPosition(CNewPosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCOutputWaveformView::OnArrowRight() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.x += CSuperSpiceViewData.CPageSize.cx;

	SetScrollBarPosition(CNewPosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCOutputWaveformView::OnPageDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y += CSuperSpiceViewData.CPageSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCOutputWaveformView::OnPageUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y -= CSuperSpiceViewData.CPageSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}


void TCOutputWaveformView::OnRunAc() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CACSetupData.CSweepData.enable = !CAnalysisSetup.CACSetupData.CSweepData.enable;
}

void TCOutputWaveformView::OnUpdateRunAc(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CACSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunDc() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.CSweepData1.enable = !CAnalysisSetup.CDCSetupData.CSweepData1.enable;

}

void TCOutputWaveformView::OnUpdateRunDc(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDCSetupData.CSweepData1.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunEnableOperatingPoint() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();

	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.enable_operating_point = !CAnalysisSetup.CDCSetupData.enable_operating_point;

}

void TCOutputWaveformView::OnUpdateRunEnableOperatingPoint(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();

	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(!!CAnalysisSetup.CDCSetupData.enable_operating_point);

	pCmdUI->ContinueRouting();
}
void TCOutputWaveformView::OnRunEnableNoise() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CNoiseSetupData.enable = !CAnalysisSetup.CNoiseSetupData.enable;

//	if(CAnalysisSetup.CNoiseSetupData.enable) CAnalysisSetup.CACSetupData.CSweepData.enable = true;
}

void TCOutputWaveformView::OnUpdateRunEnableNoise(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CNoiseSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunTransient() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.CSweepData.enable = !CAnalysisSetup.CTransientSetupData.CSweepData.enable;

}

void TCOutputWaveformView::OnUpdateRunTransient(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunEnableFourier() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.fourier_enable = !CAnalysisSetup.CTransientSetupData.fourier_enable;

	if(CAnalysisSetup.CTransientSetupData.fourier_enable) CAnalysisSetup.CTransientSetupData.CSweepData.enable = true;

}

void TCOutputWaveformView::OnUpdateRunEnableFourier(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.fourier_enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunStatistics() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CStatisticsSetupData.enable = !CAnalysisSetup.CStatisticsSetupData.enable;

	if(CAnalysisSetup.CStatisticsSetupData.enable)
	{
		CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
	}
}

void TCOutputWaveformView::OnUpdateRunStatistics(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CStatisticsSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunParametric() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CParametricSetupData.CSweepData.enable = !CAnalysisSetup.CParametricSetupData.CSweepData.enable;

	if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCOutputWaveformView::OnUpdateRunParametric(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CParametricSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunTemperature() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = !CAnalysisSetup.CTemperatureSetupData.CSweepData.enable;

	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable &&
	   CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
	{
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CReRun.enable = false;
	}
}

void TCOutputWaveformView::OnUpdateRunTemperature(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunSensitivity() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_dc = !CAnalysisSetup.CSensitivitySetupData.enable_dc;

	if(CAnalysisSetup.CSensitivitySetupData.enable_dc) CAnalysisSetup.CSensitivitySetupData.enable_ac = false;
}

void TCOutputWaveformView::OnUpdateRunSensitivity(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_dc);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunSensitivityAc() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_ac = !CAnalysisSetup.CSensitivitySetupData.enable_ac;	

	if(CAnalysisSetup.CSensitivitySetupData.enable_ac) CAnalysisSetup.CSensitivitySetupData.enable_dc = false;
}

void TCOutputWaveformView::OnUpdateRunSensitivityAc(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_ac);

	pCmdUI->ContinueRouting();	
}
void TCOutputWaveformView::OnRunEnablePoleZero() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CPoleZeroSetupData.enable = !CAnalysisSetup.CPoleZeroSetupData.enable;

	if(CAnalysisSetup.CPoleZeroSetupData.enable) CAnalysisSetup.CACSetupData.CSweepData.enable = true;

}

void TCOutputWaveformView::OnUpdateRunEnablePoleZero(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CPoleZeroSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunEnableDistortion() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDistortionSetupData.enable = !CAnalysisSetup.CDistortionSetupData.enable;
}

void TCOutputWaveformView::OnUpdateRunEnableDistortion(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDistortionSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunReRuns() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCOutputWaveformView::OnUpdateRunReRuns(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES ||
		CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}

void TCOutputWaveformView::OnRunStop() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->OnRunStop();
}

void TCOutputWaveformView::OnRunEnableMonteCarlo()
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_MC_RERUN_FILE;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCOutputWaveformView::OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI)
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}

BOOL TCOutputWaveformView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	pWnd; nHitTest;  message;

	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return true;

	pWnd; nHitTest;  message;

	if(!CSuperSpiceViewData.PCMSchematicManager) return true;

	int type = CSuperSpiceViewData.PCMSchematicManager->GetComponentOutlinedType();
	
	TCSchematicObject *PCSchematicObject = CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent;
	bool waveform_corner = false;
	
	if(PCSchematicObject)
		if(!IsBadReadPtr(PCSchematicObject, 4))
			if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT) waveform_corner = true;

	if(type)
	{
		switch(type)
		{
			case E_SCHEMATIC_PIN:	if(!waveform_corner){m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;}
									else m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_SIZENWSE);break;

			case E_SCHEMATIC_OBJECT:		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_WAVEFORM_OBJECT:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_TEXT_LABEL:	m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_LABEL:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;

			case E_WAVEFORM_OBJECT_SCREEN: m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE);break;

			default: m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
		}
	}
	else
	{
		switch(CSuperSpiceViewData.system_state)
		{
			case E_GRAPHICS_MANAGER_STATE_IDLE:		
			 m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
			case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:
			 m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
			case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:
			 m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;		 
			case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:
			 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:
			 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			
			case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:
				 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_CLOSED_HAND);break;

			default: break;
		}
	}

	SetCursor(m_hcursor);

	return true;
}



void TCOutputWaveformView::OnWindowNewGraph() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCSuperSpiceDoc *PCSDoc = PCDoc->PCParentSuperSpiceDoc;

	PCSDoc = PCSDoc->GetTopLevelDoc();

	if(!PCSDoc) return;

	PCSDoc->OnViewNewGraph(this);
}

void TCOutputWaveformView::OnViewTopLevelFiles() 
{

	GCWorkspaceTree.RefreshSchematicFiles();
}

void TCOutputWaveformView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);

	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->EraseComponentOutline();

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());
}


CPoint TCOutputWaveformView::GetScrollBarPosition(void)
{
	CPoint CScrollBarPosition;

	CScrollBarPosition.y = GetScrollPos(SB_VERT);
	CScrollBarPosition.x = GetScrollPos(SB_HORZ);

	return CScrollBarPosition;
}

void TCOutputWaveformView::SetScrollBarPosition(CPoint CScrollBarPosition)
{
	if(CScrollBarPosition.x < 0) CScrollBarPosition.x = 0;
	if(CScrollBarPosition.x >= CSuperSpiceViewData.CMaxSize.cx -1)
		CScrollBarPosition.x = CSuperSpiceViewData.CMaxSize.cx;


	CScrollBarPosition.x = CScrollBarPosition.x / CSuperSpiceViewData.CLineSize.cx;
	CScrollBarPosition.x = CScrollBarPosition.x * CSuperSpiceViewData.CLineSize.cx;

	CScrollBarPosition.y = CScrollBarPosition.y / CSuperSpiceViewData.CLineSize.cy;
	CScrollBarPosition.y = CScrollBarPosition.y * CSuperSpiceViewData.CLineSize.cy;


	if(CScrollBarPosition.y < 0) CScrollBarPosition.y = 0;
	if(CScrollBarPosition.y >= CSuperSpiceViewData.CMaxSize.cy - 1)
		CScrollBarPosition.y = CSuperSpiceViewData.CMaxSize.cy;

	SetScrollPos(SB_VERT, CScrollBarPosition.y);
	SetScrollPos(SB_HORZ, CScrollBarPosition.x);
	OnHScroll(SB_THUMBTRACK, CScrollBarPosition.x, NULL);
	OnVScroll(SB_THUMBTRACK,CScrollBarPosition.y, NULL); 
}
void TCOutputWaveformView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
	
	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->EraseComponentOutline();

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);	

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());

}

void TCOutputWaveformView::OnDrawingZoomIn() 
{
	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewZoomIn(this);

	float zoom = CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	CMaxSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CMaxSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	// MFC asserts for this, presumably due to 16 bit problems
	// need to correct this later
	if(CMaxSize.cx > 32767) CMaxSize.cx = 32767;
	if(CMaxSize.cy> 32767) CMaxSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

void TCOutputWaveformView::OnUpdateDrawingZoomIn(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(PCDoc->OnViewCheckZoomIn(this))
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(false);
	}
	
}

void TCOutputWaveformView::OnDrawingZoomOut() 
{
	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSize CPageSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	PCDoc->OnViewZoomOut(this);
	
	float zoom = CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	CPageSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CPageSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	if(CPageSize.cx > 32767) CPageSize.cx = 32767;
	if(CPageSize.cy> 32767) CPageSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CPageSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
	
}

void TCOutputWaveformView::OnUpdateDrawingZoomOut(CCmdUI* pCmdUI) 
{
	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(PCDoc->OnViewCheckZoomOut(this))
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(false);
	}
}

void TCOutputWaveformView::OnDrawingZoomCenter() 
{
	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc;
//	PCDoc->OnViewZoomCenter(this, GlobalMousePosition);
}

void TCOutputWaveformView::OnAddUserText() 
{
	TCAddText1 CDlgText;
	
	CDlgText.CMEditAddText = GCSuperSpiceDataBase.CMDefaults[E_LABEL_COMPONENT].CLabel;
	
	if(CDlgText.DoModal() == IDCANCEL) return;

	CString CText = CDlgText.CMEditAddText;

	CString CTemp = CText;

	CTemp.TrimLeft();

	if(CTemp == "") return;
	
	TCSchematicObjectData CSchematicObjectDataBase;

	GCSuperSpiceDataBase.CMDefaults[E_LABEL_COMPONENT].CLabel =  CText;

	GetComponent(E_LABEL_COMPONENT, -1);

	CGlobalStatusMessage = E_STATUS_MSG_PLACING_TEXT;	
}

void TCOutputWaveformView::OnGraphicsPlaceNewGraph() 
{
	GetComponent(E_WAVEFORM_COMPONENT, -1);	
}

BOOL TCOutputWaveformView::OnPreparePrinting(CPrintInfo* pInfo) 
{
	// TODO: call DoPreparePrinting to invoke the Print dialog box
	
//	return CScrollView::OnPreparePrinting(pInfo);

	return DoPreparePrinting(pInfo);
}

void TCOutputWaveformView::OnWaveformsDisplayDCWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_DC))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_DC, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_DC;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_DC);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
	
}

void TCOutputWaveformView::OnUpdateWaveformsDisplayDCWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_DC));
}

void TCOutputWaveformView::OnWaveformsDisplayACWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_AC))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_AC, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_AC;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_AC);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
}

void TCOutputWaveformView::OnUpdateWaveformsDisplayACWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC));
}

void TCOutputWaveformView::OnWaveformsDisplayTransWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_TRANSIENT))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_TRANSIENT, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_TRANSIENT;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
	
}

void TCOutputWaveformView::OnUpdateWaveformsDisplaytransWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT));	
}

void TCOutputWaveformView::OnWaveformsDisplayNoiseWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_NOISE_SPECTRAL))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_NOISE_SPECTRAL, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_NOISE_SPECTRAL;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_NOISE_SPECTRAL);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
	
}

void TCOutputWaveformView::OnUpdateWaveformsDisplayNoiseWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_NOISE_SPECTRAL));
	
}

void TCOutputWaveformView::OnWaveformsDisplayFourierWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_FOURIER))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_FOURIER, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_FOURIER;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_FOURIER);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}

void TCOutputWaveformView::OnUpdateWaveformsDisplayFourierWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_FOURIER));
	
}

void TCOutputWaveformView::OnWaveformsDisplaySensitivityWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;
	
	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_SENSITIVITY);

	if(index < 0) return;

	PCDoc->OnViewDisplaySensitivityText(this);
}

void TCOutputWaveformView::OnUpdateWaveformsDisplaySensitivityWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_SENSITIVITY));
}

void TCOutputWaveformView::OnWaveformsDisplayPoleZeroWaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;
	
	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_POLE_ZERO);

	if(index < 0) return;

	PCDoc->OnViewDisplayPoleZeroText(this);
}

void TCOutputWaveformView::OnUpdateWaveformsDisplayPoleZeroWaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_POLE_ZERO));
}

void TCOutputWaveformView::OnWaveformsDistortion2() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_THD;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_THD);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
}

void TCOutputWaveformView::OnUpdateWaveformsDistortion2(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_THD));
}


void TCOutputWaveformView::OnWaveformsDistortion() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_IMD;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_IMD);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
}

void TCOutputWaveformView::OnUpdateWaveformsDistortion(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_IMD));
}

void TCOutputWaveformView::OnWaveformsDistortionF2() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_DISTORTION_IMD_2F;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_DISTORTION_IMD_2F);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
	
}

void TCOutputWaveformView::OnUpdateWaveformsDistortionF2(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_DISTORTION_IMD_2F));
}

void TCOutputWaveformView::OnAxisAutoScale() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisAutoScale();
}

void TCOutputWaveformView::OnWindowNew() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	PCDoc->OnViewNewView(this);
}

void TCOutputWaveformView::OnAxisMagnify() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisMagnify();
}

void TCOutputWaveformView::OnAxisReduce() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisReduce(); 
}

void TCOutputWaveformView::OnAxisScrollXLeft() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisScrollXLeft(); 
}

void TCOutputWaveformView::OnAxisScrollXRight() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisScrollXRight();
}

void TCOutputWaveformView::OnAxisScrollYDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisScrollYDown();
}

void TCOutputWaveformView::OnAxisScrollYUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisScrollYUp();
}

void TCOutputWaveformView::OnUpdateAxisMagnify(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_current_waveform_type > 0);	
}

void TCOutputWaveformView::OnUpdateAxisReduce(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_current_waveform_type > 0);	
}

void TCOutputWaveformView::OnUpdateAxisScrollXLeft(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_current_waveform_type > 0);		
}

void TCOutputWaveformView::OnUpdateAxisScrollXRight(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_current_waveform_type > 0);		
}

void TCOutputWaveformView::OnUpdateAxisScrollYDown(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_current_waveform_type > 0);	
}

void TCOutputWaveformView::OnUpdateAxisScrollYUp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_current_waveform_type > 0);		
}

void TCOutputWaveformView::OnViewDesignNotes() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCSuperSpiceDoc *PCSDoc = PCDoc->PCParentSuperSpiceDoc;

	PCSDoc = PCSDoc->GetTopLevelDoc();

	if(!PCSDoc) return;

	PCSDoc->OnViewDisplayDesignNotes(this);
}

void TCOutputWaveformView::OnHelpGetcomputerpassword() 
{
	TCPasswordId CPasswordId;

	CPasswordId.DoModal();	
}


BOOL TCOutputWaveformView::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// need to modify to go direct to relevent help

	pHelpInfo;

	AfxGetApp()->WinHelpInternal(0, HELP_CONTENTS);
	
	return true;	
}


void TCOutputWaveformView::OnPropertyAccelerater() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCSuperSpiceDoc *PCSDoc = PCDoc->PCParentSuperSpiceDoc;

	PCSDoc = PCSDoc->GetTopLevelDoc();

	if(!PCSDoc) return;

	PCDoc->OnViewPropertyAccelerater(this);		
}

void TCOutputWaveformView::OnWaveformsTrantofreqFFT() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();	

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_TIME_TO_FREQ_FFT;

	int index = E_SPICE_RECORD_TIME_TO_FREQ_FFT;

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
}

void TCOutputWaveformView::OnUpdateWaveformsTrantofreqFFT(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_TIME_TO_FREQ_FFT));		
}


void TCOutputWaveformView::OnWaveformsActotimedomainFFT() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_FREQ_TO_TIME_FFT;

	int index = E_SPICE_RECORD_FREQ_TO_TIME_FFT;

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}

void TCOutputWaveformView::OnUpdateWaveformsActotimedomainFFT(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_FREQ_TO_TIME_FFT));		
}

void TCOutputWaveformView::OnViewPcbNetlist() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewPcbNetlist(this);	
}

void TCOutputWaveformView::OnViewDisplaySpiceErrorLog() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplaySpiceErrorLog(this);	
}

void TCOutputWaveformView::OnSetFocus(CWnd* pOldWnd) 
{
	CScrollView::OnSetFocus(pOldWnd);
	
	PCSuperSpiceDocLastFocused = NULL;
	PCSuperSpiceViewLastFocused  = NULL;
	
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();

	PCDoc->m_waveform_type = m_current_waveform_type;

	TCSuperSpiceDoc *PCSuperSpiceDoc = PCDoc->PCParentSuperSpiceDoc;

	if(!PCSuperSpiceDoc) return;

	PCSuperSpiceDoc = PCSuperSpiceDoc->GetTopLevelDoc();

	if(!PCSuperSpiceDoc) return;

	GCWorkspaceTree.LoadSignalsList(&PCSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns, m_current_waveform_type);
}


void TCOutputWaveformView::OnPopupProperties() 
{
	OnLButtonDblClk(0, CSuperSpiceViewData.CLastMousePosition);
}

void TCOutputWaveformView::OnPopupChangeWaveColour() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ChangeWaveformColour(this);
}

void TCOutputWaveformView::OnPopUpClearAllWaveforms(void) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ClearAllWaveforms(this);
}

void TCOutputWaveformView::OnPopupChangeGraphBKGColour(void) 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ChangeGraphBKGColour(this);
}

void TCOutputWaveformView::OnEditDebagtest2() 
{
	TCOutputWaveformDoc* PCDoc = (TCOutputWaveformDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnDebugTest2();
}


