#if !defined(AFX_TCOUTPUTWAVEFORMVIEW_H__76DA29C1_E920_11D2_AD95_10BE4FC10000__INCLUDED_)
#define AFX_TCOUTPUTWAVEFORMVIEW_H__76DA29C1_E920_11D2_AD95_10BE4FC10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TCOutputWaveformView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// TCOutputWaveformView view
#include "TCOutputWaveformData.h"

class TCWaveformGraphicsManager;

class TCOutputWaveformView : public CScrollView
{

	HCURSOR m_hcursor;

protected:
	TCOutputWaveformView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(TCOutputWaveformView)

// Attributes
public:

	friend class TCOutputWaveformDoc;

	CPoint CLastWindowSize;
	
// Operations
public:

	TCSuperSpiceViewData		CSuperSpiceViewData;
	WINDOWPLACEMENT				s_window_placment;
	bool						first_draw;
	int							m_current_waveform_type;
	bool						m_is_window_sizing;

	void SetScrollSizesZoomed(float zoom);
	CPoint GetScrollBarPosition(void);
	void	SetScrollBarPosition(CPoint CScrollBarPosition);

	void Update(void);// fucking M.S. functins get called when no valid view!!

	void GetComponent(int graphic_id, short version = 0);

	void IdleOnCancel(void);				// wrong way round in naming !!
	void GraphicsSelectedOnCancel(void);
	void GraphicsMovingOnCancel(void);	
	void SelectRegionOnCancel(void);
	void GotGraphicOnCancel(void);
	void GotClipboardOnCancel(void);

	void UpdateWaveforms(int type);

	void IdleGetGraphic(int graphic_id = 0, short version = 0);
	void GraphicsSelectedGetGraphic(int graphic_id = 0, short version = 0);
	void GraphicsMovingGetGraphic(int graphic_id = 0, short version = 0);	
	void SelectRegionGetGraphic(int graphic_id = 0, short version = 0);		 
	void GotGraphicGetGraphic(int graphic_id = 0, short version = 0);
	void GotClipboardGetGraphic(int graphic_id = 0, short version = 0);

	void IdleLBDown(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedLBDown(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingLBDown(UINT nFlags, CPoint CMousePosition);
	void SelectRegionLBDown(UINT nFlags, CPoint CMousePosition);
	void GotGraphicLBDown(UINT nFlags, CPoint CMousePosition);
	void GotClipboardLBDown(UINT nFlags, CPoint CMousePosition);
	void SizingWaveformWindowLBDown(UINT nFlags, CPoint CMousePosition);


	void IdleLBUp(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedLBUp(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingLBUp(UINT nFlags, CPoint CMousePosition);
	void SelectRegionLBUp(UINT nFlags, CPoint CMousePosition);
	void GotGraphicLBUp(UINT nFlags, CPoint CMousePosition);
	void GotClipboardLBUp(UINT nFlags, CPoint CMousePosition);
	void SizingWaveformWindowLBUp(UINT nFlags, CPoint CMousePosition);
	void SetGraphSize();

	void IdleMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingMouseMoved(UINT nFlags, CPoint CMousePosition);
	void SelectRegionMouseMoved(UINT nFlags, CPoint CMousePosition);	
	void GotGraphicMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition);
	void SizingWaveformWindowMouseMoved(UINT nFlags, CPoint CMousePosition);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCOutputWaveformView)
	public:
	virtual void OnInitialUpdate();
	virtual void Serialize(CArchive& ar);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~TCOutputWaveformView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(TCOutputWaveformView)
	afx_msg void OnViewIncludedModelsfile();
	afx_msg void OnViewIncludeFile();
	afx_msg void OnViewSchematic();
	afx_msg void OnViewSchematicFiles();
	afx_msg void OnRunRun();
	afx_msg void OnRunRunSameNrtList();
	afx_msg void OnViewOutputGraph();
	afx_msg void OnViewOutputText();
	afx_msg void OnViewSpiceText();
	afx_msg void OnOptionsSchematic();
	afx_msg void OnOptionsProgram();
	afx_msg void OnSimulationSetup();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditDelete();
	afx_msg void OnEditCut();
	afx_msg void OnEditCopy();
	afx_msg void OnDrawingZoomIn();
	afx_msg void OnDrawingZoomOut();
	afx_msg void OnDrawingZoomArea();
	afx_msg void OnEditSelectAll();
	afx_msg void OnArowUp();
	afx_msg void OnArrowDown();
	afx_msg void OnArrowLeft();
	afx_msg void OnArrowRight();
	afx_msg void OnPageDown();
	afx_msg void OnPageUp();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnCancelCommand();
	afx_msg void OnRunAc();
	afx_msg void OnUpdateRunAc(CCmdUI* pCmdUI);
	afx_msg void OnRunDc();
	afx_msg void OnUpdateRunDc(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableDistortion();
	afx_msg void OnUpdateRunEnableDistortion(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableFourier();
	afx_msg void OnUpdateRunEnableFourier(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableNoise();
	afx_msg void OnUpdateRunEnableNoise(CCmdUI* pCmdUI);
	afx_msg void OnRunEnablePoleZero();
	afx_msg void OnRunStatistics();
	afx_msg void OnUpdateRunEnablePoleZero(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRunStatistics(CCmdUI* pCmdUI);
	afx_msg void OnRunParametric();
	afx_msg void OnUpdateRunParametric(CCmdUI* pCmdUI);
	afx_msg void OnRunReRuns();
	afx_msg void OnUpdateRunReRuns(CCmdUI* pCmdUI);
	afx_msg void OnRunSensitivity();
	afx_msg void OnUpdateRunSensitivity(CCmdUI* pCmdUI);
	afx_msg void OnRunStop();
	afx_msg void OnRunTemperature();
	afx_msg void OnUpdateRunTemperature(CCmdUI* pCmdUI);
	afx_msg void OnRunTransient();
	afx_msg void OnUpdateRunTransient(CCmdUI* pCmdUI);
	afx_msg void OnCancelEditCntr();
	afx_msg void OnWindowNewGraph();
	afx_msg void OnViewTopLevelFiles();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnUpdateDrawingZoomIn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDrawingZoomOut(CCmdUI* pCmdUI);
	afx_msg void OnDrawingZoomCenter();
	afx_msg void OnAddUserText();
	afx_msg void OnEditCopyWithPaste();
	afx_msg void OnEditPaste1();
	afx_msg void OnWaveformsDisplayDCWaveform();
	afx_msg void OnUpdateWaveformsDisplayDCWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplayACWaveform();
	afx_msg void OnUpdateWaveformsDisplayACWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplayTransWaveform();
	afx_msg void OnUpdateWaveformsDisplaytransWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplayNoiseWaveform();
	afx_msg void OnUpdateWaveformsDisplayNoiseWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplayFourierWaveform();
	afx_msg void OnUpdateWaveformsDisplayFourierWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplaySensitivityWaveform();
	afx_msg void OnUpdateWaveformsDisplaySensitivityWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplayPoleZeroWaveform();
	afx_msg void OnUpdateWaveformsDisplayPoleZeroWaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDistortion();
	afx_msg void OnUpdateWaveformsDistortion(CCmdUI* pCmdUI);
	afx_msg void OnWindowNew();
	afx_msg void OnAxisMagnify();
	afx_msg void OnAxisReduce();
	afx_msg void OnAxisScrollXLeft();
	afx_msg void OnAxisScrollXRight();
	afx_msg void OnAxisScrollYDown();
	afx_msg void OnAxisScrollYUp();
	afx_msg void OnUpdateAxisMagnify(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAxisReduce(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAxisScrollXLeft(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAxisScrollXRight(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAxisScrollYDown(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAxisScrollYUp(CCmdUI* pCmdUI);
	afx_msg void OnGraphicsPlaceNewGraph();
	afx_msg void OnRunEnableOperatingPoint();
	afx_msg void OnUpdateRunEnableOperatingPoint(CCmdUI* pCmdUI);
	afx_msg void OnAxisAutoScale();
	afx_msg void OnViewDesignNotes();
	afx_msg void OnHelpGetcomputerpassword();
	afx_msg void OnEditCopyToWindowsClipboard();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnRunRunDebugMode();
	afx_msg void OnViewComponentMaker();
	afx_msg void OnRunSensitivityAc();
	afx_msg void OnUpdateRunSensitivityAc(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDistortion2();
	afx_msg void OnUpdateWaveformsDistortion2(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDistortionF2();
	afx_msg void OnUpdateWaveformsDistortionF2(CCmdUI* pCmdUI);
	afx_msg void OnPropertyAccelerater();
	afx_msg void OnWaveformsTrantofreqFFT();
	afx_msg void OnWaveformsActotimedomainFFT();
	afx_msg void OnUpdateWaveformsTrantofreqFFT(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWaveformsActotimedomainFFT(CCmdUI* pCmdUI);
	afx_msg void OnViewPcbNetlist();
	afx_msg void OnViewDisplaySpiceErrorLog();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnPopupProperties();
	afx_msg void OnPopupChangeWaveColour();
	afx_msg void OnPopUpClearAllWaveforms();
	afx_msg void OnPopupChangeGraphBKGColour();
	afx_msg void OnEditDebagtest2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnRunEnableMonteCarlo();
	afx_msg void OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TCOUTPUTWAVEFORMVIEW_H__76DA29C1_E920_11D2_AD95_10BE4FC10000__INCLUDED_)
