// TCPCBComponentDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCPCBComponentDlg.h"
#include "TESuperSpiceEnums.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCPCBComponentDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCPCBComponentDlg property page

TCPCBComponentDlg::TCPCBComponentDlg() : CPropertyPage(TCPCBComponentDlg::IDD)
{
	//{{AFX_DATA_INIT(TCPCBComponentDlg)
	CMPackageName = _T("");
	CMComponentName = _T("");
	m_include_in_pcb_netlist = TRUE;
	m_include_in_spice_netlist = TRUE;
	//}}AFX_DATA_INIT

	PCSchematicObjectData = NULL;
}

TCPCBComponentDlg::~TCPCBComponentDlg()
{
}

void TCPCBComponentDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCPCBComponentDlg)
	DDX_Text(pDX, IDC_EDIT_PACKAGE_NAME, CMPackageName);
	DDX_Text(pDX, IDC_EDIT_COMPONENT_NAME, CMComponentName);
	DDX_Check(pDX, IDC_CHECK_INCLUDE_IN_PCB, m_include_in_pcb_netlist);
	DDX_Check(pDX, IDC_CHECK_INCLUDE_IN_PCB2, m_include_in_spice_netlist);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCPCBComponentDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCPCBComponentDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCPCBComponentDlg::OnKillActive() 
{
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	if(!PCSchematicObjectData->CReserved.CStringArray.GetSize())
	{

	}
	else 
	{
		PCSchematicObjectData->CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = CMPackageName;
		PCSchematicObjectData->CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CMComponentName;
		
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = (float)m_include_in_pcb_netlist;
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = (float)m_include_in_spice_netlist;

	}

	return true;
}

BOOL TCPCBComponentDlg::OnSetActive() 
{
	g_last_active_component_property_page = 3;

	if(!PCSchematicObjectData->CReserved.CStringArray.GetSize())
	{

	}

	else 
	{
		CMPackageName = PCSchematicObjectData->CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];

		CMComponentName = PCSchematicObjectData->CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME];
		
		m_include_in_pcb_netlist = (int)PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE];
		m_include_in_spice_netlist = (int)PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE]; 
	}

	return CPropertyPage::OnSetActive();
}

BOOL TCPCBComponentDlg::OnInitDialog() 
{
	if(!PCSchematicObjectData->CReserved.CStringArray.GetSize())
	{

	}
	 else 
	 {
		CMPackageName = PCSchematicObjectData->CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME];

		CMComponentName = PCSchematicObjectData->CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME];
		
		m_include_in_pcb_netlist = (int)PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE];
		m_include_in_spice_netlist = (int)PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE]; 
	 }
	
	 CPropertyPage::OnInitDialog();

	return TRUE;  
}
