#include "stdafx.h"
#include "resource.h"
#include"TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TCMKSConvert.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCParamDefs.h"
#include "TCMasterModelDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCParamDefs, CPropertyPage)

extern class TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern class TCSuperSpiceGlobalData	GCSuperSpiceGlobalData; 

extern int	g_last_active_simulation_setup_page;


TCParamDefs::TCParamDefs() : CPropertyPage(TCParamDefs::IDD)
{
	//{{AFX_DATA_INIT(TCParamDefs)
	CEditSpiceParameter = _T("");
	CEditSpiceParameterValue = _T("");
	//}}AFX_DATA_INIT
}

TCParamDefs::~TCParamDefs()
{
}

void TCParamDefs::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCParamDefs)
	DDX_Control(pDX, IDC_LIST_SPICE_PARAMETERS, CMListSpiceModelParameter);
	DDX_Text(pDX, IDC_EDIT_SPICE_PARAMETER, CEditSpiceParameter);
	DDX_Text(pDX, IDC_EDIT_SPICE_PARAMETERVALUE, CEditSpiceParameterValue);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCParamDefs, CPropertyPage)
	//{{AFX_MSG_MAP(TCParamDefs)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SPICE_PARAMETERS, OnClickListSpiceParameters)
	ON_BN_CLICKED(IDC_BUTTON_INSERT, OnButtonInsert)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_PARAMETERVALUE, OnKillfocusEditSpiceParameterValue)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_PARAMETER, OnKillfocusEditSpiceParameterName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCParamDefs::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{		 
		GetDisplay();
	}

	return value;
}

BOOL TCParamDefs::OnInitDialog() 
{
	GCSuperSpiceDataBase.CModelDataBase.Get(CSpiceParameters);  

	CPropertyPage::OnInitDialog();
	
	CString CText;

	int length = (int)(CMListSpiceModelParameter.GetStringWidth("Model Parameter") * 1.5);

	CText ="Parameter Name";
	CMListSpiceModelParameter.InsertColumn(0, CText, LVCFMT_LEFT,length,0);

	CText ="Parameter Value";
	CMListSpiceModelParameter.InsertColumn(1, CText, LVCFMT_LEFT, length,1);

	InsertItems();

	SetDisplay();

	return TRUE;
}

void TCParamDefs::SetDisplay(void)
{
	int count = CSpiceParameters.CData.GetSize();
	
	CString CText;

	for(int p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = CSpiceParameters.CData[p];

		CMListSpiceModelParameter.SetItemText(p, 0, CNameValueData.CName);

		if(!CNameValueData.is_text_data) CText = FloatToMKSString(CNameValueData.value);
		else CText = CNameValueData.CValue;

		CMListSpiceModelParameter.SetItemText(p, 1, CText);
	}

	if(count)
	{
		if(CSpiceParameters.last_selected >= count)
			CSpiceParameters.last_selected = 0;

		TCNameValueData &CNameValueData = 
		CSpiceParameters.CData[CSpiceParameters.last_selected];

		CEditSpiceParameter	= CNameValueData.CName;
		
		if(!CNameValueData.is_text_data) CEditSpiceParameterValue = FloatToMKSString(CNameValueData.value);
		else CEditSpiceParameterValue = CNameValueData.CValue;
	}

	CMListSpiceModelParameter.SetItemState(CSpiceParameters.last_selected, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );

	UpdateData(false);
}

void TCParamDefs::GetDisplay(void)
{
	UpdateData(true);

	int id = CSpiceParameters.last_selected;

	if(id >=CSpiceParameters.CData.GetSize())
	{
		return;
	}

	TCNameValueData CNameValueData;

	CNameValueData.CName = CEditSpiceParameter;

	int test_test;

	test_test = 0;

	if(CEditSpiceParameterValue.Find('[') > -1)  test_test = 1;
	if(CEditSpiceParameterValue.Find('"') > -1)  test_test = 1;
	if(CEditSpiceParameterValue.Find('\'') > -1) test_test = 1;
	if(CEditSpiceParameterValue.Find('{') > -1)  test_test = 1;

	if(test_test) 
	{
		CSpiceParameters.CData[id].is_text_data = true;
	}
	else
	{
		CSpiceParameters.CData[id].is_text_data = false;
	}

	CNameValueData.is_text_data = CSpiceParameters.CData[id].is_text_data;

	if(!CNameValueData.is_text_data) CNameValueData.value = MKSStringToFloat(CEditSpiceParameterValue);
	else CNameValueData.CValue = CEditSpiceParameterValue;

	CSpiceParameters.CData[id] = CNameValueData;
}

void TCParamDefs::OnClickListSpiceParameters(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR;
	*pResult = 0;

	GetDisplay();

	int item = CMListSpiceModelParameter.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item < 0) return;

	CMListSpiceModelParameter.SetItemState(item, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );

	CSpiceParameters.last_selected = item;

	SetDisplay();
}

void TCParamDefs::OnKillfocusEditSpiceParameterValue() 
{
	UpdateData(true);

	int item = CSpiceParameters.last_selected;

	if(item < 0) return;

	int count = CSpiceParameters.CData.GetSize();

	if(!(item < count)) return;

	TCNameValueData &CNameValueData = CSpiceParameters.CData[item];

	if(!CNameValueData.is_text_data) CNameValueData.value = MKSStringToFloat(CEditSpiceParameterValue);
	else CNameValueData.CValue = CEditSpiceParameterValue;

	CMListSpiceModelParameter.SetItemText(item, 1, CEditSpiceParameterValue);
}

void TCParamDefs::OnKillfocusEditSpiceParameterName() 
{
	UpdateData(true);

	int item = CSpiceParameters.last_selected;

	if(item < 0) return;

	int count = CSpiceParameters.CData.GetSize();

	if(!(item < count)) return;

	TCNameValueData &CNameValueData = CSpiceParameters.CData[item];

	CNameValueData.CName = CEditSpiceParameter;

	CMListSpiceModelParameter.SetItemText(item, 0, CEditSpiceParameter);

	UpdateData(false);
}

void TCParamDefs::InsertItems(void)
{
	CMListSpiceModelParameter.DeleteAllItems();

	int count = CSpiceParameters.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = CSpiceParameters.CData[p];
		
		CMListSpiceModelParameter.InsertItem(p, CNameValueData.CName);
	}
}

void TCParamDefs::OnButtonInsert() 
{
	int id = CSpiceParameters.last_selected;

	TCNameValueData CNameValueData;

	if(id) id++;
 
//	int randx;

//	randx = (rand() * 100)/RAND_MAX;// value from 0 to 100

	CNameValueData.CName = "?";

	CNameValueData.value = 1;

	CSpiceParameters.last_selected = id;

	CSpiceParameters.CData.InsertAt(id, CNameValueData);

	InsertItems();

	SetDisplay();
}

void TCParamDefs::OnButtonDelete() 
{
	int size = CSpiceParameters.CData.GetSize();

	if(!size) return;

	int id = CSpiceParameters.last_selected;

	if(id >= size) return;

	CSpiceParameters.CData.RemoveAt(id);

	InsertItems();

	SetDisplay();
}

BOOL TCParamDefs::OnSetActive() 
{
	g_last_active_simulation_setup_page = 12;
	
	SetDisplay();

	return CPropertyPage::OnSetActive();
}