// TCPinInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCPinInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCPinInfoDlg dialog


TCPinInfoDlg::TCPinInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCPinInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCPinInfoDlg)
	CEditPinName = _T("");
	m_pin_id = 0;
	CEditPinNumber = _T("");
	m_pin_current_visable = FALSE;
	m_pin_name_visable = FALSE;
	m_pin_number_visable = FALSE;
	m_pin_voltage_visable = FALSE;
	CEditPinCurrent = _T("");
	CEditPinVoltage = _T("");
	m_pin_net_name_visable = FALSE;
	CEditNetName = _T("");
	m_pin_type = -1;
	//}}AFX_DATA_INIT

	is_from_symbol_editor = false;
}


void TCPinInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCPinInfoDlg)
	DDX_Control(pDX, IDC_EDIT_PIN_NET_NAME, CMEditNodeName);
	DDX_Control(pDX, IDC_EDIT_PIN_ID, CMEditPinId);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME, CEditPinName);
	DDX_Text(pDX, IDC_EDIT_PIN_ID, m_pin_id);
	DDX_Text(pDX, IDC_EDIT_PIN_NUMBER, CEditPinNumber);
	DDX_Check(pDX, IDC_CHECK_PIN_CURRENT_VISABLE, m_pin_current_visable);
	DDX_Check(pDX, IDC_CHECK_PIN_NAME_VISABLE, m_pin_name_visable);
	DDX_Check(pDX, IDC_CHECK_PIN_NUMBER_VISABLE, m_pin_number_visable);
	DDX_Check(pDX, IDC_CHECK_PIN_VOLTAGE_VISABLE, m_pin_voltage_visable);
	DDX_Text(pDX, IDC_EDIT_PIN_CURRENT, CEditPinCurrent);
	DDX_Text(pDX, IDC_EDIT_PIN_VOLTAGE, CEditPinVoltage);
	DDX_Check(pDX, IDC_CHECK_PIN_NET_NAME, m_pin_net_name_visable);
	DDX_Text(pDX, IDC_EDIT_PIN_NET_NAME, CEditNetName);
	DDX_Radio(pDX, IDC_RADIO_PIN_TYPE, m_pin_type);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCPinInfoDlg, CDialog)
	//{{AFX_MSG_MAP(TCPinInfoDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCPinInfoDlg message handlers
TCSchematicObjectData &TCPinInfoDlg::GetData(void)
{
	return CMSchematicObjectData;
}

void TCPinInfoDlg::SetData(TCSchematicObjectData &CSchematicObjectData, int id)
{
	CMSchematicObjectData = CSchematicObjectData;

	if(CSchematicObjectData.type != E_SUBCIRCUIT_PIN_CONNECTER)
	{
		m_pin_id = id;
	}
	else
	{
		m_pin_id = (int)MKSStringToFloat(CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);
	}

	if(is_from_symbol_editor) id = 0;
	
	if(!(m_pin_id < CMSchematicObjectData.CPinListData.GetSize())) return;

	if(!(E_NUM_PIN_LABELS <= CMSchematicObjectData.CPinListData[id].CLabelListData.GetSize())) return;
	
	CEditPinName	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
	CEditPinNumber  = CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;
	CEditPinCurrent = CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel;
	CEditPinVoltage	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel;
	CEditNetName	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

	m_pin_type				= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NAME].connection_type;
	m_pin_current_visable	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_CURENT].is_visable;
	m_pin_name_visable		= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NAME].is_visable;
	m_pin_number_visable	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable;
	m_pin_voltage_visable	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_VOLTAGE].is_visable;
	m_pin_net_name_visable	= CMSchematicObjectData.CPinListData[id].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable;
	
}

void TCPinInfoDlg::OnOK() 
{	
	CDialog::OnOK();

	if(CMSchematicObjectData.type == E_SUBCIRCUIT_PIN_CONNECTER)
	{
		CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = FloatToMKSString((float) m_pin_id);
	
		m_pin_id = 0;
	}
	
	if(is_from_symbol_editor) 
	{
		CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = FloatToMKSString((double)m_pin_id);
	
		m_pin_id = 0;
	}

	if(!(m_pin_id < CMSchematicObjectData.CPinListData.GetSize())) return;

	if(!(E_NUM_PIN_LABELS <= CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData.GetSize())) return;

	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = (unsigned char) m_pin_type;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CEditPinName;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CEditPinNumber;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = CEditNetName;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_CURENT].is_visable = !!m_pin_current_visable;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NAME ].is_visable = !!m_pin_name_visable;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable = !!m_pin_number_visable;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_VOLTAGE].is_visable = !!m_pin_voltage_visable;
	CMSchematicObjectData.CPinListData[m_pin_id].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = !!m_pin_net_name_visable;
}

BOOL TCPinInfoDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);

	return true;
}

BOOL TCPinInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if(CMSchematicObjectData.type != E_SUBCIRCUIT_PIN_CONNECTER)
	{
		CMEditPinId.SetReadOnly();

		if(is_from_symbol_editor) CMEditNodeName.SetReadOnly();
	}
	
	return TRUE; 
}
