// TCPoleZeroDialog.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCPoleZeroDialog.h"
#include "TCOutputWaveformData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString FloatToMKSString(double data);

/////////////////////////////////////////////////////////////////////////////
// TCPoleZeroDialog dialog


TCPoleZeroDialog::TCPoleZeroDialog(CWnd* pParent /*=NULL*/)
	: CDialog(TCPoleZeroDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCPoleZeroDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	PCWaveformDataRuns = NULL;
}


void TCPoleZeroDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCPoleZeroDialog)
	DDX_Control(pDX, IDC_LIST_RUNS, CMListRuns);
	DDX_Control(pDX, IDC_LIST_POLEL_ZERO_DATA, CMListPoleZero);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCPoleZeroDialog, CDialog)
	//{{AFX_MSG_MAP(TCPoleZeroDialog)
	ON_LBN_SELCHANGE(IDC_LIST_RUNS, OnSelchangeListRuns)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCPoleZeroDialog message handlers

BOOL TCPoleZeroDialog::OnInitDialog() 
{

	CDialog::OnInitDialog();

	DisplayData();

	return TRUE;  	              
}


void TCPoleZeroDialog::DisplayData(void)
{
	if(!PCWaveformDataRuns) return;

	DisplayRuns();

	DisplayPoleZeros();

	UpdateData(false);
}

void TCPoleZeroDialog::OnSelchangeListRuns() 
{
	DisplayData();	
}

void TCPoleZeroDialog::DisplayRuns(void)
{
	if(!PCWaveformDataRuns) return;

	int run_index = CMListRuns.GetCurSel();

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!(run_index < count)) run_index = 0;

	if(run_index < 0) run_index = 0;

	CMListRuns.ResetContent();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		if(!PCWaveformDataRuns->CRuns[p]) return;

		CText = PCWaveformDataRuns->CRuns[p]->CRunDiscription;

		CMListRuns.AddString(CText);
	}

	CMListRuns.SetCurSel(run_index);
}

void TCPoleZeroDialog::DisplayPoleZeros(void)
{
	if(!PCWaveformDataRuns) return;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	int run_index = CMListRuns.GetCurSel();

	if(!(run_index < count)) run_index = 0;

	if(run_index < 0) run_index = 0;

	CMListPoleZero.ResetContent();

	if(!PCWaveformDataRuns->CRuns[0]) return;

	TCOutputWaveformData &COutputWaveformData = *PCWaveformDataRuns->CRuns[run_index];

	if(!(E_SPICE_RECORD_POLE_ZERO < COutputWaveformData.CRecords.GetSize())) return;

	TCOutputWaveformDataRecord& CRecords = COutputWaveformData.CRecords[E_SPICE_RECORD_POLE_ZERO];

	int num_signals = CRecords.CSignals.GetSize();

	if(!num_signals) return;

	CString CText;
	CString CTextHeader;
	double data;

	for(int p = 0; p < num_signals; p++)
	{
	  	TCSignal &CSignal = CRecords.CSignals[p];

		if(!CSignal.CMagnitudeData.CX.GetSize()) return;
		if(!CSignal.CPhaseData.CX.GetSize()) return;
	
		CTextHeader = CSignal.CName + ":    ";

		CText = CTextHeader + FloatToMKSString(CSignal.CMagnitudeData.CX[0]);

		data = CSignal.CPhaseData.CX[0];

		if(data < 0)
		{
			data = -data;

			CText += " - i";

			CText += FloatToMKSString(data);
		}
		else
		{
			CText += " + i";

			CText += FloatToMKSString(data);
		}

		CMListPoleZero.AddString(CText);	
	}
}
