// TCProgramOptionsMasterSheet.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCProgramOptionsMasterSheet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCProgramOptionsMasterSheet

IMPLEMENT_DYNAMIC(TCProgramOptionsMasterSheet, CPropertySheet)

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern int g_last_active_program_options_page;

TCProgramOptionsMasterSheet::TCProgramOptionsMasterSheet(CWnd* pWndParent)
	 : CPropertySheet(IDS_PROPSHT_CAPTION3, pWndParent)
{
	// Add all of the property pages here.  Note that
	// the order that they appear in here will be
	// the order they appear in on screen.  By default,
	// the first page of the set is the active one.
	// One way to make a different property page the 
	// active one is to call SetActivePage().

	AddPage(&m_Page1);//General
	AddPage(&m_Page2);//Errors

	SetActivePage(g_last_active_program_options_page);

}

TCProgramOptionsMasterSheet::~TCProgramOptionsMasterSheet()
{
}


BEGIN_MESSAGE_MAP(TCProgramOptionsMasterSheet, CPropertySheet)
	//{{AFX_MSG_MAP(TCProgramOptionsMasterSheet)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCProgramOptionsMasterSheet message handlers



INT_PTR TCProgramOptionsMasterSheet::DoModal() 
{
	m_Page1.CGeneral			= CProgramOptions.CGeneral;
	m_Page2.CSpiceEngine		= CProgramOptions.CSpiceEngine;
	m_Page1.PCSpiceEngine		= &m_Page2.CSpiceEngine;// for save now functionality

	int value = CPropertySheet::DoModal();

	if(value == IDOK)
	{
		CProgramOptions.CGeneral		= m_Page1.CGeneral;
		CProgramOptions.CSpiceEngine	= m_Page2.CSpiceEngine;
	}

	return value;
}
