// TCProgramOptionsPages1.cpp : implementation file
//

#include "stdafx.h"
#include "SuperSpice.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCProgramOptionsPages1.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CString GetProgramDirectory(void);
extern CString GetApplicationDataDirectory(void);

IMPLEMENT_DYNCREATE(TCProgramOptionsPages1, CPropertyPage)
IMPLEMENT_DYNCREATE(TCProgramOptionsPages2, CPropertyPage)

extern int g_last_active_program_options_page;
extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern CString ExtractFileName(CString);
extern CString GetFileExtention(CString CPathAndName);


/////////////////////////////////////////////////////////////////////////////
// TCProgramOptionsPages1 property page

TCProgramOptionsPages1::TCProgramOptionsPages1() : CPropertyPage(TCProgramOptionsPages1::IDD)
{
	//{{AFX_DATA_INIT(TCProgramOptionsPages1)
	m_load_on_start = FALSE;
	m_save_on_exit = FALSE;
	m_prompt_save_model_files_on_exit = FALSE;
	m_prompt_save_symbols_files_on_exit = FALSE;
	m_save_models_on_exit = FALSE;
	m_save_symbols_on_exit = FALSE;
	m_auto_display_graphics = FALSE;
	m_auto_connect_analog_input_pins = FALSE;
	m_auto_connect_analog_output_pins = FALSE;
	m_auto_connect_digital_input_pins = FALSE;
	m_load_last_output_data = FALSE;
	m_calculate_fft_on_load = FALSE;
	m_calculate_selected_fft_signals = FALSE;
	m_flat_netlist = FALSE;
	m_interperlated_points = FALSE;
	m_save_subckt_currents = FALSE;
	m_graph_default_setups = FALSE;
	m_display_signal_x2 = 0;
	m_prompt_to_save_circuits = FALSE;
	m_save_circuits = FALSE;
	m_auto_update_calc_graph = FALSE;
	m_check_for_vi_sources = FALSE;
	m_flatten_nested_subckts = FALSE;
	m_lock_graph_size_to_window_size = FALSE;
	//}}AFX_DATA_INIT

	PCSpiceEngine = NULL;
}

TCProgramOptionsPages1::~TCProgramOptionsPages1()
{
}

void TCProgramOptionsPages1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCProgramOptionsPages1)
	DDX_Check(pDX, IDC_CHECK_LOAD_WORKSPACE, m_load_on_start);
	DDX_Check(pDX, IDC_CHECK_SAVE_WORKSPACE, m_save_on_exit);
	DDX_Check(pDX, IDC_CHECK_PROMPT_SAVE_MODELS, m_prompt_save_model_files_on_exit);
	DDX_Check(pDX, IDC_CHECK_PROMPT_SAVE_SYMBOLS, m_prompt_save_symbols_files_on_exit);
	DDX_Check(pDX, IDC_CHECK_PROMPT_SAVE_MODELS_ONEXIT, m_save_models_on_exit);
	DDX_Check(pDX, IDC_CHECK_PROMPT_SAVE_SYMBOLS2ONEXIT, m_save_symbols_on_exit);
	DDX_Check(pDX, IDC_CHECK_AUTO_DISPLAY_GRAPHICS, m_auto_display_graphics);
	DDX_Check(pDX, IDC_CHECK_AUTO_CONNECT_ANALOG_INPUT_PINS, m_auto_connect_analog_input_pins);
	DDX_Check(pDX, IDC_CHECK_AUTO_CONNECT_ANALOG_OUTPUT_PINS, m_auto_connect_analog_output_pins);
	DDX_Check(pDX, IDC_CHECK_AUTO_CONNECT_DIGITAL_INTPUT_PINS, m_auto_connect_digital_input_pins);
	DDX_Check(pDX, IDC_CHECK_LOAD_OUTPUT_DATA, m_load_last_output_data);
//	DDX_Check(pDX, IDC_CHECK_CALCULATEFFT_ON_LOAD, m_calculate_fft_on_load);
//	DDX_Check(pDX, IDC_CHECK_SELECTED_FFT_SIGNALS, m_calculate_selected_fft_signals);
	DDX_Check(pDX, IDC_CHECK_FLAT_NETLIST, m_flat_netlist);
	DDX_Check(pDX, IDC_CHECK_INTERPOLATED_POINTS, m_interperlated_points);
	DDX_Check(pDX, IDC_CHECK_SAVE_SUBCKT_CURRENTS, m_save_subckt_currents);
	DDX_Check(pDX, IDC_CHECK_DEFAULT_GRAPHS, m_graph_default_setups);
	DDX_Radio(pDX, IDC_RADIO_DISPLAY_PHASE, m_display_signal_x2);
	DDX_Check(pDX, IDC_CHECK_PROMPT_SAVE_CIRCUITS, m_prompt_to_save_circuits);
	DDX_Check(pDX, IDC_CHECK_PROMPT_SAVE_CIRCUITS2ONEXIT, m_save_circuits);
	DDX_Check(pDX, IDC_CHECK_AUTO_UPDATE_CALC_GRAPH, m_auto_update_calc_graph);
	DDX_Check(pDX, IDC_CHECK_VI_SOURCES, m_check_for_vi_sources);
	DDX_Check(pDX, IDC_CHECK_FLANNEN_NESTEDSUBCKTS, m_flatten_nested_subckts);
	DDX_Check(pDX, IDC_CHECK_FLANNEN_AUTO_SIZE_GRAPHS, m_lock_graph_size_to_window_size);
	//}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(TCProgramOptionsPages1, CPropertyPage)
	//{{AFX_MSG_MAP(TCProgramOptionsPages1)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_NOW, OnButtonSaveNow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCProgramOptionsPages2 property page

TCProgramOptionsPages2::TCProgramOptionsPages2() : CPropertyPage(TCProgramOptionsPages2::IDD)
, CMProgramExeDir(_T(""))
, CMProgramDataDir(_T(""))
{
	//{{AFX_DATA_INIT(TCProgramOptionsPages2)
	CEditSpiceEngineName = _T("");
	CEditCommandLine = _T("");
	m_default_command = FALSE;
	m_run_minimised = FALSE;
	m_check_spice3_compatible = FALSE;
	m_beep_when_engine_finished = FALSE;
	m_display_loading_status = FALSE;
	m_display_xspice_status = FALSE;
	//}}AFX_DATA_INIT

}

TCProgramOptionsPages2::~TCProgramOptionsPages2()
{
}

void TCProgramOptionsPages2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCProgramOptionsPages2)
	DDX_Control(pDX, IDC_EDIT_SPICE_COMMAND_LINE, CMEditCntlCommandLine);
	DDX_Text(pDX, IDC_EDIT_SPICE_ENGINE_NAME, CEditSpiceEngineName);
	DDX_Text(pDX, IDC_EDIT_SPICE_COMMAND_LINE, CEditCommandLine);
	DDX_Check(pDX, IDC_CHECK_DEFAULT_SWITCHS, m_default_command);
	DDX_Check(pDX, IDC_CHECK_RUN_MINIMISED, m_run_minimised);
	DDX_Check(pDX, IDC_CHECK_SPICE3, m_check_spice3_compatible);
	DDX_Check(pDX, IDC_CHECK_BEEP, m_beep_when_engine_finished);
	DDX_Check(pDX, IDC_CHECK_SISPLAY_LOAD_STATAS, m_display_loading_status);
	DDX_Check(pDX, IDC_CHECK_SISPLAY_XSPICE_SATAUS, m_display_xspice_status);
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_EDIT_EXE_FOLDER, CMProgramExeDir);
	DDX_Text(pDX, IDC_EDIT_APP_DATA, CMProgramDataDir);
}


BEGIN_MESSAGE_MAP(TCProgramOptionsPages2, CPropertyPage)
	//{{AFX_MSG_MAP(TCProgramOptionsPages2)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, OnButtonBrowse)
	ON_BN_CLICKED(IDC_CHECK_DEFAULT_SWITCHS, OnCheckDefaultCommandLine)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_ENGINE_NAME, OnKillfocusEditSpiceEngineName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCProgramOptionsPages1::OnKillActive() 
{	
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}

	return value;
}

void TCProgramOptionsPages1::GetDisplay(void)
{
	UpdateData(true);

	CGeneral.load_on_start = m_load_on_start;
	CGeneral.save_on_exit = m_save_on_exit;
	CGeneral.prompt_save_model_files_on_exit = m_prompt_save_model_files_on_exit;
	CGeneral.prompt_save_symbol_files_on_exit = m_prompt_save_symbols_files_on_exit;
	CGeneral.save_model_files_on_exit = m_save_models_on_exit;
	CGeneral.save_symbol_files_on_exit = m_save_symbols_on_exit;
	CGeneral.auto_display_graphics = m_auto_display_graphics;
	CGeneral.graph_default_setups = m_graph_default_setups;
	CGeneral.auto_connect_analog_input_pins = m_auto_connect_analog_input_pins;
	CGeneral.auto_connect_analog_output_pins = m_auto_connect_analog_output_pins;
	CGeneral.auto_connect_digital_input_pins = m_auto_connect_digital_input_pins;
	CGeneral.load_last_output_data	= m_load_last_output_data;
	CGeneral.calculate_fft_on_load = m_calculate_fft_on_load;
	CGeneral.calculate_selected_fft_signals = m_calculate_selected_fft_signals;
	CGeneral.flat_netlist = m_flat_netlist;
	CGeneral.interperlated_points = m_interperlated_points;
	CGeneral.save_subckt_currents = m_save_subckt_currents;
	CGeneral.display_signal_x2	= m_display_signal_x2;
	CGeneral.auto_update_calc_graph = m_auto_update_calc_graph;
	CGeneral.check_for_vi_sources = m_check_for_vi_sources;
	CGeneral.flatten_nested_subckts = m_flatten_nested_subckts;
	CGeneral.lock_graph_size_to_window_size = m_lock_graph_size_to_window_size;

	CGeneral.prompt_save_component_files_on_exit = m_prompt_to_save_circuits;
	CGeneral.save_component_files_on_exit = m_save_circuits;
}

BOOL TCProgramOptionsPages1::OnInitDialog() 
{
	m_load_on_start = CGeneral.load_on_start;
	m_save_on_exit	= CGeneral.save_on_exit;
	m_prompt_save_model_files_on_exit =	CGeneral.prompt_save_model_files_on_exit;
	m_prompt_save_symbols_files_on_exit = CGeneral.prompt_save_symbol_files_on_exit;
	m_save_models_on_exit =	CGeneral.save_model_files_on_exit;
	m_save_symbols_on_exit = CGeneral.save_symbol_files_on_exit;
	m_auto_display_graphics = CGeneral.auto_display_graphics;
	m_graph_default_setups = CGeneral.graph_default_setups;
	m_auto_connect_analog_input_pins  = CGeneral.auto_connect_analog_input_pins;
	m_auto_connect_analog_output_pins = CGeneral.auto_connect_analog_output_pins;
	m_auto_connect_digital_input_pins = CGeneral.auto_connect_digital_input_pins;
	m_load_last_output_data = CGeneral.load_last_output_data;
	m_load_last_output_data		= CGeneral.load_last_output_data;
	m_calculate_fft_on_load		= CGeneral.calculate_fft_on_load;
	m_calculate_selected_fft_signals = CGeneral.calculate_selected_fft_signals;
	m_flat_netlist = CGeneral.flat_netlist;
	m_interperlated_points = CGeneral.interperlated_points;
	m_save_subckt_currents = CGeneral.save_subckt_currents;
	m_display_signal_x2 = CGeneral.display_signal_x2;
	m_auto_update_calc_graph = CGeneral.auto_update_calc_graph;
	m_check_for_vi_sources = CGeneral.check_for_vi_sources;
	m_flatten_nested_subckts  = CGeneral.flatten_nested_subckts;
	m_lock_graph_size_to_window_size = CGeneral.lock_graph_size_to_window_size;

	m_prompt_to_save_circuits = CGeneral.prompt_save_component_files_on_exit;
	m_save_circuits = CGeneral.save_component_files_on_exit;

	CPropertyPage::OnInitDialog();
	
	return TRUE; 
}

BOOL TCProgramOptionsPages2::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}

	return value;

}

void TCProgramOptionsPages2::GetDisplay(void)
{
	UpdateData(true);

	CSpiceEngine.CCommandLine		= CEditCommandLine;
	CSpiceEngine.CSpiceEngineName	= CEditSpiceEngineName;
	CSpiceEngine.default_command	= m_default_command;
	CSpiceEngine.run_minimised		= m_run_minimised;
	CSpiceEngine.spice3_compatible	= m_check_spice3_compatible;
	CSpiceEngine.beep_when_engine_finished = m_beep_when_engine_finished;
	CSpiceEngine.display_loading_status = m_display_loading_status;
	CSpiceEngine.display_xspice_status = m_display_xspice_status;
}

BOOL TCProgramOptionsPages2::OnInitDialog() 
{
	CEditSpiceEngineName		= CSpiceEngine.CSpiceEngineName;
	CEditCommandLine			= CSpiceEngine.CCommandLine;
	m_default_command			= CSpiceEngine.default_command;
	m_run_minimised				= CSpiceEngine.run_minimised;
	m_check_spice3_compatible	= CSpiceEngine.spice3_compatible;
	m_beep_when_engine_finished = CSpiceEngine.beep_when_engine_finished;
	m_display_loading_status	= CSpiceEngine.display_loading_status;
	m_display_xspice_status		= CSpiceEngine.display_xspice_status;

	CMProgramExeDir	= GetProgramDirectory();
	CMProgramDataDir = GetApplicationDataDirectory();

	CPropertyPage::OnInitDialog();

	if(m_default_command) CMEditCntlCommandLine.SetReadOnly(true);
	else CMEditCntlCommandLine.SetReadOnly(false);	

	return TRUE;  
}

BOOL TCProgramOptionsPages1::OnSetActive() 
{
	g_last_active_program_options_page = 0;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCProgramOptionsPages2::OnSetActive() 
{
	g_last_active_program_options_page = 1;

	return CPropertyPage::OnSetActive();
}

void TCProgramOptionsPages1::OnButtonSaveNow() 
{
	TCSuperSpiceApp *PCCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetApp();
	
	GetDisplay();

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral = CGeneral;

	if(PCSpiceEngine)
		GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine = *PCSpiceEngine;

	PCCSuperSpiceApp->SaveOnExit();
}

void TCProgramOptionsPages2::OnButtonBrowse() 
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "", CSpiceEngine.CSpiceEngineName, 0,"Application Files (*.exe)| *.exe||");

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		CSpiceEngine.CSpiceEngineName = CFileName;

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	CString CExt = GetFileExtention(CFileName);

	CExt.MakeLower();

	if(CExt != "exe")
	{
		AfxMessageBox(IDS_INVALID_SS_FILE_EXTENTION);

		return;
	}
// Check to make sure one does not load the GUI itself

	CString CText1 = ExtractFileName(CFileName);

	CString CText2 = AfxGetApp()->m_pszAppName;

	CText2 += ".exe";

	CText1.MakeLower();
	CText2.MakeLower();

	if(CText1 == CText2)
	{
		AfxMessageBox(IDS_SUPER_SPICE_NOT_ENGINE);

		return;
	}

	CEditSpiceEngineName = CFileName;

	CSpiceEngine.CSpiceEngineName = CFileName;

	UpdateData(false);
}

void TCProgramOptionsPages2::OnCheckDefaultCommandLine() 
{
	GetDisplay();

	if(m_default_command) CMEditCntlCommandLine.SetReadOnly(true);
	else CMEditCntlCommandLine.SetReadOnly(false);	
}

void TCProgramOptionsPages2::OnKillfocusEditSpiceEngineName() 
{
	CString COldEngine = CEditSpiceEngineName;

	GetDisplay();	//gets new CEditSpiceEngineName

	CString CText1 = ExtractFileName(CEditSpiceEngineName);

	CString CText2 = AfxGetApp()->m_pszAppName;

	CText2 += ".exe";

	CText1.MakeLower();
	CText2.MakeLower();

	if(CText1 == CText2)
	{
		AfxMessageBox(IDS_SUPER_SPICE_NOT_ENGINE);

		CEditSpiceEngineName = COldEngine;
	}

	UpdateData(false);
}
