#include "stdafx.h"
#include "math.h"
#include "TCFileFunctions.h"
#include "TCStringFunctions.h"
#include "Generic.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCBillOfMaterials.h"
#include "TCReRuns.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


double MKSStringToFloat(CString &CTextData);
CString FloatToSpiceMKSString(double data);

///////////////////////////////////////////////
TCReRunWCData::TCReRunWCData(void)
{

}
TCReRunWCData::TCReRunWCData(TCReRunWCData &CReRunWCData)
{
	*this = CReRunWCData;
}
TCReRunWCData::~TCReRunWCData(void)
{

}

void TCReRunWCData::operator = (TCReRunWCData &CReRunWCData)
{
	r_sigma = CReRunWCData.r_sigma;
	c_sigma = CReRunWCData.c_sigma;
	l_sigma = CReRunWCData.l_sigma;
	ps_sigma = CReRunWCData.ps_sigma;
	t_max = CReRunWCData.t_min;
	t_min = CReRunWCData.t_min;
	t_nom = CReRunWCData.t_nom;
}
///////////////////////////////////////////////
TCDotModelData::TCDotModelData(void)
{

}

TCDotModelData::TCDotModelData(TCDotModelData &CReRunData)
{
	*this = CReRunData;
}

TCDotModelData::~TCDotModelData(void)
{

}

void TCDotModelData::operator = (TCDotModelData &CData)
{
	int count = CData.CModelLines.GetSize();

	CModelLines.SetSize(count);

	for(int p = 0; p < count; p++) CModelLines[p] = CData.CModelLines[p];

	CName = CData.CName;
}

///////////////////////////////////////////////
///////////////////////////////////////////////
TCReRunData::TCReRunData(void)
{
	value		= 0.0;
	param_type	= -1;
	sigma		= 0;
	variable = 0;
	mean		= 0;
	distribution = E_MONTE_CARLO_UNIFORM;
}

TCReRunData::TCReRunData(TCReRunData &CReRuns)
{
	*this = CReRuns;
}

TCReRunData::~TCReRunData(void)
{

}

void TCReRunData::operator = (TCReRunData &CReRunData)
{
	CRefDes		= CReRunData.CRefDes;
	CParamName	= CReRunData.CParamName;
	CModelName	= CReRunData.CModelName;
	value		= CReRunData.value;
	mean		= CReRunData.mean;
	param_type	= CReRunData.param_type;
	sigma		= CReRunData.sigma;
	variable = CReRunData.variable;
	distribution  = CReRunData.distribution;

	int count = CReRunData.CValueList.GetSize();

	CValueList.SetSize(count);

	for(int p = 0; p < count; p++) CValueList[p] = CReRunData.CValueList[p];
}

void TCReRunData::operator = (TCBillOfMaterials &CBillOfMaterials)
{
	CRefDes			= CBillOfMaterials.CRefDes;
	CModelName		= CBillOfMaterials.CModelName;
	value			= CBillOfMaterials.value;
}

void TCReRunData::ConvetParameterNameToInt(void)
{
	if(CRefDes == "") return;
	if(CParamName == "") return;

	CRefDes.MakeLower();
	CParamName.MakeLower();

	char data = CRefDes.GetAt(0);

	if(data != 'v' && data != 'i') return;

	data = CParamName.GetAt(0);

	CParamName = CParamName.Right(CParamName.GetLength() - 1);

	ConvertDCParam();// will be overwritten if nessesary

	CString CTest = CModelName;

	CTest.MakeLower();

	if(CTest.Find("sine") >= 0)		ConvertSineParam();
	else if(CTest.Find("pulse") >= 0)	ConvertPulseParam();
	else if(CTest.Find("exp") >= 0)	ConvertExpParam();
	else if(CTest.Find("sffm") >= 0)	ConvertSFFMParam();
}

void TCReRunData::ConvertDCParam(void)
{
	if(CParamName == "dcvalue")
	{
		param_type = -1;

		return;
	}
	if(CParamName == "acvalue")
	{
		param_type = -2;

		return;
	}
	if(CParamName == "phase")
	{
		param_type = -3;

		return;
	}

	if(CParamName == "imd1")
	{
		param_type = -4;

		return;
	}
	if(CParamName == "imd2")
	{
		param_type = -5;

		return;
	}
}
void TCReRunData::ConvertSineParam(void)
{
	if(CParamName == "offset")
	{
		param_type = 0;

		return;
	}
	if(CParamName == "amplitude")
	{
		param_type = 1;

		return;
	}
	if(CParamName == "frequency")
	{
		param_type = 2;

		return;
	}
	if(CParamName == "delay")
	{
		param_type = 3;

		return;
	}
	if(CParamName == "damping")
	{
		param_type = 4;

		return;
	}
}
void TCReRunData::ConvertPulseParam(void)
{
	if(CParamName == "start_amplitude")
	{
		param_type = 0;

		return;
	}
	if(CParamName == "stop_amplitude")
	{
		param_type = 1;

		return;
	}
	if(CParamName == "delay")
	{
		param_type = 2;

		return;
	}
	if(CParamName == "tr")
	{
		param_type = 3;

		return;
	}
	if(CParamName == "tf")
	{
		param_type = 4;

		return;
	}
	if(CParamName == "width")
	{
		param_type = 5;

		return;
	}
	if(CParamName == "period")
	{
		param_type = 6;

		return;
	}
}
void TCReRunData::ConvertSFFMParam(void)
{
	if(CParamName == "offset")
	{
		param_type = 0;

		return;
	}
	if(CParamName == "carrier_amplitude")
	{
		param_type = 1;

		return;
	}
	if(CParamName == "carrier_frequency")
	{
		param_type = 2;

		return;
	}
	if(CParamName == "modulation_index")
	{
		param_type = 3;

		return;
	}
	if(CParamName == "modulation_frequency")
	{
		param_type = 4;

		return;
	}
}
void TCReRunData::ConvertExpParam(void)
{
	if(CParamName == "start_amplitude")
	{
		param_type = 0;

		return;
	}
	if(CParamName == "stop_amplitude")
	{
		param_type = 1;

		return;
	}
	if(CParamName == "tau1_delay")
	{
		param_type = 2;

		return;
	}
	if(CParamName == "tau1")
	{
		param_type = 3;

		return;
	}
	if(CParamName == "tau1_delay")
	{
		param_type = 4;

		return;
	}
	if(CParamName == "tau2")
	{
		param_type = 5;

		return;
	}
}

bool TCReRunData::GenerateMonteCarlo(void)
{
	switch(distribution)
	{
		case E_MONTE_CARLO_UNIFORM:	 value = GetMCUniform(mean, sigma);	break;
		case E_MONTE_CARLO_GAUSSIAN: value = GetMCGaussian(mean, sigma);	break;
		case E_MONTE_CARLO_POISSION: value = GetMCPoisson(mean, sigma);	break;

		default: return false;
	}

	return true;
}

bool TCReRunData::GenerateWC(int sign)
{
	value = mean * (1 + sign * sigma);

	return true;
}

///////////////////////////////////////////////
///////////////////////////////////////////////

TCReRunDataList::TCReRunDataList(void)
{
	
}

TCReRunDataList::TCReRunDataList(TCReRunDataList &CReRunList)
{
	*this = CReRunList;
}

TCReRunDataList::~TCReRunDataList(void)
{

}

void TCReRunDataList::operator = (TCReRunDataList &CReRunDataList)
{
	CName = CReRunDataList.CName;

	int count;

	count = CReRunDataList.CReRunData.GetSize();

	CReRunData.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CReRunData[p] = CReRunDataList.CReRunData[p];
	}
}

bool TCReRunDataList::GenerateMonteCarlo(void)
{
	int count = CReRunData.GetSize();

	for(int p = 0; p < count; p++) CReRunData[p].GenerateMonteCarlo();

	return true;
}

///////////////////////////////////////////////
///////////////////////////////////////////////

TCReRuns::TCReRuns(void)
{
	Clear();	
}

TCReRuns::~TCReRuns(void)
{

}

void TCReRuns::Clear(void)
{
	enable		= false;
	run_index	= 0;
	loaded		= false;
}

void TCReRuns::Init(void)
{
	enable		= true;
	loaded		= true;
}

bool TCReRuns::Load(CString CFileName)
{
	if(!enable) return false;

	char buff[1024];
	
	Clear();
	
	TCIFStream CFileStream;

	int flags = ios::in;

	CFileStream.text_file_mode = true;

//	CFileStream.text_file_mode = false;

	CFileStream.open(CFileName, flags);

	if(CFileStream.fail()) return false;

	CString CText, CTextCopy;
	int run_counter = 0;

	CReRunDataList.SetSize(0);

	while(!CFileStream.eof())
	{
		if(!CFileStream.ReadLine(buff, 1023)) break;

		if(*buff == '*') continue;

		CText		= buff;

		CText.TrimLeft();
		CText.TrimRight();

		if(CText == "") continue;
		if(CText.GetAt(0) == '*')  continue;
 
		CTextCopy = CText.Left(6);

		CTextCopy.MakeLower();

		if(CTextCopy == ".rrend")// look for next runs
		{
			run_counter++;

			continue;
		}

		CTextCopy = GetFirstWord(CText);

		CTextCopy.MakeLower();

		if(CTextCopy == ".rerun")
		{
			CTextCopy = RemoveFirstWord(CText);

			CReRunDataList.SetSize(run_counter + 1);

			CTextCopy.TrimRight();

			CReRunDataList[run_counter].CName = CTextCopy;

			continue;
		}

		if(!(run_counter < CReRunDataList.GetSize())) return false;

		TCReRunData CReRunData;

		CReRunData.CRefDes = GetFirstWord(CText);

		CText = RemoveFirstWord(CText);

		CTextCopy = GetFirstWord(CText);

		CReRunData.value = MKSStringToFloat(CTextCopy);

		CText = RemoveFirstWord(CText);

		CTextCopy = GetFirstWord(CText);

		CReRunData.CParamName = CTextCopy;

		CReRunData.CModelName = RemoveFirstWord(CText);

		CReRunData.ConvetParameterNameToInt();

		CReRunDataList[run_counter].CReRunData.Add(CReRunData);
	}

	Init();

	return true;
}

char *TCReRuns::GetFirstRunFileName(char *p_output_file_name, char *p_rerun_file_name)
{
	if(!p_output_file_name) return p_output_file_name; 

	CString CFileName;

	if(!p_output_file_name)
	{
		CFileName = p_output_file_name;

		CFileName = RemoveExtention(CFileName);

		CFileName += ".rrn";
	}
	else CFileName = p_rerun_file_name;

	if(!Load(CFileName)) return p_output_file_name;
	if(!CReRunDataList.GetSize()) return p_output_file_name;

	COuputFileBaseName = p_output_file_name;

	CString CText = COuputFileBaseName;

	COuputFileBaseName = RemoveExtention(CText);

	COuputFileName.Format("%s%d.out", COuputFileBaseName, run_index + 1);

	return COuputFileName.GetBuffer(COuputFileName.GetLength() + 1);
}

char *TCReRuns::GetNextRunFileame(void)
{
	if(!enable) return NULL;
	if(!loaded) return NULL;

	run_index++;

	if(!(run_index < CReRunDataList.GetSize())) return NULL;

	COuputFileName.Format("%s%d.out", COuputFileBaseName, run_index + 1);

	return COuputFileName.GetBuffer(COuputFileName.GetLength() + 1);
}

bool TCReRuns::SaveDotModels(CString CFileName, CArray <CString, CString&> &CModelLines)
{
	int count = CModelLines.GetSize();

	if(!count) return true;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CString  CWord;
	char ref_des;
	int flag_subckt = false;

	for(int p = 0; p < count; p++)
	{
		CString &CLine = CModelLines[p];

		CWord = GetFirstWord(CLine);

		CWord.MakeLower();

		if(CWord == "") continue;

		ref_des = CWord.GetAt(0);

		if(ref_des == '*') continue;

		if(ref_des == 'r' || ref_des == 'l' || ref_des == 'c' ) continue;

		if(ref_des == 'v' || ref_des == 'i') continue;

		if(CWord == ".lib") continue;

		if(ref_des == '.')
		{
			if(CWord == ".subckt")
			{
				flag_subckt++;
			}
			if(CWord == ".ends")
			{
				flag_subckt--;

				continue;
			}

			if(CWord != ".model") continue;
		}

		if(flag_subckt > 0) continue;
	
		CDataFile.Write(CLine, CLine.GetLength());

		CDataFile.Write("\r\n", 2);
	}

	CDataFile.Close();

	return true;
}

bool TCReRuns::Save(CString CFileName)
{
	int count = CReRunDataList.GetSize();

	if(!count) return false;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CString CReRunStart, CReRunEnd, CTemp;

	CReRunStart = ".rerun ";
	CReRunEnd = ".rrend\r\n";
	CString CRefDesCheck;

	for(int p = 0; p < count; p++)
	{
		TCReRunDataList &CDataList = CReRunDataList[p];

		CDataFile.Write(CReRunStart, CReRunStart.GetLength());
		CDataFile.Write(CDataList.CName, CDataList.CName.GetLength());

		CDataFile.Write("\r\n", 2);

		int count2 = CDataList.CReRunData.GetSize();

		for(int q = 0; q < count2; q++)
		{
			TCReRunData &CReRunData = CDataList.CReRunData[q];

			CDataFile.Write(CReRunData.CRefDes, CReRunData.CRefDes.GetLength());

			CTemp = " ";

			if(CReRunData.CRefDes == "")
			{
				ASSERT(0);

				CDataFile.Write("\r\n", 2);

				continue;
			}

			CRefDesCheck = CReRunData.CRefDes;

			CRefDesCheck.MakeLower();

			if(CReRunData.CRefDes.GetAt(0) != '.' || CRefDesCheck == ".temp")
			{
				CTemp += FloatToSpiceMKSString(CReRunData.value);

				CTemp += " ";
			}

			if(CReRunData.CParamName != "")
				CTemp += CReRunData.CParamName + " ";

			CDataFile.Write(CTemp, CTemp.GetLength());

			if(CReRunData.CModelName != "")
			{
				CDataFile.Write(CReRunData.CModelName, CReRunData.CModelName.GetLength());
			}

			CDataFile.Write("\r\n", 2);
		}

		CDataFile.Write(CReRunEnd, CReRunEnd.GetLength());
	}

	CDataFile.Close();

	return true;
}

bool TCReRuns::GenerateMonteCarlo(CString CFileName, CArray <TCReRunData, TCReRunData &> &CDataList, int number_of_runs, int distribution)
{
	if(!number_of_runs) return false;

	int count = CDataList.GetSize();

	CReRunDataList.SetSize(number_of_runs);

	for(int p = 0; p < number_of_runs; p++)
	{
		TCReRunDataList &CReRunDataListLocal = CReRunDataList[p];

		CReRunDataListLocal.CReRunData.SetSize(count);

		CReRunDataListLocal.CName.Format("Run %d", p); 

		for(int q = 0; q < count; q++)
		{
			TCReRunData &CReRunDataLocal = CReRunDataListLocal.CReRunData[q];

			CReRunDataLocal = CDataList[q];

			CReRunDataLocal.distribution = distribution; 

			CReRunDataLocal.GenerateMonteCarlo();
		}
	}

	return Save(CFileName);
}

bool TCReRuns::GenerateCombienations(CArray <TCReRunData, TCReRunData &> &CDataList, CString CFileName)
{
	// Passed in list is a list of RefId data with a list of values
	bool result = GetFirstRun(CDataList);

	if(!result) return false;

	if(!CDataList.GetSize()) return false;

	while(GetNextRun(CDataList));

	if(CFileName == "") return true;

	return Save(CFileName);
}

bool TCReRuns::GetFirstValues(CArray <double, double> &CValues, CArray <TCReRunData, TCReRunData &> &CDataList)
{
	int count = CDataList.GetSize();

	if(!count) return false;

	if(!CDataList[0].CValueList.GetSize()) return false;

	CValues.SetSize(0);
	CValues.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		if(CDataList[p].CValueList.GetSize()) return false;

		CValues[p] = CDataList[p].CValueList[0];
	}

	return true;
}

bool TCReRuns::GetNextValues(CArray <double, double> &CValues, CArray <TCReRunData, TCReRunData &> &CDataList)
{
	int count = CDataList.GetSize();

	if(!count) return false;

	int value_size = CDataList[0].CValueList.GetSize();

	if(!value_size) return false;

	int max_count = 1;

	int p;

	for(int p = 0; p < count; p++)
	{
		max_count *= CDataList[p].CValueList.GetSize();
	}

	if(!(m_value_index < max_count)) return false;

	CValues.SetSize(0);
	CValues.SetSize(count);

	int index, repeat;
	CValues;

	value_size = 1;

	for(p = 0; p < count; p++)
	{
		repeat = CDataList[p].CValueList.GetSize();

		if(!repeat) continue;

		if(p)value_size *= CDataList[p - 1].CValueList.GetSize();

		index = (int)((double)m_value_index/value_size);

		index = index % repeat;

		CValues[p] = CDataList[p].CValueList[index];
	}

	m_value_index++;

	return true;
}

bool TCReRuns::GetFirstRun(CArray <TCReRunData, TCReRunData &> &CDataList)
{
	CReRunDataList.SetSize(0, 32);

	int count = CDataList.GetSize();

	if(!count) return false;

	m_value_index = 0;

	return true;
}

bool TCReRuns::GetNextRun(CArray <TCReRunData, TCReRunData &> &CDataList)
{
	TCReRunDataList CNewReRunDataList;

	int count = CDataList.GetSize();

	if(!count) return false;

	CArray <double, double> CValues;

	if(!GetNextValues(CValues, CDataList)) return false;

	CNewReRunDataList.CReRunData.SetSize(count);

	CString CValue;
	char check;

	for(int p = 0; p < count; p++)
	{
		TCReRunData &CReRunData = CDataList[p];
		TCReRunData &CThisReRunData = CNewReRunDataList.CReRunData[p];

		CThisReRunData.CRefDes		= CReRunData.CRefDes;
		CThisReRunData.CModelName	= CReRunData.CModelName;
		CThisReRunData.CParamName   = CReRunData.CParamName;
		CThisReRunData.value		= CValues[p];

		if(CThisReRunData.CModelName == "")
		{
			if(CThisReRunData.CRefDes != "")
			{
				check = CThisReRunData.CRefDes.GetAt(0);

				if(check != 't' && check != 'o' && check != 'T' && check != 'O' && check != '.')
					CThisReRunData.CParamName = check;			 
			}

		}

		CNewReRunDataList.CName		+=	CThisReRunData.CRefDes;
		CNewReRunDataList.CName		+= " ";
		CNewReRunDataList.CName		+= CThisReRunData.CParamName;
		CNewReRunDataList.CName		+= "=";

		CValue = FloatToSpiceMKSString(CThisReRunData.value);

		CNewReRunDataList.CName		+= CValue;
		CNewReRunDataList.CName		+= "; ";
	}

	CNewReRunDataList.CName = CNewReRunDataList.CName.Left(CNewReRunDataList.CName.GetLength() - 2);

	CReRunDataList.Add(CNewReRunDataList);

	return true;
}

void TCReRuns::CombienationTest(void)
{
	CArray <TCReRunData, TCReRunData &> CDataList;

	TCReRuns CReRuns;

	CDataList.SetSize(4);

	for(int p = 0; p < 4; p++) CDataList[p].CValueList.SetSize(3);

	CDataList[0].CRefDes		= "R1";
	CDataList[0].CValueList[0]	= 1;
	CDataList[0].CValueList[1]	= 2;
	CDataList[0].CValueList[2]	= 3;

	CDataList[1].CRefDes		= "C2";
	CDataList[1].CValueList[0]	= 1;
	CDataList[1].CValueList[1]	= 2;
	CDataList[1].CValueList[2]	= 3;

	CDataList[2].CRefDes		= "L3";
	CDataList[2].CValueList[0]	= 1;
	CDataList[2].CValueList[1]	= 2;
	CDataList[2].CValueList[2]	= 3;

	CDataList[3].CRefDes		= "X4";
	CDataList[3].CValueList[0]	= 1;
	CDataList[3].CValueList[1]	= 2;
	CDataList[3].CValueList[2]	= 3;

	GenerateCombienations(CDataList, "C:\\Program Files\\AnaSoft\\SuperSpice\\Test.rrn");
}

bool TCReRuns::CreateRRGLines(CArray <TCSelectParameter, TCSelectParameter &> &CData, CArray <CString, CString> &CLineList)
{
	int count = CData.GetSize();

	if(!count) return false;

	CArray <TCReRunData, TCReRunData &> CDataList;
	CString CLine;
	char ref_des_type;
	char ref_des;
	CString CModelName;
	CString CRefDes;

	CLineList.SetSize(0);

	bool flag = 0;

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CRefData = CData[p];

		if(!CRefData.CSweepData.enable) continue;
		if(!CRefData.CRefDesignator) continue;

		if(!CRefData.PCParameter) continue;

		if(IsBadCodePtr((FARPROC)CRefData.PCParameter))// lower level scheamtics might be closed in transist
		{
			CRefData.PCParameter = NULL;

			continue;
		}

		CRefDes = CRefData.CRefDesignator;

		CRefDes.MakeLower();

		ref_des = CRefDes.GetAt(0);

		ref_des_type = CRefData.CRefDesignator.GetAt(0);

		if(CRefData.CSweepData.type != E_PARAMETER_SWEEP_TYPE_LIST) CRefData.CSweepData.CreateValueList();

		if(ref_des == 'c' || ref_des == 'r'  || ref_des == 'l')// . for temperature sweep
		{
			CLine = CRefData.CRefDesignator + " : ";		
		}
		else if(ref_des == 'v' || ref_des == 'i')
		{
			CLine = CRefData.CRefDesignator + " ";

			CLine += CRefData.CParameter  + " ";

			CModelName = CRefData.PCParameter->CDataBaseIdInfo.CRecordName;
	
			CModelName.MakeLower();
 
			if(CModelName.Find("dcsource") >= 0) CModelName = "DC";
			else if(CModelName.Find("sinesource") >= 0) CModelName = "Sine";
			else if(CModelName.Find("pulsesource") >= 0) CModelName = "Pulse";
			else if(CModelName.Find("expsource") >= 0) CModelName = "Exp";
			else if(CModelName.Find("pwlsource") >= 0) CModelName = "PWL";
			else if(CModelName.Find("sffmsource") >= 0) CModelName = "SFFM";
			else return false;

			CLine += ref_des_type;
				
	//		CLine += CModelName + " : ";// added the : use same rountine as RLC 26th June 2014, prior missed 1st value

			CLine += CModelName + " ";
		}
		else if(ref_des == 'e' || ref_des == 'g' ||  ref_des == 'h' ||  ref_des == 'f')
		{		
			CLine = CRefData.CRefDesignator + " ";

			CLine += CRefData.CParameter  + " ";

			switch(ref_des)
			{
				case 'e': CModelName = "VCVS"; break;
				case 'g': CModelName = "VCCS"; break;
				case 'h': CModelName = "CCVS"; break;
				case 'f': CModelName = "CCCS"; break;
			}
		
			CLine += CModelName + " ";
		}
		else if(ref_des == 't')
		{
			CLine = CRefData.CRefDesignator + " ";

			CLine += CRefData.CParameter  + " : ";
		}
		else if(ref_des == '.')
		{
			CRefData.CParameter = "Temp";// Force the parameter name in case of error.

			CLine = CRefData.CRefDesignator + " ";

			CLine += CRefData.CParameter  + " : ";
		}
		else
		{
			CModelName = CRefData.PCParameter->CDataBaseIdInfo.CRecordName;

			CLine = CRefData.CRefDesignator + " ";

			CLine += CRefData.CParameter  + " ";

			CLine += CModelName + " ";
		}
 
		CLine += CRefData.CSweepData.CValueList;

		if(CRefData.CSweepData.CValueList != "")
			CLineList.Add(CLine);

		flag = true;// error if no parameters to be swept
	}

	return flag;
}

bool TCReRuns::CreateParameterReRuns(CString CFileName, CArray <TCSelectParameter, TCSelectParameter &> &CData)
{
	int count = CData.GetSize();

	if(!count) return false;

	CArray <TCReRunData, TCReRunData &> CDataList;
	CArray <CString, CString> CLineList;
	
	if(!CreateRRGLines(CData, CLineList)) return false;

	if(!GenerateDataList(CLineList, CDataList)) return false;

	if(!GenerateCombienations(CDataList, CFileName))  return false;

	return true;
}

bool TCReRuns::LoadSetup(CString CFileName)
{
	TCIFStream CFileStream;

	int flags = ios::in;

	CFileStream.text_file_mode = true;

	CFileStream.open(CFileName, flags);

	if(CFileStream.fail()) return false;

	char *p_buff = new char[16384];

	if(!p_buff) return false;

	CArray <CString, CString> CLineList;
	CString CLine;

	while(!CFileStream.eof())
	{
		if(!CFileStream.ReadLine(p_buff, 16383)) break;
		
		CLine = p_buff;

		CLine.TrimLeft();
		CLine.TrimRight();

		CLineList.Add(CLine);
	}

	if(p_buff) delete [] p_buff;

	CFileStream.close();

	CArray <TCReRunData, TCReRunData &> CDataList;

	if(!GenerateDataList(CLineList, CDataList)) return false;

	CFileName = RemoveExtention(CFileName);

	CFileName += ".rrn";

	return GenerateCombienations(CDataList, CFileName);
}

bool TCReRuns::GenerateDataList(CArray <CString, CString> &CLineList, CArray <TCReRunData, TCReRunData &> &CDataList)
{
	int count = CLineList.GetSize();

	if(!count) return false;

	CString CLine, CWord;
	double data;

	for(int p = 0; p < count; p++)
	{
		CLine = CLineList[p];

		CWord = GetFirstWord(CLine);

		if(CWord == "") continue;

		if(CWord.GetAt(0) == '*') continue;

		TCReRunData CReRunData;

		CReRunData.CRefDes = CWord;

		CLine = RemoveFirstWord(CLine);

		CWord = GetFirstWord(CLine);

		CWord.TrimLeft();

		if(CWord == "") continue;

		if(CWord.GetAt(0) == ':')
		{
			CLine = RemoveFirstWord(CLine);

			CWord = GetFirstWord(CLine);

			while(CWord != "")
			{
				data = MKSStringToFloat(CWord);

				CReRunData.CValueList.Add(data);

				CLine = RemoveFirstWord(CLine);

				CWord = GetFirstWord(CLine);
			}

			CDataList.Add(CReRunData);

			continue;
		}

		CReRunData.CParamName = CWord;

		CLine = RemoveFirstWord(CLine);
			
		if(CLine == "") continue;

		if(CLine.GetAt(0) == ':')// T! td : 1n 2n 3n
		{
			CLine = RemoveFirstWord(CLine);

			CWord = GetFirstWord(CLine);

			while(CWord != "")
			{
				data = MKSStringToFloat(CWord);

				CReRunData.CValueList.Add(data);

				CLine = RemoveFirstWord(CLine);

				CWord = GetFirstWord(CLine);
			}

			CDataList.Add(CReRunData);

			continue;
		}

		CWord = GetFirstWord(CLine);

		if(CWord == "") continue;

		CReRunData.CModelName = CWord;

		CLine = RemoveFirstWord(CLine);

		CWord = GetFirstWord(CLine);

		while(CWord != "")
		{
			data = MKSStringToFloat(CWord);

			CReRunData.CValueList.Add(data);

			CLine = RemoveFirstWord(CLine);

			CWord = GetFirstWord(CLine);
		}

		CDataList.Add(CReRunData);
	}

	return true;
}

void TCReRuns::operator += (TCReRuns &CReRuns)
{
	int line_count = CReRuns.CReRunDataList.GetSize();

	if(!line_count) return;

	int current_count = CReRunDataList.GetSize();

	int new_count = line_count + current_count;

	CReRunDataList.SetSize(new_count);

	for(int p = current_count; p < new_count; p++) CReRunDataList[p] = CReRuns.CReRunDataList[p - current_count];
}

bool TCReRuns::CreateWCFromDotModels(CArray <CString, CString&> &CModelLines, CString CRunName, CString CFileName, TCReRunWCData &CReRunWCData)
{
	CReRunDataList.SetSize(1);

	TCReRunDataList &CReRunModelDataList = CReRunDataList[0];

	CReRunModelDataList.CName = CRunName;

	int model_line_count = CModelLines.GetSize();
	int counter = 0;

	CString CLine, CWord, CLibFileName;
	TCReRunData CData;
	char ref_des;
	int sign = 1;
	int flag_subckt = 0;

	CLibFileName = RemoveExtention(CFileName);

	CRunName.Replace(':', '%');

	CLibFileName += CRunName;

	CLibFileName += ".lib";

	CReRunModelDataList.CReRunData.SetSize(model_line_count + 1);

	CData.CRefDes = ".lib";
	CData.CModelName = CLibFileName;
	CData.CParamName = "";	

	CReRunModelDataList.CReRunData[0] = CData;

	for(int p = 1; p < model_line_count; p++)
	{
		CLine = CModelLines[p];

		CWord = GetFirstWord(CLine);

		CWord.MakeLower();

		if(CWord == "") continue;

		ref_des = CWord.GetAt(0);

		if(ref_des == '*') continue;

		if(ref_des == '.')
		{
			if(CWord == ".subckt")
			{
				flag_subckt++;
			}
			if(CWord == ".ends")
			{
				flag_subckt--;
			}
				
			continue;		
		}

		if(flag_subckt > 0) continue;

		if(ref_des != 'r' && ref_des != 'c' && ref_des != 'l' && ref_des != 'v' && ref_des != 'i') continue;

		CData.CParamName	= ref_des;
		CData.CRefDes		= CWord;
		CData.CModelName	= "";

		if(ref_des == 'r' || ref_des == 'c' || ref_des == 'l')
		{
			if(CRunName.Find("SRLC") > -1 ) sign = -1;
			else if(CRunName.Find("WRLC") > -1 ) sign = 1;
			else sign = 0;

			if(ref_des == 'r') CData.sigma = CReRunWCData.r_sigma;
			else if(ref_des == 'c') CData.sigma = CReRunWCData.c_sigma;
			else CData.sigma = CReRunWCData.l_sigma;
		}
		else //(ref_des == 'v' or 'i')
		{
			if(CRunName.Find("SG") > -1 ) sign = 1;
			else if(CRunName.Find("WG") > -1 ) sign = -1;
			else sign = 0;

			CData.sigma = CReRunWCData.ps_sigma;

			CData.CModelName = RemoveFirstWord(CLine);

			CData.CModelName = RemoveFirstWord(CData.CModelName);

			CData.CParamName = "";
		}

		CLine = RemoveFirstWord(CLine);

		CWord = GetFirstWord(CLine);

		CData.mean = MKSStringToFloat(CWord);

		CData.GenerateWC(sign);

		CReRunModelDataList.CReRunData[counter +  1] = CData;

		counter++;
	}

	CData.CRefDes = ".TEMP";
	CData.CModelName = "";
	CData.sigma = 0;
	sign = 0;

	if(CRunName.Find("ST") > -1 ) CData.mean = CReRunWCData.t_max;
	else if(CRunName.Find("WT") > -1 ) CData.mean = CReRunWCData.t_min;
	else CData.mean = CReRunWCData.t_nom;

	CData.GenerateWC(sign);

//	CData.CParamName = FloatToMKSString(CData.value);
	CData.CParamName = "";

	CReRunModelDataList.CReRunData[counter +  1] = CData;// yeah no way will counter not be , max count!!

	counter++;

	CReRunModelDataList.CReRunData.SetSize(counter + 1);

	return SaveDotModels(CLibFileName, CModelLines);
}

///////////////////////////////////////////////
///////////////////////////////////////////////