
#ifndef _TCReRuns_H
#define _TCReRuns_H

#include <afxtempl.h>

class TCBillOfMaterials;
class TCSelectParameter;

enum TE_MONTE_CARLO_DISTIBUTION
{
	E_MONTE_CARLO_UNIFORM,
	E_MONTE_CARLO_GAUSSIAN,
	E_MONTE_CARLO_POISSION,

};

class TCReRunWCData : public CObject
{
	public:	TCReRunWCData(void);
			TCReRunWCData(TCReRunWCData &CBlank);
			~TCReRunWCData(void);

			double r_sigma;
			double c_sigma;
			double l_sigma;
			double ps_sigma;
			double t_max;
			double t_min;
			double t_nom;

			void operator = (TCReRunWCData &CBlank);
};

class TCDotModelData
{
	public:	TCDotModelData(void);
			TCDotModelData(TCDotModelData &CReRunData);
			~TCDotModelData(void);

			CArray <CString, CString&> CModelLines;
			CString CName;

			void operator = (TCDotModelData &CData);
};

class TCReRunData 
{
	public:	TCReRunData(void);
			TCReRunData(TCReRunData &CReRunData);
			~TCReRunData(void);

			CString CRefDes;
			CString CParamName;
			CString CModelName;
			double  value;
			int		param_type;
			double  mean;
			double	sigma;
			double	variable;
			int		distribution;


			CArray <double, double> CValueList;

			void	ConvetParameterNameToInt(void);
			void    ConvertDCParam(void);
			void    ConvertSineParam(void);
			void    ConvertPulseParam(void);
			void    ConvertSFFMParam(void);
			void    ConvertExpParam(void);

			bool	GenerateMonteCarlo(void);
			bool	GenerateWC(int sign);


			void operator = (TCReRunData &CReRunData);
			void operator = (TCBillOfMaterials &CBillOfMaterials);
			
};

class TCReRunDataList 
{
	public:	TCReRunDataList(void);
			TCReRunDataList(TCReRunDataList &CReRunDataList);
			~TCReRunDataList(void);

			CString CName;

			bool GenerateMonteCarlo(void);

			void operator = (TCReRunDataList &CReRunDataList);
			
			CArray <TCReRunData,TCReRunData &> CReRunData;
};

class TCReRuns 
{
	public:	TCReRuns(void);
			~TCReRuns(void);

			CArray <TCReRunDataList, TCReRunDataList &> CReRunDataList;

			void operator += (TCReRuns &CReRuns);

			bool Load(CString CFileName);
			bool Save(CString CFileName);
			bool SaveDotModels(CString CFileName, CArray <CString, CString&> &CModelLines);
			bool LoadSetup(CString CFileName);
			bool CreateParameterReRuns(CString CFileName, CArray <TCSelectParameter, TCSelectParameter &> &CData);
			bool CreateRRGLines(CArray <TCSelectParameter, TCSelectParameter &> &CData, CArray <CString, CString> &CLineList);
			void Clear(void);
			void Init(void);
			bool GenerateCombienations(CArray <TCReRunData, TCReRunData &> &CDataList, CString CFileName ="");
			bool GenerateMonteCarlo(CString CFileName, CArray <TCReRunData, TCReRunData &> &CDataList, int number_of_runs, int distribution);
			bool CreateWCFromDotModels(CArray <CString, CString&> &CModelLines, CString CRunName, CString CFileName, TCReRunWCData &CReRunWCData);

			bool GenerateDataList(CArray <CString, CString> &CLineList, CArray <TCReRunData, TCReRunData &> &CDataList);
			
			void CombienationTest(void);

			char *GetFirstRunFileName(char *p_output_file_name, char *p_rerun_file_name);
			char *GetNextRunFileame(void);

			bool GetFirstRun(CArray <TCReRunData, TCReRunData &> &CDataList);
			bool GetNextRun(CArray <TCReRunData, TCReRunData &> &CDataList);
			bool GetFirstValues(CArray <double, double> &CValues, CArray <TCReRunData, TCReRunData &> &CDataList);
			bool GetNextValues(CArray <double, double> &CValues, CArray <TCReRunData, TCReRunData &> &CDataList);

			CString COuputFileBaseName;
			CString COuputFileName;

			bool enable;
			bool loaded;
			int  run_index;
			int  m_value_index;

};

#endif