// TCResistorLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCResistorLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCResistorLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;
extern double MKSStringToFloat(CString &CTextData);
extern CString FloatToSpiceMKSString(double data);

/////////////////////////////////////////////////////////////////////////////
// TCResistorLabelsDlg property page

TCResistorLabelsDlg::TCResistorLabelsDlg() : CPropertyPage(TCResistorLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCResistorLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	CMEditValueHeader = _T("");
	m_value_designer_type = -1;
	CMCurrent = _T("");
	CMEditTC1 = _T("");
	CMEditTC2 = _T("");
	m_check_visable_tc1 = FALSE;
	m_check_visable_tc2 = FALSE;
	m_multiplier_m_is_visable = FALSE;
	CMMultiplierM = _T("");
	//}}AFX_DATA_INIT
}

TCResistorLabelsDlg::~TCResistorLabelsDlg()
{
}

void TCResistorLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCResistorLabelsDlg)
	DDX_Control(pDX, IDC_CHECK_VISABLE_TC2, CMVisableTC2);
	DDX_Control(pDX, IDC_CHECK_VISABLE_TC1, CMVisableTC1);
	DDX_Control(pDX, IDC_EDIT_TC2, CMEditCtrlTC2);
	DDX_Control(pDX, IDC_EDIT_TC1, CMEditCtrlTC1);
	DDX_Control(pDX, IDC_RADIO_VALUE_DESIGNER, CMValueDesignerCtrl);
	DDX_Control(pDX, IDC_EDIT_CURRENT, CMCurrentCtrl);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditCntlRefDes);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_STATIC_VALUE, CMEditValueHeader);
	DDX_Radio(pDX, IDC_RADIO_VALUE_DESIGNER, m_value_designer_type);
	DDX_Text(pDX, IDC_EDIT_CURRENT, CMCurrent);
	DDX_Text(pDX, IDC_EDIT_TC1, CMEditTC1);
	DDX_Text(pDX, IDC_EDIT_TC2, CMEditTC2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TC1, m_check_visable_tc1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TC2, m_check_visable_tc2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_MULTIPLIER_M, m_multiplier_m_is_visable);
	DDX_Text(pDX, IDC_EDIT_MULTIPLIER_M, CMMultiplierM);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCResistorLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCResistorLabelsDlg)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER, OnRadioValueDesignerNone)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER2, OnRadioValueDesignerPositive)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER3, OnRadioValueDesignerNegative)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER4, OnRadioValueDesignerCurrent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCResistorLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_RESISTOR)
	{
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE] = (float) m_value_designer_type;
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE] = (float) MKSStringToFloat(CMCurrent);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelValue = CMEditTC1;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].is_visable = !!m_check_visable_tc1;
	
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelValue = CMEditTC2;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].is_visable = !!m_check_visable_tc2;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue = CMMultiplierM;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].is_visable = !!m_multiplier_m_is_visable;
	}
	else
	{
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE] = (float) 0;
	}

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCResistorLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
		
	// need to update from value set in other page
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;


	return CPropertyPage::OnSetActive();
}

BOOL TCResistorLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_RESISTOR)
	{
		CMCurrent = FloatToSpiceMKSString((double)PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE]);

		m_value_designer_type = (int) PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];

		CMEditTC1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelValue;
		m_check_visable_tc1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].is_visable;
	
		CMEditTC2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelValue;
		m_check_visable_tc2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].is_visable;

		CMMultiplierM = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue;
		m_multiplier_m_is_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].is_visable;
	}

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_RESISTOR ||
	   PCSchematicObjectData->component_property_view_type == E_PROPERTY_THERMISTOR	|| 
	   PCSchematicObjectData->component_property_view_type == E_PROPERTY_FUSE)
	{
		CMEditValueHeader = "Resistance";
	}
	else 
	{
		CMEditValueHeader = "Spice value";
	}

	CPropertyPage::OnInitDialog();

//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);
	CMEditCntlRefDes.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].read_only);

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_RESISTOR)
	{
		CMValueDesignerCtrl.EnableWindow(true);
		CMCurrentCtrl.EnableWindow(true);

		if(m_value_designer_type != E_VALUE_DESIGNER_CURRENT) CMCurrentCtrl.EnableWindow(false);

		CMEditCtrlTC1.EnableWindow(true);
		CMEditCtrlTC2.EnableWindow(true);
		CMVisableTC1.EnableWindow(true);
		CMVisableTC2.EnableWindow(true);
	}
	else
	{
		CMValueDesignerCtrl.EnableWindow(false);
		CMCurrentCtrl.EnableWindow(false);
		CMEditCtrlTC1.EnableWindow(false);
		CMEditCtrlTC2.EnableWindow(false);
		CMVisableTC1.EnableWindow(false);
		CMVisableTC2.EnableWindow(false);
	}

	return TRUE;  
}

void TCResistorLabelsDlg::OnRadioValueDesignerNone() 
{
	CMCurrentCtrl.EnableWindow(false);	
}

void TCResistorLabelsDlg::OnRadioValueDesignerPositive() 
{
	CMCurrentCtrl.EnableWindow(false);	
}

void TCResistorLabelsDlg::OnRadioValueDesignerNegative() 
{
	CMCurrentCtrl.EnableWindow(false);	
}

void TCResistorLabelsDlg::OnRadioValueDesignerCurrent() 
{
	CMCurrentCtrl.EnableWindow(true);	
}
