/*

	Copywrite ANASOFT LTD. (c) 1996
	
	File:	




 */

#include "stdafx.h"
#include "math.h"
#include "resource.h"
#include "TDVersion.h"
#include "SuperSpice.h"
#include "TESuperSpiceMsgStringsEnums.h"
#include "Generic.h"		// for MultyplyCPoint temp
#include "TCStringFunctions.h"
#include "TCTestPointData.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSpiceParameters.h"
#include "TCSuperSpiceDataBase.h"
#include "TCWireInfo.h"
#include "TCSchematicManager.h"
#include "TCSchematicObject.h"
#include "TCGeneratorData.h"
#include "TCOutputWaveformData.h"
#include "TCFloatingCursorDlg.h"
#include "TCSuperSpiceDoc.h"
#include "TEPropertyViewTypes.h"
#include "TCSuperSpiceView.h"
#include "TCOutputWaveformView.h"
#include "TCSymbolEditorView.h"
#include "TCModelSymbolTab.h"

#ifdef _DEBUG
#define new DEBUG_NEW 
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern CString GSubCktCurrentPinStr;
extern TCModelSymbolTab CModelSymbolTab;


IMPLEMENT_SERIAL(TCSchematicManager, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSchematicManagerData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCWireTags, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCWireList, CObject, ID_VERSION_NUMBER)

char CLetterArray[] ={'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '%'};

extern TCSuperSpiceDataBase GCSuperSpiceDataBase; // Global
extern TCMultyTaskedString CGlobalStatusMessage;
extern void MultyplyCPoint(CPoint*, float);
extern bool IsBadWindowHandle(CWnd*);
extern int global_screen_planes;
extern int global_screen_bitspixels;
extern CDC GlobalCDCTemp;
CString FloatToMKSString(double data);
void SetDataCursorBar(TCFloatingCursorData &CFloatingCursorData);
double MKSStringToFloat(CString &CTextData);
extern int GetGeneratorVersionfromViewType(int view_type);


enum TE_MISC_SCHEMATIC_MANAGER
{
	E_SCHEMATIC_OBJECT_ALLOC_SIZE = 2048,
};
//////////////////////////////////////////////////////////////

TCWireTags::TCWireTags()
{
	PCSchematicObject = NULL;
}
void TCWireTags::operator = (TCWireTags &CWireTags)
{
	int p, count;

	PCSchematicObject = CWireTags.PCSchematicObject;

	count = CWireTags.Info.GetSize();

	Info.SetSize(count, count);

	for(p = 0; p < count; p++) Info[p] = CWireTags.Info[p];

}
void TCWireTags::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	int count, p;

	if(ar.IsStoring())
	{
		count = Info.GetSize();
		
		ar << count;

		for(p = 0; p < count; p++)Info.Serialize(ar);
	}
	else
	{
		ar >> count;

		Info.SetSize(count, count);

		for(p = 0; p < count; p++)Info.Serialize(ar);
	}
}
//////////////////////////////////////////////////////////////
void TCWireList::operator = (TCWireList &CWireList)
{
	int count, p;

	count = CWireList.CWireTags.GetSize();

	for(p = 0; p < count; p++) CWireTags[p] = CWireList.CWireTags[p];
}
void TCWireList::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	int count, p;

	if(ar.IsStoring())
	{
		count = CWireTags.GetSize();
		
		ar << count;

		for(p = 0; p < count; p++)CWireTags.Serialize(ar);
	}
	else
	{
		ar >> count;

		CWireTags.SetSize(count, count);

		for(p = 0; p < count; p++)CWireTags.Serialize(ar);
	}
}
//////////////////////////////////////////////////////////////

TCSchematicManager::TCSchematicManager()
{												
	m_error = false;
	is_pin_moveable = false;
	is_symbol_editor = false;
	is_symbol_viewer = false;
	m_auto_keep_pasting = true;
	zoom_index = 8;

	PCWaveformDataRuns = NULL;

	CMSchematicManagerData.page_id = 0;
	CMSchematicManagerData.is_active_view = false;

	CMSchematicManagerData.CSelectionBoxThickness.cx = 1;
	CMSchematicManagerData.CSelectionBoxThickness.cy = 1;

	CMSchematicManagerData.CViewPortOrigin.y = 0;
	CMSchematicManagerData.CViewPortOrigin.x = 0;

	CMSchematicManagerData.CScrollBarPosition.x = 0;
	CMSchematicManagerData.CScrollBarPosition.y = 0;
	CMSchematicManagerData.zoom = 0.5;

	UpdatePageOutline();

	PCMLastCreatedGraphic = NULL;
	PCLastWaveformGraphic = NULL;
	m_last_created_id	= -1;

	fm_select_region = false;
	graphics_modified = false;

	CMSchematicManagerData.CGraphicList.SetSize(0, E_SCHEMATIC_OBJECT_ALLOC_SIZE);

	m_current_wire_being_drawn = -1;
	PCMCurrentWireBeingDrawnObject = NULL;
	CMLastMousePosition.x = 0;
	CMLastMousePosition.y = 0;

	f_inspect_highlight = false;
	inspect_highlight = 0;
	m_component_is_outlined = false;
	CMLastOutlinedMousePosition.x = 0;
	CMLastOutlinedMousePosition.y = 0;
	PCMLastOutlinedComponent = NULL;
	m_last_outline_property = E_SCHEMATIC_OBJECT;

	CMDrawSelectionRegion.SetStyle(E_SELECTION_REGION_OUTLINE_STYE);
	CMComponentOutlineRegion.SetStyle(E_COMPONENT_OUTLINE_STYE);

	PCCursor1 = NULL;
	PCCursor2 = NULL;

	active_cursor = 1;

	CreateCursor(0); 
	CreateCursor(1);

	CPinNumberStack.SetBlockSize(64);
	CPinNumberStack.CreateNewNumbers();
	CPinNumberStack.Reset();

	SetUpTipWindow();

	repaste_required = false;
}
	
TCSchematicManager::~TCSchematicManager()
{
	if(::IsWindow(CMTipWindow.m_hWnd)) 
	{			
		CMTipWindow.DestroyWindow();
	}

	DeleteSchematicObjects();
	DeleteCursor(0);
	DeleteCursor(1);
	DeleteDeleteList();
}

void TCSchematicManager::SetUpTipWindow(void)
{
	int background_colour	= ::GetSysColor(COLOR_INFOBK);
	int text_colour			= ::GetSysColor(COLOR_INFOTEXT);

	CMTipWindow.SetTipColors(background_colour, text_colour);
	CMTipWindow.SetMargins(CSize(8,8));
	CMTipWindow.SetLineSpace(0);
}

void TCSchematicManager::DisplayTipWindow(CPoint CLocation, CString CText, bool position_type)
{

	if(position_type && !GCSuperSpiceGlobalData.CDrawData.lables_graph) return;
	if(!position_type && !GCSuperSpiceGlobalData.CDrawData.labels_schematic) return;

	if(CMSchematicManagerData.PCView->IsKindOf(RUNTIME_CLASS(TCSymbolEditorView))) return;

	int system_state = E_GRAPHICS_MANAGER_STATE_IDLE;
	
	if(CMSchematicManagerData.PCView->IsKindOf(RUNTIME_CLASS(TCSuperSpiceView)))
	{
		TCSuperSpiceView *PCView = (TCSuperSpiceView*)CMSchematicManagerData.PCView;

		system_state = PCView->CSuperSpiceViewData.system_state;
	}

	if(CMSchematicManagerData.PCView->IsKindOf(RUNTIME_CLASS(TCOutputWaveformView)))
	{
		TCOutputWaveformView *PCView = (TCOutputWaveformView*)CMSchematicManagerData.PCView;

		system_state = PCView->CSuperSpiceViewData.system_state;
	}

	if(system_state != E_GRAPHICS_MANAGER_STATE_IDLE && system_state != E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED) return;
	
	CPoint COffset;

	if(position_type)
	{
		COffset.x = GCSuperSpiceGlobalData.CDrawData.lable_graph_x;
		COffset.y = GCSuperSpiceGlobalData.CDrawData.lable_graph_y;
	}
	else
	{
		COffset.x = GCSuperSpiceGlobalData.CDrawData.lable_schematic_x;
		COffset.y = GCSuperSpiceGlobalData.CDrawData.lable_schematic_y;
	}

	CMSchematicManagerData.PCView->ClientToScreen(&CLocation);

	CLocation += COffset;

	if(!::IsWindow(CMTipWindow.m_hWnd))
		if(!CMTipWindow.Create(CMSchematicManagerData.PCView)) return;

	CMTipWindow.SetTipText("", CText, true);// Null title GCSuperSpiceGlobalData.CDrawData.lable_timeout

//	CMTipWindow.ShowTipWindow(CLocation, TWS_XT_ALPHASHADOW | TWS_XT_THICKBORDER | TWS_XT_DROPSHADOW, 0, GCSuperSpiceGlobalData.CDrawData.lable_timeout, true);

	CMTipWindow.ShowTipWindow(CLocation, TWS_XT_THICKBORDER, 0, GCSuperSpiceGlobalData.CDrawData.lable_timeout, true);

	ReleaseCapture();
}

void TCSchematicManager::SwopCursor(CPoint CLocation)
{
	active_cursor = !active_cursor;

	CCursorData.cursor2_active = active_cursor;

	ClearCursor(active_cursor);

	PasteCursor(active_cursor, CLocation);
}

void TCSchematicManager::ClearCursor(int id)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	if(!id) 
	{
		if(PCCursor1)
			PCCursor1->Clear(PCViewDC, false);
	}
	else 
	{
		if(PCCursor2)
			PCCursor2->Clear(PCViewDC, false);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::MoveCursor(int id, CPoint CLocation)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	if(repaste_required)
	{
		RepasteCursor(PCViewDC, active_cursor);

		repaste_required = false;
	}

	if(!id) 
	{
		if(PCCursor1)
			PCCursor1->MoveTo(PCViewDC, CLocation, false, true);
	}
	else 
	{
		if(PCCursor2)

			PCCursor2->MoveTo(PCViewDC, CLocation, false, true);
	}
	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::PasteCursor(int id, CPoint CLocation)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	if(!id) 
	{
		if(PCCursor1)
			PCCursor1->Paste(PCViewDC, CLocation, true);
	}
	else 
	{
		if(PCCursor2)
			PCCursor2->Paste(PCViewDC, CLocation, true);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::RepasteCursor(CDC *PCViewDC, int id)
{
	if(!id) 
	{
		if(PCCursor1)
			PCCursor1->Paste(PCViewDC, PCCursor1->CMLocation, true);
	}
	else 
	{
		if(PCCursor2)
			PCCursor2->Paste(PCViewDC, PCCursor2->CMLocation, true);
	}
}

TCSchematicObject *TCSchematicManager::CreateCursor(int id)
{
	//Clipboard calls this befor edatabase is set up
	if(!GCSuperSpiceDataBase.CMDefaults[E_BOX_WAVEFORM_CURSOR].f_vector_graphic) return NULL;

	TCSchematicObject *PCSchematicObject;

	PCSchematicObject = new TCSchematicObject;

	if(!PCSchematicObject) return NULL;

	PCSchematicObject->is_symbol_editor = is_symbol_editor;

	if(!PCSchematicObject->Create(&GlobalCDCTemp, GCSuperSpiceDataBase.CMDefaults[E_BOX_WAVEFORM_CURSOR], 1.0)) 
	{
		if(PCMLastOutlinedComponent == PCSchematicObject) PCMLastOutlinedComponent = NULL;

		delete PCSchematicObject;

		ASSERT(0);

		return NULL;
	}

	if(!id) 
	{
		PCCursor1 = PCSchematicObject;
		PCSchematicObject->SetSelect();
	}
	else 
	{
		PCCursor2 = PCSchematicObject;

		PCSchematicObject->SetSelect();// when tracking mouse
	}

	CPoint CLocation;
	CLocation.x = 0;
	CLocation.y = 0;

	PCSchematicObject->Paste(&GlobalCDCTemp, CLocation, true);

	return PCSchematicObject;
}

void TCSchematicManager::DeleteCursor(int id)
{
	if(!id) 	
	{
		if(PCCursor1) delete PCCursor1;

		PCCursor1 = NULL;

		return;
	}

	if(PCCursor2) delete PCCursor2;

	PCCursor2 = NULL;
}

void TCSchematicManager::SetView(CView *PCView)
{
	CMSchematicManagerData.PCView = PCView;
	
	if(PCView) CMSchematicManagerData.is_active_view = true;
	else CMSchematicManagerData.is_active_view = false;
}

CView *TCSchematicManager::GetView(void)
{
	return CMSchematicManagerData.PCView;
}

bool TCSchematicManager::IsActiveView(void)
{
	return CMSchematicManagerData.is_active_view;
}

bool TCSchematicManager::Error()
{
	bool result = m_error;

	m_error = false;

	return result;
}

int	TCSchematicManager::GetPageId(void)
{
	return CMSchematicManagerData.page_id;
}

bool TCSchematicManager::SetPageId(int page_id)
{
	CMSchematicManagerData.page_id = page_id;

	TCSchematicObject*	PCSchematicObject;

	int number = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < number; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
			
		PCSchematicObject->SetPageId(page_id);
	}

	return true;
}

bool TCSchematicManager::SetMemoryBlockSize(int mem_block_size)
{
	int size = CMSchematicManagerData.CGraphicList.GetSize();

	CMSchematicManagerData.CGraphicList.SetSize(size, size);
	mem_block_size;
	return true;
}

void TCSchematicManager::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	CMSchematicManagerData.Serialize(ar);

	if(ar.IsLoading())
	{
		zoom_index = GCSuperSpiceGlobalData.GetZoomIndex(CMSchematicManagerData.zoom);
	}

	SerializeSchematicObjects(ar);
}

void TCSchematicManager::SerializeSchematicObjects(CArchive &ar)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObjectData CSchematicObjectData;
	
	int count;
	int p;

	if (ar.IsStoring())
	{	
		count = CMSchematicManagerData.CGraphicList.GetSize();

		ar << count;

		for(p = 0; p < count; p++)
		{
			PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

			PCSchematicObject->Serialize(ar);
		}
	}
	else
	{
		ar >> count;

#ifdef _DEBUG
			if(count > 1023)
			{
				ASSERT(0);

				return;
			}
#endif

 
		for(p = 0; p < count; p++)
		{
			TCSchematicObject *PCSchematicObject = new TCSchematicObject;

			ASSERT(PCSchematicObject); // Major error

			PCSchematicObject->PCWaveformDataRuns = PCWaveformDataRuns;

			if(PCSchematicObject) 
			{
				PCSchematicObject->is_symbol_editor = is_symbol_editor;//is_symbol_editor is not serialised

				PCSchematicObject->Serialize(ar);
			}

			CMSchematicManagerData.CGraphicList.Add(PCSchematicObject);
		}
	}
}

TCSchematicManagerData::TCSchematicManagerData(void)
{
	page_id				= 0;
	is_active_view		= false;
	CViewPortOrigin.x	= 0;
	CViewPortOrigin.y	= 0;
	CScrollBarPosition.x = 0;
	CScrollBarPosition.y = 0;
	CViewSize.cx		= 1024;
	CViewSize.cy		= 1024;
	zoom				= 1;

	CActiveWaveformRefDesignator = "W1";

	PCPageData = new TCSchematicPageData;
}
TCSchematicManagerData::~TCSchematicManagerData()
{
	if(PCPageData) delete PCPageData;
}

void TCSchematicManagerData::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	PCPageData->Serialize(ar);

	if (ar.IsStoring())
	{
		ar << page_id;
		ar.Write(&is_active_view, sizeof(is_active_view));
		ar << CViewPortOrigin;
		ar << CScrollBarPosition;
		ar << CViewSize;
		ar << zoom;
		ar << CZoomCenter;
		ar << CActiveWaveformRefDesignator;
	}
	else
	{
		ar >> page_id;
		ar.Read(&is_active_view, sizeof(is_active_view));
		ar >> CViewPortOrigin;
		ar >> CScrollBarPosition;
		ar >> CViewSize;
		ar >> zoom;
		ar >> CZoomCenter;
		ar >> CActiveWaveformRefDesignator;
	}
}

void TCSchematicManagerData::operator = (TCSchematicManagerData &CGraphicsManagerData)
{
	page_id				= CGraphicsManagerData.page_id;
	is_active_view		= CGraphicsManagerData.is_active_view;
	CViewPortOrigin		= CGraphicsManagerData.CViewPortOrigin;
	CScrollBarPosition	= CGraphicsManagerData.CScrollBarPosition;
	CViewSize			= CGraphicsManagerData.CViewSize;
	zoom				= CGraphicsManagerData.zoom;
	CZoomCenter			= CGraphicsManagerData.CZoomCenter;
	CActiveWaveformRefDesignator = CGraphicsManagerData.CActiveWaveformRefDesignator;

	if(PCPageData)*PCPageData = *CGraphicsManagerData.PCPageData;
	else 
	{
		PCPageData = new TCSchematicPageData;

		if(!PCPageData) return;

		*PCPageData = *CGraphicsManagerData.PCPageData;
	}
}
////////////////////////////////////////////////
void TCSchematicManager::SetViewSize(CSize CViewSize)
{
	CMSchematicManagerData.CViewSize = CViewSize;
}
CSize TCSchematicManager::GetViewSize(void)
{
	return CMSchematicManagerData.CViewSize;
}	


int TCSchematicManager::GetGridSize(void)
{
	if(is_symbol_editor) return GCSuperSpiceGlobalData.CDrawData.symbol_editor_grid_size;
	return GCSuperSpiceGlobalData.CDrawData.grid_size;
}

int TCSchematicManager::GetSnapToDistance(void)
{
	if(is_symbol_editor) return GCSuperSpiceGlobalData.CDrawData.symbol_editor_snap_to_distance;
	return GCSuperSpiceGlobalData.CDrawData.snap_to_distance;
}

void TCSchematicManager::SetOverideSnapToGrid(void)
{
	// a bit messy to pass data via this global
	GCSuperSpiceGlobalData.CDrawData.symbol_editor_overide_snap_to_grid = true;
}

void TCSchematicManager::ClearOverideSnapToGrid(void)
{
	GCSuperSpiceGlobalData.CDrawData.symbol_editor_overide_snap_to_grid = false;
}

void TCSchematicManager::SetZoom(float zoom)
{
/*	int l_zoom;//quantise to 1/16;

	l_zoom = (int) (zoom * 16);

	zoom = (float)(l_zoom / 16 + 0.5);

	if(zoom < .0625) zoom = 0.0625;*/

	CMSchematicManagerData.zoom = zoom;
}

float TCSchematicManager::GetZoom(void)
{
	if(!CMSchematicManagerData.zoom) return 1;

	return 	CMSchematicManagerData.zoom;
}
CPoint TCSchematicManager::GetZoomCenter(void)
{
	return CMSchematicManagerData.CZoomCenter;
}
void TCSchematicManager::SetZoomCenter(CPoint CZoomCenter)
{
	CMSchematicManagerData.CZoomCenter = CZoomCenter;
}

void TCSchematicManager::Zoom(float zoom, TE_GRAPHICS_MANAGER_SYSTEM_STATE state)
{
	ClearOverideSnapToGrid();//Play it safe

	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CPoint CAbsoluteLocation;
	CPoint CEndLocation;

	if(m_component_is_outlined) EraseComponentOutline();

	if(is_symbol_editor) SetOverideSnapToGrid();// do not scrambleup/requantise fine resolutionlines

	if(state == E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE)
	{
		if(PCMCurrentWireBeingDrawnObject)// should not be NULL
		{
			int q = FindGraphicId(PCMCurrentWireBeingDrawnObject);

			if(q < 0) 
			{
				if(is_symbol_editor) ClearOverideSnapToGrid();

				return;
			}

			CMSchematicManagerData.CGraphicList.RemoveAt(q);

			if(PCMCurrentWireBeingDrawnObject) delete PCMCurrentWireBeingDrawnObject;
		}
	}

	CMSchematicManagerData.zoom = zoom;

	ClearScreen(PCViewDC);
	DrawGrid(PCViewDC);

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject *PCSchematicObject;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		PCSchematicObject->Zoom(zoom);

		if(PCSchematicObject->m_property != E_WAVEFORM_OBJECT) continue;

//		PCSchematicObject->ReLabelAxis();// a bit of a cludge
//		PCSchematicObject->Paste(&GlobalCDCTemp, PCSchematicObject->CMLocation);
	}

	if(state == E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE)
	{
		CAbsoluteLocation = CCurrentWireAbsoluteLocation;
		MultyplyCPoint(&CAbsoluteLocation, zoom);

		CEndLocation = CAbsoluteLocation;// force start to end positive
		int size = (int)(4 * GetGridSize() * zoom);
		CEndLocation.x += size;
		CEndLocation.y += size;

		PCMCurrentWireBeingDrawnObject = CreateWire(&GlobalCDCTemp, CAbsoluteLocation, CEndLocation);

		PCMCurrentWireBeingDrawnObject->SetSelect();
	}

	UpdatePageOutline();
	DrawPageOutline(PCViewDC, true);

	RePasteAllGraphics(PCViewDC);

	if(is_symbol_editor) ClearOverideSnapToGrid();

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::ClipboardZoom(float zoom)
{
	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject *PCSchematicObject;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		PCSchematicObject->Zoom(zoom);
	}

}

void TCSchematicManager::UpdateSchematicObject()
{
	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject *PCSchematicObject;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		PCSchematicObject->UpdateSchematicObject();
	}
}

void TCSchematicManager::ShowPinNames(int show, int id)
{
	CDC CViewDC;

	if(!CViewDC.CreateCompatibleDC(NULL)) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject *PCSchematicObject;

	CString CRefDes;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_type)
		{
			CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
		}

		if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT) continue;
		if(PCSchematicObject->m_type == E_WIRE_COMPONENT) continue;
		if(PCSchematicObject->m_type)// 10th Oct 2001
		if(PCSchematicObject->m_type > E_WIRE_COMPONENT && PCSchematicObject->m_type < E_GROUND) continue;
		
		if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_CAPACITOR && id == E_COMPONENT_PIN_CURENT) continue;

		int count2 = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();
		int count3 = PCSchematicObject->CMPinListObject.GetSize();

		if(count3 != count2) continue;

		for(int q = 0; q < count2; q++)
		{
			if(!(id < PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData.GetSize())) continue;

			if(!(id < PCSchematicObject->CMPinListObject[q].CMLabelListObject.GetSize())) continue;

			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_RESISTOR && !q && id == E_COMPONENT_PIN_CURENT)continue;// only display one node current
			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_INDUCTOR && !q && id == E_COMPONENT_PIN_CURENT)continue;// only display one node current

//			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type >= E_PROPERTY_DC_VOLTAGE_SOURCE && PCSchematicObject->CMSchematicObjectData.component_property_view_type <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM)continue;

			PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[id].is_visable = !!show;
			PCSchematicObject->CMPinListObject[q].CMLabelListObject[id].m_visable = !!show;

			PCSchematicObject->SetPinLabel(&CViewDC, q, id, PCSchematicObject->GetPinLabel(q, id));
		}
	}

	DrawAll();
}

void TCSchematicManager::ClearPinCurrentsAndVoltages(void)
{
	CDC CViewDC;

	if(!CViewDC.CreateCompatibleDC(NULL)) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject *PCSchematicObject;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT) continue;
		if(PCSchematicObject->m_type == E_WIRE_COMPONENT) continue;
		if(PCSchematicObject->m_type)// 10th Oct 2001
		if(PCSchematicObject->m_type > E_WIRE_COMPONENT && PCSchematicObject->m_type < E_GROUND) continue;
		
		int count2 = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();
		int count3 = PCSchematicObject->CMPinListObject.GetSize();

		if(count3 != count2) continue;

		for(int q = 0; q < count2; q++)
		{
			if(!(E_COMPONENT_PIN_NET_NAME < PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData.GetSize())) continue;
			if(!(E_COMPONENT_PIN_NET_NAME < PCSchematicObject->CMPinListObject[q].CMLabelListObject.GetSize())) continue;

			PCSchematicObject->SetPinLabel(&CViewDC, q, E_COMPONENT_PIN_VOLTAGE, "?V");

			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_CAPACITOR) continue;
			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type >= E_PROPERTY_DC_VOLTAGE_SOURCE && PCSchematicObject->CMSchematicObjectData.component_property_view_type <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM)continue;

			PCSchematicObject->SetPinLabel(&CViewDC, q, E_COMPONENT_PIN_CURENT, "?A");
		}
	}

	DrawAll();
}

void TCSchematicManager::ShowNetNames(int show)
{
	ShowPinNames(show, E_COMPONENT_PIN_NET_NAME);
}
void TCSchematicManager::ShowDcVoltages(int show)
{
	ShowPinNames(show, E_COMPONENT_PIN_VOLTAGE);
}
void TCSchematicManager::ShowDcCurrents(int show)
{
	ShowPinNames(show, E_COMPONENT_PIN_CURENT);
}

void TCSchematicManager::DrawAll(void)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	UpdatePageOutline();// make sure sizes are upto date
	RepositionTitleBlock();

	EraseComponentOutline();

	// This is to update the origin as DrawAll gets called before the scroll bars!!
	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);
	CMSchematicManagerData.CViewPortOrigin = PCViewDC->GetViewportOrg();
	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CDC CMemDC;
	
	CMemDC.CreateCompatibleDC(PCViewDC);

	CBitmap CBitmapTemp;

	CRect CWindowRect;

	PCViewDC->GetClipBox(&CWindowRect); 

	int w = CWindowRect.Width();
	int h = CWindowRect.Height();

	if(!CBitmapTemp.CreateBitmap(w, h, global_screen_planes, global_screen_bitspixels,  NULL))
	{
		if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
		CMemDC.DeleteDC();

		return;
	}

	HGDIOBJ oldobject = CMemDC.SelectObject(CBitmapTemp);

	ClearScreen(&CMemDC);
	DrawGrid(&CMemDC);

	DrawPageOutline(&CMemDC, true);

	RePasteAllGraphicsFromMemory(&CMemDC);

	PCViewDC->BitBlt(0, 0, w, h, &CMemDC, 0, 0, SRCCOPY);

	CMemDC.SelectObject(oldobject);
	CBitmapTemp.DeleteObject();
	CMemDC.DeleteDC();

	repaste_required = true;

/*	if(PCMLastOutlinedComponent)
	{
		OutlineGraphics(CMLastOutlinedMousePosition);
	}*/

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

}

bool TCSchematicManager::RePasteAllGraphicsFromMemory(CDC *PCViewDC)
{
	if(!PCViewDC) return false;

	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	CPoint				LCLocation;

	CPoint COrigin;

	COrigin.y = -CMSchematicManagerData.PCView->GetScrollPos(SB_VERT);
	COrigin.x = -CMSchematicManagerData.PCView->GetScrollPos(SB_HORZ);

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		LCLocation = (*PCSchematicObjectPtr)->CMLocation;

		LCLocation += COrigin;

		(*PCSchematicObjectPtr)->RePaste(PCViewDC, LCLocation);

		PCSchematicObjectPtr++;
	}

	return true;
}

bool TCSchematicManager::PrintAllAsBitmap(CDC *PCDC)
{
	if(!PCDC) return false;
	if(!CMSchematicManagerData.CGraphicList.GetSize()) return false;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CDC CMemDC;

	CMemDC.CreateCompatibleDC(PCDC);

	TCSchematicManager CSchematicManager;

	CopyAll(&CSchematicManager, "");

	CSchematicManager.CMSchematicManagerData.PCView = CMSchematicManagerData.PCView;

//	CRect CPageSize = GCSuperSpiceGlobalData.CPrinterData.GetPrinterPageSize();

	int w = 1024;//CPageSize.Width();
	int h = 1024;//CPageSize.Height();

	CBitmap CBitMap;

	// create memory for dc
	if(!CBitMap.CreateBitmap(w, h, global_screen_planes, global_screen_bitspixels,  NULL))
	{
		if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

		return false;
	}

	HGDIOBJ oldobject = CMemDC.SelectObject(CBitMap);

	if(!oldobject) 
	{	
		CMemDC.DeleteDC();

		if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

		return false;
	}

	ClearScreen(&CMemDC);

	CSchematicManager.DrawPageOutline(&CMemDC, false);
		
//	float zoom = CMSchematicManagerData.zoom;

//	float printer_zoom = GCSuperSpiceGlobalData.CPrinterData.GetPrinterZoom();

	CSchematicManager.ClipboardResetSelectAll(&CMemDC);// need to unselect all components

//	CSchematicManager.Zoom(printer_zoom, (TE_GRAPHICS_MANAGER_SYSTEM_STATE)0);

	if(GCSuperSpiceGlobalData.CDrawData.is_grid_display_on) CSchematicManager.DrawGrid(&CMemDC);

	CPoint CMousePosition(0, 0);

	CSchematicManager.ClipboardPaste(&CMemDC, CMousePosition);

//	if(PCDC->IsPrinting())
	{
//		PrintBitmap(PCDC, CBitMap, 0, 0);
	}
//	else
	{
		PCDC->BitBlt(0, 0, w, h, &CMemDC, 0, 0, SRCCOPY);
	}
	
	CMemDC.SelectObject(oldobject);

	CMemDC.DeleteDC();

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return true;
}

bool TCSchematicManager::PrintAll(CDC *PCDC)
{
	if(!PCDC) return false;

//	return PrintAllAsBitmap(PCDC);

	TCSchematicObject	*PCSchematicObject;
	CPoint				LCLocation;

	float zoom = CMSchematicManagerData.zoom;

	float printer_zoom = GCSuperSpiceGlobalData.CPrinterData.GetPrinterZoom();

	Zoom(printer_zoom, (TE_GRAPHICS_MANAGER_SYSTEM_STATE)0);

	DrawPageOutline(PCDC, false);

//	DrawGrid(PCDC); to fix

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject) continue;

		if(GCSuperSpiceGlobalData.CDrawData.vector_printing)
			PCSchematicObject->VectorPrint(PCDC);
		else
			PCSchematicObject->BitmapPrint(PCDC);
	}

	Zoom(zoom, (TE_GRAPHICS_MANAGER_SYSTEM_STATE)0);

	return true;
}

bool TCSchematicManager::GetComponentsExtent(CRect &CRectangleExtent)
{	
	// used for clipboard, which has reset components to display in normal colours
	
	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return false;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(0);

	CRectangleExtent = PCSchematicObject->GetComponentExtent();

	CRect CNewRectangleExtent;
	CRect CTestRectangleExtent;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject) continue;

		CTestRectangleExtent = CRectangleExtent;

		CNewRectangleExtent = PCSchematicObject->GetComponentExtent();

		CRectangleExtent.UnionRect(&CNewRectangleExtent, &CTestRectangleExtent);
	}

	CRectangleExtent.top	-= 1;
	CRectangleExtent.left	-= 1;
	CRectangleExtent.right	+= 1;
	CRectangleExtent.bottom += 1;
	
	
	return true;
}

void TCSchematicManager::ClearScreen(CDC *PCViewDC)
{
	if(!PCViewDC) return;

	CBrush CBackgroundBrush(GCSuperSpiceGlobalData.CColorData.background);
 
	CBrush* pOldBrush = PCViewDC->SelectObject(&CBackgroundBrush);
 
	CRect CWindowRect;

	PCViewDC->GetClipBox(&CWindowRect);    

	// Note all devices support PatBlt, well tough luck !!

	PCViewDC->PatBlt(CWindowRect.left, CWindowRect.top, CWindowRect.Width(), 
					 CWindowRect.Height(), PATCOPY);
	
	PCViewDC->SelectObject(pOldBrush);

	CBackgroundBrush.DeleteObject();
}

void TCSchematicManager::DrawGrid(CDC *PCViewDC)
{
	if(!PCViewDC) return;
	if(is_symbol_viewer) return;
	if(!GCSuperSpiceGlobalData.CDrawData.is_grid_display_on) return;

	int grid_size = GetGridSize();

	if(grid_size < 1) return;

	int xn_counter = 0;
	int yn_counter = 0;

	grid_size = (int)(grid_size * CMSchematicManagerData.zoom);

 // prevent small grids by auto expanding grid, temp code, to change later

	if(!is_symbol_editor) 
	{
		if(grid_size < 4) return;
		
	}
	else if(grid_size < 2) return;

	CRect CWindowRect;

	PCViewDC->GetClipBox(&CWindowRect);

	CPoint CViewSize;

	CPoint COrigin;

	COrigin.y = CMSchematicManagerData.PCView->GetScrollPos(SB_VERT);
	COrigin.x = CMSchematicManagerData.PCView->GetScrollPos(SB_HORZ);
	
	register int x_count = CWindowRect.Width() / grid_size + 1;
	register int y_count = CWindowRect.Height() / grid_size + 1;

	int	ix, iy;

	ix =  COrigin.x - grid_size * (COrigin.x / grid_size);
	iy =  COrigin.y - grid_size * (COrigin.y / grid_size);

	register int next_x = grid_size - ix;
	register int next_y = grid_size - iy;

	int p, q;
	
	HDC h_dc = PCViewDC->m_hDC;

	COLORREF colour = GCSuperSpiceGlobalData.CColorData.grid;
	
	for(p = 0; p < x_count; p++)
	{
		next_y		= grid_size - iy;
		yn_counter = 0;

		for(q = 0; q < y_count; q++)
		{	
			SetPixel(h_dc, next_x, next_y, colour);

			next_y += grid_size;
		}

		xn_counter++;
		next_x += grid_size;
	}

	if(is_symbol_editor) DrawOverlayGrid(PCViewDC);
}

void TCSchematicManager::DrawOverlayGrid(CDC *PCViewDC)
{
	// quick and nasty copy

	if(!PCViewDC) return;

	if(!GCSuperSpiceGlobalData.CDrawData.is_grid_display_on) return;

	int grid_size = (int)(GCSuperSpiceGlobalData.CDrawData.grid_size * CMSchematicManagerData.zoom);
	
	if(!GCSuperSpiceGlobalData.CDrawData.symbol_editor_grid_size)
		GCSuperSpiceGlobalData.CDrawData.symbol_editor_grid_size = 1;


 // prevent small grids by auto expanding grid, temp code, to change later

	if(grid_size < 2) return;
		
	CRect CWindowRect;

	PCViewDC->GetClipBox(&CWindowRect);

	CPoint CViewSize;

	CPoint COrigin;

	COrigin.y = CMSchematicManagerData.PCView->GetScrollPos(SB_VERT);
	COrigin.x = CMSchematicManagerData.PCView->GetScrollPos(SB_HORZ);
	
	register int x_count = CWindowRect.Width() / grid_size + 1;
	register int y_count = CWindowRect.Height() / grid_size + 1;

	int	ix, iy;

	ix =  COrigin.x - grid_size * (COrigin.x / grid_size);
	iy =  COrigin.y - grid_size * (COrigin.y / grid_size);

	register int next_x = grid_size - ix;
	register int next_y = grid_size - iy;

	int p, q;
	
	HDC h_dc = PCViewDC->m_hDC;

	COLORREF colour = RGB(255, 0, 255);// GCSuperSpiceGlobalData.CColorData.grid;
	
	for(p = 0; p < x_count; p++)
	{
		next_y = grid_size - iy;

		for(q = 0; q < y_count; q++)
		{
			SetPixel(h_dc, next_x, next_y, colour);

			SetPixel(h_dc, next_x+1, next_y, colour);
			SetPixel(h_dc, next_x-1, next_y, colour);
			SetPixel(h_dc, next_x, next_y+1, colour);
			SetPixel(h_dc, next_x, next_y-1, colour);

			next_y += grid_size;
		}

		next_x += grid_size;
	}
}

void TCSchematicManager::DrawGrid(CDC *PCViewDC, CPoint CStart, int x_size, int width, int y_size, int height, COLORREF color)
{
	if(!PCViewDC) return;

	// for waveform graph

	x_size = (int)(x_size * CMSchematicManagerData.zoom);
	y_size = (int)(y_size * CMSchematicManagerData.zoom);

	CPoint COrigin;

	COrigin.y = CMSchematicManagerData.PCView->GetScrollPos(SB_VERT);
	COrigin.x = CMSchematicManagerData.PCView->GetScrollPos(SB_HORZ);

// MultyplyCPoint(&COrigin, CMSchematicManagerData.zoom);

	register int x_count = width / x_size + 1;
	register int y_count = height / y_size + 1;

	int	ix, iy;

//	ix =  COrigin.x - x_size * (COrigin.x / x_size) - CStart.x;
//	iy =  COrigin.y - y_size * (COrigin.y / y_size) - CStart.y;

	ix =  CStart.x - COrigin.x;
	iy =  CStart.y - COrigin.y;

	register int next_x = ix;
	register int next_y = iy;

	int p, q;
	
	HDC h_dc = PCViewDC->m_hDC;
	
	for(p = 0; p < x_count; p++)
	{
		next_y = iy;

		for(q = 0; q < y_count; q++)
		{
			SetPixel(h_dc, next_x, next_y, color);

			next_y += y_size;
		}

		next_x += x_size;
	}
}

void TCSchematicManager::UpdatePageOutline(void)
{
	if(is_symbol_viewer) return;
	float zoom = CMSchematicManagerData.zoom;

	int grid_size = GetGridSize();

	if(grid_size < 1) return;

	CRect CPageArea = GCSuperSpiceGlobalData.CPrinterData.CPrinterPageOutline;

	int scale = grid_size * 10;
	int width = (CPageArea.Width()/scale) * scale;
	int height = (CPageArea.Height()/scale) * scale;


	CPageArea.left = (long)(grid_size * zoom);
	CPageArea.top = (long)(grid_size * zoom);

	CPageArea.bottom = (long)(CPageArea.top + height * zoom);
	CPageArea.right = (long)(CPageArea.left + width * zoom);

	CMSchematicManagerData.CPageArea = CPageArea;

	CInerPageArea = CPageArea;

	int border_width = grid_size;//may make variable in TCSuperSpiceDrawData

	if(border_width < 1) return;
 
	border_width = (int)(border_width * CMSchematicManagerData.zoom);

	CInerPageArea.left	+= border_width;
	CInerPageArea.right -= border_width;
	CInerPageArea.top	+= border_width;
	CInerPageArea.bottom-= border_width;
}

void TCSchematicManager::DrawPageOutline(CDC *PCViewDC, bool offset)
{
	if(is_symbol_viewer) return;

	if(!PCViewDC) return;

	if(is_symbol_editor)  return;

	if(!GCSuperSpiceGlobalData.CDrawData.draw_schematic_page_border) return;

	CRect CPageArea = CMSchematicManagerData.CPageArea;

	CPoint CTemp = CMSchematicManagerData.CViewPortOrigin;

	if(offset) CPageArea += CTemp;

	MultyplyCPoint(&CTemp, CMSchematicManagerData.zoom);

	PCViewDC->MoveTo(CPageArea.left, CPageArea.top);
	PCViewDC->LineTo(CPageArea.left, CPageArea.bottom);
	PCViewDC->LineTo(CPageArea.right, CPageArea.bottom);
	PCViewDC->LineTo(CPageArea.right, CPageArea.top);
	PCViewDC->LineTo(CPageArea.left, CPageArea.top);

	int		border_width;

	CInerPageArea = CPageArea;

	int grid_size = GetGridSize();

	border_width = grid_size;//may make variable in TCSuperSpiceDrawData

	if(border_width < 1) return;
 
	border_width = (int)(border_width * CMSchematicManagerData.zoom);

	CInerPageArea.left	+= border_width;
	CInerPageArea.right -= border_width;
	CInerPageArea.top	+= border_width;
	CInerPageArea.bottom-= border_width;

	PCViewDC->MoveTo(CInerPageArea.left, CInerPageArea.top);
	PCViewDC->LineTo(CInerPageArea.left, CInerPageArea.bottom);
	PCViewDC->LineTo(CInerPageArea.right, CInerPageArea.bottom);
	PCViewDC->LineTo(CInerPageArea.right, CInerPageArea.top);
	PCViewDC->LineTo(CInerPageArea.left, CInerPageArea.top);

	int x_position, y_position, step;
	int count;

	step = CPageArea.Width()/10;

	if(!step) 
	{
		ASSERT(0);

		step = 1;
	}
	count = 10;

	x_position = CPageArea.left + step;
	y_position = CPageArea.top;

//   Create font and select it

	CFont	CInitFont;
	LOGFONT s_logfont;
	int font_size = (int) (200 * grid_size/32);// normalized to normal grid size

	font_size = (int)(font_size * CMSchematicManagerData.zoom);

	CInitFont.CreatePointFont(font_size, "Times New Roman", NULL);
	CInitFont.GetLogFont(&s_logfont);

	CFont *COldFont = PCViewDC->SelectObject(&CInitFont);

	if(!COldFont) ASSERT(0);

	CSize CTextSpacing = GetTextSize("W", s_logfont, 1);// largest letter

//
	int p;

	for(p = 0; p < count; p++) //top vertical bars and Letters A B C...
	{
		PCViewDC->MoveTo(x_position, y_position);

		PCViewDC->LineTo(x_position, y_position + border_width);

		if(p < 26) PCViewDC->TextOut(x_position - step/2 - CTextSpacing.cx/2 + 1, y_position + 1 /*+ CTextSpacing.cy/2*/, CLetterArray[p]);
		
		x_position += step;
	}

	x_position = CPageArea.left + step;
	y_position = CPageArea.bottom;

	for(p = 0; p < count; p++) //bottom vertical bars and Letters A B C...
	{
		PCViewDC->MoveTo(x_position, y_position);

		PCViewDC->LineTo(x_position, y_position - border_width);

		if(p < 26) PCViewDC->TextOut(x_position - step/2 - CTextSpacing.cx/2 + 1, y_position + 1 - border_width, CLetterArray[p]);

		x_position += step;
	}

	count = CPageArea.Height()/step;

	x_position = CPageArea.left;
	y_position = CPageArea.top + step;

	CString CNumber;

	int double_offset;

	for(p = 0; p < count; p++) //left horizonal bars and Numbers 1 2 3...
	{
		PCViewDC->MoveTo(x_position, y_position);

		PCViewDC->LineTo(x_position + border_width, y_position);

		CNumber.Format("%d", p + 1);

		if(p > 8) double_offset = CTextSpacing.cx/2 - 2;
		else double_offset = 0;

		PCViewDC->TextOut(x_position + CTextSpacing.cx/2 - double_offset, y_position + 1 - step/2, CNumber);

		y_position += step;
	}

	x_position = CPageArea.right;
	y_position = CPageArea.top + step;

	for(p = 0; p < count; p++) //right horizonal bars and Numbers 1 2 3...
	{
		PCViewDC->MoveTo(x_position, y_position);

		PCViewDC->LineTo(x_position - border_width, y_position);

		CNumber.Format("%d", p + 1);

		if(p > 8) double_offset = CTextSpacing.cx/2 - 2;
		else double_offset = 0;

		PCViewDC->TextOut(x_position + CTextSpacing.cx/2 - border_width - double_offset, y_position + 1 - step/2, CNumber);

		y_position += step;
	}

	PCViewDC->SelectObject(COldFont);

	CInitFont.DeleteObject();
}

bool TCSchematicManager::AddGraphicToList(TCSchematicObject*PGraphicsObject)
{
	
	CMSchematicManagerData.CGraphicList.Add(PGraphicsObject);
		
	return true;
}

bool TCSchematicManager::RemoveGraphicFromList(int index)
{
	
	CMSchematicManagerData.CGraphicList.RemoveAt(index); 	

	return true;
}

bool TCSchematicManager::DestroyGraphic(CPoint CLocation, bool fine)
{
	
	int index = FindGraphic(CLocation, fine);

	if(index < 0) return false;

	TCSchematicObject* PCSchematicObject;
	
	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(index); 
	
	RemoveGraphicFromList(index);

	if(PCMLastOutlinedComponent == PCSchematicObject) PCMLastOutlinedComponent = NULL;

	if(PCSchematicObject) delete PCSchematicObject;

	return true;
}


void TCSchematicManager::SetViewPortOrigin(CPoint CViewPortOrigin)
{
	CMSchematicManagerData.CViewPortOrigin = CViewPortOrigin;

	UpdatePageOutline();
}

CPoint TCSchematicManager::GetViewPortOrigin(void)
{
	return CMSchematicManagerData.CViewPortOrigin;
}

void TCSchematicManager::SetScrollBarPosition(CPoint CScrollBarPosition)
{
	CMSchematicManagerData.CScrollBarPosition = CScrollBarPosition;
}

CPoint TCSchematicManager::GetScrollBarPosition(void)
{
	return CMSchematicManagerData.CScrollBarPosition;
}

int TCSchematicManager::FindGraphic(CPoint CLocation, bool fine)
{
	// To do cycle through to next

	if(!CMSchematicManagerData.PCView) return false;

	int q = -1;

	TCSchematicObject		*PCSchematicObject;
	TCSchematicComponentInfo CSchematicComponentInfo;
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;

	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	CLocation -= CMSchematicManagerData.CViewPortOrigin;

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(!PCSchematicObject) 
		{
			PCSchematicObjectPtr++;

			continue;		
		}
		
		if(PCSchematicObject->IsThere(&CSchematicComponentInfo, CLocation, fine)) q = p;
		
		PCSchematicObjectPtr++;
	}

	return q;
}

TCSchematicComponentInfo TCSchematicManager::InspectSchematicObject(CPoint CLocation, bool fine, bool ignor_wire, bool pin_only)
{
	TCSchematicComponentInfo   CSchematicComponentInfo;
	TCSchematicComponentInfo   CSchematicComponentInfoReturned;

	CSchematicComponentInfo.id = -1;
	CSchematicComponentInfoReturned.id = -1;

	if(!CMSchematicManagerData.PCView) return CSchematicComponentInfo;

	int q = -1;

	TCSchematicObject	*PCSchematicObject;
	
	int number = CMSchematicManagerData.CGraphicList.GetSize();
	int result;

	CLocation -= CMSchematicManagerData.CViewPortOrigin;

	for(int p = 0; p < number; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject) continue;		
		
		result = PCSchematicObject->IsThere(&CSchematicComponentInfo, CLocation, fine);

		if(ignor_wire)
			if(PCSchematicObject->m_type == E_WIRE_COMPONENT)
				if(CSchematicComponentInfo.type == E_SCHEMATIC_PIN) continue;

		if(result)
		{
			// only look for pins
			if(pin_only) if(CSchematicComponentInfo.type != E_SCHEMATIC_PIN) continue;

			q = p;	
			CSchematicComponentInfoReturned = CSchematicComponentInfo;
		}
	}

	CSchematicComponentInfoReturned.id	= q;

	return CSchematicComponentInfoReturned;
}


bool TCSchematicManager::IsRecursivePaste(TCSchematicObject *PCSchematicObject, CString CExcludeComponent)
{
	CString CText = PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName;

	if(CExcludeComponent == "")return false;
	CText.MakeUpper();
	CExcludeComponent.MakeUpper();

	return CText == CExcludeComponent;
}

bool TCSchematicManager::CopyAll(TCSchematicManager	*PCGraphicsManager, CString CExcludeComponent)
{
	TCSchematicObject		*PCSchematicObject;
	TCSchematicObject		*PCSchematicObjectCopy;

	if(!PCGraphicsManager) return false;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(IsRecursivePaste(PCSchematicObject, CExcludeComponent)) 
		{
			CGlobalStatusMessage = "Cannot add a component to itself";

			continue;
		}

		PCSchematicObjectCopy = new TCSchematicObject;

		if(!PCSchematicObjectCopy) 
		{
			for(int q = 0; q < p; q++)
			{
				delete PCSchematicObjectCopy;
			}

			return false;
		}

		*PCSchematicObjectCopy = *PCSchematicObject;

		PCGraphicsManager->AddGraphicToList(PCSchematicObjectCopy);		
	}

	return true;
}

void TCSchematicManager::DeleteSchematicObjects(void)
{
	TCSchematicObject*	PCSchematicObject;

	int number = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < number; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
			
		if(PCMLastOutlinedComponent == PCSchematicObject) PCMLastOutlinedComponent = NULL;

		if(PCSchematicObject) delete PCSchematicObject;
	}
}
void TCSchematicManager::operator = (TCSchematicManager &CSchematicManager)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CMSchematicManagerData = CSchematicManager.CMSchematicManagerData;
	PCWaveformDataRuns = CSchematicManager.PCWaveformDataRuns;

	int count = CSchematicManager.CMSchematicManagerData.CGraphicList.GetSize();

	DeleteSchematicObjects();

	CMSchematicManagerData.CGraphicList.SetSize(0);
	CMSchematicManagerData.CGraphicList.SetSize(count, E_SCHEMATIC_OBJECT_ALLOC_SIZE);

	TCSchematicObject	*PCSchematicObject;
	TCSchematicObject	*PCSchematicObjectCopy;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = (TCSchematicObject*) CSchematicManager.CMSchematicManagerData.CGraphicList.GetAt(p);

		PCSchematicObjectCopy = new TCSchematicObject; 

		if(!PCSchematicObjectCopy) 
		{
			for(int q = 0; q < p; q++)
			{
				delete PCSchematicObjectCopy;
			}

			CMSchematicManagerData.CGraphicList.SetSize(0, E_SCHEMATIC_OBJECT_ALLOC_SIZE);

			if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

			return;
		}

		PCSchematicObjectCopy->Create(PCViewDC, PCSchematicObject->GetSchematicObjectData()
			                         , CMSchematicManagerData.zoom);

		*PCSchematicObjectCopy = *PCSchematicObject;

		CMSchematicManagerData.CGraphicList[p] = PCSchematicObjectCopy;		
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
	// Netlist to do also
}
void TCSchematicManager::ResetGraphicList(void)
{
	TCSchematicObject*	PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{	
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
			
		if(PCMLastOutlinedComponent == PCSchematicObject) PCMLastOutlinedComponent = NULL;

		if(PCSchematicObject) delete PCSchematicObject;
	}

	CMSchematicManagerData.CGraphicList.SetSize(0, E_SCHEMATIC_OBJECT_ALLOC_SIZE);
}

bool TCSchematicManager::CopySelected(TCSchematicManager *PCGraphicsManager)
{
	TCSchematicObject		*PCSchematicObject;
	TCSchematicObject		*PCSchematicObjectCopy;

	if(!PCGraphicsManager) return false;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(PCMLastOutlinedComponent)
	{
		PCSchematicObjectCopy = new TCSchematicObject;

		if(!PCSchematicObjectCopy) return false;

		*PCSchematicObjectCopy = *PCMLastOutlinedComponent;

		PCSchematicObjectCopy->SetSelect();
		EraseComponentOutline();

		PCGraphicsManager->AddGraphicToList(PCSchematicObjectCopy);
	}
	else
	{
		for(int p = 0; p < count; p++)
		{
			PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

			if(!PCSchematicObject->m_selected) continue;
		
			PCSchematicObjectCopy = new TCSchematicObject;

			if(!PCSchematicObjectCopy) 
			{
				for(int q = 0; q < p; q++)
				{
					delete PCSchematicObjectCopy;

				}

				return false;
			}
		
			*PCSchematicObjectCopy = *PCSchematicObject;

			PCGraphicsManager->AddGraphicToList(PCSchematicObjectCopy);		
		}
	}

	return true;
}

bool TCSchematicManager::Paste(TCSchematicManager *PCGraphicsManager, CPoint CMousePosition, CString CExcludeComponent)
{
	if(!PCGraphicsManager->GetView()) return false;

	if(!GraphicsSelected())return false;

	PCGraphicsManager->ResetSelectAll(true);

	CMousePosition -= PCGraphicsManager->GetViewPortOrigin();

	CopyAll(PCGraphicsManager, CExcludeComponent);

	PCGraphicsManager->PasteSelected(CMousePosition);

	return true;
}

CArray <TCSchematicObject *, TCSchematicObject *> &TCSchematicManager::GetSchematicObjectSelectedList(void)
{
	return CPCSchematicObjectSelectedList;
}
CArray <int, int> & TCSchematicManager::GetSchematicObjectIdSelectedList(void)
{
	return CPCSchematicObjectIdSelectedList;
}
bool TCSchematicManager::GraphicsSelected(void)
{
	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSchematicObject *PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_selected || PCSchematicObject->m_highlighted) return true;
	}

	return false;
}


bool TCSchematicManager::PasteSelected(CPoint CMousePosition)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	TCSchematicObject	*PCSchematicObject;
	CPoint			LCLocation;
	int				f_first = true;
	CPoint			COffset(0, 0);
	CPoint			CLocation;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return false;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);
	
	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
 
		if(!PCSchematicObject->m_selected) continue;

		if(f_first)
		{
			f_first = false;

			PCSchematicObject->GetLocation(&COffset);

			COffset = (CPoint) (COffset + PCSchematicObject->CMCenterPoint);
		} 
  
		PCSchematicObject->GetLocation(&CLocation);

		CLocation = (CPoint) (CLocation - COffset);

		PCSchematicObject->SetPageId(CMSchematicManagerData.page_id);

		PCSchematicObject->Paste(PCViewDC, (CPoint)(CMousePosition + CLocation), !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	InitaliseAllGraphicLocations(CMousePosition);

	return true;  
}

void TCSchematicManager::ClipboardPaste(CDC *PCMemDC, CPoint CMousePosition)
{
	if(!PCMemDC) return;

	TCSchematicObject	*PCSchematicObject;
	CPoint			LCLocation;
	CPoint			CLocation;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return;

	for(int p = 0; p < count; p++)// paste to  0, 0 of top left most component
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
  
		PCSchematicObject->GetLocation(&CLocation);

		CLocation = (CPoint) (CLocation - CMousePosition);

		PCSchematicObject->RePaste(PCMemDC, CLocation);
	}
}

void TCSchematicManager::Mirror(void)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CPoint CLocation;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);
	
	if(PCMLastOutlinedComponent)
	{
		PCSchematicObject = PCMLastOutlinedComponent;
		EraseComponentOutline();
		PCSchematicObject->GetLocation(&CLocation);
		PCSchematicObject->Clear(PCViewDC);
		PCSchematicObject->Mirror();
		PCSchematicObject->Paste(PCViewDC, CLocation);
		OutlineGraphics(CMLastOutlinedMousePosition);
	}
	else
	{
		for(int p = 0; p < count; p++)
		{
			PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
		
			if(!PCSchematicObject->m_selected) continue;

			PCSchematicObject->Clear(PCViewDC);
			PCSchematicObject->Mirror();
			PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		}
	}

	UpdateSchematicObjectDataBase();

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::Rotate(void)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CPoint				CLocation;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);
	
	if(PCMLastOutlinedComponent)
	{
		PCSchematicObject = PCMLastOutlinedComponent; 
		EraseComponentOutline();
		PCSchematicObject->Clear(PCViewDC);
		PCSchematicObject->Rotate();
		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		OutlineGraphics(CMLastOutlinedMousePosition);
	}
	else
	{
		for(int p = 0; p < count; p++)
		{
			PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
	
			if(!PCSchematicObject->m_selected) continue;	
	
			PCSchematicObject->Clear(PCViewDC);  // Selected graphics are already re listed
			PCSchematicObject->Rotate();
			PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		}
	}
	UpdateSchematicObjectDataBase();

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
void TCSchematicManager::Flip(void)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CPoint				CLocation;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);
	
	if(PCMLastOutlinedComponent)
	{
		PCSchematicObject = PCMLastOutlinedComponent;
		EraseComponentOutline();
		PCSchematicObject->Clear(PCViewDC);
		PCSchematicObject->Flip();
		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		OutlineGraphics(CMLastOutlinedMousePosition);
	}
	else
	{
		for(int p = 0; p < count; p++)
		{
			PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
		
			if(!PCSchematicObject->m_selected) continue;

			PCSchematicObject->Clear(PCViewDC);  // Selected graphics are already re listed
			PCSchematicObject->Flip();
			PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		}
	}
	UpdateSchematicObjectDataBase();
	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
CPoint TCSchematicManager::GetLocation(int id)
{
	TCSchematicObject	*PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	return PCSchematicObject->CMLocation; 
}

bool TCSchematicManager::ClearSelected(bool hyde_labels)
{
	if(!CMSchematicManagerData.PCView) return false;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	CDC *PCViewDC;

	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	for(int p = count - 1; p > -1; p--)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_selected) continue;
	
		PCSchematicObject->Clear(PCViewDC, hyde_labels);	
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return true;
}

void TCSchematicManager::DeleteLastSelectedGraphic(CArray <TCSchematicObject *, TCSchematicObject *> *PCGraphicDeleteList, bool enable_undelete)
{
	if(enable_undelete) DeleteDeleteList();

	int q = FindGraphicId(PCMLastOutlinedComponent);

	if(q < 0) return;

	CMSchematicManagerData.CGraphicList.RemoveAt(q);

	if(enable_undelete)
	{
		PCGraphicDeleteList->SetSize(1);

		(*PCGraphicDeleteList)[0] = PCMLastOutlinedComponent;
	}
	else delete PCMLastOutlinedComponent;

	PCMLastOutlinedComponent = NULL;
}

void TCSchematicManager::DeleteSelectedGraphics(bool enable_undelete)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	// if a component is outlined, it will deleted, not selected ones
	// excecpt for the waveform graph
	// if none outlined, selected ones will be deleted

	CArray <TCSchematicObject *, TCSchematicObject *> *PCGraphicDeleteList;
	CArray <TCSchematicObject *, TCSchematicObject *> CGraphicDeleteList;

	if(enable_undelete) PCGraphicDeleteList = &CMGraphicDeleteList;
	else PCGraphicDeleteList = &CGraphicDeleteList;

	if(PCMLastOutlinedComponent)
	{
		int type = PCMLastOutlinedComponent->m_type;

		if(PCMLastOutlinedComponent->m_type == E_TEST_MARKER)
		{
			DeleteLastSelectedGraphic(PCGraphicDeleteList, enable_undelete);

			DrawAll();

			return;
		}
		else if(PCMLastOutlinedComponent->m_type == E_WAVEFORM_COMPONENT)
		{
			CPoint COffsetPosition = CMLastOutlinedMousePosition - CMSchematicManagerData.CViewPortOrigin;

			if(PCMLastOutlinedComponent->m_selected)
			{
				DeleteLastSelectedGraphic(PCGraphicDeleteList, enable_undelete);

				DrawAll();
			}
			else if(PCMLastOutlinedComponent->GetWaveformData(CCursorData, COffsetPosition)) 
			{
				RemoveWaveform(PCMLastOutlinedComponent, CCursorData);

				DrawAll();

				return;
			}
		}
		else
		{
			DeleteLastSelectedGraphic(PCGraphicDeleteList, enable_undelete);

			if(type == E_WIRE_COMPONENT)
			{
				JoinUpAllWires();

				SplitUpAllWires(); 
			}

			DrawAll();
		}

		m_current_wire_being_drawn = -1;

		PCMCurrentWireBeingDrawnObject = NULL;

		return;
	}

	if(enable_undelete) DeleteDeleteList();

	TCSchematicObject		*PCSchematicObject;

	CArray <TCSchematicObject *, TCSchematicObject *> CGraphicNoDeleteList;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCGraphicDeleteList->SetSize(count);
	CGraphicNoDeleteList.SetSize(count);

	int add_counter = 0;
	int non_delete_counter = 0;

	bool flag_wire = false;

	AfxGetApp()->BeginWaitCursor();

	int p;

	for(p = count - 1; p > -1; p--)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_selected) 
		{
			CGraphicNoDeleteList[non_delete_counter++] = PCSchematicObject;

			continue;
		}

		if(PCSchematicObject->m_type == E_TEST_MARKER) RemoveTestPointWaveform(PCSchematicObject);

		(*PCGraphicDeleteList)[add_counter++] = PCSchematicObject;
	}

	PCGraphicDeleteList->SetSize(add_counter);
	CGraphicNoDeleteList.SetSize(non_delete_counter);

	if(add_counter + non_delete_counter != count) ASSERT(0);

	TCSchematicObject	**PCSchematicObjectPtr;
	
	PCSchematicObjectPtr = PCGraphicDeleteList->GetData();

	for(p = 0; p < add_counter; p++) // now delete them all
	{
		PCSchematicObject = *PCSchematicObjectPtr++;

		if(PCSchematicObject->m_type == E_WIRE_COMPONENT) flag_wire = true;

		if(is_symbol_editor) PutBackPinNumber(PCSchematicObject);

		if(!enable_undelete) delete PCSchematicObject;		
	}

	CMSchematicManagerData.CGraphicList.SetSize(non_delete_counter);
	
	for(p = 0; p < non_delete_counter; p++) CMSchematicManagerData.CGraphicList[p] = CGraphicNoDeleteList[p];

	if(flag_wire)
	{
		JoinUpAllWires();
		SplitUpAllWires(); 

		m_current_wire_being_drawn = -1;

		PCMCurrentWireBeingDrawnObject = NULL;
	}

	DrawAll();

	AfxGetApp()->EndWaitCursor();
}

void TCSchematicManager::DeleteDeleteList(void)
{
	int delete_count = CMGraphicDeleteList.GetSize();

	for(int p = 0; p < delete_count; p++)
	{
		delete CMGraphicDeleteList[p];
	}

	CMGraphicDeleteList.SetSize(0);
}

void TCSchematicManager::Undelete(void)
{
	int delete_count = CMGraphicDeleteList.GetSize();

	if(!delete_count) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CMSchematicManagerData.CGraphicList.SetSize(count + delete_count);

	for(int p = 0; p < delete_count; p++)
	{
		CMSchematicManagerData.CGraphicList[count + p] = CMGraphicDeleteList[p];
	}

	CMGraphicDeleteList.SetSize(0); //dont want 2 copies!

	DrawAll();
}

void TCSchematicManager::RemoveTestPointWaveform(TCSchematicObject *PCSchematicObject)
{
	CTestPointData.COld		= PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
	CTestPointData.old_type = PCSchematicObject->CMSchematicObjectData.version;
	CTestPointData.CNew     = "";
	CTestPointData.new_type = -1;
	CTestPointData.update_graph_views = true;// used to update graph windows
	CTestPointData.version = PCSchematicObject->CMSchematicObjectData.version;

	ChangeWaveform(CTestPointData);
}

void TCSchematicManager::PutBackPinNumber(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;

	int type = PCSchematicObject->m_type;

	if(type != E_SYMBOL_POINTING_UP_PIN_COMPONENT && type != E_SYMBOL_POINTING_DOWN_PIN_COMPONENT && 
	   type != E_SYMBOL_POINTING_LEFT_PIN_COMPONENT&& type != E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT) return;

	int pin_number = 0;

	// get number to do

	CString CPinNumber = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NUMBER);

	pin_number = (int) MKSStringToFloat(CPinNumber);

	pin_number--;

	CPinNumberStack.Push(pin_number);
}

void TCSchematicManager::GetandSetNewPinData(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;

	int type = PCSchematicObject->m_type;

	if(type != E_SYMBOL_POINTING_UP_PIN_COMPONENT && type != E_SYMBOL_POINTING_DOWN_PIN_COMPONENT && 
	   type != E_SYMBOL_POINTING_LEFT_PIN_COMPONENT&& type != E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT) return;

	int pin_number = CPinNumberStack.Pop();

	CString CPinNumber = FloatToMKSString((int) pin_number);

	PCSchematicObject->CMPinListObject[0].CMLabelListObject[E_COMPONENT_PIN_NUMBER].m_visable = false;

	PCSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NET_NAME, CPinNumber);

	CPinNumber = FloatToMKSString((int) (pin_number + 1));

	PCSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NUMBER, CPinNumber);

	CPinNumber = "Name" + CPinNumber;

	PCSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NAME, CPinNumber);
}


void TCSchematicManager::RemoveWaveform(TCSchematicObject *PCSchematicObject, TCFloatingCursorData &CFloatingCursorData)
{
	if(!PCMLastOutlinedComponent) return;

	TCTestPointData CTestPointData;

	if(!CFloatingCursorData.PCSignalY) return;//dublication of effort but who cares

	TCSignal &CYSignal = *CFloatingCursorData.PCSignalY;

	CTestPointData.COld = CYSignal.CName;// forces removel of old
	CTestPointData.CNew = "";
	CTestPointData.new_type = -1;
	CTestPointData.update_graph_views = true;
	CTestPointData.version = -1;

	if(CFloatingCursorData.signal_type < TE_SIGNAL_DISPLAY_PHASE_DEG) CTestPointData.old_type = E_TESTPOINT_VMAG;
	else CTestPointData.old_type = E_TESTPOINT_VPHDEGS;// dont care actual type

	if(!PCSchematicObject->ChangeWaveform(CTestPointData)) return;

	PCSchematicObject->Paste(&GlobalCDCTemp, PCSchematicObject->CMLocation);
}

int TCSchematicManager::FindGraphicId(TCSchematicObject *PCSchematicObject)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	register int count;

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	count = CMSchematicManagerData.CGraphicList.GetSize();

	for(p = 0; p < count; p++)
	{
		if(PCSchematicObject == *PCSchematicObjectPtr++) 
		{
			return p;
		}

	//	PCSchematicObjectPtr++;
	}

	return -1;
}


bool TCSchematicManager::PasteGraphic(int id, CPoint CLocation, bool hyde_labels)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	CDC					*PCViewDC;
	TCSchematicObject	*PCSchematicObject;
	CPoint				LCLocation;
	
	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	LCLocation = (CPoint)(CLocation - PCSchematicObject->CMCenterPoint);
	
	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObject->Paste(PCViewDC, LCLocation, hyde_labels);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	InitaliseGraphicLocation(id, CLocation);

	return true;
}

//not quite just is pin there!!
TCSchematicObject *TCSchematicManager::IsPinThere(TCSchematicObject *PCSchematicObjectSource, CPoint &CMousePosition)
{
	TCSchematicComponentInfo   CSchematicComponentInfo;

	TCSchematicObject	*PCSchematicObject;
	
	int count = CMSchematicManagerData.CGraphicList.GetSize();
	int result;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
		
		result = PCSchematicObject->IsThere(&CSchematicComponentInfo, CMousePosition, false);

		if(!result) continue;

		if(PCSchematicObjectSource == PCSchematicObject) continue;

		// finish wires that end on other wires
		if(PCSchematicObject->m_type == E_WIRE_COMPONENT) return PCSchematicObject;

		if(CSchematicComponentInfo.type != E_SCHEMATIC_PIN) continue;

		return PCSchematicObject;
	}

	return NULL;
}

bool TCSchematicManager::RePasteAllGraphics(CDC *PCViewDC)
{
	if(!PCViewDC) return false;

	TCSchematicObject	*PCSchematicObject;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);	

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
	}

	if(PCCursor1) PCCursor1->Paste(PCViewDC, PCCursor1->CMLocation);
	if(PCCursor2) PCCursor1->Paste(PCViewDC, PCCursor2->CMLocation);

	return true;
}
void TCSchematicManager::RePasteSelected(bool hyde_labels)
{
	if(!CMSchematicManagerData.PCView) return ;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CPoint			LCLocation;
	CDC				*PCViewDC;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);	

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_selected) continue;

		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation, hyde_labels);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

}

void TCSchematicManager::ReDrawAllSelectedGraphics()
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CDC				*PCViewDC;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_selected) continue;

		PCSchematicObject->Clear(PCViewDC);

		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::ReDrawOverlapedRegion()
{
	TCSchematicObject	*PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p); 

		if(!PCSchematicObject) continue;

		ReDrawOverlapedRegion(p);
	}
} 

void TCSchematicManager::ClearOverlapedRegion(void)
{
	TCSchematicObject	*PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p); 

		if(!PCSchematicObject) continue;

		ClearOverlapedRegion(p);
	}
}
void TCSchematicManager::ReDrawOverlapedRegion(int p)
{
	ResetOverlapedRegion();
	TagOverlapedRegion(p); 
	BringSelectedGraphicsToTop();
	RePasteOverlapedGraphics();
}

void TCSchematicManager::ClearOverlapedRegion(int p)
{
	ResetOverlapedRegion();
	TagOverlapedRegion(p);
	ClearOverLapedGraphics();
}

void TCSchematicManager::RePasteOverlapedGraphics(void)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CDC				*PCViewDC;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_overlaped) continue;

		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::ClearOverLapedGraphics(void)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PCSchematicObject;
	CPoint			LCLocation;
	CDC				*PCViewDC;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	for(int p = count - 1; p > -1; p--)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_overlaped) continue;

		PCSchematicObject->Clear(PCViewDC);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}



void TCSchematicManager::TagOverlapedRegion(int id)
{
	CRect CInitOverlaped(0, 0, 0 ,0);

	TCSchematicObject	*PCSchematicObject;
	TCSchematicComponentInfo CSchematicComponentInfo;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(id >= count)
	{	
		ASSERT(0);

		return;
	}
	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	CInitOverlaped = PCSchematicObject->CMRectGrabLocationRegion;

	for(int p = 0; p < count; p++) 
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_overlaped) continue;

		if(PCSchematicObject->IsThere(&CSchematicComponentInfo, CInitOverlaped, false, true)) // true = ignore pins
		{
			PCSchematicObject->m_overlaped = true;

			TagOverlapedRegion(p);
		}
	}


	TCSchematicObject *PCSchematicObjectBase = CMSchematicManagerData.CGraphicList.GetAt(id);

	int count2 = PCSchematicObjectBase->GetNumberOfLabels();

	int p;

	for(int q = 0; q < count2; q++)
	{
		CInitOverlaped = PCSchematicObjectBase->GetLabelLocation(q);

		for(p = 0; p < count; p++) 
		{
			PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

			if(PCSchematicObject->m_overlaped) continue;

			if(PCSchematicObject->IsThere(&CSchematicComponentInfo, CInitOverlaped, false, true)) 
			{
				PCSchematicObject->m_overlaped = true;

				TagOverlapedRegion(p);
			}
		}
	}

	int count3 = PCSchematicObjectBase->GetNumberOfPins();

	for(int r = 0; r < count3; r++)
	{
		count2 = PCSchematicObjectBase->GetNumberOfPinLabels(r);

		for(int q = 0; q < count2; q++)
		{
			CInitOverlaped = PCSchematicObjectBase->GetPinLabelLocation(r, q);

			for(p = 0; p < count; p++) 
			{
				PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

				if(PCSchematicObject->m_overlaped) continue;

				if(PCSchematicObject->IsThere(&CSchematicComponentInfo, CInitOverlaped, false, true)) 
				{
					PCSchematicObject->m_overlaped = true;

					TagOverlapedRegion(p);
				}
			}
		}
	}
}

void TCSchematicManager::ResetOverlapedRegion(void)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;

	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		(*PCSchematicObjectPtr)->m_overlaped = 0;

		PCSchematicObjectPtr++;
	}
}

void TCSchematicManager::BringSelectedGraphicsToTop(void)
{
	TCSchematicObject	*PCSchematicObject;

	CArray <TCSchematicObject *, TCSchematicObject *> CSelectedList;
	CArray <TCSchematicObject *, TCSchematicObject *> CNotSelectedList;

	CSelectedList.SetSize(0);
	CNotSelectedList.SetSize(0);

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p); 

		if(PCSchematicObject->m_selected) CSelectedList.Add(PCSchematicObject);

		else CNotSelectedList.Add(PCSchematicObject);
	}

	int count2 = CNotSelectedList.GetSize();

	for(p = 0; p < count2; p++)
	{
		PCSchematicObject = CNotSelectedList.GetAt(p);

		CMSchematicManagerData.CGraphicList.SetAt(p, PCSchematicObject);
	}	

	for(int q = 0; p < count; p++, q++)
	{
		PCSchematicObject = CSelectedList.GetAt(q); 

		CMSchematicManagerData.CGraphicList.SetAt(p, PCSchematicObject);
	}	
}

bool TCSchematicManager::MoveTo(int id, CPoint CLocation)
{
	if(!CMSchematicManagerData.PCView) return false;

	CDC *PCViewDC;

	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	TCSchematicObject *PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	CLocation = (CPoint)(CLocation - PCSchematicObject->GetMouseOffset());
	
	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObject->MoveTo(PCViewDC, CLocation, false);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
	
	return true;
}

bool TCSchematicManager::ClearAllGraphics()
{
	if(!CMSchematicManagerData.PCView) return false;

	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	CDC *PCViewDC;

	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
	
		PCSchematicObject->Clear(PCViewDC, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);	
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return true;  
}

bool TCSchematicManager::Clear( int id)
{
	if(!CMSchematicManagerData.PCView) return false;

	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	CDC *PCViewDC;

	TCSchematicObject *PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return false;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);
	
	PCSchematicObject->Clear(PCViewDC, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return true; 
}


void TCSchematicManager::SetMouseOffset(int id, CPoint CMouseOffset)
{
	TCSchematicObject*	PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	PCSchematicObject->SetMouseOffset(CMouseOffset);

	CMSchematicManagerData.CGraphicList.SetAt(id, PCSchematicObject);

}

CPoint TCSchematicManager::GetMouseOffset(int id)
{

	TCSchematicObject *PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	return PCSchematicObject->GetMouseOffset();
}

TCSchematicObject *TCSchematicManager::GetSchematicObject(int id)
{
	if(id < 0) return NULL;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return NULL;

	return CMSchematicManagerData.CGraphicList.GetAt(id);	 
}

void TCSchematicManager::SetSelect(int id, bool redraw)
{
	if(!CMSchematicManagerData.PCView) return;
	if(id < 0) return;

	TCSchematicObject* PCSchematicObject;

	if(!(id < CMSchematicManagerData.CGraphicList.GetSize())) return;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->m_selected && !PCSchematicObject->m_highlighted) return; // added 22/11/97
	
	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);

	PCSchematicObject->Clear(PCDC);
	PCSchematicObject->SetSelect();
	PCSchematicObject->Paste(PCDC, PCSchematicObject->CMLocation);
	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

	if(redraw)DrawAll();
}

void TCSchematicManager::ResetSelect(int id, bool redraw )
{
	if(!CMSchematicManagerData.PCView) return;
	if(id < 0) return;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return;

	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(!PCSchematicObject->m_selected && !PCSchematicObject->m_highlighted) return; 

	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);

	PCSchematicObject->Clear(PCDC);
	PCSchematicObject->ResetSelect();
	PCSchematicObject->Paste(PCDC, PCSchematicObject->CMLocation);
	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

	if(redraw) DrawAll();	
}
void TCSchematicManager::SetHighlight(int id, bool redraw)
{
	if(!CMSchematicManagerData.PCView) return;

	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->m_highlighted) return; 
	
	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;


	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);

	PCSchematicObject->Clear(PCDC);
	PCSchematicObject->SetHighlighted();
	PCSchematicObject->Paste(PCDC, PCSchematicObject->CMLocation);
	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

	if(redraw) DrawAll();
}


void TCSchematicManager::SetSelectLabel(int id, int label_id, bool select, bool redraw )
{
	if(!CMSchematicManagerData.PCView) return;
	if(id < 0) return;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return;

	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->GetSelectLabel(label_id) == select) return; 
	
	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;


	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);

	PCSchematicObject->Clear(PCDC);
	PCSchematicObject->SetSelectLabel(NULL, label_id, select);
	PCSchematicObject->Paste(PCDC, PCSchematicObject->CMLocation);
	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

	if(redraw)DrawAll();	
}

void TCSchematicManager::SetSelectPinLabel(int id, int pin_id, int label_id, bool select, bool redraw)
{
	if(!CMSchematicManagerData.PCView) return;
	if(id < 0) return;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return;

	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->GetSelectPinLabel(pin_id, label_id) == select) return; 
	
	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);

	PCSchematicObject->Clear(PCDC);
	PCSchematicObject->SetSelectPinLabel(NULL, pin_id, label_id, select);
	PCSchematicObject->Paste(PCDC, PCSchematicObject->CMLocation);
	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

	if(redraw )DrawAll();
}

void TCSchematicManager::SetSelectPin(int id, int pin_id, bool select, bool redraw)
{
	if(!CMSchematicManagerData.PCView) return;
	if(id < 0) return;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return;

	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->GetSelectPin(pin_id) == select) return; 
	
	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);


	PCSchematicObject->Clear(PCDC);
	PCSchematicObject->SetSelectPin(NULL, pin_id, select);
	PCSchematicObject->Paste(PCDC, PCSchematicObject->CMLocation);
	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

	if(redraw)DrawAll();
}

bool TCSchematicManager::GetSelect(int id)
{
	if(id < 0) return NULL;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return NULL;

	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	return PCSchematicObject->m_selected;
}


bool TCSchematicManager::GetHighlight(int id)
{
	if(id < 0) return NULL;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return NULL;
	
	TCSchematicObject* PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);
	
	return PCSchematicObject->m_highlighted;
}

CString	TCSchematicManager::GetLabel(int id, int id_label)
{
	if(id < 0) return "";
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return "";

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = GetSchematicObject(id);

	if(!PCSchematicObject) return "";

	if(!(id_label < PCSchematicObject->CMSchematicObjectData.CLabelListData.GetSize())) return "";

	return PCSchematicObject->CMSchematicObjectData.CLabelListData[id_label].CLabel;
}

void TCSchematicManager::SetLabel(int id, int id_label, CString CText, bool redraw, int f_all_same_nodes)
{
	redraw;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	if(id < 0) return;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return;

	bool flag = false;

	if(m_component_is_outlined) 
	{
		EraseComponentOutline();

		flag = true;
	}

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = GetSchematicObject(id);

	if(!PCSchematicObject) return;

	CPoint CLocation;

	CLocation = GetLocation(id);

	CLocation = (CPoint)(CLocation + PCSchematicObject->CMCenterPoint);

	CDC *PCDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCDC, NULL);

	if(!GCSuperSpiceGlobalData.CDrawData.hyde_labels)
		PCSchematicObject->ClearLabel(PCDC, id_label);

	PCSchematicObject->SetLabel(PCDC, id_label, CText, false);

	if(!GCSuperSpiceGlobalData.CDrawData.hyde_labels)
		PCSchematicObject->RepasteLabel(PCDC, id_label);

	CMSchematicManagerData.PCView->ReleaseDC(PCDC);

/*
	if(redraw)PasteGraphic(id, CLocation, false);
	else PasteGraphic(id, CLocation, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);
*/
	if(f_all_same_nodes) 
	{
		MakeSameWiresHaveSameName(id, f_all_same_nodes);
	
		DrawAll();
	}

	if(flag) OutlineGraphics(CMLastOutlinedMousePosition);
}
 
void TCSchematicManager::SetPinLabel(int id, int id_pin, int id_label, CString CText, bool redraw)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	if(id < 0) return;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return;

	bool flag = false;

	if(m_component_is_outlined) 
	{
		EraseComponentOutline();

		flag = true;
	}
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = GetSchematicObject(id);

	CPoint CLocation;

	CLocation = GetLocation(id);

	CLocation = (CPoint)(CLocation + PCSchematicObject->CMCenterPoint);
	
	Clear(id);

	PCSchematicObject->SetPinLabel(&GlobalCDCTemp, id_pin, id_label, CText);

	if(redraw)PasteGraphic(id, CLocation, false);
	else PasteGraphic(id, CLocation, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);

	if(flag) OutlineGraphics(CMLastOutlinedMousePosition);
}

TCSchematicObjectData *TCSchematicManager::GetSchematicObjectData(int id)
{
//	if(id =< 0) do not call , temp
	TCSchematicObject		*PCSchematicObject;

	if(id >=  CMSchematicManagerData.CGraphicList.GetSize())
	{
		PCSchematicObject = GetSchematicObject(0);// this must exist

		if(!PCSchematicObject) return NULL;

		return &PCSchematicObject->GetSchematicObjectData();
	}
	PCSchematicObject = GetSchematicObject(id);

	if(!PCSchematicObject) return NULL;

	return &PCSchematicObject->GetSchematicObjectData();
}

bool TCSchematicManager::SetSchematicObjectData(int id, TCSchematicObjectData &CSchematicObjectData)
{
	if(id < 0) return false;
	if(id >=  CMSchematicManagerData.CGraphicList.GetSize()) return false;

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = GetSchematicObject(id);

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return false;

	CPoint CLocation = PCSchematicObject->CMLocation;

	PCSchematicObject->SetSchematicObjectData(&CDCTemp, CSchematicObjectData);

	PCSchematicObject->ReLabelAxis();
	// SetSchem resets symbol data so redo;
	PCSchematicObject->Paste(&CDCTemp, CLocation);

	DrawAll();

	return true;
}

void TCSchematicManager::MoveGraphics(CPoint CLocation, bool draw_overlaped, int snap_to_grid_is_enabled, bool hyde_labels)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;
	draw_overlaped;
	CPoint				CGraphicPosition;
	register TCSchematicObject	**PCSchematicObjectPtr; 
	register int		p;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();	
	CDC					*PCViewDC;

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{				
		CGraphicPosition = (CPoint)(CLocation - (*PCSchematicObjectPtr)->CMMouseOffset);

		if((*PCSchematicObjectPtr)->m_selected)
		if((*PCSchematicObjectPtr)->m_type != E_TEST_MARKER) graphics_modified = true;// waveform signal support

		(*PCSchematicObjectPtr)->MoveTo(PCViewDC, CGraphicPosition, snap_to_grid_is_enabled, hyde_labels);	

		PCSchematicObjectPtr++;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::InsertIntoWire(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;

	if(PCSchematicObject->m_type)
	if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE)  return;
	if(PCSchematicObject->GetNumberOfPins() != 2) return;// improve this later

	register TCSchematicObject	**PCSchematicObjectPtr; 
	register int		p;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();	
	CDC					*PCViewDC;

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	CRect CTestRect, CPinRect0, CPinRect1;
	CPoint CTestPoint, CStartPoint, CEndPoint, CNewEndPoint;

	CPinRect0 = PCSchematicObject->GetPinGrabRegion(0);
	CPinRect1 = PCSchematicObject->GetPinGrabRegion(1);

	TCSchematicObject *PCSchematicWireObject;

	for(p = 0; p < count; p++)
	{				
		if((*PCSchematicObjectPtr)->m_type != E_WIRE_COMPONENT){PCSchematicObjectPtr++;continue;}

		PCSchematicWireObject = *PCSchematicObjectPtr;

		if(!CTestRect.IntersectRect(PCSchematicWireObject->CMRectGrabLocationRegion, CPinRect0)) {PCSchematicObjectPtr++;continue;}
		if(!CTestRect.IntersectRect(PCSchematicWireObject->CMRectGrabLocationRegion, CPinRect1)) {PCSchematicObjectPtr++;continue;}

		//Shorten wire end first
		CStartPoint = CPinRect0.CenterPoint();
		CEndPoint	= CPinRect1.CenterPoint();

		CNewEndPoint = PCSchematicWireObject->CMLineEnd;

		if(PCSchematicWireObject->m_draw_angle == E_HORIZONTAL)
		{
			if(CEndPoint.x < CStartPoint.x) 
			{
				CTestPoint	= CStartPoint;
				CStartPoint	= CEndPoint;
				CEndPoint	= CTestPoint;
			}
		}
		else
		{
			if(CEndPoint.y < CStartPoint.y)
			{
				CTestPoint	= CStartPoint;
				CStartPoint	= CEndPoint;
				CEndPoint	= CTestPoint;
			}
		}

		PCSchematicWireObject->StopDrawingLine(PCViewDC, CStartPoint, false);

		PCSchematicWireObject->DisplayConnectionDot2(PCViewDC);
		PCSchematicWireObject->Zoom(PCSchematicWireObject->m_zoom);
		PCSchematicWireObject->Paste(PCViewDC, PCSchematicWireObject->CMLocation, false);

		PCSchematicWireObject = CreateWire(PCViewDC, CEndPoint, CNewEndPoint);

		if(!PCSchematicWireObject) break;

		PCSchematicWireObject->DisplayConnectionDot1(PCViewDC);
		PCSchematicWireObject->Zoom(PCSchematicWireObject->m_zoom);
		PCSchematicWireObject->Paste(PCViewDC, PCSchematicWireObject->CMLocation, false);

		break;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::StartRubberBanding(void)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	register int count = CMSchematicManagerData.CGraphicList.GetSize();	
	register TCSchematicObject	**PCSchematicObjectPtr, **PCSchematicWireObjectPtr;
	register TCSchematicObject *PCSchematicObject, *PCWireSchematicObject;

	int pin_count;
	CRect CTestRect;
	CRect CPinRegion;
	TCRubberBandPinData CRubberBandPinData;


	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(int p = 0; p < count; p++)// find what component pins are connected to what wire, if any
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(!PCSchematicObject->m_selected || PCSchematicObject->m_type == E_TEST_MARKER)
		{
			PCSchematicObjectPtr++;

			continue;
		}

		pin_count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();

		for(int q = 0; q < pin_count; q++)
		{
			CPinRegion	= PCSchematicObject->GetPinGrabRegion(q);

			PCSchematicObject->CMPinListObject[q].CRubberBandPinList.SetSize(0, pin_count);// clear old data

			PCSchematicWireObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

			for(int r = 0; r < count; r++)
			{
				PCWireSchematicObject = *PCSchematicWireObjectPtr;

				if(PCWireSchematicObject->m_type != E_WIRE_COMPONENT || PCWireSchematicObject->m_selected ||
					PCWireSchematicObject == PCSchematicObject)
				{
					PCSchematicWireObjectPtr++;

					continue;
				}

				if(CTestRect.IntersectRect(CPinRegion, PCWireSchematicObject->GetPinGrabRegion(0)))
				{
					CRubberBandPinData.PCObject	= PCWireSchematicObject;

					PCSchematicObject->CMPinListObject[q].CRubberBandPinList.Add(CRubberBandPinData);

					//Start drawing new wires connected to component pins
					PCWireSchematicObject->Clear(PCViewDC);
					PCWireSchematicObject->StartDrawingLine(PCViewDC, PCWireSchematicObject->CMLineEnd, CMSchematicManagerData.zoom);
					PCWireSchematicObject->ContinueDrawingLine(PCViewDC, PCWireSchematicObject->CMLineStart, false);
					PCWireSchematicObject->ResetSelect();
				}
				else if (CTestRect.IntersectRect(CPinRegion, PCWireSchematicObject->GetPinGrabRegion(1)))
				{
					CRubberBandPinData.PCObject		= PCWireSchematicObject;

					PCSchematicObject->CMPinListObject[q].CRubberBandPinList.Add(CRubberBandPinData);
				
					PCWireSchematicObject->Clear(PCViewDC);
					PCWireSchematicObject->StartDrawingLine(PCViewDC, PCWireSchematicObject->CMLineStart, CMSchematicManagerData.zoom);
					PCWireSchematicObject->ContinueDrawingLine(PCViewDC, PCWireSchematicObject->CMLineEnd, false);
					PCWireSchematicObject->ResetSelect();
				}

				PCSchematicWireObjectPtr++;
			}
		}

		PCSchematicObjectPtr++;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::ContinueRubberBanding(void)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	register int count = CMSchematicManagerData.CGraphicList.GetSize();	
	TCSchematicObject *PCSchematicObject, **PCSchematicObjectPtr;
	int pin_count;
	TCRubberBandPinData CRubberBandPinData;
	CPoint CComponentLocation, CPinLocation, CWirePinLocation;
	int wire_count;

	CRect CGrabRegion;

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(!PCSchematicObject->m_selected || PCSchematicObject->m_type == E_TEST_MARKER)
		{
			PCSchematicObjectPtr++;

			continue;
		}

		pin_count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();

		CComponentLocation = PCSchematicObject->CMSchematicObjectData.CLocation;

		for(int q = 0; q < pin_count; q++)
		{
			CArray <TCRubberBandPinData, TCRubberBandPinData&> &CRubberBandPinData = PCSchematicObject->CMPinListObject[q].CRubberBandPinList;
			
			CGrabRegion = PCSchematicObject->GetPinGrabRegion(q);

			CWirePinLocation = CGrabRegion.CenterPoint();

			wire_count = CRubberBandPinData.GetSize();

			for(int r = 0; r < wire_count; r++)
			{
				if(!CRubberBandPinData[r].PCObject) continue;

				CRubberBandPinData[r].PCObject->ContinueDrawingLine(PCViewDC, CWirePinLocation, false);
			}
		}

		PCSchematicObjectPtr++;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::EndRubberBanding(void)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	register int count = CMSchematicManagerData.CGraphicList.GetSize();	
	TCSchematicObject *PCSchematicObject, **PCSchematicObjectPtr, *PCSchematicWireObject;
	int pin_count;
	TCRubberBandPinData CRubberBandPinData;
	CPoint CComponentLocation, CPinLocation, CWirePinLocation;
	int wire_count;

	CRect CGrabRegion;

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(!PCSchematicObject->m_selected)
		{
			PCSchematicObjectPtr++;

			continue;
		}

		pin_count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();

		CComponentLocation = PCSchematicObject->CMSchematicObjectData.CLocation;

		for(int q = 0; q < pin_count; q++)
		{
			CArray <TCRubberBandPinData, TCRubberBandPinData&> &CRubberBandPinData = PCSchematicObject->CMPinListObject[q].CRubberBandPinList;

			wire_count = CRubberBandPinData.GetSize();

			CGrabRegion = PCSchematicObject->GetPinGrabRegion(q);

			CWirePinLocation = CGrabRegion.CenterPoint();

			for(int r = 0; r < wire_count; r++)
			{
				PCSchematicWireObject = CRubberBandPinData[r].PCObject;

				if(PCSchematicWireObject)
				{
					if(PCSchematicWireObject->CMLocation !=  CWirePinLocation)//Quick fix
					
					PCSchematicWireObject->StopDrawingLine(PCViewDC, CWirePinLocation, true);

					PCSchematicWireObject->m_selected = true;// force grab region
					PCSchematicWireObject->MoveTo(PCViewDC, PCSchematicWireObject->CMLocation, true);
					PCSchematicWireObject->m_selected = false;
				}

				CRubberBandPinData[r].PCObject = NULL;
			}
		}

		PCSchematicObjectPtr++;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::DrawSelectionBox(CDC *PCViewDC, CPoint CMousePosition)
{
	if(!PCViewDC) return;

	CMDrawSelectionRegion.Continue(PCViewDC, CMousePosition);	
}

void TCSchematicManager::DrawInitialSelectionBox(CDC *PCViewDC, CPoint CMousePosition)
{	
	if(!PCViewDC) return;

	CMDrawSelectionRegion.SetView(CMSchematicManagerData.PCView);

	CMDrawSelectionRegion.Start(PCViewDC, CMousePosition);
}

void TCSchematicManager::CancelSelectionBox(CDC *PCViewDC)
{
	if(!PCViewDC) return;

	CMDrawSelectionRegion.Delete(PCViewDC);
}

void TCSchematicManager::ResetSelectAll(bool f_redraw)
{	
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	register int count;
	
	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	count = CMSchematicManagerData.CGraphicList.GetSize();

	for(p = 0; p < count; p++)
	{		
		if(!(*PCSchematicObjectPtr)->m_selected && !(*PCSchematicObjectPtr)->m_highlighted) 
		{
			PCSchematicObjectPtr++;
			continue;
		}

		if(f_redraw) 
		{
			(*PCSchematicObjectPtr)->Clear(PCViewDC);
			(*PCSchematicObjectPtr)->ResetSelect();
			(*PCSchematicObjectPtr)->Paste(PCViewDC, (*PCSchematicObjectPtr)->CMLocation);
		}
		else (*PCSchematicObjectPtr)->ResetSelect();

		PCSchematicObjectPtr++;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::ClipboardResetSelectAll(CDC *PCMemDC)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	register int count;

	if(!PCMemDC) return;
	
	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	count = CMSchematicManagerData.CGraphicList.GetSize();

	for(p = 0; p < count; p++)
	{		
		if(!(*PCSchematicObjectPtr)->m_selected && !(*PCSchematicObjectPtr)->m_highlighted) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		if((*PCSchematicObjectPtr)->m_type == E_WAVEFORM_COMPONENT) 
		{
			(*PCSchematicObjectPtr)->Clear(PCMemDC);
			(*PCSchematicObjectPtr)->ResetSelect();
			(*PCSchematicObjectPtr)->Paste(PCMemDC, (*PCSchematicObjectPtr)->CMLocation);
		}
		else (*PCSchematicObjectPtr)->ResetSelect();

		PCSchematicObjectPtr++;
	}
}

void TCSchematicManager::SetSelectAll()
{
	if(!CMSchematicManagerData.PCView) return;

	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
		
		if(PCSchematicObject->m_type == E_TITLE_BLOCK) continue;

		PCSchematicObject->SetSelect();
	}

	DrawAll();
}

void TCSchematicManager::InitaliseGraphicLocation(int id, CPoint CMousePosition)
{
	CPoint COffset = GetLocation(id);

	COffset = (CPoint)(CMousePosition - COffset);

	SetMouseOffset(id, COffset);
}

void TCSchematicManager::InitaliseAllGraphicLocations( CPoint CMousePosition)
{
	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{

		CPoint COffset = GetLocation(p);

		COffset = (CPoint)(CMousePosition - COffset);

		SetMouseOffset(p, COffset);
	}
}


bool TCSchematicManager::OpenGraphic(CPoint CMousePosition, int graphic, short  version, TCSchematicObjectData &CSchematicObjectData)
{
	int id = -1;

	if(!graphic)
	{
		id = CreateGraphic(CSchematicObjectData);
	}
	else
	{
		id = CreateGraphic((TE_TYPE_OF_COMPONENT) graphic);
	}

	if(id < 0)
	{
		AfxMessageBox(IDS_ERR_FAILED_SYMBOLCREATE);

		return false;
	}

	ResetSelectAll(true);

	CMSchematicManagerData.CGraphicList.GetAt(id)->SetSelect();

	PCMLastCreatedGraphic->CMSchematicObjectData.version = version;


	if(PCMLastCreatedGraphic->CMSchematicObjectData.CReserved.CIntArray.GetSize() > 1)
	{
		PCMLastCreatedGraphic->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = true;	// overide to always include in Spice and PCB netlist
		PCMLastCreatedGraphic->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = true;
		PCMLastCreatedGraphic->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE] = 0;// always overide the designer value to off
	}	

	int type = CMSchematicManagerData.CGraphicList.GetAt(id)->m_type; 

	if(version || type == E_TEST_MARKER || type == E_WIRE_COMPONENT || type == E_SUBCIRCUIT_PIN_CONNECTER)// a bit messy, but needed to stop next testpoint deleting last waveform
		if(!DoSpecialComponentProccessing(CMSchematicManagerData.CGraphicList.GetAt(id), version))
		{
			AfxMessageBox(IDS_ERR_FAILED_SYMBOLCREATE);

			DeleteSelectedGraphics();

			return false;
		}

	m_last_created_id = id;

	PCMLastCreatedGraphic = CMSchematicManagerData.CGraphicList.GetAt(id);

	PCMLastCreatedGraphic->SetPageId(CMSchematicManagerData.page_id);

	// 17th September 2001. Correct and tidy up 
	PCMLastCreatedGraphic->CMSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = PCMLastCreatedGraphic->CMSchematicObjectData.CSymbolData.CName;


	// this was needed to see if initial data is in the data base and then get it
	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(PCMLastCreatedGraphic->CMSchematicObjectData.CSpiceParameters);

	if(PCSpiceParameters) PCMLastCreatedGraphic->CMSchematicObjectData.CSpiceParameters = *PCSpiceParameters;

	PCMLastCreatedGraphic->FormatLabels();

	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
	{
		PCMLastCreatedGraphic->StartMoveTo();
	}

	PasteGraphic(id, CMousePosition, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);

	return true;
}

int TCSchematicManager::DoSpecialComponentProccessing(TCSchematicObject *PCSchematicObject, short version)
{
	if(!PCSchematicObject) return false;
		
	PCSchematicObject->CMSchematicObjectData.version = version;

	CDC CDCTemp;

	CDCTemp.CreateCompatibleDC(NULL);

	int type = PCSchematicObject->m_type;

	if(type == E_WIRE_COMPONENT)
	{
		PCSchematicObject->SetLabel(&CDCTemp, E_WIRE_NET_VOLTAGE, "V?");
	}

	if(type == E_TEST_MARKER)
	{	
		PCSchematicObject->CMSchematicObjectData.version = -1;
		PCSchematicObject->SetLabel(&CDCTemp, E_COMPONENT_SYMBOL_NAME, "Name?");
		PCSchematicObject->SetLabel(&CDCTemp, E_COMPONENT_SPICE_MODEL_NAME, "Name?");
		PCSchematicObject->SetPinLabel(&CDCTemp, 0, E_COMPONENT_PIN_NET_NAME, "Node?");

		return true;
	}

	if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_GENERATOR)
	{		
		if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData)
			PCSchematicObject->CMSchematicObjectData.PCGeneratorData = new TCGeneratorData;
	
		if(IsBadReadPtr(PCSchematicObject->CMSchematicObjectData.PCGeneratorData, 4))
		{
			return false;
		}
		
		PCSchematicObject->CMSchematicObjectData.PCGeneratorData->version = GetGeneratorVersionfromViewType(PCSchematicObject->CMSchematicObjectData.component_property_view_type);
		
		//quick fix, but better default
		if(PCSchematicObject->CMSchematicObjectData.PCGeneratorData->version == E_SINE_VOLTAGE_SOURCE) PCSchematicObject->CMSchematicObjectData.component_property_view_type = E_PROPERTY_SINE_VOLTAGE_SOURCE;
		
		PCSchematicObject->CMSchematicObjectData.version = (unsigned short)PCSchematicObject->CMSchematicObjectData.PCGeneratorData->version;

		TCGeneratorData &CGeneratorData = *PCSchematicObject->CMSchematicObjectData.PCGeneratorData;

		if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_DC_VOLTAGE_SOURCE || 
		   PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_DC_CURRENT_SOURCE)
		{
			CGeneratorData.CDCGeneratorData.CACVoltage  = "0";
			CGeneratorData.CDCGeneratorData.CACPhase	= "0";
			CGeneratorData.CDCGeneratorData.CDCVoltage	= "1";
		}
		else
		{
			CGeneratorData.CDCGeneratorData.CACVoltage  = "1";
			CGeneratorData.CDCGeneratorData.CACPhase	= "0";
			CGeneratorData.CDCGeneratorData.CDCVoltage	= "0";
		}
	}

	if(type == E_SUBCIRCUIT_PIN_CONNECTER)
	{		
		PCSchematicObject->SetLabel(&CDCTemp, E_COMPONENT_VALUE, "#", true);
	}

	if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_RESISTOR)
	{
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelValue = "";
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].is_visable = 0;
	
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelValue = "";
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].is_visable = 0;

		PCSchematicObject->CMSchematicObjectData.FormatLabel();
	}
	else if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_CAPACITOR)
	{
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].CLabelValue = "";
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].is_visable = 0;
	
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].CLabelValue = "";
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].is_visable = 0;

		PCSchematicObject->CMSchematicObjectData.FormatLabel();
	}
	else if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_INDUCTOR)
	{
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].CLabelValue = "";
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].is_visable = 0;
	
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].CLabelValue = "";
		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].is_visable = 0;

		PCSchematicObject->CMSchematicObjectData.FormatLabel();
	}

	return true;
}

void TCSchematicManager::CreateTitleBlock(void)
{
	CPoint CMousePosition;

	UpdatePageOutline();

	CMousePosition.x = CInerPageArea.right;
	CMousePosition.y = CInerPageArea.bottom;

	int width = GCSuperSpiceDataBase.CMDefaults[E_TITLE_BLOCK].width/2;
	int height = GCSuperSpiceDataBase.CMDefaults[E_TITLE_BLOCK].height/2;

	width = (int) (width * CMSchematicManagerData.zoom);
	height = (int) (height * CMSchematicManagerData.zoom);

	CMousePosition.x -= width;
	CMousePosition.y -= height;

	if(!OpenGraphic(CMousePosition, E_TITLE_BLOCK, 0, GCSuperSpiceDataBase.CMDefaults[E_TITLE_BLOCK])) return;

	ResetSelect(m_last_created_id);
}

void TCSchematicManager::CreateInitGnd(void)
{
	CPoint CMousePosition;

	CMousePosition.x = 64;
	CMousePosition.y = 64;

	if(!OpenGraphic(CMousePosition, E_GROUND, 0, GCSuperSpiceDataBase.CMDefaults[E_GROUND])) return;

	ResetSelect(m_last_created_id);
}
void TCSchematicManager::CreateInitTestMarker(void)
{
	CPoint CMousePosition;

	CMousePosition.x = 72;
	CMousePosition.y = 64;

	if(!OpenGraphic(CMousePosition, E_TEST_MARKER, 0, GCSuperSpiceDataBase.CMDefaults[E_TEST_MARKER])) return;

	ResetSelect(m_last_created_id);
}

void TCSchematicManager::RepositionTitleBlock(void)
{
	CPoint CMousePosition;

	CMousePosition.x = CInerPageArea.right;
	CMousePosition.y = CInerPageArea.bottom;

	int width = GCSuperSpiceDataBase.CMDefaults[E_TITLE_BLOCK].width/2;
	int height = GCSuperSpiceDataBase.CMDefaults[E_TITLE_BLOCK].height/2;

	width = (int) (width * CMSchematicManagerData.zoom);
	height = (int) (height * CMSchematicManagerData.zoom);

	CMousePosition.x -= width;
	CMousePosition.y -= height;

	CDC					*PCViewDC;
	TCSchematicObject	*PCSchematicObject;
	CPoint				LCLocation;

	int id = FindTitleBlock();

	if(id < 0) return;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->CMSchematicObjectData.reserved) return;//unlocked tittle block

	LCLocation = (CPoint)(CMousePosition - PCSchematicObject->CMCenterPoint);
	
	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObject->Clear(PCViewDC);
	PCSchematicObject->Paste(PCViewDC, LCLocation);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	InitaliseGraphicLocation(id, CMousePosition);
}

int TCSchematicManager::FindTitleBlock(void)
{
	register TCSchematicObject	**PCSchematicObjectPtr, *PCSchematicObject;
	register int p;
	register int count;

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	count = CMSchematicManagerData.CGraphicList.GetSize();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr++;

		if(PCSchematicObject->m_type == E_TITLE_BLOCK) return p;
	}

	return -1;
}

TCSchematicObject *TCSchematicManager::GetLastCreatedGraphic(void)
{
	return PCMLastCreatedGraphic;
}

void TCSchematicManager::UpdateSchematicObjectDataBase(void)
{
	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++) 
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject) continue;

		if(!(PCSchematicObject->m_selected || PCSchematicObject->m_highlighted|| m_component_is_outlined)) continue;

//		if(PCSchematicObject->m_type == E_WIRE_COMPONENT) continue;// Connection dot support.

		// dont update line draw data
		TCSchematicObjectData CSchematicObjectData;

		PCSchematicObject->UpdateSchematicObjectData();
		CSchematicObjectData.Copy(PCSchematicObject->GetSchematicObjectData()); // doesnot overwrite synmbol data

//		GCSuperSpiceDataBase.CMDefaults[PCSchematicObject->m_type].Copy(CSchematicObjectData);

		if(PCSchematicObject->m_type != E_WAVEFORM_COMPONENT)// two risky
			GCSuperSpiceDataBase.SetSchematicObjectData(CSchematicObjectData, false);
	}
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::IdleStateGetGraphic(CPoint CMousePosition, int graphic_type, short version, TCSchematicObjectData &CSchematicObjectData)
{	
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_type, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
	
	return E_GRAPHICS_MANAGER_STATE_IDLE;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsSelectedStateGetGraphic(CPoint CMousePosition, int graphic_type, short version, TCSchematicObjectData &CSchematicObjectData)
{
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_type, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsMovingStateGetGraphic(CPoint CMousePosition, int graphic_type, short version, TCSchematicObjectData &CSchematicObjectData)
{
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_type, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING;
}	
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SelectRegionStateGetGraphic(CPoint CMousePosition, int graphic_type, short version, TCSchematicObjectData &CSchematicObjectData)
{
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_type, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

	return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;
}	
	 
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotGraphicStateGetGraphic(CPoint CMousePosition, int graphic_type, short version, TCSchematicObjectData &CSchematicObjectData)
{
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_type, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

	return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotClipboardGetGraphic(CPoint CMousePosition, int graphic_type, short version, TCSchematicObjectData &CSchematicObjectData)
{
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_type, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::IdleStateLBDown(UINT mouse_flags, CPoint CMousePosition)
{
	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	mouse_flags;
	// First see if a component is at the mouse position 

	TCSchematicComponentInfo CSchematicComponentInfo;
	TCSchematicObject *PCSchematicObject = NULL;

	bool fine = false;
	bool draw_wire_flag = false;

//	if(mouse_flags & MK_SHIFT) fine = true;

	CSchematicComponentInfo = InspectSchematicObject(CMousePosition, fine);

	int id			= CSchematicComponentInfo.id;
	int label_id	= CSchematicComponentInfo.label_id;
	int pin_id		= CSchematicComponentInfo.pin_id;
	
	if(!(id < 0))
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

		if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)//ignore graph labels
		{
			if(CSchematicComponentInfo.type == E_SCHEMATIC_LABEL)
				if(CSchematicComponentInfo.label_id > E_WAVEFORM_ENABLE)
					id = -1;
		}
	}
	
	if(!(id < 0)) // Graphic found so select it
	{
		if(m_component_is_outlined) EraseComponentOutline();

		bool waveform_corner = false;

		if(CSchematicComponentInfo.type == E_WAVEFORM_OBJECT_SCREEN)// screen zoom in selection region
		{
			fm_select_region = true;
			SetActiveWaveform(id);

			if(mouse_flags & MK_CONTROL) SwopCursor(CMousePosition);
			if(mouse_flags & MK_SHIFT)	SwopAxis(PCSchematicObject, CMousePosition);

			return E_GRAPHICS_MANAGER_STATE_IDLE; 
		}

		if(!is_symbol_editor)
		{
			if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
			{
				if(CSchematicComponentInfo.type == E_SCHEMATIC_PIN) waveform_corner = true;
			}

			else if(mouse_flags & MK_ALT) 
			{
				WaveformOnClickStateLBDown(mouse_flags, CMousePosition);

				if(CTestPointData.update_graph_views)// pin or wire found
				return E_GRAPHICS_MANAGER_STATE_IDLE;
			}

			else if(mouse_flags & MK_SHIFT) 
			{
				WaveformOnClickStateLBDown(mouse_flags, CMousePosition);

				if(CTestPointData.update_graph_views)// pin or wire found
					return E_GRAPHICS_MANAGER_STATE_IDLE;
			}
		}

		DisplayModelAndSymbol(id);//in docking window

		switch(CSchematicComponentInfo.type)
		{
			case E_SCHEMATIC_OBJECT: SetSelect(id, false); CGlobalStatusMessage = E_STATUS_MSG_COMONENT_SELECTED;  break;

			case E_WAVEFORM_OBJECT: SetActiveWaveform(id); SetSelect(id, false); CGlobalStatusMessage = "Waveform selected";break;

			case E_SCHEMATIC_TEXT_LABEL: SetSelect(id, false); CGlobalStatusMessage = E_STATUS_MSG_TEXT_SELECTED;break;

			case E_SCHEMATIC_WIRE: SetSelect(id, false); CGlobalStatusMessage = E_STATUS_MSG_COMPONENT_WIRE_SELECTED;break;	
		
			case E_SCHEMATIC_LABEL: SetSelectLabel(id, label_id, true, false);CGlobalStatusMessage = E_STATUS_MSG_COMPONENT_LABEL_SELECTED;break;	

			case E_SCHEMATIC_PIN: if(!is_pin_moveable)
								  {
									  if(!waveform_corner) 
									  {
										  if(is_symbol_editor && PCSchematicObject->m_type == E_WIRE_COMPONENT) 
										  {
											  SetSelect(id, false); CGlobalStatusMessage = E_STATUS_MSG_COMPONENT_WIRE_SELECTED;break;
										  }
										  if(!(is_symbol_editor && PCSchematicObject->m_type != E_WIRE_COMPONENT))
										  {
											draw_wire_flag = true; 
										  }

										  CGlobalStatusMessage = E_STATUS_MSG_PIN_SELECTED;

										  break;
									  }								  
								  }
								 
								  else SetSelectPin(id, pin_id, true);break;

			case E_SCHEMATIC_PIN_LABEL: SetSelectPinLabel(id, pin_id, label_id, true, false);CGlobalStatusMessage = E_STATUS_MSG_COMPONENT_PIN_LABEL_SELECTED;break;	
		
			default: return E_GRAPHICS_MANAGER_STATE_IDLE;;
		}

		if(draw_wire_flag) return WaitingToDrawWireLBDown(0, CMousePosition);

		if(waveform_corner) 
		{
			PCMLastOutlinedComponent = PCSchematicObject;

			return SizingWaveformWindowLBDown(mouse_flags, CMousePosition);
		}
		InitaliseGraphicLocation(id, CMousePosition);

		return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
	}	
	
	// If no component found attempt a selection region box if mouse only if draged

	fm_select_region = true;

	return E_GRAPHICS_MANAGER_STATE_IDLE; 
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsSelectedStateLBDown(UINT mouse_flags, CPoint CMousePosition)
{
	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicComponentInfo CSchematicComponentInfo;
	TCSchematicObject *PCSchematicObject;

	if(!is_symbol_editor)
	{
		if(mouse_flags & MK_ALT) 
		{
			WaveformOnClickStateLBDown(mouse_flags, CMousePosition);

			if(CTestPointData.update_graph_views)// pin or wire found
			return E_GRAPHICS_MANAGER_STATE_IDLE;
		}

		else if(mouse_flags & MK_SHIFT) 
		{
			WaveformOnClickStateLBDown(mouse_flags, CMousePosition);

			if(CTestPointData.update_graph_views)// pin or wire found
				return E_GRAPHICS_MANAGER_STATE_IDLE;
		}
	}

	bool fine = false;
//	if(mouse_flags & MK_SHIFT) fine = true;

	CSchematicComponentInfo = InspectSchematicObject(CMousePosition, fine);

	int id			= CSchematicComponentInfo.id;
	int label_id	= CSchematicComponentInfo.label_id;
	int pin_id		= CSchematicComponentInfo.pin_id;

	if(id < 0)  // No component so start draw selection region and cancel all selected
	{
		CGlobalStatusMessage = E_STATUS_MSG_IDLE;
		fm_select_region = true; // attempt a select region
		ResetSelectAll(true);
//		DrawAll();

		return E_GRAPHICS_MANAGER_STATE_IDLE;	// 
	}

	if(m_component_is_outlined) EraseComponentOutline();

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	bool waveform_corner = false;
		
	if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
	{
		if(CSchematicComponentInfo.type == E_SCHEMATIC_PIN) waveform_corner = true;

		else if(CSchematicComponentInfo.type == E_SCHEMATIC_LABEL)
			 if(CSchematicComponentInfo.label_id > E_WAVEFORM_ENABLE) return E_GRAPHICS_MANAGER_STATE_IDLE; 
	}

	if(PCSchematicObject->m_type == E_WAVEFORM_OBJECT_SCREEN) SetActiveWaveform(id);

	int draw_wire_flag = false;

	if(mouse_flags & MK_CONTROL) // Multiple select toggeling if ctrl held down
	{
		switch(CSchematicComponentInfo.type)
		{

			case E_SCHEMATIC_OBJECT: if(!GetSelect(id)) SetSelect(id); 
									 else ResetSelect(id);break;
									 
			case E_WAVEFORM_OBJECT: if(!GetSelect(id)) {SetActiveWaveform(id);SetSelect(id);} 
									 else ResetSelect(id);break;

			case E_SCHEMATIC_TEXT_LABEL:if(!GetSelect(id)) SetSelect(id); 
										else ResetSelect(id);break;

			case E_SCHEMATIC_WIRE: if(!GetSelect(id)) SetSelect(id); 
									 else ResetSelect(id);break;
			case E_SCHEMATIC_LABEL: SetSelectLabel(id, label_id, !PCSchematicObject->GetSelectLabel(label_id));break;	

			case E_SCHEMATIC_PIN:  if(!is_pin_moveable)
								  {
									  if(!waveform_corner) 
									  {
										  if(is_symbol_editor && PCSchematicObject->m_type == E_WIRE_COMPONENT) 
										  {
											  if(!GetSelect(id)) SetSelect(id); 
												else ResetSelect(id);break;
										  }

										  if(!(is_symbol_editor && PCSchematicObject->m_type != E_WIRE_COMPONENT))
										  {
											draw_wire_flag = true; 
										  }

										  CGlobalStatusMessage = E_STATUS_MSG_PIN_SELECTED;

										  break;
									  }								  
								  }
								   else SetSelectPin(id, pin_id, true);break;

			case E_SCHEMATIC_PIN_LABEL: SetSelectPinLabel(id, pin_id, label_id, !PCSchematicObject->GetSelectPinLabel(pin_id, label_id));break;	

		}
	}
	else
	{
		DisplayModelAndSymbol(id);

			if(!(GetSelect(id) || GetHighlight(id)))
			{	
				ResetSelectAll(false);// dont redraw, done in SetSelect

				switch(CSchematicComponentInfo.type)
				{
					case E_SCHEMATIC_OBJECT: SetSelect(id, true); break;

					case E_WAVEFORM_OBJECT:  SetActiveWaveform(id);SetSelect(id, true);  break;

					case E_SCHEMATIC_TEXT_LABEL: SetSelect(id, true); break;
					
					case E_SCHEMATIC_WIRE: SetSelect(id, true); break;

					case E_SCHEMATIC_LABEL: SetSelectLabel(id, label_id, true, true);break;	

					case E_SCHEMATIC_PIN:	if(!is_pin_moveable)
											{
												if(!waveform_corner) 
												{
													if(is_symbol_editor && PCSchematicObject->m_type == E_WIRE_COMPONENT) 
													{
														SetSelect(id, false); CGlobalStatusMessage = E_STATUS_MSG_COMPONENT_WIRE_SELECTED;break;
													}

													if(!(is_symbol_editor && PCSchematicObject->m_type != E_WIRE_COMPONENT))
													{
														draw_wire_flag = true; 
													}	

													CGlobalStatusMessage = E_STATUS_MSG_PIN_SELECTED;

													break;
												}								  
											}
											else SetSelectPin(id, pin_id, true);break;

					case E_SCHEMATIC_PIN_LABEL: SetSelectPinLabel(id, pin_id, label_id, true, true);break;	
				}
			}
			else
			{
				if(CSchematicComponentInfo.type == E_SCHEMATIC_OBJECT ||
				   CSchematicComponentInfo.type == E_SCHEMATIC_WIRE)
				{	 
			//		ResetSelectAll();
					SetSelect(id, false);// Clear labels and pins selected
				}
				else
				{
					
					switch(CSchematicComponentInfo.type)
					{	
						case E_SCHEMATIC_LABEL: if(!PCSchematicObject->GetSelectLabel(label_id))
												{
													ResetSelectAll(true);
													SetSelectLabel(id, label_id, true);
												}
												else SetSelectLabel(id, label_id, true);break;	

						case E_SCHEMATIC_PIN:	if(!is_pin_moveable)
												{
													if(!waveform_corner) 
													{
														if(is_symbol_editor && PCSchematicObject->m_type == E_WIRE_COMPONENT) 
														{
															SetSelect(id, false); CGlobalStatusMessage = E_STATUS_MSG_COMPONENT_WIRE_SELECTED;break;
														}
														if(!(is_symbol_editor && PCSchematicObject->m_type != E_WIRE_COMPONENT))
														{
															draw_wire_flag = true; 
														}	

														CGlobalStatusMessage = E_STATUS_MSG_PIN_SELECTED;

														break;												
													}
												}
												else SetSelectPin(id, pin_id, true);break;

						case E_SCHEMATIC_PIN_LABEL: if(!PCSchematicObject->GetSelectPinLabel(pin_id, label_id))
													{
														ResetSelectAll(true);
														SetSelectPinLabel(id, pin_id, label_id, true);
													}
													else SetSelectPinLabel(id, pin_id, label_id, true);break;	

					}
				}
			}
	}
	

	if(draw_wire_flag) return WaitingToDrawWireLBDown(0, CMousePosition);

/*	if(waveform_corner) 
	{
		PCMLastOutlinedComponent = PCSchematicObject;

		return SizingWaveformWindowLBDown(mouse_flags, CMousePosition);
	}*/

	if(!GraphicsSelected()) return E_GRAPHICS_MANAGER_STATE_IDLE;

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}

void TCSchematicManager::DisplayModelAndSymbol(int id)
{
	if(is_symbol_editor) return;
	if(is_symbol_viewer) return;
	if(id < 0) return;
	if(!(id < CMSchematicManagerData.CGraphicList.GetSize())) return;

	TCSchematicObject *PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	CString CFileName, CModelName;

	CFileName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath + PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CModelName = PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;
	
	CModelSymbolTab.DisplayModel(CFileName, CModelName, false);

	CFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CFilePath + PCSchematicObject->CMSchematicObjectData.CSymbolData.CFileName;

	CModelName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CName;

	CModelSymbolTab.DisplaySymbol(CFileName, CModelName, false, PCSchematicObject->CMSchematicObjectData.type);
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::IdleOnCancel(void)
{
	ResetSelectAll(true);

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsSelectedOnCancel(void)
{
	ResetSelectAll(true);

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsMovingOnCancel(void)
{
	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

	
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SelectRegionOnCancel(void)
{
	return E_GRAPHICS_MANAGER_STATE_IDLE;
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotGraphicOnCancel(void)
{
	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
	{
		if(PCMLastCreatedGraphic) PCMLastCreatedGraphic->EndMoveTo();
	}

	DeleteSelectedGraphics();	

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotClipboardOnCancel(void)
{
	DeleteSelectedGraphics();

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsMovingStateLBDown(UINT mouse_flags, CPoint CMousePosition)
{

	// This will occur when graphic id draged of screen when button goes up


	return GraphicsSelectedStateLBDown(mouse_flags, CMousePosition);
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SelectRegionStateLBDown(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;

	// This will occur when mouse is draged of screen when button goes up

	return SelectRegionStateLBUp(nFlags, CMousePosition);

}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotGraphicStateLBDown(UINT nFlags, CPoint CMousePosition)
{
	TCSchematicObject *PCSchematicObject = NULL;
	nFlags;
	int id = 0;

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CPoint CLocation;

	int p;

	bool hyde_labels = !!GCSuperSpiceGlobalData.CDrawData.hyde_labels;

	for(p = 0; p < count; p++) // Find id and make another copy
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject) continue;

		if(!PCSchematicObject->m_selected) continue;

		id = p;
		
		CPoint CGraphicPosition = (CPoint)(CMousePosition - PCSchematicObject->GetMouseOffset());
		PCSchematicObject->MoveTo(PCViewDC, CGraphicPosition, true, hyde_labels);			
		PCSchematicObject->Clear(PCViewDC, hyde_labels);
		PCSchematicObject->ResetSelect();
		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation, false/*hyde_labels*/);

		if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
		{
			PCSchematicObject->EndMoveTo();
		}

		break;		
	}

	if(PCSchematicObject)
	{
		int type = PCSchematicObject->m_type;
//
//	Dynamic update of net name for grounds and connectors

		if(type == E_GROUND || type == E_PAGE_CONNECTER_INPUT ||
		   type == E_PAGE_CONNECTER_OUTPUT || type == E_PAGE_CONNECTER_BIDIRECTIONAL ||
		   type == E_SUBCIRCUIT_PIN_CONNECTER)
		{
			UpdateNetNamesFromPinNames(id, 0);//Pin 0
		}
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	InsertIntoWire(PCSchematicObject);

	if(PCMLastCreatedGraphic)
	if(PCMLastCreatedGraphic->m_type == E_TEST_MARKER) 
	{
		AfxGetApp()->BeginWaitCursor();

		NameAllTestPoints();

		CTestPointData.CNew		= PCMLastCreatedGraphic->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
		CTestPointData.new_type = PCMLastCreatedGraphic->CMSchematicObjectData.version;
		CTestPointData.COld = "";
		CTestPointData.update_graph_views = true;
		CTestPointData.CNew.MakeLower();// spice is lower case;
		ChangeWaveform(CTestPointData);
		CTestPointData.version = PCMLastCreatedGraphic->CMSchematicObjectData.version;

		PCMLastCreatedGraphic->ResetSelect();

		DrawAll();

		AfxGetApp()->EndWaitCursor();
	}


	p = CreateGraphic(PCSchematicObject->CMSchematicObjectData);

	if(p < 0) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CMSchematicManagerData.CGraphicList.GetAt(p)->SetSelect();
	
	short version = PCSchematicObject->CMSchematicObjectData.version;

	if(PCSchematicObject->m_type == E_TEST_MARKER || version  || PCSchematicObject->m_type == E_SUBCIRCUIT_PIN_CONNECTER) 
	{
		//stops last testpoint being deleted on cancel

		if(!DoSpecialComponentProccessing(CMSchematicManagerData.CGraphicList.GetAt(p), version))
		{
			AfxMessageBox(IDS_ERR_FAILED_SYMBOLCREATE);

			DeleteSelectedGraphics();

			return E_GRAPHICS_MANAGER_STATE_IDLE;
		}
	}
	
	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
	{
		PCMLastCreatedGraphic->StartMoveTo();
	}

	PasteGraphic(p, CMousePosition, hyde_labels);

	return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotClipboardLBDown(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	MoveGraphics(CMousePosition, false, true, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels); // Snap to grid is true

	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
	{
		EndMoveTo();
	}
	
	//Now try and insert last clibord graphic into wires
	TCSchematicObject	**PCSchematicObjectPtr;
	TCSchematicObject *PCSchematicObject;
	int count = CMSchematicManagerData.CGraphicList.GetSize();	

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(int p = 0; p < count; p++)
	{
		if(!(*PCSchematicObjectPtr)->m_selected) {PCSchematicObjectPtr++;continue;}

		PCSchematicObject = *PCSchematicObjectPtr;
		
		if(PCSchematicObject->m_type)
		if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE) {PCSchematicObjectPtr++;continue;}

		InsertIntoWire(PCSchematicObject);

		break;
	}

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD; // keep pasting
}
//////////////////////////////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SizingWaveformWindowLBDown(UINT nFlags, CPoint CMousePosition)
{
	nFlags;

	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	if(!PCMLastOutlinedComponent) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(PCMLastOutlinedComponent->m_type != E_WAVEFORM_COMPONENT) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint CLocation = PCMLastOutlinedComponent->CMLocation;

	CPoint CViewPortOrigin = CMSchematicManagerData.CViewPortOrigin;

	CLocation += CViewPortOrigin;

	DrawInitialSelectionBox(PCViewDC, CLocation);

	DrawSelectionBox(PCViewDC, CMousePosition);

	return E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SizingWaveformWindowMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	nFlags;

	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_IDLE;

	DrawSelectionBox(PCViewDC, CMousePosition);

	return E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SizingWaveformWindowLBUp(UINT nFlags, CPoint CMousePosition)
{
	nFlags;

	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	if(!PCMLastOutlinedComponent) return E_GRAPHICS_MANAGER_STATE_IDLE;

	if(PCMLastOutlinedComponent->m_type != E_WAVEFORM_COMPONENT) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CancelSelectionBox(PCViewDC); 

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CPoint CLocation = PCMLastOutlinedComponent->CMLocation;

	CPoint CobjectLocation = CLocation;

	CLocation += CMSchematicManagerData.CViewPortOrigin;

	if(CMousePosition.x < CLocation.x) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(CMousePosition.y < CLocation.y) return E_GRAPHICS_MANAGER_STATE_IDLE;

	unsigned short width = (unsigned short)((CMousePosition.x - CLocation.x)/CMSchematicManagerData.zoom);
	unsigned short height = (unsigned short)((CMousePosition.y - CLocation.y)/CMSchematicManagerData.zoom);

// change size via zoom 

	PCMLastOutlinedComponent->CMSchematicObjectData.width  = width; 
	PCMLastOutlinedComponent->CMSchematicObjectData.height = height;

	PCMLastOutlinedComponent->Zoom(CMSchematicManagerData.zoom);// recreates with new size;

//	PCMLastOutlinedComponent->ReLabelAxis();// a bit of a cludge

	PCMLastOutlinedComponent->Paste(PCViewDC, CobjectLocation);

	PCMLastOutlinedComponent = NULL; //cancels sizeing pointer

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	DrawAll();

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}
///////////////////////////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::IdleStateLBUp( UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;

	return E_GRAPHICS_MANAGER_STATE_IDLE; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsSelectedStateLBUp(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsMovingStateLBUp(UINT mouse_flags, CPoint CMousePosition)
{
	CMousePosition;
	mouse_flags;
	TCSchematicObject *PCSchematicObject, *PCLastSchematicObject = NULL;
	TCSchematicObject *PCTestPointSchematicObject = NULL;

										     //unhyde labels
	MoveGraphics(CMousePosition, false, true, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels); // Snap to grid is true

	bool flag = false;

	CTestPointData.update_graph_views = false;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++) 
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject) continue;

		PCSchematicObject->UpdateLableAndPinLocations();

		if(PCSchematicObject->m_selected)
		{
			if(PCSchematicObject->m_type == E_WIRE_COMPONENT)
			{
				flag = true;
			}
			if(PCSchematicObject->m_type == E_TEST_MARKER) 
			{
				PCTestPointSchematicObject = PCSchematicObject;// dont support multyple testpoint placings
				
				PCTestPointSchematicObject->ResetSelect();

				CTestPointData.COld		= PCTestPointSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
				CTestPointData.old_type = PCTestPointSchematicObject->CMSchematicObjectData.version;

				CTestPointData.update_graph_views = true;
			}

			if(PCSchematicObject->m_type)
			if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE) continue;

			PCLastSchematicObject = PCSchematicObject;
		}
	}

	UpdateSchematicObjectDataBase();

	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
	{
		EndMoveTo();
	}

	if(GCSuperSpiceGlobalData.CDrawData.is_rubber_band_on && !is_symbol_editor)
		EndRubberBanding();

	if(flag)
	{
		JoinUpAllWires();
		SplitUpAllWires();
	}
//	else
	{
		DisplayAllConnectionDots();
	}

	if(CTestPointData.update_graph_views) 
	{
		AfxGetApp()->BeginWaitCursor();

		NameAllTestPoints();

		CTestPointData.CNew		= PCTestPointSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
		CTestPointData.new_type = PCTestPointSchematicObject->CMSchematicObjectData.version;

		CTestPointData.CNew.MakeLower();// spice is lower case;
		CTestPointData.COld.MakeLower();
		CTestPointData.version = PCTestPointSchematicObject->CMSchematicObjectData.version;

		ChangeWaveform(CTestPointData);// remove last waveform and replace with new one

		if(CTestPointData.update_graph_views) AfxGetApp()->EndWaitCursor();
	}

	InsertIntoWire(PCLastSchematicObject);
	
	DrawAll();

	if(CTestPointData.update_graph_views) AfxGetApp()->EndWaitCursor();

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SelectRegionStateLBUp(UINT mouse_flags, CPoint CMousePosition)
{
	mouse_flags;
	CMousePosition;

	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	if(!CMSchematicManagerData.PCView)  return E_GRAPHICS_MANAGER_STATE_IDLE;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC)  return E_GRAPHICS_MANAGER_STATE_IDLE;

	CancelSelectionBox(PCViewDC); 

	if(GraphicsSelected()) 
	{
		CGlobalStatusMessage = E_STATUS_MSG_SELECTION_MADE;

		CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

		return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
	}
	
	TCSchematicComponentInfo CSchematicComponentInfo = InspectSchematicObject(CMousePosition, false);

	int id	= CSchematicComponentInfo.id;

	if(!(id < 0))
	{
		TCSchematicObject *PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

		if(CSchematicComponentInfo.type == E_WAVEFORM_OBJECT_SCREEN)
		{
			if(PCViewDC)
			{
				CRect COutline = CMDrawSelectionRegion.GetSelectionBox();

				COutline -= CMSchematicManagerData.CViewPortOrigin;

				CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

				PCSchematicObject->WaveFormZoom(PCViewDC, COutline);

				CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

				DrawAll();// added to cleanup things
			}
		}
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
	
	CGlobalStatusMessage = E_STATUS_MSG_IDLE;

//	DrawAll();

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotGraphicStateLBUp(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	MoveGraphics(CMousePosition, false, true, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);

	return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotClipboardLBUp(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;
	
	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::IdleStateMouseMoved(UINT nFlags, CPoint CMousePosition)
{
 
	if(!(nFlags & MK_LBUTTON)) 
	{
		fm_select_region = false;			// select region attempt canceled 

		OutlineGraphics(CMousePosition); // Dynamic component highlighting

		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}

	CDC *PCViewDC = NULL;

	if(fm_select_region) 
	{
		fm_select_region = false;

		if(CMSchematicManagerData.PCView)
			if(!IsBadWindowHandle(CMSchematicManagerData.PCView)) 
			{

				CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

				if(PCViewDC) DrawInitialSelectionBox(PCViewDC, CMousePosition);
			}
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return E_GRAPHICS_MANAGER_STATE_SELECT_REGION; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::WaveformOnClickStateLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_IDLE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicComponentInfo CSchematicComponentInfo;
	TCSchematicObject *PCSchematicObject = NULL;

	bool fine = false;

	CTestPointData.update_graph_views = false;

	// first look for pins
	CSchematicComponentInfo = InspectSchematicObject(CMousePosition, fine, true, true);// ignore wire pins, look for pins (currents) first

	int id			= CSchematicComponentInfo.id;
	int pin_id		= CSchematicComponentInfo.pin_id;
	
	if(id < 0) // now look for wires
	{
		CSchematicComponentInfo = InspectSchematicObject(CMousePosition, fine, true, false);// ignore wire pins, now look for wires look

		id			= CSchematicComponentInfo.id;
		pin_id		= CSchematicComponentInfo.pin_id;

		if(id < 0) return E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;
	}
	
	CTestPointData = GCSuperSpiceGlobalData.CConfigData.CTestPointData;

	CTestPointData.new_index = -1;
	CTestPointData.old_index = -1;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	CString CText;
	CString CParentRefDes;

	if(PCWaveformDataRuns)// convieniant, contains the
	{
		if(PCWaveformDataRuns->PCDoc)
		{
			CParentRefDes = PCWaveformDataRuns->PCDoc->CParentRefDes;
		}
		else
		{
			ASSERT(0);// program fuckup
		}
	}

	CString CTextTemp, CTemp;
	int index;

	CString CAppend, CPinNumber;
	int bracket_index;

	switch(CSchematicComponentInfo.type)
	{
		case E_SCHEMATIC_WIRE: CText = PCSchematicObject->GetLabel(E_WIRE_NET_NAME); 
			
							if(CParentRefDes != "") 
							{
								if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
								{
									CText = CParentRefDes + ':' + CText;
								}
								else
								{
									CText +=  ':' + CParentRefDes;
								}
							}

							break;	
	
		case E_SCHEMATIC_PIN: 
		case E_SCHEMATIC_OBJECT:

			{
				CArray <CString, CString> CDeviceNodes;// use existing code to get device current name

				PCSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CDeviceNodes);

				if(CSchematicComponentInfo.type == E_SCHEMATIC_OBJECT)// get power
				{
					int model_power_type = GCSuperSpiceDataBase.GetSpiceModelType(&PCSchematicObject->CMSchematicObjectData);

					if(!(model_power_type < 0))
						pin_id = GCSuperSpiceDataBase.CSpiceNodeParameterStartIndex[model_power_type] - 1;

					if(!pin_id)// subckts, no power available
					{
						CTestPointData.update_graph_views = false;

						return E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;
					}
				}

				if(!(pin_id < CDeviceNodes.GetSize()) || pin_id < 0)
				{
					CTestPointData.update_graph_views = false;

					return E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;
				}

				CText = CDeviceNodes[pin_id];

				CAppend = ':';

				CPinNumber.Format("%d", pin_id);

				bracket_index = CText.Find('[');

				if((PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
				   PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) && CParentRefDes == "")// .subckt
				{
					CAppend += GSubCktCurrentPinStr + CPinNumber;

					CText.Insert(bracket_index, CAppend);
				}

				if(CParentRefDes != "") 
				{
					if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
					{
						if(!(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
								PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC)) CText = CParentRefDes + CAppend + CText;
						else
						{
							CText = CParentRefDes + CAppend + CText;
				
							bracket_index = CText.Find('[');

							CAppend += GSubCktCurrentPinStr + CPinNumber;

							CText.Insert(bracket_index, CAppend);
						}
					}
					else
					{
						CTextTemp	= CText;
						CTemp		= CText;

						index = CTemp.Find('[');

						CTemp = CTemp.Left(index);

						CTextTemp.Replace(CTemp, "");

						if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
						   PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC)  
						{
							CText = CTemp + CAppend + CParentRefDes;

							CAppend += GSubCktCurrentPinStr + CPinNumber;

							CText += CAppend;
						}
						else
						{
							CText = CTemp + CAppend + CParentRefDes;
						}

						CText += CTextTemp;
					}
				}

				break;
			}
		default: 
			{
				CTestPointData.update_graph_views = false;

				return E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;
			}
	}

	//if probe mode, plot new, delete old unless alt or shift are on, whenc signal is added/deleted to
	if(GCSuperSpiceGlobalData.CDrawData.probe_mode)
	{
		nFlags &= ~MK_ALT; // clear possible false alt

		if(nFlags & MK_EXTRA_ALT_1) nFlags |= MK_ALT;//detect real alt

		if(!(nFlags & MK_SHIFT) && !(nFlags & MK_ALT))
		{
			ClearAllWaveforms();

			CTestPointData.clear_waveforms = true;//passed on to graphics
		}

		nFlags |= MK_ALT;//force an alt
	}
	else CTestPointData.clear_waveforms = false;

	if(nFlags & MK_SHIFT)// shift deletes, non-shift adds
	{
		CTestPointData.update_graph_views = true;
		CTestPointData.COld = CText;
		CTestPointData.CNew = "";
	}

	else if(nFlags & MK_ALT)
	{
		CTestPointData.update_graph_views = true;
		CTestPointData.CNew = CText;
		CTestPointData.COld = "";
	}

	CTestPointData.CNew.MakeLower();
	CTestPointData.COld.MakeLower();

	AfxGetApp()->BeginWaitCursor();

	ChangeWaveform(CTestPointData);

	AfxGetApp()->EndWaitCursor();

	EraseComponentOutline();

	DrawAll();

	return E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsSelectedStateMouseMoved(UINT mouse_flags, CPoint CMousePosition)
{
	OutlineGraphics(CMousePosition);

	if(!(mouse_flags & MK_LBUTTON)) return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED; // If no draging

	bool fine = false;
//	if(mouse_flags & MK_SHIFT) fine = true;

	int id = FindGraphic(CMousePosition, fine);

	if(id < 0) 
	{
		if(m_component_is_outlined) EraseComponentOutline();

		ResetSelectAll(true);

		if(fm_select_region) 
		{
			fm_select_region = false;

			if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;
			if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;

			CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

			if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;

			DrawInitialSelectionBox(PCViewDC, CMousePosition);

			if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

			return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;
		}

		return E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING;	
	}

	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
	{
		StartMoveTo();
	}

	InitaliseAllGraphicLocations(CMousePosition);

	if(GCSuperSpiceGlobalData.CDrawData.is_rubber_band_on && !is_symbol_editor)
			StartRubberBanding();

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING;
}
// Fucking M.S. with their 16 bit GDI
void  TCSchematicManager::DeleteBitmapBackgroundLabels(void)
{
	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)// Check for any components going off screen
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
	
		if(!PCSchematicObject->m_selected) continue;

		PCSchematicObject->DeleteBitmapBackgroundLabels();
	}
}
void  TCSchematicManager::CreateBitmapBackgroundLabels(void)
{
	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)// Check for any components going off screen
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);
	
		if(!PCSchematicObject->m_selected) continue;

		PCSchematicObject->CreateBitmapBackgroundLabels();
	}
}

void TCSchematicManager::StartMoveTo(void)
{
	register TCSchematicObject	**PCSchematicObjectPtr; 
	register TCSchematicObject *PCSchematicObject;
	register int	p;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();	

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	ClearSelected();// prepare to hyde text labels on moving

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr++;

		if(!(PCSchematicObject->m_selected | PCSchematicObject->m_highlighted))continue;
		
//		PCSchematicObject->Clear(PCViewDC);
		PCSchematicObject->StartMoveTo();
		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation, true);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

//	DrawAll();
//	RePasteSelected(true);//redraw with labels hidden
}

void TCSchematicManager::EndMoveTo(void)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register TCSchematicObject *PCSchematicObject;
	register int	p;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();	

	ClearSelected(true);// do not clear labels// shouldnot work now

//	RePasteSelected(false);//redraw with labels unhidden

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr++;

		if(!(PCSchematicObject->m_selected | PCSchematicObject->m_highlighted))continue;

//		PCSchematicObject->Clear(PCViewDC, true);
		PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		PCSchematicObject->EndMoveTo();
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

//	DrawAll();
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsMovingStateMouseMoved(UINT mouse_flags, CPoint CMousePosition)
{

	if(!(mouse_flags & MK_LBUTTON)) return E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING;
	
	TCSchematicObject *PCSchematicObject;
	CPoint CLocation;
	
	if(m_component_is_outlined)EraseComponentOutline();
									    //hyde labels
	MoveGraphics(CMousePosition, false, false, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);	// Dont snapt to grid is false unless asked

	if(GCSuperSpiceGlobalData.CDrawData.is_rubber_band_on && !is_symbol_editor)
			ContinueRubberBanding();// dont need mouse, data is in selected objects

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	bool flag = false;

	for(int p = 0; p < count; p++)// Check for any components going off screen
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->GetSelect()) continue;

		PCSchematicObject->GetLocation(&CLocation);

		if(CLocation.x < 1 || CLocation.y < 1)//if(CLocation.x < maxx || CLocation.y > maxy); to do
		{
			flag = true;

			break;
		}
	}

	if(flag) MoveGraphics(CMLastMousePosition, false, false, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);	// Dont snapt to grid is false unless asked
	else CMLastMousePosition = CMousePosition;

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING;
 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SelectRegionStateMouseMoved(UINT mouse_flags, CPoint CMousePosition)
{
	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;

	if(!(mouse_flags & MK_LBUTTON)) // This happens if mouse goes off screen before button up
	{
		return SelectRegionStateLBUp(mouse_flags, CMousePosition);
	//	if(GraphicsSelected()) return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
	
	//	return E_GRAPHICS_MANAGER_STATE_IDLE;
	}

	CRect CSelectionBox = CMDrawSelectionRegion.GetPreSelectionBox(CMousePosition);

	CPoint CFirstMousePosition = CMDrawSelectionRegion.GetFirstMousePosition();

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;

	CancelSelectionBox(PCViewDC); // This is for clearing to work correctly

	CPoint CViewPortOrigin = CMSchematicManagerData.CViewPortOrigin;

	CSelectionBox.top		-= CViewPortOrigin.y;
	CSelectionBox.left		-= CViewPortOrigin.x;
	CSelectionBox.bottom	-= CViewPortOrigin.y;
	CSelectionBox.right		-= CViewPortOrigin.x;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);
	TCSchematicComponentInfo CSchematicComponentInfo;

	TCSchematicObject *PCSchematicObject;
	
	int all_enclosed = GCSuperSpiceGlobalData.CDrawData.all_enclosed;

	if(mouse_flags & MK_CONTROL) all_enclosed = !all_enclosed;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->IsThere(&CSchematicComponentInfo, CSelectionBox, !!all_enclosed, false)) 
		{
			if(PCSchematicObject->m_selected || PCSchematicObject->m_highlighted) ResetSelect(p, false);

			continue;
		}

		CSchematicComponentInfo.id = p;
		int label_id	= CSchematicComponentInfo.label_id;
//		int pin_id		= CSchematicComponentInfo.pin_id;

		switch(CSchematicComponentInfo.type)
		{
			case E_SCHEMATIC_OBJECT: if(!PCSchematicObject->m_selected) SetSelect(p, false); break;
			
			case E_WAVEFORM_OBJECT: if(!PCSchematicObject->m_selected) {SetActiveWaveform(p);SetSelect(p, false);}; break;

			case E_SCHEMATIC_LABEL: 
			{	
				if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
				{
					if(CSchematicComponentInfo.label_id <= E_WAVEFORM_ENABLE)
						SetSelectLabel(p, label_id, true, false);
					
					break;
				}
				else SetSelectLabel(p, label_id, true, false);break;
			}

			case E_SCHEMATIC_TEXT_LABEL: if(!PCSchematicObject->m_selected && !PCSchematicObject->m_highlighted) SetSelect(p, false); break;
			
			case E_SCHEMATIC_WIRE: if(!PCSchematicObject->m_selected) SetSelect(p, false); break;

			case E_WAVEFORM_OBJECT_SCREEN: break;

			default: 
			{
				if(PCSchematicObject->m_selected && !PCSchematicObject->m_highlighted) ResetSelect(p, false);	
			
				continue;
			}
		}
	}

	DrawInitialSelectionBox(PCViewDC, CFirstMousePosition);

	DrawSelectionBox(PCViewDC, CMousePosition);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;
}

void TCSchematicManager::OutlineGraphics(CPoint CMousePosition)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;
	
	bool f_found = false;

	CString CLastMessage;

	register TCSchematicObject	**PCSchematicObjectPtr; 
	register TCSchematicObject *PCSchematicObject = NULL;
	register int	p;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();	

	TCSchematicComponentInfo CSchematicComponentInfo;

	CPoint CPositionTemp = CMSchematicManagerData.CViewPortOrigin;

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	bool position_type = false;
	bool waveform_found = false;
	
	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr++;

		if(PCSchematicObject->CMSchematicObjectData.type == E_WIRE_COMPONENT) continue;

		if(PCSchematicObject->IsThere(&CSchematicComponentInfo, CMousePosition)) 
		{
			CMLastOutlinedMousePosition = CMousePosition + CPositionTemp;
			m_last_outline_property = CSchematicComponentInfo.type;

			if(PCSchematicObject->m_property == E_WAVEFORM_OBJECT) 
			{
				if(CSchematicComponentInfo.type == E_SCHEMATIC_LABEL)
					if(CSchematicComponentInfo.label_id > E_WAVEFORM_ENABLE) continue;

				CLastMessage = CGlobalStatusMessage;

				waveform_found = UpdateFloatingCursor(PCSchematicObject, CMousePosition);

				position_type = true;

				if(waveform_found)
				{
					if(CLastMessage != CGlobalStatusMessage)
					{
						if(::IsWindow(CMTipWindow.m_hWnd)) CMTipWindow.HideTipWindow();

						DisplayTipWindow(CMLastOutlinedMousePosition, CGlobalStatusMessage, position_type);
					}
				}
				else
				{
					if(::IsWindow(CMTipWindow.m_hWnd)) 
					{	
						CMTipWindow.HideTipWindow();
					}
				}

			}
			else position_type = false;

			f_found = true;

			break;
		}
	}

	if(f_found) 
	{
		CLastMessage = CGlobalStatusMessage;

		DisplayOutlineComponentStatus(PCSchematicObject, CSchematicComponentInfo, waveform_found);

		if(CLastMessage != CGlobalStatusMessage)
			if(!(PCSchematicObject->m_property == E_WAVEFORM_OBJECT && !waveform_found))
				DisplayTipWindow(CMLastOutlinedMousePosition, CGlobalStatusMessage, position_type);//CGlobalStatusMessage stufed by last function

		OutlineComponent(PCSchematicObject, CSchematicComponentInfo);
		
		return;
	}
	
	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr++;

		if(PCSchematicObject->CMSchematicObjectData.type != E_WIRE_COMPONENT) continue;

		if(PCSchematicObject->IsThere(&CSchematicComponentInfo, CMousePosition)) 
		{
			CMLastOutlinedMousePosition = CMousePosition + CPositionTemp;
			m_last_outline_property = CSchematicComponentInfo.type;

			if(PCSchematicObject->m_property == E_WAVEFORM_OBJECT) 
			{
				if(CSchematicComponentInfo.type == E_SCHEMATIC_LABEL)
					if(CSchematicComponentInfo.label_id > E_WAVEFORM_ENABLE) continue;

				CLastMessage = CGlobalStatusMessage;

				waveform_found = UpdateFloatingCursor(PCSchematicObject, CMousePosition);

				position_type = true;

				if(waveform_found)
				{
					if(CLastMessage != CGlobalStatusMessage)
						DisplayTipWindow(CMLastOutlinedMousePosition, CGlobalStatusMessage, position_type);
				}
				else
				{
					if(::IsWindow(CMTipWindow.m_hWnd)) 
					{	
						CMTipWindow.HideTipWindow();						
					}
				}

			}
			else position_type = false;

			f_found = true;

			break;
		}
	}

	if(f_found) 
	{
		CLastMessage = CGlobalStatusMessage;

		DisplayOutlineComponentStatus(PCSchematicObject, CSchematicComponentInfo, waveform_found);

		if(CLastMessage != CGlobalStatusMessage)
			if(!(PCSchematicObject->m_property == E_WAVEFORM_OBJECT && !waveform_found))
			{
				//if(::IsWindow(CMTipWindow.m_hWnd)) CMTipWindow.HideTipWindow();

				DisplayTipWindow(CMLastOutlinedMousePosition, CGlobalStatusMessage, position_type);//CGlobalStatusMessage stufed by last function
			}

		OutlineComponent(PCSchematicObject, CSchematicComponentInfo);
		
		return;
	}

	if(m_component_is_outlined) EraseComponentOutline();

	if(!f_found)
	{
		CGlobalStatusMessage = "";

		if(::IsWindow(CMTipWindow.m_hWnd)) 
		{		
			CMTipWindow.HideTipWindow();
		}
	}
}

void TCSchematicManager::DisplayOutlineComponentStatus(TCSchematicObject *PCSchematicObject, TCSchematicComponentInfo &CSchematicComponentInfo, bool waveform_found)
{
	if(!PCSchematicObject) return;

	CString CText;

	CGlobalStatusMessage = ""; //30th July 2017

	if(is_symbol_editor)
	{
		if(PCSchematicObject->m_type == E_SYMBOL_POINTING_UP_PIN_COMPONENT || PCSchematicObject->m_type == E_SYMBOL_POINTING_DOWN_PIN_COMPONENT ||
		   PCSchematicObject->m_type == E_SYMBOL_POINTING_LEFT_PIN_COMPONENT || PCSchematicObject->m_type == E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT)
		{
			CGlobalStatusMessage = "Pin ID=";
			CGlobalStatusMessage += PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);

			CGlobalStatusMessage += " Pin Name=" + PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NAME);

			CGlobalStatusMessage += " Pin Number=" + PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NUMBER);

			return;
		}

		return;
	}

	if(PCSchematicObject->m_type == E_WIRE_COMPONENT)
	{
		CGlobalStatusMessage = PCSchematicObject->GetLabel(E_WIRE_NET_NAME);

		CGlobalStatusMessage += " : V=";

		CGlobalStatusMessage += PCSchematicObject->GetLabel(E_WIRE_NET_VOLTAGE);

		return;
	}
	else if(CSchematicComponentInfo.type == E_SCHEMATIC_PIN)
	{
		CString CMessage;

		CGlobalStatusMessage = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
		{
			CGlobalStatusMessage += ": Resize graph";

			return;
		}

		CMessage.Format("%d", CSchematicComponentInfo.pin_id);

		CGlobalStatusMessage += ": ID=" + CMessage;
			
		CGlobalStatusMessage +=" Name=";

		// Removed display of pin number 25th Dec 2016
		CGlobalStatusMessage += PCSchematicObject->GetPinLabel(CSchematicComponentInfo.pin_id, E_COMPONENT_PIN_NAME);

//		CGlobalStatusMessage +=" Num=";

//		CGlobalStatusMessage += PCSchematicObject->GetPinLabel(CSchematicComponentInfo.pin_id, E_COMPONENT_PIN_NUMBER);

		CGlobalStatusMessage += " V=";

		CGlobalStatusMessage += PCSchematicObject->GetPinLabel(CSchematicComponentInfo.pin_id, E_COMPONENT_PIN_VOLTAGE);
		
		CGlobalStatusMessage += " I=";

		CGlobalStatusMessage += PCSchematicObject->GetPinLabel(CSchematicComponentInfo.pin_id, E_COMPONENT_PIN_CURENT);

		return;
	}
	else if(CSchematicComponentInfo.type == E_SCHEMATIC_PIN_LABEL && PCSchematicObject->m_type != E_WAVEFORM_COMPONENT)
	{
		CGlobalStatusMessage = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		CGlobalStatusMessage += ": Pin name: '" + PCSchematicObject->GetPinLabel(CSchematicComponentInfo.pin_id, E_COMPONENT_PIN_NAME) + "'";

		switch(CSchematicComponentInfo.label_id)
		{
			case E_COMPONENT_PIN_NAME: CText = "Name label"; break;
			case E_COMPONENT_PIN_NUMBER:CText = "Number label"; break;
			case E_COMPONENT_PIN_VOLTAGE:CText = "Voltage label"; break;
			case E_COMPONENT_PIN_CURENT:CText = "Current label"; break;
			case E_COMPONENT_PIN_NET_NAME:CText = "Net name label"; break;
		}

		CGlobalStatusMessage += " : " + CText;

		CGlobalStatusMessage += "=" + PCSchematicObject->GetPinLabel(CSchematicComponentInfo.pin_id, CSchematicComponentInfo.label_id);
	}
	else if(CSchematicComponentInfo.type == E_SCHEMATIC_LABEL)
	{
		CGlobalStatusMessage = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		switch(CSchematicComponentInfo.label_id)
		{
			case E_COMPONENT_SYMBOL_NAME: CText = ": Component symbol name"; break;
			case E_COMPONENT_SPICE_MODEL_NAME:CText = ": Spice model name"; break;
			case E_COMPONENT_VALUE:CText = ": Component value"; break;
			case E_COMPONENT_DESIGNATOR:CText = ": Referance designator"; break;
		}

		CGlobalStatusMessage += " " + CText;

		CGlobalStatusMessage += "=" + PCSchematicObject->GetLabel(CSchematicComponentInfo.label_id);
	}
	else if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT)
	{
		if(!waveform_found)
		{
			CGlobalStatusMessage = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

			if(CSchematicComponentInfo.type == E_WAVEFORM_OBJECT)//top bar
			{
				CGlobalStatusMessage += ": ";

				CGlobalStatusMessage += "Select to delete graph, grab to move graph";
			}
		}

		return;
	}
		
	else 
	{
		if(PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray.GetSize() <= E_RESERVED_INT_COMPONENT_DATA_MAX)
		{
			double dc_power, tran_power;

			dc_power = PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER];

			CGlobalStatusMessage += " PDC=";

			CGlobalStatusMessage += FloatToMKSString(dc_power);

			CGlobalStatusMessage += "W ";

			if(PCWaveformDataRuns && PCWaveformDataRuns->CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT))
			{
				CGlobalStatusMessage += "\nPTRAN=";

				tran_power = PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER];

				CGlobalStatusMessage += FloatToMKSString(tran_power);

				CGlobalStatusMessage += "W ";

				CCursorData.CSignalNameHeader = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);
				CCursorData.CSignalName.LoadString(IDS_DC_TRAN_POWER_MSG);
				CCursorData.y1 = dc_power;
				CCursorData.y2 = tran_power;

				SetDataCursorBar(CCursorData);
			}

			// 25th Dec 2016
			if(PCWaveformDataRuns && PCWaveformDataRuns->CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_OPERATING_POINT))
			{
				CGlobalStatusMessage += GetOperatingPoints(PCSchematicObject); // 25th Dec 2016
			}
		}

		CGlobalStatusMessage += "\n" + PCSchematicObject->GetLabel(E_COMPONENT_SYMBOL_NAME) +  "\n";

		CGlobalStatusMessage += PCSchematicObject->GetLabel(E_COMPONENT_SPICE_MODEL_NAME);
	}
}

 // 25th Dec 2016, Setup in UpdateOperatingPoints()
CString TCSchematicManager::GetOperatingPoints(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return "";

	int p, count;

	count = PCSchematicObject->CMSchematicObjectData.COpPoints.GetSize();

	CString COpPoints;

	for(p = 0; p < count; p++)
	{
		TCNameValueData &CNameValue = PCSchematicObject->CMSchematicObjectData.COpPoints[p];

		COpPoints += "\n" + CNameValue.CName + '=' + CNameValue.CValue;
	}

	return COpPoints;
}

void TCSchematicManager::OutlineComponent(TCSchematicObject *PCSchematicObject, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	if(m_component_is_outlined) EraseComponentOutline();

	CRect COutline = PCSchematicObject->GetGrabRegion(CSchematicComponentInfo);

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	if(PCSchematicObject->m_type == E_WIRE_COMPONENT)
	{
		if(PCSchematicObject->m_active_line_color != PCSchematicObject->m_line_highlighted_color)
		{
			PCSchematicObject->m_active_line_color = PCSchematicObject->m_line_highlighted_color;
		
			PCSchematicObject->Clear(PCViewDC);
			PCSchematicObject->Paste(PCViewDC, PCSchematicObject->CMLocation);
		}

		if(CSchematicComponentInfo.type != E_SCHEMATIC_LABEL && CSchematicComponentInfo.type != E_SCHEMATIC_PIN)
		{
			CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

			PCMLastOutlinedComponent = PCSchematicObject;

			m_component_is_outlined = true;

			return;
		}
	}

	CMOutlineTopLeft.x = COutline.left - 1;
	CMOutlineTopLeft.y = COutline.top - 1;

	CMOutlineBottomRight.x = COutline.right;
	CMOutlineBottomRight.y = COutline.bottom;

	CMOutlineTopLeft += CMSchematicManagerData.CViewPortOrigin;
	CMOutlineBottomRight += CMSchematicManagerData.CViewPortOrigin;

	CMComponentOutlineRegion.Start(PCViewDC, CMOutlineTopLeft);
	CMComponentOutlineRegion.Continue(PCViewDC, CMOutlineBottomRight);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	PCMLastOutlinedComponent = PCSchematicObject;

	m_component_is_outlined = true;
}

void TCSchematicManager::ReOutlineComponent(TCSchematicObject *PCSchematicObject)
{
	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CMComponentOutlineRegion.Start(PCViewDC, CMOutlineTopLeft);
	CMComponentOutlineRegion.Continue(PCViewDC, CMOutlineBottomRight);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	PCMLastOutlinedComponent = PCSchematicObject;
	m_component_is_outlined = true;
}

void TCSchematicManager::EraseComponentOutline(void)
{
	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();
	
	if(!PCViewDC) return;

	if(!m_component_is_outlined) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CMComponentOutlineRegion.Delete(PCViewDC);

	if(PCMLastOutlinedComponent)// unhighlight wire/line
	if(IsBadCodePtr((FARPROC)PCMLastOutlinedComponent))
	{
		PCMLastOutlinedComponent = NULL;
	}
	if(PCMLastOutlinedComponent)
	if(PCMLastOutlinedComponent->m_type == E_WIRE_COMPONENT)
	{			
		if(PCMLastOutlinedComponent->m_selected)
			PCMLastOutlinedComponent->m_active_line_color = PCMLastOutlinedComponent->m_line_selected_color;
		else
			PCMLastOutlinedComponent->m_active_line_color = PCMLastOutlinedComponent->m_line_color;

		if(PCMLastOutlinedComponent->m_highlighted) 
			PCMLastOutlinedComponent->m_active_line_color = PCMLastOutlinedComponent->m_line_highlighted_color;

		PCMLastOutlinedComponent->Clear(PCViewDC);

		PCMLastOutlinedComponent->Paste(PCViewDC, PCMLastOutlinedComponent->CMLocation);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	PCMLastOutlinedComponent = NULL;
	m_component_is_outlined = false;
}
bool TCSchematicManager::GetGraphicSelectedPosition(CPoint *CPosition)
{
	int count = CMSchematicManagerData.CGraphicList.GetSize();
	CPoint CCenter;
	CRect CGrabLocationRegion;

	for(int p = 0; p < count; p++)
	{
		TCSchematicObject *PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_selected)
		{
			CGrabLocationRegion = PCSchematicObject->CMRectGrabLocationRegion;

			CCenter = PCSchematicObject->CMCenterPoint;

			CPosition->x = CGrabLocationRegion.left + CCenter.x;
			CPosition->y = CGrabLocationRegion.top + CCenter.y;

			return true;
		}
		if(PCSchematicObject->GetLabelOrPinLabelLocation(CPosition))
		{
			return true;
		}
	}

	return false;
}
TCSchematicObject *TCSchematicManager::GetFirstSelectedSchematicComponent(void)
{
	TCSchematicObject *PCSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_selected) continue;

		if(PCSchematicObject->m_property != E_SCHEMATIC_OBJECT) continue;

		return PCSchematicObject;

	}
	return NULL;
}

bool TCSchematicManager::IsComponentOutlined(void)
{
	return m_component_is_outlined;
}
CPoint &TCSchematicManager::GetComponentOutlinePosition(void)
{
	return CMLastOutlinedMousePosition;
}
int TCSchematicManager::GetComponentOutlinedType(void)
{
	if(!PCMLastOutlinedComponent) return false;

	return m_last_outline_property;
}

TCSchematicObject *TCSchematicManager::GetComponentOutlined(void)
{
	return PCMLastOutlinedComponent;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotGraphicStateMouseMoved( UINT mouse_flags, CPoint CMousePosition)
{
	mouse_flags;

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;
	
//	MoveGraphics(CMousePosition, false, false);
	MoveGraphics(CMousePosition, false, false, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);	// Dont snapt to grid is false unless asked

	return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	nFlags;

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

//	MoveGraphics(CMousePosition, false, false);
	MoveGraphics(CMousePosition, false, false, !!GCSuperSpiceGlobalData.CDrawData.hyde_labels);	// Dont snapt to grid is false unless asked

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::WaitingToDrawWireGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData)
{
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_id, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;

	return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::WaitingToDrawWireLBDown(UINT nFlags, CPoint CMousePosition)
{
	nFlags;

	if(!CMSchematicManagerData.PCView) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

	if(m_component_is_outlined) EraseComponentOutline();

	if(nFlags & MK_ALT) 
	{
		WaveformOnClickStateLBDown(nFlags, CMousePosition);

		if(CTestPointData.update_graph_views)// pin or wire found
			return E_GRAPHICS_MANAGER_STATE_IDLE;
	}

	else if(nFlags & MK_SHIFT) 
	{
		WaveformOnClickStateLBDown(nFlags, CMousePosition);

		if(CTestPointData.update_graph_views)// pin or wire found
			return E_GRAPHICS_MANAGER_STATE_IDLE;
	}

	if(m_current_wire_being_drawn >= 0)
	{
		ResetSelect(m_current_wire_being_drawn);
	}

	PCMCurrentWireBeingDrawnObject = new TCSchematicObject; 

	if(!PCMCurrentWireBeingDrawnObject) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

	PCMCurrentWireBeingDrawnObject->is_symbol_editor = is_symbol_editor;
	
	PCMCurrentWireBeingDrawnObject->SetPageId(CMSchematicManagerData.page_id);

	CMSchematicManagerData.CGraphicList.Add(PCMCurrentWireBeingDrawnObject);

	m_current_wire_being_drawn = CMSchematicManagerData.CGraphicList.GetSize() - 1;

	if(m_current_wire_being_drawn < 0)return E_GRAPHICS_MANAGER_STATE_IDLE;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	PCMCurrentWireBeingDrawnObject->SetSelect();

	PCMCurrentWireBeingDrawnObject->StartDrawingLine(PCViewDC, CMousePosition,CMSchematicManagerData.zoom);
	
	PCMCurrentWireBeingDrawnObject->GetLocation(&CCurrentWireAbsoluteLocation);

	MultyplyCPoint(&CCurrentWireAbsoluteLocation, 1/CMSchematicManagerData.zoom);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	CGlobalStatusMessage = E_STATUS_MSG_DRAWING_WIRE;

	return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireLBDblClk(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;
	DrawingWireOnCancel();// Doubleclick always after a single click
							// when new wire started, so cancel it
	// stop drawing current wire, wait to start new wire

	CGlobalStatusMessage = E_STATUS_MSG_WAITING_TO_DRAW_WIRE;

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::WaitingToDrawWireLBUp(UINT nFlags, CPoint CMousePosition)
{
	// can't happen state.
	nFlags;
	CMousePosition;

	CGlobalStatusMessage = E_STATUS_MSG_DRAWING_WIRE;

	return E_GRAPHICS_MANAGER_STATE_IDLE;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::WaitingToDrawWireOnCancel(void)
{
	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData)
{
	DrawingWireOnCancel();
	ResetSelectAll(true);
	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	if(OpenGraphic(CMousePosition, graphic_id, version, CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;
	
	return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireLBDown(UINT nFlags, CPoint CMousePosition)
{
	nFlags;

	CPoint COrginalMousePosition = CMousePosition;

	EraseComponentOutline();

	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
	if(!PCMCurrentWireBeingDrawnObject) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

	if(!PCMCurrentWireBeingDrawnObject) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	PCMCurrentWireBeingDrawnObject->StopDrawingLine(PCViewDC, CMousePosition, is_symbol_editor);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	TCWireInfo CInfo;

	CInfo = PCMCurrentWireBeingDrawnObject->GetWireInfo();

	TCSchematicObject *PCSchematicObjectTemp;

	PCSchematicObjectTemp = IsPinThere(PCMCurrentWireBeingDrawnObject, CMousePosition);

	int dx = CInfo.CStart.x - CInfo.CEnd.x;
	int dy = CInfo.CStart.y - CInfo.CEnd.y;
	
	if(dx || dy)
	{
		ResetSelect(m_current_wire_being_drawn);

		if(!is_symbol_editor)
		{
			PCMCurrentWireBeingDrawnObject = JoinUpWithOtherWires(m_current_wire_being_drawn);

			m_current_wire_being_drawn = FindGraphicId(PCMCurrentWireBeingDrawnObject);

			if(m_current_wire_being_drawn < 0) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

			if(PCMCurrentWireBeingDrawnObject->m_draw_angle == E_VERTICAL || PCMCurrentWireBeingDrawnObject->m_draw_angle == E_HORIZONTAL)
				SplitUpWire(m_current_wire_being_drawn);
		}
	}
	else
	{
		DeleteSelectedGraphics();
	}

	m_last_created_id = CMSchematicManagerData.CGraphicList.GetSize() - 1;

	if(m_last_created_id < 0)
	{
		DrawAll();
		return WaitingToDrawWireLBDown(nFlags, COrginalMousePosition);
	}

	PCMLastCreatedGraphic = CMSchematicManagerData.CGraphicList.GetAt(m_last_created_id);

	if(PCSchematicObjectTemp)//finish wire touch other wire
	{
		DisplayAllConnectionDots();// needs updating
		DrawAll();

		return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
	}

	return WaitingToDrawWireLBDown(nFlags, COrginalMousePosition);
}



TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireLBUp(UINT nFlags, CPoint CMousePosition)
{
	nFlags;
	CMousePosition;

	return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;// this is ignored
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
	nFlags;
//	if(!(nFlags & MK_LBUTTON)) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

	OutlineGraphics(CMousePosition);

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
	if(!PCMCurrentWireBeingDrawnObject) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;

	CMousePosition -= CMSchematicManagerData.CViewPortOrigin;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	PCMCurrentWireBeingDrawnObject->ContinueDrawingLine(PCViewDC, CMousePosition, false);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::WaitingToDrawWireMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
	nFlags;

	OutlineGraphics(CMousePosition);

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireOnCancel(void)
{
	if(m_current_wire_being_drawn < 0) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject;

	if(m_current_wire_being_drawn >= CMSchematicManagerData.CGraphicList.GetSize())
	{
		ASSERT(0);
		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}
	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(m_current_wire_being_drawn);
			
	PCMCurrentWireBeingDrawnObject = NULL;
	
	if(!PCSchematicObject)
	{
		m_current_wire_being_drawn = -1;

		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}
	if(!PCSchematicObject->m_selected)
	{
		m_current_wire_being_drawn = -1;
		PCMCurrentWireBeingDrawnObject = NULL;

		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}
	CMSchematicManagerData.CGraphicList.RemoveAt(m_current_wire_being_drawn);

	if(PCSchematicObject) delete PCSchematicObject;

	m_current_wire_being_drawn = -1;
	PCMCurrentWireBeingDrawnObject = NULL;
	PCMLastOutlinedComponent = NULL;

	JoinUpAllWires();
	SplitUpAllWires();

	DrawAll();
	return E_GRAPHICS_MANAGER_STATE_IDLE;
}

bool TCSchematicManager::TagSameTypeOverlapedWires(int id)
{
	TCSchematicObject *PCSchematicObject, *PCSchematicObjectCheck;
	TCSchematicObject *PCSchematicObjectId;

	TCWireInfo CNewWireInfo;
	TCWireInfo COldWireInfo;
	TCWireInfo CTempWireInfo;
	CRect CTestRect;
	CRect CNewRect;
	CRect COldRect; 
	CRect CTempRect;
	CPoint CTempPoint(0, 0);
	bool flag = false;
	bool flag_overlaped = false;
	bool return_flag = false;

	PCSchematicObjectId = CMSchematicManagerData.CGraphicList.GetAt(id);

	id = FindWireId(PCSchematicObjectId);

	if(id < 0){ASSERT(0); return false;}
	if(id >= CMWireList.CWireTags.GetSize()){ASSERT(0); return false;}

	TCWireTags &CWireTag = CMWireList.CWireTags[id];

	CNewWireInfo = PCSchematicObjectId->GetWireInfo();

	int count = CMWireList.CWireTags.GetSize();

	CWireTag.Info.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMWireList.CWireTags[p].PCSchematicObject;

		if(!PCSchematicObject) continue;

		if(PCSchematicObject->m_draw_angle != E_VERTICAL && PCSchematicObject->m_draw_angle != E_HORIZONTAL) continue;

		COldWireInfo = PCSchematicObject->GetWireInfo();

		if(CTestRect.IntersectRect(CNewWireInfo.CExtent, COldWireInfo.CExtent)) 
		{	//don't rejoin up split wires, only check touching at ends
			if(CNewWireInfo.type == COldWireInfo.type)// only join up h to h, v to v
			{
				flag = false; // do wires touch at ends ?
				if(CNewWireInfo.CStart == COldWireInfo.CStart)
					{CTempPoint = COldWireInfo.CStart; flag = true;}
				if(CNewWireInfo.CEnd == COldWireInfo.CStart)
					{CTempPoint = COldWireInfo.CStart; flag = true;}
				if(CNewWireInfo.CStart == COldWireInfo.CEnd)
					{CTempPoint = COldWireInfo.CEnd; flag = true;}
				if(CNewWireInfo.CEnd == COldWireInfo.CEnd)
					{CTempPoint = COldWireInfo.CEnd; flag = true;}

				if(!flag) // no touching at ends so tag to join them up
				{
					COldWireInfo.id	= p;
					COldWireInfo.split = false;
					COldWireInfo.tagged = true;
					COldWireInfo.PCSchematicObject = PCSchematicObject;
			//		CWireTag.Info.SetAtGrow(p, COldWireInfo);

					CWireTag.Info[p] = COldWireInfo;

					return_flag = true;
				}
				else // wires touch at their ends, is there an intersecting wire
				{
					flag_overlaped = false;

					for(int r = 0; r < count; r++)// to check other type this time
					{
						PCSchematicObjectCheck = CMWireList.CWireTags[r].PCSchematicObject;

						if(!PCSchematicObjectCheck) continue;

						CTempWireInfo = PCSchematicObjectCheck->GetWireInfo();

						if(CNewWireInfo.type != CTempWireInfo.type)
						{
							if(CTempWireInfo.CExtent.PtInRect(CTempPoint)) break;

							continue;
						}

						flag_overlaped = true; break;
					}
					if(flag_overlaped)//no intersecting wire for end touching so join up
					{
						COldWireInfo.id	= p;
						COldWireInfo.split = false;
						COldWireInfo.tagged = true;
						COldWireInfo.PCSchematicObject = PCSchematicObject;
				//		CWireTag.Info.SetAtGrow(p, COldWireInfo);
						CWireTag.Info[p] = COldWireInfo;
						return_flag = true;
					}
					else// intersecting wire so do not joinup
					{
						COldWireInfo.id	= p;
						COldWireInfo.split = true;
						COldWireInfo.tagged = false;
						COldWireInfo.PCSchematicObject = PCSchematicObject;
				//		CWireTag.Info.SetAtGrow(p, COldWireInfo);
						CWireTag.Info[p] = COldWireInfo;
						return_flag = true;
					}
				}
			}	
		}
	}

	return return_flag;
}

bool TCSchematicManager::TagDiffTypeOverlapedWires(int id)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCSchematicObjectId;
	TCWireInfo CNewWireInfo;
	TCWireInfo COldWireInfo;
	CRect CTestRect;
	CRect CNewRect;
	CRect COldRect; 
	CRect CTempRect;
	bool return_flag = false;

	PCSchematicObjectId = CMSchematicManagerData.CGraphicList.GetAt(id);

	id = FindWireId(PCSchematicObjectId);

	if(id < 0){ASSERT(0); return false;}
	if(id >= CMWireList.CWireTags.GetSize()){ASSERT(0); return false;}

	TCWireTags &CWireTag = CMWireList.CWireTags[id];

	CNewWireInfo = PCSchematicObjectId->GetWireInfo();

	int count = CMWireList.CWireTags.GetSize();

	CWireTag.Info.SetSize(count);

	CString CText;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return false;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMWireList.CWireTags[p].PCSchematicObject;

		if(!PCSchematicObject) continue;

		if(PCSchematicObject->m_draw_angle != E_VERTICAL && PCSchematicObject->m_draw_angle != E_HORIZONTAL) continue;

		COldWireInfo = PCSchematicObject->GetWireInfo();

		if(CNewWireInfo.type != COldWireInfo.type) 
		{	// only split up h to v, v to h in tne middle of wires
			// not ends and not crossovers
			if(CTestRect.IntersectRect(CNewWireInfo.CExtent, COldWireInfo.CExtent))
			{
				CNewRect = CNewWireInfo.CExtent;
				COldRect = COldWireInfo.CExtent;

				if(!(CNewWireInfo.CStart == COldWireInfo.CStart ||
					CNewWireInfo.CEnd == COldWireInfo.CEnd || 
					CNewWireInfo.CEnd == COldWireInfo.CStart ||
					CNewWireInfo.CStart == COldWireInfo.CEnd))
				{	
					if(COldRect.PtInRect(CNewWireInfo.CStart))// prior drawn wire needs splitup
					{
						COldWireInfo.id	= p;
						COldWireInfo.tagged = true;//delete old wire
						COldWireInfo.split = true;
						COldWireInfo.CMid = CNewWireInfo.CStart;
						COldWireInfo.PCSchematicObject = PCSchematicObject;
					//	CWireTag.Info.SetAtGrow(p, COldWireInfo);
						CWireTag.Info[p] = COldWireInfo;
						return_flag = true;
						continue;
					}
					if(COldRect.PtInRect(CNewWireInfo.CEnd))// prior drawn wire needs splitup
					{
						COldWireInfo.id	= p;
						COldWireInfo.tagged = true;//delete old wire
						COldWireInfo.split = true;
						COldWireInfo.CMid = CNewWireInfo.CEnd;
						COldWireInfo.PCSchematicObject = PCSchematicObject;
					//	CWireTag.Info.SetAtGrow(p, COldWireInfo);
						CWireTag.Info[p] = COldWireInfo;
						return_flag = true;
						continue;
					}
					if(CNewRect.PtInRect(COldWireInfo.CStart))// current draw wire needs splitup
					{
						CNewWireInfo.id	= p;
						CNewWireInfo.split = true;
						CNewWireInfo.CMid = COldWireInfo.CStart;
						CNewWireInfo.tagged = true;//delete current wire
						CNewWireInfo.PCSchematicObject = PCSchematicObjectId;
					//	CWireTag.Info.SetAtGrow(p, CNewWireInfo);
						CWireTag.Info[p] = CNewWireInfo;
						return_flag = true;
						continue;
					}
					if(CNewRect.PtInRect(COldWireInfo.CEnd))// current draw wire needs splitup
					{
						CNewWireInfo.id	= p;
						CNewWireInfo.split = true;
						CNewWireInfo.CMid = COldWireInfo.CEnd;
						CNewWireInfo.tagged = true;//delete current wire
						CNewWireInfo.PCSchematicObject = PCSchematicObjectId;// mark the wire to be deleted
					//	CWireTag.Info.SetAtGrow(p, CNewWireInfo);
						CWireTag.Info[p] = CNewWireInfo;
						return_flag = true;
					}
				}
				else
				{
//					PCSchematicObjectId->SetLabel(&CDCTemp, E_WIRE_NET_NAME, COldWireInfo.CNetName);
				}
			}
		}
	}
	return return_flag;
}

TCSchematicObject *TCSchematicManager::CreateOneJoinedUpWire(int id)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCSchematicObjectPrefered = NULL;

	TCWireInfo COldWireInfo;
	TCWireInfo CNewWireInfo;
	CPoint CWireStart;
	CPoint CWireEnd;
	bool f_tagged = false;
	CString CText;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

//	if(PCSchematicObject->m_draw_angle != E_VERTICAL && PCSchematicObject->m_draw_angle != E_HORIZONTAL) return PCMCurrentWireBeingDrawnObject;

	id = FindWireId(PCSchematicObject);

	if(id < 0){ASSERT(0); return NULL;}

	TCWireTags &CWireTag = CMWireList.CWireTags[id];

	COldWireInfo = PCSchematicObject->GetWireInfo();
	CWireStart	= COldWireInfo.CStart;
	CWireEnd	= COldWireInfo.CEnd;

	int count = CWireTag.Info.GetSize();

	TCWireInfo *PTCWireInfo = CWireTag.Info.GetData();

	int p;

	for(p = 0; p < count; p++)
	{	
		if(!PTCWireInfo->tagged) 
		{
			PTCWireInfo++;

			continue;
		}

		CNewWireInfo = *PTCWireInfo;

		if(CNewWireInfo.PCSchematicObject->m_user_label_preferred)
		{
			PCSchematicObjectPrefered = CNewWireInfo.PCSchematicObject;

			CText = PCSchematicObjectPrefered->GetLabel(E_WIRE_NET_NAME);
		}

		f_tagged = true;

		switch(COldWireInfo.type)
		{

			case E_HORIZONTAL:
			{
				
				if(CNewWireInfo.CStart.x  < CWireStart.x) CWireStart.x = CNewWireInfo.CStart.x;
				if(CNewWireInfo.CEnd.x  > CWireEnd.x) CWireEnd.x = CNewWireInfo.CEnd.x;

			} break;
			case E_VERTICAL:
			{

				if(CNewWireInfo.CStart.y  < CWireStart.y) CWireStart.y = CNewWireInfo.CStart.y;
				if(CNewWireInfo.CEnd.y  > CWireEnd.y) CWireEnd.y = CNewWireInfo.CEnd.y;

			}break;
		}

		PTCWireInfo++;
	}
 
	if(!f_tagged) return PCSchematicObject;

	CDC CDCTemp;

	CDCTemp.CreateCompatibleDC(NULL);

	PCMCurrentWireBeingDrawnObject = CreateWire(&CDCTemp,CWireStart, CWireEnd);

	if(!PCMCurrentWireBeingDrawnObject) return NULL;

	// now keep same visability of labels

	int count2;
	TCSchematicObject *PCSchematicObject2;

	PTCWireInfo = CWireTag.Info.GetData();

	for(p = 0; p < count; p++)
	{	
		if(!PTCWireInfo->tagged) 
		{
			PTCWireInfo++;

			continue;
		}

		CNewWireInfo = *PTCWireInfo;

		PCSchematicObject2 = CNewWireInfo.PCSchematicObject;
		
		count2 = PCSchematicObject2->CMSchematicObjectData.CLabelListData.GetSize();
		f_tagged = false;

		for(int q = 0; q < count2; q++)
		{
			if(PCSchematicObject2->CMSchematicObjectData.CLabelListData[q].is_visable)
			{
				f_tagged = true;
			}
			if(f_tagged)
			{
				PCMCurrentWireBeingDrawnObject->CMSchematicObjectData.CLabelListData[q].is_visable = true;
				PCMCurrentWireBeingDrawnObject->CMLabelListObject[q].m_visable = true;
				break;
			}
		}

		PTCWireInfo++;
	}

	if(PCSchematicObjectPrefered)
	{
		PCMCurrentWireBeingDrawnObject->m_user_label_preferred = PCSchematicObjectPrefered->m_user_label_preferred;
	}

	count2 = PCMCurrentWireBeingDrawnObject->CMSchematicObjectData.CLabelListData.GetSize();

	for(int q = 0; q < count2; q++)
	{
		if(p == E_WIRE_NET_NAME) continue;

		CText = PCMCurrentWireBeingDrawnObject->GetLabel(q);

		PCMCurrentWireBeingDrawnObject->SetLabel(&CDCTemp, q, CText);
	}

//	PCMCurrentWireBeingDrawnObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = COldWireInfo.CNetName;

	PCMCurrentWireBeingDrawnObject->SetLabel(&CDCTemp, E_WIRE_NET_NAME, COldWireInfo.CNetName, true);

//	PCMCurrentWireBeingDrawnObject->Paste(&CDCTemp,PCMCurrentWireBeingDrawnObject->CMLocation);

	return PCMCurrentWireBeingDrawnObject;
}

void TCSchematicManager::CreateOneSplitWire(int id)
{
	register int p;
	TCSchematicObject *PCSchematicObject, *PCSchematicObject1;
	TCSchematicObject *PCSchematicObject2 = NULL;
	TCWireInfo		CSplitingWireInfo;
	TCWireInfo		CSplitWireInfo;
	CPoint			CSplitWireStart;
	CPoint			CSplitWireEnd;
	CPoint			CSplintPoint;

	CDC CDCTemp;

	CDCTemp.CreateCompatibleDC(NULL);

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	id = FindWireId(PCSchematicObject);

	if(id < 0){ASSERT(0); return;}

	if(id >= CMWireList.CWireTags.GetSize()){ASSERT(0);return;}

	TCWireTags &CWireTag = CMWireList.CWireTags[id];

	TCWireInfo *PCWireInfo = CWireTag.Info.GetData();

	int count = CWireTag.Info.GetSize();

	int flag = false;

	for(p = 0; p < count; p++)
	{	
		if(!PCWireInfo->split) 
		{
			PCWireInfo++;

			continue;
		}

		flag = true;

		CSplitWireInfo = *PCWireInfo;
		CSplitWireStart = CSplitWireInfo.CStart;
		CSplitWireEnd	= CSplitWireInfo.CEnd;
		CSplintPoint	= CSplitWireInfo.CMid;

		PCSchematicObject1 =CreateWire(&CDCTemp, CSplitWireStart, CSplintPoint);
		PCSchematicObject1->SetLabel(&CDCTemp, E_WIRE_NET_NAME, CSplitWireInfo.CNetName);
		PCSchematicObject1->Paste(&CDCTemp,PCSchematicObject1->CMLocation);

		PCSchematicObject2 = CreateWire(&CDCTemp, CSplintPoint, CSplitWireEnd);
		PCSchematicObject2->SetLabel(&CDCTemp, E_WIRE_NET_NAME, CSplitWireInfo.CNetName);
		PCSchematicObject2->Paste(&CDCTemp,PCSchematicObject2->CMLocation);

		PCWireInfo++;
	}

	if(!flag) return;
		
	PCSchematicObject->SetLabel(&CDCTemp, E_WIRE_NET_NAME, CSplitWireInfo.CNetName, true);

	PCMCurrentWireBeingDrawnObject = PCSchematicObject2;

	return;
}

void TCSchematicManager::ClearAllConnectionDotes(CDC *PCViewDC)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	TCSchematicObject		*PCSchematicObject;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)// will make this a non local array for speed
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		PCSchematicObject->ClearConnectionDots(PCViewDC);

		PCSchematicObjectPtr++;
	}
}

void TCSchematicManager::DisplayAllConnectionDots(void)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register TCSchematicObject	**PCSchematicObjectPtrCompare;
	register int p;
	TCSchematicObject		*PCSchematicObject, *PCSchematicObjectCompare;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	ClearAllConnectionDotes(PCViewDC);

	if(!GCSuperSpiceGlobalData.CDrawData.display_connection_dots || is_symbol_editor)
	{
		CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

		return;
	}

	CRect	CTestRect;
	CRect	CWirePinRegion;	
	CRect	CWireGrabRegion;
	int		f_pin_hit_count;
	int		f_pin_hit;
	int		pin_count;
	
	TCSchematicComponentInfo CSchematicComponentInfo;

	CSchematicComponentInfo.type = E_SCHEMATIC_WIRE;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		CWirePinRegion = PCSchematicObject->GetPinGrabRegion(0);

		f_pin_hit_count = 0;

		PCSchematicObjectPtrCompare = CMSchematicManagerData.CGraphicList.GetData();

		int q;

		for(q = 0; q < count; q++)
		{
			PCSchematicObjectCompare = *PCSchematicObjectPtrCompare;

			if(PCSchematicObject == PCSchematicObjectCompare)
			{
				PCSchematicObjectPtrCompare++;

				continue;
			}

			if(PCSchematicObjectCompare->m_type != E_WIRE_COMPONENT)// check all other decices
			{
				pin_count = PCSchematicObjectCompare->GetNumberOfPins();

				for(int r = 0; r < pin_count; r++)
				{
					CWireGrabRegion = PCSchematicObjectCompare->GetPinGrabRegion(r);
	
					if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion))
					{
						PCSchematicObject->DisplayConnectionDot1(PCViewDC);

						break;
					}
				}

				PCSchematicObjectPtrCompare++;

				continue;
			}

			CWireGrabRegion = PCSchematicObjectCompare->GetPinGrabRegion(0);
			f_pin_hit = 0;

			if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion)) 
				{f_pin_hit_count++; f_pin_hit = true;}

			CWireGrabRegion = PCSchematicObjectCompare->GetPinGrabRegion(1);

			if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion))
				{f_pin_hit_count++; f_pin_hit = true;}

			CWireGrabRegion = PCSchematicObjectCompare->GetGrabRegion(CSchematicComponentInfo);

			if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion) && !f_pin_hit && PCSchematicObjectCompare->m_type == E_WIRE_COMPONENT)
			{
				PCSchematicObject->DisplayConnectionDot1(PCViewDC);

				PCSchematicObjectPtrCompare++;

				continue;
			}

			PCSchematicObjectPtrCompare++;
		}

		if(f_pin_hit_count != 1)PCSchematicObject->DisplayConnectionDot1(PCViewDC);

		CWirePinRegion = PCSchematicObject->GetPinGrabRegion(1);

		f_pin_hit_count = 0;

		PCSchematicObjectPtrCompare = CMSchematicManagerData.CGraphicList.GetData();

		for(q = 0; q < count; q++)
		{
			PCSchematicObjectCompare = *PCSchematicObjectPtrCompare;

			if(PCSchematicObject == PCSchematicObjectCompare)
			{
				PCSchematicObjectPtrCompare++;

				continue;
			}

			if(PCSchematicObjectCompare->m_type != E_WIRE_COMPONENT)// check all other devices
			{
				pin_count = PCSchematicObjectCompare->GetNumberOfPins();

				for(int r = 0; r < pin_count; r++)
				{
					CWireGrabRegion = PCSchematicObjectCompare->GetPinGrabRegion(r);
	
					if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion))
					{
						PCSchematicObject->DisplayConnectionDot2(PCViewDC);

						break;
					}
				}
			} 

			CWireGrabRegion = PCSchematicObjectCompare->GetPinGrabRegion(0);
			f_pin_hit = 0;

			if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion)) 
				{f_pin_hit_count++; f_pin_hit = true;}

			CWireGrabRegion = PCSchematicObjectCompare->GetPinGrabRegion(1);

			if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion))
				{f_pin_hit_count++; f_pin_hit = true;}

			CWireGrabRegion = PCSchematicObjectCompare->GetGrabRegion(CSchematicComponentInfo);

			if(CTestRect.IntersectRect(CWirePinRegion, CWireGrabRegion) && !f_pin_hit && PCSchematicObjectCompare->m_type == E_WIRE_COMPONENT)
			{
				PCSchematicObject->DisplayConnectionDot2(PCViewDC);

				PCSchematicObjectPtrCompare++;

				continue;
			}

			PCSchematicObjectPtrCompare++;
		}

		if(f_pin_hit_count != 1)PCSchematicObject->DisplayConnectionDot2(PCViewDC);

		PCSchematicObjectPtr++;
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

TCSchematicObject *TCSchematicManager::CreateWire(CDC *PCDC, CPoint CWireStart, CPoint CWireEnd)
{
	TCSchematicObject *PCSchematicObject;

	PCSchematicObject = new TCSchematicObject; 

	if(!PCSchematicObject) return NULL;

	PCSchematicObject->is_symbol_editor = is_symbol_editor;
	
	CMSchematicManagerData.CGraphicList.Add(PCSchematicObject);

//	PCSchematicObject->CMSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);

	PCSchematicObject->StartDrawingLine(PCDC, CWireStart, CMSchematicManagerData.zoom);
	PCSchematicObject->ContinueDrawingLine(PCDC, CWireEnd, false);
	PCSchematicObject->StopDrawingLine(PCDC, CWireEnd, is_symbol_editor);
	PCSchematicObject->ResetSelect();

	PCSchematicObject->SetPageId(CMSchematicManagerData.page_id);

	PCSchematicObject->DisplayConnectionDot1(PCDC);// needed to reset data
	PCSchematicObject->DisplayConnectionDot2(PCDC);// needed to reset data
	PCSchematicObject->ClearConnectionDots(PCDC);

	m_current_wire_being_drawn = FindGraphicId(PCSchematicObject);

	return PCSchematicObject;
}

void TCSchematicManager::DeleteOverlapedWires(void)
{
	TCSchematicObject *PCSchematicObject;
	int count = CMSchematicManagerData.CGraphicList.GetSize();
	bool f_flag = false;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(!PCSchematicObject->m_overlaped) continue;

		PCSchematicObject->SetSelect();

		f_flag = true;
	}
	
	if(f_flag)
	{
		DeleteSelectedGraphics();
		DrawAll();
	}
}
void TCSchematicManager::RemoveOverlapedWires(void)
{
	TCSchematicObject		*PCSchematicObject;
	register int p;

	CArray <TCSchematicObject *, TCSchematicObject *> CGraphicDeleteList;

	int count = CMWireList.CWireTags.GetSize();
	int count2;
	int add_counter = 0;

	CGraphicDeleteList.SetSize(count);

	TCWireTags *PCWireTag = CMWireList.CWireTags.GetData();

	for(p = 0; p < count; p++)
	{
		TCWireTags &CWireTag = *PCWireTag;

		count2 = CWireTag.Info.GetSize();

		TCWireInfo *PCWireInfo = CWireTag.Info.GetData();

		for(int q = 0; q < count2; q++)
		{
			TCWireInfo &Info = *PCWireInfo;

			if(!Info.tagged) 
			{
				*PCWireInfo++;

				continue;
			}

			CGraphicDeleteList[add_counter] = Info.PCSchematicObject;

			add_counter++;

			*PCWireInfo++;
		}

		PCWireTag++;
	}

	CGraphicDeleteList.SetSize(add_counter);

	count = CGraphicDeleteList.GetSize();

	TCSchematicObject **PPCSchematicObject = CGraphicDeleteList.GetData();

	for(p = 0; p < count; p++) // now delete them all
	{
		PCSchematicObject = *PPCSchematicObject;

		int q = FindGraphicId(PCSchematicObject);

		if(q < 0) 
		{
			PPCSchematicObject++;

			continue;
		}

		CMSchematicManagerData.CGraphicList.RemoveAt(q);

		if(PCMLastOutlinedComponent == PCSchematicObject) PCMLastOutlinedComponent = NULL;

		if(PCSchematicObject) delete PCSchematicObject;

		PPCSchematicObject++;
	}

	m_current_wire_being_drawn = FindGraphicId(PCMCurrentWireBeingDrawnObject);
}

void TCSchematicManager::ResetTagedOverlapedWires(void)
{
	ResetOverlapedRegion();
}

void TCSchematicManager::InitWireList(void)
{
	TCSchematicObject *PCSchematicObject;
	TCWireTags CWireTags;
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;

	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	CMWireList.CWireTags.SetSize(0);

	CMWireList.CWireTags.SetSize(count);//added 14th June 2002

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) 
		{
			PCSchematicObjectPtr++;

			continue;
		}
	
		CWireTags.PCSchematicObject = PCSchematicObject;

//		CMWireList.CWireTags.SetAtGrow(p, CWireTags); //14th June 2002

		CMWireList.CWireTags[p] = CWireTags;

		PCSchematicObjectPtr++;
	}
}

void TCSchematicManager::ClearAllNetNames(void)
{
	TCSchematicObject *PCSchematicObject;

	CString CText;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) continue;

		PCSchematicObject->m_user_label_preferred = false;

		CText = "";

		PCSchematicObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = CText;
	}
}

void TCSchematicManager::UpdateAndGetWireLabelIds(CArray <int, int> &CWireLabelUpdateIds, bool correct_wires)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCOldSchematicObject;

	CString CText, CTemp;
	int type;

//	JoinUpAllWires();// not added. Bug does nt split up wires and makes naming all nets the same fail.
	if(correct_wires) SplitUpAllWires();// added 20th May 2022 to fix netlisting bug
	// if wire name is null generate new name
	// if wire name is same as connector but dosent touch rename
	
	// 12/6/99 if wire name is same as another wire but doesnot touch rename
	//to do
	int count = CMSchematicManagerData.CGraphicList.GetSize();

	bool flag;
	int  wire_id_counter = 0;
	int  wire_id_size = 2*count;

	CWireLabelUpdateIds.SetSize(wire_id_size);

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) continue;
	
		CText = PCSchematicObject->GetLabel(E_WIRE_NET_NAME);

		CText.TrimLeft();
		CText.TrimRight();
		CText.MakeUpper();

		if(CText == "")
		{
//			CWireLabelUpdateIds.Add(p);

			if(!(wire_id_counter < CWireLabelUpdateIds.GetSize()))
			{
				wire_id_size *= 2;

				CWireLabelUpdateIds.SetSize(wire_id_size);
			}

			CWireLabelUpdateIds[wire_id_counter++] = p;

			continue;
		}

		ResetTagTouchingWires();// 12/6/99
		TagTouchingWires(p);
		flag = false;

		for(int q = 0; q < count; q++)
		{
			PCOldSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(q);

			if(PCOldSchematicObject == PCSchematicObject) continue;

			type = PCOldSchematicObject->m_type;

			if(type != E_PAGE_CONNECTER_INPUT && type != E_PAGE_CONNECTER_OUTPUT &&
				type != E_PAGE_CONNECTER_BIDIRECTIONAL  && type != E_GROUND
				&& type != E_SUBCIRCUIT_PIN_CONNECTER && type != E_WIRE_COMPONENT) continue;

			if(type == E_WIRE_COMPONENT)// if wire not taged, but has same name rename
			{
				if(PCOldSchematicObject->m_overlaped) continue;

				CTemp = PCOldSchematicObject->GetLabel(E_WIRE_NET_NAME);
			
				CTemp.TrimLeft();
				CTemp.TrimRight();
				CTemp.MakeUpper();

				if(CText != CTemp) continue;

	//			CWireLabelUpdateIds.Add(p);

				if(!(wire_id_counter < CWireLabelUpdateIds.GetSize()))
				{
					wire_id_size *= 2;

					CWireLabelUpdateIds.SetSize(wire_id_size);
				}

				CWireLabelUpdateIds[wire_id_counter++] = p;

				continue;
			}

			CTemp = PCOldSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
			
			CTemp.TrimLeft();
			CTemp.TrimRight();
			CTemp.MakeUpper();

			if(CText != CTemp) continue;

			if(!(wire_id_counter < CWireLabelUpdateIds.GetSize()))
			{
				wire_id_size *= 2;

				CWireLabelUpdateIds.SetSize(wire_id_size);
			}
			//CWireLabelUpdateIds.Add(p);

			CWireLabelUpdateIds[wire_id_counter++] = p;
		}
	}

	CWireLabelUpdateIds.SetSize(wire_id_counter);
}

void TCSchematicManager::NameAllTestPoints(void)// called after all nets are correct
{
	TCSchematicObject *PCTestSchematicObject;
	TCSchematicObject *PCWireSchematicObject;

	CString CNetName, CTemp;
	CRect	CTestRect;
	CRect	CPinRegion;	
	CRect	CDeviceRect;

	int q, r;

	// this function will determine whether pin is connected to wire or other pin
	// it assumes pins first
	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(!count) return;

	int pin_count;

	CArray <CString, CString> CDeviceNodes;

	CString CParentRefDes;

	if(PCWaveformDataRuns)// convieniant, contains the
	{
		if(PCWaveformDataRuns->PCDoc)
		{
			CParentRefDes = PCWaveformDataRuns->PCDoc->CParentRefDes;
		}
		else
		{
			ASSERT(0);// program fuckup
		}
	}

	int flag_break = false;
	int device_node_count;
	int bracket_index;
	CString CAppend, CPinNumber;

	for(int p = 0; p < count; p++)
	{
		PCTestSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCTestSchematicObject->m_type != E_TEST_MARKER) continue;

		if(PCTestSchematicObject->CMSchematicObjectData.version < 0)
			PCTestSchematicObject->CMSchematicObjectData.version = 0;

		// null it
		PCTestSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NET_NAME, "???");

		CPinRegion = PCTestSchematicObject->GetPinGrabRegion(0);

		flag_break = false;

		for(q = 0; q < count; q++)// first if testpin hits a device pin
		{
			PCWireSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(q);

			if(PCWireSchematicObject == PCTestSchematicObject) continue;

			pin_count = PCWireSchematicObject->GetNumberOfPins();

			if(PCWireSchematicObject->m_type == E_WIRE_COMPONENT) continue;

//			if(PCWireSchematicObject->m_type < E_DC_VOLTAGE_SOURCE && PCWireSchematicObject->m_type) continue;
//			if(PCWireSchematicObject->m_type < E_DC_VOLTAGE_SOURCE && !PCWireSchematicObject->m_type) continue;

			PCWireSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CDeviceNodes);
				
			device_node_count = CDeviceNodes.GetSize();// not all pins have distinct currents in spice

			// ignore unsupported currents

			for(r = 0; r < pin_count; r++)// check all pins
			{
				if(!CTestRect.IntersectRect(CPinRegion, PCWireSchematicObject->GetPinGrabRegion(r))) continue;

				flag_break = true;

				break;
			}

			if(!flag_break)// now see if on device and plot power, if available
			{
				if(CTestRect.IntersectRect(CPinRegion, PCWireSchematicObject->CMRectGrabLocationRegion)) 
				{
					if(r < device_node_count)
					{
						int model_power_type = GCSuperSpiceDataBase.GetSpiceModelType(&PCWireSchematicObject->CMSchematicObjectData);

						if(!(model_power_type < 0))
							 r = GCSuperSpiceDataBase.CSpiceNodeParameterStartIndex[model_power_type] - 1;

						if(r && r > -1) flag_break = true;//r=0 is sub, no power available.
					}
				}
			}

			if(flag_break) // see TCSuperSpiceDataBase::SetupSpiceNodeNames()
			{
				PCWireSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CDeviceNodes);
				
				CAppend = ':';

				CPinNumber.Format("%d", r);

				if(r < device_node_count)// for Transisters, 3 or 4 terminal etc
				{
					CNetName = CDeviceNodes[r];

					bracket_index = CNetName.Find('[');
					
					if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
					{
						if(CParentRefDes != "") 
						{
							CNetName = CParentRefDes + CAppend + CNetName;
				
							bracket_index = CNetName.Find('[');

							if(PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
							   PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC)  
							{						
								CAppend += GSubCktCurrentPinStr + CPinNumber;

								CNetName.Insert(bracket_index, CAppend);
							}

						}
						else
						{
							if(PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
								PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) 
							{						
								CAppend += GSubCktCurrentPinStr + CPinNumber;

								CNetName.Insert(bracket_index, CAppend);
							}
						}
					}
					else
					{
						if(CParentRefDes != "") 
						{
							if(PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
								PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) 
							{
								CAppend += GSubCktCurrentPinStr + CPinNumber;
							}

							CNetName.Insert(bracket_index, CAppend);

							if(PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
								PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) 
									CAppend = CParentRefDes + ':';
							else CAppend = CParentRefDes;

							CNetName.Insert(bracket_index + 1, CAppend);
						}
						else
						{
							if(PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
								PCWireSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) 
							{
								CAppend += GSubCktCurrentPinStr + CPinNumber;

								CNetName.Insert(bracket_index, CAppend);
							}
						}
					}

				}// this may need modified to support other components
				else if(device_node_count && PCWireSchematicObject->m_type) // for two terminal when i in is i out
				{
					if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
					{
						CNetName = CParentRefDes + CDeviceNodes[0];// works for R, L, C
					}
					else
					{
						CNetName = CDeviceNodes[0];

						bracket_index = CNetName.Find('[');

						if(CParentRefDes != "") 
						{
							CNetName.Insert(bracket_index, CAppend);
							CNetName.Insert(bracket_index  + 1, CParentRefDes);
						}
					}
				}

				PCTestSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NET_NAME, CNetName);

				PCTestSchematicObject->SetLabel(&GlobalCDCTemp, E_COMPONENT_SYMBOL_NAME, GCSuperSpiceDataBase.CTestPointNames[PCTestSchematicObject->CMSchematicObjectData.version]);

				break;
			}
		}

		if(flag_break) continue;// found pin, dont bother with wire

		for(q = 0; q < count; q++)// now find if on wire
		{
			PCWireSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(q);

			if(PCWireSchematicObject->m_type != E_WIRE_COMPONENT) continue;

			pin_count = PCWireSchematicObject->GetNumberOfPins();

			CDeviceRect = PCWireSchematicObject->CMRectGrabLocationRegion;

			if(CTestRect.IntersectRect(CPinRegion, CDeviceRect))
			{
				CNetName = PCWireSchematicObject->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;
					
				if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
				{
					if(CParentRefDes != "") CNetName = CParentRefDes + ':' + CNetName;
				}
				else 
				{
					if(CParentRefDes != "") CNetName +=  ':' + CParentRefDes;
				}
				
				PCTestSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NET_NAME, CNetName);

				PCTestSchematicObject->SetLabel(&GlobalCDCTemp, E_COMPONENT_SYMBOL_NAME, GCSuperSpiceDataBase.CTestPointNames[PCTestSchematicObject->CMSchematicObjectData.version]);

				break;
			}
		
			if(PCTestSchematicObject->m_type == E_TEST_MARKER)//on blank bit of page so null label
				PCTestSchematicObject->SetPinLabel(&GlobalCDCTemp, 0, E_COMPONENT_PIN_NET_NAME, "Node?");
		}
	}
}

void TCSchematicManager::MakeSameWiresHaveSameName(void)
{
	TCSchematicObject *PCSchematicObject;
	CString CText;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int p;

	// first scan asnd set prefered node names i.e. user overidded node
	// names should be kept if possible
	// this is a hobsons choice, there no real way to determine which 
	// name should be kept
	
	for(p = 0; p < count; p++)
	{	
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) continue;

		if(!PCSchematicObject->m_user_label_preferred) continue;
	
		MakeSameWiresHaveSameName(p, E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED);
	}

	//Now scan non prefered node names
	for(p = 0; p < count; p++)
	{	
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) continue;

		if(PCSchematicObject->m_user_label_preferred) continue;
	
		MakeSameWiresHaveSameName(p, E_UPDATE_OTHER_NODE_NAMES);
	}

	LabelGroundAndConectersWires();
}

void TCSchematicManager::TagTouchingWires(int id)
{
	TCWireInfo CWireInfo;
	TCWireInfo CNewWireInfo;
	CRect CTestRect;

	register TCSchematicObject	**PCSchematicObjectPtr;
	register TCSchematicObject	*PCSchematicObject;
	register int p;

	TCSchematicObject	*PCOldSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCOldSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	CWireInfo = PCOldSchematicObject->GetWireInfo();

	CRect	CPinRegion;
	CRect	COldPin0, COldPin1, CNewPin0, CNewPin1;
	bool old_is_angle, new_is_angle;

	for(p = 0; p < count; p++) 
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(!PCSchematicObject || PCSchematicObject->m_type != E_WIRE_COMPONENT || PCSchematicObject->m_overlaped) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		CNewWireInfo = PCSchematicObject->GetWireInfo();

		if(!CTestRect.IntersectRect(CNewWireInfo.CExtent, CWireInfo.CExtent))
		{
			PCSchematicObjectPtr++;

			continue;
		}

		if(PCOldSchematicObject->m_draw_angle == E_VERTICAL || PCOldSchematicObject->m_draw_angle == E_HORIZONTAL)
			old_is_angle = false;
		else old_is_angle = true;

		if(PCSchematicObject->m_draw_angle == E_VERTICAL || PCSchematicObject->m_draw_angle == E_HORIZONTAL)
			new_is_angle = false;
		else new_is_angle = true;

		//22nd March angled support fix
/*
		if(!(CNewWireInfo.CStart == CWireInfo.CStart ||//ignor overlapped wires
				CNewWireInfo.CEnd == CWireInfo.CEnd || 
				CNewWireInfo.CEnd == CWireInfo.CStart ||
				CNewWireInfo.CStart == CWireInfo.CEnd)) 
				
		{
			if(PCOldSchematicObject->m_draw_angle == E_VERTICAL || PCOldSchematicObject->m_draw_angle == E_HORIZONTAL) 
			{
				PCSchematicObjectPtr++;

				continue;
			}

			CPinRegion = PCOldSchematicObject->GetPinGrabRegion(0);// angle touching in middle of lin
			
			if(!CTestRect.IntersectRect(CNewWireInfo.CExtent, CPinRegion))
			{
				CPinRegion = PCOldSchematicObject->GetPinGrabRegion(1);

				if(!CTestRect.IntersectRect(CNewWireInfo.CExtent, CPinRegion))
				{
					PCSchematicObjectPtr++;

					continue;
				}
			}
		}
*/
		//22nd March angled support fix

		COldPin0 = PCOldSchematicObject->GetPinGrabRegion(0);
		COldPin1 = PCOldSchematicObject->GetPinGrabRegion(1);
		CNewPin0 = PCSchematicObject->GetPinGrabRegion(0);
		CNewPin1 = PCSchematicObject->GetPinGrabRegion(1);

		if((!old_is_angle && !new_is_angle) || (old_is_angle && new_is_angle))// id ends dont touch, ignor
		if(!(CTestRect.IntersectRect(COldPin0, CNewPin0) || CTestRect.IntersectRect(COldPin0, CNewPin1) ||
			CTestRect.IntersectRect(COldPin1, CNewPin0) || CTestRect.IntersectRect(COldPin1, CNewPin1)))
		{
			PCSchematicObjectPtr++;

			continue;
		}

		if(!old_is_angle && new_is_angle)
		if(!(CTestRect.IntersectRect(CNewPin0, CWireInfo.CExtent) || CTestRect.IntersectRect(CNewPin1, CWireInfo.CExtent)))
		{
			PCSchematicObjectPtr++;

			continue;
		}

		if(old_is_angle && !new_is_angle)
		if(!(CTestRect.IntersectRect(COldPin0, CNewWireInfo.CExtent) || CTestRect.IntersectRect(COldPin1, CNewWireInfo.CExtent)))
		{
			PCSchematicObjectPtr++;

			continue;
		}

		PCSchematicObject->m_overlaped = true;

		TagTouchingWires(p);

		PCSchematicObjectPtr++;
	}
}
void TCSchematicManager::ResetTagTouchingWires(void)
{
	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		(*PCSchematicObjectPtr)->m_overlaped = 0;

		PCSchematicObjectPtr++;
	}
}

void TCSchematicManager::LabelGroundAndConectersWires(void)
{
	TCSchematicObject *PCSchematicObject, *PCSchematicObject2;
	CString CText, CTemp, CRefDes, CNetName;
	CRect	CTestRect;
	CRect	CPinRegion;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();
	int type;

	for(int p = 0; p < count; p++)
	{	
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		type = PCSchematicObject->m_type;

		CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		if(!(type == E_GROUND || type == E_PAGE_CONNECTER_INPUT ||
			 type == E_PAGE_CONNECTER_OUTPUT|| type == E_PAGE_CONNECTER_BIDIRECTIONAL ||
			 type == E_SUBCIRCUIT_PIN_CONNECTER)) continue;

		for(int q = 0; q < count; q++)
		{
			PCSchematicObject2 = CMSchematicManagerData.CGraphicList.GetAt(q);

			if(PCSchematicObject == PCSchematicObject2) continue;

			if(PCSchematicObject2->m_type != E_WIRE_COMPONENT) continue;

			CNetName = PCSchematicObject2->CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

			CPinRegion = PCSchematicObject->GetPinGrabRegion(0);

			if(!CTestRect.IntersectRect(PCSchematicObject2->CMRectGrabLocationRegion, CPinRegion)) continue;

			if(type == E_GROUND) PCSchematicObject2->SetLabel(&CDCTemp, E_WIRE_NET_NAME, "0");
			else
			{
				CTemp = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

				PCSchematicObject2->SetLabel(&CDCTemp, E_WIRE_NET_NAME, CTemp);
			}
			MakeSameWiresHaveSameName(q, E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED);

			break;
		}
	}
}

void TCSchematicManager::MakeSameWiresHaveSameName(int id, int options)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCOldSchematicObject;
	TCWireInfo CNewWireInfo;
	TCWireInfo COldWireInfo;
	CRect CTestRect;
	CString CText, CTest, COldVoltage;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(id >= count) return;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->m_type != E_WIRE_COMPONENT) return;

	ResetTagTouchingWires();
	TagTouchingWires(id);

	if(options == E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED)
		PCSchematicObject->m_user_label_preferred = true;
	else PCSchematicObject->m_user_label_preferred = false;

	CText = PCSchematicObject->GetLabel(E_WIRE_NET_NAME);

	CString CNodeVoltage = PCSchematicObject->GetLabel(E_WIRE_NET_VOLTAGE);
	double  designer_voltage = PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE];

	for(int p = 0; p < count; p++)
	{
		PCOldSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) continue;

		CTest		= PCOldSchematicObject->GetLabel(E_WIRE_NET_NAME);
		COldVoltage = PCOldSchematicObject->GetLabel(E_WIRE_NET_VOLTAGE);

		if(!PCOldSchematicObject->m_overlaped) continue;

		if(CTest == CText)
		{
			if(options == E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED)
				PCOldSchematicObject->m_user_label_preferred = true;
			else PCOldSchematicObject->m_user_label_preferred = false;

			if(COldVoltage != CNodeVoltage) PCOldSchematicObject->SetLabel(&CDCTemp, E_WIRE_NET_VOLTAGE, CNodeVoltage);			

			PCOldSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE] = (float) designer_voltage;		

			continue;
		}

		PCOldSchematicObject->SetLabel(&CDCTemp, E_WIRE_NET_NAME, CText);

		if(COldVoltage != CNodeVoltage) PCOldSchematicObject->SetLabel(&CDCTemp, E_WIRE_NET_VOLTAGE, CNodeVoltage);		
			
		PCOldSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE] = (float) designer_voltage;
		
		if(options == E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED)
			PCOldSchematicObject->m_user_label_preferred = true;
		else PCOldSchematicObject->m_user_label_preferred = false;
	}
}

void TCSchematicManager::UpdateNetNamesFromPinNames(int id)
{
	TCSchematicObject *PCSchematicObject;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	int count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();
	
	for(int p = 0; p < count; p++)
	{
		UpdateNetNamesFromPinNames(id, p);
	}
}

void TCSchematicManager::UpdateNetNamesFromPinNames(int id, int pin_id)
{
	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCOldSchematicObject;
	TCWireInfo CNewWireInfo;
	TCWireInfo COldWireInfo;
	CRect CTestRect;
	CString CText;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(id >= count) return;

	PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(id);

	if(PCSchematicObject->m_type < E_PAGE_CONNECTER_INPUT) return;

	CRect CPinRect = PCSchematicObject->CMPinListObject[pin_id].CMRectGrabLocationRegion;

	CText = PCSchematicObject->CMSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

	if(CText == "") return;

	for(int p = 0; p < count; p++)
	{
		PCOldSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		if(PCOldSchematicObject->m_type != E_WIRE_COMPONENT) continue;

		if(!PCOldSchematicObject->TCGraphicBitMapVectorObject::IsThere(CPinRect, false)) continue;

		PCOldSchematicObject->m_user_label_preferred = true;

		PCOldSchematicObject->SetLabel(&CDCTemp, E_WIRE_NET_NAME, CText);	

		MakeSameWiresHaveSameName(p, E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED);

		return;
	}
}

int TCSchematicManager::FindWireId(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return -1;

	register TCWireTags	*PCWireTags;
	register int p;

	register int count = CMWireList.CWireTags.GetSize();

	PCWireTags = CMWireList.CWireTags.GetData();

	for(p = 0; p < count; p++)
	{
		if(PCSchematicObject == PCWireTags->PCSchematicObject) 
		{
			return p;
		}

		PCWireTags++;
	}

	return -1;
}
 
TCSchematicObject *TCSchematicManager::JoinUpWithOtherWires(int id)
{
	TCSchematicObject *PCSchematicObject;
	InitWireList();
//	ResetTagedOverlapedWires();
	ResetOverlapedRegion();
	TagSameTypeOverlapedWires(id);
	PCSchematicObject = CreateOneJoinedUpWire(id);
	RemoveOverlapedWires(); 

	return PCSchematicObject;
}

void TCSchematicManager::SplitUpWire(int id)
{
	if(is_symbol_editor) return;

	InitWireList();
//	ResetTagedOverlapedWires();
	ResetOverlapedRegion();
	TagDiffTypeOverlapedWires(id);
	CreateOneSplitWire(id);
	RemoveOverlapedWires();
}

void TCSchematicManager::JoinUpAllWires(void) 
{
	if(is_symbol_editor) return;

	TCSchematicObject	*PCSchematicObject;
	int p;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject	**PCSchematicObjectPtr;

	CArray <TCSchematicObject *, TCSchematicObject *> CWireTable;

	int add_counter = 0;

//	CWireTable.SetSize(0, E_SCHEMATIC_OBJECT_ALLOC_SIZE);
	CWireTable.SetSize(count);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT || 
			PCSchematicObject->m_draw_angle != E_VERTICAL && PCSchematicObject->m_draw_angle != E_HORIZONTAL) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

//		CWireTable.Add(PCSchematicObject);

		CWireTable[add_counter] = PCSchematicObject;

		add_counter++;

		PCSchematicObjectPtr++;
	}

	CWireTable.SetSize(add_counter);

	count = CWireTable.GetSize();

	int id;

	PCSchematicObjectPtr = CWireTable.GetData();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		id = FindGraphicId(PCSchematicObject);

		if(id < 0) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		JoinUpWithOtherWires(id);

		PCSchematicObjectPtr++;
	}
}

void TCSchematicManager::JoinUpWires(CArray <CString, CString> &CNetNameList)
{
	int id;
	int count = CNetNameList.GetSize();
	CString CNetName;

	for(int p = 0; p < count; p++)
	{
		id = FindComponentId(CNetNameList[p]);

		if(id < 0) continue;
	
		JoinUpWithOtherWires(id);
	}
}

void TCSchematicManager::SplitUpAllWires(void)
{
	if(is_symbol_editor) return;

	register TCSchematicObject	**PCSchematicObjectPtr;
	register int p;
	TCSchematicObject		*PCSchematicObject;
	register int count = CMSchematicManagerData.CGraphicList.GetSize();

	CArray <TCSchematicObject *, TCSchematicObject *> CWireTable;
	CWireTable.SetSize(0, E_SCHEMATIC_OBJECT_ALLOC_SIZE);

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(p = 0; p < count; p++)// will make this a non local array for speed
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT ||// added vertical/horizontal 21 march 2002
		   PCSchematicObject->m_draw_angle != E_VERTICAL && PCSchematicObject->m_draw_angle != E_HORIZONTAL) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		CWireTable.Add(PCSchematicObject);

		PCSchematicObjectPtr++;
	}

	count = CWireTable.GetSize();

	int id;

	PCSchematicObjectPtr = CWireTable.GetData();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = *PCSchematicObjectPtr;

		id = FindGraphicId(PCSchematicObject);

		if(id < 0) 
		{
			PCSchematicObjectPtr++;

			continue;
		}

		SplitUpWire(id);

		PCSchematicObjectPtr++;
	}

	DisplayAllConnectionDots();
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::IdleDrawWire(CPoint CMousePosition)
{
	CMousePosition;

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsSelectedDrawWire(CPoint CMousePosition)
{
	CMousePosition;

	GraphicsSelectedOnCancel();

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GraphicsMovingDrawWire(CPoint CMousePosition)
{
	CMousePosition;

	GraphicsMovingOnCancel();

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::SelectRegionDrawWire(CPoint CMousePosition)
{
	CMousePosition;

	SelectRegionOnCancel();

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotGraphicDrawWire(CPoint CMousePosition)
{
	CMousePosition;
	GraphicsSelectedOnCancel();

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::GotClipboardDrawWire(CPoint CMousePosition)
{
	CMousePosition;
	GotClipboardOnCancel();

	return E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSchematicManager::DrawingWireDrawWire(CPoint CMousePosition)
{
	CMousePosition;
// will change to finish up current wire start new
	return E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE;
}

int	TCSchematicManager::FindGraphicId(int component_type)
{
	register TCSchematicObject	**PCSchematicObjectPtr;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	PCSchematicObjectPtr = CMSchematicManagerData.CGraphicList.GetData();

	for(int p = 0; p < count; p++)
	{
		if((*PCSchematicObjectPtr)->m_type == component_type) return p;
	
		PCSchematicObjectPtr++;
	}

	return -1;
}

void TCSchematicManager::AxisScrollXRight(void)
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormScrollXRight();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
void TCSchematicManager::AxisScrollXLeft(void)
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormScrollXLeft();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
void TCSchematicManager::AxisScrollYUp(void)
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormScrollYUp();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
void TCSchematicManager::AxisScrollYDown(void)
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;
	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormScrollYDown();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
void TCSchematicManager::AxisMagnify(void)
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormMagnify();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
void TCSchematicManager::AxisReduce(void)
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormReduce();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::AxisAutoScale(void)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	TCSchematicObject	*PSchematicObject;

	PSchematicObject = GetWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);

	if(!PSchematicObject) return;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	EraseComponentOutline();

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PSchematicObject->Clear(PCViewDC);
	PSchematicObject->WaveFormAutoScale();
	PSchematicObject->ReCreate();
	PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	DrawAll();
}

int	TCSchematicManager::FindWaveform(CString CRefDes)
{
	TCSchematicObject	*PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		if(PSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel != CRefDes) continue;

		return p;
	}

	return -1;
}

TCSchematicObject *TCSchematicManager::FindComponent(CString CRefDes)
{
	TCSchematicObject	*PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CRefDes.MakeUpper();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		CText = PSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		CText.MakeUpper();

		if(CText != CRefDes) continue;

		return PSchematicObject;
	}

	return NULL;
}

int TCSchematicManager::FindComponentId(CString CRefDes)
{
	TCSchematicObject	*PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		CText = PSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		if(CText != CRefDes) continue;

		return p;
	}

	return -1;
}

bool TCSchematicManager::SetFilterValues(TCFantasticFilter &CFantasticFilter)
{
	TCSchematicObject	*PSchematicObject;
	CFantasticFilter;

	int count = CFantasticFilter.ComponentList.GetSize();

	if(!count) return false;

	CString CText, CTemp;

	bool ok = true;

	int p;

	for(p = 0; p < count; p++)
	{
		CTemp = CFantasticFilter.ComponentList[p].CRefDesignator;

		PSchematicObject = FindComponent(CTemp);

		if(!PSchematicObject) 
		{
			ok = false;
			
			continue;
		}

		CText = FloatToMKSString(CFantasticFilter.ComponentList[p].value);

		PSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = CText;
	}

	//Bug fix. Ensure components are always enabled in the netlist.

	count = CMSchematicManagerData.CGraphicList.GetSize();

	for(p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		PSchematicObject->CMSchematicObjectData.CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);

		PSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = true;
		PSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = true;
		PSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER] = 0;
		PSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = 0;
	}

	return ok;
}

TCSchematicObject *TCSchematicManager::GetWaveform(CString CRefDes)
{
	TCSchematicObject	*PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		if(PSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel != CRefDes) continue;

		return PSchematicObject;
	}

	return NULL;
}

void TCSchematicManager::ResetActiveWaveform(void)
{
	SetActiveWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);
}

bool TCSchematicManager::SetActiveWaveform(CString CRefDes)
{
	if(!CMSchematicManagerData.PCView) return false;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	TCSchematicObject	*PSchematicObject;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		PSchematicObject->ClearLabel(PCViewDC, E_WAVEFORM_ENABLE);

		if(PSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel != CRefDes)
		{
			PSchematicObject->SetLabel(PCViewDC ,E_WAVEFORM_ENABLE, "Inactive", false);
		}
		else
		{
			PSchematicObject->SetLabel(PCViewDC ,E_WAVEFORM_ENABLE, "Active", false);
			CMSchematicManagerData.CActiveWaveformRefDesignator = PSchematicObject->GetLabel(E_WAVEFORM_DESIGNATOR);
		}

		PSchematicObject->RepasteLabel(PCViewDC, E_WAVEFORM_ENABLE);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return true;
}

bool TCSchematicManager::SetActiveWaveform(int id)
{
	if(!CMSchematicManagerData.PCView) return false;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	TCSchematicObject	*PSchematicObject;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		PSchematicObject->ClearLabel(PCViewDC, E_WAVEFORM_ENABLE);

		if(id != p)
		{
			PSchematicObject->SetLabel(PCViewDC ,E_WAVEFORM_ENABLE, "Inactive", false);
		}
		else
		{
			PSchematicObject->SetLabel(PCViewDC ,E_WAVEFORM_ENABLE, "Active", false);

			CMSchematicManagerData.CActiveWaveformRefDesignator = PSchematicObject->GetLabel(E_WAVEFORM_DESIGNATOR);
		}

		PSchematicObject->RepasteLabel(PCViewDC, E_WAVEFORM_ENABLE);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	return true;
}

bool TCSchematicManager::UpdateSchematicWaveforms(TCOutputWaveformData &COutputWaveformData)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;// bug fix 13th 2001
	if(IsBadReadPtr(&COutputWaveformData, 4))return false;

	TCSchematicObject *PSchematicObject;

	int count2 = COutputWaveformData.CRecords.GetSize();

	int count = CMSchematicManagerData.CGraphicList.GetSize();

//	TCSchematicObjectData CSchematicObjectData;

	CMSchematicManagerData.PCView->BeginWaitCursor();

	PCWaveformDataRuns->SetupMathFunctionData(); //5th sept to auto update calculator data display

	for(int q = 0; q < count; q++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		for(int p = 0; p < count2; p++)
		{
			TCOutputWaveformDataHeader &COutputWaveformDataHeader = COutputWaveformData.CRecords[p].CHeader;

			if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

			if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) continue;

			if(PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->type != COutputWaveformDataHeader.type) continue;

			PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals = COutputWaveformDataHeader.PCSignals;
			PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->PCWaveformDataRuns = PCWaveformDataRuns;// ensure latest run data pointer
					
			PSchematicObject->CMSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
			PSchematicObject->CMSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;

			SetSignalsDisplayedList(PSchematicObject);

//			CSchematicObjectData = PSchematicObject->CMSchematicObjectData;

//			PSchematicObject->SetSchematicObjectData(&GlobalCDCTemp, CSchematicObjectData);

			PSchematicObject->SetSchematicObjectData(&GlobalCDCTemp, PSchematicObject->CMSchematicObjectData);

			PSchematicObject->Paste(&GlobalCDCTemp, PSchematicObject->CMLocation);
		
			break;
		}
	}

	UpdateaAllTestPoints();

	UpdateOperatingPoints(COutputWaveformData);
	UpdateDeviceACCurrents(COutputWaveformData);

	DrawAll();

	CMSchematicManagerData.PCView->EndWaitCursor();

	return true;
}

bool TCSchematicManager::UpdateGraphicWaveforms(TCOutputWaveformData &COutputWaveformData, CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;
	if(IsBadReadPtr(&COutputWaveformData, 4)) return false;
	if(!PCWaveformDataRuns) return false;
	
	TCSchematicObject *PSchematicObject;

	int count2 = COutputWaveformData.CRecords.GetSize();

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObjectData CSchematicObjectData;

	CMSchematicManagerData.PCView->BeginWaitCursor();

	PCWaveformDataRuns->SetupMathFunctionData(); //5th sept to auto update calculator data display

	for(int q = 0; q < count; q++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		for(int p = 0; p < count2; p++)
		{
			TCOutputWaveformDataHeader &COutputWaveformDataHeader = COutputWaveformData.CRecords[p].CHeader;

			if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

			if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) continue;

			if(PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->type != COutputWaveformDataHeader.type) continue;

			PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals = COutputWaveformDataHeader.PCSignals;
			PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->PCWaveformDataRuns = PCWaveformDataRuns;// ensure latest run data pointer
					
			PSchematicObject->CMSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
			PSchematicObject->CMSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;

			SetSignalsDisplayedList(PSchematicObject);

			PSchematicObject->SetSchematicObjectData(&GlobalCDCTemp, PSchematicObject->CMSchematicObjectData);

			PSchematicObject->Paste(&GlobalCDCTemp, PSchematicObject->CMLocation);
		
			break;
		}
	}

	ChangeGraphicWaveform(CTestPointDataList);
	
	DrawAll();

	CMSchematicManagerData.PCView->EndWaitCursor();

	return true;
}

void TCSchematicManager::ChangeGraphicWaveform(CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList)
{
	TCSchematicObject *PSchematicObject;

	int count;
	int testpoint_count;

	testpoint_count = CTestPointDataList.GetSize();

	if(!testpoint_count) return;

	count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < count; p++)// update all graphs for all runs, may add selection later
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[p];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		for(int q = 0; q < testpoint_count; q++)
		{
			PSchematicObject->ChangeWaveform(CTestPointDataList[q]);
		}

		PSchematicObject->Paste(&GlobalCDCTemp, PSchematicObject->CMLocation);
	}
}

bool TCSchematicManager::UpdateWaveforms(TCOutputWaveformDataHeader &COutputWaveformDataHeader)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return false;

	if(IsBadReadPtr(&COutputWaveformDataHeader, 4)) return false;

	COutputWaveformDataHeader.PCWaveformDataRuns = PCWaveformDataRuns;// ensure latest run data pointer

	TCSchematicObjectData CSchematicObjectData;
	
	CSchematicObjectData = GCSuperSpiceDataBase.CMDefaults[E_WAVEFORM_COMPONENT];

	TCSchematicObject	*PSchematicObject;

	PSchematicObject = new TCSchematicObject;

	if(!PSchematicObject) return false;

	PSchematicObject->is_symbol_editor = is_symbol_editor;

	PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

	if(!PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return false;

	PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals = COutputWaveformDataHeader.PCSignals;
	
	CPoint CLocation;

	int	index =	FindWaveform(CMSchematicManagerData.CActiveWaveformRefDesignator);
 
	CMSchematicManagerData.PCView->BeginWaitCursor();

	unsigned short local_width;
	unsigned short local_height;

	int list_count;

	if(index > -1)
	{
		TCSchematicObjectData &CSchematicObjectDataLocal = CMSchematicManagerData.CGraphicList[index]->CMSchematicObjectData;

		CArray <TCDisplayedSignals, TCDisplayedSignals> CDisplayedSignalList;

		list_count = CSchematicObjectDataLocal.PCOutputWaveformDataHeader->CDisplayedSignalsList.GetSize();

		CDisplayedSignalList.SetSize(list_count);

		int r;

		for(int r = 0; r < list_count; r++) CDisplayedSignalList[r] = CSchematicObjectDataLocal.PCOutputWaveformDataHeader->CDisplayedSignalsList[r];

		local_width	= (unsigned short)(CSchematicObjectDataLocal.width * CMSchematicManagerData.zoom);
		local_height = (unsigned short)(CSchematicObjectDataLocal.height * CMSchematicManagerData.zoom);

		//kludge
		
		if(CSchematicObjectDataLocal.PCOutputWaveformDataHeader->type != E_SPICE_RECORD_MATH_0)
		{
			*CSchematicObjectDataLocal.PCOutputWaveformDataHeader = COutputWaveformDataHeader;
		}
		else
		{
			CSchematicObjectDataLocal.PCOutputWaveformDataHeader->CDisplayedSignalsList.SetSize(list_count);

			for(r = 0; r < list_count; r++) CSchematicObjectDataLocal.PCOutputWaveformDataHeader->CDisplayedSignalsList[r] = CDisplayedSignalList[r];
		}

		CSchematicObjectDataLocal.CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
		CSchematicObjectDataLocal.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;
	
		if(!PSchematicObject->Create(&GlobalCDCTemp, CSchematicObjectDataLocal, CMSchematicManagerData.zoom)) 
		{
			delete PSchematicObject;

			CMSchematicManagerData.PCView->EndWaitCursor();

			return false;
		}

		//restore data fucked by create.
		GCSuperSpiceDataBase.SetWaveFormDefaultSize(local_width, local_height);

		CLocation = CMSchematicManagerData.CGraphicList[index]->CMLocation;

		delete CMSchematicManagerData.CGraphicList[index];

		CMSchematicManagerData.CGraphicList[index] = PSchematicObject;

		PSchematicObject->ResetSelect();
		PSchematicObject->Paste(&GlobalCDCTemp, CLocation);

		SetActiveWaveform(index);
	}
	else
	{// use default location

		local_width	= CSchematicObjectData.width;
		local_height = CSchematicObjectData.height;

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_display_graphics &&
			!CMSchematicManagerData.CGraphicList.GetSize())// bit of a bodge
		{
			CSchematicObjectData.width = (unsigned short)(local_width/CMSchematicManagerData.zoom);
			CSchematicObjectData.height = (unsigned short)(local_height/CMSchematicManagerData.zoom);
		}

		CSchematicObjectData.CLabelListData[E_WAVEFORM_TITLE].CLabel = COutputWaveformDataHeader.CTitle;
		CSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
		CSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;
		CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMSchematicManagerData.CActiveWaveformRefDesignator;
		
		// Dont do border for graphics window 18th Jan 2014
		if(!GCSuperSpiceGlobalData.CDrawData.draw_waveform_page_border)
		{
			CSchematicObjectData.CLocation.y -= GCSuperSpiceGlobalData.CDrawData.wave_graph_no_border_y_offset;
		}

		CLocation = CSchematicObjectData.CLocation;

		if(CSchematicObjectData.PCOutputWaveformDataHeader)
		*CSchematicObjectData.PCOutputWaveformDataHeader = COutputWaveformDataHeader;

		if(!PSchematicObject->Create(&GlobalCDCTemp, CSchematicObjectData, CMSchematicManagerData.zoom)) 
		{
			delete PSchematicObject;

			CMSchematicManagerData.PCView->EndWaitCursor();

			return false;
		}

		//restore data fucked by create.
		GCSuperSpiceDataBase.SetWaveFormDefaultSize(local_width, local_height);			

		CMSchematicManagerData.CGraphicList.Add(PSchematicObject);

		PSchematicObject->ResetSelect();
		PSchematicObject->Paste(&GlobalCDCTemp, CLocation);

		m_last_created_id = CMSchematicManagerData.CGraphicList.GetSize() - 1;

		SetActiveWaveform(m_last_created_id);

		PCMLastCreatedGraphic = CMSchematicManagerData.CGraphicList.GetAt(m_last_created_id);

	}

	DrawAll();

	CMSchematicManagerData.PCView->EndWaitCursor();

	return true;
}


CString TCSchematicManager::ConvertVoltRefDes(CString CText)
{
	CString CParentRefDes;

	if(PCWaveformDataRuns)// convieniant, contains the
	{
		if(PCWaveformDataRuns->PCDoc)
		{
			CParentRefDes = PCWaveformDataRuns->PCDoc->CParentRefDes;
		}
		else
		{
			ASSERT(0);// program fuckup
		}
	}

	if(CParentRefDes == "") return CText; 

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
	{
		CText = CParentRefDes + ':' + CText;
	}
	else
	{
		CText +=  ':' + CParentRefDes;
	}

	return CText; 
}

CString TCSchematicManager::ConvertCurrentRefDes(CString CText)
{
	CString CParentRefDes;
	int index;

	if(PCWaveformDataRuns)// convieniant, contains the
	{
		if(PCWaveformDataRuns->PCDoc)
		{
			CParentRefDes = PCWaveformDataRuns->PCDoc->CParentRefDes;
		}
		else
		{
			ASSERT(0);// program fuckup
		}
	}

	if(CParentRefDes == "")  return CText;

	CString CTextTemp, CTemp;

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
	{
		CText = CParentRefDes + ':' + CText;
	}
	else
	{
		CTextTemp	= CText;
		CTemp		= CText;

		index = CTemp.Find('[');

		CTemp = CTemp.Left(index);

		CTextTemp.Replace(CTemp, "");

		CText = CTemp + ':' + CParentRefDes;

		CText += CTextTemp;
	}

	return CText; 
}

bool TCSchematicManager::GetVoltageSignalNames(TCSchematicObject *PCSchematicObject, CArray <CString, CString> &CDeviceNodes)
{
	CDeviceNodes.SetSize(0);

	int pin_count = PCSchematicObject->GetNumberOfPins();
	CString CText;

	if(!pin_count) return false;

	for(int p = 0; p < pin_count; p++)
	{
		CString CText = PCSchematicObject->GetPinLabel(p, E_COMPONENT_PIN_NET_NAME);

		if(CText == "0") continue;

	//	CText = ConvertVoltRefDes(CText);

		CDeviceNodes.Add(CText);
	}

	return true;
}

bool TCSchematicManager::GetCurrentSignalNames(TCSchematicObject *PCSchematicObject, CArray <CString, CString> &CDeviceNodes)
{
	CDeviceNodes.SetSize(0);

	CArray <CString, CString> CLocalDeviceNodes;

	PCSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CLocalDeviceNodes);

	int pin_count = PCSchematicObject->GetNumberOfPins();

	if(!pin_count) return false;

	int test_count = CLocalDeviceNodes.GetSize();

	if(!(pin_count <= test_count)) return false;// can occure

	CString CText, CAppend, CPinNumber;
	int bracket_index;

	for(int p = 0; p < pin_count; p++)
	{	 
		CText = PCSchematicObject->GetPinLabel(p, E_COMPONENT_PIN_NET_NAME);

		if(CText == "0") continue;

		CText = CLocalDeviceNodes[p];

		CText = ConvertCurrentRefDes(CText);

		if((PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
				PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC))
		{
			CAppend = ':';

			CPinNumber.Format("%d", p);

			bracket_index = CText.Find('[');

			CAppend += GSubCktCurrentPinStr + CPinNumber;

			CText.Insert(bracket_index, CAppend);
		}

		CDeviceNodes.Add(CText);
	}

	return true;
}

void TCSchematicManager::UpdateDeviceACCurrents(TCOutputWaveformData &COutputWaveformData)
{
	if(!COutputWaveformData.IsWaveformHeaderAvailable(E_SPICE_RECORD_AC)) return;//
//return; Add AC Currents
	TCOutputWaveformDataHeader &COutputWaveformDataHeader = COutputWaveformData.CRecords[E_SPICE_RECORD_AC].CHeader;

	if(IsBadReadPtr(COutputWaveformDataHeader.PCSignals, 4)) return;

	CArray <TCSignal, TCSignal&> &CSignals = *COutputWaveformDataHeader.PCSignals;

	if(!CSignals.GetSize()) return;

	TCSchematicObject *PCSchematicObject;
	CArray <CString, CString> CDeviceNodes;

	CString CRefDes, CLable, CText;
	double pi_2 = 6.283185307;
	double m;
	double im, ip, vpm, vpp, vnm, vnp, value, f, dvr, dvi, dv;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int view_type, points, index, p_index, n_index, tp_index, tn_index, pow_index;

	for(int p = 0; p < count; p++)// Spice outputs incorrect data for ac currents, so calculate them
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList[p];

		view_type = PCSchematicObject->CMSchematicObjectData.component_property_view_type;

		if(view_type != E_PROPERTY_RESISTOR && view_type != E_PROPERTY_CAPACITOR && view_type != E_PROPERTY_INDUCTOR) continue;
		
		CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);
		CLable	= PCSchematicObject->GetLabel(E_COMPONENT_VALUE);

		value = MKSStringToFloat(CLable);

		if(!value) continue;

		if(view_type == E_PROPERTY_RESISTOR)
		{
			m = MKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue);

			value *= m;		
		}

		if(view_type == E_PROPERTY_CAPACITOR)
		{
			m = MKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelValue);

			value *= m;
		}

		PCSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CDeviceNodes);

		CText = CDeviceNodes[0];// get first pin current name

		CText = ConvertCurrentRefDes(CText);

		index = COutputWaveformDataHeader.FindSignal(CText);

		if(index < 0) continue;

		CText.Replace("[i]", "[p]");

		pow_index  = COutputWaveformDataHeader.FindSignal(CText);

		CText = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist) CText = ConvertVoltRefDes(CText);

		p_index = COutputWaveformDataHeader.FindSignal(CText);

		CText = PCSchematicObject->CMSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist) CText = ConvertVoltRefDes(CText);

		n_index = COutputWaveformDataHeader.FindSignal(CText);

		if(p_index < 0) tp_index = 0;
		else tp_index = p_index;

		if(n_index < 0) tn_index = 0;
		else tn_index = n_index;

		TCSignal &CSignalF	= CSignals[0];
		TCSignal &CSignal	= CSignals[index];
		TCSignal &CSignalVp	= CSignals[tp_index];
		TCSignal &CSignalVn	= CSignals[tn_index];
		
		points = CSignal.CMagnitudeData.CX.GetSize();

		if(!points) continue;

		CSignal.CPhaseData.CX.SetSize(points);// make sure phase is available

		if(pow_index > -1) CSignals[pow_index].CPhaseData.CX.SetSize(points);// make sure phase is available

		for(int q = 0; q < points; q++)
		{
			f = CSignalF.CMagnitudeData.CX[q];
			
			if(!f) continue;//should'nt happen;

			if(p_index > -1)
			{
				vpm = CSignalVp.CMagnitudeData.CX[q];
				vpp = CSignalVp.CPhaseData.CX[q];
			}
			else 
			{
				vpm = 0;
				vpp = 0;
			}

			if(n_index > -1)
			{
				vnm = CSignalVn.CMagnitudeData.CX[q];
				vnp = CSignalVn.CPhaseData.CX[q];
			}
			else
			{
				vnm = 0;
				vnp = 0;
			}

			dvr = vpm * cos(vpp) - vnm * cos(vnp);
			dvi = vpm * sin(vpp) - vnm * sin(vnp);

			dv = sqrt(dvr*dvr + dvi*dvi);
			im = dv;
			
			if(view_type == E_PROPERTY_RESISTOR)
			{
				im /= value;

				ip = atan2(dvi, dvr);
			}
			else if(view_type == E_PROPERTY_CAPACITOR)
			{
				im *= (value*pi_2*f);

				ip = atan2(dvr, -dvi);
			}
			else
			{
				im /= (value*pi_2*f);

				ip = atan2(-dvr, dvi);
			}

			CSignal.CMagnitudeData.CX[q]	= im;
			CSignal.CPhaseData.CX[q]		= ip;

			if(pow_index > -1)
			{
				TCSignal &CSignalP	= CSignals[pow_index];

				CSignalP.CMagnitudeData.CX[q]	= dv*im;
				CSignalP.CPhaseData.CX[q]		= atan2(dvi, dvr) + ip;
			}
		}
	}
}

void TCSchematicManager::UpdateOperatingPoints(TCOutputWaveformData &COutputWaveformData)
{
	TCSchematicObject *PCSchematicObject;
	TCTestPointData CTestPointData;
	int q, pin_count, signal_index;
	CString CText;
	double data;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC)  return;

	if(!COutputWaveformData.CRecords.GetSize()) return;

	if(!COutputWaveformData.IsWaveformHeaderAvailable(E_SPICE_RECORD_OPERATING_POINT)) 
	{
		CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

		return;
	}

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = COutputWaveformData.CRecords[E_SPICE_RECORD_OPERATING_POINT].CHeader;

	if(IsBadReadPtr(COutputWaveformDataHeader.PCSignals, 4))
	{
		ASSERT(0);

		CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

		return;
	}

	CArray <TCSignal, TCSignal&> &CSignals = *COutputWaveformDataHeader.PCSignals;
	CArray <CString, CString> CDeviceNodes;
	CString CTextTemp, CTemp, CRefDes;
	char tst;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int mos_sign = 1;

	for(int p = 0; p < count; p++)// update all graphs for all runs, may add selection later
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList[p];

		if(PCSchematicObject->m_type == E_WIRE_COMPONENT) 
		{
			CText = PCSchematicObject->GetLabel(E_WIRE_NET_NAME);
			
			if(CText == "0")
			{
				PCSchematicObject->SetLabel(PCViewDC, E_WIRE_NET_VOLTAGE, "0v");

				continue;
			}
			
			CText = ConvertVoltRefDes(CText);

			signal_index = COutputWaveformDataHeader.FindSignal(CText);

			if(signal_index < 0) 
			{
				PCSchematicObject->SetLabel(PCViewDC, E_WIRE_NET_VOLTAGE, "V?");

				continue;
			}

			TCSignal &CSignal = CSignals[signal_index];

			if(IsBadCodePtr((FARPROC)&CSignal)) 
			{
				CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

				return;
			}

			if(!CSignal.CMagnitudeData.CX.GetSize())
			{
				CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

				return;
			}

			data = CSignal.CMagnitudeData.CX[0];

			CText = FloatToMKSString(data);

			CText += 'v';

			PCSchematicObject->SetLabel(PCViewDC, E_WIRE_NET_VOLTAGE, CText);

			continue;
		}

		pin_count = PCSchematicObject->GetNumberOfPins();

		if(pin_count < 2 && PCSchematicObject->m_type != E_TEST_MARKER) continue;

		PCSchematicObject->CMSchematicObjectData.GetDeviceCurrentNodeNames(CDeviceNodes);

		CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		CRefDes.MakeLower();

		if(!(pin_count < CDeviceNodes.GetSize() + 1)) continue;

		CString CAppend, CPinNumber;
		int bracket_index;

		for(q = 0; q < pin_count; q++)
		{
			tst = CRefDes.GetAt(0);

			if(tst == 'c')// daft spice has dc currents in caps!
			{
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_CURENT, "0a");
			}

			if(tst == 'w')// daft spice has dc currents in caps!
			{
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_CURENT, "A?");

				continue;
			}

			CText = CDeviceNodes[q]; 

			CText = ConvertCurrentRefDes(CText);

			//added 12th Aug 2002 to support operating point mouse probing
			if((PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT ||
				PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC))
			{
				CAppend = ':';

				CPinNumber.Format("%d", q);

				bracket_index = CText.Find('[');

				CAppend += GSubCktCurrentPinStr + CPinNumber;

				CText.Insert(bracket_index, CAppend);
			}

			signal_index = COutputWaveformDataHeader.FindSignal(CText);

			//Added for device designer 9th June
			mos_sign = 1;

			if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_MOSFET)
			if(signal_index < 0)
			{
				CText.Replace("[is]", "[id]");

				signal_index = COutputWaveformDataHeader.FindSignal(CText);

				mos_sign = -1;
			}

			if(tst != 'c')
			if(signal_index < 0 && tst != 'i') 
			{			
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_CURENT, "A?");
			}
			else if(tst != 'i')
			{
				TCSignal &CSignal = CSignals[signal_index];

				if(IsBadCodePtr((FARPROC)&CSignal)) 
				{
					CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

					return;
				}

				if(!CSignal.CMagnitudeData.CX.GetSize()) 
				{
					CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

					return;
				}

				data = CSignal.CMagnitudeData.CX[0];

				data *= mos_sign;

				//change the sign of 2nd pin for two pin spice devices only
				if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_DOT_MODEL || 
				   PCSchematicObject->CMSchematicObjectData.attached_model_type == 	E_SPICE_GENERATOR)
					if(pin_count == 2) if(q == 1) data = -data;

				CText = FloatToMKSString(data);

				CText += 'a';
			
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_CURENT, CText);
			}
			else if(PCSchematicObject->CMSchematicObjectData.PCGeneratorData)// Cheat to get pin current for isources
			{  
				data = PCSchematicObject->CMSchematicObjectData.EvaluateComponentValue(PCSchematicObject->CMSchematicObjectData.PCGeneratorData->CDCGeneratorData.CDCVoltage);

				if(pin_count == 2) if(q == 1) data = -data;

				CText = FloatToMKSString(data);

				CText += 'a';
			
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_CURENT, CText);
			}

			// now do pin voltages
			CText = PCSchematicObject->CMSchematicObjectData.CPinListData[q].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

			if(CText == "0")
			{
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_VOLTAGE, "0v");

				continue;
			}

			if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)

				CText = ConvertVoltRefDes(CText);

			signal_index = COutputWaveformDataHeader.FindSignal(CText);

			if(signal_index < 0) 
			{
				PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_VOLTAGE, "V?");

				continue;
			}

			TCSignal &CSignal = CSignals[signal_index];

			if(IsBadCodePtr((FARPROC)&CSignal)) 
			{
				CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

				return;
			}

			if(!CSignal.CMagnitudeData.CX.GetSize()) 
			{
				CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

				return;
			}

			data = CSignal.CMagnitudeData.CX[0];

			CText = FloatToMKSString(data);

			CText += 'v';

			PCSchematicObject->SetPinLabel(PCViewDC, q, E_COMPONENT_PIN_VOLTAGE, CText);
		}

		SetupOpPoints(COutputWaveformDataHeader, PCSchematicObject);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	CalculateComponentPower();
}

void TCSchematicManager::UpdateDesignerValues(int select_mode)
{
	if(select_mode != E_DEVICE_DESIGNER_SELECTED_MOSFETS) UpdateDesignerResistanceValues(select_mode);
	if(select_mode != E_DEVICE_DESIGNER_SELECTED_RESISTORS) UpdateDesignerMosfetValues(select_mode);

	DrawAll();
}

void TCSchematicManager::SetupOpPoints(TCOutputWaveformDataHeader &COutputWaveformDataHeader, TCSchematicObject *PCSchematicObject)
{
	if(!COutputWaveformDataHeader.PCSignals) return;

	if(!COutputWaveformDataHeader.PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = *COutputWaveformDataHeader.PCDoc->CMSuperSpiceDocData.PCAnalysisSetup;

	if(!CAnalysisSetup.CDCSetupData.display_device_op_points) return; // to add in to gui

	CArray <TCSignal, TCSignal&> &CSignals = *COutputWaveformDataHeader.PCSignals;

	CArray <TCNameValueData, TCNameValueData>	&COpPoints = PCSchematicObject->CMSchematicObjectData.COpPoints;

	COpPoints.SetSize(0); // Clear old data

	TCNameValueData CNameValue;

	CString CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

	CRefDes.MakeLower();

	char ctype;
	CString CText, CName; 
	int signal_index, count;

	ctype = CRefDes.GetAt(0);

	int spice_type = 0;

	switch(ctype)
	{
		case 'm':	spice_type = E_SPICE_NMOS;	break;
		case 'q':	spice_type = E_SPICE_NPN;	break;
		case 'j':	spice_type = E_SPICE_NJF;	break;
		case 'z':	spice_type = E_SPICE_NMF;	break;
		case 'd':	spice_type = E_SPICE_D;		break;
		case 'r':	spice_type = E_SPICE_R;		break;
		case 'c':	spice_type = E_SPICE_C;		break;
		case 'l':	spice_type = E_SPICE_L;		break;

		default: return;
	}

	TCSpiceNodeNames &CSpiceNodeNames = GCSuperSpiceDataBase.CSpiceNodeNames[spice_type];

	count = CSpiceNodeNames.CDeviceNodes.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(spice_type == E_SPICE_NMOS && (p > 12)) continue;// Fudge, Don't display capacitances as not valid

		CName = CSpiceNodeNames.CDeviceNodes[p];

		if(CName == "p") continue; // power is always zero at this point

		CText = CRefDes + '[' + CName + ']';

		signal_index = COutputWaveformDataHeader.FindSignal(CText);

		if(signal_index < 0) continue;

		CNameValue.CName = CName;

		TCSignal &CSignal = CSignals[signal_index];

		if(IsBadCodePtr((FARPROC)&CSignal)) continue;

		CNameValue.CValue = FloatToMKSString(CSignal.CMagnitudeData.CX[0]);

		COpPoints.Add(CNameValue);
	}
}

void TCSchematicManager::UpdateDesignerMosfetValues(int select_mode)
{
	TCSchematicObject *PCSchematicObject;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC)  return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int type;

	double vd, vs, id, vg, vb=0, length_width, vds, vgs, vbs, temp;
	CString CLable;
	int length;
	int designer_mode;

	TCSpiceParameters *PCSpiceParameters;

	int level;

	for(int q = 0; q < count; q++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PCSchematicObject->CMSchematicObjectData.component_property_view_type != E_PROPERTY_MOSFET) continue;

		type = (int) PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];
		
		if(!type || !select_mode) continue;

		designer_mode = (int) PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_CALC_MODE];

		CLable = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_VOLTAGE);

		vd = MKSStringToFloat(CLable);

		CLable = PCSchematicObject->GetPinLabel(2, E_COMPONENT_PIN_VOLTAGE);

		vs = MKSStringToFloat(CLable);

		vds = vd - vs;

		CLable = PCSchematicObject->GetPinLabel(1, E_COMPONENT_PIN_VOLTAGE);

		vg = MKSStringToFloat(CLable);

		vgs = vg - vs;

		CLable = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_CURENT);

		length = CLable.GetLength();

		CLable = CLable.Left(length -1);// remove last a

		id = MKSStringToFloat(CLable);

		if(!id) continue;

		CLable = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabelValue;

		temp = MKSStringToFloat(CLable);

		if(temp > 0) id /= temp;

		if(type == E_VALUE_DESIGNER_POSITIVE_VOLTS) id = -id;//swooped generator terminals

		level = 0;

		if(level != 1 && level != 2 && level != 3) designer_mode = E_COMPONENT_FET_WIDTH;
		 
		if(designer_mode == E_COMPONENT_FET_WIDTH)
			CLable = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue;
		else 
			CLable = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue;

		length_width = MKSStringToFloat(CLable);

		CLable = PCSchematicObject->GetPinLabel(3, E_COMPONENT_PIN_VOLTAGE);

		if(CLable == "") vb = vs;// 3 terminal mosfet
		else vb = MKSStringToFloat(CLable);

		vbs = vb - vs;

		PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(PCSchematicObject->CMSchematicObjectData.CSpiceParameters);

		if(!PCSpiceParameters) continue;

		if(!PCSpiceParameters->MosfetDesigner(vds, vgs, vbs, id, designer_mode, length_width)) continue;

		CLable = FloatToMKSString(length_width);

		PCSchematicObject->CMSchematicObjectData.CLabelListData[designer_mode].CLabelValue = CLable;

		PCSchematicObject->CMSchematicObjectData.FormatLabel();

		CLable = PCSchematicObject->GetLabel(designer_mode);

		PCSchematicObject->SetLabel(PCViewDC, designer_mode, CLable, false);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::UpdateDesignerResistanceValues(int select_mode)
{
	TCSchematicObject *PCSchematicObject;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC)  return;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int type;

	double volts_pos, volts_neg, current, resistance;
	CString CLable, CRefDes;
	int length;

	for(int q = 0; q < count; q++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PCSchematicObject->CMSchematicObjectData.component_property_view_type != E_PROPERTY_RESISTOR) continue;

		type = (int) PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];

		if(!type || !select_mode) continue;

		CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

		CLable = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_VOLTAGE);

		volts_pos = MKSStringToFloat(CLable);

		CLable = PCSchematicObject->GetPinLabel(1, E_COMPONENT_PIN_VOLTAGE);

		volts_neg = MKSStringToFloat(CLable);

		CLable = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_CURENT);

		length = CLable.GetLength();

		CLable = CLable.Left(length -1);// remove last a

		current = MKSStringToFloat(CLable);

		if(!current) continue;

		if(type == E_VALUE_DESIGNER_POSITIVE_VOLTS) current = -current;//swooped generator terminals

		resistance = (volts_pos - volts_neg)/current;

		CLable = FloatToMKSString(resistance);

		PCSchematicObject->SetLabel(PCViewDC, E_COMPONENT_VALUE, CLable, false);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::CalculateComponentPower(void)
{
	TCSchematicObject *PCSchematicObject;
	int pin_count;

	int count = CMSchematicManagerData.CGraphicList.GetSize();
	float voltage, current, power;
	CString CVoltage, CCurrent;

	for(int q = 0; q < count; q++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PCSchematicObject->m_type)
			if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE) continue;

		pin_count = PCSchematicObject->GetNumberOfPins();
		
		if(!pin_count)  continue;

		power = 0;

		for(int p = 0; p < pin_count; p++)
		{
			CVoltage = PCSchematicObject->GetPinLabel(p, E_COMPONENT_PIN_VOLTAGE);
			CCurrent = PCSchematicObject->GetPinLabel(p, E_COMPONENT_PIN_CURENT);

			if(CVoltage == "") continue;
			if(CCurrent == "") continue;

			if(CVoltage.GetAt(CVoltage.GetLength() == 'v')) CVoltage = CVoltage.Left(CVoltage.GetLength() - 1);
			if(CCurrent.GetAt(CCurrent.GetLength() == 'a')) CCurrent = CCurrent.Left(CCurrent.GetLength() - 1);

			voltage = (float)MKSStringToFloat(CVoltage);
			current = (float)MKSStringToFloat(CCurrent);

			power += voltage * current;
		}

		int sign = GCSuperSpiceDataBase.GetSpicePowerPolarity(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType);

		if(PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray.GetSize() <= E_RESERVED_INT_COMPONENT_DATA_MAX)
			PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER] = power * sign;
	}
}

void TCSchematicManager::UpdateaAllTestPoints(void)
{
	TCSchematicObject *PSchematicObject;
	TCTestPointData CTestPointData;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int q = 0; q < count; q++)// update all graphs for all runs, may add selection later
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_TEST_MARKER) continue;

		CTestPointData.CNew		= PSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
		CTestPointData.new_type = PSchematicObject->CMSchematicObjectData.version;
		CTestPointData.COld      = "";
		CTestPointData.old_type = -1;
		CTestPointData.update_graph_views = true;// used to update graph windows
		CTestPointData.version = PSchematicObject->CMSchematicObjectData.version;

		ChangeWaveform(CTestPointData);
	}
}

void TCSchematicManager::ChangeWaveformsFromList(CArray <CString, CString> &CSignalList)
{
	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	TCSchematicObject *PSchematicObject;

	ClearAllWaveforms(false);

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	TCTestPointData CTestPointData;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	int signal_count = CSignalList.GetSize();

	CString CPlotName, CWaveformName;

	bool f_noise_waveform = 0;//only change noise graph for noise waveforms

	for(int q = 0; q < count; q++)// update all active graphs for all runs, may add selection later
	{
		if(f_noise_waveform) break;

		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		CPlotName = PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->CPlotName;
		
		CPlotName.MakeLower();

		if(CPlotName.Find("noise") > -1) f_noise_waveform = 1;

		for(int q = 0; q < signal_count; q++)
		{
			CTestPointData.CNew = CSignalList[q];

			CTestPointData.new_type = GCSuperSpiceGlobalData.CConfigData.CTestPointData.new_type;

			if(!PSchematicObject->ChangeWaveform(CTestPointData)) continue;
		}

		PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	DrawAll();
}

void TCSchematicManager::ChangeWaveform(TCTestPointData &CTestPointData)
{
	TCSchematicObject *PSchematicObject;

	CString CPlotName, CWaveformName;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	if(CTestPointData.clear_waveforms) ClearAllWaveforms();

	for(int q = 0; q < count; q++)// update all active graphs for all runs, may add selection later
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		CPlotName = PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->CPlotName;
		
		CPlotName.MakeLower();

		if(CPlotName.Find("noise") > -1) continue; //dont update waveform graphs with test point moves

		if(!PSchematicObject->ChangeWaveform(CTestPointData)) continue;

		PSchematicObject->Paste(&GlobalCDCTemp, PSchematicObject->CMLocation);
	}
}

void TCSchematicManager::ChangeColour(TCTestPointData &CTestPointData)
{
	TCSchematicObject *PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int q = 0; q < count; q++)// update all graphs for all runs, may add selection later
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		if(!PSchematicObject->ChangeColour(CTestPointData)) continue;

		PSchematicObject->Paste(&GlobalCDCTemp, PSchematicObject->CMLocation);
	}
}

void TCSchematicManager::SetGraphSize(TCSchematicObject *PCSchematicObject, CRect &CWindowData)
{
	int id;

	if(CLastGraphSize == CWindowData) return;

	CLastGraphSize = CWindowData;

	if(!PCSchematicObject) 
	{
		id = FindGraphicId(E_WAVEFORM_COMPONENT);// find first waveform object;

		if(id < 0) return;

		PCSchematicObject = CMSchematicManagerData.CGraphicList[id];
	}

	if(!PCSchematicObject) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC, NULL);

	CPoint CLocation = PCSchematicObject->CMLocation;

	CPoint CobjectLocation = CLocation;

	CLocation += CMSchematicManagerData.CViewPortOrigin;

// change size via zoom 

	float zoom = CMSchematicManagerData.zoom;

	PCSchematicObject->CMSchematicObjectData.width  = (unsigned short) (CWindowData.Width() / zoom); 
	PCSchematicObject->CMSchematicObjectData.height = (unsigned short) (CWindowData.Height() / zoom);

	PCSchematicObject->Zoom(CMSchematicManagerData.zoom);// recreates with new size;

	PCSchematicObject->Paste(PCViewDC, CobjectLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	DrawAll();
}

void TCSchematicManager::ChangeColour(CPoint CPosition, int colour)
{
	OutlineGraphics(CPosition);

	if(!PCMLastOutlinedComponent) return;

	CPoint COffsetPosition = CMLastOutlinedMousePosition - CMSchematicManagerData.CViewPortOrigin;

	PCMLastOutlinedComponent->GetWaveformData(CCursorData, COffsetPosition);

	TCTestPointData CTestPointData;

	if(!CCursorData.PCSignalY) return;

	TCSignal &CYSignal = *CCursorData.PCSignalY;

	CTestPointData.COld = "";
	CTestPointData.CNew = CYSignal.CName;
	CTestPointData.new_type = CCursorData.signal_type;
	CTestPointData.old_type = colour;
	CTestPointData.update_graph_views = true;
	CTestPointData.version = -1;

	ChangeColour(CTestPointData);

	DrawAll();
}

void TCSchematicManager::ChangeGraphBKGColour(CPoint CPosition, int colour)
{
	OutlineGraphics(CPosition);

	if(!PCMLastOutlinedComponent) return;

	if(PCMLastOutlinedComponent->m_type != E_WAVEFORM_COMPONENT) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PCMLastOutlinedComponent->ChangeBKGColour(colour);

	PCMLastOutlinedComponent->Paste(PCViewDC, PCMLastOutlinedComponent->CMLocation);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::ChangeAllGraphBKGColours(CDC *PDC, int colour)
{
	TCSchematicObject *PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int q = 0; q < count; q++)// update all graphs for all runs, may add selection later
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		// for restoring after a print;
		if(colour != -1) PSchematicObject->original_bck_colour = PSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->background_colour;
		else colour = PSchematicObject->original_bck_colour;

		PSchematicObject->ChangeBKGColour(colour);

		PSchematicObject->Paste(PDC, PSchematicObject->CMLocation);
	}
}

void TCSchematicManager::ClearAllWaveforms(bool redraw)
{
	TCSchematicObject *PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CString CText;

	for(int q = 0; q < count; q++)// update all graphs for all runs, may add selection later
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		CText = PSchematicObject->GetLabel(E_WAVEFORM_ENABLE);

		if(CText != "") if(CText.GetAt(0) != 'A') continue;

		PSchematicObject->ClearAllWaveforms();

		PSchematicObject->Paste(&GlobalCDCTemp, PSchematicObject->CMLocation);
	}

	if(redraw) DrawAll();
}

void TCSchematicManager::UpdateMarchingWaveforms(int run_number)
{
	TCSchematicObject *PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	for(int q = 0; q < count; q++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		PSchematicObject->UpdateMarchingWaveform(PCViewDC, run_number);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::SetupMarchingWaveforms(TCWaveformDataRuns *PCWaveformDataRunsNew, CArray <TCSignal, TCSignal&> *PCSignalsNew, int waveform_type, int run_number)
{
	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	TCSchematicObject *PSchematicObject;

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	for(int q = 0; q < count; q++)
	{
		PSchematicObject = CMSchematicManagerData.CGraphicList[q];

		if(PSchematicObject->m_type != E_WAVEFORM_COMPONENT) continue;

		PSchematicObject->SetupMarchingWaveforms(PCWaveformDataRunsNew, PCSignalsNew, waveform_type, run_number);

		PSchematicObject->Paste(PCViewDC, PSchematicObject->CMLocation);
	}

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}


int TCSchematicManager::CreateGraphic(TCSchematicObject *PGraphicsObject, TCSchematicObjectData &CSchematicObjectData)
{
	if(!PGraphicsObject) return -1;

	CDC CDCTemp;

	CDCTemp.CreateCompatibleDC(NULL);

	if(!PGraphicsObject->Create(&CDCTemp, CSchematicObjectData, CMSchematicManagerData.zoom)) 
	{
		return -1;
	}

	CMSchematicManagerData.CGraphicList.Add(PGraphicsObject);

	m_last_created_id = CMSchematicManagerData.CGraphicList.GetSize() - 1;

	PCMLastCreatedGraphic = CMSchematicManagerData.CGraphicList.GetAt(m_last_created_id);

	if(PCMLastCreatedGraphic) if(is_symbol_editor) GetandSetNewPinData(PCMLastCreatedGraphic);

	return m_last_created_id;		
}
 
int TCSchematicManager::CreateGraphic(TE_TYPE_OF_COMPONENT graphic) 
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = new TCSchematicObject;

	if(!PSchematicObject) return false;

	PSchematicObject->is_symbol_editor = is_symbol_editor;

	PSchematicObject->m_type = (unsigned short) graphic;

	int id = CreateGraphic(PSchematicObject, GCSuperSpiceDataBase.CMDefaults[(int)graphic]);

	if(id < 0) delete PSchematicObject;
	
	m_last_created_id = CMSchematicManagerData.CGraphicList.GetSize() - 1;

	if(id > -1)
	{
		PCMLastCreatedGraphic = CMSchematicManagerData.CGraphicList.GetAt(id);
	}

	return id;
		
}
int TCSchematicManager::CreateGraphic(TCSchematicObjectData &CSchematicObjectData) 
{
	TCSchematicObject	*PSchematicObject;

	PSchematicObject = new TCSchematicObject;

	if(!PSchematicObject) return false;

	PSchematicObject->is_symbol_editor = is_symbol_editor;

	int id = CreateGraphic(PSchematicObject, CSchematicObjectData);

	if(id < 0) 
	{
		delete PSchematicObject;

		return -1;
	}
	
	m_last_created_id = CMSchematicManagerData.CGraphicList.GetSize() - 1;

	PCMLastCreatedGraphic = CMSchematicManagerData.CGraphicList.GetAt(id);

	return id;
		
}
void TCSchematicManager::SetPageData(TCSchematicPageData &CPageData)
{
	*CMSchematicManagerData.PCPageData	= CPageData;
}

TCSchematicPageData &TCSchematicManager::GetPageData(void)
{
	return *CMSchematicManagerData.PCPageData;
}

bool TCSchematicManager::UpdateFloatingCursor(TCSchematicObject *PCSchematicObject, CPoint CMousePosition)
{
	if(!PCSchematicObject) return false;

	if(!PCSchematicObject->GetWaveformData(CCursorData, CMousePosition)) 
	{
		CMousePosition += CMSchematicManagerData.CViewPortOrigin;

		MoveCursor(active_cursor, CMousePosition);

		CCursorData.CSignalNameHeader = "Signal: ";
		CCursorData.CSignalName = "None Selected";

		SetDataCursorBar(CCursorData);

		return false;
	}


	// updates axis labels dynamically
	if(GCSuperSpiceGlobalData.CWaveformData.auto_axis)
	{
		if(PCSchematicObject->ReLabelRequired())
		{
			if(PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader)
			{
				if(PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->multy_magnitude_axis ||
					PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->multy_phase_axis) 
						ReLabelAxis(PCSchematicObject);			
				else 
				{
					ReLabelAxis(PCSchematicObject);
				//	ReLabelAxisSignalNames(PCSchematicObject);
				}
			}
		}
	}

	ReScaleOnWaveformObjectChange(PCSchematicObject);

	CMousePosition += CMSchematicManagerData.CViewPortOrigin;

	if(!CCursorData.is_xindex) CMousePosition.y -= CCursorData.delta_y;
	else CMousePosition.x -= CCursorData.delta_x;

	MoveCursor(active_cursor, CMousePosition);

	SetDataCursorBar(CCursorData);

	CString CText = CCursorData.CSignalNameHeader;// "Waveform data: ";

	CText += ' ' + CCursorData.CSignalName;

	CText += ": X=";

	CText += FloatToMKSString(CCursorData.x1);

	CText += ", Y=";

	CText += FloatToMKSString(CCursorData.y1);

	CGlobalStatusMessage = CText;

	return true;
}

void TCSchematicManager::ReScaleOnWaveformObjectChange(TCSchematicObject *PCSchematicObject)
{
	if(PCWaveformDataRuns->CRuns.GetSize() != 1) return;

	if(PCSchematicObject == PCLastWaveformGraphic) return;// 11 may 2003 changed from below

//	if(PCSchematicObject == PCLastWaveformGraphic && !PCMLastOutlinedComponent) return;

	if(!PCWaveformDataRuns) return;

	SetSignalsDisplayedList(PCSchematicObject);

	int type = PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->type;
	unsigned short object_width = PCSchematicObject->CMSchematicObjectData.width;
	unsigned short object_height=PCSchematicObject->CMSchematicObjectData.height;

	PCWaveformDataRuns->CRuns[0]->CRecords[type].CHeader.active_magnitude_axis_index = PCSchematicObject->active_magnitude_axis_index;
	PCWaveformDataRuns->CRuns[0]->CRecords[type].CHeader.active_phase_axis_index	= PCSchematicObject->active_phase_axis_index;

	PCWaveformDataRuns->SetScaleFactors(object_width, object_height, type, CMSchematicManagerData.zoom);
/*
	CRect CZoomRect = PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->CZoomRectangle;

	if(CZoomRect.IsRectEmpty())
	{
		PCSchematicObject->WaveFormAutoScale();
		PCWaveformDataRuns->SetScaleFactors(object_width, object_height, type, CMSchematicManagerData.zoom);
	}
	else
	{
		PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader->WaveformZoom(CZoomRect);
	}
*/
	PCLastWaveformGraphic = PCSchematicObject;
}

void TCSchematicManager::SwopAxis(TCSchematicObject *PCSchematicObject, CPoint CLocation)
{
	if(!PCSchematicObject) return;

	// this id's up the current index
	CLocation -= CMSchematicManagerData.CViewPortOrigin;

	// true, ignore the 'ignor update of current waveform selected'
	if(!PCSchematicObject->GetWaveformData(CCursorData, CLocation, true)) return;

	ReLabelAxis(PCSchematicObject);
}

void TCSchematicManager::ReLabelAxis(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;
	if(!PCWaveformDataRuns) return;
	if(!PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PCSchematicObject->ClearAllLabels(PCViewDC);

	SetSignalsDisplayedList(PCSchematicObject);

	PCSchematicObject->ReLabelAxis();			// only updates if changed, or not set already

	PCSchematicObject->RepasteAllLabels(PCViewDC);

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCSchematicManager::SetSignalsDisplayedList(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;
	if(!PCWaveformDataRuns) return;
	if(!PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	if(PCWaveformDataRuns->CRuns.GetSize() == 1)
	{
		TCOutputWaveformDataHeader &CHeader = *PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader;

		TCOutputWaveformDataHeader &COutputWaveformDataHeader = PCWaveformDataRuns->CRuns[0]->CRecords[CHeader.type].CHeader;

		COutputWaveformDataHeader.SetDisplayedSignals(CHeader);
	}
}

void TCSchematicManager::ReLabelAxisSignalNames(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;

	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);

	PCSchematicObject->ReLabelAxisSignalNames(PCViewDC);		

	CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}
//////////////////////////////////////////////////////////////////
TCDrawSelectionRegion::TCDrawSelectionRegion()
{
	sm_thickness.cx		= 1;
	sm_thickness.cy		= 1;
	f_already_deleted	= false;
	m_style				= 0;

	CRect CDefaultRect(0,0,0,0);

	CMNewSelectionBox   = CDefaultRect;
	CMLastSelectionBox	= CDefaultRect;
	CMFirstSelectionBox	= CDefaultRect;
}

void TCDrawSelectionRegion::SetStyle(int style)
{
	m_style = style;
}
TCDrawSelectionRegion::~TCDrawSelectionRegion()
{

}

void TCDrawSelectionRegion::Start(CDC *PCViewDC, CPoint CMousePosition)
{
	if(!PCViewDC) return;

	if(CMousePosition.y < 0) CMousePosition.y = 0;
	if(CMousePosition.x < 0) CMousePosition.x = 0;

	CMLastSelectionBox.top		= CMousePosition.y;
	CMLastSelectionBox.left		= CMousePosition.x;
	CMLastSelectionBox.bottom   = CMousePosition.y;
	CMLastSelectionBox.right	= CMousePosition.x;

	f_already_deleted = false;

	CMFirstMousePosition = CMousePosition;

	CMFirstSelectionBox = CMLastSelectionBox;

	PCViewDC->DrawDragRect(&CMLastSelectionBox, sm_thickness, NULL, sm_thickness);
}

CPoint TCDrawSelectionRegion::GetFirstMousePosition(void)
{
	return CMFirstMousePosition;
}

void TCDrawSelectionRegion::Continue(CDC *PCViewDC, CPoint CMousePosition)
{
	if(!PCViewDC) return;

	CMNewSelectionBox.top		= CMLastSelectionBox.top;
	CMNewSelectionBox.left		= CMLastSelectionBox.left;
	CMNewSelectionBox.bottom	= CMousePosition.y;
	CMNewSelectionBox.right		= CMousePosition.x;

	if(CMousePosition.x < CMFirstSelectionBox.left)
	{	
		CMNewSelectionBox.left		= CMousePosition.x;
		CMNewSelectionBox.right		= CMLastSelectionBox.right;		
	}

	if(CMousePosition.y < CMFirstSelectionBox.top)
	{
		CMNewSelectionBox.bottom	= CMLastSelectionBox.bottom;
		CMNewSelectionBox.top		= CMousePosition.y;
	}

	PCViewDC->DrawDragRect(&CMNewSelectionBox, sm_thickness, &CMLastSelectionBox, sm_thickness);


	CMLastSelectionBox.bottom	= CMousePosition.y;
	CMLastSelectionBox.right	= CMousePosition.x;	


	if(CMousePosition.x < CMFirstSelectionBox.left)
	{	
		CMLastSelectionBox.left		= CMousePosition.x;
		CMLastSelectionBox.right	= CMNewSelectionBox.right;
	}

	if(CMousePosition.y < CMFirstSelectionBox.top)
	{
		CMLastSelectionBox.top		= CMousePosition.y;
		CMLastSelectionBox.bottom	= CMNewSelectionBox.bottom;
	}
}

CRect TCDrawSelectionRegion::GetPreSelectionBox(CPoint CMousePosition)
{
	CRect CLastSelectionBox = CMLastSelectionBox;
	CRect CNewSelectionBox;
	CRect CFirstSelectionBox = CMFirstSelectionBox;

	CNewSelectionBox.top	= CLastSelectionBox.top;
	CNewSelectionBox.left	= CLastSelectionBox.left;
	CNewSelectionBox.bottom	= CMousePosition.y;
	CNewSelectionBox.right	= CMousePosition.x;

	if(CMousePosition.x < CFirstSelectionBox.left)
	{	
		CNewSelectionBox.left		= CMousePosition.x;
		CNewSelectionBox.right		= CLastSelectionBox.right;		
	}

	if(CMousePosition.y < CFirstSelectionBox.top)
	{
		CNewSelectionBox.bottom	= CLastSelectionBox.bottom;
		CNewSelectionBox.top	= CMousePosition.y;
	}


	CLastSelectionBox.bottom	= CMousePosition.y;
	CLastSelectionBox.right		= CMousePosition.x;	


	if(CMousePosition.x < CFirstSelectionBox.left)
	{	
		CLastSelectionBox.left	= CMousePosition.x;
		CLastSelectionBox.right	= CNewSelectionBox.right;
	}

	if(CMousePosition.y < CFirstSelectionBox.top)
	{
		CLastSelectionBox.top		= CMousePosition.y;
		CLastSelectionBox.bottom	= CNewSelectionBox.bottom;
	}

	return CLastSelectionBox;
}

void TCDrawSelectionRegion::SetView(CView *PCView)
{
	PCMView	= PCView;
}

void TCDrawSelectionRegion::Delete(CDC *PCViewDC)
{
	if(!PCViewDC) return;
	if(f_already_deleted) return;

	PCViewDC->DrawDragRect(&CMFirstSelectionBox, sm_thickness, &CMLastSelectionBox, sm_thickness);

	f_already_deleted = true;
}

CRect TCDrawSelectionRegion::GetSelectionBox(void)
{
	return CMLastSelectionBox;
}
/////////////////////////////////////////////////////



///////////////////////////////////////////////////////////
