#ifndef _T_SCHEMATIC_MANAGER_H
#define _T_SCHEMATIC_MANAGER_H

 
#include <afxtempl.h>

#include "TESuperSpiceEnums.h"
#include "TCSchematicObject.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCOutputWaveformData.h"
#include "TCFantasticFilter.h"
#include "TCNumberStack.h"

class TCOutputWaveformDataRecord;
class TCOutputWaveformData;
//////////////////////////////////////

#define MK_EXTRA_ALT_1 64// may need changed if MK_ALT, MK_SHIFT_ MK_CTRL changed

class TCWireTags : public CObject
{
	public:	
			TCWireTags();
			~TCWireTags(){};
			
			CArray <TCWireInfo, TCWireInfo &> Info;
			TCSchematicObject *PCSchematicObject;

			void operator = (TCWireTags &CWireTags);
			void Serialize(CArchive &ar);

			DECLARE_SERIAL(TCWireTags)	

};

class TCWireList : public CObject
{
	public:

			CArray <TCWireTags, TCWireTags&> CWireTags;
			TCWireList(){};
			~TCWireList(){};

			void operator = (TCWireList &CWireList);
			void Serialize(CArchive &ar);

			DECLARE_SERIAL(TCWireList)
};

class TCDrawSelectionRegion
{

private:		CRect	CMNewSelectionBox;
				CRect	CMLastSelectionBox;
				CRect	CMFirstSelectionBox;
				SIZE	sm_thickness;
				CView	*PCMView;
				CPoint	CMFirstMousePosition;
				bool	f_already_deleted;
				int		m_style;

	public:		TCDrawSelectionRegion();
				~TCDrawSelectionRegion();

				void SetStyle(int style);
				void SetView(CView *PCView);
				void Continue(CDC *PCViewDC, CPoint CMousePosition);
				void Start(CDC *PCViewDC, CPoint CMousePosition);
				void Delete(CDC *PCViewDC);
				CRect GetSelectionBox(void);
				CRect GetPreSelectionBox(CPoint CMousePosition);
				CPoint	GetFirstMousePosition(void);
};

class TCSchematicPageData;

class TCSchematicManagerData : public CObject
{
		
	

	public:	TCSchematicManagerData();
			~TCSchematicManagerData();

			TCSchematicPageData *PCPageData;

			CArray<TCSchematicObject*, TCSchematicObject*> CGraphicList;

			int		 page_id;
			CView	*PCView;
			bool	is_active_view;
			SIZE	CSelectionBoxThickness;
			CPoint  CViewPortOrigin;
			CPoint	CScrollBarPosition;
			CSize	CViewSize;
			float	zoom;
			CPoint	CZoomCenter;
			CRect  CPageArea;
			CString CActiveWaveformRefDesignator;

			
			void operator = (TCSchematicManagerData &CGraphicsManagerData);

			void Serialize(CArchive &ar);

			DECLARE_SERIAL(TCSchematicManagerData)	

};

class TCGraphicBitmapVectorObject;


class TCSchematicManager : public CObject
{

	public:	bool m_error;
				TCDrawSelectionRegion CMDrawSelectionRegion;
				TCDrawSelectionRegion CMComponentOutlineRegion;

				bool	fm_select_region;
				bool f_inspect_highlight;
				int inspect_highlight;
				CPoint CMLastMousePosition;
				bool m_component_is_outlined;
				bool graphics_modified;

				CPoint CMOutlineTopLeft;
				CPoint CMOutlineBottomRight;
				CRect	CInerPageArea;
				
				


				int m_current_wire_being_drawn;
				TCSchematicObject *PCMCurrentWireBeingDrawnObject;
				CPoint CCurrentWireAbsoluteLocation;

				
				int					m_last_created_id;

				TCWireList	CMWireList;
				void		InitWireList(void);
				CArray <TCSchematicObject *, TCSchematicObject *> CPCSchematicObjectSelectedList;
				CArray <int, int> CPCSchematicObjectIdSelectedList;
		

				CRect	CMLastSelectionBox;		

	public:	TCSchematicManager();

			TCSchematicObject *PCMLastCreatedGraphic;
			TCSchematicObject *PCLastWaveformGraphic;

			~TCSchematicManager();

			TCSchematicManagerData CMSchematicManagerData;
			TCWaveformDataRuns *PCWaveformDataRuns;

			CArray <TCSchematicObject *, TCSchematicObject *> CMGraphicDeleteList;

			CXTTipWindow CMTipWindow;

			bool	m_auto_keep_pasting;

				int GetGridSize(void);
				int GetSnapToDistance(void);
				void SetOverideSnapToGrid(void);
				void ClearOverideSnapToGrid(void);

				void ClearAllNetNames(void);

				bool is_pin_moveable;
				bool is_symbol_editor;
				bool is_symbol_viewer;

				CPoint CMLastOutlinedMousePosition;
				TCSchematicObject *PCMLastOutlinedComponent;
				int m_last_outline_property;
				int zoom_index;

				TCSchematicObject *PCCursor1;
				TCSchematicObject *PCCursor2;

				TCNumberStack CPinNumberStack;


				TCTestPointData CTestPointData;// to pass data to graph window

				CRect CLastGraphSize;
				
				void PutBackPinNumber(TCSchematicObject *PCSchematicObject);
				void GetandSetNewPinData(TCSchematicObject *PCSchematicObject);
				
				void SetUpTipWindow(void);
				void DisplayModelAndSymbol(int id);
				void DisplayTipWindow(CPoint CLocation, CString CText, bool position_type);

				int active_cursor;
				void ClearCursor(int id);
				void MoveCursor(int id, CPoint CLocation);
				void PasteCursor(int id, CPoint CLocation);
				void RepasteCursor(CDC *PCViewDC, int id);
				TCSchematicObject *CreateCursor(int id);
				void DeleteCursor(int id);
				void SwopCursor(CPoint CLocation);
				void SwopAxis(TCSchematicObject *PCSchematicObject, CPoint CLocation);
				bool repaste_required;
				TCFloatingCursorData CCursorData;

				void ReLabelAxis(TCSchematicObject *PCSchematicObject);
				void ReLabelAxisSignalNames(TCSchematicObject *PCSchematicObject);
				void SetSignalsDisplayedList(TCSchematicObject *PCSchematicObject);

				void DeleteSchematicObjects(void);
				void RemoveWaveform(TCSchematicObject *PCSchematicObject, TCFloatingCursorData &CFloatingCursorData);
				void RemoveTestPointWaveform(TCSchematicObject *PCSchematicObject);

				void ShowNetNames(int show);
				void ShowDcVoltages(int show);
				void ShowDcCurrents(int show);
				void ShowPinNames(int show, int id);
				void ClearPinCurrentsAndVoltages(void);
				CString ConvertVoltRefDes(CString CText);
				CString ConvertCurrentRefDes(CString CText);

				void  DeleteBitmapBackgroundLabels(void);
				void  CreateBitmapBackgroundLabels(void);
				bool UpdateFloatingCursor(TCSchematicObject *PCSchematicObject, CPoint CMousePosition);

				void NameAllTestPoints(void);
				void ChangeWaveform(TCTestPointData &CTestPointData);// remove last waveform and replace with new one
				void ChangeWaveformsFromList(CArray <CString, CString> &CSignalList);
				void UpdateaAllTestPoints(void);
				void UpdateOperatingPoints(TCOutputWaveformData &COutputWaveformData);
				void CalculateComponentPower(void);
				void SetupOpPoints(TCOutputWaveformDataHeader &COutputWaveformDataHeader, TCSchematicObject *PCSchematicObject);
				void UpdateDesignerValues(int all_selected);
				void UpdateDesignerResistanceValues(int all_selected);
				void UpdateDesignerMosfetValues(int all_selected);

				void ChangeColour(TCTestPointData &CTestPointData);
				void ChangeColour(CPoint CPosition, int colour);
				void ClearAllWaveforms(bool redraw = true);
				void ReScaleOnWaveformObjectChange(TCSchematicObject *PCSchematicObject);
				void SetGraphSize(TCSchematicObject *PCSchematicObject, CRect &WindowData);
				void UpdateMarchingWaveforms(int run_number);
				void SetupMarchingWaveforms(TCWaveformDataRuns *PCWaveformDataRunsNew, CArray <TCSignal, TCSignal&> *PCSignalsNew, int waveform_type, int run_number);

				void ChangeGraphBKGColour(CPoint CPosition, int colour);
				void ChangeAllGraphBKGColours(CDC *PDC, int colour);

				int DoSpecialComponentProccessing(TCSchematicObject *PCSchematicObject, short version);

				TCSchematicObject *GetLastCreatedGraphic(void);
				TCSchematicObject *GetComponentOutlined(void);
				int GetLastCreatedId(void){return m_last_created_id;};
				
				bool GetComponentsExtent(CRect &CRectangleExtent);

				CArray <TCSchematicObject *, TCSchematicObject *> &GetSchematicObjectSelectedList(void);
				CArray <int, int> &GetSchematicObjectIdSelectedList(void);
				int FindWireId(TCSchematicObject *PCSchematicObject);

				void SetSelectPin(int id, int pin_id, bool select, bool redraw = true);
				void SetSelectPinLabel(int id, int pin_id, int label_id, bool select, bool redraw = true);
				void SetSelectLabel(int id, int label_id, bool select, bool redraw = true);
				bool SetMemoryBlockSize(int mem_block_size);
		
				void OutlineComponent(TCSchematicObject *PCSchematicObject, TCSchematicComponentInfo &CSchematicComponentInfo);
				void EraseComponentOutline(void);
				bool IsComponentOutlined(void);
				void OutlineGraphics(CPoint CMousePosition);
				void DisplayOutlineComponentStatus(TCSchematicObject *PCSchematicObject, TCSchematicComponentInfo &CSchematicComponentInfo, bool waveform_found);
				CString GetOperatingPoints(TCSchematicObject *PCSchematicObject);

				CPoint &GetComponentOutlinePosition(void);
				void ReOutlineComponent(TCSchematicObject *PCSchematicObject);
				int GetComponentOutlinedType(void);

				void	SetView(CView *PCView);
				CView  *GetView(void);
				bool	IsActiveView(void);
				void	Serialize(CArchive &ar);
				void	SerializeSchematicObjects(CArchive &ar);
				void	SerializeWires(CArchive &ar);
				bool	Error(void);
				int		GetPageId(void);
				bool	SetPageId(int page_id);
				float	GetZoom(void);
				void	SetZoom(float zoom);
				CPoint	GetZoomCenter(void);
				void	SetZoomCenter(CPoint CZoomCenter);
				void	ClipboardZoom(float zoom);
				void	Mirror(void);
				void	Rotate(void);
				void	Flip(void);

				bool	AddGraphicToList(TCSchematicObject *PGraphicsObject);
				bool	RemoveGraphicFromList(int index);

				void	SetSelect(int id, bool redraw = true);
				void	ResetSelect(int id, bool redraw = true);
				void	SetHighlight(int id, bool redraw = true);
				bool	GetSelect(int id);
				bool	GetHighlight(int id);
				void	ResetSelectAll(bool f_redraw);
				void	SetSelectAll(void);

				void	SetMouseOffset(int id, CPoint CMouseOffset);
				CPoint	GetMouseOffset(int id);
				CPoint	GetLocation(int id);

				void	InitaliseGraphicLocation(int id, CPoint CMousePosition);

				void	InitaliseAllGraphicLocations(CPoint CMousePosition);
				bool	CopyAll(TCSchematicManager *PCGraphicsManager, CString CExcludeComponent);
				void    operator = (TCSchematicManager &CGraphicsManager);
				bool	CopySelected(TCSchematicManager *PCGraphicsManager);
				bool	PasteSelected(CPoint CMousePosition);
				void    ClipboardPaste(CDC *PCMemDC, CPoint CMousePosition);
				void	ClipboardResetSelectAll(CDC *PCMemDC);
				void	RePasteSelected(bool hyde_labels);
				TCSchematicObject *IsPinThere(TCSchematicObject *PCSchematicObjectSource, CPoint &CMousePosition);
				bool	IsRecursivePaste(TCSchematicObject *PCSchematicObject, CString CExcludeComponent);

				bool	ClearSelected(bool hyde_labels = false);
				void	SetViewPortOrigin(CPoint CViewPortOrigin);
				CPoint	GetViewPortOrigin(void);

				void	SetViewSize(CSize CViewSize);
				CSize	GetViewSize(void);

				void	SetScrollBarPosition(CPoint CScrollBarPosition);
				CPoint	GetScrollBarPosition(void);
				void	ResetGraphicList(void);
				bool	Paste(TCSchematicManager *PCGraphicsManager, CPoint CMousePosition, CString CExcludeComponent);

				CString	GetLabel(int id, int id_label);
				void	SetLabel(int id, int id_label, CString CText, bool redraw = false, int f_all_same_nodes = false);
				void	SetPinLabel(int id, int id_pin, int id_label, CString CText, bool redraw = false);

				TCSchematicObjectData *GetSchematicObjectData(int id);
				bool	SetSchematicObjectData(int id, TCSchematicObjectData &CSchematicObjectData);

				void	ClearScreen(CDC *PCViewDC);
				virtual void	DrawGrid(CDC *PCViewDC);
				void	DrawOverlayGrid(CDC *PCViewDC);

				void	DrawGrid(CDC *PCViewDC, CPoint CStart, int x_size, int width, int y_size, int hieght, COLORREF color);
				void	DrawPageOutline(CDC *PCViewDC, bool offset);
				void	UpdatePageOutline(void);
				void	UpdateSchematicObject();

				void	ReDrawOverlapedRegion(void);
				void	ReDrawOverlapedRegion(int p);
				void	ClearOverlapedRegion(void);
				void	ClearOverlapedRegion(int p);
				void	ClearOverLapedGraphics(void);
				void	RePasteOverlapedGraphics(void);
				void	TagOverlapedRegion(int id);
				void	ResetOverlapedRegion(void);
				void	BringSelectedGraphicsToTop(void);
				bool	GraphicsSelected(void);
				int		FindGraphicId(TCSchematicObject *PGraphicsObject);
				int		FindGraphicId(int component_type);
				bool	GetGraphicSelectedPosition(CPoint *CPosition);

				void	DrawSelectionBox(CDC *PCViewDC, CPoint CMousePosition);
				void	DrawInitialSelectionBox(CDC *PCViewDC, CPoint CMousePosition);
				void	CancelSelectionBox(CDC *PCViewDC);

				TCSchematicObject *JoinUpWithOtherWires(int id);
				void JoinUpAllWires(void);
				void JoinUpWires(CArray <CString, CString> &CNetNameList);
				bool TagSameTypeOverlapedWires(int id);
				bool TagDiffTypeOverlapedWires(int id);
				void ResetTagedOverlapedWires();
				TCSchematicObject *CreateOneJoinedUpWire(int id);
				void DeleteOverlapedWires(void);
				void RemoveOverlapedWires(void);
				TCSchematicObject *CreateWire(CDC *PCDC, CPoint CWireStart, CPoint CWireEnd);

				void SplitUpWire(int id);
				void SplitUpAllWires(void);
				void CreateOneSplitWire(int id);

				void StartRubberBanding(void);
				void ContinueRubberBanding(void);
				void EndRubberBanding(void);

				void LabelGroundAndConectersWires(void);

				CArray<TCSchematicObject*, TCSchematicObject*> &GetGraphicList(void){return CMSchematicManagerData.CGraphicList;};

				TCSchematicObject *GetSchematicObject(int id); 

				void SetPageData(TCSchematicPageData &CPropertyData);
				TCSchematicPageData &GetPageData(void);

				void	TagTouchingWires(int id);
				void	ResetTagTouchingWires(void);
				bool	DestroyGraphic(CPoint CLocation, bool fine);
				int		FindGraphic(CPoint CLocation, bool fine);				
				virtual void	DrawAll(void);
				bool	PasteGraphic(int id, CPoint CLocation, bool hyde_labels = false);
				bool	RePasteAllGraphics(CDC *PCViewDC);
				bool	RePasteAllGraphicsFromMemory(CDC *PCViewDC);
				void	ReDrawAllSelectedGraphics(void);
				bool	MoveTo(int id, CPoint CLoction);
				bool	Clear(int id);	
				bool	ClearAllGraphics();
				virtual void	DeleteSelectedGraphics(bool enable_undelete = false);
				void	MoveGraphics(CPoint CLocation, bool draw_overlaped, int snap_to_grid_is_enabled, bool hyde_labels = false);
				void	UpdateSchematicObjectDataBase(void);
				void	UpdateNetNamesFromPinNames(int id, int pin_id);
				void	UpdateNetNamesFromPinNames(int id);
				virtual bool	PrintAll(CDC *PCDC);
				bool    PrintAllAsBitmap(CDC *PCDC);
				void	StartMoveTo(void);
				void	EndMoveTo(void);
				TCSchematicObject *GetFirstSelectedSchematicComponent(void);

				void CreateTitleBlock(void);
				void CreateInitGnd(void);
				void CreateInitTestMarker(void);
				void RepositionTitleBlock(void);
				int FindTitleBlock(void);


				void ClearAllConnectionDotes(CDC *PCViewDC);
				void DisplayAllConnectionDots(void);

				void Undelete(void);
				void DeleteDeleteList(void);
				void DeleteLastSelectedGraphic(CArray <TCSchematicObject *, TCSchematicObject *> *PCGraphicDeleteList, bool enable_undelete);

				void InsertIntoWire(TCSchematicObject *PCSchematicObject);

				virtual bool	OpenGraphic(CPoint CMousePosition, int graphic_type, short version,TCSchematicObjectData &CSchematicObjectData);
				int		CreateGraphic(TE_TYPE_OF_COMPONENT graphic_type);
				int		CreateGraphic(TCSchematicObject *PGraphicsObject, TCSchematicObjectData &CSchematicObjectData);
				int		CreateGraphic(TCSchematicObjectData &CSchematicObjectData);
				
				bool	UpdateWaveforms(TCOutputWaveformDataHeader &COutputWaveformDataHeader);
				bool	UpdateSchematicWaveforms(TCOutputWaveformData &COutputWaveformData);
				bool	UpdateGraphicWaveforms(TCOutputWaveformData &COutputWaveformData, CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList);
				void	ChangeGraphicWaveform(CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList);
				void	UpdateDeviceACCurrents(TCOutputWaveformData &COutputWaveformData);
				int		FindWaveform(CString CRefDes);
				TCSchematicObject *FindComponent(CString CRefDes);
				int     FindComponentId(CString CRefDes);
				bool	SetFilterValues(TCFantasticFilter &CFantasticFilter);

				TCSchematicObject	*GetWaveform(CString CRefDes);
				bool	SetActiveWaveform(CString CRefDes);
				bool	SetActiveWaveform(int id);
				void	ResetActiveWaveform(void);
				void	AxisScrollXRight(void);
				void	AxisScrollXLeft(void);
				void	AxisScrollYUp(void);
				void	AxisScrollYDown(void);
				void	AxisMagnify(void);
				void	AxisReduce(void);
				void	AxisAutoScale(void);

				TCSchematicComponentInfo InspectSchematicObject(CPoint CLocation, bool fine, bool ignor_wire = false, bool pin_only = false);

				void Zoom(float zoom, TE_GRAPHICS_MANAGER_SYSTEM_STATE state);

				void UpdateAndGetWireLabelIds(CArray <int, int> &CWireLabelUpdateIds, bool correct_wires);
				void MakeSameWiresHaveSameName(void);
				void MakeSameWiresHaveSameName(int id, int options);
				

				bool GetVoltageSignalNames(TCSchematicObject *PCSchematicObject, CArray <CString, CString> &CDeviceNodes);
				bool GetCurrentSignalNames(TCSchematicObject *PCSchematicObject, CArray <CString, CString> &CDeviceNodes);

	 TE_GRAPHICS_MANAGER_SYSTEM_STATE IdleStateGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsSelectedStateGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsMovingStateGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);	
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SelectRegionStateGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);		 
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotGraphicStateGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotClipboardGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireGetGraphic(CPoint CMousePosition, int graphic_id, short, TCSchematicObjectData &CSchematicObjectData);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE IdleDrawWire(CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsSelectedDrawWire(CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsMovingDrawWire(CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE SelectRegionDrawWire(CPoint CMousePosition); 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE GotGraphicDrawWire(CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE GotClipboardDrawWire(CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireDrawWire(CPoint CMousePosition);




	 TE_GRAPHICS_MANAGER_SYSTEM_STATE IdleStateLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsSelectedStateLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsMovingStateLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SelectRegionStateLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotGraphicStateLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotClipboardLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireLBDown(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SizingWaveformWindowLBDown(UINT nFlags, CPoint CMousePosition);
	

	 TE_GRAPHICS_MANAGER_SYSTEM_STATE IdleStateLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsSelectedStateLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsMovingStateLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SelectRegionStateLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotGraphicStateLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotClipboardLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireLBUp(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SizingWaveformWindowLBUp(UINT nFlags, CPoint CMousePosition);


	 TE_GRAPHICS_MANAGER_SYSTEM_STATE IdleStateMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsSelectedStateMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsMovingStateMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SelectRegionStateMouseMoved(UINT nFlags, CPoint CMousePosition);	
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotGraphicStateMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE WaitingToDrawWireMouseMoved(UINT nFlags, CPoint CMousePosition);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SizingWaveformWindowMouseMoved(UINT nFlags, CPoint CMousePosition);


	 TE_GRAPHICS_MANAGER_SYSTEM_STATE IdleOnCancel(void);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsSelectedOnCancel(void);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GraphicsMovingOnCancel(void);	
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE SelectRegionOnCancel(void);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotGraphicOnCancel(void);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE GotClipboardOnCancel(void);
	 TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireOnCancel(void);


	TE_GRAPHICS_MANAGER_SYSTEM_STATE WaitingToDrawWireGetGraphic(CPoint CMousePosition, int graphic_id, short version, TCSchematicObjectData &CSchematicObjectData);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE WaitingToDrawWireLBDown(UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE WaitingToDrawWireLBUp(UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE WaitingToDrawWireOnCancel(void);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE DrawingWireLBDblClk(UINT nFlags, CPoint CMousePosition);


	TE_GRAPHICS_MANAGER_SYSTEM_STATE WaveformOnClickStateLBDown(UINT nFlags, CPoint CMousePosition);

	DECLARE_SERIAL(TCSchematicManager)

};


#endif