/*

	Copywrite Kevin Aylward. (c) 1996
	
	File:	TCSchematicObject.cpp




 */

#include "TDVersion.h"
#include "stdafx.h"
#include "resource.h"
#include "math.h"
#include "TEPropertyViewTypes.h"
#include "TCGraphicsFunctions.h"
#include "Generic.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TESuperSpiceEnums.h"
#include "TCSchematicObject.h"
#include "TCOutputWaveformData.h"
#include "Equation.h"
#include "TEAnalysisExtra.h"
#include "TCSuperSpiceDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// These globals really do seem the best way to implement features
// passing values gets quite cumbersome
extern TCSuperSpiceDataBase	GCSuperSpiceDataBase;
extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern CString GGeneratorLoadVersion;
extern CString GGeneratorSaveVersion;

extern CString FloatToSpiceMKSString(double);
extern double SpiceMKSStringToFloat(CString &);
CString FloatToSpiceMKSString(double);
CString MKSStringToSpiceMKSString(CString &CText);
CString FloatToMKSString(double data);
double MKSStringToFloat(CString &CTextData);
CSize GetTextSize(CString CText, LOGFONT &s_logfont, float zoom);
extern CDC GlobalCDCTemp;
extern int global_screen_planes;
extern int global_screen_bitspixels;
double	AntiLog(double value);
extern CString GSSKeyWordArea;
extern CString GSSKeyWordLength;
extern CString GSSKeyWordWidth;
extern CString GSSKeyWordMultiplier;

//////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL(TCSchematicObject, TCGraphicBitMapVectorObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSchematicObjectData, TCGraphicObjectData, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSchematicPinData, TCGraphicObjectData, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSchematicPinObject, TCGraphicBitMapVectorObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSymbolData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCRubberBandData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCRubberBandPinData, CObject, ID_VERSION_NUMBER)

//*****************
IMPLEMENT_SERIAL(TCSchematicDataLoadSave, CObject, ID_VERSION_NUMBER)


TCSchematicDataLoadSave::TCSchematicDataLoadSave(void)
{
	PCOutputWaveformDataHeader = NULL;
	PCOutputWaveformDataHeader = NULL;

	class_version = 1;

	f_validate_label_value			= true;
	component_property_view_type	= 0;
	version							= -1;
	
	format_spice_value				= true;
	attached_model_type				= 0;

	PCGeneratorData				= NULL;
	PCOutputWaveformDataHeader  = NULL;

	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = false;
	CLabelListData[E_COMPONENT_VALUE].read_only = true;
}

TCSchematicDataLoadSave::TCSchematicDataLoadSave(TCSchematicDataLoadSave &CBlank)
{
	*this = CBlank;
}
TCSchematicDataLoadSave::~TCSchematicDataLoadSave(void)
{
	if(PCGeneratorData) delete PCGeneratorData;
}

void TCSchematicDataLoadSave::Serialize(CArchive& CArchiveFile)
{
	int data, count, p;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << mirror_state;
		CArchiveFile << rotation_state;
		CArchiveFile << f_validate_label_value;
		CArchiveFile << format_spice_value;	
		CArchiveFile << component_property_view_type;
		CArchiveFile << version;					
		CArchiveFile << attached_model_type;
		CArchiveFile << type;
		CArchiveFile << class_version;

		CArchiveFile << CRecordName;	
		CArchiveFile << CRecordFilePathAndName; 
	
		CArchiveFile << CSymbolName;
		CArchiveFile << CSymbolFilePathAndName;

		count = CLabelListData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);

		if(PCOutputWaveformDataHeader)
		{
			data = true;
			CArchiveFile << data;
			PCOutputWaveformDataHeader->Serialize(CArchiveFile);
		}
		else
		{
			data = false;
			CArchiveFile << data;
		}

		if(PCGeneratorData)
		{
			if(attached_model_type != E_SPICE_GENERATOR)
			{
				ASSERT(0);
			}
			data = true;
			CArchiveFile << data;

			PCGeneratorData->Serialize(CArchiveFile);
		}
		else
		{
			data = false;
			CArchiveFile << data;
		}
	}
	else
	{
		CArchiveFile >> mirror_state;
		CArchiveFile >> rotation_state;
		CArchiveFile >> f_validate_label_value;
		CArchiveFile >> format_spice_value;	
		CArchiveFile >> component_property_view_type;
		CArchiveFile >> version;					
		CArchiveFile >> attached_model_type;
		CArchiveFile >> type;
		CArchiveFile >> class_version;

		CArchiveFile >> CRecordName;	
		CArchiveFile >> CRecordFilePathAndName; 
	
		CArchiveFile >> CSymbolName;
		CArchiveFile >> CSymbolFilePathAndName;

		CArchiveFile >> count;

		CLabelListData.SetSize(count, count);

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);

		CArchiveFile >> data;

		if(data)
		{
			if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)
				PCOutputWaveformDataHeader->Serialize(CArchiveFile);
		}

		CArchiveFile >> data;

		if(data)
		{
			if(attached_model_type != E_SPICE_GENERATOR)
			{
				ASSERT(0);
			}
			if(!PCGeneratorData)
				PCGeneratorData	= new TCGeneratorData;

			if(!PCGeneratorData) return;

			PCGeneratorData->Serialize(CArchiveFile);
		}
	}
}

void TCSchematicDataLoadSave::operator = (TCSchematicDataLoadSave &CSchematicDataLoadSave)
{

	int count = CSchematicDataLoadSave.CLabelListData.GetSize();

	CLabelListData.SetSize(count,  count);

	for(int p = 0; p < count; p++) CLabelListData[p]  = CSchematicDataLoadSave.CLabelListData[p];

	if(CSchematicDataLoadSave.PCOutputWaveformDataHeader)
	{
		if(type != E_WAVEFORM_COMPONENT)
		{
			ASSERT(0);// this is a program fault
			return;
		}

		if(PCOutputWaveformDataHeader)
		{
			*PCOutputWaveformDataHeader = *CSchematicDataLoadSave.PCOutputWaveformDataHeader;
		}
		else
		{
			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)*PCOutputWaveformDataHeader = *CSchematicDataLoadSave.PCOutputWaveformDataHeader;
		}
	}
	else
	{
		if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

		PCOutputWaveformDataHeader = NULL;
	}

	if(CSchematicDataLoadSave.PCGeneratorData)
	{

		if(!PCGeneratorData)
			PCGeneratorData	= new TCGeneratorData;

		if(!PCGeneratorData) return;

		*PCGeneratorData = *CSchematicDataLoadSave.PCGeneratorData;
	}

	mirror_state					= CSchematicDataLoadSave.mirror_state;
	rotation_state					= CSchematicDataLoadSave.rotation_state;
	f_validate_label_value			= CSchematicDataLoadSave.f_validate_label_value;
	format_spice_value				= CSchematicDataLoadSave.format_spice_value;	
	component_property_view_type	= CSchematicDataLoadSave.component_property_view_type;
	version							= CSchematicDataLoadSave.version;					
	attached_model_type				= CSchematicDataLoadSave.attached_model_type;
	type							= CSchematicDataLoadSave.type;
	class_version					= CSchematicDataLoadSave.class_version;

	
	CRecordName				= CSchematicDataLoadSave.CRecordName;	
	CRecordFilePathAndName	= CSchematicDataLoadSave.CRecordFilePathAndName; 

	CSymbolName				= CSchematicDataLoadSave.CSymbolName;
	CSymbolFilePathAndName	= CSchematicDataLoadSave.CSymbolFilePathAndName;
	CSymbolChildFileName	= CSchematicDataLoadSave.CSymbolChildFileName;
}

void TCSchematicDataLoadSave::operator = (TCSchematicObjectData &CSchematicObjectData)
{
	int count = CSchematicObjectData.CLabelListData.GetSize();

	CLabelListData.SetSize(count,  count);

	for(int p = 0; p < count; p++) CLabelListData[p]  = CSchematicObjectData.CLabelListData[p];

	if(CSchematicObjectData.PCOutputWaveformDataHeader)
	{
		if(PCOutputWaveformDataHeader)
		{
			*PCOutputWaveformDataHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		}
		else
		{
			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)*PCOutputWaveformDataHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		}
	}
	else
	{
		if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

		PCOutputWaveformDataHeader = NULL;
	}

	if(CSchematicObjectData.PCGeneratorData)
	{

		if(!PCGeneratorData)
			PCGeneratorData	= new TCGeneratorData;

		if(!PCGeneratorData) return;

		*PCGeneratorData = *CSchematicObjectData.PCGeneratorData;
	}

	mirror_state					= CSchematicObjectData.mirror_state;
	rotation_state					= CSchematicObjectData.rotation_state;
	f_validate_label_value			= CSchematicObjectData.f_validate_label_value;
	format_spice_value				= CSchematicObjectData.format_spice_value;	
	component_property_view_type	= CSchematicObjectData.component_property_view_type;
	version							= (char)CSchematicObjectData.version;					
	attached_model_type				= CSchematicObjectData.attached_model_type;
	type							= CSchematicObjectData.type;
	
	CRecordName				= CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;	
	CRecordFilePathAndName	= CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath +  CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CSymbolName				= CSchematicObjectData.CSymbolData.CName;
	CSymbolFilePathAndName	= CSchematicObjectData.CSymbolData.CFilePath + CSchematicObjectData.CSymbolData.CFileName;
	CSymbolChildFileName	= CSchematicObjectData.CSymbolData.CChildFileName;
}

void TCSchematicObjectData::operator = (TCSchematicDataLoadSave &CSchematicDataLoadSave)
{
	RecreateSchematicData(CSchematicDataLoadSave);

	int count = CSchematicDataLoadSave.CLabelListData.GetSize();

	CLabelListData.SetSize(count,  count);

	for(int p = 0; p < count; p++) CLabelListData[p]  = CSchematicDataLoadSave.CLabelListData[p];

	if(CSchematicDataLoadSave.PCOutputWaveformDataHeader)
	{
		if(type != E_WAVEFORM_COMPONENT)
		{
			ASSERT(0);// this is a program fault
			return;
		}

		if(PCOutputWaveformDataHeader)
		{
			*PCOutputWaveformDataHeader = *CSchematicDataLoadSave.PCOutputWaveformDataHeader;
		}
		else
		{
			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)*PCOutputWaveformDataHeader = *CSchematicDataLoadSave.PCOutputWaveformDataHeader;
		}

		CheckAndNullWaveformDataPointers();
	}
	else
	{
		if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

		PCOutputWaveformDataHeader = NULL;
	}

	if(CSchematicDataLoadSave.PCGeneratorData)
	{

		if(!PCGeneratorData)
			PCGeneratorData	= new TCGeneratorData;

		if(!PCGeneratorData) return;

		*PCGeneratorData = *CSchematicDataLoadSave.PCGeneratorData;
	}

	mirror_state					= CSchematicDataLoadSave.mirror_state;
	rotation_state					= CSchematicDataLoadSave.rotation_state;
	f_validate_label_value			= !!CSchematicDataLoadSave.f_validate_label_value;
	format_spice_value				= !!CSchematicDataLoadSave.format_spice_value;	
	component_property_view_type	= CSchematicDataLoadSave.component_property_view_type;
	version							= CSchematicDataLoadSave.version;					
	attached_model_type				= CSchematicDataLoadSave.attached_model_type;
	type							= CSchematicDataLoadSave.type;

	
	CSpiceParameters.CDataBaseIdInfo.CRecordName		= CSchematicDataLoadSave.CRecordName;	
	CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= ExtractFileName(CSchematicDataLoadSave.CRecordFilePathAndName); 
	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= ExtractPathName(CSchematicDataLoadSave.CRecordFilePathAndName);	

	CSymbolData.CChildFileName	= CSchematicDataLoadSave.CSymbolChildFileName;
	
}

bool TCSchematicObjectData::IsStraightVectorsOnly(void)
{
	int	count = CSymbolData.CData.GetSize();

	int type;

	for(int p = 0; p < count; p++) 
	{
		type = CSymbolData.CData[p].type;

		if(type == E_SCHEMATIC_SYMBOL_CIRCLE) return false;
	}

	return true;
}

bool TCSchematicObjectData::RecreateSchematicData(TCSchematicDataLoadSave &CSchematicDataLoadSave)
{
	CSymbolData.CFilePath = ExtractPathName(CSchematicDataLoadSave.CSymbolFilePathAndName);
	CSymbolData.CFileName = ExtractFileName(CSchematicDataLoadSave.CSymbolFilePathAndName);
	CSymbolData.CName	  = CSchematicDataLoadSave.CSymbolName;
	type				  = CSchematicDataLoadSave.type;

	return GCSuperSpiceDataBase.GetSchematicObjectData(*this);
}

//*********************

TCSymbolData::TCSymbolData(void)
{
	PCParentSpiceDoc	= NULL;
	PCChildSpiceDoc		= NULL;
}

TCSymbolData::TCSymbolData(TCSymbolData &CSymbolData)
{
	*this = CSymbolData;
}
TCSymbolData::~TCSymbolData(void)
{
	
}

void TCSymbolData::Serialize(CArchive& CArchiveFile)
{
	int p, count;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CName;
		CArchiveFile << CFileName;
		CArchiveFile << CFilePath;
		CArchiveFile << CChildFileName;//CParentFileName does not want to be rememberd
		CArchiveFile << CDescription;

		count = CData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> CName;
		CArchiveFile >> CFileName;
		CArchiveFile >> CFilePath;
		CArchiveFile >> CChildFileName;
		CArchiveFile >> CDescription;

		CArchiveFile >> count;

		CData.SetSize(count, count);
	
		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);
	}
}

void TCSymbolData::operator = (TCSymbolData &CSymbolData)
{
	int p, count;

	CName				= CSymbolData.CName;
	CFileName			= CSymbolData.CFileName;
	CFilePath			= CSymbolData.CFilePath;
//	CParentFileName		= CSymbolData.CParentFileName;
	PCParentSpiceDoc	= CSymbolData.PCParentSpiceDoc;
	CChildFileName		= CSymbolData.CChildFileName;
	PCChildSpiceDoc		= CSymbolData.PCChildSpiceDoc;
	CDescription		= CSymbolData.CDescription;

	count = CSymbolData.CData.GetSize();

	CData.SetSize(count, count);

	for(p = 0; p < count; p++) CData[p] = CSymbolData.CData[p];
}

void TCSymbolData::Copy(TCSymbolData &CSymbolData)
{
	CName				= CSymbolData.CName;
	CFileName			= CSymbolData.CFileName;
	CFilePath			= CSymbolData.CFilePath;
//	CParentFileName		= CSymbolData.CParentFileName;
	PCParentSpiceDoc	= CSymbolData.PCParentSpiceDoc;
	CChildFileName		= CSymbolData.CChildFileName;
	PCChildSpiceDoc		= CSymbolData.PCChildSpiceDoc;
	CDescription		= CSymbolData.CDescription;
}

void TCSymbolData::Rescale(float scale)
{
	int count, p;

	count = CData.GetSize();

	for(p = 0; p < count; p++)
	{
		CData[p].Zoom(scale);
	}
}

bool TCSymbolData::CopyToNewDir(CString CPath)
{
	//Doc->CopySymbolsToNewDir();// maybe needed

	return true;
}
//////////////////////////////////////////////////
///////////////////////////////////////////////////
TCSchematicObject::TCSchematicObject()
{
	active_magnitude_axis_index = -1;
	active_phase_axis_index		= -1;
	xaxis_start_index			= -1;
	yphase_axis_start_index		= -1;
	ymagnitude_axis_start_index = -1;
	y_magnitude_axis_signal_name_index = 0;
	y_phase_axis_signal_name_index		= 0;
}

TCSchematicObject::TCSchematicObject(TCSchematicObject &CSchematicObject)
{
	*this = CSchematicObject;
}

TCSchematicObject::~TCSchematicObject()
{


}

 
void TCSchematicObject::Serialize(CArchive& CArchiveFile)
{
	if(CArchiveFile.IsStoring())
	{
		UpdateSchematicObjectData();
	}

	CMSchematicObjectData.Serialize(CArchiveFile);
 
	TCGraphicBitMapVectorObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsLoading())
	{
		CDC CViewDC;

		if(!CViewDC.CreateCompatibleDC(NULL)) return;

		if(m_property == E_SCHEMATIC_WIRE)
		{

			TCGraphicBitMapVectorObject::Create(CMLineStart, CMLineEnd, m_line_width, 
				    GCSuperSpiceGlobalData.CColorData.wire_normal, GCSuperSpiceGlobalData.CColorData.wire_selected,
					GCSuperSpiceGlobalData.CColorData.wire_highlighted, 
					GetSnapToDistance());
				CreateLabels(&CViewDC);
				CreateWirePins(&CViewDC);

				CreateGrabRegion(CMLocation);
		}
		else if(m_property == E_SCHEMATIC_TEXT_LABEL)
			{
				CString CTempLable;

				CTempLable = CMLabel;  // Use existing code and then update
										// this is simpler
				if(Create(&CViewDC, CMSchematicObjectData, m_zoom)) 
				{
					SetLabel(&CViewDC, 0, CTempLable);
				}
				CreateGrabRegion(CMLocation);
			}
		
			else 
			{
				if(!Create(&CViewDC, CMSchematicObjectData, m_zoom)) 
				{
					return;
				}

				if(m_mode == E_BITMAP_TEXT_OBJECT)
				{
					CreateGrabRegion(CMLocation);
				}
				Paste(&CViewDC, CMLocation); // make sure line data is in sinc
			}
		if(m_selected) SetSelect();
		else if(m_highlighted)SetHighlight(true);
	}

	SerializeLabelsAndPins(CArchiveFile);

		// 17 Sept 2001 correct old circuits. bug fixed 20th June 2005, waveform lables use symbol name
	if(m_type != E_WIRE_COMPONENT &&  m_type != E_WAVEFORM_COMPONENT)
		CMSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMSchematicObjectData.CSymbolData.CName;
}

void TCSchematicObject::SerializeSchematicDataLoadSave(CArchive& CArchiveFile)
{
	if(CArchiveFile.IsStoring())
	{
		UpdateSchematicObjectData();
	}

	TCSchematicDataLoadSave CSchematicDataLoadSave;
 
	TCGraphicBitMapVectorObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsLoading())
	{
		CSchematicDataLoadSave.Serialize(CArchiveFile);

		CMSchematicObjectData = CSchematicDataLoadSave;

		CDC CViewDC;

		if(!CViewDC.CreateCompatibleDC(NULL)) return;

		if(m_property == E_SCHEMATIC_WIRE)
		{

			TCGraphicBitMapVectorObject::Create(CMLineStart, CMLineEnd, m_line_width, 
				    GCSuperSpiceGlobalData.CColorData.wire_normal, GCSuperSpiceGlobalData.CColorData.wire_selected,
					GCSuperSpiceGlobalData.CColorData.wire_highlighted, 
					GetSnapToDistance());
				CreateLabels(&CViewDC);
				CreateWirePins(&CViewDC);

				CreateGrabRegion(CMLocation);
		}
		else if(m_property == E_SCHEMATIC_TEXT_LABEL)
			{
				CString CTempLable;

				CTempLable = CMLabel;  // Use existing code and then update
										// this is simpler
				if(Create(&CViewDC, CMSchematicObjectData, m_zoom)) 
				{
					SetLabel(&CViewDC, 0, CTempLable);
				}
				CreateGrabRegion(CMLocation);
			}
		
			else 
			{
				if(!Create(&CViewDC, CMSchematicObjectData, m_zoom)) 
				{
					return;
				}

				if(m_mode == E_BITMAP_TEXT_OBJECT)
				{
					CreateGrabRegion(CMLocation);
				}
				Paste(&CViewDC, CMLocation); // make sure line data is in sinc
			}
		if(m_selected) SetSelect();
		else if(m_highlighted)SetHighlight(true);
	}
	else
	{
		CSchematicDataLoadSave = CMSchematicObjectData;

		CSchematicDataLoadSave.Serialize(CArchiveFile);
	}
}

void TCSchematicObject::SerializeLabelsAndPins(CArchive& CArchiveFile)
{
	int count;
	unsigned char label_count;

	int p;

	if(CArchiveFile.IsStoring()) //CMPinListObject.GetSize() => CMSchematicObjectData sizes;
	{
		count = CMPinListObject.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CMPinListObject[p].Serialize(CArchiveFile);
	
		label_count = (unsigned char) CMLabelListObject.GetSize();

		CArchiveFile << label_count;

		for(p = 0; p < label_count; p++) CMLabelListObject[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> count;

		CMPinListObject.SetSize(count,  count);

		for(p = 0; p < count; p++) CMPinListObject[p].Serialize(CArchiveFile);
		
		CArchiveFile >> label_count;

		CMLabelListObject.SetSize((int)label_count,  (int)label_count);

		for(p = 0; p < label_count; p++) CMLabelListObject[p].Serialize(CArchiveFile);
	}
}

void TCSchematicObject::UpdateSchematicObjectData(void)
{
	int count = CMSchematicObjectData.CPinListData.GetSize();

	for(int p = 0; p < count; p++) 
	{
		int count2 = CMSchematicObjectData.CPinListData[p].CLabelListData.GetSize();
	
		for(int q = 0; q < count2; q++) 
		{
			CMSchematicObjectData.CPinListData[p].CLabelListData[q] = CMPinListObject[p].GetPinData().CLabelListData[q];
		}
	}
}

void TCSchematicObject::operator = (TCSchematicObject  &CSchematicObject)
{
	active_magnitude_axis_index	= CSchematicObject.active_magnitude_axis_index;
	active_phase_axis_index		= CSchematicObject.active_phase_axis_index;
	xaxis_start_index			= CSchematicObject.xaxis_start_index;
	yphase_axis_start_index 	= CSchematicObject.yphase_axis_start_index;
	ymagnitude_axis_start_index	= CSchematicObject.ymagnitude_axis_start_index;
	is_digital					= CSchematicObject.is_digital;

	CMSchematicObjectData = CSchematicObject.CMSchematicObjectData;

	TCGraphicBitMapVectorObject::operator = (CSchematicObject);

	int count = CSchematicObject.CMLabelListObject.GetSize();

	CMLabelListObject.SetSize(count, count);

	int p;

	for(p = 0; p < count; p++)
	{
		CMLabelListObject[p] = CSchematicObject.CMLabelListObject[p];			
	}

	count = CSchematicObject.CMPinListObject.GetSize();

	CMPinListObject.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CMPinListObject[p] = CSchematicObject.CMPinListObject[p];		
	}
}

void TCSchematicObject::SetPageId(int page_id)
{
	CMPageId.Format("Page%d", page_id);

	m_page_id = page_id;

	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMLabelListObject[p].m_page_id = page_id;	
		CMLabelListObject[p].CMPageId = CMPageId;
	}

	count = CMPinListObject.GetSize();

	CMPinListObject.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CMPinListObject[p].SetPageId(page_id);	
	}
}

void TCSchematicPinObject::SetPageId(int page_id)
{
	CMPageId.Format("Page%d", page_id);

	m_page_id = page_id;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMLabelListObject[p].m_page_id = page_id;	
		CMLabelListObject[p].CMPageId = CMPageId;
	}
}
////////////////////////////////////////////////////////


TCSchematicObjectData &TCSchematicObject::GetSchematicObjectData(void)
{
	return CMSchematicObjectData;
}


CString TCSchematicObjectData::GetSpiceValue(TCAnalysisSetup &CAnalysisSetup)
{
	CString CText;
	if(CAnalysisSetup.CReRun.enable == 1 || 
	   CAnalysisSetup.CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_MODEL_FILE)
	{
		m_rerun_enable = true;
	}
	else m_rerun_enable = false;

	m_parameter_enable	= CAnalysisSetup.CParametricSetupData.CSweepData.enable;
	PCMAnalysisSetup	= &CAnalysisSetup;

	// RerunType will contain the data value for parameter sweep
	switch(component_property_view_type)
	{
		case E_PROPERTY_RESISTOR: CText = GetResistorValue();return CText;
		case E_PROPERTY_CAPACITOR: CText = GetCapacitorValue();return CText;
		case E_PROPERTY_INDUCTOR: CText = GetInductorValue();return CText;
		case E_PROPERTY_IC_RESISTOR: CText = GetICResistorValue();return CText;
		case E_PROPERTY_IC_CAPACITOR: CText = GetICCapacitorValue();return CText;
		case E_PROPERTY_DIODE:CText = GetDiodeValue();return CText;
		case E_PROPERTY_BIPOLAR:CText = GetBipolarValue();return CText;
		case E_PROPERTY_MOSFET:CText = GetMosValue();return CText;
		case E_PROPERTY_FET:
		case E_PROPERTY_MESFET:
			 CText = GetFetValue();return CText;
		case E_PROPERTY_URC_TRANSMISSION_LINE:CText = GetURCValue();return CText;
		case E_PROPERTY_TRANSMISSION_LINE: CText = GetTransmissionLineValue();return CText;
		case E_PROPERTY_LOSSLESS_TRANSMISSION_LINE: CText = GetLosslessTransmissionLineValue();return CText;
		case E_PROPERTY_LAPLACE_TRANSFORM: CText = GetLaplaceValue(); return CText;
		case E_PROPERTY_CONTROLED_SOURCE: CText = GetControlledSourceValue(); return CText;
		case E_PROPERTY_NONLINEARSOURCE: CText = GetControlledSourceValue(); return CText;
		case E_PROPERTY_GENERIC_MODEL://added 19th feb 2004 bug fix
		case E_PROPERTY_SUBCIRCUIT:
		case E_PROPERTY_GENERIC_SUBCIRCUIT: CText = GetSubCktValue(); return CText;
	}

	CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

	switch(component_property_view_type)//was type
	{
		case E_PROPERTY_DC_VOLTAGE_SOURCE:			CText = GetDCSourceValue(); break;
		case E_PROPERTY_SINE_VOLTAGE_SOURCE:		CText = GetSineSourceValue(); break;
		case E_PROPERTY_PULSE_VOLTAGE_SOURCE:		CText = GetPulseSourceValue(); break;
		case E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE:	CText = GetExpSourceValue(); break;
		case E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE:CText = GetPWLSourceValue(); break;
		case E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM:		CText = GetSFFMSourceValue(); break;
		case E_PROPERTY_DC_CURRENT_SOURCE:			CText = GetDCSourceValue();  break;
		case E_PROPERTY_SINE_CURRENT_SOURCE:		CText = GetSineSourceValue(); break;
		case E_PROPERTY_PULSE_CURRENT_SOURCE:		CText = GetPulseSourceValue(); break;
		case E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE:	CText = GetExpSourceValue(); break;
		case E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE:CText = GetPWLSourceValue(); break;
		case E_PROPERTY_SINGLE_FREQ_CURRENT_FM:		CText = GetSFFMSourceValue(); break;
	
		default: CText = GetSubCircuitDefaultValue(); break; //A Type devices
	}

	return CText;
}

double  TCSchematicObjectData::GetComponentValue(int label_id)
{
	int size_check;

	size_check = CLabelListData.GetSize();

	if(!(label_id < size_check)) return 0; //SpiceMKSStringToFloat(CLabelListData[label_id].CLabel);

	if(!PCMAnalysisSetup)
	{
		return  SpiceMKSStringToFloat(CLabelListData[label_id].CLabel);
	}

	return EvaluateComponentValue(CLabelListData[label_id].CLabel);
}

double  TCSchematicObjectData::GetComponentLabelValue(int label_id)
{
	int size_check;

	size_check = CLabelListData.GetSize();

	if(!(label_id < size_check)) return 0;//SpiceMKSStringToFloat(CLabelListData[label_id].CLabelValue);

	if(!PCMAnalysisSetup)
	{
		return  SpiceMKSStringToFloat(CLabelListData[label_id].CLabelValue);
	}

	return EvaluateComponentValue(CLabelListData[label_id].CLabelValue);
}

double TCSchematicObjectData::EvaluateComponentValue(CString CLable)
{
	if(!PCMAnalysisSetup) return 0;
	if(!PCMAnalysisSetup->PCDoc) return 0;

	TCSuperSpiceDoc *PCDoc = PCMAnalysisSetup->PCDoc->GetTopLevelDoc();
	
	if(!PCDoc) return 0;

	double data = PCDoc->EvaluateComponentValue(CLable);

	return data;
}

CString TCSchematicObjectData::GetSchematicParameters(void)
{
	if(!PCMAnalysisSetup) return "";

	if(!PCMAnalysisSetup->PCDoc) return "";

	TCSuperSpiceDoc *PCDoc = PCMAnalysisSetup->PCDoc->GetTopLevelDoc();
	
	if(!PCDoc) return "";

	CString CSchematicParameters;

	CSchematicParameters = PCDoc->GetSchematicParameters();

	return CSchematicParameters;
}

CString TCSchematicObjectData::GetComponentValueSpiceString(int label_id)
{
	return FloatToSpiceMKSString(GetComponentValue(label_id));
}

CString TCSchematicObjectData::GetComponentLabelValueSpiceString(int label_id)
{
	return FloatToSpiceMKSString(GetComponentLabelValue(label_id));
}

CString TCSchematicObjectData::GetResistorValue(void)
{
	CString CText;
	double	value;
	CString CValue;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

//	value = SpiceMKSStringToFloat(CLabelListData[E_COMPONENT_VALUE].CLabel);

	value = GetComponentValue(E_COMPONENT_VALUE);

	CValue = FloatToSpiceMKSString(value);

	if(!CSpiceParameters.use_model)
	{
		if(!m_rerun_enable )

		{
			CText = GetTCMString(E_COMPONENT_RESISTOR_TEMPCO1, E_COMPONENT_RESISTOR_TEMPCO2, E_COMPONENT_RESISTOR_MULTIPLIER_M);

			CValue += ' ' + CText;

			return CValue;
		}
	}

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) 
	{
		CValue = "W=1 L=1";// value calculated from sheet resistance in model

		CText = CText.Left(CText.GetLength() - 3) + CRefDes + "_XN";
	}

	CText += ' ' + CValue;

	CValue = GetTCMString(E_COMPONENT_RESISTOR_TEMPCO1, E_COMPONENT_RESISTOR_TEMPCO2, E_COMPONENT_RESISTOR_MULTIPLIER_M);

	CText += ' ' + CValue;

	return CText;
}

CString TCSchematicObjectData::GetCapacitorValue(void)
{
	CString CText;
	double	value;
	CString CValue;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	value = GetComponentValue(E_COMPONENT_VALUE);

	CValue = FloatToSpiceMKSString(value);

	if(!CSpiceParameters.use_model)
	{
		if(!m_rerun_enable)
		{
			CText = GetComponentLabelValueSpiceString(E_COMPONENT_CAPACITOR_IC); 

			CText.TrimLeft();
			CText.TrimRight();
			
			if(CText != "" && CText != "0")
			{
				CValue += ' ';

				CValue += "IC=" + CText;
			}
			
			CValue += ' ' + GetTCMString(E_COMPONENT_CAPACITOR_TEMPCO1, E_COMPONENT_CAPACITOR_TEMPCO2, E_COMPONENT_CAPACITOR_MULTIPLIER_M);

			return CValue;
		}
	}

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) 
	{
		CValue = "W=1 L=1";// uses virtual specific capacitance

		CText = CText.Left(CText.GetLength() - 3) + CRefDes + "_XN";
	}

	CText += ' ' + CValue;

	CValue = GetTCMString(E_COMPONENT_CAPACITOR_TEMPCO1, E_COMPONENT_CAPACITOR_TEMPCO2, E_COMPONENT_CAPACITOR_MULTIPLIER_M);

	CText += ' ' + CValue;

	return CText;
}

CString TCSchematicObjectData::GetInductorValue(void)
{
	CString CText;
	double	value;
	CString CValue;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	value = GetComponentValue(E_COMPONENT_VALUE);

	CValue = FloatToSpiceMKSString(value);

	if(!CSpiceParameters.use_model)
	{
		if(!m_rerun_enable)
		{
			CText = GetComponentLabelValueSpiceString(E_COMPONENT_INDUCTOR_IC);

			CText.TrimLeft();
			CText.TrimRight();

			if(CText != "" && CText != "0")
			{
				CValue += ' ';

				CValue += "IC=" + CText;
			}

			CValue += ' ' + GetTCMString(E_COMPONENT_INDUCTOR_TEMPCO1, E_COMPONENT_INDUCTOR_TEMPCO2, -1);

			return CValue;
		}	
	}

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) 
	{
		CValue = "";// uses subcircuit for data

		CText = CText.Left(CText.GetLength() - 3) + CRefDes + "_XN";
	}

	CText += ' ' + CValue;

	return CText;
}

CString TCSchematicObjectData::GetICResistorValue(void)
{
	CString CText;
	double	value;
	CString CValue;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	value = GetComponentValue(E_COMPONENT_VALUE);

	CValue = FloatToSpiceMKSString(value);

	if(!CSpiceParameters.use_model)
	{
		return CValue;
	}

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	double data = GetComponentLabelValue(E_COMPONENT_RESISTOR_LENGTH);

	if(data)
		CText += " L=" + FloatToSpiceMKSString(data);

	data = GetComponentLabelValue(E_COMPONENT_RESISTOR_WIDTH);

	if(data)
		CText += " W=" + FloatToSpiceMKSString(data);

	data = GetComponentLabelValue(E_COMPONENT_RESISTOR_MULTIPLIER_M);

	if(data <= 0) data = 1;

	data = 1/data;// m resistors in series

	if(data != 1)
		CText += " M=" + FloatToSpiceMKSString(data);

	return CText;
}

CString TCSchematicObjectData::GetICCapacitorValue(void)
{
	CString CText;
	double	value;
	CString CValue;
	double data;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	value = GetComponentValue(E_COMPONENT_VALUE);

	CValue = FloatToSpiceMKSString(value);

	if(!CSpiceParameters.use_model)
	{
		return CValue;
	}

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	CText += " L=" + FloatToSpiceMKSString(GetComponentLabelValue(E_COMPONENT_CAPACITOR_LENGTH));

	CText += " W=" + FloatToSpiceMKSString(GetComponentLabelValue(E_COMPONENT_CAPACITOR_WIDTH));

	data = GetComponentLabelValue(E_COMPONENT_CAPACITOR_MULTIPLIER_M);

	if(data <= 0) data = 1;

	if(data != 1)
		CText += " M=" + FloatToSpiceMKSString(data);

	return CText;
}

CString TCSchematicObjectData::GetDiodeValue(void)
{
	CString CText;

	if(!CSpiceParameters.use_model)
	{
		return FloatToSpiceMKSString(GetComponentValue(E_COMPONENT_VALUE));
	}

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	CText += ' ' + FloatToSpiceMKSString(GetComponentLabelValue(E_COMPONENT_DIODE_M));

	if(CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue != "")
	{
		double breakdown_volt=0, breakdown_volt_check;

		TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters);

		if(!PCSpiceParameters) return CText;

		if(PCSpiceParameters->Get("BV", &breakdown_volt))
		{
			breakdown_volt_check = GetComponentLabelValue(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE);

			if(breakdown_volt_check == breakdown_volt) return CText;
		}

		if(!breakdown_volt)
			CText += " Bv=" + FloatToSpiceMKSString(breakdown_volt);
	}

	return CText;
}


CString TCSchematicObjectData::GetBipolarValue(void)
{
	CString CText;
	double value;

	if(!CSpiceParameters.use_model)
	{
		return CLabelListData[E_COMPONENT_VALUE].CLabel;
	}

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	value = GetComponentLabelValue(E_COMPONENT_BIPOLAR_M);

	if(value <= 0) value = 1;

	CText += ' ' + FloatToSpiceMKSString(value);

	return CText;
}

CString TCSchematicObjectData::GetFetValue(void)
{
	CString CText, CTemp;

	if(!CSpiceParameters.use_model)
	{
		return CLabelListData[E_COMPONENT_VALUE].CLabel;
	}

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	CTemp = GetComponentLabelValueSpiceString(E_COMPONENT_FET_M);

	if(CTemp == "" || CTemp == "0") CTemp = "1";

	CText += ' ' + CTemp;

	return CText;
}

CString TCSchematicObjectData::GetMosValue(void)
{
	CString CText, CTempText;

	if(!CSpiceParameters.use_model)
	{
		return CLabelListData[E_COMPONENT_VALUE].CLabel;
	}

	if(CLabelListData[E_COMPONENT_FET_USE_DEFAULT_WL].is_visable)//16th August 2002
	{
		return CLabelListData[E_COMPONENT_VALUE].CLabel;
	}
	
	double width, length;

	GetWidthAndLength(width, length);

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.GetRecordName(width, length);

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	// If parameter data not stored locally
	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSpiceParameters);

	if(PCSpiceParameters)
	{
		if(!length) 
		{
			PCSpiceParameters->Get("L", &length);

			CTempText = FloatToMKSString(length);

			CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = CTempText;
		}

		if(!width) 
		{
			PCSpiceParameters->Get("W", &width);

			CTempText = FloatToMKSString(width);

			CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = FloatToMKSString(width);
		}
	}

	if(length)
		CText += " L=" + FloatToSpiceMKSString(GetComponentLabelValue(E_COMPONENT_FET_LENGTH));

	// multyply W by # of fingers for non BSim devices
	double number_fingers, effective_width, mos_level = 0.0;

	number_fingers = GetComponentLabelValue(E_COMPONENT_FET_M);

	if(number_fingers <= 0.0) number_fingers = 1.0;

	effective_width = GetComponentLabelValue(E_COMPONENT_FET_WIDTH);

	if(PCSpiceParameters)
	{
		PCSpiceParameters->Get("level", &mos_level);

		if(mos_level > 6 && mos_level < 15) 
		{
			if(effective_width)
				CText += " W=" + FloatToSpiceMKSString(effective_width);// dont change

			if(number_fingers > 0)
				CText += " M=" + FloatToSpiceMKSString(number_fingers);
		}
		else
		{
			effective_width *= number_fingers;

			if(effective_width)
				CText += " W=" + FloatToSpiceMKSString(effective_width);
		}
	}
	else
	{
		effective_width *= number_fingers;

		if(effective_width)
			CText += " W=" + FloatToSpiceMKSString(effective_width);
	}

	if(!PCSpiceParameters) return  CText;
	//calculate AD AS PS PD NRD NRS from new SuperSpice parameters wd, width of drain and ws, width of source 
	double wd = 0, ws = 0, ad_as = 0, ps_pd = 0, hdif = 0, rsh = 0, ns = 0;
	CString CValue; 
  
	PCSpiceParameters->Get("wd", &wd);
	PCSpiceParameters->Get("ws", &ws);
	PCSpiceParameters->Get("hdif", &hdif);
	PCSpiceParameters->Get("rsh", &rsh);
 
	if(hdif)//HSpice parameter overides 
	{  
		wd = 2 * hdif; 
		ws = wd; 
	} 
 
	if(CLabelListData[E_COMPONENT_FET_ENABLE_AD].is_visable && wd)
	{
		ad_as = effective_width * wd;

		CValue = FloatToSpiceMKSString(ad_as);
	
		CText += " AD=" + CValue;

		ps_pd = 2*effective_width + 2 * wd;

		CValue = FloatToSpiceMKSString(ps_pd);
	
		CText += " PD=" + CValue;
	}
	else CText += " AD=0 PD=0 NRD=0";

	if(CLabelListData[E_COMPONENT_FET_ENABLE_AS].is_visable && ws)
	{
		ad_as = effective_width * ws;

		CValue = FloatToSpiceMKSString(ad_as);

		CText += " AS=" + CValue;

		ps_pd = 2*effective_width + 2 * ws;

		CValue = FloatToSpiceMKSString(ps_pd);

		CText += " PS=" + CValue;
	}
	else CText += " AS=0 PS=0 NRS=0";

	if(rsh && effective_width && ws && CLabelListData[E_COMPONENT_FET_ENABLE_AS].is_visable)
	{
		ns = ws/effective_width/2;

		CValue = FloatToSpiceMKSString(ns);
	
		CText += " NRS=" + CValue;
	}

	if(rsh && effective_width && ws && CLabelListData[E_COMPONENT_FET_ENABLE_AD].is_visable)
	{
		ns = wd/effective_width/2;

		CValue = FloatToSpiceMKSString(ns);
	
		CText += " NRD=" + CValue;
	}

	return CText;
}

CString TCSchematicObjectData::GetControlledSourceValue(void)
{
	CString CText, CTemp;
	double value;

	value = GetComponentValue(E_COMPONENT_VALUE);

	CTemp = CSpiceParameters.CDataBaseIdInfo.CRecordType; // Oct 2017

	CTemp.MakeLower();

	if(CTemp.GetAt(0) == 'f' || CTemp.GetAt(0) == 'h')

		CText = CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].CLabel + " "; // Oct 2017

	if(CTemp.GetAt(0) == 'b')
	{
		CText = CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].CLabel;

		return CText;
	}

	CText += FloatToSpiceMKSString(value); 

	return CText;
}

CString TCSchematicObjectData::GetURCValue(void)
{
	CString CText;
	double	value;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	value = GetComponentLabelValue(E_COMPONENT_URC_LENGTH);

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	if(!value) value = 1;

	CText += " L=" + FloatToSpiceMKSString(value);

	CText += " N=" + GetComponentLabelValueSpiceString(E_COMPONENT_URC_NUMBER_SECTIONS);

	return CText;
}

CString TCSchematicObjectData::GetTransmissionLineValue(void)
{
	CString CText;

	CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

	return CText;
}

CString TCSchematicObjectData::GetLosslessTransmissionLineValue(void)
{
	CString CText;

	if(CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelValue != "")
		CText += CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelType + "=" + GetComponentLabelValueSpiceString(E_COMPONENT_TRANSMISSION_LINE_Z0);

	if(CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelValue != "")
		CText +=  " " + CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelType + "=" + GetComponentLabelValueSpiceString(E_COMPONENT_TRANSMISSION_LINE_TD);

	if(CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelValue != "")
		CText += " " + CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelType + "=" + GetComponentLabelValueSpiceString(E_COMPONENT_TRANSMISSION_LINE_F0);

	if(CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].CLabelValue != "")
		CText += " " + CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].CLabelType + "=" + GetComponentLabelValueSpiceString(E_COMPONENT_TRANSMISSION_LINE_LENGTH);

	return CText;
}

CString TCSchematicObjectData::GetLaplaceValue(void)
{
	CString CText;

	CText = CLabelListData[E_COMPONENT_VALUE].CLabel;//temp

	return CText;
}

CString TCSchematicObjectData::GetSubCktValue(void)
{
	CString CText;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(is_unique_model) CText = CRefDes;

	CText += CLabelListData[E_COMPONENT_VALUE].CLabel;

	if(m_rerun_enable) CText = CText.Left(CText.GetLength() - 3) + "_XN";

	return CText;
}

CString TCSchematicObjectData::GetSubCircuitDefaultValue(void)
{
	CString CText;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(is_unique_model) CText = CRefDes;

	CText += CSpiceParameters.CDataBaseIdInfo.CRecordName;

	return CText;
}

CString TCSchematicObjectData::GetSymbolParameters(void)
{
	CString CSymbolParameters;
	double length=1;
	double width=1;
	double area=1;
	double mult=1;

	CString CArea, CAreaValue, CMultiplier, CMultiplierValue;

	if(component_property_view_type == E_PROPERTY_MOSFET)
	{
		GetWidthAndLength(width, length);

		CSymbolParameters = CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabel;

		mult = GetComponentLabelValue(E_COMPONENT_FET_M);
	}
	else if(component_property_view_type == E_PROPERTY_FET || component_property_view_type == E_PROPERTY_MESFET)
	{
		CSymbolParameters	= CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabel;

		mult = GetComponentLabelValue(E_COMPONENT_FET_M);
		
		// Extract width and length, if specified, lazy...

		EquationSetVaribles(CSymbolParameters);

		if(!GetValue(GSSKeyWordLength.GetBuffer(GSSKeyWordWidth.GetLength() + 1), &length)) length = 1;

		if(!GetValue(GSSKeyWordWidth.GetBuffer(GSSKeyWordWidth.GetLength() + 1), &width)) width = 1; 
	}
	else if(component_property_view_type == E_PROPERTY_BIPOLAR)
	{
		CSymbolParameters	= CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabel;

		mult = GetComponentLabelValue(E_COMPONENT_BIPOLAR_M);
		
		// Extract width and length, if specified, lazy...

		EquationSetVaribles(CSymbolParameters);

		if(!GetValue(GSSKeyWordLength.GetBuffer(GSSKeyWordWidth.GetLength() + 1), &length)) length = 1;

		if(!GetValue(GSSKeyWordWidth.GetBuffer(GSSKeyWordWidth.GetLength() + 1), &width)) width = 1; 
	}	
	else if(component_property_view_type == E_PROPERTY_IC_RESISTOR)
	{
		mult = GetComponentLabelValue(E_COMPONENT_RESISTOR_MULTIPLIER_M);

		width = GetComponentLabelValue(E_COMPONENT_RESISTOR_WIDTH);

		length = GetComponentLabelValue(E_COMPONENT_RESISTOR_LENGTH);

		CSymbolParameters.Format("%s=%e %s=%e ", GSSKeyWordWidth, width, GSSKeyWordLength, length);
	}
	else if(component_property_view_type == E_PROPERTY_IC_CAPACITOR)
	{
		mult = GetComponentLabelValue(E_COMPONENT_CAPACITOR_MULTIPLIER_M);

		width = GetComponentLabelValue(E_COMPONENT_CAPACITOR_WIDTH);

		length = GetComponentLabelValue(E_COMPONENT_CAPACITOR_LENGTH);

		CSymbolParameters.Format("%s=%e %s=%e ", GSSKeyWordWidth, width, GSSKeyWordLength, length);
	}
	else if(component_property_view_type == E_PROPERTY_GENERIC_SUBCIRCUIT)
	{
		CSymbolParameters	= CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel;
		
		// Extract width and length, if specified, lazy...

		EquationSetVaribles(CSymbolParameters);

		if(!GetValue(GSSKeyWordLength.GetBuffer(GSSKeyWordWidth.GetLength() + 1), &length)) length = 1;

		if(!GetValue(GSSKeyWordWidth.GetBuffer(GSSKeyWordWidth.GetLength() + 1), &width)) width = 1; 
	}
	else return "";

	area = width * length * mult;

	CAreaValue.Format("%e", area);

	CArea = " " + GSSKeyWordArea + "=" + CAreaValue + " "; //"area" is a special prediffined parameter name

	CMultiplierValue.Format("%e", mult);

	if(!mult || mult < 0)		mult = 1;
	if(!length || length < 0)	length = 1;
	if(!width || width < 0)		width = 1;

	CMultiplier = " " + GSSKeyWordMultiplier + "=" + CMultiplierValue; //"m" is a special prediffined parameter name

	CSymbolParameters = CSymbolParameters + CArea  + CMultiplier;

	return CSymbolParameters;
}

bool TCSchematicObjectData::GetWidthAndLength(double &width, double &length)
{
	width = 1;
	length = 1;

	if(component_property_view_type == E_PROPERTY_MOSFET)
	{
		if(!(E_COMPONENT_FET_USE_DEFAULT_WL < CLabelListData.GetSize())) return false;

		length = GetComponentLabelValue(E_COMPONENT_FET_LENGTH);

		width = GetComponentLabelValue(E_COMPONENT_FET_WIDTH);

		if(!length) length = 1;

		if(!width) width = 1;

		return true;
	}
	if(component_property_view_type == E_PROPERTY_RESISTOR)
	{
		if(!(E_COMPONENT_RESISTOR_MULTIPLIER_M < CLabelListData.GetSize())) return false;

		length = GetComponentLabelValue(E_COMPONENT_RESISTOR_LENGTH);

		width = GetComponentLabelValue(E_COMPONENT_RESISTOR_WIDTH);

		if(!length) length = 1;

		if(!width) width = 1;
		
		return true;
	}
	if(component_property_view_type == E_PROPERTY_CAPACITOR)
	{
		if(!(E_COMPONENT_CAPACITOR_MULTIPLIER_M < CLabelListData.GetSize())) return false;

		length = GetComponentLabelValue(E_COMPONENT_CAPACITOR_LENGTH);

		width = GetComponentLabelValue(E_COMPONENT_CAPACITOR_WIDTH);

		if(!length) length = 1;

		if(!width) width = 1;

		return true;
	}

	return false;
}

CString TCSchematicObjectData::GetTCMString(int tc1, int tc2, int m_id)
{
	CString CTemp, CValue, CText;
	double m, value;

	value = GetComponentLabelValue(tc1);

	CTemp = FloatToMKSString(value);
		
	if(CTemp != "0")
	{
		CTemp = MKSStringToSpiceMKSString(CTemp);

		CValue = "TC1=" + CTemp;
	}

	value = GetComponentLabelValue(tc2); 
			
	CTemp = FloatToMKSString(value);

	if(CTemp != "0")
	{
		CTemp = MKSStringToSpiceMKSString(CTemp);

		CValue += ' ';

		CValue += "TC2=" + CTemp;
	}

	if(m_id < 0) return CValue;

	value = GetComponentLabelValue(m_id);

	if(!value) return CValue;

	CTemp = FloatToMKSString(value);

	if(CTemp != "" && CTemp != "1" )
	{
		m = MKSStringToFloat(CTemp);
		
		if(m != 1)
		{
			if(m_id == E_COMPONENT_RESISTOR_MULTIPLIER_M) m = 1/m;// resistors specifide by number in series

			CTemp = FloatToSpiceMKSString(m);

			CValue += ' ';

			CValue += "M=" + CTemp;
		}
	}

	return CValue;
}

bool TCSchematicObjectData::FormatLabel(void)
{
	if(attached_model_type == E_SPICE_GENERATOR)
	{
		switch(component_property_view_type)
		{
			case E_PROPERTY_DC_VOLTAGE_SOURCE:FormatDCGenerator();return true;
			case E_PROPERTY_SINE_VOLTAGE_SOURCE:FormatSineGenerator();return true;
			case E_PROPERTY_PULSE_VOLTAGE_SOURCE:FormatPulseGenerator();return true;
			case E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE:FormatExpGenerator();return true;
			case E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE:FormatPWLGenerator();return true;
			case E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM:FormatSFFMGenerator();return true;
			case E_PROPERTY_DC_CURRENT_SOURCE:FormatDCGenerator();return true;
			case E_PROPERTY_SINE_CURRENT_SOURCE:FormatSineGenerator();return true;
			case E_PROPERTY_PULSE_CURRENT_SOURCE:FormatPulseGenerator();return true;
			case E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE:FormatExpGenerator();return true;
			case E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE:FormatPWLGenerator();return true;
			case E_PROPERTY_SINGLE_FREQ_CURRENT_FM:FormatSFFMGenerator();return true;
		}

		return true;
	}

	switch(component_property_view_type)
	{
		case E_TEST_MARKER:FormatTestMarker();return true;

		case E_PROPERTY_RESISTOR:FormatResistor();return true;
		case E_PROPERTY_IC_RESISTOR:FormatICResistor();return true;
		case E_PROPERTY_CAPACITOR:FormatCapacitor();return true;
		case E_PROPERTY_IC_CAPACITOR:FormatICCapacitor();return true;
		case E_PROPERTY_INDUCTOR:FormatInductor();return true;
		case E_PROPERTY_DIODE:FormatDiode();return true;
		case E_PROPERTY_URC_TRANSMISSION_LINE:FormatURC();return true;

		case E_PROPERTY_BIPOLAR:FormatTransistor();return true;

		case E_PROPERTY_MOSFET:FormatMOS();return true;

		case E_PROPERTY_FET: 
		case E_PROPERTY_MESFET:
				FormatFet();return true;

		case E_PROPERTY_CONTROLED_SOURCE:FormatVCVC();return true;

		case E_PROPERTY_TRANSFORMER:FormatTransformer();return true;
		case E_PROPERTY_TRANSMISSION_LINE:FormatTransmissionLine();return true;
		case E_PROPERTY_LOSSLESS_TRANSMISSION_LINE:FormatLosslessTransmissionLine();return true;

		case E_PROPERTY_SWITCH:FormatVSwitch();return true;
		case E_PROPERTY_ISWITCH:FormatISwitch();return true;
		
		case E_PROPERTY_MULTYPLIER:;
		case E_PROPERTY_DIVIDER: FormatMultiplier();return true;

		case E_PROPERTY_SUBCIRCUIT_PIN_CONNECTORS: return true;
		case E_PROPERTY_LAPLACE_TRANSFORM: FormatLaplace(); return true;

		case E_PROPERTY_VARIABLE_RESISTOR: FormatVariableResistor();return true;

		case E_PROPERTY_TITLE_BLOCK:
		case E_PROPERTY_NULL:		return true;

		default: FormatSubcircuit(); return true;
	}
}

bool TCSchematicObjectData::FormatRecordName(void)
{
	if(type == E_WAVEFORM_COMPONENT) return true;

	if(attached_model_type == E_SPICE_SCHEMATIC)
	{
		CSpiceParameters.CDataBaseIdInfo.CRecordName = CSymbolData.CName;
		
		return true;
	}

	CSpiceParameters.CDataBaseIdInfo.CRecordName = CSpiceParameters.FormatSpiceValue(CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel);

	return true;
}

bool TCSchematicObjectData::FormatSpiceValue(void)
{
	if(!format_spice_value) return true;

	CString CText;

	if(attached_model_type == E_SPICE_SCHEMATIC)
	{
		CLabelListData[E_COMPONENT_VALUE].CLabel = CSymbolData.CName;
		
		return true;
	}

	CText = CSpiceParameters.FormatSpiceValue(CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel);

	CLabelListData[E_COMPONENT_VALUE].CLabel = CText;

	if(CText == CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel)
	{
		CText = CText.Left(CText.GetLength() - 3);

		CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CText;
	}

	return true;
}

bool TCSchematicObjectData::FormatSpiceName(void)
{
	CString CText;

	if(type == E_WAVEFORM_COMPONENT) return true;
	if(type == E_TITLE_BLOCK) return true;

	if(attached_model_type == E_SPICE_SCHEMATIC)
	{
		CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CSymbolData.CName;
		
		return true;
	}

	CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

	int count = CText.GetLength();

	CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CText.Left(count - 3);

	return true;
}

bool TCSchematicObjectData::FormatLabels()
{
	if(type == E_WAVEFORM_COMPONENT) return true;
	if(type == E_LABEL_COMPONENT) return true;
	if(type == E_TITLE_BLOCK) return true;

	if(type != E_WIRE_COMPONENT)
	{
		FormatComponent();
	}
	else return FormatWire();

	if(PCGeneratorData)
	{
		TCSuperSpiceDoc *PCDocX = NULL;
		
		if(PCMAnalysisSetup) PCDocX = PCMAnalysisSetup->PCDoc->GetTopLevelDoc();

		CLabelListData[E_COMPONENT_VALUE].CLabel = PCGeneratorData->Format(PCDocX);

		FormatLabel();

		return true;
	}

	FormatLabel();

	return true;
}

void TCSchematicObjectData::SetGeneratorLabelSize(int version)
{
	if(version < 0) CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	switch(version)
	{
		case 0: CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);
	}
}

bool TCSchematicObjectData::FormatCLabel(int label_id)
{
	CString CTemp;

	if(label_id >= CLabelListData.GetSize())
	{
		ASSERT(0);

		return false;
	}
	CTemp = CLabelListData[label_id].CLabelType	+ '=';

	CTemp += CLabelListData[label_id].CLabelValue;

	CLabelListData[label_id].CLabel = CTemp;

	return true;
}

bool TCSchematicObjectData::FormatComponent()
{
	if(!(E_COMPONENT_MAX_LABEL_NUMBER < CLabelListData.GetSize()))
	{
		CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);
	}

	return true;
}

bool TCSchematicObjectData::FormatWire()
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}
bool TCSchematicObjectData::FormatTestMarker(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}

bool TCSchematicObjectData::FormatSubcircuit(void)
{
	CLabelListData.SetSize(E_COMPONENT_SUBCKT_PARAMETERS + 1);// Extra 1 added to support parameters 12th April 2005

	FormatSpiceValue();

	return true;
}

bool TCSchematicObjectData::FormatLaplace(void)
{
	CLabelListData.SetSize(E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY  + 1, E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY + 1);

	CLabelListData[E_COMPONENT_LAPLACE_NUMERATOR].CLabelType = "N";
	CLabelListData[E_COMPONENT_LAPLACE_DENOMINATOR].CLabelType = "D";
	CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].CLabelType = "Ref.Freq.";
	CLabelListData[E_COMPONENT_LAPLACE_GAIN].CLabelType = "Gain";

	FormatCLabel(E_COMPONENT_LAPLACE_NUMERATOR);
	FormatCLabel(E_COMPONENT_LAPLACE_DENOMINATOR);
	FormatCLabel(E_COMPONENT_LAPLACE_GAIN);
	FormatCLabel(E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY);

	return true;
}

bool TCSchematicObjectData::FormatResistor(void)
{
	CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE  + 1, E_COMPONENT_RESISTOR_RESISTANCE + 1);
	
	CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelType = "W";
	CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelType = "L";
	CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelType = "TC1";
	CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelType = "TC2";
	CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelType = "R";
	CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelType = "M";

	FormatCLabel(E_COMPONENT_RESISTOR_RESISTANCE);
	FormatCLabel(E_COMPONENT_RESISTOR_TEMPCO1);
	FormatCLabel(E_COMPONENT_RESISTOR_TEMPCO2);
	FormatCLabel(E_COMPONENT_RESISTOR_MULTIPLIER_M);

	CSpiceParameters.UpdateUseModel();

	return true;
}

bool TCSchematicObjectData::FormatCapacitor(void)
{
	CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE  + 1, E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);

	CLabelListData[E_COMPONENT_CAPACITOR_IC].CLabelType = "IC";
	CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelType = "W";
	CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelType = "L";
	CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].CLabelType = "TC1";
	CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].CLabelType = "TC2";
	CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelType = "M";

	FormatCLabel(E_COMPONENT_CAPACITOR_IC);
	FormatCLabel(E_COMPONENT_CAPACITOR_TEMPCO1);
	FormatCLabel(E_COMPONENT_CAPACITOR_TEMPCO2);
	FormatCLabel(E_COMPONENT_CAPACITOR_MULTIPLIER_M);

	CSpiceParameters.UpdateUseModel();

	return true;
}

bool TCSchematicObjectData::FormatVariableResistor(void)
{
	CLabelListData.SetSize(E_COMPONENT_VARABLE_RESISTOR_LOG_MULTIPLYER  + 1, E_COMPONENT_VARABLE_RESISTOR_LOG_MULTIPLYER + 1);

	CLabelListData[E_COMPONENT_VARABLE_RESISTOR_RESISTANCE].CLabelType = "R";
	CLabelListData[E_COMPONENT_VARABLE_RESISTOR_ROTATION].CLabelType = "Rot.";
	CLabelListData[E_COMPONENT_VARABLE_RESISTOR_LOG].CLabelType = "FALSE";

	FormatCLabel(E_COMPONENT_VARABLE_RESISTOR_LOG);
	FormatCLabel(E_COMPONENT_VARABLE_RESISTOR_LOG_MULTIPLYER);
	FormatCLabel(E_COMPONENT_VARABLE_RESISTOR_RESISTANCE);
	FormatCLabel(E_COMPONENT_VARABLE_RESISTOR_ROTATION);

	return true;
}

bool TCSchematicObjectData::FormatICResistor(void)
{
	CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE  + 1, E_COMPONENT_RESISTOR_RESISTANCE + 1);

	double resistance = 1e-12, length =1e-6, width=1e-6, sheet=1e-3;

	CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelType = "W";

	CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelType = "L";

	CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelType = "TC1";
	CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].CLabelType = "R/Sq";
	CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelType = "TC2";
	CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelType = "R";
	CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelType = "M";

	FormatCLabel(E_COMPONENT_RESISTOR_TEMPCO1);
	FormatCLabel(E_COMPONENT_RESISTOR_TEMPCO2);
	FormatCLabel(E_COMPONENT_RESISTOR_MULTIPLIER_M);

	sheet = MKSStringToFloat(CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].CLabelValue);
	FormatCLabel(E_COMPONENT_RESISTOR_RESISTIVITY);

	width = MKSStringToFloat(CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelValue);
	FormatCLabel(E_COMPONENT_RESISTOR_WIDTH);

	length = MKSStringToFloat(CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelValue);
	FormatCLabel(E_COMPONENT_RESISTOR_LENGTH);

	if(!width) width = 1e-6;

	resistance = sheet * length / width;

	CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelValue = 
	FloatToSpiceMKSString(resistance);
	FormatCLabel(E_COMPONENT_RESISTOR_RESISTANCE);
	
	return true;
}

bool TCSchematicObjectData::FormatICCapacitor(void)
{	
	CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1 , E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);

	double capacitance = 1e-12, length =1e-6, width=1e-6, sheet=1e-3;
	
	CLabelListData[E_COMPONENT_CAPACITOR_IC].CLabelType = "IC";
	CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelType = "W";
	CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelType = "L";
	CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].CLabelType = "TC1";
	CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].CLabelType = "TC2";
	CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelType = "M";
	CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelType = "C";


	FormatCLabel(E_COMPONENT_CAPACITOR_IC);
	FormatCLabel(E_COMPONENT_CAPACITOR_LENGTH);
	FormatCLabel(E_COMPONENT_CAPACITOR_WIDTH);
	FormatCLabel(E_COMPONENT_CAPACITOR_CAPACITIVITY);
	FormatCLabel(E_COMPONENT_CAPACITOR_MULTIPLIER_M);

	width = MKSStringToFloat(CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelValue);
	FormatCLabel(E_COMPONENT_CAPACITOR_WIDTH);

	length = MKSStringToFloat(CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelValue);
	FormatCLabel(E_COMPONENT_CAPACITOR_LENGTH);

	sheet = MKSStringToFloat(CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].CLabelValue);

	capacitance = sheet * length * width;
	
	CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelValue = 
	FloatToSpiceMKSString(capacitance);
	FormatCLabel(E_COMPONENT_CAPACITOR_CAPAPACITANCE);
	
	return true;
}

bool TCSchematicObjectData::FormatInductor(void)
{
	CLabelListData.SetSize(E_COMPONENT_INDUCTOR_TEMPCO2  + 1, E_COMPONENT_INDUCTOR_TEMPCO2 + 1);

	CLabelListData[E_COMPONENT_INDUCTOR_IC].CLabelType = "IC";

	FormatCLabel(E_COMPONENT_INDUCTOR_IC);
	FormatCLabel(E_COMPONENT_INDUCTOR_TEMPCO1);
	FormatCLabel(E_COMPONENT_INDUCTOR_TEMPCO2);

	CSpiceParameters.UpdateUseModel();

	return true;
}

bool TCSchematicObjectData::FormatDiode(void)
{
	CLabelListData.SetSize(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE  + 1, E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1);

	CLabelListData[E_COMPONENT_DIODE_M].CLabelType = "M";
	CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelType = "BV";

	FormatCLabel(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE);
	FormatCLabel(E_COMPONENT_DIODE_M);

	FormatSpiceValue();

	return true;
}

bool TCSchematicObjectData::FormatURC(void)
{
	CLabelListData.SetSize(E_COMPONENT_URC_NUMBER_SECTIONS  + 1, E_COMPONENT_URC_NUMBER_SECTIONS + 1);

	CLabelListData[E_COMPONENT_URC_NUMBER_SECTIONS].CLabelType = "N";
	CLabelListData[E_COMPONENT_URC_LENGTH].CLabelType = "L";

	FormatCLabel(E_COMPONENT_URC_NUMBER_SECTIONS);
	FormatCLabel(E_COMPONENT_URC_LENGTH);
	
	return true;
}

bool TCSchematicObjectData::FormatTransistor(void)
{
	CLabelListData.SetSize(E_COMPONENT_BIPOLAR_PARAMETERS  + 1, E_COMPONENT_BIPOLAR_PARAMETERS + 1);

	CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelType = "M";
	CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelType = "Params";

	FormatCLabel(E_COMPONENT_BIPOLAR_M);

	CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabel = CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue; 
	
	FormatSpiceValue();

	return true;
}

bool TCSchematicObjectData::FormatFet(void)
{
	CString CText;

	CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS  + 1, E_COMPONENT_FET_PARAMETERS + 1);

	CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = ""; 
	CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "";
	CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelType = "";

	CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabel = CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelValue;


	FormatCLabel(E_COMPONENT_FET_M);  

	FormatSpiceValue();

	return true;
}

bool TCSchematicObjectData::FormatMOS(void)
{
	CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS  + 1, E_COMPONENT_FET_PARAMETERS + 1);

	CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
	CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelType = "";

	CLabelListData[E_COMPONENT_FET_ENABLE_AD].CLabel = ""; // 
	CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabel = "";
	CLabelListData[E_COMPONENT_FET_ENABLE_AD].CLabelType = "";
	CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "";
	CLabelListData[E_COMPONENT_FET_USE_DEFAULT_WL].CLabel = ""; 
	CLabelListData[E_COMPONENT_FET_USE_DEFAULT_WL].CLabelType = "";

	FormatCLabel(E_COMPONENT_FET_M);
	FormatCLabel(E_COMPONENT_FET_WIDTH);
	FormatCLabel(E_COMPONENT_FET_LENGTH);

	CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabel = CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelValue;

	FormatSpiceValue();

	return true;
}

bool TCSchematicObjectData::FormatDCGenerator(void)
{
	if(!PCGeneratorData) return false;

	int size = CLabelListData.GetSize();

	if(!(E_GENERATOR_PHASE_VALUE < size))
	{
		CLabelListData.SetSize(E_GENERATOR_PHASE_VALUE + 1);
	}

	CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CLabelListData[E_GENERATOR_AC_IMD1].CLabelType = "I.M.D.1";
	CLabelListData[E_GENERATOR_AC_IMD2].CLabelType = "I.M.D.2";

	CLabelListData[E_GENERATOR_DC_VALUE].CLabelValue = PCGeneratorData->CDCGeneratorData.CDCVoltage;
//	FloatToSpiceMKSString(PCGeneratorData->CDCGeneratorData.dc_voltage);

	FormatCLabel(E_GENERATOR_DC_VALUE);
	 
	CLabelListData[E_GENERATOR_AC_VALUE].CLabelValue = PCGeneratorData->CDCGeneratorData.CACVoltage;
//	FloatToSpiceMKSString(PCGeneratorData->CDCGeneratorData.ac_voltage);
	FormatCLabel(E_GENERATOR_AC_VALUE);

	CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelValue = PCGeneratorData->CDCGeneratorData.CACPhase;
//	FloatToSpiceMKSString(PCGeneratorData->CDCGeneratorData.ac_phase);
	FormatCLabel(E_GENERATOR_PHASE_VALUE);

	FormatCLabel(E_GENERATOR_AC_IMD1);
	FormatCLabel(E_GENERATOR_AC_IMD2);

	return true;
}

bool TCSchematicObjectData::FormatSineGenerator(void)
{
	if(!FormatDCGenerator()) return false;

	CLabelListData.SetSize(E_GENERATOR_SINE_DAMPING_VALUE + 1);

	CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].CLabelType = "VPk";
	CLabelListData[E_GENERATOR_SINE_FREQUENCY_VALUE].CLabelType = "F";
	CLabelListData[E_GENERATOR_SINE_OFFSET_VALUE].CLabelType = "Offset";
	CLabelListData[E_GENERATOR_SINE_DELAY_VALUE].CLabelType = "Delay";
	CLabelListData[E_GENERATOR_SINE_DAMPING_VALUE].CLabelType = "Damping";
	CLabelListData[E_GENERATOR_SINE_IMD1].CLabelType = "I.M.D.1";
	CLabelListData[E_GENERATOR_SINE_IMD2].CLabelType = "I.M.D.2";

	CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].CLabelValue = PCGeneratorData->CSineGeneratorData.CAmplitude;
//	FloatToSpiceMKSString(PCGeneratorData->CSineGeneratorData.amplitude);
	FormatCLabel(E_GENERATOR_SINE_AMPLITUDE_VALUE);

	CLabelListData[E_GENERATOR_SINE_FREQUENCY_VALUE].CLabelValue = PCGeneratorData->CSineGeneratorData.CFrequency;
//	FloatToSpiceMKSString(PCGeneratorData->CSineGeneratorData.frequency);
	FormatCLabel(E_GENERATOR_SINE_FREQUENCY_VALUE);

	CLabelListData[E_GENERATOR_SINE_OFFSET_VALUE].CLabelValue = PCGeneratorData->CSineGeneratorData.COffset;
//	FloatToSpiceMKSString(PCGeneratorData->CSineGeneratorData.offset);
	FormatCLabel(E_GENERATOR_SINE_OFFSET_VALUE);

	CLabelListData[E_GENERATOR_SINE_DELAY_VALUE].CLabelValue = PCGeneratorData->CSineGeneratorData.CDelay;
//	FloatToSpiceMKSString(PCGeneratorData->CSineGeneratorData.delay);
	FormatCLabel(E_GENERATOR_SINE_DELAY_VALUE);

	CLabelListData[E_GENERATOR_SINE_DAMPING_VALUE].CLabelValue = PCGeneratorData->CSineGeneratorData.CDamping;
//	FloatToSpiceMKSString(PCGeneratorData->CSineGeneratorData.damping);
	FormatCLabel(E_GENERATOR_SINE_DAMPING_VALUE);

	FormatCLabel(E_GENERATOR_SINE_IMD1);
	FormatCLabel(E_GENERATOR_SINE_IMD2);

	return true;
}

bool TCSchematicObjectData::FormatPulseGenerator(void)
{
	if(!FormatDCGenerator()) return false;

	CLabelListData.SetSize(E_GENERATOR_PULSE_PERIOD_VALUE + 1);

	CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CLabelListData[E_GENERATOR_PULSE_START_AMPLITUDE_VALUE].CLabelType = "V1";
	CLabelListData[E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE].CLabelType = "V2";
	CLabelListData[E_GENERATOR_PULSE_DELAY_VALUE].CLabelType = "Td";
	CLabelListData[E_GENERATOR_PULSE_RISE_TIME_VALUE].CLabelType = "Tr";
	CLabelListData[E_GENERATOR_PULSE_FALL_TIME_VALUE].CLabelType = "Tf";
	CLabelListData[E_GENERATOR_PULSE_WIDTH_VALUE].CLabelType = "Width";
	CLabelListData[E_GENERATOR_PULSE_PERIOD_VALUE].CLabelType = "Period";
	CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelType = "I.M.D.1";
	CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelType = "I.M.D.2";

	CLabelListData[E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CEnd;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.end);
	FormatCLabel(E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE);

	CLabelListData[E_GENERATOR_PULSE_START_AMPLITUDE_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CStart;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.start);
	FormatCLabel(E_GENERATOR_PULSE_START_AMPLITUDE_VALUE);

	CLabelListData[E_GENERATOR_PULSE_RISE_TIME_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CRise;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.rise);
	FormatCLabel(E_GENERATOR_PULSE_RISE_TIME_VALUE);

	CLabelListData[E_GENERATOR_PULSE_FALL_TIME_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CFall;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.fall);
	FormatCLabel(E_GENERATOR_PULSE_FALL_TIME_VALUE);

	CLabelListData[E_GENERATOR_PULSE_WIDTH_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CWidth;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.width);
	FormatCLabel(E_GENERATOR_PULSE_WIDTH_VALUE);

	CLabelListData[E_GENERATOR_PULSE_DELAY_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CDelay;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.delay);
	FormatCLabel(E_GENERATOR_PULSE_DELAY_VALUE);

	CLabelListData[E_GENERATOR_PULSE_PERIOD_VALUE].CLabelValue = PCGeneratorData->CPulseGeneratorData.CPeriod;
//	FloatToSpiceMKSString(PCGeneratorData->CPulseGeneratorData.period);
	FormatCLabel(E_GENERATOR_PULSE_PERIOD_VALUE);

	FormatCLabel(E_GENERATOR_PULSE_IMD1);
	FormatCLabel(E_GENERATOR_PULSE_IMD2);

	return true;
}

bool TCSchematicObjectData::FormatExpGenerator(void)
{
	if(!FormatDCGenerator()) return false;

	CLabelListData.SetSize(E_GENERATOR_EXP_TAU2_VALUE + 1);

	CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CLabelListData[E_GENERATOR_EXP_START_VALUE].CLabelType = "V1";
	CLabelListData[E_GENERATOR_EXP_STOP_VALUE].CLabelType = "V2";
	CLabelListData[E_GENERATOR_EXP_TAU1_DELAY_VALUE].CLabelType = "Tau1 delay";
	CLabelListData[E_GENERATOR_EXP_TAU1_VALUE].CLabelType = "Tau1";
	CLabelListData[E_GENERATOR_EXP_TAU2_DELAY_VALUE].CLabelType = "Tau2 delay";
	CLabelListData[E_GENERATOR_EXP_TAU2_VALUE].CLabelType = "Tau2";
	CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VExp";
	CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VExp";
	CLabelListData[E_GENERATOR_EXP_IMD1].CLabelType = "I.M.D.1";
	CLabelListData[E_GENERATOR_EXP_IMD2].CLabelType = "I.M.D.2";

	CLabelListData[E_GENERATOR_EXP_START_VALUE].CLabelValue = PCGeneratorData->CExponentialGeneratorData.CStart;
//	FloatToSpiceMKSString(PCGeneratorData->CExponentialGeneratorData.start);
	FormatCLabel(E_GENERATOR_EXP_START_VALUE);

	CLabelListData[E_GENERATOR_EXP_STOP_VALUE].CLabelValue = PCGeneratorData->CExponentialGeneratorData.CEnd;
//	FloatToSpiceMKSString(PCGeneratorData->CExponentialGeneratorData.end);
	FormatCLabel(E_GENERATOR_EXP_STOP_VALUE);

	CLabelListData[E_GENERATOR_EXP_TAU1_DELAY_VALUE].CLabelValue = PCGeneratorData->CExponentialGeneratorData.CDelay1;
//	FloatToSpiceMKSString(PCGeneratorData->CExponentialGeneratorData.delay1);
	FormatCLabel(E_GENERATOR_EXP_TAU1_DELAY_VALUE);

	CLabelListData[E_GENERATOR_EXP_TAU1_VALUE].CLabelValue = PCGeneratorData->CExponentialGeneratorData.CRiseTime1;
//	FloatToSpiceMKSString(PCGeneratorData->CExponentialGeneratorData.rise_time1);
	FormatCLabel(E_GENERATOR_EXP_TAU1_VALUE);

	CLabelListData[E_GENERATOR_EXP_TAU2_DELAY_VALUE].CLabelValue = PCGeneratorData->CExponentialGeneratorData.CDelay2;
//	FloatToSpiceMKSString(PCGeneratorData->CExponentialGeneratorData.delay2);
	FormatCLabel(E_GENERATOR_EXP_TAU2_DELAY_VALUE);

	CLabelListData[E_GENERATOR_EXP_TAU2_VALUE].CLabelValue = PCGeneratorData->CExponentialGeneratorData.CRiseTime2;
//	FloatToSpiceMKSString(PCGeneratorData->CExponentialGeneratorData.rise_time2);
	FormatCLabel(E_GENERATOR_EXP_TAU2_VALUE);

	FormatCLabel(E_GENERATOR_EXP_IMD1);
	FormatCLabel(E_GENERATOR_EXP_IMD2);

	return true;
}

bool TCSchematicObjectData::FormatPWLGenerator(void)
{
	if(!FormatDCGenerator()) return false;

	CLabelListData.SetSize(E_GENERATOR_PWL_IMD2 + 1);

	CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CLabelListData[E_GENERATOR_PWL_IMD1].CLabelType = "I.M.D.1";
	CLabelListData[E_GENERATOR_PWL_IMD2].CLabelType = "I.M.D.2";

	FormatCLabel(E_GENERATOR_PWL_IMD1);
	FormatCLabel(E_GENERATOR_PWL_IMD2);

	return true;
}

bool TCSchematicObjectData::FormatSFFMGenerator(void)
{
	if(!FormatDCGenerator()) return false;

	CLabelListData.SetSize(E_GENERATOR_SFFM_OFFSET_VALUE + 1);

	CLabelListData[E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE].CLabelType = "VPk";
	CLabelListData[E_GENERATOR_SFFM_MODULATION_INDEX_VALUE].CLabelType = "m";
	CLabelListData[E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE].CLabelType = "Fc";
	CLabelListData[E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE].CLabelType = "Fm";
	CLabelListData[E_GENERATOR_SFFM_OFFSET_VALUE].CLabelType = "Offset";
	CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VSFFM";
	CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelType = "I.M.D.1";
	CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelType = "I.M.D.2";

	CLabelListData[E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE].CLabelValue = PCGeneratorData->CSFFMGeneratorData.CCarrierMagnitude;
//	FloatToSpiceMKSString(PCGeneratorData->CSFFMGeneratorData.carrier_magnitude);
	FormatCLabel(E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE);

	CLabelListData[E_GENERATOR_SFFM_MODULATION_INDEX_VALUE].CLabelValue = PCGeneratorData->CSFFMGeneratorData.CModulationIndex;
//	FloatToSpiceMKSString(PCGeneratorData->CSFFMGeneratorData.modulation_index);
	FormatCLabel(E_GENERATOR_SFFM_MODULATION_INDEX_VALUE);

	CLabelListData[E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE].CLabelValue = PCGeneratorData->CSFFMGeneratorData.CCarrierFrequency;
//	FloatToSpiceMKSString(PCGeneratorData->CSFFMGeneratorData.carrier_frequency);
	FormatCLabel(E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE);

	CLabelListData[E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE].CLabelValue = PCGeneratorData->CSFFMGeneratorData.CModulationFrequency;
//	FloatToSpiceMKSString(PCGeneratorData->CSFFMGeneratorData.modulation_frequency);
	FormatCLabel(E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE);

	CLabelListData[E_GENERATOR_SFFM_OFFSET_VALUE].CLabelValue = PCGeneratorData->CSFFMGeneratorData.COffset;
//	FloatToSpiceMKSString(PCGeneratorData->CSFFMGeneratorData.offset);
	FormatCLabel(E_GENERATOR_SFFM_OFFSET_VALUE);

	FormatCLabel(E_GENERATOR_SFFM_IMD1);
	FormatCLabel(E_GENERATOR_SFFM_IMD2);

	return true;
}

bool TCSchematicObjectData::FormatVCVC(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}
bool TCSchematicObjectData::FormatICVC(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}
bool TCSchematicObjectData::FormatVCVIC(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}
bool TCSchematicObjectData::FormatICIC(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}

bool TCSchematicObjectData::FormatMultiplier(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	return true;
}

bool TCSchematicObjectData::FormatVCA(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	FormatSpiceValue();

	return true;
}

bool TCSchematicObjectData::FormatOpAmp(void)
{
	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	FormatSpiceValue();

	return true;
}


bool TCSchematicObjectData::FormatISwitch(void)
{
	CLabelListData.SetSize(E_COMPONENT_VSWITCH_VH  + 1, E_COMPONENT_VSWITCH_VH + 1);

	FormatCLabel(E_COMPONENT_ISWITCH_IT);
	FormatCLabel(E_COMPONENT_ISWITCH_IH);
	FormatCLabel(E_COMPONENT_ISWITCH_RON);
	FormatCLabel(E_COMPONENT_ISWITCH_ROFF);

	return true;
}

bool TCSchematicObjectData::FormatVSwitch(void)
{
	CLabelListData.SetSize(E_COMPONENT_VSWITCH_VH  + 1, E_COMPONENT_VSWITCH_VH  + 1);

	FormatCLabel(E_COMPONENT_VSWITCH_RON);
	FormatCLabel(E_COMPONENT_VSWITCH_ROFF);
	FormatCLabel(E_COMPONENT_VSWITCH_VT);
	FormatCLabel(E_COMPONENT_VSWITCH_VH);

	return true;
}

bool TCSchematicObjectData::FormatTransformer(void)
{
	CLabelListData.SetSize(E_COMPONENT_TRANSFORMER_TEMPCO2  + 1, E_COMPONENT_TRANSFORMER_TEMPCO2 + 1);

	FormatCLabel(E_COMPONENT_TRANSFORMER_AL);
	FormatCLabel(E_COMPONENT_TRANSFORMER_N1);
	FormatCLabel(E_COMPONENT_TRANSFORMER_N2);
	FormatCLabel(E_COMPONENT_TRANSFORMER_L1);
	FormatCLabel(E_COMPONENT_TRANSFORMER_L2);
	FormatCLabel(E_COMPONENT_TRANSFORMER_LMUTUAL);
	FormatCLabel(E_COMPONENT_TRANSFORMER_COUPLING);
	FormatCLabel(E_COMPONENT_TRANSFORMER_TEMPCO1);
	FormatCLabel(E_COMPONENT_TRANSFORMER_TEMPCO2);

	return true;
}

bool TCSchematicObjectData::FormatTransmissionLine(void)
{
	CLabelListData.SetSize(E_COMPONENT_TRANSMISSION_LINE_G0  + 1, E_COMPONENT_TRANSMISSION_LINE_G0 + 1);

	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelType = "Z0";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_R0].CLabelType = "R";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_L0].CLabelType = "L";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_C0].CLabelType = "C";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_G0].CLabelType = "G";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelType = "Td";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].CLabelType = "LEN";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelType = "F";

	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_G0].CLabelValue = "0";

	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_Z0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_TD);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_F0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_LENGTH);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_R0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_L0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_C0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_G0);


	return true;
}

bool TCSchematicObjectData::FormatLosslessTransmissionLine()
{
	CLabelListData.SetSize(E_COMPONENT_TRANSMISSION_LINE_G0  + 1, E_COMPONENT_TRANSMISSION_LINE_G0 + 1);

	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelType = "Z0";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelType = "Td";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].CLabelType = "NL";
	CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelType = "F";

	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_Z0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_TD);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_F0);
	FormatCLabel(E_COMPONENT_TRANSMISSION_LINE_LENGTH);

	CSpiceParameters.use_model = false;

	return true;
}

bool TCSchematicObjectData::Rename(CString CNewName)
{
	CSymbolData.CName = CNewName;
	CString CText;

	if(attached_model_type == E_SPICE_SCHEMATIC)
	{
		CText = ExtractPathName(CSymbolData.CChildFileName);

		CSymbolData.CChildFileName = CText + CNewName + ".sss";
	
		CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CNewName;

		CLabelListData[E_COMPONENT_VALUE].CLabel = CNewName;

		CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CNewName;

	}
	else
		CSymbolData.CChildFileName = "";

	return true;
}


void TCSchematicObjectData::Rescale(float scale)
{
	width	= (unsigned short) (width * scale);
	height	= (unsigned short) (height *scale);

	MultyplyCPoint(&CLocationOffset, scale);
	MultyplyCPoint(&CGrabOffset, scale);

	CSymbolData.Rescale(scale);

	int count = CPinListData.GetSize();

	for(int p = 0; p < count; p++)
	{
		MultyplyCPoint(&CPinListData[p].CLocation, scale);
		MultyplyCPoint(&CPinListData[p].CLocationOffset, scale);
	}
}

bool TCSchematicObjectData::GetDeviceCurrentNodeNames(CArray <CString, CString> &CDeviceNodes)
{
	if(!GCSuperSpiceDataBase.GetDeviceCurrentNodeNames(this, CDeviceNodes)) return false;

	int count = CDeviceNodes.GetSize();

	for(int p = 0; p < count; p++)
	{
		CDeviceNodes[p] = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + '[' +CDeviceNodes[p] +']';
	}

	return true;
}

bool TCSchematicObjectData::IsWorstCaseGenerator(void)
{
	CString CRefDes, CSweptParamName, CSpiceValue;

	CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	CRefDes.MakeUpper();

	if(CRefDes == GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CVGeneratorName) return true;
	if(CRefDes == GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CIGeneratorName) return true;

	if(!PCGeneratorData)  return false;
	if(!PCMAnalysisSetup)  return false;
	if(!PCMAnalysisSetup->CParametricSetupData.CSweepData.enable) return false;
	if(PCMAnalysisSetup->CParametricSetupData.IsSwept(CRefDes)) return true;

	CSpiceValue = PCGeneratorData->GetAllSpiceValues();

	CSweptParamName = PCMAnalysisSetup->CParametricSetupData.GetSweptParamName();

	if(CSweptParamName == "") return false;

	if(CSpiceValue.Find(CSweptParamName) > -1) return true; // Look for param var string, not foolproof

	return false;
}

bool TCSchematicObjectData::IsWorstCaseQRC(void)
{
	CString CRefDes;

	CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	CRefDes.MakeUpper();

	if(CRefDes == GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CRQWCName) return true;
	if(CRefDes == GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CCQWCName) return true;

	return false;
}

bool TCSchematicObjectData::GetVirtualParameterModel(CArray <CString, CString&> &CTextArray, TCAnalysisSetup &CAnalysisSetup)
{
	CString CText, CTemp;

	if(!PCMAnalysisSetup) PCMAnalysisSetup = &CAnalysisSetup;

	// create a unique model/subcircuit name
	// Resistors use a virtual semiconductor resistor model to change value

	CString CData;// = MKSStringToSpiceMKSString(CLabelListData[E_COMPONENT_VALUE].CLabel);

	double data = GetComponentValue(E_COMPONENT_VALUE);
	char cruntype;
	double tol;
	int create_wc_subckt_model;
	int is_qr_wc = 0;
	bool is_swept, wc_value;
	CString COriginalData, COrginalIMD1, COrginalIMD2;
	CString CParameterName;
	CString CRunType, CGeneratorLine;
	TCGeneratorData CGeneratorData;

	TCSuperSpiceDoc	*PCTopLevelDoc = NULL;
	
	if(PCMAnalysisSetup->PCDoc) // Should always be the case
		if(PCMAnalysisSetup->PCDoc)
			PCTopLevelDoc = PCMAnalysisSetup->PCDoc->GetTopLevelDoc();

	create_wc_subckt_model = IsWorstCaseGenerator();

	create_wc_subckt_model &= m_rerun_enable;

	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	is_swept = CAnalysisSetup.CParametricSetupData.IsSwept(CRefDes);

	wc_value = CAnalysisSetup.CParametricSetupData.CSweepData.enable && !is_swept; // will ok {} sweeps in V/I sources

	CRefDes.MakeUpper();

	switch(component_property_view_type)
	{
		case E_PROPERTY_RESISTOR:  
		{
			if(CRefDes == CAnalysisSetup.CReRun.CRQWCName)	
					is_qr_wc = true;

			if(CAnalysisSetup.CReRun.enable == 1 || wc_value)
			{
				data = GetComponentValue(E_COMPONENT_VALUE);

				if(!is_qr_wc) CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_RLC];
				else CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_QRC];

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.resistor_tol;

				if(tol && !is_qr_wc)
				{
					if(cruntype == 'S') data *= (1 - tol/100);		// Nov 2012, changed sign
					else if(cruntype == 'W') data *= (1 + tol/100); // Nov 2012, changed sign
				}
				else if(tol && is_qr_wc)
				{
					if(cruntype == 'S') data = CAnalysisSetup.CReRun.qrc_min;		
					else if(cruntype == 'W') data = CAnalysisSetup.CReRun.qrc_max;
					else data = CAnalysisSetup.CReRun.qrc_nom;
				}
			}
			else if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
			{
				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CData = FloatToSpiceMKSString(data);

			CText = ".MODEL ";
				
			CTemp = CSpiceParameters.CDataBaseIdInfo.CRecordName;

			CTemp = CTemp.Left(CTemp.GetLength() - 3);

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " R(RSH=";

			CText += CData;

			CTemp = GetComponentLabelValueSpiceString(E_COMPONENT_RESISTOR_TEMPCO1);
			
			if(CTemp != "0")
				CText += " TC1=" + CTemp;

			CTemp = GetComponentLabelValueSpiceString(E_COMPONENT_RESISTOR_TEMPCO2);
			
			if(CTemp != "0")
				CText += " TC2=" + CTemp;

			CText += ")";

			CTextArray.SetSize(1);

			CTextArray[0] = CText;

			break;
		}
		case E_PROPERTY_CAPACITOR: 
		{
			if(CRefDes == CAnalysisSetup.CReRun.CCQWCName)	
					is_qr_wc = true;

			if(CAnalysisSetup.CReRun.enable == 1  || wc_value)
			{
				data = GetComponentValue(E_COMPONENT_VALUE);

				if(!is_qr_wc) CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_RLC];
				else CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_QRC];

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.capacitor_tol;

				if(tol && !is_qr_wc)
				{
					if(cruntype == 'S') data *= (1 - tol/100);		// Nov 2012, changed sign
					else if(cruntype == 'W') data *= (1 + tol/100); // Nov 2012, changed sign
				}
				else if(tol && is_qr_wc)
				{
					if(cruntype == 'S') data = CAnalysisSetup.CReRun.qrc_min;		
					else if(cruntype == 'W') data = CAnalysisSetup.CReRun.qrc_max;
					else data = CAnalysisSetup.CReRun.qrc_nom;
				}
			}
			else if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
			{
				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CData = FloatToSpiceMKSString(data);

			CText = ".MODEL ";

			CTemp = CSpiceParameters.CDataBaseIdInfo.CRecordName;

			CTemp = CTemp.Left(CTemp.GetLength() - 3);

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " C(CJ=";

			CText += CData + ")";

			CTextArray.SetSize(1);

			CTextArray[0] = CText;

			break;
		}
		case E_PROPERTY_INDUCTOR: 
		{
			if(CAnalysisSetup.CReRun.enable == 1  || wc_value)
			{
				data = GetComponentValue(E_COMPONENT_VALUE);

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_RLC];

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.inductor_tol;

				if(tol)
				{
					if(cruntype == 'S') data *= (1 - tol/100);		// Nov 2012, changed sign
					else if(cruntype == 'W') data *= (1 + tol/100); // Nov 2012, changed sign
				}
			}
			else if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
			{
				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CData = FloatToSpiceMKSString(data);

/*			Now have .model for inductor 
			CText = ".SUBCKT ";

			CTemp = CSpiceParameters.CDataBaseIdInfo.CRecordName;

			CTemp = CTemp.Left(CTemp.GetLength() - 3);

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			CText  = "L1 1 2 " + CData;

			CText  += ' ' + GetTCMString(E_COMPONENT_INDUCTOR_TEMPCO1, E_COMPONENT_INDUCTOR_TEMPCO2, -1);

			CTextArray[1] = CText;//was 1

			CTextArray[2] = ".ENDS";
*/
			CText = ".MODEL ";

			CTemp = CSpiceParameters.CDataBaseIdInfo.CRecordName;

			CTemp = CTemp.Left(CTemp.GetLength() - 3);

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " L(ind=";

			CText += CData + ")";

			CTextArray.SetSize(1);

			CTextArray[0] = CText;

			break;
		}
		case E_PROPERTY_DC_VOLTAGE_SOURCE: // These modes no longer work for param, fix up later
		case E_PROPERTY_DC_CURRENT_SOURCE:
		{
			if(!PCGeneratorData)break;

			if(!create_wc_subckt_model)
				if(!CAnalysisSetup.CParametricSetupData.CSweepData.enable)break;

			if(CAnalysisSetup.CReRun.enable == 1 && create_wc_subckt_model )// WC not param, allows WC generators
			{
				CParameterName = "DCVALUE";

				data = EvaluateComponentValue(PCGeneratorData->CDCGeneratorData.CDCVoltage);

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_GENERATOR];

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.generator_tol;//

				if(tol)
				{
					if(cruntype == 'S') data *= (1 + tol/100);		
					else if(cruntype == 'W') data *= (1 - tol/100); 
				}
			}
			else
			{
				CParameterName = CAnalysisSetup.CParametricSetupData.GetSweptParamName();

				CParameterName.MakeUpper();

				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}
				
			CText = ".SUBCKT ";

			CText += GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName;

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			if(component_property_view_type == E_PROPERTY_DC_VOLTAGE_SOURCE)CText  = "V1 1 2 ";
			else CText  = "I1 1 2 ";

			CGeneratorData = *PCGeneratorData;

			COrginalIMD1 = CLabelListData[E_GENERATOR_AC_IMD1].CLabelValue;
			COrginalIMD2 = CLabelListData[E_GENERATOR_AC_IMD2].CLabelValue;

			if(CParameterName == "DCVALUE")			PCGeneratorData->CDCGeneratorData.CDCVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "ACVALUE")	PCGeneratorData->CDCGeneratorData.CACVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "PHASE")		PCGeneratorData->CDCGeneratorData.CACPhase	 = FloatToSpiceMKSString(data);
			else if(CParameterName == "IMD1")		CLabelListData[E_GENERATOR_AC_IMD1].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;
			else if(CParameterName == "IMD2")		CLabelListData[E_GENERATOR_AC_IMD2].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;

			CText += GetDCSourceValue(true);

			*PCGeneratorData = CGeneratorData;

			PCGeneratorData->Format(PCTopLevelDoc);

			CLabelListData[E_GENERATOR_AC_IMD1].CLabelValue = COrginalIMD1;
			CLabelListData[E_GENERATOR_AC_IMD2].CLabelValue = COrginalIMD2;

			CTextArray[1] = CText;

			CTextArray[2] = ".ENDS";

		}	break;

		case E_PROPERTY_SINE_VOLTAGE_SOURCE:
		case E_PROPERTY_SINE_CURRENT_SOURCE:
		{
			if(!PCGeneratorData)break;

			if(!create_wc_subckt_model)
				if(!CAnalysisSetup.CParametricSetupData.CSweepData.enable)break;

			if(CAnalysisSetup.CReRun.enable == 1 && create_wc_subckt_model)// WC not param
			{
				CParameterName = "AMPLITUDE";

				data = EvaluateComponentValue(PCGeneratorData->CSineGeneratorData.CAmplitude);

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_GENERATOR];// 

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.generator_tol;//

				if(tol)
				{
					if(cruntype == 'S') data *= (1 + tol/100);		
					else if(cruntype == 'W') data *= (1 - tol/100); 
				}
			}
			else
			{
				CParameterName = CAnalysisSetup.CParametricSetupData.GetSweptParamName();

				CParameterName.MakeUpper();

				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CGeneratorData = *PCGeneratorData;

			COrginalIMD1 = CLabelListData[E_GENERATOR_SINE_IMD1].CLabelValue;
			COrginalIMD2 = CLabelListData[E_GENERATOR_SINE_IMD2].CLabelValue;

			if(CParameterName == "DCVALUE")			PCGeneratorData->CDCGeneratorData.CDCVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "ACVALUE")	PCGeneratorData->CDCGeneratorData.CACVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "PHASE")		PCGeneratorData->CDCGeneratorData.CACPhase	 = FloatToSpiceMKSString(data);
			else if(CParameterName == "AMPLITUDE")  PCGeneratorData->CSineGeneratorData.CAmplitude = FloatToSpiceMKSString(data);
			else if(CParameterName == "FREQUENCY")  PCGeneratorData->CSineGeneratorData.CFrequency = FloatToSpiceMKSString(data);
			else if(CParameterName == "OFFSET")		PCGeneratorData->CSineGeneratorData.COffset = FloatToSpiceMKSString(data);
			else if(CParameterName == "DELAY")		PCGeneratorData->CSineGeneratorData.CDelay = FloatToSpiceMKSString(data);
			else if(CParameterName == "DAMPING")	PCGeneratorData->CSineGeneratorData.CDamping = FloatToSpiceMKSString(data);
			else if(CParameterName == "IMD1")		CLabelListData[E_GENERATOR_SINE_IMD1].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;
			else if(CParameterName == "IMD2")		CLabelListData[E_GENERATOR_SINE_IMD2].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;

			CText = ".SUBCKT ";

			CText += GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName;

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			if(component_property_view_type == E_PROPERTY_SINE_VOLTAGE_SOURCE)CText  = "V1 1 2 ";
			else CText  = "I1 1 2 ";

			CText += GetSineSourceValue(true);

			*PCGeneratorData = CGeneratorData;

			PCGeneratorData->Format(PCTopLevelDoc);

			CLabelListData[E_GENERATOR_SINE_IMD1].CLabelValue = COrginalIMD1;
			CLabelListData[E_GENERATOR_SINE_IMD2].CLabelValue = COrginalIMD2;
	
			CTextArray[1] = CText;

			CTextArray[2] = ".ENDS";

		}	break;

		case E_PROPERTY_PULSE_VOLTAGE_SOURCE:
		case E_PROPERTY_PULSE_CURRENT_SOURCE:
		{
			if(!PCGeneratorData)break;

			if(!create_wc_subckt_model)
				if(!CAnalysisSetup.CParametricSetupData.CSweepData.enable)break;

			if(CAnalysisSetup.CReRun.enable == 1 && create_wc_subckt_model)// WC not param
			{
				CParameterName = "STOP_AMPLITUDE";

				data = EvaluateComponentValue(PCGeneratorData->CPulseGeneratorData.CEnd); // hard coded, Pulse end value

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_GENERATOR];

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.generator_tol;//

				if(tol)
				{
					if(cruntype == 'S') data *= (1 + tol/100);		
					else if(cruntype == 'W') data *= (1 - tol/100); 
				}
			}
			else
			{
				CParameterName = CAnalysisSetup.CParametricSetupData.GetSweptParamName();

				CParameterName.MakeUpper();

				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CGeneratorData = *PCGeneratorData;

			COrginalIMD1 = CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelValue;
			COrginalIMD2 = CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelValue;

			if(CParameterName == "DCVALUE")				PCGeneratorData->CDCGeneratorData.CDCVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "ACVALUE")		PCGeneratorData->CDCGeneratorData.CACVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "PHASE")			PCGeneratorData->CDCGeneratorData.CACPhase	 = FloatToSpiceMKSString(data);
			else if(CParameterName == "START_AMPLITUDE")PCGeneratorData->CPulseGeneratorData.CStart = FloatToSpiceMKSString(data);
			else if(CParameterName == "STOP_AMPLITUDE") PCGeneratorData->CPulseGeneratorData.CEnd = FloatToSpiceMKSString(data);
			else if(CParameterName == "DELAY")			PCGeneratorData->CPulseGeneratorData.CDelay = FloatToSpiceMKSString(data);
			else if(CParameterName == "TR")				PCGeneratorData->CPulseGeneratorData.CRise = FloatToSpiceMKSString(data);
			else if(CParameterName == "TF")				PCGeneratorData->CPulseGeneratorData.CFall = FloatToSpiceMKSString(data);
			else if(CParameterName == "WIDTH")			PCGeneratorData->CPulseGeneratorData.CWidth = FloatToSpiceMKSString(data);
			else if(CParameterName == "PERIOD")			PCGeneratorData->CPulseGeneratorData.CPeriod = FloatToSpiceMKSString(data);
			else if(CParameterName == "IMD1")			CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;
			else if(CParameterName == "IMD2")			CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;

			CText = ".SUBCKT ";

			CText += GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName;

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			if(component_property_view_type == E_PROPERTY_PULSE_VOLTAGE_SOURCE) CText  = "V1 1 2 ";
			else CText  = "I1 1 2 ";

			CText += GetPulseSourceValue(true);

			*PCGeneratorData = CGeneratorData;

			PCGeneratorData->Format(PCTopLevelDoc);

			CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelValue = COrginalIMD1;
			CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelValue = COrginalIMD2;

			CTextArray[1] = CText;

			CTextArray[2] = ".ENDS";

		}	break;

		case E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE:// only does the dc values, not the the pwl itself
		case E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE:
		{
			if(!PCGeneratorData)break;

			if(!create_wc_subckt_model)
				if(!CAnalysisSetup.CParametricSetupData.CSweepData.enable)break;

			if(CAnalysisSetup.CReRun.enable == 1 && create_wc_subckt_model )// WC not param, allows WC generators
			{
				CParameterName = "DCVALUE";

				data = EvaluateComponentValue(PCGeneratorData->CDCGeneratorData.CDCVoltage);

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_GENERATOR];

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.generator_tol;//

				if(tol)
				{
					if(cruntype == 'S') data *= (1 + tol/100);		
					else if(cruntype == 'W') data *= (1 - tol/100); 
				}
			}
			else
			{
				CParameterName = CAnalysisSetup.CParametricSetupData.GetSweptParamName();

				CParameterName.MakeUpper();

				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CGeneratorData = *PCGeneratorData;

			COrginalIMD1 = CLabelListData[E_GENERATOR_PWL_IMD1].CLabelValue;
			COrginalIMD2 = CLabelListData[E_GENERATOR_PWL_IMD2].CLabelValue;

			if(CParameterName == "DCVALUE")			PCGeneratorData->CDCGeneratorData.CDCVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "ACVALUE")	PCGeneratorData->CDCGeneratorData.CACVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "PHASE")		PCGeneratorData->CDCGeneratorData.CACPhase	 = FloatToSpiceMKSString(data);
			else if(CParameterName == "IMD1")		CLabelListData[E_GENERATOR_PWL_IMD1].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;
			else if(CParameterName == "IMD2")		CLabelListData[E_GENERATOR_PWL_IMD2].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;

			CText = ".SUBCKT ";

			CText += GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName;

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			if(component_property_view_type == E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE) CText  = "V1 1 2 ";
			else CText  = "I1 1 2 ";

			CText += GetPWLSourceValue(true);

			*PCGeneratorData = CGeneratorData;

			PCGeneratorData->Format(PCTopLevelDoc);

			CLabelListData[E_GENERATOR_PWL_IMD1].CLabelValue = COrginalIMD1;
			CLabelListData[E_GENERATOR_PWL_IMD2].CLabelValue = COrginalIMD2;

			CTextArray[1] = CText;

			CTextArray[2] = ".ENDS";

		}	break;

		case E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE:
		case E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE:
		{
			if(!PCGeneratorData)break;

			if(!create_wc_subckt_model)
				if(!CAnalysisSetup.CParametricSetupData.CSweepData.enable)break;

			if(CAnalysisSetup.CReRun.enable == 1 && create_wc_subckt_model )// WC not param, allows WC generators
			{
				CParameterName = "DCVALUE";

				data = EvaluateComponentValue(PCGeneratorData->CDCGeneratorData.CDCVoltage);

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_GENERATOR];// moved from L

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.generator_tol;//

				if(tol)
				{
					if(cruntype == 'S') data *= (1 + tol/100);		
					else if(cruntype == 'W') data *= (1 - tol/100); 
				}
			}
			else
			{
				CParameterName = CAnalysisSetup.CParametricSetupData.GetSweptParamName();

				CParameterName.MakeUpper();

				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}
			
			CGeneratorData = *PCGeneratorData;

			COrginalIMD1 = CLabelListData[E_GENERATOR_EXP_IMD1].CLabelValue;
			COrginalIMD2 = CLabelListData[E_GENERATOR_EXP_IMD2].CLabelValue;

			if(CParameterName == "DCVALUE")			PCGeneratorData->CDCGeneratorData.CDCVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "ACVALUE")	PCGeneratorData->CDCGeneratorData.CACVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "PHASE")		PCGeneratorData->CDCGeneratorData.CACPhase	 = FloatToSpiceMKSString(data);

			else if(CParameterName == "START_AMPLITUDE")PCGeneratorData->CExponentialGeneratorData.CStart = FloatToSpiceMKSString(data);
			else if(CParameterName == "STOP_AMPLITUDE")	PCGeneratorData->CExponentialGeneratorData.CEnd = FloatToSpiceMKSString(data);
			else if(CParameterName == "TAU1_DELAY")		PCGeneratorData->CExponentialGeneratorData.CDelay1 = FloatToSpiceMKSString(data);
			else if(CParameterName == "TAU1")			PCGeneratorData->CExponentialGeneratorData.CRiseTime1 = FloatToSpiceMKSString(data);
			else if(CParameterName == "TAU2_DELAY")		PCGeneratorData->CExponentialGeneratorData.CDelay2 = FloatToSpiceMKSString(data);
			else if(CParameterName == "TAU2")			PCGeneratorData->CExponentialGeneratorData.CRiseTime2 = FloatToSpiceMKSString(data);
			else if(CParameterName == "IMD1")		CLabelListData[E_GENERATOR_EXP_IMD1].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;
			else if(CParameterName == "IMD2")		CLabelListData[E_GENERATOR_EXP_IMD2].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;

			CText = ".SUBCKT ";

			CText += GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName;

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			if(component_property_view_type == E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE) CText  = "V1 1 2 ";
			else CText  = "I1 1 2 ";

			CText += GetExpSourceValue(true);

			*PCGeneratorData = CGeneratorData;

			PCGeneratorData->Format(PCTopLevelDoc);

			CLabelListData[E_GENERATOR_EXP_IMD1].CLabelValue = COrginalIMD1;
			CLabelListData[E_GENERATOR_EXP_IMD2].CLabelValue = COrginalIMD2;

			CTextArray[1] = CText;

			CTextArray[2] = ".ENDS";

		}	break;

		case E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM:
		case E_PROPERTY_SINGLE_FREQ_CURRENT_FM:
		{
			if(!PCGeneratorData)break;

			if(!create_wc_subckt_model)
				if(!CAnalysisSetup.CParametricSetupData.CSweepData.enable)break;

			if(CAnalysisSetup.CReRun.enable == 1 && create_wc_subckt_model )// WC not param, allows WC generators
			{
				CParameterName = "DCVALUE";

				data = EvaluateComponentValue(PCGeneratorData->CDCGeneratorData.CDCVoltage);

				CRunType = CAnalysisSetup.CReRun.CRunType[E_WC_GENERATOR];// moved from L

				if(CRunType.GetLength() < 1) cruntype = 'N';
				else cruntype = CRunType.GetAt(2);

				tol = CAnalysisSetup.CReRun.generator_tol;//

				if(tol)
				{
					if(cruntype == 'S') data *= (1 + tol/100);		
					else if(cruntype == 'W') data *= (1 - tol/100); 
				}
			}
			else
			{
				CParameterName = CAnalysisSetup.CParametricSetupData.GetSweptParamName();

				CParameterName.MakeUpper();

				data = MKSStringToFloat(CAnalysisSetup.CParametricSetupData.CValue);
			}

			CGeneratorData = *PCGeneratorData;

			COrginalIMD1 = CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelValue;
			COrginalIMD2 = CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelValue;

			if(CParameterName == "DCVALUE")			PCGeneratorData->CDCGeneratorData.CDCVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "ACVALUE")	PCGeneratorData->CDCGeneratorData.CACVoltage = FloatToSpiceMKSString(data);
			else if(CParameterName == "PHASE")		PCGeneratorData->CDCGeneratorData.CACPhase	 = FloatToSpiceMKSString(data);

			else if(CParameterName == "CARRIER_AMPLITUDE")		PCGeneratorData->CSFFMGeneratorData.CCarrierMagnitude = FloatToSpiceMKSString(data);
			else if(CParameterName == "MODULATION_INDEX")		PCGeneratorData->CSFFMGeneratorData.CModulationIndex = FloatToSpiceMKSString(data);
			else if(CParameterName == "CARRIER_FREQUENCY")		PCGeneratorData->CSFFMGeneratorData.CCarrierFrequency = FloatToSpiceMKSString(data);
			else if(CParameterName == "MODULATION_FREQUENCY")	PCGeneratorData->CSFFMGeneratorData.CModulationFrequency = FloatToSpiceMKSString(data);
			else if(CParameterName == "OFFSET")					PCGeneratorData->CSFFMGeneratorData.COffset = FloatToSpiceMKSString(data);
			else if(CParameterName == "IMD1")		CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;
			else if(CParameterName == "IMD2")		CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelValue = CAnalysisSetup.CParametricSetupData.CValue;

			CText = ".SUBCKT ";

			CText += GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName;

			CText += CTemp + CLabelListData[E_COMPONENT_DESIGNATOR].CLabel + "_XN";

			CText += " 1 2 ";

			CTextArray.SetSize(3);

			CTextArray[0] = CText;

			if(component_property_view_type == E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM) CText  = "V1 1 2 ";
			else CText  = "I1 1 2 ";

			CText += GetSFFMSourceValue(true);

			*PCGeneratorData = CGeneratorData;

			PCGeneratorData->Format(PCTopLevelDoc);

			CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelValue = COrginalIMD1;
			CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelValue = COrginalIMD2;

			CTextArray[1] = CText;

			CTextArray[2] = ".ENDS";

		}	break;

		default: return false;
	}

	return true;
}

CString TCSchematicObjectData::GetDCSourceValue(bool normal)
{
	if(!PCMAnalysisSetup)
	{
		ASSERT(0);

		return "";

	}
	CString CText;
	int loop_gain = 0;
	
	TCParametricSetupData &CParametricSetupData = PCMAnalysisSetup->CParametricSetupData;

	CString &CParamRefDes  = CParametricSetupData.CSource;
	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	int create_wc_subckt_model;
	
	create_wc_subckt_model = IsWorstCaseGenerator();

	if(m_rerun_enable && create_wc_subckt_model && !normal) return GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName + CRefDes + "_XN"; 

	if(CRefDes != CParamRefDes || normal || !m_rerun_enable || !PCMAnalysisSetup->CReRun.xspice_run_mode)
	{
		CText = CLabelListData[E_COMPONENT_VALUE].CLabel; // default;

		if(PCMAnalysisSetup) // Should always be the case
			if(PCMAnalysisSetup->PCDoc)
			{
				if(PCMAnalysisSetup->CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] != CRefDes)
					if(PCMAnalysisSetup->CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
						loop_gain = 1; // Set AC=0 for all sources other than the loop gain source.

				CText = PCGeneratorData->Format(PCMAnalysisSetup->PCDoc->GetTopLevelDoc(), loop_gain);
			}

		CText += " DISTOF1 " + GetComponentLabelValueSpiceString(E_GENERATOR_AC_IMD1);
			

		CText += " DISTOF2 " + GetComponentLabelValueSpiceString(E_GENERATOR_AC_IMD2);
	}
	else
	{
//		CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;
		CText = "Generator_XN";
	}

	return CText;
}

CString TCSchematicObjectData::GetSineSourceValue(bool normal)
{
	CString CText;
	int loop_gain = 0;
	
	TCParametricSetupData &CParametricSetupData = PCMAnalysisSetup->CParametricSetupData;

	CString &CParamRefDes  = CParametricSetupData.CSource;
	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	int create_wc_subckt_model;

	create_wc_subckt_model = IsWorstCaseGenerator();

	if(m_rerun_enable && create_wc_subckt_model && !normal) return GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName + CRefDes + "_XN"; 

	if(CRefDes != CParamRefDes || normal || !m_rerun_enable || !PCMAnalysisSetup->CReRun.xspice_run_mode)
	{
		CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

		if(PCMAnalysisSetup) // Should always be the case
			if(PCMAnalysisSetup->PCDoc)
			{
				if(PCMAnalysisSetup->CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] != CRefDes)
					if(PCMAnalysisSetup->CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
						loop_gain = 1; // Set AC=0 for all sources other than the loop gain source.

				CText = PCGeneratorData->Format(PCMAnalysisSetup->PCDoc->GetTopLevelDoc(), loop_gain);
			}

		CText += " DISTOF1 " + GetComponentLabelValueSpiceString(E_GENERATOR_SINE_IMD1);
			
		CText += " DISTOF2 " + GetComponentLabelValueSpiceString(E_GENERATOR_SINE_IMD2);
	}
	else
	{
//		CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CText = "Generator_XN";
	}

	return CText;
}

CString TCSchematicObjectData::GetPulseSourceValue(bool normal)
{
	CString CText;
	int loop_gain = 0;
	
	TCParametricSetupData &CParametricSetupData = PCMAnalysisSetup->CParametricSetupData;

	CString &CParamRefDes  = CParametricSetupData.CSource;
	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	int create_wc_subckt_model;

	create_wc_subckt_model = IsWorstCaseGenerator();

	if(m_rerun_enable && create_wc_subckt_model && !normal) return GCSuperSpiceGlobalData.CAnalysisSetup.CReRun.CXGeneratorName + CRefDes + "_XN"; 

	if(CRefDes != CParamRefDes || normal || !m_rerun_enable || !PCMAnalysisSetup->CReRun.xspice_run_mode)
	{
		CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

		if(PCMAnalysisSetup) // Should always be the case
			if(PCMAnalysisSetup->PCDoc)
			{
				if(PCMAnalysisSetup->CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] != CRefDes)
					if(PCMAnalysisSetup->CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
						loop_gain = 1; // Set AC=0 for all sources other than the loop gain source.

				CText = PCGeneratorData->Format(PCMAnalysisSetup->PCDoc->GetTopLevelDoc(), loop_gain);
			}

		CText += " DISTOF1 " + GetComponentLabelValueSpiceString(E_GENERATOR_PULSE_IMD1);
			
		CText += " DISTOF2 " + GetComponentLabelValueSpiceString(E_GENERATOR_PULSE_IMD2);
	}
	else
	{
//		CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CText = "Generator_XN";
	}

	return CText;
}

CString TCSchematicObjectData::GetExpSourceValue(bool normal)
{
	CString CText;
	int loop_gain = 0;
	
	TCParametricSetupData &CParametricSetupData = PCMAnalysisSetup->CParametricSetupData;

	CString &CParamRefDes  = CParametricSetupData.CSource;
	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(CRefDes != CParamRefDes || normal || !m_rerun_enable || !PCMAnalysisSetup->CReRun.xspice_run_mode)
	{
		CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

		if(PCMAnalysisSetup) // Should always be the case
			if(PCMAnalysisSetup->PCDoc)
			{
				if(PCMAnalysisSetup->CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] != CRefDes)
					if(PCMAnalysisSetup->CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
						loop_gain = 1; // Set AC=0 for all sources other than the loop gain source.

				CText = PCGeneratorData->Format(PCMAnalysisSetup->PCDoc->GetTopLevelDoc(), loop_gain);
			}

		CText += " DISTOF1 " + GetComponentLabelValueSpiceString(E_GENERATOR_EXP_IMD1);
			
		CText += " DISTOF2 " + GetComponentLabelValueSpiceString(E_GENERATOR_EXP_IMD2);
	}
	else
	{
//		CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CText = "Generator_XN";
	}

	return CText;
}

CString TCSchematicObjectData::GetPWLSourceValue(bool normal)
{
	CString CText;
	
	TCParametricSetupData &CParametricSetupData = PCMAnalysisSetup->CParametricSetupData;

	CString &CParamRefDes  = CParametricSetupData.CSource;
	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(CRefDes != CParamRefDes || normal || !m_rerun_enable || !PCMAnalysisSetup->CReRun.xspice_run_mode)
	{
		CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

		CText += " DISTOF1 " + GetComponentLabelValueSpiceString(E_GENERATOR_PWL_IMD1);
			
		CText += " DISTOF2 " + GetComponentLabelValueSpiceString(E_GENERATOR_PWL_IMD2);
	}
	else
	{
//		CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CText = "Generator_XN";
	}

	return CText;
}

CString TCSchematicObjectData::GetSFFMSourceValue(bool normal)
{
	CString CText;
	
	TCParametricSetupData &CParametricSetupData = PCMAnalysisSetup->CParametricSetupData;

	CString &CParamRefDes  = CParametricSetupData.CSource;
	CString CRefDes = CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	if(CRefDes != CParamRefDes || normal || !m_rerun_enable || !PCMAnalysisSetup->CReRun.xspice_run_mode)
	{
		CText = CLabelListData[E_COMPONENT_VALUE].CLabel;

		if(PCMAnalysisSetup) // Should always be the case
			if(PCMAnalysisSetup->PCDoc)
				CText = PCGeneratorData->Format(PCMAnalysisSetup->PCDoc->GetTopLevelDoc());

		CText += " DISTOF1 " + GetComponentLabelValueSpiceString(E_GENERATOR_SFFM_IMD1);
			
		CText += " DISTOF2 " + GetComponentLabelValueSpiceString(E_GENERATOR_SFFM_IMD2);
	}
	else
	{
//		CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CText = "Generator_XN";
	}

	return CText;
}

///////////////////////////////////////////////////////
////////////////////////////////////////////////////////

bool TCSchematicObject::GetVirtualParameterModel(CArray <CString, CString&> &CTextArray, TCAnalysisSetup &CAnalysisSetup)
{
	return CMSchematicObjectData.GetVirtualParameterModel(CTextArray, CAnalysisSetup);
}

bool TCSchematicObject::SetSchematicObjectData(CDC *PCViewDC, TCSchematicObjectData &CSchematicObjectData)
{
	if(m_property == E_SCHEMATIC_WIRE)
	{
		CMSchematicObjectData = CSchematicObjectData;

		m_user_label_preferred	= CSchematicObjectData.user_label_preferred;

		CreateLabels(PCViewDC);

		return true;
	}

	if(m_type == E_WAVEFORM_COMPONENT) 
	if(PCWaveformDataRuns && CSchematicObjectData.PCOutputWaveformDataHeader) 
	{
		int run_count = PCWaveformDataRuns->CRuns.GetSize();
		if(!run_count) return false;

		if(run_count == 1) 	CSchematicObjectData.PCOutputWaveformDataHeader->CreateListOfDisplayedSignals();
		else PCWaveformDataRuns->CreateListsOfDisplayedSignals(CSchematicObjectData.PCOutputWaveformDataHeader);
	
	}

	return Create(PCViewDC, CSchematicObjectData, m_zoom);
}

void TCSchematicObject::FormatLabels(void)
{
	CDC CViewDC;

	if(!CViewDC.CreateCompatibleDC(NULL)) return;

	CMSchematicObjectData.FormatLabels();

	if(CMSchematicObjectData.PCGeneratorData) 
	{
		CreateLabels(&CViewDC);

		return;
	}

	CMSchematicObjectData.FormatSpiceName();

	if(CMSchematicObjectData.format_spice_value) CMSchematicObjectData.FormatSpiceValue();
}

bool TCSchematicObject::Create(CDC *PCViewDC, TCSchematicObjectData &CSchematicObjectData, float zoom)
{	
/*
	This function creates all graphic types except wires - main graphic
	pins and labels;
*/

	CMSchematicObjectData = CSchematicObjectData;

	m_type					= CSchematicObjectData.type;
	m_zoom					= zoom;
	CMLocationOffset		= CSchematicObjectData.CLocationOffset;
	CMGrabOffset			= CSchematicObjectData.CGrabOffset;
	m_mirror_state			= CSchematicObjectData.mirror_state;
	m_rotation_state		= CSchematicObjectData.rotation_state;
	m_user_label_preferred	= CSchematicObjectData.user_label_preferred;

	int size = GCSuperSpiceDataBase.CMDefaults.GetSize();

	if(m_type >= size) return false;

	if(m_type == E_WAVEFORM_COMPONENT)
	{
		// to do
		m_property = E_WAVEFORM_OBJECT;

		if(!CreateWaveform(zoom))return false;

		return true;
	}

	if(!CMSchematicObjectData.f_vector_graphic) //Fre lables
	{// bitmap to do, maybe

		if(m_type != E_LABEL_COMPONENT) return false;
//		ASSERT(0);

	//	return false;

		m_property = E_SCHEMATIC_TEXT_LABEL;
		m_version = CSchematicObjectData.version;
		CMLabel = CMSchematicObjectData.CLabel;
	
		TCGraphicBitMapVectorObject::Create(PCViewDC, CMLabel, m_zoom,
									     GCSuperSpiceGlobalData.CColorData.user_text_normal,
										GCSuperSpiceGlobalData.CColorData.user_text_selected, 
										GCSuperSpiceGlobalData.CColorData.user_text_highlighted);

		

	}
	else
	{	
		m_property = E_SCHEMATIC_OBJECT;
		
		RotateSymbolData(true); // Get the database data and setup 

		int object_width = CMSchematicObjectData.width; 
		int object_height = CMSchematicObjectData.height;

		if(m_rotation_state == E_SECOND_QUADRANT ||
			m_rotation_state == E_FORTH_QUADRANT)
		{
			object_width = CMSchematicObjectData.height; 
			object_height = CMSchematicObjectData.width;
		}
		ZoomRaw();

		TCGraphicBitMapVectorObject::Create(CMDrawLineData,
			(unsigned short)(object_width * zoom), 
			(unsigned short)(object_height * zoom),
			GCSuperSpiceGlobalData.CColorData.component_normal,
			GCSuperSpiceGlobalData.CColorData.component_selected, 
			GCSuperSpiceGlobalData.CColorData.component_highlighted);
	}
	if(!CreateLabels(PCViewDC)) return false;
	if(!CreatePins(PCViewDC )) return false;

	return true;
}

void TCSchematicObject::SetAbsoluteLocation(CPoint &CAbsLocation)
{
	TCGraphicBitMapVectorObject::SetAbsoluteLocation(CAbsLocation);
	// and labels to do
}
void TCSchematicObject::UpdateSchematicObject(void)
{
	m_snap_to_distance = GetSnapToDistance();

	if(m_property == E_SCHEMATIC_OBJECT)
	{
		m_line_color				= GCSuperSpiceGlobalData.CColorData.component_normal;
		m_line_selected_color		= GCSuperSpiceGlobalData.CColorData.component_selected;
		m_line_highlighted_color	= GCSuperSpiceGlobalData.CColorData.component_highlighted;
	}
	else if(m_property == E_SCHEMATIC_WIRE)
	{
		m_line_color				= GCSuperSpiceGlobalData.CColorData.wire_normal;
		m_line_selected_color		= GCSuperSpiceGlobalData.CColorData.wire_selected;
		m_line_highlighted_color	= GCSuperSpiceGlobalData.CColorData.wire_highlighted;
		
	}

	if(m_selected)
		m_active_line_color  = m_line_selected_color;
	else
		m_active_line_color  = m_line_color;

	if(m_highlighted) m_active_line_color = m_line_highlighted_color;

	CArray <bool, bool> CSelected;
	CArray <bool, bool> CHighlighted;

	CArray <TCPinObjectState, TCPinObjectState &> CPinState;

	int count1 = CMLabelListObject.GetSize();
	
	int count2 = CMPinListObject.GetSize();
	int count3;
	
	CPinState.SetSize(count2);

	CSelected.SetSize(count1);
	CHighlighted.SetSize(count1);

	int p;

	for(p = 0; p < count1; p++)
	{
		CSelected[p]	= CMLabelListObject[p].m_selected;
		CHighlighted[p]	= CMLabelListObject[p].m_highlighted;
	}

	for(p = 0; p < count2; p++)
	{
		count3 = CMPinListObject[p].CMLabelListObject.GetSize();

		CPinState[p].CSelected.SetSize(count3);
		CPinState[p].CHighlighted.SetSize(count3);

		for(int q = 0; q < count3; q++)
		{
			CPinState[p].CSelected[q]	= CMPinListObject[p].CMLabelListObject[q].m_selected;
			CPinState[p].CHighlighted[q]= CMPinListObject[p].CMLabelListObject[q].m_highlighted;
		}
	}

	Zoom(m_zoom);// This will recreate evering with current global settings

	for(p = 0; p < count1; p++)
	{
		if(CSelected[p]) CMLabelListObject[p].SetSelect();
		else if(CHighlighted[p]) CMLabelListObject[p].SetHighlight();
	}

	for(p = 0; p < count2; p++)
	{
		count3 = CMPinListObject[p].CMLabelListObject.GetSize();

		for(int q = 0; q < count3; q++)
		{
			if(CPinState[p].CSelected[q]) CMPinListObject[p].CMLabelListObject[q].SetSelect();
			else if(CPinState[p].CHighlighted[q]) CMPinListObject[p].CMLabelListObject[q].SetHighlight();
		}
	}

	// needed due to double sbuffering on screen

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	Paste(&CDCTemp, CMLocation);
}
void TCSchematicObject::Zoom(float zoom)
{
	m_zoom = zoom;
	
	CMLocation.x = (int) (CMAbsoluteLocation.x * zoom);
	CMLocation.y = (int) (CMAbsoluteLocation.y * zoom);

	if(m_property == E_WAVEFORM_OBJECT)
	{
		CreateWaveform(zoom);

		return;
	}

	if(m_mode == E_VECTOR_OBJECT)
	{
		if(m_property == E_SCHEMATIC_OBJECT)
		{
			int object_width = CMSchematicObjectData.width; 
			int object_height = CMSchematicObjectData.height;

			RotateSymbolData(true);// need to keep current rotate state
			if(m_rotation_state == E_SECOND_QUADRANT ||
				m_rotation_state == E_FORTH_QUADRANT)
			{
				object_width = CMSchematicObjectData.height; 
				object_height = CMSchematicObjectData.width;
			}					

			ZoomRaw();
			
			TCGraphicBitMapVectorObject::Create(CMDrawLineData,
			(unsigned short)(object_width * zoom), 
			(unsigned short)(object_height * zoom),
			GCSuperSpiceGlobalData.CColorData.component_normal,
			GCSuperSpiceGlobalData.CColorData.component_selected, 
			GCSuperSpiceGlobalData.CColorData.component_highlighted);
		}
		else if(m_property == E_SCHEMATIC_WIRE)
		{
			CMLineStart.x	= (int) (CMAbsoluteLocation.x  * zoom);
			CMLineStart.y	= (int) (CMAbsoluteLocation.y * zoom);
			CMLineEnd.x		= (int) (CMAbsoluteEndLocation.x * zoom);
			CMLineEnd.y		= (int) (CMAbsoluteEndLocation.y * zoom);
			

			TCGraphicBitMapVectorObject::Create(CMLineStart, CMLineEnd, m_line_width, 
				    GCSuperSpiceGlobalData.CColorData.wire_normal, GCSuperSpiceGlobalData.CColorData.wire_selected,
					GCSuperSpiceGlobalData.CColorData.wire_highlighted, 
					GetSnapToDistance());

		}

		CDC CViewDC;

		if(!CViewDC.CreateCompatibleDC(NULL)) return;

		CreateLabels(&CViewDC); // Will delete existing label
		CreatePins(&CViewDC);

	}

	else if (m_property == E_SCHEMATIC_TEXT_LABEL) // user text
	{
		UpdateLabel();
	}
}

void TCSchematicObject::Mirror(void)
{
	if(m_type == E_WIRE_COMPONENT) return;

	if(m_mode == E_VECTOR_OBJECT)
	{
		if(m_property == E_SCHEMATIC_OBJECT)
		{
			MirrorSymbolData(false); // No need to get original data base data

			TCGraphicBitMapVectorObject::Create(CMDrawLineData,
			(unsigned short)(m_object_width), 
			(unsigned short)(m_object_height),
			GCSuperSpiceGlobalData.CColorData.component_normal,
			GCSuperSpiceGlobalData.CColorData.component_selected, 
			GCSuperSpiceGlobalData.CColorData.component_highlighted);
		}
		CDC CViewDC;

		if(!CViewDC.CreateCompatibleDC(NULL)) return;

		CreatePins(&CViewDC);// mirror and keeps zoom
								// six and half a dozan whether to make a rotate
								// functionfor pins
	}
}

void TCSchematicObject::Rotate(void)
{
	if(m_type == E_WIRE_COMPONENT) return;

	if(m_mode == E_VECTOR_OBJECT)
	{
		if(m_property == E_SCHEMATIC_OBJECT)
		{
			RotateSymbolData(false);

			int object_width = CMSchematicObjectData.width; 
			int object_height = CMSchematicObjectData.height;

			if(m_rotation_state == E_SECOND_QUADRANT ||
				m_rotation_state == E_FORTH_QUADRANT)
			{
				object_width = CMSchematicObjectData.height; 
				object_height = CMSchematicObjectData.width;
			}
			ZoomRaw();

			TCGraphicBitMapVectorObject::Create(CMDrawLineData,
			(unsigned short)(object_width * m_zoom), 
			(unsigned short)(object_height * m_zoom),
			GCSuperSpiceGlobalData.CColorData.component_normal,
			GCSuperSpiceGlobalData.CColorData.component_selected, 
			GCSuperSpiceGlobalData.CColorData.component_highlighted);
		}
		CDC CViewDC;

		if(!CViewDC.CreateCompatibleDC(NULL)) return;

		CreatePins(&CViewDC);// rotates and keeps zoom
	}
}
void TCSchematicObject::Flip(void)
{
	if(m_type == E_WIRE_COMPONENT) return;

	Rotate();
	Rotate();
	Mirror();
}

void TCSchematicObject::RotateSymbolData(bool current_not_next)
{
	double angle = 0.0;
	double sin_angle;
	double cos_angle;
 
	CArray <TCLineData, TCLineData &> &CSymbolData = CMSchematicObjectData.CSymbolData.CData;
	CArray<TCSchematicPinData, TCSchematicPinData &> &CPinData = GCSuperSpiceDataBase.GetPinListData(CMSchematicObjectData);

	if(current_not_next) angle = (double)(90 * (m_rotation_state - 1));
	else
	{
		m_rotation_state++;

		if(m_rotation_state > 4) m_rotation_state = 1; 

		angle = (double)(90 * (m_rotation_state - 1));
	}


	sin_angle = sin(angle / 57.29577951308);
	cos_angle = cos(angle / 57.29577951308);
			
	int size = CSymbolData.GetSize();

	CMDrawLineData.SetSize(size);

	CPoint CTemp(0, 0);

	int p;

	for(p = 0; p < size; p++)
	{
		TCLineData &CDrawLineData = CMDrawLineData[p];
		TCLineData &CSymbolDataL = CMSchematicObjectData.CSymbolData.CData[p];

		if(CDrawLineData.type == E_SCHEMATIC_SYMBOL_CIRCLE) 
		{
			if(m_mirror_state) CSymbolDataL.CEndLocation.x = -1;
			else CSymbolDataL.CEndLocation.x = 1;
		}

		CDrawLineData = CSymbolDataL; // copy lines
		CDrawLineData.Rotate(CTemp, sin_angle, cos_angle); 
		CDrawLineData.Rotate(CTemp, (int)angle); // for circles, messy, so what
	}

	// Update pin locations, TCPinObject updates pin directions
	size = CPinData.GetSize();

	if(size != CMSchematicObjectData.CPinListData.GetSize()) return;
		
	for(p = 0; p < size; p++)
	{
		CMSchematicObjectData.CPinListData[p].CLocation = RotatePoint(CPinData[p].CLocation, sin_angle, cos_angle, CTemp);
	}

	size = CMSchematicObjectData.CLabelListData.GetSize();

	CPoint CRotateCenter = CMSchematicObjectData.CLocationOffset;
	
	if(m_mirror_state) MirrorSymbolData(true);

	CMSchematicObjectData.mirror_state	= m_mirror_state;
	CMSchematicObjectData.rotation_state = m_rotation_state;
}

void TCSchematicObject::MirrorSymbolData(int current_not_next)
{
	if(!current_not_next) m_mirror_state = !m_mirror_state;
					
	int size = CMDrawLineData.GetSize();

	int p;

	for(p = 0; p < size; p++)
	{
		TCLineData &CDrawLineData = CMDrawLineData[p];

		if(CDrawLineData.type == E_SCHEMATIC_SYMBOL_CIRCLE) 
		{
			if(m_mirror_state) CMDrawLineData[p].CEndLocation.x = -1;
			else CDrawLineData.CEndLocation.x = 1;
		}

		CMDrawLineData[p].Mirror(0);
	}	

	// Update pin locations, TCPinObject updates pin directions

	size = CMSchematicObjectData.CPinListData.GetSize();
		
	for(p = 0; p < size; p++)
	{
		CMSchematicObjectData.CPinListData[p].CLocation = 
		MirrorPoint(CMSchematicObjectData.CPinListData[p].CLocation, 0);
	}

	size = CMSchematicObjectData.CLabelListData.GetSize();

	CMSchematicObjectData.mirror_state	= m_mirror_state;
	CMSchematicObjectData.rotation_state = m_rotation_state;
}

void TCSchematicObject::FlipSymbolData(int current_not_next)
{	
	if(!current_not_next) m_mirror_state = !m_mirror_state;
					
	int size = CMDrawLineData.GetSize();

	int p;
// not called or debugged !! yet
	for(p = 0; p < size; p++)
	{
//		CMDrawLineData[p].CStartLocation	= FlipPoint(CMDrawLineData[p].CStartLocation);
//		CMDrawLineData[p].CEndLocation		= FlipPoint(CMDrawLineData[p].CEndLocation);

		CMDrawLineData[p].Mirror(0);
	}	

	size = CMSchematicObjectData.CPinListData.GetSize();
		
	for(p = 0; p < size; p++)
	{
		CMSchematicObjectData.CPinListData[p].CLocation = 
		FlipPoint(CMSchematicObjectData.CPinListData[p].CLocation, 0);
	}

	size = CMSchematicObjectData.CLabelListData.GetSize();

	int y = m_object_height/2;//CMDrawLineData[0].CStartLocation.x;

	for(p = 0; p < size; p++)
	{
		if(m_mirror_state) y = CMDrawLineData[0].CStartLocation.y;
		else y = 0;

		CMSchematicObjectData.CLabelListData[p].CLocation =
		FlipPoint(CMSchematicObjectData.CLabelListData[p].CLocation, y);
	}
}

void TCSchematicObject::UpdateLabel(void)
{
		CDC CViewDC;

		if(!CViewDC.CreateCompatibleDC(NULL)) return;
			
		bool select = m_selected;
		bool highlight = m_highlighted;

		TCGraphicBitMapVectorObject::DeleteBitmapNew();

		TCGraphicBitMapVectorObject::Create(&CViewDC, CMLabel, m_zoom, 
									     GCSuperSpiceGlobalData.CColorData.user_text_normal,
										GCSuperSpiceGlobalData.CColorData.user_text_selected, 
										GCSuperSpiceGlobalData.CColorData.user_text_highlighted);
		
		CreateGrabRegion(CMLocation);

		if(select) SetSelect();
		else SetHighlight(highlight);
}

void TCSchematicObject::ZoomSymbolData(CArray<TCLineData, TCLineData &> &CSymbolData)
{
	int size = CSymbolData.GetSize();

	CMDrawLineData.SetSize(size, size);

	for(int p = 0; p < size; p++)
	{
		CMDrawLineData[p] = CSymbolData[p];

		CMDrawLineData[p].Zoom(m_zoom);
	}
}

void TCSchematicObject::ZoomRaw(void)
{
	int size = CMDrawLineData.GetSize();

	for(int p = 0; p < size; p++)
	{
		CMDrawLineData[p].Zoom(m_zoom);
	}
}

void TCSchematicObjectData::SetWaveFormLabels(TCOutputWaveformDataHeader &COutputWaveformDataHeader)
{
	// no checking, this should never fail if code is right
//	CLabelListData[E_WAVEFORM_TITLE].CLabel = COutputWaveformDataHeader.CTitle;
	CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
	CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;

}

bool TCSchematicObject::CreateWaveform(float zoom, bool refresh)
{
	m_zoom = zoom;

	CDC CViewDC;

	if(!CViewDC.CreateCompatibleDC(NULL)) return false;

	if(CMSchematicObjectData.PCOutputWaveformDataHeader)
	{
		int type = CMSchematicObjectData.PCOutputWaveformDataHeader->type;

		CheckAndNullWaveformDataPointers();

		TCGraphicBitMapVectorObject::Create(CMSchematicObjectData.PCOutputWaveformDataHeader->PCWaveformDataRuns, CMSchematicObjectData.PCOutputWaveformDataHeader, type);
	}
	else
	{
		TCGraphicBitMapVectorObject::Create(NULL, NULL, 0);
	}

	CreateWaveformWindow();
	CreateWaveformPoints(refresh);
	CreateWaveformLabels(&CViewDC);// will do zoom
	CreateWaveformPins(&CViewDC);// will do zoom;

	return true;
}

bool TCSchematicObject::CheckAndNullWaveformDataPointers(void)
{
	if(CMSchematicObjectData.CheckAndNullWaveformDataPointers()) return true;

	PCWaveformDataRuns = NULL;

	return false;
}

bool TCSchematicObject::CreateWaveformWindow(void)
{
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader)
	{
		ASSERT(0);

		return false;
	}

	unsigned short object_width = CMSchematicObjectData.width; 
	unsigned short object_height = CMSchematicObjectData.height;

	if(object_width < 16) return false;
	if(object_height < 16) return false;

	if(CMSchematicObjectData.PCOutputWaveformDataHeader) 
	{
		//prevent noise graph from shrinking ! Quick fudge fix
		if(CMSchematicObjectData.PCOutputWaveformDataHeader->type == E_SPICE_RECORD_NOISE_SPECTRAL ||
			CMSchematicObjectData.PCOutputWaveformDataHeader->type == E_SPICE_RECORD_NOISE_INTEGRATED)
		{
			object_width += 4;
			object_height += 8;
		}

		CMSchematicObjectData.PCOutputWaveformDataHeader->ScaleGrid(&object_width, &object_height);
	}

	if(PCWaveformDataRuns)// this should be nulled in operator = if bad
		PCWaveformDataRuns->SetScaleFactors(object_width, object_height, CMSchematicObjectData.PCOutputWaveformDataHeader->type, m_zoom);

	CMSchematicObjectData.width = object_width;
	CMSchematicObjectData.height = object_height;

	TCSchematicObjectData &CSchematicObjectDataCopy = GCSuperSpiceDataBase.CMDefaults[E_WAVEFORM_COMPONENT];

	m_local_width	= CSchematicObjectDataCopy.width;
	m_local_height  = CSchematicObjectDataCopy.height;

	GCSuperSpiceDataBase.SetWaveFormDefaultSize(object_width, object_height);

	CreateWaveformWindowOutline();
	CreateWaveformAxis();

	RotateSymbolData(true);// needed to set up CMDrawLineData, rotate not supported for waveforms
	ZoomRaw();// setsup CMDrawLineData from csymboldata


	COLORREF normal = CMSchematicObjectData.PCOutputWaveformDataHeader->axis_normal_colour;
	COLORREF selected = CMSchematicObjectData.PCOutputWaveformDataHeader->axis_selected_colour;
	COLORREF highlighted = CMSchematicObjectData.PCOutputWaveformDataHeader->axis_highlighted_colour;
	
	if(!TCGraphicBitMapVectorObject::Create(CMDrawLineData,
		(unsigned short)(object_width * m_zoom), 
		(unsigned short)(object_height * m_zoom),
		normal,
		selected, 
		highlighted)) 
	{
		GCSuperSpiceDataBase.SetWaveFormDefaultSize(m_local_width, m_local_height);

		return false;
	}

	ReLabelAxis();// First time round axis labels do not line up with graph outline if resized, this fixes it
	
	return true;
}

bool TCSchematicObject::CreateWaveformWindowOutline(void)
{
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader)return false;

	CArray <TCLineData, TCLineData &> &CSymbolData = CMSchematicObjectData.CSymbolData.CData;
	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	int size = CHeader.x_minor_grid_number * CHeader.x_major_grid_number  + 
		       CHeader.y_minor_grid_number * CHeader.y_major_grid_number;

	size *= 2;
	size += 4;
		
	CSymbolData.SetSize(4, size);

	CSymbolData[0].CStartLocation.x	= 0; 
	CSymbolData[0].CStartLocation.y	= 0;
	CSymbolData[0].CEndLocation.x	= 0;
	CSymbolData[0].CEndLocation.y	= CMSchematicObjectData.height;

	CSymbolData[1].CStartLocation.x		= 0; 
	CSymbolData[1].CStartLocation.y		= CMSchematicObjectData.height;
	CSymbolData[1].CEndLocation.x		= CMSchematicObjectData.width;
	CSymbolData[1].CEndLocation.y		= CMSchematicObjectData.height;

	CSymbolData[2].CStartLocation.x		= CMSchematicObjectData.width; 
	CSymbolData[2].CStartLocation.y		= CMSchematicObjectData.height;
	CSymbolData[2].CEndLocation.x		= CMSchematicObjectData.width;
	CSymbolData[2].CEndLocation.y		= 0;

	CSymbolData[3].CStartLocation.x		= CMSchematicObjectData.width; 
	CSymbolData[3].CStartLocation.y		= 0;
	CSymbolData[3].CEndLocation.x		= 0;
	CSymbolData[3].CEndLocation.y		= 0;

	return true;
}

bool TCSchematicObject::CreateWaveformAxis(void)
{
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader)return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->axis_index;

	int width	= CMSchematicObjectData.width;
	int height	= CMSchematicObjectData.height;

	float points_per_float = 100.0;//default if no data

	int signals_size = CSignals.GetSize();

	if(axis_index < signals_size)
		if(!CSignals[axis_index].phase_axis)
			points_per_float = (float)CSignals[axis_index].points_per_float;
		else points_per_float = (float)CSignals[axis_index].phase_points_per_float;


	CreateBottomWaveformAxis(height, CHeader.x_major_grid_number, 1, CHeader.x_major_grid_size, 32, 0, points_per_float);//major ticks
	CreateBottomWaveformAxis(height, CHeader.x_major_grid_number, CHeader.x_minor_grid_number, CHeader.x_minor_grid_size, 16, CHeader.x_grid_decades, points_per_float);//minor ticks

	CreateTopWaveformAxis(0, CHeader.x_major_grid_number, 1, CHeader.x_major_grid_size, 32, 0, points_per_float);//major ticks
	CreateTopWaveformAxis(0, CHeader.x_major_grid_number, CHeader.x_minor_grid_number, CHeader.x_minor_grid_size, 16, CHeader.x_grid_decades, points_per_float);//minor ticks

	axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index;

	if(axis_index > -1)
	{
		if(axis_index < signals_size)
		{
			points_per_float = (float)CSignals[axis_index].points_per_float;
		}
	}

	CreateLeftWaveformAxis(0, CHeader.y_major_grid_number, 1, CHeader.y_major_grid_size, 32, 0, points_per_float);// major ticks
	CreateLeftWaveformAxis(0, CHeader.y_major_grid_number, CHeader.y_minor_grid_number, CHeader.y_minor_grid_size, 16, CHeader.y_grid_decades, points_per_float);// minor ticks

	axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index;
	
	if(axis_index > -1)
	{
		if(axis_index < signals_size)
		{
			points_per_float = (float)CSignals[axis_index].phase_points_per_float;
		}
	}

	CreateRightWaveformAxis(width, CHeader.y_phase_major_grid_number, 1, CHeader.y_phase_major_grid_size, 32, 0, points_per_float);// major ticks
	CreateRightWaveformAxis(width, CHeader.y_phase_major_grid_number, CHeader.y_phase_minor_grid_number, CHeader.y_phase_minor_grid_size, 16, CHeader.y_phase_manual, points_per_float);// minor ticks

	xaxis_start_index = E_WAVEFORM_ENABLE;// generic labels end at

	CMSchematicObjectData.CLabelListData.SetSize(xaxis_start_index + 1);

	SetupBottomWaveformLabels();// this order determins
	SetupLeftWaveformLabels();
	SetupRightWaveformLabels();
	CreateMagnitudeGraphLines();
	CreatePhaseGraphLines();

	return true;
}

bool TCSchematicObject::CreateTopWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float)
{
	CArray <TCLineData, TCLineData &> &CSymbolData = CMSchematicObjectData.CSymbolData.CData;

	int start	= CSymbolData.GetSize();
	double next	= 0;
	int index	= start;
	int major_next = 0;

	CSymbolData.SetSize(start + count * minor_count);

	for(int p = 0; p < count; p++)
	{
		next = 0;

		for(int q = 0; q < minor_count; q++)
		{
			CSymbolData[index].CStartLocation.x = major_next + (int)next;
			CSymbolData[index].CEndLocation.x	= major_next + (int)next;

			CSymbolData[index].CStartLocation.y = location;
			CSymbolData[index].CEndLocation.y	= tick_size;

			if(!type) next += (int)increment;
			else next = (int) (points_per_float * log10((float)q + 1) / m_zoom);

			index++;
		}
		major_next += minor_count * increment;
	}

	return true;
}

bool TCSchematicObject::CreateLeftWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float)
{
	CArray <TCLineData, TCLineData &> &CSymbolData = CMSchematicObjectData.CSymbolData.CData;

	int		start	= CSymbolData.GetSize();
	double	next = 0;
	int		index	= start;

	int major_next = minor_count * increment;

	CSymbolData.SetSize(start + count * minor_count);

	for(int p = 0; p < count; p++)
	{
		next = 0;

		for(int q = 0; q < minor_count; q++)
		{	
			CSymbolData[index].CStartLocation.x = location;
			CSymbolData[index].CEndLocation.x	= tick_size;

			CSymbolData[index].CStartLocation.y = major_next - (int)next;
			CSymbolData[index].CEndLocation.y	= major_next - (int)next;

			if(!type) next += (int)increment;
			else next = (int) (points_per_float * log10((float)minor_count - q) / m_zoom);


			index++;
		}
		major_next += minor_count * increment;
	}

	return true;
}

void TCSchematicObject::CreateMagnitudeGraphLines(void)
{
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;

}

void TCSchematicObject::CreatePhaseGraphLines(void)
{
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;

}

bool TCSchematicObject::CreateBottomWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float)
{
	CArray <TCLineData, TCLineData &> &CSymbolData = CMSchematicObjectData.CSymbolData.CData;

	int start	= CSymbolData.GetSize();
	int index	= start;
	double next	= 0;

	int major_next = 0;

	CSymbolData.SetSize(start + count * minor_count);

	for(int p = 0; p < count; p++)
	{
		next = 0;

		for(int q = 0; q < minor_count; q++)
		{
			CSymbolData[index].CStartLocation.x = major_next + (int)next;
			CSymbolData[index].CEndLocation.x	= major_next + (int)next;

			CSymbolData[index].CStartLocation.y = location;
			CSymbolData[index].CEndLocation.y	= location - tick_size;

			if(!type) next += (int)increment;
			else next = (int) (points_per_float * log10((float)q + 1) / m_zoom);

			index++;
		}

		major_next += minor_count * increment;
	}

	return true;
}

bool TCSchematicObject::CreateRightWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float)
{
	CArray <TCLineData, TCLineData &> &CSymbolData = CMSchematicObjectData.CSymbolData.CData;

	int start	= CSymbolData.GetSize();
	int index	= start;
	double next	= 0;

	int major_next = minor_count * increment;

	CSymbolData.SetSize(start + count * minor_count);

	for(int p = 0; p < count; p++)
	{
		next = 0;

		for(int q = 0; q < minor_count; q++)
		{
			CSymbolData[index].CStartLocation.x = location;
			CSymbolData[index].CEndLocation.x	= location - tick_size;

			CSymbolData[index].CStartLocation.y = major_next - (int)next;
			CSymbolData[index].CEndLocation.y	= major_next - (int)next;

			if(!type) next += (int)increment;
			else next = (int) (points_per_float * log10((float)minor_count - q) / m_zoom);

			index++;
		}
		major_next += minor_count * increment;
	}

	return true;
}

void TCSchematicObject::ReCreate(void)
{
	Zoom(m_zoom);
}

bool TCSchematicObject::ChangeColour(TCTestPointData &CTestPointData)
{
	if(!PCWaveformDataRuns) return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;
	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return false;

	if(!PCWaveformDataRuns->ChangeColour(CMSchematicObjectData.PCOutputWaveformDataHeader, CTestPointData)) return false;

	ReCreate();

	return true;
}

void TCSchematicObject::ChangeBKGColour(int colour)
{
	if(m_type != E_WAVEFORM_COMPONENT) return;

	CMSchematicObjectData.PCOutputWaveformDataHeader->background_colour = colour;

	// a paste is required to effect changes.

	//Below is additional Dec 2018 Fix as BKG colour was not saved!

	if(!PCWaveformDataRuns) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	int run_count = PCWaveformDataRuns->CRuns.GetSize();

	if(!run_count) return;

	PCWaveformDataRuns->ChangeBKGColour(CMSchematicObjectData.PCOutputWaveformDataHeader, colour);
}

void TCSchematicObject::ClearAllWaveforms(void)
{
	if(!PCWaveformDataRuns) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return;
	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return; 
	}

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return;

	if(!PCWaveformDataRuns->ClearAllWaveforms(CMSchematicObjectData.PCOutputWaveformDataHeader)) return;

	if(run_count == 1) 	CMSchematicObjectData.PCOutputWaveformDataHeader->CreateListOfDisplayedSignals();
	else PCWaveformDataRuns->CreateListsOfDisplayedSignals(CMSchematicObjectData.PCOutputWaveformDataHeader);
	
	ReCreate();
}

bool TCSchematicObject::ChangeWaveform(TCTestPointData &CTestPointData)
{
	if(!PCWaveformDataRuns) return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;
	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return false;

	if(!PCWaveformDataRuns->ChangeWaveform(CMSchematicObjectData.PCOutputWaveformDataHeader, CTestPointData)) return false;

	PCWaveformDataRuns->CreateListsOfDisplayedSignals(CMSchematicObjectData.PCOutputWaveformDataHeader);

	ReCreate();

	return true;
}

void TCSchematicObject::WaveFormZoom(CDC *PCViewDC, CRect CZoomRect)
{
	if(CZoomRect.Width() < 2 || CZoomRect.Height() < 2) return;

	Clear(PCViewDC);
	WaveFormZoom(CZoomRect);
	Paste(PCViewDC, CMLocation);
}

void TCSchematicObject::WaveFormZoom(CRect CZoomRect)
{
	if(!PCWaveformDataRuns) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &CThisHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	CThisHeader.x_manual = true;
	CThisHeader.y_manual = true;
	CThisHeader.y_phase_manual = true;

	if(!PCWaveformDataRuns->GetHeader(CMSchematicObjectData.PCOutputWaveformDataHeader, 0)) return;

	TCOutputWaveformDataHeader &CHeader = *PCWaveformDataRuns->GetHeader(CMSchematicObjectData.PCOutputWaveformDataHeader, 0);

	CHeader.x_manual = true;
	CHeader.y_manual = true;
	CHeader.y_phase_manual = true;

	CZoomRect -= CMLocation;

	CZoomRect.top		= m_object_height - CZoomRect.top;
	CZoomRect.bottom	= m_object_height - CZoomRect.bottom;

	CHeader.AllWaveformZoom(CZoomRect);
	CThisHeader.WaveformZoom(CZoomRect);// setup the max and min values from CRect

	Zoom(m_zoom);
}

void TCSchematicObject::WaveFormAutoScale(void)
{
	if(!PCWaveformDataRuns) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	CMSchematicObjectData.PCOutputWaveformDataHeader->x_manual = false;
	CMSchematicObjectData.PCOutputWaveformDataHeader->y_manual = false;
	CMSchematicObjectData.PCOutputWaveformDataHeader->y_phase_manual = false;

	CMSchematicObjectData.PCOutputWaveformDataHeader->CZoomRectangle.SetRectEmpty();
	CMSchematicObjectData.PCOutputWaveformDataHeader->SyncAllRuns();
}

void TCSchematicObject::WaveFormScrollXRight(void)
{

}

void TCSchematicObject::WaveFormScrollXLeft(void)
{

}

void TCSchematicObject::WaveFormScrollYUp(void)
{

}

void TCSchematicObject::WaveFormScrollYDown(void)
{

}

void TCSchematicObject::WaveFormMagnify(void)
{

}

void TCSchematicObject::WaveFormReduce(void)
{

}

void TCSchematicObject::ReLabelAxis(void)
{
	// This is not foolprof, axis needs to be refreshed, but this takes time
	if(!PCWaveformDataRuns) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return; 
	}

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return;

	if(IsBadCodePtr((FARPROC)PCWaveformDataRuns))
	{
		ASSERT(0);

		return; 
	}

	if(!PCWaveformDataRuns->CRuns.GetSize()) return;

	TCOutputWaveformData *PCOutputWaveformData =  PCWaveformDataRuns->CRuns[0];

	if(!PCOutputWaveformData) return;

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;
	
	// need to keep things in sync
	active_magnitude_axis_index = CHeader.active_magnitude_axis_index;
	active_phase_axis_index		= CHeader.active_phase_axis_index;

	int record_waveform_index = m_waveform_index;

//	if(PCWaveformDataRuns->CMathFunctionDataList[0].calculator_enabled)
//			record_waveform_index = E_SPICE_RECORD_MATH_0;

	PCOutputWaveformData->CRecords[record_waveform_index].CHeader.active_magnitude_axis_index = active_magnitude_axis_index;
	PCOutputWaveformData->CRecords[record_waveform_index].CHeader.active_phase_axis_index	= active_phase_axis_index;

	xaxis_start_index = E_WAVEFORM_ENABLE;// generic labels end at

	CMSchematicObjectData.CLabelListData.SetSize(xaxis_start_index + 1);


	SetupBottomWaveformLabels();
	SetupLeftWaveformLabels();
	SetupRightWaveformLabels();
	CreateLabels(&GlobalCDCTemp);
}

void TCSchematicObject::ReLabelAxisSignalNames(CDC *PCViewDC)
{
	ReLabelLeftAxisSignalName(PCViewDC);
	ReLabelRightAxisSignalName(PCViewDC);
}

bool TCSchematicObject::ReLabelLeftAxisSignalName(CDC *PCViewDC)
{
	if(!PCWaveformDataRuns) return false;

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals)) return false; 

	if(IsBadCodePtr((FARPROC)PCWaveformDataRuns)) return false; 

	if(!PCWaveformDataRuns->IsAnyMagnitudesDisplayed(CHeader.type)) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index;

	if(axis_index < 0) return false;

	if(!(axis_index < CSignals.GetSize())) return false;

	LOGFONT &s_logfont = GCSuperSpiceGlobalData.CFontData.CWaveformAxisLogFont;

	TCSignal &CSignal = CSignals[axis_index];

	active_magnitude_axis_index = axis_index;

	if(!(y_magnitude_axis_signal_name_index < CMSchematicObjectData.CLabelListData.GetSize())) return false;

	CString CName;
	CSize CTextSize;

	CSize CTextSpacing = GetTextSize("W", s_logfont, m_zoom);// largest letter

	if(CHeader.type == E_SPICE_RECORD_MATH_0) CName = CSignal.CCalculatorNameMagnitude;
	else CName = CSignal.CName;

	CTextSize = GetTextSize(CName, s_logfont, m_zoom);

	ClearLabel(PCViewDC, y_magnitude_axis_signal_name_index);

	CMSchematicObjectData.CLabelListData[y_magnitude_axis_signal_name_index].CLabel = CName;

	CMSchematicObjectData.CLabelListData[y_magnitude_axis_signal_name_index].CLocation.x = - (long)(CTextSize.cx/m_zoom + CTextSpacing.cx);
	CMSchematicObjectData.CLabelListData[y_magnitude_axis_signal_name_index].CLocation.y = - (long)(CTextSize.cy/m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[y_magnitude_axis_signal_name_index].is_visable  = true;

	SetLabel(PCViewDC, y_magnitude_axis_signal_name_index, CName, false);//create

//	RepasteLabel(PCViewDC, y_magnitude_axis_signal_name_index);
	RePasteSingleLabel(PCViewDC, y_magnitude_axis_signal_name_index);

	return true;
}

bool TCSchematicObject::ReLabelRightAxisSignalName(CDC *PCViewDC)
{
	if(!PCWaveformDataRuns) return false;

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals)) return false; 

	if(IsBadCodePtr((FARPROC)PCWaveformDataRuns)) return false; 

	if(!PCWaveformDataRuns->IsAnyPhaseDisplayed(CHeader.type)) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index;

	if(axis_index < 0) return false;

	if(!(axis_index < CSignals.GetSize())) return false;

	TCSignal &CSignal = CSignals[axis_index];

	if(!CSignal.CPhaseData.CX.GetSize()) return false;

	LOGFONT &s_logfont = GCSuperSpiceGlobalData.CFontData.CWaveformAxisLogFont;

	active_phase_axis_index = axis_index;

	if(!(y_phase_axis_signal_name_index < CMSchematicObjectData.CLabelListData.GetSize())) return false;

	CString CName;
	CSize CTextSize;

	CSize CTextSpacing = GetTextSize("W", s_logfont, m_zoom);// largest letter

	if(CHeader.type == E_SPICE_RECORD_MATH_0) CName = CSignal.CCalculatorNameMagnitude;
	else CName = CSignal.CName;

	CTextSize = GetTextSize(CName, s_logfont, m_zoom);

	ClearLabel(PCViewDC, y_phase_axis_signal_name_index);

	CMSchematicObjectData.CLabelListData[y_phase_axis_signal_name_index].CLabel = CName;

	CMSchematicObjectData.CLabelListData[y_phase_axis_signal_name_index].CLocation.x = - (long)(CTextSize.cx/m_zoom + CTextSpacing.cx);
	CMSchematicObjectData.CLabelListData[y_phase_axis_signal_name_index].CLocation.y = - (long)(CTextSize.cy/m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[y_phase_axis_signal_name_index].is_visable  = true;

	SetLabel(PCViewDC, y_phase_axis_signal_name_index, CName, false);

//	RepasteLabel(PCViewDC, y_phase_axis_signal_name_index);

	RePasteSingleLabel(PCViewDC, y_phase_axis_signal_name_index);

	return true;
}

bool TCSchematicObject::ReLabelRequired(void)
{
	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	if(CHeader.active_phase_axis_index == active_phase_axis_index && 
	   CHeader.active_magnitude_axis_index	== active_magnitude_axis_index) return false;

	return true;
}

bool TCSchematicObject::SetupBottomWaveformLabels(void)
{
	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int axis_index = CHeader.axis_index;

	if(!(axis_index < CSignals.GetSize())) return false;

	if(axis_index < 0) return false;

	TCSignal &CSignal = CSignals[axis_index];

	LOGFONT &s_logfont = GCSuperSpiceGlobalData.CFontData.CWaveformAxisLogFont;

	//test = 1 label
	xaxis_start_index = E_WAVEFORM_ENABLE + 1;

	CMSchematicObjectData.CLabelListData.SetSize(xaxis_start_index + 1, 32);

	CSize CTextSize = GetTextSize(CSignal.CName, s_logfont, m_zoom);
	CSize CTextSpacing = GetTextSize("W", s_logfont, m_zoom);// largest letter

	CMSchematicObjectData.CLabelListData[xaxis_start_index].CLabel = CSignal.CName;

	CMSchematicObjectData.CLabelListData[xaxis_start_index].CLocation.x = (int)((m_object_width - CTextSize.cx) / m_zoom/2);
	CMSchematicObjectData.CLabelListData[xaxis_start_index].CLocation.y = (int)((m_object_height + CTextSize.cy) / m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[xaxis_start_index].is_visable	= true;

	int start	= CMSchematicObjectData.CLabelListData.GetSize();
	int index	= start;
	int count	= CHeader.x_major_grid_number + 1;// need both ends labeled
	CString	CText;
	int major_next = 0;

	CMSchematicObjectData.CLabelListData.SetSize(start + count);

	for(int p = 0; p < count; p++)
	{
		CText		= CHeader.GetDataTextXValue((long)(major_next * m_zoom));
		CTextSize	= GetTextSize(CText, s_logfont, m_zoom);

		CMSchematicObjectData.CLabelListData[index].CLabel = CText;
		CMSchematicObjectData.CLabelListData[index].CLocation.x = (long)(major_next  - (CTextSize.cx/2)/ m_zoom);

		CMSchematicObjectData.CLabelListData[index].CLocation.y = (long)(m_object_height / m_zoom + CTextSpacing.cy);

		CMSchematicObjectData.CLabelListData[index].is_visable	= true;

		major_next += CHeader.x_major_grid_size;

		index++;
	}

	return true;
}

bool TCSchematicObject::SetupRightWaveformLabels(void)
{
	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	if(IsBadCodePtr((FARPROC)PCWaveformDataRuns))
	{
		ASSERT(0);

		return false; 
	}

	if(!PCWaveformDataRuns->IsAnyPhaseDisplayed(CHeader.type)) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index;

	if(axis_index < 0) return false;

	int signal_count = CSignals.GetSize();

	if(!(axis_index < signal_count)) return false;

	TCSignal *PCSignal = &CSignals[axis_index];

	if(!PCSignal->CPhaseData.CX.GetSize()) return false;

	LOGFONT &s_logfont = GCSuperSpiceGlobalData.CFontData.CWaveformAxisLogFont;

	active_phase_axis_index = axis_index;

	if(PCSignal->phase == -1)//bad axis index, find first good one
	{
		for(int p = 0; p < signal_count; p++)
		{
			if(CSignals[p].phase == -1) continue;

			active_magnitude_axis_index = p;
			axis_index = p;
			CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index = p;

			break;
		}
	}

	PCSignal = &CSignals[axis_index];

	yphase_axis_start_index = CMSchematicObjectData.CLabelListData.GetSize();

	CMSchematicObjectData.CLabelListData.SetSize(yphase_axis_start_index + 2);

	CString CYAxisLabel = "Phase/Imaj";

	if(CHeader.type == E_SPICE_RECORD_SENSITIVITY) CYAxisLabel = "Sens2.";

	CSize CTextSize = GetTextSize(CYAxisLabel, s_logfont, m_zoom);
	CSize CTextSpacing = GetTextSize("W", s_logfont, m_zoom);// largest letter

	CMSchematicObjectData.CLabelListData[yphase_axis_start_index].CLabel = CYAxisLabel;

	CMSchematicObjectData.CLabelListData[yphase_axis_start_index].CLocation.x = (long)(m_object_width / m_zoom + CTextSpacing.cx);
	CMSchematicObjectData.CLabelListData[yphase_axis_start_index].CLocation.y = - (long)(CTextSize.cy / m_zoom + CTextSize.cy / m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[yphase_axis_start_index].is_visable  = true;

	CString CName, CModText;

	if(CHeader.type == E_SPICE_RECORD_MATH_0) 
	{
		CName = PCSignal->CCalculatorNamePhase;

		if(CName.Find("Group delay") > -1) CModText = "Sec.";
	}
	else CName = PCSignal->CName;

	CTextSize = GetTextSize(CName, s_logfont, m_zoom);

	y_phase_axis_signal_name_index = yphase_axis_start_index + 1;

	CMSchematicObjectData.CLabelListData[yphase_axis_start_index + 1].CLabel = CName;

	CMSchematicObjectData.CLabelListData[yphase_axis_start_index + 1].CLocation.x = (long)(m_object_width / m_zoom + CTextSpacing.cx);
	CMSchematicObjectData.CLabelListData[yphase_axis_start_index + 1].CLocation.y = - (long)(CTextSize.cy / m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[yphase_axis_start_index + 1].is_visable  = true;

	int start	= CMSchematicObjectData.CLabelListData.GetSize();
	int index	= start;
	int count	= CHeader.y_phase_major_grid_number + 1;// need both ends labeled
	CString	CText;
	int major_next = 0;

	CMSchematicObjectData.CLabelListData.SetSize(start + count);

	for(int p = 0; p < count; p++)
	{
		CText		= CHeader.GetDataTextYValue((long)(m_object_height - major_next * m_zoom), true);
		
		if(CModText != "") CText.Replace("deg.", CModText);

		CTextSize	= GetTextSize(CText, s_logfont, m_zoom);

		CMSchematicObjectData.CLabelListData[index].CLabel		= CText;
		CMSchematicObjectData.CLabelListData[index].CLocation.x =  (long)(m_object_width / m_zoom + CTextSpacing.cx);

		CMSchematicObjectData.CLabelListData[index].CLocation.y = (long)(major_next - CTextSize.cy/2/m_zoom);

		CMSchematicObjectData.CLabelListData[index].is_visable	= true;

		major_next += CHeader.y_phase_major_grid_size;

		index++;
	}

	return true;
}

bool TCSchematicObject::SetupLeftWaveformLabels(void)
{
	if(!PCWaveformDataRuns) return false;

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return false;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	if(IsBadCodePtr((FARPROC)PCWaveformDataRuns))
	{
		ASSERT(0);

		return false; 
	}

	if(!PCWaveformDataRuns->IsAnyMagnitudesDisplayed(CHeader.type)) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index;

	if(axis_index < 0) return false;

	int signal_count = CSignals.GetSize();

	if(!(axis_index < signal_count)) return false;

	LOGFONT &s_logfont = GCSuperSpiceGlobalData.CFontData.CWaveformAxisLogFont;

	TCSignal *PCSignal = &CSignals[axis_index];

	active_magnitude_axis_index = axis_index;

	if(PCSignal->magnitude == -1)//bad axis index, find first good one
	{
		for(int p = 0; p < signal_count; p++)
		{
			if(CSignals[p].magnitude == -1) continue;

			active_magnitude_axis_index = p;
			axis_index = p;
			CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index = p;

			break;
		}
	}

	PCSignal = &CSignals[axis_index];

	ymagnitude_axis_start_index = CMSchematicObjectData.CLabelListData.GetSize();

	CMSchematicObjectData.CLabelListData.SetSize(ymagnitude_axis_start_index + 2);

	CString CYAxisLabel = "Mag/Real";

	if(CHeader.type == E_SPICE_RECORD_SENSITIVITY) CYAxisLabel = "Sens1.";

	CSize CTextSize = GetTextSize(CYAxisLabel, s_logfont, m_zoom);// get if mag or real to do
	
	CSize CTextSpacing = GetTextSize("W", s_logfont, m_zoom);// largest letter

	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index].CLabel = CYAxisLabel ;
	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index].CLocation.x = - (long)(CTextSize.cx/m_zoom + CTextSpacing.cx);
	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index].CLocation.y = - (long)(CTextSize.cy/m_zoom + CTextSize.cy/m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index].is_visable  = true;

	CString CName;

	if(CHeader.type == E_SPICE_RECORD_MATH_0) CName = PCSignal->CCalculatorNameMagnitude;
	else CName = PCSignal->CName;

	CTextSize = GetTextSize(CName, s_logfont, m_zoom);

	y_magnitude_axis_signal_name_index = ymagnitude_axis_start_index + 1;

	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index + 1].CLabel = CName;

	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index + 1].CLocation.x = - (long)(CTextSize.cx/m_zoom + CTextSpacing.cx);
	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index + 1].CLocation.y = - (long)(CTextSize.cy/m_zoom + CTextSpacing.cy);
	CMSchematicObjectData.CLabelListData[ymagnitude_axis_start_index + 1].is_visable  = true;

	int start	= CMSchematicObjectData.CLabelListData.GetSize();
	int index	= start;
	int count	= CHeader.y_major_grid_number + 1;// need both ends labeled
	CString	CText;
	int major_next = 0;

	CMSchematicObjectData.CLabelListData.SetSize(start + count);

	for(int p = 0; p < count; p++)
	{
		CText		= CHeader.GetDataTextYValue((long)(m_object_height - major_next * m_zoom), false);
		CTextSize	= GetTextSize(CText, s_logfont, m_zoom);

		CMSchematicObjectData.CLabelListData[index].CLabel		= CText;
		CMSchematicObjectData.CLabelListData[index].CLocation.x =  - (long)(CTextSize.cx/m_zoom + CTextSpacing.cx);

		CMSchematicObjectData.CLabelListData[index].CLocation.y = (long)(major_next - CTextSize.cy/2/m_zoom);

		CMSchematicObjectData.CLabelListData[index].is_visable	= true;

		major_next += CHeader.y_major_grid_size;

		index++;
	}

	return true;
}

bool TCSchematicObject::UpdateGraphScaleFactors(CDC *PCViewDC, int run_number)
{
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return true;
	if(!PCWaveformDataRuns) return true;

	double max_min;
	double g_max_min;

	if(run_number < 0) return true;
	if(m_waveform_index < 0) return true;// failed

	int run_count = PCWaveformDataRuns->CRuns.GetSize();

	if(!run_count) return true;

	if(!(run_number < run_count)) return true;

	TCOutputWaveformData *PCOutputWaveformData =  PCWaveformDataRuns->CRuns[run_number];

	CArray<class TCDisplayedSignals,class TCDisplayedSignals &> *PCDisplayedSignalList = &PCOutputWaveformData->CRecords[m_waveform_index].CHeader.CDisplayedSignalsList;

	if(run_count == 1)
		PCDisplayedSignalList = &CMSchematicObjectData.PCOutputWaveformDataHeader->CDisplayedSignalsList;

	int count = PCDisplayedSignalList->GetSize();

	if(!count) return true;

	bool flag = false;

	for(int p = 0; p < count; p++)
	{
		TCDisplayedSignals &CDisplayedSignalM = (*PCDisplayedSignalList)[p];

		TCSignal &CXSignal = *CDisplayedSignalM.PCSignalX;
		TCSignal &CYSignal = *CDisplayedSignalM.PCSignal1;

		if(!&CXSignal) continue;
		if(!&CYSignal)  continue;

		//X Check
		max_min = CXSignal.CMagnitudeData.GetMaxValue();

		g_max_min = (m_object_width - CXSignal.min_points) / CXSignal.points_per_float;

		if(max_min > g_max_min) {flag = true; break;}

		max_min = CXSignal.CMagnitudeData.GetMinValue();

		g_max_min = - CXSignal.min_points/CXSignal.points_per_float;

		if(max_min < g_max_min) {flag = true; break;}
	
		// Y mag check
		if(CYSignal.magnitude > -1)
		{
			max_min = CYSignal.CMagnitudeData.GetMaxValue();

			g_max_min = (m_object_height - CYSignal.min_points) / CYSignal.points_per_float;

			if(CYSignal.magnitude) g_max_min = AntiLog(g_max_min / 20);

			if(max_min > g_max_min) {flag = true; break;}

			max_min = CYSignal.CMagnitudeData.GetMinValue();

			g_max_min =  - CYSignal.min_points / CYSignal.points_per_float;

			if(CYSignal.magnitude) g_max_min = AntiLog(g_max_min / 20);

			if(max_min < g_max_min) {flag = true; break;}
		}

		// Y Phase check
		if(CYSignal.phase > -1)
		{
			max_min = CYSignal.CPhaseData.GetMaxValue();

			g_max_min = (m_object_height - CYSignal.min_phase_points) / CYSignal.phase_points_per_float;

			if(!CYSignal.phase) g_max_min /= 57.29577951308;

			if(max_min > g_max_min) {flag = true; break;}

			max_min = CYSignal.CPhaseData.GetMinValue();

			g_max_min =  - CYSignal.min_phase_points / CYSignal.phase_points_per_float;

			if(!CYSignal.phase) g_max_min /= 57.29577951308;

			if(max_min < g_max_min) {flag = true; break;}
		}
	}

	if(!flag) return false;

	Clear(PCViewDC);

	CreateWaveform(m_zoom);

	Paste(PCViewDC, CMLocation);

	return true;
}

bool TCSchematicObject::UpdateMarchingWaveform(CDC *PCViewDC, int run_number)
{	
	if(UpdateGraphScaleFactors(PCViewDC, run_number)) return true;// Check to see if marching waveform is out of graph range

	if(!CreateWaveformPoints(true)) return false;

	VectorRePaste(PCViewDC, CMLocation, true);//true = only do waveforms

	return true;
}

void TCSchematicObject::SetupMarchingWaveforms(TCWaveformDataRuns *PCWaveformDataRunsNew, CArray <TCSignal, TCSignal&> *PCSignalsNew, int waveform_type, int run_number)
{
	if(m_property != E_WAVEFORM_OBJECT) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader)  return;

	CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals = PCSignalsNew;
	CMSchematicObjectData.PCOutputWaveformDataHeader->PCWaveformDataRuns = PCWaveformDataRunsNew;
	PCWaveformDataRuns = PCWaveformDataRunsNew;
	m_waveform_index = waveform_type;

	if(!CheckAndNullWaveformDataPointers())return;

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return;

	if(run_count == 1) 	CMSchematicObjectData.PCOutputWaveformDataHeader->CreateListOfDisplayedSignals();
	else PCWaveformDataRuns->CreateListsOfDisplayedSignals(CMSchematicObjectData.PCOutputWaveformDataHeader);
	
	int count = CMDrawLineData.GetSize();
	
	if(m_waveform_index_start)
	for(int p = m_waveform_index_start; p < count; p++)
	{
		TCLineData &CLineData = CMDrawLineData[p];

		CLineData.start_point = 0;
		CLineData.stop_point = 0;
		CLineData.CPoints.SetSize(0);
	}

	CreateWaveformPoints(run_number + 1);

	// a paste is done after this
}

bool TCSchematicObject::CreateWaveformPoints(int refresh)
{
	if(!PCWaveformDataRuns) return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return true;

	if(IsBadCodePtr((FARPROC)CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals))
	{
		ASSERT(0);

		return false; 
	}

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int count = CSignals.GetSize();

	if(count < 2) return false;

	if(!refresh) m_waveform_index_start = CMDrawLineData.GetSize();// add onto axis data

	int num_signals = count * run_count;// estimate the buffer alloc size

	if(!num_signals) return false;

	CMDrawLineData.SetSize(m_waveform_index_start + count);// worst case all with phase

	if(0)
	if(!refresh)
	{
		CMWaveFormDrawData.SetSize(0);

		CMWaveFormDrawData.SetSize(count);
	}

	if(CMDrawLineData.GetSize() != m_waveform_index_start + count) return false;

	int signal_counter	= 0;//indexex each signal for each run;
	int index			= m_waveform_index_start;// indexs all waveforms, for all runs after axis

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->axis_index;

	if(!(axis_index < count)) // auto correct 
	{
		CMSchematicObjectData.PCOutputWaveformDataHeader->axis_index = 0;
		axis_index = 0;// signal to be used as xaxis  
	}

	int record_waveform_index = m_waveform_index;

	CArray<class TCDisplayedSignals,class TCDisplayedSignals &> *PCDisplayedSignalList;

	int new_refresh;

	for(int q = 0; q < run_count; q++)
	{ 
		TCOutputWaveformData *PCOutputWaveformData =  PCWaveformDataRuns->CRuns[q];

		if(!PCOutputWaveformData) return false;

		if(!(record_waveform_index < PCOutputWaveformData->CRecords.GetSize())) return false; 

		CArray <TCSignal, TCSignal &> &CSignals = *PCWaveformDataRuns->CRuns[q]->CRecords[record_waveform_index].CHeader.PCSignals;

		if(!PCOutputWaveformData->CRecords[record_waveform_index].CHeader.run_selected) continue;

		count = CSignals.GetSize();

		if(!count) continue;

		if(!(axis_index < count)) continue;

		TCSignal &CSignalX = CSignals[axis_index];

		long graph_points_size = CSignalX.max_points - CSignalX.min_points + 1;

		if(!refresh) CSignalX.GraphPointToMagDataIndex.SetSize(0);
		CSignalX.GraphPointToMagDataIndex.SetSize(graph_points_size);

		if(!refresh) CSignalX.ClearGraphPointToMagData();

		CSignalX.GraphPointToMagDataIndex[0] = 0;
 
		PCDisplayedSignalList = &PCOutputWaveformData->CRecords[record_waveform_index].CHeader.CDisplayedSignalsList;

//		11 April 2003, attempt to get individual graphs

		if(run_count == 1)
			PCDisplayedSignalList = &CMSchematicObjectData.PCOutputWaveformDataHeader->CDisplayedSignalsList;

		int displayed_list_count = PCDisplayedSignalList->GetSize();

		signal_counter = 0;

		new_refresh = 0;

		if(refresh) if(q == refresh - 1) new_refresh = true;// only one waveform set is marching
	
		for(int p = 0; p < count; p++)
		{
			if(!(signal_counter < displayed_list_count)) break;//all found

			TCDisplayedSignals &CDisplayedSignalM = (*PCDisplayedSignalList)[signal_counter];

			CDisplayedSignalM.PCSignal1 = &CSignals[p];
			CDisplayedSignalM.PCSignalX = &CSignalX;

			TCSignal &CSignal = *CDisplayedSignalM.PCSignal1;

			if(CDisplayedSignalM.index1 == p)
			if(CDisplayedSignalM.magnitude != -1)
			{
				CSignal.type = CDisplayedSignalM.type;
		
				CreateWaveformPoints(index, CSignals[axis_index], CSignal, CSignal.type, new_refresh);
		
				index++;
				signal_counter++;
			}

			if(!(signal_counter < displayed_list_count)) break;//all found

			TCDisplayedSignals &CDisplayedSignalP = (*PCDisplayedSignalList)[signal_counter];

			CDisplayedSignalP.PCSignal1 = CDisplayedSignalM.PCSignal1;
			CDisplayedSignalP.PCSignalX = CDisplayedSignalM.PCSignalX;
			
			if(CDisplayedSignalP.index1 == p)
			if(CDisplayedSignalP.phase != -1)
			{
				CSignal.type = CDisplayedSignalP.type;
		
				CreateWaveformPoints(index, CSignals[axis_index], CSignal,  CSignal.type, new_refresh);
		
				index++;
				signal_counter++;
			}

		// Add other types of data displayed here 
		}

		//CSignalX.FormatGraphPointToMagDataIndex();
	}// end of scan all runs

	if(0) CMWaveFormDrawData.SetSize(signal_counter);

	return true;
}

bool TCSchematicObject::CreateWaveformPoints(int index, TCSignal &CSignalX, TCSignal &CSignalY, int type, int refresh)
{
	TCLineData	CLinePointsAccumelate, CLinePoints;
	TCLineData	CPointAtoB;
	CPoint		CLastPoint;
	long		ref_x = 0;
	long		ref_y = 0;

	int count = CSignalX.CMagnitudeData.CX.GetSize();
	if(!count) return false;

	int y_count = CSignalY.CMagnitudeData.CX.GetSize();

	if(y_count != count) return false;

	long x=0, y=0;

	CPoint CLocation(0,0);

	if(refresh) CLocation = CMLocation;

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	int x_axis_type		= CHeader.x_grid_decades;
	int yp_axis_type	= CHeader.y_phase_grid_decades;
	int ym_axis_type	= CHeader.y_grid_decades;
	int start_point		= 0;

	if(refresh && CSignalY.start_point) if(CSignalY.start_point < count) start_point = CSignalY.start_point;

	if(refresh)	{ref_x = CMLocation.x; ref_y = CMLocation.y;}

	// this should be moved to signal class
	int xtype = type;// phase on x axis needs to be done still
	
	xtype = CSignalX.GetXAxisType();

	int accumelate_size = 16 * count; // just a guess a value, its still a vast improvment on the original code

	CLinePointsAccumelate.CPoints.SetSize(accumelate_size);

	int line_points_accumelate = 0;
	int line_points_to_add = 0;
	int q, r;

	long graph_points_size = CSignalX.max_points - CSignalX.min_points + 1;
	long graph_points_stop = 0, graph_points_start = 0;
	bool f_graph_points_start = false;

	if(!x_axis_type)
		CPointAtoB.CStartLocation.x = CSignalX.GetDataPoint(start_point, xtype, CSignalY.x_gain, CSignalY.x_offset);
	else
		CPointAtoB.CStartLocation.x = CSignalX.GetLogDataPoint(start_point, xtype, CSignalY.x_gain, CSignalY.x_offset);

	if(type == TE_SIGNAL_DISPLAY_MAGNITUDE || type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		if(!ym_axis_type)
			CPointAtoB.CStartLocation.y = m_object_height - CSignalY.GetDataPoint(start_point, type);
		else
			CPointAtoB.CStartLocation.y = m_object_height - CSignalY.GetLogDataPoint(start_point, type);
	}
	else
	{
		if(CSignalY.CPhaseData.CX.GetSize() != count) return false;

		if(!yp_axis_type)
			CPointAtoB.CStartLocation.y = m_object_height - CSignalY.GetDataPoint(start_point, type);
		else
			CPointAtoB.CStartLocation.y = m_object_height - CSignalY.GetLogDataPoint(start_point, type);
	}

	if(refresh) {CPointAtoB.CStartLocation.x += ref_x; CPointAtoB.CStartLocation.y += ref_y;}

	if(CSignalY.stop_point > count) CSignalY.stop_point = count;

	if(CSignalY.stop_point) count = CSignalY.stop_point;// realtime update modification

	int waveform_index = index - m_waveform_index_start;

	CArray <TCLineData,  TCLineData &> CWaveformLines;

	int p;

	for(p = start_point + 1; p < count; p++)// each signal can be offset and gained in both X and Y direction
	{
		if(!x_axis_type)
			x = CSignalX.GetDataPoint(p, xtype, CSignalY.x_gain, CSignalY.x_offset);
		else
			x = CSignalX.GetLogDataPoint(p, xtype, CSignalY.x_gain, CSignalY.x_offset);

		if(type == TE_SIGNAL_DISPLAY_MAGNITUDE || type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
		{
			if(!ym_axis_type)
				y = m_object_height - CSignalY.GetDataPoint(p, type);
			else
				y = m_object_height - CSignalY.GetLogDataPoint(p, type);
		}
		else
		{
			if(!yp_axis_type)
				y = m_object_height - CSignalY.GetDataPoint(p, type);
			else
				y = m_object_height - CSignalY.GetLogDataPoint(p, type);
		}

		if(refresh)
		{
			x += ref_x;
			y += ref_y;
		}

		//Ignore if next point is same as last
		if(x == CPointAtoB.CStartLocation.x && y == CPointAtoB.CStartLocation.y) continue;	

		CPointAtoB.CEndLocation.x = x;
		CPointAtoB.CEndLocation.y = y;
/*
		if(x - ref_x < 0 && y - ref_y < 0 &&
		   x - ref_x > m_object_width && y - ref_y > m_object_height &&
		   CPointAtoB.CStartLocation.x - ref_x < 0 && CPointAtoB.CStartLocation.y - ref_y < 0 && 
		   CPointAtoB.CStartLocation.x - ref_x > m_object_width && 
		   CPointAtoB.CStartLocation.y - ref_y > m_object_height) continue;

		if(!(x - ref_x < 0) && x - ref_x < graph_points_size)
		{
			if(!f_graph_points_start)
			{
				f_graph_points_start = true;

				graph_points_start = x - ref_x;
			}

			graph_points_stop = x - ref_x;

			CSignalX.GraphPointToMagDataIndex[x - ref_x] = p;
		}

		//if last and current points out of graph are, dont draw line to them
		if(x  - ref_x < 0 && CPointAtoB.CStartLocation.x - ref_x < 0 || x - ref_x > m_object_width && CPointAtoB.CStartLocation.x - ref_x > m_object_width ||
		   x - ref_x  < 0 && CPointAtoB.CStartLocation.x - ref_x > m_object_width || x - ref_x > m_object_width && CPointAtoB.CStartLocation.x - ref_x < 0)
		{
			CPointAtoB.CStartLocation = CPointAtoB.CEndLocation;

			continue;
		} 
 
		if(y - ref_y < 0 && CPointAtoB.CStartLocation.y - ref_y < 0 || y - ref_y > m_object_height && CPointAtoB.CStartLocation.y - ref_y > m_object_height ||
		   y - ref_y < 0 && CPointAtoB.CStartLocation.y - ref_y > m_object_height || y - ref_y > m_object_height && CPointAtoB.CStartLocation.y - ref_y < 0)
		{
			CPointAtoB.CStartLocation = CPointAtoB.CEndLocation;

			continue;
		}
*/
		CLastPoint = CPointAtoB.CEndLocation;

		//added  26th May 2003 for intended cdc.drawline()
		if(!CPointAtoB.Clip(CLocation, m_object_width, m_object_height)) 
		{
			CPointAtoB.CStartLocation = CPointAtoB.CEndLocation;

			continue;
		}

		if(!(x - ref_x < 0) && x - ref_x < graph_points_size)
		{
			if(!f_graph_points_start)
			{
				f_graph_points_start = true;

				graph_points_start = x - ref_x;
			}

			graph_points_stop = x - ref_x;

			CSignalX.GraphPointToMagDataIndex[x - ref_x] = p;
		}

		if(0)// new code to be debuged  // to be added 26th May 2003 for intended cdc.drawline()
		{
			CWaveformLines.Add(CPointAtoB);
		}

		CPointAtoB.FormatLinePoints();

		line_points_to_add = CPointAtoB.CPoints.GetSize();

		while(!((line_points_to_add + line_points_accumelate) < accumelate_size))
		{
			accumelate_size *= 2;

			CLinePointsAccumelate.CPoints.SetSize(accumelate_size);
		}

		for(q = line_points_accumelate, r = 0; r < line_points_to_add; q++, r++) 
		{
			CLinePointsAccumelate.CPoints[q] = CPointAtoB.CPoints[r];
		}

		line_points_accumelate += line_points_to_add;

		CPointAtoB.CStartLocation = CLastPoint;//CPointAtoB.CEndLocation;
	}

	if(!line_points_accumelate) return false;

	CLinePointsAccumelate.CPoints.SetSize(line_points_accumelate);

	TCDrawLineData CTestPoint;

	count = CLinePointsAccumelate.CPoints.GetSize();

	CLinePoints.CPoints.SetSize(count);// create space

	int points_counter = 0;

	for(p = 0; p < count; p++)// Clip waveform ponts out of graph area // now already cliped 26th May
	{
		CTestPoint.CLocation = CLinePointsAccumelate.CPoints[p].CLocation;
/*
		x = CTestPoint.CLocation.x;
		y = CTestPoint.CLocation.y;

		if(x - ref_x < 0) continue; 
		if(y - ref_y < 0) continue;
		if(x - ref_x > m_object_width) continue;
		if(y - ref_y > m_object_height) continue;*/

		CLinePoints.CPoints[points_counter] = CTestPoint;

		points_counter++;
	}

	if(0)
	{
		TCWaveFormDrawData CWaveFormDrawData;

		CWaveFormDrawData = CWaveformLines;

		CMWaveFormDrawData.SetAtGrow(waveform_index, CWaveFormDrawData);
	}

	if(!refresh) 
	{
		CLinePoints.CPoints.SetSize(points_counter);// delete space, need to remove for realtime addition

		CLinePoints.start_point = 0; //Clear for normal data
		CLinePoints.stop_point	= (int) (CSignalY.graphic_stop_point * m_zoom);
	}
	else CLinePoints.stop_point = points_counter;// realtime addition

	if(!refresh) CMDrawLineData.SetAtGrow(index, CLinePoints);
	else
	{
		if(index < CMDrawLineData.GetSize())
		{
			TCLineData &CExistingLineData = CMDrawLineData[index];

			CExistingLineData += CLinePoints;// this will set up all stops and starts
		}

		else CMDrawLineData.SetAtGrow(index, CLinePoints);//should not happen as prior allocated

		CSignalY.start_point = CSignalY.stop_point - 1;// need to make sure end point is drawn
		CSignalY.graphic_stop_point = (int) (CMDrawLineData[index].stop_point / m_zoom);
	}

	CSignalX.FormatGraphPointToMagDataIndex(graph_points_start, graph_points_stop + 1);

	return true;
}

// This function is going to be mofified to look for nearest waveform
bool TCSchematicObject::GetWaveformData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, bool ignor_auto_axis)
{
	if(!PCWaveformDataRuns) return false;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals) return true;

	if(!CheckAndNullWaveformDataPointers())
	{
		return false; 
	}

	int run_count = PCWaveformDataRuns->CRuns.GetSize();
	if(!run_count) return false;

	CArray <TCSignal, TCSignal &> &CSignals = *CMSchematicObjectData.PCOutputWaveformDataHeader->PCSignals;

	int count = CSignals.GetSize();
 
	if(count < 2) return false;

	int index = m_waveform_index_start;// indexs all waveforms, for all runs after axis

	int draw_line_data_size = CMDrawLineData.GetSize(); 
	
	if(!(index < draw_line_data_size))
	{
		ASSERT(0);

		return false;
	}

	int axis_index = CMSchematicObjectData.PCOutputWaveformDataHeader->axis_index;

	if(!(axis_index < count)) return false;

	CFloatingCursorData.PCGraphData			= &CMDrawLineData;
	CFloatingCursorData.graph_start_index	= m_waveform_index_start;

	int xindex;

// This fuction looks for nearest y value to an x point and then the nearest x to a y point

	int record_waveform_index  = m_waveform_index;

	for(int q = 0; q < run_count; q++)
	{ 
		TCOutputWaveformData *PCOutputWaveformData =  PCWaveformDataRuns->CRuns[q];

		if(!PCOutputWaveformData) return false;

//		if(PCWaveformDataRuns->CMathFunctionDataList[0].calculator_enabled)
//			record_waveform_index = E_SPICE_RECORD_MATH_0;

		if(!(record_waveform_index < PCOutputWaveformData->CRecords.GetSize())) return false; 


		CArray<class TCDisplayedSignals,class TCDisplayedSignals &> *PCDisplayedSignalList;

		PCDisplayedSignalList = &PCOutputWaveformData->CRecords[record_waveform_index].CHeader.CDisplayedSignalsList;

//		11 April 2003, attempt to get individual graphs 
		if(run_count == 1)
			PCDisplayedSignalList = &CMSchematicObjectData.PCOutputWaveformDataHeader->CDisplayedSignalsList;

		count = PCDisplayedSignalList->GetSize();

		for(int p = 0; p < count; p++)
		{
			CFloatingCursorData.run_index		= q;
			CFloatingCursorData.type			= CMSchematicObjectData.PCOutputWaveformDataHeader->type;
			CFloatingCursorData.axis_index		= CMSchematicObjectData.PCOutputWaveformDataHeader->axis_index;
			CFloatingCursorData.signal_index	= (*PCDisplayedSignalList)[p].index1;
			CFloatingCursorData.signal_type		= (*PCDisplayedSignalList)[p].type;	
			CFloatingCursorData.PCSignalY		= (*PCDisplayedSignalList)[p].PCSignal1;
			CFloatingCursorData.PCSignalX		= (*PCDisplayedSignalList)[p].PCSignalX;

			if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_MAGNITUDE || 
				CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
			{
				CFloatingCursorData.signal_type = TE_SIGNAL_DISPLAY_MAGNITUDE;

				xindex = CMDrawLineData[index].FindXIndex(CLocation.x, 0);

				if(xindex > -1) 
				{
					if(GetYSignalData(CFloatingCursorData, CLocation, index,  xindex)) 
					{
						CFloatingCursorData.xindex = xindex;

						if(ignor_auto_axis)
							CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index = CFloatingCursorData.signal_index;
						else if(GCSuperSpiceGlobalData.CWaveformData.auto_axis)
							CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index = CFloatingCursorData.signal_index;

						return true;
					}
					else
					{
						xindex = CMDrawLineData[index].FindYXIndex(CLocation, GCSuperSpiceGlobalData.CWaveformData.resolution);
					
						if(xindex > -1)
						if(GetXSignalData(CFloatingCursorData, CLocation, index, xindex))
						{
							CFloatingCursorData.xindex = xindex;

							if(ignor_auto_axis)
								CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index = CFloatingCursorData.signal_index;

							else if(GCSuperSpiceGlobalData.CWaveformData.auto_axis)
								CMSchematicObjectData.PCOutputWaveformDataHeader->active_magnitude_axis_index = CFloatingCursorData.signal_index;

							return true;
						}
					}
				}
			}

			if(CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_PHASE_DEG || 
				CFloatingCursorData.signal_type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
			{
				CFloatingCursorData.signal_type = TE_SIGNAL_DISPLAY_PHASE_DEG;

				xindex = CMDrawLineData[index].FindXIndex(CLocation.x, 0);
//				xindex = CMDrawLineData[index].FindXYIndex(CLocation, GCSuperSpiceGlobalData.CWaveformData.resolution);

				if(xindex > -1) 
				{
					if(GetYSignalData(CFloatingCursorData, CLocation, index, xindex))
					{
						CFloatingCursorData.xindex = xindex;

						if(ignor_auto_axis)
							CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index = CFloatingCursorData.signal_index;
						else if(GCSuperSpiceGlobalData.CWaveformData.auto_axis)
							CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index = CFloatingCursorData.signal_index;

						return true;
					}
					else
					{
//						xindex = CMDrawLineData[index].FindYIndex(CLocation.y, 0);
						xindex = CMDrawLineData[index].FindYXIndex(CLocation, GCSuperSpiceGlobalData.CWaveformData.resolution);
					
						if(xindex > -1)
						if(GetXSignalData(CFloatingCursorData, CLocation, index, xindex))
						{
							CFloatingCursorData.xindex = xindex;

							if(ignor_auto_axis)
								CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index = CFloatingCursorData.signal_index;
							else if(GCSuperSpiceGlobalData.CWaveformData.auto_axis)
								CMSchematicObjectData.PCOutputWaveformDataHeader->active_phase_axis_index = CFloatingCursorData.signal_index;

							return true;
						}
					}
				}
			}
			index++;

			if(!(index < draw_line_data_size)) return false;
		}
	}

	return false;
}

bool TCSchematicObject::GetSignalData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, int wave_index, int index, int is_xindex)
{
	if(is_xindex) return GetYSignalData(CFloatingCursorData, CLocation, wave_index, index);
	
	return GetXSignalData(CFloatingCursorData, CLocation, wave_index, index);
}

bool TCSchematicObject::GetYSignalData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, int wave_index, int xindex)
{
	CPoint CTest;

	long y = CLocation.y;

	CFloatingCursorData.delta_y = y;
 
	if(!CMDrawLineData[wave_index].GetValueY(xindex, y, GCSuperSpiceGlobalData.CWaveformData.resolution)) return false;

	// to reposition box on waveform line;
	CFloatingCursorData.delta_y = CFloatingCursorData.delta_y - y;

	CLocation.y = y;

	CLocation = CLocation - CMLocation;// now normalise

	CLocation.y = m_object_height - CLocation.y;

	CFloatingCursorData.CSignalLocation = CLocation;
	CFloatingCursorData.is_xindex		= false;

	return PCWaveformDataRuns->GetData(CFloatingCursorData);
}

bool TCSchematicObject::GetXSignalData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, int wave_index, int yindex)
{
	CPoint CTest;

	long x = CLocation.x;

	CFloatingCursorData.delta_x = x;
 
	if(!CMDrawLineData[wave_index].GetValueX(yindex, x, GCSuperSpiceGlobalData.CWaveformData.resolution)) return false;

	// to reposition box on waveform line;
	CFloatingCursorData.delta_x = CFloatingCursorData.delta_x - x;

	CLocation.x = x;

	CLocation = CLocation - CMLocation;// now normalise

	CLocation.x = CLocation.x;
	CLocation.y = m_object_height - CLocation.y;

	CFloatingCursorData.CSignalLocation = CLocation;
	CFloatingCursorData.is_xindex = true;

	return PCWaveformDataRuns->GetData(CFloatingCursorData);
}

bool TCSchematicObject::CreateWaveformLabels(CDC *PCViewDC)
{
	CreateLabels(PCViewDC);

	return true;
}

bool TCSchematicObject::CreateWaveformPins(CDC *PCViewDC)
{
	// this is very poor code. pin object uses global data so need to set up here
	//as each waveform can be different size;

	CreatePins(PCViewDC);// pin 1 is window sizing pin 
	
	GCSuperSpiceDataBase.SetWaveFormDefaultSize(m_local_width, m_local_height);

	return true;
}

void TCSchematicObject::DrawBackground(CDC *PCViewDC, CPoint CLocation)
{
	if(m_property != E_WAVEFORM_OBJECT) return;

	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;
	
	if(!PCViewDC) return;	

	CRect CBackground(0, 0, m_object_width, m_object_height);

	CBackground += CLocation;

	ClearScreen(PCViewDC, CBackground, CMSchematicObjectData.PCOutputWaveformDataHeader->background_colour);

	DrawGrid(PCViewDC, CLocation);
}

void TCSchematicObject::DrawGrid(CDC *PCViewDC, CPoint CLocation)
{
	if(!PCViewDC) return;
	if(m_property != E_WAVEFORM_OBJECT) return;
	if(!CMSchematicObjectData.PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

	COLORREF colour = CHeader.grid_colour;

	CPoint CStart = CMLocation;

	int x_size	= CHeader.x_major_grid_size;	
	int y_size	= CHeader.y_major_grid_size;

	x_size = (int)(x_size * m_zoom);
	y_size = (int)(y_size * m_zoom);

	register int x_count = CHeader.x_major_grid_number;
	register int y_count = CHeader.y_major_grid_number;

	int	ix, iy;

	ix =  CLocation.x;
	iy =  CLocation.y;

	register int next_x = ix;
	register int next_y = m_object_height + iy;

	int p, q;
	
	HDC h_dc = PCViewDC->m_hDC;
	
	for(p = 0; p < x_count; p++)
	{
		next_y = m_object_height + iy;

		for(q = 0; q < y_count; q++)
		{
			SetPixel(h_dc, next_x, next_y, colour);

			next_y -= (int) y_size;
		}

		next_x += x_size;
	}
}


bool TCSchematicObject::CreateLabels(CDC *PCViewDC)
{
	CString CText;

	int count = CMSchematicObjectData.CLabelListData.GetSize();

	if(count < 0)
	{
		ASSERT(0);

		return false;
	}

	CMLabelListObject.SetSize(count, count);

	for(int p = 0; p < count; p++)
	{
		CText = CMSchematicObjectData.CLabelListData[p].CLabel;

		CMLabelListObject[p].DeleteBitmapNew();
		CMLabelListObject[p].m_property = E_SCHEMATIC_LABEL;

		if(CMSchematicObjectData.CLabelListData[p].is_visable)

			if(!CMLabelListObject[p].Create(PCViewDC, CText, m_zoom, 
									GCSuperSpiceGlobalData.CColorData.component_text_normal,
									GCSuperSpiceGlobalData.CColorData.component_text_selected, 
									GCSuperSpiceGlobalData.CColorData.component_text_highlighted)) continue;

		CMLabelListObject[p].SetProperty(E_SCHEMATIC_LABEL);

		CMLabelListObject[p].m_visable = CMSchematicObjectData.CLabelListData[p].is_visable;
	}

	if(m_type == E_WIRE_COMPONENT)
	{
		CMLabelListObject[E_WIRE_NET_CONNECTION_DOT1].m_type = 666;
		CMLabelListObject[E_WIRE_NET_CONNECTION_DOT2].m_type = 666;
	}

	return true;
}

bool TCSchematicObject::CreatePins(CDC *PCViewDC)
{
	if(m_type == E_WIRE_COMPONENT) 
	{
		CreateWirePins(PCViewDC);

		return true;
	}

	int count = CMSchematicObjectData.CPinListData.GetSize();

	CMPinListObject.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CMPinListObject[p].Create(PCViewDC, CMSchematicObjectData.CPinListData[p], m_zoom, m_rotation_state, m_mirror_state);

		CMPinListObject[p].m_visable = CMSchematicObjectData.CPinListData[p].is_visable;

		CMPinListObject[p].is_symbol_editor = is_symbol_editor;
	}

	return true;
}


int TCSchematicObject::IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CPoint CLocation, bool fine)
{
	int result;

	if(!CSchematicComponentInfo) return 0;

	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		if(m_type == E_WIRE_COMPONENT)
		{
			if(p == E_WIRE_NET_CONNECTION_DOT1 || p == E_WIRE_NET_CONNECTION_DOT2) continue;
		}

		result = CMLabelListObject[p].IsThere(CLocation, fine);

		if(result) 
		{
			CSchematicComponentInfo->type		= E_SCHEMATIC_LABEL;
			CSchematicComponentInfo->label_id	= p;
			CSchematicComponentInfo->CText		=
			CMSchematicObjectData.CLabelListData[p].CLabel;

			return true;
		}
	}

	count = CMPinListObject.GetSize();

	for(p = 0; p < count; p++)
	{
		CSchematicComponentInfo->type = E_SCHEMATIC_PIN;

		result = CMPinListObject[p].IsThere(CSchematicComponentInfo, CLocation, fine);

		if(result)
		{
			CSchematicComponentInfo->pin_id = p;

			return true;
		}
	}

	if(TCGraphicBitMapVectorObject::IsThere(CLocation, fine)) 
	{
		CSchematicComponentInfo->type = m_property;

		return true;
	}

	if(m_property == E_WAVEFORM_OBJECT)// finer detail
	{
		CRect CScreenSize;

		CScreenSize.top		= CMLocation.y;
		CScreenSize.left	= CMLocation.x;
		CScreenSize.bottom	= CMLocation.y + m_object_height+ 1;// 1 added to get end point of waveform
		CScreenSize.right	= CMLocation.x + m_object_width + 1;// 1 added to get end point of waveform

		if(CScreenSize.PtInRect(CLocation)) 
		{
			CSchematicComponentInfo->type = E_WAVEFORM_OBJECT_SCREEN;

			return true;
		}
	}

	return false;
}

CRect TCSchematicObject::GetPinGrabRegion(int pin)
{	// no checking for speed in netlisting to be added
	CRect CDummy(0, 0, 0, 0);

	if(pin >= CMPinListObject.GetSize()) 
	{
		return CDummy;
	}
	return CMPinListObject[pin].CMRectGrabLocationRegion;
}

void TCSchematicObject::CreateGrabRegion(CPoint CLocation)
{
	if(m_type) //new bit added 26th April 2003
	{
		TCGraphicBitMapVectorObject::CreateGrabRegion(CLocation);

		return; 
	}

	//new bits added 26th April 2003
	if(!CMSchematicObjectData.IsStraightVectorsOnly()) 
	{
		TCGraphicBitMapVectorObject::CreateGrabRegion(CLocation);

		return;
	}

	//This overides symbol editor created components to fix grab region.
	// After a paste this is called
	int count = CMDrawLineData.GetSize();
	int x_min, x_max, y_min, y_max;

	if(!count) return;
	
	int points = CMDrawLineData[0].CPoints.GetSize();

	if(points < 1) return;

	x_min = CMDrawLineData[0].CPoints[0].CLocation.x;
	x_max = x_min;

	y_min = CMDrawLineData[0].CPoints[0].CLocation.y;
	y_max = y_min;

	for(int p = 0; p < count; p++)
	{
		TCLineData &CLineData = CMDrawLineData[p];

		points = CLineData.CPoints.GetSize();

		if(points < 1) continue;

		points--;

		CPoint &CPointL0 = CLineData.CPoints[0].CLocation;
		CPoint &CPointLM = CLineData.CPoints[points].CLocation;

		if(CPointL0.x > x_max) x_max = CPointL0.x;
		if(CPointLM.x > x_max) x_max = CPointLM.x;

		if(CPointL0.x < x_min) x_min = CPointL0.x;
		if(CPointLM.x < x_min) x_min = CPointLM.x;

		if(CPointL0.y > y_max) y_max = CPointL0.y;
		if(CPointLM.y > y_max) y_max = CPointLM.y;

		if(CPointL0.y < y_min) y_min = CPointL0.y;
		if(CPointLM.y < y_min) y_min = CPointLM.y;
	}

	CMRectGrabLocationRegion.left	= x_min;
	CMRectGrabLocationRegion.top	= y_min;
	CMRectGrabLocationRegion.right	= x_max + 1;
	CMRectGrabLocationRegion.bottom = y_max + 1;
}

CRect TCSchematicObject::GetComponentExtent(void)
{
	CRect CRectangleExtent;
	CRect CNewRectangleExtent;
	CRect CTestRectangleExtent;

	int w, h;

	h = m_object_height;
	w = m_object_width;

	CRectangleExtent = CMRectGrabLocationRegion;// main component

	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)// labels
	{
		CTestRectangleExtent = CRectangleExtent;
		CNewRectangleExtent  = CMLabelListObject[p].CMRectGrabLocationRegion;

		CRectangleExtent.UnionRect(&CNewRectangleExtent, &CTestRectangleExtent);
	}

	count = CMPinListObject.GetSize();
	
	int q, label_count;

	for(p = 0; p < count; p++)
	{
		label_count = CMPinListObject[p].CMLabelListObject.GetSize();

		for(q = 0; q < label_count; q++)// pins accounted for already
		{
			CTestRectangleExtent = CRectangleExtent;

			CNewRectangleExtent  = CMPinListObject[p].CMLabelListObject[q].CMRectGrabLocationRegion;

			CRectangleExtent.UnionRect(&CNewRectangleExtent, &CTestRectangleExtent);
		}
	}

	return CRectangleExtent;
}

CRect TCSchematicObject::GetGrabRegion(TCSchematicComponentInfo &CSchematicComponentInfo)
{
	CRect CGrabRegion(0, 0, 0,0);

	int pin_id		= CSchematicComponentInfo.pin_id;
	int label_id	= CSchematicComponentInfo.label_id;

	switch(CSchematicComponentInfo.type)
	{
		case E_SCHEMATIC_OBJECT: return CMRectGrabLocationRegion;
		case E_SCHEMATIC_WIRE: return CMRectGrabLocationRegion;
		case E_SCHEMATIC_TEXT_LABEL: return CMRectGrabLocationRegion;
		case E_SCHEMATIC_BITMAP:     return CMRectGrabLocationRegion;

		case E_SCHEMATIC_LABEL: 
		{
			if(!(label_id < CMLabelListObject.GetSize()))
			{	
				ASSERT(0);
				return CGrabRegion;
			}
			return CMLabelListObject[label_id].CMRectGrabLocationRegion;
		}
		case E_SCHEMATIC_PIN: 
		{
			if(!(pin_id < CMPinListObject.GetSize()))
			{
				ASSERT(0);
				return CGrabRegion;
			}
			return CMPinListObject[pin_id].CMRectGrabLocationRegion;
		}
		case E_SCHEMATIC_PIN_LABEL: 	
		{
			if(!(pin_id < CMPinListObject.GetSize()))
			{
				ASSERT(0);
				return CGrabRegion;
			}
			if(!(label_id < CMPinListObject[pin_id].CMLabelListObject.GetSize()))
			{	
				ASSERT(0);
				return CGrabRegion;
			}
			return CMPinListObject[pin_id].CMLabelListObject[label_id].CMRectGrabLocationRegion;
		}

		default: return CMRectGrabLocationRegion;
	}
}

int TCSchematicObject::IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CRect CLocation, bool all_enclosed, bool ignor_pins)
{
	int result;

	if(!CSchematicComponentInfo) return 0;

	if(TCGraphicBitMapVectorObject::IsThere(CLocation, all_enclosed)) 
	{
		CSchematicComponentInfo->type = m_property;

		return true;
	}

	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		TCGraphicBitMapVectorObject &CGraphicBitMapVectorObject = CMLabelListObject[p];

		TCGraphicObjectData &CGraphicObjectData = CMSchematicObjectData.CLabelListData[p];

		result = CGraphicBitMapVectorObject.IsThere(CLocation, all_enclosed);


		if(result) 
		{
					if(p == E_GENERATOR_PHASE_VALUE)
		{
			CGraphicObjectData.is_visable = CGraphicObjectData.is_visable;
		}
			CSchematicComponentInfo->type		= E_SCHEMATIC_LABEL;
			CSchematicComponentInfo->label_id	= p;
			CSchematicComponentInfo->CText		=
			CGraphicObjectData.CLabel;

			return true;
		}
	}

	count = CMPinListObject.GetSize();

	if(!ignor_pins) // pins are inherantly whithin the selection box
	{
		for(p = 0; p < count; p++)
		{
			CSchematicComponentInfo->type = E_SCHEMATIC_PIN;

			result = CMPinListObject[p].IsThere(CSchematicComponentInfo, CLocation, all_enclosed);

			if(result)
			{
				CSchematicComponentInfo->pin_id = p;

				return true;
			}
		}
	}

	return false;
}

int TCSchematicObject::PinIsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CRect CLocation, bool all_enclosed)
{
	int result;

	if(!CSchematicComponentInfo) return 0;

	int count = CMPinListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CSchematicComponentInfo->type = E_SCHEMATIC_PIN;

		result = CMPinListObject[p].IsThere(CSchematicComponentInfo, CLocation, all_enclosed);

		if(result)
		{
			CSchematicComponentInfo->pin_id = p;

			return true;
		}
	}
	return false;
}

int TCSchematicObject::GetNumberOfLabels(void)
{
	return CMLabelListObject.GetSize();
}
int TCSchematicObject::GetNumberOfPinLabels(int pin_id)
{
	if(pin_id >= CMPinListObject.GetSize()) return 0;

	return CMPinListObject[pin_id].CMLabelListObject.GetSize();
}
int TCSchematicObject::GetNumberOfPins(void)
{
	return CMPinListObject.GetSize();
}

CRect TCSchematicObject::GetLabelLocation(int label_id)
{
	if(label_id >= CMLabelListObject.GetSize())
	{
		ASSERT(0);
		return 0;
	}
	return CMLabelListObject[label_id].CMRectGrabLocationRegion;
}

CRect TCSchematicObject::GetPinLabelLocation(int pin_id, int label_id)
{
	if(pin_id >= CMPinListObject.GetSize())
	{
		ASSERT(0);
		return 0;
	}

	if(label_id >= CMPinListObject[pin_id].CMLabelListObject.GetSize())
	{
		ASSERT(0);
		return 0;;
	}
	return CMPinListObject[pin_id].CMLabelListObject[label_id].CMRectGrabLocationRegion;
}

void TCSchematicObject::SetSelect(void)
{
	TCGraphicBitMapVectorObject::SetSelect();

	int count1 = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count1; p++)
	{
		CMLabelListObject[p].SetHighlight();
	}

	count1 = CMPinListObject.GetSize();

	for(p = 0; p < count1; p++)
	{
		CMPinListObject[p].ResetSelect();

		int count2 = CMPinListObject[p].CMLabelListObject.GetSize();

		for(int q = 0; q < count2; q++)
		{
			CMPinListObject[p].CMLabelListObject[q].SetHighlight();
		}
	}
}
void TCSchematicObject::SetHighlighted(void)
{
	TCGraphicBitMapVectorObject::SetHighlight(true);
}
void TCSchematicObject::ResetSelect(void)
{

	TCGraphicBitMapVectorObject::ResetSelect();

	int count1 = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count1; p++)
	{
		CMLabelListObject[p].ResetSelect();
	}

	count1 = CMPinListObject.GetSize();

	for(p = 0; p < count1; p++)
	{
		CMPinListObject[p].ResetSelect();

		int count2 = CMPinListObject[p].CMLabelListObject.GetSize();

		for(int q = 0; q < count2; q++)
		{
			CMPinListObject[p].CMLabelListObject[q].ResetSelect();
		}
	}
}

bool TCSchematicObject::GetSelect(void)
{
	return m_selected;
}

bool TCSchematicObject::GetHighlight(void)
{
	if(TCGraphicBitMapVectorObject::m_highlighted) return true;

	return IsLabelOrPinLabelOrPinHighlighted();
}

bool TCSchematicObject::IsLabelOrPinLabelOrPinSelected(void)
{
	if(IsLabelSelected()) return true;
	if(IsPinSelected()) return true;
	if(IsPinLabelSelected()) return true;

	return false;
}
bool TCSchematicObject::IsLabelSelected(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count = CMLabelListObject.GetSize();

	PCGraphicObject = CMLabelListObject.GetData();

	for(int p = 0; p < count; p++)
	{
		if(PCGraphicObject->m_selected) return true;

		PCGraphicObject++;
	}

/*	for(int p = 0; p < count; p++)
	{
		if(CMLabelListObject[p].m_selected) return true;
	}*/

	return false;
}

bool TCSchematicObject::IsPinSelected(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count = CMPinListObject.GetSize();

	PCGraphicObject = CMPinListObject.GetData();

	for(int p = 0; p < count; p++)
	{
		if(PCGraphicObject->m_selected) return true;

		PCGraphicObject++;
	}

	return false;
}
bool TCSchematicObject::IsPinLabelSelected(void)
{
	register TCGraphicBitMapVectorObject *PCPinLabelGraphicObject;
	register TCSchematicPinObject *PCPinGraphicObject;
	register int count1 = CMPinListObject.GetSize();
	register int q;
	register int count2;
	register int p;

	PCPinGraphicObject = CMPinListObject.GetData();

	for(p = 0; p < count1; p++)
	{
		count2 = PCPinGraphicObject->CMLabelListObject.GetSize();

		PCPinLabelGraphicObject = PCPinGraphicObject->CMLabelListObject.GetData();

		for(q = 0; q < count2; q++)
		{
			if(PCPinLabelGraphicObject->m_selected) return true;
			
			PCPinLabelGraphicObject++;
		}

		PCPinGraphicObject++;
	}
	return false;
}
bool TCSchematicObject::GetLabelOrPinLabelLocation(CPoint *CLocation)
{

	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		if(CMLabelListObject[p].m_selected) 
		{
			CMLabelListObject[p].GetLocation(CLocation); 
			return true;
		}
	}

	count = CMPinListObject.GetSize();

	for(p = 0; p < count; p++)
	{
		int count2 = CMPinListObject[p].CMLabelListObject.GetSize();

		for(int q = 0; q < count2; q++)
		{
			if(CMPinListObject[p].CMLabelListObject[q].m_selected)
			{
				CMPinListObject[p].CMLabelListObject[q].GetLocation(CLocation);

				return true;
			}
		}
	}

	count = CMPinListObject.GetSize();

	for(p = 0; p < count; p++)
	{
		if(CMPinListObject[p].m_selected)
		{
			CMPinListObject[p].GetLocation(CLocation);

			return true;
		}
	}
	return false;
}
bool TCSchematicObject::IsLabelOrPinLabelOrPinHighlighted(void)
{
	if(IsLabelHighlighted()) return true;
	if(IsPinHighlighted()) return true;
	if(IsPinLabelHighlighted()) return true;

	return false;
}
bool TCSchematicObject::IsLabelHighlighted(void)
{
	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CMLabelListObject[p].m_highlighted) return true;
	}

	return false;
}
bool TCSchematicObject::IsPinHighlighted(void)
{
	int count = CMPinListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CMPinListObject[p].m_highlighted) return true;
	}

	return false;
}
bool TCSchematicObject::IsPinLabelHighlighted(void)
{
	int count = CMPinListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CMPinListObject[p].m_highlighted) return true;
	}

	return false;
}
bool TCSchematicObject::Paste(CDC *PCDC, CPoint CLocation, bool hyde_labels)
{
	if(m_property == E_WAVEFORM_OBJECT) DrawBackground(PCDC, CLocation);

	TCGraphicBitMapVectorObject::Paste(PCDC, CLocation, m_zoom, true);

	CPoint CLocationOffset;

	int count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		CMPinListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), CMPinListObject[p].m_visable, hyde_labels);
	}

	count = CMLabelListObject.GetSize();

	int lable_list_count = CMSchematicObjectData.CLabelListData.GetSize();// added 10th Jan 2003 bug fix

	if(lable_list_count == count)// added 10th Jan 2003 bug fix
	for(int p = 0; p < count; p++)
	{
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		CMLabelListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable && !hyde_labels);
		
	}

	if(!m_type) CreateGrabRegion(CLocation); //new bit added 26th April 2003

	return true;
}

void TCSchematicObject::RePasteSingleLabel(CDC *PCViewDC, int id)
{
	if(!(id < CMLabelListObject.GetSize())) return;

	CPoint CLocationOffset;

	if(!CMSchematicObjectData.CLabelListData[id].CLocations_Mirror.GetSize())
		CLocationOffset = CMSchematicObjectData.CLabelListData[id].CLocation;
	else
		CLocationOffset = CMSchematicObjectData.CLabelListData[id].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
	CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
	CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

	CMLabelListObject[id].Paste(PCViewDC, (CPoint)(CMLocation + CLocationOffset), m_zoom, CMLabelListObject[id].m_visable);
}

bool TCSchematicObject::Print(CDC *PCDC)
{
	CPoint CLocation;

	CLocation.x = 0;
	CLocation.y = 0;

	int width = CMRectGrabLocationRegion.Width() + 1;
	int height = CMRectGrabLocationRegion.Height() + 1;

	if(m_rotation_state == E_FIRST_QUADRANT || m_rotation_state == E_THIRD_QUADRANT)
	{
		width  += CMSchematicObjectData.CGrabOffset.x;
		height += CMSchematicObjectData.CGrabOffset.y;

		CLocation = - CMSchematicObjectData.CLocationOffset;
	}
	else
	{
		width  += CMSchematicObjectData.CGrabOffset.y;
		height += CMSchematicObjectData.CGrabOffset.x;

		CLocation.x = - CMSchematicObjectData.CLocationOffset.y;
		CLocation.y = - CMSchematicObjectData.CLocationOffset.x;
	}

	CBitmap CBitMap;

	if(!CBitMap.CreateBitmap(width, height, global_screen_planes, global_screen_bitspixels,  NULL)) return false;

	HGDIOBJ oldobject = GlobalCDCTemp.SelectObject(CBitMap);// create mem in DC

	if(!oldobject) return false;
////////Clear
	CBrush CBackgroundBrush(GCSuperSpiceGlobalData.CColorData.background);
 
	CBrush* pOldBrush = GlobalCDCTemp.SelectObject(&CBackgroundBrush);
 
	GlobalCDCTemp.PatBlt(0, 0, width, height, PATCOPY);
	
	GlobalCDCTemp.SelectObject(pOldBrush);

	CBackgroundBrush.DeleteObject();
//////

	Print(&GlobalCDCTemp, CLocation);

	GlobalCDCTemp.SelectObject(oldobject);

	PrintBitmap(PCDC, CBitMap, CMLocation.x + CLocation.x, CMLocation.y + CLocation.y);

	CBitMap.DeleteObject();

	PrintLabels(PCDC);

	return true;
}

bool TCSchematicObject::VectorPrint(CDC *PCDC)
{
	return VectorPrint(PCDC, CMLocation);
}

bool TCSchematicObject::BitmapPrint(CDC *PCDC)
{
	return BitmapPrint(PCDC, CMLocation);
}

bool TCSchematicObject::BitmapPrint(CDC *PCDC, CPoint CLocation)
{
	if(m_visable) TCGraphicBitMapVectorObject::BitmapPrint(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].BitmapPrint(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));	
	}

	return true;
}

bool TCSchematicObject::VectorPrint(CDC *PCDC, CPoint CLocation)
{
	if(m_visable) TCGraphicBitMapVectorObject::Print(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].VectorPrint(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));	
	}

	return true;
}

bool TCSchematicObject::PrintLabels(CDC *PCDC)
{
	CPoint CLocationOffset;

	int count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].PrintLabels(PCDC, (CPoint)(CMLocation + CLocationOffset));
	}

	count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CMLocation + CLocationOffset));	
	}

	return true;
}

bool TCSchematicObject::Print(CDC *PCDC, CPoint CLocation)
{
	if(m_visable) TCGraphicBitMapVectorObject::Print(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));
	}
/*
	count = CMLabelListObject.GetSize();

	for(p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));	
	}*/

	return true;
}



bool TCSchematicObject::RePaste(CDC *PCDC, CPoint CLocation)
{
	if(m_visable) 
	{
		if(m_property == E_WAVEFORM_OBJECT) DrawBackground(PCDC, CLocation);

		TCGraphicBitMapVectorObject::RePaste(PCDC, CLocation);
	}

	CPoint CLocationOffset;

	int count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].RePaste(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	count = CMLabelListObject.GetSize();

	int lable_list_count = CMSchematicObjectData.CLabelListData.GetSize();// added 10th Jan 2003 bug fix

	if(lable_list_count == count)// added 10th Jan 2003 bug fix
	for(int p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].RePaste(PCDC, (CPoint)(CLocation + CLocationOffset));	
	}

	return true;
}
void TCSchematicObject::StartMoveTo(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register TCSchematicPinObject *PCSchematicPinObject;
	register int count;
	register int p;

	count = CMPinListObject.GetSize();

	PCSchematicPinObject = CMPinListObject.GetData();

	for(p = 0; p < count; p++)
	{ 
		if(PCSchematicPinObject->m_visable)
			PCSchematicPinObject->StartMoveTo();

		PCSchematicPinObject++;
	}
		
	count = CMLabelListObject.GetSize();

	PCGraphicObject = CMLabelListObject.GetData();

	for(p = 0; p < count; p++)
	{ 
		if(PCGraphicObject->m_visable)
			PCGraphicObject->CreateBitmapBackgroundLabel(); 

		PCGraphicObject++;
	}
}
void TCSchematicObject::EndMoveTo(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register TCSchematicPinObject *PCSchematicPinObject;
	register int count;
	register int p;

	count = CMPinListObject.GetSize() - 1;
	PCSchematicPinObject = CMPinListObject.GetData();
	PCSchematicPinObject = PCSchematicPinObject + count;
	
#ifdef _DEBUG// incase I forget

	if(count > 255)//debuging
	{
		ASSERT(0);

		return;
	}
#endif
	for(p = count; p >= 0 ; p--)
	{
		if(PCSchematicPinObject->m_visable)
			PCSchematicPinObject->EndMoveTo();

		PCSchematicPinObject--;
	}

	count = CMLabelListObject.GetSize() - 1;

	PCGraphicObject = CMLabelListObject.GetData();
	PCGraphicObject = PCGraphicObject + count;

	for(p = count; p >= 0; p--)
	{
		if(PCGraphicObject->m_visable)
			PCGraphicObject->CBitmapBackground.DeleteObject(); 

		PCGraphicObject--;
	}
}
bool TCSchematicObject::MoveTo(CDC *PCDC, CPoint CLocation, int snap_to_grid_is_enabled, bool hyde_labels)
{
	int is_label_or_pinlabel_or_pin_selected = 0;

	if(!m_selected)
	{
		is_label_or_pinlabel_or_pin_selected = m_highlighted;
		if(!is_label_or_pinlabel_or_pin_selected) return false;
	}


	int grid_size		= (int)(GetGridSize() * m_zoom);
	int snap_to_grid	= GCSuperSpiceGlobalData.CDrawData.is_snap_to_grid_on;
	int is_move_with_snap_to_grid = GCSuperSpiceGlobalData.CDrawData.is_move_with_snap_to_grid;

	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count = CMLabelListObject.GetSize();

	register int p;

	if(!hyde_labels || is_label_or_pinlabel_or_pin_selected)
	{
		PCGraphicObject = CMLabelListObject.GetData();
		PCGraphicObject = PCGraphicObject + count - 1;

		for(p = count - 1; p > -1; p--)
		{
			if(PCGraphicObject->m_selected || m_selected)
				if(PCGraphicObject->m_visable)
					PCGraphicObject->Clear(PCDC);

			PCGraphicObject--;
		}
	}

	count = CMPinListObject.GetSize();

	for(p = count - 1; p > -1; p--)
	{
		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].Clear(PCDC, hyde_labels);
	}

	if(m_selected) TCGraphicBitMapVectorObject::Clear(PCDC);

	CPoint CGraphicPosition = CLocation;

	if(snap_to_grid && is_move_with_snap_to_grid)  CGraphicPosition = SnapToGrid(CGraphicPosition, grid_size);
	if(snap_to_grid && snap_to_grid_is_enabled) CGraphicPosition = SnapToGrid(CGraphicPosition, grid_size);

	if(is_label_or_pinlabel_or_pin_selected)
	{
		if(m_selected) TCGraphicBitMapVectorObject::Paste(PCDC, CMLocation, m_zoom, true);
	}
	else
	{
		TCGraphicBitMapVectorObject::Paste(PCDC, CGraphicPosition, m_zoom, true);
	}
	CPoint CLocationOffset;

	count = CMPinListObject.GetSize();

	int pin_count = CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count == count)// bug fix nov23 2000
	for(p = 0; p < count; p++)
	{
		{
			CLocationOffset = CMSchematicObjectData.CPinListData[p].CLocation;

			CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
			CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

			if(CMPinListObject[p].m_selected || CMPinListObject[p].IsLabelSelected())
				CMPinListObject[p].PasteWithMove(PCDC, (CPoint)(CLocation+ CLocationOffset), m_zoom, CMPinListObject[p].m_visable, hyde_labels);
			else
			{
				CMPinListObject[p].Paste(PCDC, (CPoint)(CMLocation + CLocationOffset), CMPinListObject[p].m_visable, hyde_labels);
			}
		}
	}

	count = CMLabelListObject.GetSize();

	for(p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_selected)
		{
			CMLabelListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable);
		}
		else
		{
			CMLabelListObject[p].Paste(PCDC, (CPoint)(CMLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable && (!hyde_labels || is_label_or_pinlabel_or_pin_selected));
	//		CMLabelListObject[p].Paste(PCDC, (CPoint)(CMLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable);

		}
	}

	return true;
}
void TCSchematicObject::UpdateLableAndPinLocations(void)
{
	CPoint CLabelLocation;
	CPoint CTemp;

	int count = CMSchematicObjectData.CPinListData.GetSize();

	int count_check = CMPinListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		if(p < count_check)
		  CMPinListObject[p].GetLocation(&CLabelLocation);

		CTemp = (CPoint)(CLabelLocation - CMLocation);

		CTemp.x	= (int)(CTemp.x / m_zoom);
		CTemp.y	= (int)(CTemp.y / m_zoom);

		CMSchematicObjectData.CPinListData[p].CLocation = CTemp;
		
		if(p < count_check)
			CMPinListObject[p].UpdateLableLocations();	
	}

	count = CMSchematicObjectData.CLabelListData.GetSize();

	count_check = CMLabelListObject.GetSize();

	for( p = 0; p < count; p++)
	{ 
		if(p < count_check)
			CMLabelListObject[p].GetLocation(&CLabelLocation);
 
		CTemp = (CPoint)(CLabelLocation - CMLocation);

		CTemp.x	= (int)(CTemp.x / m_zoom);
		CTemp.y	= (int)(CTemp.y / m_zoom);

		CMSchematicObjectData.CLabelListData[p].CLocation = CTemp;
		if(CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1] = CTemp;
	}
}

void  TCSchematicObject::DeleteBitmapBackgroundLabels(void)
{
	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMLabelListObject[p].CBitmapBackground.DeleteObject();
	}

	count = CMPinListObject.GetSize();

	for(p = 0; p < count; p++)
	{
		CMPinListObject[p].DeleteBitmapBackgroundLabels();
	}
}
void  TCSchematicObject::CreateBitmapBackgroundLabels(void)
{
	int count = CMLabelListObject.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMLabelListObject[p].CreateBitmapBackgroundLabel();
	}

	count = CMPinListObject.GetSize();

	for(p = 0; p < count; p++)
	{
		CMPinListObject[p].CreateBitmapBackgroundLabels();
	}
}
bool TCSchematicObject::Clear(CDC *PCDC, bool hyde_labels)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count = CMLabelListObject.GetSize();

//	int is_label_or_pinlabel_or_pin_selected = IsLabelOrPinLabelOrPinSelected();

	int is_label_or_pinlabel_or_pin_selected = 0;

	if(!m_selected)
	{
		is_label_or_pinlabel_or_pin_selected = m_highlighted;
	}

	if(!hyde_labels || is_label_or_pinlabel_or_pin_selected)
	{
		PCGraphicObject = CMLabelListObject.GetData();
		PCGraphicObject = PCGraphicObject + count - 1;

		for(int p = count - 1; p > -1; p--)
		{
			if(PCGraphicObject->m_visable)
				PCGraphicObject->Clear(PCDC);

			PCGraphicObject--;
		}
	}

	count = CMPinListObject.GetSize();

	for(int p = count - 1; p > -1; p--)
	{
		if(CMPinListObject[p].m_visable)
			CMPinListObject[p].Clear(PCDC, hyde_labels);
	}

	bool result = TCGraphicBitMapVectorObject::Clear(PCDC);

	return result;
}


void TCSchematicObject::SetLabel(CDC *PCViewDC, int id, CString CText, bool redraw) 
{
	if(CText == "") return;
	if(id < 0) return;

	if(m_property == E_SCHEMATIC_TEXT_LABEL)
	{
		CMLabel = CText;

		UpdateLabel();

		return;
	}

	if(id >= CMSchematicObjectData.CLabelListData.GetSize()) return;
	
	CPoint CLocalLocation;

	if(id >= CMLabelListObject.GetSize()) return;

	TCGraphicBitMapVectorObject &CGraphicLabelObject = CMLabelListObject[id];

	CMSchematicObjectData.CLabelListData[id].CLabel = CText;

	CGraphicLabelObject.DeleteBitmapNew();

	CGraphicLabelObject.Create(PCViewDC, CText, m_zoom,
								GCSuperSpiceGlobalData.CColorData.component_text_normal,
								GCSuperSpiceGlobalData.CColorData.component_selected, 
								GCSuperSpiceGlobalData.CColorData.component_text_highlighted);


	CGraphicLabelObject.m_property = E_SCHEMATIC_LABEL;

	if(redraw) Paste(PCViewDC, CMLocation);
}

void TCSchematicObject::ClearLabel(CDC *PCDC, int id)
{
	if(id < 0) return;
	if(!PCDC) return;
	if(!(id < CMLabelListObject.GetSize())) return;

	if(!CMLabelListObject[id].m_visable) return;

	CMLabelListObject[id].Clear(PCDC);
}

void TCSchematicObject::RepasteLabel(CDC *PCDC, int id)
{
	if(id < 0) return;
	if(!PCDC) return;
	if(!(id < CMLabelListObject.GetSize())) return;

	if(!CMLabelListObject[id].m_visable) return;

	CMLabelListObject[id].Paste(PCDC, CMLabelListObject[id].CMLocation, m_zoom, true);
}

void TCSchematicObject::ClearAllLabels(CDC *PCDC)
{
	int count, p;

	count = CMLabelListObject.GetSize();

	for(p = 0; p < count; p++)
	{
		CMLabelListObject[p].Clear(PCDC);
	}
}

void TCSchematicObject::RepasteAllLabels(CDC *PCDC)
{
	int count, p;// used for waveform updates

	count = CMLabelListObject.GetSize();

	CPoint CLocation = CMLocation;
	CPoint	CLocationOffset;
	bool hyde_labels = false;

	for( p = 0; p < count; p++)
	{ 
		if(!CMSchematicObjectData.CLabelListData[p].CLocations_Mirror.GetSize())
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocation;
		else
			CLocationOffset = CMSchematicObjectData.CLabelListData[p].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];
		
		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		CMLabelListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable && !hyde_labels);
		
	}
}

void TCSchematicObject::ClearAllPhaseLabels(CDC *PCDC)
{
	int count, p;

	count = CMLabelListObject.GetSize();

	for(p = yphase_axis_start_index; p < count; p++)
	{
		CMLabelListObject[p].Clear(PCDC);
	}
}

void TCSchematicObject::ClearAllAllMagnitudeLabels(CDC *PCDC)
{
	int count, p;

	if(yphase_axis_start_index < 0)return;
	if(ymagnitude_axis_start_index < 0)return;

	count = CMLabelListObject.GetSize();

	if(!(yphase_axis_start_index < count))
	{
		ASSERT(0);
		return;
	}

	for(p = ymagnitude_axis_start_index; p < yphase_axis_start_index; p++)
	{
		CMLabelListObject[p].Clear(PCDC);
	}
}
void TCSchematicObject::RepasteAllPhaseLabels(CDC *PCDC)
{
	if(yphase_axis_start_index < 0)return;
	if(ymagnitude_axis_start_index < 0)return;

	int count, p;

	count = CMLabelListObject.GetSize();

	for(p = yphase_axis_start_index; p < count; p++)
	{
		CMLabelListObject[p].Paste(PCDC, CMLabelListObject[p].CMLocation, m_zoom, true);
	}
}
					
void TCSchematicObject::RepasteAllMagnitudeLabels(CDC *PCDC)
{
	if(yphase_axis_start_index < 0)return;
	if(ymagnitude_axis_start_index < 0)return;

	int count, p;

	count = CMLabelListObject.GetSize();

	if(!(yphase_axis_start_index < count))
	{
		ASSERT(0);
		return;
	}

	for(p = ymagnitude_axis_start_index; p < yphase_axis_start_index; p++)
	{
		CMLabelListObject[p].Paste(PCDC, CMLabelListObject[p].CMLocation, m_zoom, true);
	}
}

TCWireInfo &TCSchematicObject::GetWireInfo(void)
{
	TCWireInfo &CWireInfo = TCGraphicBitMapVectorObject::GetWireInfo();

	CWireInfo.CNetName = CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

	return CWireInfo;
}

CString	TCSchematicObject::GetLabel(void)
{
	return CMLabel;
}
CString TCSchematicObject::GetLabel(int id) 
{
	if(id >= CMSchematicObjectData.CLabelListData.GetSize()) return "";
	if(id < 0) return "";

	return CMSchematicObjectData.CLabelListData[id].CLabel;
}
void TCSchematicObject::SetPinLabel(CDC *PCViewDC, int pin_id, int label_id, CString CText)
{
	if(CText == "") return;

	if(pin_id >= CMSchematicObjectData.CPinListData.GetSize()) return;
	if(pin_id < 0) return;

	if(label_id >= CMSchematicObjectData.CPinListData[pin_id].CLabelListData.GetSize()) return;
	if(label_id < 0) return;

	TCGraphicBitMapVectorObject &CGraphicLabelObject = CMPinListObject[pin_id].CMLabelListObject[label_id];

	CMSchematicObjectData.CPinListData[pin_id].CLabelListData[label_id].CLabel = CText;

	CGraphicLabelObject.DeleteBitmapNew();

	if(CGraphicLabelObject.m_visable)
	{
		CGraphicLabelObject.Create(PCViewDC, CText, m_zoom, 
									GCSuperSpiceGlobalData.CColorData.pin_text_normal,
									GCSuperSpiceGlobalData.CColorData.pin_text_selected, 
									GCSuperSpiceGlobalData.CColorData.pin_text_highlighted);

	}
	else CGraphicLabelObject.DeleteBitmapNew();

	CGraphicLabelObject.m_property = E_SCHEMATIC_PIN_LABEL;// 23rd November 2000, font size reload problem

	TCSchematicPinData &CSchematicPinData = CMPinListObject[pin_id].GetPinData();
	
	CSchematicPinData.CLabelListData[label_id].CLabel = CText;


	CMPinListObject[pin_id].Paste(PCViewDC, CMPinListObject[pin_id].CMLocation, CGraphicLabelObject.m_visable, false);
}

void TCSchematicObject::SetSelectLabel(CDC *PCViewDC, int label_id, bool select)
{
	if(label_id >= CMSchematicObjectData.CLabelListData.GetSize()) return;
	if(label_id < 0) return;

	if(PCViewDC) Clear(PCViewDC);

	TCGraphicBitMapVectorObject::SetHighlight(select);

	if(select) 
	{
		CMLabelListObject[label_id].SetSelect();
	}
	else  
	{
		CMLabelListObject[label_id].ResetSelect();
	}

	if(PCViewDC) Paste(PCViewDC, CMLocation);

}

bool TCSchematicObject::GetSelectLabel(int label_id)
{
	if(label_id >= CMSchematicObjectData.CLabelListData.GetSize()) return false;
	if(label_id < 0) return false;

	return CMLabelListObject[label_id].m_selected;
}
bool TCSchematicObject::GetSelectPinLabel(int pin_id, int label_id)
{
	if(pin_id >= CMSchematicObjectData.CPinListData.GetSize()) return false;
	if(pin_id < 0) return false;

	if(label_id >= CMSchematicObjectData.CPinListData[pin_id].CLabelListData.GetSize()) return false;
	if(label_id < 0) return false;

	return CMPinListObject[pin_id].CMLabelListObject[label_id].m_selected;
}

bool TCSchematicObject::GetSelectPin(int pin_id)
{
	if(pin_id >= CMSchematicObjectData.CPinListData.GetSize()) return false;
	if(pin_id < 0) return false;

	return CMPinListObject[pin_id].m_selected;
}

void TCSchematicObject::SetSelectPin(CDC *PCViewDC, int pin_id, bool select)
{
	if(pin_id >= CMSchematicObjectData.CPinListData.GetSize()) return;
	if(pin_id < 0) return;

	if(PCViewDC) Clear(PCViewDC);

	TCGraphicBitMapVectorObject::SetHighlight(select);

	if(select) CMPinListObject[pin_id].SetSelect();
	else  CMPinListObject[pin_id].ResetSelect();

	if(PCViewDC) Paste(PCViewDC, CMLocation);
}

void TCSchematicObject::SetSelectPinLabel(CDC *PCViewDC,int pin_id, int label_id, bool select)
{
	if(pin_id >= CMSchematicObjectData.CPinListData.GetSize()) return;
	if(pin_id < 0) return;

	if(label_id >= CMSchematicObjectData.CPinListData[pin_id].CLabelListData.GetSize()) return;
	if(label_id < 0) return;

	if(PCViewDC) Clear(PCViewDC);

	TCGraphicBitMapVectorObject::SetHighlight(select);

	if(select) CMPinListObject[pin_id].CMLabelListObject[label_id].SetSelect();
	else  CMPinListObject[pin_id].CMLabelListObject[label_id].ResetSelect();

	if(PCViewDC) Paste(PCViewDC, CMLocation);
}


CString TCSchematicObject::GetPinLabel(int pin_id, int label_id)
{
	if(pin_id >= CMSchematicObjectData.CPinListData.GetSize()) return "";
	if(pin_id < 0) return "";

	if(label_id >= CMSchematicObjectData.CPinListData[pin_id].CLabelListData.GetSize()) return "";
	if(label_id < 0) return "";


	return 	CMSchematicObjectData.CPinListData[pin_id].CLabelListData[label_id].CLabel;
}

bool TCSchematicObject::StartDrawingLine(CDC *PCDC, CPoint CMousePosition, float zoom)
{
	m_zoom = zoom;

	int grid_size		= (int)(GetGridSize() * m_zoom);
	int snap_to_grid	= GCSuperSpiceGlobalData.CDrawData.is_snap_to_grid_on;

	if(snap_to_grid) CMousePosition = SnapToGrid(CMousePosition, grid_size);

	m_property	= E_SCHEMATIC_WIRE;
	m_type		= E_WIRE_COMPONENT;

	CMSchematicObjectData = GCSuperSpiceDataBase.CMDefaults[E_WIRE_COMPONENT];


	//Overide global use last name which dos'nt really make sense here

	int count = CMSchematicObjectData.CLabelListData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMSchematicObjectData.CLabelListData[p].CLabel == "";
		CMSchematicObjectData.CLabelListData[p].is_visable = false;
	}

	CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].user_label_preferred = false;
	m_user_label_preferred	= false;

	return TCGraphicBitMapVectorObject::StartDrawingLine(PCDC, CMousePosition,
		    GCSuperSpiceGlobalData.CColorData.wire_normal,
			GCSuperSpiceGlobalData.CColorData.wire_selected,  
			GCSuperSpiceGlobalData.CColorData.wire_highlighted,
			1, //line_width,
			GetSnapToDistance());


}
bool TCSchematicObject::ContinueDrawingLine(CDC *PCDC, CPoint CMousePosition, int snap_to_grid_is_enabled)
{
	int grid_size		= (int)(GetGridSize() * m_zoom);
	int snap_to_grid	= GCSuperSpiceGlobalData.CDrawData.is_snap_to_grid_on;
	int is_move_with_snap_to_grid = GCSuperSpiceGlobalData.CDrawData.is_move_with_snap_to_grid;

	if(snap_to_grid && is_move_with_snap_to_grid)  CMousePosition = SnapToGrid(CMousePosition, grid_size);
	if(snap_to_grid && snap_to_grid_is_enabled) CMousePosition = SnapToGrid(CMousePosition, grid_size);

	return TCGraphicBitMapVectorObject::ContinueDrawingLine(PCDC, CMousePosition);
}
bool TCSchematicObject::StopDrawingLine(CDC *PCDC, CPoint CMousePosition, bool is_symbol_editor)
{
	int grid_size		= (int)(GetGridSize() * m_zoom);
	int snap_to_grid	= GCSuperSpiceGlobalData.CDrawData.is_snap_to_grid_on;

	int is_draw_orthoganal_on = GCSuperSpiceGlobalData.CDrawData.is_draw_orthoganal_on;

	if(is_symbol_editor) is_draw_orthoganal_on = false;

	if(snap_to_grid)  CMousePosition = SnapToGrid(CMousePosition, grid_size);

	CDC CViewDC;


	if(!CViewDC.CreateCompatibleDC(NULL)) return TCGraphicBitMapVectorObject::StopDrawingLine(PCDC, CMousePosition, GCSuperSpiceGlobalData.CDrawData.is_draw_orthoganal_on);

	CreateLabels(&CViewDC);

	bool result = TCGraphicBitMapVectorObject::StopDrawingLine(PCDC, CMousePosition, is_draw_orthoganal_on);
	
	CreateWirePins(&CViewDC);

	return result;
}

void TCSchematicObject::CreateWirePins(CDC *PCDC)
{
	CreateWirePinData();

	int count = CMSchematicObjectData.CPinListData.GetSize();

	CMPinListObject.SetSize(count);

	m_rotation_state;// eliminated, what pins to be in he same type always
	m_mirror_state;

	for(int p = 0; p < count; p++)
	{
		CMPinListObject[p].is_symbol_editor = is_symbol_editor;

		CMPinListObject[p].Create(PCDC, CMSchematicObjectData.CPinListData[p], m_zoom, E_HORIZONTAL, 0);

		CMPinListObject[p].m_visable = CMSchematicObjectData.CPinListData[p].is_visable;
	}
}

void TCSchematicObject::ClearConnectionDots(CDC *PCViewDC)
{
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT1].is_visable = false;
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].is_visable = false;

	SetSchematicObjectData(PCViewDC, CMSchematicObjectData);
}

void TCSchematicObject::DisplayConnectionDot1(CDC *PCViewDC)
{
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT1].is_visable = true;
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT1].CLabel = ".";

	int y_offset = GCSuperSpiceGlobalData.CDrawData.connection_dot_size/2;
	int x_offset = GCSuperSpiceGlobalData.CDrawData.connection_dot_size/2;

	CPoint &CLocation = CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT1].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1];

	if(m_draw_angle == E_HORIZONTAL)
	{
		CLocation.y = -y_offset;
		CLocation.x = -x_offset;
	}
	else if(m_draw_angle == E_VERTICAL)
	{
		CLocation.y = -y_offset;
		CLocation.x = -x_offset;
	}
	else
	{
		CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT1].is_visable = false;
	}

	SetSchematicObjectData(PCViewDC, CMSchematicObjectData);
}

void TCSchematicObject::DisplayConnectionDot2(CDC *PCViewDC)
{
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].is_visable = true;
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLabel = ".";

	int y_offset = GCSuperSpiceGlobalData.CDrawData.connection_dot_size/2;
	int x_offset = GCSuperSpiceGlobalData.CDrawData.connection_dot_size/2;

	if(m_draw_angle == E_HORIZONTAL)
	{
		CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1].y = -y_offset;
		CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1].x = (int)((CMLineEnd.x - CMLineStart.x)/m_zoom) - x_offset;
	}
	else if(m_draw_angle == E_VERTICAL)
	{
		CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1].x = -x_offset;
		CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLocations_Mirror[m_mirror_state].CQuadrant[m_rotation_state - 1].y = (int)((CMLineEnd.y - CMLineStart.y)/m_zoom) - y_offset;
	}
	else
	{
		CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].is_visable = false;
	}

	SetSchematicObjectData(PCViewDC, CMSchematicObjectData);
}

void TCSchematicObject::CreateWirePinData(void)
{
	// won't support angled virtul pins
//	if(m_draw_angle != E_HORIZONTAL && m_draw_angle != E_VERTICAL) return;

	int length = GCSuperSpiceDataBase.CMDefaults[E_POINTING_LEFT_PIN_COMPONENT].width;

	CMSchematicObjectData.CPinListData.SetSize(2);

	// this gets rotated automatically for vertical
	CMSchematicObjectData.CPinListData[0].type	= E_POINTING_LEFT_PIN_COMPONENT;
	CMSchematicObjectData.CPinListData[1].type	= E_POINTING_RIGHT_PIN_COMPONENT;
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT1].CLabel = ".";
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLabel = ".";

	//switch on h/v
	if(m_draw_angle == E_HORIZONTAL)
	{
		CMSchematicObjectData.CPinListData[0].CLocation.x		= length;
		CMSchematicObjectData.CPinListData[0].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[0].is_visable		= false;

		CMSchematicObjectData.CPinListData[1].CLocation.x		= (long)((m_object_width)/m_zoom - length);
		CMSchematicObjectData.CPinListData[1].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[1].is_visable		= false;

		//connection dots.
	}
	else if(m_draw_angle == E_VERTICAL)
	{
		CMSchematicObjectData.CPinListData[0].CLocation.x		= length;
		CMSchematicObjectData.CPinListData[0].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[0].is_visable		= false;

		CMSchematicObjectData.CPinListData[1].CLocation.x		= -length;
		CMSchematicObjectData.CPinListData[1].CLocation.y		= (long)((m_object_height/m_zoom));
		CMSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[1].is_visable		= false;
	}
	else if(m_draw_angle == E_FIRST_QUADRANT)
	{
		CMSchematicObjectData.CPinListData[0].CLocation.x		= length;
		CMSchematicObjectData.CPinListData[0].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[0].is_visable		= false;

		CMSchematicObjectData.CPinListData[1].CLocation.x		= (long)((m_object_width)/m_zoom - length);
		CMSchematicObjectData.CPinListData[1].CLocation.y		= (long)((-m_object_height/m_zoom));
		CMSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[1].is_visable		= false;
	}
	else if(m_draw_angle == E_SECOND_QUADRANT)
	{
		CMSchematicObjectData.CPinListData[0].CLocation.x		= length;
		CMSchematicObjectData.CPinListData[0].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[0].is_visable		= false;

		CMSchematicObjectData.CPinListData[1].CLocation.x		= (long)((-m_object_width)/m_zoom - length);
		CMSchematicObjectData.CPinListData[1].CLocation.y		= (long)((-m_object_height/m_zoom));
		CMSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[1].is_visable		= false;
	}

	else if(m_draw_angle == E_THIRD_QUADRANT)
	{
		CMSchematicObjectData.CPinListData[0].CLocation.x		= length;
		CMSchematicObjectData.CPinListData[0].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[0].is_visable		= false;

		CMSchematicObjectData.CPinListData[1].CLocation.x		= (long)((-m_object_width)/m_zoom - length);
		CMSchematicObjectData.CPinListData[1].CLocation.y		= (long)((m_object_height/m_zoom));
		CMSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[1].is_visable		= false;
	}
	else
	{
		CMSchematicObjectData.CPinListData[0].CLocation.x		= length;
		CMSchematicObjectData.CPinListData[0].CLocation.y		= 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[0].is_visable		= false;

		CMSchematicObjectData.CPinListData[1].CLocation.x		= (long)((m_object_width)/m_zoom - length);
		CMSchematicObjectData.CPinListData[1].CLocation.y		= (long)((m_object_height/m_zoom));
		CMSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
		CMSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
		CMSchematicObjectData.CPinListData[1].is_visable		= false;
	}
}

////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////

TCSchematicObjectData::~TCSchematicObjectData(void)
{
	if(PCGeneratorData) delete PCGeneratorData;
	if(PCOutputWaveformDataHeader) 
	{
		delete PCOutputWaveformDataHeader;
	
		PCOutputWaveformDataHeader = NULL;
	}
}

TCSchematicObjectData::TCSchematicObjectData(void)
{
	CPinListData.SetSize(0);
	CLabelListData.SetSize(0);
	CSymbolData.CData.SetSize(0);

	f_validate_label_value			= true;
	component_property_view_type	= 0;
	version							= -1;
	is_unique_model					= 0;
	
	format_spice_value				= true;
	attached_model_type				= 0;

	PCGeneratorData				= NULL;
	PCOutputWaveformDataHeader = NULL;
	PCMAnalysisSetup = NULL;

	CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER + 1);

	CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = false;
	CLabelListData[E_COMPONENT_VALUE].read_only = true;

	width	= 32; 
	height	= 32;

	HTreeItem = NULL;

	CVersionInfo.CSaveMajor = "2";
	GGeneratorLoadVersion = CVersionInfo.CLoadMajor;
	GGeneratorSaveVersion = CVersionInfo.CSaveMajor;
}

TCSchematicObjectData::TCSchematicObjectData(TCSchematicObjectData &CSchematicObjectData)
{
	*this = CSchematicObjectData;
}

void TCSchematicObjectData::Serialize(CArchive& CArchiveFile)
{
	int count;
	int p = 1;
	int data;

	int check = 654321;
	int check_read = 1;

	CVersionInfo.Serialize(CArchiveFile);
	TCGraphicObjectData::Serialize(CArchiveFile);
	CSpiceParameters.SerializeInfo(CArchiveFile);
	CSymbolData.Serialize(CArchiveFile);
	CComponentInfo.Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if (CArchiveFile.IsStoring())
	{
        GGeneratorSaveVersion = CVersionInfo.CSaveMajor;

		CArchiveFile.Write(&f_validate_label_value, sizeof(f_validate_label_value));
		CArchiveFile << component_property_view_type;
		CArchiveFile << version;
		CArchiveFile.Write(&format_spice_value, sizeof(format_spice_value));
		CArchiveFile << attached_model_type;
		CArchiveFile << CGrabOffset;

		if(PCOutputWaveformDataHeader)
		{
			data = true;
			CArchiveFile << data;
			PCOutputWaveformDataHeader->Serialize(CArchiveFile);
		}
		else
		{
			data = false;
			CArchiveFile << data;
		}

		if(PCGeneratorData)
		{
			if(attached_model_type != E_SPICE_GENERATOR)
			{
				delete PCGeneratorData;

				PCGeneratorData = NULL;

				data = false;
				CArchiveFile << data;
//				ASSERT(0);
			}
			else
			{
				data = true;
				CArchiveFile << data;

				PCGeneratorData->Serialize(CArchiveFile);
			}
		}
		else
		{
			data = false;
			CArchiveFile << data;
		}
		count = CPinListData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CPinListData[p].Serialize(CArchiveFile);

		count = CLabelListData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);

		CArchiveFile << check;
	}
	else
	{
		GGeneratorLoadVersion = CVersionInfo.CLoadMajor;

		CArchiveFile.Read(&f_validate_label_value, sizeof(f_validate_label_value));

		CArchiveFile >> component_property_view_type;
		CArchiveFile >> version;
		CArchiveFile.Read(&format_spice_value, sizeof(format_spice_value));
		CArchiveFile >> attached_model_type;
		CArchiveFile >> CGrabOffset;

		CArchiveFile >> data;

		if(data)
		{
			if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)
				PCOutputWaveformDataHeader->Serialize(CArchiveFile);
		}

		CArchiveFile >> data;

		if(data)
		{
			if(attached_model_type != E_SPICE_GENERATOR)
			{
				ASSERT(0);
			}
			if(!PCGeneratorData)
				PCGeneratorData	= new TCGeneratorData;

			if(!PCGeneratorData) return;

			PCGeneratorData->Serialize(CArchiveFile);
		}

		CArchiveFile >> count;

		CPinListData.SetSize(count, count);

		for(p = 0; p < count; p++) CPinListData[p].Serialize(CArchiveFile);
		
		CArchiveFile >> count;

		CLabelListData.SetSize(count, count);

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);

		CArchiveFile >> check_read;

		if(check_read != check)
		{
			AfxMessageBox(IDS_INVALID_FILE);

			return;
		}

			// quick bodge fix
		if(component_property_view_type == E_PROPERTY_RESISTOR || component_property_view_type == E_PROPERTY_INDUCTOR ||
			component_property_view_type == E_PROPERTY_CAPACITOR || component_property_view_type == E_PROPERTY_CONTROLED_SOURCE ||
			type == E_TITLE_BLOCK)
		{
			CSpiceParameters.use_model = false;
		}
		// quick bodge fix
		if(component_property_view_type == E_PROPERTY_RESISTOR)
		{
			CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE + 1);
		}
		if(component_property_view_type == E_PROPERTY_CAPACITOR)
		{
			CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);
		}

		if(component_property_view_type == E_PROPERTY_SUBCIRCUIT || component_property_view_type == E_PROPERTY_GENERIC_MODEL ||
		   component_property_view_type == E_PROPERTY_GENERIC_SUBCIRCUIT) 
		{
			CLabelListData.SetSize(E_COMPONENT_SUBCKT_PARAMETERS + 1);
		}

///// Compaterbility with existing schematics
		if(CReserved.CStringArray.GetSize() < E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX)// PCB updated version at 8th October 2000
		{
			CReserved.CStringArray.SetSize(E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX);// Force prior versions to add a fields for PCB package type and device name
			CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = "SMD";
			CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

		}
		if(CReserved.CIntArray.GetSize() < E_RESERVED_INT_COMPONENT_DATA_MAX)
		{
			CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);// Force prior versions to add a fields for PCB include in netlists

		}
		if(component_property_view_type == E_PROPERTY_MOSFET ||
		   component_property_view_type == E_PROPERTY_FET ||
		   component_property_view_type == E_PROPERTY_MESFET)// adding of AD/AD enables, and parameters
		{
			CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
		}
		if(component_property_view_type == E_PROPERTY_BIPOLAR)// adding of AD/AD enables, and parameters
		{
			CLabelListData.SetSize(E_COMPONENT_BIPOLAR_PARAMETERS + 1);
		}
	}
}

void TCSchematicObjectData::SerializeSymbolData(CArchive& CArchiveFile)
{
	int count;
	int p;

	CVersionInfo.Serialize(CArchiveFile);
	TCGraphicObjectData::Serialize(CArchiveFile);
	CSymbolData.Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if (CArchiveFile.IsStoring())
	{
		count = CPinListData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CPinListData[p].Serialize(CArchiveFile);

		count = CLabelListData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);
		
	}
	else
	{
		CArchiveFile >> count;

		CPinListData.SetSize(count, count);

		for(p = 0; p < count; p++) CPinListData[p].Serialize(CArchiveFile);
		
		CArchiveFile >> count;

		CLabelListData.SetSize(count, count);

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);

		// quick bodge fix
		if(component_property_view_type == E_PROPERTY_RESISTOR || component_property_view_type == E_PROPERTY_INDUCTOR ||
		   component_property_view_type == E_PROPERTY_CAPACITOR || component_property_view_type == E_PROPERTY_CONTROLED_SOURCE ||
		   type == E_TITLE_BLOCK)
		{
			CSpiceParameters.use_model = false;
		}

		// These fields have been incressed.
		if(component_property_view_type == E_PROPERTY_RESISTOR)
		{
			CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE + 1);
		}
		if(component_property_view_type == E_PROPERTY_CAPACITOR)
		{
			CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);
		}

		if(component_property_view_type == E_PROPERTY_SUBCIRCUIT || component_property_view_type == E_PROPERTY_GENERIC_MODEL ||
		   component_property_view_type == E_PROPERTY_GENERIC_SUBCIRCUIT) 
		{
			CLabelListData.SetSize(E_COMPONENT_SUBCKT_PARAMETERS + 1);
		}
///// Compaterbility with existing schematics
		if(CReserved.CStringArray.GetSize() < E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX)// PCB updated version at 8th October 2000
		{
			CReserved.CStringArray.SetSize(E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX);// Force prior versions to add a fields for PCB package type and device name
			CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = "SMD";
			CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

		}
		if(CReserved.CIntArray.GetSize() < E_RESERVED_INT_COMPONENT_DATA_MAX)
		{
			CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);// Force prior versions to add a fields for PCB include in netlists
		}

		if(component_property_view_type == E_PROPERTY_MOSFET)// adding of AD/AD enables, and parameters
		{
			CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
		}
	}
}

bool TCSchematicObjectData::Load(CString CFileName)
{
	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::load);

	SerializeSymbolData(CArchiveFile);

	return true;
}

bool TCSchematicObjectData::Save(CString CFileName)
{
	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::store | CFile::shareDenyNone);

	SerializeSymbolData(CArchiveFile);

	return true;
}

void TCSchematicObjectData::Copy(TCSchematicObjectData &CSchematicObjectData)
{
	CVersionInfo	= CSchematicObjectData.CVersionInfo;

	TCGraphicObjectData::Copy(CSchematicObjectData);
	CSpiceParameters = CSchematicObjectData.CSpiceParameters;
//	CSpiceParameters.CopyInfo(CSchematicObjectData.CSpiceParameters);
	CGrabOffset = CSchematicObjectData.CGrabOffset;

//	CSymbolData		= CSchematicObjectData.CSymbolData;
	CSymbolData.Copy(CSchematicObjectData.CSymbolData);//23rd Aug 2001

	CReserved = CSchematicObjectData.CReserved;

	f_validate_label_value	= CSchematicObjectData.f_validate_label_value;
	component_property_view_type = CSchematicObjectData.component_property_view_type;

	read_only				= CSchematicObjectData.read_only;
	version					= CSchematicObjectData.version;
	format_spice_value		= CSchematicObjectData.format_spice_value;
	attached_model_type		= CSchematicObjectData.attached_model_type;
	CComponentInfo			= CSchematicObjectData.CComponentInfo;
	HTreeItem				= CSchematicObjectData.HTreeItem;
	is_unique_model			= CSchematicObjectData.is_unique_model;

	if(CSchematicObjectData.PCOutputWaveformDataHeader)
	{
		if(type != E_WAVEFORM_COMPONENT)
		{
			ASSERT(0);// this is a program fault
			return;
		}

		if(PCOutputWaveformDataHeader)
		{
			*PCOutputWaveformDataHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		}
		else
		{
			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)*PCOutputWaveformDataHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		}

		//Now see if data is ok added 8th April 2000 to fix bug
		CheckAndNullWaveformDataPointers();
	}
	else
	{
		if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

		PCOutputWaveformDataHeader = NULL;
	}

	if(CSchematicObjectData.PCGeneratorData)
	{
		if(attached_model_type != E_SPICE_GENERATOR)
		{
			delete CSchematicObjectData.PCGeneratorData;

			CSchematicObjectData.PCGeneratorData = NULL;
		}
		else
		{
			if(!PCGeneratorData)
				PCGeneratorData	= new TCGeneratorData;

			if(!PCGeneratorData) return;

			*PCGeneratorData = *CSchematicObjectData.PCGeneratorData;
		}
	}

	int count = CSchematicObjectData.CPinListData.GetSize();

	CPinListData.SetSize(count,  count);

	int p;

	for(p = 0; p < count; p++) 
	{
		int count2 = CSchematicObjectData.CPinListData[p].CLabelListData.GetSize();

		CPinListData[p].CLabelListData.SetSize(count2);
		for(int q = 0; q < count2; q++) 
		{
			CPinListData[p].CLabelListData[q] = CSchematicObjectData.CPinListData[p].CLabelListData[q];
		}
	}
	count = CSchematicObjectData.CLabelListData.GetSize();

	CLabelListData.SetSize(count, count);

	for(p = 0; p < count; p++) CLabelListData[p]  = CSchematicObjectData.CLabelListData[p];

	count = CSchematicObjectData.COpPoints.GetSize();

	COpPoints.SetSize(count);

	for(p = 0; p < count; p++) COpPoints[p] = CSchematicObjectData.COpPoints[p];
}

void TCSchematicObjectData::operator = (TCSchematicObjectData  &CSchematicObjectData)
{
	CVersionInfo	= CSchematicObjectData.CVersionInfo;

	TCGraphicObjectData::operator = (CSchematicObjectData);

	CSpiceParameters = CSchematicObjectData.CSpiceParameters;// only copy parameter id
	
	CSymbolData		= CSchematicObjectData.CSymbolData;
	CComponentInfo	= CSchematicObjectData.CComponentInfo;
	CGrabOffset		= CSchematicObjectData.CGrabOffset;
	CReserved		= CSchematicObjectData.CReserved;

	f_validate_label_value	= CSchematicObjectData.f_validate_label_value;
	component_property_view_type = CSchematicObjectData.component_property_view_type;
	read_only				= CSchematicObjectData.read_only;
	version					= CSchematicObjectData.version;
	format_spice_value		= CSchematicObjectData.format_spice_value;
	attached_model_type		= CSchematicObjectData.attached_model_type;
	HTreeItem				= CSchematicObjectData.HTreeItem;
	is_unique_model			= CSchematicObjectData.is_unique_model;
	
	if(CSchematicObjectData.PCOutputWaveformDataHeader)
	{
		if(type != E_WAVEFORM_COMPONENT)
		{
			ASSERT(0);// this is a program fault
			return;
		}

		if(PCOutputWaveformDataHeader)
		{
			*PCOutputWaveformDataHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		}
		else
		{
			PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;

			if(PCOutputWaveformDataHeader)*PCOutputWaveformDataHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		}

		CheckAndNullWaveformDataPointers();
	}
	else
	{
		if(PCOutputWaveformDataHeader) delete PCOutputWaveformDataHeader;

		PCOutputWaveformDataHeader = NULL;
	}

	if(CSchematicObjectData.PCGeneratorData)
	{
		if(attached_model_type != E_SPICE_GENERATOR)
		{
			delete CSchematicObjectData.PCGeneratorData;

			CSchematicObjectData.PCGeneratorData = NULL;
		}
		else
		{
			if(!PCGeneratorData)
				PCGeneratorData	= new TCGeneratorData;

			if(!PCGeneratorData) return;

			*PCGeneratorData = *CSchematicObjectData.PCGeneratorData;
		}
	}

	int count = CSchematicObjectData.CPinListData.GetSize();

	CPinListData.SetSize(count,  count);

	int p;

	for(p = 0; p < count; p++) CPinListData[p]  = CSchematicObjectData.CPinListData[p];

	count = CSchematicObjectData.CLabelListData.GetSize();

	CLabelListData.SetSize(count,  count);

	for(p = 0; p < count; p++) CLabelListData[p]  = CSchematicObjectData.CLabelListData[p];

		// quick bodge fix
	if(component_property_view_type == E_PROPERTY_RESISTOR || component_property_view_type == E_PROPERTY_INDUCTOR ||
	   component_property_view_type == E_PROPERTY_CAPACITOR)
	{
		CSpiceParameters.use_model = false;
	}

	count = CSchematicObjectData.COpPoints.GetSize();

	COpPoints.SetSize(count);

	for(p = 0; p < count; p++) COpPoints[p] = CSchematicObjectData.COpPoints[p];
}

bool TCSchematicObjectData::CheckAndNullWaveformDataPointers(void)
{
	//Now see if data is ok added 8th April 2000 to fix bug

	if(PCOutputWaveformDataHeader)//first parameters is too speed up a little on null runss
	if(!PCOutputWaveformDataHeader->PCWaveformDataRuns || !PCOutputWaveformDataHeader->PCWaveformDataRuns ||
			!PCOutputWaveformDataHeader->PCSignals || IsBadCodePtr((FARPROC)PCOutputWaveformDataHeader->PCWaveformDataRuns) ||
			IsBadCodePtr((FARPROC)PCOutputWaveformDataHeader->PCSignals) ||
			PCOutputWaveformDataHeader->IsBadSignalsPointer())// this is for when database is copied but has destroyed pointer	
	{

		PCOutputWaveformDataHeader->PCWaveformDataRuns = NULL;
		PCOutputWaveformDataHeader->PCSignals = NULL;

		return false;
	}

	if(!PCOutputWaveformDataHeader) return false;

	return true;
}
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

TCSchematicPinData::TCSchematicPinData(void)
{
	CLabelListData.SetSize(0);
}

void TCSchematicPinData::Serialize(CArchive& CArchiveFile)
{
	TCGraphicObjectData::Serialize(CArchiveFile);

	int count, p;
	
	if (CArchiveFile.IsStoring())
	{
		count = CLabelListData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);	
	}
	else
	{
		CArchiveFile >> count;
		
		CLabelListData.SetSize(count, count);

		for(p = 0; p < count; p++) CLabelListData[p].Serialize(CArchiveFile);
	}	
}

void TCSchematicPinData::operator = (TCSchematicPinData  &CSchematicPinData)
{
	TCGraphicObjectData::operator = (CSchematicPinData);	
	
	Copy(CSchematicPinData);
}

void TCSchematicPinData::Copy(TCSchematicPinData &CSchematicPinData)
{
	int count = CSchematicPinData.CLabelListData.GetSize();

	CLabelListData.SetSize(count, count);

	for(int p = 0; p < count; p++) CLabelListData[p] = CSchematicPinData.CLabelListData[p];
}
////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////


TCSchematicPinObject::TCSchematicPinObject()
{
	
}
TCSchematicPinObject::~TCSchematicPinObject()
{

}


void TCSchematicPinObject::operator = (TCSchematicPinObject  &CSchematicPinObject)
{
	TCGraphicBitMapVectorObject::operator = (CSchematicPinObject);

	CMSchematicPinData = CSchematicPinObject.CMSchematicPinData;

	int count = CSchematicPinObject.CMLabelListObject.GetSize();

	CMLabelListObject.SetSize(count, count);

	int p;

	for(p = 0; p < count; p++)
	{
		CMLabelListObject[p] = CSchematicPinObject.CMLabelListObject[p];	
	}
	
	count = CSchematicPinObject.CRubberBandPinList.GetSize();

	CRubberBandPinList.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CRubberBandPinList[p] = CSchematicPinObject.CRubberBandPinList[p];
	}
}

void TCSchematicPinObject::Serialize(CArchive& CArchiveFile)
{
	TCGraphicBitMapVectorObject::Serialize(CArchiveFile);

	int count;

	if(CArchiveFile.IsStoring())
	{
		count = CMLabelListObject.GetSize();

		CArchiveFile << count;

		for(int p = 0; p < count; p++) CMLabelListObject[p].Serialize(CArchiveFile);		
	}
	else
	{
		CArchiveFile >> count;

		CMLabelListObject.SetSize(count, count);

		for(int p = 0; p < count; p++) CMLabelListObject[p].Serialize(CArchiveFile);
	}	
}

bool TCSchematicPinObject::Create(CDC *PCViewDC, TCSchematicPinData  &CSchematicPinData, float zoom, unsigned char  rotation_state, unsigned char  mirror_state)
{
	m_zoom = zoom;
	bool result = 0;

	CMSchematicPinData	= CSchematicPinData;
	m_type				= CMSchematicPinData.type;
	CMLocationOffset	= CSchematicPinData.CLocationOffset;
	m_rotation_state	= rotation_state;
	m_mirror_state		= mirror_state;

	m_active_line_color = GCSuperSpiceGlobalData.CColorData.pin_normal;// added 16 May 2002 for reducing saved data.

	m_property = E_SCHEMATIC_PIN;

	if(!GCSuperSpiceDataBase.CMDefaults[m_type].f_vector_graphic)
	{

	}
	else
	{
		Rotate(m_rotation_state);

		ZoomRaw();
	
		  result = TCGraphicBitMapVectorObject::Create(CMDrawLineData,
			(unsigned short)(GCSuperSpiceDataBase.CMDefaults[m_type].width * zoom), 
			(unsigned short)(GCSuperSpiceDataBase.CMDefaults[m_type].height * zoom),
			GCSuperSpiceGlobalData.CColorData.pin_normal,
			GCSuperSpiceGlobalData.CColorData.pin_selected, 
			GCSuperSpiceGlobalData.CColorData.pin_highlighted);
	}

	if(!CreateLabels(PCViewDC, CSchematicPinData)) return false;

	return result;
}

void TCSchematicPinObject::ZoomSymbolData(CArray<TCLineData, TCLineData &> &CSymbolData)
{
	int size = CSymbolData.GetSize();

	CMDrawLineData.SetSize(size, size);

	for(int p = 0; p < size; p++)
	{
		CMDrawLineData[p] = CSymbolData[p];

		CMDrawLineData[p].Zoom(m_zoom);
	}
}

void TCSchematicPinObject::ZoomRaw(void)
{
	int size = CMDrawLineData.GetSize();

	for(int p = 0; p < size; p++)
	{
		CMDrawLineData[p].Zoom(m_zoom);
	}
}
void TCSchematicPinObject::Rotate(int rotate_state)
{
	switch(rotate_state)
	{
		case E_FIRST_QUADRANT:
		{
			if(m_mirror_state)
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
				}
			}

		} break;
		case E_SECOND_QUADRANT: // one rotate
		{
			if(!m_mirror_state)
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
				}
			}
			else
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
				}
			}
		} break;
		case E_THIRD_QUADRANT:  // two rotates
		{
			if(!m_mirror_state)
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
				}
			}
			else
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
				}
			}
		} break;
		case E_FORTH_QUADRANT: // three rotates
		{
			if(!m_mirror_state)
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
				}
			}
			else
			{
				switch (m_type)
				{
					case E_POINTING_UP_PIN_COMPONENT: m_type = E_POINTING_RIGHT_PIN_COMPONENT; break;
					case E_POINTING_DOWN_PIN_COMPONENT: m_type = E_POINTING_LEFT_PIN_COMPONENT; break;
					case E_POINTING_LEFT_PIN_COMPONENT: m_type = E_POINTING_DOWN_PIN_COMPONENT; break;
					case E_POINTING_RIGHT_PIN_COMPONENT: m_type = E_POINTING_UP_PIN_COMPONENT; break;
				}
			}
		} break;
	}

	CArray <TCLineData, TCLineData &> &CSymbolData = GCSuperSpiceDataBase.CMDefaults[m_type].CSymbolData.CData;

	GCSuperSpiceDataBase.CMDefaults[m_type].CSymbolData;

	int size = CSymbolData.GetSize();

	CMDrawLineData.SetSize(size, size);

	for(int p = 0; p < size; p++)
	{
		CMDrawLineData[p] = CSymbolData[p];
	}
}

void TCSchematicPinObject::Flip(void)
{

}
void TCSchematicPinObject::Mirror(void)
{

}

bool TCSchematicPinObject::CreateLabels(CDC *PCViewDC, TCSchematicPinData  &CSchematicPinData)
{
	CString CText;
	CSchematicPinData;

	int count = CSchematicPinData.CLabelListData.GetSize();

	CMLabelListObject.SetSize(count, count);

	for(int p = 0; p < count; p++)
	{
		CText = CSchematicPinData.CLabelListData[p].CLabel;

		CMLabelListObject[p].DeleteBitmapNew();

		CMLabelListObject[p].m_property = E_SCHEMATIC_PIN_LABEL;


		if(CSchematicPinData.CLabelListData[p].is_visable)

			if(!CMLabelListObject[p].Create(PCViewDC, CText, m_zoom, 
									GCSuperSpiceGlobalData.CColorData.pin_text_normal,
									GCSuperSpiceGlobalData.CColorData.pin_text_selected, 
									GCSuperSpiceGlobalData.CColorData.pin_text_highlighted)) return false;

		CMLabelListObject[p].SetProperty(E_SCHEMATIC_PIN_LABEL);

		CMLabelListObject[p].m_visable = CSchematicPinData.CLabelListData[p].is_visable;

		CMLabelListObject[p].m_type = CSchematicPinData.CLabelListData[p].type;
	}

	return true;
}


int TCSchematicPinObject::IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CPoint CLocation, bool fine)
{
	int count = CMLabelListObject.GetSize();
	int result;
	if(!CSchematicComponentInfo) return 0;

	for(int p = 0; p < count; p++)
	{
		result = CMLabelListObject[p].IsThere(CLocation, fine);

		if(result)
		{
			CSchematicComponentInfo->type = E_SCHEMATIC_PIN_LABEL;

			CSchematicComponentInfo->label_id = p;
			CSchematicComponentInfo->CText		=
			CMSchematicPinData.CLabelListData[p].CLabel;

			return true;
		}
	}

	if(TCGraphicBitMapVectorObject::IsThere(CLocation, fine))
	{
		CSchematicComponentInfo->type = E_SCHEMATIC_PIN;
		
		return true;
	}

	return 0;
}

int TCSchematicPinObject::IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CRect CLocation, bool all_enclosed)
{
	int count = CMLabelListObject.GetSize();
	int result;
	if(!CSchematicComponentInfo) return 0;

	for(int p = 0; p < count; p++)
	{
		result = CMLabelListObject[p].IsThere(CLocation, all_enclosed);

		if(result)
		{
			CSchematicComponentInfo->type = E_SCHEMATIC_PIN_LABEL;

			CSchematicComponentInfo->label_id = p;
			CSchematicComponentInfo->CText		=
			CMSchematicPinData.CLabelListData[p].CLabel;

			return true;
		}
	}

	if(TCGraphicBitMapVectorObject::IsThere(CLocation, all_enclosed))
	{
		CSchematicComponentInfo->type = E_SCHEMATIC_PIN;	
	}

	return 0;
}



bool TCSchematicPinObject::Paste(CDC *PCDC, CPoint CLocation, bool is_visable, bool hyde_labels)
{
	TCGraphicBitMapVectorObject::Paste(PCDC, CLocation, m_zoom, is_visable);

	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		CMLabelListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable && !hyde_labels);
	}

	return true;
}

bool TCSchematicPinObject::PrintLabels(CDC *PCDC, CPoint CLocation)
{
	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	return true;
}

bool TCSchematicPinObject::VectorPrint(CDC *PCDC, CPoint CLocation)
{
	TCGraphicBitMapVectorObject::Print(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	return true;
}

bool TCSchematicPinObject::BitmapPrint(CDC *PCDC, CPoint CLocation)
{
	TCGraphicBitMapVectorObject::BitmapPrint(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	return true;
}

bool TCSchematicPinObject::Print(CDC *PCDC, CPoint CLocation)
{
	TCGraphicBitMapVectorObject::Print(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Print(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	return true;
}

bool TCSchematicPinObject::RePaste(CDC *PCDC, CPoint CLocation)
{
	TCGraphicBitMapVectorObject::RePaste(PCDC, CLocation);

	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].RePaste(PCDC, (CPoint)(CLocation + CLocationOffset));
	}

	return true;
}

void TCSchematicPinObject::PasteWithMove(CDC *PCDC, CPoint CLocation, float zoom, bool is_visable, bool hyde_labels)
{
	int grid_size		= (int)(GetGridSize() * m_zoom);
	int snap_to_grid	= GCSuperSpiceGlobalData.CDrawData.is_snap_to_grid_on;

	CPoint CGraphicPosition = CLocation;

	if(snap_to_grid) CGraphicPosition = SnapToGrid(CGraphicPosition, grid_size);

	if(!m_selected)
	{
		TCGraphicBitMapVectorObject::Paste(PCDC, CMLocation, zoom, is_visable);
	}
	else 
	{
		TCGraphicBitMapVectorObject::Paste(PCDC, CGraphicPosition, zoom, is_visable);
	}
	
	CPoint CLocationOffset;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{ 
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * zoom);

		if(CMLabelListObject[p].m_selected)
		{
			CMLabelListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), zoom, CMLabelListObject[p].m_visable);
		}
		else
		{
			CMLabelListObject[p].Paste(PCDC, (CPoint)(CMLocation + CLocationOffset), zoom, CMLabelListObject[p].m_visable && !hyde_labels);
		}
	}
}

void TCSchematicPinObject::StartMoveTo(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count;
	register int p;

	count = CMLabelListObject.GetSize();

	PCGraphicObject = CMLabelListObject.GetData();

	for(p = 0; p < count; p++)
	{ 
		if(PCGraphicObject->m_visable)
			PCGraphicObject->CreateBitmapBackgroundLabel(); 

		PCGraphicObject++;
	}
}
void TCSchematicPinObject::EndMoveTo(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count = CMLabelListObject.GetSize() - 1;
	register int p;

#ifdef _DEBUG// incase I forget

	if(count > 255)//debuging
	{
		ASSERT(0);

		return;
	}
#endif

	PCGraphicObject = CMLabelListObject.GetData();
	PCGraphicObject = PCGraphicObject + count;

	for(p = count; p >= 0; p--)
	{
		if(PCGraphicObject->m_visable)
			PCGraphicObject->CBitmapBackground.DeleteObject(); 

		PCGraphicObject--;
	}
}

bool TCSchematicPinObject::MoveTo(CDC *PCDC, CPoint CLocation, bool is_visable)
{
	int count = CMLabelListObject.GetSize();

	int p;

	for(p = count - 1; p > -1; p--)
	{
		if(CMLabelListObject[p].m_visable)
			CMLabelListObject[p].Clear(PCDC);
	}

	if(is_visable)TCGraphicBitMapVectorObject::Clear(PCDC);

	if(IsLabelSelected())
	{
		TCGraphicBitMapVectorObject::Paste(PCDC, CMLocation, m_zoom, is_visable);
	}
	else
	{
		TCGraphicBitMapVectorObject::Paste(PCDC, CLocation, m_zoom, is_visable);
	}
	CPoint CLocationOffset;

	count = CMLabelListObject.GetSize();

	for(p = 0; p < count; p++)
	{ 
		CLocationOffset = CMSchematicPinData.CLabelListData[p].CLocation;

		CLocationOffset.x = (int)(CLocationOffset.x * m_zoom);
		CLocationOffset.y = (int)(CLocationOffset.y * m_zoom);

		if(CMLabelListObject[p].m_selected)
		{
			CMLabelListObject[p].Paste(PCDC, (CPoint)(CLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable);
		}
		else
		{
			CMLabelListObject[p].Paste(PCDC, (CPoint)(CMLocation + CLocationOffset), m_zoom, CMLabelListObject[p].m_visable);
		}

	}
	return true;
}

bool TCSchematicPinObject::Clear(CDC *PCDC, bool hyde_labels)
{
	int count = CMLabelListObject.GetSize();

	if(!hyde_labels || IsLabelSelected())
	{
		for(int p = count - 1; p > -1; p--)
		{
			if(CMLabelListObject[p].m_visable)
				CMLabelListObject[p].Clear(PCDC);
		}
	}
	return TCGraphicBitMapVectorObject::Clear(PCDC);;
}

void  TCSchematicPinObject::DeleteBitmapBackgroundLabels(void)
{
	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMLabelListObject[p].CBitmapBackground.DeleteObject();
	}
}
void  TCSchematicPinObject::CreateBitmapBackgroundLabels(void)
{
	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMLabelListObject[p].CreateBitmapBackgroundLabel();
	}

}
bool TCSchematicPinObject::IsLabelSelected(void)
{
	register TCGraphicBitMapVectorObject *PCGraphicObject;
	register int count = CMLabelListObject.GetSize();

	PCGraphicObject = CMLabelListObject.GetData();

	for(int p = 0; p < count; p++)
	{
		if(PCGraphicObject->m_selected) return true;

		PCGraphicObject++;
	}

	return false;
}
void TCSchematicPinObject::UpdateLableLocations()
{
	CPoint CLabelLocation;

	CPoint CTemp;

	int count = CMLabelListObject.GetSize();

	for(int p = 0; p < count; p++)
	{ 
		CMLabelListObject[p].GetLocation(&CLabelLocation);

		CTemp = (CPoint)(CLabelLocation - CMLocation);

		CTemp.x	= (int)(CTemp.x / m_zoom);
		CTemp.y	= (int)(CTemp.y / m_zoom);

		CMSchematicPinData.CLabelListData[p].CLocation = CTemp;	
	}
}

TCSchematicPinData &TCSchematicPinObject::GetPinData(void)
{
	return CMSchematicPinData;
}

void TCSchematicPinObject::SetPinData(TCSchematicPinData &CSchematicPinData)
{
	CMSchematicPinData = CSchematicPinData;
}
//////////////////////////////////////////////////////////////////


///////////////////////////////////////////////
TCRubberBandPinData::TCRubberBandPinData(void)
{
	pin		= -1;
	PCObject = NULL;
	type	= 0;
}
TCRubberBandPinData::TCRubberBandPinData(TCRubberBandPinData &CRubberBandPinData)
{
	*this = CRubberBandPinData;
}
TCRubberBandPinData::~TCRubberBandPinData(void)
{

}

void TCRubberBandPinData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile  >> pin;	
		CArchiveFile  >> PCObject;
		CArchiveFile  >> type;
		CArchiveFile  >> CLocation;
	}
	else
	{
		CArchiveFile  >> pin;	
		CArchiveFile  >> PCObject;
		CArchiveFile  >> type;
		CArchiveFile  >> CLocation;
	}
}
void TCRubberBandPinData::operator = (TCRubberBandPinData &CRubberBandPinData)
{
	CRubberBandPinData;

	pin			= CRubberBandPinData.pin;
	CLocation	= CRubberBandPinData.CLocation;
	PCObject	= CRubberBandPinData.PCObject;
	type		= CRubberBandPinData.type;
}
/////////////////////////////////////////////

//////////////////////////////////////////////////////////
TCRubberBandData::TCRubberBandData(void)
{
	CPinList.SetSize(0, 4);
}
TCRubberBandData::TCRubberBandData(TCRubberBandData &CRubberBandData)
{
	*this = CRubberBandData;
}
TCRubberBandData::~TCRubberBandData(void)
{

}

void TCRubberBandData::Serialize(CArchive& CArchiveFile)
{
	int count;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		count = CPinList.GetSize();

		CArchiveFile << count;
	
		for(int p = 0; p < count; p++) CPinList.Serialize(CArchiveFile);

	}
	else
	{
		CArchiveFile >> count;

		CPinList.SetSize(count, 4);

		for(int p = 0; p < count; p++) CPinList.Serialize(CArchiveFile);
	}
}

void TCRubberBandData::operator = (TCRubberBandData &CRubberBandData)
{
	int count = CRubberBandData.CPinList.GetSize();

	CPinList.SetSize(count, 4);

	for(int p = 0; p < count; p++)
	{
		CPinList[p] = CRubberBandData.CPinList[p];
	}
}
/////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////


