#ifndef _TCSCHEMATIC_OBJECT_H
#define _TCSCHEMATIC_OBJECT_H


#include "TCGraphicObject.h"
#include "TCGraphicBitMapVectorObject.h"
#include "TCSchematicObjectData.h"
#include "TCFloatingCursorData.h"

class TCSchematicManager;
class TCSignal;
class TCTestPointData;


enum TE_RUBBERBAND_DATA
{
	E_RUBBERBAND_START,
	E_RUBBERBAND_END,

};

class TCRubberBandPinData : public CObject
{
	public:	TCRubberBandPinData(void);
			TCRubberBandPinData(TCRubberBandPinData &CRubberBandPinData);
			~TCRubberBandPinData(void);

			int					pin;
			CPoint				CLocation;
			TCSchematicObject	*PCObject;
			int					type;

			void operator = (TCRubberBandPinData &CRubberBandPinData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCRubberBandPinData)

};

class TCRubberBandData : public CObject
{
	public:	TCRubberBandData(void);
			TCRubberBandData(TCRubberBandData &CRubberBandData);
			~TCRubberBandData(void);

			CArray <TCRubberBandPinData, TCRubberBandPinData&> CPinList;

			void operator = (TCRubberBandData &CRubberBandData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCRubberBandData)

};

class TCSchematicComponentInfo
{
	public: 
			int id;
			int type;
			int pin_id;
			int label_id;
			CString CText;
};



class TCPinObjectState
{
	public:
			CArray <bool, bool &> CSelected;
			CArray <bool, bool &> CHighlighted;
};

class TCSchematicPinObject : public TCGraphicBitMapVectorObject
{
	private:	
				
				TCSchematicPinData		CMSchematicPinData;
				bool CreateLabels(CDC *PCViewDC, TCSchematicPinData &CSchematicPinData);

				friend class TCSchematicManager;

				CArray <TCRubberBandPinData, TCRubberBandPinData&> CRubberBandPinList;

	public:	TCSchematicPinObject();
			~TCSchematicPinObject();

			void DeleteBitmapBackgroundLabels(void);
			void CreateBitmapBackgroundLabels(void);

			CArray<TCGraphicBitMapVectorObject, TCGraphicBitMapVectorObject&> CMLabelListObject;

			void operator = (TCSchematicPinObject  &CSchematicPinObject);
			virtual void Serialize(CArchive& CArchiveFile);

			bool Create(CDC *PCViewDC, TCSchematicPinData &CSchematicPinData, float zoom, unsigned char rotate_state, unsigned char  mirror_state);

			
			int IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CPoint CLocation, bool fine = false);
			int IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CRect CLocation, bool all_enclosed);
			bool Paste(CDC *PCDC, CPoint CLocation, bool is_visable, bool hyde_labels);
			bool MoveTo(CDC *PCDC, CPoint CLocation, bool is_visable);
			bool Clear(CDC *PCDC, bool hyde_labels);
			void StartMoveTo(void);
			void EndMoveTo(void);
			bool Print(CDC *PCDC, CPoint CLocation);
			bool RePaste(CDC *PCDC, CPoint CLocation);
			void SetView(CView *PCView);
			bool IsLabelSelected(void);
			void UpdateLableLocations(void);
			TCSchematicPinData &GetPinData(void);
			void SetPinData(TCSchematicPinData &CMSchematicPinData);
			void SetPageId(int page_id);
			void ZoomSymbolData(CArray<TCLineData, TCLineData &> &CSymbolData);
			void ZoomRaw(void);
			void Rotate(int rotate_state);
			void Flip(void);
			void Mirror(void);
			void PasteWithMove(CDC *PCDC, CPoint CLocation, float zoom, bool is_visable, bool hyde_labels);

			bool PrintLabels(CDC *PCDC, CPoint CLocation);
			bool VectorPrint(CDC *PCDC, CPoint CLocation);
			bool BitmapPrint(CDC *PCDC, CPoint CLocation);

			DECLARE_SERIAL(TCSchematicPinObject)

};


class TCSchematicObject : public TCGraphicBitMapVectorObject
{
	private:	CArray<TCSchematicPinObject, TCSchematicPinObject&> CMPinListObject;
				CArray<TCGraphicBitMapVectorObject, TCGraphicBitMapVectorObject&> CMLabelListObject;
				
				void ZoomRaw(void);

				bool CreateLabels(CDC *PCViewDC);
				bool CreateWaveform(float zoom, bool refresh = false);
				bool CreateWaveformLabels(CDC *PCViewDC);
				bool CreateWaveformPoints(int refresh = false);
				bool CreateWaveformPoints(int index, TCSignal &CSignalX, TCSignal &CSignalY, int type, int refresh = false);
				bool CreateWaveformWindow(void);
				bool CreateWaveformAxis(void);
				bool CreateWaveformWindowOutline(void);
				bool UpdateMarchingWaveform(CDC *PCViewDC, int run_number);
				bool UpdateGraphScaleFactors(CDC *PCViewDC, int run_number);
				void SetupMarchingWaveforms(TCWaveformDataRuns *PCWaveformDataRunsNew, CArray <TCSignal, TCSignal&> *PCSignalsNew, int waveform_type, int run_number);

				bool CreateTopWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float);
				bool CreateLeftWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float);
				bool CreateBottomWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float);
				bool CreateRightWaveformAxis(int location, int count, int minor_count, int increment, int tick_size, int type, float points_per_float);
				
				
				bool SetupBottomWaveformLabels(void);
				bool SetupRightWaveformLabels(void);
				bool SetupLeftWaveformLabels(void);
				void CreateMagnitudeGraphLines(void);
				void CreatePhaseGraphLines(void);

				bool CreateWaveformPins(CDC *PCViewDC);// pins are tick marks
				bool GetXSignalData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, int wave_index, int xindex);
				bool GetYSignalData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, int wave_index, int yindex);
				bool GetSignalData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, int wave_index, int index, int is_xindex);

				bool CreatePins(CDC *PCViewDC);
				void CreateWirePinData(void);

				void ZoomSymbolData(CArray<TCLineData, TCLineData &> &CSymbolData);
				void RotateSymbolData(bool current_not_next);
				void MirrorSymbolData(int current_not_next);
				void FlipSymbolData(int current_not_next);

				friend class TCNetList;
				friend class TCSchematicManager;
				friend class TCOutputWaveformDoc;
				friend class TCOutputWaveformView;

				unsigned short m_local_width;
				unsigned short m_local_height;

				int original_bck_colour;// for printing
				

	public:	TCSchematicObject();
			TCSchematicObject(TCSchematicObject &CSchematicObject);
			virtual ~TCSchematicObject();

			// I dont fucking care about private data!!! 
			TCSchematicObjectData	 CMSchematicObjectData;
			int		active_magnitude_axis_index;
			int		active_phase_axis_index;
			int		xaxis_start_index;
			int		yphase_axis_start_index;
			int		ymagnitude_axis_start_index;
			int		y_magnitude_axis_signal_name_index;
			int		y_phase_axis_signal_name_index;

			int		is_digital;// used for wires only 

			void FormatLabels(void);
			void UpdateSchematicObject(void);
			void operator = (TCSchematicObject  &CSchematicObject);
			void Serialize(CArchive& CArchiveFile);
			void SerializeLabelsAndPins(CArchive& CArchiveFile);

			void ReLabelAxis(void);
			void ReLabelAxisSignalNames(CDC *PCViewDC);
			bool ReLabelRequired(void);
			bool ReLabelLeftAxisSignalName(CDC *PCViewDC);
			bool ReLabelRightAxisSignalName(CDC *PCViewDC);
			void RePasteSingleLabel(CDC *PCViewDC, int id);

			bool GetWaveformData(TCFloatingCursorData &CFloatingCursorData, CPoint CLocation, bool ignor_auto_axis = false);

			bool Create(CDC *PCViewDC, TCSchematicObjectData &CSchematicObjectData, float zoom);
			CRect GetGrabRegion(TCSchematicComponentInfo &CSchematicComponentInfo);
			void SetPageId(int page_id);
			int IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CPoint CLocation,bool fine = false);
			int IsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CRect CLocation, bool all_enclosed, bool ignor_pins);
			int PinIsThere(TCSchematicComponentInfo *CSchematicComponentInfo, CRect CLocation, bool all_enclosed);
			bool IsLabelOrPinLabelOrPinSelected(void);
			bool IsLabelSelected(void);
			bool IsPinSelected(void);
			bool IsPinLabelSelected(void);
			bool GetLabelOrPinLabelLocation(CPoint *CLocation);

			bool IsLabelOrPinLabelOrPinHighlighted(void);
			bool IsLabelHighlighted(void);
			bool IsPinHighlighted(void);
			bool IsPinLabelHighlighted(void);
			void DeleteBitmapBackgroundLabels(void);
			void CreateBitmapBackgroundLabels(void);
			void CreateWirePins(CDC *PCDC);
			bool CheckAndNullWaveformDataPointers(void);

			bool GetSelect(void);
			bool GetHighlight(void);

			virtual void Mirror(void);
			virtual void Rotate(void);
			virtual void Flip(void);

			bool Paste(CDC *PCDC, CPoint CLocation, bool hyde_labels = false);
			bool MoveTo(CDC *PCDC, CPoint CLocation,int snap_to_grid_is_enabled, bool hyde_labels = false);
			bool Clear(CDC *PCDC, bool hyde_labels = false);
			void ClearLabel(CDC *PCDC, int id);
			void RepasteLabel(CDC *PCDC, int id);
			void ClearAllLabels(CDC *PCDC);
			void RepasteAllLabels(CDC *PCDC);

			void ClearAllPhaseLabels(CDC *PCDC);
			void ClearAllAllMagnitudeLabels(CDC *PCDC);
			void RepasteAllPhaseLabels(CDC *PCDC);
			void RepasteAllMagnitudeLabels(CDC *PCDC);

			void StartMoveTo(void);
			void EndMoveTo(void);
			bool Print(CDC *PCDC, CPoint CLocation);
			bool RePaste(CDC *PCDC, CPoint CLocation);
			void SetView(CView *PCView);
			void Zoom(float zoom);
			void UpdateSchematicObjectData(void);
			void UpdateLabel(void);
			virtual void SetAbsoluteLocation(CPoint &CAbsLocation);
			virtual TCWireInfo &GetWireInfo(void);
			void SetSelect(void);
			void ResetSelect(void);
			void SetHighlighted(void);
			void UpdateLableAndPinLocations(void);
			int GetNumberOfLabels(void);
			int GetNumberOfPinLabels(int pin_id);
			int GetNumberOfPins(void);
			CRect GetPinGrabRegion(int pin);
			CRect GetLabelLocation(int label_id);
			CRect GetPinLabelLocation(int pin_id, int label_id);
			CRect GetComponentExtent(void);
			void ClearConnectionDots(CDC *PCViewDC);
			void DisplayConnectionDot1(CDC *PCViewDC);
			void DisplayConnectionDot2(CDC *PCViewDC);

			
			void	SetLabel(CDC *PCViewDC, int id, CString CText, bool redraw = true) ;
			CString GetLabel(int id) ;
			CString	GetLabel(void);
			void	SetPinLabel(CDC *PCViewDC, int pin_id, int label_id, CString CText);
			CString GetPinLabel(int pin_id, int label_id);

			void SetSelectLabel(CDC *PCViewDC, int label_id, bool select = true);
			void SetSelectPinLabel(CDC *PCViewDC, int pin_id, int label_id, bool select = true);
			void SetSelectPin(CDC *PCViewDC, int pin_id, bool select = true);

			bool GetSelectLabel(int label_id);
			bool GetSelectPinLabel(int pin_id, int label_id);
			bool GetSelectPin(int pin_id);

			bool StartDrawingLine(CDC *PCDC, CPoint CMousePosition, float zoom);
			bool ContinueDrawingLine(CDC *PCDC, CPoint CMousePosition, int snap_to_grid_is_enabled);
			bool StopDrawingLine(CDC *PCDC, CPoint CMousePosition, bool is_symbol_editor);


			TCSchematicObjectData &GetSchematicObjectData(void);
			bool SetSchematicObjectData(CDC *PCViewDC, TCSchematicObjectData &CSchematicObjectData);


			bool Print(CDC *PCDC);
			bool VectorPrint(CDC *PCDC);
			bool VectorPrint(CDC *PCDC, CPoint CLocation);
			bool BitmapPrint(CDC *PCDC);
			bool BitmapPrint(CDC *PCDC, CPoint CLocation);
			bool PrintLabels(CDC *PCDC);

			virtual void CreateGrabRegion(CPoint CLocation);


			void DrawBackground(CDC *PCViewDC, CPoint CLocation);
			void DrawGrid(CDC *PCViewDC, CPoint CLocation);

			void WaveFormZoom(CDC *PCViewDC, CRect CZoomRect);
			void WaveFormZoom(CRect CZoomRect);
			void WaveFormScrollXRight(void);
			void WaveFormScrollXLeft(void);
			void WaveFormScrollYUp(void);
			void WaveFormScrollYDown(void);
			void WaveFormMagnify(void);
			void WaveFormReduce(void);
			void WaveFormAutoScale(void);
			void ReCreate(void);
			bool ChangeWaveform(TCTestPointData &CTestPointData);
			bool ChangeColour(TCTestPointData &CTestPointData);
			void ClearAllWaveforms(void);
			void ChangeBKGColour(int colour);
			bool GetVirtualParameterModel(CArray <CString, CString&> &CTextArray, TCAnalysisSetup &CAnalysisSetup);
			
			void SerializeSchematicDataLoadSave(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSchematicObject)

};


#endif