#ifndef _TCSCHEMATIC_OBJECT_DATA_H
#define _TCSCHEMATIC_OBJECT_DATA_H

#include "TCSuperSpiceGlobalData.h"
#include "TCStringFunctions.h"
#include "TCSpiceParameters.h"
#include "TCDataBaseIdInfo.h"
#include "TCGraphicObject.h"
#include "TCGeneratorData.h"


class TCOutputWaveformDataHeader;
class TCWaveformDataRuns;
class TCSchematicDataLoadSave;

enum TE_RESERVED_SCHEMATIC_OBJECT_DATA
{
	E_RESERVED_PCB_PACKAGE_NAME = 0,
	E_RESERVED_PCB_COMPONENT_NAME = 1,

	E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX,
};

enum TE_RESERVED_INT_COMPONENT_DATA
{
	E_RESERVED_INT_COMPONENT_PCB_INCLUDE = 0,
	E_RESERVED_INT_COMPONENT_SPICE_INCLUDE,
	E_RESERVED_INT_COMPONENT_POWER,
	E_RESERVED_INT_COMPONENT_TRANSIENT_POWER,
	E_RESERVED_INT_DESIGNER_TYPE,
	E_RESERVED_INT_DESIGNER_VALUE,
	E_RESERVED_INT_DESIGNER_CALC_MODE,
	E_RESERVED_INT_COMPONENT_DATA_MAX,
};

enum TE_VALUE_DESIGNER_TYPES
{
	E_VALUE_DESIGNER_POSITIVE_NONE  = 0,
	E_VALUE_DESIGNER_POSITIVE_VOLTS,
	E_VALUE_DESIGNER_NEGATIVE_VOLTS,
	E_VALUE_DESIGNER_CURRENT,

};

class TCSchematicPinData : public TCGraphicObjectData
{
	public:	
			TCSchematicPinData(void);

//			CArray <TCGraphicObjectData, TCGraphicObjectData&> CLabelListData;
			CArray <TCGraphicPinObjectData, TCGraphicPinObjectData&> CLabelListData;

			void operator = (TCSchematicPinData  &CSchematicPinData);
			void Copy(TCSchematicPinData &CSchematicPinData);

			virtual void Serialize(CArchive& CArchiveFile);
	
			DECLARE_SERIAL(TCSchematicPinData)
};

class TCSuperSpiceDoc;

class TCSymbolData : public CObject
{
	public:	TCSymbolData(void);
			TCSymbolData(TCSymbolData &CSymbolData);
			~TCSymbolData(void);

			CString CName;
			CString CFileName;
			CString CFilePath;
			CString CDescription;

//			CString			CParentFileName;//symbol may be a whole schematic
			TCSuperSpiceDoc *PCParentSpiceDoc;
			CString			CChildFileName;
			TCSuperSpiceDoc *PCChildSpiceDoc;

			CArray<TCLineData, TCLineData &>CData;

			void operator = (TCSymbolData &CSymbolData);
			void Copy(TCSymbolData &CSymbolData);
	
			void Serialize(CArchive& CArchiveFile);
			void Rescale(float scale);
			bool CopyToNewDir(CString CPath);

			DECLARE_SERIAL(TCSymbolData)

};

class TCSchematicObjectData : public TCGraphicObjectData
{
	public:

			TCSchematicObjectData(void);
			~TCSchematicObjectData();
			TCSchematicObjectData(TCSchematicObjectData &CSchematicObjectData);

			void operator =  (TCSchematicObjectData &CSchematicObjectData);
			void Copy(TCSchematicObjectData &CSchematicObjectData);

			bool FormatLabel(void);
			bool FormatCLabel(int label_id);
			bool FormatLabels(void);
			bool FormatRecordName(void);
			bool FormatSpiceName(void);
			bool FormatComponent(void);
			bool FormatSpiceValue(void);
			bool FormatWire(void);

			bool FormatTestMarker(void);
			bool FormatResistor(void);
			bool FormatCapacitor(void);
			bool FormatICResistor(void);
			bool FormatICCapacitor(void);
			bool FormatInductor(void);
			bool FormatDiode(void);
			bool FormatTransistor(void);
			bool FormatFet(void);
			bool FormatMOS(void);
			bool FormatDCGenerator(void);
			bool FormatSineGenerator(void);
			bool FormatPulseGenerator(void);
			bool FormatExpGenerator(void);
			bool FormatPWLGenerator(void);
			bool FormatSFFMGenerator(void);
			bool FormatVCVC(void);
			bool FormatICVC(void);
			bool FormatVCVIC(void);
			bool FormatICIC(void);
			bool FormatMultiplier(void);
			bool FormatVCA(void);
			bool FormatOpAmp(void);
			bool FormatVSwitch(void);
			bool FormatISwitch(void);
			bool FormatTransformer(void);
			bool FormatTransmissionLine(void);
			bool FormatLosslessTransmissionLine(void);
			bool FormatSubcircuit(void);
			bool FormatLaplace(void);
			bool FormatVariableResistor(void);
			bool FormatURC(void);
			
			CString GetSpiceValue(TCAnalysisSetup &CAnalysisSetup);
			double  GetComponentValue(int label_id);
			double  GetComponentLabelValue(int label_id);
			CString GetComponentValueSpiceString(int label_id);
			CString GetComponentLabelValueSpiceString(int label_id);
			CString GetSchematicParameters(void);
			double  EvaluateComponentValue(CString CLable);
			CString GetResistorValue(void);
			CString GetCapacitorValue(void);
			CString GetInductorValue(void);
			CString GetICResistorValue(void);
			CString GetICCapacitorValue(void);
			CString GetBipolarValue(void);
			CString GetFetValue(void);
			CString GetMosValue(void);
			CString GetDiodeValue(void);
			CString GetTransmissionLineValue(void);
			CString GetLosslessTransmissionLineValue(void);
			CString GetSubCircuitDefaultValue(void);
			CString GetLaplaceValue(void);
			CString GetSubCktValue(void);
			CString GetURCValue(void);
			CString GetControlledSourceValue(void);

			CString GetDCSourceValue(bool normal = 0);
			CString GetSineSourceValue(bool normal = 0);
			CString GetPulseSourceValue(bool normal = 0);
			CString GetExpSourceValue(bool normal = 0);
			CString GetPWLSourceValue(bool normal = 0);
			CString GetSFFMSourceValue(bool normal = 0);
			bool GetWidthAndLength(double &width, double &height);
			CString GetTCMString(int tc1, int tc2, int m_id);
			CString GetSymbolParameters(void);

			void SetGeneratorLabelSize(int version);

			bool GetVirtualParameterModel(CArray <CString, CString&> &CTextArray, TCAnalysisSetup &CAnalysisSetup);
			void SetWaveFormLabels(TCOutputWaveformDataHeader &COutputWaveformDataHeader);

			bool	GetDeviceCurrentNodeNames(CArray <CString, CString> &CDeviceNodes);
			bool	IsWorstCaseGenerator(void);
			bool	IsWorstCaseQRC(void);

			void Rescale(float scale);
			bool IsStraightVectorsOnly(void);

			virtual void Serialize(CArchive& CFileArchive);
			void	SerializeSymbolData(CArchive& CFileArchive);

			bool Load(CString CFileName);
			bool Save(CString CFileName);
			bool Rename(CString CNewName);

			bool CheckAndNullWaveformDataPointers(void);

			TCVersionInfo CVersionInfo;
			TCSymbolData  CSymbolData;

			CArray <TCSchematicPinData, TCSchematicPinData &> CPinListData;
			CArray <TCGraphicObjectData, TCGraphicObjectData &> CLabelListData;

			bool				f_validate_label_value;
			bool				format_spice_value;	
			unsigned char		component_property_view_type;
			short				version;						// voltage or current sin, pulse etc
			unsigned char		attached_model_type;
			unsigned char		is_unique_model;

			CArray <TCNameValueData, TCNameValueData>	COpPoints; // 25th Dec 2016, not saved/not seralised, calculated as needed


			TCOutputWaveformDataHeader *PCOutputWaveformDataHeader;// used for waveform and alows graphs to be put on schematic

			TCGeneratorData		*PCGeneratorData;

			TCSpiceParameters	CSpiceParameters;
			CPoint				CGrabOffset;

			TCComponentInfo		CComponentInfo;

			int					 m_rerun_enable; //this is a quick fix, should pass through the data
			int					 m_parameter_enable; //this is a quick fix, should pass through the data
			TCAnalysisSetup		*PCMAnalysisSetup;

			TCReserved			CReserved;// set of ints and strings for future expansion, if required. adds 128 bytes
			
			HTREEITEM			HTreeItem;

			bool RecreateSchematicData(TCSchematicDataLoadSave &CSchematicDataLoadSave);

			void operator = (TCSchematicDataLoadSave &CSchematicDataLoadSave);


			DECLARE_SERIAL(TCSchematicObjectData)
};

class TCSchematicDataLoadSave : public CObject
{
	public:	TCSchematicDataLoadSave(void);
			TCSchematicDataLoadSave(TCSchematicDataLoadSave &CSchematicDataLoadSave);
			~TCSchematicDataLoadSave(void);
			
			CArray <TCGraphicObjectData, TCGraphicObjectData &> CLabelListData;

			char				f_validate_label_value;
			char				format_spice_value;	
			char				component_property_view_type;
			char				version;						
			unsigned char		attached_model_type;


			TCGeneratorData				*PCGeneratorData; //need to keep this.
			TCOutputWaveformDataHeader  *PCOutputWaveformDataHeader;


			CString CRecordName;		//instrad of saving CSpiceParameters
			CString CRecordFilePathAndName; 

			CString CSymbolName;
			CString CSymbolFilePathAndName;
			CString	CSymbolChildFileName;

			unsigned char	mirror_state;
			unsigned char	rotation_state;
			unsigned short  type; 
			char			class_version;


			void operator = (TCSchematicDataLoadSave &CSchematicDataLoadSave);
			void operator = (TCSchematicObjectData &CSchematicObjectData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSchematicDataLoadSave)

};


#endif