// TCSensitivityDialog.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCSensitivityDialog.h"
#include "TCOutputWaveformData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString FloatToMKSString(double data);

/////////////////////////////////////////////////////////////////////////////
// TCSensitivityDialog dialog


TCSensitivityDialog::TCSensitivityDialog(CWnd* pParent /*=NULL*/)
	: CDialog(TCSensitivityDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCSensitivityDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	PCWaveformDataRuns = NULL;
}


void TCSensitivityDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSensitivityDialog)
	DDX_Control(pDX, IDC_LIST_RUNS, CMListRuns);
	DDX_Control(pDX, IDC_LIST_POLEL_ZERO_DATA, CMListSensitivity);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSensitivityDialog, CDialog)
	//{{AFX_MSG_MAP(TCSensitivityDialog)
	ON_LBN_SELCHANGE(IDC_LIST_RUNS, OnSelchangeListRuns)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSensitivityDialog message handlers

BOOL TCSensitivityDialog::OnInitDialog() 
{

	CDialog::OnInitDialog();

	DisplayData();

	return TRUE;  	              
}


void TCSensitivityDialog::DisplayData(void)
{
	if(!PCWaveformDataRuns) return;

	DisplayRuns();

	DisplaySensitivity();

	UpdateData(false);
}

void TCSensitivityDialog::OnSelchangeListRuns() 
{
	DisplayData();	
}

void TCSensitivityDialog::DisplayRuns(void)
{
	if(!PCWaveformDataRuns) return;

	int run_index = CMListRuns.GetCurSel();

	int count = PCWaveformDataRuns->CRuns.GetSize();

	if(!(run_index < count)) run_index = 0;

	if(run_index < 0) run_index = 0;

	CMListRuns.ResetContent();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		if(!PCWaveformDataRuns->CRuns[p]) return;

		CText = PCWaveformDataRuns->CRuns[p]->CRunDiscription;

		CMListRuns.AddString(CText);
	}

	CMListRuns.SetCurSel(run_index);
}

void TCSensitivityDialog::DisplaySensitivity(void)
{
	if(!PCWaveformDataRuns) return;

	int count = PCWaveformDataRuns->CRuns.GetSize();

	int run_index = CMListRuns.GetCurSel();

	if(!(run_index < count)) run_index = 0;

	if(run_index < 0) run_index = 0;

	CMListSensitivity.ResetContent();

	if(!PCWaveformDataRuns->CRuns[0]) return;

	TCOutputWaveformData &COutputWaveformData = *PCWaveformDataRuns->CRuns[run_index];

	if(!(E_SPICE_RECORD_POLE_ZERO < COutputWaveformData.CRecords.GetSize())) return;

	TCOutputWaveformDataRecord& CRecords = COutputWaveformData.CRecords[E_SPICE_RECORD_SENSITIVITY];

	int num_signals = CRecords.CSignals.GetSize();

	if(!num_signals) return;

	CString CText;
	CString CTextHeader;

	int phase_size;

	for(int p = 0; p < num_signals; p++)
	{
	  	TCSignal &CSignal = CRecords.CSignals[p];

		if(!CSignal.CMagnitudeData.CX.GetSize()) return;

		CTextHeader = CSignal.CName + ":      ";

		CText = CTextHeader + FloatToMKSString(CSignal.CMagnitudeData.CX[0]);

		phase_size = CSignal.CPhaseData.CX.GetSize();

		if(phase_size)
		{
			CText +="      " + FloatToMKSString(CSignal.CPhaseData.CX[0]);
		}

		CMListSensitivity.AddString(CText);	
	}
}
