// TCSignalsTreeView.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCSuperSpiceMainFrame.h"
#include "TCOutputWaveformChildFrame.h"
#include "TCSuperSpiceView.h"
#include "TCWaveformGraphicsManager.h"
#include "TCOutputWaveformData.h"
#include "TCOutputWaveformView.h"
#include "TCOutputWaveformDoc.h"
#include "TCSignalsTreeView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCSignalsTreeView

IMPLEMENT_DYNCREATE(TCSignalsTreeView, CListView )

TCSignalsTreeView::TCSignalsTreeView()
{
	m_waveform_type = -1;
	PCMWaveformRuns = NULL;
}

TCSignalsTreeView::~TCSignalsTreeView()
{
}


BEGIN_MESSAGE_MAP(TCSignalsTreeView, CListView )
	//{{AFX_MSG_MAP(TCSignalsTreeView)
	//}}AFX_MSG_MAP

	ON_NOTIFY_REFLECT(NM_CLICK, OnClickTree)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSignalsTreeView drawing

void TCSignalsTreeView::OnDraw(CDC* pDC)
{
	pDC;
	CDocument* pDoc = GetDocument();
	pDoc;
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// TCSignalsTreeView diagnostics

#ifdef _DEBUG
void TCSignalsTreeView::AssertValid() const
{
	CListView ::AssertValid();
}

void TCSignalsTreeView::Dump(CDumpContext& dc) const
{
	CListView ::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSignalsTreeView message handlers

void TCSignalsTreeView::OnClickTree(NMHDR * pNMHDR, LRESULT* pResult)
{
	*pResult = 0;

	if(!PCMWaveformRuns) return;

	pNMHDR;

	int index;

	CListCtrl &CSignalListCtrl = GetListCtrl();

	POSITION pos = CSignalListCtrl.GetFirstSelectedItemPosition();

	CArray <CString, CString> CSignalList;

	int p = 0;

	CSignalList.SetSize(32);

	while(pos)
	{
		index = CSignalListCtrl.GetNextSelectedItem(pos);

		CSignalList.SetAtGrow(p, CSignalListCtrl.GetItemText(index, 0));

		p++;
	}

	if(p) 
	{
		CSignalList.SetSize(p);

		UpdateGraphWaveforms(CSignalList);
	}
}

void TCSignalsTreeView::UpdateGraphWaveforms(CArray <CString, CString> &CSignalList)
{
	if(!PCMWaveformRuns) return;

	TCSuperSpiceMainFrame *PCSuperSpicMainFrame = (TCSuperSpiceMainFrame *) AfxGetMainWnd();

	CMDIChildWnd *PCMDIChildWnd = PCSuperSpicMainFrame->MDIGetActive();

	if(!PCMDIChildWnd) return;

	if(!PCMDIChildWnd->IsKindOf(RUNTIME_CLASS(TCOutputWaveformChildFrame))) return;

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc*) PCMDIChildWnd->GetActiveDocument();

	POSITION pos = PCDoc->GetFirstViewPosition();

	while(pos != NULL)
	{
		TCOutputWaveformView *PCOutputWaveformView = (TCOutputWaveformView*) PCDoc->GetNextView(pos);

		if(PCOutputWaveformView->m_current_waveform_type != m_waveform_type) continue;

		TCWaveformGraphicsManager *PCSchematicManager = (TCWaveformGraphicsManager *) PCOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

		PCSchematicManager->ChangeWaveformsFromList(CSignalList);
	}
}

void TCSignalsTreeView::UpdateAllData(void)
{
	if(!(m_waveform_type < 0)) LoadSignalsList(PCMWaveformRuns, m_waveform_type);
}

void TCSignalsTreeView::LoadSignalsList(TCWaveformDataRuns *PCWaveformRuns, int waveform_type)
{
	if(!PCWaveformRuns) return;
	if(IsBadReadPtr(PCWaveformRuns, sizeof(TCWaveformDataRuns))) 
	{
		PCWaveformRuns = NULL;

		return;
	}

	if(!PCWaveformRuns->CRuns.GetSize()) return;
	if(!PCWaveformRuns->CRuns[0]) return;
	if(IsBadReadPtr(PCWaveformRuns->CRuns[0], sizeof(TCOutputWaveformData))) return;

	m_waveform_type = waveform_type;

	if(m_waveform_type < 0) m_waveform_type = PCWaveformRuns->CRuns[0]->GetFirstActiveAnalysisType();

	if(m_waveform_type < 0) return;

	PCMWaveformRuns = PCWaveformRuns;

	if(!(m_waveform_type < PCWaveformRuns->CRuns[0]->CRecords.GetSize())) return;

	TCOutputWaveformDataHeader *PCHeader = &PCWaveformRuns->CRuns[0]->CRecords[m_waveform_type].CHeader;

	if(!PCHeader) return;

	if(IsBadReadPtr(PCHeader->PCSignals, 4)) return;

	CListCtrl &CSignalListCtrl = GetListCtrl();

	CSignalListCtrl.DeleteAllItems();
	CSignalListCtrl.DeleteColumn(0);

	CString CTextHeader = PCHeader->CPlotName;

	CSignalListCtrl.InsertColumn(0, CTextHeader, LVCFMT_LEFT, 1024);

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	for(int p = 0; p < count; p++)
	{
		CSignalListCtrl.InsertItem(p, CSignals[p].CName);
	}
}

BOOL TCSignalsTreeView::PreCreateWindow(CREATESTRUCT& cs) 
{	
	cs.style |= LVS_REPORT;

	return CListView ::PreCreateWindow(cs);
}

