// TCSimulationPropertyPages.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCReRuns.h"
#include "SuperSpice.h"
#include "TCSimulationPropertyPages.h"
#include "TCSuperSpiceDoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern int	g_last_active_simulation_setup_page;
CString RemoveExtention(CString);

IMPLEMENT_DYNCREATE(TCACSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCDCSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCNoiseSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCTransientSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCMonteWorstSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCParameterSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSensitivitiesSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSpiceOptionsSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCTemperatureSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCDistortionSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCPoleZeroSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCOutputSelectSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCReRunSetup, CPropertyPage)

/////////////////////////////////////////////////////////////////////////////
// TCACSetup property page

bool FileExists(CString &CName);

TCACSetup::TCACSetup() : CPropertyPage(TCACSetup::IDD)
{
	//{{AFX_DATA_INIT(TCACSetup)
	m_enable = FALSE;
	m_type = 0;
	m_enable_plot_all = FALSE;
	m_enable_print_all = FALSE;
	CMLoopGainSource = _T("");
	m_zero_phase = 0.0;
	m_plot_ac_analysis = FALSE;
	m_ac_analysis_type = 0;
	m_freq_device_mode = 0;
	//}}AFX_DATA_INIT

	m_stop = 1.0;
	m_start = 1.0;
	m_step = 1.0;	
}

TCACSetup::~TCACSetup()
{
}

void TCACSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCACSetup)
	DDX_Control(pDX, IDC_COMBO_LOOP_GAIN, CMComboSourceList);
	DDX_Check(pDX, IDC_CHECK_AC_ENABLE, m_enable);
	DDX_Radio(pDX, IDC_RADIO_DECADE_SWEEPS, m_type);
	DDX_MKSValue(pDX, IDC_EDIT_STOP_FREQUENCY, m_stop);
	DDX_MKSValue(pDX, IDC_EDIT_START_FREQUENCY, m_start);
	DDX_MKSValue(pDX, IDC_EDIT_NUMBER_OF_POINTS, m_step);
	DDX_CBString(pDX, IDC_COMBO_LOOP_GAIN, CMLoopGainSource);
	DDX_Text(pDX, IDC_EDIT_ZERO_PHASE_POINT, m_zero_phase);
	DDX_Check(pDX, IDC_CHECK_PLOT_LOOP_GAIN, m_plot_ac_analysis);
	DDX_Radio(pDX, IDC_RADIO_ANALYSIS, m_ac_analysis_type);
	DDX_Radio(pDX, IDC_RADIO_FREQ_DEVICE, m_freq_device_mode);
	DDX_Text(pDX, IDC_EDIT_REFDES_SWEEP_DEVICE, CMRefDesSweptDevice);
	DDX_Text(pDX, IDC_EDIT_SWEPT_DEVICE_FREQ, CMRefSweptDeviceFreq);
	DDX_Text(pDX, IDC_EDIT_AC_PARAM_RERUN_VALUE, CMMultiRunACParam);
	DDX_Text(pDX, IDC_STATIC_AC_START_FREQUENCY, CMStartFrequency);
	DDX_Text(pDX, IDC_STATIC_AC_STOP_FREQUENCY, CMStopFrequency);
	DDX_Text(pDX, IDC_STATIC_AC_POINTS, CMNumberOfPoints);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(TCACSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCACSetup)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_RADIO_FREQ_DEVICE2, &TCACSetup::OnBnClickedRadioSweepModeDevice)
	ON_BN_CLICKED(IDC_RADIO_FREQ_DEVICE, &TCACSetup::OnBnClickedRadioSweepModeFrequency)
	ON_BN_CLICKED(IDC_RADIO_DECADE_SWEEPS, &TCACSetup::OnBnClickedRadioDecadeSweeps)
	ON_BN_CLICKED(IDC_RADIO_OCTAVE_SWEEPS, &TCACSetup::OnBnClickedRadioOctaveSweeps)
	ON_BN_CLICKED(IDC_RADIO_LINEAR_SWEEP, &TCACSetup::OnBnClickedRadioLinearSweep)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCDCSetup property page

TCDCSetup::TCDCSetup() : CPropertyPage(TCDCSetup::IDD)
{
	//{{AFX_DATA_INIT(TCDCSetup)
	m_enable1 = FALSE;
	m_enable2 = FALSE;
	m_type1 = 2;
	m_type2 = 0;
	CMComboSource2 = _T("");
	CMComboSource1 = _T("");
	m_enable_plot_all = FALSE;
	m_enable_print_all = FALSE;
	m_enable_operating_point = FALSE;
	m_display_device_op_points = FALSE;
	//}}AFX_DATA_INIT

	m_stop1= 1.0;
	m_start1= 1.0;
	m_step1= 1.0;

	m_stop2= 1.0;
	m_start2= 1.0;
	m_step2= 1.0;
}

TCDCSetup::~TCDCSetup()
{
}

void TCDCSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCDCSetup)

	DDX_Control(pDX, IDC_COMBO_SWEEP_SOURCE1, CMComboSourceList1);
	DDX_Check(pDX, IDC_CHECK_DC_ENABLE, m_enable1);
	DDX_Radio(pDX, IDC_RADIO_DECADE_SWEEPS, m_type1);
	DDX_MKSValue(pDX, IDC_EDIT_STOP_DC, m_stop1);
	DDX_MKSValue(pDX, IDC_EDIT_START_DC, m_start1);
	DDX_MKSValue(pDX, IDC_EDIT_DC_STEPS, m_step1);
	DDX_CBString(pDX, IDC_COMBO_SWEEP_SOURCE1, CMComboSource1);
	DDX_Check(pDX, IDC_CHECK_OPERATING_POINT, m_enable_operating_point);
	DDX_Check(pDX, IDC_CHECK_DISPLAY_OPERATING_POINT, m_display_device_op_points);
	DDX_Text(pDX, IDC_EDIT_DC_PARAM_RERUN_VALUE, CMMultiRunDCParam);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCDCSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCDCSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCNoiseSetup property page

TCNoiseSetup::TCNoiseSetup() : CPropertyPage(TCNoiseSetup::IDD)
{
	//{{AFX_DATA_INIT(TCNoiseSetup)
	m_enable = FALSE;
	CMSource = _T("");
	CMOutput = _T("");
	m_check_enable_summary = FALSE;
	CMEditSummaryPoints = _T("");
	CMNoiseReportFrequencyList = _T("1");
	//}}AFX_DATA_INIT
}

TCNoiseSetup::~TCNoiseSetup()
{
}

void TCNoiseSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCNoiseSetup)
	DDX_Control(pDX, IDC_COMBO_EIN_INPUT1, CMComboSource);
	DDX_Control(pDX, IDC_COMBO_EIN_OUTPUT1, CMComboOutput);
	DDX_Check(pDX, IDC_CHECK_NOISE_ENABLE, m_enable);
	DDX_CBString(pDX, IDC_COMBO_EIN_INPUT1, CMSource);
	DDX_CBString(pDX, IDC_COMBO_EIN_OUTPUT1, CMOutput);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SUMARY, m_check_enable_summary);
	DDX_Text(pDX, IDC_EDIT_SUMMARY_POINTS, CMEditSummaryPoints);
	DDX_Text(pDX, IDC_EDIT_NOISE_REPORT_FREQ, CMNoiseReportFrequencyList);

	DDX_Text(pDX, IDC_EDIT_NOISE_PARAM_RERUN_VALUE, CMMultiRunNoiseParam);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCNoiseSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCNoiseSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCTransientSetup property page

TCTransientSetup::TCTransientSetup() : CPropertyPage(TCTransientSetup::IDD)
{
	//{{AFX_DATA_INIT(TCTransientSetup)
	m_enable = FALSE;
	CMOutput = _T("");
	m_fourier_enable = FALSE;
	m_enable_plot_all = FALSE;
	m_enable_print_all = FALSE;
	m_enable_print_all_fourier = FALSE;
	m_enable_plot_all_fourier = FALSE;
	m_use_initial_conditions = FALSE;
	m_linearize_transient_data = FALSE;
	m_trans_frequency_enable = FALSE;
	CMTransFrequencySignalName = _T("");
	m_trans_xing_sign = 0;
	m_trans_xing_last_count = 0;
	m_trans_xing_first_count = 0;
	m_enable_marching_waveforms = FALSE;
	m_full_scale_marching_xaxis = FALSE;
	m_enable_real_time_changes = FALSE;
	//}}AFX_DATA_INIT

	m_stop = 1.0;
	m_start = 1.0;
	m_frequency = 1.0;
	m_max_compute_step_size = 1.0;
}

TCTransientSetup::~TCTransientSetup()
{
}

void TCTransientSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCTransientSetup)
	DDX_Control(pDX, IDC_COMBO_NET_NAME, CMComboSource);
	DDX_Control(pDX, IDC_EDIT_CALCULATION_STEP_SIZE, CMEditMaxStepSize);
	DDX_Check(pDX, IDC_CHECK_TRANSIENT_ENABLE, m_enable);
	DDX_MKSValue(pDX, IDC_EDIT_STOP_FREQUENCY, m_stop);
	DDX_MKSValue(pDX, IDC_EDIT_START_FREQUENCY, m_start);

	DDX_MKSValue(pDX, IDC_EDIT_CALCULATION_STEP_SIZE, m_max_compute_step_size);
	DDX_Check(pDX, IDC_CHECK_UIC, m_use_initial_conditions);
	DDX_Check(pDX, IDC_CHECK_LINEARIZE_TRANS_DATA, m_linearize_transient_data);
	DDX_Check(pDX, IDC_CHECK_ENABLE_TRANS_FREQUENCY, m_trans_frequency_enable);
	DDX_CBString(pDX, IDC_COMBO_NET_NAME, CMTransFrequencySignalName);
	DDX_Radio(pDX, IDC_RADIO_EDGE_POLARITY, m_trans_xing_sign);
	DDX_Text(pDX, IDC_EDIT_END_CYCLE, m_trans_xing_last_count);
	DDX_Text(pDX, IDC_EDIT_START_CYCLE, m_trans_xing_first_count);
	DDX_MKSValue(pDX, IDC_EDIT_0XING_VALUE, m_trans_xing_level);
	DDX_Check(pDX, IDC_CHECK_MARCHING_WAVEFORMS, m_enable_marching_waveforms);
	DDX_Check(pDX, IDC_CHECK_MARCHING_WAVEFORMS_FIXED_XAXIS, m_full_scale_marching_xaxis);
	DDX_Check(pDX, IDC_CHECK_ENABLE_REAL_TIME_CHANGER, m_enable_real_time_changes);

	DDX_Check(pDX, IDC_CHECK_AUTO_CALC_FFT, m_auto_calc_fft);
	DDX_Check(pDX, IDC_CHECK_SELECTED_FFT_SIGNALS, m_calc_selected_signals_fft);

	DDX_Text(pDX, IDC_EDIT_TRAN_PARAM_RERUN_VALUE, CMultiRunTranParam);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCTransientSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCTransientSetup)
	ON_BN_CLICKED(IDC_CHECK_MAX_CALC_IS_PRINT_TIME, OnCheckMaxCalcIsPrintTime)
	ON_BN_CLICKED(IDC_BUTTON1, OnCalculateAverageFrequency)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCOutputSelectSetup property page

TCOutputSelectSetup::TCOutputSelectSetup() : CPropertyPage(TCOutputSelectSetup::IDD)
{
	//{{AFX_DATA_INIT(TCOutputSelectSetup)
	m_all_currents = FALSE;
	m_all_volts = FALSE;
	m_index_output_source = -1;
	m_index_output_selected = -1;
	m_index_device = -1;
	m_text_file_type = -1;
	m_enable_auto_ad_conversion = FALSE;
	CADConversionVoltage = _T("");
	//}}AFX_DATA_INIT
}

TCOutputSelectSetup::~TCOutputSelectSetup()
{
}

void TCOutputSelectSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCOutputSelectSetup)
	DDX_Control(pDX, IDC_LIST_OUTPUT_DEVICE_CURRENTS, CListDeviceSource);
	DDX_Control(pDX, IDC_LIST_OUTPUT_SOURCE, CListOutputsSource);
	DDX_Control(pDX, IDC_LIST_OUTPUT_SELECTED, CListOutputsSelected);
	DDX_Check(pDX, IDC_CHECK_ALL_CURRENTS, m_all_currents);
	DDX_Check(pDX, IDC_CHECK_ALL_VOLTS, m_all_volts);
	DDX_LBIndex(pDX, IDC_LIST_OUTPUT_SOURCE, m_index_output_source);
	DDX_LBIndex(pDX, IDC_LIST_OUTPUT_SELECTED, m_index_output_selected);
	DDX_LBIndex(pDX, IDC_LIST_OUTPUT_DEVICE_CURRENTS, m_index_device);
	DDX_Radio(pDX, IDC_RADIO_OUTPUY_FILE_TYPE, m_text_file_type);
	DDX_Check(pDX, IDC_CHECK_ENABL_AUTO_AD, m_enable_auto_ad_conversion);
	DDX_Text(pDX, IDC_EDIT_AD_VOLTAGE, CADConversionVoltage);
	DDX_MKSValue(pDX, IDC_EDIT_ADC_IN_CAPACITANCE, m_input_capacitance);
	DDX_MKSValue(pDX, IDC_EDIT_ADC_OUT_RESISTANCE, m_output_resistance);
	DDX_MKSValue(pDX, IDC_TRANSITION_TIME, m_transition_time);

	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCOutputSelectSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCOutputSelectSetup)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_LBN_SELCHANGE(IDC_LIST_OUTPUT_SELECTED, OnSelchangeListOutputSelected)
	ON_LBN_SELCHANGE(IDC_LIST_OUTPUT_SOURCE, OnSelchangeListOutputSource)
	ON_BN_CLICKED(IDC_BUTTON_ADD_DEVICE_NODE, OnButtonAddDeviceNode)
	ON_LBN_SELCHANGE(IDC_LIST_OUTPUT_DEVICE_CURRENTS, OnSelchangeListOutputDeviceCurrents)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

////////////////////////////////////////////

// TCMonteWorstSetup property page

TCMonteWorstSetup::TCMonteWorstSetup() : CPropertyPage(TCMonteWorstSetup::IDD)
{
	//{{AFX_DATA_INIT(TCMonteWorstSetup)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

TCMonteWorstSetup::~TCMonteWorstSetup()
{
}

void TCMonteWorstSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCMonteWorstSetup)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCMonteWorstSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCMonteWorstSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCParameterSetup property page

TCParameterSetup::TCParameterSetup() : CPropertyPage(TCParameterSetup::IDD)
{
	//{{AFX_DATA_INIT(TCParameterSetup)
	m_enable = FALSE;
	m_type = -1;
	CMSource = _T("");
	CMParameter = _T("");
	CMFileName = _T("");
	m_auto_generate_rerun_file = FALSE;
	CMValueList = _T("");
	m_enable_parameter = FALSE;
	//}}AFX_DATA_INIT

	m_stop = 1.0;
	m_start = 1.0;
	m_step = 1.0;
	m_number_of_runs = 0;
	m_multi_run_enable = 0;
}

TCParameterSetup::~TCParameterSetup()
{
}

void TCParameterSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCParameterSetup)
	DDX_Control(pDX, IDC_CHECK_ENABLE, CMCtrlEnable);
	DDX_Control(pDX, IDC_EDIT_STOP, CMEditStop);
	DDX_Control(pDX, IDC_EDIT_START, CMEditStart);
	DDX_Control(pDX, IDC_EDIT_VALUE_LIST, CEditValueList);
	DDX_Control(pDX, IDC_EDIT_FILE_NAME, CMCtrlFileName);
	DDX_Control(pDX, IDC_EDIT_STEPS, CEditSteps);
	DDX_Control(pDX, IDC_COMBO_PARAMETER, CMComboParameter);
	DDX_Control(pDX, IDC_COMBO_PARAMETER_SOURCE, CMComboSource);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_enable);
	DDX_MKSValue(pDX, IDC_EDIT_START, m_start);
	DDX_MKSValue(pDX, IDC_EDIT_STEPS, m_step);
	DDX_MKSValue(pDX, IDC_EDIT_STOP, m_stop);
	DDX_Radio(pDX, IDC_RADIO_DECADE_SWEEPS, m_type);
	DDX_CBString(pDX, IDC_COMBO_PARAMETER_SOURCE, CMSource);
	DDX_CBString(pDX, IDC_COMBO_PARAMETER, CMParameter);
	DDX_Text(pDX, IDC_EDIT_FILE_NAME, CMFileName);
	DDX_Check(pDX, IDC_CHECK_AUTOGENERATE_RRERUN, m_auto_generate_rerun_file);
	DDX_Text(pDX, IDC_EDIT_VALUE_LIST, CMValueList);
	DDX_Check(pDX, IDC_CHECK_ENABLE_PARAM, m_enable_parameter);
	DDX_MKSValue(pDX, IDC_EDIT_NUMBER_RUNS, m_number_of_runs);
	DDX_Text(pDX, IDC_EDIT_MULTIRUN_SIGNAL, CMMultiRunSignal);

	DDX_Check(pDX, IDC_CHECK_AUTOGENERATE_RRERUN_ENABLE, m_multi_run_enable);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCParameterSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCParameterSetup)
	ON_CBN_SELCHANGE(IDC_COMBO_PARAMETER, OnSelchangeComboParameter)
	ON_CBN_SELCHANGE(IDC_COMBO_PARAMETER_SOURCE, OnSelchangeComboParameterSource)
	ON_BN_CLICKED(IDC_RADIO_DECADE_SWEEPS, OnRadioDecadeSweeps)
	ON_BN_CLICKED(IDC_RADIO_OCTAVE_SWEEPS, OnRadioOctaveSweeps)
	ON_BN_CLICKED(IDC_RADIO_LINEAR_SWEEP, OnRadioLinearSweep)
	ON_BN_CLICKED(IDC_RADIO_LINEAR_SWEEP3, OnRadioLinearSweep3)
	ON_BN_CLICKED(IDC_BUTTON_FILE_BROWSE, OnButtonFileBrowse)
	ON_BN_CLICKED(IDC_BUTTON_GENERATE, OnButtonGenerateRNNFile)
	ON_BN_CLICKED(IDC_BUTTON_EDIT_RRG_FILE, OnButtonEditRrgFile)
	ON_BN_CLICKED(IDC_BUTTON_EDIT_RRN_FILE, OnButtonEditRrnFile)
	ON_BN_CLICKED(IDC_RADIO_LINEAR_SWEEP4, OnRadioLinearValueList)
	ON_BN_CLICKED(IDC_CHECK_ENABLE_PARAM, OnCheckEnableParam)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR_PARAM_ENABLES, OnButtonClearParamEnables)
	ON_BN_CLICKED(IDC_BUTTON_CALCULATE_RUNS, OnButtonCalculateRuns)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSensitivitiesSetup property page

TCSensitivitiesSetup::TCSensitivitiesSetup() : CPropertyPage(TCSensitivitiesSetup::IDD)
{
	//{{AFX_DATA_INIT(TCSensitivitiesSetup)
	m_enable_print_all = FALSE;
	m_enable_plot_all = FALSE;
	m_enable_dc = FALSE;
	m_enable_ac = FALSE;
	CListStringAC = _T("");
	CListStringDC = _T("");
	//}}AFX_DATA_INIT
}

TCSensitivitiesSetup::~TCSensitivitiesSetup()
{
}

void TCSensitivitiesSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSensitivitiesSetup)
	DDX_Control(pDX, IDC_CHECK_ENABLE, CMEnableDC);
	DDX_Control(pDX, IDC_CHECK_ENABLE_AC, CMEnableAC);
	DDX_Control(pDX, IDC_LIST_OUTPUT_DC, CListDCList);
	DDX_Control(pDX, IDC_LIST_OUTPUT_AC, CListACList);
//	DDX_Check(pDX, IDC_CHECK_ENABLE_PRINT, m_enable_print_all);
//	DDX_Check(pDX, IDC_CHECK_ENABLE_PLOT, m_enable_plot_all);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_enable_dc);
	DDX_Check(pDX, IDC_CHECK_ENABLE_AC, m_enable_ac);
	DDX_LBString(pDX, IDC_LIST_OUTPUT_AC, CListStringAC);
	DDX_LBString(pDX, IDC_LIST_OUTPUT_DC, CListStringDC);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSensitivitiesSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCSensitivitiesSetup)
	ON_LBN_SELCHANGE(IDC_LIST_OUTPUT_AC, OnSelchangeListOutputAc)
	ON_LBN_SELCHANGE(IDC_LIST_OUTPUT_DC, OnSelchangeListOutputDc)
	ON_BN_CLICKED(IDC_CHECK_ENABLE_AC, OnCheckEnableAc)
	ON_BN_CLICKED(IDC_CHECK_ENABLE, OnCheckEnableDc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSpiceOptionsSetup property page

TCSpiceOptionsSetup::TCSpiceOptionsSetup() : CPropertyPage(TCSpiceOptionsSetup::IDD)
, tran_nodeset(FALSE)
{
	//{{AFX_DATA_INIT(TCSpiceOptionsSetup)
	CMOptionStringValue = _T("");
	CMOptionsSpiceName = _T("");
	CMOptionsStringSpiceName = _T("");
	CMOptionsStringDescription = _T("");
	CMOptionsDescription = _T("");
	m_include_double = FALSE;
	m_include_string = FALSE;
	m_tran_nodeset	= FALSE;
	//}}AFX_DATA_INIT

	m_option_value = 0.0;
}

TCSpiceOptionsSetup::~TCSpiceOptionsSetup()
{
}

void TCSpiceOptionsSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSpiceOptionsSetup)
	DDX_Control(pDX, IDC_LIST_SPICE_OPTIONS_STRING, CMOptionStringList);
	DDX_Control(pDX, IDC_LIST_SPICE_OPTIONS, CMOptionsList);
	DDX_Text(pDX, IDC_EDIT_OPTIONS_STRING_VALUE, CMOptionStringValue);
	DDX_Text(pDX, IDC_EDIT_OPTIONS_SPICE_NAME, CMOptionsSpiceName);
	DDX_Text(pDX, IDC_EDIT_SPICE_OPTION_STRING_SPICE_NAME, CMOptionsStringSpiceName);
	DDX_Text(pDX, IDC_EDIT_SPICE_OPTION_SPICE_STRING_DESCRIPTION, CMOptionsStringDescription);
	DDX_Text(pDX, IDC_EDIT_SPICE_OPTION_DESCRIPTION, CMOptionsDescription);
	DDX_Check(pDX, IDC_CHECK_INCLUDE_FLOAT, m_include_double);
	DDX_Check(pDX, IDC_CHECK_INCLUDE_STRING, m_include_string);
	DDX_MKSValue(pDX, IDC_EDIT_OPTIONS_VALUE, m_option_value);
	DDX_Check(pDX, IDC_CHECK_TRAN_NODESET, m_tran_nodeset);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSpiceOptionsSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCSpiceOptionsSetup)
	ON_WM_SHOWWINDOW()
	ON_NOTIFY(NM_CLICK, IDC_LIST_SPICE_OPTIONS, OnClickListSpiceOptions)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDeleteFloat)
	ON_BN_CLICKED(IDC_BUTTON_DELETE2, OnButtonDeleteString)
	ON_BN_CLICKED(IDC_BUTTON_INSERT, OnButtonInsertFloat)
	ON_BN_CLICKED(IDC_BUTTON_INSERT2, OnButtonInsertString)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SPICE_OPTIONS_STRING, OnClickListSpiceOptionsString)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

///////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// TCTemperatureSetup property page

TCTemperatureSetup::TCTemperatureSetup() : CPropertyPage(TCTemperatureSetup::IDD)
{
	//{{AFX_DATA_INIT(TCTemperatureSetup)
	m_enable = FALSE;
	m_sweep_type = -1;
	//}}AFX_DATA_INIT

	m_stop = 1.0;
	m_start = 1.0;
	m_step = 1.0;
	m_temperature = 1.0;
	m_sweep_type = 0;
	m_type = 1;
}

TCTemperatureSetup::~TCTemperatureSetup()
{
}

void TCTemperatureSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCTemperatureSetup)
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_enable);
	DDX_MKSValue(pDX, IDC_EDIT_START_TEMPERATURE, m_start);
	DDX_MKSValue(pDX, IDC_EDIT_STOP_TEMPERATURE, m_stop);
	DDX_MKSValue(pDX, IDC_EDIT_TEMPERATURE_STEPS, m_step);
	DDX_Radio(pDX, IDC_RADIO_DECADE_SWEEPS, m_type);
	DDX_MKSValue(pDX, IDC_EDIT_TEMPERATURE, m_temperature);
//	DDX_Radio(pDX, IDC_RADIO_PARAM_SWEEP, m_sweep_type);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCTemperatureSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCTemperatureSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
////////////////////////////////



// TCDistortionSetup property page

TCDistortionSetup::TCDistortionSetup() : CPropertyPage(TCDistortionSetup::IDD)
{
	//{{AFX_DATA_INIT(TCDistortionSetup)
	m_enable = FALSE;
	m_type = -1;
	m_enable_plot_all = FALSE;
	m_enable_print_all = FALSE;
	//}}AFX_DATA_INIT

	m_frequency = 1.0;
}

TCDistortionSetup::~TCDistortionSetup()
{
}

void TCDistortionSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCDistortionSetup)
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_enable);
	DDX_Radio(pDX, IDC_RADIO_DISTORTION_THD, m_type);
	DDX_MKSValue(pDX, IDC_EDIT_IM_FREQUENCY, m_frequency);

	DDX_Text(pDX , IDC_EDIT_THD_PARAM_RERUN_VALUE, CMMultiRunTHDParam); 
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCDistortionSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCDistortionSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////

// TCPoleZeroSetup property page

TCPoleZeroSetup::TCPoleZeroSetup() : CPropertyPage(TCPoleZeroSetup::IDD)
{
	//{{AFX_DATA_INIT(TCPoleZeroSetup)
	m_enable = FALSE;
	m_type = -1;
	CMOutputNeg = _T("");
	CMOutputPos = _T("");
	CMInputNeg = _T("");
	CMInputPos = _T("");
	//}}AFX_DATA_INIT
}

TCPoleZeroSetup::~TCPoleZeroSetup()
{
}

void TCPoleZeroSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCPoleZeroSetup)
	DDX_Control(pDX, IDC_COMBO_SOURCE_POS, CMInputPosList);
	DDX_Control(pDX, IDC_COMBO_SOURCE_NEG, CMInputNegList);
	DDX_Control(pDX, IDC_COMBO_OUTPUT_POS, CMOutputPosList);
	DDX_Control(pDX, IDC_COMBO_OUTPUT_NEG, CMOutputListNeg);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_enable);
	DDX_Radio(pDX, IDC_RADIO_TYPE, m_type);
	DDX_CBString(pDX, IDC_COMBO_OUTPUT_NEG, CMOutputNeg);
	DDX_CBString(pDX, IDC_COMBO_OUTPUT_POS, CMOutputPos);
	DDX_CBString(pDX, IDC_COMBO_SOURCE_NEG, CMInputNeg);
	DDX_CBString(pDX, IDC_COMBO_SOURCE_POS, CMInputPos);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCPoleZeroSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCPoleZeroSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////

BOOL TCDCSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 0;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCACSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCNoiseSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 2;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCTransientSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 3;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCDistortionSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 4;
	
	return CPropertyPage::OnSetActive();
}
BOOL TCSensitivitiesSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 5;
	
	return CPropertyPage::OnSetActive();
}
BOOL TCPoleZeroSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 6;
	
	return CPropertyPage::OnSetActive();
}
BOOL TCTemperatureSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 7;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCReRunSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 8;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCParameterSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 9;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCSpiceOptionsSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 10;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCOutputSelectSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 11;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCMonteWorstSetup::OnSetActive() 
{
	g_last_active_simulation_setup_page = 12;
	
	return CPropertyPage::OnSetActive();
}


void TCACSetup::OnOK() 
{	
	CACSetupData.CSweepData.enable		= m_enable;
	CACSetupData.CSweepData.step		= m_step;
	CACSetupData.CSweepData.start		= m_start;
	CACSetupData.CSweepData.stop		= m_stop;
	

	CPropertyPage::OnOK();
}

BOOL TCACSetup::OnKillActive() 
{	
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CACSetupData.CSweepData.enable		= m_enable;
		CACSetupData.CSweepData.step		= m_step;
		CACSetupData.CSweepData.start		= m_start;
		CACSetupData.CSweepData.stop		= m_stop;
		CACSetupData.CSweepData.type		= m_type;
		CACSetupData.enable_plot_all		= m_enable_plot_all;
		CACSetupData.enable_print_all		= m_enable_print_all;
	}

	return value;
}

BOOL TCACSetup::OnInitDialog() 
{
	m_enable	= CACSetupData.CSweepData.enable;
	m_step		= CACSetupData.CSweepData.step;
	m_start		= CACSetupData.CSweepData.start;
	m_stop		= CACSetupData.CSweepData.stop;
	m_type		= CACSetupData.CSweepData.type;

	m_enable_plot_all	= CACSetupData.enable_plot_all;
	m_enable_print_all  = CACSetupData.enable_print_all;

	SetLabels();

	CPropertyPage::OnInitDialog();
	
	int count = CSourceList.CData.GetSize();
	CString CData;

	CMComboSourceList.InsertString(-1, "None");

	for(int p = 0; p < count; p++)
	{
		CData = CSourceList.CData[p].CUserName;

		if(CData.GetAt(0) == 'I' || CData.GetAt(0) == 'i') continue;

		CMComboSourceList.InsertString(-1, CData);
	}

	if(count)
	{
		CMComboSourceList.SelectString(-1, CMLoopGainSource);
	}
	
	return TRUE;               
}

void TCACSetup::SetLabels(void)
{
	if(m_freq_device_mode)
	{
		CMStartFrequency	= "Param Start";
		CMStopFrequency		= "Param Stop";
		
		if(m_type == 2) // Linear
		{
			CMNumberOfPoints	= "# Points";
		}
		else if(m_type == 1) //oct
		{
			CMNumberOfPoints = "# Points/Oct";	
		}
		else CMNumberOfPoints = "# Points/Dec";
	}
	else
	{
		CMStartFrequency	= "Start Frequency";
		CMStopFrequency		= "Stop Frequency";

		if(m_type == 2)
		{
			CMNumberOfPoints	= "# Points";
		}
		else if(m_type == 1) //oct
		{
			CMNumberOfPoints = "# Points/Oct";
		}
		else CMNumberOfPoints = "# Points/Dec";
	}
}

void TCACSetup::OnBnClickedRadioSweepModeDevice()
{
	UpdateData(true);

	SetLabels();

	UpdateData(false);
}

void TCACSetup::OnBnClickedRadioSweepModeFrequency()
{
	UpdateData(true);

	SetLabels();

	UpdateData(false);
}
void TCACSetup::OnBnClickedRadioDecadeSweeps()
{
	UpdateData(true);

	SetLabels();

	UpdateData(false);
}

void TCACSetup::OnBnClickedRadioOctaveSweeps()
{
	UpdateData(true);

	SetLabels();

	UpdateData(false);
}

void TCACSetup::OnBnClickedRadioLinearSweep()
{
	UpdateData(true);

	SetLabels();

	UpdateData(false);
}


BOOL TCDCSetup::OnKillActive() 
{
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CDCSetupData.CSweepData1.enable		= m_enable1;
		CDCSetupData.CSweepData1.step		= m_step1;
		CDCSetupData.CSweepData1.start		= m_start1;
		CDCSetupData.CSweepData1.stop		= m_stop1;
		CDCSetupData.CSweepData1.type		= m_type1;

		CDCSetupData.CSweepData2.enable		= m_enable2;
		CDCSetupData.CSweepData2.step		= m_step2;
		CDCSetupData.CSweepData2.start		= m_start2;
		CDCSetupData.CSweepData2.stop		= m_stop2;
		CDCSetupData.CSweepData2.type		= m_type2;

		CDCSetupData.enable_plot_all		= m_enable_plot_all;
		CDCSetupData.enable_print_all		= m_enable_print_all;
		CDCSetupData.enable_operating_point = m_enable_operating_point;
		CDCSetupData.display_device_op_points = m_display_device_op_points; 

		CDCSetupData.CSource1 = CMComboSource1;
		CDCSetupData.CSource2 = CMComboSource2;
	}

	return value;
}

BOOL TCDCSetup::OnInitDialog() 
{
	m_enable1	= CDCSetupData.CSweepData1.enable;
	m_step1		= CDCSetupData.CSweepData1.step;
	m_start1	= CDCSetupData.CSweepData1.start;
	m_stop1		= CDCSetupData.CSweepData1.stop;

	if(CDCSetupData.CSweepData1.type < 0) CDCSetupData.CSweepData1.type = 1;// default to linear sweep

	m_type1		= CDCSetupData.CSweepData1.type;

	m_enable2	= CDCSetupData.CSweepData2.enable;
	m_step2		= CDCSetupData.CSweepData2.step;
	m_start2	= CDCSetupData.CSweepData2.start;
	m_stop2		= CDCSetupData.CSweepData2.stop;
	m_type2		= CDCSetupData.CSweepData2.type;
	m_enable_plot_all	= CDCSetupData.enable_plot_all;
	m_enable_print_all  = CDCSetupData.enable_print_all;
	m_enable_operating_point = CDCSetupData.enable_operating_point;
	m_display_device_op_points = CDCSetupData.display_device_op_points; 

	CMComboSource1 = CDCSetupData.CSource1;
	CMComboSource2 = CDCSetupData.CSource2;

	CPropertyPage::OnInitDialog();
	
	// direct stuffing here

	CMComboSourceList1.ResetContent();

	int count = CSourceList.CData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMComboSourceList1.InsertString(-1, CSourceList.CData[p].CUserName);
	}

	count = CParametricSetupData.CData.GetSize();

	CString CRefDes;

	for(p = 0; p < count; p++)
	{
		CRefDes = CParametricSetupData.CData[p].CRefDesignator;

		if(!(CRefDes.GetAt(0) == 'r' || CRefDes.GetAt(0) == 'R')) continue;

		CMComboSourceList1.InsertString(-1, CRefDes);
	}


	CMComboSourceList1.SelectString(-1, CDCSetupData.CSource1);

	return TRUE;  
}

BOOL TCNoiseSetup::OnKillActive() 
{
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CNoiseSetupData.enable  = m_enable;
		CNoiseSetupData.CSource = CMSource;
		CNoiseSetupData.COutput = CMOutput;
		CNoiseSetupData.output_index = CMComboOutput.GetCurSel();
		CNoiseSetupData.enable_summary = !!m_check_enable_summary;
		CNoiseSetupData.CSummaryPoints = CMEditSummaryPoints;
	}

	return value;
}

BOOL TCNoiseSetup::OnInitDialog() 
{
	m_enable	= CNoiseSetupData.enable;
	CMSource	= CNoiseSetupData.CSource;
	CMOutput	= CNoiseSetupData.COutput;

	m_check_enable_summary	= CNoiseSetupData.enable_summary;
	CMEditSummaryPoints		= CNoiseSetupData.CSummaryPoints;

	CPropertyPage::OnInitDialog();
	
	CMComboSource.ResetContent();
	CMComboOutput.ResetContent();
	
	int count = CSourceList.CData.GetSize();
	char test_char;

	int p;

	for(p = 0; p < count; p++)
	{
		CMComboSource.InsertString(-1, CSourceList.CData[p].CUserName);
	}

	if(count)
	{
		CMComboSource.SelectString(-1, CNoiseSetupData.CSource);
	}

	count = COutputList.CData.GetSize();

	for(p = 0; p < count; p++)
	{
		test_char = COutputList.CData[p].CUserName.GetAt(0);

		if(test_char == 'I') continue;// I source not valid really need another array

		CMComboOutput.InsertString(-1, COutputList.CData[p].CUserName);
	}

	if(count)
	{
		CMComboOutput.SelectString(-1, CNoiseSetupData.COutput);
	}
	return TRUE; 
}

BOOL TCTransientSetup::OnKillActive() 
{	
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		if(!m_max_compute_step_size) m_max_compute_step_size = (m_stop - m_start)/50;

		CTransientSetupData.CSweepData.enable	= m_enable;
		CTransientSetupData.CSweepData.step		= m_max_compute_step_size;
		CTransientSetupData.CSweepData.start	= m_start;
		CTransientSetupData.CSweepData.stop		= m_stop;
		CTransientSetupData.max_compute_step_size = m_max_compute_step_size;
		CTransientSetupData.frequency			= m_frequency;
		CTransientSetupData.COutput				= CMOutput;
		CTransientSetupData.fourier_enable		= m_fourier_enable;
		CTransientSetupData.enable_plot_all		= m_enable_plot_all;
		CTransientSetupData.enable_print_all	= m_enable_print_all;
		CTransientSetupData.enable_plot_all_fourier		= m_enable_plot_all_fourier;
		CTransientSetupData.enable_print_all_fourier	= m_enable_print_all_fourier;
		CTransientSetupData.use_initial_conditions = m_use_initial_conditions;
		CTransientSetupData.max_calc_is_print_time = true;
		CTransientSetupData.linearize_transient_data = m_linearize_transient_data;
		CTransientSetupData.enable_marching_waveforms = m_enable_marching_waveforms;
		CTransientSetupData.full_scale_marching_xaxis = m_full_scale_marching_xaxis;
		CTransientSetupData.enable_real_time_changes = m_enable_real_time_changes;
		
//		CTransientSetupData.output_index = CMComboOutput.GetCurSel();
	}

	return value;
}

BOOL TCTransientSetup::OnInitDialog() 
{
	m_enable			= CTransientSetupData.CSweepData.enable;
	m_start				= CTransientSetupData.CSweepData.start;
	m_stop				= CTransientSetupData.CSweepData.stop;
	m_frequency			= CTransientSetupData.frequency;
	m_fourier_enable	= CTransientSetupData.fourier_enable;
	m_max_compute_step_size = CTransientSetupData.max_compute_step_size;
	CMOutput			= CTransientSetupData.COutput;
	m_enable_plot_all	= CTransientSetupData.enable_plot_all;
	m_enable_print_all  = CTransientSetupData.enable_print_all;
	m_enable_plot_all_fourier	= CTransientSetupData.enable_plot_all_fourier;
	m_enable_print_all_fourier  = CTransientSetupData.enable_print_all_fourier;
	m_use_initial_conditions =	CTransientSetupData.use_initial_conditions;

	m_linearize_transient_data = CTransientSetupData.linearize_transient_data;
	m_enable_marching_waveforms  = CTransientSetupData.enable_marching_waveforms;
	m_full_scale_marching_xaxis  =  CTransientSetupData.full_scale_marching_xaxis;
	m_enable_real_time_changes	=  CTransientSetupData.enable_real_time_changes;

	CPropertyPage::OnInitDialog();
/*
	CMComboOutput.ResetContent();

	int count = COutputList.CData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMComboOutput.InsertString(-1, COutputList.CData[p].CUserName);
	}

	if(count)
	{
		CMComboOutput.SelectString(-1, CTransientSetupData.COutput);
	}
*/
	int count, p;

	CMComboSource.ResetContent();

	count = CSourceList.CData.GetSize();

	for(p = 0; p < count; p++)
	{
		CMComboSource.InsertString(-1, CSourceList.CData[p].CUserName);
	}

	if(count)
	{
		CMComboSource.SelectString(-1, CMTransFrequencySignalName);
	}

	return TRUE;  
}

void TCTransientSetup::OnCheckMaxCalcIsPrintTime() 
{
	UpdateData(true);

//	if(m_max_calc_is_print_time) CMEditMaxStepSize.SetReadOnly(true);
	CMEditMaxStepSize.SetReadOnly(false);
}

BOOL TCSensitivitiesSetup::OnKillActive() 
{
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CSensitivitySetupData.enable_dc	= m_enable_dc;
		CSensitivitySetupData.enable_ac	= m_enable_ac;

		CSensitivitySetupData.CStaticOutput	= CListStringDC;
		CSensitivitySetupData.COutput		= CListStringAC;

		CSensitivitySetupData.ac_output_index = CListACList.GetCurSel();
		CSensitivitySetupData.dc_output_index = CListDCList.GetCurSel();

		CSensitivitySetupData.enable_plot_all	= m_enable_plot_all;
		CSensitivitySetupData.enable_print_all	= m_enable_print_all;
	}

	return value;
}

BOOL TCSensitivitiesSetup::OnInitDialog() 
{
	m_enable_ac	= CSensitivitySetupData.enable_ac;
	m_enable_dc		= CSensitivitySetupData.enable_dc;

	CListStringDC = CSensitivitySetupData.CStaticOutput;
	CListStringAC = CSensitivitySetupData.COutput;

	m_enable_plot_all	= CSensitivitySetupData.enable_plot_all;
	m_enable_print_all  = CSensitivitySetupData.enable_print_all;

	CPropertyPage::OnInitDialog();
	
	SetDisplay();

	return TRUE; 
}
void TCSensitivitiesSetup::SetDisplay(void)
{
	CListDCList.ResetContent();
	CListACList.ResetContent();

	int count;

	count = COutputList.CData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CListACList.InsertString(-1, COutputList.CData[p].CUserName);
	}

	if(count)
	{
		CListACList.SelectString(-1, CSensitivitySetupData.COutput);
	}


	count = CStaticOutputList.CData.GetSize();

	for(p = 0; p < count; p++)
	{
		CListDCList.InsertString(-1, CStaticOutputList.CData[p].CUserName);
	}

	if(count)
	{
		CListDCList.SelectString(-1, CSensitivitySetupData.CStaticOutput);
	}
}


void TCSensitivitiesSetup::OnSelchangeListOutputAc() 
{
	CSensitivitySetupData.ac_output_index = CListACList.GetCurSel();
}

void TCSensitivitiesSetup::OnSelchangeListOutputDc() 
{
	CSensitivitySetupData.dc_output_index = CListDCList.GetCurSel();
}

/////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
BOOL TCMonteWorstSetup::OnKillActive() 
{
	
	return CPropertyPage::OnKillActive();
}

BOOL TCMonteWorstSetup::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	
	return TRUE;  
}
//////////////////////////////////////////////
BOOL TCOutputSelectSetup::OnKillActive() 
{
	GetDisplay();

	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		COutputSelectData.all_currents	= m_all_currents;
		COutputSelectData.all_volts		= m_all_volts;
		COutputSelectData.text_file_type =  m_text_file_type;
		COutputSelectData.index_output_source	= m_index_output_source;
		COutputSelectData.index_spice_volt_and_current	= m_index_output_selected;
		COutputSelectData.index_device_current_node	= m_index_device;
		COutputSelectData.enable_auto_ad_conversion = m_enable_auto_ad_conversion;
	}

	return value;
}

BOOL TCOutputSelectSetup::OnInitDialog() 
{
	m_all_currents			= COutputSelectData.all_currents;
	m_all_volts				= COutputSelectData.all_volts;
	m_text_file_type		= COutputSelectData.text_file_type;
	m_index_output_source	= COutputSelectData.index_output_source;
	m_index_output_selected = COutputSelectData.index_spice_volt_and_current;
	m_index_device			= COutputSelectData.index_device_current_node;
	m_enable_auto_ad_conversion = COutputSelectData.enable_auto_ad_conversion;


	CPropertyPage::OnInitDialog();
	
	SetDisplay();

	return TRUE; 
}

void TCOutputSelectSetup::GetDisplay(void)
{
	UpdateData(true);

	CListOutputsSource;
	CListOutputsSelected;
}

void TCOutputSelectSetup::SetDisplay(void)
{
	COutputList;

	CListOutputsSource.ResetContent();
	CListOutputsSelected.ResetContent();
	CListDeviceSource.ResetContent();

	int count = COutputList.CData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CListOutputsSource.InsertString(-1, COutputList.CData[p].CUserName);
	}

	count = CDeviceCurrentNodeList.CData.GetSize();

	for(p = 0; p < count; p++)
	{
		CListDeviceSource.InsertString(-1, CDeviceCurrentNodeList.CData[p].CUserName);
	}

	count = COutputSelectData.CSpiceVoltAndCurrentList.GetSize();

	for(p = 0; p < count; p++)
	{
		CListOutputsSelected.InsertString(-1, COutputSelectData.CSpiceVoltAndCurrentList[p]);
	}

	UpdateData(false);
}


void TCOutputSelectSetup::OnButtonAddDeviceNode() 
{
	if(!(COutputSelectData.index_device_current_node < CDeviceCurrentNodeList.CData.GetSize())) return;

	COutputSelectData.CSpiceVoltAndCurrentList.Add(CDeviceCurrentNodeList.CData[COutputSelectData.index_device_current_node].CUserName);

	SetDisplay();
}

void TCOutputSelectSetup::OnButtonAdd() 
{
	if(!(COutputSelectData.index_output_source < COutputList.CData.GetSize())) return;

	COutputSelectData.CSpiceVoltAndCurrentList.Add(COutputList.CData[COutputSelectData.index_output_source].CUserName);

	SetDisplay();	
}

void TCOutputSelectSetup::OnButtonDelete() 
{
	if(!(COutputSelectData.index_spice_volt_and_current < COutputSelectData.CSpiceVoltAndCurrentList.GetSize())) return;
	if(COutputSelectData.index_spice_volt_and_current < 0) return;

	COutputSelectData.CSpiceVoltAndCurrentList.RemoveAt(COutputSelectData.index_spice_volt_and_current);

	if(COutputSelectData.index_spice_volt_and_current < 0) COutputSelectData.index_spice_volt_and_current = 0;

	m_index_output_source	= COutputSelectData.index_output_source;

	SetDisplay();
}

void TCOutputSelectSetup::OnSelchangeListOutputSelected() 
{
	COutputSelectData.index_spice_volt_and_current = CListOutputsSelected.GetCurSel();
}

void TCOutputSelectSetup::OnSelchangeListOutputSource() 
{
	COutputSelectData.index_output_source = CListOutputsSource.GetCurSel();
}

void TCOutputSelectSetup::OnSelchangeListOutputDeviceCurrents() 
{
	COutputSelectData.index_device_current_node = CListDeviceSource.GetCurSel();
}

//////////////////////////////////////
BOOL TCParameterSetup::OnKillActive() 
{
	GetDisplay();

	int value = CPropertyPage::OnKillActive();
	int count;

	if(value)
	{
		CParametricSetupData.CSweepData.enable	= m_enable;
		CParametricSetupData.CSweepData.step	= m_step;
		CParametricSetupData.CSweepData.start	= m_start;
		CParametricSetupData.CSweepData.stop	= m_stop;
		CParametricSetupData.CSweepData.type	= m_type;
		CParametricSetupData.CSweepData.CValueList = CMValueList;
		CParametricSetupData.CSource			= CMSource;
		
		count = CParametricSetupData.CData.GetSize();

		if(!(CParametricSetupData.source_id < count)) return value;

		CMFileName.TrimLeft();
		CMFileName.TrimRight();

		CParametricSetupData.CValue = CMFileName;

		CParametricSetupData.CData[CParametricSetupData.source_id].CSweepData = CParametricSetupData.CSweepData;
		CParametricSetupData.CData[CParametricSetupData.source_id].CSweepData.enable = m_enable_parameter;

		if(m_type == E_PARAMETER_RUN_MODE_EXTERNAL_FILE) // may add option to reinstate old model vary method
		{
			CParametricSetupData.CSweepData.sweep_type = E_PARAMETER_RUN_MODE_EXTERNAL_FILE; // External named rnn file
		}
		else CParametricSetupData.CSweepData.sweep_type = E_PARAMETER_RUN_MODE_INTERNAL_FILE;// internal rrn file
	}

	return value;
}

void TCParameterSetup::OnButtonFileBrowse() 
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "", CMFileName, 0,"Parameter List ReRun Files (*.rrn)| *.rrn||");

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;
	
	CMFileName = CFileName;

	SetDisplay();
}

void TCParameterSetup::OnSelchangeComboParameter() 
{
	int param_id;
	int source_id;

	param_id	= CMComboParameter.GetCurSel();	
	source_id	= CParametricSetupData.source_id;
	CString CValidateText;

	 if(source_id < CParametricSetupData.CData.GetSize())
	 if(source_id >= 0)
	 {
		if(param_id < CParametricSetupData.CData[source_id].PCParameter->CData.GetSize())
			if(param_id >= 0)
			{
				CValidateText = CParametricSetupData.CData[source_id].PCParameter->CData[param_id].CName;

				CValidateText.MakeLower(); // Quick bodge to allow m (area) of BJTs, and L, W of Bsim4 to be swept, but not passed to model

				if(CValidateText != 'm' && CValidateText != "area" && CValidateText != "l" && CValidateText != "w")
				if(!CParametricSetupData.CData[source_id].PCParameter->Validate(CParametricSetupData.CData[source_id].PCParameter->CData[param_id]))
				{
					AfxMessageBox(IDS_INVALID_SWEEP_PARAM);

					return;
				}

				CParametricSetupData.CData[source_id].CParameter	= 
				CParametricSetupData.CData[source_id].PCParameter->CData[param_id].CName;
				
				CParametricSetupData.CData[source_id].parameter_id = param_id;
			}
	 }
}

void TCParameterSetup::OnSelchangeComboParameterSource() 
{
	GetDisplay();//added aug 2005

	int count = CParametricSetupData.CData.GetSize();

	int source_id;

	CParametricSetupData.source_id	= CMComboSource.GetCurSel();

	source_id	= CParametricSetupData.source_id;

	if(source_id < count)
	 if(source_id >= 0)
	 {
		CParametricSetupData.CSource = CParametricSetupData.CData[source_id].CRefDesignator;
	 }

	 SetDisplay();
}

void TCParameterSetup::GetDisplay(void)
{
	UpdateData(true);

	int source_id;
	int old_source_id;
	int param_id;

	old_source_id = CParametricSetupData.source_id;
	CParametricSetupData.source_id	= CMComboSource.GetCurSel();
	CParametricSetupData.CSweepData.enable = m_enable;
	CParametricSetupData.CSweepData.type = m_type;

	if(CParametricSetupData.source_id < 0) CParametricSetupData.source_id = 0;

	source_id	= CParametricSetupData.source_id;
	param_id	= CMComboParameter.GetCurSel();

	if(source_id < CParametricSetupData.CData.GetSize())
	 if(source_id >= 0)
	 {
		CParametricSetupData.CSource = CParametricSetupData.CData[source_id].CRefDesignator;

		if(CParametricSetupData.CData[source_id].PCParameter)
			 CParametricSetupData.CRecordName = CParametricSetupData.CData[source_id].PCParameter->CDataBaseIdInfo.CRecordName;
		else CParametricSetupData.CRecordName = "";
	 }

	if(old_source_id < 0) old_source_id = 0;

	if((old_source_id < CParametricSetupData.CData.GetSize())) 
	{
		TCSelectParameter &CSelectParameter = CParametricSetupData.CData[old_source_id];

		CSelectParameter.CSweepData.enable = m_enable_parameter;
		CSelectParameter.CSweepData.step	= m_step;
		CSelectParameter.CSweepData.start	= m_start;
		CSelectParameter.CSweepData.stop	= m_stop;
		CSelectParameter.CSweepData.CValueList = CMValueList;
		CSelectParameter.CSweepData.type = m_type;
	}
}

void TCParameterSetup::SetDisplay(bool ignore_ref_des_list)
{
	CString CText;
	CMSource	= CParametricSetupData.CSource;
	m_enable	= CParametricSetupData.CSweepData.enable;

	if(!(CMSource.Find(":") < 0)) CMCtrlEnable.EnableWindow(false);// for lower level schematic disable enable

	
	CMComboParameter.ResetContent();

	int count = CParametricSetupData.CData.GetSize();

	int p;

	if(!ignore_ref_des_list)
	{
		CMComboSource.ResetContent();

		for(int p = 0; p < count; p++)
		{
			CMComboSource.InsertString(-1, CParametricSetupData.CData[p].CRefDesignator);

		}

		if(count)
		{
			if(CMComboSource.SelectString(-1, CParametricSetupData.CSource) == CB_ERR) CMComboSource.SelectString(-1, "NONE");
		}
	}

	if((CParametricSetupData.source_id > -1) && count)
	{
		if(CParametricSetupData.source_id < CParametricSetupData.CData.GetSize())
		{
			if(!CParametricSetupData.CData[CParametricSetupData.source_id].PCParameter)
			{
				return;
			}
			count = CParametricSetupData.CData[CParametricSetupData.source_id].PCParameter->CData.GetSize();
		}
		else count = 0;

		for(p = 0; p < count; p++)
		{
			CText = CParametricSetupData.CData[CParametricSetupData.source_id].PCParameter->CData[p].CName;

			CMComboParameter.InsertString(-1, CText);
		}
	}

	if(count && CParametricSetupData.source_id > -1)
	{
		if(CParametricSetupData.source_id < 0) CParametricSetupData.source_id = 0;

		if((CParametricSetupData.source_id < CParametricSetupData.CData.GetSize())) 
		{
			TCSelectParameter &CSelectParameter = CParametricSetupData.CData[CParametricSetupData.source_id];

			m_enable_parameter	= CSelectParameter.CSweepData.enable;
			m_step		= CSelectParameter.CSweepData.step;
			m_start		= CSelectParameter.CSweepData.start;
			m_stop		= CSelectParameter.CSweepData.stop;
			m_type		= CSelectParameter.CSweepData.type;

			CMValueList = CSelectParameter.CSweepData.CValueList;
		}

		if(CParametricSetupData.CData[CParametricSetupData.source_id].parameter_id < 
			CParametricSetupData.CData[CParametricSetupData.source_id].PCParameter->CData.GetSize())
			if(CParametricSetupData.CData[CParametricSetupData.source_id].parameter_id >= 0)
			  CMParameter = CParametricSetupData.CData[CParametricSetupData.source_id].PCParameter->CData[CParametricSetupData.CData[CParametricSetupData.source_id].parameter_id].CName;
				
		if(CMComboParameter.SelectString(-1, CMParameter) == CB_ERR) CMComboSource.SelectString(-1, "NONE");
	}

	CEditSteps.SetReadOnly(false);
	CMCtrlFileName.SetReadOnly(true);
	CMComboParameter.EnableWindow(true);
	CMComboSource.EnableWindow(true);
	CEditValueList.SetReadOnly(true);
	CMEditStart.SetReadOnly(false);
	CMEditStop.SetReadOnly(false);

	if(m_type == E_PARAMETER_SWEEP_TYPE_EXTERNAL_FILE) 
	{
		CMCtrlFileName.SetReadOnly(false);
		CMComboParameter.EnableWindow(false);
		CMComboSource.EnableWindow(false);
		CMEditStart.SetReadOnly(true);
		CMEditStop.SetReadOnly(true);
	}

	if(m_type == E_PARAMETER_SWEEP_TYPE_LIST)
	{
		CEditValueList.SetReadOnly(false);
		CMCtrlFileName.SetReadOnly(true);
		CMComboParameter.EnableWindow(true);
		CMComboSource.EnableWindow(true);
		CMEditStart.SetReadOnly(true);
		CMEditStop.SetReadOnly(true);
	}

	UpdateData(false);
}

void TCParameterSetup::OnButtonCalculateRuns() 
{	
	GetDisplay();

	if(CParametricSetupData.source_id < 0) return;

	int count = CParametricSetupData.CData.GetSize();

	int number, flag = 0;

	m_number_of_runs = 1;

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CLParametricSetupData = CParametricSetupData.CData[p];

		CLParametricSetupData.CSweepData.CreateValueList();

		if(!CLParametricSetupData.CSweepData.enable) continue;

		number =  CLParametricSetupData.CSweepData.GetCount();

		if(!number) continue;

		flag = true;

		m_number_of_runs *= number;
	}

	if(!flag) m_number_of_runs = 0;

	SetDisplay();
}

BOOL TCParameterSetup::OnInitDialog() 
{
	m_enable	= CParametricSetupData.CSweepData.enable;
	m_step		= CParametricSetupData.CSweepData.step;
	m_start		= CParametricSetupData.CSweepData.start;
	m_stop		= CParametricSetupData.CSweepData.stop;
	m_type		= CParametricSetupData.CSweepData.type;
	CMValueList = CParametricSetupData.CSweepData.CValueList;

	if(CParametricSetupData.source_id < 0) CParametricSetupData.source_id = 0;

	if((CParametricSetupData.source_id < CParametricSetupData.CData.GetSize())) 
	{
		TCSelectParameter &CLParametricSetupData = CParametricSetupData.CData[CParametricSetupData.source_id];

		m_enable_parameter	= CLParametricSetupData.CSweepData.enable;
		m_step		= CLParametricSetupData.CSweepData.step;
		m_start		= CLParametricSetupData.CSweepData.start;
		m_stop		= CLParametricSetupData.CSweepData.stop;

		m_type	= CLParametricSetupData.CSweepData.type;

		CMValueList = CLParametricSetupData.CSweepData.CValueList;
	}

	CMFileName = CParametricSetupData.CValue;

	CPropertyPage::OnInitDialog();
	
	CEditSteps.SetReadOnly(false);
	CMCtrlFileName.SetReadOnly(true);
	CMComboParameter.EnableWindow(true);
	CMComboSource.EnableWindow(true);
	CEditValueList.SetReadOnly(true);
	CMEditStart.SetReadOnly(false);
	CMEditStop.SetReadOnly(false);

	if(m_type == E_PARAMETER_SWEEP_TYPE_EXTERNAL_FILE) 
	{
		CMCtrlFileName.SetReadOnly(false);
		CMComboParameter.EnableWindow(false);
		CMComboSource.EnableWindow(false);
		CMEditStart.SetReadOnly(true);
		CMEditStop.SetReadOnly(true);
	}

	if(m_type == E_PARAMETER_SWEEP_TYPE_LIST)
	{
		CEditValueList.SetReadOnly(false);
		CMCtrlFileName.SetReadOnly(true);
		CMComboParameter.EnableWindow(true);
		CMComboSource.EnableWindow(true);
		CMEditStart.SetReadOnly(true);
		CMEditStop.SetReadOnly(true);
	}

	SetDisplay();

	OnButtonCalculateRuns();

	return TRUE; 
}

void TCParameterSetup::OnCheckEnableParam() 
{
	if(CParametricSetupData.source_id < 0) return;

	if(!(CParametricSetupData.source_id < CParametricSetupData.CData.GetSize())) return; 

	TCSelectParameter &CSelectParameter = CParametricSetupData.CData[CParametricSetupData.source_id];

	int flag = CSelectParameter.CSweepData.enable; 

	CSelectParameter.CSweepData.enable = !flag;

	m_enable_parameter	= CSelectParameter.CSweepData.enable;
//	SetDisplay();
}

void TCParameterSetup::OnButtonClearParamEnables() 
{
	GetDisplay();

	CParametricSetupData.DisableAll();

	m_enable_parameter = false;
	m_enable		   = false;
	m_number_of_runs   = 0;

	SetDisplay();
}

//*******************
BOOL TCTemperatureSetup::OnKillActive() 
{

	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CTemperatureSetupData.CSweepData.enable		= m_enable;
		CTemperatureSetupData.CSweepData.step		= m_step;
		CTemperatureSetupData.CSweepData.start		= m_start;
		CTemperatureSetupData.CSweepData.stop		= m_stop;
		CTemperatureSetupData.CSweepData.type		= m_type;
		temperature = m_temperature;

		CTemperatureSetupData.CSweepData.sweep_type	= m_sweep_type;

		CTemperatureSetupData.CSweepData.sweep_type = E_TEMPERATURE_SWEEP_VOLTS_V_TEMP;// overide all stored verions. Parameters now does multi sweep.

	}

	return value;
}

BOOL TCTemperatureSetup::OnInitDialog() 
{
	m_enable	= CTemperatureSetupData.CSweepData.enable;
	m_step		= CTemperatureSetupData.CSweepData.step;
	m_start		= CTemperatureSetupData.CSweepData.start;
	m_stop		= CTemperatureSetupData.CSweepData.stop;

	if(CTemperatureSetupData.CSweepData.type) CTemperatureSetupData.CSweepData.type = 1;// exception to type number

	m_type		= CTemperatureSetupData.CSweepData.type;
	m_sweep_type= CTemperatureSetupData.CSweepData.sweep_type;

	m_temperature =  temperature;

	CPropertyPage::OnInitDialog();
	
	
	return TRUE;
}

BOOL TCSpiceOptionsSetup::OnKillActive() 
{
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}

	return value;


}

void TCSpiceOptionsSetup::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CPropertyPage::OnShowWindow(bShow, nStatus);
}


BOOL TCSpiceOptionsSetup::OnInitDialog() 
{

	CPropertyPage::OnInitDialog();
	
	CString CText;


	int length = (int)(CMOptionsList.GetStringWidth("Description") * 3.8);

	CText ="Description";
	CMOptionsList.InsertColumn(0, CText, LVCFMT_LEFT,length,0);

	length = (int)(CMOptionsList.GetStringWidth("Spice Name") *1.3);

	CText ="Spice Name";
	CMOptionsList.InsertColumn(1, CText, LVCFMT_LEFT,length,0);

	length = (int)(CMOptionsList.GetStringWidth("Value") * 2);

	CText ="Value";
	CMOptionsList.InsertColumn(2, CText, LVCFMT_LEFT, length,1);

	CText ="Include";
	CMOptionsList.InsertColumn(3, CText, LVCFMT_LEFT, length,1);

	/////////////////////////////////////

	length = (int)(CMOptionStringList.GetStringWidth("Description") * 3.8);

	CText ="Description";
	CMOptionStringList.InsertColumn(0, CText, LVCFMT_LEFT,length,0);

	length = (int)(CMOptionsList.GetStringWidth("Spice Name") *1.3);

	CText ="Spice Name";
	CMOptionStringList.InsertColumn(1, CText, LVCFMT_LEFT,length,0);

	length = (int)(CMOptionsList.GetStringWidth("Value") * 2);

	CText ="Value";
	CMOptionStringList.InsertColumn(2, CText, LVCFMT_LEFT, length,1);

	CText ="Include";
	CMOptionStringList.InsertColumn(3, CText, LVCFMT_LEFT, length,1);

	InsertItems();
	SetDisplay();

	return TRUE;  
}

void TCSpiceOptionsSetup::InsertItems(void)
{
	CMOptionsList.DeleteAllItems();
	CMOptionStringList.DeleteAllItems();

	int count = CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMOptionsList.InsertItem(p, CBerklySpiceOptionsSetupData.COptionsFloatData[p].CType);
	}

	count = CBerklySpiceOptionsSetupData.COptionsStringData.GetSize();

	for(p = 0; p < count; p++)
	{
		CMOptionStringList.InsertItem(p, CBerklySpiceOptionsSetupData.COptionsStringData[p].CType);
	}
}

void TCSpiceOptionsSetup::GetDisplay(void)
{
	UpdateData(true);

	int index = CBerklySpiceOptionsSetupData.last_float_option_selected;

	if(index > -1 && index < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())
	{	
		CBerklySpiceOptionsSetupData.COptionsFloatData[index].value			= m_option_value;
		CBerklySpiceOptionsSetupData.COptionsFloatData[index].SpiceName		= CMOptionsSpiceName;
		CBerklySpiceOptionsSetupData.COptionsFloatData[index].CType			= CMOptionsDescription;
		CBerklySpiceOptionsSetupData.COptionsFloatData[index].m_include		= !!m_include_double;
	}

	index = CBerklySpiceOptionsSetupData.last_string_option_selected;

	if(index > -1 && index < CBerklySpiceOptionsSetupData.COptionsStringData.GetSize())
	{
		CBerklySpiceOptionsSetupData.COptionsStringData[index].CValue		= CMOptionStringValue;
		CBerklySpiceOptionsSetupData.COptionsStringData[index].SpiceName	= CMOptionsStringSpiceName;
		CBerklySpiceOptionsSetupData.COptionsStringData[index].CType		= CMOptionsStringDescription;
		CBerklySpiceOptionsSetupData.COptionsStringData[index].m_include	= !!m_include_string;
		CBerklySpiceOptionsSetupData.tran_nodeset							= !!m_tran_nodeset;
	}
}

void TCSpiceOptionsSetup::SetDisplay(void)
{
	double data;
	CString CText;

	int index = CBerklySpiceOptionsSetupData.last_float_option_selected;

	if(index < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())
	{
		if(index >= 0)
		{
			m_option_value			= CBerklySpiceOptionsSetupData.COptionsFloatData[index].value;
			CMOptionsDescription	= CBerklySpiceOptionsSetupData.COptionsFloatData[index].CType;
			CMOptionsSpiceName		= CBerklySpiceOptionsSetupData.COptionsFloatData[index].SpiceName;
			m_include_double		= CBerklySpiceOptionsSetupData.COptionsFloatData[index].m_include;

		}
	}
	int count = CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMOptionsList.SetItemText(p, 0, CBerklySpiceOptionsSetupData.COptionsFloatData[p].CType);

		CMOptionsList.SetItemText(p, 1, CBerklySpiceOptionsSetupData.COptionsFloatData[p].SpiceName);

		data =  CBerklySpiceOptionsSetupData.COptionsFloatData[p].value;

		CMOptionsList.SetItemText(p, 2, FloatToMKSString(data));

		if(CBerklySpiceOptionsSetupData.COptionsFloatData[p].m_include)
			CText = "Yes";
		else CText = "No";

		CMOptionsList.SetItemText(p, 3, CText);
	}
///////
		
	index = CBerklySpiceOptionsSetupData.last_string_option_selected;

	if(index < CBerklySpiceOptionsSetupData.COptionsStringData.GetSize())
	{
		if(index >= 0)
		{
			CMOptionStringValue			= CBerklySpiceOptionsSetupData.COptionsStringData[index].CValue;
			CMOptionsStringDescription	= CBerklySpiceOptionsSetupData.COptionsStringData[index].CType;
			CMOptionsStringSpiceName	= CBerklySpiceOptionsSetupData.COptionsStringData[index].SpiceName;
			m_include_string			= CBerklySpiceOptionsSetupData.COptionsStringData[index].m_include;
			m_tran_nodeset				= CBerklySpiceOptionsSetupData.tran_nodeset;				
		}
	}
	count = CBerklySpiceOptionsSetupData.COptionsStringData.GetSize();

	for(p = 0; p < count; p++)
	{
		CMOptionStringList.SetItemText(p, 0, CBerklySpiceOptionsSetupData.COptionsStringData[p].CType);

		CMOptionStringList.SetItemText(p, 1, CBerklySpiceOptionsSetupData.COptionsStringData[p].SpiceName);

		CMOptionStringList.SetItemText(p, 2, CBerklySpiceOptionsSetupData.COptionsStringData[p].CValue);

		if(CBerklySpiceOptionsSetupData.COptionsStringData[p].m_include)
			CText = "Yes";
		else CText = "No";

		CMOptionStringList.SetItemText(p, 3, CText);
	}

	UpdateData(false);

	CMOptionsList.SetItemState(CBerklySpiceOptionsSetupData.last_float_option_selected, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);

	CMOptionStringList.SetItemState(CBerklySpiceOptionsSetupData.last_string_option_selected, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);

}

void TCSpiceOptionsSetup::OnButtonDeleteFloat() 
{
	GetDisplay();

	int index = CBerklySpiceOptionsSetupData.last_float_option_selected;

	if(index < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize() && index > -1)
	{
		CBerklySpiceOptionsSetupData.COptionsFloatData.RemoveAt(index);
	}

//	if(CBerklySpiceOptionsSetupData.last_float_option_selected > 0)
//		CBerklySpiceOptionsSetupData.last_float_option_selected--;

	InsertItems();
	SetDisplay();
}

void TCSpiceOptionsSetup::OnButtonDeleteString() 
{
	GetDisplay();

	int index = CBerklySpiceOptionsSetupData.last_string_option_selected;

	if(index < CBerklySpiceOptionsSetupData.COptionsStringData.GetSize() && index > -1)
	{
		CBerklySpiceOptionsSetupData.COptionsStringData.RemoveAt(index);
	}

//	if(CBerklySpiceOptionsSetupData.last_string_option_selected > 0)
//		CBerklySpiceOptionsSetupData.last_string_option_selected--;

	InsertItems();
	SetDisplay();
}

void TCSpiceOptionsSetup::OnButtonInsertFloat() 
{
	GetDisplay();

	TCSpiceOptionsData CSpiceOptionsData;

	int index = CBerklySpiceOptionsSetupData.last_float_option_selected;
	if(index) index++;

	m_option_value			= CSpiceOptionsData.value;
	CMOptionsDescription	= CSpiceOptionsData.CType;
	CMOptionsSpiceName		= CSpiceOptionsData.SpiceName;

	CBerklySpiceOptionsSetupData.last_float_option_selected = index;

	CBerklySpiceOptionsSetupData.COptionsFloatData.InsertAt(index, CSpiceOptionsData);

	InsertItems();
	SetDisplay();
}

void TCSpiceOptionsSetup::OnButtonInsertString() 
{
	GetDisplay();

	TCSpiceOptionsData CSpiceOptionsData;

	int index = CBerklySpiceOptionsSetupData.last_string_option_selected;

	if(index) index++;

	CBerklySpiceOptionsSetupData.last_string_option_selected = index;

	CMOptionStringValue		= CSpiceOptionsData.CValue;
	CMOptionsDescription	= CSpiceOptionsData.CType;
	CMOptionsSpiceName		= CSpiceOptionsData.SpiceName;

	CBerklySpiceOptionsSetupData.COptionsStringData.InsertAt(index, CSpiceOptionsData);

	InsertItems();
	SetDisplay();
}

void TCSpiceOptionsSetup::OnClickListSpiceOptions(NMHDR* pNMHDR, LRESULT* pResult) 
{	
	*pResult = 0;
	pNMHDR;

	GetDisplay();

	int item = CMOptionsList.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item < 0) return;

	CMOptionsList.SetItemState(item, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);

	CBerklySpiceOptionsSetupData.last_float_option_selected = item;

	SetDisplay();// Display new value in edit box
}

void TCSpiceOptionsSetup::OnClickListSpiceOptionsString(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	pNMHDR;

	GetDisplay();

	int item = CMOptionStringList.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item < 0) return;

	CMOptionStringList.SetItemState(item, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);

	CBerklySpiceOptionsSetupData.last_string_option_selected = item;

	SetDisplay();
}

/////////////////////////////////////////////////////////////////
BOOL TCDistortionSetup::OnKillActive() 
{
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CDistortionSetupData.enable		= m_enable;
		CDistortionSetupData.frequency	= m_frequency;
		CDistortionSetupData.type		= m_type;
		CDistortionSetupData.enable_plot_all	= m_enable_plot_all;
		CDistortionSetupData.enable_print_all	= m_enable_print_all;
	}

	return value;
}
BOOL TCDistortionSetup::OnInitDialog() 
{
	m_enable			= CDistortionSetupData.enable;
	m_frequency			=  CDistortionSetupData.frequency;
	m_type				= CDistortionSetupData.type;
	m_enable_plot_all	= CDistortionSetupData.enable_plot_all;
	m_enable_print_all  = CDistortionSetupData.enable_print_all;

	CPropertyPage::OnInitDialog();
	
	return TRUE;
}

BOOL TCPoleZeroSetup::OnKillActive() 
{
	int value = CPropertyPage::OnKillActive();

	if(value)
	{
		CPoleZeroSetupData.enable	= m_enable;
		CPoleZeroSetupData.type		= m_type;
		CPoleZeroSetupData.COutput2	= CMOutputNeg;
		CPoleZeroSetupData.COutput1	= CMOutputPos;
		CPoleZeroSetupData.CSource2	= CMInputNeg;
		CPoleZeroSetupData.CSource1	= CMInputPos;
	}

	return value;

}
BOOL TCPoleZeroSetup::OnInitDialog() 
{
	m_enable		= CPoleZeroSetupData.enable;
	m_type			= CPoleZeroSetupData.type;
	CMOutputNeg		= CPoleZeroSetupData.COutput2;
	CMOutputPos		= CPoleZeroSetupData.COutput1;
	CMInputNeg		= CPoleZeroSetupData.CSource2;
	CMInputPos		= CPoleZeroSetupData.CSource1;

	CPropertyPage::OnInitDialog();
	
	CMInputPosList.ResetContent();
	CMInputNegList.ResetContent();
	CMOutputPosList.ResetContent();
	CMOutputListNeg.ResetContent();

	int count = CSourceList.CData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CMInputPosList.InsertString(-1, CSourceList.CData[p].CUserName);
	}

	if(count)
	{
		CMInputPosList.SelectString(-1, CPoleZeroSetupData.CSource1);
	}

	for(p = 0; p < count; p++)
	{
		CMInputNegList.InsertString(-1, CSourceList.CData[p].CUserName);
	}

	if(count)
	{
		CMInputNegList.SelectString(-1, CPoleZeroSetupData.CSource2);
	}
///////////
	for(p = 0; p < count; p++)
	{
		CMOutputPosList.InsertString(-1, COutputList.CData[p].CUserName);
	}

	if(count)
	{
		CMOutputPosList.SelectString(-1, CPoleZeroSetupData.COutput1);
	}

	for(p = 0; p < count; p++)
	{
		CMOutputListNeg.InsertString(-1, COutputList.CData[p].CUserName);
	}

	if(count)
	{
		CMOutputListNeg.SelectString(-1, CPoleZeroSetupData.COutput2);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////
TCReRunSetup::TCReRunSetup() : CPropertyPage(TCReRunSetup::IDD)
{
	//{{AFX_DATA_INIT(TCReRunSetup)
	m_nominal_npn = FALSE;
	m_nominal_nmos = FALSE;
	m_nominal_pmos = FALSE;
	m_nominal_pnp = FALSE;
	m_nominal_rc = FALSE;
	m_strong_nmos = FALSE;
	m_strong_npn = FALSE;
	m_strong_pmos = FALSE;
	m_strong_pnp = FALSE;
	m_strong_rc = FALSE;
	m_weak_nmos = FALSE;
	m_weak_npn = FALSE;
	m_weak_pmos = FALSE;
	m_weak_pnp = FALSE;
	m_weak_rc = FALSE;
	m_number_of_reruns = 0;
	m_strong_qrc_param = FALSE;
	m_strong_generator = FALSE;
	m_nominal_qrc_param = FALSE;
	m_nominal_generator = FALSE;
	m_weak_qrc_param = FALSE;
	m_weak_generator = FALSE;
	m_strong_sub = FALSE;
	m_weak_sub = FALSE;
	m_nominal_sub = FALSE;
	m_nominal_temp = FALSE;
	m_strong_temp = FALSE;
	m_weak_temp = FALSE;
	m_enable = 0;
	m_xspice_run_mode = FALSE;
	m_distribution = 0;
	//}}AFX_DATA_INIT

	m_capacitor_tol = 1.0;
	m_inductor_tol	= 1.0;
	m_temp_nominal	= 1.0;
	m_temp_min		= 1.0;
	m_temp_max		= 1.0;
	m_resistor_tol	= 1.0;
	m_generator_tol = 1.0;
}

TCReRunSetup::~TCReRunSetup()
{
}

void TCReRunSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCReRunSetup)
	DDX_Control(pDX, IDC_EDIT_NUMBER_OF_RERUNS, CMNumberOfReRuns);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_NPN, m_nominal_npn);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_NMOS, m_nominal_nmos);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_PMOS, m_nominal_pmos);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_PNP, m_nominal_pnp);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_RC, m_nominal_rc);
	DDX_Check(pDX, IDC_CHECK_STRONG_NMOS, m_strong_nmos);
	DDX_Check(pDX, IDC_CHECK_STRONG_NPN, m_strong_npn);
	DDX_Check(pDX, IDC_CHECK_STRONG_PMOS, m_strong_pmos);
	DDX_Check(pDX, IDC_CHECK_STRONG_PNP, m_strong_pnp);
	DDX_Check(pDX, IDC_CHECK_STRONG_RC, m_strong_rc);
	DDX_Check(pDX, IDC_CHECK_WEAK_NMOS, m_weak_nmos);
	DDX_Check(pDX, IDC_CHECK_WEAK_NPN, m_weak_npn);
	DDX_Check(pDX, IDC_CHECK_WEAK_PMOS, m_weak_pmos);
	DDX_Check(pDX, IDC_CHECK_WEAK_PNP, m_weak_pnp);
	DDX_Check(pDX, IDC_CHECK_WEAK_RC, m_weak_rc);
	DDX_Text(pDX, IDC_EDIT_NUMBER_OF_RERUNS, m_number_of_reruns);
	DDX_Check(pDX, IDC_CHECK_STRONG_DIODE, m_strong_qrc_param);
	DDX_Check(pDX, IDC_CHECK_STRONG_INDUCTOR, m_strong_generator);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_DIODE, m_nominal_qrc_param);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_INDUCTOR, m_nominal_generator);
	DDX_Check(pDX, IDC_CHECK_WEAK_DIODE, m_weak_qrc_param);
	DDX_Check(pDX, IDC_CHECK_WEAK_INDUCTOR, m_weak_generator);
	DDX_Check(pDX, IDC_CHECK_STRONG_RC2, m_strong_sub);
	DDX_Check(pDX, IDC_CHECK_WEAK_RC2, m_weak_sub);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_RC2, m_nominal_sub);
	DDX_Check(pDX, IDC_CHECK_NOMINAL_TEMP1, m_nominal_temp);
	DDX_Check(pDX, IDC_CHECK_STRONG_TEMP, m_strong_temp);
	DDX_Check(pDX, IDC_CHECK_WEAK_TEMP, m_weak_temp);
	DDX_MKSValue(pDX, IDC_EDIT_CAPACITOR_TOL, m_capacitor_tol);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_TOL, m_inductor_tol);
	DDX_MKSValue(pDX, IDC_EDIT_NOMINAL_TEMPERATURE, m_temp_nominal);
	DDX_MKSValue(pDX, IDC_EDIT_MIN_TEMPERATURE, m_temp_min);
	DDX_MKSValue(pDX, IDC_EDIT_MAX_TEMPERATURE, m_temp_max);
	DDX_MKSValue(pDX, IDC_EDIT_RESISTOR_TOL, m_resistor_tol);
	DDX_Radio(pDX, IDC_RADIO_ENABLE, m_enable);
	DDX_Check(pDX, IDC_CHECK_XSPICE_RUN_MODE, m_xspice_run_mode);
	DDX_MKSValue(pDX, IDC_EDIT_GENERATOR_TOL, m_generator_tol);
	DDX_MKSValue(pDX, IDC_EDIT_QWC_STRONG, m_qrc_strong);
	DDX_MKSValue(pDX, IDC_EDIT_QRC_WEAK, m_qrc_weak);
	DDX_MKSValue(pDX, IDC_EDIT_QRC_NOM, m_qrc_nom);
	DDX_Radio(pDX, IDC_RADIO_DISTRIBUTION, m_distribution);
	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCReRunSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCReRunSetup)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR_ALL, OnButtonClearAll)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_ALL, OnButtonSelectAll)
	ON_BN_CLICKED(IDC_BUTTON_CORNERS, OnButtonCorners)
	ON_BN_CLICKED(IDC_CHECK_WEAK_NPN, OnCheckWeakNpn)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_NPN, OnCheckNominalNpn)
	ON_BN_CLICKED(IDC_CHECK_STRONG_NPN, OnCheckStrongNpn)
	ON_BN_CLICKED(IDC_CHECK_WEAK_PNP, OnCheckWeakPnp)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_PNP, OnCheckNominalPnp)
	ON_BN_CLICKED(IDC_CHECK_STRONG_PNP, OnCheckStrongPnp)
	ON_BN_CLICKED(IDC_CHECK_WEAK_DIODE, OnCheckWeakQRCParam)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_DIODE, OnCheckNominalQRCParam)
	ON_BN_CLICKED(IDC_CHECK_STRONG_DIODE, OnCheckStrongQRCParam)
	ON_BN_CLICKED(IDC_CHECK_WEAK_RC, OnCheckWeakRCL)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_RC, OnCheckNominalRCL)
	ON_BN_CLICKED(IDC_CHECK_STRONG_RC, OnCheckStrongRCL)
	ON_BN_CLICKED(IDC_CHECK_WEAK_NMOS, OnCheckWeakNmos)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_NMOS, OnCheckNominalNmos)
	ON_BN_CLICKED(IDC_CHECK_STRONG_NMOS, OnCheckStrongNmos)
	ON_BN_CLICKED(IDC_CHECK_WEAK_PMOS, OnCheckWeakPmos)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_PMOS, OnCheckNominalPmos)
	ON_BN_CLICKED(IDC_CHECK_STRONG_PMOS, OnCheckStrongPmos)
	ON_BN_CLICKED(IDC_CHECK_WEAK_INDUCTOR, OnCheckWeakGenerator)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_INDUCTOR, OnCheckNominalGenerator)
	ON_BN_CLICKED(IDC_CHECK_STRONG_INDUCTOR, OnCheckStrongGenerator)
	ON_BN_CLICKED(IDC_CHECK_STRONG_RC2, OnCheckStrongSubckt)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_RC2, OnCheckNominalSubckt)
	ON_BN_CLICKED(IDC_CHECK_WEAK_RC2, OnCheckWeakSubckt)
	ON_BN_CLICKED(IDC_BUTTON_ALL_NOMINAL, OnButtonAllNominal)
	ON_BN_CLICKED(IDC_CHECK_STRONG_TEMP, OnCheckStrongTemp)
	ON_BN_CLICKED(IDC_CHECK_NOMINAL_TEMP1, OnCheckNominalTemp)
	ON_BN_CLICKED(IDC_CHECK_WEAK_TEMP, OnCheckWeakTemp)
	ON_BN_CLICKED(IDC_BUTTON_STRONG_MAXT, OnButtonStrongMaxTemp)
	ON_BN_CLICKED(IDC_BUTTON_STRONG_MINT, OnButtonStrongMinTemp)
	ON_BN_CLICKED(IDC_BUTTON_WEAK_HT, OnButtonWeakMaxTemp)
	ON_BN_CLICKED(IDC_BUTTON_WEAK_LOWT, OnButtonWeakMinTemp)
	ON_BN_CLICKED(IDC_RADIO_ENABLE, OnRadioDisable)
	ON_BN_CLICKED(IDC_RADIO_ENABLE2, OnRadioEnableWC)
	ON_BN_CLICKED(IDC_RADIO_ENABLE3, OnRadioEnableMC)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_RADIO_DISTRIBUTION, &TCReRunSetup::OnBnClickedRadioDistributionUniform)
	ON_BN_CLICKED(IDC_RADIO_DISTRIBUTION2, &TCReRunSetup::OnBnClickedRadioDistributionGaussian)
	ON_BN_CLICKED(IDC_CHECK_XSPICE_RUN_MODE, &TCReRunSetup::OnBnClickedCheckXSpiceRunMode)
END_MESSAGE_MAP()

BOOL TCReRunSetup::OnKillActive() 
{	
	BOOL result = CPropertyPage::OnKillActive();

	GetDisplay();

	return result;
}

BOOL TCReRunSetup::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	SetDisplay();

	return TRUE;  
}

void TCReRunSetup::SetDisplay(void)
{
	m_enable		= CReRun.enable;

	//Rerun enable will be changed dynamaicaly depending on whether .subckts are being swept. 
	if(m_enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) m_enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) CMNumberOfReRuns.SetReadOnly(false);
	else CMNumberOfReRuns.SetReadOnly(true);

	m_nominal_npn	= CReRun.CWorstCase[E_WORST_CASE_NPN].nominal;
	m_nominal_nmos	= CReRun.CWorstCase[E_WORST_CASE_NMOS].nominal;
	m_nominal_pmos	= CReRun.CWorstCase[E_WORST_CASE_PMOS].nominal;
	m_nominal_pnp	= CReRun.CWorstCase[E_WORST_CASE_PNP].nominal;
	m_nominal_rc	= CReRun.CWorstCase[E_WORST_CASE_RLC].nominal;
	m_strong_nmos	= CReRun.CWorstCase[E_WORST_CASE_NMOS].strong;
	m_strong_npn	= CReRun.CWorstCase[E_WORST_CASE_NPN].strong;
	m_strong_pmos	= CReRun.CWorstCase[E_WORST_CASE_PMOS].strong;
	m_strong_pnp	= CReRun.CWorstCase[E_WORST_CASE_PNP].strong;
	m_strong_rc		= CReRun.CWorstCase[E_WORST_CASE_RLC].strong;
	m_weak_nmos		= CReRun.CWorstCase[E_WORST_CASE_NMOS].weak;
	m_weak_npn		= CReRun.CWorstCase[E_WORST_CASE_NPN].weak;
	m_weak_pmos		= CReRun.CWorstCase[E_WORST_CASE_PMOS].weak;
	m_weak_pnp		= CReRun.CWorstCase[E_WORST_CASE_PNP].weak;
	m_weak_rc		= CReRun.CWorstCase[E_WORST_CASE_RLC].weak;
	m_nominal_qrc_param	= CReRun.CWorstCase[E_WORST_CASE_QR].nominal;
	m_nominal_generator = CReRun.CWorstCase[E_WORST_CASE_GENERATOR].nominal;
	m_strong_qrc_param	= CReRun.CWorstCase[E_WORST_CASE_QR].strong;
	m_strong_generator = CReRun.CWorstCase[E_WORST_CASE_GENERATOR].strong;
	m_weak_qrc_param	= CReRun.CWorstCase[E_WORST_CASE_QR].weak;
	m_weak_generator	= CReRun.CWorstCase[E_WORST_CASE_GENERATOR].weak;
	m_weak_sub		= CReRun.CWorstCase[E_WORST_CASE_SUB].weak;
	m_nominal_sub		= CReRun.CWorstCase[E_WORST_CASE_SUB].nominal;
	m_strong_sub		= CReRun.CWorstCase[E_WORST_CASE_SUB].strong;

	m_weak_temp		= CReRun.CWorstCase[E_WORST_CASE_TEMP].weak;
	m_nominal_temp	= CReRun.CWorstCase[E_WORST_CASE_TEMP].nominal;
	m_strong_temp	= CReRun.CWorstCase[E_WORST_CASE_TEMP].strong;

	m_capacitor_tol = CReRun.capacitor_tol;
	m_inductor_tol	= CReRun.inductor_tol;
	m_resistor_tol	= CReRun.resistor_tol;
	m_generator_tol = CReRun.generator_tol;
	m_temp_nominal	= CReRun.temp_nominal;
	m_temp_min		= CReRun.temp_min;
	m_temp_max		= CReRun.temp_max;
	m_qrc_weak		= CReRun.qrc_max;
	m_qrc_nom		= CReRun.qrc_nom;
	m_qrc_strong    = CReRun.qrc_min;
	m_distribution  = CReRun.distribution;

	m_xspice_run_mode = !!CReRun.xspice_run_mode;

	m_number_of_reruns = CReRun.CalculateNumberOfReRuns();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) m_number_of_reruns = (int) CReRun.number_of_wc_runs;

	UpdateData(false);
}

void TCReRunSetup::GetDisplay(void)
{
	UpdateData(true);

	CReRun.enable = m_enable;

	CReRun.xspice_run_mode = m_xspice_run_mode;

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) CReRun.number_of_wc_runs = m_number_of_reruns;

	CReRun.CWorstCase[E_WORST_CASE_NPN].nominal		= !!m_nominal_npn;
	CReRun.CWorstCase[E_WORST_CASE_NMOS].nominal	= !!m_nominal_nmos;
	CReRun.CWorstCase[E_WORST_CASE_PMOS].nominal	= !!m_nominal_pmos;
	CReRun.CWorstCase[E_WORST_CASE_PNP].nominal		= !!m_nominal_pnp;
	CReRun.CWorstCase[E_WORST_CASE_RLC].nominal		= !!m_nominal_rc;
	CReRun.CWorstCase[E_WORST_CASE_NMOS].strong		= !!m_strong_nmos;
	CReRun.CWorstCase[E_WORST_CASE_NPN].strong		= !!m_strong_npn;
	CReRun.CWorstCase[E_WORST_CASE_PMOS].strong		= !!m_strong_pmos;
	CReRun.CWorstCase[E_WORST_CASE_PNP].strong		= !!m_strong_pnp;
	CReRun.CWorstCase[E_WORST_CASE_RLC].strong		= !!m_strong_rc;
	CReRun.CWorstCase[E_WORST_CASE_NMOS].weak		= !!m_weak_nmos;
	CReRun.CWorstCase[E_WORST_CASE_NPN].weak		= !!m_weak_npn;
	CReRun.CWorstCase[E_WORST_CASE_PMOS].weak		= !!m_weak_pmos;
	CReRun.CWorstCase[E_WORST_CASE_PNP].weak		= !!m_weak_pnp;
	CReRun.CWorstCase[E_WORST_CASE_RLC].weak			= !!m_weak_rc;
	CReRun.CWorstCase[E_WORST_CASE_QR].nominal   = !!m_nominal_qrc_param;
	CReRun.CWorstCase[E_WORST_CASE_GENERATOR].nominal		= !!m_nominal_generator;
	CReRun.CWorstCase[E_WORST_CASE_QR].strong	= !!m_strong_qrc_param;
	CReRun.CWorstCase[E_WORST_CASE_GENERATOR].strong		= !!m_strong_generator;
	CReRun.CWorstCase[E_WORST_CASE_QR].weak		= !!m_weak_qrc_param;
	CReRun.CWorstCase[E_WORST_CASE_GENERATOR].weak			= !!m_weak_generator;
	CReRun.CWorstCase[E_WORST_CASE_SUB].weak			= !!m_weak_sub;
	CReRun.CWorstCase[E_WORST_CASE_SUB].nominal		= !!m_nominal_sub;
	CReRun.CWorstCase[E_WORST_CASE_SUB].strong		= !!m_strong_sub;

	CReRun.CWorstCase[E_WORST_CASE_TEMP].weak		= !!m_weak_temp;
	CReRun.CWorstCase[E_WORST_CASE_TEMP].nominal	= !!m_nominal_temp;
	CReRun.CWorstCase[E_WORST_CASE_TEMP].strong		= !!m_strong_temp;

	CReRun.capacitor_tol = m_capacitor_tol;
	CReRun.inductor_tol	= m_inductor_tol;
	CReRun.generator_tol = m_generator_tol;
	CReRun.resistor_tol = m_resistor_tol;
	CReRun.temp_nominal = m_temp_nominal;
	CReRun.temp_min		= m_temp_min;
	CReRun.temp_max		= m_temp_max;
	CReRun.distribution = m_distribution;

	CReRun.qrc_max = m_qrc_weak;
	CReRun.qrc_nom = m_qrc_nom;
	CReRun.qrc_min = m_qrc_strong;

}

void TCReRunSetup::OnButtonClearAll() 
{
	CReRun.ClearAll();

	SetDisplay();
}

void TCReRunSetup::OnButtonSelectAll() 
{
	CReRun.SelectAll();

	SetDisplay();
}

void TCReRunSetup::OnButtonAllNominal() 
{
	CReRun.SelectAllNominal();

	SetDisplay();	
}

void TCReRunSetup::OnButtonCorners() 
{
	CReRun.SelectMaxMin();

	SetDisplay();
}

void TCReRunSetup::OnButtonStrongMaxTemp() 
{
	CReRun.AllStrongMaxTemp();

	SetDisplay();
}

void TCReRunSetup::OnButtonStrongMinTemp() 
{
	CReRun.AllStrongMinTemp();

	SetDisplay();
}

void TCReRunSetup::OnButtonWeakMaxTemp() 
{
	CReRun.AllWeakMaxTemp();

	SetDisplay();	
}

void TCReRunSetup::OnButtonWeakMinTemp() 
{
	CReRun.AllWeakMinTemp();

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakNpn() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_NPN].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_NPN].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_NPN].strong = 0;
	}

	SetDisplay();
}

void TCReRunSetup::OnCheckNominalNpn() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_NPN].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_NPN].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_NPN].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongNpn() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_NPN].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_NPN].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_NPN].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakPnp() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_PNP].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_PNP].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_PNP].strong = 0;
	}	
	
	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalPnp() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_PNP].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_PNP].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_PNP].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongPnp() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_PNP].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_PNP].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_PNP].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakQRCParam() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_QR].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_QR].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_QR].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalQRCParam() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_QR].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_QR].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_QR].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongQRCParam() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_QR].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_QR].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_QR].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakRCL() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_RLC].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_RLC].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_RLC].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalRCL() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_RLC].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_RLC].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_RLC].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongRCL() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_RLC].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_RLC].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_RLC].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakNmos() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_NMOS].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_NMOS].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_NMOS].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongNmos()
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_NMOS].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_NMOS].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_NMOS].strong = 1;
	}

	SetDisplay();
}
void TCReRunSetup::OnCheckNominalNmos() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_NMOS].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_NMOS].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_NMOS].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakPmos() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_PMOS].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_PMOS].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_PMOS].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalPmos() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_PMOS].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_PMOS].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_PMOS].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongPmos() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_PMOS].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_PMOS].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_PMOS].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakGenerator() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalGenerator() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongGenerator() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_GENERATOR].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongSubckt() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_SUB].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_SUB].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_SUB].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalSubckt() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_SUB].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_SUB].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_SUB].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakSubckt() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_SUB].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_SUB].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_SUB].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckStrongTemp() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_TEMP].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_TEMP].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_TEMP].strong = 1;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckNominalTemp() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_TEMP].weak = 0;
		CReRun.CWorstCase[E_WORST_CASE_TEMP].nominal = 1;
		CReRun.CWorstCase[E_WORST_CASE_TEMP].strong = 0;
	}

	SetDisplay();	
}

void TCReRunSetup::OnCheckWeakTemp() 
{
	GetDisplay();

	if(m_enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CReRun.CWorstCase[E_WORST_CASE_TEMP].weak = 1;
		CReRun.CWorstCase[E_WORST_CASE_TEMP].nominal = 0;
		CReRun.CWorstCase[E_WORST_CASE_TEMP].strong = 0;
	}

	SetDisplay();	
}

void TCParameterSetup::OnRadioDecadeSweeps() 
{
	CEditSteps.SetReadOnly(false);
	
	CMCtrlFileName.SetReadOnly(true);
	CMComboParameter.EnableWindow(true);
	CMComboSource.EnableWindow(true);
	CEditValueList.SetReadOnly(true);
	CMEditStart.SetReadOnly(false);
	CMEditStop.SetReadOnly(false);
}

void TCParameterSetup::OnRadioOctaveSweeps() 
{
	CEditSteps.SetReadOnly(false);

	CMCtrlFileName.SetReadOnly(true);
	CMComboParameter.EnableWindow(true);
	CMComboSource.EnableWindow(true);
	CEditValueList.SetReadOnly(true);
	CMEditStart.SetReadOnly(false);
	CMEditStop.SetReadOnly(false);
}

void TCParameterSetup::OnRadioLinearSweep() 
{
	CEditSteps.SetReadOnly(false);

	CMCtrlFileName.SetReadOnly(true);
	CMComboParameter.EnableWindow(true);
	CMComboSource.EnableWindow(true);
	CEditValueList.SetReadOnly(true);
	CMEditStart.SetReadOnly(false);
	CMEditStop.SetReadOnly(false);
}

void TCParameterSetup::OnRadioLinearSweep3() 
{
	CMCtrlFileName.SetReadOnly(false);
	CMComboParameter.EnableWindow(false);
	CMComboSource.EnableWindow(false);
	CEditValueList.SetReadOnly(true);
	CMEditStart.SetReadOnly(true);
	CMEditStop.SetReadOnly(true);
	CEditSteps.SetReadOnly(true);
}

void TCParameterSetup::OnRadioLinearValueList() 
{
	CEditValueList.SetReadOnly(false);
	CMCtrlFileName.SetReadOnly(true);
	CMComboParameter.EnableWindow(true);
	CMComboSource.EnableWindow(true);
	CMEditStart.SetReadOnly(true);
	CMEditStop.SetReadOnly(true);
	CEditSteps.SetReadOnly(true);
}

void TCParameterSetup::OnButtonEditRrgFile() 
{
	CString CFileName, CMsg;

	CFileName = RemoveExtention(CMFileName);

	CFileName += ".rrg";

	if(!FileExists(CFileName)) 
	{
		CFile CDataFile;

		if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) 
		{
			CMsg.LoadString(IDS_UNABLE_TO_CREATE_FILE);
		
			CMsg += " ";

			CMsg += CFileName;

			AfxMessageBox(CMsg);

			return;
		}

		CDataFile.Close();
	}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCParameterSetup::OnButtonEditRrnFile() 
{
	CString CFileName, CMsg;

	CFileName = CMFileName;

	if(!FileExists(CFileName)) 
	{
		CFile CDataFile;

		if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) 
		{
			CMsg.LoadString(IDS_UNABLE_TO_CREATE_FILE);
		
			CMsg += " ";

			CMsg += CFileName;

			AfxMessageBox(CMsg);

			return;
		}

		CDataFile.Close();
	}

	AfxGetApp()->OpenDocumentFile(CFileName);	
}

void TCACSetup::WinHelp(DWORD dwData, UINT nCmd) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CPropertyPage::WinHelp(dwData, nCmd);
}

void TCSensitivitiesSetup::OnCheckEnableAc() 
{
	if(!m_enable_ac)
	{
		CMEnableDC.SetCheck(false);

		m_enable_dc = false;
	}
}

void TCSensitivitiesSetup::OnCheckEnableDc() 
{
	if(!m_enable_dc)
	{
		CMEnableAC.SetCheck(false);

		m_enable_dc = false;
	}
}



void TCParameterSetup::OnButtonGenerateRNNFile() 
{
	TCReRuns CReRuns;

	CString CLocalFileName, CMsg;

	CLocalFileName = RemoveExtention(CMFileName);

	CLocalFileName += ".rrg";

	if(!FileExists(CLocalFileName)) 
	{
		CMsg.LoadString(IDS_UNABLE_TO_FIND_RRG_FILE);
		
		CMsg += " ";

		CMsg += CLocalFileName;

		AfxMessageBox(CMsg);

		return;
	}

	if(!CReRuns.LoadSetup(CLocalFileName))
	{
		CMsg.LoadString(IDS_UNABLE_TO_CREATE_RRN_FILE);

		return;
	}

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->OpenDocumentFile(CMFileName);
}

void TCReRunSetup::OnRadioDisable() 
{	
	m_number_of_reruns = CReRun.CalculateNumberOfReRuns();

	CMNumberOfReRuns.SetReadOnly(true);

	m_enable = 0;

	UpdateData(false);
}

void TCReRunSetup::OnRadioEnableWC() 
{
	m_number_of_reruns = CReRun.CalculateNumberOfReRuns();

	CMNumberOfReRuns.SetReadOnly(true);

	m_enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;

	CReRun.enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;

	UpdateData(false);
}

void TCReRunSetup::OnRadioEnableMC() 
{
	m_number_of_reruns = (int) CReRun.number_of_wc_runs;

	CMNumberOfReRuns.SetReadOnly(false);

	m_enable = E_RERUN_SWEEP_TYPE_MC_RERUN_FILE;

	CReRun.enable = E_RERUN_SWEEP_TYPE_MC_RERUN_FILE;

	if(CReRun.CalculateNumberOfReRuns() != 1) OnButtonAllNominal();// Can only run one WC type for MC runs

	SetDisplay();
}


void TCTransientSetup::OnCalculateAverageFrequency() 
{
	if(!PCSuperSpiceDocLastFocused)	return;

	UpdateData(true);

	TCWaveformAnalyisisData CWaveformAnalyisisData;

	CWaveformAnalyisisData.trans_frequency_enable	= !!m_trans_frequency_enable;			
	CWaveformAnalyisisData.trans_xing_level			= m_trans_xing_level;
	CWaveformAnalyisisData.trans_xing_first_count	= m_trans_xing_first_count;
	CWaveformAnalyisisData.trans_xing_last_count	= m_trans_xing_last_count;

	if(m_trans_xing_sign)// 1 is negative slope
		CWaveformAnalyisisData.trans_xing_sign		= -1;
	else // positive slope
		CWaveformAnalyisisData.trans_xing_sign		= 1;

	PCSuperSpiceDocLastFocused->CalculateAverageFrequency(CWaveformAnalyisisData);

}

void TCReRunSetup::OnBnClickedRadioDistributionUniform()
{
	m_distribution = 0;

	UpdateData(false);
}

void TCReRunSetup::OnBnClickedRadioDistributionGaussian()
{
	m_distribution = 1;

	UpdateData(false);
}

void TCReRunSetup::OnBnClickedCheckXSpiceRunMode()
{
	m_xspice_run_mode = !m_xspice_run_mode;

	UpdateData(false);
}


