// TCSimulationPropertyPages.h : header file
//

#ifndef __TCSIMULATIONPROPERTYPAGES_H__
#define __TCSIMULATIONPROPERTYPAGES_H__

/////////////////////////////////////////////////////////////////////////////
// TCACSetup dialog

class TCACSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCACSetup)

// Construction
public:
	TCACSetup();
	~TCACSetup();

	TCACSetupData CACSetupData;
	TCSpiceNodeList CSourceList;

// Dialog Data
	//{{AFX_DATA(TCACSetup)
	enum { IDD = IDD_PROPPAGE_AC_ANALYSIS };
	CComboBox	CMComboSourceList;
	BOOL	m_enable;
	int		m_type;
	double	m_stop;
	double	m_start;
	double	m_step;
	BOOL	m_enable_plot_all;
	BOOL	m_enable_print_all;
	CString	CMLoopGainSource;
	double	m_zero_phase;
	BOOL	m_plot_ac_analysis;
	int		m_ac_analysis_type;
	CString CMMultiRunACParam;
	CString CMRefDesSweptDevice;
	CString CMRefSweptDeviceFreq;
	int		m_freq_device_mode;

	CString CMStartFrequency;
	CString CMStopFrequency;
	CString CMNumberOfPoints;

	//}}AFX_DATA

	void SetLabels(void);
// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCACSetup)
	public:
	virtual BOOL OnSetActive();
	virtual void OnOK();
	virtual BOOL OnKillActive();
	virtual void WinHelp(DWORD dwData, UINT nCmd = HELP_CONTEXT);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCACSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
	afx_msg void OnBnClickedRadioSweepModeDevice();
	afx_msg void OnBnClickedRadioSweepModeFrequency();
	afx_msg void OnBnClickedRadioDecadeSweeps();
	afx_msg void OnBnClickedRadioOctaveSweeps();
	afx_msg void OnBnClickedRadioLinearSweep();
};


/////////////////////////////////////////////////////////////////////////////
// TCDCSetup dialog

class TCDCSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCDCSetup)

// Construction
public:
	TCDCSetup();
	~TCDCSetup();

	TCDCSetupData CDCSetupData;
	TCSpiceNodeList CSourceList;
	TCParametricSetupData CParametricSetupData;
// Dialog Data
	//{{AFX_DATA(TCDCSetup)
	enum { IDD = IDD_PROPPAGE_DC_ANALYSIS };
	CComboBox	CMComboSourceList2;
	CComboBox	CMComboSourceList1;
	BOOL	m_enable1;
	BOOL	m_enable2;
	int		m_type1;
	int		m_type2;
	double	m_stop2;
	double	m_stop1;
	double	m_start2;
	double	m_start1;
	double	m_step2;
	double	m_step1;
	CString	CMComboSource2;
	CString	CMComboSource1;
	BOOL	m_enable_plot_all;
	BOOL	m_enable_print_all;
	BOOL	m_enable_operating_point;
	BOOL m_display_device_op_points;
	CString CMMultiRunDCParam;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCDCSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCDCSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// TCNoiseSetup dialog

class TCNoiseSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCNoiseSetup)

// Construction
public:
	TCNoiseSetup();
	~TCNoiseSetup();

	TCNoiseSetupData CNoiseSetupData;
	TCSpiceNodeList COutputList;
	TCSpiceNodeList CSourceList;

// Dialog Data
	//{{AFX_DATA(TCNoiseSetup)
	enum { IDD = IDD_PROPPAGE_NOISE_ANALYSIS1 };
	CComboBox	CMComboSource;
	CComboBox	CMComboOutput;
	BOOL	m_enable;
	CString	CMSource;
	CString	CMOutput;
	BOOL	m_check_enable_summary;
	CString	CMEditSummaryPoints;
	CString CMNoiseReportFrequencyList;
	CString CMMultiRunNoiseParam;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCNoiseSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCNoiseSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// TCTransientSetup dialog

class TCTransientSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCTransientSetup)

// Construction
public:
	TCTransientSetup();
	~TCTransientSetup();

	TCTransientSetupData CTransientSetupData;
	TCSpiceNodeList COutputList;
	TCSpiceNodeList CSourceList;
// Dialog Data
	//{{AFX_DATA(TCTransientSetup)
	enum { IDD = IDD_PROPPAGE_TRANSIENT_ANALYSIS };
	CComboBox	CMComboSource;
	CEdit	CMEditMaxStepSize;
	CComboBox	CMComboOutput;
	BOOL	m_enable;
	double	m_stop;
	double	m_start;
	double	m_frequency;
	CString	CMOutput;
	BOOL	m_fourier_enable;
	BOOL	m_enable_plot_all;
	BOOL	m_enable_print_all;
	BOOL	m_enable_print_all_fourier;
	BOOL	m_enable_plot_all_fourier;
	double	m_max_compute_step_size;
	BOOL	m_use_initial_conditions;
	BOOL	m_linearize_transient_data;
	BOOL	m_trans_frequency_enable;
	CString	CMTransFrequencySignalName;
	int		m_trans_xing_sign;
	UINT	m_trans_xing_last_count;
	UINT	m_trans_xing_first_count;
	double	m_trans_xing_level;
	BOOL	m_enable_marching_waveforms;
	BOOL	m_full_scale_marching_xaxis;
	BOOL	m_enable_real_time_changes;
	BOOL	m_auto_calc_fft;
	BOOL    m_calc_selected_signals_fft;

	double	m_trans_step_time;

	CString CMultiRunTranParam;

	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCTransientSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCTransientSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnCheckMaxCalcIsPrintTime();
	afx_msg void OnCalculateAverageFrequency();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class TCReRunSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCReRunSetup)

// Construction
public:
	TCReRunSetup();
	~TCReRunSetup();

	void SetDisplay(void);
	void GetDisplay(void);

	TCReRun CReRun;
// Dialog Data
	//{{AFX_DATA(TCReRunSetup)
	enum { IDD = IDD_PROPPAGE_RERUN };
	CEdit	CMNumberOfReRuns;
	BOOL	m_nominal_npn;
	BOOL	m_nominal_nmos;
	BOOL	m_nominal_pmos;
	BOOL	m_nominal_pnp;
	BOOL	m_nominal_rc;
	BOOL	m_strong_nmos;
	BOOL	m_strong_npn;
	BOOL	m_strong_pmos;
	BOOL	m_strong_pnp;
	BOOL	m_strong_rc;
	BOOL	m_weak_nmos;
	BOOL	m_weak_npn;
	BOOL	m_weak_pmos;
	BOOL	m_weak_pnp;
	BOOL	m_weak_rc;
	int		m_number_of_reruns;
	BOOL	m_strong_qrc_param;
	BOOL	m_strong_generator;
	BOOL	m_nominal_qrc_param;
	BOOL	m_nominal_generator;
	BOOL	m_weak_qrc_param;
	BOOL	m_weak_generator;
	BOOL	m_strong_sub;
	BOOL	m_weak_sub;
	BOOL	m_nominal_sub;
	BOOL	m_nominal_temp;
	BOOL	m_strong_temp;
	BOOL	m_weak_temp;
	double	m_capacitor_tol;
	double	m_inductor_tol;
	double	m_temp_nominal;
	double	m_temp_min;
	double	m_temp_max;
	double	m_resistor_tol;
	int		m_enable;
	BOOL	m_xspice_run_mode;
	double  m_generator_tol;
	double  m_qrc_strong;
	double 	m_qrc_weak;
	double 	m_qrc_nom;
	int m_distribution;

	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCReRunSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCReRunSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonClearAll();
	afx_msg void OnButtonSelectAll();
	afx_msg void OnButtonCorners();
	afx_msg void OnCheckWeakNpn();
	afx_msg void OnCheckNominalNpn();
	afx_msg void OnCheckStrongNpn();
	afx_msg void OnCheckWeakPnp();
	afx_msg void OnCheckNominalPnp();
	afx_msg void OnCheckStrongPnp();
	afx_msg void OnCheckWeakQRCParam();
	afx_msg void OnCheckNominalQRCParam();
	afx_msg void OnCheckStrongQRCParam();
	afx_msg void OnCheckWeakRCL();
	afx_msg void OnCheckNominalRCL();
	afx_msg void OnCheckStrongRCL();
	afx_msg void OnCheckWeakNmos();
	afx_msg void OnCheckNominalNmos();
	afx_msg void OnCheckStrongNmos();
	afx_msg void OnCheckWeakPmos();
	afx_msg void OnCheckNominalPmos();
	afx_msg void OnCheckStrongPmos();
	afx_msg void OnCheckWeakGenerator();
	afx_msg void OnCheckNominalGenerator();
	afx_msg void OnCheckStrongGenerator();
	afx_msg void OnCheckStrongSubckt();
	afx_msg void OnCheckNominalSubckt();
	afx_msg void OnCheckWeakSubckt();
	afx_msg void OnButtonAllNominal();
	afx_msg void OnCheckStrongTemp();
	afx_msg void OnCheckNominalTemp();
	afx_msg void OnCheckWeakTemp();
	afx_msg void OnButtonStrongMaxTemp();
	afx_msg void OnButtonStrongMinTemp();
	afx_msg void OnButtonWeakMaxTemp();
	afx_msg void OnButtonWeakMinTemp();
	afx_msg void OnRadioDisable();
	afx_msg void OnRadioEnableWC();
	afx_msg void OnRadioEnableMC();
	afx_msg void OnBnClickedRadioDistributionUniform();
	afx_msg void OnBnClickedRadioDistributionGaussian();
	afx_msg void OnBnClickedCheckXSpiceRunMode();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:


};
///////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// TCMonteWorstSetup dialog

class TCMonteWorstSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCMonteWorstSetup)

// Construction
public:
	TCMonteWorstSetup();
	~TCMonteWorstSetup();

	TCStatisticsSetupData CStatisticsSetupData;
// Dialog Data
	//{{AFX_DATA(TCMonteWorstSetup)
	enum { IDD = IDD_PROPPAGE_STATISYICAL_ANALYSIS };
		// NOTE - ClassWizard will add data members here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCMonteWorstSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCMonteWorstSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////

class TCOutputSelectSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCOutputSelectSetup)

// Construction
public:
	TCOutputSelectSetup();
	~TCOutputSelectSetup();

	void GetDisplay(void);
	void SetDisplay(void);

	TCOutputSelectData	COutputSelectData;
	TCSpiceNodeList		COutputList;
	TCSpiceNodeList		CDeviceCurrentNodeList;

// Dialog Data
	//{{AFX_DATA(TCOutputSelectSetup)
	enum { IDD = IDD_DIALOG_OUTPUT_SELECT };
	CListBox	CListDeviceSource;
	CListBox	CListOutputsSource;
	CListBox	CListOutputsSelected;
	BOOL	m_all_currents;
	BOOL	m_all_volts;
	int		m_index_output_source;
	int		m_index_output_selected;
	int		m_index_device;
	int		m_text_file_type;
	BOOL	m_enable_auto_ad_conversion;
	CString	CADConversionVoltage;
	double	m_input_capacitance;
	double	m_output_resistance;
	double  m_transition_time;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCOutputSelectSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCOutputSelectSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonAdd();
	afx_msg void OnButtonDelete();
	afx_msg void OnSelchangeListOutputSelected();
	afx_msg void OnSelchangeListOutputSource();
	afx_msg void OnButtonAddDeviceNode();
	afx_msg void OnSelchangeListOutputDeviceCurrents();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
/////////////////////////////////////////////////////////////////////////////
// TCParameterSetup dialog

class TCParameterSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCParameterSetup)

// Construction
public:
	TCParameterSetup();
	~TCParameterSetup();

	void GetDisplay(void);
	void SetDisplay(bool ignore_ref_des_list=false);

	TCParametricSetupData CParametricSetupData;
	TCSpiceNodeList CSourceList;
// Dialog Data
	//{{AFX_DATA(TCParameterSetup)
	enum { IDD = IDD_PROPPAGE_PARAMETER_ANALYSIS };
	CButton	CMCtrlEnable;
	CEdit	CMEditStop;
	CEdit	CMEditStart;
	CEdit	CEditValueList;
	CEdit	CMCtrlFileName;
	CEdit	CEditSteps;
	CComboBox	CMComboParameter;
	CComboBox	CMComboSource;
	BOOL	m_enable;
	double	m_start;
	double	m_step;
	double	m_stop;
	int		m_type;
	CString	CMSource;
	CString	CMParameter;
	CString	CMFileName;
	BOOL	m_auto_generate_rerun_file;
	CString	CMValueList;
	BOOL	m_enable_parameter;
	double	m_number_of_runs;
	BOOL m_multi_run_enable;
	CString CMMultiRunSignal;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCParameterSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCParameterSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeComboParameter();
	afx_msg void OnSelchangeComboParameterSource();
	afx_msg void OnRadioDecadeSweeps();
	afx_msg void OnRadioOctaveSweeps();
	afx_msg void OnRadioLinearSweep();
	afx_msg void OnRadioLinearSweep3();
	afx_msg void OnButtonFileBrowse();
	afx_msg void OnButtonGenerateRNNFile();
	afx_msg void OnButtonEditRrgFile();
	afx_msg void OnButtonEditRrnFile();
	afx_msg void OnRadioLinearValueList();
	afx_msg void OnCheckEnableParam();
	afx_msg void OnButtonClearParamEnables();
	afx_msg void OnButtonCalculateRuns();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// TCSensitivitiesSetup dialog

class TCSensitivitiesSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCSensitivitiesSetup)

// Construction
public:
	TCSensitivitiesSetup();
	~TCSensitivitiesSetup();

	TCSensitivitySetupData CSensitivitySetupData;
	TCSpiceNodeList COutputList;
	TCSpiceNodeList CStaticOutputList;
	void SetDisplay(void);


// Dialog Data
	//{{AFX_DATA(TCSensitivitiesSetup)
	enum { IDD = IDD_PROPPAGE_SENSITIVITY };
	CButton	CMEnableDC;
	CButton	CMEnableAC;
	CListBox	CListDCList;
	CListBox	CListACList;
	BOOL	m_enable_print_all;
	BOOL	m_enable_plot_all;
	BOOL	m_enable_dc;
	BOOL	m_enable_ac;
	CString	CListStringAC;
	CString	CListStringDC;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCSensitivitiesSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCSensitivitiesSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeListOutputAc();
	afx_msg void OnSelchangeListOutputDc();
	afx_msg void OnCheckEnableAc();
	afx_msg void OnCheckEnableDc();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// TCSpiceOptionsSetup dialog

class TCSpiceOptionsSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCSpiceOptionsSetup)

// Construction
public:
	TCSpiceOptionsSetup();
	~TCSpiceOptionsSetup();

	void GetDisplay(void);
	void SetDisplay(void);
	void InsertItems(void);

	TCSpiceNodeList COutputList;

	TCBerklySpiceOptionsSetupData CBerklySpiceOptionsSetupData;
// Dialog Data
	//{{AFX_DATA(TCSpiceOptionsSetup)
	enum { IDD = IDD_PROPPAGE_BERKLY_OPTION };
	CListCtrl	CMOptionStringList;
	CListCtrl	CMOptionsList;
	CString	CMOptionStringValue;
	CString	CMOptionsSpiceName;
	CString	CMOptionsStringSpiceName;
	CString	CMOptionsStringDescription;
	CString	CMOptionsDescription;
	BOOL	m_include_double;
	BOOL	m_include_string;
	BOOL    m_tran_nodeset;
	double	m_option_value;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCSpiceOptionsSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCSpiceOptionsSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnClickListSpiceOptions(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnButtonDeleteFloat();
	afx_msg void OnButtonDeleteString();
	afx_msg void OnButtonInsertFloat();
	afx_msg void OnButtonInsertString();
	afx_msg void OnClickListSpiceOptionsString(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
	BOOL tran_nodeset;
};

// TCTemperatureSetup dialog

class TCTemperatureSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCTemperatureSetup)

// Construction
public:
	TCTemperatureSetup();
	~TCTemperatureSetup();

	TCTemperatureSetupData	CTemperatureSetupData;
	double					temperature;

// Dialog Data
	//{{AFX_DATA(TCTemperatureSetup)
	enum { IDD = IDD_PROPPAGE_TEMPERATURE };
	BOOL	m_enable;
	double	m_start;
	double	m_stop;
	double	m_step;
	int		m_type;
	double	m_temperature;
	int		m_sweep_type;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCTemperatureSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCTemperatureSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

// TCDistortionSetup dialog

class TCDistortionSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCDistortionSetup)

// Construction
public:
	TCDistortionSetup();
	~TCDistortionSetup();

	TCDistortionData CDistortionSetupData;
// Dialog Data
	//{{AFX_DATA(TCDistortionSetup)
	enum { IDD = IDD_PROPPAGE_DISTORTION };
	BOOL	m_enable;
	int		m_type;
	double	m_frequency;
	BOOL	m_enable_plot_all;
	BOOL	m_enable_print_all;
	CString CMMultiRunTHDParam;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCDistortionSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCDistortionSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

// TCPoleZeroSetup dialog

class TCPoleZeroSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCPoleZeroSetup)

// Construction
public:
	TCPoleZeroSetup();
	~TCPoleZeroSetup();

	TCPoleZeroData CPoleZeroSetupData;
	TCSpiceNodeList COutputList;
	TCSpiceNodeList CSourceList;
// Dialog Data
	//{{AFX_DATA(TCPoleZeroSetup)
	enum { IDD = IDD_PROPPAGE_POLE_ZERO };
	CComboBox	CMInputPosList;
	CComboBox	CMInputNegList;
	CComboBox	CMOutputPosList;
	CComboBox	CMOutputListNeg;
	BOOL	m_enable;
	int		m_type;
	CString	CMOutputNeg;
	CString	CMOutputPos;
	CString	CMInputNeg;
	CString	CMInputPos;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCPoleZeroSetup)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCPoleZeroSetup)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

#endif // __TCSIMULATIONPROPERTYPAGES_H__
