// TCSimulationSetup.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceOpionsEnums.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSimulationSetup.h"
#include "TEAnalysisExtra.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern int	g_last_active_simulation_setup_page;
/////////////////////////////////////////////////////////////////////////////
// TCSimulationSetup

IMPLEMENT_DYNAMIC(TCSimulationSetup, CPropertySheet)
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;

TCSimulationSetup::TCSimulationSetup(CWnd* pWndParent)
	 : CPropertySheet(IDS_PROPSHT_CAPTION2, pWndParent)
{
	// Add all of the property pages here.  Note that
	// the order that they appear in here will be
	// the order they appear in on screen.  By default,
	// the first page of the set is the active one.
	// One way to make a different property page the 
	// active one is to call SetActivePage().

	AddPage(&m_Page2);//DC 0
	AddPage(&m_Page1);//AC 1
	AddPage(&m_Page3);//Noise 2
	AddPage(&m_Page4);//Trans 3
	AddPage(&m_Page10);//Distortion 4
	AddPage(&m_Page7);//Sensitivity 5
	AddPage(&m_Page11);//Pole-Zero 6
	AddPage(&m_Page9);//temperature 7
	AddPage(&m_Page5);//WC ReRun 8
	AddPage(&m_Page6);//Param 9
	AddPage(&m_Page8);//options 10
	AddPage(&m_Page12);//Output select 11
	AddPage(&m_Page13); // Parameters


	SetActivePage(g_last_active_simulation_setup_page);
}

TCSimulationSetup::~TCSimulationSetup()
{
}


BEGIN_MESSAGE_MAP(TCSimulationSetup, CPropertySheet)
	//{{AFX_MSG_MAP(TCSimulationSetup)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSimulationSetup message handlers



INT_PTR TCSimulationSetup::DoModal() 
{
	m_Page1.CACSetupData = CAnalysisSetup.CACSetupData;

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1 ||
	   CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] == 1)
	{
		m_Page1.m_plot_ac_analysis = true;
	}
	else m_Page1.m_plot_ac_analysis = false;
	
	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE]) m_Page1.m_ac_analysis_type = 0;
	else m_Page1.m_ac_analysis_type = 1;

	m_Page1.CMLoopGainSource = CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE];
	m_Page1.m_zero_phase = CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_ZERO_PHASE];
	m_Page1.CSourceList = CAnalysisSetup.CSourceList;
	m_Page1.CMRefDesSweptDevice = CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE];
	m_Page1.CMRefSweptDeviceFreq = CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE_FREQ];
	m_Page1.m_freq_device_mode = CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_FREQ_DEVICE_MODE];

	m_Page2.CDCSetupData			= CAnalysisSetup.CDCSetupData;
	m_Page2.CSourceList				= CAnalysisSetup.CSourceList;
	m_Page2.CParametricSetupData	= CAnalysisSetup.CParametricSetupData;//re-added 24th March 2017. No idea why this bug came from. Ok in 21st May 2016


	m_Page3.CNoiseSetupData = CAnalysisSetup.CNoiseSetupData;
	m_Page3.CSourceList		= CAnalysisSetup.CSourceList;
	m_Page3.COutputList		= CAnalysisSetup.CStaticOutputList;
	m_Page3.CMNoiseReportFrequencyList = CAnalysisSetup.CReRun.CReserved.CStringArray[E_NOISE_REPORT_FREQUENCY_LIST];
 
	m_Page4.CTransientSetupData = CAnalysisSetup.CTransientSetupData;
	m_Page4.COutputList	= CAnalysisSetup.CStaticOutputList;
	m_Page4.CSourceList = CAnalysisSetup.CNodeList;
	m_Page4.m_trans_frequency_enable =  !!CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE];
	m_Page4.m_trans_xing_last_count =  (int)CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_LAST_COUNT];
	m_Page4.m_trans_xing_first_count =  (int)CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT];
	m_Page4.CMTransFrequencySignalName = CAnalysisSetup.CReRun.CReserved.CStringArray[E_TRAN_ANALYSIS_RESERVED_OUTPUT_NAME];
    m_Page4.m_trans_xing_level = CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_XING_LEVEL];

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_POLARITY] < 0)
		m_Page4.m_trans_xing_sign = 1;
	else m_Page4.m_trans_xing_sign = 0;

	m_Page5.CReRun					= CAnalysisSetup.CReRun;

	m_Page7.CSensitivitySetupData	= CAnalysisSetup.CSensitivitySetupData;
	m_Page7.COutputList				= CAnalysisSetup.CStaticOutputList;
	m_Page7.CStaticOutputList		= CAnalysisSetup.CStaticOutputList;

	m_Page6.CParametricSetupData = CAnalysisSetup.CParametricSetupData;
	m_Page6.CSourceList			 = CAnalysisSetup.CSourceList;
	m_Page6.m_auto_generate_rerun_file = (int) CAnalysisSetup.CReRun.CReserved.CIntArray[E_PARAMETER_AUTO_GENERATE_RNN_FILE];
	m_Page6.m_multi_run_enable = (int) CAnalysisSetup.CReRun.CReserved.CIntArray[E_PARAMETER_MULTIRUN_ENABLE];
	m_Page6.CMMultiRunSignal = CAnalysisSetup.CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_SIGNAL];

	m_Page9.CTemperatureSetupData			= CAnalysisSetup.CTemperatureSetupData;
	m_Page9.temperature = CAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value;

	m_Page8.CBerklySpiceOptionsSetupData = CAnalysisSetup.CBerklySpiceOptionsSetupData;

	m_Page10.CDistortionSetupData = CAnalysisSetup.CDistortionSetupData;

	m_Page11.CPoleZeroSetupData = CAnalysisSetup.CPoleZeroSetupData;
	m_Page11.COutputList	= CAnalysisSetup.CNodeList;
	m_Page11.CSourceList	= CAnalysisSetup.CNodeList;
 
	m_Page12.COutputSelectData		= CAnalysisSetup.COutputSelectData;
	m_Page12.COutputList			= CAnalysisSetup.COutputList;
	m_Page12.CDeviceCurrentNodeList = CAnalysisSetup.CDeviceCurrentNodeList;

	m_Page12.CADConversionVoltage = CAnalysisSetup.CReRun.CReserved.CStringArray[E_ADC_VOLTAGE];
	m_Page12.m_output_resistance = (double) CAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_OUTPUT_RESISTANCE];
	m_Page12.m_input_capacitance = (double) CAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_INPUT_CAPACITANCE];
	m_Page12.m_transition_time = (double) CAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_T_RISE_FALL_DELAY];
	
	m_Page4.m_auto_calc_fft = CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_FFT_ON_LOAD];
	m_Page4.m_calc_selected_signals_fft = CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_SELECTED_FFT_SIGNALS];

	m_Page13.CSpiceParameters = CAnalysisSetup.CSchematicDefsParameters;
	
	m_Page1.CMMultiRunACParam		= CAnalysisSetup.CParametricSetupData.CMultiRunACParam;
	m_Page2.CMMultiRunDCParam		= CAnalysisSetup.CParametricSetupData.CMultiRunDCParam;
	m_Page3.CMMultiRunNoiseParam	= CAnalysisSetup.CParametricSetupData.CMultiRunNoiseParam;
	m_Page4.CMultiRunTranParam		= CAnalysisSetup.CParametricSetupData.CMultiRunTranParam;
	m_Page6.CMMultiRunSignal		= CAnalysisSetup.CParametricSetupData.CMultiRunSignal;
	m_Page6.m_multi_run_enable		= CAnalysisSetup.CParametricSetupData.multi_run_enable;
	m_Page10.CMMultiRunTHDParam		= CAnalysisSetup.CParametricSetupData.CMultiRunTHDParam;

	int value = CPropertySheet::DoModal();

	if(value == IDOK)
	{
		CAnalysisSetup.CACSetupData = m_Page1.CACSetupData;
		CAnalysisSetup.CDCSetupData = m_Page2.CDCSetupData;
		CAnalysisSetup.CNoiseSetupData = m_Page3.CNoiseSetupData;
		CAnalysisSetup.CTransientSetupData = m_Page4.CTransientSetupData;
		CAnalysisSetup.CSensitivitySetupData = m_Page7.CSensitivitySetupData;
		CAnalysisSetup.CParametricSetupData = m_Page6.CParametricSetupData;
		CAnalysisSetup.CTemperatureSetupData = m_Page9.CTemperatureSetupData;
		CAnalysisSetup.CBerklySpiceOptionsSetupData = m_Page8.CBerklySpiceOptionsSetupData;
		CAnalysisSetup.CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value = m_Page9.temperature;
		CAnalysisSetup.CDistortionSetupData = m_Page10.CDistortionSetupData;
		CAnalysisSetup.CPoleZeroSetupData = m_Page11.CPoleZeroSetupData;
		CAnalysisSetup.COutputSelectData = m_Page12.COutputSelectData;
		CAnalysisSetup.CReRun			= m_Page5.CReRun;

		CAnalysisSetup.CReRun.CReserved.CStringArray[E_ADC_VOLTAGE]			= m_Page12.CADConversionVoltage;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_OUTPUT_RESISTANCE]	= (float) m_Page12.m_output_resistance;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_INPUT_CAPACITANCE]	= (float) m_Page12.m_input_capacitance;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_ADC_T_RISE_FALL_DELAY]	= (float) m_Page12.m_transition_time;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_FFT_ON_LOAD]	= m_Page4.m_auto_calc_fft;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_CALCULATE_SELECTED_FFT_SIGNALS]	= m_Page4.m_calc_selected_signals_fft;

		CAnalysisSetup.CReRun.CReserved.CIntArray[E_PARAMETER_MULTIRUN_ENABLE]		= m_Page6.m_multi_run_enable;
	    CAnalysisSetup.CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_SIGNAL]	= m_Page6.CMMultiRunSignal;

		CAnalysisSetup.CParametricSetupData.CMultiRunACParam	= m_Page1.CMMultiRunACParam;
		CAnalysisSetup.CParametricSetupData.CMultiRunDCParam	= m_Page2.CMMultiRunDCParam;
		CAnalysisSetup.CParametricSetupData.CMultiRunNoiseParam	= m_Page3.CMMultiRunNoiseParam;
		CAnalysisSetup.CParametricSetupData.CMultiRunTranParam	= m_Page4.CMultiRunTranParam;
		CAnalysisSetup.CParametricSetupData.CMultiRunSignal		= m_Page6.CMMultiRunSignal;
		CAnalysisSetup.CParametricSetupData.multi_run_enable	= m_Page6.m_multi_run_enable;
		CAnalysisSetup.CParametricSetupData.CMultiRunTHDParam	= m_Page10.CMMultiRunTHDParam;
		
		if(m_Page1.m_plot_ac_analysis)
		{
			if(!m_Page1.m_ac_analysis_type) 
			{
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = true;
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] = false;
			}
			else
			{
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = false;
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] = true;
			}
		}
		else 
		{
			if(m_Page1.m_ac_analysis_type)//impedance 
			{
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = false;
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] = 2;
			}
			else
			{
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 2;
				CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] = false;
			}
		}
		
		CAnalysisSetup.CReRun.CReserved.CStringArray[E_NOISE_REPORT_FREQUENCY_LIST] = m_Page3.CMNoiseReportFrequencyList;

		CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = m_Page1.CMLoopGainSource;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_ZERO_PHASE] = (float)m_Page1.m_zero_phase;

		CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE] = m_Page1.CMRefDesSweptDevice;
		CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE_FREQ] = m_Page1.CMRefSweptDeviceFreq;		
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_FREQ_DEVICE_MODE] = m_Page1.m_freq_device_mode;


		CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE] = !!m_Page4.m_trans_frequency_enable;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_LAST_COUNT] = (float)m_Page4.m_trans_xing_last_count;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT] = (float)m_Page4.m_trans_xing_first_count;
		CAnalysisSetup.CReRun.CReserved.CStringArray[E_TRAN_ANALYSIS_RESERVED_OUTPUT_NAME] = m_Page4.CMTransFrequencySignalName;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_XING_LEVEL] = (float) m_Page4.m_trans_xing_level;

		if(m_Page4.m_trans_xing_sign) CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_POLARITY] = -1;
		else CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_POLARITY] = 1;

		if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_LAST_COUNT] <= CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT])
			CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_LAST_COUNT] = CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT] + 1;

		if(m_Page6.m_auto_generate_rerun_file) CAnalysisSetup.CReRun.CReserved.CIntArray[E_PARAMETER_AUTO_GENERATE_RNN_FILE] = 1;
		else CAnalysisSetup.CReRun.CReserved.CIntArray[E_PARAMETER_AUTO_GENERATE_RNN_FILE] = 0;

		if(CAnalysisSetup.CReRun.enable) CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;

		// Force valid run modes
		if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
		if(CAnalysisSetup.CParametricSetupData.GetNumberOfParamsSwept() > 1)
		{
			CAnalysisSetup.CReRun.xspice_run_mode = 1;// Multi xspice runs can only vary one parameter, needs run once

			CAnalysisSetup.CParametricSetupData.DisableSchParamsSweep();
		}

		if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
		{
			if(CAnalysisSetup.CParametricSetupData.IsSwept(GCSuperSpiceGlobalData.CSchParamsName))
			{
				CAnalysisSetup.CReRun.xspice_run_mode = 0; // If SchParam sweeps must be run multi times mode
			}
			else
			{
				if(!CAnalysisSetup.CParametricSetupData.IsValidSingleRun())// Only RLC and V/I can use run_mode = 0
						CAnalysisSetup.CReRun.xspice_run_mode = 1;  // V and I sources must use single run mode	
			}
		}

		if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
		{
			CAnalysisSetup.CReRun.xspice_run_mode = 1; // MC requires one run mode
		}

		CAnalysisSetup.CParametricSetupData.GetSweptParamName();

		CAnalysisSetup.CSchematicDefsParameters = m_Page13.CSpiceParameters;
	}

	return value;
}
