// TCSpiceComponentDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include"TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicObjectData.h"
#include "TCSpiceComponentDlg.h"
#include "TCMasterModelDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCMOSFETLabelsDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSpiceComponentPinsDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSpiceComponentModelDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCBipolarLabelsDlg, CPropertyPage)


extern class TCSuperSpiceDataBase GCSuperSpiceDataBase;

extern int	g_last_active_component_property_page;
extern int	g_last_active_generator_property_page;
/////////////////////////////////////////////////////////////////////////////
// TCMOSFETLabelsDlg property page

TCMOSFETLabelsDlg::TCMOSFETLabelsDlg() : CPropertyPage(TCMOSFETLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCMOSFETLabelsDlg)
	m_check_visable_ref_designator = FALSE;
	m_check_visable_spice_name = FALSE;
	m_check_visable_type_name = FALSE;
	m_check_visable_value = FALSE;
	m_parameters_visable = FALSE;
	CMRefDesignator = _T("");
	CMEditSpiceName = _T("");
	CMEditTypeName = _T("");
	CMEditValue = _T("");
	CEditValueParameters = _T("");
	m_value_1_visable = FALSE;
	m_value_2_visable = FALSE;
	m_value_3_visable = FALSE;
	CEditValueHeader1 = _T("");
	CEditValueHeader2 = _T("");
	CEditValueHeader3 = _T("");
	CMEditValue1 = _T("");
	CMEditValue2 = _T("");
	CMEditValue3 = _T("");
	m_enable_as = FALSE;
	m_enable_ad = FALSE;
	m_use_default_l_w = FALSE;
	m_value_designer_type = 0;
	m_calculation_type = 1;
	//}}AFX_DATA_INIT
}

TCMOSFETLabelsDlg::~TCMOSFETLabelsDlg()
{
}

void TCMOSFETLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCMOSFETLabelsDlg)
	DDX_Control(pDX, IDC_RADIO_CALC_TYPE, CMLengthRadio);
	DDX_Control(pDX, IDC_RADIO_CALC_TYPE2, CMWidthRadio);
	DDX_Control(pDX, IDC_EDIT_CURRENT2, CMCurrentCtrl);
	DDX_Control(pDX, IDC_EDIT_VALUE_3, CMEditCntrlValue3);
	DDX_Control(pDX, IDC_EDIT_VALUE_1, CMEditCntrlValue1);
	DDX_Control(pDX, IDC_CHECK_VISABLE_USE_DEFAULT_WL, CMCtrlUseModelLW);
	DDX_Control(pDX, IDC_CHECK_VISABLE_ENABLE_AS, CMEnableAS);
	DDX_Control(pDX, IDC_CHECK_VISABLE_ENABLE_AD, CMEnableAD);
	DDX_Control(pDX, IDC_EDIT_VALUE_2, CMEditCntrlValue2);
	DDX_Control(pDX, IDC_EDIT_VALUE, CEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CEditCntlRefDesignator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_check_visable_ref_designator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_check_visable_spice_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_check_visable_type_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_check_visable_value);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_5, m_parameters_visable);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMRefDesignator);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpiceName);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Text(pDX, IDC_EDIT_VALUE_5, CEditValueParameters);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_1, m_value_1_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_2, m_value_2_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_3, m_value_3_visable);
	DDX_Text(pDX, IDC_STATIC_VALUE_1, CEditValueHeader1);
	DDX_Text(pDX, IDC_STATIC_VALUE_2, CEditValueHeader2);
	DDX_Text(pDX, IDC_STATIC_VALUE_3, CEditValueHeader3);
	DDX_Text(pDX, IDC_EDIT_VALUE_1, CMEditValue1);
	DDX_Text(pDX, IDC_EDIT_VALUE_2, CMEditValue2);
	DDX_Text(pDX, IDC_EDIT_VALUE_3, CMEditValue3);
	DDX_Check(pDX, IDC_CHECK_VISABLE_ENABLE_AS, m_enable_as);
	DDX_Check(pDX, IDC_CHECK_VISABLE_ENABLE_AD, m_enable_ad);
	DDX_Check(pDX, IDC_CHECK_VISABLE_USE_DEFAULT_WL, m_use_default_l_w);
	DDX_MKSValue(pDX, IDC_EDIT_CURRENT2, m_drain_current);
	DDX_Radio(pDX, IDC_RADIO_VALUE_DESIGNER, m_value_designer_type);
	DDX_Radio(pDX, IDC_RADIO_CALC_TYPE, m_calculation_type);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_EDIT_VALUE_5, CEditParameters);
}


BEGIN_MESSAGE_MAP(TCMOSFETLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCMOSFETLabelsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_NAME, OnKillfocusEditSpiceName)
	ON_BN_CLICKED(IDC_CHECK_VISABLE_USE_DEFAULT_WL, OnCheckVisableUseDefaultWl)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER, OnRadioValueDesigner)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER2, OnRadioValueDesigner2)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER3, OnRadioValueDesigner3)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER4, OnRadioValueDesigner4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSpiceComponentPinsDlg property page

TCSpiceComponentPinsDlg::TCSpiceComponentPinsDlg() : CPropertyPage(TCSpiceComponentPinsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSpiceComponentPinsDlg)
	m_check_visable_pin_name0 = FALSE;
	m_check_visable_pin_name1 = FALSE;
	m_check_visable_pin_name2 = FALSE;
	m_check_visable_pin_name3 = FALSE;
	m_check_visable_pin_num0 = FALSE;
	m_check_visable_pin_num1 = FALSE;
	m_check_visable_pin_num2 = FALSE;
	m_check_visable_pin_num3 = FALSE;
	CMEditPinName0 = _T("");
	CMEditPinName1 = _T("");
	CMEditPinName2 = _T("");
	CMEditPinNum0 = _T("");
	CMEditPinNum1 = _T("");
	CMEditPinNum2 = _T("");
	CMEditPinNum3 = _T("");
	CMEditPinName3 = _T("");
	//}}AFX_DATA_INIT
}

TCSpiceComponentPinsDlg::~TCSpiceComponentPinsDlg()
{
}

void TCSpiceComponentPinsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSpiceComponentPinsDlg)
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_3, CCheckPinNumber3);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_2, CCheckPinNumber2);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_1, CCheckPinNumber1);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_0, CCheckPinNumber0);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_3, CCheckPinName3);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_2, CCheckPinName2);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_1, CCheckPinName1);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_0, CCheckPinName0);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_3, CEditCntlPinNumber3);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_2, CEditCntlPinNumber2);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_1, CEditCntlPinNumber1);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_0, CEditCntlPinNumber0);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_3, CEditCntlPinName3);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_2, CEditCntlPinName2);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_1, CEditCntlPinName1);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_0, CEditCntlPinName0);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_0, m_check_visable_pin_name0);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_1, m_check_visable_pin_name1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_2, m_check_visable_pin_name2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_3, m_check_visable_pin_name3);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_0, m_check_visable_pin_num0);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_1, m_check_visable_pin_num1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_2, m_check_visable_pin_num2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_3, m_check_visable_pin_num3);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_0, CMEditPinName0);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_1, CMEditPinName1);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_2, CMEditPinName2);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_0, CMEditPinNum0);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_1, CMEditPinNum1);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_2, CMEditPinNum2);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_3, CMEditPinNum3);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_3, CMEditPinName3);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSpiceComponentPinsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSpiceComponentPinsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSpiceComponentModelDlg property page

TCSpiceComponentModelDlg::TCSpiceComponentModelDlg() : CPropertyPage(TCSpiceComponentModelDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSpiceComponentModelDlg)
	CEditSpiceParameter = _T("");
	CEditSpiceParameterValue = _T("");
	CEditRecordName = _T("");
	CEditRecordVersion = _T("");
	m_matched = 1;
	m_strength = 1;
	CEditRecordVersion2 = _T("");
	//}}AFX_DATA_INIT
}

TCSpiceComponentModelDlg::~TCSpiceComponentModelDlg()
{
}

void TCSpiceComponentModelDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSpiceComponentModelDlg)
	DDX_Control(pDX, IDC_EDIT_RECORD_NAME, CEditCntlRecordName);
	DDX_Control(pDX, IDC_LIST_SPICE_PARAMETERS, CMListSpiceModelParameter);
	DDX_Text(pDX, IDC_EDIT_SPICE_PARAMETER, CEditSpiceParameter);
	DDX_Text(pDX, IDC_EDIT_SPICE_PARAMETERVALUE, CEditSpiceParameterValue);
	DDX_Text(pDX, IDC_EDIT_RECORD_NAME, CEditRecordName);
	DDX_Text(pDX, IDC_EDIT_RECORD_VERSION, CEditRecordVersion);
//	DDX_Radio(pDX, IDC_RADIO_MATCHED, m_matched);
//	DDX_Radio(pDX, IDC_RADIO_WEAK, m_strength);
	DDX_Text(pDX, IDC_EDIT_RECORD_VERSION2, CEditRecordVersion2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSpiceComponentModelDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSpiceComponentModelDlg)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_MODEL, OnButtonSelectModel)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SPICE_PARAMETERS, OnClickListSpiceParameters)
	ON_BN_CLICKED(IDC_BUTTON_INSERT, OnButtonInsert)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_BN_CLICKED(IDC_RADIO_MATCHED, OnRadioMatched)
	ON_BN_CLICKED(IDC_RADIO_NOMINAL, OnRadioNominal)
	ON_BN_CLICKED(IDC_RADIO_STRONG, OnRadioStrong)
	ON_BN_CLICKED(IDC_RADIO_UNMATCHED, OnRadioUnmatched)
	ON_BN_CLICKED(IDC_RADIO_WEAK, OnRadioWeak)
	ON_BN_CLICKED(IDC_RADIO_XCOUPLED, OnRadioXcoupled)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_PARAMETERVALUE, OnKillfocusEditSpiceParameterValue)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_PARAMETER, OnKillfocusEditSpiceParameterName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCSpiceComponentModelDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{		 
		GetDisplay();
	}

	PCSchematicObjectData->FormatLabel();

	return value;
}

BOOL TCSpiceComponentModelDlg::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	CString CText;

	int length = (int)(CMListSpiceModelParameter.GetStringWidth("Model Parameter") * 1.5);

	CText ="Model Parameter";
	CMListSpiceModelParameter.InsertColumn(0, CText, LVCFMT_LEFT,length,0);

	CText ="Model Value    ";
	CMListSpiceModelParameter.InsertColumn(1, CText, LVCFMT_LEFT, length,1);

	InsertItems();
	SetDisplay();

//	CEditCntlRecordName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);

	CEditCntlRecordName.SetWindowText(CEditRecordName);
	return TRUE;
}

void TCSpiceComponentModelDlg::SetDisplay(void)
{
	int count = PCSchematicObjectData->CSpiceParameters.CData.GetSize();
	
	CString CText;

	for(int p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = PCSchematicObjectData->CSpiceParameters.CData[p];

		CMListSpiceModelParameter.SetItemText(p, 0, CNameValueData.CName);

		if(!CNameValueData.is_text_data) CText = FloatToMKSString(CNameValueData.value);
		else CText = CNameValueData.CValue;

		CMListSpiceModelParameter.SetItemText(p, 1, CText);
	}

	if(count)
	{
		if(PCSchematicObjectData->CSpiceParameters.last_selected >= count)
			PCSchematicObjectData->CSpiceParameters.last_selected = 0;

		TCNameValueData &CNameValueData = 
		PCSchematicObjectData->CSpiceParameters.CData[PCSchematicObjectData->CSpiceParameters.last_selected];

		CEditSpiceParameter	= CNameValueData.CName;
		
		if(!CNameValueData.is_text_data) CEditSpiceParameterValue = FloatToMKSString(CNameValueData.value);
		else CEditSpiceParameterValue = CNameValueData.CValue;
	}

	CMListSpiceModelParameter.SetItemState(PCSchematicObjectData->CSpiceParameters.last_selected, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );

	m_matched			= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched;
	m_strength			= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength;
//	CEditRecordName		= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName;
	CEditRecordName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	CEditRecordVersion	= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CEditRecordVersion2	= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;

	UpdateData(false);
}

void TCSpiceComponentModelDlg::GetDisplay(void)
{
	UpdateData(true);

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched			= m_matched;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength			= m_strength;
//	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName		= CEditRecordName;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CEditRecordName;

	PCSchematicObjectData->FormatRecordName();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CEditRecordVersion;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CEditRecordVersion2;

	int id = PCSchematicObjectData->CSpiceParameters.last_selected;

	if(id >=PCSchematicObjectData->CSpiceParameters.CData.GetSize())
	{
		return;
	}

	TCNameValueData CNameValueData;

	CNameValueData.CName		= CEditSpiceParameter;

	int test_test;

	test_test = 0;

	if(CEditSpiceParameterValue.Find('[') > -1)  test_test = 1;
	if(CEditSpiceParameterValue.Find('"') > -1)  test_test = 1;
	if(CEditSpiceParameterValue.Find('\'') > -1) test_test = 1;
	if(CEditSpiceParameterValue.Find('{') > -1)  test_test = 1;

	if(test_test) 
//	if(CEditSpiceParameterValue.Find('[') > -1 || CEditSpiceParameterValue.Find('"') > -1 || CEditSpiceParameterValue.Find('\'') > -1) 
	{
		PCSchematicObjectData->CSpiceParameters.CData[id].is_text_data = true;
	}
	else
	{
		PCSchematicObjectData->CSpiceParameters.CData[id].is_text_data = false;
	}

	CNameValueData.is_text_data = PCSchematicObjectData->CSpiceParameters.CData[id].is_text_data;

	if(!CNameValueData.is_text_data) CNameValueData.value = MKSStringToFloat(CEditSpiceParameterValue);
	else CNameValueData.CValue = CEditSpiceParameterValue;

	PCSchematicObjectData->CSpiceParameters.CData[id] = CNameValueData;
}

void TCSpiceComponentModelDlg::OnClickListSpiceParameters(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR;
	*pResult = 0;

	GetDisplay();

	int item = CMListSpiceModelParameter.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item < 0) return;

	CMListSpiceModelParameter.SetItemState(item, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );

	PCSchematicObjectData->CSpiceParameters.last_selected = item;

	SetDisplay();
}

void TCSpiceComponentModelDlg::OnKillfocusEditSpiceParameterValue() 
{
	UpdateData(true);

	int item = PCSchematicObjectData->CSpiceParameters.last_selected;

	if(item < 0) return;

	int count = PCSchematicObjectData->CSpiceParameters.CData.GetSize();

	if(!(item < count)) return;

	TCNameValueData &CNameValueData = PCSchematicObjectData->CSpiceParameters.CData[item];

	if(!CNameValueData.is_text_data) CNameValueData.value = MKSStringToFloat(CEditSpiceParameterValue);
	else CNameValueData.CValue = CEditSpiceParameterValue;

	CMListSpiceModelParameter.SetItemText(item, 1, CEditSpiceParameterValue);
}

void TCSpiceComponentModelDlg::OnKillfocusEditSpiceParameterName() 
{
	UpdateData(true);

	int item = PCSchematicObjectData->CSpiceParameters.last_selected;

	if(item < 0) return;

	int count = PCSchematicObjectData->CSpiceParameters.CData.GetSize();

	if(!(item < count)) return;

	TCNameValueData &CNameValueData = PCSchematicObjectData->CSpiceParameters.CData[item];

	CNameValueData.CName = CEditSpiceParameter;

	CMListSpiceModelParameter.SetItemText(item, 0, CEditSpiceParameter);

	UpdateData(false);
}

void TCSpiceComponentModelDlg::InsertItems(void)
{
	CMListSpiceModelParameter.DeleteAllItems();

	int count = PCSchematicObjectData->CSpiceParameters.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = PCSchematicObjectData->CSpiceParameters.CData[p];
		
		CMListSpiceModelParameter.InsertItem(p, CNameValueData.CName);
	}
}

void TCSpiceComponentModelDlg::OnButtonInsert() 
{
	int id = PCSchematicObjectData->CSpiceParameters.last_selected;

	TCNameValueData CNameValueData;

	if(id) id++;

	int randx;

	randx = (rand() * 100)/RAND_MAX;// value from 0 to 100

	CNameValueData.CName.Format("ParamX%d", randx);

	CNameValueData.value = 1;

	PCSchematicObjectData->CSpiceParameters.last_selected = id;

	PCSchematicObjectData->CSpiceParameters.CData.InsertAt(id, CNameValueData);

	InsertItems();

	SetDisplay();
}

void TCSpiceComponentModelDlg::OnButtonDelete() 
{
	int size = PCSchematicObjectData->CSpiceParameters.CData.GetSize();

	if(!size) return;

	int id = PCSchematicObjectData->CSpiceParameters.last_selected;

	if(id >= size) return;

	PCSchematicObjectData->CSpiceParameters.CData.RemoveAt(id);

	InsertItems();
	SetDisplay();
}

BOOL TCSpiceComponentPinsDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
	int count = PCSchematicObjectData->CPinListData.GetSize();

	int q, count2;

	for(int p = 0; p < count; p++)
	{
		if(p == 0)
		{
			count2 = PCSchematicObjectData->CPinListData[0].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[0].CLabelListData[0].is_visable = !!m_check_visable_pin_name0;
					PCSchematicObjectData->CPinListData[0].CLabelListData[0].CLabel = CMEditPinName0;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[0].CLabelListData[1].is_visable = !!m_check_visable_pin_num0;
					PCSchematicObjectData->CPinListData[0].CLabelListData[1].CLabel = CMEditPinNum0;
				}
			}
		}
		if(p == 1)
		{
			count2 = PCSchematicObjectData->CPinListData[1].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[1].CLabelListData[0].is_visable = !!m_check_visable_pin_name1;
					PCSchematicObjectData->CPinListData[1].CLabelListData[0].CLabel = CMEditPinName1;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[1].CLabelListData[1].is_visable = !!m_check_visable_pin_num1;
					PCSchematicObjectData->CPinListData[1].CLabelListData[1].CLabel = CMEditPinNum1;
				}
			}
		}
		if(p == 2)
		{
			count2 = PCSchematicObjectData->CPinListData[2].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[2].CLabelListData[0].is_visable = !!m_check_visable_pin_name2;
					PCSchematicObjectData->CPinListData[2].CLabelListData[0].CLabel = CMEditPinName2;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[2].CLabelListData[1].is_visable = !!m_check_visable_pin_num2;
					PCSchematicObjectData->CPinListData[2].CLabelListData[1].CLabel = CMEditPinNum2;
				}
			}
		}
		if(p == 3)
		{
			count2 = PCSchematicObjectData->CPinListData[3].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[3].CLabelListData[0].is_visable = !!m_check_visable_pin_name3;
					PCSchematicObjectData->CPinListData[3].CLabelListData[0].CLabel = CMEditPinName3;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[3].CLabelListData[1].is_visable = !!m_check_visable_pin_num3;
					PCSchematicObjectData->CPinListData[3].CLabelListData[1].CLabel = CMEditPinNum3;
				}
			}
		}
	}
	}

	
	return value;
}

BOOL TCSpiceComponentPinsDlg::OnInitDialog() 
{

	int count = PCSchematicObjectData->CPinListData.GetSize();

	int q, count2;

	for(int p = 0; p < count; p++)
	{
		if(p == 0)
		{
			count2 = PCSchematicObjectData->CPinListData[0].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name0 = PCSchematicObjectData->CPinListData[0].CLabelListData[0].is_visable;
					CMEditPinName0 =  PCSchematicObjectData->CPinListData[0].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num0 = PCSchematicObjectData->CPinListData[0].CLabelListData[1].is_visable;
					CMEditPinNum0 =  PCSchematicObjectData->CPinListData[0].CLabelListData[1].CLabel;
				}
			}
		}
		if(p == 1)
		{
			count2 = PCSchematicObjectData->CPinListData[1].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name1 = PCSchematicObjectData->CPinListData[1].CLabelListData[0].is_visable;
					CMEditPinName1 =  PCSchematicObjectData->CPinListData[1].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num1 = PCSchematicObjectData->CPinListData[1].CLabelListData[1].is_visable;
					CMEditPinNum1 =  PCSchematicObjectData->CPinListData[1].CLabelListData[1].CLabel;
				}
			}
		}
		if(p == 2)
		{
			count2 = PCSchematicObjectData->CPinListData[2].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name2 = PCSchematicObjectData->CPinListData[2].CLabelListData[0].is_visable;
					CMEditPinName2 =  PCSchematicObjectData->CPinListData[2].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num2 = PCSchematicObjectData->CPinListData[2].CLabelListData[1].is_visable;
					CMEditPinNum2 =  PCSchematicObjectData->CPinListData[2].CLabelListData[1].CLabel;
				}
			}
		}
		if(p == 3)
		{
			count2 = PCSchematicObjectData->CPinListData[3].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name3 = PCSchematicObjectData->CPinListData[3].CLabelListData[0].is_visable;
					CMEditPinName3 =  PCSchematicObjectData->CPinListData[3].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num3 = PCSchematicObjectData->CPinListData[3].CLabelListData[1].is_visable;
					CMEditPinNum3 =  PCSchematicObjectData->CPinListData[3].CLabelListData[1].CLabel;
				}
			}
		}
	}
	CPropertyPage::OnInitDialog();
	
	count = PCSchematicObjectData->CPinListData.GetSize();

	switch(count)
	{
		case 1:	CEditCntlPinName1.SetReadOnly();
				CEditCntlPinNumber1.SetReadOnly(); 
				CEditCntlPinName2.SetReadOnly();
				CEditCntlPinNumber2.SetReadOnly();
				CEditCntlPinName3.SetReadOnly();
				CEditCntlPinNumber3.SetReadOnly();
				CCheckPinName3.EnableWindow(false);
				CCheckPinName2.EnableWindow(false);
				CCheckPinName1.EnableWindow(false);
				CCheckPinNumber3.EnableWindow(false);
				CCheckPinNumber2.EnableWindow(false);
				CCheckPinNumber1.EnableWindow(false);
				break;

		case 2:	CEditCntlPinName2.SetReadOnly();
				CEditCntlPinNumber2.SetReadOnly(); 
				CEditCntlPinName3.SetReadOnly();
				CEditCntlPinNumber3.SetReadOnly();
				CCheckPinName3.EnableWindow(false);
				CCheckPinName2.EnableWindow(false);
				CCheckPinNumber3.EnableWindow(false);
				CCheckPinNumber2.EnableWindow(false);
				break;

		case 3:	CEditCntlPinName3.SetReadOnly();
				CEditCntlPinNumber3.SetReadOnly();
				CCheckPinNumber3.EnableWindow(false);
				CCheckPinName3.EnableWindow(false);
				break;
	
	}
	
	return TRUE;  
}

BOOL TCMOSFETLabelsDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	double data;

	if(value)
	{
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_check_visable_type_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMEditTypeName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_check_visable_spice_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_check_visable_value;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_check_visable_ref_designator;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMRefDesignator;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_WIDTH].is_visable = !!m_value_1_visable;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_LENGTH].is_visable = !!m_value_2_visable;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].is_visable = !!m_value_3_visable;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].is_visable = !!m_parameters_visable;
		
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_ENABLE_AD].is_visable = !!m_enable_ad;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_ENABLE_AS].is_visable = !!m_enable_as;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_USE_DEFAULT_WL].is_visable = !!m_use_default_l_w;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = CMEditValue1;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = CMEditValue2;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].CLabelValue = CMEditValue3;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelValue =	CEditValueParameters;

		data = SpiceMKSStringToFloat(CMEditValue2);

		if(m_calculation_type) PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_CALC_MODE] = E_COMPONENT_FET_WIDTH;
		else PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_CALC_MODE] = E_COMPONENT_FET_LENGTH;
			
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE] = (float) m_value_designer_type;
		PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE] = (float) m_drain_current;

	}
 
	PCSchematicObjectData->FormatLabel();

	return value;
}

BOOL TCMOSFETLabelsDlg::OnInitDialog() 
{
	m_check_visable_type_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_check_visable_spice_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpiceName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	

	m_check_visable_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue =  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;
	
	m_check_visable_ref_designator = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMRefDesignator =  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
	
	m_drain_current = PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE];
	m_value_designer_type = (int) PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];

	if(PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_CALC_MODE] == E_COMPONENT_FET_WIDTH) m_calculation_type = 1;
	else m_calculation_type = 0;
			
	CEditValueHeader3	= "Parameters:";
	CEditValueHeader3	= "Multiplier:";
	CEditValueHeader1	= "Width:";
	CEditValueHeader2	= "Length:";

	m_value_1_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_WIDTH].is_visable;
	m_value_2_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_LENGTH].is_visable;
	m_value_3_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].is_visable;

	int size_check = PCSchematicObjectData->CLabelListData.GetSize();

	if(!(E_COMPONENT_FET_PARAMETERS < size_check)) PCSchematicObjectData->CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);

	m_parameters_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].is_visable;
		
	m_enable_ad = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_ENABLE_AD].is_visable;
	m_enable_as = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_ENABLE_AS].is_visable;

	m_use_default_l_w = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_USE_DEFAULT_WL].is_visable;

	CMEditValue1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue;
	CMEditValue2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue;
	CMEditValue3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].CLabelValue;
	CEditValueParameters = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelValue;
		
	CMEditValue1.TrimLeft();
	CMEditValue1.TrimRight();
	CMEditValue2.TrimLeft();
	CMEditValue2.TrimRight();
	CEditValueParameters.TrimLeft();
	CEditValueParameters.TrimRight();

	TCSpiceParameters &CSpiceParameters = PCSchematicObjectData->CSpiceParameters;

	double data = 0; // set defaults for pspice where l and w are in model description

	if(CMEditValue1 == "" || CMEditValue1 == "0" || m_use_default_l_w)
	{
		if(CSpiceParameters.Get("W", &data)) CMEditValue1 = FloatToSpiceMKSString(data);
	}

	if(CMEditValue2 == "" || CMEditValue2 == "0" || m_use_default_l_w)
	{
		if(CSpiceParameters.Get("L", &data)) CMEditValue2 = FloatToSpiceMKSString(data);
	}

	double level = 2;

	PCSchematicObjectData->CSpiceParameters.Get("Level", &level);

	if(level == 8) 
	{
		m_calculation_type = 1;//force Width to be selected
	}

	CPropertyPage::OnInitDialog();
	
	CEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	if(m_value_designer_type == 3) CMCurrentCtrl.EnableWindow(true);
	else CMCurrentCtrl.EnableWindow(false);

	CMEditCntrlValue2.SetReadOnly(false);

	if(m_use_default_l_w)
	{
		CMEditCntrlValue1.SetReadOnly(true);
		CMEditCntrlValue2.SetReadOnly(true);
		CMEditCntrlValue3.SetReadOnly(true);
	}


	if(m_use_default_l_w)
	{
		CMEnableAD.EnableWindow(false);
		CMEnableAS.EnableWindow(false);
	}
	else
	{
		CMEnableAD.EnableWindow(true);
		CMEnableAS.EnableWindow(true);
	}

	CMCtrlUseModelLW.EnableWindow(true);


	if(level == 8) 
	{
		CMWidthRadio.EnableWindow(false);
		CMLengthRadio.EnableWindow(false);
	}
	else
	{
		CMWidthRadio.EnableWindow(true);
		CMLengthRadio.EnableWindow(true);
	}

	return TRUE; 
}


void TCMOSFETLabelsDlg::OnRadioValueDesigner() 
{
	CMCurrentCtrl.EnableWindow(false);
}

void TCMOSFETLabelsDlg::OnRadioValueDesigner2() 
{
	CMCurrentCtrl.EnableWindow(false);
}

void TCMOSFETLabelsDlg::OnRadioValueDesigner3() 
{
	CMCurrentCtrl.EnableWindow(false);
}

void TCMOSFETLabelsDlg::OnRadioValueDesigner4() 
{
	CMCurrentCtrl.EnableWindow(true);
}

void TCMOSFETLabelsDlg::OnCheckVisableUseDefaultWl() 
{
	UpdateData(true);

	if(m_use_default_l_w)
	{
		CMEditCntrlValue1.SetReadOnly(true);
		CMEditCntrlValue2.SetReadOnly(true);
		CMEditCntrlValue3.SetReadOnly(true);
		CMEnableAD.EnableWindow(false);
		CMEnableAS.EnableWindow(false);
	}
	else
	{
		CMEditCntrlValue1.SetReadOnly(false);
		CMEditCntrlValue2.SetReadOnly(false);
		CMEditCntrlValue3.SetReadOnly(false);
		CMEnableAD.EnableWindow(true);
		CMEnableAS.EnableWindow(true);
	}
}

void TCSpiceComponentModelDlg::OnButtonSelectModel() 
{
	if(!PCSchematicObjectData) return;

	TCMasterModelDlg CMasterModelDlg;

	CMasterModelDlg.attached_model_type = PCSchematicObjectData->attached_model_type;

	TCSchematicObjectData CSchematicObjectData;

	TCComponentDataBaseData CComponentDataBaseData;

	CSchematicObjectData = *PCSchematicObjectData;

	GCSuperSpiceDataBase.SetDefaultModelDisplayed(*PCSchematicObjectData);

	if(CMasterModelDlg.DoModal() != IDOK) return;

	CComponentDataBaseData = CMasterModelDlg.CComponentDataBaseData;

	if(!GCSuperSpiceDataBase.CheckAndCorrectModelData(&CComponentDataBaseData, PCSchematicObjectData->attached_model_type)) 
	{
		AfxMessageBox(IDS_MODEL_SYM_MUST_MATCH);

		return;
	}

	if(!GCSuperSpiceDataBase.GetModel(CComponentDataBaseData, CSchematicObjectData)) return;

	*PCSchematicObjectData = CSchematicObjectData;

	InsertItems();
	SetDisplay();
}


BOOL TCSpiceComponentModelDlg::OnSetActive() 
{
	g_last_active_component_property_page = 2;
	
	PCSchematicObjectData->FormatRecordName();

//	CEditRecordName	= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName;

	CEditRecordName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

//	CEditCntlRecordName.SetWindowText(CEditRecordName);

	SetDisplay();

	return CPropertyPage::OnSetActive();
}

BOOL TCSpiceComponentPinsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCMOSFETLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	g_last_active_generator_property_page = 0;

	PCSchematicObjectData->FormatSpiceName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CEditCntlValue.SetWindowText(CMEditValue);
	CEditCntlSpiceName.SetWindowText(CMEditSpiceName);

	double level = 2;

	PCSchematicObjectData->CSpiceParameters.Get("Level", &level);

	if(level == 8) 
	{
		m_calculation_type = 1;

		CMWidthRadio.EnableWindow(false);
		CMLengthRadio.EnableWindow(false);
	}
	else
	{
		CMWidthRadio.EnableWindow(true);
		CMLengthRadio.EnableWindow(true);
	}

	return CPropertyPage::OnSetActive();
}

void TCMOSFETLabelsDlg::OnKillfocusEditSpiceName() 
{
	UpdateData(true);
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

	PCSchematicObjectData->FormatRecordName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CEditCntlValue.SetWindowText(CMEditValue);
}

void TCSpiceComponentModelDlg::OnRadioMatched() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched	= 0;
	
	PCSchematicObjectData->FormatRecordName();
	
	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSpiceComponentModelDlg::OnRadioNominal() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 1;

	PCSchematicObjectData->FormatRecordName();
	
	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);
/*
	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.CModelDataBase.GetPointer(PCSchematicObjectData->CSpiceParameters, true);

	if(!PCSpiceParameters) return;

	PCSchematicObjectData->CSpiceParameters = *PCSpiceParameters;
*/
	SetDisplay();
}

void TCSpiceComponentModelDlg::OnRadioStrong() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 2;

	PCSchematicObjectData->FormatRecordName();
	
//	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.CModelDataBase.GetPointer(PCSchematicObjectData->CSpiceParameters, true);

	if(!PCSpiceParameters) return;

	PCSchematicObjectData->CSpiceParameters = *PCSpiceParameters;

	SetDisplay();
}

void TCSpiceComponentModelDlg::OnRadioUnmatched() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched	= 2;	

	PCSchematicObjectData->FormatRecordName();
	
	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSpiceComponentModelDlg::OnRadioWeak() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 0;

	PCSchematicObjectData->FormatRecordName();

//	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.CModelDataBase.GetPointer(PCSchematicObjectData->CSpiceParameters, true);

	if(!PCSpiceParameters) return;

	PCSchematicObjectData->CSpiceParameters = *PCSpiceParameters;

	SetDisplay();
}

void TCSpiceComponentModelDlg::OnRadioXcoupled() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 1;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}
//////////////////////
/////////////////////
TCBipolarLabelsDlg::TCBipolarLabelsDlg() : CPropertyPage(TCBipolarLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCBipolarLabelsDlg)
	m_check_visable_ref_designator = FALSE;
	m_check_visable_spice_name = FALSE;
	m_check_visable_type_name = FALSE;
	m_check_visable_value = FALSE;
	CMRefDesignator = _T("");
	CMEditSpiceName = _T("");
	CMEditTypeName = _T("");
	CMEditValue = _T("");
	m_value_1_visable = FALSE;
	m_value_3_visable = FALSE;
	CEditValueHeader1 = _T("");
	CEditValueHeader3 = _T("");
	CMEditValue1 = _T("");
	CMEditValue3 = _T("");
	//}}AFX_DATA_INIT
}

TCBipolarLabelsDlg::~TCBipolarLabelsDlg()
{
}

void TCBipolarLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCBipolarLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE_3, CMEditCntrlValue3);
	DDX_Control(pDX, IDC_EDIT_VALUE_1, CMEditCntrlValue1);
	DDX_Control(pDX, IDC_EDIT_VALUE, CEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CEditCntlRefDesignator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_check_visable_ref_designator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_check_visable_spice_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_check_visable_type_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_check_visable_value);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMRefDesignator);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpiceName);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_1, m_value_1_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_3, m_value_3_visable);
	DDX_Text(pDX, IDC_STATIC_VALUE_1, CEditValueHeader1);
	DDX_Text(pDX, IDC_STATIC_VALUE_3, CEditValueHeader3);
	DDX_Text(pDX, IDC_EDIT_VALUE_1, CMEditValue1);
	DDX_Text(pDX, IDC_EDIT_VALUE_3, CMEditValue3);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCBipolarLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCBipolarLabelsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_NAME, OnKillfocusEditSpiceName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL TCBipolarLabelsDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_check_visable_type_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMEditTypeName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_check_visable_spice_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_check_visable_value;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_check_visable_ref_designator;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMRefDesignator;


		PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_M].is_visable = !!m_value_1_visable;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].is_visable = !!m_value_3_visable;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelValue = CMEditValue1;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue = CMEditValue3;
	}

	PCSchematicObjectData->FormatLabel();

	return value;
}

BOOL TCBipolarLabelsDlg::OnInitDialog() 
{
	m_check_visable_type_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_check_visable_spice_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpiceName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	

	m_check_visable_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue =  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;
	
	m_check_visable_ref_designator = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMRefDesignator =  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
	

	CEditValueHeader3	= "Parameters:";
	CEditValueHeader1	= "Multiplier:";

	m_value_1_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_M].is_visable;
	m_value_3_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].is_visable;
		
	CMEditValue1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelValue;
	CMEditValue3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue;

	CPropertyPage::OnInitDialog();
	
	CEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE; 
}

BOOL TCBipolarLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	g_last_active_generator_property_page = 0;

	PCSchematicObjectData->FormatSpiceName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CEditCntlValue.SetWindowText(CMEditValue);
	CEditCntlSpiceName.SetWindowText(CMEditSpiceName);

	return CPropertyPage::OnSetActive();
}

void TCBipolarLabelsDlg::OnKillfocusEditSpiceName() 
{
	UpdateData(true);
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

	PCSchematicObjectData->FormatRecordName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CEditCntlValue.SetWindowText(CMEditValue);
}


