#include "stdafx.h"
#include <math.h>
#include <float.h>
#include "TDVersion.h"
#include <fstream>
#include <iostream>
using namespace std;
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCWordConvert.h"
#include "TCMKSConvert.h"
#include "TCStringFunctions.h"
#include "TCSpiceParameters.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"
//#include "evallt.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase	GCSuperSpiceDataBase; 
extern TCWorkspaceTree GCWorkspaceTree;

CString GSubCktCurrentStr = "!"; //changed to for 1st Jan 2014
//CString GSubCktCurrentStr = "_ssi_pin"; // prior, too messy
CString GSubCktCurrentStrLegacy ="_ssi_pin";// Support for existing client subckt models
CString GSubCktCurrentPinStr = "Pin";
CString GSSModelSymbolFileName ="_ss_symbol_filename";
CString GSSModelSymbolName	= "_ss_symbol_name";
CString GSSModelSymbolComment = "_ss_comment";
CString GSSWCFileName = "sswc_filename";
CString GSSWCModelName = "sswc_modelname";
CString GSSWCSubcktModelType = "_ss_subckt_model_type";
CString GSSWCDefaltName = "virtual_sswc_";
extern CString GSSKeyWordArea = "area";
extern CString GSSKeyWordLength = "length";
extern CString GSSKeyWordWidth = "width";
extern CString GSSKeyWordMultiplier = "m";


CString RemoveFirstWord(CString CText);
extern CString GetSuperSpiceDefaultFileName(CString CFileName);
extern CString RemoveSquareBrakets(CString CText);
extern TCGeneralReportsTab GCGeneralReportsTab;


IMPLEMENT_SERIAL(TCSpiceParameters, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSpiceParametersList, CObject, ID_VERSION_NUMBER)

IMPLEMENT_SERIAL(TCNameValueData, CObject, ID_VERSION_NUMBER)
int Equation(CString CExpression, CString CValues, double *data_result);
int Equation(CString CExpression, double *data_result);
void ClearAllVars(void);
int EquationSetVaribles(CString CNameEqualsValueList);
int EquationSetVarible(CString CName, CString CValue);
#define MAX_SUBCKT_LINE_SIZE 65536

double BSim3v3EpsilonOxide = 3.453133e-11;
double BSim3v3EpsilonSI = 1.03594e-10;
double ElectronCharge = 1.60219e-19;
double BoltzmansConstant = 1.380658e-23;
double KboQ = 8.617087e-5;  /* Kb / q  where q = 1.60219e-19 */

TCNameValueData::TCNameValueData(void)
{
	value = 0;
	is_text_data = false;
	include  = true;
}
TCNameValueData::TCNameValueData(TCNameValueData &CNameValueData)
{
	*this = CNameValueData;
}
TCNameValueData::~TCNameValueData(void)
{

}

void TCNameValueData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	//member CValue and is_text_data is not seralised as it was added to support xspice models
	// after the fact. it will be recreated from the text model data
	// there is no need to store it anyway

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << value;
		CArchiveFile << CName;
	}
	else
	{
		CArchiveFile >> value;
		CArchiveFile >> CName;
	}
}
void TCNameValueData::operator = (TCNameValueData &CNameValueData)
{
	value = CNameValueData.value;
	CName = CNameValueData.CName;
	CValue = CNameValueData.CValue;

	is_text_data = CNameValueData.is_text_data;
	include = CNameValueData.include;
}
////////////////////////////////
TCSpiceParameters::TCSpiceParameters(void)
{
	unique_instance		= false;
	unique_parameters	= false;
	modified			= false;
	last_selected		= 0;
	use_model			= true;
	HTreeItem			= NULL;
}
TCSpiceParameters::TCSpiceParameters(TCSpiceParameters &CSpiceParameters)
{
	*this = CSpiceParameters;
}
TCSpiceParameters::~TCSpiceParameters(void)
{

}

void TCSpiceParameters::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CDataBaseIdInfo.Serialize(CArchiveFile);

	int p, count;
	int unique;
	// CSymbolParameters not saved. This data is always temporary. Added Oct 2014
	// CSubcktModelType not saved

	if(CArchiveFile.IsStoring())
	{
		unique = (unique_instance & 1) | (unique_parameters << 1 & 2);
		
		CArchiveFile << unique;
		CArchiveFile << modified;
		CArchiveFile << last_selected;
		CArchiveFile << use_model;

		count = CData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> unique;
		CArchiveFile >> modified;
		CArchiveFile >> last_selected;
		CArchiveFile >> use_model;

		CArchiveFile >> count;

		CData.SetSize(count, count);

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);

		unique_instance		= unique & 1;
		unique_parameters	= unique & 2;
	}
}

void TCSpiceParameters::SerializeInfo(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CDataBaseIdInfo.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << unique_instance;
		CArchiveFile << modified;
		CArchiveFile << last_selected;
		CArchiveFile << use_model;
	}
	else
	{
		CArchiveFile >> unique_instance;
		CArchiveFile >> modified;
		CArchiveFile >> last_selected;
		CArchiveFile >> use_model;
	}
}


void TCSpiceParameters::operator = (TCSpiceParameters &CSpiceParameters)
{
	int count, p;

	unique_instance	= CSpiceParameters.unique_instance;
	unique_parameters= CSpiceParameters.unique_parameters;
	modified		= CSpiceParameters.modified;
	last_selected	= CSpiceParameters.last_selected;
	use_model 		= CSpiceParameters.use_model;
	HTreeItem 		= CSpiceParameters.HTreeItem;
	CSymbolParameters = CSpiceParameters.CSymbolParameters;
	CSubcktModelType = CSpiceParameters.CSubcktModelType;

	CDataBaseIdInfo = CSpiceParameters.CDataBaseIdInfo;

	count = CSpiceParameters.CData.GetSize();

	CData.SetSize(count, count);

	for(p = 0; p < count; p++) CData[p] = CSpiceParameters.CData[p];

	count = CSpiceParameters.CPinArray.GetSize();

	CPinArray.SetSize(count);

	for(p = 0; p < count; p++) CPinArray[p] = CSpiceParameters.CPinArray[p];
}

void TCSpiceParameters::CopyInfo(TCSpiceParameters &CSpiceParameters)
{
	unique_instance	= CSpiceParameters.unique_instance;
	unique_parameters= CSpiceParameters.unique_parameters;
	modified		= CSpiceParameters.modified;
	last_selected	= CSpiceParameters.last_selected;
	use_model 		= CSpiceParameters.use_model;
	HTreeItem 		= CSpiceParameters.HTreeItem;
	CSymbolParameters = CSpiceParameters.CSymbolParameters;
	CSubcktModelType  = CSpiceParameters.CSubcktModelType;

	CDataBaseIdInfo = CSpiceParameters.CDataBaseIdInfo;
}

void TCSpiceParameters::Rename(CString CText)
{
	CString CTemp;

	if(CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL)
	{
		CDataBaseIdInfo.CRecordName = CText;

		return;
	}

	if(!CData.GetSize()) return;

	CTemp = RemoveFirstWord(CData[0].CName);

	CTemp = RemoveFirstWord(CTemp);// pins left to the right

	CDataBaseIdInfo.CRecordName = CText;

	CData[0].CName = '.' + CDataBaseIdInfo.CModelType + ' ' + 
		             CDataBaseIdInfo.CRecordName + ' ' + CTemp;

	CTemp = CData[0].CName;// checking
}

bool TCSpiceParameters::CreateReRunText(CArray <CString, CString> &CReRunList)
{
	int count = CData.GetSize();

	CReRunList.SetSize(0);
	CReRunList.SetSize(count);
	
	CString CName = CDataBaseIdInfo.CRecordName;

	CName = CName.Left(CName.GetLength() - 2);

	CName += "XN";

	char data;

	for(int p = 0; p < count; p++)
	{
		CString &CLine = CReRunList[p];

		if(!CData[p].include) 
		{
			CLine = "";

			continue;
		}
		
		data = GetSpiceModelChar();

		CLine = data;

		CLine +=  " ";

		CLine += FloatToMKSString(CData[p].value)  + " ";

		CLine += CData[p].CName  + " ";

		CLine += CName;
	}

	return true;
}

char TCSpiceParameters::GetSpiceModelChar(void)
{
	CString CText = CDataBaseIdInfo.CRecordType;

	CText.MakeLower();

	if(CText == "d") return 'd';
	if(CText == "npn" || CText == "pnp") return 'q';
	if(CText == "nmos" || CText == "pmos") return 'm';
	if(CText == "njf" || CText == "pjf") return 'j';
	if(CText == "nmf" || CText == "pmf") return 'z';
	if(CText == "c") return 'c';
	if(CText == "r") return 'r';
	if(CText == "l") return 'l';
	if(CText == "sw") return 's';
	if(CText == "csw") return 'w';
	if(CText == "urc") return 'u';
	if(CText == "ltra") return 'o';

	return '?';
}

bool TCSpiceParameters::IsDigital(void)
{
	CString CModelType = CDataBaseIdInfo.CRecordType;

	CModelType.MakeLower();

	if(CModelType == "d_pullup") return true; 
	if(CModelType == "d_pulldown")return true; 
	if(CModelType == "adc_bridge")return true;
	if(CModelType == "dac_bridge")return true;
	if(CModelType == "d_inverter")return true;
	if(CModelType == "d_nor")return true;
	if(CModelType == "d_or")return true;
	if(CModelType == "d_and")return true;
	if(CModelType == "d_nand")return true;
	if(CModelType == "d_xor")return true;
	if(CModelType == "d_xnor")return true;
	if(CModelType == "d_srff")return true;
	if(CModelType == "d_jkff")return true;
	if(CModelType == "d_dff")return true;

	return false;
}

void TCSpiceParameters::UpdateUseModel(void)
{
	// This function is used for R/C. If TC's and I.C.'s are zero dont use a model
	if(CDataBaseIdInfo.model_type == E_SPICE_SCHEMATIC)
	{
		use_model = false;

		return;
	}

	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_MODEL)
	{
		use_model = true;

		return;
	}

	int p, count;
	bool flag = false;

	count = CData.GetSize();

	if(!count)
	{
		use_model = false;

		return;
	}

	for(p = 0; p < count; p++)
	{
		if(CData[p].value != 0) flag = true;
	}

	if(flag) use_model = true;
	else use_model = false;
}

bool TCSpiceParameters::LoadModel(CString CFileName, CString CRecordName)
{
	ifstream CFileStream;
 
	CFileStream.open(CFileName, ios::in);

	if(CFileStream.fail()) return false;

	CArray <CString, CString&> CLines;
	CString CText;

	CLines.SetSize(0, 8);

	char *buff = new char[MAX_SUBCKT_LINE_SIZE];

	if(!buff) return false;

	unique_instance		= false;
	unique_parameters	= false;

	int p = 0;

	int found = false;

	CString CTemp;

	while(!CFileStream.eof())
	{
		CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

		if(*buff == 0) continue;

		CText = buff;
		CTemp = buff;

		CTemp.TrimLeft();

		if(CTemp.GetAt(0) == '*') continue;

		CTemp.MakeUpper();
		CTemp = CTemp.Left(6);

		if(CTemp != ".MODEL") continue;

		CDataBaseIdInfo.CModelType = "MODEL";
		CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;

		CTemp = buff;

		CTemp = CTemp.Right(CTemp.GetLength() - 6);

		char ctemp = CTemp.GetAt(CRecordName.GetLength() + 1);
		if(ctemp != '\t' && ctemp != ' ')  continue;

		CTemp.TrimLeft();
		CTemp.MakeUpper();
		CTemp = CTemp.Left(CRecordName.GetLength());
		CRecordName.MakeUpper();

		if(CRecordName != CTemp) continue;

		CLines.SetAtGrow(p++, CText);

		found = true;
		char peek;

		while((peek=(char)CFileStream.peek()) == '+'|| 
					peek == ' ' || peek == '*' || 
					peek == '\t'|| peek == '\n')

		{
			CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

			CText = buff;

			CText.TrimLeft();
			CText.TrimRight();

			if(CText == "") continue;
			if(CText == "*") continue;

			CLines.SetAtGrow(p++, CText);
		}


		break;
	}
	CFileStream.close();

	delete [] buff;

	if(!found) return false;

	if(!SetFromText(CLines)) return false;

	modified			= false;

	CDataBaseIdInfo.CRecordName		= CRecordName;
	CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CFileName);
	CDataBaseIdInfo.CRecordFileName = ExtractFileName(CFileName);

	return true;
}


bool TCSpiceParameters::LoadSubCircuit(CString CFileName, CString CRecordName)
{
	ifstream CFileStream;
	int test;
 
	CFileStream.open(CFileName, ios::in);

	if(CFileStream.fail()) return false;

	CArray <CString, CString&> CLines;
	CString CText;

	CLines.SetSize(0, 128);

	char *buff = new char[MAX_SUBCKT_LINE_SIZE];

	if(!buff) return false;

	int p = 0;
	unique_instance		= false;
	unique_parameters	= false;

	int found = false;
	int subckt_counter;

	CString CTemp, CTemp2;
	CString CEndCheck;

	while(!CFileStream.eof())
	{
		CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

		// white space in colum 1 is a comment for spice3
//		if(*buff == 0 || *buff == ' ' || *buff == '\t' || *buff == '*') continue;
		if(*buff == 0 || *buff == '*') continue;

		CText = buff;
		CTemp = buff;

		CTemp.MakeUpper();
		CTemp = CTemp.Left(7);
  
		if(CTemp != ".SUBCKT") continue;

		CDataBaseIdInfo.CModelType = "SUBCKT";
		CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;

		CTemp = buff;

		test = CTemp.GetLength() - 7;

		if(test < 0) break;

		CTemp = CTemp.Right(test);

		if(test < 0) break;

		test = CRecordName.GetLength() + 1;

		if(test >= CTemp.GetLength()) continue;

		char ctemp = CTemp.GetAt(test);

		if(ctemp != '\t' && ctemp != ' ')  continue;

		CTemp.TrimLeft();
		CTemp.MakeUpper();
		CTemp = CTemp.Left(CRecordName.GetLength());
		
		CTemp2 = CRecordName;

		CTemp2.MakeUpper();

		if(CTemp != CTemp2) continue;

		CLines.SetAtGrow(p++, CText);

		found = true;

		subckt_counter = 1;

		while(!CFileStream.eof())
		{
			bool first = false;

			CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

			CText = buff;
			CText.TrimLeft();
			CText.TrimRight();

			if(CText == "") continue;

			if(!first && CText.GetAt(0) == '+')// muliple line support for names and parameters
			{
				first = true;

				CText = CText.Right(CText.GetLength() - 1);

				CLines[0] += ' ';

				CLines[0] += CText;

				while(CFileStream.peek() == '+')
				{
					CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

					CText = buff;

					CText = CText.Right(CText.GetLength() - 1);

					CLines[0] += ' ';

					CLines[0]  += CText;
				}

				continue;
			}

			first = true;

			CLines.SetAtGrow(p++, CText);

			CEndCheck = GetFirstWord(CText);

			CEndCheck.TrimRight();

			CEndCheck.MakeUpper();

			if(CEndCheck == ".SUBCKT") subckt_counter++;

			if(CEndCheck == ".ENDS") // check if nested subckt.
			{
				subckt_counter--;

				if(subckt_counter < 1) break;// This will terminate most nested subckt without names required
			}
		}

		break;
	}
	CFileStream.close();

	delete [] buff;

	if(!found) return false;

	int count = CLines.GetSize();

	CData.SetSize(count, count);

	for(p = 0; p < count; p++) CData[p].CName = CLines[p];

	modified			= false;

	CDataBaseIdInfo.CRecordName		= CRecordName;
	CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CFileName);
	CDataBaseIdInfo.CRecordFileName = ExtractFileName(CFileName);

	return true;
}

CString TCSpiceParameters::GetPinList(CArray <CString, CString> &CPinArray)
{
	CString CText;

	TCNameValueData CNameValueData, CSubPinData;
	CString CSubCktName;
	CString CLine, CWord;

	int line_count;
	int pin_count = 0;
	CPinArray.SetSize(0, 32);

	line_count = CData.GetSize();

	if(line_count < 3) return "";

	if(CData[1].CName.GetLength() > 3) 
		if(CData[1].CName.GetAt(0) == '*' && CData[1].CName.GetAt(1) == '#' && 
			CData[1].CName.GetAt(2) == '$' && CData[1].CName.GetAt(3) == '@') return "";//need code to leave text headers

	CLine = CData[0].CName;

	CLine = RemoveFirstWord(CLine);//.subckt

	CSubCktName = GetFirstWord(CLine);

	CLine = RemoveFirstWord(CLine);//name

	if(CLine == "") return "";

	CPinArray.SetSize(0, 32);

	CString CParamTest;

	CLine.Replace('\t', ' '); 
	int index;

	while(CLine != "")
	{
		CWord = GetFirstWord(CLine);

		CParamTest = CWord;

		CParamTest.MakeLower();

		if(CParamTest == "params:") break;//end of pins

		index = CParamTest.Find('=');

		if(index > -1)// remove the last added data as not a pin
		{
			if(index == 0)// key=value or key = value
			{
				pin_count--;

				CPinArray.SetSize(pin_count);
			}

			break;//end of pins
		}

		CLine = RemoveFirstWord(CLine);

		CPinArray.Add(CWord);

		pin_count++;
	}

	if(!line_count) return "";

	for(int p = 0; p < pin_count; p++)
	{
		CText += CPinArray[p] + " ";
	}
	
	return CText;
}


void TCSpiceParameters::AddCurrentProbingVoltageSources(void)
{
	TCNameValueData CNameValueData, CSubPinData;
	CString CSubCktName;
	CString CLine, CWord;
	CArray <CString, CString> CPinArray;

	int line_count;
	int pin_count = 0;

	line_count = CData.GetSize();

	if(line_count < 3) return;

	if(CData[1].CName.GetLength() > 3) 
		if(CData[1].CName.GetAt(0) == '*' && CData[1].CName.GetAt(1) == '#' && 
			CData[1].CName.GetAt(2) == '$' && CData[1].CName.GetAt(3) == '@') return;//need code to leave text headers

	CLine = CData[0].CName;

	CLine = RemoveFirstWord(CLine);//.subckt

	CSubCktName = GetFirstWord(CLine);

	CLine = RemoveFirstWord(CLine);//name

	if(CLine == "") return;

	CPinArray.SetSize(0, 32);

	CString CParamTest;

	CLine.Replace('\t', ' '); 
	int index;

	while(CLine != "")
	{
		CWord = GetFirstWord(CLine);

		CParamTest = CWord;

		CParamTest.MakeLower();

		if(CParamTest == "params:") break;//end of pins

		index = CParamTest.Find('=');

		if(index > -1)// remove the last added data as not a pin
		{
			if(index == 0)// key=value or key = value
			{
				pin_count--;

				CPinArray.SetSize(pin_count);
			}

			break;//end of pins
		}

		CLine = RemoveFirstWord(CLine);

		if(CWord.Find(GSubCktCurrentStr) > -1) return;// already has the volt sources
		if(CWord.Find(GSubCktCurrentStrLegacy) > -1) return;// legacy already has the volt sources
		
		if(CWord.Find('#') > -1) return;// digital AD signals
		if(CWord.Find('$') > -1) return;

		CPinArray.Add(CWord);

		pin_count++;
	}

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_subckt_currents) return;

	if(!line_count) return;

	CSubPinData.CName = ".subckt " + CSubCktName + ' ';

	CString CPinCount;
	CString CNetName;
	CString CVoltName;
	CString OrginalPinName;

	for(int p = 0; p < pin_count; p++)
	{
		OrginalPinName = CPinArray[p];

		CNetName.Format("%s%d_%s ", GSubCktCurrentStr, p, OrginalPinName);
		CVoltName.Format("V%s%d ", GSubCktCurrentStr, p);

		CLine = CVoltName + CNetName + ' ';

		CSubPinData.CName += CNetName; // new external connection pin list

		CLine += OrginalPinName;

		CNameValueData.CName = CLine + " 0"; // v_ssi_1  _ssi_1 1 0
		
		CData.InsertAt(2, CNameValueData); 
	}

	//recover params: section
	CString CParamLine = IsParamInLine(CData[0].CName);

	if(CParamLine != "")
	{
		CSubPinData.CName  += ' ';
		CSubPinData.CName  += CParamLine;
	}

	CData.SetAt(0, CSubPinData);
}

bool TCSpiceParameters::LoadModelOrSubcircuit(ifstream &CFileStream)
{
	CArray <CString, CString&> CLines;
	CString CText;
	CString CEndCheck;

	CLines.SetSize(256, 256);// guess a size, that truncate it

	char *buff = new char[MAX_SUBCKT_LINE_SIZE];

	if(!buff) return false;

	int p = 0;

	int found = false;
	int subckt_counter;
	unique_instance		= false;
	unique_parameters	= false;

	CString CTemp, CTemp2;

	while(!CFileStream.eof())
	{
		CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

		// white space in colum 1 is a comment for spice3
//		if(*buff == 0 || *buff == ' ' || *buff == '\t' || *buff == '*') continue;
		if(*buff == 0 || *buff == '*') continue;

		CText = buff;
		CTemp = buff;

		CTemp.MakeUpper();
		CTemp = CTemp.Left(7);

		if(CTemp == ".SUBCKT") 
		{
			CDataBaseIdInfo.CModelType = "SUBCKT";
			CDataBaseIdInfo.CRecordType = "X";		// added 6th Aug, 2001
			CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
		}
		else
		{
			CTemp = CTemp.Left(6);

			if(CTemp == ".MODEL")
			{
				CDataBaseIdInfo.CModelType = "MODEL";
				CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
			}
			else 
			{
				CTemp = CTemp.Left(4);

				if(CTemp == ".LIB")
				{
					CDataBaseIdInfo.CModelType = "LIB";
					CDataBaseIdInfo.model_type = E_SPICE_DOT_HSPICELIB;
				}
				else continue;
			}	
		}
		
		CTemp = buff;

		CTemp = CTemp.Right(CTemp.GetLength() - CDataBaseIdInfo.CModelType.GetLength() -1);

		CTemp.TrimLeft();

		int index = CTemp.Find("\t");

		if(index < 0) index = CTemp.Find(" ");
		if(index < 0)  continue;

		CDataBaseIdInfo.CRecordName = CTemp.Left(index);// get name

		CTemp = CTemp.Right(CTemp.GetLength() - index);

		CLines.SetAtGrow(p++, CText);

		found = true;
		subckt_counter = 1;
		char peek;

		if(CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL)
		{
			while((peek=(char)CFileStream.peek()) == '+'|| 
					peek == ' ' || peek == '*' || 
					peek == '\t'|| peek == '\n')
			{
				CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

				CText = buff;

				CText.TrimLeft();
				CText.TrimRight();

				if(CText == "") continue;
				if(CText.GetAt(0) == '*') continue;

				CLines.SetAtGrow(p++, CText);
			}
		}
		else if(CDataBaseIdInfo.model_type == E_SPICE_DOT_SUBCIRCUIT)
		{
			bool first = false;

			while(!CFileStream.eof())
			{				
				CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

				CText = buff;
				CText.TrimLeft();
				CText.TrimRight();

				if(CText == "") continue;

				if(!first && CText.GetAt(0) == '+')// muliple line support for names and parameters
				{
					CText = CText.Right(CText.GetLength() - 1);

					first = true;

					CLines[0] += ' ';

					CLines[0]  += CText;

					while(CFileStream.peek() == '+')
					{
						CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

						CText = buff;

						CText = CText.Right(CText.GetLength() - 1);

						CLines[0] += ' ';

						CLines[0]  += CText;
					}

					continue;
				}

				first = true;

				CLines.SetAtGrow(p++, CText);

				CEndCheck = GetFirstWord(CText);

				CEndCheck.TrimRight();

				CEndCheck.MakeUpper();

				if(CEndCheck == ".SUBCKT") subckt_counter++;

				if(CEndCheck == ".ENDS") // check if nested subckt.
				{
					subckt_counter--;

					if(subckt_counter < 1) break; // .subckt match .ends
				}
			}
		}
		else //HSpice LIb surpport
		{
			bool first = false;

			while(!CFileStream.eof())
			{				
				CFileStream.getline(buff, MAX_SUBCKT_LINE_SIZE);

				CText = buff;
				CText.TrimLeft();
				CText.TrimRight();

				if(CText == "") continue;

				first = true;

				CLines.SetAtGrow(p++, CText);

				CEndCheck = GetFirstWord(CText);

				CEndCheck.TrimRight();

				CEndCheck.MakeUpper();

				if(CEndCheck == ".LIB") subckt_counter++;

				if(CEndCheck == ".ENDL") // check if nested subckt.
				{
					subckt_counter--;

					if(subckt_counter < 1) break; // .lib match .endl
				}
			}
		}

		break;
	}

	delete [] buff;

	if(!found) return false;

//	int count = CLines.GetSize();

	CLines.SetSize(p);// added to speed things up.

	int count = p;

	if(CDataBaseIdInfo.model_type == E_SPICE_DOT_SUBCIRCUIT)
	{
		CDataBaseIdInfo.CSymbolName = "";
		CDataBaseIdInfo.CSymbolFileName = "";
		CData.SetSize(count, count);

		CString CSpiceTextLine;

		for(p = 0; p < count; p++) //Modified 6th Aug 2001
		{
			CSpiceTextLine = CLines[p];

			CData[p].CName = CSpiceTextLine;

			SetSubcircuitSymbolName(CSpiceTextLine);// added

			SetSubcktModelType(CSpiceTextLine);// WC support
		}

		AddCurrentProbingVoltageSources();

		ConvertPSpiceSyntaxToSpice3();
	}
	else 
	{
		if(!SetFromText(CLines)) return false;

		if(CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL) SetModelSymbolName();
	}

	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_HSPICELIB)
	{
		CDataBaseIdInfo.CRecordName = FormatSpiceValue(CDataBaseIdInfo.CRecordName);//If not a superspice formated model convertit

		Rename(CDataBaseIdInfo.CRecordName);// only needed for subcircuits
	}

	modified			= false;

	return true;

}

void TCSpiceParameters::ConvertPSpiceSyntaxToSpice3(void)
{
	ConvertPSpiceSourcesToSpice3BSource();
}

void TCSpiceParameters::ConvertPSpiceSourcesToSpice3BSource(void)
{
	int count = CData.GetSize();

	if(count < 2) return;

	CString CText, COldValue;
	char sourcetype;

	for(int p = 1; p < count; p++)
	{
		CString &CLine = CData[p].CName;

		COldValue = IsValueInLine(CLine);

		if(COldValue == "") continue;

		CText = GetFirstWord(CLine);

		sourcetype = CText.GetAt(0);

		if(sourcetype == 'G' || sourcetype == 'g' || 
		   sourcetype == 'F' || sourcetype == 'f')
		{
			CLine.Replace(COldValue, "i");
		}
		else
		{
			CLine.Replace(COldValue, "v");
		}
		
		CLine.Replace("{", "");
		CLine.Replace("}", "");

		CLine = "B" + CLine;
	}
}

CString TCSpiceParameters::IsValueInLine(CString CLine)
{
	CString CText, CTextReturn;

	int index = CLine.Find("="); //G1 1 2 VALUE = {V(1,2) ....

	if(index < 0) return "";

	CText = CLine.Left(index); //G1 1 2 VALUE //

	CText.TrimRight();	//G1 1 2 VALUE/

	CTextReturn = CText.Right(5); //VALUE/

	CText = CTextReturn;

	CText.MakeLower();

	if(CText == "value") return CTextReturn;

	return "";
}

CString TCSpiceParameters::IsParamInLine(CString CLine)
{
	CString CText, CTemp;

	int index = CLine.Find("="); //.SUBCKT RBMV 1 2 3 PARAMS: m=1....

	if(index < 0) return "";	//or .SUBCKT RBMV 1 2 3 m=1....

	CLine.Replace('\t', ' ');  

	CTemp = CLine.Left(index); //.SUBCKT RBMV 1 2 3 m

	CTemp.TrimRight();

	index = CTemp.ReverseFind(' ');

	CTemp = CTemp.Left(index);

	CLine = CLine.Right(CLine.GetLength() - CTemp.GetLength()); 

	CLine.TrimRight();
	CLine.TrimLeft();

	return CLine;
}

CString TCSpiceParameters::GetSubcktParameters()
{
	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_SUBCIRCUIT) return "";
	if(!CData.GetSize()) return "";

	CString CParameterLine = IsParamInLine(CData[0].CName);

	return CParameterLine;
}

void TCSpiceParameters::SetSubcktParameters(CString CParameterLine)
{
	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_SUBCIRCUIT) return;
	if(!CData.GetSize()) return;

	CParameterLine.TrimLeft();
	CParameterLine.TrimRight();

	if(CParameterLine == "") return;

	CArray <CString, CString> CPinArray;
	CString CLine;
	CString &CNewData = CData[0].CName;

	GetPinList(CPinArray);

	int count = CPinArray.GetSize();

	CLine = '.' + CDataBaseIdInfo.CModelType + " " + CDataBaseIdInfo.CRecordName + " ";

	for(int p = 0; p < count; p++)
	{
		CLine += CPinArray[p] + " ";
	}

	CNewData = CLine + CParameterLine;
}

CString TCSpiceParameters::ArrayToLine(void)
{
	CString CLine;
	int p, count;

	count = CData.GetSize();

	for(p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = CData[p];

		CLine += CNameValueData.CName + '=';

		if(CNameValueData.is_text_data)
		{
			CLine += CNameValueData.CValue + ' ';
		}
		else
		{
			CLine += FloatToMKSString(CNameValueData.value)  + ' ';
		}
	}

	return CLine;
}

void TCSpiceParameters::LineToArray(CString CLine)
{
	if(CLine == "") return ;

	TCNameValueData CNameValueData;

	int num_words, num_param;
	int size_words;
	int count;
	char** words;

	num_param	= CountCharacters(CLine, '=');

	size_words	= CLine.GetLength() + 1; // Must be smallar than total line length

	num_words = num_param * 2 + 1;

	words = NewCharArray(1 + num_words, size_words);

	if(!words) return;

	CData.SetSize(0, 256);

	strcpy(words[0], CLine.GetBuffer(size_words));

	ExtractSpiceModelWords(words, num_words);

	count = num_param;

	char **p_data = &words[1];

	for(int p = 0; p < count; p++)
	{
		CNameValueData.CName  = *p_data++;
		CNameValueData.CValue = *p_data++;
		 
		if(!(CNameValueData.CValue.Find('{') < 0))
		{
			CNameValueData.value  = 0;

			CNameValueData.is_text_data = true;
		}
		else
		{		
			CNameValueData.value = SpiceMKSStringToFloat(CNameValueData.CValue);

			CNameValueData.CValue = "";

			CNameValueData.is_text_data = false;
		}

		CData.Add(CNameValueData);
	}

	DeleteCharArray(words, 1 + num_words);
}

CString TCSpiceParameters::EvaluateParameterLine(CString CParameterDefs, CString CParameterLine)
{
	CString CLocalParamLine, CText; // assumes input is "x=1 y={data} z=3" 
	CString CName, CValue, CNameValue;

	if(CParameterDefs == "") return CParameterLine;
	if(CParameterLine == "") return "";

	int num_words, num_param;
	int size_words;
	int count;
	char** words;
	double result = 0;
//	double dummy;
// int f_flag;

	num_param	= CountCharacters(CParameterLine, '=');

	size_words	= CParameterLine.GetLength() + 1; // Must be smallar than total line length

	num_words = num_param * 2 + 1;

	words = NewCharArray(1 + num_words, size_words);

	if(!words) return CParameterLine;

	EquationSetVaribles(CParameterDefs);

	strcpy(words[0], CParameterLine.GetBuffer(size_words));

	ExtractSpiceModelWords(words, num_words);

//	count = num_words/2 - 1; 

	count = num_param;

	char **p_data = &words[1];

	for(int p = 0; p < count; p++)
	{
		CName = *p_data++;
		
		CValue = *p_data++;

		if(!(CValue.Find('{') < 0))
		{
			CValue.Remove('{');
			CValue.Remove('}');

			Equation(CValue, &result);

			CValue = FloatToMKSString(result);

			CNameValue = CName + '=' + CValue;
		}
		else
		{
			CNameValue = CName + '=' + CValue;
		}

//		Evaluate(CNameValue.GetBuffer(CName.GetLength() + 1), &dummy, &f_flag);//use for following expressions

		CLocalParamLine += CNameValue + ' ';
	}

	DeleteCharArray(words, 1 + num_words);

	return CLocalParamLine;
}

void TCSpiceParameters::EvaluateSubcktParameters(CString CModelParameters, CString CSymbolParameterLine)
{
	ConvertSpiceParameters(CModelParameters, CSymbolParameterLine);

	int count = CData.GetSize();

	if(count < 2) return;

	CString CParameterLine;

	CParameterLine = IsParamInLine(CData[0].CName);

	if(CParameterLine == "") return;

	// Remove parameter string from subckt header line

	CString &CLine = CData[0].CName;

	int index = CLine.Find(":"); //.SUBCKT RBMV 1 2 3 PARAMS: m=1....

	if(index > -1) CLine = CLine.Left(index - 6);// remove param:
	else // no param, but remove before key=value
	{
		int index = CLine.Find("="); // pinx key = value

		CLine = CLine.Left(index);// pinx key //

		CLine.Replace("\t", " ");

		CLine.TrimRight();

		index = CLine.ReverseFind(' ');

		CLine = CLine.Left(index);// pinx
	}
}

void TCSpiceParameters::ConvertSpiceParameters(CString CModelParameters, CString CSymbolParameterLine)
{
	int count = CData.GetSize();

	if(count < 2) return;

	CString CParameterLine;

	CParameterLine = IsParamInLine(CData[0].CName);

	CModelParameters.TrimLeft();
	CModelParameters.TrimRight();

	if(CModelParameters != "") CParameterLine = CModelParameters;

	CParameterLine.TrimLeft();
	CParameterLine.TrimRight();

	// use individuale symbol parameters if available
	if(CSymbolParameterLine != "") CParameterLine = CSymbolParameterLine;

	//process param line and .param lines in .subckt
	ReplaceExpression(CParameterLine);
}

void TCSpiceParameters::ReplaceExpression(CString CExpressionParameters, char open_char, char close_char)
{
	if(!EquationSetVaribles(CExpressionParameters)) return;// In expression.cpp

	int count = CData.GetSize();

	if(count < 2) return;

	int open_brace, close_brace, index;

	CString CParam, CNewLine, CParameterValue, ParamVar, ParamValue;
	double result;
	CString CParamCheck;

	//find .param lines in subckt, added 31st July 2005

	int p, expression_flag;

	for(int p = 1; p < count; p++)
	{
		CString CLine = CData[p].CName;

		CParamCheck = CLine;

		CParamCheck.MakeLower();

		CLine.TrimLeft();

		index = CParamCheck.Find(".param");

		if(index < 0) continue;

		CNewLine = CLine.Right(CLine.GetLength() - 7 - index);

//		Added 17th December 2013
		// Evaluate .param x=f(input parameter varibles)// no braces required

		expression_flag = CNewLine.Find('{');

		if(expression_flag < 0) // If no braces expression, set all variables as is including evaluating spice multipliers
		{
			expression_flag = CNewLine.Find(';');// remove comments

			if(expression_flag > -1)
			{
				CNewLine = CNewLine.Left(expression_flag);
			}

			EquationSetVaribles(CNewLine);

			continue;
		}

		// Assume full expressions, so remove braces. Get expression and evaluate
		CNewLine.Replace('{', ' '); // does not require {}
		CNewLine.Replace('}', ' ');
		ParamVar = GetFirstWord(CNewLine, '=');
		ParamValue = RemoveFirstWord(CNewLine, '=');
		Equation(ParamValue, &result); 
		ParamValue.Format("%e", result);
		EquationSetVarible(ParamVar, ParamValue); // Latest expression evaluation available for following evaluations
//		Added 17th December 2013

//		EquationSetVaribles(CNewLine); //prior to 17th December 2013
	}
	
	CString CLineEnd;

	close_brace = 0;
	int flag;
	
	for(p = 1; p < count; p++)
	{
		flag = 1;

		while(flag)
		{
			CString &CLine = CData[p].CName;// search each line for each set of {} or ''

			open_brace = CLine.Find(open_char); // D1 1 3 DRSUB { x+y }$ extra text

			if(open_brace < 0) 
			{
				flag = 0;

				break;//go on to next line
			}

			close_brace = CLine.Find(close_char);

			if(close_brace < 0)
			{	
				flag = 0;

				break;//go on to next line
			}

			CNewLine = CLine.Left(open_brace);// D1 1 3 DRSUB 

		//	CNewLine.TrimRight();

			CLineEnd = CLine.Right(CLine.GetLength() - close_brace - 1);

			CParam = CLine.Left(close_brace);
 
			CParam.TrimRight();  // D1 1 3 DRSUB { x+y

			CParam = CParam.Right(CParam.GetLength() - open_brace - 1); // x+y //

			CParam.TrimRight();
			CParam.TrimLeft();
//			CParam.MakeLower();

			Equation(CParam, &result);
	
			CParameterValue.Format("%e", result);

			CLine = CNewLine + CParameterValue + CLineEnd;
		} //try text again for more substitutions
	}
} 

void TCSpiceParameters::EvaluateModelParameters(CString CSymbolParameterLine)
{
	double  result = 0;
	CString CParamExpression;

	CSymbolParameterLine.TrimLeft();
	CSymbolParameterLine.TrimRight();
	
	if(CSymbolParameterLine == "") return;			
	if(CSymbolParameterLine.Find('=') < 0) return;			
	if(CSymbolParameterLine.GetLength() < 3) return;

	if(!EquationSetVaribles(CSymbolParameterLine)) return;// In expression.cpp

	int count = CData.GetSize();

	if(!count) return;

	for(int p = 0; p < count; p++)
	{
		if(!CData[p].is_text_data) continue;

		CParamExpression = CData[p].CValue;

		if(!(CParamExpression.Find('[') < 0)) continue;// ignore non param strings like file names
		if(!(CParamExpression.Find(']') < 0)) continue;

		CParamExpression.Remove('\"');
		CParamExpression.Remove('\'');
		CParamExpression.Remove('{');
		CParamExpression.Remove('}');

		if(!Equation(CParamExpression, &result)) continue;

		CData[p].value = result;

		CData[p].is_text_data = false;
	}
}

void TCSpiceParameters::EvaluateModelParameters(CString CSymbolParameterLine, int id)
{
	double  result = 0;
	CString CParamExpression;

	int count = CData.GetSize();

	if(!count) return;

	if(!(id < count)) return;

	CSymbolParameterLine.TrimLeft();
	CSymbolParameterLine.TrimRight();
	
	if(CSymbolParameterLine == "") return;			
	if(CSymbolParameterLine.Find('=') < 0) return;			
	if(CSymbolParameterLine.GetLength() < 3) return;

	if(!CData[id].is_text_data) return;

	if(!EquationSetVaribles(CSymbolParameterLine)) return;// In expression.cpp

	CParamExpression = CData[id].CValue;

	if(!(CParamExpression.Find('[') < 0)) return; // ignore non param strings like file names
	if(!(CParamExpression.Find(']') < 0)) return;

	CParamExpression.Remove('\"');
	CParamExpression.Remove('\'');
	CParamExpression.Remove('{');
	CParamExpression.Remove('}');

	if(!Equation(CParamExpression, &result)) return;

	CData[id].value = result;

	CData[id].is_text_data = false;
}

CString TCSpiceParameters::ConvertToParameterString(void)
{
	CString CParameters;
	CString CNameValue;
	CString CValueData;
	double data = 0;

	int count = CData.GetSize();

	if(!count) return "";

	for(int p = 0; p < count; p++)
	{
		TCNameValueData CNameValueData = CData[p];

		if(!CNameValueData.is_text_data)
		{
			CNameValue = CNameValueData.CName + "=" + FloatToMKSString(CNameValueData.value);

			EquationSetVaribles(CNameValue); // use first diffined params to set later ones 

			CParameters += CNameValue + ' ';
		}
		else
		{
			CNameValueData.CValue.Remove('{');

			CNameValueData.CValue.Remove('}');

			Equation(CNameValueData.CValue, &data);// evaluate from prior data

			CValueData = FloatToMKSString(data);

			CParameters += CNameValueData.CName + "=" + CValueData + ' ';
		}
	}

	return CParameters;
}

CString TCSpiceParameters::GetLibParameter(void)
{
	CString CParameters;

	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_HSPICELIB) return "";

	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CParameters += CData[p].CName;

		CParameters += "=";

		CParameters += CData[p].CValue;
	
		CParameters += " ";
	}

	return CParameters;
}

bool TCSpiceParameters::SetSubcircuitSymbolName(CString CSpiceLine)
{
	//format is 
	//* _SS_Symbol [C:\Program Files\AnaSoft\SuperSpice\Default\SuperSpice.ssm] [Fuse]

	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_SUBCIRCUIT) return false;

	CSpiceLine.TrimLeft();

	if(CSpiceLine == "") return false;

	if(CSpiceLine.GetAt(0) != '*') return false;

	int length = CSpiceLine.GetLength();

	CSpiceLine = CSpiceLine.Right(length - 1);

	CString CKeyWord = GetFirstWord(CSpiceLine);

	CKeyWord.MakeLower();

	if("_ss_symbol" != CKeyWord) return false;

	CSpiceLine = RemoveFirstWord(CSpiceLine);

	int index = CSpiceLine.Find(']');

	CDataBaseIdInfo.CSymbolFileName = CSpiceLine.Left(index);// remove ], keep spaces in path name

	length = CDataBaseIdInfo.CSymbolFileName.GetLength();

	CDataBaseIdInfo.CSymbolFileName = CDataBaseIdInfo.CSymbolFileName.Right(length - 1);

	CDataBaseIdInfo.CSymbolFileName = GetSuperSpiceDefaultFileName(CDataBaseIdInfo.CSymbolFileName);

	length = CSpiceLine.GetLength();

	CSpiceLine = CSpiceLine.Right(length - index);

	CSpiceLine.TrimLeft();

	length = CSpiceLine.GetLength();

	if(length < 1) return false;

	CSpiceLine = CSpiceLine.Right(length - 1);// grt rid of ]

	CSpiceLine.TrimLeft();

	index = CSpiceLine.Find(']');

	if(index < 0) return false;

	CSpiceLine = CSpiceLine.Left(index);// grt rid of end stuff
	//CSpiceLine

	index = CSpiceLine.Find('[');

	if(index < 0) return false;

	length = CSpiceLine.GetLength();

	if(length < 1) return false;

	CSpiceLine = CSpiceLine.Right(length - index - 1);

	CDataBaseIdInfo.CSymbolName = CSpiceLine;

	return true;
}

bool TCSpiceParameters::SetSubcktModelType(CString CSpiceLine)
{
	// NPN, PNP if subckt is a subckt of a standard spice model for WC/MC

	//format is 
	//* GSSWCSubcktModelType NPN

	CSubcktModelType = "SUB"; // default the type

	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_SUBCIRCUIT) return false;

	CSpiceLine.TrimLeft();

	if(CSpiceLine == "") return false;

	if(CSpiceLine.GetAt(0) != '*') return false;

	int length = CSpiceLine.GetLength();

	CSpiceLine = CSpiceLine.Right(length - 1);

	CString CKeyWord = GetFirstWord(CSpiceLine);

	CKeyWord.MakeLower();

	if(GSSWCSubcktModelType != CKeyWord) return false;

	CSpiceLine = RemoveFirstWord(CSpiceLine);

	CKeyWord = GetFirstWord(CSpiceLine);

	CSubcktModelType = CKeyWord.MakeUpper();

	return true;
}

void TCSpiceParameters::AddSubcircuitSymbolName(void)
{
	if(CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL) 
	{
		AddModelSymbolName();

		return;
	}

	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_SUBCIRCUIT) return;

	TCNameValueData CNameValueData;
	CString CSpiceLine;
	int length;

	int count = CData.GetSize();
	int found_index = -1;

	for(int p = 0; p < count; p++) // find out if line is already there
	{
		CSpiceLine = CData[p].CName;

		CSpiceLine.TrimLeft();

		if(CSpiceLine == "") continue;

		if(CSpiceLine.GetAt(0) != '*') continue;

		length = CSpiceLine.GetLength();

		CSpiceLine = CSpiceLine.Right(length - 1);

		CString CKeyWord = GetFirstWord(CSpiceLine);

		CKeyWord.MakeLower();

		if("_ss_symbol" != CKeyWord) continue;

		found_index = p;

		break;
	}

	CString CTextLine;

	CTextLine = "* _SS_Symbol [";

	CTextLine += CDataBaseIdInfo.CSymbolFileName + "] [";

	CTextLine += CDataBaseIdInfo.CSymbolName + ']';

	CNameValueData.CName = CTextLine;

	if(found_index == -1) CData.InsertAt(1, CNameValueData);
	else CData[found_index] = CNameValueData;
}

bool TCSpiceParameters::SetModelSymbolName(void)
{
	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_MODEL) return false;

	CString CText;

	CDataBaseIdInfo.CSymbolFileName = "";
	CDataBaseIdInfo.CSymbolName = "";

	if(!Get("_SS_Symbol_FileName", &CText)) if (CText == "") return false;
		
	CDataBaseIdInfo.CSymbolFileName= RemoveSquareBrakets(CText);

	if(!Get("_SS_Symbol_Name", &CText)) if (CText == "") return false;
		
	CDataBaseIdInfo.CSymbolName = RemoveSquareBrakets(CText);

	return true;
}

void TCSpiceParameters::AddModelSymbolName(void)
{
	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_MODEL) return;

	CString CText;

	CText = '[' + CDataBaseIdInfo.CSymbolFileName + ']';

	Set("_SS_Symbol_FileName", CText);

	CText = '[' + CDataBaseIdInfo.CSymbolName + ']';

	Set("_SS_Symbol_Name", CText);
}

bool TCSpiceParameters::Save(CString CFileName, CString CRecordName)
{
	TCSpiceParametersList CSpiceParametersList;
	
	if(!CSpiceParametersList.LoadAll(CFileName)) return false;

	Rename(CRecordName);// ensure correct name

	int index = CSpiceParametersList.FindModelOrSubcircuit(CRecordName);

	if(index < 0) 
	{
		int id = CSpiceParametersList.CParameters.Add(*this);

		GCWorkspaceTree.AddModel(CFileName, id);
	}
	else CSpiceParametersList.CParameters[index] = *this;

	return CSpiceParametersList.SaveAll(CFileName);
}

bool TCSpiceParameters::SaveToSingleFile(CString CFileName, CString CRecordName)
{
	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CArray <CString, CString&> CModelData;

	CString CTemp = CDataBaseIdInfo.CRecordName;// for SaveAs

//	CDataBaseIdInfo.CRecordName = CRecordName;

	Rename(CRecordName);// ensure correct name

	GetToText(CModelData);

	CDataBaseIdInfo.CRecordName = CTemp;

	int count =  CModelData.GetSize();

	if(!count) return false;

	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);

	count--;

	int p;

	for(p = 0; p < count; p++)
	{
		CDataFile.Write(CModelData[p], CModelData[p].GetLength());

		CDataFile.Write(data, char_size);
	}

	CDataFile.Write(CModelData[p], CModelData[p].GetLength());

	CDataFile.Close();

	return true;
}

bool TCSpiceParameters::Save(ifstream &CFileStream)
{
	CFileStream;
	return true;
}

CString TCSpiceParameters::FormatSpiceValue(CString CTextData)
{
	CString CText;

	CText = CTextData;

// check and if already with _??

	CTextData = CTextData.Right(3);
	CTextData.MakeUpper();
	
	if(CTextData == "_MW") 
	{
		CDataBaseIdInfo.matched		= 0;
		CDataBaseIdInfo.strength	= 0;

		return CText;
	}
	if(CTextData == "_MN") 
	{
		CDataBaseIdInfo.matched		= 0;
		CDataBaseIdInfo.strength	= 1;

		return CText;
	}
	if(CTextData == "_MS") 
	{
		CDataBaseIdInfo.matched		= 0;
		CDataBaseIdInfo.strength	= 2;

		return CText;
	}
	if(CTextData == "_XW") 
	{
		CDataBaseIdInfo.matched		= 1;
		CDataBaseIdInfo.strength	= 0;

		return CText;
	}
	if(CTextData == "_XN") 
	{
		CDataBaseIdInfo.matched		= 1;
		CDataBaseIdInfo.strength	= 1;

		return CText;
	}
	if(CTextData == "_XS") 
	{
		CDataBaseIdInfo.matched		= 1;
		CDataBaseIdInfo.strength	= 2;

		return CText;
	}
	if(CTextData == "_UW") 
	{
		CDataBaseIdInfo.matched		= 2;
		CDataBaseIdInfo.strength	= 0;

		return CText;
	}
	if(CTextData == "_UN") 
	{
		CDataBaseIdInfo.matched		= 2;
		CDataBaseIdInfo.strength	= 1;

		return CText;
	}
	if(CTextData == "_US") 
	{
		CDataBaseIdInfo.matched		= 2;
		CDataBaseIdInfo.strength	= 2;

		return CText;
	}

	CText += '_';

	if(CDataBaseIdInfo.matched == 0) CText += 'M';
	else if (CDataBaseIdInfo.matched == 1) CText += 'X';
	else CText += 'U';

	if(CDataBaseIdInfo.strength == 0) CText += 'W';
	else if (CDataBaseIdInfo.strength == 1) CText += 'N';
	else CText += 'S';

	return CText;
}

bool TCSpiceParameters::SetFromText(CArray <CString, CString&> &CModelData)
{
	int count, count2, p, num_param;
	int num_words;
	int size_words;
	char** words;
	CString CModelType;
	int test_test;

	count = CModelData.GetSize();

	if(!count) return false;

	num_param	= CountCharacters(CModelData[0], '=');
	size_words	= CModelData[0].GetLength() + 1;

	num_words = num_param * 2 + 3;

	words = NewCharArray(1 + num_words, size_words);

	if(!words) return false;

	unique_parameters = false;

	strcpy(words[0], CModelData[0].GetBuffer(size_words));

	ExtractSpiceModelWords(words, num_words);

	CString CTemp;

	CTemp = words[1];

	CTemp.MakeUpper();

	CModelType = CTemp;

	if(CTemp != ".MODEL" && CTemp != ".LIB") 
	{
		DeleteCharArray(words, 1 + num_words);

		return false;
	}

	CDataBaseIdInfo.CRecordName = words[2];

	if(CDataBaseIdInfo.CRecordName == "")
	{
		DeleteCharArray(words, 1 + num_words);

		return false;
	}

	CDataBaseIdInfo.CRecordType = words[3];
	CDataBaseIdInfo.CRecordType.TrimLeft();

	if(CTemp != ".LIB")
	if(CDataBaseIdInfo.CRecordType == "")
	{
		DeleteCharArray(words, 1 + num_words);

		return false;
	}

	CArray <TCNameValueData, TCNameValueData &> CDataCopy;

	CDataCopy.SetSize(0, 32);

	TCNameValueData CNameValueData;

	count2 = num_words/2 - 1;

	char **p_data = &words[4];

	for(p = 0; p < count2; p++)
	{
		CNameValueData.CName = *p_data;

		if(CNameValueData.CName == "")
		{	
			continue; //	7th November 2004 Modified to support '=' in comments.
		}

		CTemp = *++p_data;

		if(CTemp == "")
		{	
			continue; //	7th November 2004 Modified to support '=' in comments.
		}

		test_test = 0;

		if(CTemp.Find('[') > -1)  test_test = 1;
		if(CTemp.Find('"') > -1)  test_test = 1;
		if(CTemp.Find('\'') > -1) test_test = 1;

		if(CTemp.Find('{') > -1)  
		{
			test_test = 1;

			unique_parameters = true; // Assume any {} data means that the model needs unique instance of the model
		}

		if(test_test) // This is a definite complier bug. The if() on the expression fails. 11th Nov 2014
//		if(CTemp.Find('[') > -1 || CTemp.Find('"') > -1 || CTemp.Find('\'') > -1 || CTemp.Find('{') > -1) 
		{
			CNameValueData.CValue = CTemp;// xspice arrays support and other xspice quoted strings

			CNameValueData.CValue.TrimRight();// remove anything after ] 6/12/2002

			CNameValueData.value = 0;

			CNameValueData.is_text_data = true;
		}
		else 
		{
			CNameValueData.value = SpiceMKSStringToFloat(CTemp);

			CNameValueData.CValue = "";

			CNameValueData.is_text_data = false;
		}

		CDataCopy.Add(CNameValueData);

		p_data++;
	}

	DeleteCharArray(words, 1 + num_words);


/////////// Scan the rest of the lines

	int		length;
	CString CTemp2;
	char char_test;

	for(int q = 1; q < count; q++)
	{
		CTemp = CModelData[q];

		CTemp.TrimLeft();

		length = CTemp.GetLength();

		if(!length) return true;

		char_test = CTemp.GetAt(0);

		if(char_test != '+' && char_test != '.' && char_test != '*') return true;

		CTemp2 = CTemp.Right(length - 1);

		CTemp2.TrimLeft();

		length = CTemp2.GetLength();

		if(!length) return true;

		num_param	= CountCharacters(CTemp, '=');
		size_words	= length + 1;

		if(!num_param) continue;

		num_words = num_param * 2;

		words = NewCharArray(1 + num_words, size_words);

		if(!words) return false;

		strcpy(words[0], CTemp2.GetBuffer(size_words));

		ExtractSpiceModelWords(words, num_words);

		p_data = &words[1];

		for(p = 0; p < num_param; p++)
		{
			CNameValueData.CName = *p_data;

			if(CNameValueData.CName == "")
			{		
				continue; //	7th November 2004 Modified to support '=' in comments.
			}

			CTemp2 = *++p_data;

			if(CTemp2 == "")
			{
				continue; //	7th November 2004 Modified to support '=' in comments.
			}
			
			test_test = 0;

			if(CTemp2.Find('[') > -1)  test_test = 1;
			if(CTemp2.Find('"') > -1)  test_test = 1;
			if(CTemp2.Find('\'') > -1) test_test = 1;

			if(CTemp.Find('{') > -1)  
			{
				test_test = 1;

				unique_parameters = true; // Assume any {} data means that the model needs unique instance of the model
			}

			if(test_test) // This is a definite complier bug. The if() on the expression fails. 11th Nov 2014
//			if((CTemp2.Find('[') > -1) || (CTemp2.Find('"') > -1) || (CTemp2.Find('\'') > -1) || (CTemp.Find('{') > -1) ) 
			{
				CNameValueData.CValue = CTemp2;// xspice arrays and string parameters support

				CNameValueData.CValue.TrimRight();// remove anything after ] 6/12/2002

				CNameValueData.value = 0; // removed why? then added Nov 2014, 

				CNameValueData.is_text_data = true;
			}
			else 
			{
				CNameValueData.value = SpiceMKSStringToFloat(CTemp2);

				CNameValueData.CValue = ""; // removed why? then added Nov 2014, 

				CNameValueData.is_text_data = false; 
			}
			
			CDataCopy.Add(CNameValueData);

			p_data++;
		}

		DeleteCharArray(words, 1 + num_words);
	}

	count = CDataCopy.GetSize();

	CData.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		CData[p] = CDataCopy[p];
	}

	return true;
}

bool TCSpiceParameters::GetToText(CArray <CString, CString&> &CModelData, int f_validate, bool f_exponent)
{
	if(CDataBaseIdInfo.model_type == E_SPICE_DOT_MODEL) return GetToModelText(CModelData, f_validate, f_exponent);

	return GetToSubCircuitText(CModelData, f_validate);
}

bool TCSpiceParameters::GetToModelText(CArray <CString, CString&> &CModelData, int f_validate, bool f_exponent)
{
	if(CDataBaseIdInfo.CRecordName == "") return false;

	if(CDataBaseIdInfo.CRecordType == "") return false;

	int count = CData.GetSize();// number of parameters

	if(!count) return false;

	CModelData.SetSize(0, 8);

	CString CText;

	CText = ".MODEL " + CDataBaseIdInfo.CRecordName + " ";
	CText += CDataBaseIdInfo.CRecordType + "(";

	int q = 0;

	CString CTempText;

	for(int p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = CData[p];

		if(f_validate) if(!Validate(CNameValueData)) continue;

		if(q == 8)// arbitary 8 parameters per line
		{
			if(p < count - 1)
			{
				CModelData.Add(CText);

				CText = "+ ";
			}
			else// added march 21 2000
			{
				if(!CNameValueData.is_text_data)
				{
					if(!f_exponent) CTempText = FloatToSpiceMKSString(CNameValueData.value);
					else CTempText.Format("%e", CNameValueData.value);

					CText += CNameValueData.CName + "=" +  CTempText + " ";
				}
				else// xspice support,  added March 31 2000
				{
					CText += CNameValueData.CName + "=" + CNameValueData.CValue + " ";
				}

				CText.TrimRight();

				CText += ')';

				CModelData.Add(CText);

				return true;
			}

			q = 0;
		}

		if(!CNameValueData.is_text_data)
		{
			if(!f_exponent) CTempText = FloatToSpiceMKSString(CNameValueData.value);
			else CTempText.Format("%e", CNameValueData.value);

			CText += CNameValueData.CName + "=" + CTempText + " ";
		}
		else // xspice support,  added March 31 2000, modified 23rd Jan 2003
		{
			CText += CNameValueData.CName + "=" + CNameValueData.CValue + " ";
		}

		q++;
	}

	CText.TrimRight();

	CText += ')';

	CModelData.Add(CText);

	return true;
}

CString TCSpiceParameters::GetRecordName(double width, double length)
{
	if(CDataBaseIdInfo.model_type != E_SPICE_DOT_MODEL) return CDataBaseIdInfo.CRecordName;

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(*this);

	if(!PCSpiceParameters) return CDataBaseIdInfo.CRecordName;
	
	return GCSuperSpiceDataBase.GetRecordName(*PCSpiceParameters, width, length);
}

bool TCSpiceParameters::Validate(TCNameValueData CNameValueData)
{
	double data = 0.0;

	CString CRecordType;
	CNameValueData.CName.MakeLower();

	CRecordType = CDataBaseIdInfo.CRecordType;

	CRecordType.MakeLower();

	if(CNameValueData.CName == GSSModelSymbolFileName) return false;
	if(CNameValueData.CName == GSSModelSymbolName) return false;
	if(CNameValueData.CName == GSSModelSymbolComment) return false;
	if(CNameValueData.CName == GSSWCFileName) return false;
	if(CNameValueData.CName == GSSWCModelName) return false;

	CDataBaseIdInfo.CRecordType.MakeLower();

	// PSpice support, L and W is on model line, not in the 
	if(CDataBaseIdInfo.CRecordType == "nmos" || CDataBaseIdInfo.CRecordType == "pmos" ||
	   CDataBaseIdInfo.CRecordType == "nmf" || CDataBaseIdInfo.CRecordType == "pmf")
	{
		if(!Get("Level", &data)) Set("Level", 1);

		if(CNameValueData.CName == "wd") return false;
		if(CNameValueData.CName == "ws") return false;
		if(CNameValueData.CName == "m") return false;

		if(data == 49 || data == 8)//HSpice support and eliminate unrecognised parameters
		{
			Set("Level", 8);

			if(CNameValueData.CName == "nlev") return false;
			if(CNameValueData.CName == "calcacm") return false;
			if(CNameValueData.CName == "sfvtflag") return false;
			if(CNameValueData.CName == "vfbflag") return false;
			if(CNameValueData.CName == "xl") return false;
			if(CNameValueData.CName == "xw") return false;
			if(CNameValueData.CName == "ldif") return false;
			if(CNameValueData.CName == "rs") return false;
			if(CNameValueData.CName == "rd") return false;
			if(CNameValueData.CName == "cta") return false;
			if(CNameValueData.CName == "ctp") return false;
			if(CNameValueData.CName == "pta") return false;
			if(CNameValueData.CName == "ptp") return false;
			if(CNameValueData.CName == "acm") return false;
			if(CNameValueData.CName == "nqsmod") return false;
			if(CNameValueData.CName == "n") return false;
			if(CNameValueData.CName == "tlev") return false;
			if(CNameValueData.CName == "tlevc") return false;
			if(CNameValueData.CName == "hdif") return false;// hdiff bug in xspice engine

		}
		if(data == 14)
		{
			if(CNameValueData.CName == "hdif") return false;
			if(CNameValueData.CName == "l") return false;
			if(CNameValueData.CName == "w") return false;
		}
	}

	else if(CDataBaseIdInfo.CRecordType == "njf" || CDataBaseIdInfo.CRecordType == "pjf")
	{
		if(CNameValueData.CName == "l") return false;
		if(CNameValueData.CName == "w") return false;

		// Ignore PSpice extensions

		if(CNameValueData.CName == "isr") return false;
		if(CNameValueData.CName == "n") return false;
		if(CNameValueData.CName == "alpha") return false;
		if(CNameValueData.CName == "vk") return false;
		if(CNameValueData.CName == "m") return false;
		if(CNameValueData.CName == "nr") return false;
	}
	else if(CDataBaseIdInfo.CRecordType == "r")
	{
		if(CNameValueData.CName == "l") return false;
		if(CNameValueData.CName == "w") return false;
		if(CNameValueData.CName == "r" && Get("rsh", &data)) return false;
	}

	else if(CDataBaseIdInfo.CRecordType == "c")
	{
		if(CNameValueData.CName == "c" && Get("cj", &data)) return false;
		if(CNameValueData.CName == "l") return false;
		if(CNameValueData.CName == "w") return false;
	}

	else if(CDataBaseIdInfo.CRecordType == "npn" || CDataBaseIdInfo.CRecordType == "pnp")
	{
		if(CNameValueData.CName == "area") return false;
		if(CNameValueData.CName == "m") return false;
		if(CNameValueData.CName == "lmax") return false;
		if(CNameValueData.CName == "lmin") return false;
		if(CNameValueData.CName == "wmin") return false;
		if(CNameValueData.CName == "wmax") return false;

		//hspice rubbish
		if(CNameValueData.CName == "tlev") return false;
		if(CNameValueData.CName == "tlevc") return false;
		if(CNameValueData.CName == "tref") return false;
		if(CNameValueData.CName == "tbf1") return false;
		if(CNameValueData.CName == "tbf2") return false;
		if(CNameValueData.CName == "tbr1") return false;
		if(CNameValueData.CName == "tbr2") return false;
		if(CNameValueData.CName == "tne1") return false;
		if(CNameValueData.CName == "cte") return false;
		if(CNameValueData.CName == "tvjc") return false;
		if(CNameValueData.CName == "tvje") return false;
		if(CNameValueData.CName == "ctc") return false;
		if(CNameValueData.CName == "subs") return false;
		if(CNameValueData.CName == "tnf1") return false;
		if(CNameValueData.CName == "tnc1") return false;
		if(CNameValueData.CName == "tnc2") return false;
		if(CNameValueData.CName == "tnr1") return false;
		if(CNameValueData.CName == "tnr2") return false;
	}

	else if(CDataBaseIdInfo.CRecordType == "d")
	{
		//PSpice
		if(CNameValueData.CName == "isr") return false;
		if(CNameValueData.CName == "nr") return false;
		//hspice rubbish
		if(CNameValueData.CName == "tlev") return false;
		if(CNameValueData.CName == "tlevc") return false;
		if(CNameValueData.CName == "tref") return false;
		if(CNameValueData.CName == "ik") return false;
		if(CNameValueData.CName == "ikr") return false;
		if(CNameValueData.CName == "jsw") return false;
		if(CNameValueData.CName == "area") return false;
		if(CNameValueData.CName == "pj") return false;
		if(CNameValueData.CName == "cj") return false;
		if(CNameValueData.CName == "pb") return false;
		if(CNameValueData.CName == "cjsw") return false;
		if(CNameValueData.CName == "php") return false;
		if(CNameValueData.CName == "mjsw") return false;
		if(CNameValueData.CName == "tcv") return false;
		if(CNameValueData.CName == "trs") return false;
		if(CNameValueData.CName == "cta") return false;
		if(CNameValueData.CName == "tpb") return false;
		if(CNameValueData.CName == "fcs") return false;
		if(CNameValueData.CName == "ctp") return false;
		if(CNameValueData.CName == "tphp") return false;
	}

	return true;
}
 
bool TCSpiceParameters::ValidateSubCktLine(CString &CSubCktLine)
{
	CString CTest, CCopyTest;
	CTest = CSubCktLine;

	CTest.TrimLeft();
	CTest.TrimRight();
	CTest.MakeLower();

	CCopyTest = CTest;

	if(CCopyTest == "") return true;

	if(CCopyTest.GetAt(0) == '*') return true;
	
	CCopyTest = CCopyTest.Left(6);

	if(CCopyTest == ".param") return false;

	int index = CSubCktLine.Find(';');// remove anything after ; as a comment
	
	if(index > -1) CSubCktLine = CSubCktLine.Left(index);

	return true;
}

bool TCSpiceParameters::MosfetDesigner(double vds, double vgs, double vbs, double id, int type, double &value)
{
	double sign=1;
	if(!id) return false;
	if(!value) return false;

	if(CDataBaseIdInfo.CRecordType.GetAt(0) == 'P' || CDataBaseIdInfo.CRecordType.GetAt(0) == 'p') sign= -1;

	vds *= sign;
	vgs *= sign;
	vbs *= sign;
	id  *= sign;

	double level = 1;

	Get("level", &level);

	switch((int)level)
	{
		case 1: return Mos1Designer(vds, vgs, vbs, id, type, value);
		case 2: return Mos2Designer(vds, vgs, vbs, id, type, value);
		case 8: return MosBSim3Designer(vds, vgs, vbs, id, value);
	}

	return false;
}

bool TCSpiceParameters::Mos1Designer(double vds, double vgs, double vbs, double id, int type, double &value)
{
	double kp=20e-6, vto=0, x=0, lambda=0, vgst, ro_factor, sign=1, ld =0, phi=0.6,gamma=0;

	Get("kp", &kp);
	Get("vto", &vto);
	Get("lambda", &lambda);
	Get("ld", &ld);
	Get("phi", &phi);
	Get("gamma", &gamma);


	if(phi < 0) phi =-phi;

	if(CDataBaseIdInfo.CRecordType.GetAt(0) == 'P' || CDataBaseIdInfo.CRecordType.GetAt(0) == 'p') sign= -1;

	vto *= sign;

	if(!(phi-vbs < 0) && !(phi < 0))
		vto = vto + gamma*(sqrt(phi-vbs) - sqrt(phi));

	vgst = vgs - vto;

	ro_factor = (1+lambda*vds);

	if(vds >= vgst)  x = kp/2*ro_factor*vgst*vgst/id;			//satuation region
	else			 x = kp*ro_factor*vds*(vgst - vds/2)/id;    // linear region

	if(type == E_COMPONENT_FET_WIDTH) 
	{
		if(x) value = value/x;

		else return false;
	}
	else
	{
		value = value*x;

		value += 2*ld;
	}
	
	return true;
}

bool TCSpiceParameters::Mos2Designer(double vds, double vgs, double vbs, double id, int type, double &value)
{
	double kp=20e-6, vto=0, x=0, lambda=0, phi=0.6, gamma=0, vgst, ro_factor=0, sign=1;
	double ld=0, vdsat, body, bodys, bsarg, vbin, sarg3, Tox, Cox=0, U0=600;

	if(!id) return false;

	if(!Get("kp", &kp))// not all implemented
	{
		if(Get("Tox", &Tox) && Get("U0", &U0))
		{						
			U0 *=1e-4;

			if(Tox)	Cox = BSim3v3EpsilonOxide/Tox;

			kp = U0*Cox;
		}
	}

	Get("vto", &vto);
	Get("lambda", &lambda);
	Get("phi", &phi);
	Get("gamma", &gamma); //gamma = GetMosGamma();

	if(CDataBaseIdInfo.CRecordType.GetAt(0) == 'P' || CDataBaseIdInfo.CRecordType.GetAt(0) == 'p') sign= -1;

	vto *= sign;

	vbin = GetMos2Vbi(vto, gamma, phi);//vbin ~vbi

	vdsat = GetMos2Vdsat(gamma, phi, vgs, vbs, vbin);

	vgst = vgs - vto;

	ro_factor = 1.0-lambda*vds;

	if(ro_factor) ro_factor = 1/ro_factor;
	else ro_factor = 0;

	double barg = sqrt(phi  - vbs + vds);

	double sarg = sqrt(phi - vbs);

	sarg3 = sarg*sarg*sarg;

	body = barg*barg*barg-sarg3;

	if ((vbs-vdsat) <= 0) 
	{
		bsarg = sqrt(vdsat + phi - vbs);            
    } 
	else 
	{
		bsarg = sqrt(phi)/(1.0 + 0.5*(vbs-vdsat)/phi);
	}

	bodys = bsarg*bsarg*bsarg-sarg3;

	if(vds <= vdsat) //linear region
	{
		x = kp*ro_factor*((vgs - vbin - vds/2.0)*vds-gamma*body/1.5);
    } 
	else //saturation region
	{
        x = kp*ro_factor*((vgs - vbin - vdsat/2.0)*vdsat-gamma*bodys/1.5);
	}

	x /= id;

	if(type == E_COMPONENT_FET_WIDTH) 
	{
		if(x) value = value/x;

		else return false;
	}
	else 
	{
		value = value*x;

		value += 2*ld;
	}
	
	return true;
}

double TCSpiceParameters::GetMos2Vdsat(double gamma, double phi, double vgs, double vbs, double vbin)
{
	double vdsat, arg, argv;

	if(!gamma) return vgs - vbin;
           
	argv = vgs - vbin + phi - vbs;
                
	if (argv <= 0.0) return 0.0;
     
	arg = sqrt(1.0+4.0*argv/gamma/gamma);
                    
	vdsat = (vgs - vbin) + gamma*gamma*(1.0-arg)/2.0;
                                                         
	if(vdsat < 0) return 0;

	return vdsat;
}

double TCSpiceParameters::GetMos2Vbi(double vt0, double gamma, double phi)
{
	double vbi;

	vbi = vt0 - gamma* sqrt(phi);

	return vbi;
}

bool TCSpiceParameters::MosBSim3Designer(double Vds, double Vgs, double Vbs, double id, double &value)
{
	double Vth, x=0, Tox, Cox, Idso, Leff, Vt, Vgsteff, Vasat, Rds, Weff=0.33e-6;
	double Vdsat, ueff, Vdseff, Esat, Vaclm, Phi, Vbseff=0, Va, Vadiblc, Vascbe, Abulk;

	if(!id) return false;

	if(!Get("Tox", &Tox))return false;
 
	Cox = BSim3v3EpsilonOxide/Tox;

	Vt		= GetThermalVt(300.15);
	Phi		= GetBSimPhi();
	Leff	= GetBSimLeff(value, Weff);
	Vbseff  = GetBSimVbseff(Vbs, Leff, Weff);
	Vth		= GetBSimVth(Vbseff, Vds, Leff, Weff);		
	Vgsteff = GetBSimVgseff(Vgs, Vth, Cox, Vbseff, Leff, Weff);
	Rds		= GetBSimRds(Vgsteff, Vbseff, Weff);
	Abulk   = GetBSimAbulk(Vgsteff, Vbseff, Leff, Weff);
	ueff	= GetBSimUeff(Vgsteff, Vth, Tox, Leff, Weff);
	Esat	= GetBSimEsat(ueff, Leff, Weff);
	Vdsat	= GetBSimVdsat(Leff, Weff, Esat, Vgsteff, Abulk, Rds);
	Vdseff	= GetBSimVdseff(Vds, Vdsat);
	Vasat	= GetBSimVasat(Vgsteff, Esat, Leff, Weff, Vdsat, Rds, Abulk);
	Vaclm	= GetBSimAclm(Esat, Vgsteff, Vds, Vdseff, Leff, Weff, Abulk);
	Vadiblc = GetBSimVadiblc(Vgsteff, Vdsat, Leff, Weff, Abulk, Vbseff);
	Va		= GetBSinVa(Vasat, Vgsteff, Vaclm, Vadiblc, Esat, Leff);
	Vascbe	= GetBSimVascbe(Vds,Vdseff, Leff);

	Idso = Cox*ueff*Vgsteff*Vdseff*(1 - Abulk*Vdseff/(Vgsteff+2*Vt)/2)/(1 + Vdseff/Esat/Leff);

	x = Idso*(1 + (Vds-Vdseff)/Va)*(1 + (Vds-Vdseff)/Vascbe)/id/(1 + Rds*Idso/Vdseff);

	if(!x) return false;

	double length = value;

	value = Leff/x; //effective width

	value = GetBSimW(value, length);

	return true;
}

double TCSpiceParameters::GetMosGamma(void)
{
	double NSub=1e15, Cox, Tox=1.0e-7, gamma;

	Get("NSub", &NSub);
	Get("Tox", &Tox);

	if(NSub < 0) NSub =-NSub;

	if(!Tox) Tox = Tox=1.0e-7;

	Cox = BSim3v3EpsilonOxide/Tox;

	gamma = sqrt(2*ElectronCharge*BSim3v3EpsilonSI*NSub)/Cox;

	return gamma;
}

double TCSpiceParameters::GetBSimN(double Cox, double Vbseff, double Leff, double Weff)
{
	double N, NFactor=1, Xdep, Cit=0, Cdsc=0, Phi;

	Get("NFactor", &NFactor);
	Get("Cdsc", &Cdsc);

	Phi = GetBSimPhi();

	Cit = GetBSimEffParam("Cit", Leff, Weff);

	Xdep = GetBSimXdep(Vbseff);

	N = 1 + (NFactor*BSim3v3EpsilonSI/Xdep + Cit + Cdsc)/Cox;

	return N;
}

double TCSpiceParameters::GetThermalVt(double Temp)
{
	return BoltzmansConstant*Temp/ElectronCharge;
}

double TCSpiceParameters::GetBSimEffParam(CString CParam, double effective_length, double effective_width)
{
	double param = 0, data;
	CString CParamX;

	CParamX = CParam;

	Get(CParamX, &data);

	param = data;

	CParamX = 'L' + CParam;

	data = 0;

	Get(CParamX, &data);

	if(effective_length) param += data/effective_length;

	CParamX = 'W' + CParam;

	data = 0;

	Get(CParamX, &data);

	if(effective_width) param += data/effective_width;

	CParamX = 'P' + CParam;

	data = 0;

	Get(CParamX, &data);

	if(effective_width && effective_length) param += data/effective_width/effective_length;
	
	return param;
}

double TCSpiceParameters::GetBSimXdep(double vbseff)
{
	double Xdep, Phi, Nch=1.7e17;

	if(!Get("Nch", &Nch)) Get("Nsub", &Nch) ;

	if(!Nch) Nch=1.7e17;

	Phi = GetBSimPhi();

	Xdep = sqrt(2.0 * BSim3v3EpsilonSI / (ElectronCharge * Nch * 1.0e6)) * sqrt(Phi - vbseff);

	return Xdep;
}

double TCSpiceParameters::GetBSimXdep0(void)
{
	return GetBSimXdep(0);
}

double TCSpiceParameters::GetBSimNi(double Tnom)
{
	double Eg0, ni;

	if(!Tnom) Tnom = 300.15;

	Eg0 = 1.16 - 7.02e-4 * Tnom * Tnom / (Tnom + 1108.0); 

    ni = 1.45e10 * (Tnom / 300.15) * sqrt(Tnom / 300.15) * exp(21.5565981 - Eg0 / (2.0 * KboQ * Tnom));

	return ni;
}

double TCSpiceParameters::GetBSimVbi(double Tnom)
{
	double  Vtm0, ni, Vbi, Nch=1.7e17;

	if(!Get("Nch", &Nch))
	{
		Get("NSUB", &Nch);
	}

	Vtm0 = KboQ * Tnom;

	ni = GetBSimNi(Tnom);

	Vbi = Vtm0 * log(1.0e20* Nch / (ni * ni));

	return Vbi;
}

double TCSpiceParameters::GetBSimPhi(void)
{
	double Nch = 1e15, ni,  Phi, Tnom = 27;

	if(!Get("Nch", &Nch))
	{
		Get("NSUB", &Nch);
	}

	Get("TNOM", &Tnom);

	Tnom += 273.15;

	ni = GetBSimNi(Tnom);

	Phi = 2.0 * KboQ * Tnom * log(Nch / ni);

	return Phi;
}

double TCSpiceParameters::GetBSimW(double Weff, double L)
{
	double W = Weff;
	double dw, Wint, Wl=0, Ww=0, Wwl=0, Wwn=1, Wln=1, T0, T1;

	Get("WINT", &Wint);
	Get("WL",	&Wl);
	Get("WW",	&Ww);
	Get("WWL",	&Wwl);
	Get("Wln",	&Wln);
	Get("Wwn",	&Wwn);

    T0 = pow(L, Wln);
	T1 = pow(W, Wwn);
 
	dw = Wint;

	if(T0) dw += Wl / T0;
		
	if(T1) dw += Ww / T1;
		
	if(T0 && T1) dw += Wwl / (T0 * T1);                

	W = Weff + 2*dw;

	return W;
}

double TCSpiceParameters::GetBSimLeff(double L, double W)
{
	double Leff;
	double dl, Lint, Ll=0, Lw=0, Lwl=0, Lwn=1, Lln=1, T0, T1;

	Get("LINT", &Lint);
	Get("LL",	&Ll);
	Get("LW",	&Lw);
	Get("LWL",	&Lwl);
	Get("Lln",	&Lln);
	Get("Lwn",	&Lwn);

	T0 = pow(L, Lln);
    T1 = pow(W, Lwn);

    dl = Lint;
		
	if(T0) dl += Ll / T0; 
		
	if(T1) dl += Lw / T1; 
		
	if(T0 && T1) dl	+= Lwl / (T0 * T1);

	Leff = L - 2*dl; 

	return Leff;
}

double TCSpiceParameters::GetBSimVbseff(double Vbs, double Leff, double Weff)
{
	double Vbseff=0, Vbc=0, K1=0, K2=0, Phi, delta=0;

	Get("Delta", &delta);

	K1 = GetBSimEffParam("K1", Leff, Weff);
	K2 = GetBSimEffParam("K2", Leff, Weff);

	Phi = GetBSimPhi();

	if (K2 < 0.0)	  
	{                 
		Vbc = 0.9 * (Phi - 0.25*(K1/K2)*(K1/K2));
		      
		if(Vbc > -3.0) Vbc = -3.0;
		else if (Vbc < -30.0) Vbc = -30.0;
	}
	else
	{   
		Vbc = -30.0;	  
	}


//	if(K2) Vbc = 0.9*(Phi-0.25*(K1/K2)*(K1/K2));

	Vbseff = Vbc + (Vbs - Vbc - delta + sqrt((Vbs - Vbc - delta)*(Vbs - Vbc - delta) - 4* delta*Vbc))*0.5;

	return Vbseff;
}

double TCSpiceParameters::GetBSimVth(double Vbseff, double Vds, double Leff, double Weff)
{
	double Vth, Vth0, phi, K1, K2, Nlx=0, Tox=1e-9, W0=0, K3=0,K3b=0;
	double Dvt0w=0, Vbi, Dvt1w=0, Dvt2w, Xdep, Xdep0, lt, Cox, Dvt2=0, ltw, lt0;
	double Dvt0=0, Dvt1=0, Etab=0, Eta0=0, Dsub=0, sign = 1;
	
	Get("Nlx", &Nlx);
	Get("Tox", &Tox);
	Get("W0", &W0);
	Get("K3", &K3);
	Get("K3b", &K3b);
	Get("Dvt0w", &Dvt0w);
	Get("Dvt1w", &Dvt1w);
	Get("Dvt2w", &Dvt2w);
	Get("Dvt1", &Dvt1);
	Get("Dvt0", &Dvt0);
	Get("Etab", &Etab);
	Get("Eta0", &Eta0);
	Get("Dsub", &Dsub);

	Vth0 = GetBSimEffParam("Vth0", Leff, Weff);

	if(CDataBaseIdInfo.CRecordType.GetAt(0) == 'P' || CDataBaseIdInfo.CRecordType.GetAt(0) == 'p') sign= -1;

	K1 = GetBSimEffParam("K1", Leff, Weff);
	K2 = GetBSimEffParam("K2", Leff, Weff);

	Cox = BSim3v3EpsilonOxide/Tox;

	phi = GetBSimPhi();
	Vbi = GetBSimVbi(300.15);
	Xdep = GetBSimXdep(Vbseff);
	Xdep0 = GetBSimXdep0();

	lt = sqrt(BSim3v3EpsilonSI*Xdep/Cox)*(1+Dvt2*Vbseff);
	ltw = sqrt(BSim3v3EpsilonSI*Xdep/Cox)*(1+Dvt2w*Vbseff);
	lt0 = sqrt(BSim3v3EpsilonSI*Xdep0/Cox);

	Vth = Vth0*sign - K1*sqrt(phi) + K1*sqrt(phi - Vbseff) - K2*Vbseff;

	if(!Leff) return Vth;

	Vth += K1*sqrt(phi)*(sqrt(1 + Nlx/Leff) - 1);
	
	if(Weff + W0) Vth += (K3 + K3b*Vbseff)*Tox*phi/(Weff + W0);
	
	if(ltw) Vth -= Dvt0w*(exp(-Dvt1w*Leff*Weff/2/ltw) +2*exp(-Dvt1w*Leff*Weff/ltw))*(Vbi-phi);

	if(lt) Vth -= Dvt0*(exp(-Dvt1*Leff/lt/2) + 2*exp(-Dvt1*Leff/lt))*(Vbi-phi);

	Vth -= (exp(-Dsub*Leff/2/lt0) +2*exp(-Dsub*Leff/lt0))*(Eta0+Etab*Vbseff)*Vds;

	return Vth;
}

double TCSpiceParameters::GetBSimVgseff(double Vgs, double Vth, double Cox, double Vbseff, double Leff, double Weff)
{
	double Vgsteff, Nch, N, Vt, a, numerator, denominator=1, Voff=0, Phi;
	double b, c;

	Get("Nch", &Nch);

	Voff = GetBSimEffParam("Voff", Leff, Weff);

	if(!Nch) Nch = 1e17;

	N = GetBSimN(Cox, Vbseff, Leff, Weff);
	Vt = GetThermalVt(300.15);
	Phi = GetBSimPhi();

	numerator = 2*N*Vt*log(1 + exp((Vgs-Vth)/2/N/Vt));

	a = 2*N*Cox;

	b = exp(-(Vgs-Vth-2*Voff)/2/N/Vt);

	c = sqrt(2*Phi/ElectronCharge/Nch/BSim3v3EpsilonSI/1e6);

	denominator = 1 + a*b*c;

	Vgsteff = numerator/denominator;

	return Vgsteff;
}

double TCSpiceParameters::GetBSimAbulk(double Vgsteff, double vbseff, double Leff, double Weff)
{
	double Abulk, A0, Xj, Ags, term0, term1, term2, lterm, Phi, K1=0.5, Tox, Xdep;
	double B0=0, B1=0, Keta;

	Get("A0", &A0);
	Get("Xj", &Xj);
	Get("Ags", &Ags);
	Get("K1", &K1);
	Get("Tox", &Tox);
	Get("B0", &B0);
	Get("B1", &B1);

	A0	= GetBSimEffParam("A0", Leff, Weff);
	K1	= GetBSimEffParam("K1", Leff, Weff);
	Ags = GetBSimEffParam("Ags", Leff, Weff);
	Keta = GetBSimEffParam("Keta", Leff, Weff);

	Phi = GetBSimPhi();

	if(!Phi) Phi = 1;

	Xdep = GetBSimXdep(vbseff);

	lterm = Leff/(Leff+2*sqrt(Xj*Xdep));

	term0 = (1 - Ags*Vgsteff*lterm*lterm);

	term1 = A0*lterm; 

	if(B1+Weff) term1 += B0/(B1+Weff);//approximate Weff.

	term2 = K1/2/sqrt(Phi - vbseff);

	Abulk = term0*term1*term2;
	
	Abulk += 1;

	if(Keta*vbseff) Abulk *= 1/(1+Keta*vbseff);

	return Abulk;
}

double TCSpiceParameters::GetBSimUeff(double Vgsteff, double Vth, double Tox, double Leff, double Weff)
{
	double U0=400, Ua=0, Ub=0, ueff, tratio, Ute=-2, Tnom, div, T3, T5;

	Get("U0", &U0);
	Get("Ua", &Ua);
	Get("Ub", &Ub);
	Get("TNOM", &Tnom);
	Get("Ute", &Ute);

	U0 = GetBSimEffParam("U0", Leff, Weff);
	Ua = GetBSimEffParam("Ua", Leff, Weff);
	Ub = GetBSimEffParam("Ub", Leff, Weff);

	Tnom += 273.15;

	if(!Tnom) Tnom = 298.15;

	tratio = 300.15/Tnom; //need to get temp of circuit default is 27deg.

	U0 = U0 * pow(tratio, Ute);

	if(U0 > 1) U0 *= 1e-4;// automatic units conversion
	
	T3 = (Vgsteff + 2*Vth)/ Tox;
	T5 = T3 * (Ua + Ub * T3);

	if (T5 >= -0.8) div = 1.0 + T5;
	else div = (0.6 + T5) * (1.0 / (7.0 + 10.0 * T5));

    ueff = U0 / div;

	return ueff;
}

double TCSpiceParameters::GetBSimEsat(double ueff, double Leff, double Weff)
{
	double Esat;
	double Vsat=100000;

	Get("Vsat", &Vsat);
	
	Vsat = GetBSimEffParam("Vsat", Leff, Weff);

	Esat = 2*Vsat/ueff;

	return Esat;
}

double TCSpiceParameters::GetBSimVdsat(double Leff, double Weff, double Esat, double Vgsteff, double Abulk, double Rds)
{
	double Vdsat, Vt, A1=0, A2=0, a, b, c, lambda, Vsat=0, Cox, Tox=1e-9;

	Get("A1", &A1);
	Get("A2", &A2);
	Get("Tox", &Tox);

	if(!Tox) Tox=1e-9;

	Cox = BSim3v3EpsilonOxide/Tox;

	Vsat = GetBSimEffParam("Vsat", Leff, Weff);

	Vt = GetThermalVt(300.15);

	lambda = A1*Vgsteff + A2;

	if((!Rds && lambda == 1) || !lambda)
	{
		Vdsat = Esat * Leff * (Vgsteff + 2*Vt)/(Abulk *Esat * Leff + (Vgsteff + 2*Vt));

		return Vdsat;
	}


	a = Abulk*Abulk*Weff*Vsat*Cox*Rds + (1/lambda - 1)*Abulk;

	if(!a) return 0.1;//error

	b = (Vgsteff + 2*Vt)*(2/lambda-1) +  Abulk * Esat * Leff +3*Abulk*(Vgsteff + 2*Vt)*Weff*Vsat*Cox*Rds;

	b = -b;

	c = (Vgsteff + 2*Vt)*Esat * Leff + 2*(Vgsteff + 2*Vt)*(Vgsteff + 2*Vt)*Weff*Vsat*Cox*Rds;

	Vdsat = (-b - sqrt(b*b-4*a*c))/2/a;

	return Vdsat;
}

double TCSpiceParameters::GetBSimVdseff(double vds, double Vdsat)
{
	double Delta = 0;
	double Vdeff;

	Get("Delta", &Delta);

	Vdeff = Vdsat - (Vdsat - vds - Delta + sqrt((Vdsat - vds - Delta)*(Vdsat - vds - Delta) + 4*Delta*Vdsat))/2;

	return Vdeff;
}

double TCSpiceParameters::GetBSimVasat(double Vgsteff, double Esat, double Leff, double Weff, double Vdsat, double Rds, double Abulk)
{
	double Vasat, A1=0, A2=1, term1, term2, lambda,Vsat=100e3, Tox, Cox, Vt;

	Get("A1", &A1);
	Get("A2", &A2);
	Get("Tox", &Tox);

	if(!Tox) Tox=1e-9;

	Cox = BSim3v3EpsilonOxide/Tox;

	Vsat = GetBSimEffParam("Vsat", Leff, Weff);

	Vt = GetThermalVt(300.15);

	lambda = A1*Vgsteff + A2;

	if(!lambda)
	{
		return Esat*Leff + Vdsat;
	}

	term1 = Esat*Leff + Vdsat + 2*Rds*Vsat*Cox*Weff*Vgsteff*(1 - Abulk*Vdsat/2/(Vgsteff + 2*Vt));

	term2 = 2/lambda - 1 + Rds*Vsat*Cox*Weff*Abulk;
	 
	if(!term2)
	{
		return Esat*Leff + Vdsat;
	}

	Vasat = term1/term2;

	return Vasat;
}

double TCSpiceParameters::GetBSimAclm(double Esat, double Vgsteff, double Vds, double Vdseff, double Leff, double Weff, double Abulk)
{
	double Vaclm, Xj, litl,Tox, Pclm=1;

	Get("Xj", &Xj);

	if(!Get("Tox", &Tox))return false;

	Pclm = GetBSimEffParam("Pclm", Leff, Weff);

	litl = sqrt(3*Xj*Tox);

	Vaclm = (Abulk*Esat*Leff+Vgsteff)*(Vds-Vdseff)/(Pclm*Abulk*Esat*litl);

	return Vaclm;
}

double TCSpiceParameters::GetBSimVadiblc(double Vgsteff, double Vdsat, double Leff, double Weff, double Abulk, double Vbseff)
{
	double Pdiblc1=0, Vt, theata_rout, Vadiblc, Tox=1e-9;
	double Pdiblc2=0, Pdiblcb=0, Drout=0, Xdep0, lt0, Cox;

	Pdiblc1 = GetBSimEffParam("Pdiblc1", Leff, Weff);
	Pdiblc2 = GetBSimEffParam("Pdiblc2", Leff, Weff);

	Get("Pdiblcb", &Pdiblcb);
	Get("Drout", &Drout);
	Get("Tox", &Tox);

	if(!Tox) Tox=1e-9;

	Xdep0 = GetBSimXdep0();

	Cox = BSim3v3EpsilonOxide/Tox;

	lt0 = sqrt(BSim3v3EpsilonSI*Xdep0/Cox);

	Vt = GetThermalVt(300.15);

	theata_rout = Pdiblc1*(exp(-Drout*Leff/2/lt0) + 2*exp(-Drout*Leff/lt0)) + Pdiblc2;

	if(!theata_rout) theata_rout = 1;

	Vadiblc = (Vgsteff + 2*Vt)*(1 - Abulk*Vdsat/(Abulk*Vdsat + Vgsteff + 2*Vt))/theata_rout/(1+Pdiblcb*Vbseff);

	return Vadiblc;
}

double TCSpiceParameters::GetBSinVa(double Vasat, double Vgsteff, double Vaclm, double vadiblc, double Esat, double Leff)
{
	double Va, Pvag=0;

	Get("Pvag", &Pvag);

	if(!Vaclm) Vaclm=1;
	if(!vadiblc) vadiblc = 1;

	Va = Vasat + (1 + Pvag*Vgsteff/Esat/Leff)/(1/Vaclm + 1/vadiblc);

	return Va;
}

double TCSpiceParameters::GetBSimVascbe(double vds, double vdseff, double Leff)
{
	double Vascbe, Pscbe1, Pscbe2;
	double Xj, litl,Tox=1e-9;

	if(!(vds - vdseff)) return 1;
	if(!Leff) return 1;

	Get("Pscbe1", &Pscbe1);
	Get("Pscbe2", &Pscbe2);
	Get("Xj", &Xj);
	Get("Tox", &Tox);

	if(!Tox) Tox=1e-9;

	litl = sqrt(3*Xj*Tox);

	if(!(vds - vdseff)) return 100;

	Vascbe = Pscbe2/Leff*exp(-Pscbe1*litl/(vds - vdseff));

	return 1/Vascbe;
}

double TCSpiceParameters::GetBSimRds(double Vgsteff, double Vbsteff, double Weff)
{
	double Rdsw=0, Rds0, Rds, Wr=1, Prwg=0, Prwb=0, phi; //Prt=0, 

	Get("Rdsw", &Rdsw);//ignore temp depandance for now
//	Get("Prt", &Prt);
	Get("Wr", &Wr);
	Get("Prwg", &Prwg);
	Get("Prwb", &Prwb);

	phi = GetBSimPhi();

//	(Rdsw + Prt * T0) T0 = (TRatio - 1.0);//ignore temp depandance for now

	Rds0 = Rdsw / pow(Weff * 1E6, Wr);

	Rds = Rds0*(1 + Prwg*Vgsteff + Prwb*(sqrt(phi-Vbsteff)-sqrt(phi)));

	return Rds;
}

bool TCSpiceParameters::IsEmpty(void)
{
	int count = CData.GetSize();

	if(!count) return true;

	if(CDataBaseIdInfo.model_type == E_SPICE_DOT_SUBCIRCUIT)
	{
		if(count < 3) return true;
		else return false;
	}
	
	int counter = 0;
	CString CTemp;

	if(Get(GSSModelSymbolFileName, &CTemp)) counter++;
	if(Get(GSSModelSymbolName, &CTemp)) counter++;
	if(Get(GSSModelSymbolComment, &CTemp)) counter++;
		
	if(count > counter) return false;	

	return true;
}

bool TCSpiceParameters::GetToSubCircuitText(CArray <CString, CString&> &CModelData, int f_validate)
{
	int count = CData.GetSize();// number of lines

	if(!count) return false;

	int offset = 0;
	
	CString CText = ".Lib ";

	if(CDataBaseIdInfo.model_type == E_SPICE_DOT_HSPICELIB)
	{
		count += 2;

		offset = 1;

		CModelData.SetSize(count, count);

		CText += CDataBaseIdInfo.CRecordName;

		CModelData[0] = CText;

		CModelData[count - 1] = ".EndL";
	}

	else CModelData.SetSize(count, count);

	for(int p = offset; p < count - 2*offset; p++)
	{
		if(CDataBaseIdInfo.model_type == E_SPICE_DOT_SUBCIRCUIT)
		{
			if(f_validate)
			{
				if(!ValidateSubCktLine(CData[p].CName)) 
				{
					CModelData[p] = "*";

					continue;
				}
			}

			CModelData[p] = CData[p].CName;
		}
		else //HSpice .lib support
		{
			CModelData[p] = CData[p].CName;

			if(!CData[p].is_text_data) CModelData[p] += '=' + FloatToSpiceMKSString(CData[p].value);
		}	
	}

	if(f_validate) if(CDataBaseIdInfo.model_type == E_SPICE_DOT_SUBCIRCUIT) FlattenSubckts(CModelData);

	return true;
}

void TCSpiceParameters::FlattenSubckts(CArray <CString, CString&> &CModelData)
{
	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flatten_nested_subckts) return;

	CArray <CString, CString&> CModelAccumelateData, CSubcktAccumelateData;
	CString CTest;

	int line_count;

	line_count = CModelData.GetSize();

	if(line_count < 2) return;

	CModelAccumelateData.SetSize(1);

	CModelAccumelateData[0] = CModelData[0];

	int p;

	for(p = 1; p < line_count; p++)// assume only one nest level
	{
		CTest = GetFirstWord(CModelData[p]);

		CTest.MakeLower();

		if(CTest == ".subckt")
		{
			CSubcktAccumelateData.Add(CModelData[p]);

			p++;

			for(; p < line_count; p++)
			{
				CTest = GetFirstWord(CModelData[p]);

				CTest.MakeLower();

				if(CTest == ".ends") 
				{
					CSubcktAccumelateData.Add(CModelData[p]);

					break;
				}

				else CSubcktAccumelateData.Add(CModelData[p]);
			}
		}

		else CModelAccumelateData.Add(CModelData[p]);
	}

	int accum_line_count = CModelAccumelateData.GetSize();

	int sub_line_count = CSubcktAccumelateData.GetSize();

	int new_line_count = accum_line_count + sub_line_count;

	if(new_line_count != line_count)
	{
		ASSERT(0);

		return;
	}

	for(p = 1; p < accum_line_count; p++) CModelData[p] = CModelAccumelateData[p];

	for(p = 0; p < sub_line_count; p++) CModelData[p + accum_line_count] = CSubcktAccumelateData[p];
}

bool TCSpiceParameters::Get(CString CText, double *data)
{
	int id;

	id = Find(CText);

	if(id < 0) return false;

	EvaluateModelParameters(CSymbolParameters, id); // Contains the individule symbol parameter line

	*data = CData[id].value;

	return true;
}

void TCSpiceParameters::SetInclude(CString CText, int include)
{
	int id;

	id = Find(CText);

	if(id < 0) return;

	CData[id].include = include;
}

bool TCSpiceParameters::Set(CString CText, double data)
{
	int id;

	if(CDataBaseIdInfo.CRecordType == "nmos" || CDataBaseIdInfo.CRecordType == "pmos")
	{
		CString CTextLocal = CText;// dont allow zero length and width to be set

		CTextLocal.MakeLower();

		if(CTextLocal == "l") if(!data) return false;
		if(CTextLocal == "w") if(!data) return false;
	}

	id = Find(CText);

	if(id < 0) 
	{
		TCNameValueData CNameValueData;

		CNameValueData.CName = CText;
		CNameValueData.value = data;
		CNameValueData.is_text_data = false;

		CData.Add(CNameValueData);
			
		return true;
	}

	CData[id].value = data;

	return true;
}

bool TCSpiceParameters::Get(CString CText, CString *CValue)
{
	int id;

	id = Find(CText);

	if(id < 0) return false;

	*CValue = CData[id].CValue;

	return true;
}

bool TCSpiceParameters::GetString(CString CText, CString *CData)
{
	if(!Get(CText, CData))return false;

	CData->Remove('\"');
	CData->Remove('\'');
	CData->Remove('[');
	CData->Remove(']');
	CData->Remove('{');
	CData->Remove('}');

	return true;
}

bool TCSpiceParameters::Set(CString CText, CString CValue)
{
	int id;

	id = Find(CText);

	if(id < 0) 
	{
		TCNameValueData CNameValueData;

		CNameValueData.CName = CText;
		CNameValueData.CValue = CValue;
		CNameValueData.is_text_data = true;

		CData.Add(CNameValueData);
			
		return true;
	}
	CData[id].CValue = CValue;

	return true;
}

int  TCSpiceParameters::Find(CString CText)
{
	int count = CData.GetSize();
	int p;
	CString CTemp;

	CText.MakeUpper();

	TCNameValueData *PCNameValueData = CData.GetData();

	for(p = 0; p < count; p++)
	{
		CTemp = PCNameValueData->CName;

		CTemp.MakeUpper();

		if(CTemp == CText) return p;
			
		PCNameValueData++;
	}

	return -1;
}

CString TCSpiceParameters::GetSpiceDesignator(void)
{
	CString CText = CDataBaseIdInfo.CRecordType;

	if(CText == "") return "";

	if(CText == "X") return CText;
	if(CText == "R") return CText;
	if(CText == "L") return CText;
	if(CText == "C") return CText;
	if(CText == "CAP") return "C";
	if(CText == "RES") return "R";
	if(CText == "SW") return "S";
	if(CText == "CSW") return "W";
	if(CText == "URC") return "U";
	if(CText == "LTRA") return "O";
	if(CText == "T") return "T";
	if(CText == "D") return "D";
	if(CText == "NPN") return "QN";
	if(CText == "PNP") return "QP";
	if(CText == "NJF") return "JN";
	if(CText == "PJF") return "JP";
	if(CText == "NMOS") return "MN";
	if(CText == "PMOS") return "MP";
	if(CText == "NMF") return "ZN";
	if(CText == "PMF") return "ZP";
	if(CText == "B")  return CText;//E_NONLINEAR_DEPENDANT_SOURCE;
	if(CText == "E")  return CText;//E_VCVSRC_COMPONENT;
	if(CText == "G")  return CText;//E_VCISRC_COMPONENT;
	if(CText == "H")  return CText;//E_ICVSRC_COMPONENT;
	if(CText == "F")  return CText;//E_ICISRC_COMPONENT;

	// non spice additions
	if(CText == "W") return CText;
	if(CText == "Node") return CText;
	if(CText == "G") return CText;
	if(CText == "CONT") return CText;
	if(CText == "TST") return CText;

	return "A";// assume all others are xspice
}

CString TCSpiceParameters::GetSpicePolynomialFromSpiceCoefficients(CString CSpiceCoefficients)
{
	// this is to convert the [1.5 0.0 3.2 1 2] type spice syntax to
	// 1.5s^4 + 0.0s^3 + 3.2s^2 + s + 2

	CString CSpicePolynomial;

	CSpiceCoefficients.TrimLeft();
	CSpiceCoefficients.TrimRight();

	if(CSpiceCoefficients == "") return "";

	if(CSpiceCoefficients.GetAt(0) != '[') return "";

	int length = CSpiceCoefficients.GetLength();

	length--;

	if(CSpiceCoefficients.GetAt(length) != ']') return "";

	CSpiceCoefficients = CSpiceCoefficients.Left(length);
	CSpiceCoefficients = CSpiceCoefficients.Right(length - 1);// now left with "1.0 1.14124 1.0"

	CString CText, CTemp;
	int count, number;

	if(CSpiceCoefficients == "") return "";

	count = CountWords(CSpiceCoefficients);

	if(!count) return "";

	number = count;

	for(int p = 0; p < number; p++)
	{
		count--;// contains the power

		CText				= GetFirstWord(CSpiceCoefficients);
		CSpiceCoefficients	= RemoveFirstWord(CSpiceCoefficients);

		if(count > 1)
		{
			CTemp.Format("%ss^%d", CText, count);

			CSpicePolynomial += CTemp + ' ' + '+' + ' ';
		}
		if(count == 1)
		{
			CTemp.Format("%ss", CText);

			CSpicePolynomial += CTemp + ' '+ '+' + ' ';
		}
		if(!count) 
		{
			CTemp.Format("%s", CText);

			CSpicePolynomial += CTemp;

			return CSpicePolynomial;
		}
	}

	return CSpicePolynomial;
}

CString TCSpiceParameters::GetSpiceCoefficientsFromSpicePolynomial(CString CSpicePolynomial)
{
	// this is to convert the 1.5s^4 + 0.0s^3 + 3.2s^2 + s + 2 type spice syntax to
	// [1.5 0.0 3.2 1 2]

	CString CSpiceCoefficients;
	CString CText, CTemp;
	int index;

	// first tidy up, assume the + signs are there
	CSpicePolynomial.Remove(' ');
	CSpicePolynomial.Remove('\t');
	CSpicePolynomial.Replace("+", " + ");

	CText = CSpicePolynomial;

	CSpicePolynomial.MakeLower();

	index = CText.Find('s');

//	if(index < 0) return "";

	CSpicePolynomial.Remove('+');

	do
	{
		CText = GetFirstWord(CSpicePolynomial);

		index = CText.Find('s');

		if(index > -1)// powers found
		{
			CText = CText.Left(index);

			if(CText == "") CText ='1';

			CText += ' ';

			CTemp += CText;
		}
		else
		{
			CTemp += CText;
		}
		

	} while((CSpicePolynomial = RemoveFirstWord(CSpicePolynomial)) != "");


	CTemp = '[' + CTemp + ']';

	return CTemp;
}

///////////////////////////
////////////////////////

TCSpiceParametersList::TCSpiceParametersList(void)
{

}
TCSpiceParametersList::TCSpiceParametersList(TCSpiceParametersList &CSpiceParametersList)
{
	*this = CSpiceParametersList;
}
TCSpiceParametersList::~TCSpiceParametersList(void)
{

}

void TCSpiceParametersList::Serialize(CArchive& CArchiveFile)
{
	int count, p;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		count = CParameters.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CParameters[p].Serialize(CArchiveFile);

	}
	else
	{
		CArchiveFile >> count;

		CParameters.SetSize(count, count);

		for(p = 0; p < count; p++) CParameters[p].Serialize(CArchiveFile);

	}
}

void TCSpiceParametersList::operator = (TCSpiceParametersList &CSpiceParametersList)
{
	int p;

	int count = CSpiceParametersList.CParameters.GetSize();

	CParameters.SetSize(count, count);

	for(p = 0; p < count; p++)CParameters[p] = CSpiceParametersList.CParameters[p];
}



bool TCSpiceParametersList::LoadModel(CString CFileNAme, CString CModelName, int id)
{
	if(id < 0) return false;

	TCSpiceParameters CTemp;

	CTemp.CDataBaseIdInfo.CModelType = "MODEL";
	CTemp.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;

	CParameters.SetAtGrow(id, CTemp);

	if(CParameters[id].LoadModel(CFileNAme, CModelName)) return true;

	CParameters.RemoveAt(id);

	return false;
}

bool TCSpiceParametersList::LoadSubCircuit(CString CFileNAme, CString CModelName, int id)
{
	if(id < 0) return false;

	TCSpiceParameters CTemp;

	CTemp.CDataBaseIdInfo.CModelType = "SUBCKT";
	CTemp.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;

	CParameters.SetAtGrow(id, CTemp);

	if(CParameters[id].LoadSubCircuit(CFileNAme, CModelName)) return true;

	CParameters.RemoveAt(id);

	return false;
}

bool TCSpiceParametersList::Save(CString CFileNAme, CString CRecordName, int id)
{
	if(id < 0) return false;

	if(CParameters.GetSize() < id + 1) return false;

	return CParameters[id].Save(CFileNAme, CRecordName);
}

bool TCSpiceParametersList::SetFromText(CArray <CString, CString&> &CModelData, int id)
{
	if(id < 0) return false;

	TCSpiceParameters CTemp;

	CParameters.SetAtGrow(id, CTemp);

	if(CParameters[id].SetFromText(CModelData)) return true;

	CParameters.RemoveAt(id);

	return false;
}


bool TCSpiceParametersList::GetToText(CArray <CString, CString&> &CModelData, int id)
{
	if(id < 0) return false;

	if(CParameters.GetSize() < id + 1) return false;

	return CParameters[id].GetToText(CModelData);

}

bool TCSpiceParametersList::LoadAll(CString CFileName)
{
	ifstream CFileStream;
 
//	CFileStream.open(CFileName, ios::in, filebuf::sh_read || filebuf::sh_write);

	CFileStream.open(CFileName, ios::in);

	if(CFileStream.fail()) return false;
	
	CParameters.SetSize(0, 16);

	CString CText1, CText2;

	CText1 = ExtractPathName(CFileName);
	CText2 = ExtractFileName(CFileName);

	TCSpiceParameters CSpiceParameters;

	int p, count;
	CString CTemp, CRecordName;
	bool flag = false;

	while(!CFileStream.eof())
	{
		if(CSpiceParameters.LoadModelOrSubcircuit(CFileStream))
		{
			CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CText1;
			CSpiceParameters.CDataBaseIdInfo.CRecordFileName = CText2;

			CRecordName = CSpiceParameters.CDataBaseIdInfo.CRecordName;

			CRecordName.MakeUpper();

			count = CParameters.GetSize();

			for(p = 0; p < count; p++)
			{
				CTemp = CParameters[p].CDataBaseIdInfo.CRecordName;

				CTemp.MakeUpper();

				if(CTemp != CRecordName) continue;// dont add same model name twice;
			
				flag = true;

				break;
			}

			if(flag)
			{
				flag = false;

				continue;
			}
			
			int id = CParameters.Add(CSpiceParameters);

			if(id < 0) return false;

			GCWorkspaceTree.AddModel(CFileName, id);
		}
	}

	CFileStream.close();

//	CreateWCModelsFromLib(); to do

	return true;
}

bool TCSpiceParametersList::SaveAll(CString CFileName)
{
	CFile CDataFile;
	char data[2];
	data[0] = '\r';
	data[1] = '\n';
	int char_size = 2 * sizeof(char);

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	int count = CParameters.GetSize();

	CArray <CString, CString&> CModelData;

	int p;

	for(int q = 0; q < count; q++)
	{
		CParameters[q].GetToText(CModelData);

		int count =  CModelData.GetSize();

		if(!count) continue;

		count--;

		for(p = 0; p < count; p++)
		{
			CDataFile.Write(CModelData[p], CModelData[p].GetLength());

			CDataFile.Write(data, char_size);
		}
	
		CDataFile.Write(CModelData[p], CModelData[p].GetLength());
		CDataFile.Write(data, char_size);
		CDataFile.Write(data, char_size);
	}

	CDataFile.Close();
	
	return true;
}

void TCSpiceParametersList::CreateWCModelsFromLib(void)
{
	int param_count;
	int count = CParameters.GetSize();

	CString CName, CModelName, CTemp, CParameterData;

	TCSpiceParameters CSpiceParameters;

	for(int p = 0; p < count; p++)
	{
		if(CParameters[p].CDataBaseIdInfo.model_type != E_SPICE_DOT_HSPICELIB) continue;

		CName = CParameters[p].CDataBaseIdInfo.CRecordName;

		CName.MakeLower();

		CTemp = CName.Left(CName.GetLength() - 3);

		CTemp += "_xn";

		CParameterData = CParameters[p].GetLibParameter();

		for(int q = 0; q < count; q++)
		{
			if(CParameters[q].CDataBaseIdInfo.model_type != E_SPICE_DOT_MODEL) continue;

			CModelName = CParameters[q].CDataBaseIdInfo.CRecordName;

			CModelName.MakeLower();			 
	
			if(CModelName != CTemp) continue;// find nominal matching wc base name

			CSpiceParameters = CParameters[q];// copy existing data

			CSpiceParameters.CDataBaseIdInfo.CRecordName = CParameters[p].CDataBaseIdInfo.CRecordName;

			param_count = CSpiceParameters.CData.GetSize();

			for (int k = 0; k < param_count; k++)
			{
				CSpiceParameters.ReplaceExpression(CParameterData, '\'', '\'');

				CSpiceParameters.CData[k].is_text_data = false;


			}
		}
	}
}

int TCSpiceParametersList::FindModelOrSubcircuit(CString CRecordName)
{
	int count, p;
	CString CText;

	CRecordName.MakeUpper();

	count = CParameters.GetSize();

	for(p = 0; p < count; p++)
	{
		CText = CParameters[p].CDataBaseIdInfo.CRecordName;

		CText.MakeUpper();

		if(CText != CRecordName) continue;

		return p;
	}

	return -1;
}

bool TCSpiceParametersList::FindModels(CString CModel, CArray <CString, CString> &CModelNames, CArray <HTREEITEM,  HTREEITEM> &CHandles)
{
	int count, p;
	CString CText;
	bool found_flag = false;

	CModel.MakeUpper();

	count = CParameters.GetSize();

	for(p = 0; p < count; p++)
	{
		CText = CParameters[p].CDataBaseIdInfo.CRecordName;

		CText.MakeUpper();

		if(CText.Find(CModel) < 0) continue;

		CModelNames.Add(CParameters[p].CDataBaseIdInfo.CRecordName);
		CHandles.Add(CParameters[p].HTreeItem);

		found_flag = true;
	}

	return found_flag;
}

int TCSpiceParametersList::FindModelWithExtention(CString CRecordName, int start)
{
	int count, p;
	CString CText, CBaseName, CRecordBaseName, CType;

	CRecordName.MakeUpper();

	CRecordBaseName = RemoveExtention(CRecordName); //model.1_XN

	CType = CRecordName.Right(3);	// get the last _XN

	CRecordBaseName += CType; //model_XN

	count = CParameters.GetSize();

	for(p = start; p < count; p++)
	{
		CText = CParameters[p].CDataBaseIdInfo.CRecordName;

		CText.MakeUpper();
		
		CBaseName = RemoveExtention(CText);

		CType = CText.Right(3);	

		CBaseName += CType; 

		if(CBaseName != CRecordBaseName) continue;

		return p;
	}

	return -1;
}
/////////////////////////////