#ifndef _TCSpiceParameters_H
#define _TCSpiceParameters_H

#include <afxtempl.h>
#include <fstream>
#include <iostream>
using namespace std;
#include "TCDataBaseIdInfo.h"


enum TE_MODEL_TYPE
{
	E_SPICE_DOT_MODEL,
	E_SPICE_DOT_SUBCIRCUIT,
	E_SPICE_SCHEMATIC,
	E_SPICE_GENERATOR,
	E_SPICE_DOT_HSPICELIB

};


enum E_SWEEP_TYPES
{
	E_SWEEP_DECADE,
	E_SWEEP_OCTAVE,
	E_SWEEP_LINEAR
};

enum TE_BASIC_SPICE_TYPES
{
	E_SPICE_NULL= 0,
	E_SPICE_R = 1,
	E_SPICE_L,
	E_SPICE_C,
	E_SPICE_SW,
	E_SPICE_CSW,
	E_SPICE_URC,
	E_SPICE_LTRA,
	E_SPICE_D,
	E_SPICE_NPN,
	E_SPICE_PNP,
	E_SPICE_NJF,
	E_SPICE_PJF,
	E_SPICE_NMOS,
	E_SPICE_PMOS,
	E_SPICE_NMF,
	E_SPICE_PMF,
	E_SPICE_B,
	E_SPICE_E,
	E_SPICE_G,
	E_SPICE_H,
	E_SPICE_F,
	E_SPICE_XSPICE_DIGITAL,//covers laplace, integrators etc.

	E_SPICE_VSRC,// compatible stuff
	E_SPICE_VDC,
	E_SPICE_VSIN,// this is not for use in Berkerly spice
	E_SPICE_VPULSE,
	E_SPICE_VPWL,
	E_SPICE_VEXP,
	E_SPICE_VSFFM,
	E_SPICE_IDC,
	E_SPICE_ISIN,
	E_SPICE_IPULSE,
	E_SPICE_IPWL,
	E_SPICE_IEXP,
	E_SPICE_ISFFM,


	E_SPICE_TEMP,
	E_SPICE_LLTL,
	E_NUMBER_OF_BASIC_SPICE_TYPES_VER1,

	
	E_SPICE_TYPE_RESERVED3,
	E_SPICE_TYPE_RESERVED4,
	E_SPICE_TYPE_RESERVED5,
	E_SPICE_TYPE_RESERVED6,
	E_SPICE_TYPE_RESERVED7,
	E_SPICE_TYPE_RESERVED8,
	E_SPICE_TYPE_RESERVED9,

	E_NUMBER_OF_BASIC_SPICE_TYPES
};

enum TE_WC_SPICE_ALIAS_TYPES
{
	E_WC_NPN		= E_SPICE_NPN,
	E_WC_PNP		= E_SPICE_PNP,
	E_WC_NMOS		= E_SPICE_NMOS,
	E_WC_PMOS		= E_SPICE_PMOS,
	E_WC_SUBCKT		= E_SPICE_C,
	E_WC_RLC		= E_SPICE_R,
	E_WC_GENERATOR	= E_SPICE_L,
	E_WC_NPN_DIODE  = E_SPICE_NPN,
	E_WC_QRC		= E_SPICE_D
};

class TCNameValueData : public CObject
{
	public:	TCNameValueData(void);
			TCNameValueData(TCNameValueData &CNameValueData);
			~TCNameValueData(void);

			double	value;
			CString CName;
			CString CValue;//this has been added to support xspice models
			int	is_text_data;
			int include;

			void operator = (TCNameValueData &CNameValueData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCNameValueData)

};

class TCSpiceParameters : public CObject
{
	public:	TCSpiceParameters(void);
			TCSpiceParameters(TCSpiceParameters &CSpiceParameters);
			~TCSpiceParameters(void);

			int unique_instance;
			int unique_parameters;
			int modified;
			int last_selected;
			int use_model;
			HTREEITEM HTreeItem;

			TCDataBaseIdInfo CDataBaseIdInfo;

			CArray <TCNameValueData, TCNameValueData &> CData;
			CArray <CString, CString> CPinArray;
			CString CSymbolParameters;
			CString CSubcktModelType;

			void operator = (TCSpiceParameters &CSpiceParameters);
	
			void Serialize(CArchive& CArchiveFile);
			void SerializeInfo(CArchive& CArchiveFile);
			void CopyInfo(TCSpiceParameters &CSpiceParameters);

			CString FormatSpiceValue(CString CTextData);

			void UpdateUseModel(void);
			bool IsDigital(void);

			bool LoadModel(CString CFileName, CString CModelName);
			bool LoadSubCircuit(CString CFileName, CString CModelName);

			bool SaveToSingleFile(CString CFileNAme, CString CModelName);
			bool Save(CString CFileNAme, CString CModelName);

			bool LoadModelOrSubcircuit(ifstream &CFileStream);

			bool Save(ifstream &CFileStream);

			bool SetFromText(CArray <CString, CString&> &CModelData);
			bool GetToText(CArray <CString, CString&> &CModelData, int f_validate = 0, bool f_exponent = false);
			bool GetToModelText(CArray <CString, CString&> &CModelData, int f_validate = 0, bool f_exponent = false);
			bool GetToSubCircuitText(CArray <CString, CString&> &CModelData, int f_validate = 0);

			bool Get(CString CText, double *data);// parameters can be in any position in array
			bool Set(CString CText, double data);
			bool Get(CString CText, CString *CData);// for xspice data arrays
			bool Set(CString CText, CString CData);// for xspice data arrays
			bool GetString(CString CText, CString *CData);// for parameter strings 
			void SetInclude(CString CText, int include);// rerun

			int  Find(CString CText);
			void Rename(CString CText);
			CString GetSpiceDesignator(void);
			bool Validate(TCNameValueData CNameValueData);
			bool ValidateSubCktLine(CString &CSubCktLine);
			CString GetRecordName(double width, double length);

			bool SetSubcircuitSymbolName(CString CSpiceLine);
			bool SetSubcktModelType(CString CSpiceLine);
			void AddSubcircuitSymbolName(void);
			bool SetModelSymbolName(void);
			void AddModelSymbolName(void);

			CString GetSpicePolynomialFromSpiceCoefficients(CString CSpiceCoefficients);
			CString GetSpiceCoefficientsFromSpicePolynomial(CString CSpicePolynomial);
			CString IsValueInLine(CString CLine);
			CString IsParamInLine(CString CLine);
			void AddCurrentProbingVoltageSources(void);
			void ConvertPSpiceSyntaxToSpice3(void);
			void ConvertPSpiceSourcesToSpice3BSource(void);
			void EvaluateSubcktParameters(CString CModelParameters, CString CSymbolParameterLine);
			void ReplaceWithParameterValue(CString CParamaterName, CString CParameterValue);
			CString EvaluateParameterLine(CString CParameterDefs, CString CParameterLine);
			CString ArrayToLine(void);
			void LineToArray(CString CLine);

			void EvaluateModelParameters(CString CSymbolParameterLine);
			void EvaluateModelParameters(CString CSymbolParameterLine, int id);
			CString ConvertToParameterString(void);
			
			void ReplaceExpression(CString CExpressionParameters, char open_char = '{', char close_char = '}');
			void ConvertSpiceParameters(CString CModelParameters, CString CSymbolParameterLine);
			bool CreateReRunText(CArray <CString, CString> &CReRunList);
			char GetSpiceModelChar(void);
			CString GetSubcktParameters(void);
			void	SetSubcktParameters(CString CParameterLine);
			CString GetLibParameter(void);

			bool IsEmpty(void);

			void FlattenSubckts(CArray <CString, CString&> &CModelData);

			CString GetPinList(CArray <CString, CString> &CPinArray);

			bool MosfetDesigner(double vds, double vgs, double vbs, double id, int type, double &value);
			bool Mos1Designer(double vds, double vgs, double id, double vbs,int type, double &value);
			bool Mos2Designer(double vds, double vgs, double id, double vbs, int type, double &value);
			bool MosBSim3Designer(double vds, double vgs, double vbs, double id, double &value);

			double GetMosGamma(void);
			double GetMos2Vdsat(double gamma, double phi, double vgs, double vbs, double vbin);
			double GetMos2Vbi(double vt0, double gamma, double phi);

			double GetBSimEffParam(CString CParam, double effective_length, double effective_width);
			double GetThermalVt(double Temp);
			double GetBSimVbi(double Tnom);
			double GetBSimNi(double Tnom);
			double GetBSimPhi(void);
			double GetBSimXdep(double vbseff);
			double GetBSimXdep0(void);
			double GetBSimVbseff(double Vbs, double Leff, double Weff);
			double GetBSimAbulk(double Vgsteff, double vbseff, double Leff, double Weff);
			double GetBSimN(double Cox, double Vbseff, double Leff, double Weff);
			double GetBSimUeff(double Vgsteff, double Vth, double Tox, double Leff, double Weff);
			double GetBSimVgseff(double Vgs, double Vth, double Cox, double Vbseff, double Leff, double Weff);
			double GetBSimVth(double Vbseff, double Vds, double Leff, double Weff);
			double GetBSimVdsat(double length, double Weff, double Esat, double Vgsteff, double Abulk, double Rds);
			double GetBSimVdseff(double vds, double Vdsat);
			double GetBSimEsat(double ueff, double Leff, double Weff);
			double GetBSimLeff(double L, double W);
			double GetBSimW(double Weff, double L);
			double GetBSimVascbe(double vds, double vdseff, double Leff);
			double GetBSimVadiblc(double Vgsteff, double Vdsat, double Leff, double Weff, double Abulk, double Vbseff);
			double GetBSinVa(double Vasat, double Vgsteff, double Vaclm, double vadiblc, double Esat, double Leff);
			double GetBSimVasat(double Vgsteff, double Esat, double Leff, double Weff, double Vdsat, double Rds, double Abulk);
			double GetBSimAclm(double Esat, double Vgsteff, double Vds, double Vdseff, double Leff, double Weff, double Abulk);
			double GetBSimRds(double Vgsteff, double Vbsteff, double Weff);

			DECLARE_SERIAL(TCSpiceParameters)

};

class TCSpiceParametersList : public CObject
{
	public:	TCSpiceParametersList(void);
			TCSpiceParametersList(TCSpiceParametersList &CSpiceParametersList);
			~TCSpiceParametersList(void);

			CArray <TCSpiceParameters, TCSpiceParameters&> CParameters;

			void operator = (TCSpiceParametersList &CSpiceParametersList);
	
			void Serialize(CArchive& CArchiveFile);

			bool LoadModel(CString CFileNAme, CString CModelName, int id);
			bool LoadSubCircuit(CString CFileName, CString CModelName, int id);

			bool Save(CString CFileNAme, CString CModelName, int id);

			bool LoadAll(CString CFileName);
			bool SaveAll(CString CFileName);
			void CreateWCModelsFromLib(void);

			int FindModelOrSubcircuit(CString CRecordName);
			int FindModelWithExtention(CString CRecordName, int start = 0);
			bool FindModels(CString CModel, CArray <CString, CString> &CModelNames, CArray <HTREEITEM,  HTREEITEM> &CHandles);

			bool SetFromText(CArray <CString, CString&> &CModelData, int id);
			bool GetToText(CArray <CString, CString&> &CModelData, int id);

			DECLARE_SERIAL(TCSpiceParametersList)

};

#endif