
#include "stdafx.h"
#include <afxtempl.h>
#include "TCFileFunctions.h"
#include "TCStringFunctions.h"



#ifdef _DEBUG
#define new DEBUG_NEW 
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCStringList, CObject, 1)
IMPLEMENT_SERIAL(TCStringListData, CObject, 1)
IMPLEMENT_SERIAL(TCComponentInfo, CObject, 1)

extern CString GSubCktCurrentStr;
extern CString GSubCktCurrentPinStr;


CSize GetTextSize(CString CText, LOGFONT &s_logfont, float zoom)
{
	CFont	CTextFont;		// Only need to get bitmap sizes
	LOGFONT sm_logfont = s_logfont;
	CSize	CBitmapSize(0, 0);

	sm_logfont.lfHeight = (LONG)(s_logfont.lfHeight * zoom);
	sm_logfont.lfWidth  = (LONG)(s_logfont.lfWidth * zoom);

	if(!CTextFont.CreateFontIndirect(&sm_logfont)) return CBitmapSize;

	CDC CDCTemp;

	CDCTemp.CreateCompatibleDC(NULL);

	CFont *COldFont	= CDCTemp.SelectObject(&CTextFont);

	if(!COldFont)
	{
		CTextFont.DeleteObject();

		return CBitmapSize;
	}

	CBitmapSize	= CDCTemp.GetTextExtent(CText);

	CDCTemp.SelectObject(COldFont);
	CTextFont.DeleteObject();

	return CBitmapSize;
}


TCComponentInfo::TCComponentInfo(void)
{

}
TCComponentInfo::TCComponentInfo(TCComponentInfo &CComponentInfo)
{
	*this = CComponentInfo;
}
TCComponentInfo::~TCComponentInfo(void)
{

}

void TCComponentInfo::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CExtraData.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CDescription;
		CArchiveFile << CNotes;
		CArchiveFile << CCreationDate;
		CArchiveFile << CModifiedDate;
		CArchiveFile << CLastAccesedDate;
		CArchiveFile << CCreater;
		CArchiveFile << CVersion;
	}
	else
	{
		CArchiveFile >> CDescription;
		CArchiveFile >> CNotes;
		CArchiveFile >> CCreationDate;
		CArchiveFile >> CModifiedDate;
		CArchiveFile >> CLastAccesedDate;
		CArchiveFile >> CCreater;
		CArchiveFile >> CVersion;
	}
}
void TCComponentInfo::operator = (TCComponentInfo &CComponentInfo)
{
	CDescription	= CComponentInfo.CDescription;
	CNotes			= CComponentInfo.CNotes;
	CCreationDate	= CComponentInfo.CCreationDate;
	CModifiedDate	= CComponentInfo.CModifiedDate;
	CLastAccesedDate= CComponentInfo.CLastAccesedDate;
	CCreater		= CComponentInfo.CCreater;
	CVersion		= CComponentInfo.CVersion;
	CExtraData		= CComponentInfo.CExtraData;
}

////////////////////////////////////////////////////////////
TCStringListData::TCStringListData(void)
{

}
TCStringListData::TCStringListData(TCStringListData &CStringListData)
{
	*this = CStringListData;
}
TCStringListData::~TCStringListData(void)
{

}

void TCStringListData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CType;
		CArchiveFile << CValue;
		CArchiveFile << value;
	}
	else
	{
		CArchiveFile >> CType;
		CArchiveFile >> CValue;
		CArchiveFile >> value;
	}
}
void TCStringListData::operator = (TCStringListData &CStringListData)
{
	CType	= CStringListData.CType;
	CValue	= CStringListData.CValue;
	value	= CStringListData.value;
}
////////////////////////////////////////////////////
TCStringList::TCStringList(void)
{

}
TCStringList::TCStringList(TCStringList &CStringList)
{
	*this = CStringList;
}
TCStringList::~TCStringList(void)
{

}

void TCStringList::Serialize(CArchive& CArchiveFile)
{
	int count, p;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		count = CData.GetSize();

		CArchiveFile << count;
		
		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> count;

		CData.SetSize(count, count);

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);
	}
}
void TCStringList::operator = (TCStringList &CStringList)
{
	int count, p;

	count = CStringList.CData.GetSize();

	CData.SetSize(count, count);

	for(p = 0; p < count; p++) CData[p] = CStringList.CData[p];
}

int TCStringList::Find(CString CType)
{
	int count, p;
	CString CText;

	CType.MakeUpper();

	count = CData.GetSize();

	for(p = 0; p < count; p++) 
	{
		CText = CData[p].CType;

		CText.MakeUpper();

		if(CText != CType) continue;
	
		return p;
	}

	return -1;
}

int TCStringList::Set(TCStringListData &CStringListData)
{
	int index = Find(CStringListData.CValue);

	if(index < 0)
	{
		CData.Add(CStringListData);
		
		return ++index;
	}

	CData[index] = CStringListData;

	return index;
}

int TCStringList::Get(TCStringListData &CStringListData)
{
	int index = Find(CStringListData.CType);

	if(index < 0) return -1;

	CStringListData = CData[index];

	return index;
}
/////////////////////////////////////////////////
CString ReplaceFileExtension(CString CPathAndName, CString CExt)
{
	CString CNewName;
	CString CPath;
	CString CName, CNameCopy;
	char	*p_str, *p_str_scan;
		
	CName = ExtractFileName(CPathAndName);
	CPath = ExtractPathName(CPathAndName);
		
	CNameCopy = CName;
	p_str = CNameCopy.GetBuffer(CNameCopy.GetLength() + 1);

	p_str_scan = &p_str[strlen(p_str)]; 

	while(p_str != p_str_scan)
	{
		if(*p_str_scan == '.')
		{
			CNameCopy.ReleaseBuffer();
			CNewName = CPath + CNameCopy + CExt;
			return CNewName;
		}
		*p_str_scan-- = 0;
	}
 
	CNewName = CPath + CName + '.' + CExt; // no extention previously found so add a new extention

	return CNewName;
}

CString ExtractFileName(CString CPathAndName)
{
	char	*p_str, *p_str_scan;
	CString	CName = CPathAndName;

	p_str		= CPathAndName.GetBuffer(CPathAndName.GetLength() + 1);
	p_str_scan = &p_str[strlen(p_str)];
	
	while(p_str != p_str_scan)
	{
		if((*p_str_scan == '\\') || (*p_str_scan == '>')) // ignor <system>, or <.> preappended to name
		{
			CName = ++p_str_scan;

			return CName;
		}
		*p_str_scan--;
	}

	return CName;
}

CString ExtractPathName(CString CPathAndName)
{
	CString CPath;
	CString CName;

	CName = ExtractFileName(CPathAndName);

	CPath = CPathAndName.Left(CPathAndName.GetLength() - CName.GetLength());

	CPath = ExpandFilePath(CPath); // expand special identifiers to full path

	return CPath;
}
CString RemoveExtention(CString CPathAndName)
{
	CString CNewName;
	CString CPath;
	CString CName, CNameCopy;
	char	*p_str, *p_str_scan;
		
	CName = ExtractFileName(CPathAndName);
	CPath = ExtractPathName(CPathAndName);
		
	CNameCopy = CName;
	p_str = CNameCopy.GetBuffer(CNameCopy.GetLength() + 1);

	p_str_scan = &p_str[strlen(p_str)]; 

	while(p_str != p_str_scan)
	{
		if(*p_str_scan == '.')
		{
			*p_str_scan = 0;
			CNameCopy.ReleaseBuffer();
			CNewName = CPath + CNameCopy;
			return CNewName;
		}
		*p_str_scan-- = 0;
	}
 
	CNewName = CPath + CName;

	return CNewName;
}

void TCMultyTaskedString::operator = (TCMultyTaskedString &CMultyTaskedString)
{
	// add locking to do
	CString::operator = ((CString)CMultyTaskedString);
}

void TCMultyTaskedString::operator = (char *CMultyTaskedString)
{
	// add locking to do
	CString::operator = (CMultyTaskedString);
}

void TCMultyTaskedString::operator = (int resource_id)
{
	// add locking to do

	LoadString(resource_id);

}

void TCMultyTaskedString::operator = (CString CMultyTaskedString)
{
	// add locking to do

	CString::operator = (CMultyTaskedString);
}

CString RemoveFirstWord(CString CText)
{
	CString CTemp;
	int index;

	CText.TrimLeft();

	index = CText.Find(' ');

	if(index > -1)
	{
		CTemp = CText.Right(CText.GetLength() - index - 1);

		return CTemp;
	}

	index = CText.Find('\t');

	if(index > -1)
	{
		CTemp = CText.Right(CText.GetLength() - index - 1);

		return CTemp;
	}

	return "";
}

CString RemoveFirstWord(CString CText, char delimiter)
{
	CString CTemp;

	int index;

	CText.TrimLeft();

	index = CText.Find(delimiter);

	if(index > -1)
	{
		CTemp = CText.Right(CText.GetLength() - index - 1);

		CTemp.TrimLeft();

		return CTemp;
	}

	return "";
}

CString GetFirstWord(CString CText, char delimiter)
{
	CString CTemp;

	int index;

	CText.TrimLeft();

	index = CText.Find(delimiter);

	if(index > -1)
	{
		CTemp = CText.Left(index);

		CTemp.TrimLeft();

		return CTemp;
	}

	return CText;
}

CString GetFirstWord(CString CText)
{
	CString CTemp;

	int index;

	CText.TrimLeft();

	index = CText.Find(' ');

	if(index > -1)
	{
		CTemp = CText.Left(index);

		CTemp.TrimLeft();

		return CTemp;
	}

	index = CText.Find('\t');

	if(index > -1)
	{
		CTemp = CText.Left(index);

		CTemp.TrimLeft();

		return CTemp;
	}

	return CText;
}

CString GetWord(CString CText, int n)
{
	CString CWord;

	if(n < 1) return "";

	for(int p = 0; p < n; p++)
	{
		CWord = GetFirstWord(CText);

		CText = RemoveFirstWord(CText);
	}

	return CWord;
}

CString Spice3ToSuperSpiceName(CString CName)
{
	if(CName.Find(':') < 0) return CName;

	if(CName == "")return "";

	// 1:2:r[i] to x1:x2:r[i]

	// change spice 3 name from v(1:in) to x1:vin
	
	// this code is very messy, hope that a name dont contain Xx

	bool flag = false;

	char a_char;
	char replace = 'v';

	a_char = CName.GetAt(0);

	if(a_char == 'V')
	{
		CName.Replace("V(", "X");
		CName.Remove(')');
	}
	else if(a_char == 'v')
	{
		flag = true;
		CName.Replace("v:", "X");
		replace = 'v';
	}

	CName.Replace(":", ":X");

	bool vi_flag = false;

	if(CName.Find(GSubCktCurrentStr) > -1)//nasty fixup
	{
		vi_flag = true;

		CString CReplaceString = "X" + GSubCktCurrentStr;

		CName.Replace(":Xx", ":X");

		if(CName.Find(CReplaceString) > -1)
			CName.Replace(CReplaceString, GSubCktCurrentPinStr);
		else //toplevel pin current mode
		{
			CReplaceString = "v" + GSubCktCurrentStr;

			if(CName.Find(CReplaceString) > -1)
			{
				int index = CName.Find(':');// get first :
				CString CFirstRefDes;

				if(index > -1)// change V_ssi_pin1:X1:X2:X3:X4[i] to X4:X1:X2:X3:Pin1[i]
				{
					CString CCopyName;
					CString CEnd;

					CCopyName = CName.Left(index);//V_ssi_pin1:

					CCopyName = CCopyName.Right(CCopyName.GetLength() - CReplaceString.GetLength());// get pin number pin1

					CCopyName = GSubCktCurrentPinStr + CCopyName;// Pin1, pins string got

					CName = CName.Right(CName.GetLength() - index - 1); // X1:X2:X3:X4[i]

					index = CName.ReverseFind(':');// get last :

					CFirstRefDes = CName.Right(CName.GetLength() - index - 1);//X4[i]

					index = CFirstRefDes.Find('[');// X1:X2:X3:X4[i]

					CFirstRefDes = CFirstRefDes.Left(index);//X4

					index = CName.Find('[');// X1:X2:X3:X4[i]

					CEnd = CName.Right(CName.GetLength() - index);//[i]

					index = CName.ReverseFind(':');// X1:X2:X3:X4[i]

					CName = CName.Left(index);//X1:X2:X3

					if(CName != "")CName = CFirstRefDes + ':' + CName;//X4:X1:X2:X3
					else CName = CFirstRefDes;

					CName += ':' + CCopyName + CEnd;	
				}
			}
		}
	}

	int position = CName.ReverseFind('X');// undo last one

	if(!position) return CName;

	if(flag /*&& replace == 'v'*/ && !vi_flag) 
	{	
		CName.SetAt(position, replace);
		
		CName.Delete(position);

		CName.Replace(":Xx", ":X");

		return CName;
	}
	
	if(!vi_flag) CName.Delete(position);

	CName.Replace(":Xx", ":X");

	return CName;
}

bool IsSpice3SubcircuitTypeName(CString CName)
{
	if(CName.Find(':') < 0) return false;// not a subcircuit

	if(CName.GetAt(0) != 'x')
		if(CName.GetAt(0) != 'X') return true;

	return false;
}

CString GetTextLinesFromFile(CString CFileName, int count, bool add_lf)
{
	if(count < 1) return "";

	ifstream CTextFile;

	CTextFile.open(CFileName, ios::in);

	if(CTextFile.fail()) return "";

	CString CText;

	char *p_buffer = new char[count];

	while(!CTextFile.eof())
	{
		CTextFile.getline(p_buffer, count);

		CText += p_buffer;
		if(add_lf) CText += "\r\n";
	}

	delete [] p_buffer;

	return CText;
}

CString RemoveSquareBrakets(CString CText)
{

	CText.TrimLeft();
	CText.TrimRight();

	int length = CText.GetLength();

	if(length < 2) return "";

	if(CText.GetAt(0) != '[') return "";
	if(CText.GetAt(length - 1) != ']') return "";

	CText = CText.Left(length - 1);
	CText = CText.Right(length - 2);

	return CText;
}

TCMultiLineString::TCMultiLineString()
{

}

TCMultiLineString::TCMultiLineString(TCMultiLineString &CMultiLineString)
{
	*this = CMultiLineString;
}

TCMultiLineString::~TCMultiLineString()
{

}

void TCMultiLineString::operator = (TCMultiLineString &CMultiLineString)
{
	CLine = CMultiLineString.CLine;

	int count = CMultiLineString.CLines.GetSize();

	CLines.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CLines[p] = CMultiLineString.CLines[p];
	}
}
/*
CArchive& TCMultiLineString::operator << (TCMultiLineString &CMultiLineString)
{

}
CArchive& TCMultiLineString::operator >> (TCMultiLineString &CMultiLineString)
{

}
*/
void TCMultiLineString::Serialize(CArchive& CArchiveFile)
{
	// Saves and loads as if it were a single string
	if(CArchiveFile.IsStoring())
	{
		Save(CArchiveFile);
	}
	else
	{
		Load(CArchiveFile);
	}
}

void TCMultiLineString::Save(CArchive& CArchiveFile)
{
	LinesToLine();

	CArchiveFile << CLine;
}

void TCMultiLineString::Load(CArchive& CArchiveFile)
{
	CArchiveFile >> CLine;
		
	LineToLines();
}

void TCMultiLineString::LineToLines()
{
	CString CLocalLine;

	CLines.SetSize(0, 1024);

	char *p_buff = CLine.GetBuffer(CLine.GetLength() + 1);

	while(*p_buff)
	{
		if(*p_buff != '\n')
		{
			CLocalLine += *p_buff;

			p_buff++;

			if(!*p_buff)
			{
				CLines.Add(CLocalLine);

				return;
			}

			continue;
		}
		else
		{
			CLines.Add(CLocalLine);
		}

		if(*p_buff == '\n') 

		p_buff++;

		CLocalLine = "";
	}
}

void TCMultiLineString::LinesToLine()
{
	int count = CLines.GetSize();

	CLine = "";

	for(int p = 0; p < count; p++)
	{
		CLine += CLines[p];

		CLine += '\n';
	}
}
