
#ifndef TCStringFunctions_h
#define TCStringFunctions_h

#include "stdafx.h"
#include <afxtempl.h>

CString ReplaceFileExtension(CString CPathAndName, CString CExt);
CString ExtractFileName(CString CPathAndName);
CString ExtractPathName(CString CPathAndName);
CString RemoveExtention(CString CPathAndName);
CString RemoveSquareBrakets(CString CText);

CString RemoveFirstWord(CString CText);
CString RemoveFirstWord(CString CText, char delimiter);
CString GetFirstWord(CString CText, char delimiter);
CString GetFirstWord(CString CText);
CString	GetWord(CString CText, int n);
CSize	GetTextSize(CString CText, LOGFONT &s_logfont, float zoom);
CString Spice3ToSuperSpiceName(CString CName);
bool    IsSpice3SubcircuitTypeName(CString CName);
CString GetTextLinesFromFile(CString CFileName,  int count, bool add_lf);

class TCStringListData : public CObject
{
	public:	TCStringListData(void);
			TCStringListData(TCStringListData &CStringListData);
			~TCStringListData(void);

			CString CType;
			CString CValue;
			float	value;

			void operator = (TCStringListData &CStringListData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCStringListData)

};

class TCStringList : public CObject
{
	public:	TCStringList(void);
			TCStringList(TCStringList &CStringList);
			~TCStringList(void);

			CArray <TCStringListData, TCStringListData&> CData;

			int Find(CString CType);
			int Set(TCStringListData &CStringListData);
			int Get(TCStringListData &CStringListData);

			void operator = (TCStringList &CStringList);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCStringList)

};

class TCComponentInfo : public CObject
{
	public:	TCComponentInfo(void);
			TCComponentInfo(TCComponentInfo &CComponentInfo);
			~TCComponentInfo(void);

			CString CDescription;
			CString CNotes;
			CString CCreationDate;
			CString CModifiedDate;
			CString CLastAccesedDate;
			CString CCreater;
			CString CVersion;

			TCStringList CExtraData;

			void operator = (TCComponentInfo &CComponentInfo);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCComponentInfo)

};


class TCMultyTaskedString : public CString
{
	public:
				TCMultyTaskedString(){};
				~TCMultyTaskedString(){};

				void operator = (TCMultyTaskedString &CMultyTaskedString);
				void operator = (char *CMultyTaskedString);
				void operator = (int resource_id);
				void operator = (CString CMultyTaskedString);

	

};

class TCMultiLineString 
{
		public:

		TCMultiLineString();
		TCMultiLineString(TCMultiLineString &CMultiLineString);
		~TCMultiLineString();

		CString CLine;

		CArray <CString, CString&> CLines;

		void LineToLines();
		void LinesToLine();

		void operator = (TCMultiLineString &CMultiLineString);

//		CArchive&  operator << (TCMultiLineString &CMultiLineString); 
//		CArchive&  operator >> (TCMultiLineString &CMultiLineString);

		void Serialize(CArchive& CArchiveFile);
		void Save(CArchive& CArchiveFile);
		void Load(CArchive& CArchiveFile);

};
#endif