// TCSubcircuitDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSubcircuitDlg.h"
#include "TCMasterModelDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCSubcircuitLabelsDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSubcircuitPinsDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSubcircuitModelDlg, CPropertyPage)


/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitLabelsDlg property page

extern int	g_last_active_component_property_page;
extern TCSuperSpiceDataBase	GCSuperSpiceDataBase;

TCSubcircuitLabelsDlg::TCSubcircuitLabelsDlg() : CPropertyPage(TCSubcircuitLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSubcircuitLabelsDlg)
	m_check_visable_ref_designator = FALSE;
	m_check_visable_spice_name = FALSE;
	m_check_visable_type_name = FALSE;
	m_check_visable_value = FALSE;
	CMRefDesignator = _T("");
	CMEditSpiceName = _T("");
	CMEditTypeName = _T("");
	CMEditValue = _T("");
	CMParameters = _T("");
	//}}AFX_DATA_INIT
}

TCSubcircuitLabelsDlg::~TCSubcircuitLabelsDlg()
{
}

void TCSubcircuitLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_check_visable_ref_designator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_check_visable_spice_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_check_visable_type_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_check_visable_value);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMRefDesignator);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpiceName);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Text(pDX, IDC_EDIT_PARAMETERS, CMParameters);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSubcircuitLabelsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_NAME, OnKillfocusEditSpiceName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitPinsDlg property page

TCSubcircuitPinsDlg::TCSubcircuitPinsDlg() : CPropertyPage(TCSubcircuitPinsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSubcircuitPinsDlg)
	m_check_visable_pin_name0 = FALSE;
	m_check_visable_pin_name1 = FALSE;
	m_check_visable_pin_name2 = FALSE;
	m_check_visable_pin_name3 = FALSE;
	m_check_visable_pin_num0 = FALSE;
	m_check_visable_pin_num1 = FALSE;
	m_check_visable_pin_num2 = FALSE;
	m_check_visable_pin_num3 = FALSE;
	CMEditPinName0 = _T("");
	CMEditPinName1 = _T("");
	CMEditPinName2 = _T("");
	CMEditPinName3 = _T("");
	CMEditPinNum0 = _T("");
	CMEditPinNum1 = _T("");
	CMEditPinNum2 = _T("");
	CMEditPinNum3 = _T("");
	//}}AFX_DATA_INIT
}

TCSubcircuitPinsDlg::~TCSubcircuitPinsDlg()
{
}

void TCSubcircuitPinsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitPinsDlg)
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_3, CCheckPinNumber3);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_2, CCheckPinNumber2);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_1, CCheckPinNumber1);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NUM_0, CCheckPinNumber0);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_3, CCheckPinName3);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_2, CCheckPinName2);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_1, CCheckPinName1);
	DDX_Control(pDX, IDC_CHECK_VISABLE_PIN_NAME_0, CCheckPinName0);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_3, CEditCntlPinNumber3);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_2, CEditCntlPinNumber2);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_1, CEditCntlPinNumber1);
	DDX_Control(pDX, IDC_EDIT_PIN_NUM_0, CEditCntlPinNumber0);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_3, CEditCntlPinName3);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_2, CEditCntlPinName2);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_1, CEditCntlPinName1);
	DDX_Control(pDX, IDC_EDIT_PIN_NAME_0, CEditCntlPinName0);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_0, m_check_visable_pin_name0);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_1, m_check_visable_pin_name1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_2, m_check_visable_pin_name2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME_3, m_check_visable_pin_name3);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_0, m_check_visable_pin_num0);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_1, m_check_visable_pin_num1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_2, m_check_visable_pin_num2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUM_3, m_check_visable_pin_num3);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_0, CMEditPinName0);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_1, CMEditPinName1);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_2, CMEditPinName2);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME_3, CMEditPinName3);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_0, CMEditPinNum0);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_1, CMEditPinNum1);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_2, CMEditPinNum2);
	DDX_Text(pDX, IDC_EDIT_PIN_NUM_3, CMEditPinNum3);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitPinsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSubcircuitPinsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitModelDlg property page

TCSubcircuitModelDlg::TCSubcircuitModelDlg() : CPropertyPage(TCSubcircuitModelDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSubcircuitModelDlg)
	m_matched = 1;
	m_strength = 1;
	CEditRecordName = _T("");
	CEditRecordVersion = _T("");
	CEditSpiceStringModelData = _T("");
	CEditRecordFilePath = _T("");
	//}}AFX_DATA_INIT
}

TCSubcircuitModelDlg::~TCSubcircuitModelDlg()
{
}

void TCSubcircuitModelDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitModelDlg)
	DDX_Control(pDX, IDC_BUTTON_SELECT_MODEL, CButtonSelect);
	DDX_Control(pDX, IDC_EDIT_RECORD_NAME, CEditCntlRecordName);
	DDX_Control(pDX, IDC_EDIT_SPICE_MODEL_DATA, CEditSpiceModelData);
//	DDX_Radio(pDX, IDC_RADIO_MATCHED, m_matched);
//	DDX_Radio(pDX, IDC_RADIO_WEAK, m_strength);
	DDX_Text(pDX, IDC_EDIT_RECORD_NAME, CEditRecordName);
	DDX_Text(pDX, IDC_EDIT_RECORD_VERSION, CEditRecordVersion);
	DDX_Text(pDX, IDC_EDIT_SPICE_MODEL_DATA, CEditSpiceStringModelData);
	DDX_Text(pDX, IDC_EDIT_RECORD_VERSION2, CEditRecordFilePath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitModelDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSubcircuitModelDlg)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_MODEL, OnButtonSelectModel)
	ON_BN_CLICKED(IDC_RADIO_MATCHED, OnRadioMatched)
	ON_BN_CLICKED(IDC_RADIO_NOMINAL, OnRadioNominal)
	ON_BN_CLICKED(IDC_RADIO_STRONG, OnRadioStrong)
	ON_BN_CLICKED(IDC_RADIO_UNMATCHED, OnRadioUnmatched)
	ON_BN_CLICKED(IDC_RADIO_WEAK, OnRadioWeak)
	ON_BN_CLICKED(IDC_RADIO_XCOUPLED, OnRadioXcoupled)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCSubcircuitLabelsDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_check_visable_type_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMEditTypeName;
		
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_check_visable_spice_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_check_visable_value;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_check_visable_ref_designator;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMRefDesignator;
	}

	OnKillfocusEditSpiceName();

	PCSchematicObjectData->CSpiceParameters.SetSubcktParameters(CMParameters);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel = CMParameters;

//	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	return value;
}

BOOL TCSubcircuitLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;


	PCSchematicObjectData->FormatSpiceName();
	PCSchematicObjectData->FormatSpiceValue();
	
	CMEditSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntlValue.SetWindowText(CMEditValue);
	CMEditCntlSpiceName.SetWindowText(CMEditSpiceName);

	CString CText = PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel;

	CText.TrimLeft();
	CText.TrimRight();

	if(CMParameters == "") 
		CMParameters = PCSchematicObjectData->CSpiceParameters.GetSubcktParameters();

	return CPropertyPage::OnSetActive();
}

void TCSubcircuitLabelsDlg::OnKillfocusEditSpiceName() 
{
	if(!PCSchematicObjectData) return;

	UpdateData(true);
	
	PCSchematicObjectData->Rename(CMEditSpiceName);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

	PCSchematicObjectData->FormatRecordName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntlValue.SetWindowText(CMEditValue);
}

BOOL TCSubcircuitLabelsDlg::OnInitDialog() 
{
	int count = PCSchematicObjectData->CLabelListData.GetSize();


	for(int p = 0; p < count; p++)
	{

		m_check_visable_type_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
		CMEditTypeName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

		m_check_visable_spice_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
		CMEditSpiceName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

		m_check_visable_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
		CMEditValue =  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

		m_check_visable_ref_designator = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
		CMRefDesignator =  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
	}

	CMParameters = PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel;

	CMParameters.TrimLeft();
	CMParameters.TrimRight();

	if(CMParameters == "") 
		CMParameters = PCSchematicObjectData->CSpiceParameters.GetSubcktParameters();

	CPropertyPage::OnInitDialog();

	CMEditCntlTypeName.SetReadOnly(true);

	if(PCSchematicObjectData->attached_model_type == E_SPICE_SCHEMATIC) CMEditCntlSpiceName.SetReadOnly(true);

	return TRUE;
}

BOOL TCSubcircuitModelDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}

	PCSchematicObjectData->FormatLabels();

	return value;
}

void TCSubcircuitModelDlg::SetDisplay(void)
{
	m_matched			= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched;
	m_strength			= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength;
//	CEditRecordName		= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName;
	CEditRecordVersion	= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CEditRecordFilePath = PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;

	CEditRecordName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	int count = PCSchematicObjectData->CSpiceParameters.CData.GetSize();

	CEditSpiceStringModelData = "";

	int test = count - 1;

	for(int p = 0; p < count; p++)
	{
		CEditSpiceStringModelData += PCSchematicObjectData->CSpiceParameters.CData[p].CName;

		if(p < test) CEditSpiceStringModelData += "\r\n";
	}
	
	UpdateData(false);
}

BOOL TCSubcircuitModelDlg::OnSetActive() 
{
	g_last_active_component_property_page = 2;

	PCSchematicObjectData->FormatRecordName();

	SetDisplay();

	return CPropertyPage::OnSetActive();
}

BOOL TCSubcircuitModelDlg::OnInitDialog() 
{

	CPropertyPage::OnInitDialog();

	SetDisplay();

	return TRUE; 
}

void TCSubcircuitModelDlg::GetDisplay(void)
{
	UpdateData(true);

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched			= m_matched;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength		= m_strength;
//	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName		= CEditRecordName;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CEditRecordVersion;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CEditRecordName;

	PCSchematicObjectData->FormatRecordName();

	if(!CEditSpiceModelData.GetModify()) return;

	TCNameValueData CNameValueData;

	PCSchematicObjectData->CSpiceParameters.CData.SetSize(0, 128);

	int size;
	char *buff;

	size = CEditSpiceStringModelData.GetLength();

	buff = CEditSpiceStringModelData.GetBuffer(size + 1);

	while(*buff != 0)
	{
		if(*buff == '\r')
		{
			buff++;// ignore next \n that should be there !!??
			if(*buff == '\n') buff++;

			PCSchematicObjectData->CSpiceParameters.CData.Add(CNameValueData);

			CNameValueData.CName = "";
		}
		else CNameValueData.CName += *buff++;
	}

	if(CNameValueData.CName != "")PCSchematicObjectData->CSpiceParameters.CData.Add(CNameValueData);
//	CButtonSave.Enable(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CButtonLoad.Enable(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CButtonSelect.Enable(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CEditCntlRecordName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
}

BOOL TCSubcircuitPinsDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
	int count = PCSchematicObjectData->CPinListData.GetSize();

	int q, count2;

	for(int p = 0; p < count; p++)
	{
		if(p == 0)
		{
			count2 = PCSchematicObjectData->CPinListData[0].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[0].CLabelListData[0].is_visable = !!m_check_visable_pin_name0;
					PCSchematicObjectData->CPinListData[0].CLabelListData[0].CLabel = CMEditPinName0;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[0].CLabelListData[1].is_visable = !!m_check_visable_pin_num0;
					PCSchematicObjectData->CPinListData[0].CLabelListData[1].CLabel = CMEditPinNum0;
				}
			}
		}
		if(p == 1)
		{
			count2 = PCSchematicObjectData->CPinListData[1].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[1].CLabelListData[0].is_visable = !!m_check_visable_pin_name1;
					PCSchematicObjectData->CPinListData[1].CLabelListData[0].CLabel = CMEditPinName1;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[1].CLabelListData[1].is_visable = !!m_check_visable_pin_num1;
					PCSchematicObjectData->CPinListData[1].CLabelListData[1].CLabel = CMEditPinNum1;
				}
			}
		}
		if(p == 2)
		{
			count2 = PCSchematicObjectData->CPinListData[2].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[2].CLabelListData[0].is_visable = !!m_check_visable_pin_name2;
					PCSchematicObjectData->CPinListData[2].CLabelListData[0].CLabel = CMEditPinName2;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[2].CLabelListData[1].is_visable = !!m_check_visable_pin_num2;
					PCSchematicObjectData->CPinListData[2].CLabelListData[1].CLabel = CMEditPinNum2;
				}
			}
		}
		if(p == 3)
		{
			count2 = PCSchematicObjectData->CPinListData[3].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					PCSchematicObjectData->CPinListData[3].CLabelListData[0].is_visable = !!m_check_visable_pin_name3;
					PCSchematicObjectData->CPinListData[3].CLabelListData[0].CLabel = CMEditPinName3;
				}
				if(q == 1)
				{
					PCSchematicObjectData->CPinListData[3].CLabelListData[1].is_visable = !!m_check_visable_pin_num3;
					PCSchematicObjectData->CPinListData[3].CLabelListData[1].CLabel = CMEditPinNum3;
				}
			}
		}
	}
	}
	return value;
}

BOOL TCSubcircuitPinsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 1;

	return CPropertyPage::OnSetActive();
}

BOOL TCSubcircuitPinsDlg::OnInitDialog() 
{
	int count = PCSchematicObjectData->CPinListData.GetSize();

	int q, count2;

	for(int p = 0; p < count; p++)
	{
		if(p == 0)
		{
			count2 = PCSchematicObjectData->CPinListData[0].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name0 = PCSchematicObjectData->CPinListData[0].CLabelListData[0].is_visable;
					CMEditPinName0 =  PCSchematicObjectData->CPinListData[0].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num0 = PCSchematicObjectData->CPinListData[0].CLabelListData[1].is_visable;
					CMEditPinNum0 =  PCSchematicObjectData->CPinListData[0].CLabelListData[1].CLabel;
				}
			}
		}
		if(p == 1)
		{
			count2 = PCSchematicObjectData->CPinListData[1].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name1 = PCSchematicObjectData->CPinListData[1].CLabelListData[0].is_visable;
					CMEditPinName1 =  PCSchematicObjectData->CPinListData[1].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num1 = PCSchematicObjectData->CPinListData[1].CLabelListData[1].is_visable;
					CMEditPinNum1 =  PCSchematicObjectData->CPinListData[1].CLabelListData[1].CLabel;
				}
			}
		}
		if(p == 2)
		{
			count2 = PCSchematicObjectData->CPinListData[2].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name2 = PCSchematicObjectData->CPinListData[2].CLabelListData[0].is_visable;
					CMEditPinName2 =  PCSchematicObjectData->CPinListData[2].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num2 = PCSchematicObjectData->CPinListData[2].CLabelListData[1].is_visable;
					CMEditPinNum2 =  PCSchematicObjectData->CPinListData[2].CLabelListData[1].CLabel;
				}
			}
		}
		if(p == 3)
		{
			count2 = PCSchematicObjectData->CPinListData[3].CLabelListData.GetSize();

			for(q = 0; q < count2; q++)
			{
				if(q == 0)
				{
					m_check_visable_pin_name3 = PCSchematicObjectData->CPinListData[3].CLabelListData[0].is_visable;
					CMEditPinName3 =  PCSchematicObjectData->CPinListData[3].CLabelListData[0].CLabel;
				}
				if(q == 1)
				{
					m_check_visable_pin_num3 = PCSchematicObjectData->CPinListData[3].CLabelListData[1].is_visable;
					CMEditPinNum3 =  PCSchematicObjectData->CPinListData[3].CLabelListData[1].CLabel;
				}
			}
		}
	}
	CPropertyPage::OnInitDialog();
	
	count = PCSchematicObjectData->CPinListData.GetSize();

	switch(count)
	{
		case 1:	CEditCntlPinName1.SetReadOnly();
				CEditCntlPinNumber1.SetReadOnly(); 
				CEditCntlPinName2.SetReadOnly();
				CEditCntlPinNumber2.SetReadOnly();
				CEditCntlPinName3.SetReadOnly();
				CEditCntlPinNumber3.SetReadOnly();
				CCheckPinName3.EnableWindow(false);
				CCheckPinName2.EnableWindow(false);
				CCheckPinName1.EnableWindow(false);
				CCheckPinNumber3.EnableWindow(false);
				CCheckPinNumber2.EnableWindow(false);
				CCheckPinNumber1.EnableWindow(false);
				break;

		case 2:	CEditCntlPinName2.SetReadOnly();
				CEditCntlPinNumber2.SetReadOnly(); 
				CEditCntlPinName3.SetReadOnly();
				CEditCntlPinNumber3.SetReadOnly();
				CCheckPinName3.EnableWindow(false);
				CCheckPinName2.EnableWindow(false);
				CCheckPinNumber3.EnableWindow(false);
				CCheckPinNumber2.EnableWindow(false);
				break;

		case 3:	CEditCntlPinName3.SetReadOnly();
				CEditCntlPinNumber3.SetReadOnly();
				CCheckPinNumber3.EnableWindow(false);
				CCheckPinName3.EnableWindow(false);
				break;
	
	}
	
	return TRUE;   
}

void TCSubcircuitModelDlg::OnButtonSelectModel() 
{
	if(!PCSchematicObjectData) return;

	TCMasterModelDlg CMasterModelDlg;

	CMasterModelDlg.attached_model_type = PCSchematicObjectData->attached_model_type;

	TCSchematicObjectData CSchematicObjectData;

	TCComponentDataBaseData CComponentDataBaseData;

	CSchematicObjectData = *PCSchematicObjectData;

	GCSuperSpiceDataBase.SetDefaultModelDisplayed(*PCSchematicObjectData);

	if(CMasterModelDlg.DoModal() != IDOK) return;

	CComponentDataBaseData = CMasterModelDlg.CComponentDataBaseData;

//	CComponentDataBaseData.CSymbolName		= PCSchematicObjectData->CSymbolData.CName;
//	CComponentDataBaseData.CSymbolFileName	= PCSchematicObjectData->CSymbolData.CFileName;
//	CComponentDataBaseData.CSymbolPathName	= PCSchematicObjectData->CSymbolData.CFilePath;

	if(!GCSuperSpiceDataBase.CheckAndCorrectModelData(&CComponentDataBaseData, PCSchematicObjectData->attached_model_type)) 
	{
		AfxMessageBox(IDS_MODEL_SYM_MUST_MATCH);

		return;
	}

	if(!GCSuperSpiceDataBase.GetModel(CComponentDataBaseData, CSchematicObjectData)) return;

	*PCSchematicObjectData = CSchematicObjectData;

	SetDisplay();
}


void TCSubcircuitModelDlg::OnRadioMatched() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 0;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelDlg::OnRadioNominal() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 1;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelDlg::OnRadioStrong() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 2;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelDlg::OnRadioUnmatched() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 2;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelDlg::OnRadioWeak() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 0;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelDlg::OnRadioXcoupled() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 1;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}
