// TCSubcircuitLargeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSubcircuitLargeDlg.h"
#include "TCMasterModelDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCSubcircuitLabelsLargeDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSubcircuitPinsLargeDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSubcircuitModelLargeDlg, CPropertyPage)

extern int	g_last_active_component_property_page;

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase	GCSuperSpiceDataBase;

/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitLabelsLargeDlg property page

TCSubcircuitLabelsLargeDlg::TCSubcircuitLabelsLargeDlg() : CPropertyPage(TCSubcircuitLabelsLargeDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSubcircuitLabelsLargeDlg)
	m_check_visable_ref_designator = FALSE;
	m_check_visable_spice_name = FALSE;
	m_check_visable_type_name = FALSE;
	m_check_visable_value = FALSE;
	CMRefDesignator = _T("");
	CMEditSpiceName = _T("");
	CMEditTypeName = _T("");
	CMEditValue = _T("");
	CMParameters = _T("");
	m_check_visable_parameter = FALSE;
	//}}AFX_DATA_INIT
}

TCSubcircuitLabelsLargeDlg::~TCSubcircuitLabelsLargeDlg()
{
}

void TCSubcircuitLabelsLargeDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitLabelsLargeDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_check_visable_ref_designator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_check_visable_spice_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_check_visable_type_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_check_visable_value);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMRefDesignator);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpiceName);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Text(pDX, IDC_EDIT_PARAMETERS, CMParameters);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PARAMETER, m_check_visable_parameter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitLabelsLargeDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSubcircuitLabelsLargeDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_NAME, OnKillfocusEditSpiceName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitPinsLargeDlg property page

TCSubcircuitPinsLargeDlg::TCSubcircuitPinsLargeDlg() : CPropertyPage(TCSubcircuitPinsLargeDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSubcircuitPinsLargeDlg)
	m_check_visable_pin_name = FALSE;
	m_check_visable_pin_number = FALSE;
	CEditPinName = _T("");
	CEditPinNumber = _T("");
	CEditPinId = 0;
	//}}AFX_DATA_INIT
}

TCSubcircuitPinsLargeDlg::~TCSubcircuitPinsLargeDlg()
{

}
 
void TCSubcircuitPinsLargeDlg::DoDataExchange(CDataExchange* pDX)
{
	int p = GCSuperSpiceGlobalData.CGeneric.CComponentPropertyCurrentPin.GetSize();

	if(!p) return;

	if(PCSchematicObjectData->type >= p) p = 0;

	if(!(PCSchematicObjectData->type < GCSuperSpiceGlobalData.CGeneric.CComponentPropertyCurrentPin.GetSize())) return;

	SetupPinDataDisplay(GCSuperSpiceGlobalData.CGeneric.CComponentPropertyCurrentPin[PCSchematicObjectData->type]);

	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitPinsLargeDlg)
	DDX_Control(pDX, IDC_LIST_PIN_DATA, CListControlPinData);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME, m_check_visable_pin_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUMBER, m_check_visable_pin_number);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME, CEditPinName);
	DDX_Text(pDX, IDC_EDIT_PIN_NUMBER, CEditPinNumber);
	DDX_Text(pDX, IDC_EDITPIN_ID, CEditPinId);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitPinsLargeDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSubcircuitPinsLargeDlg)
	ON_NOTIFY(NM_CLICK, IDC_LIST_PIN_DATA, OnClickListPinData)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitModelLargeDlg property page

TCSubcircuitModelLargeDlg::TCSubcircuitModelLargeDlg() : CPropertyPage(TCSubcircuitModelLargeDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSubcircuitModelLargeDlg)
	CEditRecordName = _T("");
	CEditRecordVersion = _T("");
	m_matched = -1;
	m_strength = -1;
	CMEditStringModelData = _T("");
	CEditRecordVersion2 = _T("");
	//}}AFX_DATA_INIT
}

TCSubcircuitModelLargeDlg::~TCSubcircuitModelLargeDlg()
{
}

void TCSubcircuitModelLargeDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitModelLargeDlg)
	DDX_Control(pDX, IDC_EDIT_RECORD_NAME, CEditCntlRecordName);
	DDX_Control(pDX, IDC_EDIT_SPICE_MODEL_DATA, CEditSpiceModelData);
	DDX_Text(pDX, IDC_EDIT_RECORD_NAME, CEditRecordName);
	DDX_Text(pDX, IDC_EDIT_RECORD_VERSION, CEditRecordVersion);
	DDX_Radio(pDX, IDC_RADIO_MATCHED, m_matched);
	DDX_Radio(pDX, IDC_RADIO_WEAK, m_strength);
	DDX_Text(pDX, IDC_EDIT_SPICE_MODEL_DATA, CMEditStringModelData);
	DDX_Text(pDX, IDC_EDIT_RECORD_VERSION2, CEditRecordVersion2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitModelLargeDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSubcircuitModelLargeDlg)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_MODEL, OnButtonSelectModel)
	ON_BN_CLICKED(IDC_BUTTON_LOAD, OnButtonLoad)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnButtonSave)
	ON_BN_CLICKED(IDC_RADIO_MATCHED, OnRadioMatched)
	ON_BN_CLICKED(IDC_RADIO_NOMINAL, OnRadioNominal)
	ON_BN_CLICKED(IDC_RADIO_STRONG, OnRadioStrong)
	ON_BN_CLICKED(IDC_RADIO_UNMATCHED, OnRadioUnmatched)
	ON_BN_CLICKED(IDC_RADIO_WEAK, OnRadioWeak)
	ON_BN_CLICKED(IDC_RADIO_XCOUPLED, OnRadioXcoupled)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



void TCSubcircuitModelLargeDlg::OnButtonSelectModel() 
{
	if(!PCSchematicObjectData) return;

	TCMasterModelDlg CMasterModelDlg;

	CMasterModelDlg.attached_model_type = PCSchematicObjectData->attached_model_type;

	TCSchematicObjectData CSchematicObjectData;

	TCComponentDataBaseData CComponentDataBaseData;

	CSchematicObjectData = *PCSchematicObjectData;

	GCSuperSpiceDataBase.SetDefaultModelDisplayed(*PCSchematicObjectData);

	if(CMasterModelDlg.DoModal() != IDOK) return;

	CComponentDataBaseData = CMasterModelDlg.CComponentDataBaseData;

	if(!GCSuperSpiceDataBase.CheckAndCorrectModelData(&CComponentDataBaseData, PCSchematicObjectData->attached_model_type)) 
	{
		AfxMessageBox(IDS_MODEL_SYM_MUST_MATCH);

		return;
	}

	if(!GCSuperSpiceDataBase.GetModel(CComponentDataBaseData, CSchematicObjectData)) return;

	*PCSchematicObjectData = CSchematicObjectData;

	SetDisplay();	
}

BOOL TCSubcircuitModelLargeDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}

	PCSchematicObjectData->FormatLabels();

	return value;
}

void TCSubcircuitModelLargeDlg::GetDisplay(void)
{
	UpdateData(true);

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched			= m_matched;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength			= m_strength;
//	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName		= CEditRecordName;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CEditRecordVersion;
	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CEditRecordVersion2;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CEditRecordName;

	PCSchematicObjectData->FormatRecordName();

	if(!CEditSpiceModelData.GetModify()) return;

	TCNameValueData CNameValueData;

	PCSchematicObjectData->CSpiceParameters.CData.SetSize(0, 128);

	int size;
	char *buff;
	
	CMEditStringModelData += '\r';//for last line only

	size = CMEditStringModelData.GetLength();

	if(!size) return;

	buff = CMEditStringModelData.GetBuffer(size + 1);

	while(*buff != 0)
	{
		if(*buff == '\r')
		{
			buff++;// ignore next \n if there
			if(*buff == '\n') buff++;

			PCSchematicObjectData->CSpiceParameters.CData.Add(CNameValueData);

			CNameValueData.CName = "";
		}
		else CNameValueData.CName += *buff++;
	}
}

BOOL TCSubcircuitModelLargeDlg::OnSetActive() 
{
	g_last_active_component_property_page = 2;
	

	PCSchematicObjectData->FormatRecordName();

	SetDisplay();

	return CPropertyPage::OnSetActive();
}

BOOL TCSubcircuitModelLargeDlg::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	SetDisplay();

//	CEditCntlRecordName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);

	return TRUE; 
}

void TCSubcircuitModelLargeDlg::SetDisplay(void)
{
	int count = PCSchematicObjectData->CSpiceParameters.CData.GetSize();

	CMEditStringModelData = "";

	int test = count - 1;

	for(int p = 0; p < count; p++)
	{
		CMEditStringModelData += PCSchematicObjectData->CSpiceParameters.CData[p].CName;

		if(p < test)CMEditStringModelData += "\r\n";
	}
	
	m_matched			= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched;
	m_strength			= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength;
//	CEditRecordName		= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordName;
	CEditRecordVersion	= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CEditRecordVersion2	= PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;

	CEditRecordName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	UpdateData(false);
}
BOOL TCSubcircuitLabelsLargeDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_check_visable_type_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMEditTypeName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_check_visable_spice_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;
		
		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_check_visable_value;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;
		
		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_check_visable_ref_designator;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMRefDesignator;
	}

	PCSchematicObjectData->CSpiceParameters.SetSubcktParameters(CMParameters);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel = CMParameters;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].is_visable = !!m_check_visable_parameter;

	return value;
}

BOOL TCSubcircuitLabelsLargeDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	PCSchematicObjectData->FormatSpiceName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntlValue.SetWindowText(CMEditValue);
	CMEditCntlSpiceName.SetWindowText(CMEditSpiceName);

	CString CText = PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel;

	CText.TrimLeft();
	CText.TrimRight();

	if(CMParameters == "") 
		CMParameters = PCSchematicObjectData->CSpiceParameters.GetSubcktParameters();

	return CPropertyPage::OnSetActive();
}

BOOL TCSubcircuitLabelsLargeDlg::OnInitDialog() 
{
	int count = PCSchematicObjectData->CLabelListData.GetSize();

	for(int p = 0; p < count; p++)
	{
		m_check_visable_type_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
		CMEditTypeName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

		m_check_visable_spice_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
		CMEditSpiceName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

		m_check_visable_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
		CMEditValue =  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

		m_check_visable_ref_designator = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
		CMRefDesignator =  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;	
	}

	CMParameters = PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].CLabel;
	m_check_visable_parameter = PCSchematicObjectData->CLabelListData[E_COMPONENT_SUBCKT_PARAMETERS].is_visable;

	CMParameters.TrimLeft();
	CMParameters.TrimRight();

	if(CMParameters == "") 
		CMParameters = PCSchematicObjectData->CSpiceParameters.GetSubcktParameters();

	CPropertyPage::OnInitDialog();
	
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	if(PCSchematicObjectData->attached_model_type == E_SPICE_SCHEMATIC) CMEditCntlSpiceName.SetReadOnly(true);
	
	return TRUE;
}

BOOL TCSubcircuitPinsLargeDlg::OnKillActive() 
{
	
	GetPinDataDisplay();

	return CPropertyPage::OnKillActive();
}

BOOL TCSubcircuitPinsLargeDlg::OnSetActive() 
{
	g_last_active_component_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCSubcircuitPinsLargeDlg::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	
	CString CText;

	int length = (int)(CListControlPinData.GetStringWidth("Number Visable") * 1.2);

	CText ="ID ";
	CListControlPinData.InsertColumn(E_COMPONENT_LIST_PIN_ID, CText, LVCFMT_LEFT,length/2,E_COMPONENT_LIST_PIN_ID);


	CText ="Name    ";
	CListControlPinData.InsertColumn(E_COMPONENT_LIST_PIN_NAME, CText, LVCFMT_LEFT, length,E_COMPONENT_PIN_NAME);

	CText ="Name Visible";
	CListControlPinData.InsertColumn(E_COMPONENT_LIST_PIN_NAME_VISABLE, CText, LVCFMT_LEFT, length, E_COMPONENT_LIST_PIN_NAME_VISABLE);

	CText ="Number";
	CListControlPinData.InsertColumn(E_COMPONENT_LIST_PIN_NUMBER, CText, LVCFMT_LEFT, (int)(length/1.5), E_COMPONENT_LIST_PIN_NUMBER);

	CText ="Number Visible";
	CListControlPinData.InsertColumn(E_COMPONENT_LIST_PIN_NUMBER_VISABLE, CText, LVCFMT_LEFT, length, E_COMPONENT_LIST_PIN_NUMBER_VISABLE);

	int count = PCSchematicObjectData->CPinListData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CText.Format("%d",p);
		
		CListControlPinData.InsertItem(p, CText);
	}

	SetupPinDataList();
	
	return TRUE;  
}

void TCSubcircuitPinsLargeDlg::GetPinDataDisplay(void)
{
	if(!PCSchematicObjectData) return;

	UpdateData(true);

	if(!(CEditPinId < PCSchematicObjectData->CPinListData.GetSize())) return;

	PCSchematicObjectData->CPinListData[CEditPinId].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CEditPinName;
	PCSchematicObjectData->CPinListData[CEditPinId].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CEditPinNumber;

	PCSchematicObjectData->CPinListData[CEditPinId].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = !!m_check_visable_pin_name;
	PCSchematicObjectData->CPinListData[CEditPinId].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable = !!m_check_visable_pin_number;
}
void TCSubcircuitPinsLargeDlg::SetupPinDataList(void)
{
	CString CText;
	int count = PCSchematicObjectData->CPinListData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CText.Format("%d",p);
		
		CListControlPinData.SetItemText(p, E_COMPONENT_LIST_PIN_NAME, PCSchematicObjectData->CPinListData[p].CLabelListData[E_COMPONENT_PIN_NAME].CLabel);

		if(PCSchematicObjectData->CPinListData[p].CLabelListData[E_COMPONENT_PIN_NAME].is_visable)
			CText = "Yes";
		else CText = "No";

		CListControlPinData.SetItemText(p, E_COMPONENT_LIST_PIN_NAME_VISABLE, CText);

		CListControlPinData.SetItemText(p, E_COMPONENT_LIST_PIN_NUMBER, PCSchematicObjectData->CPinListData[p].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel);

		if(PCSchematicObjectData->CPinListData[p].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable)
			CText = "Yes";
		else CText = "No";

		CListControlPinData.SetItemText(p, E_COMPONENT_LIST_PIN_NUMBER_VISABLE, CText);
	}
}

void TCSubcircuitPinsLargeDlg::SetupPinDataDisplay(int pin_id)
{
	if(!(pin_id < PCSchematicObjectData->CPinListData.GetSize())) return;

	CEditPinId = pin_id;
	CEditPinName	= PCSchematicObjectData->CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
	CEditPinNumber = PCSchematicObjectData->CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;

	m_check_visable_pin_name = !!PCSchematicObjectData->CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].is_visable;
	m_check_visable_pin_number	= !!PCSchematicObjectData->CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable;
}

void TCSubcircuitPinsLargeDlg::OnClickListPinData(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	pNMHDR;

	GetPinDataDisplay();
	SetupPinDataList();

	int item = CListControlPinData.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item < 0) return;

	CListControlPinData.SetItemState(item, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );

	int p = GCSuperSpiceGlobalData.CGeneric.CComponentPropertyCurrentPin.GetSize();

	if(!p) return;

	if(PCSchematicObjectData->type >= p) p = 0;

	GCSuperSpiceGlobalData.CGeneric.CComponentPropertyCurrentPin[PCSchematicObjectData->type] = item;

	UpdateData(false);
}

void TCSubcircuitModelLargeDlg::OnButtonLoad() 
{
	GetDisplay();

	if(!GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters)) 
	{
		AfxMessageBox(IDS_ERR_UNABLE_TO_LOAD_MODEL);

		return;		
	}
	SetDisplay();
}

void TCSubcircuitModelLargeDlg::OnButtonSave() 
{
	GetDisplay();

	if(!GCSuperSpiceDataBase.SetModel(PCSchematicObjectData->CSpiceParameters))
	{
		AfxMessageBox(IDS_ERR_UNABLE_TO_SAVE_MODEL);

		return;		
	}
	SetDisplay();
}

void TCSubcircuitLabelsLargeDlg::OnKillfocusEditSpiceName() 
{
	UpdateData(true);
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

	PCSchematicObjectData->FormatRecordName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntlValue.SetWindowText(CMEditValue);
}

void TCSubcircuitModelLargeDlg::OnRadioMatched() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 0;
	
	PCSchematicObjectData->FormatRecordName();
	
	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelLargeDlg::OnRadioNominal() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 1;

	PCSchematicObjectData->FormatRecordName();
	
	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelLargeDlg::OnRadioStrong() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 2;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelLargeDlg::OnRadioUnmatched() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 2;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelLargeDlg::OnRadioWeak() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.strength = 0;

	PCSchematicObjectData->FormatRecordName();

	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}

void TCSubcircuitModelLargeDlg::OnRadioXcoupled() 
{
	GetDisplay();

	PCSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.matched = 1;

	PCSchematicObjectData->FormatRecordName();
	
	GCSuperSpiceDataBase.GetModel(PCSchematicObjectData->CSpiceParameters);

	SetDisplay();
}
