// TCSubcircuitConnectorDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSubcircuitPinConnectorDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitConnectorDlg dialog


TCSubcircuitConnectorDlg::TCSubcircuitConnectorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCSubcircuitConnectorDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCSubcircuitConnectorDlg)
	m_visable_ref_des = FALSE;
	m_visable_type = FALSE;
	m_visable_name = FALSE;
	CMEditRefDes = _T("");
	CMEditType = _T("");
	CMEditName = _T("");
	m_pin_number_visable = FALSE;
	CMEditPinNumber = _T("");
	//}}AFX_DATA_INIT
}


void TCSubcircuitConnectorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSubcircuitConnectorDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlName);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlType);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_visable_ref_des);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_visable_type);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_visable_name);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditType);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUMBER, m_pin_number_visable);
	DDX_Text(pDX, IDC_EDIT_PIN_NUMBER, CMEditPinNumber);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSubcircuitConnectorDlg, CDialog)
	//{{AFX_MSG_MAP(TCSubcircuitConnectorDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_VALUE, OnKillfocusEditValue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSubcircuitConnectorDlg message handlers

BOOL TCSubcircuitConnectorDlg::OnInitDialog() 
{
	m_visable_type = CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditType	=  CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_visable_ref_des = CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes = CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_visable_name = CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable;
	CMEditName = CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

	m_pin_number_visable = CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditPinNumber = CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;

	CDialog::OnInitDialog();
	
	CMEditCntlType.SetReadOnly(CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
//	CMEditCntlName.SetReadOnly(CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].read_only);

	return TRUE;  
}

void TCSubcircuitConnectorDlg::OnOK() 
{
	CDialog::OnOK();

	CMEditName.TrimLeft();
	CMEditName.TrimRight();

	if(CMEditName.GetAt(0) == 'v' || CMEditName.GetAt(0) == 'V' || CMEditName.GetAt(0) == '+' || CMEditName.GetAt(0) == '-')
	{
		AfxMessageBox(IDS_V_NOT_ALLOWED_SUBCKT);

		CMEditName.SetAt(0, 's');
	}

	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable		= !!m_visable_type;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel			= CMEditType;

	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable	= !!m_visable_ref_des;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel		= CMEditRefDes;

	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable	= !!m_visable_name;
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel		= CMEditName;

	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].is_visable	= !!m_pin_number_visable;
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel		= CMEditPinNumber;

}

void TCSubcircuitConnectorDlg::OnKillfocusEditValue() 
{
	UpdateData(true);

	CMEditName.TrimLeft();
	CMEditName.TrimRight();

	if(CMEditName == "") return;

	if(CMEditName.GetAt(0) == 'v' || CMEditName.GetAt(0) == 'V' || CMEditName.GetAt(0) == '+' || CMEditName.GetAt(0) == '-')
	{
		AfxMessageBox(IDS_V_NOT_ALLOWED_SUBCKT);

		CMEditName.SetAt(0, 's');

		UpdateData(false);
	}
}
