#include "stdafx.h"
#include "TDVersion.h"
#include "Generic.h"
#include "TCSuperSpiceClipboard.h"
#include "TCSuperSpiceGlobalData.h"

extern int global_screen_planes;
extern int global_screen_bitspixels;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;

IMPLEMENT_SERIAL(TCSuperSpiceClipboard, CObject, ID_VERSION_NUMBER)


TCSuperSpiceClipboard::TCSuperSpiceClipboard()
{
	PCMSchematicManagerClipboard = new TCSchematicManager;

//	PCMSchematicManagerClipboard->SetView(AfxGetApp()->m_pMainWnd);
}

TCSuperSpiceClipboard::~TCSuperSpiceClipboard()
{
	if(PCMSchematicManagerClipboard) delete PCMSchematicManagerClipboard;
}

void TCSuperSpiceClipboard::CutComponents(TCSchematicManager *PCSchematicManager)
{
	if(!PCMSchematicManagerClipboard) return;
	if(!PCSchematicManager)			  return;

	PCMSchematicManagerClipboard->CMSchematicManagerData.PCView = PCSchematicManager->CMSchematicManagerData.PCView;

	PCMSchematicManagerClipboard->ResetGraphicList();

	PCSchematicManager->CopySelected(PCMSchematicManagerClipboard);

	PCSchematicManager->DeleteSelectedGraphics();
}

void TCSuperSpiceClipboard::CopyComponents(TCSchematicManager *PCSchematicManager)
{
	if(!PCMSchematicManagerClipboard) return;
	if(!PCSchematicManager)			  return;

	PCMSchematicManagerClipboard->CMSchematicManagerData.PCView = PCSchematicManager->CMSchematicManagerData.PCView;
	
	PCMSchematicManagerClipboard->ResetGraphicList();

	PCSchematicManager->CopySelected(PCMSchematicManagerClipboard);
}

void TCSuperSpiceClipboard::CopyComponentsToWindowsClipboard(TCSchematicManager *PCSchematicManager)
{
	if(!PCMSchematicManagerClipboard) return;
	if(!PCSchematicManager)			  return;

	PCMSchematicManagerClipboard->CMSchematicManagerData.PCView = PCSchematicManager->CMSchematicManagerData.PCView;
	
	PCMSchematicManagerClipboard->ResetGraphicList();

	// force copy of selected components, not just an outlined component
	PCSchematicManager->PCMLastOutlinedComponent = NULL;

	PCSchematicManager->CopySelected(PCMSchematicManagerClipboard);

	if(!AfxGetApp()->m_pMainWnd->OpenClipboard()) return;

	CBitmap CBitMap;

	if(CreateBitMap(CBitMap)) 
	{
		EmptyClipboard();

		SetClipboardData(CF_BITMAP, CBitMap.GetSafeHandle());
	}

	CloseClipboard();

	CBitMap.Detach();
}

BOOL TCSuperSpiceClipboard::PasteComponents(TCSchematicManager *PCSchematicManager, CPoint CMousePosition, CString CExcludeComponent)
{
	if(!PCMSchematicManagerClipboard) return FALSE;
	if(!PCSchematicManager)			  return FALSE;

	BOOL result = PCMSchematicManagerClipboard->Paste(PCSchematicManager, CMousePosition, CExcludeComponent);

	if(!result) return FALSE;

	HWND  h_window = PCSchematicManager->GetView()->m_hWnd;

	if(!OpenClipboard(h_window)) return FALSE;

	CloseClipboard();

	return TRUE;
}

bool TCSuperSpiceClipboard::SetFilterValues(TCFantasticFilter &CFantasticFilter)
{
	if(!PCMSchematicManagerClipboard)return false;
	if(!PCMSchematicManagerClipboard->CMSchematicManagerData.CGraphicList.GetSize()) return false;

	return PCMSchematicManagerClipboard->SetFilterValues(CFantasticFilter);
}

bool TCSuperSpiceClipboard::CreateBitMap(CBitmap &CBitMap)
{
	if(!PCMSchematicManagerClipboard)return false;
	if(!PCMSchematicManagerClipboard->CMSchematicManagerData.CGraphicList.GetSize()) return false;

	CDC CMemDC;
	
	CMemDC.CreateCompatibleDC(NULL);

	TCSchematicManager CSchematicManager;

	PCMSchematicManagerClipboard->CopyAll(&CSchematicManager, "");

	CSchematicManager.CMSchematicManagerData.PCView= PCMSchematicManagerClipboard->CMSchematicManagerData.PCView;

	CSchematicManager.ClipboardResetSelectAll(&CMemDC);// need to unselect all components

	CRect CRectangleExtent;

	if(!CSchematicManager.GetComponentsExtent(CRectangleExtent)) return false;

	int w = CRectangleExtent.Width();
	int h = CRectangleExtent.Height();

	if(!CBitMap.CreateBitmap(w, h, global_screen_planes, global_screen_bitspixels,  NULL))
	{
		return false;
	}

	HGDIOBJ oldobject = CMemDC.SelectObject(CBitMap);

	if(!oldobject) 
	{	
		CMemDC.SelectObject(oldobject);

		CMemDC.DeleteDC();

		return false;
	}

	CSchematicManager.ClearScreen(&CMemDC);

	if(GCSuperSpiceGlobalData.CDrawData.is_grid_display_on)
		CSchematicManager.DrawGrid(&CMemDC);

	CPoint CMousePosition;

	CMousePosition.x = CRectangleExtent.left;
	CMousePosition.y = CRectangleExtent.top;

	CSchematicManager.ClipboardPaste(&CMemDC, CMousePosition);

	CMemDC.SelectObject(oldobject);

	CMemDC.DeleteDC();

	return true;
}

void TCSuperSpiceClipboard::DeleteComponents(void)
{
	if(!PCMSchematicManagerClipboard) return;


}

void TCSuperSpiceClipboard::Zoom(float zoom)
{
	if(!PCMSchematicManagerClipboard) return;

	PCMSchematicManagerClipboard->ClipboardZoom(zoom);
}

bool TCSuperSpiceClipboard::Load(CString CFileName)
{
	if(!PCMSchematicManagerClipboard) return false;

	PCMSchematicManagerClipboard->ResetGraphicList();

	return LoadGenericFromArchive(this, CFileName);
}

bool TCSuperSpiceClipboard::Save(CString CFileName)
{
	if(!PCMSchematicManagerClipboard) return false;

	return SaveGenericToArchive(this, CFileName);
}

void TCSuperSpiceClipboard::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(PCMSchematicManagerClipboard) PCMSchematicManagerClipboard->Serialize(CArchiveFile);
	
	if(CArchiveFile.IsStoring())
	{
		
	}
	else
	{

	}
}

int TCSuperSpiceClipboard::GetNumberOfComponents(void)
{
	if(!PCMSchematicManagerClipboard) return false;

	int number_of_components = 0;
	int component_count = 0;
	TCSchematicObject *PCSchematicObject;

	component_count = PCMSchematicManagerClipboard->CMSchematicManagerData.CGraphicList.GetSize();

	for(int p = 0; p < component_count; p++)
	{
		PCSchematicObject = PCMSchematicManagerClipboard->CMSchematicManagerData.CGraphicList[p];
		
		if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE && PCSchematicObject->m_type) continue;

		number_of_components++;
	}

	return number_of_components;
}