#ifndef _SUPERSPICE_CLIPBOARD_H
#define _SUPERSPICE_CLIPBOARD_H

#include "TCSchematicManager.h"

class CFantasticFilter; 

class TCSuperSpiceClipboard : public CObject
{
				


	public:		TCSuperSpiceClipboard();
				~TCSuperSpiceClipboard();

				TCSchematicManager *PCMSchematicManagerClipboard;

				void CutComponents(TCSchematicManager *PCMSchematicManager);
				void CopyComponents(TCSchematicManager *PCMSchematicManager);
				void CopyComponentsToWindowsClipboard(TCSchematicManager *PCMSchematicManager);

				BOOL PasteComponents(TCSchematicManager *PCMSchematicManager, CPoint CMousePosition, CString CExcludeComponent);
				void DeleteComponents();
				void Zoom(float zoom);
				TCSchematicManager *GetSchematicManager(){return PCMSchematicManagerClipboard;};

				bool Load(CString CFileName);
				bool Save(CString CFileName);
				bool CreateBitMap(CBitmap &CBitMap);
				bool SetFilterValues(TCFantasticFilter &CFantasticFilter);
				int GetNumberOfComponents(void);

				void Serialize(CArchive& CArchiveFile);

				DECLARE_SERIAL(TCSuperSpiceClipboard)
};


#endif