
#include "float.h"
#include "TDVersion.h"
#include "TESuperSpiceEnums.h"
#include "TECircuitsAttributes.h"
#include "stdafx.h"
#include "TCFileFunctions.h"
#include "TCStringFunctions.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "SuperSpice.h"
#include "TCSuperSpiceDoc.h"
#include "TCMasterSymbolDlg.h"
#include "TEPropertyViewTypes.h"
#include "TCCreateSymbolFromSchematicData.h"
#include "TCCreateSymbolForModelDlg.h"
#include "TCSuperSpiceClipboard.h"
#include "TCCircuitPropertiesDlg.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"

extern TCSuperSpiceClipboard GCSuperSpiceClipboard;

TCCreateSymbolFromSchematicData CMCreateSymbolFromSchematicData; // Global
void ClearAllVars(void);
int EquationSetVaribles(CString CNameEqualsValueList);
int EquationSetVarible(CString CName, CString CValue);
int Equation(CString CExpression, CString CValues, double *data_result);
int Equation(CString CExpression, double *data_result);
double SpiceMKSStringToFloat(CString &CTextData);

IMPLEMENT_SERIAL(TCModelDataBase, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCModelDataBaseData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSymbolDataBase, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCComponentDataBase, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSymbolDataBaseData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCComponentDataBaseData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCComponentDataBaseList, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSymbolDataBaseDataList, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCDataBaseClipboard, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSpiceNodeNames, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSymbolEditorData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCCircuitsDataBase, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCCircuitsDataBaseData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCCircuitsNameData, CObject, ID_VERSION_NUMBER)


extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;
extern TCSuperSpiceDataBase	GCSuperSpiceDataBase; 
extern CString GSSWCFileName;
extern CString GSSWCModelName;
extern CString GSSWCDefaltName;
CString GCDirFileSpecCircuits = "*.scl";
char GPGeneralFileNameBuffer[1024];
extern TCGeneralReportsTab GCGeneralReportsTab;
extern TCWorkspaceTree GCWorkspaceTree;


int GetPropertyViewType(int id);
int GetPropertyViewType(CString CModelType);

extern bool IsBadWindowHandle(CWnd *PCWnd);

////////////////////////////////////


TCCircuitsNameData::TCCircuitsNameData(void)
{
	HTreeItem = NULL;

	CAttributes.SetSize(TE_CIRCUITS_ATTRIBUTES_MAX);

	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_ID].CName = "ID";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_ID].CValue = "-1";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_TYPE].CName = "Circuit Type";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_TYPE].CValue = "(Unspecified type)";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_NAME].CName = "Circuit Name";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_NAME].CValue = "(Unspecified circuit name)";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_DISCRIPTION].CName = "Discription";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_DISCRIPTION].CValue = "(NULL)";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_FILE_NAME].CName = "File Name";
	CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_FILE_NAME].CValue = "(NULL)";
}

TCCircuitsNameData::TCCircuitsNameData(TCCircuitsNameData &CBlank)
{
	*this = CBlank;
}
TCCircuitsNameData::~TCCircuitsNameData(void)
{

}

void TCCircuitsNameData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CName;

		count = CAttributes.GetSize();

		CArchiveFile << count;

		for(int p = 0; p < count; p++)  CAttributes[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> CName;

		CArchiveFile >> count;

		CAttributes.SetSize(count);

		for(int p = 0; p < count; p++) CAttributes[p].Serialize(CArchiveFile);
	}
}
void TCCircuitsNameData::operator = (TCCircuitsNameData &CCircuitsNameData)
{
	CName = CCircuitsNameData.CName;

	HTreeItem = CCircuitsNameData.HTreeItem;

	int count = CCircuitsNameData.CAttributes.GetSize();

	for(int p = 0; p < count; p++) CAttributes[p] = CCircuitsNameData.CAttributes[p];

}

////////////////////////////////////
TCCircuitsDataBaseData::TCCircuitsDataBaseData(void)
{
	index = -1;
	HTreeItem = NULL;
}

TCCircuitsDataBaseData::TCCircuitsDataBaseData(TCCircuitsDataBaseData &CCircuitsDataBaseData)
{
	*this = CCircuitsDataBaseData;
}

TCCircuitsDataBaseData::~TCCircuitsDataBaseData(void)
{

}

void TCCircuitsDataBaseData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count;

	if(CArchiveFile.IsStoring())
	{
		count = CCircuitNameList.GetSize();

		CArchiveFile << count;

		for(int p = 0; p < count; p++)  CArchiveFile << CCircuitNameList[p].CName;

		CArchiveFile << CPath;
		CArchiveFile << CName;
		CArchiveFile << CIndex;
		CArchiveFile << index;
	}
	else
	{
		CArchiveFile >> count;

		CCircuitNameList.SetSize(count);

		for(int p = 0; p < count; p++)  CArchiveFile >> CCircuitNameList[p].CName;

		CArchiveFile >> CPath;
		CArchiveFile >> CName;
		CArchiveFile >> CIndex;
		CArchiveFile >> index;
	}
}

void TCCircuitsDataBaseData::operator = (TCCircuitsDataBaseData &CCircuitsDataBaseData)
{
	int count = CCircuitsDataBaseData.CCircuitNameList.GetSize();

	CCircuitNameList.SetSize(count);

	for(int p = 0; p < count; p++) CCircuitNameList[p] = CCircuitsDataBaseData.CCircuitNameList[p];

	CPath	= CCircuitsDataBaseData.CPath;
	CName	= CCircuitsDataBaseData.CName;
	CIndex	= CCircuitsDataBaseData.CIndex;
	index	= CCircuitsDataBaseData.index;
	HTreeItem = CCircuitsDataBaseData.HTreeItem;
}

int TCCircuitsDataBaseData::Find(CString CName)
{
	int count = CCircuitNameList.GetSize();

	if(!count) return -1;

	CName.MakeLower();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		TCCircuitsNameData &CCircuitsNameData = CCircuitNameList[p];

		CText = CCircuitsNameData.CName;

		CText.MakeLower();

		if(CText != CName) continue;

		return p;
	}
	
	return -1;
}

bool TCCircuitsDataBaseData::Save(int index)
{
	CString CFilePath = CPath + CName + "\\";
	CString CFileName;

	int count = CCircuitNameList.GetSize();//load data associated with CCircuitName

	if(!count) return true;

	if(index < 0) return false;

	if(!(index < count)) return false;

	TCSchematicPageData CPageData;

	TCCircuitsNameData &CCircuitsNameData = CCircuitNameList[index];
		
	CFileName = CFilePath + CCircuitsNameData.CName +".scl";

	if(!GCSuperSpiceClipboard.Load(CFileName)) return false;

	CPageData.CPageTitle = CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_TYPE].CValue;
		  
	CPageData.CPageTitle += '\n';// info stored by first line, this is all existing compatibility shit

	CPageData.CPageTitle += CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_NAME].CValue;

	CPageData.CPageInfo  = CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_DISCRIPTION].CValue;

	*GCSuperSpiceClipboard.PCMSchematicManagerClipboard->CMSchematicManagerData.PCPageData = CPageData;

	GCSuperSpiceClipboard.Save(CFileName);

	return true;
}

bool TCCircuitsDataBaseData::Save(void)
{
	//Save data description in directory given by:
	// Folder/Dir name set by call to AddCircuitsFile()

	CString CFilePath = CPath + CName + "\\";
	CString CFileName;

	int count = CCircuitNameList.GetSize();//load data associated with CCircuitName

	if(!count) return true;

	TCSchematicPageData CPageData;

	for(int p = 0; p < count; p++)// This uses data text fild that are already in the schematic manger
	{
		TCCircuitsNameData &CCircuitsNameData = CCircuitNameList[p];
		
		CFileName = CFilePath + CCircuitsNameData.CName +".scl";

		if(!GCSuperSpiceClipboard.Load(CFileName)) continue;

		CPageData.CPageTitle = CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_TYPE].CValue;
		  
		CPageData.CPageTitle += '\n';// info stored by first line, this is all existing compatibility shit

		CPageData.CPageTitle += CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_NAME].CValue;

		CPageData.CPageInfo  = CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_DISCRIPTION].CValue;

		*GCSuperSpiceClipboard.PCMSchematicManagerClipboard->CMSchematicManagerData.PCPageData = CPageData;

		GCSuperSpiceClipboard.Save(CFileName);
	}

	return true;
}

bool TCCircuitsDataBaseData::Load(void)
{
	//Load file names and data description in directory given by:
	// Folder/Dir name set by call to AddCircuitsFile()

	CString CFilePath = CPath + CName + "\\";

	if(!LoadCircuitList(CFilePath)) return false;

	int count = CCircuitNameList.GetSize();//load data associated with CCircuitName

	if(!count) return true;

	TCSchematicPageData CPageData;
	CString CFileName, CText;

	for(int p = 0; p < count; p++)
	{
		TCCircuitsNameData &CCircuitsNameData = CCircuitNameList[p];

		CFileName = CFilePath + CCircuitsNameData.CName +".scl";

		CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_NAME].CValue = CCircuitsNameData.CName;
		CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_FILE_NAME].CValue = CFileName;

		if(!GCSuperSpiceClipboard.Load(CFileName)) continue;

		CPageData = *GCSuperSpiceClipboard.PCMSchematicManagerClipboard->CMSchematicManagerData.PCPageData;

		if(CPageData.CPageTitle != "")
		{
			CText = GetFirstWord(CPageData.CPageTitle, '\n');

			CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_TYPE].CValue  = CText;
		
			CText = RemoveFirstWord(CPageData.CPageTitle, '\n');

			if(CText != "")
				CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_NAME].CValue = CText;
		}

		if(CPageData.CPageInfo != "")
			CCircuitsNameData.CAttributes[TE_CIRCUITS_ATTRIBUTES_CIRCUIT_DISCRIPTION].CValue = CPageData.CPageInfo;

	}

	return true;
}

bool TCCircuitsDataBaseData::LoadCircuitList(CString CPath)
{
	WIN32_FIND_DATA SFileData;

	CString CFileSearchSpec = CPath + GCDirFileSpecCircuits;

	CListBox CGenericListBox;

	CRect CDummy;

	CGenericListBox.Create(LBS_SORT, CDummy, AfxGetMainWnd(), 768);

	strcpy(GPGeneralFileNameBuffer, CFileSearchSpec);

	HANDLE fhandel = FindFirstFile(GPGeneralFileNameBuffer, &SFileData);

	if(!fhandel)  return false;

	CString CExtCheck;

	int result = true;

	while(fhandel && result)// Look in the directory
	{
		CExtCheck = GetFileExtention(SFileData.cFileName);

		CExtCheck.MakeLower();

		if(CExtCheck != "scl")
		{
			result = FindNextFile(fhandel, &SFileData);

			continue;
		}

		CGenericListBox.AddString(SFileData.cFileName);

		result = FindNextFile(fhandel, &SFileData);
	}

	int count = CGenericListBox.GetCount();

	if(!count) return false;
	
	CCircuitNameList.SetSize(0);
	CCircuitNameList.SetSize(count);

	TCCircuitsNameData CCircuitName;

	for(int p = 0; p < count; p++)// Now copy over list
	{
		CGenericListBox.GetText(p, CCircuitName.CName);

		CCircuitName.CName = RemoveExtention(CCircuitName.CName);

		CCircuitNameList[p] = CCircuitName;
	}

	return true;
}

//////////////////////////////////

TCCircuitsDataBase::TCCircuitsDataBase(void)
{
	index = -1;
}
TCCircuitsDataBase::TCCircuitsDataBase(TCCircuitsDataBase &CCircuitsDataBaseData)
{
	*this = CCircuitsDataBaseData;
}
TCCircuitsDataBase::~TCCircuitsDataBase(void)
{

}

void TCCircuitsDataBase::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count;

	int p;

	if(CArchiveFile.IsStoring())
	{
		count = CReseved.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++)  CArchiveFile << CReseved[p];

		CArchiveFile << CPath;
		CArchiveFile << CName;
		CArchiveFile << CIndex;
		CArchiveFile << index;

		count = CFileList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}
	}
	else
	{
		CArchiveFile >> count;

		CReseved.SetSize(count);

		for(p = 0; p < count; p++)  CArchiveFile >> CReseved[p];

		CArchiveFile >> CPath;
		CArchiveFile >> CName;
		CArchiveFile >> CIndex;
		CArchiveFile >> index;

		CArchiveFile >> count;

		CFileList.SetSize(count, count);

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}
	}
}
void TCCircuitsDataBase::operator = (TCCircuitsDataBase &CCircuitsDataBase)
{
	CCircuitsDataBase;

	int count = CCircuitsDataBase.CReseved.GetSize();

	CReseved.SetSize(count);

	int p;

	for(p = 0; p < count; p++) CReseved[p] = CCircuitsDataBase.CReseved[p];

	count = CCircuitsDataBase.CFileList.GetSize();

	for(p = 0; p < count; p++) CFileList[p] = CCircuitsDataBase.CFileList[p];

	CPath	= CCircuitsDataBase.CPath;
	CName	= CCircuitsDataBase.CName;
	CIndex	= CCircuitsDataBase.CIndex;
	index	= CCircuitsDataBase.index;
}

bool TCCircuitsDataBase::Save(void)
{
	int count, p;
	bool flag = true;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Save()) flag = false;
	}

	return flag;
}

bool TCCircuitsDataBase::Load(void)
{
	int count, p;
	bool flag = true;
	CString CErrorMsg;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Load()) 
		{
			CErrorMsg.LoadString(IDS_UNABLE_TO_OPEN_FILE);

			CErrorMsg += ' ' + CFileList[p].CPath + CFileList[p].CName;

			GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, CErrorMsg, 0);

			flag = false;
		}
	}

	return flag;
}

///////////////////////

//*********************************************

TCSymbolEditorData::TCSymbolEditorData(void)
{

}
TCSymbolEditorData::TCSymbolEditorData(TCSymbolEditorData &CSymbolEditorData)
{
	*this = CSymbolEditorData;
}
TCSymbolEditorData::~TCSymbolEditorData(void)
{

}

void TCSymbolEditorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CSymbolFileName;
		CArchiveFile << CSymbolName;
	}
	else
	{
		CArchiveFile >> CSymbolFileName;
		CArchiveFile >> CSymbolName;
	}
}

void TCSymbolEditorData::operator = (TCSymbolEditorData &CSymbolEditorData)
{
	CSymbolFileName = CSymbolEditorData.CSymbolFileName;
	CSymbolName		= CSymbolEditorData.CSymbolName;
}


/////////////////////////////////////////////
TCSpiceNodeNames::TCSpiceNodeNames(void)
{

}
TCSpiceNodeNames::TCSpiceNodeNames(TCSpiceNodeNames &CSpiceNodeNames)
{
	*this = CSpiceNodeNames;
}
TCSpiceNodeNames::~TCSpiceNodeNames(void)
{

}

void TCSpiceNodeNames::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCSpiceNodeNames::operator = (TCSpiceNodeNames &CSpiceNodeNames)
{
	CSpiceNodeNames;
}
/////////////////////////////////////
/////////////////////////////////////////////////////////////////
TCDataBaseClipboard::TCDataBaseClipboard(void)
{
	model_count			= 1;
	symbol_count		= 1;
	model_file_count	= 1;
	symbol_file_count	= 1;
}
TCDataBaseClipboard::TCDataBaseClipboard(TCDataBaseClipboard &TCDataBaseClipboard)
{
	*this = TCDataBaseClipboard;
}

TCDataBaseClipboard::~TCDataBaseClipboard(void)
{

}

void TCDataBaseClipboard::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CSource.Serialize(CArchiveFile);
	CDestination.Serialize(CArchiveFile);
	CFileSource.Serialize(CArchiveFile);
	CFileDestination.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << model_count;
		CArchiveFile << symbol_count;
		CArchiveFile << model_file_count;
		CArchiveFile << symbol_file_count;
	}
	else
	{
		CArchiveFile >> model_count;
		CArchiveFile >> symbol_count;
		CArchiveFile >> model_file_count;
		CArchiveFile >> symbol_file_count;
	}
}

void TCDataBaseClipboard::operator = (TCDataBaseClipboard &CDataBaseClipboard)
{
	CSource			= CDataBaseClipboard.CSource;
	CDestination	= CDataBaseClipboard.CDestination;

	model_count			= CDataBaseClipboard.model_count;
	symbol_count		= CDataBaseClipboard.symbol_count;
	model_file_count	= CDataBaseClipboard.model_file_count;
	symbol_file_count	= CDataBaseClipboard.symbol_file_count;	
}

CString TCDataBaseClipboard::GetNewModelFileName(void)
{
	CString CText;

	CText.Format("Copy%dof%s", model_file_count, CFileSource.CModelName);

	model_file_count++;

	return CText;
}

CString TCDataBaseClipboard::GetNewSymboFilelName(void)
{
	CString CText;

	CText.Format("Copy%dof%s", symbol_file_count, CFileSource.CSymbolName);

	symbol_file_count++;

	return CText;
}

CString TCDataBaseClipboard::GetNewModelName(void)
{
	CString CText;

	CText.Format("New%dof%s", model_count, CSource.CModelName);

	model_count++;

	return CText;
}

CString TCDataBaseClipboard::GetNewSymbolName(void)
{
	CString CText;

	CText.Format("New%dof%s", symbol_count, CSource.CSymbolName);

	symbol_count++;

	return CText;
}
////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
TCSymbolDataBaseDataList::TCSymbolDataBaseDataList(void)
{

}
TCSymbolDataBaseDataList::TCSymbolDataBaseDataList(TCSymbolDataBaseDataList &CSymbolDataBaseDataList)
{
	*this = CSymbolDataBaseDataList;
}
TCSymbolDataBaseDataList::~TCSymbolDataBaseDataList(void)
{

}

void TCSymbolDataBaseDataList::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCSymbolDataBaseDataList::operator = (TCSymbolDataBaseDataList &CSymbolDataBaseDataList)
{
	CSymbolDataBaseDataList;
}


TCComponentDataBaseData::TCComponentDataBaseData(void)
{
	use_index			= true;
	symbol_file_index	= 0;
	symbol_index		= 0;
	model_file_index	= 0;
	model_index			= 0;
	component_file_index= 0;
	component_index		= 0;
}

TCComponentDataBaseData::TCComponentDataBaseData(TCComponentDataBaseData &CComponentDataBaseData)
{
	*this = CComponentDataBaseData;
}
TCComponentDataBaseData::~TCComponentDataBaseData(void)
{

}

void TCComponentDataBaseData::Serialize(CArchive& CArchiveFile)
{
	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCComponentDataBaseData));
	}
	catch(...)
	{
		_fpreset();

		return;
	}

	CObject::Serialize(CArchiveFile);
		
	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << use_index;
		CArchiveFile << symbol_file_index;
		CArchiveFile << symbol_index;
		CArchiveFile << model_file_index;
		CArchiveFile << model_index;
		CArchiveFile << component_file_index;
		CArchiveFile << component_index;

		CArchiveFile << CSymbolName;
		CArchiveFile << CSymbolFileName;
		CArchiveFile << CSymbolPathName;

		CArchiveFile << CModelName;
		CArchiveFile << CModelFileName;
		CArchiveFile << CModelPathName;

		CArchiveFile << CComponentFileName;
		CArchiveFile << CComponentPathName;
		CArchiveFile << CComponentName;
		CArchiveFile << CComponentType;
		CArchiveFile << CComponentDescription;
	}
	else
	{
		CArchiveFile >> use_index;
		CArchiveFile >> symbol_file_index;
		CArchiveFile >> symbol_index;
		CArchiveFile >> model_file_index;
		CArchiveFile >> model_index;
		CArchiveFile >> component_file_index;
		CArchiveFile >> component_index;

		CArchiveFile >> CSymbolName;
		CArchiveFile >> CSymbolFileName;
		CArchiveFile >> CSymbolPathName;

		CArchiveFile >> CModelName;
		CArchiveFile >> CModelFileName;
		CArchiveFile >> CModelPathName;

		CArchiveFile >> CComponentFileName;
		CArchiveFile >> CComponentPathName;
		CArchiveFile >> CComponentName;
		CArchiveFile >> CComponentType;
		CArchiveFile >> CComponentDescription;
	}
}
void TCComponentDataBaseData::operator = (TCComponentDataBaseData &CComponentDataBaseData)
{
	use_index			= CComponentDataBaseData.use_index;
	symbol_file_index	= CComponentDataBaseData.symbol_file_index;
	symbol_index		= CComponentDataBaseData.symbol_index;
	model_file_index	= CComponentDataBaseData.model_file_index;
	model_index			= CComponentDataBaseData.model_index;
	component_file_index= CComponentDataBaseData.component_file_index;
	component_index		= CComponentDataBaseData.component_index;

	CSymbolName		= CComponentDataBaseData.CSymbolName;
	CSymbolFileName	= CComponentDataBaseData.CSymbolFileName;
	CSymbolPathName	= CComponentDataBaseData.CSymbolPathName;

	CModelName		= CComponentDataBaseData.CModelName;
	CModelFileName	= CComponentDataBaseData.CModelFileName;
	CModelPathName	= CComponentDataBaseData.CModelPathName;

	CComponentFileName		= CComponentDataBaseData.CComponentFileName;
	CComponentPathName	= CComponentDataBaseData.CComponentPathName;
	CComponentName			= CComponentDataBaseData.CComponentName;
	CComponentType			= CComponentDataBaseData.CComponentType;

	CComponentDescription	= CComponentDataBaseData.CComponentDescription;
}
bool TCComponentDataBaseData::operator != (TCComponentDataBaseData &CComponentDataBaseData)
{
	return !(*this == CComponentDataBaseData);
}

bool TCComponentDataBaseData::operator == (TCComponentDataBaseData &CComponentDataBaseData)
{
	CString CTemp1, CTemp2;

	CTemp1 = CComponentName;
	CTemp2 = CComponentDataBaseData.CComponentName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CComponentType;
	CTemp2 = CComponentDataBaseData.CComponentType;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CSymbolName;
	CTemp2 = CComponentDataBaseData.CSymbolName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CSymbolFileName;
	CTemp2 = CComponentDataBaseData.CSymbolFileName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CSymbolPathName;
	CTemp2 = CComponentDataBaseData.CSymbolPathName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CModelName;
	CTemp2 = CComponentDataBaseData.CModelName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CModelFileName;
	CTemp2 = CComponentDataBaseData.CModelFileName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CModelPathName;
	CTemp2 = CComponentDataBaseData.CModelPathName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	return true;
}

///////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
TCComponentDataBaseList::TCComponentDataBaseList(void)
{
	index = 0;
}
TCComponentDataBaseList::TCComponentDataBaseList(TCComponentDataBaseList &CComponentDataBaseList)
{
	*this = CComponentDataBaseList;
}
TCComponentDataBaseList::~TCComponentDataBaseList(void)
{

}

void TCComponentDataBaseList::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CName;
		CArchiveFile << CPath;
		CArchiveFile << CType;
		CArchiveFile << CNotes;
		CArchiveFile << CComboEdit;
		CArchiveFile << index;
	}
	else
	{
		CArchiveFile >> CName;
		CArchiveFile >> CPath;
		CArchiveFile >> CType;
		CArchiveFile >> CNotes;
		CArchiveFile >> CComboEdit;
		CArchiveFile >> index;
		
	}
}

void TCComponentDataBaseList::operator = (TCComponentDataBaseList &CComponentDataBaseList)
{
	CName	= CComponentDataBaseList.CName;
	CPath	= CComponentDataBaseList.CPath;
	CType	= CComponentDataBaseList.CType;
	CNotes	= CComponentDataBaseList.CNotes;
	CComboEdit = CComponentDataBaseList.CComboEdit;
	index	   = CComponentDataBaseList.index;

	int count, p;

	count = CComponentDataBaseList.CComponentList.GetSize();
	
	CComponentList.SetSize(count, count);

	for(p = 0; p < count; p++) CComponentList[p] = CComponentDataBaseList.CComponentList[p];
}

bool TCComponentDataBaseList::Get(TCComponentDataBaseData &CComponentDataBaseData)
{
	int index = Find(CComponentDataBaseData);

	if(index < 0) return false;

	CComponentDataBaseData = CComponentList[index];

	return true;
}

bool TCComponentDataBaseList::Set(TCComponentDataBaseData &CComponentDataBaseData)
{
	int index = Find(CComponentDataBaseData);

	if(index < 0)
	{
		CComponentList.Add(CComponentDataBaseData);
	}
	else
	{
		CComponentList[index] = CComponentDataBaseData;
	}

	return Save();
}


int  TCComponentDataBaseList::Find(TCComponentDataBaseData &CComponentDataBaseData)
{
	int count = CComponentList.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CComponentList[p] != CComponentDataBaseData) continue;

		return p;
	}

	return -1;
}

bool TCComponentDataBaseList::Load(void)
{
	CString CFileName;

	CFileName = CPath + CName;

	int p, count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::load);

	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCComponentDataBaseList));
	}
	catch(...)
	{
		_fpreset();

		return false;
	}

	count = CComponentList.GetSize();

	CArchiveFile >> count;

	for(p = 0; p < count; p++)
	{
		CComponentList[p].Serialize(CArchiveFile);

		CComponentList[p].CComponentPathName = CPath;
		CComponentList[p].CComponentFileName = CName;
	}

	return true;
}

bool TCComponentDataBaseList::Save(void)
{
	CString CFileName;

	CFileName = CPath + CName;

	int p, count;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::store);

	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCComponentDataBaseList));
	}
	catch(...)
	{
		_fpreset();

		return false;
	}

	count = CComponentList.GetSize();

	CArchiveFile << count;

	for(p = 0; p < count; p++)
	{
		CComponentList[p].Serialize(CArchiveFile);
	}

	return true;
}
//////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////


TCComponentDataBase::TCComponentDataBase(void)
{
	index = 0;
}
TCComponentDataBase::TCComponentDataBase(TCComponentDataBase &CComponentDataBase)
{
	*this = CComponentDataBase;
}
TCComponentDataBase::~TCComponentDataBase(void)
{

}
bool TCComponentDataBase::Save(void)
{
	int count, p;
	bool flag = true;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Save()) flag = false;
	}

	return flag;
}
bool TCComponentDataBase::Load(void)
{
	int count, p;
	bool flag = true;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Load()) flag = false;
	}

	return flag;
}
void TCComponentDataBase::Serialize(CArchive& CArchiveFile)
{
	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCComponentDataBase));
	}
	catch(...)
	{
		_fpreset();

		return;
	}

	CObject::Serialize(CArchiveFile);
		
	int count, p;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CComboEdit;
		CArchiveFile << index;

		count = CFileList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}
	}
	else
	{
		CArchiveFile >> CComboEdit;
		CArchiveFile >> index;

		CArchiveFile >> count;

		CFileList.SetSize(count, count);

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}
	}
}

void TCComponentDataBase::operator = (TCComponentDataBase &CComponentDataBase)
{
	int count, p;

	CComboEdit = CComponentDataBase.CComboEdit;
	index	   = CComponentDataBase.index;

	count = CComponentDataBase.CFileList.GetSize();
	
	CFileList.SetSize(count, count);

	for(p = 0; p < count; p++) CFileList[p] = CComponentDataBase.CFileList[p];
}


bool TCComponentDataBase::Get(TCComponentDataBaseData &CComponentDataBaseData)
{
	int count, p;

	CString CText1, CText2;

	CText1 = CComponentDataBaseData.CComponentPathName + 
			 CComponentDataBaseData.CComponentFileName;

	count = CFileList.GetSize();
	
	for(p = 0; p < count; p++)
	{
		CText2 = CFileList[p].CPath +
		         CFileList[p].CName;

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText2 != CText1) continue;

		if(CFileList[p].Get(CComponentDataBaseData)) return true;
	}

	return false;
}

bool TCComponentDataBase::Set(TCComponentDataBaseData &CComponentDataBaseData)
{
	CString CText1, CText2;

	CText1 = CComponentDataBaseData.CComponentPathName + 
	         CComponentDataBaseData.CComponentFileName;

	int count = CFileList.GetSize();

	for(int p = 0; p < count; p++)
	{
		CText2 = CFileList[p].CPath +
		         CFileList[p].CName;

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(!CFileList[p].Set(CComponentDataBaseData)) return false;
			
		return true;

	}

	TCComponentDataBaseList CComponentDataBaseList; 

	CComponentDataBaseList.CPath = CComponentDataBaseData.CComponentPathName;
	CComponentDataBaseList.CName = CComponentDataBaseData.CComponentFileName;
	
	CFileList.Add(CComponentDataBaseList);// create new file id

	count = CFileList.GetSize() - 1;

	// create new entry in file
	if(!CFileList[count].Set(CComponentDataBaseData)) return false;

	return true;
}


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

TCSymbolDataBaseData::TCSymbolDataBaseData(void)
{
	index = 0;
	HTreeItem = NULL;
}
TCSymbolDataBaseData::TCSymbolDataBaseData(TCSymbolDataBaseData &CSymbolDataBaseData)
{
	*this = CSymbolDataBaseData;
}
TCSymbolDataBaseData::~TCSymbolDataBaseData(void)
{

}

void TCSymbolDataBaseData::Serialize(CArchive& CArchiveFile)
{
	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSymbolDataBaseData));
	}
	catch(...)
	{
		_fpreset();

		return;
	}

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile <<	CPath;
		CArchiveFile <<	CName;
		CArchiveFile << CType;
		CArchiveFile << CNotes;
		CArchiveFile << CComboEdit;
		CArchiveFile << index;
	}
	else
	{
		CArchiveFile >>	CPath;
		CArchiveFile >>	CName;
		CArchiveFile >> CType;
		CArchiveFile >> CNotes;
		CArchiveFile >> CComboEdit;
		CArchiveFile >> index;

		HTreeItem = NULL;
	}
}
void TCSymbolDataBaseData::operator = (TCSymbolDataBaseData &CSymbolDataBaseData)
{
	CPath	= CSymbolDataBaseData.CPath;
	CName	= CSymbolDataBaseData.CName;
	CType	= CSymbolDataBaseData.CType;
	CNotes	= CSymbolDataBaseData.CNotes;
	CComboEdit = CSymbolDataBaseData.CComboEdit;
	index	   = CSymbolDataBaseData.index;
	HTreeItem = CSymbolDataBaseData.HTreeItem;

	int count = CSymbolDataBaseData.CSymbolList.GetSize();
	
	CSymbolList.SetSize(count, count);

	for(int p = 0; p < count; p++) CSymbolList[p] = CSymbolDataBaseData.CSymbolList[p];
}

bool TCSymbolDataBaseData::New(void)
{
	TCSchematicObjectData CSymbolData;

	CSymbolData.attached_model_type = E_SPICE_SCHEMATIC;

	CSymbolData.CSymbolData.CName = "Blank Symbol";// libary needs a blank symbol to avoid copying bug

	CSymbolList.SetSize(0);

	int id = CSymbolList.Add(CSymbolData);

	if(id < 0) return false;

	GCWorkspaceTree.AddSymbol(CPath + CName, id);

	return Save();
}

bool TCSymbolDataBaseData::Load(void)
{
	CString CFileName = CPath + CName;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::load);

	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSymbolDataBaseDataList));
	}
	catch(...)
	{
		_fpreset();

		return false;
	}

	int count, p;

	CArchiveFile >> count;

	CSymbolList.SetSize(count, count);

	for(p = 0; p < count; p++) 
	{
		CSymbolList[p].Serialize(CArchiveFile);

		CSymbolList[p].CSymbolData.CFilePath = CPath;
		CSymbolList[p].CSymbolData.CFileName = CName;
	}

	CArchiveFile.Close();
	CDataFile.Close();

	return true;
}

bool TCSymbolDataBaseData::Save(void)
{
	CString CFileName, CDummy;

	CFileName = CPath + CName;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::store | CFile::shareDenyNone);

	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSymbolDataBaseDataList));
	}
	catch(...)
	{
		_fpreset();

		return false;
	}

	int count = CSymbolList.GetSize();

	CArchiveFile << count;

	for(int p = 0; p < count; p++) 
	{
		CSymbolList[p].CSymbolData.CFilePath = CPath;
		CSymbolList[p].CSymbolData.CFileName = CName;

		CSymbolList[p].Serialize(CArchiveFile);
	}
	CArchiveFile.Close();
	CDataFile.Close();

	return true;
}

bool TCSymbolDataBaseData::CopyToNewDir(void)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!PCSuperSpiceApp) return false;

	CMultiDocTemplate *PCMSuperSpiceDocTemplate = PCSuperSpiceApp->GetSuperSpiceDocTemplate();

	if(!PCMSuperSpiceDocTemplate) return false;//major system error

	int count = CSymbolList.GetSize();
	bool flag = true;

	CString CNewSchematicName;
	CString COldSchematicName;

	for(int p = 0; p < count; p++) 
	{
		if(CSymbolList[p].attached_model_type != E_SPICE_SCHEMATIC) continue;

		COldSchematicName = ExtractFileName(CSymbolList[p].CSymbolData.CChildFileName);
		
		if(COldSchematicName == "") continue;

		CNewSchematicName = CPath + COldSchematicName;

		if(!CopyFile(CSymbolList[p].CSymbolData.CChildFileName, CNewSchematicName, 0))  {flag = false; continue;};

		PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMSuperSpiceDocTemplate->OpenDocumentFile(CNewSchematicName, false);

		if(!PCSuperSpiceDoc) {flag = false; continue;}

		PCSuperSpiceDoc->CopySymbolsSchematicsToNewDir(CPath);
		PCSuperSpiceDoc->ChangeSymbolsSchematicsDir(CPath);
		PCSuperSpiceDoc->RegenerateSchematicDocumentsWindowList(true);
		PCSuperSpiceDoc->OnSaveDocument(CNewSchematicName);
		PCSuperSpiceDoc->OnCloseDocument();

		CSymbolList[p].CSymbolData.CChildFileName = CNewSchematicName;
	}

	return flag;
}

bool TCSymbolDataBaseData::Get(TCSchematicObjectData &CSchematicObjectData)
{
	int index = Find(CSchematicObjectData.CSymbolData.CName);

	if(index < 0) return false;

	CSchematicObjectData = CSymbolList[index];

	return true;
}

bool TCSymbolDataBaseData::Set(TCSchematicObjectData &CSchematicObjectData, int insert_index)
{
	int index = Find(CSchematicObjectData.CSymbolData.CName);
	int id;

	if(index < 0) 
	{
		if(insert_index < 0 || !(insert_index < CSymbolList.GetSize()))
			id = CSymbolList.Add(CSchematicObjectData);
		else 
		{
			CSymbolList.InsertAt(insert_index, CSchematicObjectData);

			id = insert_index;
		}

		GCWorkspaceTree.AddSymbol(CPath + CName, id);

		return Save();
	}
	else
	{
		CSymbolList[index] = CSchematicObjectData;
	}

	return true;
}

int TCSymbolDataBaseData::Find(CString CName)
{
	int p, count;
	CString CText;

	CName.MakeUpper();
	count = CSymbolList.GetSize();

	for(p = 0; p < count; p++)
	{
		CText = CSymbolList[p].CSymbolData.CName;

		CText.MakeUpper();

		if(CText != CName) continue;

		return p;
	}

	return -1;
}

CArray<TCSchematicPinData, TCSchematicPinData &> &TCSymbolDataBaseData::GetPinListData(TCSchematicObjectData &CSchematicObjectData)
{
	int index = Find(CSchematicObjectData.CSymbolData.CName);

	if(index < 0) return CSchematicObjectData.CPinListData;

	return  CSymbolList[index].CPinListData;
}

///////////////////////////////////////////////////////////////
TCSymbolDataBase::TCSymbolDataBase(void)
{
	index = 0;
}
TCSymbolDataBase::TCSymbolDataBase(TCSymbolDataBase &CSymbolDataBase)
{
	*this = CSymbolDataBase;
}
TCSymbolDataBase::~TCSymbolDataBase(void)
{

}
bool TCSymbolDataBase::Save(void)
{
	int count, p;
	bool flag = true;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Save()) flag = false;
	}

	return flag;
}
bool TCSymbolDataBase::Load(void)
{
	int count, p;
	bool flag = true;
	CString CErrorMsg;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Load()) 
		{
			CErrorMsg.LoadString(IDS_UNABLE_TO_OPEN_FILE);

			CErrorMsg += ' ' + CFileList[p].CPath + CFileList[p].CName;

			GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, CErrorMsg, 0);

			flag = false;
		}
	}

	return flag;
}
void TCSymbolDataBase::Serialize(CArchive& CArchiveFile)
{
	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSymbolDataBase));
	}
	catch(...)
	{
		_fpreset();

		return;
	}

	CObject::Serialize(CArchiveFile);
		
	int count, p;
	int check = 654321;
	int check_read = 0;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CComboEdit;
		CArchiveFile << index;

		count = CFileList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}

		CArchiveFile << check;
	}
	else
	{
		CArchiveFile >> CComboEdit;
		CArchiveFile >> index;

		CArchiveFile >> count;

		CFileList.SetSize(count, count);

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}

		CArchiveFile >> check_read;

		if(check_read != check)
		{
			ASSERT(0);

			return;
		}
	}
}
void TCSymbolDataBase::operator = (TCSymbolDataBase &CSymbolDataBase)
{
	int count, p;

	CComboEdit = CSymbolDataBase.CComboEdit;
	index	   = CSymbolDataBase.index;

	count = CSymbolDataBase.CFileList.GetSize();
	
	CFileList.SetSize(count, count);

	for(p = 0; p < count; p++) CFileList[p] = CSymbolDataBase.CFileList[p];
}

bool TCSymbolDataBase::Get(TCSchematicObjectData &CSchematicObjectData)
{
	CString CText1, CText2;

	bool null_path = false;

	if(CSchematicObjectData.CSymbolData.CFilePath != "")
	{
		CText2 = CSchematicObjectData.CSymbolData.CFilePath + 
			     CSchematicObjectData.CSymbolData.CFileName;
	}
	else 
	{
		null_path = true;

		CText2 = CSchematicObjectData.CSymbolData.CFileName;
	}

	int count = CFileList.GetSize();

	for(int p = 0; p < count; p++) // if null path find first available
	{
		if(CSchematicObjectData.CSymbolData.CFilePath != "")
		CText1 = CFileList[p].CPath + CFileList[p].CName;
		else CText1 = CFileList[p].CName;

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(!CFileList[p].Get(CSchematicObjectData)) continue;

		if(null_path) CSchematicObjectData.CSymbolData.CFilePath = "";// recover original null path
		
		return true;
	}

	return false;
}

bool TCSymbolDataBase::Set(TCSchematicObjectData &CSchematicObjectData, bool save, int insert_index)
{
	CString CText1, CText2;

	int count = CFileList.GetSize();

	for(int p = 0; p < count; p++)
	{
		CText1 = CFileList[p].CPath + CFileList[p].CName;
		CText2 = CSchematicObjectData.CSymbolData.CFilePath + 
			     CSchematicObjectData.CSymbolData.CFileName;

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(!CFileList[p].Set(CSchematicObjectData, insert_index)) return false;

		if(save) return CFileList[p].Save();
			
		return true;
	}

	TCSymbolDataBaseData CSymbolDataBaseData;

	CSymbolDataBaseData.CPath	= CSchematicObjectData.CSymbolData.CFilePath;
	CSymbolDataBaseData.CName	= CSchematicObjectData.CSymbolData.CFileName;
	CSymbolDataBaseData.CType	= RemoveExtention(CSymbolDataBaseData.CName);

	CFileList.Add(CSymbolDataBaseData);// create new file id

	count = CFileList.GetSize() - 1;

	if(count < 0) return false;

	if(!CFileList[count].Load()) return false;
	// create new entry in file
	if(!CFileList[count].Set(CSchematicObjectData)) return false;

	return true;
}

CArray<TCSchematicPinData, TCSchematicPinData &> &TCSymbolDataBase::GetPinListData(TCSchematicObjectData &CSchematicObjectData)
{
	CString CText1, CText2;

	CText2 = CSchematicObjectData.CSymbolData.CFilePath + 
			 CSchematicObjectData.CSymbolData.CFileName;

	int count = CFileList.GetSize();

	int p;

	for(p = 0; p < count; p++)// first try and find the exact match
	{
		CText1 = CFileList[p].CPath + CFileList[p].CName;

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		return CFileList[p].GetPinListData(CSchematicObjectData);
	}

	CText2 = CSchematicObjectData.CSymbolData.CFileName;

	for(p = 0; p < count; p++)// Now ignore the path and try and find the symbol data
	{
		CText1 = CFileList[p].CName;

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		return CFileList[p].GetPinListData(CSchematicObjectData);
	}

	return CSchematicObjectData.CPinListData;
}

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////
TCModelDataBaseData::TCModelDataBaseData(void)
{
	index = 0;
	HTreeItem = 0;
}
TCModelDataBaseData::TCModelDataBaseData(TCModelDataBaseData &CModelDataBaseData)
{
	*this = CModelDataBaseData;
}
TCModelDataBaseData::~TCModelDataBaseData(void)
{

}

void TCModelDataBaseData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

//  Do not Serialize parameter data, data is loaded from text file
//	CParametersList.Serialize(CArchiveFile);
	
	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CPath;
		CArchiveFile << CName;
		CArchiveFile << CType;
		CArchiveFile << CNotes;
		CArchiveFile << CComboEdit;
		CArchiveFile << index;
	}
	else
	{
		CArchiveFile >> CPath;
		CArchiveFile >> CName;
		CArchiveFile >> CType;
		CArchiveFile >> CNotes;
		CArchiveFile >> CComboEdit;
		CArchiveFile >> index;

		HTreeItem = NULL;
	}
}
void TCModelDataBaseData::operator = (TCModelDataBaseData &CModelDataBaseData)
{
	CPath	= CModelDataBaseData.CPath;
	CName	= CModelDataBaseData.CName;
	CType	= CModelDataBaseData.CType;
	CNotes	= CModelDataBaseData.CNotes;
	CComboEdit = CModelDataBaseData.CComboEdit;
	index	   = CModelDataBaseData.index;
	HTreeItem = CModelDataBaseData.HTreeItem;

	CParametersList = CModelDataBaseData.CParametersList;
}

bool TCModelDataBaseData::Load(void)
{
	CString CFileName;

	CFileName = CPath + CName;

	return CParametersList.LoadAll(CFileName);
}

bool TCModelDataBaseData::Save(void)
{
	CString CFileName;

	CFileName = CPath + CName;

	return CParametersList.SaveAll(CFileName);
}

bool TCModelDataBaseData::Get(TCSpiceParameters &CSpiceParameters)
{
	CString CText;

	CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

	int index = CParametersList.FindModelOrSubcircuit(CText);

	if(index > -1) 
	{
		CSpiceParameters = CParametersList.CParameters[index];

		return true;
	}

	// If not found try a normal name (without the _?? SuperSpice addition)
	CText = CText.Left(CText.GetLength() - 3);
	
	if(CText == "") return false;

	index = CParametersList.FindModelOrSubcircuit(CText);

	if(index < 0) return false;

	CSpiceParameters = CParametersList.CParameters[index];

	CSpiceParameters.CDataBaseIdInfo.CRecordName  += "_XN";
	CSpiceParameters.CDataBaseIdInfo.matched		= 1;
	CSpiceParameters.CDataBaseIdInfo.strength		= 1;

	CSpiceParameters.Rename(CSpiceParameters.CDataBaseIdInfo.CRecordName);

	return true;
}

TCSpiceParameters *TCModelDataBaseData::GetPointer(TCSpiceParameters &CSpiceParameters)
{
	CString CText;

	CText = CSpiceParameters.CDataBaseIdInfo.CRecordName;

	int index = CParametersList.FindModelOrSubcircuit(CText);

	if(index > -1) 
	{
		return &CParametersList.CParameters[index];
	}

	return NULL;
}

bool TCModelDataBaseData::Set(TCSpiceParameters &CSpiceParameters, int insert_index)
{
	int index = CParametersList.FindModelOrSubcircuit(CSpiceParameters.CDataBaseIdInfo.CRecordName);
	int id;

	if(index < 0) 
	{
		if(CSpiceParameters.IsEmpty()) 
		{
			ASSERT(0);

			return false;// dont create if no data
		}

		if(insert_index < 0 || !(insert_index < CParametersList.CParameters.GetSize()))
			id = CParametersList.CParameters.Add(CSpiceParameters);
		else
		{
			id = insert_index;

			CParametersList.CParameters.InsertAt(insert_index, CSpiceParameters);
		}

		GCWorkspaceTree.AddModel(CPath + CName, id);
	}
	else
	{
		CParametersList.CParameters[index] = CSpiceParameters;
	}

	return Save();
}

//////////////////////////////////
TCModelDataBase::TCModelDataBase(void)
{
	index = 0;
}
TCModelDataBase::TCModelDataBase(TCModelDataBase &CModelDataBase)
{
	*this = CModelDataBase;
}
TCModelDataBase::~TCModelDataBase(void)
{

}
bool TCModelDataBase::Save(void)
{
	int count, p;
	bool flag = true;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Save()) flag = false;
	}

	return flag;
}
bool TCModelDataBase::Load(void)
{
	int count, p;
	bool flag = true;
	CString CErrorMsg;

	count = CFileList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CFileList[p].Load()) 
		{
			CErrorMsg.LoadString(IDS_UNABLE_TO_OPEN_FILE);

			CErrorMsg += ' ' + CFileList[p].CPath + CFileList[p].CName;

			GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, CErrorMsg, 0);

			flag = false;
		}
	}

	return flag;
}

void TCModelDataBase::Serialize(CArchive& CArchiveFile)
{
	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCModelDataBase));
	}
	catch(...)
	{
		_fpreset();

		return;
	}

	CObject::Serialize(CArchiveFile);
		
	int count, p;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CComboEdit;
		CArchiveFile << index;

		count = CFileList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);
		}
	}
	else
	{
		CArchiveFile >> CComboEdit;
		CArchiveFile >> index;

		CArchiveFile >> count;

		CFileList.SetSize(count, count);

		for(p = 0; p < count; p++) 
		{
			CFileList[p].Serialize(CArchiveFile);// read in names of the text files to beloaded
		}
	}
}
void TCModelDataBase::operator = (TCModelDataBase &CModelDataBase)
{
	int count, p;

	CComboEdit = CModelDataBase.CComboEdit;
	index	   = CModelDataBase.index;

	count = CModelDataBase.CFileList.GetSize();
	
	CFileList.SetSize(count, count);

	for(p = 0; p < count; p++) CFileList[p] = CModelDataBase.CFileList[p];
}

bool TCModelDataBase::Get(TCSpiceParameters &CSpiceParameters)
{
	CString CText1, CText2;

	CString CRecordFilePath = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	CString CRecordFileName = CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CRecordFilePath.TrimLeft();
	CRecordFilePath.TrimRight();
	CRecordFileName.TrimLeft();
	CRecordFileName.TrimRight();
	
	int count = CFileList.GetSize();

	// Ignore path for now
	CRecordFilePath = "";

	int p;

	for(p = 0; p < count; p++)// try exact file, first irrespective of ignore path
	{
		if(CRecordFilePath != "")// if null path find first available
		{
				CText1 = CFileList[p].CPath + CFileList[p].CName;
				CText2 = CRecordFilePath + CRecordFileName;
		}
		else
		{
			CText1 = CFileList[p].CName;
			CText2 = CRecordFileName;
		}

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(!CFileList[p].Get(CSpiceParameters)) continue;

		CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CFileList[p].CPath;

		return true;
	}

	for(p = 0; p < count; p++)// try any path if flaged
	{
		if(GCSuperSpiceGlobalData.CGeneric.ignore_model_path)
		{
			CText1 = CFileList[p].CName;
			CText2 = CRecordFileName;
		}
		else
		{
			return false;
		}

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(!CFileList[p].Get(CSpiceParameters)) continue;

		CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CFileList[p].CPath;

		return true;
	}

	return false;
}

TCSpiceParameters *TCModelDataBase::GetPointer(TCSpiceParameters &CSpiceParameters, bool auto_wc)
{
	CString CText1, CText2;

	TCSpiceParameters *PCSpiceParameters = NULL;
	
	CString CRecordFilePath = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	CString CRecordFileName = CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CRecordFilePath.TrimLeft();
	CRecordFilePath.TrimRight();
	CRecordFileName.TrimLeft();
	CRecordFileName.TrimRight();

	int count = CFileList.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{

		if(CRecordFilePath != "")// if null path find first available
		{
			CText1 = CFileList[p].CPath + CFileList[p].CName;
			CText2 = CRecordFilePath + CRecordFileName;
		}
		else
		{
			CText1 = CFileList[p].CName;
			CText2 = CRecordFileName;
		}

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(CText1 == "") continue;

		PCSpiceParameters = CFileList[p].GetPointer(CSpiceParameters);
		
		if(PCSpiceParameters) return PCSpiceParameters;// dont need recover original null
	}

	for(p = 0; p < count; p++)
	{
		if(GCSuperSpiceGlobalData.CGeneric.ignore_model_path)
		{
			CText1 = CFileList[p].CName;
			CText2 = CRecordFileName;
		}
		else 
		{
			return NULL;
		}

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		if(CText1 == "") continue;

		PCSpiceParameters = CFileList[p].GetPointer(CSpiceParameters);
		
		if(PCSpiceParameters) return PCSpiceParameters;// dont need recover original null
	}

	if(auto_wc) return GetAutoWCPointer(CSpiceParameters);
	
	return NULL;
}

TCSpiceParameters *TCModelDataBase::GetAutoWCPointer(TCSpiceParameters &CSpiceParameters)
{
	// this function will automatically generate WC parameters based on a variation spec in
	// the SuperSpice main lib.

	// First get the orignal model

	TCSpiceParameters CLocalSpiceParameters;

	CLocalSpiceParameters.CDataBaseIdInfo = CSpiceParameters.CDataBaseIdInfo;
	
	CString	CRecordName = CLocalSpiceParameters.CDataBaseIdInfo.CRecordName;

	CLocalSpiceParameters.CSymbolParameters = CSpiceParameters.CSymbolParameters;

	CString CType = CRecordName.Right(3);

	CRecordName = CRecordName.Left(CRecordName.GetLength() - 3);

	CRecordName += "_XN";

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName = CRecordName;

	TCSpiceParameters *PCSpiceParameters = GetPointer(CLocalSpiceParameters);

	if(!PCSpiceParameters) return NULL;// should not happen

	CMAutoWCSpiceParameters = CSpiceParameters;	//copy all existaing data

//// Added 11th Sept 2004 to fix bug. It needs the base name data.
	int count = PCSpiceParameters->CData.GetSize();
 
	if(!count) return NULL;

//	PCSpiceParameters->CSymbolParameters = CSpiceParameters.CSymbolParameters;

	CMAutoWCSpiceParameters.CData.SetSize(count);

	int p;

	for(p = 0; p < count; p++)
	{
		CMAutoWCSpiceParameters.CData[p] = PCSpiceParameters->CData[p];
	}

/////Added 11th Sept 2004 to fix bug. It needs the base name data.

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName	= "";
	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName		= "";

	CString CPathAndName;

	PCSpiceParameters->Get(GSSWCFileName, &CPathAndName);
	PCSpiceParameters->Get(GSSWCModelName, &CLocalSpiceParameters.CDataBaseIdInfo.CRecordName);

	CPathAndName.Remove('[');
	CPathAndName.Remove(']');
	CPathAndName.TrimRight();
	CPathAndName.TrimLeft();

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName.Remove('[');
	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName.Remove(']');

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName = ExtractFileName(CPathAndName);
	CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CPathAndName);

	if(CLocalSpiceParameters.CDataBaseIdInfo.CRecordName == "")// use default rather then user one
	{
		// Now setup and get the data multpliers
		CString CDefaultDir = GetInitDirectory();

		CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName = GCSuperSpiceDataBase.CSuperSpiceModelLibName;
		CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CDefaultDir;
	
		CLocalSpiceParameters.CDataBaseIdInfo.CRecordName = GSSWCDefaltName + CLocalSpiceParameters.CDataBaseIdInfo.CRecordType;

		CLocalSpiceParameters.CDataBaseIdInfo.CRecordName += CType;
	}
	else 
	{
		CLocalSpiceParameters.CDataBaseIdInfo.CRecordName += CType;
	}

	CMAutoWCSpiceParameters.CDataBaseIdInfo.CRecordName     =  CLocalSpiceParameters.CDataBaseIdInfo.CRecordName;// return WC data location spec
	CMAutoWCSpiceParameters.CDataBaseIdInfo.CRecordFileName =  CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CMAutoWCSpiceParameters.CDataBaseIdInfo.CRecordFilePath =  CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath;

	if(CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath == "") CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	
	PCSpiceParameters = GetPointer(CLocalSpiceParameters);

	if(!PCSpiceParameters) return NULL;

//	PCSpiceParameters->CSymbolParameters = CSpiceParameters.CSymbolParameters;
		
	CString CName;

	double data = 1;

	CString CValue, CValueText;
	double result = 0;

	for(p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = CMAutoWCSpiceParameters.CData[p];
		
		CName = CNameValueData.CName;

		CMAutoWCSpiceParameters.EvaluateModelParameters(CSpiceParameters.CSymbolParameters, p);// update CData[p]

		if(!PCSpiceParameters->Get(CName, &data)) // Get the multiplier value
		{
			CNameValueData.include = false;

			continue;
		}

		if(data != 1) CNameValueData.include = true;// rerun support, dont include unity multipliers
		else 
		{
			CNameValueData.include = false;

			continue;
		}

		if(!data) // try string for mult, + or -, as mult by 0 is meaningless
		{
			PCSpiceParameters->GetString(CName, &CValueText);// see if string
	
			if(CValueText == "") //Shouldnt happen
			{
				CNameValueData.include = false;

				continue;
			}

			CValue.Format("%e", CNameValueData.value);

			CValue += " " + CValueText; // 2.45 *3.23 or 2.45 -3.23

			if(!EquationSetVaribles(CSpiceParameters.CSymbolParameters)) continue;

			if(!Equation(CValue, &result)) continue;

			CNameValueData.include = true;

			CNameValueData.value = result;

			continue;
		}

		CNameValueData.include = true;

		CNameValueData.value *= data; // main calculation update of nominal to WC data
	}

	return &CMAutoWCSpiceParameters;
}

TCSpiceParameters *TCModelDataBase::GetWCMCModelPointer(TCSpiceParameters &CSpiceParameters, CString CWCMCRunType)
{
	TCSpiceParameters CLocalSpiceParameters = CSpiceParameters;

	CString CPathAndName;

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName	= "";
	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName		= "";

	CSpiceParameters.Get(GSSWCFileName, &CPathAndName);
	CSpiceParameters.Get(GSSWCModelName, &CLocalSpiceParameters.CDataBaseIdInfo.CRecordName);

	CPathAndName.Remove('[');
	CPathAndName.Remove(']');
	CPathAndName.TrimRight();
	CPathAndName.TrimLeft();

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName.Remove('[');
	CLocalSpiceParameters.CDataBaseIdInfo.CRecordName.Remove(']');

	CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName = ExtractFileName(CPathAndName);
	CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CPathAndName);

	if(CLocalSpiceParameters.CDataBaseIdInfo.CRecordName == "")// use default rather then user one
	{
		// Now setup and get the data multpliers
		CString CDefaultDir = GetInitDirectory();

		CLocalSpiceParameters.CDataBaseIdInfo.CRecordFileName = GCSuperSpiceDataBase.CSuperSpiceModelLibName;
		CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CDefaultDir;
	
		CLocalSpiceParameters.CDataBaseIdInfo.CRecordName = GSSWCDefaltName + CLocalSpiceParameters.CDataBaseIdInfo.CRecordType;

		CLocalSpiceParameters.CDataBaseIdInfo.CRecordName += CWCMCRunType;
	}
	else CLocalSpiceParameters.CDataBaseIdInfo.CRecordName += CWCMCRunType;

	if(CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath == "") CLocalSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	
	return GetPointer(CLocalSpiceParameters, true);
}


bool TCModelDataBase::Set(TCSpiceParameters &CSpiceParameters, int insert_index)
{
	CString CText1, CText2;
	CString CRecordFilePath = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;

	int count = CFileList.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(GCSuperSpiceGlobalData.CGeneric.ignore_model_path)
		{
			CText1 = CFileList[p].CName;
			CText2 = CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
		}
		else
		{
			CText1 = CFileList[p].CPath + CFileList[p].CName;
			CText2 = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath + 
			         CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
		}

		CText1.MakeUpper();
		CText2.MakeUpper();

		if(CText1 != CText2) continue;

		CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CFileList[p].CPath;

		if(!CFileList[p].Set(CSpiceParameters, insert_index)) return false;
			
		return true;
	}

	TCModelDataBaseData CModelDataBaseData;

	CModelDataBaseData.CPath	= CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	CModelDataBaseData.CName	= CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CModelDataBaseData.CType	= RemoveExtention(CModelDataBaseData.CName);

	CFileList.Add(CModelDataBaseData);

	count = CFileList.GetSize() - 1;

	if(count < 0) return false;

	if(!CFileList[count].Load()) return false;

	if(!CFileList[count].Set(CSpiceParameters)) return false;

	return true;
}

////////////////////////////////

///////////////////////////////////////////
bool TCSuperSpiceDataBase::RemoveSymbol(int file_index, int symbol_index)
{
	if(!(file_index < CSymbolDataBase.CFileList.GetSize())) return false;

//	symbol_index = CSymbolDataBase.CFileList[file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = CSymbolDataBase.CFileList[file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return false;

	if(symbol_index < 0) return false;

	GCWorkspaceTree.RemoveSymbol(CSymbolList[symbol_index].HTreeItem);

	CSymbolList.RemoveAt(symbol_index);

	return true;
}

bool TCSuperSpiceDataBase::RemoveModel(int file_index, int model_index)
{
	if(!(file_index < CModelDataBase.CFileList.GetSize())) return false;

	TCSpiceParametersList &CModelList = CModelDataBase.CFileList[file_index].CParametersList;

	if(!(model_index < CModelList.CParameters.GetSize())) return false;

	GCWorkspaceTree.RemoveModel(CModelList.CParameters[model_index].HTreeItem);

	CModelList.CParameters.RemoveAt(model_index);

	return true;
}

bool TCSuperSpiceDataBase::AddModelFile(CString CFileName)
{
	if(FindModelFile(CFileName) > -1) return false;// dont add twice

	TCModelDataBaseData CModelDataBaseData;

	CModelDataBaseData.CPath = ExtractPathName(CFileName);
	CModelDataBaseData.CName = ExtractFileName(CFileName);
	CModelDataBaseData.CType = RemoveExtention(CModelDataBaseData.CName);

	CModelDataBase.CFileList.Add(CModelDataBaseData);

	SaveModelsList();

	int count = CModelDataBase.CFileList.GetSize();

	if(!count) return false;

	count--;

	if(CModelDataBase.CFileList[count].Load())
	{
		return GCWorkspaceTree.AddModelFile(count);
	}

	CModelDataBase.CFileList.RemoveAt(count);
	
	return false;
}

bool TCSuperSpiceDataBase::AddModelToUserLibrary(CString CModelFileName)
{
	CString CFileName = ExtractFileName(CModelFileName);
	CString CFilePath = ExtractPathName(CModelFileName);

	CString CSystemDir = GetSuperSpiceSystemDir();

	CString CUserModelFileName = CSystemDir + "UserModels.lib";
	CString CUserSymbolFileName = CSystemDir + "UserSymbols.ssm";

	if(!FileExists(CUserModelFileName))
	{
		if(!CopyFile(CModelFileName, CUserModelFileName, 0)) return false;

		if(!AddModelFile(CUserModelFileName)) return false;
	}
 
	int index;

	index = GCSuperSpiceDataBase.FindModelFile(CUserModelFileName);

	if(index < 0) // make sure the model file is loaded
	{
		if(!AddModelFile(CUserModelFileName)) return false;
	}

	index = GCSuperSpiceDataBase.FindModelFile(CUserModelFileName);

	if(index < 0) return false;//cant happen now

	// now to add the first model in the file to the user file

	TCModelDataBaseData CModelDataBaseData;//temp buffer

	CModelDataBaseData.CName = CFileName;//source file is .cir
	CModelDataBaseData.CPath = CFilePath;//source file is .cir

	CModelDataBaseData.Load(); //load source file

	if(!CModelDataBaseData.CParametersList.CParameters.GetSize()) return false;// no model in file

	TCDataBaseIdInfo &CDataBaseIdInfo = CModelDataBaseData.CParametersList.CParameters[0].CDataBaseIdInfo;

	CDataBaseIdInfo.CSymbolName	= RemoveExtention(CFileName);
	CDataBaseIdInfo.CSymbolFileName = CUserSymbolFileName;
	
	CModelDataBaseData.CName = ExtractFileName(CUserModelFileName);
	CModelDataBaseData.CPath = ExtractPathName(CUserModelFileName);

	CDataBaseIdInfo.CRecordFilePath	= CModelDataBaseData.CPath;
	CDataBaseIdInfo.CRecordFileName	= CModelDataBaseData.CName;

	CModelDataBaseData.CParametersList.CParameters[0].AddSubcircuitSymbolName();

	//now set database
	return CModelDataBase.CFileList[index].Set(CModelDataBaseData.CParametersList.CParameters[0]);
}

bool TCSuperSpiceDataBase::ReloadModelFile(CString CFileName)
{
	int index;

	index = GCSuperSpiceDataBase.FindModelFile(CFileName);

	if(index < 0) return false;

	bool value = CModelDataBase.CFileList[index].Load();

	GCWorkspaceTree.RefreshModelFiles();

	return value;
}

bool TCSuperSpiceDataBase::RemoveModelFile(int id)
{
	if(id < 0) return false;

	if(id >= CModelDataBase.CFileList.GetSize()) return false;

	CModelDataBase.CFileList.RemoveAt(id);

	GCWorkspaceTree.RefreshModelFiles();

	return true;
}

bool TCSuperSpiceDataBase::AddSymbolFile(CString CFileName)
{
	if(FindSymbolFile(CFileName) > -1) return false;// dont add twice
	
	TCSymbolDataBaseData CSymbolDataBaseData;

	CSymbolDataBaseData.CPath = ExtractPathName(CFileName);
	CSymbolDataBaseData.CName = ExtractFileName(CFileName);
	CSymbolDataBaseData.CType = RemoveExtention(CSymbolDataBaseData.CName);

	CSymbolDataBase.CFileList.Add(CSymbolDataBaseData);

	SaveSymbolsList();

	int count = CSymbolDataBase.CFileList.GetSize();

	if(!count) return false;

	count--;

	if(CSymbolDataBase.CFileList[count].Load())
	{
		return GCWorkspaceTree.AddSymbolFile(count);	
	}

	CSymbolDataBase.CFileList.RemoveAt(count);

	return false;
}

bool TCSuperSpiceDataBase::AddCircuitsFile(CString CFileName)
{
	if(FindCircuitsFile(CFileName) > -1) return false;// dont add twice
	
	TCCircuitsDataBaseData CCircuitsDataBaseData;
 
	CCircuitsDataBaseData.CPath = ExtractPathName(CFileName);
	CCircuitsDataBaseData.CName = ExtractFileName(CFileName);

	CCircuitsDataBase.CFileList.Add(CCircuitsDataBaseData);

	int count = CCircuitsDataBase.CFileList.GetSize();

	if(!count) return false;

	count--;

	if(CCircuitsDataBase.CFileList[count].Load())
	{
		//if(PGCProjectWorkspaceTabedControlBar)
		//	return PGCProjectWorkspaceTabedControlBar->AddCircuitsFolder(count); //need to fix this
		//	PGCProjectWorkspaceTabedControlBar->Refresh();

		return true;
	}

	CCircuitsDataBase.CFileList.RemoveAt(count);

	return false;
}

bool TCSuperSpiceDataBase::NewSymbolFile(CString CFileName)
{
	if(FindSymbolFile(CFileName) > -1) return false;// dont add twice
	
	TCSymbolDataBaseData CSymbolDataBaseData;

 
	CSymbolDataBaseData.CPath = ExtractPathName(CFileName);
	CSymbolDataBaseData.CName = ExtractFileName(CFileName);
	CSymbolDataBaseData.CType = RemoveExtention(CSymbolDataBaseData.CName);

	if(!CSymbolDataBaseData.New()) return false;

	CSymbolDataBase.CFileList.Add(CSymbolDataBaseData);

	SaveSymbolsList();

	int count = CSymbolDataBase.CFileList.GetSize();

	if(!count) return false;

	count--;

	if(CSymbolDataBase.CFileList[count].Load())
	{
		return GCWorkspaceTree.AddSymbolFile(count);
	}

	CSymbolDataBase.CFileList.RemoveAt(count);

	return false;
}

bool TCSuperSpiceDataBase::NewSymbol(CString CFileName)
{
	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);

	CSchematicObjectData.CSymbolData.CName		= CClipboard.GetNewSymbolName();
	CSchematicObjectData.CSymbolData.CFileName	= ExtractFileName(CFileName);
	CSchematicObjectData.CSymbolData.CFilePath	= ExtractPathName(CFileName);

	CSchematicObjectData.CSymbolData.CChildFileName = "";
	CSchematicObjectData.attached_model_type = E_SPICE_DOT_SUBCIRCUIT;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CSchematicObjectData.CSymbolData.CName;

	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "(NULL)";

	return CSymbolDataBase.Set(CSchematicObjectData, false);// will automatically be saved as it does not exist
}

bool TCSuperSpiceDataBase::DoublicateSymbol(CString CNewFileName, TCSchematicObjectData &CSchematicObjectDataOld)
{
	TCSchematicObjectData CSchematicObjectData;
	CString CSystemDir = GetSuperSpiceSystemDir();

	//need to get data base version
	CSchematicObjectData.CSymbolData.CName		= CSchematicObjectDataOld.CSymbolData.CName;
	CSchematicObjectData.CSymbolData.CFileName	= CSchematicObjectDataOld.CSymbolData.CFileName;
	CSchematicObjectData.CSymbolData.CFilePath	= CSchematicObjectDataOld.CSymbolData.CFilePath;

	if(!CSymbolDataBase.Get(CSchematicObjectData))return false;

	CSchematicObjectData.CSymbolData.CName	= ExtractFileName(CNewFileName);
	CSchematicObjectData.CSymbolData.CName	= RemoveExtention(CSchematicObjectData.CSymbolData.CName);

	CSchematicObjectData.CSymbolData.CFileName = "UserSymbols.ssm";
	CSchematicObjectData.CSymbolData.CFilePath = CSystemDir;
	CSchematicObjectData.CSymbolData.CChildFileName = CNewFileName;

	CSchematicObjectData.Rename(CSchematicObjectData.CSymbolData.CName);

	CheckAndCorrectSymbolData(CSchematicObjectData);

	CString CSymbolFileName = CSchematicObjectData.CSymbolData.CFilePath + CSchematicObjectData.CSymbolData.CFileName;

	//if not loaded or existing, create one
	int file_index = FindSymbolFile(CSymbolFileName);

	if(file_index < 0)// create one
	{
		if(!NewSymbolFile(CSymbolFileName)) return false;
	}

	file_index = FindSymbolFile(CSymbolFileName);

	if(file_index < 0) return false;

	if(!CSymbolDataBase.Set(CSchematicObjectData, false)) return false;// will automatically be saved as it does not exist

	CSchematicObjectDataOld.CSymbolData.CName		= CSchematicObjectData.CSymbolData.CName;
	CSchematicObjectDataOld.CSymbolData.CFileName	= CSchematicObjectData.CSymbolData.CFileName;
	CSchematicObjectDataOld.CSymbolData.CFilePath	= CSchematicObjectData.CSymbolData.CFilePath;

	CSchematicObjectDataOld.CSymbolData.CChildFileName = CNewFileName;

	CSchematicObjectDataOld.Rename(CSchematicObjectData.CSymbolData.CName);

	int symbol_index = CSymbolDataBase.CFileList[file_index].Find("Blank Symbol");

	if(symbol_index < 0) return false;

	RemoveSymbol(file_index, symbol_index);

	return true;
}

bool TCSuperSpiceDataBase::AddSymbol(int file_index, CString CFileName)
{
	file_index;
	return false;
}

bool TCSuperSpiceDataBase::AddModel(int file_index, CString CFileName)
{
	file_index;
	return false;
}

bool TCSuperSpiceDataBase::CopySymbol(TCDataBaseClipboard &CDataBaseClipboard)
{
	CClipboard.CSource	= CDataBaseClipboard.CSource;

	return true;
}

bool TCSuperSpiceDataBase::PasteSymbol(TCDataBaseClipboard &CDataBaseClipboard)
{
	TCSchematicObjectData CSchematicObjectData;

	CClipboard.CDestination	= CDataBaseClipboard.CDestination;

	CSchematicObjectData.CSymbolData.CName		= CClipboard.CSource.CSymbolName;
	CSchematicObjectData.CSymbolData.CFileName	= CClipboard.CSource.CSymbolFileName;
	CSchematicObjectData.CSymbolData.CFilePath	= CClipboard.CSource.CSymbolPathName;

	if(!CSymbolDataBase.Get(CSchematicObjectData))return false;

	CString CSourceFile = CSchematicObjectData.CSymbolData.CChildFileName;

	CSchematicObjectData.CSymbolData.CName		= CClipboard.GetNewSymbolName();
	CSchematicObjectData.CSymbolData.CFileName	= CClipboard.CDestination.CSymbolFileName;
	CSchematicObjectData.CSymbolData.CFilePath	= CClipboard.CDestination.CSymbolPathName;

	if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC)
		CSchematicObjectData.CSymbolData.CChildFileName = CSchematicObjectData.CSymbolData.CFilePath + CSchematicObjectData.CSymbolData.CName +".sss";

	CString CDestFile = CSchematicObjectData.CSymbolData.CChildFileName;

	CSymbolDataBase.Set(CSchematicObjectData, false, CDataBaseClipboard.symbol_count);

	CDataBaseClipboard.CDestination.CSymbolName = CSchematicObjectData.CSymbolData.CName;

/* Removed 18th Aug 2002. A bit messy doing this when the name has new in it...
	// Create a copy of the new symbol's schematic

	CString CSystemText;

	CSystemText.Format("copy %s %s", CSourceFile, CDestFile);

	if(FileExists(CSourceFile))
		if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC)
		{
			CopyFile(CSourceFile, CDestFile, false);
				;//error warning
		}
*/
	return true;
}

bool TCSuperSpiceDataBase::CopyModel(TCDataBaseClipboard &CDataBaseClipboard)
{
	CClipboard.CSource	= CDataBaseClipboard.CSource;

	return true;
}

bool TCSuperSpiceDataBase::PasteModel(TCDataBaseClipboard &CDataBaseClipboard)
{
	TCSchematicObjectData CSchematicObjectData;

	CClipboard.CDestination	= CDataBaseClipboard.CDestination;

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= CClipboard.CSource.CModelName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CClipboard.CSource.CModelFileName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CClipboard.CSource.CModelPathName;

	if(!CModelDataBase.Get(CSchematicObjectData.CSpiceParameters)) return false;

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= CClipboard.GetNewModelName();
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CClipboard.CDestination.CModelFileName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CClipboard.CDestination.CModelPathName;

	CModelDataBase.Set(CSchematicObjectData.CSpiceParameters, CDataBaseClipboard.model_count);

	CDataBaseClipboard.CDestination.CModelName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;

	return true;
}


bool TCSuperSpiceDataBase::CopySymbolFile(TCDataBaseClipboard &CDataBaseClipboard)
{
	CClipboard.CFileSource	= CDataBaseClipboard.CSource;

	return true;
}

bool TCSuperSpiceDataBase::PasteSymbolFile(TCDataBaseClipboard &CDataBaseClipboard)
{
	CClipboard.CFileDestination	= CDataBaseClipboard.CDestination;

	CString CText = CClipboard.CFileSource.CSymbolFileName;
	CString CTemp;
	CString CTest1, CTest2;

	CTest1 = CText;

	CTest2 = CClipboard.CFileDestination.CSymbolFileName;

	CTest1.MakeUpper();
	CTest2.MakeUpper();

	if(CTest1 == CTest2)
	{
		AfxMessageBox(IDS_FILE_NAME_NON_UNIQUE);

		return false;
	}

	CText = CClipboard.CFileSource.CSymbolPathName + CText;

	int index = FindSymbolFile(CText);

	if(index < 0)
	{
		AfxMessageBox(IDS_FILE_NOT_EXISTS);

		return false;
	}


	TCSymbolDataBaseData CSymbolDataBaseData = CSymbolDataBase.CFileList[index];

	CSymbolDataBaseData.CName = CClipboard.CFileDestination.CSymbolFileName;
	CSymbolDataBaseData.CType = RemoveExtention(CSymbolDataBaseData.CName);
	
	CString CNewPath;

	CNewPath = CClipboard.CFileDestination.CSymbolPathName;//temp, need ..

	CNewPath += RemoveExtention(CSymbolDataBaseData.CName);

	CreateDirectory(CNewPath, NULL);

	CSymbolDataBaseData.CPath = CNewPath + '\\';

	// need to put all new files/symbol/schematics in a new directory
	// Now open each symbol's symbol schematics and rename path in symbol
	// and copy schematic and rename symbol's symbol schematic name
	CSymbolDataBaseData.CopyToNewDir();

	if(!CSymbolDataBaseData.Save())
	{
		AfxMessageBox(IDS_NO_FILE_SAVE);
	}

	CSymbolDataBase.CFileList.Add(CSymbolDataBaseData);

	int count = CSymbolDataBase.CFileList.GetSize();

	if(!count) return false;

	count--;

	
	GCWorkspaceTree.AddSymbolFile(count);

	return true;
}

bool TCSuperSpiceDataBase::CopyModelFile(TCDataBaseClipboard &CDataBaseClipboard)
{
	CClipboard.CFileSource	= CDataBaseClipboard.CSource;


	return true;
}

bool TCSuperSpiceDataBase::PasteModelFile(TCDataBaseClipboard &CDataBaseClipboard)
{
	CClipboard.CFileDestination	= CDataBaseClipboard.CDestination;

	CString CText = CClipboard.CFileSource.CModelPathName + CClipboard.CFileSource.CModelFileName;
	CString CTemp;
	CString CTest1, CTest2;

	CTest1 = CText;

	CTest2 = CClipboard.CFileDestination.CModelPathName + CClipboard.CFileDestination.CModelFileName;

	CTest1.MakeUpper();
	CTest2.MakeUpper();

	if(CTest1 == CTest2)
	{
		AfxMessageBox(IDS_FILE_NAME_NON_UNIQUE);

		return false;
	}

	int index = FindModelFile(CText);

	if(index < 0)
	{
		AfxMessageBox(IDS_FILE_NOT_EXISTS);

		return false;
	}

	TCModelDataBaseData CModelDataBaseData = CModelDataBase.CFileList[index];

	CModelDataBaseData.CPath = CClipboard.CFileDestination.CModelPathName;
	CModelDataBaseData.CName = CClipboard.CFileDestination.CModelFileName;
	CModelDataBaseData.CType = RemoveExtention(CModelDataBaseData.CName);
	
	if(!CModelDataBaseData.Save())
	{
		AfxMessageBox(IDS_ERR_UNABLE_TO_SAVE_MODEL);
	}

	CModelDataBase.CFileList.Add(CModelDataBaseData);

	int count = CModelDataBase.CFileList.GetSize();

	if(!count) return false;

	count--;

	
	GCWorkspaceTree.AddModelFile(count);

	return true;
}


bool TCSuperSpiceDataBase::RemoveSymbolFile(int id)
{
	if(id < 0) return false;

	if(id >= CSymbolDataBase.CFileList.GetSize()) return false;

	CSymbolDataBase.CFileList.RemoveAt(id);

	GCWorkspaceTree.RefreshSymbolFiles();

	return true;
}

int  TCSuperSpiceDataBase::FindModelFile(CString CFileName)
{
	int count,p;
	CString	CText1;

	CFileName.MakeUpper();

	count = CModelDataBase.CFileList.GetSize();

	for(p = 0; p < count; p++)
	{
		CText1 = CModelDataBase.CFileList[p].CPath + CModelDataBase.CFileList[p].CName;

		CText1.MakeUpper();

		if(CText1 != CFileName) continue;
			
		return p;

	}

	return -1;
}

bool TCSuperSpiceDataBase::GetCircuitAttributes(CString CFolderName, CString CFileName, TCCircuitsNameData &CCircuitsNameData)
{
	int folder_index = FindCircuitsFile(CFolderName);

	if(folder_index < 0) return false;

	int circuit_index = CCircuitsDataBase.CFileList[folder_index].Find(CFileName);

	if(circuit_index < 0) return false;

	CCircuitsNameData = CCircuitsDataBase.CFileList[folder_index].CCircuitNameList[circuit_index];

	return true;
}

bool TCSuperSpiceDataBase::SetCircuitAttributes(CString CFolderName, CString CFileName, TCCircuitsNameData &CCircuitsNameData)
{
	int folder_index = FindCircuitsFile(CFolderName);

	if(folder_index < 0) return false;

	int circuit_index = CCircuitsDataBase.CFileList[folder_index].Find(CFileName);

	if(circuit_index < 0) return false;

	CCircuitsDataBase.CFileList[folder_index].CCircuitNameList[circuit_index] = CCircuitsNameData;

	CCircuitsDataBase.CFileList[folder_index].Save(circuit_index);

	return true;
}

bool TCSuperSpiceDataBase::RemoveCircuitsFile(int id)
{
	if(id < 0) return false;

	if(id >= CModelDataBase.CFileList.GetSize()) return false;

	CCircuitsDataBase.CFileList.RemoveAt(id);

	
	GCWorkspaceTree.RefreshCircuitsFiles();

	return true;
}

int  TCSuperSpiceDataBase::FindCircuitsFile(CString CFileName)
{
	int count,p;
	CString	CText1;

	CFileName.MakeUpper();

	count = CCircuitsDataBase.CFileList.GetSize();

	for(p = 0; p < count; p++)
	{
		CText1 = CCircuitsDataBase.CFileList[p].CPath + CCircuitsDataBase.CFileList[p].CName;

		CText1.MakeUpper();

		if(CText1 != CFileName) continue;
			
		return p;

	}

	return -1;
}

int  TCSuperSpiceDataBase::FindSymbolFile(CString CFileName)
{
	int count,p;
	CString	CText1;

	CFileName.MakeUpper();

	count = CSymbolDataBase.CFileList.GetSize();

	for(p = 0; p < count; p++)
	{
		CText1 = CSymbolDataBase.CFileList[p].CPath + CSymbolDataBase.CFileList[p].CName;

		CText1.MakeUpper();

		if(CText1 != CFileName) continue;
			
		return p;

	}

	return -1;
}

bool TCSuperSpiceDataBase::GetComponent(TCComponentDataBaseData CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData)
{	
	CSchematicObjectData.CSymbolData.CName		= CComponentDataBaseData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFileName	= CComponentDataBaseData.CSymbolFileName;
	CSchematicObjectData.CSymbolData.CFilePath	= CComponentDataBaseData.CSymbolPathName;

	if(CComponentDataBaseData.use_index)
	{
		if(!(CComponentDataBaseData.symbol_file_index < CSymbolDataBase.CFileList.GetSize())) return false;

		if(CComponentDataBaseData.symbol_index < 0) return false;

		if(!(CComponentDataBaseData.symbol_index < CSymbolDataBase.CFileList[CComponentDataBaseData.symbol_file_index].CSymbolList.GetSize())) return false;

		CSchematicObjectData = CSymbolDataBase.CFileList[CComponentDataBaseData.symbol_file_index].CSymbolList[CComponentDataBaseData.symbol_index];
	}
	else // Get(CSymbolDataBase.CSymbolDataBase overwrites parameter data)
	{
		if(!CSymbolDataBase.Get(CSchematicObjectData))return false;
	}

	int symbol_type = GetSymbolType(CComponentDataBaseData);

	if(symbol_type == E_SPICE_SCHEMATIC) return true;

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= CComponentDataBaseData.CModelName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CComponentDataBaseData.CModelFileName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CComponentDataBaseData.CModelPathName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.model_type		= symbol_type;
	
	if(CComponentDataBaseData.use_index)
	{
		if(!(CComponentDataBaseData.model_file_index < CModelDataBase.CFileList.GetSize())) return false;

		if(!(CComponentDataBaseData.model_index < CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters.GetSize())) return false;

		if(CComponentDataBaseData.model_index < -1) return false;

		CSchematicObjectData.CSpiceParameters = CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters[CComponentDataBaseData.model_index];
	}
	else
	if(!CModelDataBase.Get(CSchematicObjectData.CSpiceParameters))
	{
		//log warning
	}
	
	// Eliminate any errors
//	CSchematicObjectData.CSymbolData.CName		= CComponentDataBaseData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFileName	= CComponentDataBaseData.CSymbolFileName;
	CSchematicObjectData.CSymbolData.CFilePath	= CComponentDataBaseData.CSymbolPathName;

//	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= CComponentDataBaseData.CModelName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CComponentDataBaseData.CModelFileName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CComponentDataBaseData.CModelPathName;
	
	if(CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel == "")// from symbol editor, kludge
		CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CComponentDataBaseData.CComponentType;


	CSchematicObjectData.FormatSpiceName();
	CSchematicObjectData.FormatSpiceValue();

	return true;
}

int TCSuperSpiceDataBase::GetGraphicTypeFromModelType(TCSchematicObjectData &CSchematicObjectData)
{
	if(CSchematicObjectData.attached_model_type != E_SPICE_DOT_MODEL) return 0;

	CString CText = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType;

	CText.TrimLeft();
	CText.MakeUpper();

	if(CText == "") return 0;

	if(CText == "X") return E_SUBCIRCUIT_COMPONENT;
	if(CText == "R") return E_RESISTOR_COMPONENT;
	if(CText == "L") return E_INDUCTOR_COMPONENT;
	if(CText == "C") return E_CAPACITOR_COMPONENT;
	if(CText == "SW") return E_VSWITCH_COMPONENT;
	if(CText == "CSW") return E_ISWITCH_COMPONENT;
	if(CText == "T") return E_LOSSLESS_TRANSMISSION_LINE_COMPONENT;
	if(CText == "LTRA") return E_TRANSMISSION_LINE_COMPONENT;
	if(CText == "D") return E_DIODE_COMPONENT;
	if(CText == "NPN") return E_NPN_TRANSISTER_COMPONENT;
	if(CText == "PNP") return E_PNP_TRANSISTER_COMPONENT;
	if(CText == "NJF") return E_NJFET_TRANSISTER_COMPONENT;
	if(CText == "PJF") return E_PJFET_TRANSISTER_COMPONENT;
	if(CText == "NMOS") return E_NMOS_4TERM_TRANSISTER_COMPONENT;
	if(CText == "PMOS") return E_PMOS_4TERM_TRANSISTER_COMPONENT;
	if(CText == "NMF") return E_NGASFET_TRANSISTER_COMPONENT;
	if(CText == "PMF") return E_PGASFET_TRANSISTER_COMPONENT;
	if(CText == "B") return E_NONLINEAR_DEPENDANT_SOURCE;
	if(CText == "E") return E_VCVSRC_COMPONENT;
	if(CText == "G") return E_VCISRC_COMPONENT;
	if(CText == "H") return E_ICVSRC_COMPONENT;
	if(CText == "F") return E_ICISRC_COMPONENT;
	if(CText == "S_XFER") return E_LAPLACE_TRANSFORM;
	if(CText == "URC") return E_URC_TRANSMISSION_LINE;

	if(CText == "A") return E_XSPICE_DIGITAL;

	if(CText == "W") return E_WAVEFORM_COMPONENT;
	if(CText == "NODE") return E_WIRE_COMPONENT;
	if(CText == "G") return E_GROUND;
	if(CText == "CONT") return E_SUBCIRCUIT_PIN_CONNECTER;
	if(CText == "TST") return E_TEST_MARKER;

	return E_XSPICE_DIGITAL;// assume all others are xspice
}

int TCSuperSpiceDataBase::GetGraphicTypeFromModelType(CString CText)
{
	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType = CText;

	CSchematicObjectData.attached_model_type = E_SPICE_DOT_MODEL;

	return GetGraphicTypeFromModelType(CSchematicObjectData);
}

bool TCSuperSpiceDataBase::CheckAndCorrectSymbolData(TCComponentDataBaseData *PCComponentDataBaseData)
{
	int model_type = GetModelType(*PCComponentDataBaseData);
	int symbol_type = GetSymbolType(*PCComponentDataBaseData);

	if(symbol_type < 0) return false;// silent, log warning to do

	if(symbol_type == E_SPICE_SCHEMATIC || symbol_type == E_SPICE_GENERATOR)// nullify any model files and accept
	{
		PCComponentDataBaseData->CModelName		= "";
		PCComponentDataBaseData->CModelFileName	= "";
		PCComponentDataBaseData->CModelPathName	= "";

		return true;
	}

	if(model_type < 0) 
	{
		return false;
	}
	bool check = true;

	return CheckAndCorrectModelData(PCComponentDataBaseData, check);
}

bool TCSuperSpiceDataBase::CheckAndCorrectSymbolData(TCSchematicObjectData &CSchematicObjectData)
{
	CString CText;

	// uses schematic.sss netlist not model data
	if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC)// delete any unused model data
	{
		//14th Aug 2001 could be zeroing out all the .models in the file
//		CSchematicObjectData.CSpiceParameters.CData.SetSize(0);

		CText = CSchematicObjectData.CSymbolData.CName;

		CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CText;

		CSchematicObjectData.FormatRecordName();
		CSchematicObjectData.FormatSpiceValue();
	}

	return true;
}

bool TCSuperSpiceDataBase::CheckAndCorrectModelData(TCComponentDataBaseData *PCComponentDataBaseData, int symbol_type)
{
	int model_type = GetModelType(*PCComponentDataBaseData);

	if(symbol_type < 0) return false;// silent, log warning to do
	if(model_type < 0) return false;

	if(symbol_type == model_type) return true;

	return false;
}

bool TCSuperSpiceDataBase::CheckAndCorrectModelData(TCComponentDataBaseData *PCComponentDataBaseData, bool check)
{
	int model_type = GetModelType(*PCComponentDataBaseData);
	int symbol_type = GetSymbolType(*PCComponentDataBaseData);

	if(symbol_type < 0) return false;// silent, log warning to do
	if(model_type < 0) return false;

	if(symbol_type != model_type) 	//if from component dlg force checking
	{								//if from libart dlg dont check
		if(!check) return true;
	}
	else return true;

	return false;
}

int TCSuperSpiceDataBase::GetModelType(TCComponentDataBaseData &CComponentDataBaseData)
{
	if(!(CComponentDataBaseData.model_file_index < CModelDataBase.CFileList.GetSize())) return -1;

	if(CComponentDataBaseData.model_file_index < 0) return -1;

	if(!(CComponentDataBaseData.model_index < CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters.GetSize())) return -1;

	if(CComponentDataBaseData.model_index < 0) return -1;

	return CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters[CComponentDataBaseData.model_index].CDataBaseIdInfo.model_type;
}

int	 TCSuperSpiceDataBase::GetSymbolType(TCComponentDataBaseData &CComponentDataBaseData)
{
	if(!(CComponentDataBaseData.symbol_file_index < CSymbolDataBase.CFileList.GetSize())) return -1;

	if(!(CComponentDataBaseData.symbol_index < CSymbolDataBase.CFileList[CComponentDataBaseData.symbol_file_index].CSymbolList.GetSize())) return -1;

	if(CComponentDataBaseData.symbol_index < 0) return -1;

	return CSymbolDataBase.CFileList[CComponentDataBaseData.symbol_file_index].CSymbolList[CComponentDataBaseData.symbol_index].attached_model_type;
}

double TCSuperSpiceDataBase::EvaluateComponentValue(CString CFileName, CString CRecordName, CString CTextValue)
{
	double data = 0;
	CString CComponentParameters;

	if(CTextValue == "") return 0;

	if(CTextValue.Find('{') < 0)// no expression to evaluate
	{
		data = SpiceMKSStringToFloat(CTextValue);

		return data;
	}

	CComponentParameters = GetSchematicParameters(CFileName, CRecordName);

	if(CComponentParameters == "") return data;

	if(!EquationSetVaribles(CComponentParameters)) return data;

	CTextValue.Remove('{');
	CTextValue.Remove('}');

	Equation(CTextValue, &data);

	return data;
}

CString TCSuperSpiceDataBase::GetSchematicParameters(CString CFileName, CString CRecordName)
{
	CString CSchematicParameters;
	TCSpiceParameters CSpiceParameters;

	// Get Component Params diffined in a virtual .model ComponentParam spec. in e.g., Parameters.lib

	CSpiceParameters.CDataBaseIdInfo.CRecordFileName = ExtractFileName(CFileName); // Global data
	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CFileName); // Global data
	CSpiceParameters.CDataBaseIdInfo.CRecordName     = CRecordName;

	if(!CModelDataBase.Get(CSpiceParameters)) return "";

	CSchematicParameters = CSpiceParameters.ConvertToParameterString();

	return CSchematicParameters;
}

bool TCSuperSpiceDataBase::GetModel(TCComponentDataBaseData &CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData)
{
	if(CComponentDataBaseData.use_index)
	{
		if(!(CComponentDataBaseData.model_file_index < CModelDataBase.CFileList.GetSize())) return false;

		if(CComponentDataBaseData.model_index < 0) return false;

		if(!(CComponentDataBaseData.model_index < CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters.GetSize())) return false;

		CSchematicObjectData.CSpiceParameters = CModelDataBase.CFileList[CComponentDataBaseData.model_file_index].CParametersList.CParameters[CComponentDataBaseData.model_index];
	}
	else
	if(!CModelDataBase.Get(CSchematicObjectData.CSpiceParameters))
	{
		//log warning
	}
	
//	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= CComponentDataBaseData.CModelName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CComponentDataBaseData.CModelFileName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CComponentDataBaseData.CModelPathName;

	CSchematicObjectData.FormatSpiceName();
	CSchematicObjectData.FormatSpiceValue();

	return true;
}

CString TCSuperSpiceDataBase::GetRecordName(TCSpiceParameters &CSpiceParameters, double width, double length)
{
	CString CText, CLocalName, CTextReturn, CNewTextReturn;

	CLocalName = CSpiceParameters.CDataBaseIdInfo.CRecordName;
	CTextReturn = CLocalName;
	
	CLocalName.MakeLower();

	if(CLocalName == "") return CTextReturn;

	CString CType = CSpiceParameters.CDataBaseIdInfo.CRecordType;

	CType.MakeLower();
		
	if(CType != "nmos" && CType!= "pmos") return CTextReturn;

	double wmax = 0, wmin = 0, lmax = 0, lmin = 0;

	if(!CSpiceParameters.Get("wmax", &wmax)) return CTextReturn;
	if(!CSpiceParameters.Get("wmin", &wmin)) return CTextReturn;
	if(!CSpiceParameters.Get("lmax", &lmax)) return CTextReturn;
	if(!CSpiceParameters.Get("lmin", &lmin)) return CTextReturn;

	// Numerical precision causes false results, i.e. 10u -> 9.99999u etc, so modify by 0.001%

	wmax *= 1.00001;
	wmin *= 0.99999;
	lmax *= 1.00001;
	lmin *= 0.99999;

	if(!(width > wmax))
		if(!(width < wmin))
			if(!(length > lmax))
				if(!(length < lmin))
					return CTextReturn; // already in range

	CString CRecordFilePath = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	CString CRecordFileName = CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CRecordFilePath.TrimLeft();
	CRecordFilePath.TrimRight();

	int index = FindModelFile(CRecordFilePath + CRecordFileName);

	if(index < 0) return CTextReturn;

	TCModelDataBaseData &CModelDataBaseData = CModelDataBase.CFileList[index];

	int model_index = CModelDataBaseData.CParametersList.FindModelWithExtention(CTextReturn, 0);

	if(model_index < 0) return CTextReturn;

	do
	{
		TCSpiceParameters &CNewSpiceParameters = CModelDataBaseData.CParametersList.CParameters[model_index];

		CNewTextReturn = CNewSpiceParameters.CDataBaseIdInfo.CRecordName;

		if(!CNewSpiceParameters.Get("wmax", &wmax)) return CTextReturn;
		if(!CNewSpiceParameters.Get("wmin", &wmin)) return CTextReturn;
		if(!CNewSpiceParameters.Get("lmax", &lmax)) return CTextReturn;
		if(!CNewSpiceParameters.Get("lmin", &lmin)) return CTextReturn;

		wmax *= 1.00001;
		wmin *= 0.99999;
		lmax *= 1.00001;
		lmin *= 0.99999;

		if(!(width > wmax))
			if(!(width < wmin))
				if(!(length > lmax))
					if(!(length < lmin))
						return CTextReturn;

		model_index = CModelDataBaseData.CParametersList.FindModelWithExtention(CTextReturn, model_index + 1);	
	
	}	while(!(model_index < 0));

	CString CMessage;

	CMessage.LoadString(IDS_UNABLE_FIND_WC_MODEL);

	CMessage += ' ' + CNewTextReturn;
	
	GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, CMessage, 0);

	return CTextReturn;
}

TCSpiceParameters *TCSuperSpiceDataBase::GetModelPointer(TCSpiceParameters &CSpiceParameters, bool auto_wc)
{
	return CModelDataBase.GetPointer(CSpiceParameters, auto_wc);
}

CString TCSuperSpiceDataBase::CreateReRunFileFromModel(CString CFilePath, CString CFileName, CString CModelName)
{
	CArray <CString, CString> CReRunList;

	CString CReRunFileName;

	TCSpiceParameters *PCSpiceParameters;
	TCSpiceParameters CSpiceParameters;

	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CFilePath;
	CSpiceParameters.CDataBaseIdInfo.CRecordFileName = CFileName;
	CSpiceParameters.CDataBaseIdInfo.CRecordName	 = CModelName;

	CString CName = CModelName.Left(CModelName.GetLength() - 3);

	CSpiceParameters.CDataBaseIdInfo.CRecordName = CName + "_XN";

	PCSpiceParameters = GetModelPointer(CSpiceParameters);

	if(!PCSpiceParameters) return "";

	CSpiceParameters = *PCSpiceParameters;

	CSpiceParameters.CDataBaseIdInfo.CRecordName = CName + "_XW";

	PCSpiceParameters = GetModelPointer(CSpiceParameters, true);//true get wc data

	if(!PCSpiceParameters) return "";

	CFile CDataFile;

	CReRunFileName = CFilePath + CName + ".rrn";

	if(!CDataFile.Open(CReRunFileName, CFile::modeCreate | CFile::modeWrite)) return "";

	PCSpiceParameters->CreateReRunText(CReRunList);

	int count = CReRunList.GetSize();

	CString CLine;
	CString CEnd = "\r\n";

	CLine = ".ReRun WeakModel";

	CDataFile.Write(CLine, CLine.GetLength());
	CDataFile.Write(CEnd, CEnd.GetLength());

	int p;

	for(p = 0; p < count; p++)
	{
		CLine = CReRunList[p];

		if(CLine == "") 
		{
			CSpiceParameters.SetInclude(PCSpiceParameters->CData[p].CName, false);

			continue;
		}

		CSpiceParameters.SetInclude(CName, true);

		CDataFile.Write(CLine, CLine.GetLength());
		CDataFile.Write(CEnd, CEnd.GetLength());
	}

	CLine = ".RREnd";

	CDataFile.Write(CLine, CLine.GetLength());
	CDataFile.Write(CEnd, CEnd.GetLength());

	CDataFile.Write("*", 1);
	CDataFile.Write(CEnd, CEnd.GetLength());

	CSpiceParameters.CDataBaseIdInfo.CRecordName = CName + "_XN";

	CSpiceParameters.CreateReRunText(CReRunList);

	count = CReRunList.GetSize();

	CLine = ".ReRun NominalModel";

	CDataFile.Write(CLine, CLine.GetLength());
	CDataFile.Write(CEnd, CEnd.GetLength());

	for(p = 0; p < count; p++)
	{
		CLine = CReRunList[p];

		if(CLine == "") continue;

		CDataFile.Write(CLine, CLine.GetLength());
		CDataFile.Write(CEnd, CEnd.GetLength());
	}

	CLine = ".RREnd";

	CDataFile.Write(CLine, CLine.GetLength());
	CDataFile.Write(CEnd, CEnd.GetLength());

	CDataFile.Write("*", 1);
	CDataFile.Write(CEnd, CEnd.GetLength());

	CSpiceParameters.CDataBaseIdInfo.CRecordName	 = CName + "_XS";

	PCSpiceParameters = GetModelPointer(CSpiceParameters, true);

	if(!PCSpiceParameters) return "";

	PCSpiceParameters->CreateReRunText(CReRunList);

	count = CReRunList.GetSize();

	CLine = ".ReRun StrongModel";

	CDataFile.Write(CLine, CLine.GetLength());
	CDataFile.Write(CEnd, CEnd.GetLength());

	for(p = 0; p < count; p++)
	{
		CLine = CReRunList[p];

		if(CLine == "") continue;

		CDataFile.Write(CLine, CLine.GetLength());
		CDataFile.Write(CEnd, CEnd.GetLength());
	}

	CLine = ".RREnd";

	CDataFile.Write(CLine, CLine.GetLength());
	CDataFile.Write(CEnd, CEnd.GetLength());

	return CReRunFileName;
}


bool TCSuperSpiceDataBase::SetComponent(TCSchematicObjectData &CSchematicObjectData)
{
// this function not used
	if(!CSymbolDataBase.Set(CSchematicObjectData, false))
	{
		//error

		return false;
	}

	if(!CModelDataBase.Set(CSchematicObjectData.CSpiceParameters))
	{
		//warning

		return true;
	}
	
	return true;
}

void TCSuperSpiceDataBase::Setup(void)
{	

	SetupPointingUpPin();
	SetupPointingLeftPin();
	SetupPointingDownPin();
	SetupPointingRightPin();

	SetupTestPointNames();
	SetupLabel();
	SetupBoxWaveformCursor();
	SetupWaveform();
	SetupSolderBlob();
	SetupNPNTransister();
	SetupPNPTransister();
	SetupNJFetTransister();
	SetupPJFetTransister();
	SetupResisister();
	SetupVariableResistor();
	SetupICResisister();
	SetupCapacitor();
	SetupICCapacitor();
	SetupInductor();
	SetupNMos();
	SetupPMos();
	SetupDiode();
	SetupOpAmp();

	SetupVDC();
	SetupVSine();
	SetupVPulse();
	SetupVExp();
	SetupVPWL();
	SetupVSFFM();
	SetupIDC();
	SetupISine();
	SetupIPulse();
	SetupIExp();
	SetupIPWL();
	SetupISFFM();

	SetupZener();
	SetupTestPoint();
	SetupVCVS();
	SetupVCIS();
	SetupICVS();
	SetupICIS();
	SetupThyresistor();
	SetupGround();
	SetupPageConnecterInput();
	SetupPageConnecterOutput();
	SetupPageConnecterBidirectional();
	SetupSubcurcuitConnecter();
	SetupShottky();
	SetupDiac();
	SetupGTO();
	SetupTransformer();
	SetupTransformerDual();
	SetupTransformerTriple();
	SetupTransformerQuad();
	SetupTransformerCenterTapedSingle();
	SetupOneCenterTapTransformer();
	SetupTransformerCenterTapedDual();
	SetupDualOneCenterTapTransformer();
	SetupTransformerCenterTapedTriple();
	SetupTransformerCenterTapedQuad();
	SetupTransformerFlyback();
	SetupTransformerTubeOutput();
	SetupTransmissionLine();
	SetupTriac();
	SetupVSwitch();
	SetupISwitch();
	SetupDualGateNMos();
	SetupDualGatePMos();
	SetupNIGBP();
	SetupPIGBP();
	SetupMultiplier();
	SetupDivider();
	SetupNonLinearSource();
	SetupUnijunction();
	Setup4TerninalNPNTransister();
	Setup4TerninalPNPTransister();
	Setup4TerninalNMos();
	Setup4TerninalPMos();
	Setup4TerninalNJFetTransister();
	Setup4TerninalPJFetTransister();
	SetupNGasFet();
	SetupPGasFet();
	Setup4TerminalNGasFet();
	Setup4TerminalPGasFet();
	SetupBuffer();
	SetupVCA();
	Setup2InputAmp();
	SetupGenericPin2Component();
	SetupGenericPin3Component();
	SetupGenericPin4Component();
	SetupGenericPin5Component();
	SetupGenericPin6Component();
	SetupGenericPin7Component();
	SetupGenericPin8Component();
	SetupGenericPin9Component();
	SetupGenericPin10Component();
	SetupGenericPin11Component();
	SetupGenericPin12Component();
	SetupGenericPin13Component();
	SetupGenericPin14Component();
	SetupGenericPin15Component();
	SetupGenericPin16Component();
	SetupTriode();
	SetupTetrode();
	SetupPentode();
	SetupAnd();
	SetupNand();
	SetupOr();
	SetupNor();
	SetupExOr();
	SetupExNor();
	SetupDType();
	SetupJKType();
	SetupSchmitt();
	SetupInvertor();
	Setup8BitCounter();
	SetupLDO5Pin();

	SetupPinLeftComponentSymbol();
	SetupPinRightComponentSymbol();
	SetupPinUpComponentSymbol();
	SetupPinDownComponentSymbol();
	SetupCurveComponentSymbol();
	SetupInductorSemicircleComponentSymbol();

	SetupDigitalAnd();
	SetupDigitalNand();
	SetupDigitalOr();
	SetupDigitalNor();
	SetupDigitalExOr();
	SetupDigitalExNor();
	SetupDigitalInvertor();
	SetupAToD();
	SetupDToA();
	SetupLaplaceTransform();

	SetupFuse();
	SetupThermistor();
	SetupVaristor();
	SetupCrystal();

	SetupTubeDiodeSingle();
	SetupTubeDiodeDualCommonCathode();
	SetupTubeDiodeDualIndividualCathode();

	SetupInductorCored();

	SetupTriodeHeater();
	SetupTetrodeHeater();
	SetupPentodeHeater();
	SetupTubeDiodeSingleHeater();
	SetupTubeDiodeDualCommonCathodeHeater();
	SetupTubeDiodeDualIndividualCathodeHeater();
	SetupTriodeDual();
	SetupTriodeDualHeater();
	SetupTube8Pin();
	SetupTriodeCommonHeater();
	SetupTubeDiodeCommonHeater();
	SetupTubeDiodeDualCommonHeater();
	SetupMoter();
	SetupMoterTacho();
	SetupCCFL();
	SetupTitleBlock();

	SetupDigital3InputAnd();
	SetupDigital3InputNand();
	SetupDigital3InputOr();
	SetupDigital3InputNor();
	Setup3InputAnd();
	Setup3InputNand();
	Setup3InputOr();
	Setup3InputNor();

	SetupPinLocations();

	RescaleComponents(component_scale);
}

void TCSuperSpiceDataBase::SetupPinLocations(void)
{
	int count = CMDefaults.GetSize();
	int p, r, size;

	CPoint CPinLocationVolts(0,0), CPinLocationAmps(0,0);
	
	CPoint CPinLeftVolts(0,0), CPinRightVolts(0,0), CPinUPVolts(0,0), CPinDownVolts(0,0);
	CPoint CPinLeftAmps(0,0), CPinRightAmps(0,0), CPinUPAmps(0,0), CPinDownAmps(0,0);

//	CPoint CPinLeftVolts(-16, -4), CPinRightVolts(64, -4), CPinUPVolts(4, -16), CPinDownVolts(4, -8);
//	CPoint CPinLeftAmps(-16, 4), CPinRightAmps(16, 4), CPinUPAmps(4, 16), CPinDownAmps(4, 8);

	CPoint CZero(0,0);

	TE_TYPE_OF_COMPONENT type;

	for(p = 0; p < count; p++)// setup pin label locations
	{
		TCSchematicObjectData &CSchematicObjectData = CMDefaults[p];

		size = CSchematicObjectData.CPinListData.GetSize();

		if(!size) continue;

		for(r = 0; r < size; r++)
		{
			TCSchematicPinData &CSchematicPinData = CSchematicObjectData.CPinListData[r];

			if(E_NUM_PIN_LABELS != CSchematicPinData.CLabelListData.GetSize()) continue;

			type = (TE_TYPE_OF_COMPONENT)CSchematicObjectData.CPinListData[r].type;

			switch(type)
			{
				case E_POINTING_LEFT_PIN_COMPONENT:	CPinLocationVolts = CPinLeftVolts;CPinLocationAmps = CPinLeftAmps;break;
				case E_POINTING_RIGHT_PIN_COMPONENT:CPinLocationVolts = CPinRightVolts;CPinLocationAmps = CPinRightAmps;	break;
				case E_POINTING_UP_PIN_COMPONENT:	CPinLocationVolts = CPinUPVolts;CPinLocationAmps = CPinUPAmps;	break;
				case E_POINTING_DOWN_PIN_COMPONENT:	CPinLocationVolts = CPinDownVolts;CPinLocationAmps = CPinDownAmps;	break;
			
				default: CPinLocationVolts = CZero; CPinLocationAmps = CZero;
			}

			CSchematicPinData.CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLocation =  CPinLocationVolts;
			CSchematicPinData.CLabelListData[E_COMPONENT_PIN_CURENT].CLocation =  CPinLocationAmps;
		}
	}


}

void TCSuperSpiceDataBase::RescaleComponents(float scale)
{
	int count = CMDefaults.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMDefaults[p].Rescale(scale);
	}
}


void TCSuperSpiceDataBase::SetupTestPointNames(void)
{
	CTestPointNames.SetSize(E_TEST_POINTS_TYPE_MAX, E_TEST_POINTS_TYPE_MAX);

	CTestPointNames[E_TEST_POINT_MAGNITUDE] = "MAG";
	CTestPointNames[E_TEST_POINT_DB]		= "DB";
	CTestPointNames[E_TEST_POINT_DEGS]		= "DEGS";
	CTestPointNames[E_TEST_POINT_RADS]		= "RADS";
	CTestPointNames[E_TEST_POINT_MAGDEG]	= "MagDegs";
	CTestPointNames[E_TEST_POINT_DBDEGS]	= "DbDegs";
	CTestPointNames[E_TEST_POINT_MAGRADS]	= "MagRads";
	CTestPointNames[E_TEST_POINT_DBRADS]	= "DbRads";
}

void TCSuperSpiceDataBase::SetupPointingRightPin(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_POINTING_RIGHT_PIN_COMPONENT];

	CSchematicObjectData.type = E_POINTING_RIGHT_PIN_COMPONENT;
	
	CSchematicObjectData.f_vector_graphic	= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	TCLineData CLineData;

	CLineData.CStartLocation.x	= 0;
	CLineData.CStartLocation.y	= 0;

	CLineData.CEndLocation.x	= 16;
	CLineData.CEndLocation.y	= 0;

	CSchematicObjectData.width		= 16;
	CSchematicObjectData.height	= 1;
	CSchematicObjectData.is_visable = true;
	CSchematicObjectData.CSymbolData.CData[0] = CLineData;

}
void TCSuperSpiceDataBase::SetupPointingLeftPin(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_POINTING_LEFT_PIN_COMPONENT];

	CSchematicObjectData.type	= E_POINTING_LEFT_PIN_COMPONENT;
	
	CSchematicObjectData.f_vector_graphic	= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	TCLineData CLineData;

	CLineData.CStartLocation.x	= 0;
	CLineData.CStartLocation.y	= 0;

	CLineData.CEndLocation.x	= -16;
	CLineData.CEndLocation.y	= 0;

	CSchematicObjectData.width		= 16;
	CSchematicObjectData.height	= 1;
	CSchematicObjectData.is_visable = true;

	CSchematicObjectData.CSymbolData.CData[0] = CLineData;

}

void TCSuperSpiceDataBase::SetupPointingUpPin(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_POINTING_UP_PIN_COMPONENT];

	CSchematicObjectData.is_visable				= true;
 	CSchematicObjectData.type					= E_POINTING_UP_PIN_COMPONENT;

	CSchematicObjectData.f_vector_graphic		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	TCLineData CLineData;

	CLineData.CStartLocation.x	= 0;
	CLineData.CStartLocation.y	= 0;

	CLineData.CEndLocation.x	= 0;
	CLineData.CEndLocation.y	= -16;

	CSchematicObjectData.width		= 1;
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.CSymbolData.CData[0] = CLineData;

}
void TCSuperSpiceDataBase::SetupPointingDownPin(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_POINTING_DOWN_PIN_COMPONENT];

	CSchematicObjectData.is_visable			= true;
 	CSchematicObjectData.type					= E_POINTING_DOWN_PIN_COMPONENT;
	
	CSchematicObjectData.f_vector_graphic				= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	TCLineData CLineData;

	CLineData.CStartLocation.x	= 0;
	CLineData.CStartLocation.y	= 0;

	CLineData.CEndLocation.x	= 0;
	CLineData.CEndLocation.y	= 16;

	CSchematicObjectData.width	= 1;
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.CSymbolData.CData[0] = CLineData;

}
void TCSuperSpiceDataBase::SetupCurveComponentSymbol(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SYMBOL_CURVE_COMPONENT];

	CSchematicObjectData.type	= E_SYMBOL_CURVE_COMPONENT;

	CSchematicObjectData.CSymbolData.CData.SetSize(1);

	CSchematicObjectData.CGrabOffset.y = -4;
	CSchematicObjectData.CGrabOffset.x = -4;

	CSchematicObjectData.CLocationOffset.x = 4;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[0].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.width	= 8;
	CSchematicObjectData.height	= 8;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupInductorSemicircleComponentSymbol(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SYMBOL_INDUCTOR_SEMICIRCLE_COMPONENT];

	CSchematicObjectData.type	= E_SYMBOL_INDUCTOR_SEMICIRCLE_COMPONENT;

	CSchematicObjectData.CSymbolData.CData.SetSize(1);

	CSchematicObjectData.CGrabOffset.y = -8;
	CSchematicObjectData.CGrabOffset.x = -8;

	CSchematicObjectData.CLocationOffset.x = -8;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].start_angle		= -180; //-180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[0].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.width	= 16;
	CSchematicObjectData.height	= 8;

//	CSchematicObjectData.rotation_state = E_SECOND_QUADRANT;

	CSchematicObjectData.f_vector_graphic = true;
}

bool TCSuperSpiceDataBase::SetupDynamicSymbolComponent(TCLineData &CData)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DYNAMIC_SYMBOL_COMPONENT];

	CSchematicObjectData.type	= E_DYNAMIC_SYMBOL_COMPONENT;

	CSchematicObjectData.CSymbolData.CData.SetSize(1);

	CSchematicObjectData.CSymbolData.CData[0] = CData;
/*
	CSchematicObjectData.CGrabOffset.y = -8;
	CSchematicObjectData.CGrabOffset.x = -8;

	CSchematicObjectData.CLocationOffset.x = -8;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].start_angle		= -180; //-180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[0].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;
*/
	CSchematicObjectData.width	= (short)(CData.radius * 2);
	CSchematicObjectData.height	= (short)(CData.radius * 2);

	CSchematicObjectData.CGrabOffset.x = -CData.radius;
	CSchematicObjectData.CGrabOffset.y = -CData.radius/2;

	CSchematicObjectData.f_vector_graphic = true;

	return true;
}

void TCSuperSpiceDataBase::SetupPinLeftComponentSymbol(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT];

	CSchematicObjectData.type	= E_SYMBOL_POINTING_LEFT_PIN_COMPONENT;

	CSchematicObjectData.CPinListData[0].type				= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 0; 
	CSchematicObjectData.CPinListData[0].CLocation.y		= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y  = 0;

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = -1;
	CSchematicObjectData.CGrabOffset.x = -16;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	CSchematicObjectData.CSymbolData.CData[0].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= -16;//pin length
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.width	= 16; //temp
	CSchematicObjectData.height	= 2;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupPinRightComponentSymbol(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT];

	CSchematicObjectData.type	= E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT;

	CSchematicObjectData.CPinListData[0].type				= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 0; 
	CSchematicObjectData.CPinListData[0].CLocation.y		= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y  = 0;

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = -1;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	CSchematicObjectData.CSymbolData.CData[0].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 16;//pin length
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.width	= 16; //temp
	CSchematicObjectData.height	= 2;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupPinUpComponentSymbol(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT];

	CSchematicObjectData.type	= E_SYMBOL_POINTING_UP_PIN_COMPONENT;

	CSchematicObjectData.CPinListData[0].type				= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 0; 
	CSchematicObjectData.CPinListData[0].CLocation.y		= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y  = 0;

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = -16;
	CSchematicObjectData.CGrabOffset.x = -1;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	CSchematicObjectData.CSymbolData.CData[0].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;//pin length
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -16;

	CSchematicObjectData.width	= 2; //temp
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupPinDownComponentSymbol(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT];

	CSchematicObjectData.type	= E_SYMBOL_POINTING_DOWN_PIN_COMPONENT;

	CSchematicObjectData.CPinListData[0].type				= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 0; 
	CSchematicObjectData.CPinListData[0].CLocation.y		= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y  = 0;

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = -1;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(1, 1);

	CSchematicObjectData.CSymbolData.CData[0].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;//pin length
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 16;

	CSchematicObjectData.width	= 2; //temp
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}
/////////////////////////////////////////////////////
void TCSuperSpiceDataBase::SetupNPNTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NPN_TRANSISTER_COMPONENT];

	CSchematicObjectData.type	= E_NPN_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type				= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // collector
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y  = 32;

	CSchematicObjectData.CPinListData[1].type					= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable				= true;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // base
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type				= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable			= true;
	CSchematicObjectData.CPinListData[2].CLocation.x		= 48;  // emitter
	CSchematicObjectData.CPinListData[2].CLocation.y		= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[1].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[3].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[4].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 48; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[5].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 52; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 37;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 48;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupPNPTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PNP_TRANSISTER_COMPONENT];


	CSchematicObjectData.type	= E_PNP_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT; 
	CSchematicObjectData.CPinListData[0].CLocation.x	= 48; // collector
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0; // base
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // emitter
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[1].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;
		
	CSchematicObjectData.CSymbolData.CData[3].type = E_SCHEMATIC_SYMBOL_LINE;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 32; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 45;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 42;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupNJFetTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NJFET_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_NJFET_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(10, 10);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}


void TCSuperSpiceDataBase::SetupPJFetTransister(void)
{
	
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PJFET_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_PJFET_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(10, 10);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -16; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupLabel(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_LABEL_COMPONENT];

	CSchematicObjectData.f_vector_graphic  = false;
	CSchematicObjectData.is_visable		= true;
	CSchematicObjectData.CLabel			= CMDefaults[E_LABEL_COMPONENT].CLabel;
	CSchematicObjectData.type			= E_LABEL_COMPONENT;
}

void TCSuperSpiceDataBase::SetupResisister(void)
{
	// Notes, CMLOcations are relative to first point in arrays + 
	// CSchematicObjectData.CLocationOffset
	// CLocationOffset is on grid, CGrabOffset may not be

	
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_RESISTOR_COMPONENT];

	CSchematicObjectData.type	= E_RESISTOR_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupVariableResistor(void)
{

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_VARIABLE_RESISTOR];

	CSchematicObjectData.type	= E_VARIABLE_RESISTOR;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
		
	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupICResisister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_IC_RESISTOR_COMPONENT];

	CSchematicObjectData.type = E_IC_RESISTOR_COMPONENT;	

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupCapacitor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_CAPACITOR_COMPONENT];
	
	CSchematicObjectData.type	= E_CAPACITOR_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 28;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 28;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 36;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupICCapacitor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_IC_CAPACITOR_COMPONENT];

	CSchematicObjectData.type = E_IC_CAPACITOR_COMPONENT;	

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 28;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 28;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 36;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupSolderBlob(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_CONNECTION_DOT];

	CSchematicObjectData.type	= E_CONNECTION_DOT;

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = -2;
	CSchematicObjectData.CGrabOffset.x = -2;

	CSchematicObjectData.CSymbolData.CData.SetSize(2);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].start_angle			= 0; 
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[1].radius				= 2;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.width	= 4; 
	CSchematicObjectData.height	= 4;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupInductor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_INDUCTOR_COMPONENT];
	
	CSchematicObjectData.type	= E_INDUCTOR_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].start_angle			= -180; //-180;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[1].radius				= 8;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].start_angle			= -180;//-180;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[2].radius				= 8;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -20;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[3].start_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[3].radius				= 2;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupInductorCored(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_INDUCTOR_COMPONENT_CORED];
	
	CSchematicObjectData.type	= E_INDUCTOR_COMPONENT_CORED;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].start_angle			= -180; //-180;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[1].radius				= 8;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].start_angle			= -180;//-180;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[2].radius				= 8;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -20;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[3].start_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[3].radius				= 2;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= -32;// core bar 1
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -32;// core bar 2
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= -12;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void  TCSuperSpiceDataBase::SetupFuse(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_COMPONENT_FUSE];

	CSchematicObjectData.type	= E_COMPONENT_FUSE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(3);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0; ;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -180;//-180;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;
	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupThermistor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SPICE_THERMISTOR];

	CSchematicObjectData.type	= E_SPICE_THERMISTOR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[6].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[6].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[6].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[6].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupVaristor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_VARISTOR_MOV];

	CSchematicObjectData.type	= E_VARISTOR_MOV;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8, 8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -8;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupCrystal(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_FREQUENCY_CRYSTAL];

	CSchematicObjectData.type	= E_FREQUENCY_CRYSTAL;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8, 8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;// x line
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 28; //y line
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 36;//y line
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;// x line
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 8;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 36;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 24;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 20;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= 20;


	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupNMos(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NMOS_TRANSISTER_COMPONENT];

	CSchematicObjectData.type	= E_NMOS_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // s/d
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		= 0; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y		= 0;
	CSchematicObjectData.CPinListData[1].is_visable			= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // s/d
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable			= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(13, 13);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 44;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 40; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 40; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= 44;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupPMos(void)
{

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PMOS_TRANSISTER_COMPONENT];

	CSchematicObjectData.type	= E_PMOS_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable			= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(13, 13);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 44;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 60; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 60; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= 44;

// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupDiode(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIODE_COMPONENT];

	CSchematicObjectData.type	= E_DIODE_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;	
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 16;



	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 16;

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupOpAmp(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_5_PIN_OP_AMP_COMPONENT];

	CSchematicObjectData.type	= E_5_PIN_OP_AMP_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// +input
	CSchematicObjectData.CPinListData[0].CLocation.y	= -32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 48;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//- input
	CSchematicObjectData.CPinListData[1].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 48;
	CSchematicObjectData.CPinListData[1].is_visable		= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 96;//output
	CSchematicObjectData.CPinListData[4].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 48;
	CSchematicObjectData.CPinListData[4].is_visable		= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;//+supply
	CSchematicObjectData.CPinListData[2].CLocation.y	= -32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 48;
	CSchematicObjectData.CPinListData[2].is_visable		= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 48;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 48;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 96;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 112;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 112;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 96;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 24; // +
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 20; // +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 20; // -
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 80;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 28;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 80;

	CSchematicObjectData.width	= 128; 
	CSchematicObjectData.height	= 96;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupWaveform(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_WAVEFORM_COMPONENT];

	CSchematicObjectData.type	= E_WAVEFORM_COMPONENT;

	CSchematicObjectData.Rescale(1/component_scale);// use saved data, others dont

	CSchematicObjectData.CPinListData.SetSize(1);
	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= CSchematicObjectData.width - 16;//
	CSchematicObjectData.CPinListData[0].CLocation.y	= CSchematicObjectData.height;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable			= false;

	/*
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;//
	CSchematicObjectData.CPinListData[1].CLocation.y	= CSchematicObjectData.height;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable			= false;*/

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::UpdateWaveFormSize(unsigned short width, unsigned short height)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_WAVEFORM_COMPONENT];

	CSchematicObjectData.width = width;
	CSchematicObjectData.height = height;

	CSchematicObjectData.CPinListData[0].CLocation.x	= (long)(width - 16 * component_scale);
	CSchematicObjectData.CPinListData[0].CLocation.y	= height;

/*	CSchematicObjectData.CPinListData[1].CLocation.x	= (long)(16 * component_scale);
	CSchematicObjectData.CPinListData[1].CLocation.y	= height;*/

	CSchematicObjectData.CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror[0].CQuadrant[0].x = width + 8;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror[0].CQuadrant[0].y = -128;

	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0].x = width + 8;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0].y = -102;
}
void TCSuperSpiceDataBase::SetWaveFormDefaultSize(unsigned short width, unsigned short height)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_WAVEFORM_COMPONENT];

	CSchematicObjectData.height = height;
	CSchematicObjectData.width = width;

	CSchematicObjectData.CPinListData.SetSize(1);
	CSchematicObjectData.CPinListData[0].is_visable	= false;
	CSchematicObjectData.CPinListData[0].CLocation.x = (unsigned short)(CSchematicObjectData.width - 16 * component_scale);//
	CSchematicObjectData.CPinListData[0].CLocation.y = CSchematicObjectData.height;
/*
	CSchematicObjectData.CPinListData[1].is_visable	= false;
	CSchematicObjectData.CPinListData[1].CLocation.x = (unsigned short)(16 * component_scale);//
	CSchematicObjectData.CPinListData[1].CLocation.y = CSchematicObjectData.height;
*/
	CSchematicObjectData.CLabelListData[E_WAVEFORM_TITLE].CLocations_Mirror[0].CQuadrant[0].x = 0;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_TITLE].CLocations_Mirror[0].CQuadrant[0].y = -102;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLocations_Mirror[0].CQuadrant[0].x = 0;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLocations_Mirror[0].CQuadrant[0].y = -72;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLocations_Mirror[0].CQuadrant[0].x = 0;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLocations_Mirror[0].CQuadrant[0].y = -40;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0].x = 
	CSchematicObjectData.width + 8;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0].y = -102;

	CSchematicObjectData.CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror[0].CQuadrant[0].x = 
	CSchematicObjectData.width + 8;
	CSchematicObjectData.CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror[0].CQuadrant[0].y = -128;
}
void TCSuperSpiceDataBase::SetupBoxWaveformCursor(void)
{

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_BOX_WAVEFORM_CURSOR];

	CSchematicObjectData.type	= E_BOX_WAVEFORM_CURSOR;

	CSchematicObjectData.CLocationOffset.x = -1;
	CSchematicObjectData.CLocationOffset.y = -1;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 2;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 2;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 2;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 2;

		
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 2;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 2;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 2;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;
		
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 2;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

/// Symbol end lines

	CSchematicObjectData.width	= 2; 
	CSchematicObjectData.height	= 2;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupVDC(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DC_VOLTAGE_SOURCE];

	CSchematicObjectData.type	= E_DC_VOLTAGE_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[0].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 40;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupMoter(void)
{
	CString CSymbolName = CMDefaults[E_MOTER].CSymbolData.CName;

	CMDefaults[E_MOTER] = CMDefaults[E_DC_VOLTAGE_SOURCE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_MOTER];

	CSchematicObjectData.type	= E_MOTER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_MOTER] = "X";
	CSchematicObjectData.attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	CSchematicObjectData.CSpiceParameters.use_model = true;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CModelType = "X";

	CSchematicObjectData.f_validate_label_value = false;

	CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);

	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Moter";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Moter";
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "Moter_XN";
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= false;

	CSchematicObjectData.CSymbolData.CData.SetSize(12);

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y += 16;


	//////
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= -8; //top line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 18;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 18;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= -8; //bottom line
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[7].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= -8; //bottom v line
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 46;
	CSchematicObjectData.CSymbolData.CData[8].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 8; //bottom v line
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= 46;
	CSchematicObjectData.CSymbolData.CData[9].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 0; // v pin line
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[10].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 0; //bottom v pin line
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[11].type				= E_SCHEMATIC_SYMBOL_LINE;

}

void TCSuperSpiceDataBase::SetupMoterTacho(void)
{
	CString CSymbolName = CMDefaults[E_MOTER_TACHO].CSymbolData.CName;

	CMDefaults[E_MOTER_TACHO] = CMDefaults[E_MOTER];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_MOTER_TACHO];

	CSchematicObjectData.type	= E_MOTER_TACHO;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_MOTER_TACHO] = "X";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "MoterTacho";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "MoterTacho";
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "MoterTacho";

	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "f+";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "f-";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(14);

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 11; // 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 21;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[12].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 16; //
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 11;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 43;
	CSchematicObjectData.CSymbolData.CData[13].type				= E_SCHEMATIC_SYMBOL_LINE;
}

void TCSuperSpiceDataBase::SetupCCFL(void)
{
/*
	//testing 
	{
		CString CSymbolName = "Test";

		TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_CCFL];

		CSchematicObjectData.type	= E_CCFL;

		

		CSchematicObjectData.CPinListData.SetSize(1);
		CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
		CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
		CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
		CSchematicObjectData.CPinListData[0].is_visable	= true;

		CSchematicObjectData.CSymbolData.CData.SetSize(1);
		CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
		CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
		CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
		CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -32;
		CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

		CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -32;
		CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
		CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 32;
		CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 0;
		CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;

		CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 64;
		CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 64;
		CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 185;
		CSchematicObjectData.CSymbolData.CData[2].start_angle		= 15;
		CSchematicObjectData.CSymbolData.CData[2].end_angle			= 200;
		CSchematicObjectData.CSymbolData.CData[2].radius			= 16;
		CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
		CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

		CSchematicObjectData.CGrabOffset.y = -32;
		CSchematicObjectData.CGrabOffset.x = -16;
		CSchematicObjectData.width	= 64; 
		CSchematicObjectData.height	= 64;

		CSchematicObjectData.f_vector_graphic = true;

		return;
	}

*/
	CString CSymbolName = CMDefaults[E_CCFL].CSymbolData.CName;

	CMDefaults[E_CCFL] = CMDefaults[E_DC_VOLTAGE_SOURCE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_CCFL];

	CSchematicObjectData.type	= E_CCFL;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_CCFL] = "X";
	CSchematicObjectData.attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	CSchematicObjectData.CSpiceParameters.use_model = true;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CModelType = "X";

	CSchematicObjectData.f_validate_label_value = false;
	CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Florecent Lamp";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "CCFL";
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "CCFL";
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= false;
	
	CSchematicObjectData.CSymbolData.CData.SetSize(5);

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 40;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.FormatLabels();
}

void TCSuperSpiceDataBase::SetupVSine(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SINE_VOLTAGE_SOURCE];

	CSchematicObjectData.type	= E_SINE_VOLTAGE_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].start_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[0].radius				= 16;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 40;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupVPulse(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PULSE_VOLTAGE_SOURCE];

	CSchematicObjectData.type	= E_PULSE_VOLTAGE_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].start_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[0].radius				= 16;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 40;

	////// Pulse symbol
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 36;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= 36;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 36;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupVExp(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE];

	CSchematicObjectData.type	= E_EXPONENTIAL_VOLTAGE_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].start_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[0].radius				= 16;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 40;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupVPWL(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE];

	CSchematicObjectData.type	= E_PIECEWISE_LINEAR_VOLTAGE_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].start_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[0].radius				= 16;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 40;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupVSFFM(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM];

	CSchematicObjectData.type	= E_SINGLE_FREQ_VOLTAGE_FM;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].start_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[0].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[0].radius				= 16;
	CSchematicObjectData.CSymbolData.CData[0].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 24;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 40;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupIDC(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DC_CURRENT_SOURCE];
	
	CSchematicObjectData.type	= E_DC_CURRENT_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -12;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 12;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -4;

	
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[4].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].start_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupISine(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SINE_CURRENT_SOURCE];
	
	CSchematicObjectData.type	= E_SINE_CURRENT_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -12;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 12;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -4;

	
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[4].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupIPulse(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PULSE_CURRENT_SOURCE];
	
	CSchematicObjectData.type	= E_PULSE_CURRENT_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -12;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 12;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -4;

	
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[4].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

		////// Pulse symbol
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -20;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= -20;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= -20;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= -16;
/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupIExp(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE];
	
	CSchematicObjectData.type	= E_EXPONENTIAL_CURRENT_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -12;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 12;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -4;

	
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[4].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupIPWL(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE];
	
	CSchematicObjectData.type	= E_PIECEWISE_LINEAR_CURRENT_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -12;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 12;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -4;

	
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[4].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupISFFM(void)
{
	
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SINGLE_FREQ_CURRENT_FM];
	
	CSchematicObjectData.type	= E_SINGLE_FREQ_CURRENT_FM;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -12;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 12;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -4;

	
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[4].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 12;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupZener(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ZENER_COMPONENT];


	

	
	CSchematicObjectData.type	= E_ZENER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
		

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 4;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8, 8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 4;


	CSchematicObjectData.f_vector_graphic = true;
	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 24;
}

void TCSuperSpiceDataBase::SetupTestPoint(void)
{
	
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TEST_MARKER];

	CSchematicObjectData.type	= E_TEST_MARKER;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;//16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;//16;

	CSchematicObjectData.CLocationOffset.x = 32;//16;
	CSchematicObjectData.CLocationOffset.y = 32;//16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= -8-16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -8-16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -16-16;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= -16-16;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= -16-16;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= -8-16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -16-16;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= -8-16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= -8-16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= -8-16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -8-16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -8-16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= -8-16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= -16-16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= -8-16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -16-16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= -16-16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -16 -16;


/// Symbol end lines

	CSchematicObjectData.width	= 16; 
	CSchematicObjectData.height	= 16;//32;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupVCVS(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_VCVSRC_COMPONENT];

	CSchematicObjectData.type	= E_VCVSRC_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(14, 14);

	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12; // -, +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16; // |, +
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -20;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 12; // -, -
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 0;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 0;


	// Vin
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= -8; 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= -8; 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= -4;


	// Vout
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 40; 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= 36;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 40; 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y		= -4;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupVCIS(void)
{	
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_VCISRC_COMPONENT];

	CSchematicObjectData.type	= E_VCISRC_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(15, 15);

	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12; // -, +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16; // |, +
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -20;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 12; // -, -
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 0;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 0;


	// Vin
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= -8; 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= -12;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= -8; 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= -4;


	// Iout
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 40; 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 36; 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 36; 
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupICVS(void)
{

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ICVSRC_COMPONENT];
	
	CSchematicObjectData.type	= E_ICVSRC_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(15, 15);

	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12; // -, +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16; // |, +
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -20;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 12; // -, -
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 0;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 0;


	// Vin
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40; 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 36;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40; 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= -4;


	// Iin
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= -8; 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= -12; 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= -12; 
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupICIS(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ICISRC_COMPONENT];

	CSchematicObjectData.type	= E_ICISRC_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(16, 16);

	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12; // -, +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16; // |, +
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -20;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 12; // -, -
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 20;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 0;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 16; 
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 0;


	// Vin
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= -8; 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= -12; 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= -12; 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= -4;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= 4;


	// Iout
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 40; 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 36; 
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 36; 
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupGround(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GROUND];
	
	CSchematicObjectData.type	= E_GROUND;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= -10;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 10;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -4;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 8;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 32;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupPageConnecterInput(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PAGE_CONNECTER_INPUT];

	CSchematicObjectData.type	= E_PAGE_CONNECTER_INPUT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 8;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -8;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupSubcurcuitConnecter(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER];

	CSchematicObjectData.type	= E_SUBCIRCUIT_PIN_CONNECTER;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 8;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 6;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -6;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 6;
/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupPageConnecterOutput(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PAGE_CONNECTER_OUTPUT];

	CSchematicObjectData.type	= E_PAGE_CONNECTER_OUTPUT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 8;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -8;

/// Symbol end lines

	CSchematicObjectData.width	= 32; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupPageConnecterBidirectional(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL];

	CSchematicObjectData.type	= E_PAGE_CONNECTER_BIDIRECTIONAL;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6, 6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 8;
	CSchematicObjectData.CSymbolData.CData[0].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -8;

/// Symbol end lines

	CSchematicObjectData.width	= 48; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupThyresistor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_THRYSISTER_COMPONENT];
	
	CSchematicObjectData.type	= E_THRYSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
		
	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 4;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8, 8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 32;


	CSchematicObjectData.f_vector_graphic = true;
	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;
}

void TCSuperSpiceDataBase::SetupShottky(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SHOTTKY_COMPONENT];

	CSchematicObjectData.type	= E_SHOTTKY_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;	

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;	


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 4;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(10, 10);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40; //bottom -
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 24;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 44; //bottom |
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 40; //top -
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 36;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 36; //top |
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 36;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 12;

	CSchematicObjectData.f_vector_graphic = true;
	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 24;

}
void TCSuperSpiceDataBase::SetupDiac(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIAC_COMPONENT];
	
	CSchematicObjectData.type	= E_DIAC_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x =16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 12;

	CSchematicObjectData.f_vector_graphic = true;
	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;
}

void TCSuperSpiceDataBase::SetupTriac(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRIAC_COMPONENT];
	
	CSchematicObjectData.type	= E_TRIAC_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x =16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
		
	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;


	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -4;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 12;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 8;

	CSchematicObjectData.f_vector_graphic = true;
	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;
}


void TCSuperSpiceDataBase::SetupDualGateNMos(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DUAL_GATE_NMOSFET];

	CSchematicObjectData.type	= E_DUAL_GATE_NMOSFET;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // s/d
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // gate 1
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // s/d
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable			= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x		 = 0; // gate 2
	CSchematicObjectData.CPinListData[3].CLocation.y		 = 16;
	CSchematicObjectData.CPinListData[3].is_visable		 = true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(14, 14);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 44;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 40; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 40; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= 44;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 16; // gate 1
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y		= 48;

	/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupDualGatePMos(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DUAL_GATE_PMOSFET];


	CSchematicObjectData.type	= E_DUAL_GATE_PMOSFET;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // gate 1
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable			= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x		 = 0; // gate 2
	CSchematicObjectData.CPinListData[3].CLocation.y		 = 16;
	CSchematicObjectData.CPinListData[3].is_visable		 = true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(14, 14);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 44;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 60; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 60; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y		= 44;


	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 16; // gate 1
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y		= 48;


	// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupGTO(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GTO_COMPONENT];
	CSchematicObjectData.type	= E_GTO_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
		
	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable		= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 4;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 24;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 28;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 44;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 52;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 28;


	CSchematicObjectData.f_vector_graphic = true;
	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;
}
void TCSuperSpiceDataBase::SetupTransformer(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_COMPONENT];

	CSchematicObjectData.type	= E_TRANSFORMER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[3].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines
	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[2].radius				= 8;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[5].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -20;
	CSchematicObjectData.CSymbolData.CData[6].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[6].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[6].radius			= 2;
	CSchematicObjectData.CSymbolData.CData[6].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupTransformerFlyback(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_FLYBACK_TRIPLE];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL];

	CSchematicObjectData.type = E_TRANSFORMER_FLYBACK_TRIPLE;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerFlyback";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Flyback";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Flyback Triple Transformer";

	CSchematicObjectData.CPinListData.SetSize(6);
	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	int p;

	for(p = 4; p < 6; p++)
	{
		CSchematicObjectData.CPinListData[p].CLocation.y += 64;
		CSchematicObjectData.CPinListData[p].CLocation.x -= 80;
	}
	
	for(p = 7; p < 11; p++)
	{	
		CSchematicObjectData.CSymbolData.CData[p].CStartLocation.y +=64;
		CSchematicObjectData.CSymbolData.CData[p].CEndLocation.y += 64;
		CSchematicObjectData.CSymbolData.CData[p].CStartLocation.x -= 80;
		CSchematicObjectData.CSymbolData.CData[p].CEndLocation.x -= 80;
	}

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y -=32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y -= 32;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y -=32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y -= 32;

	CSchematicObjectData.height = (unsigned short) (64 + 16);
	CSchematicObjectData.width = 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupTransformerTubeOutput(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_TUBE_OUTPUT];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED];

	CSchematicObjectData.type = E_TRANSFORMER_TUBE_OUTPUT;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TubeAmpTransformer";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Tube Amp Transformer";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Tube Output Transformer";

	CSchematicObjectData.CPinListData.SetSize(7, 7);

	CSchematicObjectData.CPinListData[6] = CSchematicObjectData.CPinListData[5];

	CSchematicObjectData.CPinListData[3].CLocation.x -= 16;

	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[4];

	CSchematicObjectData.CPinListData[4].CLocation.x -= 16;

	CSchematicObjectData.CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[6].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a1";
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "HT";
	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a2";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "16 ohm";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "8 ohm";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "4 ohm";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Gnd";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "7";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CSchematicObjectData.CSymbolData.CData.SetSize(8);

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= -24;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[7].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[7].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[7].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[7].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.f_vector_graphic = true;

	CSchematicObjectData.CGrabOffset.y = -16;
	CSchematicObjectData.CGrabOffset.x = -16;

	CSchematicObjectData.width += 16;
	CSchematicObjectData.height +=32;
}

void TCSuperSpiceDataBase::SetupTransformerDual(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_COMPONENT];

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerDual";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Dual";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Dual Transformer";

	CSchematicObjectData.type	= E_TRANSFORMER_DUAL;

	CSchematicObjectData.CPinListData.SetSize(8);

	CString CText;
	int offset = 4;

	int p;

	for(p = 0; p < 4; p++)
	{
		CSchematicObjectData.CPinListData[p + offset] = CSchematicObjectData.CPinListData[p]; 

		CSchematicObjectData.CPinListData[p + offset].CLocation.x = CSchematicObjectData.CPinListData[p].CLocation.x + CSchematicObjectData.width + 16;

		CText.Format("%d", p + offset + 1);

		CSchematicObjectData.CPinListData[p + offset].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CText;
	}

	CSchematicObjectData.CPinListData[offset].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+3";
	CSchematicObjectData.CPinListData[offset + 1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-3";
	CSchematicObjectData.CPinListData[offset + 2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+4";
	CSchematicObjectData.CPinListData[offset + 3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-4";

	CSchematicObjectData.CSymbolData.CData.SetSize(14, 14);

	offset = 7;

	for(p = 0; p < 7; p++)
	{
		CSchematicObjectData.CSymbolData.CData[p + offset] = CSchematicObjectData.CSymbolData.CData[p];
	
		CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x + CSchematicObjectData.width + 16;
		CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x + CSchematicObjectData.width + 16;
	}

	CSchematicObjectData.CSymbolData.CData.SetSize(15, 15);

	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 0;

	CSchematicObjectData.width = (unsigned short) (64 + 64 + 16);

}
void TCSuperSpiceDataBase::SetupTransformerTriple(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_TRIPLE];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL];

	
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerTriple";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Triple";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Triple Transformer";

	CSchematicObjectData.type	= E_TRANSFORMER_TRIPLE;

	CSchematicObjectData.CPinListData.SetSize(12);

	CString CText;
	int offset = 8;

	int p;

	for(p = 0; p < 4; p++)
	{
		CSchematicObjectData.CPinListData[p + offset] = CSchematicObjectData.CPinListData[p]; 

		CSchematicObjectData.CPinListData[p + offset].CLocation.x = CSchematicObjectData.CPinListData[p].CLocation.x + CSchematicObjectData.width + 16;

		CText.Format("%d", p + offset + 1);

		CSchematicObjectData.CPinListData[p + offset].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CText;
	}

	CSchematicObjectData.CPinListData[offset].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+5";
	CSchematicObjectData.CPinListData[offset + 1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-5";
	CSchematicObjectData.CPinListData[offset + 2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+6";
	CSchematicObjectData.CPinListData[offset + 3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-6";

	CSchematicObjectData.CSymbolData.CData.SetSize(21, 21);

	offset = 14;

	for(p = 0; p < 7; p++)
	{
		CSchematicObjectData.CSymbolData.CData[p + offset] = CSchematicObjectData.CSymbolData.CData[p];
	
		CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x + CSchematicObjectData.width + 16;
		CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x + CSchematicObjectData.width + 16;
	}

	CSchematicObjectData.CSymbolData.CData.SetSize(23, 23);

	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.x	= 112;
	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.x	= 128;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.y	= 0;

	CSchematicObjectData.width = (unsigned short) (64 + 64 + 64 + 16 + 16);
}

void TCSuperSpiceDataBase::SetupTransformerQuad(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_QUAD];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_TRIPLE];

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerQuad";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Quad";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Quad Transformer";

	CSchematicObjectData.type	= E_TRANSFORMER_QUAD;

	CSchematicObjectData.CPinListData.SetSize(16);

	CString CText;
	int offset = 12;

	int p;

	for(p = 0; p < 4; p++)
	{
		CSchematicObjectData.CPinListData[p + offset] = CSchematicObjectData.CPinListData[p]; 

		CSchematicObjectData.CPinListData[p + offset].CLocation.x = CSchematicObjectData.CPinListData[p].CLocation.x + CSchematicObjectData.width + 16;

		CText.Format("%d", p + offset + 1);

		CSchematicObjectData.CPinListData[p + offset].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CText;
	}

	CSchematicObjectData.CPinListData[offset].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+7";
	CSchematicObjectData.CPinListData[offset + 1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-7";
	CSchematicObjectData.CPinListData[offset + 2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+8";
	CSchematicObjectData.CPinListData[offset + 3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-8";

	CSchematicObjectData.CSymbolData.CData.SetSize(28, 28);

	offset = 21;

	for(p = 0; p < 7; p++)
	{
		CSchematicObjectData.CSymbolData.CData[p + offset] = CSchematicObjectData.CSymbolData.CData[p];
	
		CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x + CSchematicObjectData.width + 16;
		CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x + CSchematicObjectData.width + 16;
	}

	CSchematicObjectData.CSymbolData.CData.SetSize(31, 31);

	CSchematicObjectData.CSymbolData.CData[28].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[28].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[28].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[28].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[29].CStartLocation.x	= 112;
	CSchematicObjectData.CSymbolData.CData[29].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[29].CEndLocation.x	= 128;
	CSchematicObjectData.CSymbolData.CData[29].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[30].CStartLocation.x	= 192;
	CSchematicObjectData.CSymbolData.CData[30].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[30].CEndLocation.x	= 208;
	CSchematicObjectData.CSymbolData.CData[30].CEndLocation.y	= 0;

	CSchematicObjectData.width = (unsigned short) (64 + 64 + 64 + 64 + 16 + 16 + 16);
}

void TCSuperSpiceDataBase::SetupTransformerCenterTapedSingle(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED];

	CSchematicObjectData.type	= E_TRANSFORMER_SINGLE_CENTERTAPED;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerCentertaped";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Centertaped";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Single Center Taped Transformer";

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= -16;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[5].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines
	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 0;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= -180;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -8;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].start_angle		= -180;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[5].radius			= 8;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -20;
	CSchematicObjectData.CSymbolData.CData[6].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[6].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[6].radius			= 2;
	CSchematicObjectData.CSymbolData.CData[6].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 32;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupOneCenterTapTransformer(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_ONE_CENTER_TAP];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED];

	CSchematicObjectData.type	= E_TRANSFORMER_ONE_CENTER_TAP;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "(NO_MODEL_ATTACHED)";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "One Center Taped Transformer";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "One Center Taped Transformer";

	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[5];

	CSchematicObjectData.CPinListData.SetSize(5);
}

void TCSuperSpiceDataBase::SetupTransformerCenterTapedDual(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL_CENTERTAPED];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED];

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerCentertapedDual";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Centertaped Dual";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Dual Center Taped Transformer";

	CSchematicObjectData.type	= E_TRANSFORMER_DUAL_CENTERTAPED;

	CSchematicObjectData.CPinListData.SetSize(12);

	CString CText;
	int offset = 6;

	int p;

	for(p = 0; p < 6; p++)
	{
		CSchematicObjectData.CPinListData[p + offset] = CSchematicObjectData.CPinListData[p]; 

		CSchematicObjectData.CPinListData[p + offset].CLocation.x = CSchematicObjectData.CPinListData[p].CLocation.x + CSchematicObjectData.width + 16;

		CText.Format("%d", p + offset + 1);

		CSchematicObjectData.CPinListData[p + offset].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CText;
	}

	CSchematicObjectData.CPinListData[offset].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+3";
	CSchematicObjectData.CPinListData[offset + 1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct3";
	CSchematicObjectData.CPinListData[offset + 2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-3";
	CSchematicObjectData.CPinListData[offset + 3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+4";
	CSchematicObjectData.CPinListData[offset + 4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct4";
	CSchematicObjectData.CPinListData[offset + 5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-4";

	CSchematicObjectData.CSymbolData.CData.SetSize(14, 14);

	offset = 7;

	for(p = 0; p < 7; p++)
	{
		CSchematicObjectData.CSymbolData.CData[p + offset] = CSchematicObjectData.CSymbolData.CData[p];
	
		CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x + CSchematicObjectData.width + 16;
		CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x + CSchematicObjectData.width + 16;
	}

	CSchematicObjectData.CSymbolData.CData.SetSize(15, 15);

	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 0;

	CSchematicObjectData.width = (unsigned short) (64 + 64 + 16);
}

void TCSuperSpiceDataBase::SetupDualOneCenterTapTransformer(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL_ONE_CENTER_TAP];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL_CENTERTAPED];

	CSchematicObjectData.type	= E_TRANSFORMER_DUAL_ONE_CENTER_TAP;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "(NO_MODEL_ATTACHED)";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Dual One Center Taped Transformer";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Dual One Center Taped Transformer";

	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[5];
	CSchematicObjectData.CPinListData[10] = CSchematicObjectData.CPinListData[11];

	CSchematicObjectData.CPinListData.SetSize(12);
}

void TCSuperSpiceDataBase::SetupTransformerCenterTapedTriple(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_TRIPLE_CENTERTAPED];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_DUAL_CENTERTAPED];

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerCentertapedTriple";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Centertaped Triple";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Triple Center Taped Transformer";

	CSchematicObjectData.type	= E_TRANSFORMER_TRIPLE_CENTERTAPED;

	CSchematicObjectData.CPinListData.SetSize(18);

	CString CText;
	int offset = 12;

	int p;

	for(p = 0; p < 6; p++)
	{
		CSchematicObjectData.CPinListData[p + offset] = CSchematicObjectData.CPinListData[p]; 

		CSchematicObjectData.CPinListData[p + offset].CLocation.x = CSchematicObjectData.CPinListData[p].CLocation.x + CSchematicObjectData.width + 16;

		CText.Format("%d", p + offset + 1);

		CSchematicObjectData.CPinListData[p + offset].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CText;
	}

	CSchematicObjectData.CPinListData[offset].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+5";
	CSchematicObjectData.CPinListData[offset + 1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct5";
	CSchematicObjectData.CPinListData[offset + 2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-5";
	CSchematicObjectData.CPinListData[offset + 3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+6";
	CSchematicObjectData.CPinListData[offset + 4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct6";
	CSchematicObjectData.CPinListData[offset + 5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-6";

	CSchematicObjectData.CSymbolData.CData.SetSize(21, 21);

	offset = 14;

	for(p = 0; p < 7; p++)
	{
		CSchematicObjectData.CSymbolData.CData[p + offset] = CSchematicObjectData.CSymbolData.CData[p];
	
		CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x + CSchematicObjectData.width + 16;
		CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x + CSchematicObjectData.width + 16;
	}

	CSchematicObjectData.CSymbolData.CData.SetSize(23, 23);

	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.x	= 112;
	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.x	= 128;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.y	= 0;

	CSchematicObjectData.width = (unsigned short) (64 + 64 + 64 + 16 + 16);
}

void TCSuperSpiceDataBase::SetupTransformerCenterTapedQuad(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSFORMER_QUAD_CENTERTAPED];

	CSchematicObjectData = CMDefaults[E_TRANSFORMER_TRIPLE_CENTERTAPED];

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TransformerCentertapedQuad";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer Centertaped Quad";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName += "_XN";
	CSchematicObjectData.CSymbolData.CName = "Quad Center Taped Transformer";


	CSchematicObjectData.type	= E_TRANSFORMER_QUAD_CENTERTAPED;

	CSchematicObjectData.CPinListData.SetSize(24);

	CString CText;
	int offset = 18;

	int p;

	for(p = 0; p < 6; p++)
	{
		CSchematicObjectData.CPinListData[p + offset] = CSchematicObjectData.CPinListData[p]; 

		CSchematicObjectData.CPinListData[p + offset].CLocation.x = CSchematicObjectData.CPinListData[p].CLocation.x + CSchematicObjectData.width + 16;

		CText.Format("%d", p + offset + 1);

		CSchematicObjectData.CPinListData[p + offset].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CText;
	}

	CSchematicObjectData.CPinListData[offset].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+7";
	CSchematicObjectData.CPinListData[offset + 1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct7";
	CSchematicObjectData.CPinListData[offset + 2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-7";
	CSchematicObjectData.CPinListData[offset + 3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+8";
	CSchematicObjectData.CPinListData[offset + 4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct8";
	CSchematicObjectData.CPinListData[offset + 5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-8";

	CSchematicObjectData.CSymbolData.CData.SetSize(28, 28);

	offset = 21;

	for(p = 0; p < 7; p++)
	{
		CSchematicObjectData.CSymbolData.CData[p + offset] = CSchematicObjectData.CSymbolData.CData[p];
	
		CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CStartLocation.x + CSchematicObjectData.width + 16;
		CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x = CSchematicObjectData.CSymbolData.CData[p + offset].CEndLocation.x + CSchematicObjectData.width + 16;
	}

	CSchematicObjectData.CSymbolData.CData.SetSize(31, 31);

	CSchematicObjectData.CSymbolData.CData[28].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[28].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[28].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[28].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[29].CStartLocation.x	= 112;
	CSchematicObjectData.CSymbolData.CData[29].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[29].CEndLocation.x	= 128;
	CSchematicObjectData.CSymbolData.CData[29].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[30].CStartLocation.x	= 192;
	CSchematicObjectData.CSymbolData.CData[30].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[30].CEndLocation.x	= 208;
	CSchematicObjectData.CSymbolData.CData[30].CEndLocation.y	= 0;

	CSchematicObjectData.width = (unsigned short) (64 + 64 + 64 + 64 + 16 + 16 + 16);
}

void TCSuperSpiceDataBase::SetupTransmissionLine(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRANSMISSION_LINE_COMPONENT];

	CSchematicObjectData.type	= E_TRANSMISSION_LINE_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		 = 0; // + in
	CSchematicObjectData.CPinListData[0].CLocation.y		 = -8;
	CSchematicObjectData.CPinListData[0].is_visable		 = true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 24;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		= 0; // - in
	CSchematicObjectData.CPinListData[1].CLocation.y		= 8;
	CSchematicObjectData.CPinListData[1].is_visable			= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y	= 24;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 96;  // + out
	CSchematicObjectData.CPinListData[2].CLocation.y	= -8;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 24;
	CSchematicObjectData.CPinListData[2].is_visable		 = true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x		 = 96; // - out
	CSchematicObjectData.CPinListData[3].CLocation.y		 = 8;
	CSchematicObjectData.CPinListData[3].is_visable		 = true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 24;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 24;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 96;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 96;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 96;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -16;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 96; 
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -16;


	// Symbol end lines

	CSchematicObjectData.width	= 128; 
	CSchematicObjectData.height	= 32;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupVSwitch(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_VSWITCH_COMPONENT];

	CSchematicObjectData.type	= E_VSWITCH_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 4; // -, +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8; // |, +
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -20;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 4; // -, -
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 24; 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupISwitch(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ISWITCH_COMPONENT];

	CSchematicObjectData.type	= E_ISWITCH_COMPONENT;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;


	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].type			= E_POINTING_RIGHT_PIN_COMPONENT;

	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_LINE;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 4; // -, +
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8; // |, +
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -20;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 4; // -, -
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 16;


	// out arrow
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 24; 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupNIGBP(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NIGBP_COMPONENT];

	CSchematicObjectData.type	= E_NIGBP_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // collector
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // base
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // emitter
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable		= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 64; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 49;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 43;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 54; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40; // | top 
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 24;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 40; // | mid 
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 40; // | bottom 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 48;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupPIGBP(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PIGBP_COMPONENT];

	CSchematicObjectData.type					= E_PIGBP_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 48; // collector
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0; // base
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // emitter
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 40; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 53;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 45;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 40; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 56;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 38;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40; // | top 
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 24;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 40; // | mid 
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 40; // | bottom 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 48;


// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupMultiplier(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_MULIPLIER_COMPONENT];
	
	CSchematicObjectData.type	= E_MULIPLIER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;


	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 32;
/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}


void TCSuperSpiceDataBase::SetupTitleBlock(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TITLE_BLOCK];

	CSchematicObjectData.type	= E_TITLE_BLOCK;

	CSchematicObjectData.CSymbolData.CData.SetSize(17);
	
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 240;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 240;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 240;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 240;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

	//////////////////////////

	int y_step		= 24;
	int y_position	= y_step;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= y_position;

	y_position += y_step;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= y_position;

	y_position += y_step;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= y_position;

	y_position += y_step;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= y_position;

	y_position += y_step;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= y_position;

	y_position += y_step;
	y_position += y_step;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= y_position;

	y_position += y_step;
	y_position += y_step;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= y_position;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 320;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= y_position;

///////////
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 96;
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 96;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 216;

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 176;
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 216;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 176;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 240;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 240;
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 216;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 240;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 240;

	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 272;
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 216;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 272;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 240;

	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 272;
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 168;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x	= 272;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y	= 216;

	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.x	= 288;
	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.y	= 216;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.x	= 288;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.y	= 240;

	CSchematicObjectData.width	= 320; 
	CSchematicObjectData.height	= 240;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDivider(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_COMPONENT_DIVIDER];
	
	CSchematicObjectData.type	= E_COMPONENT_DIVIDER;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;


	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8, 8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= -32;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[6].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[6].radius			= 2;
	CSchematicObjectData.CSymbolData.CData[6].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[7].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[7].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[7].radius			= 2;
	CSchematicObjectData.CSymbolData.CData[7].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[7].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::Setup4TerninalNPNTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT];

	CSchematicObjectData.type	= E_NPN_4TERM_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // collector
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // base
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // emitter
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable		 = true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 48;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		 = true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 48; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 52; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 37;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 64; // | substrate
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 36;

// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::Setup4TerninalPNPTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_PNP_4TERM_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 48; // collector
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0; // base
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // emitter
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 48;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7, 7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 36;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 32; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 45;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 42;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 64; // | substrate
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 36;

/// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::Setup4TerninalNMos(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT];

	CSchematicObjectData.type	= E_NMOS_4TERM_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // s/d
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // s/d
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable			= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 48;  // backgate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable			= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(12, 12);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 20;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 44;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 40; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 28;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 40; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 44;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 36;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= 36;


/// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::Setup4TerninalPMos(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT];

	CSchematicObjectData.type	= E_PMOS_4TERM_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x		= 48; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y		= -16;
	CSchematicObjectData.CPinListData[0].is_visable			= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y	= 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x		 = 0; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y		 = 0;
	CSchematicObjectData.CPinListData[1].is_visable		 = true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 48;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable		 = true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 48;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		 = true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(12, 12);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 44;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 60; // lower slant
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 36;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 60; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 44;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 48;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 40;// substrate |
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x		= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y		= 36;


// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::Setup4TerninalNJFetTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT];


	CSchematicObjectData.type					= E_4TERM_NJFET_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 32; // | substrate tick
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::Setup4TerninalPJFetTransister(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_4TERM_PJFET_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -16; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 32; // | substrate tick
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupUnijunction(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_UNIJUNCTION_COMPONENT];

	CSchematicObjectData.type					= E_UNIJUNCTION_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -2;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -10;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 6;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupBuffer(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_BUFFER_COMPONENT];

	CSchematicObjectData.type					= E_BUFFER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //input
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 64;  // output
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32; // +Vcc
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // -Vee
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//upslope
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0; //upslope
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;


/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupVCA(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_VCA_COMPONENT];

	CSchematicObjectData.type					= E_VCA_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //+ input 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= -32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0; //- input 1
	CSchematicObjectData.CPinListData[1].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0; //+ input 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0; //- input 2
	CSchematicObjectData.CPinListData[3].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 96;  // output
	CSchematicObjectData.CPinListData[4].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[4].is_visable	= true;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32; // +Vcc
	CSchematicObjectData.CPinListData[5].CLocation.y	= -32;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 32;  // -Vee
	CSchematicObjectData.CPinListData[6].CLocation.y	= 32;	
	CSchematicObjectData.CPinListData[6].is_visable	= true;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 48;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 48;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -48;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//upslope
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 96;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0; //upslope
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 96;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0; // -, + in 1
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 4; // |, + in 1
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -36;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // -, - in 1
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -16;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 4; // |, + in 2
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 20;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 0; // -, + in 2
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 0; // -, - in 2
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 32;	


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 0; // in 1
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;	

/// Symbol end lines

	CSchematicObjectData.width	= 128; 
	CSchematicObjectData.height	= 96;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::Setup2InputAmp(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_2INPUT_AMP];

	CSchematicObjectData.type					= E_GENERIC_2INPUT_AMP;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //+ input 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= -32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0; //- input 1
	CSchematicObjectData.CPinListData[1].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0; //+ input 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0; //- input 2
	CSchematicObjectData.CPinListData[3].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 96;  // output
	CSchematicObjectData.CPinListData[4].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[4].is_visable	= true;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32; // +Vcc
	CSchematicObjectData.CPinListData[5].CLocation.y	= -32;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 48;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 32;  // -Vee
	CSchematicObjectData.CPinListData[6].CLocation.y	= 32;	
	CSchematicObjectData.CPinListData[6].is_visable	= true;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 48;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 48;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -48;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 48;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//upslope
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 96;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0; //upslope
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -48;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 96;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0; // -, + in 1
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 4; // |, + in 1
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= -28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= -36;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // -, - in 1
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 4; // |, + in 2
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 4;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= 20;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 0; // -, - in 2
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 0; // -, - in 2
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 32;	


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 0; // in 1
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 16;	

/// Symbol end lines

	CSchematicObjectData.width	= 128; 
	CSchematicObjectData.height	= 96;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupGenericPin2Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_2_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_2_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -8;
/*
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[5].start_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[5].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[5].radius				= 2;
	CSchematicObjectData.CSymbolData.CData[5].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[5].type				= E_SCHEMATIC_SYMBOL_CIRCLE;
*/
// Symbol end lines

	CSchematicObjectData.width		= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupGenericPin3Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_3_COMPONENT];
		
	CSchematicObjectData.type	= E_GENERIC_3_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 16;

	// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupGenericPin4Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_4_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_4_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupGenericPin5Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_5_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_5_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[4].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin6Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_6_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_6_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[5].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[5].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin7Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_7_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_7_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[5].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[5].is_visable	= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[5].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[5].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin8Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_8_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_8_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[5].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[5].is_visable	= true;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[6].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[6].is_visable	= true;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[7].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin9Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_9_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_9_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[5].is_visable	= true;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[6].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[6].is_visable	= true;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[7].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[8].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin10Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_10_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_10_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[6].is_visable	= true;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[7].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[8].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[9].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin11Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_11_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_11_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[6].is_visable	= true;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[7].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[8].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[9].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CPinListData[10].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[10].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[10].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[10].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[10].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[10].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin12Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_12_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_12_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[6].is_visable	= true;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[7].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[8].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[9].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CPinListData[10].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[10].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[10].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[10].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[10].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[10].is_visable	= true;

	CSchematicObjectData.CPinListData[11].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[11].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[11].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[11].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[11].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[11].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin13Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_13_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_13_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= -8;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].is_visable		= true;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[7].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[8].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[9].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CPinListData[10].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[10].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[10].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[10].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[10].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[10].is_visable	= true;

	CSchematicObjectData.CPinListData[11].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[11].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[11].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[11].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[11].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[11].is_visable	= true;

	CSchematicObjectData.CPinListData[12].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[12].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[12].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[12].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[12].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[12].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin14Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_14_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_14_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= -8;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 8;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].is_visable		= true;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].is_visable		= true;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[7].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[8].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[9].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CPinListData[10].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[10].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[10].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[10].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[10].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[10].is_visable	= true;

	CSchematicObjectData.CPinListData[11].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[11].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[11].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[11].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[11].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[11].is_visable	= true;

	CSchematicObjectData.CPinListData[12].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[12].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[12].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[12].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[12].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[12].is_visable	= true;

	CSchematicObjectData.CPinListData[13].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[13].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[13].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[13].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[13].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[13].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin15Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_15_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_15_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= -8;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 8;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].is_visable		= true;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].is_visable		= true;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[7].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[8].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[9].CLocation.y	= 8;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CPinListData[10].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[10].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[10].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[10].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[10].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[10].is_visable	= true;

	CSchematicObjectData.CPinListData[11].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[11].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[11].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[11].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[11].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[11].is_visable	= true;

	CSchematicObjectData.CPinListData[12].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[12].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[12].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[12].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[12].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[12].is_visable	= true;

	CSchematicObjectData.CPinListData[13].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[13].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[13].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[13].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[13].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[13].is_visable	= true;

	CSchematicObjectData.CPinListData[14].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[14].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[14].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[14].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[14].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[14].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupGenericPin16Component(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_GENERIC_16_COMPONENT];

	CSchematicObjectData.type	= E_GENERIC_16_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= -8;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 8;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].is_visable		= true;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].is_visable		= true;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].is_visable		= true;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[5].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].is_visable		= true;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[6].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].is_visable		= true;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[7].CLocation.y	= 40;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 56;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[8].CLocation.y	= 24;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CPinListData[9].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[9].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[9].CLocation.y	= 8;
	CSchematicObjectData.CPinListData[9].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[9].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[9].is_visable	= true;

	CSchematicObjectData.CPinListData[10].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[10].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[10].CLocation.y	= -8;
	CSchematicObjectData.CPinListData[10].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[10].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[10].is_visable	= true;

	CSchematicObjectData.CPinListData[11].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[11].CLocation.x	= 80;
	CSchematicObjectData.CPinListData[11].CLocation.y	= -24;
	CSchematicObjectData.CPinListData[11].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[11].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[11].is_visable	= true;

	CSchematicObjectData.CPinListData[12].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[12].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[12].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[12].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[12].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[12].is_visable	= true;

	CSchematicObjectData.CPinListData[13].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[13].CLocation.x	= 48;
	CSchematicObjectData.CPinListData[13].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[13].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[13].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[13].is_visable	= true;

	CSchematicObjectData.CPinListData[14].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[14].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[14].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[14].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[14].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[14].is_visable	= true;

	CSchematicObjectData.CPinListData[15].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[15].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[15].CLocation.y	= -40;
	CSchematicObjectData.CPinListData[15].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[15].CLocationOffset.y = 56;
	CSchematicObjectData.CPinListData[15].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 56;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -40;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 40;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 80;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -40;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 80;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -40;

/// Symbol end lines

	CSchematicObjectData.width	= 112; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}


void TCSuperSpiceDataBase::SetupNGasFet(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NGASFET_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_NGASFET_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(10, 10);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupPGasFet(void)
{
	
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PGASFET_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_PGASFET_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(10, 10);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -16; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::Setup4TerminalNGasFet(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT];


	CSchematicObjectData.type					= E_NGASFET_4TERM_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 32; // | substrate tick
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::Setup4TerminalPGasFet(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT];

	CSchematicObjectData.type					= E_PGASFET_4TERM_TRANSISTER_COMPONENT;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 32; // drain
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= -16; // gate
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;  // source
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // substrate
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 32;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(11, 11);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 16;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//-
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -12;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= 12;


	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= -16; // upper slant
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -16; // lower slant
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 4;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x		= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y		= 8;


	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 32; // upper extention
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -12;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y		= -16;


	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 32; // lower extention
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 12;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y		= 16;


	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= -16; // | gate tick
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x		= -16;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y		= 4;


	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 32; // | substrate tick
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= -4;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y		= 4;

/// Symbol end lines

	CSchematicObjectData.width	= 80; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupTriode(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRIODE_VALVE];

	CSchematicObjectData.type	= E_TRIODE_VALVE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;//anode
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;// grid
	CSchematicObjectData.CPinListData[1].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;// cathode
	CSchematicObjectData.CPinListData[2].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(12);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 180;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;// cathode line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;// cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;//andode line
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;// anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 0;// first line to grid pin
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 8;// 2nd line at grid
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 16;// 3rd line at grid 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// 4th line at grid 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 32;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupTubeDiodeSingle(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_SINGLE];

	CSchematicObjectData.type	= E_TUBE_DIODE_SINGLE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;//anode
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;// cathode
	CSchematicObjectData.CPinListData[1].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 180;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;// cathode line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;// cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;//andode line
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;// anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;


/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupTubeDiodeDualCommonCathode(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE];

	CSchematicObjectData.type	= E_TUBE_DIODE_DUAL_COMMON_CATHODE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;//anode
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;// cathode
	CSchematicObjectData.CPinListData[1].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;//anode
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 16;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(10);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 24;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 180;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 24;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;// cathode line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;// cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;//andode line
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 22;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;// anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 26;//2nd andode line
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 32;// 2nd anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= -16;



/// Symbol end lines

	CSchematicObjectData.width	= 48; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupTubeDiodeDualIndividualCathode(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES];

	CSchematicObjectData.type	= E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;//anode
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;// cathode
	CSchematicObjectData.CPinListData[1].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;//anode
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
		
	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 48;// cathode
	CSchematicObjectData.CPinListData[3].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 16;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(12);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 24;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 180;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 24;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;// cathode line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;// cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;//andode line
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 22;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;// anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 26;//2nd andode line
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 32;// 2nd anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 48;// 2nd cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 28;// 2nd cathode line
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 48;

/// Symbol end lines

	CSchematicObjectData.width	= 48; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupTetrode(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TETRODE_VALVE];

	CSchematicObjectData.type	= E_TETRODE_VALVE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;//anode
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;// screen 1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 0;// grid
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;// cathode
	CSchematicObjectData.CPinListData[3].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(16);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 180;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;// cathode line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;// cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;//andode line
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;// anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 0;// first line to grid pin
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 8;// 2nd line at grid
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 16;// 3rd line at grid 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// 4th line at grid 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 32;// top screen grid -
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 24;// top screen grid --
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 16;
	
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 16;// top screen grid --
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 8;// top screen grid --
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y	= 16;
/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupPentode(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PENTODE_VALVE];

	CSchematicObjectData.type	= E_PENTODE_VALVE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 16;//anode
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;// screen 1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;// screen 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 0;// grid
	CSchematicObjectData.CPinListData[3].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 0;// cathode
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(20);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 180;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 180;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 0;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 16;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 8;// cathode line
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 8;// cathode slant to pin
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 8;//andode line
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -8;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16;// anode vertical line to pin
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 0;// first line to grid pin
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 8;// 2nd line at grid
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 16;// 3rd line at grid 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// 4th line at grid 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 32;// top screen grid -
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 24;// top screen grid --
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 0;
	
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 16;// top screen grid --
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 8;// top screen grid --
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.x	= 32;// 2nd screen grid -
	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.x	= 28;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[17].CStartLocation.x	= 24;// 2nd screen grid --
	CSchematicObjectData.CSymbolData.CData[17].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[17].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[17].CEndLocation.y	= 16;
	
	CSchematicObjectData.CSymbolData.CData[18].CStartLocation.x	= 16;// 2nd screen grid --
	CSchematicObjectData.CSymbolData.CData[18].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[18].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[18].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[19].CStartLocation.x	= 8;// 2nd screen grid --
	CSchematicObjectData.CSymbolData.CData[19].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[19].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[19].CEndLocation.y	= 16;
/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 112;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupTriodeHeater(void)
{
	CString CSymbolName = CMDefaults[E_TRIODE_VALVE_HEATER].CSymbolData.CName;

	CMDefaults[E_TRIODE_VALVE_HEATER] = CMDefaults[E_TRIODE_VALVE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRIODE_VALVE_HEATER];

	CSchematicObjectData.type	= E_TRIODE_VALVE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TRIODE_VALVE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(5);

	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "9";

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;// heater 1
	CSchematicObjectData.CPinListData[3].CLocation.y	= 80;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(17);

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 8;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 16;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 8;// heater |  
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 80;

	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 24;// heater -  
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.x	= 8;// heater  
	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.y	= 80;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.y	= 80;
}

void TCSuperSpiceDataBase::SetupTriodeCommonHeater(void)
{
	CString CSymbolName = CMDefaults[E_TUBE_TRIODE_COMMON_CATHODE_HEATER].CSymbolData.CName;

	CMDefaults[E_TUBE_TRIODE_COMMON_CATHODE_HEATER] = CMDefaults[E_TRIODE_VALVE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_TRIODE_COMMON_CATHODE_HEATER];

	CSchematicObjectData.type	= E_TUBE_TRIODE_COMMON_CATHODE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_TRIODE_COMMON_CATHODE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k/h1";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "(NULL)";
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "(NULL)";

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[3].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(16);

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 8;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 16;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 24;// heater -  
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 8;// heater - left  
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y	= 64;
}

void TCSuperSpiceDataBase::SetupTetrodeHeater(void)
{
	CString CSymbolName = CMDefaults[E_TETRODE_VALVE_HEATER].CSymbolData.CName;

	CMDefaults[E_TETRODE_VALVE_HEATER] = CMDefaults[E_TETRODE_VALVE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TETRODE_VALVE_HEATER];

	CSchematicObjectData.type	= E_TETRODE_VALVE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TETRODE_VALVE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "9";

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// heater 1
	CSchematicObjectData.CPinListData[4].CLocation.y	= 80;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable		= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[5].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[5].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(21);

	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.x	= 8;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[17].CStartLocation.x	= 16;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[17].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[17].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[17].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[18].CStartLocation.x	= 8;// heater |  
	CSchematicObjectData.CSymbolData.CData[18].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[18].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[18].CEndLocation.y	= 80;

	CSchematicObjectData.CSymbolData.CData[19].CStartLocation.x	= 24;// heater -  
	CSchematicObjectData.CSymbolData.CData[19].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[19].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[19].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[20].CStartLocation.x	= 8;// heater  
	CSchematicObjectData.CSymbolData.CData[20].CStartLocation.y	= 80;
	CSchematicObjectData.CSymbolData.CData[20].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[20].CEndLocation.y	= 80;

}
void TCSuperSpiceDataBase::SetupPentodeHeater(void)
{
	CString CSymbolName = CMDefaults[E_PENTODE_VALVE_HEATER].CSymbolData.CName;

	CMDefaults[E_PENTODE_VALVE_HEATER] = CMDefaults[E_PENTODE_VALVE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_PENTODE_VALVE_HEATER];

	CSchematicObjectData.type	= E_PENTODE_VALVE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_PENTODE_VALVE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(7);

	CSchematicObjectData.CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[6].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "9";

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;// heater 1
	CSchematicObjectData.CPinListData[5].CLocation.y	= 80;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[5].is_visable		= true;

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[6].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[6].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(25);

	CSchematicObjectData.CSymbolData.CData[20].CStartLocation.x	= 8;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[20].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[20].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[20].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.x	= 16;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.x	= 8;// heater |  
	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.y	= 80;

	CSchematicObjectData.CSymbolData.CData[23].CStartLocation.x	= 24;// heater -  
	CSchematicObjectData.CSymbolData.CData[23].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[23].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[23].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[24].CStartLocation.x	= 8;// heater  
	CSchematicObjectData.CSymbolData.CData[24].CStartLocation.y	= 80;
	CSchematicObjectData.CSymbolData.CData[24].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[24].CEndLocation.y	= 80;

}

void TCSuperSpiceDataBase::SetupTube8Pin(void)
{
	CString CSymbolName = CMDefaults[E_TUBE_8PIN].CSymbolData.CName;

	CMDefaults[E_TUBE_8PIN] = CMDefaults[E_PENTODE_VALVE_HEATER];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_8PIN];

	CSchematicObjectData.type	= E_TUBE_8PIN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_8PIN] = "X";

	CSchematicObjectData.CPinListData.SetSize(8);
	CSchematicObjectData.CPinListData[7].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[7].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "nc";
	CSchematicObjectData.CPinListData[7].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";


	CSchematicObjectData.CPinListData[7].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 32;// ht ct
	CSchematicObjectData.CPinListData[7].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[7].is_visable	= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(25);
}

void TCSuperSpiceDataBase::SetupTubeDiodeSingleHeater(void)
{
	CString CSymbolName = CMDefaults[E_TUBE_DIODE_SINGLE_HEATER].CSymbolData.CName;

	CMDefaults[E_TUBE_DIODE_SINGLE_HEATER] = CMDefaults[E_TUBE_DIODE_SINGLE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_SINGLE_HEATER];

	CSchematicObjectData.type	= E_TUBE_DIODE_SINGLE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_DIODE_SINGLE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;// heater 1
	CSchematicObjectData.CPinListData[2].CLocation.y	= 80;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable		= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[3].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(13);

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 8;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 16;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 8;// heater |  
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 8;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 80;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// heater -  
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 8;// heater  
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 80;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 80;

}

void TCSuperSpiceDataBase::SetupTubeDiodeCommonHeater(void)
{
	CString CSymbolName = CMDefaults[E_TUBE_DIODE_COMMON_CATHODE_HEATER].CSymbolData.CName;

	CMDefaults[E_TUBE_DIODE_COMMON_CATHODE_HEATER] = CMDefaults[E_TUBE_DIODE_SINGLE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_COMMON_CATHODE_HEATER];

	CSchematicObjectData.type	= E_TUBE_DIODE_COMMON_CATHODE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_DIODE_COMMON_CATHODE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(3);

	CSchematicObjectData.CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "(NULL)";
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "(NULL)";

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[2].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(13);

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 8;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.x	= 16;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[9].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[9].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// heater -  
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 8;// heater  - left
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 64;
}

void TCSuperSpiceDataBase::SetupTubeDiodeDualCommonCathodeHeater(void)
{
	CString CSymbolName = CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER].CSymbolData.CName;

	CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER] = CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER];

	CSchematicObjectData.type	= E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(5);

	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 16;// heater 1
	CSchematicObjectData.CPinListData[3].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(12);

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 16;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 64;

}

void TCSuperSpiceDataBase::SetupTubeDiodeDualCommonHeater()
{
	CString CSymbolName = CMDefaults[E_TUBE_DIODE_DUAL_CATHODE_HEATER].CSymbolData.CName;

	CMDefaults[E_TUBE_DIODE_DUAL_CATHODE_HEATER] = CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_DUAL_CATHODE_HEATER];

	CSchematicObjectData.type	= E_TUBE_DIODE_DUAL_CATHODE_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_DIODE_DUAL_CATHODE_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k/h1";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a2";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[3].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(13);

	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.x	= 16;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[10].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[10].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.x	= 24;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[11].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[11].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 16;// heater _/  
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 64;
}

void TCSuperSpiceDataBase::SetupTubeDiodeDualIndividualCathodeHeater(void)
{
	CString CSymbolName = CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER].CSymbolData.CName;

	CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER] = CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER];

	CSchematicObjectData.type	= E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 16;// heater 1
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable		= true;

	CSchematicObjectData.CPinListData[5].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[5].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[5].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[5].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[5].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[5].is_visable		= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(14);

	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.x	= 16;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[12].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[12].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.x	= 24;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[13].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[13].CEndLocation.y	= 64;
}

void TCSuperSpiceDataBase::SetupTriodeDual(void)
{
	CString CSymbolName = CMDefaults[E_TRIODE_VALVE_DUAL].CSymbolData.CName;

	CMDefaults[E_TRIODE_VALVE_DUAL] = CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRIODE_VALVE_DUAL];

	CSchematicObjectData.type	= E_TRIODE_VALVE_DUAL;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TRIODE_VALVE_DUAL] = "X";

	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a1";
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g1";
	CSchematicObjectData.CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k1";
	CSchematicObjectData.CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a2";
	CSchematicObjectData.CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g2";
	CSchematicObjectData.CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "7";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k2";
	CSchematicObjectData.CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "8";

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;// grid 1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 48;// grid 2
	CSchematicObjectData.CPinListData[4].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(20);

	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.x	= 0;// first line to grid pin
	CSchematicObjectData.CSymbolData.CData[14].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.x	= 4;
	CSchematicObjectData.CSymbolData.CData[14].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.x	= 8;// 2nd line at grid
	CSchematicObjectData.CSymbolData.CData[15].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.x	= 12;
	CSchematicObjectData.CSymbolData.CData[15].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.x	= 16;// 3rd line at grid 
	CSchematicObjectData.CSymbolData.CData[16].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[16].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[17].CStartLocation.x	= 28;// -3 th line at grid 
	CSchematicObjectData.CSymbolData.CData[17].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[17].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[17].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[18].CStartLocation.x	= 36;// -3 th line at grid 
	CSchematicObjectData.CSymbolData.CData[18].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[18].CEndLocation.x	= 40;
	CSchematicObjectData.CSymbolData.CData[18].CEndLocation.y	= 32;

	CSchematicObjectData.CSymbolData.CData[19].CStartLocation.x	= 44;// -3 th line at grid 
	CSchematicObjectData.CSymbolData.CData[19].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[19].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[19].CEndLocation.y	= 32;
}

void TCSuperSpiceDataBase::SetupTriodeDualHeater(void)
{
	CString CSymbolName = CMDefaults[E_TRIODE_VALVE_DUAL_HEATER].CSymbolData.CName;

	CMDefaults[E_TRIODE_VALVE_DUAL_HEATER] = CMDefaults[E_TRIODE_VALVE_DUAL];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_TRIODE_VALVE_DUAL_HEATER];

	CSchematicObjectData.type	= E_TRIODE_VALVE_DUAL_HEATER;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_TRIODE_VALVE_DUAL_HEATER] = "X";

	CSchematicObjectData.CPinListData.SetSize(9);

	CSchematicObjectData.CPinListData[6].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[7].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CSchematicObjectData.CPinListData[8].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h1";
	CSchematicObjectData.CPinListData[6].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CSchematicObjectData.CPinListData[7].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "h2";
	CSchematicObjectData.CPinListData[7].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	CSchematicObjectData.CPinListData[8].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "hct";
	CSchematicObjectData.CPinListData[8].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "9";

	CSchematicObjectData.CPinListData[6].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[6].CLocation.x	= 16;// heater 1
	CSchematicObjectData.CPinListData[6].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[6].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[6].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[6].is_visable		= true;

	CSchematicObjectData.CPinListData[7].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[7].CLocation.x	= 32;// heater 2
	CSchematicObjectData.CPinListData[7].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[7].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[7].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[7].is_visable		= true;

	CSchematicObjectData.CPinListData[8].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[8].CLocation.x	= 48;// ht ct
	CSchematicObjectData.CPinListData[8].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[8].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[8].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[8].is_visable	= true;

	CSchematicObjectData.CSymbolData.CData.SetSize(25);

	CSchematicObjectData.CSymbolData.CData[20].CStartLocation.x	= 16;// heater / slant 
	CSchematicObjectData.CSymbolData.CData[20].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[20].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[20].CEndLocation.y	= 56;

	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.x	= 24;// heater \ slant 
	CSchematicObjectData.CSymbolData.CData[21].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[21].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.x	= 24;// heater up 
	CSchematicObjectData.CSymbolData.CData[22].CStartLocation.y	= 56;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.x	= 24;
	CSchematicObjectData.CSymbolData.CData[22].CEndLocation.y	= 40;

	CSchematicObjectData.CSymbolData.CData[23].CStartLocation.x	= 24;// heater ct left
	CSchematicObjectData.CSymbolData.CData[23].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[23].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[23].CEndLocation.y	= 40;

	CSchematicObjectData.CSymbolData.CData[24].CStartLocation.x	= 32;// heater ct left
	CSchematicObjectData.CSymbolData.CData[24].CStartLocation.y	= 40;
	CSchematicObjectData.CSymbolData.CData[24].CEndLocation.x	= 48;
	CSchematicObjectData.CSymbolData.CData[24].CEndLocation.y	= 48;

}


void TCSuperSpiceDataBase::SetupAnd(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_AND_GATE];

	CSchematicObjectData.type	= E_AND_GATE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;// screen 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;


/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupNand(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NAND_GATE];

	CSchematicObjectData.type	= E_NAND_GATE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// 
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupOr(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_OR_GATE];

	CSchematicObjectData.type	= E_OR_GATE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// 
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 48;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupNor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NOR_GATE];

	CSchematicObjectData.type	= E_NOR_GATE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// 
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 48;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupExOr(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_EXCLUSIVE_OR];

	CSchematicObjectData.type	= E_EXCLUSIVE_OR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;// screen 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;// grid
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// 
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -64;		// in side curve
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[6].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[6].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[6].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[6].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;


	CSchematicObjectData.f_vector_graphic = true;
}
void TCSuperSpiceDataBase::SetupExNor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_EXCLUSIVE_NOR];

	CSchematicObjectData.type	= E_EXCLUSIVE_NOR;


	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;// screen 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;// grid
	CSchematicObjectData.CPinListData[3].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[3].is_visable	= true;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 32;// 
	CSchematicObjectData.CPinListData[4].CLocation.y	= 64;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[4].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= -64;	
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[7].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[7].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[7].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[7].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[7].type				= E_SCHEMATIC_SYMBOL_CIRCLE;
/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupLDO5Pin(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_RESERVED_GENERIC_LDO];

	CSchematicObjectData.type	= E_RESERVED_GENERIC_LDO;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //input
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;  // EN
	CSchematicObjectData.CPinListData[1].CLocation.y	= 32;	
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32; // GND
	CSchematicObjectData.CPinListData[2].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 64;  // PG
	CSchematicObjectData.CPinListData[3].CLocation.y	= 32;	
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 0;

	CSchematicObjectData.CPinListData[4].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[4].CLocation.x	= 64;  // OUT
	CSchematicObjectData.CPinListData[4].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[4].is_visable	= true;
	CSchematicObjectData.CPinListData[4].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[4].CLocationOffset.y = 0;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

	/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4, 4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 64; 
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupSchmitt(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_SCHMITT_TRIGGER];

	CSchematicObjectData.type	= E_SCHMITT_TRIGGER;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //input
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 64;  // output
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32; // +Vcc
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // -Vee
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(9, 9);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//upslope
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0; //upslope
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 4; //
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 16; //
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= -16;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= 16; //
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[7].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.x	= 20; //
	CSchematicObjectData.CSymbolData.CData[8].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.x	= 20;
	CSchematicObjectData.CSymbolData.CData[8].CEndLocation.y	= 16;
/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;


	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupInvertor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_INVERTOR];

	CSchematicObjectData.type	= E_INVERTOR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //input
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 64;  // output
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_UP_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32; // +Vcc
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].is_visable		= true;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_DOWN_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;  // -Vee
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;	
	CSchematicObjectData.CPinListData[3].is_visable	= true;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//upslope
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0; //upslope
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
////////////
void TCSuperSpiceDataBase::SetupDigital3InputAnd(void)
{
	CString CSymbolName = CMDefaults[E_DIGITAL_AND_3IN].CSymbolData.CName;

	CMDefaults[E_DIGITAL_AND_3IN] = CMDefaults[E_DIGITAL_AND];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_AND_3IN];

	CSchematicObjectData.type	= E_DIGITAL_AND_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_DIGITAL_AND_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16; */

	CSchematicObjectData.CPinListData.SetSize(5);
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
/*
	int size = CSchematicObjectData.CSymbolData.CData.GetSize();

	CSchematicObjectData.CSymbolData.CData.SetSize(size + 1);

	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.y		= 80;*/
}

void TCSuperSpiceDataBase::SetupDigital3InputNand(void)
{
	CString CSymbolName = CMDefaults[E_DIGITAL_NAND_3IN].CSymbolData.CName;

	CMDefaults[E_DIGITAL_NAND_3IN] = CMDefaults[E_DIGITAL_NAND];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_NAND_3IN];

	CSchematicObjectData.type	= E_DIGITAL_NAND_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_DIGITAL_NAND_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;*/

	CSchematicObjectData.CPinListData.SetSize(5);
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
/*
	int size = CSchematicObjectData.CSymbolData.CData.GetSize();

	CSchematicObjectData.CSymbolData.CData.SetSize(size + 1);

	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.y	= -16;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.y		= 80;*/
}

void TCSuperSpiceDataBase::SetupDigital3InputOr(void)
{
	CString CSymbolName = CMDefaults[E_DIGITAL_OR_3IN].CSymbolData.CName;

	CMDefaults[E_DIGITAL_OR_3IN] = CMDefaults[E_DIGITAL_OR];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_OR_3IN];

	CSchematicObjectData.type	= E_DIGITAL_OR_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_DIGITAL_OR_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;

	int size = CSchematicObjectData.CSymbolData.CData.GetSize();

	CSchematicObjectData.CSymbolData.CData.SetSize(size + 1);

	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.y		= 32;
*/
	CSchematicObjectData.CPinListData.SetSize(5);
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
}

void TCSuperSpiceDataBase::SetupDigital3InputNor(void)
{
	CString CSymbolName = CMDefaults[E_DIGITAL_NOR_3IN].CSymbolData.CName;

	CMDefaults[E_DIGITAL_NOR_3IN] = CMDefaults[E_DIGITAL_NOR];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_NOR_3IN];

	CSchematicObjectData.type	= E_DIGITAL_NOR_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_DIGITAL_NOR_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(4);

	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;

	int size = CSchematicObjectData.CSymbolData.CData.GetSize();

	CSchematicObjectData.CSymbolData.CData.SetSize(size + 1);

	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.y		= 32;
*/
	CSchematicObjectData.CPinListData.SetSize(5);
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
}

void TCSuperSpiceDataBase::Setup3InputAnd(void)
{
	CString CSymbolName = CMDefaults[E_ANALOG_AND_3IN].CSymbolData.CName;

	CMDefaults[E_ANALOG_AND_3IN] = CMDefaults[E_AND_GATE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ANALOG_AND_3IN];

	CSchematicObjectData.type	= E_ANALOG_AND_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_ANALOG_AND_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;*/

	CSchematicObjectData.CPinListData.SetSize(7);
	
	CSchematicObjectData.CPinListData[6] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
}

void TCSuperSpiceDataBase::Setup3InputNand(void)
{
	CString CSymbolName = CMDefaults[E_ANALOG_NAND_3IN].CSymbolData.CName;

	CMDefaults[E_ANALOG_NAND_3IN] = CMDefaults[E_NAND_GATE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ANALOG_NAND_3IN];

	CSchematicObjectData.type	= E_ANALOG_NAND_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_ANALOG_NAND_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;*/

	CSchematicObjectData.CPinListData.SetSize(7);
	
	CSchematicObjectData.CPinListData[6] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
}

void TCSuperSpiceDataBase::Setup3InputOr(void)
{
	CString CSymbolName = CMDefaults[E_ANALOG_OR_3IN].CSymbolData.CName;

	CMDefaults[E_ANALOG_OR_3IN] = CMDefaults[E_OR_GATE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ANALOG_OR_3IN];

	CSchematicObjectData.type	= E_ANALOG_OR_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_ANALOG_OR_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;

	int size = CSchematicObjectData.CSymbolData.CData.GetSize();

	CSchematicObjectData.CSymbolData.CData.SetSize(size + 1);

	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.y		= 32;*/

	CSchematicObjectData.CPinListData.SetSize(7);
	
	CSchematicObjectData.CPinListData[6] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
}

void TCSuperSpiceDataBase::Setup3InputNor(void)
{
	CString CSymbolName = CMDefaults[E_ANALOG_NOR_3IN].CSymbolData.CName;

	CMDefaults[E_ANALOG_NOR_3IN] = CMDefaults[E_NOR_GATE];

	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ANALOG_NOR_3IN];

	CSchematicObjectData.type	= E_ANALOG_NOR_3IN;

	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	CReferanceDesignator[E_ANALOG_NOR_3IN] = "X";
/*
	CSchematicObjectData.CPinListData.SetSize(6);

	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[1].CLocation.y -= 16;

	int size = CSchematicObjectData.CSymbolData.CData.GetSize();

	CSchematicObjectData.CSymbolData.CData.SetSize(size + 1);

	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[size].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.x		= 8;
	CSchematicObjectData.CSymbolData.CData[size].CEndLocation.y		= 32;*/

	CSchematicObjectData.CPinListData.SetSize(7);
	
	CSchematicObjectData.CPinListData[6] = CSchematicObjectData.CPinListData[4];
	CSchematicObjectData.CPinListData[5] = CSchematicObjectData.CPinListData[3];
	CSchematicObjectData.CPinListData[4] = CSchematicObjectData.CPinListData[2];
	CSchematicObjectData.CPinListData[3] = CSchematicObjectData.CPinListData[1];
	CSchematicObjectData.CPinListData[2] = CSchematicObjectData.CPinListData[1];

	CSchematicObjectData.CPinListData[0].CLocation.y -= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y -= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y -= 0;
	CSchematicObjectData.CPinListData[3].CLocation.y += 16;
}
//////////////

void TCSuperSpiceDataBase::SetupDigitalAnd(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_AND];

	CSchematicObjectData.type	= E_DIGITAL_AND;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;// out
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(4);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;


/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDigitalNand(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_NAND];

	CSchematicObjectData.type	= E_DIGITAL_NAND;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDigitalOr(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_OR];

	CSchematicObjectData.type	= E_DIGITAL_OR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(6);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;	
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 48;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDigitalNor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_NOR];

	CSchematicObjectData.type	= E_DIGITAL_NOR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32; //out side curve
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 68; //inverter circle
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;  // pin extention
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;//28;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0;	// pin extention
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 6;// 28;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 48;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDigitalExOr(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_EX_OR];

	CSchematicObjectData.type	= E_DIGITAL_EX_OR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;// screen 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(7);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0; // pin extention
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0; // pin extention
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= -64;		// in side curve
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[6].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[6].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[6].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[6].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[6].type				= E_SCHEMATIC_SYMBOL_CIRCLE;


/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;


	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDigitalExNor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_EX_NOR];

	CSchematicObjectData.type	= E_DIGITAL_EX_NOR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;// in 1
	CSchematicObjectData.CPinListData[0].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
		
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;//  1
	CSchematicObjectData.CPinListData[1].CLocation.y	= 48;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 64;// screen 2
	CSchematicObjectData.CPinListData[2].CLocation.y	= 32;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 0;
	CSchematicObjectData.CPinListData[2].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 0;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(8);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= 0;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= -56;		// in side curve
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[1].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[1].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[1].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[1].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[1].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].start_angle		= -90;
	CSchematicObjectData.CSymbolData.CData[2].end_angle			= 90;
	CSchematicObjectData.CSymbolData.CData[2].radius			= 32;
	CSchematicObjectData.CSymbolData.CData[2].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[2].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[3].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[3].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[3].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[3].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 64;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= 64;

	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.x	= 0;   // pin extention
	CSchematicObjectData.CSymbolData.CData[5].CStartLocation.y	= 16;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[5].CEndLocation.y	= 16;

	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.x	= 0;   // pin extention
	CSchematicObjectData.CSymbolData.CData[6].CStartLocation.y	= 48;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.x	= 6;
	CSchematicObjectData.CSymbolData.CData[6].CEndLocation.y	= 48;

	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.x	= -64;		// in side curve
	CSchematicObjectData.CSymbolData.CData[7].CStartLocation.y	= 32;//32;
	CSchematicObjectData.CSymbolData.CData[7].start_angle		= -30;//-90;
	CSchematicObjectData.CSymbolData.CData[7].end_angle			= 30;//90;
	CSchematicObjectData.CSymbolData.CData[7].radius			= 64;//32;
	CSchematicObjectData.CSymbolData.CData[7].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[7].type				= E_SCHEMATIC_SYMBOL_CIRCLE;
/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDigitalInvertor(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_INVERTOR];

	CSchematicObjectData.type	= E_DIGITAL_INVERTOR;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0; //input
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 64;  // output
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;	
	CSchematicObjectData.CPinListData[1].is_visable	= true;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;//|
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;//upslope
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 0;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 0; //upslope
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 64;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= 0;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 68;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[4].start_angle		= 0;
	CSchematicObjectData.CSymbolData.CData[4].end_angle			= 360;
	CSchematicObjectData.CSymbolData.CData[4].radius			= 4;
	CSchematicObjectData.CSymbolData.CData[4].aspect_ratio		= 1;
	CSchematicObjectData.CSymbolData.CData[4].type				= E_SCHEMATIC_SYMBOL_CIRCLE;

/// Symbol end lines

	CSchematicObjectData.width	= 96; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupAToD(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_ANALOG_TO_DIGITAL];

	CSchematicObjectData.type					= E_ANALOG_TO_DIGITAL;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -8;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -8;

// Symbol end lines

	CSchematicObjectData.width	= 48; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupDToA(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DIGITAL_TO_ANALOG];

	CSchematicObjectData.type					= E_DIGITAL_TO_ANALOG;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 16;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -8;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= 8;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 16;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -8;

// Symbol end lines

	CSchematicObjectData.width	= 48; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupLaplaceTransform(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_LAPLACE_TRANSFORM];

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[0].is_visable	= true;
	
	CSchematicObjectData.CPinListData[1].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 0;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 16;
	CSchematicObjectData.CPinListData[1].is_visable	= true;

	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 16;

	CSchematicObjectData.CGrabOffset.y = 8;
	CSchematicObjectData.CGrabOffset.x = 0;

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 8;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 8;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -8;


	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -8;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -8;

// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 16;

	CSchematicObjectData.f_vector_graphic = true;

}

void TCSuperSpiceDataBase::SetupNonLinearSource(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE];

	CSchematicObjectData.type	= E_NONLINEAR_DEPENDANT_SOURCE;

	CSchematicObjectData.CPinListData[0].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[0].is_visable		= true;
	CSchematicObjectData.CPinListData[0].CLocation.x	= -0;
	CSchematicObjectData.CPinListData[0].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[0].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[1].type			= E_POINTING_LEFT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[1].is_visable		= true;
	CSchematicObjectData.CPinListData[1].CLocation.x	= 0;
	CSchematicObjectData.CPinListData[1].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[1].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[2].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[2].is_visable	= true;
	CSchematicObjectData.CPinListData[2].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[2].CLocation.y	= -16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[2].CLocationOffset.y = 32;

	CSchematicObjectData.CPinListData[3].type			= E_POINTING_RIGHT_PIN_COMPONENT;
	CSchematicObjectData.CPinListData[3].CLocation.x	= 32;
	CSchematicObjectData.CPinListData[3].CLocation.y	= 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.x = 16;
	CSchematicObjectData.CPinListData[3].CLocationOffset.y = 32;
	CSchematicObjectData.CPinListData[3].is_visable	= true;


	CSchematicObjectData.CLocationOffset.x = 16;
	CSchematicObjectData.CLocationOffset.y = 32;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;


/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y		= -32;


	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y		= 32;


	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x		= 32;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y		= -32;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= 32;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -32;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x		= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y		= -32;

/// Symbol end lines

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;

}
void TCSuperSpiceDataBase::SetupDType(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_DTYPE];

	CSchematicObjectData.type	= E_DTYPE;

	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::SetupJKType(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_JKTYPE];

	CSchematicObjectData.type	= E_JKTYPE;


	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}

void TCSuperSpiceDataBase::Setup8BitCounter(void)
{
	TCSchematicObjectData &CSchematicObjectData = CMDefaults[E_8BIT_COUNTER];

	CSchematicObjectData.type	= E_8BIT_COUNTER;


	CSchematicObjectData.width	= 64; 
	CSchematicObjectData.height	= 64;

	CSchematicObjectData.f_vector_graphic = true;
}
bool TCSuperSpiceDataBase::GetModel(TCSpiceParameters &CSpiceParameters)
{
	int type = CSpiceParameters.CDataBaseIdInfo.model_type;

	if(type < 0) return false;

	if(CModelDataBase.Get(CSpiceParameters)) return true;

	return false;
}

bool TCSuperSpiceDataBase::SetModel(TCSpiceParameters &CSpiceParameters)
{
	if(CSpiceParameters.CDataBaseIdInfo.model_type < 0) return false;

	if(CModelDataBase.Set(CSpiceParameters)) return true;

	return false;
}
	
bool TCSuperSpiceDataBase::GetSymbol(TCSchematicObjectData &CSchematicObjectData)
{
	// this function not used, not tested!
	CString CFileName, CName;
	CFile CDataFile;
	int count, p;

	CFileName = CSchematicObjectData.CSymbolData.CFilePath + CSchematicObjectData.CSymbolData.CFileName;
	CName = CSchematicObjectData.CSymbolData.CName;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::load);
	CArray <TCSchematicObjectData, TCSchematicObjectData&> CSchematicObjectDataList;

	CArchiveFile >> count;

	CSchematicObjectDataList.SetSize(count, count);

	int found = -1;
	CString CText;

	for(p = 0; p < count; p++) 
	{
		CSchematicObjectDataList[p].SerializeSymbolData(CArchiveFile);

		CText = CSchematicObjectDataList[p].CSymbolData.CName;

		CText.MakeUpper();
		CName.MakeUpper();

		if(CText != CName) continue;

		found = p;
	}

	CArchiveFile.Close();
	CDataFile.Close();

	if(found < 0) return false;

	CSchematicObjectData = CSchematicObjectDataList[found];

	return true;
}

bool TCSuperSpiceDataBase::SetSymbol(TCSchematicObjectData &CSchematicObjectData)
{
	CString CFileName, CDummy;
	CFile CDataFile;
	int count, p;

	CFileName = CSchematicObjectData.CSymbolData.CFilePath + CSchematicObjectData.CSymbolData.CFileName;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) 
	{
		if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

		count = 1;
		CArchive CArchiveFile(&CDataFile, CArchive::store);

		CArchiveFile << count;
		CSchematicObjectData.Serialize(CArchiveFile);

		CArchiveFile.Close();
		CDataFile.Close();

		return false;
	}
	CArchive CArchiveFile(&CDataFile, CArchive::load);

	CArray <TCSchematicObjectData, TCSchematicObjectData&> CSchematicObjectDataList;

	CArchiveFile >> count;

	CSchematicObjectDataList.SetSize(count, count);

	for(p = 0; p < count; p++) 
	{
		CSchematicObjectDataList[p].Serialize(CArchiveFile);
	}

	CArchiveFile.Close();
	CDataFile.Close();

	p = Find(CSchematicObjectDataList, CSchematicObjectData.CSymbolData.CName);

	if(p < 0) 
	{
		CSchematicObjectDataList.Add(CSchematicObjectData);
	}
	else
	{
		CSchematicObjectDataList[p] = CSchematicObjectData;
	}

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CArchive CArchiveFile2(&CDataFile, CArchive::store);

	count = CSchematicObjectDataList.GetSize();

	CArchiveFile2 << count;

	for(p = 0; p < count; p++) 
	{
		CSchematicObjectDataList[p].Serialize(CArchiveFile2);
	}

	CArchiveFile2.Close();
	CDataFile.Close();

	return true;
}
int TCSuperSpiceDataBase::Find(CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSchematicObjectDataList, CString CName)
{
	int p, count;
	CString CText;

	count = CSchematicObjectDataList.GetSize();

	for(p = 0; p < count; p++)
	{
		CText = CSchematicObjectDataList[p].CSymbolData.CName;

		CText.MakeUpper();
		CName.MakeUpper();

		if(CText != CName) continue;

		return p;
	}

	return -1;
}

int TCSuperSpiceDataBase::FindSymbols(CString CSymbols, CArray <CString, CString> &CSymbolNames, CArray <HTREEITEM,  HTREEITEM> &CHandles)
{
	CSymbols;
	CSymbolNames;
	CHandles;

	return false;
}

int TCSuperSpiceDataBase::FindModels(CString CModel, CArray <CString, CString> &CModelNames, CArray <HTREEITEM,  HTREEITEM> &CHandles)
{
	CModelNames.SetSize(0, 64);
	CHandles.SetSize(0, 64);

	int file_count = CModelDataBase.CFileList.GetSize();
	int count, q, start;

	for(int p = 0; p < file_count; p++)
	{
		TCModelDataBaseData &CFile = CModelDataBase.CFileList[p];

		start = CModelNames.GetSize();

		CFile.CParametersList.FindModels(CModel, CModelNames, CHandles);

		count = CModelNames.GetSize();

		for(q = start; q < count;q++)
		{
			CModelNames[q] =  "'" + RemoveExtention(CFile.CName) + "' " + CModelNames[q];
		}
	}

	return CModelNames.GetSize();
}

bool TCSuperSpiceDataBase::RenameModel(CString CFileName, CString COldName, CString CNewName)
{
	int model_file_index, model_index;

	model_file_index = FindModelFile(CFileName);

	if(model_file_index < 0) return false;

	TCSpiceParametersList &CModelList = CModelDataBase.CFileList[model_file_index].CParametersList;
		
	model_index = CModelList.FindModelOrSubcircuit(COldName);

	if(model_index < 0) return false;

	// get in to _XN format if not already
	CNewName = CModelList.CParameters[model_index].FormatSpiceValue(CNewName);
		
	CModelList.CParameters[model_index].Rename(CNewName);

	GCWorkspaceTree.RenameModel(CModelList.CParameters[model_index].HTreeItem, CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName);

	return true;
}

bool TCSuperSpiceDataBase::RenameSymbol(CString CFileName, CString COldName, CString CNewName)
{
	int symbol_file_index, symbol_index;

	symbol_file_index = FindSymbolFile(CFileName);

	if(symbol_file_index < 0) return false;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;
		
	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].Find(COldName);

	if(symbol_index < 0) return false;

	TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

	CSymbol.CSymbolData.CName = CNewName;

	GCWorkspaceTree.RenameSymbol(CSymbol.HTreeItem, CNewName);

	return true;
}

CArray<TCSchematicPinData, TCSchematicPinData &> &TCSuperSpiceDataBase::GetPinListData(TCSchematicObjectData &CSchematicObjectData)
{
	if(CSchematicObjectData.type < CMDefaults.GetSize() && 
	   CSchematicObjectData.type > 0)
	{
		return CMDefaults[CSchematicObjectData.type].CPinListData;
	}

	return CSymbolDataBase.GetPinListData(CSchematicObjectData);
}

void TCSuperSpiceDataBase::DoSpecialProcessing(TCSchematicObjectData &CSchematicObjectData)
{
	//This is stop some data being copied as defaults

	if(CSchematicObjectData.component_property_view_type == E_PROPERTY_RESISTOR)
	{
		CSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelValue = "";
		CSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].is_visable = 0;
	
		CSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelValue = "";
		CSchematicObjectData.CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].is_visable = 0;
	}
	else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_CAPACITOR)
	{
		CSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].CLabelValue = "";
		CSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].is_visable = 0;
	
		CSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].CLabelValue = "";
		CSchematicObjectData.CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].is_visable = 0;
	}
	else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_INDUCTOR)
	{
		CSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].CLabelValue = "";
		CSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].is_visable = 0;
	
		CSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].CLabelValue = "";
		CSchematicObjectData.CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].is_visable = 0;
	}

	CSchematicObjectData.FormatLabel();
}

void TCSuperSpiceDataBase::SetSchematicObjectData(TCSchematicObjectData &CSchematicObjectData, bool set_model)
{
	int p, pin_count;

	if(set_model) CModelDataBase.Set(CSchematicObjectData.CSpiceParameters);

	if(CSchematicObjectData.attached_model_type != E_SPICE_SCHEMATIC)
	{
		if(CSchematicObjectData.type < CMDefaults.GetSize() && 
			CSchematicObjectData.type > 0)
		{
			CMDefaults[CSchematicObjectData.type].Copy(CSchematicObjectData);

			DoSpecialProcessing(CMDefaults[CSchematicObjectData.type]);

			if(set_model) CModelDataBase.Set(CSchematicObjectData.CSpiceParameters);

			TCSchematicObjectData &CSchematicObjectDataLocal = CMDefaults[CSchematicObjectData.type];

			//remove the node volts and name data
			if(CSchematicObjectData.type == E_WIRE_COMPONENT)
			{
				CSchematicObjectDataLocal.CLabelListData[E_WIRE_NET_NAME].CLabel = "";
				CSchematicObjectDataLocal.CLabelListData[E_WIRE_NET_VOLTAGE].CLabel = "V?";

				return;
			}

			// dont copy over Multiplier. Too likely to cause errors.
			if(CSchematicObjectData.component_property_view_type == E_PROPERTY_RESISTOR)
			{
				CSchematicObjectDataLocal.CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue = "1";
				
				CSchematicObjectDataLocal.FormatCLabel(E_COMPONENT_RESISTOR_MULTIPLIER_M);
			}

			if(CSchematicObjectData.component_property_view_type == E_PROPERTY_CAPACITOR)
			{
				CSchematicObjectDataLocal.CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelValue = "1";
				CSchematicObjectDataLocal.FormatCLabel(E_COMPONENT_CAPACITOR_MULTIPLIER_M);
			}

			pin_count = CSchematicObjectDataLocal.CPinListData.GetSize();
			
			for(p = 0; p < pin_count; p++)
			{
				if(!(CSchematicObjectDataLocal.CPinListData[p].CLabelListData.GetSize() > E_COMPONENT_PIN_NET_NAME)) break;

				if(CSchematicObjectDataLocal.type != E_SUBCIRCUIT_PIN_CONNECTER && CSchematicObjectDataLocal.type != E_PAGE_CONNECTER_BIDIRECTIONAL &&
					CSchematicObjectDataLocal.type != E_PAGE_CONNECTER_INPUT && CSchematicObjectDataLocal.type != E_PAGE_CONNECTER_OUTPUT)
				{
					CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel	= "?V"; 
					CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel	= "?A"; 
					CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel	= ""; 

				//   Bug fix. Test points lost visability state for net name. 5th March 2004 
				//	CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_VOLTAGE].is_visable	= false; 
				//	CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_CURENT].is_visable		= false; 
				//	CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable	= false; 
				}
				else
				{
					CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel	= "?V"; 
					CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel	= "?A"; 
					CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel	= "Name?"; 

				//	CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_VOLTAGE].is_visable	= false; 
				//	CSchematicObjectDataLocal.CPinListData[p].CLabelListData[E_COMPONENT_PIN_CURENT].is_visable		= false;
				}
			}

			return;
		}
	}

	// will change later to get referance to actual data
	TCSchematicObjectData CLocalSchematicObjectData;
	
	CLocalSchematicObjectData.CSymbolData.CName		= CSchematicObjectData.CSymbolData.CName;
	CLocalSchematicObjectData.CSymbolData.CFileName	= CSchematicObjectData.CSymbolData.CFileName;
	CLocalSchematicObjectData.CSymbolData.CFilePath	= CSchematicObjectData.CSymbolData.CFilePath;

	if(!CSymbolDataBase.Get(CLocalSchematicObjectData)) return;

	CLocalSchematicObjectData.Copy(CSchematicObjectData);//dont overwrite symbol data

	DoSpecialProcessing(CLocalSchematicObjectData);

	CSymbolDataBase.Set(CLocalSchematicObjectData, false);// user must force as save

//	if(set_model) CModelDataBase.Set(CSchematicObjectData.CSpiceParameters); moved upwards 28th March 2005
}

bool TCSuperSpiceDataBase::GetSchematicObjectData(TCSchematicObjectData &CSchematicObjectData)
{
	if(CSchematicObjectData.type < CMDefaults.GetSize() && 
	   CSchematicObjectData.type > 0)
	{
		 CSchematicObjectData = CMDefaults[CSchematicObjectData.type];

		 return true;
	}

	return CSymbolDataBase.Get(CSchematicObjectData);
}

int TCSuperSpiceDataBase::SetSymbolPinName(CString CFileName, CString CSymbolName, int pin_id, CString CText)
{
	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CSymbolData.CFilePath = ExtractPathName(CFileName); 
	CSchematicObjectData.CSymbolData.CFileName = ExtractFileName(CFileName);
	
	CSchematicObjectData.CSymbolData.CName = CSymbolName;

	if(!GetSchematicObjectData(CSchematicObjectData)) return -2;

	CString CPinName;

	int number_of_pins = CSchematicObjectData.CPinListData.GetSize();

	if(!(pin_id < number_of_pins)) //check if pin id exists, if not return id for same name pin 
	{
		CText.MakeLower();

		for(int r =0; r < number_of_pins; r++)
		{
			CPinName = CSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;

			CPinName.MakeLower();

			if(CPinName == CText)
			{
				return r;
			}
		}

	}
	else 
	{
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CText;
	
		SetSchematicObjectData(CSchematicObjectData, false);

		return -1;//set ok
	}

	return -1;
}

int TCSuperSpiceDataBase::SetSymbolAllPinNames(CString CFileName, CString CSymbolName, TCSchematicObjectData &CSchematicObjectData)
{
	CSchematicObjectData;

	TCSchematicObjectData CSchematicObjectDataNew;

	CSchematicObjectDataNew.CSymbolData.CFilePath = ExtractPathName(CFileName); 
	CSchematicObjectDataNew.CSymbolData.CFileName = ExtractFileName(CFileName);
	
	CSchematicObjectDataNew.CSymbolData.CName = CSymbolName;

	if(!GetSchematicObjectData(CSchematicObjectDataNew)) return -2;


	return -2;
}


bool TCSuperSpiceDataBase::GetDeviceCurrentNodeNames(TCSchematicObjectData *CSchematicObjectData, CArray <CString, CString> &CDeviceNodes)
{
	if(!CSchematicObjectData) return false;

	int count;

	int type = GetSpiceModelType(CSchematicObjectData);

	if(!type)  //assume 0 type is .subckt
	{
		count = CSchematicObjectData->CPinListData.GetSize();

		CDeviceNodes.SetSize(count);

		for(int p = 0; p < count; p++)
		{
			CDeviceNodes[p] = 'i';
		}

		return true;
	}

	count = CSpiceNodeNames[type].CDeviceNodes.GetSize();

	if(!count) return false;

	CDeviceNodes.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CDeviceNodes[p] = CSpiceNodeNames[type].CDeviceNodes[p];
	}

	return true;
}

int	TCSuperSpiceDataBase::GetSpiceModelType(TCSchematicObjectData *CSchematicObjectData)
{
	//inspect typename NPN etc. this allows any model to be attached to a symbol 
	

//	if(CSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.model_type != E_SPICE_DOT_MODEL) return false;

	CString CText = CSchematicObjectData->CSpiceParameters.CDataBaseIdInfo.CRecordType;

	if(CText == "") return false;

	CText.MakeUpper();

	int count = CSpiceNodeNames.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CSpiceNodeNames[p].CBasicSpiceType == CText) return p;
	}

	return false;
}

int	 TCSuperSpiceDataBase::GetSpiceModelType(CString CName)
{
	CString CText = CName;

	CText.MakeUpper();
	
	int count = CSpiceNodeNames.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CSpiceNodeNames[p].CBasicSpiceType == CText) return p;
	}

	return false;
}

bool TCSuperSpiceDataBase::PlaceCircuit(CString CFolderName, CString CFileName)
{
	if(!PCSuperSpiceDocLastFocused) return true;
	if(!PCSuperSpiceViewLastFocused) return true;

	CString CCircuitName = CFolderName + "\\" + CFileName;

	AfxGetApp()->OpenDocumentFile(CCircuitName);

	return true;
}

void TCSuperSpiceDataBase::DisplayCircuitProperties(CString CFolderName, CString CFileName)
{
	TCCircuitPropertiesDlg CCircuitPropertiesDlg;

	TCCircuitsNameData CCircuitsNameData;

	if(!GetCircuitAttributes(CFolderName, CFileName, CCircuitsNameData)) 
	{
		AfxMessageBox(IDS_NO_PROP_FOND);

		return;
	}

	*CCircuitPropertiesDlg.PCCircuitsNameData = CCircuitsNameData;

	if(CCircuitPropertiesDlg.DoModal() != IDOK) return;

	 CCircuitsNameData = *CCircuitPropertiesDlg.PCCircuitsNameData;

	SetCircuitAttributes(CFolderName, CFileName, CCircuitsNameData);
}

void TCSuperSpiceDataBase::PlaceSymbolFromModel(int model_file_index, int model_index)
{
	if(model_file_index < 0) return;
	if(model_index < 0) return;

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = CModelDataBase.CFileList;
	
	int count = CFiles.GetSize();

	if(!count) return;
	if(!(model_file_index < count)) return;

	TCSpiceParametersList &CModelList = CFiles[model_file_index].CParametersList;

	if(!(model_index < CModelList.CParameters.GetSize())) return;

	TCSpiceParameters &CSpiceParameters = CModelList.CParameters[model_index];
		
	int symbol_file_index = 0, symbol_index = 0;

	if(!IsSymbolAvailableFromModel(CSpiceParameters.CDataBaseIdInfo))
	{
		AfxMessageBox(IDS_NO_ATTACHED_SYMBOL);

		return;
	}

	if(FindSymbolFromModelDescription(CSpiceParameters, symbol_file_index, symbol_index))
	{
		PlaceSymbolFromSymbol(symbol_file_index, symbol_index, 0);

		return;
	}

	int graphic_type = FindInternalSymbolFromModelType(CSpiceParameters);

	if(graphic_type)
	{
		PlaceSymbolFromSymbol(symbol_file_index, symbol_index, graphic_type);

		return;
	}

	int result = AfxMessageBox(IDS_BROWSE_FOR_SYMBOL, MB_YESNO);

	if(result != IDYES) return;

	CString CMsg;
	int number;

	CString CErrorMsg;

	CErrorMsg.LoadString(IDS_MODEL_NUMBER_OF_PINS_START);

	CErrorMsg += " ";

	CErrorMsg += CSpiceParameters.CDataBaseIdInfo.CRecordName + " ";

	CMsg.LoadString(IDS_STRING_WORD_HAS);

	CErrorMsg += CMsg;

	CArray <CString, CString> CPinArray;

	CSpiceParameters.GetPinList(CPinArray);

	number = CPinArray.GetSize();

	CMsg.Format("%d", number);

	CErrorMsg += " " + CMsg;

	CMsg.LoadString(IDS_STRING_WORD_PINS);

	CErrorMsg += " " +  CMsg;

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CErrorMsg, 0);

	if(!FindInternalSymbolFromLibrary(CSpiceParameters, symbol_file_index, symbol_index)) return;

	PlaceSymbolFromSymbol(symbol_file_index, symbol_index, graphic_type);
}

void TCSuperSpiceDataBase::PlaceSymbolFromSymbol(int symbol_file_index, int symbol_index, int graphic_type)
{
	if(symbol_file_index < 0) return;
	if(symbol_index < 0) return;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = CSymbolDataBase.CFileList;
	
	int count = CFiles.GetSize();

	if(!count) return;

	if(!(symbol_file_index < count)) return;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList= CFiles[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	if(!PCSuperSpiceDocLastFocused) return;
	if(!PCSuperSpiceViewLastFocused) return;

	if(IsBadCodePtr((FARPROC) PCSuperSpiceDocLastFocused)) return;
	if(IsBadCodePtr((FARPROC) PCSuperSpiceViewLastFocused)) return;
	if(IsBadWindowHandle((CWnd *)PCSuperSpiceViewLastFocused)) return;

	PCSuperSpiceDocLastFocused->PlaceSymbolFromSymbol((CView *) PCSuperSpiceViewLastFocused, symbol_file_index, symbol_index, graphic_type);
}

bool TCSuperSpiceDataBase::FindSymbolFromModelDescription(TCSpiceParameters &CSpiceParameters, int &symbol_file_index, int &symbol_index)
{
	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = CSymbolDataBase.CFileList;
	
	CString CSystemFileName = ExtractFileName(CSpiceParameters.CDataBaseIdInfo.CSymbolFileName);

	CString CTempFile = ExtractPathName(CSpiceParameters.CDataBaseIdInfo.CSymbolFileName);

	CString CTempText;

	CTempText = CTempFile + CSystemFileName;

//	if(FileExists(CSpiceParameters.CDataBaseIdInfo.CSymbolFileName))
	if(FileExists(CTempText))
	{
//		symbol_file_index = FindSymbolFile(CSpiceParameters.CDataBaseIdInfo.CSymbolFileName);

		symbol_file_index = FindSymbolFile(CTempText);

		if(symbol_file_index < 0)// see if it is in the superspice system directory
		{
			CString CSystemDir = GetSuperSpiceSystemDir();

	//		CString CSystemFileName = ExtractFileName(CSpiceParameters.CDataBaseIdInfo.CSymbolFileName);

			CSystemFileName.MakeLower();

			CSystemFileName = CSystemDir + CSystemFileName;

	//		CString CTempFile = ExtractPathName(CSpiceParameters.CDataBaseIdInfo.CSymbolFileName);

			CTempFile.MakeLower();

			if(CSystemDir != CTempFile) // no point in searching twice.
				symbol_file_index = FindSymbolFile(CSystemFileName);
		}

		if(!(symbol_file_index < 0))
		{
			TCSymbolDataBaseData &CSymbolDataBaseData = CFiles[symbol_file_index];

			symbol_index = CSymbolDataBaseData.Find(CSpiceParameters.CDataBaseIdInfo.CSymbolName);

			if(!(symbol_index < 0))
			{
				TCSchematicObjectData &CSchematicObjectData = CSymbolDataBaseData.CSymbolList[symbol_index];

				//Now copy new model data to existing internal
				SetSymbolViewType(CSchematicObjectData, CSpiceParameters);	

				return true;
			}
		}
	}

	symbol_index		= 0;//prefered error
	symbol_file_index	= 0;

	return false;
}

int TCSuperSpiceDataBase::FindInternalSymbolFromModelType(TCSpiceParameters &CSpiceParameters)
{
	int graphic_id = 0;
	CString CRecordType;

	CRecordType = CSpiceParameters.CDataBaseIdInfo.CRecordType;

	CRecordType.MakeLower();

	// first try and find internal .model symbols
	graphic_id = GetGraphicTypeFromModelType(CRecordType);

	if(graphic_id < E_TEST_MARKER) return 0;
	if(graphic_id == E_DTYPE || graphic_id == E_JKTYPE) return 0;
	if(graphic_id == E_XSPICE_DIGITAL) return 0;
	
	//Now copy new model data to existing internal symbol model data

	TCSchematicObjectData &CSchematicObjectData =  CMDefaults[graphic_id];

	CSchematicObjectData.attached_model_type = (unsigned char)CSpiceParameters.CDataBaseIdInfo.model_type;// overide symbol default

	int view_type = GetPropertyViewType(graphic_id);

	if(view_type < 0)
	{
		if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) CSchematicObjectData.component_property_view_type = E_PROPERTY_SUBCIRCUIT;
		else if (CSchematicObjectData.attached_model_type == E_SPICE_DOT_MODEL) CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_MODEL;
		else CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	}
	else CSchematicObjectData.component_property_view_type = (unsigned char)view_type;

	CSchematicObjectData.CSpiceParameters = CSpiceParameters;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel =  CSpiceParameters.CDataBaseIdInfo.CRecordName;
	
	if(CRecordType != "r" && CRecordType != "l" && CRecordType != "c" && CRecordType != "e" &&
	   CRecordType != "g" && CRecordType != "f" && CRecordType != "h" && CRecordType != "b")
	{
		CSchematicObjectData.format_spice_value = true;

		CSchematicObjectData.FormatSpiceValue();
	}
	else CSchematicObjectData.format_spice_value = false;

	return graphic_id;
}

int TCSuperSpiceDataBase::FindInternalSymbolFromLibrary(TCSpiceParameters &CSpiceParameters, int &symbol_file_index, int &symbol_index)
{
	TCComponentDataBaseData CComponentDataBaseData;

	CComponentDataBaseData.CModelFileName = CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
	CComponentDataBaseData.CModelPathName = CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	CComponentDataBaseData.CModelName	  = CSpiceParameters.CDataBaseIdInfo.CRecordName;

	TCMasterSymbolDlg CComponentLibaryDlg;
		
	int result = CComponentLibaryDlg.DoModal();

	if(result != IDOK)
		if(CComponentLibaryDlg.button_pressed == E_LIB_CANCEL) return false;

	CComponentDataBaseData = CComponentLibaryDlg.CComponentDataBaseData;

	symbol_index		= CComponentDataBaseData.symbol_index;
	symbol_file_index	= CComponentDataBaseData.symbol_file_index;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = CSymbolDataBase.CFileList;

	TCSchematicObjectData &CSchematicObjectData = CFiles[symbol_file_index].CSymbolList[symbol_index];
	
	CSchematicObjectData.CSpiceParameters = CSpiceParameters;

	CSpiceParameters.CDataBaseIdInfo.CSymbolFileName = CComponentDataBaseData.CSymbolPathName + CComponentDataBaseData.CSymbolFileName;
	CSpiceParameters.CDataBaseIdInfo.CSymbolName	 = CComponentDataBaseData.CSymbolName;

	CSchematicObjectData.attached_model_type = (unsigned char)CSpiceParameters.CDataBaseIdInfo.model_type;// overide symbol default

	SetSymbolViewType(CSchematicObjectData, CSpiceParameters);

	CSpiceParameters.AddSubcircuitSymbolName();// will go to model if required

	CFiles[symbol_file_index].Save();

	if(E_LIB_PLACE_SYMBOL == CComponentLibaryDlg.button_pressed) return E_LIB_PLACE_SYMBOL;
	
	return true;
}

void TCSuperSpiceDataBase::SetSymbolViewType(TCSchematicObjectData &CSchematicObjectData, TCSpiceParameters &CSpiceParameters)
{
	CString CRecordType;
	int view_type;

	// voltage sources get corrected for elsewere

	CRecordType = CSpiceParameters.CDataBaseIdInfo.CRecordType;

	CRecordType.MakeLower();

	view_type = GetPropertyView(CRecordType);// try and find by model type r, l, npn etc

	if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) CSchematicObjectData.component_property_view_type = E_PROPERTY_SUBCIRCUIT;

	else CSchematicObjectData.component_property_view_type = (unsigned char)view_type;

	CSchematicObjectData.CSpiceParameters = CSpiceParameters;
	
	if(CRecordType != "r" && CRecordType != "l" && CRecordType != "c" && CRecordType != "e" &&
		CRecordType != "g" && CRecordType != "f" && CRecordType != "h" && CRecordType != "b" &&
		CRecordType != "nmos" && CRecordType != "pmos" && CRecordType != "npn" && CRecordType != "pnp" &&
		CRecordType != "d" && CRecordType != "njf" && CRecordType != "pjf" &&
		CRecordType != "nmf" && CRecordType != "pmf" && CRecordType != "t" && 
		CRecordType != "cap" && CRecordType != "res")
	{
		CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel =  CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CSchematicObjectData.CSpiceParameters.use_model = true;
		CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = true;

		CSchematicObjectData.format_spice_value = true;

		CSchematicObjectData.FormatSpiceValue();
	}
	else
	{
		CSchematicObjectData.CSpiceParameters.use_model = false;
		CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = false;
		CSchematicObjectData.format_spice_value = false;

		TCSpiceParameters *PCParameters = GCSuperSpiceDataBase.GetModelPointer(CSchematicObjectData.CSpiceParameters);
		TCSpiceParameters CParameters;

		if(PCParameters) CParameters = *PCParameters;
		else CParameters = CSchematicObjectData.CSpiceParameters;

		// do special proccessing
		double data;

		if(CRecordType == "r" || CRecordType == "res")// find out if spice, xspice or ic type
		{
			//spice3 resistor model
			if(CParameters.Get("rsh", &data))
			{
				if(CParameters.Get("tcexp", &data) || CParameters.Get("tca", &data) || 
					CParameters.Get("tcb", &data)|| CParameters.Get("tcc", &data)) 
				{
					CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = true;
					
					CSchematicObjectData.component_property_view_type = E_PROPERTY_THERMISTOR;
				}
				else 
				{
					CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = false;

					CSchematicObjectData.component_property_view_type = E_PROPERTY_IC_RESISTOR;
				}

				CSchematicObjectData.CSpiceParameters.use_model = true;
				CSchematicObjectData.format_spice_value = true;
			}
			//xspice resistor model
			else if(CParameters.Get("xr", &data))
			{
				CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_MODEL;

				CSchematicObjectData.CSpiceParameters.use_model = true;
				CSchematicObjectData.format_spice_value = true;
			}
			else
			{
				CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "1k";
			}
		}
		else if(CRecordType == "c" || CRecordType == "cap")
		{
			//spice3 capacitor model
			if(CParameters.Get("cj", &data))
			{
				CSchematicObjectData.component_property_view_type = E_PROPERTY_IC_CAPACITOR;

				CSchematicObjectData.CSpiceParameters.use_model = true;
				CSchematicObjectData.format_spice_value = true;
			}
			else
			{
				CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabelType = "1n";
			}
		}
		else if(CRecordType == "l")
		{
			CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = "1u";
		}
		else if(CRecordType == "nmos" || CRecordType == "pmos")
		{	//just in case
			CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1, E_COMPONENT_FET_PARAMETERS + 1);

			CSchematicObjectData.CSpiceParameters.use_model = true;
			CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = true;
			CSchematicObjectData.format_spice_value = true;

			CSchematicObjectData.CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
			CSchematicObjectData.CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
			CSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";

			if(CSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabel == "")
				CSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabel = "1";

		}
		else if(CRecordType == "npn" || CRecordType == "pnp" || CRecordType == "njf" || CRecordType == "pjf" ||
			CRecordType == "nmf" || CRecordType == "pmf")
		{	
			CSchematicObjectData.CSpiceParameters.use_model = true;
			CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = true;
			CSchematicObjectData.format_spice_value = true;

			CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1, E_COMPONENT_FET_PARAMETERS + 1);

			CSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";

			if(CSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabel == "")
				CSchematicObjectData.CLabelListData[E_COMPONENT_FET_M].CLabel = "1";

			CSchematicObjectData.CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelType = "Param";

		}
		else if(CRecordType == "d")
		{	
			CSchematicObjectData.CSpiceParameters.use_model = true;
			CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = true;
			CSchematicObjectData.format_spice_value = true;

			CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1, E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1);

			CSchematicObjectData.CLabelListData[E_COMPONENT_DIODE_M].CLabelType = "A";
			CSchematicObjectData.CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelType = "Bv";

		}
		else if(CRecordType == "t")// lossless transmission line, with parameters
		{
			CSchematicObjectData.CSpiceParameters.use_model = false;
			CSchematicObjectData.format_spice_value = true;
		}
		
		if(CSchematicObjectData.format_spice_value) CSchematicObjectData.FormatSpiceValue();
	}
}

void TCSuperSpiceDataBase::SetDefaultModelDisplayed(TCComponentDataBaseData &CComponentDataBaseData)
{
	int model_file_index;
	
	model_file_index = FindModelFile(CComponentDataBaseData.CModelPathName + CComponentDataBaseData.CModelFileName);
	
	if(model_file_index < 0) return;


	TCSpiceParametersList &CModelList = CModelDataBase.CFileList[model_file_index].CParametersList;

	CModelDataBase.index = model_file_index;

	int model_index = CModelList.FindModelOrSubcircuit(CComponentDataBaseData.CModelName);
		
	if(model_index < 0) return;

	CModelDataBase.CFileList[model_file_index].index = model_index;
	CModelDataBase.CFileList[model_file_index].CComboEdit = CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName;
}

void TCSuperSpiceDataBase::SetDefaultSymbolDisplayed(TCComponentDataBaseData &CComponentDataBaseData)
{
	int symbol_file_index;
	
	symbol_file_index = FindSymbolFile(CComponentDataBaseData.CSymbolPathName + CComponentDataBaseData.CSymbolFileName);
	
	if(symbol_file_index < 0) return;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	CSymbolDataBase.index = symbol_file_index;

	int symbol_index = CSymbolDataBase.CFileList[symbol_file_index].Find(CComponentDataBaseData.CSymbolName);
		
	if(symbol_index < 0) return;

	CSymbolDataBase.CFileList[symbol_file_index].index = symbol_index;
	CSymbolDataBase.CFileList[symbol_file_index].CComboEdit = CSymbolList[symbol_index].CSymbolData.CName;

}

void TCSuperSpiceDataBase::SetDefaultModelDisplayed(TCSchematicObjectData &CSchematicObjectData)
{
	TCComponentDataBaseData CComponentDataBaseData;

	CComponentDataBaseData.CModelPathName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
		
	CComponentDataBaseData.CModelFileName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CComponentDataBaseData.CModelName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;

	SetDefaultModelDisplayed(CComponentDataBaseData);
}

void TCSuperSpiceDataBase::SetDefaultSymbolDisplayed(TCSchematicObjectData &CSchematicObjectData)
{
	TCComponentDataBaseData CComponentDataBaseData;

	CComponentDataBaseData.CModelPathName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
		
	CComponentDataBaseData.CModelFileName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName;

	CComponentDataBaseData.CModelName = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;

	SetDefaultSymbolDisplayed(CComponentDataBaseData);
}

int TCSuperSpiceDataBase::FindSymbolfromRecord(CString CRecord)
{
	int p;
	int count = CMDefaults.GetSize();
	CString CLocalRecord;

	CRecord.MakeLower();
	CRecord.TrimLeft();
	CRecord.TrimRight();

	for(p = 0; p < count; p++)
	{
		CLocalRecord = CMDefaults[p].CSpiceParameters.CDataBaseIdInfo.CRecordName;

		CLocalRecord.MakeLower();
		CLocalRecord.TrimLeft();
		CLocalRecord.TrimRight();

		if(CRecord == CLocalRecord) return p;
	}

	return -1;
}

bool TCSuperSpiceDataBase::IsSymbolAvailableFromModel(TCDataBaseIdInfo &CDataBaseIdInfo)
{
	CString CName = CDataBaseIdInfo.CRecordName;

	CName.MakeLower();

	CString CNameCopy = CName;

	CNameCopy = CNameCopy.Left(7);

	if("virtual" == CNameCopy) return false;

	CNameCopy = CName;

	CNameCopy = CNameCopy.Left(10);

	if("help_notes" == CNameCopy) return false;

	CNameCopy = CName;

	CNameCopy = CNameCopy.Left(15);

	if("mixed_mode_demo" == CNameCopy) return false;

	CNameCopy = CName;

	CNameCopy = CNameCopy.Left(16);

	if("dummyplaceholder" == CNameCopy) return false;

	CNameCopy = CName;

	CNameCopy = CNameCopy.Left(5);

	if("ss_wc" == CNameCopy) return false;

	CNameCopy = CName;

	CNameCopy = CNameCopy.Left(7);

	if("ss_note" == CNameCopy) return false;

	return true;
}

int GetPropertyViewType(CString CModelType)
{
	return GCSuperSpiceDataBase.GetGraphicTypeFromModelType(CModelType);
}

int GetPropertyViewType(int id)
{
	switch(id)
	{
		case E_SUBCIRCUIT_COMPONENT:return E_PROPERTY_SUBCIRCUIT; 
		case E_DIODE_COMPONENT:
		case E_ZENER_COMPONENT:
		case E_SHOTTKY_COMPONENT:
			return E_PROPERTY_DIODE;

		case E_NPN_TRANSISTER_COMPONENT:
		case E_PNP_TRANSISTER_COMPONENT:
		case E_NPN_4TERM_TRANSISTER_COMPONENT:
		case E_PNP_4TERM_TRANSISTER_COMPONENT:
			return E_PROPERTY_BIPOLAR;

		case E_NMOS_TRANSISTER_COMPONENT:
		case E_PMOS_TRANSISTER_COMPONENT:
		case E_NMOS_4TERM_TRANSISTER_COMPONENT:
		case E_PMOS_4TERM_TRANSISTER_COMPONENT:
				return E_PROPERTY_MOSFET;

		case E_NJFET_TRANSISTER_COMPONENT:
		case E_PJFET_TRANSISTER_COMPONENT:
		case E_4TERM_NJFET_TRANSISTER_COMPONENT:
		case E_4TERM_PJFET_TRANSISTER_COMPONENT:
		case E_NGASFET_TRANSISTER_COMPONENT:
		case E_PGASFET_TRANSISTER_COMPONENT:
		case E_NGASFET_4TERM_TRANSISTER_COMPONENT:
		case E_PGASFET_4TERM_TRANSISTER_COMPONENT:
				return E_PROPERTY_FET;

		case E_RESISTOR_COMPONENT:return E_PROPERTY_RESISTOR;
		case E_CAPACITOR_COMPONENT:return E_PROPERTY_CAPACITOR;
		case E_INDUCTOR_COMPONENT:return E_PROPERTY_INDUCTOR;
		case E_INDUCTOR_COMPONENT_CORED: return E_PROPERTY_INDUCTOR;

		case E_VCVSRC_COMPONENT:
		case E_ICVSRC_COMPONENT:
		case E_VCISRC_COMPONENT:
		case E_ICISRC_COMPONENT:
		case E_NONLINEAR_DEPENDANT_SOURCE:
			 return E_PROPERTY_CONTROLED_SOURCE;

		case E_TRANSFORMER_COMPONENT:return E_PROPERTY_TRANSFORMER;
		case E_TRANSMISSION_LINE_COMPONENT:return E_PROPERTY_TRANSMISSION_LINE;
		case E_LOSSLESS_TRANSMISSION_LINE_COMPONENT: return E_PROPERTY_LOSSLESS_TRANSMISSION_LINE;
		
		case E_VSWITCH_COMPONENT:
		case E_ISWITCH_COMPONENT:	
				return E_PROPERTY_SWITCH;

		case E_CONNECTER_POWER:

		case E_PAGE_CONNECTER_INPUT:
		case E_PAGE_CONNECTER_OUTPUT:
		case E_PAGE_CONNECTER_BIDIRECTIONAL:
				return E_PROPERTY_CONNECTORS;

		case E_TEST_MARKER:return E_PROPERTY_TEST_MARKERS;

		case E_IC_RESISTOR_COMPONENT:
		case E_IC_CAPACITOR_COMPONENT:
			 return E_PROPERTY_IC_RESISTOR;

		case E_SUBCIRCUIT_PIN_CONNECTER: return E_PROPERTY_SUBCIRCUIT_PIN_CONNECTORS;

		case E_DC_VOLTAGE_SOURCE:return E_PROPERTY_DC_VOLTAGE_SOURCE;
		case E_SINE_VOLTAGE_SOURCE:return E_PROPERTY_SINE_VOLTAGE_SOURCE;
		case E_PULSE_VOLTAGE_SOURCE:return E_PROPERTY_PULSE_VOLTAGE_SOURCE;
		case E_EXPONENTIAL_VOLTAGE_SOURCE:return E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE;
		case E_PIECEWISE_LINEAR_VOLTAGE_SOURCE:return E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE;
		case E_SINGLE_FREQ_VOLTAGE_FM:return E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM;
		case E_DC_CURRENT_SOURCE:return E_PROPERTY_DC_CURRENT_SOURCE;
		case E_SINE_CURRENT_SOURCE:return E_PROPERTY_SINE_CURRENT_SOURCE;
		case E_PULSE_CURRENT_SOURCE:return E_PROPERTY_PULSE_CURRENT_SOURCE;
		case E_EXPONENTIAL_CURRENT_SOURCE:return E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE;
		case E_PIECEWISE_LINEAR_CURRENT_SOURCE:return E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE;
		case E_SINGLE_FREQ_CURRENT_FM:return E_PROPERTY_SINGLE_FREQ_CURRENT_FM;

		case E_LAPLACE_TRANSFORM:return E_PROPERTY_LAPLACE_TRANSFORM;
		case E_MULIPLIER_COMPONENT:return E_PROPERTY_MULTYPLIER;
		case E_COMPONENT_DIVIDER:return E_PROPERTY_DIVIDER;
		case E_VARIABLE_RESISTOR:return E_PROPERTY_VARIABLE_RESISTOR;
		case E_XSPICE_DIGITAL: return E_PROPERTY_GENERIC_MODEL;
		case E_URC_TRANSMISSION_LINE: return E_PROPERTY_URC_TRANSMISSION_LINE;

		default: return -1;
	}

//	return -1;
}

int TCSuperSpiceDataBase::GetSpicePowerPolarity(CString CRecordType)
{
	return 1; // Current polarity fixed in XSpice engine July 2014

//	CRecordType.MakeLower();

//	if(CRecordType == "pnp") return -1;
//	if(CRecordType == "pjf") return -1;
//	if(CRecordType == "pmf") return -1;
//	if(CRecordType == "pmos") return  -1;

//	return 1;
}

int  TCSuperSpiceDataBase::GetPropertyView(CString CRecordType)
{
	CRecordType.MakeLower();

	if(CRecordType == "") return E_PROPERTY_GENERIC_SUBCIRCUIT;
	if(CRecordType == "x") return E_PROPERTY_GENERIC_SUBCIRCUIT;
	if(CRecordType == "a") return E_PROPERTY_GENERIC_MODEL;
	if(CRecordType == "r") return E_PROPERTY_RESISTOR;
	if(CRecordType == "l") return E_PROPERTY_INDUCTOR;
	if(CRecordType == "c") return E_PROPERTY_CAPACITOR;
	if(CRecordType == "d") return E_PROPERTY_DIODE;
	if(CRecordType == "npn") return E_PROPERTY_BIPOLAR;
	if(CRecordType == "pnp") return E_PROPERTY_BIPOLAR;
	if(CRecordType == "njf") return E_PROPERTY_FET;
	if(CRecordType == "pjf") return E_PROPERTY_FET;
	if(CRecordType == "nmf") return E_PROPERTY_MESFET;
	if(CRecordType == "pmf") return E_PROPERTY_MESFET;
	if(CRecordType == "nmos") return E_PROPERTY_MOSFET;
	if(CRecordType == "pmos") return E_PROPERTY_MOSFET;
	if(CRecordType == "sw") return E_PROPERTY_SWITCH;
	if(CRecordType == "csw") return E_PROPERTY_SWITCH;
	if(CRecordType == "t") return E_PROPERTY_LOSSLESS_TRANSMISSION_LINE;
	if(CRecordType == "ltra") return E_PROPERTY_TRANSMISSION_LINE;
	if(CRecordType == "s_xfer") return E_PROPERTY_LAPLACE_TRANSFORM;
	if(CRecordType == "potentiometer") return E_PROPERTY_VARIABLE_RESISTOR;

	if(CRecordType == "vdc") return E_PROPERTY_DC_VOLTAGE_SOURCE;
	if(CRecordType == "vsin") return E_PROPERTY_SINE_VOLTAGE_SOURCE;
	if(CRecordType == "vpulse") return E_PROPERTY_PULSE_VOLTAGE_SOURCE;
	if(CRecordType == "vpwl") return E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE;
	if(CRecordType == "vexp") return E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE;
	if(CRecordType == "vsffm") return E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM;
	if(CRecordType == "idc") return E_PROPERTY_DC_CURRENT_SOURCE;
	if(CRecordType == "isin") return E_PROPERTY_SINE_CURRENT_SOURCE;
	if(CRecordType == "ipulse") return E_PROPERTY_PULSE_CURRENT_SOURCE;
	if(CRecordType == "ipwl") return E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE;
	if(CRecordType == "iexp") return E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE;
	if(CRecordType == "isffm") return E_PROPERTY_SINGLE_FREQ_CURRENT_FM;

	if(CRecordType == "b") return E_PROPERTY_NONLINEARSOURCE;
	if(CRecordType == "e") return E_PROPERTY_CONTROLED_SOURCE;
	if(CRecordType == "g") return E_PROPERTY_CONTROLED_SOURCE;
	if(CRecordType == "h") return E_PROPERTY_CONTROLED_SOURCE;
	if(CRecordType == "f") return E_PROPERTY_CONTROLED_SOURCE;

	if(CRecordType == "g") return E_PROPERTY_CONNECTORS;
	if(CRecordType == "cont") return E_PROPERTY_CONNECTORS;
	if(CRecordType == "subcnt") return E_SUBCIRCUIT_PIN_CONNECTER;
	if(CRecordType == "tst") return E_PROPERTY_TEST_MARKERS;
	if(CRecordType == "urc") return E_PROPERTY_URC_TRANSMISSION_LINE;

	// modify and check to default to xspice a type i.e. E_PROPERTY_GENERIC_MODEL
	return E_PROPERTY_GENERIC_MODEL;
}

int GetGeneratorVersionfromViewType(int view_type)
{
	switch(view_type)
	{
		case E_PROPERTY_DC_VOLTAGE_SOURCE: return E_DC_VOLTAGE_SOURCE;
		case E_PROPERTY_SINE_VOLTAGE_SOURCE: return E_SINE_VOLTAGE_SOURCE;
		case E_PROPERTY_PULSE_VOLTAGE_SOURCE:return E_PULSE_VOLTAGE_SOURCE;
		case E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE:return E_EXPONENTIAL_VOLTAGE_SOURCE;
		case E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE:return E_PIECEWISE_LINEAR_VOLTAGE_SOURCE;
		case E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM:return E_SINGLE_FREQ_VOLTAGE_FM;
		case E_PROPERTY_DC_CURRENT_SOURCE:return E_DC_CURRENT_SOURCE;
		case E_PROPERTY_SINE_CURRENT_SOURCE:return E_SINE_CURRENT_SOURCE;
		case E_PROPERTY_PULSE_CURRENT_SOURCE:return E_PULSE_CURRENT_SOURCE;
		case E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE:return E_EXPONENTIAL_CURRENT_SOURCE;
		case E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE:return E_PIECEWISE_LINEAR_CURRENT_SOURCE;
		case E_PROPERTY_SINGLE_FREQ_CURRENT_FM:return E_SINGLE_FREQ_CURRENT_FM;

		default: return E_SINE_VOLTAGE_SOURCE;
	}
}

bool TCSuperSpiceDataBase::CreateSymbolForModel(void)
{
	TCCreateSymbolForModelDlg CCreateSymbolForModelDlg;

	CString CSystemDir = GetSuperSpiceSystemDir();

	if(CMCreateSymbolFromSchematicData.CSymbolFileName == "")
		CMCreateSymbolFromSchematicData.CSymbolFileName = CSystemDir + "UserSymbols.ssm";

	CCreateSymbolForModelDlg.CCreateSymbolFromSchematicData = CMCreateSymbolFromSchematicData;

	if(CCreateSymbolForModelDlg.DoModal() != IDOK) return false;

	CMCreateSymbolFromSchematicData = CCreateSymbolForModelDlg.CCreateSymbolFromSchematicData;

	int file_index;

	file_index = FindSymbolFile(CMCreateSymbolFromSchematicData.CSymbolFileName);

	if(file_index < 0)// create one
	{
		if(!NewSymbolFile(CMCreateSymbolFromSchematicData.CSymbolFileName)) return false;
	}

	file_index = FindSymbolFile(CMCreateSymbolFromSchematicData.CSymbolFileName);

	if(file_index < 0) return false;

	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);

	CSchematicObjectData.CSymbolData.CName		= CMCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFileName	= ExtractFileName(CMCreateSymbolFromSchematicData.CSymbolFileName);
	CSchematicObjectData.CSymbolData.CFilePath	= ExtractPathName(CMCreateSymbolFromSchematicData.CSymbolFileName);

	CSchematicObjectData.CSymbolData.CChildFileName = "";

	CSchematicObjectData.attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;

	TCDataBaseIdInfo &CDataBaseIdInfo = CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo;

	CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CDataBaseIdInfo.CModelType = "SUBCKT";
	CDataBaseIdInfo.CRecordType = "X";
	CDataBaseIdInfo.CRecordName = CMCreateSymbolFromSchematicData.CModelName;
	CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CMCreateSymbolFromSchematicData.CModelFileName);
	CDataBaseIdInfo.CRecordFileName = ExtractFileName(CMCreateSymbolFromSchematicData.CModelFileName);

	CModelDataBase.Get(CSchematicObjectData.CSpiceParameters);// Will overwrite the above if available

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CDataBaseIdInfo.CRecordName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = CDataBaseIdInfo.CRecordName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;

	CSchematicObjectData.CReserved.CStringArray.SetSize(2);
	CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = "(Package Name)";
	CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CSchematicObjectData.CSymbolData.CName;
	
	CSchematicObjectData.CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = true;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = true;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER] = 0;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = 0;

	CSchematicObjectData.FormatSpiceName();
	CSchematicObjectData.FormatSpiceValue();

	if(!CreateSchematicSymbol(CMCreateSymbolFromSchematicData, CSchematicObjectData)) return false;
	
	bool value = CSymbolDataBase.Set(CSchematicObjectData, false);// will automatically be saved as it does not exist

	if(!value) return false;

	int symbol_index = CSymbolDataBase.CFileList[file_index].Find("Blank Symbol");

	if(symbol_index < 0) return value;

	RemoveSymbol(file_index, symbol_index);

	return true;
}

bool TCSuperSpiceDataBase::CreateSymbolFromSchematic(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData)
{
	int file_index;

	file_index = FindSymbolFile(CCreateSymbolFromSchematicData.CSymbolFileName);

	if(file_index < 0)// create one
	{
		if(!NewSymbolFile(CCreateSymbolFromSchematicData.CSymbolFileName)) return false;
	}

	file_index = FindSymbolFile(CCreateSymbolFromSchematicData.CSymbolFileName);

	if(file_index < 0) return false;

	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);

	CSchematicObjectData.CSymbolData.CName		= CCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFileName	= ExtractFileName(CCreateSymbolFromSchematicData.CSymbolFileName);
	CSchematicObjectData.CSymbolData.CFilePath	= ExtractPathName(CCreateSymbolFromSchematicData.CSymbolFileName);

	CSchematicObjectData.CSymbolData.CChildFileName = CCreateSymbolFromSchematicData.CSchematicName;

	CSchematicObjectData.attached_model_type = E_SPICE_SCHEMATIC;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].is_visable = true;

	CSchematicObjectData.CReserved.CStringArray.SetSize(E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX);
	CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = "(Package Name)";
	CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CSchematicObjectData.CSymbolData.CName;
	
	CSchematicObjectData.CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = true;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = true;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER] = 0;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = 0;

	if(!CreateSchematicSymbol(CCreateSymbolFromSchematicData, CSchematicObjectData)) return false;
	
	bool value = CSymbolDataBase.Set(CSchematicObjectData, false);// will automatically be saved as it does not exist

	if(!value) return false;

	int symbol_index = CSymbolDataBase.CFileList[file_index].Find("Blank Symbol");

	if(symbol_index < 0) return value;

	RemoveSymbol(file_index, symbol_index);

	return value;
} 

bool TCSuperSpiceDataBase::CreateSchematicSymbol(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData, TCSchematicObjectData &CSchematicObjectData)
{

	int left_pin_count = CCreateSymbolFromSchematicData.CLeftList.GetSize();
	int right_pin_count = CCreateSymbolFromSchematicData.CRightList.GetSize();
	int top_pin_count = CCreateSymbolFromSchematicData.CTopList.GetSize();
	int bottom_pin_count = CCreateSymbolFromSchematicData.CBottomList.GetSize();

	int x_pin_count = top_pin_count;

	if(bottom_pin_count > x_pin_count) x_pin_count = bottom_pin_count;

	int y_pin_count = left_pin_count;

	if(right_pin_count > y_pin_count) y_pin_count = right_pin_count;

	int grid_size = GCSuperSpiceGlobalData.CDrawData.grid_size;

	int y_count = y_pin_count + 1;
	int x_count = x_pin_count + 1;
	bool f_skip = false;
	int y_skip;
	
	if(!(y_pin_count % 2)) 
	{
		y_count++;// force even number of grid steps for y side

		f_skip = true;
	}

	CSchematicObjectData.width	= (unsigned short)(x_count * grid_size);
	CSchematicObjectData.height = (unsigned short)(y_count * grid_size);

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = CSchematicObjectData.height/2;

	CSchematicObjectData.CGrabOffset.y = 0;
	CSchematicObjectData.CGrabOffset.x = 0;

	int pin_count = left_pin_count + right_pin_count + top_pin_count + bottom_pin_count;

	if(pin_count != CCreateSymbolFromSchematicData.CAllList.GetSize()) return false;

	CSchematicObjectData.CPinListData.SetSize(pin_count);

	for(int p = 0; p < pin_count; p++)
	{
		CSchematicObjectData.CPinListData[p].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	}
//Start

	int local_counter = 0;
	CString CName;
	int pin_id;
 
	int next_distance = -CSchematicObjectData.CLocationOffset.y + grid_size;

	while(local_counter < left_pin_count)
	{
		CName = CCreateSymbolFromSchematicData.CLeftList[local_counter];
		
		pin_id = CCreateSymbolFromSchematicData.FindID(CName);

		if(pin_id < 0) return false;
		if(!(pin_id < pin_count)) return false;

		CSchematicObjectData.CPinListData[pin_id].type = E_POINTING_LEFT_PIN_COMPONENT;
		CSchematicObjectData.CPinListData[pin_id].is_visable = true;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.x = 0;

		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.y = CSchematicObjectData.CLocationOffset.y;
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CName;
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel.Format("%d", pin_id + 1);

		CSchematicObjectData.CPinListData[pin_id].CLocation.x	= 0;

		if(f_skip && !(local_counter < (left_pin_count/2))) y_skip = grid_size;
		else y_skip = 0;

		CSchematicObjectData.CPinListData[pin_id].CLocation.y	= next_distance + y_skip;

		next_distance += grid_size;

		local_counter++;
	}

	next_distance =  grid_size;
	local_counter = 0;

	while(local_counter < bottom_pin_count)
	{
		CName = CCreateSymbolFromSchematicData.CBottomList[local_counter];
		
		pin_id = CCreateSymbolFromSchematicData.FindID(CName);

		if(pin_id < 0) return false;
		if(!(pin_id < pin_count)) return false;

		CSchematicObjectData.CPinListData[pin_id].type = E_POINTING_DOWN_PIN_COMPONENT;
		CSchematicObjectData.CPinListData[pin_id].is_visable = true;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.x = 0;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.y = CSchematicObjectData.CLocationOffset.y;
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CName;
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel.Format("%d", pin_id  + 1);

		CSchematicObjectData.CPinListData[pin_id].CLocation.x	= next_distance;
		CSchematicObjectData.CPinListData[pin_id].CLocation.y	= CSchematicObjectData.CLocationOffset.y;

		next_distance += grid_size;

		local_counter++;
	}

	next_distance = -CSchematicObjectData.CLocationOffset.y + grid_size;
	local_counter = 0;

	while(local_counter < right_pin_count)
	{
		CName = CCreateSymbolFromSchematicData.CRightList[local_counter];
		
		pin_id = CCreateSymbolFromSchematicData.FindID(CName);

		if(pin_id < 0) return false;
		if(!(pin_id < pin_count)) return false;

		CSchematicObjectData.CPinListData[pin_id].type = E_POINTING_RIGHT_PIN_COMPONENT;
		CSchematicObjectData.CPinListData[pin_id].is_visable = true;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.x = 0;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.y = CSchematicObjectData.CLocationOffset.y;

		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CName;
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel.Format("%d", pin_id + 1);

		CSchematicObjectData.CPinListData[pin_id].CLocation.x	= CSchematicObjectData.width;

		if(f_skip && !(local_counter < (left_pin_count/2))) y_skip = grid_size;
		else y_skip = 0;

		CSchematicObjectData.CPinListData[pin_id].CLocation.y	= next_distance + y_skip;

		next_distance += grid_size;

		local_counter++;
	}

	next_distance = grid_size;
	local_counter = 0;

	while(local_counter < top_pin_count)
	{
		CName = CCreateSymbolFromSchematicData.CTopList[local_counter];
		
		pin_id = CCreateSymbolFromSchematicData.FindID(CName);

		if(pin_id < 0) return false;
		if(!(pin_id < pin_count)) return false;

		CSchematicObjectData.CPinListData[pin_id].type = E_POINTING_UP_PIN_COMPONENT;
		CSchematicObjectData.CPinListData[pin_id].is_visable = true;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.x = 0;
		CSchematicObjectData.CPinListData[pin_id].CLocationOffset.y = CSchematicObjectData.CLocationOffset.y;

		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CName;
		CSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel.Format("%d", pin_id + 1);

		CSchematicObjectData.CPinListData[pin_id].CLocation.x	= next_distance;
		CSchematicObjectData.CPinListData[pin_id].CLocation.y	= -CSchematicObjectData.CLocationOffset.y;

		next_distance += grid_size;

		local_counter++;
	}

//Pins end

/// Symbol start lines

	CSchematicObjectData.CSymbolData.CData.SetSize(5, 5);

	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y	= -CSchematicObjectData.CLocationOffset.y;

	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CStartLocation.y	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[1].CEndLocation.y	= CSchematicObjectData.CLocationOffset.y;

	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[2].CStartLocation.y	= CSchematicObjectData.CLocationOffset.y;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.x	= CSchematicObjectData.width;
	CSchematicObjectData.CSymbolData.CData[2].CEndLocation.y	= CSchematicObjectData.CLocationOffset.y;

	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.x	= CSchematicObjectData.width;
	CSchematicObjectData.CSymbolData.CData[3].CStartLocation.y	= -CSchematicObjectData.CLocationOffset.y;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.x	= CSchematicObjectData.width;
	CSchematicObjectData.CSymbolData.CData[3].CEndLocation.y	= CSchematicObjectData.CLocationOffset.y;

	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.x	= CSchematicObjectData.width;
	CSchematicObjectData.CSymbolData.CData[4].CStartLocation.y	= -CSchematicObjectData.CLocationOffset.y;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.x	= 0;
	CSchematicObjectData.CSymbolData.CData[4].CEndLocation.y	= -CSchematicObjectData.CLocationOffset.y;

/// Symbol end lines

	CSchematicObjectData.f_vector_graphic = true;

	return true;
}

CString TCSuperSpiceDataBase::GetDefaultFileNameFromId(int id)
{
	CString CText;

	if(id < 0) return CText;
	if(!(id < CMDefaults.GetSize())) return CText;

	switch(id)
	{
		case E_DC_VOLTAGE_SOURCE:	
		case E_SINE_VOLTAGE_SOURCE:
		case E_PULSE_VOLTAGE_SOURCE:
		case E_EXPONENTIAL_VOLTAGE_SOURCE:
		case E_PIECEWISE_LINEAR_VOLTAGE_SOURCE:
		case E_SINGLE_FREQ_VOLTAGE_FM:
		case E_DC_CURRENT_SOURCE:
		case E_SINE_CURRENT_SOURCE:
		case E_PULSE_CURRENT_SOURCE:
		case E_EXPONENTIAL_CURRENT_SOURCE:
		case E_PIECEWISE_LINEAR_CURRENT_SOURCE:
		case E_SINGLE_FREQ_CURRENT_FM:
			 CText = "Generators.ssm";
			 return CText;

		case E_RESISTOR_COMPONENT:
		case E_IC_RESISTOR_COMPONENT:
		case E_CAPACITOR_COMPONENT:
		case E_IC_CAPACITOR_COMPONENT:
		case E_INDUCTOR_COMPONENT:
		case E_TRANSMISSION_LINE_COMPONENT:
		case E_LOSSLESS_TRANSMISSION_LINE_COMPONENT:
		case E_INDUCTOR_COMPONENT_CORED:
		case E_VARIABLE_RESISTOR:
		case E_URC_TRANSMISSION_LINE:
			 CText = "Basic.ssm";
			 return CText;
	
		case E_DIODE_COMPONENT:
		case E_ZENER_COMPONENT:
		case E_SHOTTKY_COMPONENT:
		case E_DIAC_COMPONENT:
			 CText = "Diodes.ssm";
			 return CText;

		case E_NPN_TRANSISTER_COMPONENT:
		case E_PNP_TRANSISTER_COMPONENT:
		case E_NPN_4TERM_TRANSISTER_COMPONENT:
		case E_PNP_4TERM_TRANSISTER_COMPONENT:
		case E_NMOS_TRANSISTER_COMPONENT:
		case E_PMOS_TRANSISTER_COMPONENT:
		case E_NMOS_4TERM_TRANSISTER_COMPONENT:
		case E_PMOS_4TERM_TRANSISTER_COMPONENT:
		case E_NJFET_TRANSISTER_COMPONENT:
		case E_PJFET_TRANSISTER_COMPONENT:
		case E_4TERM_NJFET_TRANSISTER_COMPONENT:
		case E_4TERM_PJFET_TRANSISTER_COMPONENT:
		case E_NGASFET_TRANSISTER_COMPONENT:
		case E_PGASFET_TRANSISTER_COMPONENT:
		case E_NGASFET_4TERM_TRANSISTER_COMPONENT:
		case E_PGASFET_4TERM_TRANSISTER_COMPONENT:
			 CText = "Transistors.ssm";
			 return CText;
		

		case E_VSWITCH_COMPONENT:
		case E_ISWITCH_COMPONENT:
		case E_LAPLACE_TRANSFORM:
		case E_MULIPLIER_COMPONENT:
		case E_COMPONENT_DIVIDER:
			 CText = "Functional.ssm";
			 return CText;

		case E_5_PIN_OP_AMP_COMPONENT:
		case E_7_PIN_OPAMP_COMPONENT:
		case E_8_PIN_OP_AMP_COMPONENT:
		case E_14_PIN_OP_AMP_COMPONENT:
			 CText = "AmpsAndBuffers.ssm";
			 return CText;

		case E_TRANSFORMER_COMPONENT:
		case E_TRANSFORMER_DUAL:
		case E_TRANSFORMER_TRIPLE:
		case E_TRANSFORMER_QUAD:
		case E_TRANSFORMER_SINGLE_CENTERTAPED:
		case E_TRANSFORMER_DUAL_CENTERTAPED:
		case E_TRANSFORMER_TRIPLE_CENTERTAPED:
		case E_TRANSFORMER_QUAD_CENTERTAPED:
		case E_TRANSFORMER_TUBE_OUTPUT:
		case E_TRANSFORMER_FLYBACK_TRIPLE:
			 CText = "Transformers.ssm";
			 return CText;
		
		case E_GENERIC_2_COMPONENT:
		case E_GENERIC_3_COMPONENT: 
		case E_GENERIC_4_COMPONENT:
		case E_GENERIC_5_COMPONENT:
		case E_GENERIC_6_COMPONENT:
		case E_GENERIC_7_COMPONENT:
		case E_GENERIC_8_COMPONENT:
		case E_GENERIC_9_COMPONENT:
		case E_GENERIC_10_COMPONENT:
		case E_GENERIC_11_COMPONENT:
		case E_GENERIC_12_COMPONENT:
		case E_GENERIC_13_COMPONENT:
		case E_GENERIC_14_COMPONENT:
		case E_GENERIC_15_COMPONENT:
		case E_GENERIC_16_COMPONENT:
		case E_GENERIC_17_COMPONENT:
		case E_GENERIC_18_COMPONENT:
		case E_GENERIC_19_COMPONENT:
		case E_GENERIC_20_COMPONENT:
			 CText = "SubcircuitBlocks.ssm";
			 return CText;

		case E_DIGITAL_AND:
		case E_DIGITAL_NAND:
		case E_DIGITAL_OR:
		case E_DIGITAL_NOR:
		case E_DIGITAL_EX_OR:
		case E_DIGITAL_EX_NOR:
		case E_DIGITAL_INVERTOR:
		case E_DIGITAL_SCHMITT_TRIGGER:
		case E_DIGITAL_AND_3IN:
		case E_DIGITAL_NAND_3IN:
		case E_DIGITAL_OR_3IN:
		case E_DIGITAL_NOR_3IN:
			 CText = "Digital.ssm";
			 return CText;

		case E_TRIODE_VALVE:
		case E_PENTODE_VALVE:
		case E_TETRODE_VALVE:
		case E_TUBE_8PIN:
		case E_TRIODE_VALVE_DUAL:
		case E_TRIODE_VALVE_DUAL_HEATER:
		case E_TRIODE_VALVE_HEATER:
		case E_PENTODE_VALVE_HEATER:
		case E_TETRODE_VALVE_HEATER:
		case E_TUBE_DIODE_SINGLE_HEATER:
		case E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER:
		case E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER:
		case E_TUBE_TRIODE_COMMON_CATHODE_HEATER:
		case E_TUBE_DIODE_COMMON_CATHODE_HEATER:
		case E_TUBE_DIODE_DUAL_CATHODE_HEATER:
			 CText = "Vacume Tubes.ssm";
			 return CText;

		case E_NAND_GATE:
		case E_NOR_GATE:
		case E_AND_GATE:
		case E_OR_GATE:		
		case E_EXCLUSIVE_OR:
		case E_EXCLUSIVE_NOR:
		case E_INVERTOR:
		case E_SCHMITT_TRIGGER:
		case E_DTYPE:
		case E_JKTYPE:
		case E_ANALOG_TO_DIGITAL:
		case E_DIGITAL_TO_ANALOG:
		case E_ANALOG_AND_3IN:
		case E_ANALOG_NAND_3IN:
		case E_ANALOG_OR_3IN:
		case E_ANALOG_NOR_3IN:
			 CText = "MixedMode.ssm";
			 return CText;

		case E_THRYSISTER_COMPONENT:
		case E_GTO_COMPONENT:
		case E_TRIAC_COMPONENT:
		case E_VARISTOR_MOV:
		case E_SPICE_THERMISTOR:
		case E_COMPONENT_FUSE:
		case E_FREQUENCY_CRYSTAL:
			 CText = "Discretes.ssm";
			 return CText;

			 
		case E_MOTER:
		case E_MOTER_TACHO:	
		case E_CCFL:
			CText = "SpecialFunctions.ssm";
			 return CText;

		default: return CText;
	}

//	return CText;
}

void TCSuperSpiceDataBase::SaveSymbolLocations(void)
{/*
	int count = CMDefaults.GetSize();
	int count2;

	for(int p = 0; p < count; p++)
	{
		count2 = CMDefaults.CLabelListData.Getsize();

		for(int p = 0; p < count2; )
		{
			CMDefaults.CLabelListData[q].SaveLocations();
		}

		count2 = CMDefaults.CPinLabelListData.Getsize();

		for(p = 0; p < count2; )
		{
			CMDefaults.CPinLabelListData[q].SaveLocations();
		}
	}*/
}

void TCSuperSpiceDataBase::LoadSymbolLocations(void)
{

}

////////////////////////////////////////////////
// Circuit design section

bool TCSuperSpiceDataBase::GetCircuitAttributes(CString CCircuitType, CString CircuitName, CArray <TCNameValueData, TCNameValueData&> &CAttributes)
{
	CCircuitType;
	CircuitName;
	CAttributes;

	return true;
}
